// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc" 
#include "woods.inc"

#macro klotzmaterial(Seed)
texture {
	pigment {
        wood
        color_map {
          [0.0 color CHSL2RGB(<44,0.3+rand(Seed)*0.5,0.6+rand(Seed)*0.2,0,0>)]
          [0.9 color CHSL2RGB(<44,0.1+rand(Seed)*0.8,0.6+rand(Seed)*0.2,0,0>)]
          [1.0 color CHSL2RGB(<44,0.3+rand(Seed)*0.5,0.6+rand(Seed)*0.2,0,0>)]
        }
        turbulence 0.05
        scale <0.2, 0.05, 1>
        rotate <0,90,0>
        translate <0,10*rand(Seed),0>
    }
	normal { bumps 0.1 scale 0.05 }
	finish { crand 0.1*rand(Seed) }

}
#end
  


#macro normalklotz(Seed)
superellipsoid {
  <0.05,0.05>  
  translate y
  scale<2+0.2*rand(Seed),0.5,1+0.1*rand(Seed)>
  klotzmaterial(Seed)
}
#end  

#macro halbklotz(Seed)
superellipsoid {
  <0.05,0.05>  
  translate y
  scale<1+0.1*rand(Seed),0.5,1+0.1*rand(Seed)>
  klotzmaterial(Seed)
}
#end  
