// Persistence of Vision Ray Tracer Scene Description File
// File: spielburg.pov
// Vers: 3.5
// Auth: Bugi Goertz
//

#version 3.5; 
#include "colors.inc" 
#include "stones1.inc"

#include "pfeiler.inc"
#include "mauer.inc"
#include "doorwall.inc"
#include "zwischenturm.inc"
#include "kegeldach.inc" 
#include "haus.inc"

//Toggle for fast rendering
#declare high_quality=on;  

//Toggle for TopView (for placing elements)
#declare TopView=off;

#if (high_quality)
	#include "bauklotz.inc"
	#declare Radiosity=on;
	#declare Media=on;
	#declare DOF=on;
#else
	#include "bauklotz_low.inc"
	#declare Radiosity=off;
	#declare Media=off;
	#declare DOF=off;     
#end



global_settings {
  assumed_gamma 1.0
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.02           // end pretrace at this size
      count 200                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      normal on                   // take surface normals into account 
    }
  #end
}

/* ----------------------------------------
   WORLD SETTINGS
   ---------------------------------------- */

#declare camera_location = <-10,20,-65>;
#declare camera_target = <15,15,15>;

#if (TopView)
	camera {                          
		orthographic
		location <0,130,0> 
		look_at   <0,0,0>
	}
	//Display x and z axis
	#declare i=-100;
	#while (i<100)
		sphere { <i,10,0>,0.5 pigment {color Red}}
		sphere { <0,10,i>,0.5 pigment {color Red}}  
		#declare i=i+10;
	#end
#else
	camera {                          
	  location camera_location
	  look_at   camera_target  
	  
	  //Focal Blur?
	  #if (DOF)	
		  aperture 1.5 
		  blur_samples 100
		  focal_point <17,8,-9>
		  variance 1/10000
	  #end
	}    
#end

// create a circle of point "spotlight" (conical directed) light source
#declare numoflights=6;
#declare i=0;
#declare R1=seed(1234432);

// Some colored lights, to make scene interesting
// maybe the way the constructor will see it
union {
	#while (i<numoflights)
	//Lightcolour from HSL-Model, Variation round the hue, some randomness
	#declare light_color = CHSL2RGB(<180*i/numoflights+90,2,1.1+0.3*rand(R1)>)*(0.4*rand(R1));
	light_source {
	  <100,20+10*i,0>
	  color light_color       // light's color
	  spotlight               // this kind of light source
	  point_at <0, 10, 0>      // direction of spotlight
	  radius 40                // hotspot (inner, in degrees)
	  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
	  falloff 30               // intensity falloff radius (outer, in degrees)
	  media_interaction on
	  rotate 360*i/numoflights*y
	}                     
	#declare i=i+1;
	#end
	rotate <0,270,0>
} 

//The Light of the chamber
light_source {
	<0,0,200>
	color <0.8,0.2,0.8>
	spotlight
	point_at <0,0,0>
	radius 80
	media_interaction on
}

//The smoke
#if (Media)
media {
  scattering { 1, rgb 0.001}
  intervals 2
  samples 1
  method 3  
  density {
  	 agate
  	scale 10
  	color_map {
  		[0.5 color rgb .3]
  		[0.8 color rgb .5]
  		[1 color rgb 1]
  	}
  }
}     
#end

/* ----------------------------------------
	END WORLD ENVIRONMENT
 ---------------------------------------- */

//The floor
height_field {
    tga "hf_test.tga"
    smooth
    pigment {
    	color rgb <.3,.7.3>
    }                   
    finish {
    	crand 0.25
    }
    translate <-0.5,0,-0.5>
    scale <240, 3, 240>
}

//Chamberbox
box {
	<-110,-10,-110>
	<110,220,110>
	pigment {
		color White
	}
	normal {
		wrinkles 0.5 
		scale 2
	}
	finish {
		ambient 0
		diffuse 0.8
	
	}
	hollow
}   

//Now following: building blocks

// ------------Front Wall------------------
object {
	pfeiler(10,rand(R1))
	translate <6.646,0,-24.849>
}
object {
	pfeiler(10,rand(R1))
	translate <-8.957,0,-24.849>
}

object {
	mauer(7,13,rand(R1))    
	translate <11.675,0,-24.84>
}

// ------------Outer Gatekeep------------------
object {
	doorwall(13,7,4,5,rand(R1))    
	translate <-1.325,0,-24.84>
}

object {
	mauer(7,12.5,rand(R1))    
	rotate <0,-135,0>
	translate <-14.342,0,-20.217>
	
}

object {
	mauer(7,12.5,rand(R1))    
	rotate <0,-91,0>
	translate <-18.676,0,-10.1>
}  

// ------------Inner Gatekeep------------------
union {
	doorwall(35,10,8,7,rand(R1))
	object {
		doorwall(16,10,6,5,rand(R1))
		translate <0,0,-2>
	}
	object {
		doorwall(16,10,6,5,rand(R1))
		translate <0,0,2>
	}
	rotate <0,14.139>
	translate <1.147,0,-5.763>
}

// ------------Incomplete Buildung left------------------
object {
	square(8,12,10,rand(R1))
	rotate <0,-13,0>
	translate <-17.336,0,-15.314>
}

//Left round tower
union {
	rundturm(3.75,15,rand(R1))
	object {
	kegeldach(5,0.5,rand(R1))
	translate <0,15,0>	
	}
	translate <-18.984,0,0>
}

//right round tower
union {
	rundturm(4,18,rand(R1))
	object {
	kegeldach(6,0.5,rand(R1))
	translate <0,18,0>	
	}
	translate <17.162,0,-9.859>
} 

//Wall right of right round tower
object {
	mauer(12,35,rand(R1))
	translate <36.731,0,-10.507>
}  

//Wall behind left tower
object {
	mauer(6,12.5,rand(R1))
	rotate -48.463*y
	translate <-13.283,6,7.32>
} 

//Pallas
object {
	haus(13.5,16.85,14,rand(R1))
	rotate 42.437*y
	translate <-1.115,6,14.751>	
}

//Wall beneath Pallas
object {
	haus(8.33,12.5,10,rand(R1))
	rotate -8.7*y
	translate <12.159,6,27.475>	
}
     
//Shack beneath Pallas
object {
	haus(8.33,12.5,10,rand(R1))
	rotate 43.6*y
	translate <28.051,2.237,23.43>	
}


//2nd Shack beneath Pallas
object {
	haus(8.33,12.5,10,rand(R1))
	rotate 66.6*y
	translate <36.43,6,12.161>	
}
  
//3rd Shack beneath Pallas
object {
	haus(8.33,12.5,10,rand(R1))
	rotate 88.2*y
	translate <33.252,4.5,-5.464>	
}

//Siege Tower? (Bergfried)
object {
	square(15,15,50,rand(R1))
	rotate 47.652*y
	translate <23.373,5,39.554>
}

//Chapel
object {
	haus(8.33,12.5,10,rand(R1))
	rotate 106.4*y
	translate <21.983,0,-23.378>	
}                           

union {
	turm(22,rand(R1))
	object {
		pfeiler(5,rand(R1))
		translate 21*y
	}              
	object {
		kegeldach(2,0.5,rand(R1))
		translate 26*y
	}
	rotate 13.9*y
	translate <29.761,0,-25.716>
}

//Some random blocks in the front
union {
	object {
		normalklotz(rand(R1))
		translate 2*y
	}
	object {
		normalklotz(rand(R1))
		translate 2*y
		rotate 20*z
		rotate 70*y  
		translate 1*y
		translate 0.35*z
	}
	object {
		normalklotz(rand(R1))
		rotate 25*y
		translate <3,2,3>
	} 
	object {
		halbklotz(rand(R1))
		rotate 30*y
		translate <3,3,2.5>
	}
	object {
		normalklotz(rand(R1))
		rotate -15*y
		translate 2*y
		translate 15*z
		
	}
	
	rotate 90*y
	translate <0,-1,-30>
}