#declare rotvar = 5;
#declare minabstand = 0.005;
#declare maxabstand = 0.1;
#declare avgabstand = (minabstand+maxabstand)/2;

#macro mauer (Height,length,Seed) 
union {      
	
	#local R1=seed(Seed);
	
	#local steincount = length/(4+avgabstand);
	
	//Fehlt noch ein halber?
	#if (steincount-int(steincount)>0.5)
		#local symmetrical=0;
	#else
		#local symmetrical=1;                          
	#end
	#local steincount=int(steincount);
	
	#local dir=1;
	#local j=0;
	
	#while (j<Height)
	
		#local dir=-dir;  
		#local front_half=false;
		#local end_half=false; 
		#local end_full=false;
		#if (symmetrical) 
			#local gaps=steincount+(dir+1)/2-1;
			#if (dir>0)
				#local front_half=true;
				#local end_half=true;
			#end
		#else
			#local gaps=steincount-1;
			#if (dir>0)
				#local front_half=true;
				#local end_full=true;
			#else                  
				#local end_half=true;
			#end
		#end                                
		#local abstaende=array[gaps+1];
		#if ((end_half | end_full) & symmetrical=false)
			#local abstaende[gaps]=2+rand(R1);
		#else                       
			#local abstaende[gaps]=0;
		#end
		#local summe_abstand=abstaende[gaps];
		#local i=0;
		#while (i<gaps)
			#local abstaende[i]=2+rand(R1);
			#local summe_abstand=summe_abstand+abstaende[i];
			#local i=i+1;
		#end      
		
		#if (symmetrical) 
			#local to_fill=length-4*steincount;
		#else                                
			#local to_fill=length-4*steincount-2;
		#end
		
		#local multiplier = to_fill/summe_abstand;
		
		#local start=0;
		#local i=0;		
		#while (i<steincount)
			#local actrot = rotvar * rand(R1) -(rotvar/2);             	
			#if (front_half)
				#local front_half=false;
				object {
			 		halbklotz(rand(R1))
					rotate <0,actrot,0>
					translate <start-1,j,0>
				}
				#local start = start+2+multiplier * abstaende[i];
			#else
				object {
			 		normalklotz(rand(R1))
					rotate <0,actrot,0>
					translate <start,j,0>
				}
				#local start = start+4+multiplier * abstaende[i];
			#end
			
			#local i=i+1;
		#end 
		#if (end_half)
			#local actrot = rotvar * rand(R1) -(rotvar/2);             	
			object {
		 		halbklotz(rand(R1))
				rotate <0,actrot,0>
				translate <start-1,j,0>
			}  
		
		#end                  
		
		#if (end_full)
			#local actrot = rotvar * rand(R1) -(rotvar/2);             	
			object {
		 		normalklotz(rand(R1))
				rotate <0,actrot,0>
				translate <start,j,0>
			}  
		
		#end                  
		
		#local j=j+1;
	#end  
	translate <-length/2+2,0,0>
}
#end


#macro openmauer (Height,length,Type,Seed) 
union {      
	
	#local R1=seed(Seed);
	
	#local steincount = length/(4+avgabstand);
	
	//Fehlt noch ein halber?
	#if (steincount-int(steincount)>0.5)
		#local symmetrical=0;
	#else
		#local symmetrical=1;                          
	#end
	#debug str(steincount,5,2)
	#local steincount=int(steincount+0.1);
	#debug str(steincount,5,2)
	
	#local dir=Type;
	#local j=0;
	
	#while (j<Height)
	
		#local dir=-dir;  
		#local front_half=false;
		#local end_half=false; 
		#local end_full=false;
		#if (symmetrical) 
			#local gaps=steincount+(dir+1)/2-1;
			#if (dir>0)
				#local front_half=true;
				#local end_half=true;
			#end
		#else
			#local gaps=steincount-1;
			#if (dir>0)
				#local front_half=true;
				#local end_full=true;
			#else                  
				#local end_half=true;
			#end
		#end                                
		#local abstaende=array[gaps+1];
		#if ((end_half | end_full) & symmetrical=false)
			#local abstaende[gaps]=2+rand(R1);
		#else                       
			#local abstaende[gaps]=0;
		#end
		#local summe_abstand=abstaende[gaps];
		#local i=0;
		#while (i<gaps)
			#local abstaende[i]=2+rand(R1);
			#local summe_abstand=summe_abstand+abstaende[i];
			#local i=i+1;
		#end      
		
		#if (symmetrical) 
			#local to_fill=length-4*steincount;
		#else                                
			#local to_fill=length-4*steincount-2;
		#end
		
		#local multiplier = to_fill/summe_abstand;
		
		#local start=0;
		#local i=0;		
		#while (i<steincount)
			#local actrot = rotvar * rand(R1) -(rotvar/2);             	
			#if (front_half)
				#local front_half=false;
				#local start = start+2+multiplier * abstaende[i];
			#else
				object {
			 		normalklotz(rand(R1))
					rotate <0,actrot,0>
					translate <start,j,0>
				}
				#local start = start+4+multiplier * abstaende[i];
			#end
			
			#local i=i+1;
		#end 
		#if (end_half)
			#local actrot = rotvar * rand(R1) -(rotvar/2);             	
		#end                  
		
		#if (end_full)
			#local actrot = rotvar * rand(R1) -(rotvar/2);             	
			object {
		 		normalklotz(rand(R1))
				rotate <0,actrot,0>
				translate <start,j,0>
			}  
		
		#end                  
		
		#local j=j+1;
	#end  
	translate <-length/2+2,0,0>
}
#end


#macro square(Width,Length,Height,Seed)
	
	#local Lsteincount = Length/(4+avgabstand);
	#local Wsteincount = Length/(4+avgabstand);
	
	#if (Lsteincount-int(Lsteincount)>0.5)
		#local Lsymmetrical=1;
	#else
		#local Lsymmetrical=0;
	#end                     

	#if (Wsteincount-int(Wsteincount)>0.5)
		#local Wsymmetrical=1;
	#else
		#local Wsymmetrical=0;
	#end
	
	union {
		object {
			openmauer(Height,Width,1,rand(R1))
			translate <0,0,Length/2-1>
		}                  
		object {
			openmauer(Height,Length,2*Wsymmetrical-1,rand(R1))
			translate <0,0,Width/2-1>
			rotate <0,90,0>
		}
		object {
			openmauer(Height,Width,1-2*abs(Wsymmetrical-Lsymmetrical),rand(R1))
			translate <0,0,Length/2-1>
			rotate <0,180,0>
		}
		object {
			openmauer(Height,Length,2*Wsymmetrical-1,rand(R1))
			translate <0,0,Width/2-1>
			rotate <0,270,0>
		}
}
#end
