/* BLOBHOUSE.POV - Programmed by Maarten Hofman */
/* 040403: Started programming */
/* 080403: Made the base frame */
/* 090403: Added smaller windows */
/* 140403: Added the doors */
/* 150403: Added the roof */
/* 160403: Added porch area */
/* 180403: Changed to a water surrounding */
                  
global_settings {
  radiosity { }
}
                
#include "colors.inc"
#include "skies.inc"
#include "stones.inc"
#include "functions.inc"
#include "metals.inc"
#include "woods.inc"
#include "glass.inc"

light_source { <0,1000,-1000> color White }
light_source { <1,1000,-1001> color White }
light_source { <9,4,5> color White }

sphere {
  <9,4,5>,0.3
  pigment {
    rgbt <1,1,0.9,0.5>  
  }                     
  finish {
    ambient 1
    diffuse 0.8
  }
}
cylinder {
  <9,6,5>,
  <9,4.3,5>,0.1
  texture {
    T_Chrome_1C
  }
}
              
camera {
  location <15,3,-13>
  look_at <10.5,5,0>
}  

#declare water = material {
  texture {
    pigment {
      color rgbt <1, 1, 1, 1>
    }
    finish {
      ambient 0.0
      diffuse 0.0

      reflection {
        0.0, 1.0
        fresnel on
      }

      specular 0.4
      roughness 0.003
    }
    normal {
      function {
        f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2)
      } 0.8
//      scale 0.13
    }
  }
  interior {
    ior 1.3
  }
}
  
plane {
  y,0
  material {
    water
  }
}

plane {
  y,-10
  pigment {
    DarkGreen
  }
}

sky_sphere {
  S_Cloud1
}

#declare walls = texture { T_Stone8 }
#declare roof = texture { T_Stone6 }
blob {
  threshold 0.9
  sphere { <0,0,0>,1,1 texture { T_Stone1 } }
  sphere { <1,0,0>,1,1 texture { T_Stone2 } }
  sphere { <2,0,0>,1,1 texture { T_Stone3 } }
  sphere { <3,0,0>,1,1 texture { T_Stone4 } }
  sphere { <4,0,0>,1,1 texture { T_Stone5 } }
  sphere { <5,0,0>,1,1 texture { T_Stone6 } }
  sphere { <6,0,0>,1,1 texture { T_Stone7 } }
  sphere { <6,0,1>,1,1 texture { T_Stone8 } }
  sphere { <6,0,2>,1,1 texture { T_Stone9 } }
  sphere { <6,0,3>,1,1 texture { T_Stone10 } }      
  sphere { <6,0,4>,1,1 texture { T_Stone11 } }
  sphere { <6,0,5>,1,1 texture { T_Stone12 } }
  sphere { <6,0,6>,1,1 texture { T_Stone13 } }
  sphere { <7,0,6>,1,1 texture { T_Stone14 } }
  sphere { <9,0,6>,1,1 texture { T_Stone15 } }
  sphere { <10,0,6>,1,1 texture { T_Stone16 } }
  sphere { <11,0,6>,1,1 texture { T_Stone17 } }
  sphere { <12,0,6>,1,1 texture { T_Stone18 } }
  sphere { <12,0,0>,1,1 texture { T_Stone19 } }
  sphere { <13,0,6>,1,1 texture { T_Stone20 } }
  sphere { <17,0,6>,1,1 texture { T_Stone21 } }
  sphere { <18,0,6>,1,1 texture { T_Stone22 } }
  sphere { <18,0,5>,1,1 texture { T_Stone23 } }
  sphere { <18,0,4>,1,1 texture { T_Stone24 } }
  sphere { <18,0,3>,1,1 texture { T_Stone25 } }
  sphere { <18,0,7>,1,1 texture { T_Stone26 } }
  sphere { <18,0,8>,1,1 texture { T_Stone27 } }
  sphere { <18,0,9>,1,1 texture { T_Stone28 } }
  sphere { <18,0,10>,1,1 texture { T_Stone29 } }
  sphere { <18,0,11>,1,1 texture { T_Stone30 } }  
  sphere { <18,0,12>,1,1 texture { T_Stone31 } }
  sphere { <17,0,12>,1,1 texture { T_Stone32 } }
  sphere { <16,0,12>,1,1 texture { T_Stone33 } }
  sphere { <15,0,12>,1,1 texture { T_Stone34 } }
  sphere { <14,0,12>,1,1 texture { T_Stone35 } }
  sphere { <13,0,12>,1,1 texture { T_Stone36 } }
  sphere { <12,0,12>,1,1 texture { T_Stone37 } }
  sphere { <10,0,12>,1,1 texture { T_Stone38 } }
  sphere { <9,0,12>,1,1 texture { T_Stone39 } }
  sphere { <8,0,12>,1,1 texture { T_Stone40 } }
  sphere { <7,0,12>,1,1 texture { T_Stone41 } }
  sphere { <6,0,12>,1,1 texture { T_Stone42 } }
  sphere { <5,0,12>,1,1 texture { T_Stone43 } }
  sphere { <4,0,12>,1,1 texture { T_Stone44 } }
  sphere { <3,0,12>,1,1 texture { T_Stone1 } }
  sphere { <2,0,12>,1,1 texture { T_Stone2 } }
  sphere { <1,0,12>,1,1 texture { T_Stone3 } }
  sphere { <0,0,12>,1,1 texture { T_Stone4 } }
  sphere { <0,0,11>,1,1 texture { T_Stone5 } }
  sphere { <0,0,10>,1,1 texture { T_Stone6 } }
  sphere { <0,0,9>,1,1 texture { T_Stone7 } }
  sphere { <0,0,8>,1,1 texture { T_Stone8 } }
  sphere { <0,0,7>,1,1 texture { T_Stone9 } }
  sphere { <0,0,6>,1,1 texture { T_Stone10 } }
  sphere { <0,0,5>,1,1 texture { T_Stone11 } }
  sphere { <0,0,4>,1,1 texture { T_Stone12 } }
  sphere { <0,0,3>,1,1 texture { T_Stone13 } }
  sphere { <0,0,2>,1,1 texture { T_Stone14 } }           
  sphere { <0,0,1>,1,1 texture { T_Stone15 } }           
  
  /* Next layer */
  sphere { <0,1,0>,1,1 texture { T_Stone16 } }
  sphere { <1,1,0>,1,1 texture { T_Stone17 } }
  sphere { <2,1,0>,1,1 texture { T_Stone18 } }
  sphere { <3,1,0>,1,1 texture { T_Stone19 } }
  sphere { <4,1,0>,1,1 texture { T_Stone20 } }
  sphere { <5,1,0>,1,1 texture { T_Stone21 } }
  sphere { <6,1,0>,1,1 texture { T_Stone22 } }
  sphere { <6,1,1>,1,1 texture { T_Stone23 } }
  sphere { <6,1,2>,1,1 texture { T_Stone24 } }
  sphere { <6,1,3>,1,1 texture { T_Stone25 } }      
  sphere { <6,1,4>,1,1 texture { T_Stone26 } }
  sphere { <6,1,5>,1,1 texture { T_Stone27 } }
  sphere { <6,1,6>,1,1 texture { T_Stone28 } }
  sphere { <7,1,6>,1,1 texture { T_Stone29 } }
  sphere { <9,1,6>,1,1 texture { T_Stone30 } }
  sphere { <10,1,6>,1,1 texture { T_Stone31 } }
  sphere { <11,1,6>,1,1 texture { T_Stone32 } }
  sphere { <12,1,6>,1,1 texture { T_Stone33 } }
  sphere { <12,1,0>,1,1 texture { T_Stone34 } }
  sphere { <13,1,6>,1,1 texture { T_Stone35 } }
  sphere { <17,1,6>,1,1 texture { T_Stone36 } }
  sphere { <18,1,6>,1,1 texture { T_Stone37 } }
  sphere { <18,1,5>,1,1 texture { T_Stone38 } }
  sphere { <18,1,4>,1,1 texture { T_Stone39 } }
  sphere { <18,1,3>,1,1 texture { T_Stone40 } }
  sphere { <18,1,7>,1,1 texture { T_Stone41 } }
  sphere { <18,1,8>,1,1 texture { T_Stone42 } }
  sphere { <18,1,9>,1,1 texture { T_Stone43 } }
  sphere { <18,1,10>,1,1 texture { T_Stone44 } }
  sphere { <18,1,11>,1,1 texture { T_Stone30 } }  
  sphere { <18,1,12>,1,1 texture { T_Stone1 } }
  sphere { <17,1,12>,1,1 texture { T_Stone2 } }
  sphere { <16,1,12>,1,1 texture { T_Stone3 } }
  sphere { <15,1,12>,1,1 texture { T_Stone4 } }
  sphere { <14,1,12>,1,1 texture { T_Stone5 } }
  sphere { <13,1,12>,1,1 texture { T_Stone6 } }
  sphere { <12,1,12>,1,1 texture { T_Stone7 } }
  sphere { <10,1,12>,1,1 texture { T_Stone8 } }
  sphere { <9,1,12>,1,1 texture { T_Stone9 } }
  sphere { <8,1,12>,1,1 texture { T_Stone10 } }
  sphere { <7,1,12>,1,1 texture { T_Stone11 } }
  sphere { <6,1,12>,1,1 texture { T_Stone12 } }
  sphere { <5,1,12>,1,1 texture { T_Stone13 } }
  sphere { <4,1,12>,1,1 texture { T_Stone14 } }
  sphere { <3,1,12>,1,1 texture { T_Stone15 } }
  sphere { <2,1,12>,1,1 texture { T_Stone16 } }
  sphere { <1,1,12>,1,1 texture { T_Stone17 } }
  sphere { <0,1,12>,1,1 texture { T_Stone18 } }
  sphere { <0,1,11>,1,1 texture { T_Stone19 } }
  sphere { <0,1,10>,1,1 texture { T_Stone20 } }
  sphere { <0,1,9>,1,1 texture { T_Stone21 } }
  sphere { <0,1,8>,1,1 texture { T_Stone22 } }
  sphere { <0,1,7>,1,1 texture { T_Stone23 } }
  sphere { <0,1,6>,1,1 texture { T_Stone24 } }
  sphere { <0,1,5>,1,1 texture { T_Stone25 } }
  sphere { <0,1,4>,1,1 texture { T_Stone26 } }
  sphere { <0,1,3>,1,1 texture { T_Stone27 } }
  sphere { <0,1,2>,1,1 texture { T_Stone28 } }
  sphere { <0,1,1>,1,1 texture { T_Stone29 } }

  /* Next layer */
  sphere { <0,2,0>,1,1 texture { T_Stone31 } }
  sphere { <1,2,0>,1,1 texture { T_Stone32 } }
  sphere { <5,2,0>,1,1 texture { T_Stone33 } }
  sphere { <6,2,0>,1,1 texture { T_Stone34 } }
  sphere { <6,2,1>,1,1 texture { T_Stone35 } }
  sphere { <6,2,2>,1,1 texture { T_Stone36 } }
  sphere { <6,2,3>,1,1 texture { T_Stone37 } }      
  sphere { <6,2,4>,1,1 texture { T_Stone38 } }
  sphere { <6,2,5>,1,1 texture { T_Stone39 } }
  sphere { <6,2,6>,1,1 texture { T_Stone40 } }
  sphere { <7,2,6>,1,1 texture { T_Stone41 } }
  sphere { <9,2,6>,1,1 texture { T_Stone42 } }
  sphere { <11,2,6>,1,1 texture { T_Stone43 } }
  sphere { <12,2,6>,1,1 texture { T_Stone44 } }
  sphere { <12,2,0>,1,1 texture { T_Stone1 } }
  sphere { <13,2,6>,1,1 texture { T_Stone2 } }
  sphere { <17,2,6>,1,1 texture { T_Stone3 } }
  sphere { <18,2,6>,1,1 texture { T_Stone4 } }
  sphere { <18,2,5>,1,1 texture { T_Stone5 } }
  sphere { <18,2,4>,1,1 texture { T_Stone6 } }
  sphere { <18,2,3>,1,1 texture { T_Stone7 } }
  sphere { <18,2,7>,1,1 texture { T_Stone8 } }
  sphere { <18,2,8>,1,1 texture { T_Stone9 } }
  sphere { <18,2,10>,1,1 texture { T_Stone10 } }
  sphere { <18,2,11>,1,1 texture { T_Stone11 } }  
  sphere { <18,2,12>,1,1 texture { T_Stone12 } }
  sphere { <17,2,12>,1,1 texture { T_Stone13 } }
  sphere { <16,2,12>,1,1 texture { T_Stone14 } }
  sphere { <14,2,12>,1,1 texture { T_Stone15 } }
  sphere { <13,2,12>,1,1 texture { T_Stone16 } }
  sphere { <12,2,12>,1,1 texture { T_Stone17 } }
  sphere { <10,2,12>,1,1 texture { T_Stone18 } }
  sphere { <8,2,12>,1,1 texture { T_Stone19 } }
  sphere { <7,2,12>,1,1 texture { T_Stone20 } }
  sphere { <6,2,12>,1,1 texture { T_Stone21 } }
  sphere { <5,2,12>,1,1 texture { T_Stone22 } }
  sphere { <1,2,12>,1,1 texture { T_Stone23 } }
  sphere { <0,2,12>,1,1 texture { T_Stone24 } }
  sphere { <0,2,11>,1,1 texture { T_Stone25 } }
  sphere { <0,2,10>,1,1 texture { T_Stone26 } }
  sphere { <0,2,8>,1,1 texture { T_Stone27 } }
  sphere { <0,2,7>,1,1 texture { T_Stone28 } }
  sphere { <0,2,6>,1,1 texture { T_Stone29 } }
  sphere { <0,2,5>,1,1 texture { T_Stone30 } }
  sphere { <0,2,4>,1,1 texture { T_Stone31 } }
  sphere { <0,2,2>,1,1 texture { T_Stone32 } }
  sphere { <0,2,1>,1,1 texture { T_Stone33 } }

  /* Next layer */
  sphere { <0,3,0>,1,1 texture { T_Stone34 } }
  sphere { <1,3,0>,1,1 texture { T_Stone35 } }
  sphere { <5,3,0>,1,1 texture { T_Stone36 } }
  sphere { <6,3,0>,1,1 texture { T_Stone37 } }
  sphere { <6,3,1>,1,1 texture { T_Stone38 } }
  sphere { <6,3,2>,1,1 texture { T_Stone39 } }
  sphere { <6,3,3>,1,1 texture { T_Stone40 } }      
  sphere { <6,3,4>,1,1 texture { T_Stone41 } }
  sphere { <6,3,5>,1,1 texture { T_Stone42 } }
  sphere { <6,3,6>,1,1 texture { T_Stone43 } }
  sphere { <7,3,6>,1,1 texture { T_Stone44 } }
  sphere { <9,3,6>,1,1 texture { T_Stone1 } }
  sphere { <11,3,6>,1,1 texture { T_Stone2 } }
  sphere { <12,3,6>,1,1 texture { T_Stone3 } }
  sphere { <12,3,0>,1,1 texture { T_Stone4 } }
  sphere { <13,3,6>,1,1 texture { T_Stone5 } }
  sphere { <17,3,6>,1,1 texture { T_Stone6 } }
  sphere { <18,3,6>,1,1 texture { T_Stone7 } }
  sphere { <18,3,5>,1,1 texture { T_Stone8 } }
  sphere { <18,3,4>,1,1 texture { T_Stone9 } }
  sphere { <18,3,3>,1,1 texture { T_Stone10 } }
  sphere { <18,3,7>,1,1 texture { T_Stone11 } }
  sphere { <18,3,8>,1,1 texture { T_Stone12 } }
  sphere { <18,3,10>,1,1 texture { T_Stone13 } }
  sphere { <18,3,11>,1,1 texture { T_Stone14 } }  
  sphere { <18,3,12>,1,1 texture { T_Stone15 } }
  sphere { <17,3,12>,1,1 texture { T_Stone16 } }
  sphere { <16,3,12>,1,1 texture { T_Stone17 } }
  sphere { <14,3,12>,1,1 texture { T_Stone18 } }
  sphere { <13,3,12>,1,1 texture { T_Stone19 } }
  sphere { <12,3,12>,1,1 texture { T_Stone20 } }
  sphere { <10,3,12>,1,1 texture { T_Stone21 } }
  sphere { <8,3,12>,1,1 texture { T_Stone22 } }
  sphere { <7,3,12>,1,1 texture { T_Stone23 } }
  sphere { <6,3,12>,1,1 texture { T_Stone24 } }
  sphere { <5,3,12>,1,1 texture { T_Stone25 } }
  sphere { <1,3,12>,1,1 texture { T_Stone26 } }
  sphere { <0,3,12>,1,1 texture { T_Stone27 } }
  sphere { <0,3,11>,1,1 texture { T_Stone28 } }
  sphere { <0,3,10>,1,1 texture { T_Stone29 } }
  sphere { <0,3,8>,1,1 texture { T_Stone30 } }
  sphere { <0,3,7>,1,1 texture { T_Stone31 } }
  sphere { <0,3,6>,1,1 texture { T_Stone32 } }
  sphere { <0,3,5>,1,1 texture { T_Stone33 } }
  sphere { <0,3,4>,1,1 texture { T_Stone34 } }
  sphere { <0,3,2>,1,1 texture { T_Stone35 } }
  sphere { <0,3,1>,1,1 texture { T_Stone36 } }

  /* Near roof layer */
  sphere { <0,4,0>,1,1 texture { T_Stone37 } }
  sphere { <1,4,0>,1,1 texture { T_Stone38 } }
  sphere { <2,4,0>,1,1 texture { T_Stone39 } }
  sphere { <3,4,0>,1,1 texture { T_Stone40 } }
  sphere { <4,4,0>,1,1 texture { T_Stone41 } }
  sphere { <5,4,0>,1,1 texture { T_Stone42 } }
  sphere { <6,4,0>,1,1 texture { T_Stone43 } }
  sphere { <6,4,1>,1,1 texture { T_Stone44 } }
  sphere { <6,4,2>,1,1 texture { T_Stone1 } }
  sphere { <6,4,3>,1,1 texture { T_Stone2 } }      
  sphere { <6,4,4>,1,1 texture { T_Stone3 } }
  sphere { <6,4,5>,1,1 texture { T_Stone4 } }
  sphere { <6,4,6>,1,1 texture { T_Stone5 } }
  sphere { <7,4,6>,1,1 texture { T_Stone6 } }
  sphere { <9,4,6>,1,1 texture { T_Stone7 } }
  sphere { <10,4,6>,1,1 texture { T_Stone8 } }
  sphere { <11,4,6>,1,1 texture { T_Stone9 } }
  sphere { <12,4,6>,1,1 texture { T_Stone10 } }
  sphere { <12,4,0>,1,1 texture { T_Stone11 } }
  sphere { <13,4,6>,1,1 texture { T_Stone12 } }
  sphere { <17,4,6>,1,1 texture { T_Stone13 } }
  sphere { <18,4,6>,1,1 texture { T_Stone14 } }
  sphere { <18,4,5>,1,1 texture { T_Stone15 } }
  sphere { <18,4,4>,1,1 texture { T_Stone16 } }
  sphere { <18,4,3>,1,1 texture { T_Stone17 } }
  sphere { <18,4,7>,1,1 texture { T_Stone18 } }
  sphere { <18,4,8>,1,1 texture { T_Stone19 } }
  sphere { <18,4,9>,1,1 texture { T_Stone20 } }
  sphere { <18,4,10>,1,1 texture { T_Stone21 } }
  sphere { <18,4,11>,1,1 texture { T_Stone22 } }  
  sphere { <18,4,12>,1,1 texture { T_Stone23 } }
  sphere { <17,4,12>,1,1 texture { T_Stone24 } }
  sphere { <16,4,12>,1,1 texture { T_Stone25 } }
  sphere { <15,4,12>,1,1 texture { T_Stone26 } }
  sphere { <14,4,12>,1,1 texture { T_Stone27 } }
  sphere { <13,4,12>,1,1 texture { T_Stone28 } }
  sphere { <12,4,12>,1,1 texture { T_Stone29 } }
  sphere { <10,4,12>,1,1 texture { T_Stone30 } }
  sphere { <9,4,12>,1,1 texture { T_Stone31 } }
  sphere { <8,4,12>,1,1 texture { T_Stone32 } }
  sphere { <7,4,12>,1,1 texture { T_Stone33 } }
  sphere { <6,4,12>,1,1 texture { T_Stone34 } }
  sphere { <5,4,12>,1,1 texture { T_Stone35 } }
  sphere { <4,4,12>,1,1 texture { T_Stone36 } }
  sphere { <3,4,12>,1,1 texture { T_Stone37 } }
  sphere { <2,4,12>,1,1 texture { T_Stone38 } }
  sphere { <1,4,12>,1,1 texture { T_Stone39 } }
  sphere { <0,4,12>,1,1 texture { T_Stone40 } }
  sphere { <0,4,11>,1,1 texture { T_Stone41 } }
  sphere { <0,4,10>,1,1 texture { T_Stone42 } }
  sphere { <0,4,9>,1,1 texture { T_Stone43 } }
  sphere { <0,4,8>,1,1 texture { T_Stone44 } }
  sphere { <0,4,7>,1,1 texture { T_Stone1 } }
  sphere { <0,4,6>,1,1 texture { T_Stone2 } }
  sphere { <0,4,5>,1,1 texture { T_Stone3 } }
  sphere { <0,4,4>,1,1 texture { T_Stone4 } }
  sphere { <0,4,3>,1,1 texture { T_Stone5 } }
  sphere { <0,4,2>,1,1 texture { T_Stone6 } }           
  sphere { <0,4,1>,1,1 texture { T_Stone7 } }
  sphere { <8,4,6>,1,1 texture { T_Stone8 } }
  sphere { <14,4,6>,1,1 texture { T_Stone9 } }
  sphere { <15,4,6>,1,1 texture { T_Stone10 } }
  sphere { <16,4,6>,1,1 texture { T_Stone11 } }
  sphere { <11,4,12>,1,1 texture { T_Stone13 } }
  sphere { <12,4,1>,1,1 texture { T_Stone12 } }
  sphere { <12,4,2>,1,1 texture { T_Stone13 } }
  sphere { <12,4,3>,1,1 texture { T_Stone14 } }
  sphere { <12,4,4>,1,1 texture { T_Stone15 } }
  sphere { <12,4,5>,1,1 texture { T_Stone16 } }                                               

  /* Near roof layer */
  sphere { <0,5,0>,1,1 texture { T_Stone17 } }
  sphere { <1,5,0>,1,1 texture { T_Stone18 } }
  sphere { <2,5,0>,1,1 texture { T_Stone19 } }
  sphere { <3,5,0>,1,1 texture { T_Stone20 } }
  sphere { <4,5,0>,1,1 texture { T_Stone21 } }
  sphere { <5,5,0>,1,1 texture { T_Stone22 } }
  sphere { <6,5,0>,1,1 texture { T_Stone23 } }
  sphere { <6,5,1>,1,1 texture { T_Stone24 } }
  sphere { <6,5,2>,1,1 texture { T_Stone25 } }
  sphere { <6,5,3>,1,1 texture { T_Stone26 } }      
  sphere { <6,5,4>,1,1 texture { T_Stone27 } }
  sphere { <6,5,5>,1,1 texture { T_Stone28 } }
  sphere { <6,5,6>,1,1 texture { T_Stone29 } }
  sphere { <7,5,6>,1,1 texture { T_Stone30 } }
  sphere { <9,5,6>,1,1 texture { T_Stone31 } }
  sphere { <10,5,6>,1,1 texture { T_Stone32 } }
  sphere { <11,5,6>,1,1 texture { T_Stone33 } }
  sphere { <12,5,6>,1,1 texture { T_Stone34 } }
  sphere { <12,5,0>,1,1 texture { T_Stone35 } }
  sphere { <13,5,6>,1,1 texture { T_Stone36 } }
  sphere { <17,5,6>,1,1 texture { T_Stone37 } }
  sphere { <18,5,6>,1,1 texture { T_Stone38 } }
  sphere { <18,5,5>,1,1 texture { T_Stone39 } }
  sphere { <18,5,4>,1,1 texture { T_Stone40 } }
  sphere { <18,5,3>,1,1 texture { T_Stone41 } }
  sphere { <18,5,7>,1,1 texture { T_Stone42 } }
  sphere { <18,5,8>,1,1 texture { T_Stone43 } }
  sphere { <18,5,9>,1,1 texture { T_Stone44 } }
  sphere { <18,5,10>,1,1 texture { T_Stone1 } }
  sphere { <18,5,11>,1,1 texture { T_Stone2 } }  
  sphere { <18,5,12>,1,1 texture { T_Stone3 } }
  sphere { <17,5,12>,1,1 texture { T_Stone4 } }
  sphere { <16,5,12>,1,1 texture { T_Stone5 } }
  sphere { <15,5,12>,1,1 texture { T_Stone6 } }
  sphere { <14,5,12>,1,1 texture { T_Stone7 } }
  sphere { <13,5,12>,1,1 texture { T_Stone8 } }
  sphere { <12,5,12>,1,1 texture { T_Stone9 } }
  sphere { <10,5,12>,1,1 texture { T_Stone10 } }
  sphere { <9,5,12>,1,1 texture { T_Stone11 } }
  sphere { <8,5,12>,1,1 texture { T_Stone12 } }
  sphere { <7,5,12>,1,1 texture { T_Stone13 } }
  sphere { <6,5,12>,1,1 texture { T_Stone14 } }
  sphere { <5,5,12>,1,1 texture { T_Stone15 } }
  sphere { <4,5,12>,1,1 texture { T_Stone16 } }
  sphere { <3,5,12>,1,1 texture { T_Stone17 } }
  sphere { <2,5,12>,1,1 texture { T_Stone18 } }
  sphere { <1,5,12>,1,1 texture { T_Stone19 } }
  sphere { <0,5,12>,1,1 texture { T_Stone20 } }
  sphere { <0,5,11>,1,1 texture { T_Stone21 } }
  sphere { <0,5,10>,1,1 texture { T_Stone22 } }
  sphere { <0,5,9>,1,1 texture { T_Stone23 } }
  sphere { <0,5,8>,1,1 texture { T_Stone24 } }
  sphere { <0,5,7>,1,1 texture { T_Stone25 } }
  sphere { <0,5,6>,1,1 texture { T_Stone26 } }
  sphere { <0,5,5>,1,1 texture { T_Stone27 } }
  sphere { <0,5,4>,1,1 texture { T_Stone28 } }
  sphere { <0,5,3>,1,1 texture { T_Stone29 } }
  sphere { <0,5,2>,1,1 texture { T_Stone30 } }           
  sphere { <0,5,1>,1,1 texture { T_Stone31 } }
  sphere { <8,5,6>,1,1 texture { T_Stone32 } }
  sphere { <14,5,6>,1,1 texture { T_Stone33 } }
  sphere { <15,5,6>,1,1 texture { T_Stone34 } }
  sphere { <16,5,6>,1,1 texture { T_Stone35 } }
  sphere { <11,5,12>,1,1 texture { T_Stone36 } }
  sphere { <12,5,1>,1,1 texture { T_Stone37 } }
  sphere { <12,5,2>,1,1 texture { T_Stone38 } }
  sphere { <12,5,3>,1,1 texture { T_Stone39 } }
  sphere { <12,5,4>,1,1 texture { T_Stone40 } }
  sphere { <12,5,5>,1,1 texture { T_Stone41 } }                                               
}

#declare door = union {
  difference {
    box {
      <-0.5,-0.5,-0.2>,
      <1.5,3.5,0.2>
    }
    box {
      <-0.1,-1,-1>,
      <1.1,2.9,1>
    }
    texture {
      T_Wood1
    }
    pigment {
      rgbt <1,1,1,0.1>
    }
  }
  box {
    <-0.1,-0.5,-0.1>,
    <1.1,3,0.1>
    texture {
      T_Wood1
    }
  }
}

#declare garagedoor = union {
  difference {
    box {
      <-0.5,-0.5,-0.2>,
      <3.5,3.5,0.2>
    }
    box {
      <-0.1,-1,-1>,
      <3.1,2.9,1>
    }
    texture {
      T_Wood1
    }
    pigment {
      rgbt <1,1,1,0.2>
    }
  }  
  difference {
    box {
      <-0.1,-0.5,-0.1>,
      <3.1,3,0.1>
    }
    box {
      <-1,0,-1>,
      <4,0.1,1>
    }
    box {
      <-1,0.6,-1>,
      <4,0.7,1>
    }

    box {
      <-1,1.2,-1>,
      <4,1.3,1>
    }
    box {
      <-1,1.8,-1>,
      <4,1.9,1>
    }
    box {
      <-1,2.4,-1>,
      <4,2.5,1>
    }
    box {
      <0.1,2,-1>,
      <0.4,2.3,1>
    }
    box {
      <0.5,2,-1>,
      <0.8,2.3,1>
    }
    box {
      <0.9,2,-1>,
      <1.2,2.3,1>
    }
    box {
      <1.8,2,-1>,
      <2.1,2.3,1>
    }
    box {
      <2.2,2,-1>,
      <2.5,2.3,1>
    }
    box {
      <2.6,2,-1>,
      <2.9,2.3,1>
    }
    texture {
      T_Wood1
    }
    pigment {
      rgbt <1,1,1,0.4>
    }
  }  
  box {
    <0,2,-0.05>,
    <3,2.3,0.05>
    texture {
      T_Glass1
    }
    interior {
      I_Glass
    }
  }
}
        
#declare smallwindow = union {
  box {
    <0,0,-0.1>,
    <1,2,0.1>
    texture {
      T_Glass1
    }
    interior {
      I_Glass
    }
  }
  difference {
    box {
      <-0.5,-0.5,-0.2>,
      <1.5,2.5,0.2>
    }
    box {
      <0.1,0.1,-1>,
      <0.9,0.9,1>
    }
    box {
      <0.1,1,-1>,
      <0.26,1.5,1>
    }
    box {
      <0.36,1,-1>,
      <0.63,1.5,1>
    }
    box {
      <0.73,1,-1>,
      <0.9,1.5,1>
    }
    box {
      <0.1,1.9,-1>,
      <0.26,1.6,1>
    }
    box {
      <0.36,1.9,-1>,
      <0.63,1.6,1> 
    }
    box {
      <0.73,1.9,-1>,
      <0.9,1.6,1>
    }                
    texture {
      T_Wood1
    }
    pigment {
      rgbt <1,1,1,0.1>
    }
  }  
  box {
    <-0.2,0,-0.4>,
    <1.2,-0.2,0.4>
    pigment {
      Firebrick
    }
  }  
}

#declare bigwindow = union {
  difference {
    box {
      <-0.5,-0.5,-0.2>,
      <3.5,2.5,0.2>
    }
    box {
      <0.1,0.1,-1>,
      <0.6,1.9,1>
    }
    box {
      <2.9,0.1,-1>,
      <2.4,1.9,1>
    }
    box {
      <0.8,0.1,-1>,
      <2.2,1.9,1>
    }
    texture {
      T_Wood1
    }
    pigment {
      rgbt <1,1,1,0.1>
    }
  }
  box {
    <0,0,-0.1>,
    <3,2,0.1>
    texture {
      T_Glass1
    }
    interior {
      I_Glass
    }
  }
  box {
    <-0.2,0,-0.4>,
    <3.2,-0.2,0.4>
    pigment {
      Firebrick
    }
  }
}

object {
  bigwindow
  translate <1.5,1.5,0>
}

object {
  bigwindow
  translate <1.5,1.5,12>
}

object {
  smallwindow
  translate <9.5,1.5,6>
}

object {
  smallwindow 
  translate <8.5,1.5,12>
}

object {
  smallwindow
  translate <14.5,1.5,12>
}

object {
  smallwindow
  rotate <0,90,0>
  translate <18,1.5,9.5>
}

object {
  smallwindow
  rotate <0,90,0>
  translate <0,1.5,3.5>
}

object {
  smallwindow
  rotate <0,90,0>
  translate <0,1.5,9.5>
}
           
object {
  door
  translate <7.5,0.5,6>
}    

object {
  door
  translate <10.5,0.5,12>
}

object {
  garagedoor
  translate <13.5,0.5,6>
}

#declare roofball = difference {
  sphere {
    <3,5,3>,4.5
  }
  box {
    <-2,5,-2>,
    <8,0,8>
  }
  texture {
    T_Chrome_1C
  }
}

object {
  roofball
}

object {
  roofball
  translate <6,0,0>
}

object {
  roofball
  translate <0,0,6>
}

object {
  roofball
  translate <6,0,6>
}

object {
  roofball
  translate <12,0,6>
}

box {
  <6,-1,0>,
  <12,0.5,6>
  texture {
    T_Stone2
  }
}

box {
  <12,-1,4>,
  <12.5,0.25,6>
  texture {
    T_Stone3
  }
}
        
