#declare PIRA = seed(3485623478);


#declare WET_STONE = texture{
 finish{
  ambient 0.2
  diffuse 0.2
  reflection 0.1
  specular 0.01
  roughness 2
 }
// pigment{Red}
 pigment{
  gradient y
  color_map{
   [ 0.3 DarkBrown*0.7] 
   [ 0.7 Green]
  }
 }
}

#declare CLEAN_STONE = texture{
 finish{
  ambient 0.01
  diffuse 0.5
  reflection 0
  specular 0.1
  roughness 4
 }
 pigment{Wheat5*3} 
}

#declare CLEAN_STONE_a = texture{
 finish{
  ambient 0.0
  diffuse 0.5
  reflection 0
  specular 0.1
  roughness 4
 }
 normal{
  bumps 
  scale 0.1
  turbulence 0.3
 }
 pigment{Wheat5*3} 
}

#declare DRY_STONE = texture{
 finish{
  ambient 0.1
  diffuse 0.3
  reflection 0
  specular 0.1
  roughness 2
 }
 pigment{
  marble
  color_map{
   [0.3 Black]
   [0.7 Wheat4]
   [0.7 Wheat]
//   [0.3 Wheat5*2]
//   [0.7 Wheat4*2]
//   [0.7 Wheat*2]
  }
  turbulence 1.0
 }
 normal{
  crackle
 } 
 scale 0.5
}

#declare DRY_STONE_O = texture{
 finish{
  ambient 0.1
  diffuse 0.3
  reflection 0
  specular 0.1
  roughness 2
 }
 pigment{
  marble
  color_map{
   [0.3 Black]
   [0.7 Wheat4]
   [0.7 Wheat]
  }
  turbulence 1.0
 }
 normal{
  crackle
 } 
 scale 0.5
}

#declare STONE = texture{
  gradient y
  texture_map{
   [ 0.01 WET_STONE]
   [ 0.015 CLEAN_STONE]
  }
  turbulence 0.006
  scale 50
  scale <0.1,0.5,0.1>
 translate <0,-1.8,0>
}

// ***********************************************************
// ***************** PILLAR **********************************
// ***********************************************************

//-------------------------------------------- base of pillar
#macro P_BASE(p_rad)
 union{
  box{<-p_rad-0.5,0,-p_rad-0.5>, <p_rad+0.5,0.2,p_rad+0.5>}
  cylinder{<0,0.2,0>, <0,0.4,0>, p_rad+0.4}
  cone{<0,0.4,0>,p_rad+0.4,<0,0.6,0>,p_rad+0.2}
  difference{
   cylinder{<0,0.6,0>,<0,0.8,0>,p_rad+0.2}
   torus{p_rad+0.2,0.2 translate <0,0.8,0>}
  }
 }
#end

//-------------------------------------------- body of pillar

#macro P_BODY(p_rad,p_height)
 difference{
  cylinder{<0,0,0>,<0,p_height,0>,p_rad}
  #local i = 0;
  #while (i<36)
   cylinder{<0,0,0>,<0,p_height,0>,0.05*p_rad 
     translate <p_rad,0,0> 
     rotate <0,10*i,0>
   }
   #local i = i+1;
  #end
 }
#end

//-------------------------------------------- top of pillar
#macro P_TOP(p_rad)
 union{
  difference{
   cylinder{<0,0,0>,<0,0.2,0>,p_rad+0.2}
   torus{p_rad+0.2,0.2}
  }
  cylinder{<0,0.2,0>,<0,0.3,0>,p_rad+0.3}
  cylinder{<0,0.3,0>,<0,0.5,0>,p_rad+0.2}
  cylinder{<0,0.5,0>,<0,0.6,0>,p_rad+0.3}
  difference{
   box{<-p_rad-0.4,0.6,-p_rad-0.4>,<p_rad+0.4,0.8,p_rad+0.4>}
   cylinder{<-p_rad-0.4,-0.2,-p_rad-0.4>,<-p_rad-0.4,1.8,-p_rad-0.4>,0.6}
   cylinder{<p_rad+0.4,-0.2,-p_rad-0.4>,<p_rad+0.4,1.8,-p_rad-0.4>,0.6}
   cylinder{<-p_rad-0.4,-0.2,p_rad+0.4>,<-p_rad-0.4,1.8,p_rad+0.4>,0.6}
   cylinder{<p_rad+0.4,-0.2,p_rad+0.4>,<p_rad+0.4,1.8,p_rad+0.4>,0.6}
  }
  box{<-p_rad-0.5,0.8,-p_rad-0.5>,<p_rad+0.5,1,p_rad+0.5>}
 }
#end


#declare P_TOP2 = object{
 #local i = 0;
 union{
  #while (i < 36)
   #local B_rad = 0.4/36*i;
   #local R_alpha = i*10;
    cylinder{<0,B_rad,-1>,<0,B_rad,1>,0.04
     rotate<0,0,-R_alpha>
     translate<-1,0,0>
    }
    cylinder{<0,B_rad,-1>,<0,B_rad,1>,0.04
     rotate<0,0,R_alpha>
     translate<1,0,0>
    }
    #local p1 = vrotate(<0,B_rad,0>,<0,0,R_alpha>);
    #local p2 = vrotate(<0,B_rad,0>,<0,0,-R_alpha>);
    box{<0,0,-0.95>,p1+<0,0,0.95> translate <1,0,0>}
    box{<0,0,-0.95>,p2+<0,0,0.95> translate <-1,0,0>}
   #local i = i + 1;
  #end
  box{<-1,B_rad-0.04,-1.03>,<1,B_rad+0.04,1.03> }
  box{<-1,0.4,-0.95>,<1,0,0.95> }
 }
}

//-------------------------------------------- pillar


#declare PILLAR = object{
 union{
  object{P_BASE(0.7)}
  object{P_BODY(0.7,10.2) translate <0,0.8,0>}
  object{P_TOP(0.7) translate <0,10.2,0>}
  texture{CLEAN_STONE}
 }
}

#declare PILLAR2 = object{
 union{
  object{P_BASE(0.7)}
  object{P_BODY(0.7,10.2) translate <0,0.8,0>}
  object{P_TOP2 translate <0,10.9,0>}
  texture{CLEAN_STONE}
 }
}

#declare PILLAR2a = object{
 union{
  object{P_BASE(0.7)}
  object{P_BODY(0.7,14.2) translate <0,0.8,0>}
  object{P_TOP2 translate <0,14.9,0>}
  texture{CLEAN_STONE}
 }
}

#declare REEL_BASE = object{
 difference{
  cylinder{<0,0,0>,<0,1.5,0>,0.25}
  torus{0.25,0.15 scale <1,2,1>}
  torus{0.25,0.15 scale <1,2,1> translate y*0.8}
  torus{0.25,0.15 scale <1,3,1> translate <0,1.5,0>}
 }
 texture{CLEAN_STONE}
}

#declare RECT_PILLAR = object{
 union{
  box{<-0.9,0.0,-0.65>,<0.9,0.2,0.65>}   // base
  box{<-0.8,0.2,-0.55>,<0.8,0.3,0.55>}
  box{<-0.7,0.3,-0.45>,<0.7,0.5,0.45>}
  box{<-0.8,0.5,-0.55>,<0.8,0.6,0.55>}
  box{<-0.7,0.6,-0.45>,<0.7,0.8,0.45>}
  box{<-0.5,0.8,-0.25>,<0.5,10.2,0.25>}  // body
  box{<-0.7,10.2,-0.45>,<0.7,10.5,0.45>} // top
  box{<-0.8,10.5,-0.55>,<0.8,10.6,0.55>} 
  box{<-0.7,10.6,-0.45>,<0.7,10.7,0.45>} 
  box{<-0.8,10.7,-0.55>,<0.8,10.8,0.55>} 
  box{<-0.9,10.8,-0.65>,<0.9,11.2,0.65>} 
 }
}

#declare TOWER_STAIRS = object{
 union{
  #local i = 0;
  #while (i<4)
   cylinder{<0,-i*0.5,0>,<0,-(i+1)*0.5,0>,4+i*0.5}
   box{<-(4+i*0.5),-i*0.5,0>,<4+i*0.5,-(i+1)*0.5,5>}
   #local i = i + 1;
  #end
 }
 texture{STONE}
}

// ***********************************************************
// ***************** TOWER LEVEL ONE *************************
// ***********************************************************

//-------------------------------------------- stucco element 1
#declare STUCCO_1 = object{
 #local a = 0.75;
 #local b = 1.5;
 #local r = (a*a + b*b)/(2*a);
 union{
  difference{
   box {<-0.5,0,0>,<0.5,2,1>}
   cylinder{<-0.6,0,0.75-r>,<0.6,0,0.75-r>,r}
   torus{r,0.05 rotate z*90 translate <0.25,0,0.75-r>}
   torus{r,0.05 rotate z*90 translate <-0.25,0,0.75-r>}
   box {
    <-0.125,-0.125,-0.1>,<0.125,0.125,0.05> translate <0.2625,1.75,0>}
   box {
    <-0.125,-0.125,-0.1>,<0.125,0.125,0.05> translate <-0.2625,1.75,0>}
  }
  box{<-0.625,2,-0.125>,<0.625,2.125,1>}
  box{<-0.75,2.125,-0.25>,<0.75,2.25,1>}
  box{<-0.85,2.25,-0.35>,<0.85,2.3,1>}
  box{<-0.95,2.3,-0.45>,<0.95,2.35,1>}
  box{<-1.05,2.35,-0.5>,<1.05,2.5,1>}
 } 
}

//-------------------------------------------- stucco element 2
#declare STUCCO_2 = object{
 union{
  difference{
   union{
    box{<-0.25,0,0>,<0.25,2,1>}
    box{<-0.125,-0.125,-0.1>,<0.125,0.125,0.05> translate<0,1.75,0>}
   }
   cylinder {<-0.3,0.75,0>,<0.3,0.75,0>,0.75}
   box{<-0.3,-0.1,-0.1>,<0.3,0.75,0.75>}
   cylinder {<-0.125,0.75,0>,<0.125,0.75,0>,0.8}
   box{<-0.125,-0.1,-0.1>,<0.125,0.75,0.8>}
  }
  box{<-0.375,2,-0.125>,<0.375,2.125,1>}
  box{<-0.5,2.125,-0.25>,<0.5,2.25,1>}
  box{<-0.6,2.25,-0.35>,<0.6,2.3,1>}
  box{<-0.7,2.3,-0.45>,<0.7,2.35,1>}
  box{<-0.8,2.35,-0.5>,<0.8,2.5,1>}

 } 
}

//-------------------------------------------- roof of tower lvl 1
#declare TOWER_ROOF1 = object{
 union{
  box{<-2,0,0>,<2,3.5,5>}
  box{<-2.125,3,-0.125>,<2.125,3.125,5>}
  box{<-2.25,3.125,-0.25>,<2.25,3.25,5>}
  box{<-2.35,3.25,-0.35>,<2.35,3.3,5>}
  box{<-2.45,3.3,-0.45>,<2.45,3.35,5>}
  box{<-2.55,3.35,-0.55>,<2.55,3.5,5>}
  object{STUCCO_2 translate <-1.5,1,-1>}
  object{STUCCO_2 translate <-0.5,1,-1>}
  object{STUCCO_2 translate <0.5,1,-1>}
  object{STUCCO_2 translate <1.5,1,-1>}
  object{STUCCO_1 rotate y*90 translate <-3,1,1.25>}
  object{STUCCO_1 rotate y*-90 translate <3,1,1.25>}
  box{<-2.375,1,5>,<2.375,0.9,-0.375>}
  box{<-2.25,0.9,5>,<2.25,0.8,-0.25>}
 }
}
//-------------------------------------------- arch

#macro e_cylinder(p1,p2,o_rad,th)
 difference{
  cylinder{p1,p2,o_rad}
  cylinder{p1+0.01*(p1-p2),p2+0.01*(p2-p1),o_rad-th}
 }
#end

#declare UPPER_ARCH = object{
 union{
  box{<-11.5,10.2,-0.15>,<11.5,10.5,0.15>} // 1.band
  box{<-11.5,10.5,-0.25>,<11.5,10.6,0.25>} 
  box{<-11.5,10.6,-0.15>,<11.5,10.7,0.15>} 
  box{<-11.5,10.7,-0.25>,<11.5,10.8,0.25>} 
  box{<-11.5,10.8,-0.35>,<11.5,11.2,0.35>}
  box{<-11.5,11.2+1,5>,<11.5,11.2+0.9,-0.375>} // 2.band 
  box{<-11.5,11.2+0.9,5>,<11.5,11.2+0.8,-0.25>}
  box{<-11.5,11.2+3,-1.125>,<11.5,11.2+3.125,1>} // 3. band
  box{<-11.5,11.2+3.125,-1.25>,<11.5,11.2+3.25,1>}
  box{<-11.5,11.2+3.25,-1.35>,<11.5,11.2+3.3,1>}
  box{<-11.5,11.2+3.3,-1.45>,<11.5,11.2+3.35,1>}
  box{<-11.5,11.2+3.35,-1.55>,<11.5,11.2+3.5,1>}
  #object{STUCCO_2 translate <0,12.2,-1>}
  #local i = 0;
  #while (i < 11)
   #object{STUCCO_2 translate <i + 1,12.2,-1>}
   #object{STUCCO_2 translate <-i - 1,12.2,-1>}
   #local i = i+1;
  #end
 }
}

#declare ARCH = object{
 union{
  difference{
   union{
    object{e_cylinder(<0,0,0>,    <0,0,20>,   10,0.3)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 10.3,0.3)}
    object{e_cylinder(<0,0,0>,    <0,0,20>,   10.4,0.1)}
    object{e_cylinder(<0,0,-0.2>, <0,0,20.2>, 10.7,0.3)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 10.8,0.1)}
    object{e_cylinder(<0,0,-0.2>, <0,0,20.2>, 10.9,0.1)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 11,0.1)}
    difference{
     union{
      box{<-11.5,0,0>,<11.5,14.7,20>}
      object{UPPER_ARCH}
     }
     cylinder{<0,0,-1>,<0,0,21>,11}
    }
   }
   box{<-15,0,-5>,<15,-15,25>}
  }
  box{<-9,0,-0.5>,<-11.5,-2,20.5> texture{CLEAN_STONE}}
  box{<-8.5,-0.5,-1>,<-11.5,-2,21> texture{CLEAN_STONE}}
  box{<-8,-1,-1.5>,<-11.5,-2,21.5> texture{CLEAN_STONE}}
  box{<-7.5,-1.5,-2>,<-11.5,-2,22> texture{STONE}}
  box{<9,0,-0.5>,<11.5,-2,20.5> texture{CLEAN_STONE}}
  box{<8.5,-0.5,-1>,<11.5,-2,21> texture{CLEAN_STONE}}
  box{<8,-1,-1.5>,<11.5,-2,21.5> texture{CLEAN_STONE}}
  box{<7.5,-1.5,-2>,<11.5,-2,22> texture{STONE}}
 }
 texture{CLEAN_STONE}
}

#declare ARCH_a = object{
 union{
  difference{
   union{
    object{e_cylinder(<0,0,0>,    <0,0,20>,   10,0.3)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 10.3,0.3)}
    object{e_cylinder(<0,0,0>,    <0,0,20>,   10.4,0.1)}
    object{e_cylinder(<0,0,-0.2>, <0,0,20.2>, 10.7,0.3)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 10.8,0.1)}
    object{e_cylinder(<0,0,-0.2>, <0,0,20.2>, 10.9,0.1)}
    object{e_cylinder(<0,0,-0.1>, <0,0,20.1>, 11,0.1)}
    difference{
     union{
      box{<-11.5,0,0>,<11.5,14.7,20>}
      object{UPPER_ARCH}
     }
     cylinder{<0,0,-1>,<0,0,21>,11}
    }
   }
   box{<-15,0,-5>,<15,-15,25>}
  }
  box{<-9,0,-0.5>,<-11.5,-2,20.5> texture{CLEAN_STONE}}
  box{<-8.5,-0.5,-1>,<-11.5,-2,21> texture{CLEAN_STONE}}
  box{<-8,-1,-1.5>,<-11.5,-2,21.5> texture{CLEAN_STONE}}
  box{<-7.5,-1.5,-2>,<-11.5,-2,22> texture{STONE}}
  box{<9,0,-0.5>,<11.5,-2,20.5> texture{CLEAN_STONE}}
  box{<8.5,-0.5,-1>,<11.5,-2,21> texture{CLEAN_STONE}}
  box{<8,-1,-1.5>,<11.5,-2,21.5> texture{CLEAN_STONE}}
  box{<7.5,-1.5,-2>,<11.5,-2,22> texture{STONE}}
 }
 texture{CLEAN_STONE_a}
}

#declare TOWER_ROOF2 = object{
 union{
  box{<-4,0,0>,           <4,3.5,5>}
  box{<-4.125,3,-0.125>,  <4.125,3.125,5>}
  box{<-4.25,3.125,-0.25>,<4.25,3.25,5>}
  box{<-4.35,3.25,-0.35>, <4.35,3.3,5>}
  box{<-4.45,3.3,-0.45>,  <4.45,3.35,5>}
  box{<-4.55,3.35,-0.55>, <4.55,3.5,5>}
  object{STUCCO_2 translate <-3.5,1,-1>}
  object{STUCCO_2 translate <-2.5,1,-1>}
  object{STUCCO_2 translate <2.5,1,-1>}
  object{STUCCO_2 translate <3.5,1,-1>}
  object{STUCCO_1 rotate y*90 translate <-5,1,1.25>}
  object{STUCCO_1 rotate y*-90 translate <5,1,1.25>}
  box{<-4.375,1,5>,<4.375,0.9,-0.375>}
  box{<-4.25,0.9,5>,<4.25,0.8,-0.25>}
 }
}

#declare BANK_DESIGN = object{
 union{                                        //stairs
  box{<-5,0,10>,     <20,-0.5,-7> texture{STONE}}
  box{<-5.5,-0.5,10>,<20.5,-1,-7.5>texture{STONE}}
  box{<-6,-1,10>,    <21,-1.5,-8>texture{STONE}}
  box{<-6.5,-1.5,10>,<21.5,-2,-8.5> texture{STONE}}
  object{TOWER_ROOF2 rotate y*90 translate <-5,11.2,-2>}
  object{PILLAR translate<-3,0,-5> }
  object{PILLAR translate<-3,0,0> }
  box{<-5,0,-40>,     <20,-0.5,-25>texture{STONE}}
  box{<-5.5,-0.5,-40>,<20.5,-1,-24.5>texture{STONE}}
  box{<-6,-1,-40>,    <21,-1.5,-24>texture{STONE}}
  box{<-6.5,-1.5,-40>,<21.5,-2,-23.5> texture{STONE}}
  object{TOWER_ROOF2 rotate y*90 translate <-5,11.2,-30>}
  object{PILLAR translate<-3,0,-27> }
  object{PILLAR translate<-3,0,-32> }
  object{ARCH rotate y*90 translate <0,0,-16>}

  box{<20,-4,-1>, <60,14.7,-9>}
  box{<20,-4,-31>,<60,14.7,-41>}
  #local i = 0;
  #while (i<20)
   box {<25+i*0.5,-2+i*0.5,-1>,<60,-2+0.5+i*0.5,-31> texture{CLEAN_STONE}}
   box {<35+i*0.5,3+i*0.5,-1>,<60,3.5+i*0.5,-31> texture{CLEAN_STONE}}
   #local i = i + 1;        
   
  #end

  difference{
   box{<0,0,-6>,      <20,14.7,10>}
   cylinder{<0,2,-2>,<0,5,-2>,1}
   sphere{<0,5,-2>,1}
  }
  difference{
   box{<0,0,-27.5>,      <20,14.7,-50>}
   cylinder{<0,2,-30>,<0,5,-30>,1}
   sphere{<0,5,-30>,1}
  }
 }
}


#declare BANK_DESIGN_a = object{
 union{                                        //stairs
  box{<-5,0,10>,     <20,-0.5,-7> texture{STONE}}
  box{<-5.5,-0.5,10>,<20.5,-1,-7.5>texture{STONE}}
  box{<-6,-1,10>,    <21,-1.5,-8>texture{STONE}}
  box{<-6.5,-1.5,10>,<21.5,-2,-8.5> texture{STONE}}
  object{TOWER_ROOF2 rotate y*90 translate <-5,11.2,-2>}
  object{PILLAR translate<-3,0,-5> }
  object{PILLAR translate<-3,0,0> }
  box{<-5,0,-40>,     <20,-0.5,-25>texture{STONE}}
  box{<-5.5,-0.5,-40>,<20.5,-1,-24.5>texture{STONE}}
  box{<-6,-1,-40>,    <21,-1.5,-24>texture{STONE}}
  box{<-6.5,-1.5,-40>,<21.5,-2,-23.5> texture{STONE}}
  object{TOWER_ROOF2 rotate y*90 translate <-5,11.2,-30>}
  object{PILLAR translate<-3,0,-27> }
  object{PILLAR translate<-3,0,-32> }
  object{ARCH_a rotate y*90 translate <0,0,-16>}

  box{<20,-4,-1>, <60,14.7,-9>}
  box{<20,-4,-31>,<60,14.7,-41>}
  #local i = 0;
  #while (i<20)
   box {<25+i*0.5,-2+i*0.5,-1>,<60,-2+0.5+i*0.5,-31> texture{CLEAN_STONE}}
   box {<35+i*0.5,3+i*0.5,-1>,<60,3.5+i*0.5,-31> texture{CLEAN_STONE}}
   #local i = i + 1;        
   
  #end

  difference{
   box{<0,0,-6>,      <20,14.7,10>}
   cylinder{<0,2,-2>,<0,5,-2>,1}
   sphere{<0,5,-2>,1}
  }
  difference{
   box{<0,0,-27.5>,      <20,14.7,-50>}
   cylinder{<0,2,-30>,<0,5,-30>,1}
   sphere{<0,5,-30>,1}
  }
 }
}

#declare TOWER_LEVEL1 = object{
 union{
  object{PILLAR translate<-1.5,4,1> texture{CLEAN_STONE}}
  object{PILLAR translate<1.5,4,1>texture{CLEAN_STONE}}
  object{TOWER_ROOF1 translate<0,15.2,0>}
  object{TOWER_STAIRS translate <0,4,1> }
  object{RECT_PILLAR rotate <0,90,0> translate <-2,4,4.5>}
  object{RECT_PILLAR rotate <0,90,0> translate <-1.5,4,3.5>}
  object{RECT_PILLAR rotate <0,90,0> translate <2,4,4.5>}
  object{RECT_PILLAR rotate <0,90,0> translate <1.5,4,3.5>}
 }
}

#declare LEVEL_1 = object{
 union{
  object{TOWER_LEVEL1 texture{DRY_STONE } translate <-27,0,0>} 
  object{ARCH translate<-13.5,4,5>}
  object{TOWER_LEVEL1 texture{DRY_STONE translate y*4} translate <0,0,0> }
  object{ARCH translate<13.5,4,5>}
  object{TOWER_LEVEL1 texture{DRY_STONE translate y*2} translate <27,0,0>}
  object{ARCH translate<40.5,4,5>}
  object{TOWER_LEVEL1 texture{DRY_STONE translate y*5} translate <54,0,0>}
  object{ARCH translate<67.5,4,5>}
  object{TOWER_LEVEL1 texture{DRY_STONE translate y*40} translate <81,0,0>}
  object{ARCH translate<94.5,4,5>}
  object{TOWER_LEVEL1 texture{STONE translate y*4} translate <108,0,0>}
  object{BANK_DESIGN texture{DRY_STONE} translate <115,4,0>}
  object{BANK_DESIGN_a texture{DRY_STONE} 
    matrix <-1,0,0,
             0,1,0,
             0,0,1,
             0,0,0> 
    translate <-27,4,0>
  } 
 }
}

// ***********************************************************
// ***************** TOWER LEVEL TWO *************************
// ***********************************************************


#macro BASEBOX_LEVEL2(x_dim,z_dim)
 union{
  box{<0,0,0>,<x_dim,4,z_dim>}
  box{<-0.3,0,-0.3>,<x_dim+0.3,1,z_dim+0.3> }
  box{<-0.2,1,-0.2>,<x_dim+0.2,1.1,z_dim+0.2>}
  box{<-0.1,1.1,-0.1>,<x_dim+0.1,1.2,z_dim+0.1>}

  box{<-0.2,3,-0.2>,<x_dim+0.2,3.2,z_dim+0.2>}
  box{<-0.1,3.2,-0.1>,<x_dim+0.1,3.3,z_dim+0.1>}
  box{<-0.2,3.3,-0.2>,<x_dim+0.2,3.4,z_dim+0.2>}
 }
#end        


#declare LVL2_BASE = object{
 BASEBOX_LEVEL2(135,20)
}

#macro HALF_CYLINDER(l,c_rad)
 object{
  difference{
   cylinder{<0,0,0>,<0,0,l>,c_rad}
   box{<-1.01*c_rad,0,-0.01>,<1.01*c_rad,-1.01*c_rad,1.01*l>}
  }
 } 
#end

#macro HALF_SHELL(l,c_rad,th)
 difference{
  object{HALF_CYLINDER(l,c_rad) }
  cylinder{<0,0,-0.1>,<0,0,1.1*l>,c_rad-th} 
 } 
#end 

#macro LEVEL2_ROOF(x_len,z_len)
 union{
  box{<0,0,0>,<x_len,2.8,z_len>}
  box{<-0.1,0.2,-0.1>,<x_len+0.1,0.4,z_len+0.1>} // lower part
  box{<-0.1,0.5,-0.1>,<x_len+0.1,0.7,z_len+0.1>}
  box{<-0.2,0.7,-0.2>,<x_len+0.2,0.8,z_len+0.2>}
  box{<-0.3,0.8,-0.3>,<x_len+0.3,0.9,z_len+0.3>}
  box{<-0.2,1.9,-0.2>,<x_len+0.2,2.4,z_len+0.2>} // upper part
  box{<-0.3,2.1,-0.3>,<x_len+0.3,2.2,z_len+0.3>}
  box{<-0.3,2.4,-0.3>,<x_len+0.3,2.5,z_len+0.3>}
  box{<-0.4,2.5,-0.4>,<x_len+0.4,2.7,z_len+0.4>}
  box{<-0.5,2.7,-0.5>,<x_len+0.5,2.8,z_len+0.5>}
 }
#end

#declare TOWER_LVL2 = object{
 union{
  object{BASEBOX_LEVEL2(5,5)}
  object{BASEBOX_LEVEL2(1,1) translate<-1,0,4> }
  object{BASEBOX_LEVEL2(1,1) translate<5,0,4> }
  object{PILLAR2 rotate y*90 translate<1.3,4,1.5> texture{CLEAN_STONE}}
  object{PILLAR2 rotate y*90 translate<3.7,4,1.5> texture{CLEAN_STONE}}
  object{RECT_PILLAR rotate y*90 translate <0.2,4,5>}
  object{RECT_PILLAR rotate y*90 translate <4.8,4,5>}
  object{RECT_PILLAR rotate y*90 translate <-0.3,4,6>}
  object{RECT_PILLAR rotate y*90 translate <5.3,4,6>}
  object{RECT_PILLAR rotate y*90 translate <0.7,4,4>}
  object{RECT_PILLAR rotate y*90 translate <4.3,4,4>}
  object{LEVEL2_ROOF (5,5) translate <0,15.2,0.5>}

  object{HALF_SHELL(6.5,3,0.2) translate<2.5,18,-0.5>  texture{CLEAN_STONE}}
  object{HALF_SHELL(6.2,2.8,0.4) translate<2.5,18,-0.2>  texture{CLEAN_STONE}}
  object{HALF_SHELL(6,2.4,0.4) translate<2.5,18,0>  texture{CLEAN_STONE}}
  object{HALF_CYLINDER(4.5,2) translate<2.5,18,1.5> }
  object{HALF_CYLINDER(1.5,3.5) translate<2.5,18,4.5> }

  box{<1.5,20,4>, <3.5,21.5,2> texture{CLEAN_STONE}}
  box{<1.4,22,4.1>, <3.6,21.6,1.9> texture{CLEAN_STONE}}
  box{<1.3,22.1,4.2>, <3.7,21.7,1.8> texture{CLEAN_STONE}}
  box{<1.2,22.2,4.3>, <3.8,21.8,1.7> texture{CLEAN_STONE}}
 }
}

#declare HALLWAY_LEVEL2 = object{
 union{
  #local i = 0;
  #while (i<6)
   object{PILLAR2 translate<3+i*3,4,0>}
   #local i = i + 1;
  #end
 }
}

#declare CENTER_LEVEL2 = object{
 union{
  #local i = 0;
  #while (i<6)
   #if ((i<2)|(i>3))
    #if (i<2)
     object{PILLAR2 translate<3+i*3-2,4,0>}
    #end
    #if (i>3)
     object{PILLAR2 translate<3+i*3+2,4,0>}
    #end
   #end
   #local i = i + 1;
  #end
 }
}

#declare BANK_DESIGN_LVL2 = object{
 union{                        
  object{PILLAR2 translate<-3,4,-5> }
  object{PILLAR2 translate<-3,4,0> }
  object{BASEBOX_LEVEL2(40,30) translate <-5,0,-8>}
  #local i=0;
  #while (i<13)
    #if (i<3)
     object{PILLAR2 rotate y*90 translate <-1+2.5*i,4,-7>}
    #end
    #if (i>3)
     object{PILLAR2a rotate y*90 translate <-1+2.5*i,0,-8>}
    #end
    #local i = i + 1;
  #end 
  object{LEVEL2_ROOF(35,35) translate <-5,15.2,-10>}
  difference{
   box{<0,0,-6>, <20,11.2,10>}
   box{<-2,2,-1>,<2,6,-3>}
   translate <0,4,0>
  }
  #local i = 0;
  #while (i<30)
   object{REEL_BASE translate <-0.5,0,-5-i*0.75>}
   #local i = i + 1;
  #end
  box{<-0.7,1.5,-4.5>, <-0.3,1.7,-30>}
  box{<-0.8,1.7,-4.5>, <-0.2,1.8,-30>}
  box{<-0.7,1.8,-4.5>, <0.3,2.0,-30>}
  box{<-0.8,2.0,-4.5>, <-0.2,2.1,-30>}
  object{BASEBOX_LEVEL2(5,5) translate <-3,0,-31.5>}
 }
}


#declare LEVEL_2 = object{
 union{
  object{LVL2_BASE texture{DRY_STONE} translate <-27,18.7,5>}
  object{TOWER_LVL2 texture{DRY_STONE translate 4} translate<-29.5, 18.7, 0>}
  object{TOWER_LVL2 texture{DRY_STONE translate 1} translate< -2.5, 18.7, 0>}
  object{TOWER_LVL2 texture{DRY_STONE translate -4} translate< 24.5, 18.7, 0>}
  object{TOWER_LVL2 texture{DRY_STONE translate 6} translate< 51.5, 18.7, 0>}
  object{TOWER_LVL2 texture{DRY_STONE translate 40} translate< 78.5, 18.7, 0>}
  object{TOWER_LVL2 texture{DRY_STONE translate -30} translate<105.5, 18.7, 0>}
  object{HALLWAY_LEVEL2 texture{DRY_STONE} translate<-24,18.7,7>}
  object{HALLWAY_LEVEL2 texture{DRY_STONE} translate<3,18.7,7>}
  object{CENTER_LEVEL2 texture{DRY_STONE} translate<30,18.7,7>}
  object{HALLWAY_LEVEL2 texture{DRY_STONE} translate<57,18.7,7>}
  object{HALLWAY_LEVEL2 texture{DRY_STONE} translate<84,18.7,7>}
  object{LEVEL2_ROOF(60,20) texture{DRY_STONE} translate <46,33.9,5>}
  object{LEVEL2_ROOF(60,20) texture{DRY_STONE} translate <-25,33.9,5>}
  object{BANK_DESIGN_LVL2 texture{DRY_STONE} translate <115,18.7,0>}
 }
}