//+sc0.000000 +sr0.217731 +ec0.998045 +er0.632334 angle 100
//+850 +h600

#include "colors.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"
#include "shapes.inc"

#declare cm = .01;
#include "units.inc"
                                                   
#declare R1 = seed(4456);
#declare PreTrace = 1;  //0 = compute radiosity only  1 = final render
#declare Rad_Quality = 5;  //use 3 for final

global_settings{ assumed_gamma 1
                 max_trace_level 100 
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.02
        count 50
        error_bound 0.5
        recursion_limit 3
        brightness 1
//        media on
        normal on 
        always_sample off
        save_file "Home2Rad1"
     #else 
        load_file "Home2Rad1"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008   //A=.01  B=.007
        count 200              //A=200  B=100
        error_bound 0.25       //A=.25  B=.15
        recursion_limit 3      //A=1    B=3
        brightness 1
//        media on
        normal on 
        always_sample off
        save_file "Home2Rad2"
     #else 
        load_file "Home2Rad2"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008
        count 400   
        error_bound 0.12
        recursion_limit 3  
        media on
        normal on
        always_sample off
        save_file "Home2Rad3"
     #else 
        load_file "Home2Rad3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #end

}
camera {
    angle 100
    location <15 * Feet, 2 * Feet, -12 * Feet> //low angle 80  0y
    look_at <0 * Feet, -9 * Feet, 0 * Feet>    //low angle


//    location <0 * Feet, 8 * Feet, -18 * Feet> //reg angle 70
//    look_at <0 * Feet, -5 * Feet, 0 * Feet>
  }

light_source {
  0*x                 // light's position (translated below)
  color rgb 2.0       // light's color
  area_light
  <100 * Feet, 0, 0> <0, 100 * Feet, 0> // lights spread out across this distance (x * z)
  5, 5                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 10          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <200 * Feet, 800 * Feet, -200 * Feet> 
}


light_source { < 0 * Feet,  -8 * Feet,   0 * Feet> color Gray30 shadowless} 

sky_sphere {
    pigment {
      gradient y
      color_map {
        [ 0.5  color CornflowerBlue ]
        [ 1.0  color MidnightBlue ]
      }
      scale 2
      translate -1
    }
  }

#declare HouseMaterial=  
material{  
            texture{T_Wood9 rotate <0,90,0> scale .4}
            texture {
                      pigment {
                                bozo scale .6         
                                color_map {
                                           [0.0 color rgbt <0.86, 0.58, 0.44, 0.5> ]  
                                           [0.3 color rgbt <0.59, 0.41, 0.31, 0.5> ]  
                                           [1.0 color rgbt <0.00, 0.00, 0.00, 0.5> ] 
                                          }
                              }
                     } scale .3
}

#declare Telescope=
merge{ 
    merge{
//Main Tube
       cylinder { <0 * Feet,  -3 * Feet, 0 * Feet>
                  <0 * Feet,   3 * Feet, 0 * Feet>
                   1 * Feet
                   open
                   pigment{White} 
                   finish {  
                             specular 0.8
                             roughness .0005
                             reflection 0.01
                          }
                }     
       cylinder { <0 * Feet,  -3 * Feet, 0 * Feet>
                  <0 * Feet,  -2.7 * Feet, 0 * Feet>
                   1.01 * Feet
                   open
                   texture{T_Chrome_5D}
                }     
       cylinder { <0 * Feet,  2.7 * Feet, 0 * Feet>
                  <0 * Feet,   3 * Feet, 0 * Feet>
                   1.01 * Feet
                   open
                   texture{T_Chrome_5D} 
               }     
//Guide Scope
       cylinder { <0 * Feet,  2 * Feet, -1 * Feet>
                  <0 * Feet,  3 * Feet, -1 * Feet>
                   .3 * Feet
                   open
                   pigment{Black}
                   finish {
                             specular 0.8
                             roughness .0005
                             reflection 0.01
                             metallic
                          }
                }     
       cylinder { <0 * Feet,  1.5 * Feet, -1 * Feet>
                  <0 * Feet,  2.1 * Feet, -1 * Feet>
                   .25 * Feet
                   open
                   pigment{Black}  //texture{T_Chrome_5D}
                }     
//Eyepiece
       cylinder { <-.8 * Feet,  2 * Feet, -1 * Feet>
                  <-1.3 * Feet,  2 * Feet, -1 * Feet>
                   .2 * Feet
                   pigment{Black} 
                   finish {
                             specular 0.8
                             roughness .0005
                             reflection 0.01
                          }
                }     
//Focus
       cylinder { <-.9 * Feet,  2 * Feet, -1.5 * Feet>
                  <-.9 * Feet,  2 * Feet, 0.5 * Feet>
                   .1 * Feet
                   texture{T_Chrome_5D}
                   finish {
                             specular 0.8
                             roughness .0005
                             reflection 0.01
                          }
                }
    translate<.5 * feet, 0, 0>     
    rotate<0,0,-30>
    }

//mount
  union{

    box{<-5 * Feet,-2 * Feet, -5 * Feet> , <5 * Feet,0 * Feet, 5 * Feet>
        rotate<0,20,0>
        material{ HouseMaterial }
       } 
             
    box{<-5 * Feet, 0 * Feet, -5 * Feet> , <5 * Feet, 1 * Feet, 5 * Feet>
        material{ HouseMaterial }
       }
   prism {                                
           linear_sweep  // or conic_sweep for tapering to a point
           linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
           -0.3,         // height 1
           -0.1,         // height 2
            4,           // number of points
            // (--- the <u,v> points ---)
           < -4 * Feet,-4 * Feet>, < -4 * Feet,4 * Feet>, < 7 * Feet,0 * Feet>, < -4 * Feet,-4 * Feet>
            material{ HouseMaterial }
            rotate<90,0,90>
            translate<0 * Feet,4 * Feet,-2 * Feet>
    }
   prism {                                
           linear_sweep  // or conic_sweep for tapering to a point
           linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
            1.3,         // height 1
            1.5,         // height 2
            4,           // number of points
            // (--- the <u,v> points ---)
           < -4 * Feet,-4 * Feet>, < -4 * Feet,4 * Feet>, < 7 * Feet,0 * Feet>, < -4 * Feet,-4 * Feet>
            material{ HouseMaterial }
            rotate<90,0,90>
            translate<0 * Feet,4 * Feet,-2 * Feet>
    }
    cylinder { <0 * Feet,  8 * Feet, -3.5 * Feet>
               <0 * Feet,  8 * Feet, 3.5 * Feet>
                .5 * Feet
            material{ HouseMaterial }
    }
                 
    scale .35
    translate<-.25 * Feet,-4*Feet, 0>
    } //end union mount
}


#object{Telescope
        rotate<0,-90,0>
        translate<-17 * Feet, -7.5 * Feet, -4 * Feet>
       }
           

#macro Gnomon (X1,Y1,Z1,X2,Y2,Z2)
  sphere_sweep {
    linear_spline                // alternative spline curves
    2,                            // number of specified sphere positions
    <  X1 * Feet, Y1 * Feet,   Z1 * Feet>, 1 * Feet //.5 dia               
    <  X2 * Feet, Y2 * Feet,   Z2 * Feet>, 1 * Feet                 
    tolerance 0.001             // optional
    pigment{ rgbf<1,1,1,0>}
       }
#end

#object {Gnomon( 0,0,0,  14.1, 14.1, 0) 
         translate<0 * Feet, 2 * Feet, 0 * Feet> //y = 3
         rotate<0,-90,0>
         }

#declare StairX = -13;
#declare StairZ = 13;

#macro MakeStair() 

  box{<-.25 * Feet, -25 * Feet, -.25 * Feet>,<.25 * Feet, -8 * Feet, .25 * Feet> 
      texture{T_Copper_2B}
      translate<StairX * Feet, 0 * Feet, StairZ * Feet>
      no_shadow
     }

  sphere{<0,0,0>, .8 * Feet
      texture{T_Chrome_5D}
      translate<StairX * Feet, -7.2 * Feet, StairZ * Feet> 
      no_shadow
  }      

#declare Step=
       box{<0 * Feet, 0 * Feet, -0.3 * Feet>,<2.5 * Feet, .1 * Feet, .3 * Feet> 
           texture{T_Copper_2B}
           no_shadow
          }

#declare Post= 
sphere_sweep {
              linear_spline                // alternative spline curves
              2,                            // number of specified sphere positions
              <  2.4 * Feet, 0 * Feet, 0 * Feet>, .1 * Feet                // position, radius
              <  2.4 * Feet, 4 * Feet, 0 * Feet>, .1 * Feet                 // ...
              tolerance 0.001             // optional
              texture{T_Copper_2B}
              no_shadow
             } 


   #local K = 6 / pi;
   #local Height = -12;
   #local Theta = 0;
   #local Theta1 = Theta * pi / 180;
   #local X = StairX + 2.5; 
   #local Z = StairZ + .5;     
   #while (Theta < 270)
       #local Theta1 = Theta * pi / 180;
       #local Y = Height - (K * Theta1);

       #object{Step                 
               rotate<0,Theta,0>
               translate<StairX * Feet, Y * Feet, StairZ * Feet>
               }
               
       #object{Post
               rotate<0,Theta,0>
               translate<StairX * Feet, Y * Feet, StairZ * Feet>
               }               

       #local Top = < 2.4 * Feet , 4 * Feet, 0 * Feet>;
       #local Top = vaxis_rotate(Top,<0,1,0>,Theta);
       #local Top = Top + <StairX * Feet, Y * Feet, StairZ * Feet>;
       #local Bottom = < 2.4 * Feet , 4 * Feet, 0 * Feet>;
       #local Bottom = vaxis_rotate(Bottom,<0,1,0>,Theta+15);
       #local Temp1 = (Theta+15) * pi / 180;
       #local Temp = Height - (K * Temp1);

       #local Bottom = Bottom + <StairX * Feet, Temp * Feet, StairZ * Feet>;

       sphere_sweep {
                      linear_spline                // alternative spline curves
                      2,                            // number of specified sphere positions
                      Top, .2 * Feet                // position, radius
                      Bottom, .2 * Feet                 // ...
                     tolerance 0.001             // optional
                     texture{T_Copper_2B}
                     no_shadow
                    } 
                          
       #local Theta = Theta + 15;
   #end 

#end //macro         

#include "House.inc"  

//earth globe 
sphere { <0 * Feet, 0 * Feet, 0 * Feet> 
          1 * Feet       
         texture{pigment {  image_map {
                                 jpeg "earth.jpg" 
                                 map_type 1   
                                 interpolate 2     
                                 once           
                               }  
                          }
                  }
          scale 11 * Feet
          rotate<-40,180,0>
          translate<0 * Feet, -16.5 * Feet, 0 * Feet>
}

//entrance rug
sphere_sweep {
              linear_spline                // alternative spline curves
              5,                            // number of specified sphere positions
              <  0.0 * Feet, 8 * Feet,   22.0 * Feet>, 2 * Feet                // position, radius
              <  0.0 * Feet, 15 * Feet,   26.0 * Feet>, 2 * Feet                 // ...
              <  5.0 * Feet, 23.0 * Feet,   28.0 * Feet>, 2 * Feet
              <  6.0 * Feet, 30.0 * Feet,   26.2 * Feet>, 2 * Feet
              <  10.0 * Feet, 30.0 * Feet,   26.2 * Feet>, 2 * Feet
              //<  25.0 * Feet, 23.0 * Feet,   20.2 * Feet>, 2 * Feet
              //< 29.0 * Feet, 25.0 * Feet,   0 * Feet>, 2 * Feet
              tolerance 0.001             // optional
              texture{pigment{Gray30}}
              normal{waves 5 scale .05}
              finish{phong .5 }
              scale <1,.5 * Feet, 1>
              translate<0, -13 * Feet, 0 * Feet>
             } 

MakeStair()             

 
#declare Sundial=
difference{      
          cylinder {<0 * Feet, 0 * Feet, 0 * Feet>, 
                    <0 * Feet, .5 * Feet, 0 * Feet>
                    14 * Feet
          }
          
          cylinder {<0 * Feet, -1 * Feet, 0 * Feet>, 
                    <0 * Feet, 1 * Feet, 0 * Feet>
                     11.9 * Feet
          }

//          box{<-20 * Feet, -1 * Feet, -20 * Feet>,<17 * Feet, 1 * Feet, -3 * Feet> 
//          }

          texture{T_Stone5}
          translate<0 * Feet, -12.1 * Feet, 0 * Feet>
} 

#object{Sundial}
#object{
        Circle_Text("timrom.ttf",        //font
                      "XII",             //string
                      1.5 * Feet,          //size
                      .1 * Feet,          //spacing
                      1 * Feet,          //Depth
                      12.5 * Feet,         //Radius
                      -1,                //Inverted
                      Align_Center,     //Justification
                      -270)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}

#object{
        Circle_Text("timrom.ttf",         //font
                      "VI",              //string  IV
                      1.5 * Feet,          //size
                      .1 * Feet,          //spacing
                      1 * Feet,          //Depth
                      12.5 * Feet,         //Radius
                      0,                //Inverted
                      Align_Center,      //Justification
                      180)               // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
} 

#object{
        Circle_Text("timrom.ttf",         //font
                      "IIIV",              //string VIII
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      0)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}
#object{
        Circle_Text("timrom.ttf",         //font
                      "XI",              //string   IX
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      22.5)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}

#object{
        Circle_Text("timrom.ttf",         //font
                      "X",              //string   X
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      45)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}
#object{
        Circle_Text("timrom.ttf",         //font
                      "IX",              //string   XI
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      67.5)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}
#object{
        Circle_Text("timrom.ttf",         //font
                      "I",              //string   I
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      112.5)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}

#object{
        Circle_Text("timrom.ttf",         //font
                      "II",              //string   II
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      135)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}
#object{
        Circle_Text("timrom.ttf",         //font
                      "III",              //string   III
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      157.5)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}

#object{
        Circle_Text("timrom.ttf",         //font
                      "V",              //string   V
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      202.5)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}
#object{
        Circle_Text("timrom.ttf",         //font
                      "IV",              //string   VI
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      225)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}

#object{
        Circle_Text("timrom.ttf",         //font
                      "IIV",              //string   VII
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      -22.5)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}

#object{
        Circle_Text("timrom.ttf",         //font
                      "IV",              //string   VI
                      1.5 * Feet,           //size
                      .1 * Feet,         //spacing
                      1 * Feet,           //Depth
                      12.5 * Feet,          //Radius
                      0,                 //Inverted
                      Align_Center,      //Justification
                      -45)                  // Angle

        texture{T_Brass_4C}
        finish { reflection .25 specular 1 }

        rotate<90,0,-180>                   
        translate<0 * Feet, -12.4 * Feet, 0 * Feet>
}
                                     
#object{House  
        rotate<0,0,0>  //y-55
        translate <0, -20 * Feet,0>
        }   


