// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio http://www.kurtz-fernhout.com

#declare New_plant_1 = union {
	union { // Internode
		cylinder { <0.0, 0.0, 0.0>, <-0.01557, 2.0226, 0.04714>, 0.1839 }
		cylinder { <-0.01557, 2.0226, 0.04714>, <-0.04671, 4.04338, 0.1414>, 0.1839 }
		cylinder { <-0.04671, 4.04338, 0.1414>, <-0.0934, 6.06111, 0.2827>, 0.1839 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // Internode
		cylinder { <-0.0934, 6.06111, 0.2827>, <0.04862, 9.5247, 0.399>, 0.3153 }
		cylinder { <0.04862, 9.5247, 0.399>, <0.4119, 12.9742, 0.3888>, 0.3153 }
		cylinder { <0.4119, 12.9742, 0.3888>, <0.9946, 16.3907, 0.2521>, 0.3153 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <0.9946, 16.3907, 0.2521>, <2.2475, 18.9817, -0.3124>, 0.1999 }
			cylinder { <2.2475, 18.9817, -0.3124>, <4.1342, 21.01333, -1.269>, 0.1999 }
			cylinder { <4.1342, 21.01333, -1.269>, <6.4643, 22.2803, -2.5211>, 0.1999 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <6.4643, 22.2803, -2.5211>, <7.1707, 22.6409, -2.902>, 0.1999 }
				cylinder { <7.1707, 22.6409, -2.902>, <7.8842, 22.9816, -3.2881>, 0.1999 }
				cylinder { <7.8842, 22.9816, -3.2881>, <8.6042, 23.3024, -3.679>, 0.1999 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <8.6042, 23.3024, -3.679>, <8.9125, 23.4735, -3.9886>, 0.03199 }
				cylinder { <8.9125, 23.4735, -3.9886>, <9.1228, 23.6321, -4.3768>, 0.03199 }
				cylinder { <9.1228, 23.6321, -4.3768>, <9.2199, 23.7669, -4.8157>, 0.03199 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <9.2199, 23.7669, -4.8157>, <3.8846, 26.6005, -0.9863>, <3.2401, 28.6147, -5.5906> }
				triangle { <9.2199, 23.7669, -4.8157>, <3.2401, 28.6147, -5.5906>, <3.8846, 26.6005, -0.9863> }
				triangle { <9.2199, 23.7669, -4.8157>, <3.2401, 28.6147, -5.5906>, <6.5252, 30.5568, -13.6754> }
				triangle { <9.2199, 23.7669, -4.8157>, <6.5252, 30.5568, -13.6754>, <3.2401, 28.6147, -5.5906> }
				triangle { <9.2199, 23.7669, -4.8157>, <6.5252, 30.5568, -13.6754>, <12.879, 29.7773, -17.5894> }
				triangle { <9.2199, 23.7669, -4.8157>, <12.879, 29.7773, -17.5894>, <6.5252, 30.5568, -13.6754> }
				triangle { <9.2199, 23.7669, -4.8157>, <12.879, 29.7773, -17.5894>, <17.556, 26.08847, -12.4192> }
				triangle { <9.2199, 23.7669, -4.8157>, <17.556, 26.08847, -12.4192>, <12.879, 29.7773, -17.5894> }
				triangle { <9.2199, 23.7669, -4.8157>, <17.556, 26.08847, -12.4192>, <17.2369, 23.02748, -4.2101> }
				triangle { <9.2199, 23.7669, -4.8157>, <17.2369, 23.02748, -4.2101>, <17.556, 26.08847, -12.4192> }
				triangle { <9.2199, 23.7669, -4.8157>, <17.2369, 23.02748, -4.2101>, <14.3373, 22.4931, -0.1236> }
				triangle { <9.2199, 23.7669, -4.8157>, <14.3373, 22.4931, -0.1236>, <17.2369, 23.02748, -4.2101> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <8.6042, 23.3024, -3.679>, <9.3304, 23.6031, -4.0746>, 0.1999 }
				cylinder { <9.3304, 23.6031, -4.0746>, <10.0623, 23.8833, -4.4745>, 0.1999 }
				cylinder { <10.0623, 23.8833, -4.4745>, <10.7994, 24.1431, -4.8787>, 0.1999 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <10.7994, 24.1431, -4.8787>, <11.24, 24.2704, -4.9777>, 0.03199 }
				cylinder { <11.24, 24.2704, -4.9777>, <11.6962, 24.3772, -4.9531>, 0.03199 }
				cylinder { <11.6962, 24.3772, -4.9531>, <12.135, 24.456, -4.8066>, 0.03199 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <12.135, 24.456, -4.8066>, <8.2049, 29.4348, -8.1116>, <12.7796, 31.5825, -7.7487> }
				triangle { <12.135, 24.456, -4.8066>, <12.7796, 31.5825, -7.7487>, <8.2049, 29.4348, -8.1116> }
				triangle { <12.135, 24.456, -4.8066>, <12.7796, 31.5825, -7.7487>, <20.8886, 31.8432, -3.9934> }
				triangle { <12.135, 24.456, -4.8066>, <20.8886, 31.8432, -3.9934>, <12.7796, 31.5825, -7.7487> }
				triangle { <12.135, 24.456, -4.8066>, <20.8886, 31.8432, -3.9934>, <24.8967, 28.1835, 1.1873> }
				triangle { <12.135, 24.456, -4.8066>, <24.8967, 28.1835, 1.1873>, <20.8886, 31.8432, -3.9934> }
				triangle { <12.135, 24.456, -4.8066>, <24.8967, 28.1835, 1.1873>, <19.8281, 22.6298, 3.5704> }
				triangle { <12.135, 24.456, -4.8066>, <19.8281, 22.6298, 3.5704>, <24.8967, 28.1835, 1.1873> }
				triangle { <12.135, 24.456, -4.8066>, <19.8281, 22.6298, 3.5704>, <11.6464, 19.9677, 1.8868> }
				triangle { <12.135, 24.456, -4.8066>, <11.6464, 19.9677, 1.8868>, <19.8281, 22.6298, 3.5704> }
				triangle { <12.135, 24.456, -4.8066>, <11.6464, 19.9677, 1.8868>, <7.5262, 20.8207, -0.886> }
				triangle { <12.135, 24.456, -4.8066>, <7.5262, 20.8207, -0.886>, <11.6464, 19.9677, 1.8868> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <10.7994, 24.1431, -4.8787>, <11.1925, 24.2816, -5.09421>, 0.03199 }
				cylinder { <11.1925, 24.2816, -5.09421>, <11.5856, 24.4201, -5.3097>, 0.03199 }
				cylinder { <11.5856, 24.4201, -5.3097>, <11.9787, 24.5586, -5.5252>, 0.03199 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <11.9787, 24.5586, -5.5252>, <5.9439, 28.3961, -5.6375>, <8.9821, 30.8688, -8.8511> }
				triangle { <11.9787, 24.5586, -5.5252>, <8.9821, 30.8688, -8.8511>, <5.9439, 28.3961, -5.6375> }
				triangle { <11.9787, 24.5586, -5.5252>, <8.9821, 30.8688, -8.8511>, <17.2019, 32.5031, -11.9643> }
				triangle { <11.9787, 24.5586, -5.5252>, <17.2019, 32.5031, -11.9643>, <8.9821, 30.8688, -8.8511> }
				triangle { <11.9787, 24.5586, -5.5252>, <17.2019, 32.5031, -11.9643>, <24.2925, 30.3745, -10.7433> }
				triangle { <11.9787, 24.5586, -5.5252>, <24.2925, 30.3745, -10.7433>, <17.2019, 32.5031, -11.9643> }
				triangle { <11.9787, 24.5586, -5.5252>, <24.2925, 30.3745, -10.7433>, <23.4629, 25.1748, -4.8707> }
				triangle { <11.9787, 24.5586, -5.5252>, <23.4629, 25.1748, -4.8707>, <24.2925, 30.3745, -10.7433> }
				triangle { <11.9787, 24.5586, -5.5252>, <23.4629, 25.1748, -4.8707>, <17.08699, 21.6663, 0.01793> }
				triangle { <11.9787, 24.5586, -5.5252>, <17.08699, 21.6663, 0.01793>, <23.4629, 25.1748, -4.8707> }
				triangle { <11.9787, 24.5586, -5.5252>, <17.08699, 21.6663, 0.01793>, <12.1228, 21.5997, 0.8818> }
				triangle { <11.9787, 24.5586, -5.5252>, <12.1228, 21.5997, 0.8818>, <17.08699, 21.6663, 0.01793> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <0.9946, 16.3907, 0.2521>, <3.134, 21.3628, -0.6808>, 0.4993 }
		cylinder { <3.134, 21.3628, -0.6808>, <6.3352, 25.5365, -2.2625>, 0.4993 }
		cylinder { <6.3352, 25.5365, -2.2625>, <10.3662, 28.6094, -4.3784>, 0.4993 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <10.3662, 28.6094, -4.3784>, <16.3291, 30.5306, -7.6576>, 0.4821 }
			cylinder { <16.3291, 30.5306, -7.6576>, <22.4634, 30.2229, -11.1611>, 0.4821 }
			cylinder { <22.4634, 30.2229, -11.1611>, <28.1501, 27.7176, -14.5353>, 0.4821 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <28.1501, 27.7176, -14.5353>, <29.8383, 26.9176, -15.5402>, 0.4821 }
				cylinder { <29.8383, 26.9176, -15.5402>, <31.5078, 26.06974, -16.5371>, 0.4821 }
				cylinder { <31.5078, 26.06974, -16.5371>, <33.1574, 25.1744, -17.5255>, 0.4821 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <33.1574, 25.1744, -17.5255>, <34.8426, 24.101, -19.3819>, 0.1859 }
				cylinder { <34.8426, 24.101, -19.3819>, <35.9698, 23.183, -21.6894>, 0.1859 }
				cylinder { <35.9698, 23.183, -21.6894>, <36.4576, 22.4869, -24.2808>, 0.1859 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <36.4576, 22.4869, -24.2808>, <32.4191, 38.5662, -19.5371>, <32.3733, 39.08799, -31.7413> }
				triangle { <36.4576, 22.4869, -24.2808>, <32.3733, 39.08799, -31.7413>, <32.4191, 38.5662, -19.5371> }
				triangle { <36.4576, 22.4869, -24.2808>, <32.3733, 39.08799, -31.7413>, <38.0521, 30.5726, -50.7101> }
				triangle { <36.4576, 22.4869, -24.2808>, <38.0521, 30.5726, -50.7101>, <32.3733, 39.08799, -31.7413> }
				triangle { <36.4576, 22.4869, -24.2808>, <38.0521, 30.5726, -50.7101>, <47.01233, 16.2786, -57.2396> }
				triangle { <36.4576, 22.4869, -24.2808>, <47.01233, 16.2786, -57.2396>, <38.0521, 30.5726, -50.7101> }
				triangle { <36.4576, 22.4869, -24.2808>, <47.01233, 16.2786, -57.2396>, <52.2182, 7.2514, -41.3328> }
				triangle { <36.4576, 22.4869, -24.2808>, <52.2182, 7.2514, -41.3328>, <47.01233, 16.2786, -57.2396> }
				triangle { <36.4576, 22.4869, -24.2808>, <52.2182, 7.2514, -41.3328>, <50.3853, 9.4566, -20.3917> }
				triangle { <36.4576, 22.4869, -24.2808>, <50.3853, 9.4566, -20.3917>, <52.2182, 7.2514, -41.3328> }
				triangle { <36.4576, 22.4869, -24.2808>, <50.3853, 9.4566, -20.3917>, <45.8992, 16.4067, -11.4939> }
				triangle { <36.4576, 22.4869, -24.2808>, <45.8992, 16.4067, -11.4939>, <50.3853, 9.4566, -20.3917> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <33.1574, 25.1744, -17.5255>, <34.7863, 24.2323, -18.5048>, 0.4821 }
				cylinder { <34.7863, 24.2323, -18.5048>, <36.3935, 23.2438, -19.4744>, 0.4821 }
				cylinder { <36.3935, 23.2438, -19.4744>, <37.9779, 22.2097, -20.4336>, 0.4821 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <37.9779, 22.2097, -20.4336>, <40.3001, 20.8924, -20.9905>, 0.1859 }
				cylinder { <40.3001, 20.8924, -20.9905>, <42.7392, 19.6827, -20.8308>, 0.1859 }
				cylinder { <42.7392, 19.6827, -20.8308>, <45.1185, 18.6684, -19.9659>, 0.1859 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <45.1185, 18.6684, -19.9659>, <43.9819, 30.2435, -32.6971>, <55.7857, 27.09912, -32.7358> }
				triangle { <45.1185, 18.6684, -19.9659>, <55.7857, 27.09912, -32.7358>, <43.9819, 30.2435, -32.6971> }
				triangle { <45.1185, 18.6684, -19.9659>, <55.7857, 27.09912, -32.7358>, <72.6632, 18.2049, -22.705> }
				triangle { <45.1185, 18.6684, -19.9659>, <72.6632, 18.2049, -22.705>, <55.7857, 27.09912, -32.7358> }
				triangle { <45.1185, 18.6684, -19.9659>, <72.6632, 18.2049, -22.705>, <76.6832, 10.2614, -6.9577> }
				triangle { <45.1185, 18.6684, -19.9659>, <76.6832, 10.2614, -6.9577>, <72.6632, 18.2049, -22.705> }
				triangle { <45.1185, 18.6684, -19.9659>, <76.6832, 10.2614, -6.9577>, <59.9838, 10.7734, 2.1243> }
				triangle { <45.1185, 18.6684, -19.9659>, <59.9838, 10.7734, 2.1243>, <76.6832, 10.2614, -6.9577> }
				triangle { <45.1185, 18.6684, -19.9659>, <59.9838, 10.7734, 2.1243>, <40.2181, 17.5009, -1.1638> }
				triangle { <45.1185, 18.6684, -19.9659>, <40.2181, 17.5009, -1.1638>, <59.9838, 10.7734, 2.1243> }
				triangle { <45.1185, 18.6684, -19.9659>, <40.2181, 17.5009, -1.1638>, <32.7668, 22.9429, -9.06719> }
				triangle { <45.1185, 18.6684, -19.9659>, <32.7668, 22.9429, -9.06719>, <40.2181, 17.5009, -1.1638> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <37.9779, 22.2097, -20.4336>, <40.01496, 20.8802, -21.6668>, 0.1859 }
				cylinder { <40.01496, 20.8802, -21.6668>, <42.05196, 19.5506, -22.9>, 0.1859 }
				cylinder { <42.05196, 19.5506, -22.9>, <44.08897, 18.2211, -24.1333>, 0.1859 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <44.08897, 18.2211, -24.1333>, <38.6596, 33.7749, -29.2282>, <46.6602, 30.5621, -37.8819> }
				triangle { <44.08897, 18.2211, -24.1333>, <46.6602, 30.5621, -37.8819>, <38.6596, 33.7749, -29.2282> }
				triangle { <44.08897, 18.2211, -24.1333>, <46.6602, 30.5621, -37.8819>, <63.00429, 18.08648, -44.3477> }
				triangle { <44.08897, 18.2211, -24.1333>, <63.00429, 18.08648, -44.3477>, <46.6602, 30.5621, -37.8819> }
				triangle { <44.08897, 18.2211, -24.1333>, <63.00429, 18.08648, -44.3477>, <73.3925, 4.6762, -38.06392> }
				triangle { <44.08897, 18.2211, -24.1333>, <73.3925, 4.6762, -38.06392>, <63.00429, 18.08648, -44.3477> }
				triangle { <44.08897, 18.2211, -24.1333>, <73.3925, 4.6762, -38.06392>, <66.4632, 2.1672, -20.5338> }
				triangle { <44.08897, 18.2211, -24.1333>, <66.4632, 2.1672, -20.5338>, <73.3925, 4.6762, -38.06392> }
				triangle { <44.08897, 18.2211, -24.1333>, <66.4632, 2.1672, -20.5338>, <51.4355, 10.1673, -8.006921> }
				triangle { <44.08897, 18.2211, -24.1333>, <51.4355, 10.1673, -8.006921>, <66.4632, 2.1672, -20.5338> }
				triangle { <44.08897, 18.2211, -24.1333>, <51.4355, 10.1673, -8.006921>, <42.5302, 18.3906, -7.1875> }
				triangle { <44.08897, 18.2211, -24.1333>, <42.5302, 18.3906, -7.1875>, <51.4355, 10.1673, -8.006921> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <10.3662, 28.6094, -4.3784>, <12.1038, 29.1692, -5.3339>, 0.2809 }
			cylinder { <12.1038, 29.1692, -5.3339>, <13.8913, 29.07965, -6.3548>, 0.2809 }
			cylinder { <13.8913, 29.07965, -6.3548>, <15.5483, 28.3496, -7.338>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <15.5483, 28.3496, -7.338>, <17.2054, 27.6195, -8.3212>, 0.2809 }
			cylinder { <17.2054, 27.6195, -8.3212>, <18.8624, 26.8895, -9.3044>, 0.2809 }
			cylinder { <18.8624, 26.8895, -9.3044>, <20.5195, 26.1594, -10.2876>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <20.5195, 26.1594, -10.2876>, <23.484, 25.8726, -13.1356>, 0.2809 }
				cylinder { <23.484, 25.8726, -13.1356>, <25.7017, 26.7974, -16.4835>, 0.2809 }
				cylinder { <25.7017, 26.7974, -16.4835>, <26.8754, 28.8099, -19.8827>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <28.6802, 29.6287, -24.3757>, <27.2761, 32.491, -23.1659>, <26.8754, 28.8099, -19.8827> }
					triangle { <28.6802, 29.6287, -24.3757>, <26.8754, 28.8099, -19.8827>, <27.2761, 32.491, -23.1659> }
					triangle { <26.2303, 33.4054, -26.8529>, <23.5703, 34.3605, -24.1386>, <27.2761, 32.491, -23.1659> }
					triangle { <26.2303, 33.4054, -26.8529>, <27.2761, 32.491, -23.1659>, <23.5703, 34.3605, -24.1386> }
					triangle { <27.2761, 32.491, -23.1659>, <28.1963, 31.05755, -27.6975>, <26.2303, 33.4054, -26.8529> }
					triangle { <27.2761, 32.491, -23.1659>, <26.2303, 33.4054, -26.8529>, <28.1963, 31.05755, -27.6975> }
					triangle { <28.6802, 29.6287, -24.3757>, <28.1963, 31.05755, -27.6975>, <27.2761, 32.491, -23.1659> }
					triangle { <28.6802, 29.6287, -24.3757>, <27.2761, 32.491, -23.1659>, <28.1963, 31.05755, -27.6975> }
					triangle { <27.7384, 26.5098, -27.08097>, <28.1963, 31.05755, -27.6975>, <28.6802, 29.6287, -24.3757> }
					triangle { <27.7384, 26.5098, -27.08097>, <28.6802, 29.6287, -24.3757>, <28.1963, 31.05755, -27.6975> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <26.9023, 30.4168, -24.523>, <29.2648, 32.08719, -22.7183>, <26.8754, 28.8099, -19.8827> }
					triangle { <26.9023, 30.4168, -24.523>, <26.8754, 28.8099, -19.8827>, <29.2648, 32.08719, -22.7183> }
					triangle { <28.5667, 35.2594, -24.9485>, <29.2445, 36.06035, -21.1731>, <29.2648, 32.08719, -22.7183> }
					triangle { <28.5667, 35.2594, -24.9485>, <29.2648, 32.08719, -22.7183>, <29.2445, 36.06035, -21.1731> }
					triangle { <29.2648, 32.08719, -22.7183>, <26.9743, 33.2483, -26.8224>, <28.5667, 35.2594, -24.9485> }
					triangle { <29.2648, 32.08719, -22.7183>, <28.5667, 35.2594, -24.9485>, <26.9743, 33.2483, -26.8224> }
					triangle { <26.9023, 30.4168, -24.523>, <26.9743, 33.2483, -26.8224>, <29.2648, 32.08719, -22.7183> }
					triangle { <26.9023, 30.4168, -24.523>, <29.2648, 32.08719, -22.7183>, <26.9743, 33.2483, -26.8224> }
					triangle { <22.9957, 31.05508, -26.02743>, <26.9743, 33.2483, -26.8224>, <26.9023, 30.4168, -24.523> }
					triangle { <22.9957, 31.05508, -26.02743>, <26.9023, 30.4168, -24.523>, <26.9743, 33.2483, -26.8224> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <26.8937, 32.09627, -23.5316>, <29.7799, 30.2818, -23.6093>, <26.8754, 28.8099, -19.8827> }
					triangle { <26.8937, 32.09627, -23.5316>, <26.8754, 28.8099, -19.8827>, <29.7799, 30.2818, -23.6093> }
					triangle { <31.6348, 33.496, -24.9332>, <33.7309, 31.3473, -22.4144>, <29.7799, 30.2818, -23.6093> }
					triangle { <31.6348, 33.496, -24.9332>, <29.7799, 30.2818, -23.6093>, <33.7309, 31.3473, -22.4144> }
					triangle { <29.7799, 30.2818, -23.6093>, <28.7127, 34.6559, -25.3887>, <31.6348, 33.496, -24.9332> }
					triangle { <29.7799, 30.2818, -23.6093>, <31.6348, 33.496, -24.9332>, <28.7127, 34.6559, -25.3887> }
					triangle { <26.8937, 32.09627, -23.5316>, <28.7127, 34.6559, -25.3887>, <29.7799, 30.2818, -23.6093> }
					triangle { <26.8937, 32.09627, -23.5316>, <29.7799, 30.2818, -23.6093>, <28.7127, 34.6559, -25.3887> }
					triangle { <25.5565, 35.9105, -22.2684>, <28.7127, 34.6559, -25.3887>, <26.8937, 32.09627, -23.5316> }
					triangle { <25.5565, 35.9105, -22.2684>, <26.8937, 32.09627, -23.5316>, <28.7127, 34.6559, -25.3887> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <28.666, 32.3617, -22.7625>, <28.1143, 29.5531, -24.6159>, <26.8754, 28.8099, -19.8827> }
					triangle { <28.666, 32.3617, -22.7625>, <26.8754, 28.8099, -19.8827>, <28.1143, 29.5531, -24.6159> }
					triangle { <31.2232, 30.5357, -26.828>, <30.8713, 26.6908, -26.1587>, <28.1143, 29.5531, -24.6159> }
					triangle { <31.2232, 30.5357, -26.828>, <28.1143, 29.5531, -24.6159>, <30.8713, 26.6908, -26.1587> }
					triangle { <28.1143, 29.5531, -24.6159>, <31.02539, 33.3482, -25.3645>, <31.2232, 30.5357, -26.828> }
					triangle { <28.1143, 29.5531, -24.6159>, <31.2232, 30.5357, -26.828>, <31.02539, 33.3482, -25.3645> }
					triangle { <28.666, 32.3617, -22.7625>, <31.02539, 33.3482, -25.3645>, <28.1143, 29.5531, -24.6159> }
					triangle { <28.666, 32.3617, -22.7625>, <28.1143, 29.5531, -24.6159>, <31.02539, 33.3482, -25.3645> }
					triangle { <31.9058, 34.4114, -20.9638>, <31.02539, 33.3482, -25.3645>, <28.666, 32.3617, -22.7625> }
					triangle { <31.9058, 34.4114, -20.9638>, <28.666, 32.3617, -22.7625>, <31.02539, 33.3482, -25.3645> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <29.7868, 30.8137, -23.292>, <26.5435, 30.939, -24.3377>, <26.8754, 28.8099, -19.8827> }
					triangle { <29.7868, 30.8137, -23.292>, <26.8754, 28.8099, -19.8827>, <26.5435, 30.939, -24.3377> }
					triangle { <27.8326, 30.4789, -28.03243>, <24.4969, 28.5812, -27.2405>, <26.5435, 30.939, -24.3377> }
					triangle { <27.8326, 30.4789, -28.03243>, <26.5435, 30.939, -24.3377>, <24.4969, 28.5812, -27.2405> }
					triangle { <26.5435, 30.939, -24.3377>, <30.7014, 31.09075, -26.8129>, <27.8326, 30.4789, -28.03243> }
					triangle { <26.5435, 30.939, -24.3377>, <27.8326, 30.4789, -28.03243>, <30.7014, 31.09075, -26.8129> }
					triangle { <29.7868, 30.8137, -23.292>, <30.7014, 31.09075, -26.8129>, <26.5435, 30.939, -24.3377> }
					triangle { <29.7868, 30.8137, -23.292>, <26.5435, 30.939, -24.3377>, <30.7014, 31.09075, -26.8129> }
					triangle { <33.2746, 28.5137, -23.9829>, <30.7014, 31.09075, -26.8129>, <29.7868, 30.8137, -23.292> }
					triangle { <33.2746, 28.5137, -23.9829>, <29.7868, 30.8137, -23.292>, <30.7014, 31.09075, -26.8129> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <20.5195, 26.1594, -10.2876>, <22.1765, 25.4294, -11.2708>, 0.2809 }
			cylinder { <22.1765, 25.4294, -11.2708>, <23.8336, 24.6993, -12.254>, 0.2809 }
			cylinder { <23.8336, 24.6993, -12.254>, <25.4906, 23.9693, -13.2372>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <25.4906, 23.9693, -13.2372>, <29.2629, 22.3984, -13.7706>, 0.2809 }
				cylinder { <29.2629, 22.3984, -13.7706>, <32.9877, 20.9272, -12.7994>, 0.2809 }
				cylinder { <32.9877, 20.9272, -12.7994>, <36.1659, 19.7528, -10.4538>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <40.7879, 18.9556, -8.9989>, <38.6484, 18.3095, -6.4234>, <36.1659, 19.7528, -10.4538> }
					triangle { <40.7879, 18.9556, -8.9989>, <36.1659, 19.7528, -10.4538>, <38.6484, 18.3095, -6.4234> }
					triangle { <41.4257, 19.5918, -3.9402>, <37.7746, 20.5977, -2.9342>, <38.6484, 18.3095, -6.4234> }
					triangle { <41.4257, 19.5918, -3.9402>, <38.6484, 18.3095, -6.4234>, <37.7746, 20.5977, -2.9342> }
					triangle { <38.6484, 18.3095, -6.4234>, <43.3603, 19.4205, -6.454>, <41.4257, 19.5918, -3.9402> }
					triangle { <38.6484, 18.3095, -6.4234>, <41.4257, 19.5918, -3.9402>, <43.3603, 19.4205, -6.454> }
					triangle { <40.7879, 18.9556, -8.9989>, <43.3603, 19.4205, -6.454>, <38.6484, 18.3095, -6.4234> }
					triangle { <40.7879, 18.9556, -8.9989>, <38.6484, 18.3095, -6.4234>, <43.3603, 19.4205, -6.454> }
					triangle { <43.424, 22.01861, -10.2642>, <43.3603, 19.4205, -6.454>, <40.7879, 18.9556, -8.9989> }
					triangle { <43.424, 22.01861, -10.2642>, <40.7879, 18.9556, -8.9989>, <43.3603, 19.4205, -6.454> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <40.09839, 20.03172, -7.5258>, <39.07956, 16.7866, -7.77>, <36.1659, 19.7528, -10.4538> }
					triangle { <40.09839, 20.03172, -7.5258>, <36.1659, 19.7528, -10.4538>, <39.07956, 16.7866, -7.77> }
					triangle { <40.2743, 16.2475, -4.05436>, <36.9739, 14.3479, -4.9784>, <39.07956, 16.7866, -7.77> }
					triangle { <40.2743, 16.2475, -4.05436>, <39.07956, 16.7866, -7.77>, <36.9739, 14.3479, -4.9784> }
					triangle { <39.07956, 16.7866, -7.77>, <41.7121, 19.05878, -4.4018>, <40.2743, 16.2475, -4.05436> }
					triangle { <39.07956, 16.7866, -7.77>, <40.2743, 16.2475, -4.05436>, <41.7121, 19.05878, -4.4018> }
					triangle { <40.09839, 20.03172, -7.5258>, <41.7121, 19.05878, -4.4018>, <39.07956, 16.7866, -7.77> }
					triangle { <40.09839, 20.03172, -7.5258>, <39.07956, 16.7866, -7.77>, <41.7121, 19.05878, -4.4018> }
					triangle { <39.8451, 23.2578, -4.7944>, <41.7121, 19.05878, -4.4018>, <40.09839, 20.03172, -7.5258> }
					triangle { <39.8451, 23.2578, -4.7944>, <40.09839, 20.03172, -7.5258>, <41.7121, 19.05878, -4.4018> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <38.9019, 18.9178, -6.4622>, <40.4022, 17.5281, -9.1909>, <36.1659, 19.7528, -10.4538> }
					triangle { <38.9019, 18.9178, -6.4622>, <36.1659, 19.7528, -10.4538>, <40.4022, 17.5281, -9.1909> }
					triangle { <41.7514, 14.6597, -6.8508>, <40.6537, 13.4517, -10.4131>, <40.4022, 17.5281, -9.1909> }
					triangle { <41.7514, 14.6597, -6.8508>, <40.4022, 17.5281, -9.1909>, <40.6537, 13.4517, -10.4131> }
					triangle { <40.4022, 17.5281, -9.1909>, <40.8353, 16.5517, -4.469>, <41.7514, 14.6597, -6.8508> }
					triangle { <40.4022, 17.5281, -9.1909>, <41.7514, 14.6597, -6.8508>, <40.8353, 16.5517, -4.469> }
					triangle { <38.9019, 18.9178, -6.4622>, <40.8353, 16.5517, -4.469>, <40.4022, 17.5281, -9.1909> }
					triangle { <38.9019, 18.9178, -6.4622>, <40.4022, 17.5281, -9.1909>, <40.8353, 16.5517, -4.469> }
					triangle { <36.5726, 17.7066, -3.1396>, <40.8353, 16.5517, -4.469>, <38.9019, 18.9178, -6.4622> }
					triangle { <36.5726, 17.7066, -3.1396>, <38.9019, 18.9178, -6.4622>, <40.8353, 16.5517, -4.469> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <38.8408, 17.1429, -7.2681>, <40.8008, 19.5161, -8.7358>, <36.1659, 19.7528, -10.4538> }
					triangle { <38.8408, 17.1429, -7.2681>, <36.1659, 19.7528, -10.4538>, <40.8008, 19.5161, -8.7358> }
					triangle { <43.8296, 17.00795, -8.491>, <43.7629, 19.1393, -11.7785>, <40.8008, 19.5161, -8.7358> }
					triangle { <43.8296, 17.00795, -8.491>, <40.8008, 19.5161, -8.7358>, <43.7629, 19.1393, -11.7785> }
					triangle { <40.8008, 19.5161, -8.7358>, <41.9335, 15.3405, -6.5633>, <43.8296, 17.00795, -8.491> }
					triangle { <40.8008, 19.5161, -8.7358>, <43.8296, 17.00795, -8.491>, <41.9335, 15.3405, -6.5633> }
					triangle { <38.8408, 17.1429, -7.2681>, <41.9335, 15.3405, -6.5633>, <40.8008, 19.5161, -8.7358> }
					triangle { <38.8408, 17.1429, -7.2681>, <40.8008, 19.5161, -8.7358>, <41.9335, 15.3405, -6.5633> }
					triangle { <38.09858, 12.9848, -7.5712>, <41.9335, 15.3405, -6.5633>, <38.8408, 17.1429, -7.2681> }
					triangle { <38.09858, 12.9848, -7.5712>, <38.8408, 17.1429, -7.2681>, <41.9335, 15.3405, -6.5633> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <40.02403, 17.1666, -8.8595>, <39.7006, 20.00635, -6.9995>, <36.1659, 19.7528, -10.4538> }
					triangle { <40.02403, 17.1666, -8.8595>, <36.1659, 19.7528, -10.4538>, <39.7006, 20.00635, -6.9995> }
					triangle { <43.6253, 20.1021, -6.665>, <41.9567, 23.6225, -7.08651>, <39.7006, 20.00635, -6.9995> }
					triangle { <43.6253, 20.1021, -6.665>, <39.7006, 20.00635, -6.9995>, <41.9567, 23.6225, -7.08651> }
					triangle { <39.7006, 20.00635, -6.9995>, <43.5175, 17.1403, -7.8086>, <43.6253, 20.1021, -6.665> }
					triangle { <39.7006, 20.00635, -6.9995>, <43.6253, 20.1021, -6.665>, <43.5175, 17.1403, -7.8086> }
					triangle { <40.02403, 17.1666, -8.8595>, <43.5175, 17.1403, -7.8086>, <39.7006, 20.00635, -6.9995> }
					triangle { <40.02403, 17.1666, -8.8595>, <39.7006, 20.00635, -6.9995>, <43.5175, 17.1403, -7.8086> }
					triangle { <42.3968, 15.69, -12.04095>, <43.5175, 17.1403, -7.8086>, <40.02403, 17.1666, -8.8595> }
					triangle { <42.3968, 15.69, -12.04095>, <40.02403, 17.1666, -8.8595>, <43.5175, 17.1403, -7.8086> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <25.4906, 23.9693, -13.2372>, <27.1477, 23.2393, -14.2204>, 0.2809 }
			cylinder { <27.1477, 23.2393, -14.2204>, <28.8048, 22.5092, -15.2036>, 0.2809 }
			cylinder { <28.8048, 22.5092, -15.2036>, <30.4618, 21.7792, -16.1868>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <30.4618, 21.7792, -16.1868>, <32.6734, 19.6508, -18.9365>, 0.2809 }
				cylinder { <32.6734, 19.6508, -18.9365>, <33.486, 17.1393, -22.101>, 0.2809 }
				cylinder { <33.486, 17.1393, -22.101>, <32.7908, 14.5813, -25.2562>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <33.3922, 10.8662, -28.4109>, <30.3484, 12.3178, -28.9171>, <32.7908, 14.5813, -25.2562> }
					triangle { <33.3922, 10.8662, -28.4109>, <32.7908, 14.5813, -25.2562>, <30.3484, 12.3178, -28.9171> }
					triangle { <28.9427, 8.7699, -29.8973>, <26.4487, 10.9785, -27.834>, <30.3484, 12.3178, -28.9171> }
					triangle { <28.9427, 8.7699, -29.8973>, <30.3484, 12.3178, -28.9171>, <26.4487, 10.9785, -27.834> }
					triangle { <30.3484, 12.3178, -28.9171>, <31.9953, 7.8975, -30.00636>, <28.9427, 8.7699, -29.8973> }
					triangle { <30.3484, 12.3178, -28.9171>, <28.9427, 8.7699, -29.8973>, <31.9953, 7.8975, -30.00636> }
					triangle { <33.3922, 10.8662, -28.4109>, <31.9953, 7.8975, -30.00636>, <30.3484, 12.3178, -28.9171> }
					triangle { <33.3922, 10.8662, -28.4109>, <30.3484, 12.3178, -28.9171>, <31.9953, 7.8975, -30.00636> }
					triangle { <35.01576, 7.4246, -26.553>, <31.9953, 7.8975, -30.00636>, <33.3922, 10.8662, -28.4109> }
					triangle { <35.01576, 7.4246, -26.553>, <33.3922, 10.8662, -28.4109>, <31.9953, 7.8975, -30.00636> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <31.603, 10.5051, -27.7239>, <32.00195, 13.09227, -29.9092>, <32.7908, 14.5813, -25.2562> }
					triangle { <31.603, 10.5051, -27.7239>, <32.7908, 14.5813, -25.2562>, <32.00195, 13.09227, -29.9092> }
					triangle { <29.1901, 11.4852, -32.1532>, <29.09022, 15.3995, -32.00032>, <32.00195, 13.09227, -29.9092> }
					triangle { <29.1901, 11.4852, -32.1532>, <32.00195, 13.09227, -29.9092>, <29.09022, 15.3995, -32.00032> }
					triangle { <32.00195, 13.09227, -29.9092>, <29.5649, 8.928, -30.3062>, <29.1901, 11.4852, -32.1532> }
					triangle { <32.00195, 13.09227, -29.9092>, <29.1901, 11.4852, -32.1532>, <29.5649, 8.928, -30.3062> }
					triangle { <31.603, 10.5051, -27.7239>, <29.5649, 8.928, -30.3062>, <32.00195, 13.09227, -29.9092> }
					triangle { <31.603, 10.5051, -27.7239>, <32.00195, 13.09227, -29.9092>, <29.5649, 8.928, -30.3062> }
					triangle { <28.4642, 8.3554, -25.8641>, <29.5649, 8.928, -30.3062>, <31.603, 10.5051, -27.7239> }
					triangle { <28.4642, 8.3554, -25.8641>, <31.603, 10.5051, -27.7239>, <29.5649, 8.928, -30.3062> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <30.3744, 11.8026, -28.5051>, <33.6684, 11.9741, -29.3699>, <32.7908, 14.5813, -25.2562> }
					triangle { <30.3744, 11.8026, -28.5051>, <32.7908, 14.5813, -25.2562>, <33.6684, 11.9741, -29.3699> }
					triangle { <32.5714, 11.7957, -33.15>, <35.5885, 14.1986, -32.4585>, <33.6684, 11.9741, -29.3699> }
					triangle { <32.5714, 11.7957, -33.15>, <33.6684, 11.9741, -29.3699>, <35.5885, 14.1986, -32.4585> }
					triangle { <33.6684, 11.9741, -29.3699>, <29.7284, 10.9701, -31.9979>, <32.5714, 11.7957, -33.15> }
					triangle { <33.6684, 11.9741, -29.3699>, <32.5714, 11.7957, -33.15>, <29.7284, 10.9701, -31.9979> }
					triangle { <30.3744, 11.8026, -28.5051>, <29.7284, 10.9701, -31.9979>, <33.6684, 11.9741, -29.3699> }
					triangle { <30.3744, 11.8026, -28.5051>, <33.6684, 11.9741, -29.3699>, <29.7284, 10.9701, -31.9979> }
					triangle { <26.6798, 13.5207, -29.6586>, <29.7284, 10.9701, -31.9979>, <30.3744, 11.8026, -28.5051> }
					triangle { <26.6798, 13.5207, -29.6586>, <30.3744, 11.8026, -28.5051>, <29.7284, 10.9701, -31.9979> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <31.3927, 12.9777, -29.6822>, <33.06042, 10.4982, -28.03943>, <32.7908, 14.5813, -25.2562> }
					triangle { <31.3927, 12.9777, -29.6822>, <32.7908, 14.5813, -25.2562>, <33.06042, 10.4982, -28.03943> }
					triangle { <34.4453, 9.2752, -31.5194>, <37.02393, 9.02413, -28.5796>, <33.06042, 10.4982, -28.03943> }
					triangle { <34.4453, 9.2752, -31.5194>, <33.06042, 10.4982, -28.03943>, <37.02393, 9.02413, -28.5796> }
					triangle { <33.06042, 10.4982, -28.03943>, <32.2614, 11.2208, -32.7593>, <34.4453, 9.2752, -31.5194> }
					triangle { <33.06042, 10.4982, -28.03943>, <34.4453, 9.2752, -31.5194>, <32.2614, 11.2208, -32.7593> }
					triangle { <31.3927, 12.9777, -29.6822>, <32.2614, 11.2208, -32.7593>, <33.06042, 10.4982, -28.03943> }
					triangle { <31.3927, 12.9777, -29.6822>, <33.06042, 10.4982, -28.03943>, <32.2614, 11.2208, -32.7593> }
					triangle { <32.1117, 15.8304, -32.728>, <32.2614, 11.2208, -32.7593>, <31.3927, 12.9777, -29.6822> }
					triangle { <32.1117, 15.8304, -32.728>, <31.3927, 12.9777, -29.6822>, <32.2614, 11.2208, -32.7593> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <33.286, 12.3903, -29.6231>, <30.9775, 10.7138, -27.7553>, <32.7908, 14.5813, -25.2562> }
					triangle { <33.286, 12.3903, -29.6231>, <32.7908, 14.5813, -25.2562>, <30.9775, 10.7138, -27.7553> }
					triangle { <32.1687, 7.377, -29.4788>, <31.2899, 7.003981, -25.6784>, <30.9775, 10.7138, -27.7553> }
					triangle { <32.1687, 7.377, -29.4788>, <30.9775, 10.7138, -27.7553>, <31.2899, 7.003981, -25.6784> }
					triangle { <30.9775, 10.7138, -27.7553>, <33.6836, 9.2932, -31.5098>, <32.1687, 7.377, -29.4788> }
					triangle { <30.9775, 10.7138, -27.7553>, <32.1687, 7.377, -29.4788>, <33.6836, 9.2932, -31.5098> }
					triangle { <33.286, 12.3903, -29.6231>, <33.6836, 9.2932, -31.5098>, <30.9775, 10.7138, -27.7553> }
					triangle { <33.286, 12.3903, -29.6231>, <30.9775, 10.7138, -27.7553>, <33.6836, 9.2932, -31.5098> }
					triangle { <37.3414, 12.006, -30.7797>, <33.6836, 9.2932, -31.5098>, <33.286, 12.3903, -29.6231> }
					triangle { <37.3414, 12.006, -30.7797>, <33.286, 12.3903, -29.6231>, <33.6836, 9.2932, -31.5098> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		}
	union { // Internode
		cylinder { <10.3662, 28.6094, -4.3784>, <14.1482, 31.643, -6.4551>, 0.4794 }
		cylinder { <14.1482, 31.643, -6.4551>, <17.8391, 34.7575, -8.5755>, 0.4794 }
		cylinder { <17.8391, 34.7575, -8.5755>, <21.4367, 37.9511, -10.7384>, 0.4794 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <21.4367, 37.9511, -10.7384>, <23.3938, 41.5217, -13.0303>, 0.3185 }
			cylinder { <23.3938, 41.5217, -13.0303>, <23.9234, 45.4734, -15.4667>, 0.3185 }
			cylinder { <23.9234, 45.4734, -15.4667>, <22.9721, 49.4073, -17.8017>, 0.3185 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <22.9721, 49.4073, -17.8017>, <22.6531, 50.582, -18.4969>, 0.3185 }
				cylinder { <22.6531, 50.582, -18.4969>, <22.3008, 51.7506, -19.1863>, 0.3185 }
				cylinder { <22.3008, 51.7506, -19.1863>, <21.9154, 52.9123, -19.8694>, 0.3185 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <21.9154, 52.9123, -19.8694>, <21.6164, 54.02839, -20.1578>, 0.08119 }
				cylinder { <21.6164, 54.02839, -20.1578>, <21.3674, 55.1926, -20.1333>, 0.08119 }
				cylinder { <21.3674, 55.1926, -20.1333>, <21.1866, 56.3208, -19.7977>, 0.08119 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <21.1866, 56.3208, -19.7977>, <31.07089, 50.9002, -18.136>, <32.05439, 57.875, -14.1936> }
				triangle { <21.1866, 56.3208, -19.7977>, <32.05439, 57.875, -14.1936>, <31.07089, 50.9002, -18.136> }
				triangle { <21.1866, 56.3208, -19.7977>, <32.05439, 57.875, -14.1936>, <28.00666, 71.3316, -11.8711> }
				triangle { <21.1866, 56.3208, -19.7977>, <28.00666, 71.3316, -11.8711>, <32.05439, 57.875, -14.1936> }
				triangle { <21.1866, 56.3208, -19.7977>, <28.00666, 71.3316, -11.8711>, <19.8193, 79.1508, -15.7075> }
				triangle { <21.1866, 56.3208, -19.7977>, <19.8193, 79.1508, -15.7075>, <28.00666, 71.3316, -11.8711> }
				triangle { <21.1866, 56.3208, -19.7977>, <19.8193, 79.1508, -15.7075>, <13.5464, 72.4013, -24.2514> }
				triangle { <21.1866, 56.3208, -19.7977>, <13.5464, 72.4013, -24.2514>, <19.8193, 79.1508, -15.7075> }
				triangle { <21.1866, 56.3208, -19.7977>, <13.5464, 72.4013, -24.2514>, <13.7126, 59.5637, -29.7511> }
				triangle { <21.1866, 56.3208, -19.7977>, <13.7126, 59.5637, -29.7511>, <13.5464, 72.4013, -24.2514> }
				triangle { <21.1866, 56.3208, -19.7977>, <13.7126, 59.5637, -29.7511>, <17.3786, 52.4225, -29.6347> }
				triangle { <21.1866, 56.3208, -19.7977>, <17.3786, 52.4225, -29.6347>, <13.7126, 59.5637, -29.7511> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <21.9154, 52.9123, -19.8694>, <21.497, 54.06652, -20.546>, 0.3185 }
				cylinder { <21.497, 54.06652, -20.546>, <21.04605, 55.2124, -21.2156>, 0.3185 }
				cylinder { <21.04605, 55.2124, -21.2156>, <20.5626, 56.3494, -21.8778>, 0.3185 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <20.5626, 56.3494, -21.8778>, <20.1502, 57.1155, -22.6909>, 0.08119 }
				cylinder { <20.1502, 57.1155, -22.6909>, <19.766, 57.6263, -23.6957>, 0.08119 }
				cylinder { <19.766, 57.6263, -23.6957>, <19.4379, 57.8447, -24.8195>, 0.08119 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <19.4379, 57.8447, -24.8195>, <27.5665, 63.8001, -19.4996>, <26.5644, 67.7673, -26.4576> }
				triangle { <19.4379, 57.8447, -24.8195>, <26.5644, 67.7673, -26.4576>, <27.5665, 63.8001, -19.4996> }
				triangle { <19.4379, 57.8447, -24.8195>, <26.5644, 67.7673, -26.4576>, <21.7261, 68.01717, -39.8512> }
				triangle { <19.4379, 57.8447, -24.8195>, <21.7261, 68.01717, -39.8512>, <26.5644, 67.7673, -26.4576> }
				triangle { <19.4379, 57.8447, -24.8195>, <21.7261, 68.01717, -39.8512>, <16.0638, 60.8948, -47.6036> }
				triangle { <19.4379, 57.8447, -24.8195>, <16.0638, 60.8948, -47.6036>, <21.7261, 68.01717, -39.8512> }
				triangle { <19.4379, 57.8447, -24.8195>, <16.0638, 60.8948, -47.6036>, <14.4337, 50.4288, -40.8429> }
				triangle { <19.4379, 57.8447, -24.8195>, <14.4337, 50.4288, -40.8429>, <16.0638, 60.8948, -47.6036> }
				triangle { <19.4379, 57.8447, -24.8195>, <14.4337, 50.4288, -40.8429>, <17.2439, 45.5883, -28.04647> }
				triangle { <19.4379, 57.8447, -24.8195>, <17.2439, 45.5883, -28.04647>, <14.4337, 50.4288, -40.8429> }
				triangle { <19.4379, 57.8447, -24.8195>, <17.2439, 45.5883, -28.04647>, <20.5531, 47.3462, -20.9465> }
				triangle { <19.4379, 57.8447, -24.8195>, <20.5531, 47.3462, -20.9465>, <17.2439, 45.5883, -28.04647> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <20.5626, 56.3494, -21.8778>, <20.1519, 57.3154, -22.4403>, 0.08119 }
				cylinder { <20.1519, 57.3154, -22.4403>, <19.7412, 58.2813, -23.00287>, 0.08119 }
				cylinder { <19.7412, 58.2813, -23.00287>, <19.3306, 59.2473, -23.5654>, 0.08119 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <19.3306, 59.2473, -23.5654>, <29.27, 59.1134, -17.9946>, <28.3422, 66.8722, -20.01875> }
				triangle { <19.3306, 59.2473, -23.5654>, <28.3422, 66.8722, -20.01875>, <29.27, 59.1134, -17.9946> }
				triangle { <19.3306, 59.2473, -23.5654>, <28.3422, 66.8722, -20.01875>, <21.9938, 76.7853, -28.03675> }
				triangle { <19.3306, 59.2473, -23.5654>, <21.9938, 76.7853, -28.03675>, <28.3422, 66.8722, -20.01875> }
				triangle { <19.3306, 59.2473, -23.5654>, <21.9938, 76.7853, -28.03675>, <13.8307, 77.5826, -36.7326> }
				triangle { <19.3306, 59.2473, -23.5654>, <13.8307, 77.5826, -36.7326>, <21.9938, 76.7853, -28.03675> }
				triangle { <19.3306, 59.2473, -23.5654>, <13.8307, 77.5826, -36.7326>, <10.6485, 65.5489, -38.455> }
				triangle { <19.3306, 59.2473, -23.5654>, <10.6485, 65.5489, -38.455>, <13.8307, 77.5826, -36.7326> }
				triangle { <19.3306, 59.2473, -23.5654>, <10.6485, 65.5489, -38.455>, <13.8715, 52.9491, -33.3622> }
				triangle { <19.3306, 59.2473, -23.5654>, <13.8715, 52.9491, -33.3622>, <10.6485, 65.5489, -38.455> }
				triangle { <19.3306, 59.2473, -23.5654>, <13.8715, 52.9491, -33.3622>, <18.4043, 48.9794, -28.05717> }
				triangle { <19.3306, 59.2473, -23.5654>, <18.4043, 48.9794, -28.05717>, <13.8715, 52.9491, -33.3622> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <21.4367, 37.9511, -10.7384>, <22.2997, 39.5256, -11.749>, 0.2809 }
			cylinder { <22.2997, 39.5256, -11.749>, <22.5333, 41.2682, -12.8234>, 0.2809 }
			cylinder { <22.5333, 41.2682, -12.8234>, <22.1138, 43.00297, -13.8531>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <22.1138, 43.00297, -13.8531>, <21.6942, 44.7376, -14.8828>, 0.2809 }
			cylinder { <21.6942, 44.7376, -14.8828>, <21.2747, 46.4724, -15.9125>, 0.2809 }
			cylinder { <21.2747, 46.4724, -15.9125>, <20.8552, 48.2071, -16.9421>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <20.8552, 48.2071, -16.9421>, <21.1987, 52.1232, -18.1782>, 0.2809 }
				cylinder { <21.1987, 52.1232, -18.1782>, <22.6787, 55.9612, -18.4252>, 0.2809 }
				cylinder { <22.6787, 55.9612, -18.4252>, <25.09688, 59.2068, -17.6501>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <26.5085, 63.8642, -16.9932>, <29.04988, 61.7631, -16.1239>, <25.09688, 59.2068, -17.6501> }
					triangle { <26.5085, 63.8642, -16.9932>, <25.09688, 59.2068, -17.6501>, <29.04988, 61.7631, -16.1239> }
					triangle { <30.1083, 64.3651, -13.361>, <30.4765, 60.6186, -12.2731>, <29.04988, 61.7631, -16.1239> }
					triangle { <30.1083, 64.3651, -13.361>, <29.04988, 61.7631, -16.1239>, <30.4765, 60.6186, -12.2731> }
					triangle { <29.04988, 61.7631, -16.1239>, <28.1213, 66.3421, -14.8557>, <30.1083, 64.3651, -13.361> }
					triangle { <29.04988, 61.7631, -16.1239>, <30.1083, 64.3651, -13.361>, <28.1213, 66.3421, -14.8557> }
					triangle { <26.5085, 63.8642, -16.9932>, <28.1213, 66.3421, -14.8557>, <29.04988, 61.7631, -16.1239> }
					triangle { <26.5085, 63.8642, -16.9932>, <29.04988, 61.7631, -16.1239>, <28.1213, 66.3421, -14.8557> }
					triangle { <23.5186, 66.202, -15.1152>, <28.1213, 66.3421, -14.8557>, <26.5085, 63.8642, -16.9932> }
					triangle { <23.5186, 66.202, -15.1152>, <26.5085, 63.8642, -16.9932>, <28.1213, 66.3421, -14.8557> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <27.05991, 63.05109, -15.3084>, <28.8823, 62.3615, -18.1069>, <25.09688, 59.2068, -17.6501> }
					triangle { <27.05991, 63.05109, -15.3084>, <25.09688, 59.2068, -17.6501>, <28.8823, 62.3615, -18.1069> }
					triangle { <32.1006, 63.5516, -16.1703>, <32.6798, 60.4684, -18.5184>, <28.8823, 62.3615, -18.1069> }
					triangle { <32.1006, 63.5516, -16.1703>, <28.8823, 62.3615, -18.1069>, <32.6798, 60.4684, -18.5184> }
					triangle { <28.8823, 62.3615, -18.1069>, <30.05073, 64.7092, -14.03742>, <32.1006, 63.5516, -16.1703> }
					triangle { <28.8823, 62.3615, -18.1069>, <32.1006, 63.5516, -16.1703>, <30.05073, 64.7092, -14.03742> }
					triangle { <27.05991, 63.05109, -15.3084>, <30.05073, 64.7092, -14.03742>, <28.8823, 62.3615, -18.1069> }
					triangle { <27.05991, 63.05109, -15.3084>, <28.8823, 62.3615, -18.1069>, <30.05073, 64.7092, -14.03742> }
					triangle { <27.2861, 62.4419, -11.1239>, <30.05073, 64.7092, -14.03742>, <27.05991, 63.05109, -15.3084> }
					triangle { <27.2861, 62.4419, -11.1239>, <27.05991, 63.05109, -15.3084>, <30.05073, 64.7092, -14.03742> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <28.6379, 61.9558, -15.6453>, <27.2399, 63.6242, -18.2702>, <25.09688, 59.2068, -17.6501> }
					triangle { <28.6379, 61.9558, -15.6453>, <25.09688, 59.2068, -17.6501>, <27.2399, 63.6242, -18.2702> }
					triangle { <30.7699, 65.2175, -18.9946>, <28.7273, 64.2945, -22.2088>, <27.2399, 63.6242, -18.2702> }
					triangle { <30.7699, 65.2175, -18.9946>, <27.2399, 63.6242, -18.2702>, <28.7273, 64.2945, -22.2088> }
					triangle { <27.2399, 63.6242, -18.2702>, <31.5595, 64.08561, -16.1334>, <30.7699, 65.2175, -18.9946> }
					triangle { <27.2399, 63.6242, -18.2702>, <30.7699, 65.2175, -18.9946>, <31.5595, 64.08561, -16.1334> }
					triangle { <28.6379, 61.9558, -15.6453>, <31.5595, 64.08561, -16.1334>, <27.2399, 63.6242, -18.2702> }
					triangle { <28.6379, 61.9558, -15.6453>, <27.2399, 63.6242, -18.2702>, <31.5595, 64.08561, -16.1334> }
					triangle { <32.1242, 59.7114, -14.7845>, <31.5595, 64.08561, -16.1334>, <28.6379, 61.9558, -15.6453> }
					triangle { <32.1242, 59.7114, -14.7845>, <28.6379, 61.9558, -15.6453>, <31.5595, 64.08561, -16.1334> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <29.07664, 62.08176, -17.5414>, <26.3771, 63.8179, -16.3897>, <25.09688, 59.2068, -17.6501> }
					triangle { <29.07664, 62.08176, -17.5414>, <25.09688, 59.2068, -17.6501>, <26.3771, 63.8179, -16.3897> }
					triangle { <27.9428, 67.07613, -17.9573>, <24.04438, 66.8451, -18.2788>, <26.3771, 63.8179, -16.3897> }
					triangle { <27.9428, 67.07613, -17.9573>, <26.3771, 63.8179, -16.3897>, <24.04438, 66.8451, -18.2788> }
					triangle { <26.3771, 63.8179, -16.3897>, <30.5767, 65.3273, -18.2667>, <27.9428, 67.07613, -17.9573> }
					triangle { <26.3771, 63.8179, -16.3897>, <27.9428, 67.07613, -17.9573>, <30.5767, 65.3273, -18.2667> }
					triangle { <29.07664, 62.08176, -17.5414>, <30.5767, 65.3273, -18.2667>, <26.3771, 63.8179, -16.3897> }
					triangle { <29.07664, 62.08176, -17.5414>, <26.3771, 63.8179, -16.3897>, <30.5767, 65.3273, -18.2667> }
					triangle { <31.3919, 61.7585, -21.0723>, <30.5767, 65.3273, -18.2667>, <29.07664, 62.08176, -17.5414> }
					triangle { <31.3919, 61.7585, -21.0723>, <29.07664, 62.08176, -17.5414>, <30.5767, 65.3273, -18.2667> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <27.7407, 63.279, -18.387>, <27.5126, 62.6504, -15.04323>, <25.09688, 59.2068, -17.6501> }
					triangle { <27.7407, 63.279, -18.387>, <25.09688, 59.2068, -17.6501>, <27.5126, 62.6504, -15.04323> }
					triangle { <27.5278, 66.5413, -14.4229>, <25.1417, 64.539, -12.04549>, <27.5126, 62.6504, -15.04323> }
					triangle { <27.5278, 66.5413, -14.4229>, <27.5126, 62.6504, -15.04323>, <25.1417, 64.539, -12.04549> }
					triangle { <27.5126, 62.6504, -15.04323>, <28.4197, 66.743, -17.4651>, <27.5278, 66.5413, -14.4229> }
					triangle { <27.5126, 62.6504, -15.04323>, <27.5278, 66.5413, -14.4229>, <28.4197, 66.743, -17.4651> }
					triangle { <27.7407, 63.279, -18.387>, <28.4197, 66.743, -17.4651>, <27.5126, 62.6504, -15.04323> }
					triangle { <27.7407, 63.279, -18.387>, <27.5126, 62.6504, -15.04323>, <28.4197, 66.743, -17.4651> }
					triangle { <25.9931, 65.8305, -21.2797>, <28.4197, 66.743, -17.4651>, <27.7407, 63.279, -18.387> }
					triangle { <25.9931, 65.8305, -21.2797>, <27.7407, 63.279, -18.387>, <28.4197, 66.743, -17.4651> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <20.8552, 48.2071, -16.9421>, <20.4357, 49.9418, -17.9718>, 0.2809 }
			cylinder { <20.4357, 49.9418, -17.9718>, <20.01622, 51.6765, -19.00155>, 0.2809 }
			cylinder { <20.01622, 51.6765, -19.00155>, <19.5967, 53.4112, -20.03123>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <19.5967, 53.4112, -20.03123>, <18.5947, 55.8606, -23.19>, 0.2809 }
				cylinder { <18.5947, 55.8606, -23.19>, <17.5642, 56.9618, -27.02509>, 0.2809 }
				cylinder { <17.5642, 56.9618, -27.02509>, <16.6431, 56.5671, -31.02231>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <16.36, 57.577, -35.8197>, <15.2277, 54.412, -35.2463>, <16.6431, 56.5671, -31.02231> }
					triangle { <16.36, 57.577, -35.8197>, <16.6431, 56.5671, -31.02231>, <15.2277, 54.412, -35.2463> }
					triangle { <16.6681, 53.3778, -38.7648>, <17.09047, 50.649, -35.9844>, <15.2277, 54.412, -35.2463> }
					triangle { <16.6681, 53.3778, -38.7648>, <15.2277, 54.412, -35.2463>, <17.09047, 50.649, -35.9844> }
					triangle { <15.2277, 54.412, -35.2463>, <16.9606, 56.5029, -39.2542>, <16.6681, 53.3778, -38.7648> }
					triangle { <15.2277, 54.412, -35.2463>, <16.6681, 53.3778, -38.7648>, <16.9606, 56.5029, -39.2542> }
					triangle { <16.36, 57.577, -35.8197>, <16.9606, 56.5029, -39.2542>, <15.2277, 54.412, -35.2463> }
					triangle { <16.36, 57.577, -35.8197>, <15.2277, 54.412, -35.2463>, <16.9606, 56.5029, -39.2542> }
					triangle { <19.8409, 59.5066, -37.2659>, <16.9606, 56.5029, -39.2542>, <16.36, 57.577, -35.8197> }
					triangle { <19.8409, 59.5066, -37.2659>, <16.36, 57.577, -35.8197>, <16.9606, 56.5029, -39.2542> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <17.212, 55.8229, -35.8428>, <13.8896, 55.9946, -35.09426>, <16.6431, 56.5671, -31.02231> }
					triangle { <17.212, 55.8229, -35.8428>, <16.6431, 56.5671, -31.02231>, <13.8896, 55.9946, -35.09426> }
					triangle { <13.2195, 53.3871, -37.9711>, <10.974, 52.8986, -34.7971>, <13.8896, 55.9946, -35.09426> }
					triangle { <13.2195, 53.3871, -37.9711>, <13.8896, 55.9946, -35.09426>, <10.974, 52.8986, -34.7971> }
					triangle { <13.8896, 55.9946, -35.09426>, <16.2172, 53.9869, -38.8344>, <13.2195, 53.3871, -37.9711> }
					triangle { <13.8896, 55.9946, -35.09426>, <13.2195, 53.3871, -37.9711>, <16.2172, 53.9869, -38.8344> }
					triangle { <17.212, 55.8229, -35.8428>, <16.2172, 53.9869, -38.8344>, <13.8896, 55.9946, -35.09426> }
					triangle { <17.212, 55.8229, -35.8428>, <13.8896, 55.9946, -35.09426>, <16.2172, 53.9869, -38.8344> }
					triangle { <20.1452, 52.8862, -36.6824>, <16.2172, 53.9869, -38.8344>, <17.212, 55.8229, -35.8428> }
					triangle { <20.1452, 52.8862, -36.6824>, <17.212, 55.8229, -35.8428>, <16.2172, 53.9869, -38.8344> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <15.8657, 54.483, -35.4003>, <14.9137, 57.7557, -35.5041>, <16.6431, 56.5671, -31.02231> }
					triangle { <15.8657, 54.483, -35.4003>, <16.6431, 56.5671, -31.02231>, <14.9137, 57.7557, -35.5041> }
					triangle { <12.07421, 56.7347, -38.03773>, <11.01937, 59.4896, -35.4583>, <14.9137, 57.7557, -35.5041> }
					triangle { <12.07421, 56.7347, -38.03773>, <14.9137, 57.7557, -35.5041>, <11.01937, 59.4896, -35.4583> }
					triangle { <14.9137, 57.7557, -35.5041>, <13.6286, 53.9715, -38.2364>, <12.07421, 56.7347, -38.03773> }
					triangle { <14.9137, 57.7557, -35.5041>, <12.07421, 56.7347, -38.03773>, <13.6286, 53.9715, -38.2364> }
					triangle { <15.8657, 54.483, -35.4003>, <13.6286, 53.9715, -38.2364>, <14.9137, 57.7557, -35.5041> }
					triangle { <15.8657, 54.483, -35.4003>, <14.9137, 57.7557, -35.5041>, <13.6286, 53.9715, -38.2364> }
					triangle { <14.09, 50.6532, -35.06665>, <13.6286, 53.9715, -38.2364>, <15.8657, 54.483, -35.4003> }
					triangle { <14.09, 50.6532, -35.06665>, <15.8657, 54.483, -35.4003>, <13.6286, 53.9715, -38.2364> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <14.1692, 55.3965, -35.09963>, <16.8942, 57.278, -35.9133>, <16.6431, 56.5671, -31.02231> }
					triangle { <14.1692, 55.3965, -35.09963>, <16.6431, 56.5671, -31.02231>, <16.8942, 57.278, -35.9133> }
					triangle { <14.8042, 58.8256, -38.8732>, <17.1642, 61.375, -37.06047>, <16.8942, 57.278, -35.9133> }
					triangle { <14.8042, 58.8256, -38.8732>, <16.8942, 57.278, -35.9133>, <17.1642, 61.375, -37.06047> }
					triangle { <16.8942, 57.278, -35.9133>, <12.748, 56.4777, -38.281>, <14.8042, 58.8256, -38.8732> }
					triangle { <16.8942, 57.278, -35.9133>, <14.8042, 58.8256, -38.8732>, <12.748, 56.4777, -38.281> }
					triangle { <14.1692, 55.3965, -35.09963>, <12.748, 56.4777, -38.281>, <16.8942, 57.278, -35.9133> }
					triangle { <14.1692, 55.3965, -35.09963>, <16.8942, 57.278, -35.9133>, <12.748, 56.4777, -38.281> }
					triangle { <9.9869, 55.8726, -34.6365>, <12.748, 56.4777, -38.281>, <14.1692, 55.3965, -35.09963> }
					triangle { <9.9869, 55.8726, -34.6365>, <14.1692, 55.3965, -35.09963>, <12.748, 56.4777, -38.281> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <14.4792, 57.3376, -35.3627>, <17.0913, 55.1803, -35.7516>, <16.6431, 56.5671, -31.02231> }
					triangle { <14.4792, 57.3376, -35.3627>, <16.6431, 56.5671, -31.02231>, <17.0913, 55.1803, -35.7516> }
					triangle { <17.6863, 56.7196, -39.3294>, <20.973, 55.8288, -37.3905>, <17.0913, 55.1803, -35.7516> }
					triangle { <17.6863, 56.7196, -39.3294>, <17.0913, 55.1803, -35.7516>, <20.973, 55.8288, -37.3905> }
					triangle { <17.0913, 55.1803, -35.7516>, <14.8384, 58.06589, -38.9195>, <17.6863, 56.7196, -39.3294> }
					triangle { <17.0913, 55.1803, -35.7516>, <17.6863, 56.7196, -39.3294>, <14.8384, 58.06589, -38.9195> }
					triangle { <14.4792, 57.3376, -35.3627>, <14.8384, 58.06589, -38.9195>, <17.0913, 55.1803, -35.7516> }
					triangle { <14.4792, 57.3376, -35.3627>, <17.0913, 55.1803, -35.7516>, <14.8384, 58.06589, -38.9195> }
					triangle { <13.5949, 61.427, -36.01634>, <14.8384, 58.06589, -38.9195>, <14.4792, 57.3376, -35.3627> }
					triangle { <13.5949, 61.427, -36.01634>, <14.4792, 57.3376, -35.3627>, <14.8384, 58.06589, -38.9195> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <19.5967, 53.4112, -20.03123>, <19.1771, 55.1459, -21.06091>, 0.2809 }
			cylinder { <19.1771, 55.1459, -21.06091>, <18.7576, 56.8806, -22.0906>, 0.2809 }
			cylinder { <18.7576, 56.8806, -22.0906>, <18.3381, 58.6154, -23.1202>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <18.3381, 58.6154, -23.1202>, <16.7537, 62.3402, -23.8931>, 0.2809 }
				cylinder { <16.7537, 62.3402, -23.8931>, <14.6362, 65.8212, -23.276>, 0.2809 }
				cylinder { <14.6362, 65.8212, -23.276>, <12.2695, 68.5918, -21.3515>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <8.9341, 72.1273, -20.6505>, <9.9995, 70.9431, -17.6354>, <12.2695, 68.5918, -21.3515> }
					triangle { <8.9341, 72.1273, -20.6505>, <12.2695, 68.5918, -21.3515>, <9.9995, 70.9431, -17.6354> }
					triangle { <6.3851, 71.616, -16.2184>, <8.06583, 68.3464, -14.8618>, <9.9995, 70.9431, -17.6354> }
					triangle { <6.3851, 71.616, -16.2184>, <9.9995, 70.9431, -17.6354>, <8.06583, 68.3464, -14.8618> }
					triangle { <9.9995, 70.9431, -17.6354>, <5.9423, 73.2629, -18.8985>, <6.3851, 71.616, -16.2184> }
					triangle { <9.9995, 70.9431, -17.6354>, <6.3851, 71.616, -16.2184>, <5.9423, 73.2629, -18.8985> }
					triangle { <8.9341, 72.1273, -20.6505>, <5.9423, 73.2629, -18.8985>, <9.9995, 70.9431, -17.6354> }
					triangle { <8.9341, 72.1273, -20.6505>, <9.9995, 70.9431, -17.6354>, <5.9423, 73.2629, -18.8985> }
					triangle { <5.604, 71.7332, -23.2364>, <5.9423, 73.2629, -18.8985>, <8.9341, 72.1273, -20.6505> }
					triangle { <5.604, 71.7332, -23.2364>, <8.9341, 72.1273, -20.6505>, <5.9423, 73.2629, -18.8985> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <8.2819, 70.736, -19.4495>, <11.06616, 72.4812, -18.538>, <12.2695, 68.5918, -21.3515> }
					triangle { <8.2819, 70.736, -19.4495>, <12.2695, 68.5918, -21.3515>, <11.06616, 72.4812, -18.538> }
					triangle { <9.2812, 73.3343, -15.1306>, <13.1215, 72.6263, -14.8059>, <11.06616, 72.4812, -18.538> }
					triangle { <9.2812, 73.3343, -15.1306>, <11.06616, 72.4812, -18.538>, <13.1215, 72.6263, -14.8059> }
					triangle { <11.06616, 72.4812, -18.538>, <6.6576, 72.2437, -16.5515>, <9.2812, 73.3343, -15.1306> }
					triangle { <11.06616, 72.4812, -18.538>, <9.2812, 73.3343, -15.1306>, <6.6576, 72.2437, -16.5515> }
					triangle { <8.2819, 70.736, -19.4495>, <6.6576, 72.2437, -16.5515>, <11.06616, 72.4812, -18.538> }
					triangle { <8.2819, 70.736, -19.4495>, <11.06616, 72.4812, -18.538>, <6.6576, 72.2437, -16.5515> }
					triangle { <5.5877, 67.9285, -17.7787>, <6.6576, 72.2437, -16.5515>, <8.2819, 70.736, -19.4495> }
					triangle { <5.5877, 67.9285, -17.7787>, <8.2819, 70.736, -19.4495>, <6.6576, 72.2437, -16.5515> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <9.461, 70.6653, -17.8977>, <10.1424, 72.9444, -20.3409>, <12.2695, 68.5918, -21.3515> }
					triangle { <9.461, 70.6653, -17.8977>, <12.2695, 68.5918, -21.3515>, <10.1424, 72.9444, -20.3409> }
					triangle { <10.1221, 75.7507, -17.5753>, <12.8452, 76.2412, -20.35>, <10.1424, 72.9444, -20.3409> }
					triangle { <10.1221, 75.7507, -17.5753>, <10.1424, 72.9444, -20.3409>, <12.8452, 76.2412, -20.35> }
					triangle { <10.1424, 72.9444, -20.3409>, <8.8323, 73.5211, -15.7161>, <10.1221, 75.7507, -17.5753> }
					triangle { <10.1424, 72.9444, -20.3409>, <10.1221, 75.7507, -17.5753>, <8.8323, 73.5211, -15.7161> }
					triangle { <9.461, 70.6653, -17.8977>, <8.8323, 73.5211, -15.7161>, <10.1424, 72.9444, -20.3409> }
					triangle { <9.461, 70.6653, -17.8977>, <10.1424, 72.9444, -20.3409>, <8.8323, 73.5211, -15.7161> }
					triangle { <10.7541, 69.7041, -13.9815>, <8.8323, 73.5211, -15.7161>, <9.461, 70.6653, -17.8977> }
					triangle { <10.7541, 69.7041, -13.9815>, <9.461, 70.6653, -17.8977>, <8.8323, 73.5211, -15.7161> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <10.853, 72.01231, -18.1251>, <8.4962, 71.6969, -20.5694>, <12.2695, 68.5918, -21.3515> }
					triangle { <10.853, 72.01231, -18.1251>, <12.2695, 68.5918, -21.3515>, <8.4962, 71.6969, -20.5694> }
					triangle { <7.7536, 75.5484, -20.1969>, <7.6162, 74.2292, -23.8841>, <8.4962, 71.6969, -20.5694> }
					triangle { <7.7536, 75.5484, -20.1969>, <8.4962, 71.6969, -20.5694>, <7.6162, 74.2292, -23.8841> }
					triangle { <8.4962, 71.6969, -20.5694>, <9.4813, 75.3417, -17.5391>, <7.7536, 75.5484, -20.1969> }
					triangle { <8.4962, 71.6969, -20.5694>, <7.7536, 75.5484, -20.1969>, <9.4813, 75.3417, -17.5391> }
					triangle { <10.853, 72.01231, -18.1251>, <9.4813, 75.3417, -17.5391>, <8.4962, 71.6969, -20.5694> }
					triangle { <10.853, 72.01231, -18.1251>, <8.4962, 71.6969, -20.5694>, <9.4813, 75.3417, -17.5391> }
					triangle { <14.01153, 74.6228, -17.057>, <9.4813, 75.3417, -17.5391>, <10.853, 72.01231, -18.1251> }
					triangle { <14.01153, 74.6228, -17.057>, <10.853, 72.01231, -18.1251>, <9.4813, 75.3417, -17.5391> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <10.5224, 72.9295, -19.8521>, <8.4065, 70.4413, -18.872>, <12.2695, 68.5918, -21.3515> }
					triangle { <10.5224, 72.9295, -19.8521>, <12.2695, 68.5918, -21.3515>, <8.4065, 70.4413, -18.872> }
					triangle { <5.4092, 72.9544, -19.3456>, <4.6177, 69.2763, -20.441>, <8.4065, 70.4413, -18.872> }
					triangle { <5.4092, 72.9544, -19.3456>, <8.4065, 70.4413, -18.872>, <4.6177, 69.2763, -20.441> }
					triangle { <8.4065, 70.4413, -18.872>, <7.6682, 75.1797, -19.5355>, <5.4092, 72.9544, -19.3456> }
					triangle { <8.4065, 70.4413, -18.872>, <5.4092, 72.9544, -19.3456>, <7.6682, 75.1797, -19.5355> }
					triangle { <10.5224, 72.9295, -19.8521>, <7.6682, 75.1797, -19.5355>, <8.4065, 70.4413, -18.872> }
					triangle { <10.5224, 72.9295, -19.8521>, <8.4065, 70.4413, -18.872>, <7.6682, 75.1797, -19.5355> }
					triangle { <10.7805, 75.8958, -22.8631>, <7.6682, 75.1797, -19.5355>, <10.5224, 72.9295, -19.8521> }
					triangle { <10.7805, 75.8958, -22.8631>, <10.5224, 72.9295, -19.8521>, <7.6682, 75.1797, -19.5355> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		}
	union { // Internode
		cylinder { <21.4367, 37.9511, -10.7384>, <23.3286, 39.5508, -11.7243>, 0.2424 }
		cylinder { <23.3286, 39.5508, -11.7243>, <25.2891, 41.1319, -12.6002>, 0.2424 }
		cylinder { <25.2891, 41.1319, -12.6002>, <27.3134, 42.6904, -13.3642>, 0.2424 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <27.3134, 42.6904, -13.3642>, <28.9234, 43.6115, -13.3665>, 0.1264 }
			cylinder { <28.9234, 43.6115, -13.3665>, <30.5729, 44.2765, -12.8395>, 0.1264 }
			cylinder { <30.5729, 44.2765, -12.8395>, <32.09525, 44.6183, -11.8364>, 0.1264 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <32.09525, 44.6183, -11.8364>, <32.547, 44.7128, -11.5255>, 0.1264 }
				cylinder { <32.547, 44.7128, -11.5255>, <32.9936, 44.7993, -11.205>, 0.1264 }
				cylinder { <32.9936, 44.7993, -11.205>, <33.4347, 44.8776, -10.8749>, 0.1264 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <33.4347, 44.8776, -10.8749>, <33.6006, 44.8635, -10.7885>, 0.01279 }
				cylinder { <33.6006, 44.8635, -10.7885>, <33.7718, 44.81, -10.7331>, 0.01279 }
				cylinder { <33.7718, 44.81, -10.7331>, <33.9357, 44.7208, -10.7128>, 0.01279 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <33.9357, 44.7208, -10.7128>, <32.5636, 46.4559, -14.6586>, <35.2247, 44.8467, -15.4314> }
				triangle { <33.9357, 44.7208, -10.7128>, <35.2247, 44.8467, -15.4314>, <32.5636, 46.4559, -14.6586> }
				triangle { <33.9357, 44.7208, -10.7128>, <35.2247, 44.8467, -15.4314>, <40.05172, 42.3678, -13.8429> }
				triangle { <33.9357, 44.7208, -10.7128>, <40.05172, 42.3678, -13.8429>, <35.2247, 44.8467, -15.4314> }
				triangle { <33.9357, 44.7208, -10.7128>, <40.05172, 42.3678, -13.8429>, <42.5551, 41.5415, -9.8972> }
				triangle { <33.9357, 44.7208, -10.7128>, <42.5551, 41.5415, -9.8972>, <40.05172, 42.3678, -13.8429> }
				triangle { <33.9357, 44.7208, -10.7128>, <42.5551, 41.5415, -9.8972>, <39.7051, 43.6586, -6.3931> }
				triangle { <33.9357, 44.7208, -10.7128>, <39.7051, 43.6586, -6.3931>, <42.5551, 41.5415, -9.8972> }
				triangle { <33.9357, 44.7208, -10.7128>, <39.7051, 43.6586, -6.3931>, <34.9093, 46.4124, -5.9944> }
				triangle { <33.9357, 44.7208, -10.7128>, <34.9093, 46.4124, -5.9944>, <39.7051, 43.6586, -6.3931> }
				triangle { <33.9357, 44.7208, -10.7128>, <34.9093, 46.4124, -5.9944>, <32.4261, 47.5682, -7.6237> }
				triangle { <33.9357, 44.7208, -10.7128>, <32.4261, 47.5682, -7.6237>, <34.9093, 46.4124, -5.9944> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <33.4347, 44.8776, -10.8749>, <33.87, 44.9477, -10.5356>, 0.1264 }
				cylinder { <33.87, 44.9477, -10.5356>, <34.2994, 45.00968, -10.1871>, 0.1264 }
				cylinder { <34.2994, 45.00968, -10.1871>, <34.7226, 45.06334, -9.8297>, 0.1264 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <34.7226, 45.06334, -9.8297>, <34.8375, 45.1203, -9.6927>, 0.01279 }
				cylinder { <34.8375, 45.1203, -9.6927>, <34.9164, 45.212, -9.5492>, 0.01279 }
				cylinder { <34.9164, 45.212, -9.5492>, <34.9535, 45.3318, -9.4096>, 0.01279 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <34.9535, 45.3318, -9.4096>, <37.7415, 44.7234, -12.9194>, <39.4153, 46.6192, -10.9515> }
				triangle { <34.9535, 45.3318, -9.4096>, <39.4153, 46.6192, -10.9515>, <37.7415, 44.7234, -12.9194> }
				triangle { <34.9535, 45.3318, -9.4096>, <39.4153, 46.6192, -10.9515>, <39.5425, 50.1924, -6.5715> }
				triangle { <34.9535, 45.3318, -9.4096>, <39.5425, 50.1924, -6.5715>, <39.4153, 46.6192, -10.9515> }
				triangle { <34.9535, 45.3318, -9.4096>, <39.5425, 50.1924, -6.5715>, <36.5718, 52.1859, -3.454> }
				triangle { <34.9535, 45.3318, -9.4096>, <36.5718, 52.1859, -3.454>, <39.5425, 50.1924, -6.5715> }
				triangle { <34.9535, 45.3318, -9.4096>, <36.5718, 52.1859, -3.454>, <32.1758, 50.2759, -4.8363> }
				triangle { <34.9535, 45.3318, -9.4096>, <32.1758, 50.2759, -4.8363>, <36.5718, 52.1859, -3.454> }
				triangle { <34.9535, 45.3318, -9.4096>, <32.1758, 50.2759, -4.8363>, <30.1264, 46.8146, -8.6523> }
				triangle { <34.9535, 45.3318, -9.4096>, <30.1264, 46.8146, -8.6523>, <32.1758, 50.2759, -4.8363> }
				triangle { <34.9535, 45.3318, -9.4096>, <30.1264, 46.8146, -8.6523>, <30.8509, 44.9399, -11.1256> }
				triangle { <34.9535, 45.3318, -9.4096>, <30.8509, 44.9399, -11.1256>, <30.1264, 46.8146, -8.6523> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <34.7226, 45.06334, -9.8297>, <34.8653, 45.08144, -9.7091>, 0.01279 }
				cylinder { <34.8653, 45.08144, -9.7091>, <35.00801, 45.09953, -9.5886>, 0.01279 }
				cylinder { <35.00801, 45.09953, -9.5886>, <35.1507, 45.1176, -9.4681>, 0.01279 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <35.1507, 45.1176, -9.4681>, <35.7127, 45.1858, -13.956>, <38.7107, 45.1712, -12.8246> }
				triangle { <35.1507, 45.1176, -9.4681>, <38.7107, 45.1712, -12.8246>, <35.7127, 45.1858, -13.956> }
				triangle { <35.1507, 45.1176, -9.4681>, <38.7107, 45.1712, -12.8246>, <42.3003, 45.9817, -8.532> }
				triangle { <35.1507, 45.1176, -9.4681>, <42.3003, 45.9817, -8.532>, <38.7107, 45.1712, -12.8246> }
				triangle { <35.1507, 45.1176, -9.4681>, <42.3003, 45.9817, -8.532>, <42.2322, 47.2757, -3.967> }
				triangle { <35.1507, 45.1176, -9.4681>, <42.2322, 47.2757, -3.967>, <42.3003, 45.9817, -8.532> }
				triangle { <35.1507, 45.1176, -9.4681>, <42.2322, 47.2757, -3.967>, <37.3671, 48.04042, -3.1737> }
				triangle { <35.1507, 45.1176, -9.4681>, <37.3671, 48.04042, -3.1737>, <42.2322, 47.2757, -3.967> }
				triangle { <35.1507, 45.1176, -9.4681>, <37.3671, 48.04042, -3.1737>, <32.5786, 47.7884, -5.9575> }
				triangle { <35.1507, 45.1176, -9.4681>, <32.5786, 47.7884, -5.9575>, <37.3671, 48.04042, -3.1737> }
				triangle { <35.1507, 45.1176, -9.4681>, <32.5786, 47.7884, -5.9575>, <31.234, 47.1442, -8.7741> }
				triangle { <35.1507, 45.1176, -9.4681>, <31.234, 47.1442, -8.7741>, <32.5786, 47.7884, -5.9575> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <27.3134, 42.6904, -13.3642>, <29.1019, 43.7136, -13.3668>, 0.2809 }
			cylinder { <29.1019, 43.7136, -13.3668>, <30.9341, 44.4523, -12.7814>, 0.2809 }
			cylinder { <30.9341, 44.4523, -12.7814>, <32.6252, 44.832, -11.6671>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <32.6252, 44.832, -11.6671>, <34.3162, 45.2117, -10.5527>, 0.2809 }
			cylinder { <34.3162, 45.2117, -10.5527>, <36.00729, 45.5914, -9.4384>, 0.2809 }
			cylinder { <36.00729, 45.5914, -9.4384>, <37.6983, 45.9711, -8.3241>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <37.6983, 45.9711, -8.3241>, <41.6883, 46.536, -7.4624>, 0.2809 }
				cylinder { <41.6883, 46.536, -7.4624>, <45.7515, 46.8307, -8.08313>, 0.2809 }
				cylinder { <45.7515, 46.8307, -8.08313>, <49.3434, 46.8157, -10.103>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <54.1233, 46.1673, -11.02399>, <52.5093, 47.033, -13.9004>, <49.3434, 46.8157, -10.103> }
					triangle { <54.1233, 46.1673, -11.02399>, <49.3434, 46.8157, -10.103>, <52.5093, 47.033, -13.9004> }
					triangle { <55.04742, 44.7591, -15.8783>, <51.3763, 44.6432, -17.244>, <52.5093, 47.033, -13.9004> }
					triangle { <55.04742, 44.7591, -15.8783>, <52.5093, 47.033, -13.9004>, <51.3763, 44.6432, -17.244> }
					triangle { <52.5093, 47.033, -13.9004>, <56.6992, 44.7216, -13.1651>, <55.04742, 44.7591, -15.8783> }
					triangle { <52.5093, 47.033, -13.9004>, <55.04742, 44.7591, -15.8783>, <56.6992, 44.7216, -13.1651> }
					triangle { <54.1233, 46.1673, -11.02399>, <56.6992, 44.7216, -13.1651>, <52.5093, 47.033, -13.9004> }
					triangle { <54.1233, 46.1673, -11.02399>, <52.5093, 47.033, -13.9004>, <56.6992, 44.7216, -13.1651> }
					triangle { <55.666, 42.696, -9.1525>, <56.6992, 44.7216, -13.1651>, <54.1233, 46.1673, -11.02399> }
					triangle { <55.666, 42.696, -9.1525>, <54.1233, 46.1673, -11.02399>, <56.6992, 44.7216, -13.1651> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <53.3079, 45.1385, -12.4662>, <53.2145, 48.5418, -12.6576>, <49.3434, 46.8157, -10.103> }
					triangle { <53.3079, 45.1385, -12.4662>, <49.3434, 46.8157, -10.103>, <53.2145, 48.5418, -12.6576> }
					triangle { <54.8675, 48.2764, -16.2243>, <52.1532, 51.08514, -15.9102>, <53.2145, 48.5418, -12.6576> }
					triangle { <54.8675, 48.2764, -16.2243>, <53.2145, 48.5418, -12.6576>, <52.1532, 51.08514, -15.9102> }
					triangle { <53.2145, 48.5418, -12.6576>, <55.4246, 45.25, -15.4356>, <54.8675, 48.2764, -16.2243> }
					triangle { <53.2145, 48.5418, -12.6576>, <54.8675, 48.2764, -16.2243>, <55.4246, 45.25, -15.4356> }
					triangle { <53.3079, 45.1385, -12.4662>, <55.4246, 45.25, -15.4356>, <53.2145, 48.5418, -12.6576> }
					triangle { <53.3079, 45.1385, -12.4662>, <53.2145, 48.5418, -12.6576>, <55.4246, 45.25, -15.4356> }
					triangle { <52.433, 41.7816, -14.8948>, <55.4246, 45.25, -15.4356>, <53.3079, 45.1385, -12.4662> }
					triangle { <52.433, 41.7816, -14.8948>, <53.3079, 45.1385, -12.4662>, <55.4246, 45.25, -15.4356> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <52.5783, 46.3889, -13.7729>, <54.1336, 47.6584, -11.01663>, <49.3434, 46.8157, -10.103> }
					triangle { <52.5783, 46.3889, -13.7729>, <49.3434, 46.8157, -10.103>, <54.1336, 47.6584, -11.01663> }
					triangle { <56.4492, 49.7498, -13.4225>, <55.3904, 51.6404, -10.1576>, <54.1336, 47.6584, -11.01663> }
					triangle { <56.4492, 49.7498, -13.4225>, <54.1336, 47.6584, -11.01663>, <55.3904, 51.6404, -10.1576> }
					triangle { <54.1336, 47.6584, -11.01663>, <55.2785, 47.8881, -15.7149>, <56.4492, 49.7498, -13.4225> }
					triangle { <54.1336, 47.6584, -11.01663>, <56.4492, 49.7498, -13.4225>, <55.2785, 47.8881, -15.7149> }
					triangle { <52.5783, 46.3889, -13.7729>, <55.2785, 47.8881, -15.7149>, <54.1336, 47.6584, -11.01663> }
					triangle { <52.5783, 46.3889, -13.7729>, <54.1336, 47.6584, -11.01663>, <55.2785, 47.8881, -15.7149> }
					triangle { <51.01316, 47.752, -17.4641>, <55.2785, 47.8881, -15.7149>, <52.5783, 46.3889, -13.7729> }
					triangle { <51.01316, 47.752, -17.4641>, <52.5783, 46.3889, -13.7729>, <55.2785, 47.8881, -15.7149> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <52.9359, 48.2022, -13.1505>, <54.00514, 45.5953, -11.2298>, <49.3434, 46.8157, -10.103> }
					triangle { <52.9359, 48.2022, -13.1505>, <49.3434, 46.8157, -10.103>, <54.00514, 45.5953, -11.2298> }
					triangle { <57.6214, 47.1569, -11.3187>, <56.6445, 45.5469, -7.8824>, <54.00514, 45.5953, -11.2298> }
					triangle { <57.6214, 47.1569, -11.3187>, <54.00514, 45.5953, -11.2298>, <56.6445, 45.5469, -7.8824> }
					triangle { <54.00514, 45.5953, -11.2298>, <56.4615, 49.01479, -13.6196>, <57.6214, 47.1569, -11.3187> }
					triangle { <54.00514, 45.5953, -11.2298>, <57.6214, 47.1569, -11.3187>, <56.4615, 49.01479, -13.6196> }
					triangle { <52.9359, 48.2022, -13.1505>, <56.4615, 49.01479, -13.6196>, <54.00514, 45.5953, -11.2298> }
					triangle { <52.9359, 48.2022, -13.1505>, <54.00514, 45.5953, -11.2298>, <56.4615, 49.01479, -13.6196> }
					triangle { <53.3553, 52.412, -13.3336>, <56.4615, 49.01479, -13.6196>, <52.9359, 48.2022, -13.1505> }
					triangle { <53.3553, 52.412, -13.3336>, <52.9359, 48.2022, -13.1505>, <56.4615, 49.01479, -13.6196> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <53.9051, 48.06323, -11.4258>, <52.9861, 45.2029, -13.03906>, <49.3434, 46.8157, -10.103> }
					triangle { <53.9051, 48.06323, -11.4258>, <49.3434, 46.8157, -10.103>, <52.9861, 45.2029, -13.03906> }
					triangle { <56.742, 44.02599, -12.8594>, <54.1262, 41.1571, -12.3281>, <52.9861, 45.2029, -13.03906> }
					triangle { <56.742, 44.02599, -12.8594>, <52.9861, 45.2029, -13.03906>, <54.1262, 41.1571, -12.3281> }
					triangle { <52.9861, 45.2029, -13.03906>, <57.3527, 47.02827, -12.02005>, <56.742, 44.02599, -12.8594> }
					triangle { <52.9861, 45.2029, -13.03906>, <56.742, 44.02599, -12.8594>, <57.3527, 47.02827, -12.02005> }
					triangle { <53.9051, 48.06323, -11.4258>, <57.3527, 47.02827, -12.02005>, <52.9861, 45.2029, -13.03906> }
					triangle { <53.9051, 48.06323, -11.4258>, <52.9861, 45.2029, -13.03906>, <57.3527, 47.02827, -12.02005> }
					triangle { <56.2743, 49.2401, -8.1192>, <57.3527, 47.02827, -12.02005>, <53.9051, 48.06323, -11.4258> }
					triangle { <56.2743, 49.2401, -8.1192>, <53.9051, 48.06323, -11.4258>, <57.3527, 47.02827, -12.02005> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <37.6983, 45.9711, -8.3241>, <39.3893, 46.3507, -7.2098>, 0.2809 }
			cylinder { <39.3893, 46.3507, -7.2098>, <41.08043, 46.7304, -6.09556>, 0.2809 }
			cylinder { <41.08043, 46.7304, -6.09556>, <42.7714, 47.1101, -4.9812>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <42.7714, 47.1101, -4.9812>, <45.21, 48.8992, -2.1822>, 0.2809 }
				cylinder { <45.21, 48.8992, -2.1822>, <46.3783, 51.4782, 0.812>, 0.2809 }
				cylinder { <46.3783, 51.4782, 0.812>, <46.1196, 54.5015, 3.6003>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <47.4222, 58.2859, 6.4458>, <44.06041, 57.7709, 6.6924>, <46.1196, 54.5015, 3.6003> }
					triangle { <47.4222, 58.2859, 6.4458>, <46.1196, 54.5015, 3.6003>, <44.06041, 57.7709, 6.6924> }
					triangle { <43.61, 61.6583, 7.1502>, <40.8125, 59.9532, 5.000391>, <44.06041, 57.7709, 6.6924> }
					triangle { <43.61, 61.6583, 7.1502>, <44.06041, 57.7709, 6.6924>, <40.8125, 59.9532, 5.000391> }
					triangle { <44.06041, 57.7709, 6.6924>, <46.7591, 61.694, 7.5662>, <43.61, 61.6583, 7.1502> }
					triangle { <44.06041, 57.7709, 6.6924>, <43.61, 61.6583, 7.1502>, <46.7591, 61.694, 7.5662> }
					triangle { <47.4222, 58.2859, 6.4458>, <46.7591, 61.694, 7.5662>, <44.06041, 57.7709, 6.6924> }
					triangle { <47.4222, 58.2859, 6.4458>, <44.06041, 57.7709, 6.6924>, <46.7591, 61.694, 7.5662> }
					triangle { <50.1126, 60.9124, 4.4978>, <46.7591, 61.694, 7.5662>, <47.4222, 58.2859, 6.4458> }
					triangle { <50.1126, 60.9124, 4.4978>, <47.4222, 58.2859, 6.4458>, <46.7591, 61.694, 7.5662> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <45.8801, 59.02132, 5.5054>, <45.3282, 56.7145, 7.9554>, <46.1196, 54.5015, 3.6003> }
					triangle { <45.8801, 59.02132, 5.5054>, <46.1196, 54.5015, 3.6003>, <45.3282, 56.7145, 7.9554> }
					triangle { <42.8708, 59.278, 9.6625>, <41.7001, 55.5439, 9.8635>, <45.3282, 56.7145, 7.9554> }
					triangle { <42.8708, 59.278, 9.6625>, <45.3282, 56.7145, 7.9554>, <41.7001, 55.5439, 9.8635> }
					triangle { <45.3282, 56.7145, 7.9554>, <44.1207, 61.3927, 7.6481>, <42.8708, 59.278, 9.6625> }
					triangle { <45.3282, 56.7145, 7.9554>, <42.8708, 59.278, 9.6625>, <44.1207, 61.3927, 7.6481> }
					triangle { <45.8801, 59.02132, 5.5054>, <44.1207, 61.3927, 7.6481>, <45.3282, 56.7145, 7.9554> }
					triangle { <45.8801, 59.02132, 5.5054>, <45.3282, 56.7145, 7.9554>, <44.1207, 61.3927, 7.6481> }
					triangle { <43.6605, 61.6792, 3.06802>, <44.1207, 61.3927, 7.6481>, <45.8801, 59.02132, 5.5054> }
					triangle { <43.6605, 61.6792, 3.06802>, <45.8801, 59.02132, 5.5054>, <44.1207, 61.3927, 7.6481> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <44.2687, 58.2051, 6.2409>, <47.2843, 57.2729, 7.5314>, <46.1196, 54.5015, 3.6003> }
					triangle { <44.2687, 58.2051, 6.2409>, <46.1196, 54.5015, 3.6003>, <47.2843, 57.2729, 7.5314> }
					triangle { <45.9183, 58.2062, 11.1073>, <48.1992, 55.02086, 11.03358>, <47.2843, 57.2729, 7.5314> }
					triangle { <45.9183, 58.2062, 11.1073>, <47.2843, 57.2729, 7.5314>, <48.1992, 55.02086, 11.03358> }
					triangle { <47.2843, 57.2729, 7.5314>, <43.5438, 59.6079, 9.5298>, <45.9183, 58.2062, 11.1073> }
					triangle { <47.2843, 57.2729, 7.5314>, <45.9183, 58.2062, 11.1073>, <43.5438, 59.6079, 9.5298> }
					triangle { <44.2687, 58.2051, 6.2409>, <43.5438, 59.6079, 9.5298>, <47.2843, 57.2729, 7.5314> }
					triangle { <44.2687, 58.2051, 6.2409>, <47.2843, 57.2729, 7.5314>, <43.5438, 59.6079, 9.5298> }
					triangle { <40.1479, 57.6891, 7.06852>, <43.5438, 59.6079, 9.5298>, <44.2687, 58.2051, 6.2409> }
					triangle { <40.1479, 57.6891, 7.06852>, <44.2687, 58.2051, 6.2409>, <43.5438, 59.6079, 9.5298> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <44.8, 56.9577, 7.6427>, <47.2438, 58.6796, 6.0024>, <46.1196, 54.5015, 3.6003> }
					triangle { <44.8, 56.9577, 7.6427>, <46.1196, 54.5015, 3.6003>, <47.2438, 58.6796, 6.0024> }
					triangle { <48.5693, 59.914, 9.5014>, <51.3889, 59.102, 6.9043>, <47.2438, 58.6796, 6.0024> }
					triangle { <48.5693, 59.914, 9.5014>, <47.2438, 58.6796, 6.0024>, <51.3889, 59.102, 6.9043> }
					triangle { <47.2438, 58.6796, 6.0024>, <45.8203, 58.7895, 10.6283>, <48.5693, 59.914, 9.5014> }
					triangle { <47.2438, 58.6796, 6.0024>, <48.5693, 59.914, 9.5014>, <45.8203, 58.7895, 10.6283> }
					triangle { <44.8, 56.9577, 7.6427>, <45.8203, 58.7895, 10.6283>, <47.2438, 58.6796, 6.0024> }
					triangle { <44.8, 56.9577, 7.6427>, <47.2438, 58.6796, 6.0024>, <45.8203, 58.7895, 10.6283> }
					triangle { <44.3964, 54.4191, 11.00809>, <45.8203, 58.7895, 10.6283>, <44.8, 56.9577, 7.6427> }
					triangle { <44.3964, 54.4191, 11.00809>, <44.8, 56.9577, 7.6427>, <45.8203, 58.7895, 10.6283> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <46.7784, 57.0084, 7.7713>, <45.2212, 58.992, 5.476>, <46.1196, 54.5015, 3.6003> }
					triangle { <46.7784, 57.0084, 7.7713>, <46.1196, 54.5015, 3.6003>, <45.2212, 58.992, 5.476> }
					triangle { <47.1212, 62.07975, 7.01899>, <46.7548, 62.1964, 3.1193>, <45.2212, 58.992, 5.476> }
					triangle { <47.1212, 62.07975, 7.01899>, <45.2212, 58.992, 5.476>, <46.7548, 62.1964, 3.1193> }
					triangle { <45.2212, 58.992, 5.476>, <47.8375, 60.0983, 9.3964>, <47.1212, 62.07975, 7.01899> }
					triangle { <45.2212, 58.992, 5.476>, <47.1212, 62.07975, 7.01899>, <47.8375, 60.0983, 9.3964> }
					triangle { <46.7784, 57.0084, 7.7713>, <47.8375, 60.0983, 9.3964>, <45.2212, 58.992, 5.476> }
					triangle { <46.7784, 57.0084, 7.7713>, <45.2212, 58.992, 5.476>, <47.8375, 60.0983, 9.3964> }
					triangle { <50.6479, 56.4414, 9.3953>, <47.8375, 60.0983, 9.3964>, <46.7784, 57.0084, 7.7713> }
					triangle { <50.6479, 56.4414, 9.3953>, <46.7784, 57.0084, 7.7713>, <47.8375, 60.0983, 9.3964> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <42.7714, 47.1101, -4.9812>, <44.4625, 47.4898, -3.8669>, 0.2809 }
			cylinder { <44.4625, 47.4898, -3.8669>, <46.1535, 47.8695, -2.7526>, 0.2809 }
			cylinder { <46.1535, 47.8695, -2.7526>, <47.8446, 48.2492, -1.6383>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <47.8446, 48.2492, -1.6383>, <51.2278, 47.5, 0.5919>, 0.2809 }
				cylinder { <51.2278, 47.5, 0.5919>, <54.1589, 45.3427, 2.5249>, 0.2809 }
				cylinder { <54.1589, 45.3427, 2.5249>, <56.2449, 42.06629, 3.9017>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <58.9801, 39.2274, 6.8299>, <57.8013, 37.3792, 4.2178>, <56.2449, 42.06629, 3.9017> }
					triangle { <58.9801, 39.2274, 6.8299>, <56.2449, 42.06629, 3.9017>, <57.8013, 37.3792, 4.2178> }
					triangle { <57.629, 34.2736, 6.6365>, <54.6643, 34.4956, 4.08378>, <57.8013, 37.3792, 4.2178> }
					triangle { <57.629, 34.2736, 6.6365>, <57.8013, 37.3792, 4.2178>, <54.6643, 34.4956, 4.08378> }
					triangle { <57.8013, 37.3792, 4.2178>, <59.3578, 36.06514, 8.6096>, <57.629, 34.2736, 6.6365> }
					triangle { <57.8013, 37.3792, 4.2178>, <57.629, 34.2736, 6.6365>, <59.3578, 36.06514, 8.6096> }
					triangle { <58.9801, 39.2274, 6.8299>, <59.3578, 36.06514, 8.6096>, <57.8013, 37.3792, 4.2178> }
					triangle { <58.9801, 39.2274, 6.8299>, <57.8013, 37.3792, 4.2178>, <59.3578, 36.06514, 8.6096> }
					triangle { <58.1329, 39.8577, 10.9307>, <59.3578, 36.06514, 8.6096>, <58.9801, 39.2274, 6.8299> }
					triangle { <58.1329, 39.8577, 10.9307>, <58.9801, 39.2274, 6.8299>, <59.3578, 36.06514, 8.6096> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <57.3979, 38.1149, 6.5799>, <59.5863, 38.4168, 3.9823>, <56.2449, 42.06629, 3.9017> }
					triangle { <57.3979, 38.1149, 6.5799>, <56.2449, 42.06629, 3.9017>, <59.5863, 38.4168, 3.9823> }
					triangle { <59.7998, 34.4847, 3.8497>, <59.8476, 36.2214, 0.3373>, <59.5863, 38.4168, 3.9823> }
					triangle { <59.7998, 34.4847, 3.8497>, <59.5863, 38.4168, 3.9823>, <59.8476, 36.2214, 0.3373> }
					triangle { <59.5863, 38.4168, 3.9823>, <58.3224, 34.5866, 6.66>, <59.7998, 34.4847, 3.8497> }
					triangle { <59.5863, 38.4168, 3.9823>, <59.7998, 34.4847, 3.8497>, <58.3224, 34.5866, 6.66> }
					triangle { <57.3979, 38.1149, 6.5799>, <58.3224, 34.5866, 6.66>, <59.5863, 38.4168, 3.9823> }
					triangle { <57.3979, 38.1149, 6.5799>, <59.5863, 38.4168, 3.9823>, <58.3224, 34.5866, 6.66> }
					triangle { <53.9891, 35.8327, 7.6305>, <58.3224, 34.5866, 6.66>, <57.3979, 38.1149, 6.5799> }
					triangle { <53.9891, 35.8327, 7.6305>, <57.3979, 38.1149, 6.5799>, <58.3224, 34.5866, 6.66> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <57.4431, 37.3842, 4.7723>, <59.9949, 39.4217, 5.7548>, <56.2449, 42.06629, 3.9017> }
					triangle { <57.4431, 37.3842, 4.7723>, <56.2449, 42.06629, 3.9017>, <59.9949, 39.4217, 5.7548> }
					triangle { <62.5176, 36.579, 4.7158>, <63.7544, 40.2078, 3.9048>, <59.9949, 39.4217, 5.7548> }
					triangle { <62.5176, 36.579, 4.7158>, <59.9949, 39.4217, 5.7548>, <63.7544, 40.2078, 3.9048> }
					triangle { <59.9949, 39.4217, 5.7548>, <59.9384, 34.7315, 4.5562>, <62.5176, 36.579, 4.7158> }
					triangle { <59.9949, 39.4217, 5.7548>, <62.5176, 36.579, 4.7158>, <59.9384, 34.7315, 4.5562> }
					triangle { <57.4431, 37.3842, 4.7723>, <59.9384, 34.7315, 4.5562>, <59.9949, 39.4217, 5.7548> }
					triangle { <57.4431, 37.3842, 4.7723>, <59.9949, 39.4217, 5.7548>, <59.9384, 34.7315, 4.5562> }
					triangle { <56.4576, 34.8419, 1.5324>, <59.9384, 34.7315, 4.5562>, <57.4431, 37.3842, 4.7723> }
					triangle { <56.4576, 34.8419, 1.5324>, <57.4431, 37.3842, 4.7723>, <59.9384, 34.7315, 4.5562> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <59.05381, 38.03822, 3.8883>, <58.4662, 39.01463, 7.1022>, <56.2449, 42.06629, 3.9017> }
					triangle { <59.05381, 38.03822, 3.8883>, <56.2449, 42.06629, 3.9017>, <58.4662, 39.01463, 7.1022> }
					triangle { <62.05199, 37.6819, 8.04597>, <61.02211, 40.9828, 9.8893>, <58.4662, 39.01463, 7.1022> }
					triangle { <62.05199, 37.6819, 8.04597>, <58.4662, 39.01463, 7.1022>, <61.02211, 40.9828, 9.8893> }
					triangle { <58.4662, 39.01463, 7.1022>, <61.9877, 36.3008, 5.1859>, <62.05199, 37.6819, 8.04597> }
					triangle { <58.4662, 39.01463, 7.1022>, <62.05199, 37.6819, 8.04597>, <61.9877, 36.3008, 5.1859> }
					triangle { <59.05381, 38.03822, 3.8883>, <61.9877, 36.3008, 5.1859>, <58.4662, 39.01463, 7.1022> }
					triangle { <59.05381, 38.03822, 3.8883>, <58.4662, 39.01463, 7.1022>, <61.9877, 36.3008, 5.1859> }
					triangle { <62.15, 38.2453, 1.006862>, <61.9877, 36.3008, 5.1859>, <59.05381, 38.03822, 3.8883> }
					triangle { <62.15, 38.2453, 1.006862>, <59.05381, 38.03822, 3.8883>, <61.9877, 36.3008, 5.1859> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <60.01807, 39.1945, 5.1791>, <57.09005, 37.7332, 6.138>, <56.2449, 42.06629, 3.9017> }
					triangle { <60.01807, 39.1945, 5.1791>, <56.2449, 42.06629, 3.9017>, <57.09005, 37.7332, 6.138> }
					triangle { <58.985, 36.2356, 9.2509>, <55.3193, 37.3992, 10.0016>, <57.09005, 37.7332, 6.138> }
					triangle { <58.985, 36.2356, 9.2509>, <57.09005, 37.7332, 6.138>, <55.3193, 37.3992, 10.0016> }
					triangle { <57.09005, 37.7332, 6.138>, <61.6234, 37.1375, 7.7289>, <58.985, 36.2356, 9.2509> }
					triangle { <57.09005, 37.7332, 6.138>, <58.985, 36.2356, 9.2509>, <61.6234, 37.1375, 7.7289> }
					triangle { <60.01807, 39.1945, 5.1791>, <61.6234, 37.1375, 7.7289>, <57.09005, 37.7332, 6.138> }
					triangle { <60.01807, 39.1945, 5.1791>, <57.09005, 37.7332, 6.138>, <61.6234, 37.1375, 7.7289> }
					triangle { <63.201, 41.392, 6.903>, <61.6234, 37.1375, 7.7289>, <60.01807, 39.1945, 5.1791> }
					triangle { <63.201, 41.392, 6.903>, <60.01807, 39.1945, 5.1791>, <61.6234, 37.1375, 7.7289> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <27.3134, 42.6904, -13.3642>, <32.02035, 46.3144, -15.1405>, 0.2818 }
			cylinder { <32.02035, 46.3144, -15.1405>, <36.7272, 49.9383, -16.9169>, 0.2818 }
			cylinder { <36.7272, 49.9383, -16.9169>, <41.4341, 53.5623, -18.6932>, 0.2818 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <41.4341, 53.5623, -18.6932>, <43.00311, 54.7703, -19.2853>, 0.2818 }
			cylinder { <43.00311, 54.7703, -19.2853>, <44.572, 55.9783, -19.8775>, 0.2818 }
			cylinder { <44.572, 55.9783, -19.8775>, <46.141, 57.1863, -20.4696>, 0.2818 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <46.141, 57.1863, -20.4696>, <48.4691, 60.5824, -20.8333>, 0.2818 }
				cylinder { <48.4691, 60.5824, -20.8333>, <49.6754, 64.5035, -20.3277>, 0.2818 }
				cylinder { <49.6754, 64.5035, -20.3277>, <49.5982, 68.4241, -19.02067>, 0.2818 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <50.2137, 73.296, -18.9875>, <48.38, 72.3543, -16.271>, <49.5982, 68.4241, -19.02067> }
					triangle { <50.2137, 73.296, -18.9875>, <49.5982, 68.4241, -19.02067>, <48.38, 72.3543, -16.271> }
					triangle { <46.4325, 75.7688, -16.54>, <44.2001, 72.7158, -15.5151>, <48.38, 72.3543, -16.271> }
					triangle { <46.4325, 75.7688, -16.54>, <48.38, 72.3543, -16.271>, <44.2001, 72.7158, -15.5151> }
					triangle { <48.38, 72.3543, -16.271>, <48.7357, 76.6043, -18.5621>, <46.4325, 75.7688, -16.54> }
					triangle { <48.38, 72.3543, -16.271>, <46.4325, 75.7688, -16.54>, <48.7357, 76.6043, -18.5621> }
					triangle { <50.2137, 73.296, -18.9875>, <48.7357, 76.6043, -18.5621>, <48.38, 72.3543, -16.271> }
					triangle { <50.2137, 73.296, -18.9875>, <48.38, 72.3543, -16.271>, <48.7357, 76.6043, -18.5621> }
					triangle { <49.6028, 75.02109, -22.8063>, <48.7357, 76.6043, -18.5621>, <50.2137, 73.296, -18.9875> }
					triangle { <49.6028, 75.02109, -22.8063>, <50.2137, 73.296, -18.9875>, <48.7357, 76.6043, -18.5621> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <48.2991, 73.1453, -18.6483>, <50.4532, 72.3475, -16.1281>, <49.5982, 68.4241, -19.02067> }
					triangle { <48.2991, 73.1453, -18.6483>, <49.5982, 68.4241, -19.02067>, <50.4532, 72.3475, -16.1281> }
					triangle { <48.5339, 74.9056, -13.8267>, <49.7058, 71.6489, -11.9895>, <50.4532, 72.3475, -16.1281> }
					triangle { <48.5339, 74.9056, -13.8267>, <50.4532, 72.3475, -16.1281>, <49.7058, 71.6489, -11.9895> }
					triangle { <50.4532, 72.3475, -16.1281>, <47.1829, 75.895, -16.5262>, <48.5339, 74.9056, -13.8267> }
					triangle { <50.4532, 72.3475, -16.1281>, <48.5339, 74.9056, -13.8267>, <47.1829, 75.895, -16.5262> }
					triangle { <48.2991, 73.1453, -18.6483>, <47.1829, 75.895, -16.5262>, <50.4532, 72.3475, -16.1281> }
					triangle { <48.2991, 73.1453, -18.6483>, <50.4532, 72.3475, -16.1281>, <47.1829, 75.895, -16.5262> }
					triangle { <44.1445, 73.7217, -19.2311>, <47.1829, 75.895, -16.5262>, <48.2991, 73.1453, -18.6483> }
					triangle { <44.1445, 73.7217, -19.2311>, <48.2991, 73.1453, -18.6483>, <47.1829, 75.895, -16.5262> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <48.04926, 72.5291, -16.8149>, <51.2342, 72.9704, -17.9502>, <49.5982, 68.4241, -19.02067> }
					triangle { <48.04926, 72.5291, -16.8149>, <49.5982, 68.4241, -19.02067>, <51.2342, 72.9704, -17.9502> }
					triangle { <51.8959, 75.3139, -14.8528>, <54.9284, 73.02988, -15.8233>, <51.2342, 72.9704, -17.9502> }
					triangle { <51.8959, 75.3139, -14.8528>, <51.2342, 72.9704, -17.9502>, <54.9284, 73.02988, -15.8233> }
					triangle { <51.2342, 72.9704, -17.9502>, <48.7424, 75.2424, -14.4766>, <51.8959, 75.3139, -14.8528> }
					triangle { <51.2342, 72.9704, -17.9502>, <51.8959, 75.3139, -14.8528>, <48.7424, 75.2424, -14.4766> }
					triangle { <48.04926, 72.5291, -16.8149>, <48.7424, 75.2424, -14.4766>, <51.2342, 72.9704, -17.9502> }
					triangle { <48.04926, 72.5291, -16.8149>, <51.2342, 72.9704, -17.9502>, <48.7424, 75.2424, -14.4766> }
					triangle { <46.04244, 71.7386, -13.1708>, <48.7424, 75.2424, -14.4766>, <48.04926, 72.5291, -16.8149> }
					triangle { <46.04244, 71.7386, -13.1708>, <48.04926, 72.5291, -16.8149>, <48.7424, 75.2424, -14.4766> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <49.807, 72.2933, -16.00389>, <49.6511, 73.3679, -19.2363>, <49.5982, 68.4241, -19.02067> }
					triangle { <49.807, 72.2933, -16.00389>, <49.5982, 68.4241, -19.02067>, <49.6511, 73.3679, -19.2363> }
					triangle { <51.9038, 76.4333, -18.2099>, <52.6992, 74.9632, -21.754>, <49.6511, 73.3679, -19.2363> }
					triangle { <51.9038, 76.4333, -18.2099>, <49.6511, 73.3679, -19.2363>, <52.6992, 74.9632, -21.754> }
					triangle { <49.6511, 73.3679, -19.2363>, <51.2735, 75.5423, -15.2266>, <51.9038, 76.4333, -18.2099> }
					triangle { <49.6511, 73.3679, -19.2363>, <51.9038, 76.4333, -18.2099>, <51.2735, 75.5423, -15.2266> }
					triangle { <49.807, 72.2933, -16.00389>, <51.2735, 75.5423, -15.2266>, <49.6511, 73.3679, -19.2363> }
					triangle { <49.807, 72.2933, -16.00389>, <49.6511, 73.3679, -19.2363>, <51.2735, 75.5423, -15.2266> }
					triangle { <52.6913, 71.7939, -12.9438>, <51.2735, 75.5423, -15.2266>, <49.807, 72.2933, -16.00389> }
					triangle { <52.6913, 71.7939, -12.9438>, <49.807, 72.2933, -16.00389>, <51.2735, 75.5423, -15.2266> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <51.165, 72.7745, -17.3668>, <47.8605, 72.9815, -18.1829>, <49.5982, 68.4241, -19.02067> }
					triangle { <51.165, 72.7745, -17.3668>, <49.5982, 68.4241, -19.02067>, <47.8605, 72.9815, -18.1829> }
					triangle { <48.4762, 76.7187, -19.2684>, <45.9686, 74.7662, -21.5607>, <47.8605, 72.9815, -18.1829> }
					triangle { <48.4762, 76.7187, -19.2684>, <47.8605, 72.9815, -18.1829>, <45.9686, 74.7662, -21.5607> }
					triangle { <47.8605, 72.9815, -18.1829>, <51.2693, 76.3967, -17.7897>, <48.4762, 76.7187, -19.2684> }
					triangle { <47.8605, 72.9815, -18.1829>, <48.4762, 76.7187, -19.2684>, <51.2693, 76.3967, -17.7897> }
					triangle { <51.165, 72.7745, -17.3668>, <51.2693, 76.3967, -17.7897>, <47.8605, 72.9815, -18.1829> }
					triangle { <51.165, 72.7745, -17.3668>, <47.8605, 72.9815, -18.1829>, <51.2693, 76.3967, -17.7897> }
					triangle { <54.925, 73.8532, -18.9888>, <51.2693, 76.3967, -17.7897>, <51.165, 72.7745, -17.3668> }
					triangle { <54.925, 73.8532, -18.9888>, <51.165, 72.7745, -17.3668>, <51.2693, 76.3967, -17.7897> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <46.141, 57.1863, -20.4696>, <47.71, 58.3942, -21.06174>, 0.2818 }
			cylinder { <47.71, 58.3942, -21.06174>, <49.2789, 59.6022, -21.6538>, 0.2818 }
			cylinder { <49.2789, 59.6022, -21.6538>, <50.8479, 60.8102, -22.2459>, 0.2818 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <50.8479, 60.8102, -22.2459>, <54.7305, 61.9556, -23.08247>, 0.2818 }
				cylinder { <54.7305, 61.9556, -23.08247>, <58.8373, 61.6769, -23.4591>, 0.2818 }
				cylinder { <58.8373, 61.6769, -23.4591>, <62.6181, 60.01154, -23.3254>, 0.2818 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <67.4808, 59.6297, -22.7565>, <66.1288, 56.5269, -23.1726>, <62.6181, 60.01154, -23.3254> }
					triangle { <67.4808, 59.6297, -22.7565>, <62.6181, 60.01154, -23.3254>, <66.1288, 56.5269, -23.1726> }
					triangle { <68.9087, 55.1135, -20.7645>, <65.3915, 53.4436, -20.3224>, <66.1288, 56.5269, -23.1726> }
					triangle { <68.9087, 55.1135, -20.7645>, <66.1288, 56.5269, -23.1726>, <65.3915, 53.4436, -20.3224> }
					triangle { <66.1288, 56.5269, -23.1726>, <70.291, 57.9478, -21.149>, <68.9087, 55.1135, -20.7645> }
					triangle { <66.1288, 56.5269, -23.1726>, <68.9087, 55.1135, -20.7645>, <70.291, 57.9478, -21.149> }
					triangle { <67.4808, 59.6297, -22.7565>, <70.291, 57.9478, -21.149>, <66.1288, 56.5269, -23.1726> }
					triangle { <67.4808, 59.6297, -22.7565>, <66.1288, 56.5269, -23.1726>, <70.291, 57.9478, -21.149> }
					triangle { <68.932, 62.08331, -19.625>, <70.291, 57.9478, -21.149>, <67.4808, 59.6297, -22.7565> }
					triangle { <68.932, 62.08331, -19.625>, <67.4808, 59.6297, -22.7565>, <70.291, 57.9478, -21.149> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <66.8377, 58.2693, -21.5158>, <66.6681, 57.616, -24.8583>, <62.6181, 60.01154, -23.3254> }
					triangle { <66.8377, 58.2693, -21.5158>, <62.6181, 60.01154, -23.3254>, <66.6681, 57.616, -24.8583> }
					triangle { <68.6648, 54.2844, -24.1962>, <65.8554, 53.9682, -26.9095>, <66.6681, 57.616, -24.8583> }
					triangle { <68.6648, 54.2844, -24.1962>, <66.6681, 57.616, -24.8583>, <65.8554, 53.9682, -26.9095> }
					triangle { <66.6681, 57.616, -24.8583>, <69.2275, 55.5194, -21.3239>, <68.6648, 54.2844, -24.1962> }
					triangle { <66.6681, 57.616, -24.8583>, <68.6648, 54.2844, -24.1962>, <69.2275, 55.5194, -21.3239> }
					triangle { <66.8377, 58.2693, -21.5158>, <69.2275, 55.5194, -21.3239>, <66.6681, 57.616, -24.8583> }
					triangle { <66.8377, 58.2693, -21.5158>, <66.6681, 57.616, -24.8583>, <69.2275, 55.5194, -21.3239> }
					triangle { <66.2958, 56.2422, -17.8376>, <69.2275, 55.5194, -21.3239>, <66.8377, 58.2693, -21.5158> }
					triangle { <66.2958, 56.2422, -17.8376>, <66.8377, 58.2693, -21.5158>, <69.2275, 55.5194, -21.3239> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <66.2031, 56.7453, -22.554>, <67.4487, 59.4381, -24.2349>, <62.6181, 60.01154, -23.3254> }
					triangle { <66.2031, 56.7453, -22.554>, <62.6181, 60.01154, -23.3254>, <67.4487, 59.4381, -24.2349> }
					triangle { <69.9265, 56.9972, -26.08607>, <68.5048, 59.8679, -28.3427>, <67.4487, 59.4381, -24.2349> }
					triangle { <69.9265, 56.9972, -26.08607>, <67.4487, 59.4381, -24.2349>, <68.5048, 59.8679, -28.3427> }
					triangle { <67.4487, 59.4381, -24.2349>, <69.03542, 54.8769, -23.8948>, <69.9265, 56.9972, -26.08607> }
					triangle { <67.4487, 59.4381, -24.2349>, <69.9265, 56.9972, -26.08607>, <69.03542, 54.8769, -23.8948> }
					triangle { <66.2031, 56.7453, -22.554>, <69.03542, 54.8769, -23.8948>, <67.4487, 59.4381, -24.2349> }
					triangle { <66.2031, 56.7453, -22.554>, <67.4487, 59.4381, -24.2349>, <69.03542, 54.8769, -23.8948> }
					triangle { <64.9644, 52.7766, -23.3584>, <69.03542, 54.8769, -23.8948>, <66.2031, 56.7453, -22.554> }
					triangle { <64.9644, 52.7766, -23.3584>, <66.2031, 56.7453, -22.554>, <69.03542, 54.8769, -23.8948> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <66.4481, 57.1495, -24.4461>, <67.3992, 59.4923, -22.1581>, <62.6181, 60.01154, -23.3254> }
					triangle { <66.4481, 57.1495, -24.4461>, <62.6181, 60.01154, -23.3254>, <67.3992, 59.4923, -22.1581> }
					triangle { <70.9621, 59.5283, -23.84>, <69.7031, 63.04472, -22.6547>, <67.3992, 59.4923, -22.1581> }
					triangle { <70.9621, 59.5283, -23.84>, <67.3992, 59.4923, -22.1581>, <69.7031, 63.04472, -22.6547> }
					triangle { <67.3992, 59.4923, -22.1581>, <69.9784, 56.9023, -25.3326>, <70.9621, 59.5283, -23.84> }
					triangle { <67.3992, 59.4923, -22.1581>, <70.9621, 59.5283, -23.84>, <69.9784, 56.9023, -25.3326> }
					triangle { <66.4481, 57.1495, -24.4461>, <69.9784, 56.9023, -25.3326>, <67.3992, 59.4923, -22.1581> }
					triangle { <66.4481, 57.1495, -24.4461>, <67.3992, 59.4923, -22.1581>, <69.9784, 56.9023, -25.3326> }
					triangle { <66.7653, 56.4435, -28.6095>, <69.9784, 56.9023, -25.3326>, <66.4481, 57.1495, -24.4461> }
					triangle { <66.7653, 56.4435, -28.6095>, <66.4481, 57.1495, -24.4461>, <69.9784, 56.9023, -25.3326> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <67.2496, 58.9591, -24.5732>, <66.5711, 57.6659, -21.4917>, <62.6181, 60.01154, -23.3254> }
					triangle { <67.2496, 58.9591, -24.5732>, <62.6181, 60.01154, -23.3254>, <66.5711, 57.6659, -21.4917> }
					triangle { <70.3235, 58.3465, -20.5015>, <67.7499, 59.01435, -17.623>, <66.5711, 57.6659, -21.4917> }
					triangle { <70.3235, 58.3465, -20.5015>, <66.5711, 57.6659, -21.4917>, <67.7499, 59.01435, -17.623> }
					triangle { <66.5711, 57.6659, -21.4917>, <70.7661, 58.8288, -23.61>, <70.3235, 58.3465, -20.5015> }
					triangle { <66.5711, 57.6659, -21.4917>, <70.3235, 58.3465, -20.5015>, <70.7661, 58.8288, -23.61> }
					triangle { <67.2496, 58.9591, -24.5732>, <70.7661, 58.8288, -23.61>, <66.5711, 57.6659, -21.4917> }
					triangle { <67.2496, 58.9591, -24.5732>, <66.5711, 57.6659, -21.4917>, <70.7661, 58.8288, -23.61> }
					triangle { <69.2544, 62.2822, -26.2672>, <70.7661, 58.8288, -23.61>, <67.2496, 58.9591, -24.5732> }
					triangle { <69.2544, 62.2822, -26.2672>, <67.2496, 58.9591, -24.5732>, <70.7661, 58.8288, -23.61> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <50.8479, 60.8102, -22.2459>, <52.4169, 62.01824, -22.838>, 0.2818 }
			cylinder { <52.4169, 62.01824, -22.838>, <53.9858, 63.2262, -23.4302>, 0.2818 }
			cylinder { <53.9858, 63.2262, -23.4302>, <55.5548, 64.4342, -24.02232>, 0.2818 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <55.5548, 64.4342, -24.02232>, <57.667, 67.1892, -26.266>, 0.2818 }
				cylinder { <57.667, 67.1892, -26.266>, <58.4703, 69.9141, -29.2686>, 0.2818 }
				cylinder { <58.4703, 69.9141, -29.2686>, <57.8572, 72.2436, -32.6277>, 0.2818 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <58.7724, 74.6642, -36.8012>, <55.4182, 74.667, -36.187>, <57.8572, 72.2436, -32.6277> }
					triangle { <58.7724, 74.6642, -36.8012>, <57.8572, 72.2436, -32.6277>, <55.4182, 74.667, -36.187> }
					triangle { <54.8172, 74.5565, -40.07947>, <52.2893, 72.4061, -37.996>, <55.4182, 74.667, -36.187> }
					triangle { <54.8172, 74.5565, -40.07947>, <55.4182, 74.667, -36.187>, <52.2893, 72.4061, -37.996> }
					triangle { <55.4182, 74.667, -36.187>, <57.9091, 75.2521, -40.2968>, <54.8172, 74.5565, -40.07947> }
					triangle { <55.4182, 74.667, -36.187>, <54.8172, 74.5565, -40.07947>, <57.9091, 75.2521, -40.2968> }
					triangle { <58.7724, 74.6642, -36.8012>, <57.9091, 75.2521, -40.2968>, <55.4182, 74.667, -36.187> }
					triangle { <58.7724, 74.6642, -36.8012>, <55.4182, 74.667, -36.187>, <57.9091, 75.2521, -40.2968> }
					triangle { <61.564, 72.6379, -39.2575>, <57.9091, 75.2521, -40.2968>, <58.7724, 74.6642, -36.8012> }
					triangle { <61.564, 72.6379, -39.2575>, <58.7724, 74.6642, -36.8012>, <57.9091, 75.2521, -40.2968> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <57.3084, 73.4959, -37.3443>, <56.587, 76.1714, -35.357>, <57.8572, 72.2436, -32.6277> }
					triangle { <57.3084, 73.4959, -37.3443>, <57.8572, 72.2436, -32.6277>, <56.587, 76.1714, -35.357> }
					triangle { <53.9056, 77.2862, -38.02004>, <52.8257, 77.877, -34.2998>, <56.587, 76.1714, -35.357> }
					triangle { <53.9056, 77.2862, -38.02004>, <56.587, 76.1714, -35.357>, <52.8257, 77.877, -34.2998> }
					triangle { <56.587, 76.1714, -35.357>, <55.2846, 75.1304, -39.9021>, <53.9056, 77.2862, -38.02004> }
					triangle { <56.587, 76.1714, -35.357>, <53.9056, 77.2862, -38.02004>, <55.2846, 75.1304, -39.9021> }
					triangle { <57.3084, 73.4959, -37.3443>, <55.2846, 75.1304, -39.9021>, <56.587, 76.1714, -35.357> }
					triangle { <57.3084, 73.4959, -37.3443>, <56.587, 76.1714, -35.357>, <55.2846, 75.1304, -39.9021> }
					triangle { <55.2612, 70.5304, -39.5686>, <55.2846, 75.1304, -39.9021>, <57.3084, 73.4959, -37.3443> }
					triangle { <55.2612, 70.5304, -39.5686>, <57.3084, 73.4959, -37.3443>, <55.2846, 75.1304, -39.9021> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <55.657, 74.1826, -36.5666>, <58.5587, 75.8583, -35.9341>, <57.8572, 72.2436, -32.6277> }
					triangle { <55.657, 74.1826, -36.5666>, <57.8572, 72.2436, -32.6277>, <58.5587, 75.8583, -35.9341> }
					triangle { <56.8279, 79.1359, -37.2706>, <59.1934, 79.6998, -34.198>, <58.5587, 75.8583, -35.9341> }
					triangle { <56.8279, 79.1359, -37.2706>, <58.5587, 75.8583, -35.9341>, <59.1934, 79.6998, -34.198> }
					triangle { <58.5587, 75.8583, -35.9341>, <54.5787, 77.173, -38.3567>, <56.8279, 79.1359, -37.2706> }
					triangle { <58.5587, 75.8583, -35.9341>, <56.8279, 79.1359, -37.2706>, <54.5787, 77.173, -38.3567> }
					triangle { <55.657, 74.1826, -36.5666>, <54.5787, 77.173, -38.3567>, <58.5587, 75.8583, -35.9341> }
					triangle { <55.657, 74.1826, -36.5666>, <58.5587, 75.8583, -35.9341>, <54.5787, 77.173, -38.3567> }
					triangle { <51.4915, 74.6889, -35.9966>, <54.5787, 77.173, -38.3567>, <55.657, 74.1826, -36.5666> }
					triangle { <51.4915, 74.6889, -35.9966>, <55.657, 74.1826, -36.5666>, <54.5787, 77.173, -38.3567> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <56.08502, 75.7817, -35.5357>, <58.6267, 74.1575, -37.1261>, <57.8572, 72.2436, -32.6277> }
					triangle { <56.08502, 75.7817, -35.5357>, <57.8572, 72.2436, -32.6277>, <58.6267, 74.1575, -37.1261> }
					triangle { <59.5729, 77.5667, -38.8599>, <62.6519, 75.3725, -37.8303>, <58.6267, 74.1575, -37.1261> }
					triangle { <59.5729, 77.5667, -38.8599>, <58.6267, 74.1575, -37.1261>, <62.6519, 75.3725, -37.8303> }
					triangle { <58.6267, 74.1575, -37.1261>, <56.7604, 78.5761, -37.7819>, <59.5729, 77.5667, -38.8599> }
					triangle { <58.6267, 74.1575, -37.1261>, <59.5729, 77.5667, -38.8599>, <56.7604, 78.5761, -37.7819> }
					triangle { <56.08502, 75.7817, -35.5357>, <56.7604, 78.5761, -37.7819>, <58.6267, 74.1575, -37.1261> }
					triangle { <56.08502, 75.7817, -35.5357>, <58.6267, 74.1575, -37.1261>, <56.7604, 78.5761, -37.7819> }
					triangle { <55.4293, 79.4052, -33.4445>, <56.7604, 78.5761, -37.7819>, <56.08502, 75.7817, -35.5357> }
					triangle { <55.4293, 79.4052, -33.4445>, <56.08502, 75.7817, -35.5357>, <56.7604, 78.5761, -37.7819> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <58.03953, 76.08398, -35.6828>, <56.6565, 73.4101, -37.2847>, <57.8572, 72.2436, -32.6277> }
					triangle { <58.03953, 76.08398, -35.6828>, <57.8572, 72.2436, -32.6277>, <56.6565, 73.4101, -37.2847> }
					triangle { <58.3114, 74.6938, -40.6221>, <58.3205, 70.7967, -40.2131>, <56.6565, 73.4101, -37.2847> }
					triangle { <58.3114, 74.6938, -40.6221>, <56.6565, 73.4101, -37.2847>, <58.3205, 70.7967, -40.2131> }
					triangle { <56.6565, 73.4101, -37.2847>, <58.8498, 77.371, -38.999>, <58.3114, 74.6938, -40.6221> }
					triangle { <56.6565, 73.4101, -37.2847>, <58.3114, 74.6938, -40.6221>, <58.8498, 77.371, -38.999> }
					triangle { <58.03953, 76.08398, -35.6828>, <58.8498, 77.371, -38.999>, <56.6565, 73.4101, -37.2847> }
					triangle { <58.03953, 76.08398, -35.6828>, <56.6565, 73.4101, -37.2847>, <58.8498, 77.371, -38.999> }
					triangle { <61.7484, 78.1185, -35.4903>, <58.8498, 77.371, -38.999>, <58.03953, 76.08398, -35.6828> }
					triangle { <61.7484, 78.1185, -35.4903>, <58.03953, 76.08398, -35.6828>, <58.8498, 77.371, -38.999> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		}
	union { // Internode
		cylinder { <0.9946, 16.3907, 0.2521>, <1.6281, 21.6035, -0.01085>, 0.4779 }
		cylinder { <1.6281, 21.6035, -0.01085>, <2.01045, 26.8376, -0.3288>, 0.4779 }
		cylinder { <2.01045, 26.8376, -0.3288>, <2.1406, 32.08055, -0.7012>, 0.4779 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <2.1406, 32.08055, -0.7012>, <0.4482, 37.7555, -1.4941>, 0.4073 }
			cylinder { <0.4482, 37.7555, -1.4941>, <-2.9135, 42.5747, -2.5768>, 0.4073 }
			cylinder { <-2.9135, 42.5747, -2.5768>, <-7.6054, 46.05155, -3.84>, 0.4073 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-7.6054, 46.05155, -3.84>, <-9.03825, 47.05867, -4.2216>, 0.4073 }
				cylinder { <-9.03825, 47.05867, -4.2216>, <-10.4954, 48.02924, -4.6056>, 0.4073 }
				cylinder { <-10.4954, 48.02924, -4.6056>, <-11.9761, 48.9626, -4.9917>, 0.4073 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-11.9761, 48.9626, -4.9917>, <-13.6341, 49.9786, -4.8895>, 0.1327 }
				cylinder { <-13.6341, 49.9786, -4.8895>, <-15.2214, 50.9228, -4.2728>, 0.1327 }
				cylinder { <-15.2214, 50.9228, -4.2728>, <-16.6231, 51.727, -3.1865>, 0.1327 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-16.6231, 51.727, -3.1865>, <-2.5265, 55.05275, -1.5959>, <-7.06445, 59.928, 6.2893> }
				triangle { <-16.6231, 51.727, -3.1865>, <-7.06445, 59.928, 6.2893>, <-2.5265, 55.05275, -1.5959> }
				triangle { <-16.6231, 51.727, -3.1865>, <-7.06445, 59.928, 6.2893>, <-22.1543, 66.5405, 14.05231> }
				triangle { <-16.6231, 51.727, -3.1865>, <-22.1543, 66.5405, 14.05231>, <-7.06445, 59.928, 6.2893> }
				triangle { <-16.6231, 51.727, -3.1865>, <-22.1543, 66.5405, 14.05231>, <-37.1402, 67.6408, 11.2505> }
				triangle { <-16.6231, 51.727, -3.1865>, <-37.1402, 67.6408, 11.2505>, <-22.1543, 66.5405, 14.05231> }
				triangle { <-16.6231, 51.727, -3.1865>, <-37.1402, 67.6408, 11.2505>, <-38.4187, 60.4227, -3.04801> }
				triangle { <-16.6231, 51.727, -3.1865>, <-38.4187, 60.4227, -3.04801>, <-37.1402, 67.6408, 11.2505> }
				triangle { <-16.6231, 51.727, -3.1865>, <-38.4187, 60.4227, -3.04801>, <-27.9604, 52.3781, -15.08463> }
				triangle { <-16.6231, 51.727, -3.1865>, <-27.9604, 52.3781, -15.08463>, <-38.4187, 60.4227, -3.04801> }
				triangle { <-16.6231, 51.727, -3.1865>, <-27.9604, 52.3781, -15.08463>, <-18.3351, 49.5822, -17.3021> }
				triangle { <-16.6231, 51.727, -3.1865>, <-18.3351, 49.5822, -17.3021>, <-27.9604, 52.3781, -15.08463> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-11.9761, 48.9626, -4.9917>, <-13.4794, 49.8584, -5.3798>, 0.4073 }
				cylinder { <-13.4794, 49.8584, -5.3798>, <-15.00439, 50.7159, -5.7696>, 0.4073 }
				cylinder { <-15.00439, 50.7159, -5.7696>, <-16.5501, 51.5347, -6.1609>, 0.4073 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-16.5501, 51.5347, -6.1609>, <-18.06079, 52.3533, -7.07709>, 0.1327 }
				cylinder { <-18.06079, 52.3533, -7.07709>, <-19.2934, 53.04175, -8.418>, 0.1327 }
				cylinder { <-19.2934, 53.04175, -8.418>, <-20.1587, 53.5501, -10.08671>, 0.1327 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-20.1587, 53.5501, -10.08671>, <-17.00833, 63.1535, 0.4087>, <-22.5337, 68.6739, -6.339> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-22.5337, 68.6739, -6.339>, <-17.00833, 63.1535, 0.4087> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-22.5337, 68.6739, -6.339>, <-29.3975, 70.6596, -23.09138> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-29.3975, 70.6596, -23.09138>, <-22.5337, 68.6739, -6.339> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-29.3975, 70.6596, -23.09138>, <-29.6592, 63.3084, -36.4902> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-29.6592, 63.3084, -36.4902>, <-29.3975, 70.6596, -23.09138> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-29.6592, 63.3084, -36.4902>, <-20.9141, 50.2109, -33.3022> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-20.9141, 50.2109, -33.3022>, <-29.6592, 63.3084, -36.4902> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-20.9141, 50.2109, -33.3022>, <-12.0063, 42.9308, -19.6413> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-12.0063, 42.9308, -19.6413>, <-20.9141, 50.2109, -33.3022> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-12.0063, 42.9308, -19.6413>, <-9.3332, 44.08945, -9.7978> }
				triangle { <-20.1587, 53.5501, -10.08671>, <-9.3332, 44.08945, -9.7978>, <-12.0063, 42.9308, -19.6413> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-16.5501, 51.5347, -6.1609>, <-18.2293, 52.4242, -6.5859>, 0.1327 }
				cylinder { <-18.2293, 52.4242, -6.5859>, <-19.9085, 53.3136, -7.01094>, 0.1327 }
				cylinder { <-19.9085, 53.3136, -7.01094>, <-21.5877, 54.2031, -7.4359>, 0.1327 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-21.5877, 54.2031, -7.4359>, <-11.4148, 60.2161, 1.08815>, <-19.3731, 66.7448, 1.8493> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-19.3731, 66.7448, 1.8493>, <-11.4148, 60.2161, 1.08815> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-19.3731, 66.7448, 1.8493>, <-35.1807, 73.03606, -4.6496> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-35.1807, 73.03606, -4.6496>, <-19.3731, 66.7448, 1.8493> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-35.1807, 73.03606, -4.6496>, <-44.8109, 70.5033, -16.2462> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-44.8109, 70.5033, -16.2462>, <-35.1807, 73.03606, -4.6496> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-44.8109, 70.5033, -16.2462>, <-37.5155, 58.5425, -24.114> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-37.5155, 58.5425, -24.114>, <-44.8109, 70.5033, -16.2462> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-37.5155, 58.5425, -24.114>, <-22.717, 48.6219, -22.8663> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-22.717, 48.6219, -22.8663>, <-37.5155, 58.5425, -24.114> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-22.717, 48.6219, -22.8663>, <-14.2124, 46.893, -17.3831> }
				triangle { <-21.5877, 54.2031, -7.4359>, <-14.2124, 46.893, -17.3831>, <-22.717, 48.6219, -22.8663> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <2.1406, 32.08055, -0.7012>, <1.2304, 36.2121, -1.21>, 0.3873 }
		cylinder { <1.2304, 36.2121, -1.21>, <-0.6408, 39.9785, -1.8953>, 0.3873 }
		cylinder { <-0.6408, 39.9785, -1.8953>, <-3.3611, 43.154, -2.7162>, 0.3873 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-3.3611, 43.154, -2.7162>, <-6.09401, 44.7824, -3.4217>, 0.2221 }
			cylinder { <-6.09401, 44.7824, -3.4217>, <-9.2036, 45.4466, -4.1338>, 0.2221 }
			cylinder { <-9.2036, 45.4466, -4.1338>, <-12.3762, 45.07944, -4.7806>, 0.2221 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-12.3762, 45.07944, -4.7806>, <-13.3254, 44.9455, -4.9722>, 0.2221 }
				cylinder { <-13.3254, 44.9455, -4.9722>, <-14.2715, 44.788, -5.1614>, 0.2221 }
				cylinder { <-14.2715, 44.788, -5.1614>, <-15.2138, 44.6069, -5.3481>, 0.2221 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-15.2138, 44.6069, -5.3481>, <-15.7839, 44.5149, -5.3039>, 0.03948 }
				cylinder { <-15.7839, 44.5149, -5.3039>, <-16.3246, 44.4451, -5.1083>, 0.03948 }
				cylinder { <-16.3246, 44.4451, -5.1083>, <-16.7966, 44.4023, -4.7754>, 0.03948 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-16.7966, 44.4023, -4.7754>, <-12.2119, 50.8913, -4.9247>, <-15.8361, 51.934, -0.7453> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-15.8361, 51.934, -0.7453>, <-12.2119, 50.8913, -4.9247> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-15.8361, 51.934, -0.7453>, <-24.4128, 49.9228, 3.8432> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-24.4128, 49.9228, 3.8432>, <-15.8361, 51.934, -0.7453> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-24.4128, 49.9228, 3.8432>, <-30.9516, 44.8056, 3.09903> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-30.9516, 44.8056, 3.09903>, <-24.4128, 49.9228, 3.8432> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-30.9516, 44.8056, 3.09903>, <-28.8625, 40.1961, -4.05521> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-28.8625, 40.1961, -4.05521>, <-30.9516, 44.8056, 3.09903> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-28.8625, 40.1961, -4.05521>, <-21.6651, 39.6143, -10.5924> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-21.6651, 39.6143, -10.5924>, <-28.8625, 40.1961, -4.05521> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-21.6651, 39.6143, -10.5924>, <-16.7091, 41.7087, -12.1404> }
				triangle { <-16.7966, 44.4023, -4.7754>, <-16.7091, 41.7087, -12.1404>, <-21.6651, 39.6143, -10.5924> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-15.2138, 44.6069, -5.3481>, <-16.1519, 44.4023, -5.532>, 0.2221 }
				cylinder { <-16.1519, 44.4023, -5.532>, <-17.08515, 44.1744, -5.7131>, 0.2221 }
				cylinder { <-17.08515, 44.1744, -5.7131>, <-18.01297, 43.9233, -5.8913>, 0.2221 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-18.01297, 43.9233, -5.8913>, <-18.5107, 43.7685, -6.1437>, 0.03948 }
				cylinder { <-18.5107, 43.7685, -6.1437>, <-18.9204, 43.6187, -6.5247>, 0.03948 }
				cylinder { <-18.9204, 43.6187, -6.5247>, <-19.2124, 43.4849, -7.006665>, 0.03948 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-19.2124, 43.4849, -7.006665>, <-21.3859, 49.3969, -2.1618>, <-25.6276, 49.08828, -5.8499> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-25.6276, 49.08828, -5.8499>, <-21.3859, 49.3969, -2.1618> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-25.6276, 49.08828, -5.8499>, <-29.1344, 46.01041, -14.6186> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-29.1344, 46.01041, -14.6186>, <-25.6276, 49.08828, -5.8499> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-29.1344, 46.01041, -14.6186>, <-26.5816, 41.7855, -21.3363> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-26.5816, 41.7855, -21.3363>, <-29.1344, 46.01041, -14.6186> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-26.5816, 41.7855, -21.3363>, <-18.2911, 39.8626, -19.247> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-18.2911, 39.8626, -19.247>, <-26.5816, 41.7855, -21.3363> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-18.2911, 39.8626, -19.247>, <-12.03881, 41.256, -11.9093> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-12.03881, 41.256, -11.9093>, <-18.2911, 39.8626, -19.247> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-12.03881, 41.256, -11.9093>, <-11.3719, 43.5231, -6.8338> }
				triangle { <-19.2124, 43.4849, -7.006665>, <-11.3719, 43.5231, -6.8338>, <-12.03881, 41.256, -11.9093> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-18.01297, 43.9233, -5.8913>, <-18.5626, 43.7746, -5.9968>, 0.03948 }
				cylinder { <-18.5626, 43.7746, -5.9968>, <-19.1123, 43.6258, -6.1024>, 0.03948 }
				cylinder { <-19.1123, 43.6258, -6.1024>, <-19.662, 43.477, -6.208>, 0.03948 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-19.662, 43.477, -6.208>, <-17.6619, 50.2588, -2.5809>, <-23.2739, 50.1421, -2.1557> }
				triangle { <-19.662, 43.477, -6.208>, <-23.2739, 50.1421, -2.1557>, <-17.6619, 50.2588, -2.5809> }
				triangle { <-19.662, 43.477, -6.208>, <-23.2739, 50.1421, -2.1557>, <-32.01056, 46.5161, -5.1862> }
				triangle { <-19.662, 43.477, -6.208>, <-32.01056, 46.5161, -5.1862>, <-23.2739, 50.1421, -2.1557> }
				triangle { <-19.662, 43.477, -6.208>, <-32.01056, 46.5161, -5.1862>, <-35.0349, 41.07115, -10.727> }
				triangle { <-19.662, 43.477, -6.208>, <-35.0349, 41.07115, -10.727>, <-32.01056, 46.5161, -5.1862> }
				triangle { <-19.662, 43.477, -6.208>, <-35.0349, 41.07115, -10.727>, <-27.7328, 38.1402, -14.5852> }
				triangle { <-19.662, 43.477, -6.208>, <-27.7328, 38.1402, -14.5852>, <-35.0349, 41.07115, -10.727> }
				triangle { <-19.662, 43.477, -6.208>, <-27.7328, 38.1402, -14.5852>, <-18.09864, 39.4856, -14.0877> }
				triangle { <-19.662, 43.477, -6.208>, <-18.09864, 39.4856, -14.0877>, <-27.7328, 38.1402, -14.5852> }
				triangle { <-19.662, 43.477, -6.208>, <-18.09864, 39.4856, -14.0877>, <-13.9961, 42.2782, -11.4962> }
				triangle { <-19.662, 43.477, -6.208>, <-13.9961, 42.2782, -11.4962>, <-18.09864, 39.4856, -14.0877> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-3.3611, 43.154, -2.7162>, <-3.98, 43.9011, -2.8882>, 0.08956 }
		cylinder { <-3.98, 43.9011, -2.8882>, <-4.5884, 44.6605, -3.0423>, 0.08956 }
		cylinder { <-4.5884, 44.6605, -3.0423>, <-5.1859, 45.432, -3.1783>, 0.08956 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-5.1859, 45.432, -3.1783>, <-5.5042, 46.09042, -3.1025>, 0.05012 }
			cylinder { <-5.5042, 46.09042, -3.1025>, <-5.6628, 46.765, -2.8571>, 0.05012 }
			cylinder { <-5.6628, 46.765, -2.8571>, <-5.6456, 47.3878, -2.4668>, 0.05012 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-5.6456, 47.3878, -2.4668>, <-5.6404, 47.5747, -2.3497>, 0.05012 }
				cylinder { <-5.6404, 47.5747, -2.3497>, <-5.6353, 47.7615, -2.2326>, 0.05012 }
				cylinder { <-5.6353, 47.7615, -2.2326>, <-5.6301, 47.9484, -2.1155>, 0.05012 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-5.6301, 47.9484, -2.1155>, <-5.6243, 47.9755, -2.1056>, 0.00201 }
				cylinder { <-5.6243, 47.9755, -2.1056>, <-5.6139, 48.0029, -2.102>, 0.00201 }
				cylinder { <-5.6139, 48.0029, -2.102>, <-5.5995, 48.02844, -2.1051>, 0.00201 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.5995, 48.02844, -2.1051>, <-6.6793, 47.3625, -3.3721>, <-6.1442, 48.3673, -3.9354> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-6.1442, 48.3673, -3.9354>, <-6.6793, 47.3625, -3.3721> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-6.1442, 48.3673, -3.9354>, <-5.02646, 50.303, -3.7735> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-5.02646, 50.303, -3.7735>, <-6.1442, 48.3673, -3.9354> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-5.02646, 50.303, -3.7735>, <-4.2931, 51.4249, -2.454> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-4.2931, 51.4249, -2.454>, <-5.02646, 50.303, -3.7735> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-4.2931, 51.4249, -2.454>, <-4.7345, 50.45, -0.7914> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-4.7345, 50.45, -0.7914>, <-4.2931, 51.4249, -2.454> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-4.7345, 50.45, -0.7914>, <-5.7478, 48.6016, -0.1697> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-5.7478, 48.6016, -0.1697>, <-4.7345, 50.45, -0.7914> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-5.7478, 48.6016, -0.1697>, <-6.3628, 47.5751, -0.5744> }
				triangle { <-5.5995, 48.02844, -2.1051>, <-6.3628, 47.5751, -0.5744>, <-5.7478, 48.6016, -0.1697> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-5.6301, 47.9484, -2.1155>, <-5.625, 48.1352, -1.9984>, 0.05012 }
				cylinder { <-5.625, 48.1352, -1.9984>, <-5.6198, 48.3221, -1.8813>, 0.05012 }
				cylinder { <-5.6198, 48.3221, -1.8813>, <-5.6147, 48.5089, -1.7642>, 0.05012 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-5.6147, 48.5089, -1.7642>, <-5.6191, 48.5299, -1.744>, 0.00201 }
				cylinder { <-5.6191, 48.5299, -1.744>, <-5.6284, 48.5454, -1.7208>, 0.00201 }
				cylinder { <-5.6284, 48.5454, -1.7208>, <-5.6418, 48.5543, -1.6961>, 0.00201 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.6418, 48.5543, -1.6961>, <-5.7781, 49.4408, -3.2486>, <-6.355, 50.2077, -2.4166> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-6.355, 50.2077, -2.4166>, <-5.7781, 49.4408, -3.2486> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-6.355, 50.2077, -2.4166>, <-7.3294, 50.5066, -0.4207> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-7.3294, 50.5066, -0.4207>, <-6.355, 50.2077, -2.4166> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-7.3294, 50.5066, -0.4207>, <-7.7597, 49.5212, 1.1224> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-7.7597, 49.5212, 1.1224>, <-7.3294, 50.5066, -0.4207> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-7.7597, 49.5212, 1.1224>, <-7.07754, 47.7221, 0.667> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-7.07754, 47.7221, 0.667>, <-7.7597, 49.5212, 1.1224> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-7.07754, 47.7221, 0.667>, <-6.06179, 46.7031, -0.9941> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-6.06179, 46.7031, -0.9941>, <-7.07754, 47.7221, 0.667> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-6.06179, 46.7031, -0.9941>, <-5.58, 46.846, -2.153> }
				triangle { <-5.6418, 48.5543, -1.6961>, <-5.58, 46.846, -2.153>, <-6.06179, 46.7031, -0.9941> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-5.6147, 48.5089, -1.7642>, <-5.614, 48.5339, -1.7486>, 0.00201 }
				cylinder { <-5.614, 48.5339, -1.7486>, <-5.6133, 48.5589, -1.7329>, 0.00201 }
				cylinder { <-5.6133, 48.5589, -1.7329>, <-5.6126, 48.5838, -1.7173>, 0.00201 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.06213, 48.538, -3.4524>, <-6.002726, 49.78, -3.1933> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.002726, 49.78, -3.1933>, <-6.06213, 48.538, -3.4524> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.002726, 49.78, -3.1933>, <-5.9795, 51.4387, -1.6865> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-5.9795, 51.4387, -1.6865>, <-6.002726, 49.78, -3.1933> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-5.9795, 51.4387, -1.6865>, <-6.05594, 51.6787, 0.1774> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.05594, 51.6787, 0.1774>, <-5.9795, 51.4387, -1.6865> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.05594, 51.6787, 0.1774>, <-6.1953, 49.8168, 0.8279> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.1953, 49.8168, 0.8279>, <-6.05594, 51.6787, 0.1774> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.1953, 49.8168, 0.8279>, <-6.2742, 47.776, 0.01638> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.2742, 47.776, 0.01638>, <-6.1953, 49.8168, 0.8279> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.2742, 47.776, 0.01638>, <-6.2631, 47.08405, -1.04036> }
				triangle { <-5.6126, 48.5838, -1.7173>, <-6.2631, 47.08405, -1.04036>, <-6.2742, 47.776, 0.01638> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <-5.1859, 45.432, -3.1783>, <-8.935, 50.272, -4.03195>, 0.2809 }
			cylinder { <-8.935, 50.272, -4.03195>, <-12.684, 55.1119, -4.8855>, 0.2809 }
			cylinder { <-12.684, 55.1119, -4.8855>, <-16.4331, 59.9519, -5.7391>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-16.4331, 59.9519, -5.7391>, <-17.6827, 61.5652, -6.02367>, 0.2809 }
			cylinder { <-17.6827, 61.5652, -6.02367>, <-18.9324, 63.1785, -6.3082>, 0.2809 }
			cylinder { <-18.9324, 63.1785, -6.3082>, <-20.1821, 64.7918, -6.5927>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-20.1821, 64.7918, -6.5927>, <-23.4093, 67.2973, -6.05457>, 0.2809 }
				cylinder { <-23.4093, 67.2973, -6.05457>, <-26.9319, 68.7458, -4.4813>, 0.2809 }
				cylinder { <-26.9319, 68.7458, -4.4813>, <-30.2778, 68.9433, -2.08379>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-34.886, 69.8482, -0.6484>, <-33.2694, 68.04981, 1.7557>, <-30.2778, 68.9433, -2.08379> }
					triangle { <-34.886, 69.8482, -0.6484>, <-30.2778, 68.9433, -2.08379>, <-33.2694, 68.04981, 1.7557> }
					triangle { <-36.6984, 66.3011, 2.5974>, <-33.5881, 63.9251, 2.7851>, <-33.2694, 68.04981, 1.7557> }
					triangle { <-36.6984, 66.3011, 2.5974>, <-33.2694, 68.04981, 1.7557>, <-33.5881, 63.9251, 2.7851> }
					triangle { <-33.2694, 68.04981, 1.7557>, <-37.9856, 68.5839, 0.8021>, <-36.6984, 66.3011, 2.5974> }
					triangle { <-33.2694, 68.04981, 1.7557>, <-36.6984, 66.3011, 2.5974>, <-37.9856, 68.5839, 0.8021> }
					triangle { <-34.886, 69.8482, -0.6484>, <-37.9856, 68.5839, 0.8021>, <-33.2694, 68.04981, 1.7557> }
					triangle { <-34.886, 69.8482, -0.6484>, <-33.2694, 68.04981, 1.7557>, <-37.9856, 68.5839, 0.8021> }
					triangle { <-37.6923, 69.219, -3.7566>, <-37.9856, 68.5839, 0.8021>, <-34.886, 69.8482, -0.6484> }
					triangle { <-37.6923, 69.219, -3.7566>, <-34.886, 69.8482, -0.6484>, <-37.9856, 68.5839, 0.8021> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-34.7324, 67.9399, -0.2768>, <-33.1224, 70.1223, 1.7902>, <-30.2778, 68.9433, -2.08379> }
					triangle { <-34.7324, 67.9399, -0.2768>, <-30.2778, 68.9433, -2.08379>, <-33.1224, 70.1223, 1.7902> }
					triangle { <-34.9713, 68.4333, 4.8321>, <-31.2647, 69.4677, 5.5711>, <-33.1224, 70.1223, 1.7902> }
					triangle { <-34.9713, 68.4333, 4.8321>, <-33.1224, 70.1223, 1.7902>, <-31.2647, 69.4677, 5.5711> }
					triangle { <-33.1224, 70.1223, 1.7902>, <-36.7791, 67.05785, 2.6115>, <-34.9713, 68.4333, 4.8321> }
					triangle { <-33.1224, 70.1223, 1.7902>, <-34.9713, 68.4333, 4.8321>, <-36.7791, 67.05785, 2.6115> }
					triangle { <-34.7324, 67.9399, -0.2768>, <-36.7791, 67.05785, 2.6115>, <-33.1224, 70.1223, 1.7902> }
					triangle { <-34.7324, 67.9399, -0.2768>, <-33.1224, 70.1223, 1.7902>, <-36.7791, 67.05785, 2.6115> }
					triangle { <-35.6516, 63.8104, -0.4633>, <-36.7791, 67.05785, 2.6115>, <-34.7324, 67.9399, -0.2768> }
					triangle { <-35.6516, 63.8104, -0.4633>, <-34.7324, 67.9399, -0.2768>, <-36.7791, 67.05785, 2.6115> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-33.613, 67.7127, 1.3039>, <-34.2196, 70.8803, 0.1965>, <-30.2778, 68.9433, -2.08379> }
					triangle { <-33.613, 67.7127, 1.3039>, <-30.2778, 68.9433, -2.08379>, <-34.2196, 70.8803, 0.1965> }
					triangle { <-35.5057, 71.7791, 3.8107>, <-33.471, 74.6377, 2.06628>, <-34.2196, 70.8803, 0.1965> }
					triangle { <-35.5057, 71.7791, 3.8107>, <-34.2196, 70.8803, 0.1965>, <-33.471, 74.6377, 2.06628> }
					triangle { <-34.2196, 70.8803, 0.1965>, <-35.4753, 68.6406, 4.3008>, <-35.5057, 71.7791, 3.8107> }
					triangle { <-34.2196, 70.8803, 0.1965>, <-35.5057, 71.7791, 3.8107>, <-35.4753, 68.6406, 4.3008> }
					triangle { <-33.613, 67.7127, 1.3039>, <-35.4753, 68.6406, 4.3008>, <-34.2196, 70.8803, 0.1965> }
					triangle { <-33.613, 67.7127, 1.3039>, <-34.2196, 70.8803, 0.1965>, <-35.4753, 68.6406, 4.3008> }
					triangle { <-31.8738, 65.7802, 4.6465>, <-35.4753, 68.6406, 4.3008>, <-33.613, 67.7127, 1.3039> }
					triangle { <-31.8738, 65.7802, 4.6465>, <-33.613, 67.7127, 1.3039>, <-35.4753, 68.6406, 4.3008> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-33.06452, 69.4784, 1.924>, <-35.05507, 69.2832, -0.8377>, <-30.2778, 68.9433, -2.08379> }
					triangle { <-33.06452, 69.4784, 1.924>, <-30.2778, 68.9433, -2.08379>, <-35.05507, 69.2832, -0.8377> }
					triangle { <-37.5681, 71.7459, 0.9353>, <-37.1786, 72.3385, -2.9185>, <-35.05507, 69.2832, -0.8377> }
					triangle { <-37.5681, 71.7459, 0.9353>, <-35.05507, 69.2832, -0.8377>, <-37.1786, 72.3385, -2.9185> }
					triangle { <-35.05507, 69.2832, -0.8377>, <-35.8638, 71.1597, 3.5511>, <-37.5681, 71.7459, 0.9353> }
					triangle { <-35.05507, 69.2832, -0.8377>, <-37.5681, 71.7459, 0.9353>, <-35.8638, 71.1597, 3.5511> }
					triangle { <-33.06452, 69.4784, 1.924>, <-35.8638, 71.1597, 3.5511>, <-35.05507, 69.2832, -0.8377> }
					triangle { <-33.06452, 69.4784, 1.924>, <-35.05507, 69.2832, -0.8377>, <-35.8638, 71.1597, 3.5511> }
					triangle { <-31.5445, 72.4245, 4.559>, <-35.8638, 71.1597, 3.5511>, <-33.06452, 69.4784, 1.924> }
					triangle { <-31.5445, 72.4245, 4.559>, <-33.06452, 69.4784, 1.924>, <-35.8638, 71.1597, 3.5511> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-33.8631, 70.8182, 0.6992>, <-34.4589, 67.5075, 0.1404>, <-30.2778, 68.9433, -2.08379> }
					triangle { <-33.8631, 70.8182, 0.6992>, <-30.2778, 68.9433, -2.08379>, <-34.4589, 67.5075, 0.1404> }
					triangle { <-38.3164, 68.3093, 0.1741>, <-37.2521, 65.6178, -2.4675>, <-34.4589, 67.5075, 0.1404> }
					triangle { <-38.3164, 68.3093, 0.1741>, <-34.4589, 67.5075, 0.1404>, <-37.2521, 65.6178, -2.4675> }
					triangle { <-34.4589, 67.5075, 0.1404>, <-37.4387, 71.1241, 1.3562>, <-38.3164, 68.3093, 0.1741> }
					triangle { <-34.4589, 67.5075, 0.1404>, <-38.3164, 68.3093, 0.1741>, <-37.4387, 71.1241, 1.3562> }
					triangle { <-33.8631, 70.8182, 0.6992>, <-37.4387, 71.1241, 1.3562>, <-34.4589, 67.5075, 0.1404> }
					triangle { <-33.8631, 70.8182, 0.6992>, <-34.4589, 67.5075, 0.1404>, <-37.4387, 71.1241, 1.3562> }
					triangle { <-35.1948, 74.5818, -0.7128>, <-37.4387, 71.1241, 1.3562>, <-33.8631, 70.8182, 0.6992> }
					triangle { <-35.1948, 74.5818, -0.7128>, <-33.8631, 70.8182, 0.6992>, <-37.4387, 71.1241, 1.3562> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <-20.1821, 64.7918, -6.5927>, <-21.4318, 66.4052, -6.8772>, 0.2809 }
			cylinder { <-21.4318, 66.4052, -6.8772>, <-22.6815, 68.01853, -7.1618>, 0.2809 }
			cylinder { <-22.6815, 68.01853, -7.1618>, <-23.9312, 69.6318, -7.4463>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-23.9312, 69.6318, -7.4463>, <-25.08437, 73.5349, -8.09294>, 0.2809 }
				cylinder { <-25.08437, 73.5349, -8.09294>, <-24.7368, 77.5913, -8.7304>, 0.2809 }
				cylinder { <-24.7368, 77.5913, -8.7304>, <-22.935, 81.2575, -9.2734>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-22.1719, 86.1046, -9.077>, <-19.3996, 84.5578, -10.3218>, <-22.935, 81.2575, -9.2734> }
					triangle { <-22.1719, 86.1046, -9.077>, <-22.935, 81.2575, -9.2734>, <-19.3996, 84.5578, -10.3218> }
					triangle { <-17.206, 87.3244, -8.5731>, <-15.6486, 83.7301, -8.4728>, <-19.3996, 84.5578, -10.3218> }
					triangle { <-17.206, 87.3244, -8.5731>, <-19.3996, 84.5578, -10.3218>, <-15.6486, 83.7301, -8.4728> }
					triangle { <-19.3996, 84.5578, -10.3218>, <-19.9581, 88.8598, -8.1728>, <-17.206, 87.3244, -8.5731> }
					triangle { <-19.3996, 84.5578, -10.3218>, <-17.206, 87.3244, -8.5731>, <-19.9581, 88.8598, -8.1728> }
					triangle { <-22.1719, 86.1046, -9.077>, <-19.9581, 88.8598, -8.1728>, <-19.3996, 84.5578, -10.3218> }
					triangle { <-22.1719, 86.1046, -9.077>, <-19.3996, 84.5578, -10.3218>, <-19.9581, 88.8598, -8.1728> }
					triangle { <-23.5155, 87.7987, -5.4359>, <-19.9581, 88.8598, -8.1728>, <-22.1719, 86.1046, -9.077> }
					triangle { <-23.5155, 87.7987, -5.4359>, <-22.1719, 86.1046, -9.077>, <-19.9581, 88.8598, -8.1728> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-20.537, 85.4218, -8.2619>, <-20.9125, 85.1066, -11.6365>, <-22.935, 81.2575, -9.2734> }
					triangle { <-20.537, 85.4218, -8.2619>, <-22.935, 81.2575, -9.2734>, <-20.9125, 85.1066, -11.6365> }
					triangle { <-17.4438, 86.9218, -12.08089>, <-18.07948, 84.01309, -14.6284>, <-20.9125, 85.1066, -11.6365> }
					triangle { <-17.4438, 86.9218, -12.08089>, <-20.9125, 85.1066, -11.6365>, <-18.07948, 84.01309, -14.6284> }
					triangle { <-20.9125, 85.1066, -11.6365>, <-17.7439, 87.6487, -9.003066>, <-17.4438, 86.9218, -12.08089> }
					triangle { <-20.9125, 85.1066, -11.6365>, <-17.4438, 86.9218, -12.08089>, <-17.7439, 87.6487, -9.003066> }
					triangle { <-20.537, 85.4218, -8.2619>, <-17.7439, 87.6487, -9.003066>, <-20.9125, 85.1066, -11.6365> }
					triangle { <-20.537, 85.4218, -8.2619>, <-20.9125, 85.1066, -11.6365>, <-17.7439, 87.6487, -9.003066> }
					triangle { <-17.5387, 84.8784, -5.3213>, <-17.7439, 87.6487, -9.003066>, <-20.537, 85.4218, -8.2619> }
					triangle { <-17.5387, 84.8784, -5.3213>, <-20.537, 85.4218, -8.2619>, <-17.7439, 87.6487, -9.003066> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-19.4211, 84.6647, -9.6707>, <-22.429, 86.01385, -10.5429>, <-22.935, 81.2575, -9.2734> }
					triangle { <-19.4211, 84.6647, -9.6707>, <-22.935, 81.2575, -9.2734>, <-22.429, 86.01385, -10.5429> }
					triangle { <-20.532, 88.2815, -13.1474>, <-24.00655, 86.9614, -14.3884>, <-22.429, 86.01385, -10.5429> }
					triangle { <-20.532, 88.2815, -13.1474>, <-22.429, 86.01385, -10.5429>, <-24.00655, 86.9614, -14.3884> }
					triangle { <-22.429, 86.01385, -10.5429>, <-17.9022, 87.3364, -11.6367>, <-20.532, 88.2815, -13.1474> }
					triangle { <-22.429, 86.01385, -10.5429>, <-20.532, 88.2815, -13.1474>, <-17.9022, 87.3364, -11.6367> }
					triangle { <-19.4211, 84.6647, -9.6707>, <-17.9022, 87.3364, -11.6367>, <-22.429, 86.01385, -10.5429> }
					triangle { <-19.4211, 84.6647, -9.6707>, <-22.429, 86.01385, -10.5429>, <-17.9022, 87.3364, -11.6367> }
					triangle { <-15.9324, 83.1671, -11.5465>, <-17.9022, 87.3364, -11.6367>, <-19.4211, 84.6647, -9.6707> }
					triangle { <-15.9324, 83.1671, -11.5465>, <-19.4211, 84.6647, -9.6707>, <-17.9022, 87.3364, -11.6367> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-20.3559, 84.8725, -11.3697>, <-21.8674, 86.03416, -8.5423>, <-22.935, 81.2575, -9.2734> }
					triangle { <-20.3559, 84.8725, -11.3697>, <-22.935, 81.2575, -9.2734>, <-21.8674, 86.03416, -8.5423> }
					triangle { <-22.2316, 89.5371, -10.3088>, <-25.2941, 88.5282, -8.08223>, <-21.8674, 86.03416, -8.5423> }
					triangle { <-22.2316, 89.5371, -10.3088>, <-21.8674, 86.03416, -8.5423>, <-25.2941, 88.5282, -8.08223> }
					triangle { <-21.8674, 86.03416, -8.5423>, <-20.2157, 88.3517, -12.4587>, <-22.2316, 89.5371, -10.3088> }
					triangle { <-21.8674, 86.03416, -8.5423>, <-22.2316, 89.5371, -10.3088>, <-20.2157, 88.3517, -12.4587> }
					triangle { <-20.3559, 84.8725, -11.3697>, <-20.2157, 88.3517, -12.4587>, <-21.8674, 86.03416, -8.5423> }
					triangle { <-20.3559, 84.8725, -11.3697>, <-21.8674, 86.03416, -8.5423>, <-20.2157, 88.3517, -12.4587> }
					triangle { <-20.9014, 85.01371, -15.5667>, <-20.2157, 88.3517, -12.4587>, <-20.3559, 84.8725, -11.3697> }
					triangle { <-20.9014, 85.01371, -15.5667>, <-20.3559, 84.8725, -11.3697>, <-20.2157, 88.3517, -12.4587> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-22.0817, 85.7758, -10.9972>, <-19.9669, 85.1207, -8.4036>, <-22.935, 81.2575, -9.2734> }
					triangle { <-22.0817, 85.7758, -10.9972>, <-22.935, 81.2575, -9.2734>, <-19.9669, 85.1207, -8.4036> }
					triangle { <-20.145, 88.9367, -7.439>, <-20.05069, 86.5009, -4.371>, <-19.9669, 85.1207, -8.4036> }
					triangle { <-20.145, 88.9367, -7.439>, <-19.9669, 85.1207, -8.4036>, <-20.05069, 86.5009, -4.371> }
					triangle { <-19.9669, 85.1207, -8.4036>, <-21.5055, 89.3074, -10.2856>, <-20.145, 88.9367, -7.439> }
					triangle { <-19.9669, 85.1207, -8.4036>, <-20.145, 88.9367, -7.439>, <-21.5055, 89.3074, -10.2856> }
					triangle { <-22.0817, 85.7758, -10.9972>, <-21.5055, 89.3074, -10.2856>, <-19.9669, 85.1207, -8.4036> }
					triangle { <-22.0817, 85.7758, -10.9972>, <-19.9669, 85.1207, -8.4036>, <-21.5055, 89.3074, -10.2856> }
					triangle { <-25.6588, 87.9194, -11.7331>, <-21.5055, 89.3074, -10.2856>, <-22.0817, 85.7758, -10.9972> }
					triangle { <-25.6588, 87.9194, -11.7331>, <-22.0817, 85.7758, -10.9972>, <-21.5055, 89.3074, -10.2856> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <-23.9312, 69.6318, -7.4463>, <-25.1808, 71.2451, -7.7308>, 0.2809 }
			cylinder { <-25.1808, 71.2451, -7.7308>, <-26.4305, 72.8584, -8.01539>, 0.2809 }
			cylinder { <-26.4305, 72.8584, -8.01539>, <-27.6802, 74.4718, -8.2999>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-27.6802, 74.4718, -8.2999>, <-30.8635, 76.6644, -9.7285>, 0.2809 }
				cylinder { <-30.8635, 76.6644, -9.7285>, <-34.3042, 77.5291, -11.8252>, 0.2809 }
				cylinder { <-34.3042, 77.5291, -11.8252>, <-37.5411, 76.9501, -14.3089>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-41.04382, 77.8735, -17.6246>, <-41.02325, 74.5467, -16.8759>, <-37.5411, 76.9501, -14.3089> }
					triangle { <-41.04382, 77.8735, -17.6246>, <-37.5411, 76.9501, -14.3089>, <-41.02325, 74.5467, -16.8759> }
					triangle { <-42.1, 73.8158, -20.5948>, <-39.5509, 71.2326, -19.117>, <-41.02325, 74.5467, -16.8759> }
					triangle { <-42.1, 73.8158, -20.5948>, <-41.02325, 74.5467, -16.8759>, <-39.5509, 71.2326, -19.117> }
					triangle { <-41.02325, 74.5467, -16.8759>, <-42.6815, 76.9351, -20.7467>, <-42.1, 73.8158, -20.5948> }
					triangle { <-41.02325, 74.5467, -16.8759>, <-42.1, 73.8158, -20.5948>, <-42.6815, 76.9351, -20.7467> }
					triangle { <-41.04382, 77.8735, -17.6246>, <-42.6815, 76.9351, -20.7467>, <-41.02325, 74.5467, -16.8759> }
					triangle { <-41.04382, 77.8735, -17.6246>, <-41.02325, 74.5467, -16.8759>, <-42.6815, 76.9351, -20.7467> }
					triangle { <-39.7068, 80.4594, -20.6999>, <-42.6815, 76.9351, -20.7467>, <-41.04382, 77.8735, -17.6246> }
					triangle { <-39.7068, 80.4594, -20.6999>, <-41.04382, 77.8735, -17.6246>, <-42.6815, 76.9351, -20.7467> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-40.1595, 76.3259, -18.4162>, <-42.1569, 75.829, -15.6974>, <-37.5411, 76.9501, -14.3089> }
					triangle { <-40.1595, 76.3259, -18.4162>, <-37.5411, 76.9501, -14.3089>, <-42.1569, 75.829, -15.6974> }
					triangle { <-44.1365, 73.1346, -17.782>, <-43.6485, 72.2116, -14.00519>, <-42.1569, 75.829, -15.6974> }
					triangle { <-44.1365, 73.1346, -17.782>, <-42.1569, 75.829, -15.6974>, <-43.6485, 72.2116, -14.00519> }
					triangle { <-42.1569, 75.829, -15.6974>, <-42.5727, 74.322, -20.2793>, <-44.1365, 73.1346, -17.782> }
					triangle { <-42.1569, 75.829, -15.6974>, <-44.1365, 73.1346, -17.782>, <-42.5727, 74.322, -20.2793> }
					triangle { <-40.1595, 76.3259, -18.4162>, <-42.5727, 74.322, -20.2793>, <-42.1569, 75.829, -15.6974> }
					triangle { <-40.1595, 76.3259, -18.4162>, <-42.1569, 75.829, -15.6974>, <-42.5727, 74.322, -20.2793> }
					triangle { <-38.08712, 74.03583, -21.3132>, <-42.5727, 74.322, -20.2793>, <-40.1595, 76.3259, -18.4162> }
					triangle { <-38.08712, 74.03583, -21.3132>, <-40.1595, 76.3259, -18.4162>, <-42.5727, 74.322, -20.2793> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-40.6623, 74.744, -17.3922>, <-41.9359, 77.759, -16.4353>, <-37.5411, 76.9501, -14.3089> }
					triangle { <-40.6623, 74.744, -17.3922>, <-37.5411, 76.9501, -14.3089>, <-41.9359, 77.759, -16.4353> }
					triangle { <-45.5404, 76.1843, -16.6634>, <-45.05567, 78.6765, -13.6785>, <-41.9359, 77.759, -16.4353> }
					triangle { <-45.5404, 76.1843, -16.6634>, <-41.9359, 77.759, -16.4353>, <-45.05567, 78.6765, -13.6785> }
					triangle { <-41.9359, 77.759, -16.4353>, <-44.09652, 73.7887, -18.1692>, <-45.5404, 76.1843, -16.6634> }
					triangle { <-41.9359, 77.759, -16.4353>, <-45.5404, 76.1843, -16.6634>, <-44.09652, 73.7887, -18.1692> }
					triangle { <-40.6623, 74.744, -17.3922>, <-44.09652, 73.7887, -18.1692>, <-41.9359, 77.759, -16.4353> }
					triangle { <-40.6623, 74.744, -17.3922>, <-41.9359, 77.759, -16.4353>, <-44.09652, 73.7887, -18.1692> }
					triangle { <-41.1735, 70.6365, -16.4984>, <-44.09652, 73.7887, -18.1692>, <-40.6623, 74.744, -17.3922> }
					triangle { <-41.1735, 70.6365, -16.4984>, <-40.6623, 74.744, -17.3922>, <-44.09652, 73.7887, -18.1692> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-41.8619, 75.2992, -15.9583>, <-40.6636, 77.6876, -18.07681>, <-37.5411, 76.9501, -14.3089> }
					triangle { <-41.8619, 75.2992, -15.9583>, <-37.5411, 76.9501, -14.3089>, <-40.6636, 77.6876, -18.07681> }
					triangle { <-44.3847, 78.7788, -18.7743>, <-41.8407, 81.7532, -18.5855>, <-40.6636, 77.6876, -18.07681> }
					triangle { <-44.3847, 78.7788, -18.7743>, <-40.6636, 77.6876, -18.07681>, <-41.8407, 81.7532, -18.5855> }
					triangle { <-40.6636, 77.6876, -18.07681>, <-45.1612, 76.0673, -17.3128>, <-44.3847, 78.7788, -18.7743> }
					triangle { <-40.6636, 77.6876, -18.07681>, <-44.3847, 78.7788, -18.7743>, <-45.1612, 76.0673, -17.3128> }
					triangle { <-41.8619, 75.2992, -15.9583>, <-45.1612, 76.0673, -17.3128>, <-40.6636, 77.6876, -18.07681> }
					triangle { <-41.8619, 75.2992, -15.9583>, <-40.6636, 77.6876, -18.07681>, <-45.1612, 76.0673, -17.3128> }
					triangle { <-44.7295, 74.9275, -12.8646>, <-45.1612, 76.0673, -17.3128>, <-41.8619, 75.2992, -15.9583> }
					triangle { <-44.7295, 74.9275, -12.8646>, <-41.8619, 75.2992, -15.9583>, <-45.1612, 76.0673, -17.3128> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-42.1012, 77.2625, -16.1041>, <-40.09102, 75.6723, -18.3532>, <-37.5411, 76.9501, -14.3089> }
					triangle { <-42.1012, 77.2625, -16.1041>, <-37.5411, 76.9501, -14.3089>, <-40.09102, 75.6723, -18.3532> }
					triangle { <-42.2263, 77.2929, -21.2408>, <-38.3872, 77.08326, -21.9974>, <-40.09102, 75.6723, -18.3532> }
					triangle { <-42.2263, 77.2929, -21.2408>, <-40.09102, 75.6723, -18.3532>, <-38.3872, 77.08326, -21.9974> }
					triangle { <-40.09102, 75.6723, -18.3532>, <-44.2735, 78.04126, -18.9299>, <-42.2263, 77.2929, -21.2408> }
					triangle { <-40.09102, 75.6723, -18.3532>, <-42.2263, 77.2929, -21.2408>, <-44.2735, 78.04126, -18.9299> }
					triangle { <-42.1012, 77.2625, -16.1041>, <-44.2735, 78.04126, -18.9299>, <-40.09102, 75.6723, -18.3532> }
					triangle { <-42.1012, 77.2625, -16.1041>, <-40.09102, 75.6723, -18.3532>, <-44.2735, 78.04126, -18.9299> }
					triangle { <-43.8093, 81.09011, -15.5004>, <-44.2735, 78.04126, -18.9299>, <-42.1012, 77.2625, -16.1041> }
					triangle { <-43.8093, 81.09011, -15.5004>, <-42.1012, 77.2625, -16.1041>, <-44.2735, 78.04126, -18.9299> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		}
	union { // Internode
		cylinder { <2.1406, 32.08055, -0.7012>, <2.5916, 37.5618, -0.6523>, 0.5 }
		cylinder { <2.5916, 37.5618, -0.6523>, <3.3532, 42.987, -0.1655>, 0.5 }
		cylinder { <3.3532, 42.987, -0.1655>, <4.4179, 48.3039, 0.7545>, 0.5 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <4.4179, 48.3039, 0.7545>, <6.9921, 54.3568, 3.6967>, 0.4912 }
			cylinder { <6.9921, 54.3568, 3.6967>, <10.4857, 58.8857, 8.07902>, 0.4912 }
			cylinder { <10.4857, 58.8857, 8.07902>, <14.5461, 61.4336, 13.4588>, 0.4912 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <14.5461, 61.4336, 13.4588>, <15.7723, 62.1482, 15.08934>, 0.4912 }
				cylinder { <15.7723, 62.1482, 15.08934>, <17.00598, 62.8127, 16.7354>, 0.4912 }
				cylinder { <17.00598, 62.8127, 16.7354>, <18.2462, 63.4265, 18.396>, 0.4912 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <18.2462, 63.4265, 18.396>, <20.4244, 64.1552, 20.05286>, 0.193 }
				cylinder { <20.4244, 64.1552, 20.05286>, <22.9981, 64.7555, 21.07078>, 0.193 }
				cylinder { <22.9981, 64.7555, 21.07078>, <25.7808, 65.1839, 21.376>, 0.193 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <25.7808, 65.1839, 21.376>, <16.118, 73.6282, 9.3717>, <27.7811, 76.9969, 6.6195> }
				triangle { <25.7808, 65.1839, 21.376>, <27.7811, 76.9969, 6.6195>, <16.118, 73.6282, 9.3717> }
				triangle { <25.7808, 65.1839, 21.376>, <27.7811, 76.9969, 6.6195>, <48.8477, 78.8244, 12.5594> }
				triangle { <25.7808, 65.1839, 21.376>, <48.8477, 78.8244, 12.5594>, <27.7811, 76.9969, 6.6195> }
				triangle { <25.7808, 65.1839, 21.376>, <48.8477, 78.8244, 12.5594>, <59.6799, 75.3008, 27.05278> }
				triangle { <25.7808, 65.1839, 21.376>, <59.6799, 75.3008, 27.05278>, <48.8477, 78.8244, 12.5594> }
				triangle { <25.7808, 65.1839, 21.376>, <59.6799, 75.3008, 27.05278>, <47.1089, 67.8595, 39.7848> }
				triangle { <25.7808, 65.1839, 21.376>, <47.1089, 67.8595, 39.7848>, <59.6799, 75.3008, 27.05278> }
				triangle { <25.7808, 65.1839, 21.376>, <47.1089, 67.8595, 39.7848>, <26.1192, 63.2122, 41.1106> }
				triangle { <25.7808, 65.1839, 21.376>, <26.1192, 63.2122, 41.1106>, <47.1089, 67.8595, 39.7848> }
				triangle { <25.7808, 65.1839, 21.376>, <26.1192, 63.2122, 41.1106>, <15.306, 63.4352, 35.08612> }
				triangle { <25.7808, 65.1839, 21.376>, <15.306, 63.4352, 35.08612>, <26.1192, 63.2122, 41.1106> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <18.2462, 63.4265, 18.396>, <19.4924, 63.9895, 20.0703>, 0.4912 }
				cylinder { <19.4924, 63.9895, 20.0703>, <20.7437, 64.5011, 21.7571>, 0.4912 }
				cylinder { <20.7437, 64.5011, 21.7571>, <21.9994, 64.9611, 23.4554>, 0.4912 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <21.9994, 64.9611, 23.4554>, <22.9727, 65.5885, 26.03994>, 0.193 }
				cylinder { <22.9727, 65.5885, 26.03994>, <23.2038, 66.1949, 28.7966>, 0.193 }
				cylinder { <23.2038, 66.1949, 28.7966>, <22.6758, 66.7367, 31.5257>, 0.193 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <22.6758, 66.7367, 31.5257>, <31.3677, 77.9137, 21.1186>, <32.3983, 83.04598, 32.4124> }
				triangle { <22.6758, 66.7367, 31.5257>, <32.3983, 83.04598, 32.4124>, <31.3677, 77.9137, 21.1186> }
				triangle { <22.6758, 66.7367, 31.5257>, <32.3983, 83.04598, 32.4124>, <25.4824, 84.5714, 53.2035> }
				triangle { <22.6758, 66.7367, 31.5257>, <25.4824, 84.5714, 53.2035>, <32.3983, 83.04598, 32.4124> }
				triangle { <22.6758, 66.7367, 31.5257>, <25.4824, 84.5714, 53.2035>, <12.7242, 77.2361, 64.3046> }
				triangle { <22.6758, 66.7367, 31.5257>, <12.7242, 77.2361, 64.3046>, <25.4824, 84.5714, 53.2035> }
				triangle { <22.6758, 66.7367, 31.5257>, <12.7242, 77.2361, 64.3046>, <3.7575, 64.7726, 52.4821> }
				triangle { <22.6758, 66.7367, 31.5257>, <3.7575, 64.7726, 52.4821>, <12.7242, 77.2361, 64.3046> }
				triangle { <22.6758, 66.7367, 31.5257>, <3.7575, 64.7726, 52.4821>, <4.8208, 58.1109, 32.02699> }
				triangle { <22.6758, 66.7367, 31.5257>, <4.8208, 58.1109, 32.02699>, <3.7575, 64.7726, 52.4821> }
				triangle { <22.6758, 66.7367, 31.5257>, <4.8208, 58.1109, 32.02699>, <10.7644, 59.4401, 21.2484> }
				triangle { <22.6758, 66.7367, 31.5257>, <10.7644, 59.4401, 21.2484>, <4.8208, 58.1109, 32.02699> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <21.9994, 64.9611, 23.4554>, <23.6445, 65.5638, 25.6805>, 0.193 }
				cylinder { <23.6445, 65.5638, 25.6805>, <25.2896, 66.1665, 27.9055>, 0.193 }
				cylinder { <25.2896, 66.1665, 27.9055>, <26.9347, 66.7692, 30.1305>, 0.193 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <26.9347, 66.7692, 30.1305>, <26.9719, 76.3519, 15.4012>, <36.3722, 81.134, 22.01325> }
				triangle { <26.9347, 66.7692, 30.1305>, <36.3722, 81.134, 22.01325>, <26.9719, 76.3519, 15.4012> }
				triangle { <26.9347, 66.7692, 30.1305>, <36.3722, 81.134, 22.01325>, <46.5716, 83.6663, 41.3001> }
				triangle { <26.9347, 66.7692, 30.1305>, <46.5716, 83.6663, 41.3001>, <36.3722, 81.134, 22.01325> }
				triangle { <26.9347, 66.7692, 30.1305>, <46.5716, 83.6663, 41.3001>, <44.7081, 78.5675, 58.9165> }
				triangle { <26.9347, 66.7692, 30.1305>, <44.7081, 78.5675, 58.9165>, <46.5716, 83.6663, 41.3001> }
				triangle { <26.9347, 66.7692, 30.1305>, <44.7081, 78.5675, 58.9165>, <28.508, 67.9486, 58.3628> }
				triangle { <26.9347, 66.7692, 30.1305>, <28.508, 67.9486, 58.3628>, <44.7081, 78.5675, 58.9165> }
				triangle { <26.9347, 66.7692, 30.1305>, <28.508, 67.9486, 58.3628>, <13.8446, 61.3721, 44.02215> }
				triangle { <26.9347, 66.7692, 30.1305>, <13.8446, 61.3721, 44.02215>, <28.508, 67.9486, 58.3628> }
				triangle { <26.9347, 66.7692, 30.1305>, <13.8446, 61.3721, 44.02215>, <10.4583, 61.7374, 32.1196> }
				triangle { <26.9347, 66.7692, 30.1305>, <10.4583, 61.7374, 32.1196>, <13.8446, 61.3721, 44.02215> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <4.4179, 48.3039, 0.7545>, <5.9509, 52.4795, 2.4464>, 0.4326 }
		cylinder { <5.9509, 52.4795, 2.4464>, <8.003843, 55.9798, 4.9329>, 0.4326 }
		cylinder { <8.003843, 55.9798, 4.9329>, <10.4534, 58.5949, 8.0648>, 0.4326 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <10.4534, 58.5949, 8.0648>, <12.6454, 59.585, 11.00968>, 0.2592 }
			cylinder { <12.6454, 59.585, 11.00968>, <14.8508, 59.376, 14.09992>, 0.2592 }
			cylinder { <14.8508, 59.376, 14.09992>, <16.8471, 57.9888, 17.02358>, 0.2592 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <16.8471, 57.9888, 17.02358>, <17.4385, 57.5468, 17.893>, 0.2592 }
				cylinder { <17.4385, 57.5468, 17.893>, <18.02217, 57.07923, 18.7543>, 0.2592 }
				cylinder { <18.02217, 57.07923, 18.7543>, <18.5976, 56.5862, 19.6069>, 0.2592 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <18.5976, 56.5862, 19.6069>, <19.1515, 56.2448, 20.05252>, 0.05376 }
				cylinder { <19.1515, 56.2448, 20.05252>, <19.8213, 55.9276, 20.3219>, 0.05376 }
				cylinder { <19.8213, 55.9276, 20.3219>, <20.5584, 55.6575, 20.3956>, 0.05376 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <20.5584, 55.6575, 20.3956>, <18.6349, 64.413, 18.02483>, <25.1523, 64.02161, 17.3065> }
				triangle { <20.5584, 55.6575, 20.3956>, <25.1523, 64.02161, 17.3065>, <18.6349, 64.413, 18.02483> }
				triangle { <20.5584, 55.6575, 20.3956>, <25.1523, 64.02161, 17.3065>, <35.1326, 58.5676, 19.5377> }
				triangle { <20.5584, 55.6575, 20.3956>, <35.1326, 58.5676, 19.5377>, <25.1523, 64.02161, 17.3065> }
				triangle { <20.5584, 55.6575, 20.3956>, <35.1326, 58.5676, 19.5377>, <38.3858, 50.7866, 24.3845> }
				triangle { <20.5584, 55.6575, 20.3956>, <38.3858, 50.7866, 24.3845>, <35.1326, 58.5676, 19.5377> }
				triangle { <20.5584, 55.6575, 20.3956>, <38.3858, 50.7866, 24.3845>, <29.7573, 46.9598, 28.317> }
				triangle { <20.5584, 55.6575, 20.3956>, <29.7573, 46.9598, 28.317>, <38.3858, 50.7866, 24.3845> }
				triangle { <20.5584, 55.6575, 20.3956>, <29.7573, 46.9598, 28.317>, <18.6238, 49.2423, 28.4367> }
				triangle { <20.5584, 55.6575, 20.3956>, <18.6238, 49.2423, 28.4367>, <29.7573, 46.9598, 28.317> }
				triangle { <20.5584, 55.6575, 20.3956>, <18.6238, 49.2423, 28.4367>, <13.9898, 53.3363, 26.3291> }
				triangle { <20.5584, 55.6575, 20.3956>, <13.9898, 53.3363, 26.3291>, <18.6238, 49.2423, 28.4367> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <18.5976, 56.5862, 19.6069>, <19.1645, 56.06825, 20.4504>, 0.2592 }
				cylinder { <19.1645, 56.06825, 20.4504>, <19.7227, 55.5255, 21.2841>, 0.2592 }
				cylinder { <19.7227, 55.5255, 21.2841>, <20.2716, 54.9583, 22.1076>, 0.2592 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <20.2716, 54.9583, 22.1076>, <20.4669, 54.5934, 22.7788>, 0.05376 }
				cylinder { <20.4669, 54.5934, 22.7788>, <20.4638, 54.2821, 23.5033>, 0.05376 }
				cylinder { <20.4638, 54.2821, 23.5033>, <20.2626, 54.04687, 24.2286>, 0.05376 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <20.2626, 54.04687, 24.2286>, <27.5711, 59.507, 22.57>, <28.1161, 58.1083, 28.9647> }
				triangle { <20.2626, 54.04687, 24.2286>, <28.1161, 58.1083, 28.9647>, <27.5711, 59.507, 22.57> }
				triangle { <20.2626, 54.04687, 24.2286>, <28.1161, 58.1083, 28.9647>, <23.3007, 54.3109, 38.7995> }
				triangle { <20.2626, 54.04687, 24.2286>, <23.3007, 54.3109, 38.7995>, <28.1161, 58.1083, 28.9647> }
				triangle { <20.2626, 54.04687, 24.2286>, <23.3007, 54.3109, 38.7995>, <14.7443, 51.02607, 42.05764> }
				triangle { <20.2626, 54.04687, 24.2286>, <14.7443, 51.02607, 42.05764>, <23.3007, 54.3109, 38.7995> }
				triangle { <20.2626, 54.04687, 24.2286>, <14.7443, 51.02607, 42.05764>, <8.9659, 51.3962, 33.6295> }
				triangle { <20.2626, 54.04687, 24.2286>, <8.9659, 51.3962, 33.6295>, <14.7443, 51.02607, 42.05764> }
				triangle { <20.2626, 54.04687, 24.2286>, <8.9659, 51.3962, 33.6295>, <9.9132, 54.336, 22.6915> }
				triangle { <20.2626, 54.04687, 24.2286>, <9.9132, 54.336, 22.6915>, <8.9659, 51.3962, 33.6295> }
				triangle { <20.2626, 54.04687, 24.2286>, <9.9132, 54.336, 22.6915>, <13.9665, 56.6317, 18.1114> }
				triangle { <20.2626, 54.04687, 24.2286>, <13.9665, 56.6317, 18.1114>, <9.9132, 54.336, 22.6915> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <20.2716, 54.9583, 22.1076>, <20.6511, 54.5663, 22.6769>, 0.05376 }
				cylinder { <20.6511, 54.5663, 22.6769>, <21.03058, 54.1742, 23.2462>, 0.05376 }
				cylinder { <21.03058, 54.1742, 23.2462>, <21.41, 53.7821, 23.8156>, 0.05376 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <21.41, 53.7821, 23.8156>, <24.6125, 61.684, 20.1708>, <29.5157, 59.685, 24.05775> }
				triangle { <21.41, 53.7821, 23.8156>, <29.5157, 59.685, 24.05775>, <24.6125, 61.684, 20.1708> }
				triangle { <21.41, 53.7821, 23.8156>, <29.5157, 59.685, 24.05775>, <33.2598, 53.05656, 32.797> }
				triangle { <21.41, 53.7821, 23.8156>, <33.2598, 53.05656, 32.797>, <29.5157, 59.685, 24.05775> }
				triangle { <21.41, 53.7821, 23.8156>, <33.2598, 53.05656, 32.797>, <29.8251, 46.4845, 39.09239> }
				triangle { <21.41, 53.7821, 23.8156>, <29.8251, 46.4845, 39.09239>, <33.2598, 53.05656, 32.797> }
				triangle { <21.41, 53.7821, 23.8156>, <29.8251, 46.4845, 39.09239>, <19.9645, 45.9383, 36.4409> }
				triangle { <21.41, 53.7821, 23.8156>, <19.9645, 45.9383, 36.4409>, <29.8251, 46.4845, 39.09239> }
				triangle { <21.41, 53.7821, 23.8156>, <19.9645, 45.9383, 36.4409>, <12.84, 50.539, 28.8745> }
				triangle { <21.41, 53.7821, 23.8156>, <12.84, 50.539, 28.8745>, <19.9645, 45.9383, 36.4409> }
				triangle { <21.41, 53.7821, 23.8156>, <12.84, 50.539, 28.8745>, <12.3124, 54.7643, 23.9201> }
				triangle { <21.41, 53.7821, 23.8156>, <12.3124, 54.7643, 23.9201>, <12.84, 50.539, 28.8745> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <10.4534, 58.5949, 8.0648>, <11.2726, 59.4777, 9.06688>, 0.1424 }
		cylinder { <11.2726, 59.4777, 9.06688>, <12.1039, 60.3818, 10.03942>, 0.1424 }
		cylinder { <12.1039, 60.3818, 10.03942>, <12.947, 61.3068, 10.9818>, 0.1424 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <12.947, 61.3068, 10.9818>, <13.5519, 62.03535, 11.305>, 0.06821 }
			cylinder { <13.5519, 62.03535, 11.305>, <14.1621, 62.8281, 11.3169>, 0.06821 }
			cylinder { <14.1621, 62.8281, 11.3169>, <14.7162, 63.6051, 11.0164>, 0.06821 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <14.7162, 63.6051, 11.0164>, <14.8803, 63.8369, 10.9192>, 0.06821 }
				cylinder { <14.8803, 63.8369, 10.9192>, <15.04244, 64.06718, 10.8152>, 0.06821 }
				cylinder { <15.04244, 64.06718, 10.8152>, <15.2022, 64.2957, 10.7044>, 0.06821 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <15.2022, 64.2957, 10.7044>, <15.2188, 64.3446, 10.6866>, 0.003722 }
				cylinder { <15.2188, 64.3446, 10.6866>, <15.2216, 64.3973, 10.6724>, 0.003722 }
				cylinder { <15.2216, 64.3973, 10.6724>, <15.2105, 64.4499, 10.6629>, 0.003722 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <15.2105, 64.4499, 10.6629>, <14.9756, 63.4273, 12.8658>, <14.3075, 65.00702, 13.07966> }
				triangle { <15.2105, 64.4499, 10.6629>, <14.3075, 65.00702, 13.07966>, <14.9756, 63.4273, 12.8658> }
				triangle { <15.2105, 64.4499, 10.6629>, <14.3075, 65.00702, 13.07966>, <14.00002, 67.8825, 12.111> }
				triangle { <15.2105, 64.4499, 10.6629>, <14.00002, 67.8825, 12.111>, <14.3075, 65.00702, 13.07966> }
				triangle { <15.2105, 64.4499, 10.6629>, <14.00002, 67.8825, 12.111>, <14.7846, 69.3843, 10.1925> }
				triangle { <15.2105, 64.4499, 10.6629>, <14.7846, 69.3843, 10.1925>, <14.00002, 67.8825, 12.111> }
				triangle { <15.2105, 64.4499, 10.6629>, <14.7846, 69.3843, 10.1925>, <16.3095, 67.7014, 8.7493> }
				triangle { <15.2105, 64.4499, 10.6629>, <16.3095, 67.7014, 8.7493>, <14.7846, 69.3843, 10.1925> }
				triangle { <15.2105, 64.4499, 10.6629>, <16.3095, 67.7014, 8.7493>, <17.2129, 64.8512, 8.8149> }
				triangle { <15.2105, 64.4499, 10.6629>, <17.2129, 64.8512, 8.8149>, <16.3095, 67.7014, 8.7493> }
				triangle { <15.2105, 64.4499, 10.6629>, <17.2129, 64.8512, 8.8149>, <17.1255, 63.3691, 9.6815> }
				triangle { <15.2105, 64.4499, 10.6629>, <17.1255, 63.3691, 9.6815>, <17.2129, 64.8512, 8.8149> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <15.2022, 64.2957, 10.7044>, <15.3621, 64.5243, 10.5936>, 0.06821 }
				cylinder { <15.3621, 64.5243, 10.5936>, <15.5219, 64.753, 10.4827>, 0.06821 }
				cylinder { <15.5219, 64.753, 10.4827>, <15.6817, 64.9816, 10.3719>, 0.06821 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <15.6817, 64.9816, 10.3719>, <15.7212, 65.01287, 10.3508>, 0.003722 }
				cylinder { <15.7212, 65.01287, 10.3508>, <15.7683, 65.03156, 10.3304>, 0.003722 }
				cylinder { <15.7683, 65.03156, 10.3304>, <15.8195, 65.0363, 10.3121>, 0.003722 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <15.8195, 65.0363, 10.3121>, <14.9357, 66.4, 12.1321>, <16.4904, 67.09104, 11.8267> }
				triangle { <15.8195, 65.0363, 10.3121>, <16.4904, 67.09104, 11.8267>, <14.9357, 66.4, 12.1321> }
				triangle { <15.8195, 65.0363, 10.3121>, <16.4904, 67.09104, 11.8267>, <19.2755, 66.8568, 10.6063> }
				triangle { <15.8195, 65.0363, 10.3121>, <19.2755, 66.8568, 10.6063>, <16.4904, 67.09104, 11.8267> }
				triangle { <15.8195, 65.0363, 10.3121>, <19.2755, 66.8568, 10.6063>, <20.6836, 65.1825, 9.2775> }
				triangle { <15.8195, 65.0363, 10.3121>, <20.6836, 65.1825, 9.2775>, <19.2755, 66.8568, 10.6063> }
				triangle { <15.8195, 65.0363, 10.3121>, <20.6836, 65.1825, 9.2775>, <18.9874, 63.1112, 9.008092> }
				triangle { <15.8195, 65.0363, 10.3121>, <18.9874, 63.1112, 9.008092>, <20.6836, 65.1825, 9.2775> }
				triangle { <15.8195, 65.0363, 10.3121>, <18.9874, 63.1112, 9.008092>, <16.1972, 62.3604, 9.78> }
				triangle { <15.8195, 65.0363, 10.3121>, <16.1972, 62.3604, 9.78>, <18.9874, 63.1112, 9.008092> }
				triangle { <15.8195, 65.0363, 10.3121>, <16.1972, 62.3604, 9.78>, <14.7739, 62.8848, 10.5888> }
				triangle { <15.8195, 65.0363, 10.3121>, <14.7739, 62.8848, 10.5888>, <16.1972, 62.3604, 9.78> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <15.6817, 64.9816, 10.3719>, <15.7108, 65.02319, 10.3517>, 0.003722 }
				cylinder { <15.7108, 65.02319, 10.3517>, <15.7399, 65.06478, 10.3316>, 0.003722 }
				cylinder { <15.7399, 65.06478, 10.3316>, <15.769, 65.1063, 10.3114>, 0.003722 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <15.769, 65.1063, 10.3114>, <14.7187, 65.1739, 12.5127>, <15.3119, 66.783, 12.2978> }
				triangle { <15.769, 65.1063, 10.3114>, <15.3119, 66.783, 12.2978>, <14.7187, 65.1739, 12.5127> }
				triangle { <15.769, 65.1063, 10.3114>, <15.3119, 66.783, 12.2978>, <17.1532, 68.7319, 10.8442> }
				triangle { <15.769, 65.1063, 10.3114>, <17.1532, 68.7319, 10.8442>, <15.3119, 66.783, 12.2978> }
				triangle { <15.769, 65.1063, 10.3114>, <17.1532, 68.7319, 10.8442>, <18.9069, 68.73, 8.9797> }
				triangle { <15.769, 65.1063, 10.3114>, <18.9069, 68.73, 8.9797>, <17.1532, 68.7319, 10.8442> }
				triangle { <15.769, 65.1063, 10.3114>, <18.9069, 68.73, 8.9797>, <18.9564, 66.1384, 8.2578> }
				triangle { <15.769, 65.1063, 10.3114>, <18.9564, 66.1384, 8.2578>, <18.9069, 68.73, 8.9797> }
				triangle { <15.769, 65.1063, 10.3114>, <18.9564, 66.1384, 8.2578>, <17.6329, 63.5608, 8.9987> }
				triangle { <15.769, 65.1063, 10.3114>, <17.6329, 63.5608, 8.9987>, <18.9564, 66.1384, 8.2578> }
				triangle { <15.769, 65.1063, 10.3114>, <17.6329, 63.5608, 8.9987>, <16.4779, 62.8217, 10.03548> }
				triangle { <15.769, 65.1063, 10.3114>, <16.4779, 62.8217, 10.03548>, <17.6329, 63.5608, 8.9987> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <12.947, 61.3068, 10.9818>, <16.2734, 64.9563, 14.7001>, 0.2809 }
			cylinder { <16.2734, 64.9563, 14.7001>, <19.5999, 68.6057, 18.4183>, 0.2809 }
			cylinder { <19.5999, 68.6057, 18.4183>, <22.9263, 72.2552, 22.1366>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <22.9263, 72.2552, 22.1366>, <24.03513, 73.4717, 23.376>, 0.2809 }
			cylinder { <24.03513, 73.4717, 23.376>, <25.1439, 74.6882, 24.6154>, 0.2809 }
			cylinder { <25.1439, 74.6882, 24.6154>, <26.2527, 75.9047, 25.8549>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <26.2527, 75.9047, 25.8549>, <29.5286, 77.3591, 27.8883>, 0.2809 }
				cylinder { <29.5286, 77.3591, 27.8883>, <33.4237, 77.6402, 29.2039>, 0.2809 }
				cylinder { <33.4237, 77.6402, 29.2039>, <37.4161, 76.7101, 29.6253>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <41.8439, 76.1779, 31.6813>, <41.8308, 74.7245, 28.5966>, <37.4161, 76.7101, 29.6253> }
					triangle { <41.8439, 76.1779, 31.6813>, <37.4161, 76.7101, 29.6253>, <41.8308, 74.7245, 28.5966> }
					triangle { <44.3495, 72.02789, 29.9781>, <41.6694, 70.609, 27.4964>, <41.8308, 74.7245, 28.5966> }
					triangle { <44.3495, 72.02789, 29.9781>, <41.8308, 74.7245, 28.5966>, <41.6694, 70.609, 27.4964> }
					triangle { <41.8308, 74.7245, 28.5966>, <44.6586, 73.9903, 32.457>, <44.3495, 72.02789, 29.9781> }
					triangle { <41.8308, 74.7245, 28.5966>, <44.3495, 72.02789, 29.9781>, <44.6586, 73.9903, 32.457> }
					triangle { <41.8439, 76.1779, 31.6813>, <44.6586, 73.9903, 32.457>, <41.8308, 74.7245, 28.5966> }
					triangle { <41.8439, 76.1779, 31.6813>, <41.8308, 74.7245, 28.5966>, <44.6586, 73.9903, 32.457> }
					triangle { <41.601, 75.02934, 35.7499>, <44.6586, 73.9903, 32.457>, <41.8439, 76.1779, 31.6813> }
					triangle { <41.601, 75.02934, 35.7499>, <41.8439, 76.1779, 31.6813>, <44.6586, 73.9903, 32.457> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <41.488, 74.366, 31.0538>, <42.2861, 76.7465, 28.7463>, <37.4161, 76.7101, 29.6253> }
					triangle { <41.488, 74.366, 31.0538>, <37.4161, 76.7101, 29.6253>, <42.2861, 76.7465, 28.7463> }
					triangle { <45.163, 74.3801, 27.4626>, <43.3097, 76.3497, 24.6269>, <42.2861, 76.7465, 28.7463> }
					triangle { <45.163, 74.3801, 27.4626>, <42.2861, 76.7465, 28.7463>, <43.3097, 76.3497, 24.6269> }
					triangle { <42.2861, 76.7465, 28.7463>, <44.6113, 72.7284, 30.1194>, <45.163, 74.3801, 27.4626> }
					triangle { <42.2861, 76.7465, 28.7463>, <45.163, 74.3801, 27.4626>, <44.6113, 72.7284, 30.1194> }
					triangle { <41.488, 74.366, 31.0538>, <44.6113, 72.7284, 30.1194>, <42.2861, 76.7465, 28.7463> }
					triangle { <41.488, 74.366, 31.0538>, <42.2861, 76.7465, 28.7463>, <44.6113, 72.7284, 30.1194> }
					triangle { <40.944, 70.1712, 31.2522>, <44.6113, 72.7284, 30.1194>, <41.488, 74.366, 31.0538> }
					triangle { <40.944, 70.1712, 31.2522>, <41.488, 74.366, 31.0538>, <44.6113, 72.7284, 30.1194> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <41.6868, 74.3404, 29.1138>, <42.2005, 77.2873, 30.7509>, <37.4161, 76.7101, 29.6253> }
					triangle { <41.6868, 74.3404, 29.1138>, <37.4161, 76.7101, 29.6253>, <42.2005, 77.2873, 30.7509> }
					triangle { <45.7289, 77.5111, 29.01178>, <43.8817, 80.9494, 29.3594>, <42.2005, 77.2873, 30.7509> }
					triangle { <45.7289, 77.5111, 29.01178>, <42.2005, 77.2873, 30.7509>, <43.8817, 80.9494, 29.3594> }
					triangle { <42.2005, 77.2873, 30.7509>, <45.22, 74.4783, 28.2152>, <45.7289, 77.5111, 29.01178> }
					triangle { <42.2005, 77.2873, 30.7509>, <45.7289, 77.5111, 29.01178>, <45.22, 74.4783, 28.2152> }
					triangle { <41.6868, 74.3404, 29.1138>, <45.22, 74.4783, 28.2152>, <42.2005, 77.2873, 30.7509> }
					triangle { <41.6868, 74.3404, 29.1138>, <42.2005, 77.2873, 30.7509>, <45.22, 74.4783, 28.2152> }
					triangle { <42.1734, 72.7211, 25.2314>, <45.22, 74.4783, 28.2152>, <41.6868, 74.3404, 29.1138> }
					triangle { <42.1734, 72.7211, 25.2314>, <41.6868, 74.3404, 29.1138>, <45.22, 74.4783, 28.2152> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <42.1673, 76.1362, 28.5243>, <41.6915, 75.6045, 31.8589>, <37.4161, 76.7101, 29.6253> }
					triangle { <42.1673, 76.1362, 28.5243>, <37.4161, 76.7101, 29.6253>, <41.6915, 75.6045, 31.8589> }
					triangle { <45.2704, 77.1231, 32.4992>, <42.6004, 78.0944, 35.1978>, <41.6915, 75.6045, 31.8589> }
					triangle { <45.2704, 77.1231, 32.4992>, <41.6915, 75.6045, 31.8589>, <42.6004, 78.0944, 35.1978> }
					triangle { <41.6915, 75.6045, 31.8589>, <45.6491, 76.8381, 29.3581>, <45.2704, 77.1231, 32.4992> }
					triangle { <41.6915, 75.6045, 31.8589>, <45.2704, 77.1231, 32.4992>, <45.6491, 76.8381, 29.3581> }
					triangle { <42.1673, 76.1362, 28.5243>, <45.6491, 76.8381, 29.3581>, <41.6915, 75.6045, 31.8589> }
					triangle { <42.1673, 76.1362, 28.5243>, <41.6915, 75.6045, 31.8589>, <45.6491, 76.8381, 29.3581> }
					triangle { <43.6018, 79.1789, 25.952>, <45.6491, 76.8381, 29.3581>, <42.1673, 76.1362, 28.5243> }
					triangle { <43.6018, 79.1789, 25.952>, <42.1673, 76.1362, 28.5243>, <45.6491, 76.8381, 29.3581> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <42.2659, 77.289, 30.1351>, <41.4596, 73.9967, 30.5073>, <37.4161, 76.7101, 29.6253> }
					triangle { <42.2659, 77.289, 30.1351>, <37.4161, 76.7101, 29.6253>, <41.4596, 73.9967, 30.5073> }
					triangle { <44.405, 73.6831, 33.1055>, <41.2125, 71.6071, 34.02913>, <41.4596, 73.9967, 30.5073> }
					triangle { <44.405, 73.6831, 33.1055>, <41.4596, 73.9967, 30.5073>, <41.2125, 71.6071, 34.02913> }
					triangle { <41.4596, 73.9967, 30.5073>, <45.2969, 76.5319, 32.01924>, <44.405, 73.6831, 33.1055> }
					triangle { <41.4596, 73.9967, 30.5073>, <44.405, 73.6831, 33.1055>, <45.2969, 76.5319, 32.01924> }
					triangle { <42.2659, 77.289, 30.1351>, <45.2969, 76.5319, 32.01924>, <41.4596, 73.9967, 30.5073> }
					triangle { <42.2659, 77.289, 30.1351>, <41.4596, 73.9967, 30.5073>, <45.2969, 76.5319, 32.01924> }
					triangle { <43.2427, 80.627, 32.5509>, <45.2969, 76.5319, 32.01924>, <42.2659, 77.289, 30.1351> }
					triangle { <43.2427, 80.627, 32.5509>, <42.2659, 77.289, 30.1351>, <45.2969, 76.5319, 32.01924> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <26.2527, 75.9047, 25.8549>, <27.3615, 77.1212, 27.09434>, 0.2809 }
			cylinder { <27.3615, 77.1212, 27.09434>, <28.4703, 78.3377, 28.3337>, 0.2809 }
			cylinder { <28.4703, 78.3377, 28.3337>, <29.5791, 79.5542, 29.5731>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <29.5791, 79.5542, 29.5731>, <30.9726, 83.01686, 31.3196>, 0.2809 }
				cylinder { <30.9726, 83.01686, 31.3196>, <31.3552, 87.04514, 32.09968>, 0.2809 }
				cylinder { <31.3552, 87.04514, 32.09968>, <30.6756, 91.09921, 31.8087>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <31.5217, 95.9364, 31.7988>, <28.3465, 95.3264, 30.7152>, <30.6756, 91.09921, 31.8087> }
					triangle { <31.5217, 95.9364, 31.7988>, <30.6756, 91.09921, 31.8087>, <28.3465, 95.3264, 30.7152> }
					triangle { <28.6742, 98.4536, 28.3407>, <26.7146, 95.4413, 26.7784>, <28.3465, 95.3264, 30.7152> }
					triangle { <28.6742, 98.4536, 28.3407>, <28.3465, 95.3264, 30.7152>, <26.7146, 95.4413, 26.7784> }
					triangle { <28.3465, 95.3264, 30.7152>, <31.2735, 99.123, 30.03986>, <28.6742, 98.4536, 28.3407> }
					triangle { <28.3465, 95.3264, 30.7152>, <28.6742, 98.4536, 28.3407>, <31.2735, 99.123, 30.03986> }
					triangle { <31.5217, 95.9364, 31.7988>, <31.2735, 99.123, 30.03986>, <28.3465, 95.3264, 30.7152> }
					triangle { <31.5217, 95.9364, 31.7988>, <28.3465, 95.3264, 30.7152>, <31.2735, 99.123, 30.03986> }
					triangle { <35.3139, 96.9033, 30.1813>, <31.2735, 99.123, 30.03986>, <31.5217, 95.9364, 31.7988> }
					triangle { <35.3139, 96.9033, 30.1813>, <31.5217, 95.9364, 31.7988>, <31.2735, 99.123, 30.03986> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <30.7332, 95.6776, 30.03401>, <28.6841, 95.5295, 32.7556>, <30.6756, 91.09921, 31.8087> }
					triangle { <30.7332, 95.6776, 30.03401>, <30.6756, 91.09921, 31.8087>, <28.6841, 95.5295, 32.7556> }
					triangle { <26.4174, 98.2705, 31.06043>, <24.4277, 95.5041, 32.9951>, <28.6841, 95.5295, 32.7556> }
					triangle { <26.4174, 98.2705, 31.06043>, <28.6841, 95.5295, 32.7556>, <24.4277, 95.5041, 32.9951> }
					triangle { <28.6841, 95.5295, 32.7556>, <28.8524, 98.6465, 29.05516>, <26.4174, 98.2705, 31.06043> }
					triangle { <28.6841, 95.5295, 32.7556>, <26.4174, 98.2705, 31.06043>, <28.8524, 98.6465, 29.05516> }
					triangle { <30.7332, 95.6776, 30.03401>, <28.8524, 98.6465, 29.05516>, <28.6841, 95.5295, 32.7556> }
					triangle { <30.7332, 95.6776, 30.03401>, <28.6841, 95.5295, 32.7556>, <28.8524, 98.6465, 29.05516> }
					triangle { <30.4268, 95.7705, 25.8114>, <28.8524, 98.6465, 29.05516>, <30.7332, 95.6776, 30.03401> }
					triangle { <30.4268, 95.7705, 25.8114>, <30.7332, 95.6776, 30.03401>, <28.8524, 98.6465, 29.05516> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <28.8199, 95.3729, 30.2574>, <30.7095, 95.89, 33.04854>, <30.6756, 91.09921, 31.8087> }
					triangle { <28.8199, 95.3729, 30.2574>, <30.6756, 91.09921, 31.8087>, <30.7095, 95.89, 33.04854> }
					triangle { <28.2377, 98.7902, 34.05033>, <29.5218, 96.6505, 37.0716>, <30.7095, 95.89, 33.04854> }
					triangle { <28.2377, 98.7902, 34.05033>, <30.7095, 95.89, 33.04854>, <29.5218, 96.6505, 37.0716> }
					triangle { <30.7095, 95.89, 33.04854>, <27.1411, 98.5052, 31.08257>, <28.2377, 98.7902, 34.05033> }
					triangle { <30.7095, 95.89, 33.04854>, <28.2377, 98.7902, 34.05033>, <27.1411, 98.5052, 31.08257> }
					triangle { <28.8199, 95.3729, 30.2574>, <27.1411, 98.5052, 31.08257>, <30.7095, 95.89, 33.04854> }
					triangle { <28.8199, 95.3729, 30.2574>, <30.7095, 95.89, 33.04854>, <27.1411, 98.5052, 31.08257> }
					triangle { <24.7359, 95.05857, 29.1833>, <27.1411, 98.5052, 31.08257>, <28.8199, 95.3729, 30.2574> }
					triangle { <24.7359, 95.05857, 29.1833>, <28.8199, 95.3729, 30.2574>, <27.1411, 98.5052, 31.08257> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <28.4081, 95.4406, 32.1625>, <31.6427, 95.9132, 31.1919>, <30.6756, 91.09921, 31.8087> }
					triangle { <28.4081, 95.4406, 32.1625>, <30.6756, 91.09921, 31.8087>, <31.6427, 95.9132, 31.1919> }
					triangle { <31.6365, 99.2993, 33.2064>, <35.00447, 97.3069, 33.4123>, <31.6427, 95.9132, 31.1919> }
					triangle { <31.6365, 99.2993, 33.2064>, <31.6427, 95.9132, 31.1919>, <35.00447, 97.3069, 33.4123> }
					triangle { <31.6427, 95.9132, 31.1919>, <28.4887, 98.893, 33.3392>, <31.6365, 99.2993, 33.2064> }
					triangle { <31.6427, 95.9132, 31.1919>, <31.6365, 99.2993, 33.2064>, <28.4887, 98.893, 33.3392> }
					triangle { <28.4081, 95.4406, 32.1625>, <28.4887, 98.893, 33.3392>, <31.6427, 95.9132, 31.1919> }
					triangle { <28.4081, 95.4406, 32.1625>, <31.6427, 95.9132, 31.1919>, <28.4887, 98.893, 33.3392> }
					triangle { <26.05273, 95.7447, 35.6685>, <28.4887, 98.893, 33.3392>, <28.4081, 95.4406, 32.1625> }
					triangle { <26.05273, 95.7447, 35.6685>, <28.4081, 95.4406, 32.1625>, <28.4887, 98.893, 33.3392> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <30.103, 95.7942, 33.1295>, <30.1602, 95.5596, 29.7281>, <30.6756, 91.09921, 31.8087> }
					triangle { <30.103, 95.7942, 33.1295>, <30.6756, 91.09921, 31.8087>, <30.1602, 95.5596, 29.7281> }
					triangle { <31.9104, 99.0882, 29.6245>, <33.2433, 96.5483, 26.9548>, <30.1602, 95.5596, 29.7281> }
					triangle { <31.9104, 99.0882, 29.6245>, <30.1602, 95.5596, 29.7281>, <33.2433, 96.5483, 26.9548> }
					triangle { <30.1602, 95.5596, 29.7281>, <31.08129, 99.2806, 32.685>, <31.9104, 99.0882, 29.6245> }
					triangle { <30.1602, 95.5596, 29.7281>, <31.9104, 99.0882, 29.6245>, <31.08129, 99.2806, 32.685> }
					triangle { <30.103, 95.7942, 33.1295>, <31.08129, 99.2806, 32.685>, <30.1602, 95.5596, 29.7281> }
					triangle { <30.103, 95.7942, 33.1295>, <30.1602, 95.5596, 29.7281>, <31.08129, 99.2806, 32.685> }
					triangle { <32.689, 96.902, 36.2946>, <31.08129, 99.2806, 32.685>, <30.103, 95.7942, 33.1295> }
					triangle { <32.689, 96.902, 36.2946>, <30.103, 95.7942, 33.1295>, <31.08129, 99.2806, 32.685> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <29.5791, 79.5542, 29.5731>, <30.6879, 80.7707, 30.8126>, 0.2809 }
			cylinder { <30.6879, 80.7707, 30.8126>, <31.7967, 81.9871, 32.05204>, 0.2809 }
			cylinder { <31.7967, 81.9871, 32.05204>, <32.9055, 83.2036, 33.2914>, 0.2809 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <32.9055, 83.2036, 33.2914>, <34.7687, 84.5216, 36.7226>, 0.2809 }
				cylinder { <34.7687, 84.5216, 36.7226>, <36.02793, 84.548, 40.6464>, 0.2809 }
				cylinder { <36.02793, 84.548, 40.6464>, <36.5142, 83.2791, 44.5368>, 0.2809 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <37.026, 83.4377, 49.4182>, <36.6465, 80.2022, 48.4105>, <36.5142, 83.2791, 44.5368> }
					triangle { <37.026, 83.4377, 49.4182>, <36.5142, 83.2791, 44.5368>, <36.6465, 80.2022, 48.4105> }
					triangle { <34.7557, 79.4865, 51.7924>, <33.2705, 77.6136, 48.6873>, <36.6465, 80.2022, 48.4105> }
					triangle { <34.7557, 79.4865, 51.7924>, <36.6465, 80.2022, 48.4105>, <33.2705, 77.6136, 48.6873> }
					triangle { <36.6465, 80.2022, 48.4105>, <35.8713, 82.321, 52.6939>, <34.7557, 79.4865, 51.7924> }
					triangle { <36.6465, 80.2022, 48.4105>, <34.7557, 79.4865, 51.7924>, <35.8713, 82.321, 52.6939> }
					triangle { <37.026, 83.4377, 49.4182>, <35.8713, 82.321, 52.6939>, <36.6465, 80.2022, 48.4105> }
					triangle { <37.026, 83.4377, 49.4182>, <36.6465, 80.2022, 48.4105>, <35.8713, 82.321, 52.6939> }
					triangle { <34.7193, 86.522, 51.1785>, <35.8713, 82.321, 52.6939>, <37.026, 83.4377, 49.4182> }
					triangle { <34.7193, 86.522, 51.1785>, <37.026, 83.4377, 49.4182>, <35.8713, 82.321, 52.6939> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <35.4797, 82.2644, 49.2289>, <38.5557, 81.02222, 48.4392>, <36.5142, 83.2791, 44.5368> }
					triangle { <35.4797, 82.2644, 49.2289>, <36.5142, 83.2791, 44.5368>, <38.5557, 81.02222, 48.4392> }
					triangle { <37.8738, 78.04979, 50.934>, <39.7897, 77.01349, 47.6767>, <38.5557, 81.02222, 48.4392> }
					triangle { <37.8738, 78.04979, 50.934>, <38.5557, 81.02222, 48.4392>, <39.7897, 77.01349, 47.6767> }
					triangle { <38.5557, 81.02222, 48.4392>, <35.4282, 79.8146, 51.9318>, <37.8738, 78.04979, 50.934> }
					triangle { <38.5557, 81.02222, 48.4392>, <37.8738, 78.04979, 50.934>, <35.4282, 79.8146, 51.9318> }
					triangle { <35.4797, 82.2644, 49.2289>, <35.4282, 79.8146, 51.9318>, <38.5557, 81.02222, 48.4392> }
					triangle { <35.4797, 82.2644, 49.2289>, <38.5557, 81.02222, 48.4392>, <35.4282, 79.8146, 51.9318> }
					triangle { <31.5123, 80.8739, 49.7374>, <35.4282, 79.8146, 51.9318>, <35.4797, 82.2644, 49.2289> }
					triangle { <31.5123, 80.8739, 49.7374>, <35.4797, 82.2644, 49.2289>, <35.4282, 79.8146, 51.9318> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <36.1018, 80.5314, 48.5859>, <38.4111, 82.9876, 49.09837>, <36.5142, 83.2791, 44.5368> }
					triangle { <36.1018, 80.5314, 48.5859>, <36.5142, 83.2791, 44.5368>, <38.4111, 82.9876, 49.09837> }
					triangle { <40.3907, 80.4903, 51.4154>, <42.6681, 82.7823, 49.1983>, <38.4111, 82.9876, 49.09837> }
					triangle { <40.3907, 80.4903, 51.4154>, <38.4111, 82.9876, 49.09837>, <42.6681, 82.7823, 49.1983> }
					triangle { <38.4111, 82.9876, 49.09837>, <37.7587, 78.7166, 51.2824>, <40.3907, 80.4903, 51.4154> }
					triangle { <38.4111, 82.9876, 49.09837>, <40.3907, 80.4903, 51.4154>, <37.7587, 78.7166, 51.2824> }
					triangle { <36.1018, 80.5314, 48.5859>, <37.7587, 78.7166, 51.2824>, <38.4111, 82.9876, 49.09837> }
					triangle { <36.1018, 80.5314, 48.5859>, <38.4111, 82.9876, 49.09837>, <37.7587, 78.7166, 51.2824> }
					triangle { <35.9907, 76.3888, 47.7148>, <37.7587, 78.7166, 51.2824>, <36.1018, 80.5314, 48.5859> }
					triangle { <35.9907, 76.3888, 47.7148>, <36.1018, 80.5314, 48.5859>, <37.7587, 78.7166, 51.2824> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <38.03841, 80.6176, 48.3719>, <36.4111, 83.4007, 49.483>, <36.5142, 83.2791, 44.5368> }
					triangle { <38.03841, 80.6176, 48.3719>, <36.5142, 83.2791, 44.5368>, <36.4111, 83.4007, 49.483> }
					triangle { <38.8517, 83.4582, 52.5757>, <37.9547, 87.00172, 51.1636>, <36.4111, 83.4007, 49.483> }
					triangle { <38.8517, 83.4582, 52.5757>, <36.4111, 83.4007, 49.483>, <37.9547, 87.00172, 51.1636> }
					triangle { <36.4111, 83.4007, 49.483>, <39.6639, 80.5341, 51.637>, <38.8517, 83.4582, 52.5757> }
					triangle { <36.4111, 83.4007, 49.483>, <38.8517, 83.4582, 52.5757>, <39.6639, 80.5341, 51.637> }
					triangle { <38.03841, 80.6176, 48.3719>, <39.6639, 80.5341, 51.637>, <36.4111, 83.4007, 49.483> }
					triangle { <38.03841, 80.6176, 48.3719>, <36.4111, 83.4007, 49.483>, <39.6639, 80.5341, 51.637> }
					triangle { <42.00739, 79.2232, 47.8871>, <39.6639, 80.5341, 51.637>, <38.03841, 80.6176, 48.3719> }
					triangle { <42.00739, 79.2232, 47.8871>, <38.03841, 80.6176, 48.3719>, <39.6639, 80.5341, 51.637> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <38.6181, 82.4408, 48.8941>, <35.3041, 81.6532, 49.05153>, <36.5142, 83.2791, 44.5368> }
					triangle { <38.6181, 82.4408, 48.8941>, <36.5142, 83.2791, 44.5368>, <35.3041, 81.6532, 49.05153> }
					triangle { <35.3165, 82.8284, 52.8122>, <32.0591, 83.759, 50.843>, <35.3041, 81.6532, 49.05153> }
					triangle { <35.3165, 82.8284, 52.8122>, <35.3041, 81.6532, 49.05153>, <32.0591, 83.759, 50.843> }
					triangle { <35.3041, 81.6532, 49.05153>, <38.4798, 82.7953, 52.5225>, <35.3165, 82.8284, 52.8122> }
					triangle { <35.3041, 81.6532, 49.05153>, <35.3165, 82.8284, 52.8122>, <38.4798, 82.7953, 52.5225> }
					triangle { <38.6181, 82.4408, 48.8941>, <38.4798, 82.7953, 52.5225>, <35.3041, 81.6532, 49.05153> }
					triangle { <38.6181, 82.4408, 48.8941>, <35.3041, 81.6532, 49.05153>, <38.4798, 82.7953, 52.5225> }
					triangle { <41.2097, 85.5803, 50.06017>, <38.4798, 82.7953, 52.5225>, <38.6181, 82.4408, 48.8941> }
					triangle { <41.2097, 85.5803, 50.06017>, <38.6181, 82.4408, 48.8941>, <38.4798, 82.7953, 52.5225> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		}
	union { // Internode
		cylinder { <4.4179, 48.3039, 0.7545>, <5.4991, 53.6314, 1.5408>, 0.4993 }
		cylinder { <5.4991, 53.6314, 1.5408>, <6.5974, 58.9733, 2.1942>, 0.4993 }
		cylinder { <6.5974, 58.9733, 2.1942>, <7.7122, 64.3265, 2.7143>, 0.4993 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <7.7122, 64.3265, 2.7143>, <9.3412, 71.02804, 1.1537>, 0.4821 }
			cylinder { <9.3412, 71.02804, 1.1537>, <10.9994, 76.8632, -2.4794>, 0.4821 }
			cylinder { <10.9994, 76.8632, -2.4794>, <12.5196, 81.243, -7.8185>, 0.4821 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <12.5196, 81.243, -7.8185>, <12.9704, 82.5172, -9.4534>, 0.4821 }
				cylinder { <12.9704, 82.5172, -9.4534>, <13.4158, 83.7509, -11.1206>, 0.4821 }
				cylinder { <13.4158, 83.7509, -11.1206>, <13.8555, 84.9434, -12.8191>, 0.4821 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <13.8555, 84.9434, -12.8191>, <13.6935, 86.5753, -14.9981>, 0.1859 }
				cylinder { <13.6935, 86.5753, -14.9981>, <12.8158, 88.188, -17.0148>, 0.1859 }
				cylinder { <12.8158, 88.188, -17.0148>, <11.2861, 89.6645, -18.7229>, 0.1859 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <11.2861, 89.6645, -18.7229>, <11.4334, 92.2923, -1.6809>, <2.4972, 99.6258, -5.6284> }
				triangle { <11.2861, 89.6645, -18.7229>, <2.4972, 99.6258, -5.6284>, <11.4334, 92.2923, -1.6809> }
				triangle { <11.2861, 89.6645, -18.7229>, <2.4972, 99.6258, -5.6284>, <-7.1412, 110.092, -21.8189> }
				triangle { <11.2861, 89.6645, -18.7229>, <-7.1412, 110.092, -21.8189>, <2.4972, 99.6258, -5.6284> }
				triangle { <11.2861, 89.6645, -18.7229>, <-7.1412, 110.092, -21.8189>, <-5.2801, 112.5588, -39.6427> }
				triangle { <11.2861, 89.6645, -18.7229>, <-5.2801, 112.5588, -39.6427>, <-7.1412, 110.092, -21.8189> }
				triangle { <11.2861, 89.6645, -18.7229>, <-5.2801, 112.5588, -39.6427>, <10.1714, 102.1661, -43.4971> }
				triangle { <11.2861, 89.6645, -18.7229>, <10.1714, 102.1661, -43.4971>, <-5.2801, 112.5588, -39.6427> }
				triangle { <11.2861, 89.6645, -18.7229>, <10.1714, 102.1661, -43.4971>, <24.09183, 89.8925, -33.3809> }
				triangle { <11.2861, 89.6645, -18.7229>, <24.09183, 89.8925, -33.3809>, <10.1714, 102.1661, -43.4971> }
				triangle { <11.2861, 89.6645, -18.7229>, <24.09183, 89.8925, -33.3809>, <27.2658, 85.2785, -22.5996> }
				triangle { <11.2861, 89.6645, -18.7229>, <27.2658, 85.2785, -22.5996>, <24.09183, 89.8925, -33.3809> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <13.8555, 84.9434, -12.8191>, <14.2893, 86.09388, -14.5477>, 0.4821 }
				cylinder { <14.2893, 86.09388, -14.5477>, <14.7167, 87.2016, -16.3056>, 0.4821 }
				cylinder { <14.7167, 87.2016, -16.3056>, <15.1377, 88.2661, -18.09156>, 0.4821 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <15.1377, 88.2661, -18.09156>, <16.3662, 89.4306, -20.2299>, 0.1859 }
				cylinder { <16.3662, 89.4306, -20.2299>, <18.1929, 90.3067, -22.05565>, 0.1859 }
				cylinder { <18.1929, 90.3067, -22.05565>, <20.4856, 90.8309, -23.4364>, 0.1859 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <20.4856, 90.8309, -23.4364>, <10.04618, 103.2606, -17.6159>, <18.2041, 109.3191, -24.3953> }
				triangle { <20.4856, 90.8309, -23.4364>, <18.2041, 109.3191, -24.3953>, <10.04618, 103.2606, -17.6159> }
				triangle { <20.4856, 90.8309, -23.4364>, <18.2041, 109.3191, -24.3953>, <37.3619, 109.9258, -34.2537> }
				triangle { <20.4856, 90.8309, -23.4364>, <37.3619, 109.9258, -34.2537>, <18.2041, 109.3191, -24.3953> }
				triangle { <20.4856, 90.8309, -23.4364>, <37.3619, 109.9258, -34.2537>, <51.849, 99.4009, -36.8201> }
				triangle { <20.4856, 90.8309, -23.4364>, <51.849, 99.4009, -36.8201>, <37.3619, 109.9258, -34.2537> }
				triangle { <20.4856, 90.8309, -23.4364>, <51.849, 99.4009, -36.8201>, <47.01413, 83.6193, -27.3765> }
				triangle { <20.4856, 90.8309, -23.4364>, <47.01413, 83.6193, -27.3765>, <51.849, 99.4009, -36.8201> }
				triangle { <20.4856, 90.8309, -23.4364>, <47.01413, 83.6193, -27.3765>, <30.8624, 76.1523, -15.9695> }
				triangle { <20.4856, 90.8309, -23.4364>, <30.8624, 76.1523, -15.9695>, <47.01413, 83.6193, -27.3765> }
				triangle { <20.4856, 90.8309, -23.4364>, <30.8624, 76.1523, -15.9695>, <19.8229, 78.6598, -11.5603> }
				triangle { <20.4856, 90.8309, -23.4364>, <19.8229, 78.6598, -11.5603>, <30.8624, 76.1523, -15.9695> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <15.1377, 88.2661, -18.09156>, <15.6789, 89.6346, -20.3876>, 0.1859 }
				cylinder { <15.6789, 89.6346, -20.3876>, <16.2201, 91.00322, -22.6837>, 0.1859 }
				cylinder { <16.2201, 91.00322, -22.6837>, <16.7613, 92.3717, -24.9798>, 0.1859 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <16.7613, 92.3717, -24.9798>, <8.8098, 99.5699, -11.4774>, <8.09323, 108.1609, -20.1319> }
				triangle { <16.7613, 92.3717, -24.9798>, <8.09323, 108.1609, -20.1319>, <8.8098, 99.5699, -11.4774> }
				triangle { <16.7613, 92.3717, -24.9798>, <8.09323, 108.1609, -20.1319>, <14.9937, 116.2471, -38.8821> }
				triangle { <16.7613, 92.3717, -24.9798>, <14.9937, 116.2471, -38.8821>, <8.09323, 108.1609, -20.1319> }
				triangle { <16.7613, 92.3717, -24.9798>, <14.9937, 116.2471, -38.8821>, <27.1332, 112.614, -51.7922> }
				triangle { <16.7613, 92.3717, -24.9798>, <27.1332, 112.614, -51.7922>, <14.9937, 116.2471, -38.8821> }
				triangle { <16.7613, 92.3717, -24.9798>, <27.1332, 112.614, -51.7922>, <35.24, 96.7031, -45.2546> }
				triangle { <16.7613, 92.3717, -24.9798>, <35.24, 96.7031, -45.2546>, <27.1332, 112.614, -51.7922> }
				triangle { <16.7613, 92.3717, -24.9798>, <35.24, 96.7031, -45.2546>, <33.8054, 83.7127, -28.643> }
				triangle { <16.7613, 92.3717, -24.9798>, <33.8054, 83.7127, -28.643>, <35.24, 96.7031, -45.2546> }
				triangle { <16.7613, 92.3717, -24.9798>, <33.8054, 83.7127, -28.643>, <28.02864, 81.5888, -18.1684> }
				triangle { <16.7613, 92.3717, -24.9798>, <28.02864, 81.5888, -18.1684>, <33.8054, 83.7127, -28.643> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <7.7122, 64.3265, 2.7143>, <8.1895, 66.3826, 2.4493>, 0.1933 }
		cylinder { <8.1895, 66.3826, 2.4493>, <8.6889, 68.3216, 1.7308>, 0.1933 }
		cylinder { <8.6889, 68.3216, 1.7308>, <9.1864, 70.0493, 0.5936>, 0.1933 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <9.1864, 70.0493, 0.5936>, <9.4855, 70.8945, -0.4909>, 0.09594 }
			cylinder { <9.4855, 70.8945, -0.4909>, <9.7244, 71.3569, -1.7983>, 0.09594 }
			cylinder { <9.7244, 71.3569, -1.7983>, <9.879, 71.3897, -3.1965>, 0.09594 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <9.879, 71.3897, -3.1965>, <9.9233, 71.3894, -3.6164>, 0.09594 }
				cylinder { <9.9233, 71.3894, -3.6164>, <9.9653, 71.379, -4.03635>, 0.09594 }
				cylinder { <9.9653, 71.379, -4.03635>, <10.00512, 71.3584, -4.4561>, 0.09594 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <10.00512, 71.3584, -4.4561>, <9.9869, 71.3595, -4.5625>, 0.007364 }
				cylinder { <9.9869, 71.3595, -4.5625>, <9.9417, 71.3668, -4.6603>, 0.007364 }
				cylinder { <9.9417, 71.3668, -4.6603>, <9.8727, 71.3798, -4.7424>, 0.007364 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <9.8727, 71.3798, -4.7424>, <10.4263, 73.806, -2.3795>, <8.578, 74.6942, -3.685> }
				triangle { <9.8727, 71.3798, -4.7424>, <8.578, 74.6942, -3.685>, <10.4263, 73.806, -2.3795> }
				triangle { <9.8727, 71.3798, -4.7424>, <8.578, 74.6942, -3.685>, <6.234, 74.6492, -7.277> }
				triangle { <9.8727, 71.3798, -4.7424>, <6.234, 74.6492, -7.277>, <8.578, 74.6942, -3.685> }
				triangle { <9.8727, 71.3798, -4.7424>, <6.234, 74.6492, -7.277>, <6.07139, 72.897, -10.4175> }
				triangle { <9.8727, 71.3798, -4.7424>, <6.07139, 72.897, -10.4175>, <6.234, 74.6492, -7.277> }
				triangle { <9.8727, 71.3798, -4.7424>, <6.07139, 72.897, -10.4175>, <8.9536, 70.4635, -10.1147> }
				triangle { <9.8727, 71.3798, -4.7424>, <8.9536, 70.4635, -10.1147>, <6.07139, 72.897, -10.4175> }
				triangle { <9.8727, 71.3798, -4.7424>, <8.9536, 70.4635, -10.1147>, <11.9494, 69.4133, -7.3551> }
				triangle { <9.8727, 71.3798, -4.7424>, <11.9494, 69.4133, -7.3551>, <8.9536, 70.4635, -10.1147> }
				triangle { <9.8727, 71.3798, -4.7424>, <11.9494, 69.4133, -7.3551>, <12.8813, 69.8862, -5.1749> }
				triangle { <9.8727, 71.3798, -4.7424>, <12.8813, 69.8862, -5.1749>, <11.9494, 69.4133, -7.3551> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <10.00512, 71.3584, -4.4561>, <10.04265, 71.3278, -4.8754>, 0.09594 }
				cylinder { <10.04265, 71.3278, -4.8754>, <10.07792, 71.2871, -5.2941>, 0.09594 }
				cylinder { <10.07792, 71.2871, -5.2941>, <10.1108, 71.2363, -5.7119>, 0.09594 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <10.1108, 71.2363, -5.7119>, <10.147, 71.2177, -5.812>, 0.007364 }
				cylinder { <10.147, 71.2177, -5.812>, <10.2082, 71.1947, -5.898>, 0.007364 }
				cylinder { <10.2082, 71.1947, -5.898>, <10.29, 71.1692, -5.9637>, 0.007364 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <10.29, 71.1692, -5.9637>, <8.4606, 74.0518, -6.3106>, <9.8837, 74.04009, -8.2815> }
				triangle { <10.29, 71.1692, -5.9637>, <9.8837, 74.04009, -8.2815>, <8.4606, 74.0518, -6.3106> }
				triangle { <10.29, 71.1692, -5.9637>, <9.8837, 74.04009, -8.2815>, <13.356, 72.5655, -10.3229> }
				triangle { <10.29, 71.1692, -5.9637>, <13.356, 72.5655, -10.3229>, <9.8837, 74.04009, -8.2815> }
				triangle { <10.29, 71.1692, -5.9637>, <13.356, 72.5655, -10.3229>, <16.08702, 70.2836, -9.7806> }
				triangle { <10.29, 71.1692, -5.9637>, <16.08702, 70.2836, -9.7806>, <13.356, 72.5655, -10.3229> }
				triangle { <10.29, 71.1692, -5.9637>, <16.08702, 70.2836, -9.7806>, <15.3604, 68.9954, -6.2973> }
				triangle { <10.29, 71.1692, -5.9637>, <15.3604, 68.9954, -6.2973>, <16.08702, 70.2836, -9.7806> }
				triangle { <10.29, 71.1692, -5.9637>, <15.3604, 68.9954, -6.2973>, <12.4996, 69.4996, -3.2552> }
				triangle { <10.29, 71.1692, -5.9637>, <12.4996, 69.4996, -3.2552>, <15.3604, 68.9954, -6.2973> }
				triangle { <10.29, 71.1692, -5.9637>, <12.4996, 69.4996, -3.2552>, <10.4713, 70.6528, -2.6215> }
				triangle { <10.29, 71.1692, -5.9637>, <10.4713, 70.6528, -2.6215>, <12.4996, 69.4996, -3.2552> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <10.1108, 71.2363, -5.7119>, <10.1193, 71.2233, -5.8188>, 0.007364 }
				cylinder { <10.1193, 71.2233, -5.8188>, <10.1277, 71.2103, -5.9257>, 0.007364 }
				cylinder { <10.1277, 71.2103, -5.9257>, <10.1362, 71.1973, -6.03264>, 0.007364 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <10.1362, 71.1973, -6.03264>, <9.007872, 74.1034, -4.598>, <8.6387, 74.4609, -6.974> }
				triangle { <10.1362, 71.1973, -6.03264>, <8.6387, 74.4609, -6.974>, <9.007872, 74.1034, -4.598> }
				triangle { <10.1362, 71.1973, -6.03264>, <8.6387, 74.4609, -6.974>, <9.4609, 73.3845, -11.04396> }
				triangle { <10.1362, 71.1973, -6.03264>, <9.4609, 73.3845, -11.04396>, <8.6387, 74.4609, -6.974> }
				triangle { <10.1362, 71.1973, -6.03264>, <9.4609, 73.3845, -11.04396>, <11.4444, 71.0256, -12.9041> }
				triangle { <10.1362, 71.1973, -6.03264>, <11.4444, 71.0256, -12.9041>, <9.4609, 73.3845, -11.04396> }
				triangle { <10.1362, 71.1973, -6.03264>, <11.4444, 71.0256, -12.9041>, <13.1748, 69.09886, -10.1446> }
				triangle { <10.1362, 71.1973, -6.03264>, <13.1748, 69.09886, -10.1446>, <11.4444, 71.0256, -12.9041> }
				triangle { <10.1362, 71.1973, -6.03264>, <13.1748, 69.09886, -10.1446>, <13.3441, 69.02794, -5.9423> }
				triangle { <10.1362, 71.1973, -6.03264>, <13.3441, 69.02794, -5.9423>, <13.1748, 69.09886, -10.1446> }
				triangle { <10.1362, 71.1973, -6.03264>, <13.3441, 69.02794, -5.9423>, <12.5161, 70.05009, -3.9138> }
				triangle { <10.1362, 71.1973, -6.03264>, <12.5161, 70.05009, -3.9138>, <13.3441, 69.02794, -5.9423> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <9.1864, 70.0493, 0.5936>, <10.6401, 75.09816, -2.7296>, 0.2825 }
			cylinder { <10.6401, 75.09816, -2.7296>, <12.09389, 80.147, -6.05294>, 0.2825 }
			cylinder { <12.09389, 80.147, -6.05294>, <13.5476, 85.1958, -9.3762>, 0.2825 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <13.5476, 85.1958, -9.3762>, <14.03219, 86.8788, -10.4839>, 0.2825 }
			cylinder { <14.03219, 86.8788, -10.4839>, <14.5167, 88.5617, -11.5917>, 0.2825 }
			cylinder { <14.5167, 88.5617, -11.5917>, <15.00134, 90.2447, -12.6994>, 0.2825 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <15.00134, 90.2447, -12.6994>, <17.3436, 92.9904, -14.737>, 0.2825 }
				cylinder { <17.3436, 92.9904, -14.737>, <20.7453, 94.7479, -16.3235>, 0.2825 }
				cylinder { <20.7453, 94.7479, -16.3235>, <24.7503, 95.2818, -17.2464>, 0.2825 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <29.02368, 97.5258, -18.1511>, <29.5156, 94.1566, -17.965>, <24.7503, 95.2818, -17.2464> }
					triangle { <29.02368, 97.5258, -18.1511>, <24.7503, 95.2818, -17.2464>, <29.5156, 94.1566, -17.965> }
					triangle { <33.07441, 94.8722, -16.4329>, <31.2295, 91.7952, -14.8569>, <29.5156, 94.1566, -17.965> }
					triangle { <33.07441, 94.8722, -16.4329>, <29.5156, 94.1566, -17.965>, <31.2295, 91.7952, -14.8569> }
					triangle { <29.5156, 94.1566, -17.965>, <32.5723, 97.8642, -17.3749>, <33.07441, 94.8722, -16.4329> }
					triangle { <29.5156, 94.1566, -17.965>, <33.07441, 94.8722, -16.4329>, <32.5723, 97.8642, -17.3749> }
					triangle { <29.02368, 97.5258, -18.1511>, <32.5723, 97.8642, -17.3749>, <29.5156, 94.1566, -17.965> }
					triangle { <29.02368, 97.5258, -18.1511>, <29.5156, 94.1566, -17.965>, <32.5723, 97.8642, -17.3749> }
					triangle { <29.5743, 100.9677, -15.7464>, <32.5723, 97.8642, -17.3749>, <29.02368, 97.5258, -18.1511> }
					triangle { <29.5743, 100.9677, -15.7464>, <29.02368, 97.5258, -18.1511>, <32.5723, 97.8642, -17.3749> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <29.5187, 96.3206, -16.6999>, <28.9834, 94.989, -19.7931>, <24.7503, 95.2818, -17.2464> }
					triangle { <29.5187, 96.3206, -16.6999>, <24.7503, 95.2818, -17.2464>, <28.9834, 94.989, -19.7931> }
					triangle { <32.5541, 93.3372, -19.5787>, <29.8396, 91.09235, -21.2954>, <28.9834, 94.989, -19.7931> }
					triangle { <32.5541, 93.3372, -19.5787>, <28.9834, 94.989, -19.7931>, <29.8396, 91.09235, -21.2954> }
					triangle { <28.9834, 94.989, -19.7931>, <32.9869, 95.256, -17.08431>, <32.5541, 93.3372, -19.5787> }
					triangle { <28.9834, 94.989, -19.7931>, <32.5541, 93.3372, -19.5787>, <32.9869, 95.256, -17.08431> }
					triangle { <29.5187, 96.3206, -16.6999>, <32.9869, 95.256, -17.08431>, <28.9834, 94.989, -19.7931> }
					triangle { <29.5187, 96.3206, -16.6999>, <28.9834, 94.989, -19.7931>, <32.9869, 95.256, -17.08431> }
					triangle { <31.00511, 95.1163, -12.922>, <32.9869, 95.256, -17.08431>, <29.5187, 96.3206, -16.6999> }
					triangle { <31.00511, 95.1163, -12.922>, <29.5187, 96.3206, -16.6999>, <32.9869, 95.256, -17.08431> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <29.5966, 94.5063, -17.411>, <28.7688, 97.04017, -19.5377>, <24.7503, 95.2818, -17.2464> }
					triangle { <29.5966, 94.5063, -17.411>, <24.7503, 95.2818, -17.2464>, <28.7688, 97.04017, -19.5377> }
					triangle { <31.6816, 95.8522, -21.9103>, <28.4675, 97.07358, -23.79>, <28.7688, 97.04017, -19.5377> }
					triangle { <31.6816, 95.8522, -21.9103>, <28.7688, 97.04017, -19.5377>, <28.4675, 97.07358, -23.79> }
					triangle { <28.7688, 97.04017, -19.5377>, <32.6011, 94.08356, -19.437>, <31.6816, 95.8522, -21.9103> }
					triangle { <28.7688, 97.04017, -19.5377>, <31.6816, 95.8522, -21.9103>, <32.6011, 94.08356, -19.437> }
					triangle { <29.5966, 94.5063, -17.411>, <32.6011, 94.08356, -19.437>, <28.7688, 97.04017, -19.5377> }
					triangle { <29.5966, 94.5063, -17.411>, <28.7688, 97.04017, -19.5377>, <32.6011, 94.08356, -19.437> }
					triangle { <30.5621, 90.3867, -17.5801>, <32.6011, 94.08356, -19.437>, <29.5966, 94.5063, -17.411> }
					triangle { <30.5621, 90.3867, -17.5801>, <29.5966, 94.5063, -17.411>, <32.6011, 94.08356, -19.437> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <29.1505, 94.5733, -19.3083>, <29.1665, 97.4945, -17.5493>, <24.7503, 95.2818, -17.2464> }
					triangle { <29.1505, 94.5733, -19.3083>, <24.7503, 95.2818, -17.2464>, <29.1665, 97.4945, -17.5493> }
					triangle { <31.6545, 98.9651, -20.2273>, <28.9967, 101.5289, -18.9165>, <29.1665, 97.4945, -17.5493> }
					triangle { <31.6545, 98.9651, -20.2273>, <29.1665, 97.4945, -17.5493>, <28.9967, 101.5289, -18.9165> }
					triangle { <29.1665, 97.4945, -17.5493>, <31.9444, 95.9561, -21.2036>, <31.6545, 98.9651, -20.2273> }
					triangle { <29.1665, 97.4945, -17.5493>, <31.6545, 98.9651, -20.2273>, <31.9444, 95.9561, -21.2036> }
					triangle { <29.1505, 94.5733, -19.3083>, <31.9444, 95.9561, -21.2036>, <29.1665, 97.4945, -17.5493> }
					triangle { <29.1505, 94.5733, -19.3083>, <29.1665, 97.4945, -17.5493>, <31.9444, 95.9561, -21.2036> }
					triangle { <28.8535, 93.2709, -23.3268>, <31.9444, 95.9561, -21.2036>, <29.1505, 94.5733, -19.3083> }
					triangle { <28.8535, 93.2709, -23.3268>, <29.1505, 94.5733, -19.3083>, <31.9444, 95.9561, -21.2036> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <28.791, 96.4675, -19.7727>, <29.635, 95.6854, -16.5626>, <24.7503, 95.2818, -17.2464> }
					triangle { <28.791, 96.4675, -19.7727>, <24.7503, 95.2818, -17.2464>, <29.635, 95.6854, -16.5626> }
					triangle { <32.5283, 98.3502, -16.7909>, <30.7295, 98.2174, -13.3122>, <29.635, 95.6854, -16.5626> }
					triangle { <32.5283, 98.3502, -16.7909>, <29.635, 95.6854, -16.5626>, <30.7295, 98.2174, -13.3122> }
					triangle { <29.635, 95.6854, -16.5626>, <31.9263, 98.3279, -19.91>, <32.5283, 98.3502, -16.7909> }
					triangle { <29.635, 95.6854, -16.5626>, <32.5283, 98.3502, -16.7909>, <31.9263, 98.3279, -19.91> }
					triangle { <28.791, 96.4675, -19.7727>, <31.9263, 98.3279, -19.91>, <29.635, 95.6854, -16.5626> }
					triangle { <28.791, 96.4675, -19.7727>, <29.635, 95.6854, -16.5626>, <31.9263, 98.3279, -19.91> }
					triangle { <28.2337, 99.909, -22.1764>, <31.9263, 98.3279, -19.91>, <28.791, 96.4675, -19.7727> }
					triangle { <28.2337, 99.909, -22.1764>, <28.791, 96.4675, -19.7727>, <31.9263, 98.3279, -19.91> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <15.00134, 90.2447, -12.6994>, <15.4859, 91.9276, -13.8072>, 0.2825 }
			cylinder { <15.4859, 91.9276, -13.8072>, <15.9704, 93.6106, -14.915>, 0.2825 }
			cylinder { <15.9704, 93.6106, -14.915>, <16.455, 95.2935, -16.02277>, 0.2825 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <16.455, 95.2935, -16.02277>, <16.1681, 98.2054, -18.958>, 0.2825 }
				cylinder { <16.1681, 98.2054, -18.958>, <14.6634, 100.2731, -22.2196>, 0.2825 }
				cylinder { <14.6634, 100.2731, -22.2196>, <12.1428, 101.2194, -25.3705>, 0.2825 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <10.6342, 102.838, -29.7545>, <8.05416, 101.2818, -28.1578>, <12.1428, 101.2194, -25.3705> }
					triangle { <10.6342, 102.838, -29.7545>, <12.1428, 101.2194, -25.3705>, <8.05416, 101.2818, -28.1578> }
					triangle { <6.7517, 100.0737, -31.6747>, <6.3377, 97.4341, -28.8083>, <8.05416, 101.2818, -28.1578> }
					triangle { <6.7517, 100.0737, -31.6747>, <8.05416, 101.2818, -28.1578>, <6.3377, 97.4341, -28.8083> }
					triangle { <8.05416, 101.2818, -28.1578>, <8.8304, 102.1666, -32.8538>, <6.7517, 100.0737, -31.6747> }
					triangle { <8.05416, 101.2818, -28.1578>, <6.7517, 100.0737, -31.6747>, <8.8304, 102.1666, -32.8538> }
					triangle { <10.6342, 102.838, -29.7545>, <8.8304, 102.1666, -32.8538>, <8.05416, 101.2818, -28.1578> }
					triangle { <10.6342, 102.838, -29.7545>, <8.05416, 101.2818, -28.1578>, <8.8304, 102.1666, -32.8538> }
					triangle { <13.4404, 102.0291, -32.821>, <8.8304, 102.1666, -32.8538>, <10.6342, 102.838, -29.7545> }
					triangle { <13.4404, 102.0291, -32.821>, <10.6342, 102.838, -29.7545>, <8.8304, 102.1666, -32.8538> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <9.9592, 101.0083, -29.7639>, <8.3726, 103.3048, -27.8051>, <12.1428, 101.2194, -25.3705> }
					triangle { <9.9592, 101.0083, -29.7639>, <12.1428, 101.2194, -25.3705>, <8.3726, 103.3048, -27.8051> }
					triangle { <4.998, 102.3349, -29.5927>, <4.6401, 103.0647, -25.7594>, <8.3726, 103.3048, -27.8051> }
					triangle { <4.998, 102.3349, -29.5927>, <8.3726, 103.3048, -27.8051>, <4.6401, 103.0647, -25.7594> }
					triangle { <8.3726, 103.3048, -27.8051>, <6.8593, 100.8272, -31.6792>, <4.998, 102.3349, -29.5927> }
					triangle { <8.3726, 103.3048, -27.8051>, <4.998, 102.3349, -29.5927>, <6.8593, 100.8272, -31.6792> }
					triangle { <9.9592, 101.0083, -29.7639>, <6.8593, 100.8272, -31.6792>, <8.3726, 103.3048, -27.8051> }
					triangle { <9.9592, 101.0083, -29.7639>, <8.3726, 103.3048, -27.8051>, <6.8593, 100.8272, -31.6792> }
					triangle { <9.4071, 97.02695, -31.09674>, <6.8593, 100.8272, -31.6792>, <9.9592, 101.0083, -29.7639> }
					triangle { <9.4071, 97.02695, -31.09674>, <9.9592, 101.0083, -29.7639>, <6.8593, 100.8272, -31.6792> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <8.4246, 100.9163, -28.5639>, <10.00942, 103.9131, -28.9317>, <12.1428, 101.2194, -25.3705> }
					triangle { <8.4246, 100.9163, -28.5639>, <12.1428, 101.2194, -25.3705>, <10.00942, 103.9131, -28.9317> }
					triangle { <6.5316, 105.5125, -29.8652>, <8.8332, 107.817, -27.6865>, <10.00942, 103.9131, -28.9317> }
					triangle { <6.5316, 105.5125, -29.8652>, <10.00942, 103.9131, -28.9317>, <8.8332, 107.817, -27.6865> }
					triangle { <10.00942, 103.9131, -28.9317>, <5.5288, 102.5082, -30.11>, <6.5316, 105.5125, -29.8652> }
					triangle { <10.00942, 103.9131, -28.9317>, <6.5316, 105.5125, -29.8652>, <5.5288, 102.5082, -30.11> }
					triangle { <8.4246, 100.9163, -28.5639>, <5.5288, 102.5082, -30.11>, <10.00942, 103.9131, -28.9317> }
					triangle { <8.4246, 100.9163, -28.5639>, <10.00942, 103.9131, -28.9317>, <5.5288, 102.5082, -30.11> }
					triangle { <4.9047, 99.3652, -26.7927>, <5.5288, 102.5082, -30.11>, <8.4246, 100.9163, -28.5639> }
					triangle { <4.9047, 99.3652, -26.7927>, <8.4246, 100.9163, -28.5639>, <5.5288, 102.5082, -30.11> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <8.1369, 102.6882, -27.8017>, <10.7177, 102.2718, -29.9913>, <12.1428, 101.2194, -25.3705> }
					triangle { <8.1369, 102.6882, -27.8017>, <12.1428, 101.2194, -25.3705>, <10.7177, 102.2718, -29.9913> }
					triangle { <9.2474, 105.2448, -32.1182>, <13.1613, 105.1679, -31.9445>, <10.7177, 102.2718, -29.9913> }
					triangle { <9.2474, 105.2448, -32.1182>, <10.7177, 102.2718, -29.9913>, <13.1613, 105.1679, -31.9445> }
					triangle { <10.7177, 102.2718, -29.9913>, <6.6651, 104.9022, -30.3>, <9.2474, 105.2448, -32.1182> }
					triangle { <10.7177, 102.2718, -29.9913>, <9.2474, 105.2448, -32.1182>, <6.6651, 104.9022, -30.3> }
					triangle { <8.1369, 102.6882, -27.8017>, <6.6651, 104.9022, -30.3>, <10.7177, 102.2718, -29.9913> }
					triangle { <8.1369, 102.6882, -27.8017>, <10.7177, 102.2718, -29.9913>, <6.6651, 104.9022, -30.3> }
					triangle { <6.1135, 105.8343, -25.8169>, <6.6651, 104.9022, -30.3>, <8.1369, 102.6882, -27.8017> }
					triangle { <6.1135, 105.8343, -25.8169>, <8.1369, 102.6882, -27.8017>, <6.6651, 104.9022, -30.3> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <9.5232, 103.8938, -28.5486>, <9.491, 100.621, -29.5057>, <12.1428, 101.2194, -25.3705> }
					triangle { <9.5232, 103.8938, -28.5486>, <12.1428, 101.2194, -25.3705>, <9.491, 100.621, -29.5057> }
					triangle { <9.3855, 101.8327, -33.2534>, <11.5957, 98.654, -32.6483>, <9.491, 100.621, -29.5057> }
					triangle { <9.3855, 101.8327, -33.2534>, <9.491, 100.621, -29.5057>, <11.5957, 98.654, -32.6483> }
					triangle { <9.491, 100.621, -29.5057>, <8.7364, 104.6879, -32.02144>, <9.3855, 101.8327, -33.2534> }
					triangle { <9.491, 100.621, -29.5057>, <9.3855, 101.8327, -33.2534>, <8.7364, 104.6879, -32.02144> }
					triangle { <9.5232, 103.8938, -28.5486>, <8.7364, 104.6879, -32.02144>, <9.491, 100.621, -29.5057> }
					triangle { <9.5232, 103.8938, -28.5486>, <9.491, 100.621, -29.5057>, <8.7364, 104.6879, -32.02144> }
					triangle { <11.4684, 107.5056, -29.5988>, <8.7364, 104.6879, -32.02144>, <9.5232, 103.8938, -28.5486> }
					triangle { <11.4684, 107.5056, -29.5988>, <9.5232, 103.8938, -28.5486>, <8.7364, 104.6879, -32.02144> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <16.455, 95.2935, -16.02277>, <16.9396, 96.9765, -17.1305>, 0.2825 }
			cylinder { <16.9396, 96.9765, -17.1305>, <17.4242, 98.6595, -18.2382>, 0.2825 }
			cylinder { <17.4242, 98.6595, -18.2382>, <17.9087, 100.3425, -19.346>, 0.2825 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <17.9087, 100.3425, -19.346>, <19.14, 104.2161, -20.156>, 0.2825 }
				cylinder { <19.14, 104.2161, -20.156>, <20.4684, 108.0783, -19.4519>, 0.2825 }
				cylinder { <20.4684, 108.0783, -19.4519>, <21.7159, 111.4115, -17.3281>, 0.2825 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <22.3693, 116.1155, -16.07896>, <23.4857, 114.0973, -13.5672>, <21.7159, 111.4115, -17.3281> }
					triangle { <22.3693, 116.1155, -16.07896>, <21.7159, 111.4115, -17.3281>, <23.4857, 114.0973, -13.5672> }
					triangle { <22.3409, 116.8526, -10.9938>, <21.7274, 113.1727, -9.7952>, <23.4857, 114.0973, -13.5672> }
					triangle { <22.3409, 116.8526, -10.9938>, <23.4857, 114.0973, -13.5672>, <21.7274, 113.1727, -9.7952> }
					triangle { <23.4857, 114.0973, -13.5672>, <22.05536, 118.7224, -13.546>, <22.3409, 116.8526, -10.9938> }
					triangle { <23.4857, 114.0973, -13.5672>, <22.3409, 116.8526, -10.9938>, <22.05536, 118.7224, -13.546> }
					triangle { <22.3693, 116.1155, -16.07896>, <22.05536, 118.7224, -13.546>, <23.4857, 114.0973, -13.5672> }
					triangle { <22.3693, 116.1155, -16.07896>, <23.4857, 114.0973, -13.5672>, <22.05536, 118.7224, -13.546> }
					triangle { <18.9943, 118.5057, -16.9892>, <22.05536, 118.7224, -13.546>, <22.3693, 116.1155, -16.07896> }
					triangle { <18.9943, 118.5057, -16.9892>, <22.3693, 116.1155, -16.07896>, <22.05536, 118.7224, -13.546> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <21.5404, 115.3981, -14.466>, <24.7907, 114.5903, -15.1074>, <21.7159, 111.4115, -17.3281> }
					triangle { <21.5404, 115.3981, -14.466>, <21.7159, 111.4115, -17.3281>, <24.7907, 114.5903, -15.1074> }
					triangle { <25.7151, 115.9228, -11.5166>, <27.7059, 112.731, -12.6137>, <24.7907, 114.5903, -15.1074> }
					triangle { <25.7151, 115.9228, -11.5166>, <24.7907, 114.5903, -15.1074>, <27.7059, 112.731, -12.6137> }
					triangle { <24.7907, 114.5903, -15.1074>, <22.7894, 117.1606, -11.526>, <25.7151, 115.9228, -11.5166> }
					triangle { <24.7907, 114.5903, -15.1074>, <25.7151, 115.9228, -11.5166>, <22.7894, 117.1606, -11.526> }
					triangle { <21.5404, 115.3981, -14.466>, <22.7894, 117.1606, -11.526>, <24.7907, 114.5903, -15.1074> }
					triangle { <21.5404, 115.3981, -14.466>, <24.7907, 114.5903, -15.1074>, <22.7894, 117.1606, -11.526> }
					triangle { <18.7145, 115.0087, -11.3363>, <22.7894, 117.1606, -11.526>, <21.5404, 115.3981, -14.466> }
					triangle { <18.7145, 115.0087, -11.3363>, <21.5404, 115.3981, -14.466>, <22.7894, 117.1606, -11.526> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <22.8612, 114.3087, -13.5321>, <23.784, 115.8201, -16.4462>, <21.7159, 111.4115, -17.3281> }
					triangle { <22.8612, 114.3087, -13.5321>, <21.7159, 111.4115, -17.3281>, <23.784, 115.8201, -16.4462> }
					triangle { <26.8267, 117.4224, -14.523>, <27.6438, 116.3069, -18.1895>, <23.784, 115.8201, -16.4462> }
					triangle { <26.8267, 117.4224, -14.523>, <23.784, 115.8201, -16.4462>, <27.6438, 116.3069, -18.1895> }
					triangle { <23.784, 115.8201, -16.4462>, <25.3223, 116.4505, -11.8994>, <26.8267, 117.4224, -14.523> }
					triangle { <23.784, 115.8201, -16.4462>, <26.8267, 117.4224, -14.523>, <25.3223, 116.4505, -11.8994> }
					triangle { <22.8612, 114.3087, -13.5321>, <25.3223, 116.4505, -11.8994>, <23.784, 115.8201, -16.4462> }
					triangle { <22.8612, 114.3087, -13.5321>, <23.784, 115.8201, -16.4462>, <25.3223, 116.4505, -11.8994> }
					triangle { <24.6451, 112.1599, -10.3489>, <25.3223, 116.4505, -11.8994>, <22.8612, 114.3087, -13.5321> }
					triangle { <24.6451, 112.1599, -10.3489>, <22.8612, 114.3087, -13.5321>, <25.3223, 116.4505, -11.8994> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <24.5188, 114.3427, -14.5591>, <21.8474, 116.0987, -15.7459>, <21.7159, 111.4115, -17.3281> }
					triangle { <24.5188, 114.3427, -14.5591>, <21.7159, 111.4115, -17.3281>, <21.8474, 116.0987, -15.7459> }
					triangle { <24.1499, 119.2929, -15.8864>, <21.6264, 118.992, -18.8691>, <21.8474, 116.0987, -15.7459> }
					triangle { <24.1499, 119.2929, -15.8864>, <21.8474, 116.0987, -15.7459>, <21.6264, 118.992, -18.8691> }
					triangle { <21.8474, 116.0987, -15.7459>, <26.1771, 117.5669, -14.1536>, <24.1499, 119.2929, -15.8864> }
					triangle { <21.8474, 116.0987, -15.7459>, <24.1499, 119.2929, -15.8864>, <26.1771, 117.5669, -14.1536> }
					triangle { <24.5188, 114.3427, -14.5591>, <26.1771, 117.5669, -14.1536>, <21.8474, 116.0987, -15.7459> }
					triangle { <24.5188, 114.3427, -14.5591>, <21.8474, 116.0987, -15.7459>, <26.1771, 117.5669, -14.1536> }
					triangle { <28.6456, 113.8698, -15.3823>, <26.1771, 117.5669, -14.1536>, <24.5188, 114.3427, -14.5591> }
					triangle { <28.6456, 113.8698, -15.3823>, <24.5188, 114.3427, -14.5591>, <26.1771, 117.5669, -14.1536> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <24.2102, 115.4763, -16.1569>, <21.6603, 115.0179, -13.9397>, <21.7159, 111.4115, -17.3281> }
					triangle { <24.2102, 115.4763, -16.1569>, <21.7159, 111.4115, -17.3281>, <21.6603, 115.0179, -13.9397> }
					triangle { <21.3356, 118.9355, -13.6723>, <17.9147, 117.0257, -13.6028>, <21.6603, 115.0179, -13.9397> }
					triangle { <21.3356, 118.9355, -13.6723>, <21.6603, 115.0179, -13.9397>, <17.9147, 117.0257, -13.6028> }
					triangle { <21.6603, 115.0179, -13.9397>, <24.1276, 118.9922, -15.1867>, <21.3356, 118.9355, -13.6723> }
					triangle { <21.6603, 115.0179, -13.9397>, <21.3356, 118.9355, -13.6723>, <24.1276, 118.9922, -15.1867> }
					triangle { <24.2102, 115.4763, -16.1569>, <24.1276, 118.9922, -15.1867>, <21.6603, 115.0179, -13.9397> }
					triangle { <24.2102, 115.4763, -16.1569>, <21.6603, 115.0179, -13.9397>, <24.1276, 118.9922, -15.1867> }
					triangle { <25.1005, 117.8509, -19.5482>, <24.1276, 118.9922, -15.1867>, <24.2102, 115.4763, -16.1569> }
					triangle { <25.1005, 117.8509, -19.5482>, <24.2102, 115.4763, -16.1569>, <24.1276, 118.9922, -15.1867> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		}
	union { // Internode
		cylinder { <7.7122, 64.3265, 2.7143>, <8.7828, 69.4668, 3.2137>, 0.4794 }
		cylinder { <8.7828, 69.4668, 3.2137>, <9.8533, 74.6072, 3.7132>, 0.4794 }
		cylinder { <9.8533, 74.6072, 3.7132>, <10.9238, 79.7476, 4.2126>, 0.4794 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <10.9238, 79.7476, 4.2126>, <10.7375, 84.2033, 5.6072>, 0.3185 }
			cylinder { <10.7375, 84.2033, 5.6072>, <9.4352, 88.111, 7.8132>, 0.3185 }
			cylinder { <9.4352, 88.111, 7.8132>, <7.1484, 91.07639, 10.6078>, 0.3185 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <7.1484, 91.07639, 10.6078>, <6.4422, 91.94, 11.4565>, 0.3185 }
				cylinder { <6.4422, 91.94, 11.4565>, <5.7162, 92.7773, 12.3149>, 0.3185 }
				cylinder { <5.7162, 92.7773, 12.3149>, <4.9709, 93.5877, 13.1825>, 0.3185 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <4.9709, 93.5877, 13.1825>, <4.5638, 94.186, 14.1283>, 0.08119 }
				cylinder { <4.5638, 94.186, 14.1283>, <4.4122, 94.6509, 15.2141>, 0.08119 }
				cylinder { <4.4122, 94.6509, 15.2141>, <4.5271, 94.9487, 16.3614>, 0.08119 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <4.5271, 94.9487, 16.3614>, <12.6969, 96.8474, 8.6483>, <16.2149, 98.7976, 15.6467> }
				triangle { <4.5271, 94.9487, 16.3614>, <16.2149, 98.7976, 15.6467>, <12.6969, 96.8474, 8.6483> }
				triangle { <4.5271, 94.9487, 16.3614>, <16.2149, 98.7976, 15.6467>, <15.05905, 102.2507, 29.4162> }
				triangle { <4.5271, 94.9487, 16.3614>, <15.05905, 102.2507, 29.4162>, <16.2149, 98.7976, 15.6467> }
				triangle { <4.5271, 94.9487, 16.3614>, <15.05905, 102.2507, 29.4162>, <6.5909, 103.9533, 37.6796> }
				triangle { <4.5271, 94.9487, 16.3614>, <6.5909, 103.9533, 37.6796>, <15.05905, 102.2507, 29.4162> }
				triangle { <4.5271, 94.9487, 16.3614>, <6.5909, 103.9533, 37.6796>, <-3.9226, 101.7891, 31.1465> }
				triangle { <4.5271, 94.9487, 16.3614>, <-3.9226, 101.7891, 31.1465>, <6.5909, 103.9533, 37.6796> }
				triangle { <4.5271, 94.9487, 16.3614>, <-3.9226, 101.7891, 31.1465>, <-7.7571, 98.3024, 18.1766> }
				triangle { <4.5271, 94.9487, 16.3614>, <-7.7571, 98.3024, 18.1766>, <-3.9226, 101.7891, 31.1465> }
				triangle { <4.5271, 94.9487, 16.3614>, <-7.7571, 98.3024, 18.1766>, <-5.1156, 96.549, 10.8011> }
				triangle { <4.5271, 94.9487, 16.3614>, <-5.1156, 96.549, 10.8011>, <-7.7571, 98.3024, 18.1766> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <4.9709, 93.5877, 13.1825>, <4.2067, 94.3706, 14.0589>, 0.3185 }
				cylinder { <4.2067, 94.3706, 14.0589>, <3.4241, 95.1257, 14.9434>, 0.3185 }
				cylinder { <3.4241, 95.1257, 14.9434>, <2.6236, 95.8524, 15.8355>, 0.3185 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <2.6236, 95.8524, 15.8355>, <1.765, 96.5126, 16.3306>, 0.08119 }
				cylinder { <1.765, 96.5126, 16.3306>, <0.7901, 97.1677, 16.5271>, 0.08119 }
				cylinder { <0.7901, 97.1677, 16.5271>, <-0.2303, 97.7704, 16.4107>, 0.08119 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-0.2303, 97.7704, 16.4107>, <9.3386, 102.546, 20.3442>, <3.7731, 108.29, 21.4346> }
				triangle { <-0.2303, 97.7704, 16.4107>, <3.7731, 108.29, 21.4346>, <9.3386, 102.546, 20.3442> }
				triangle { <-0.2303, 97.7704, 16.4107>, <3.7731, 108.29, 21.4346>, <-9.06802, 113.6619, 18.4168> }
				triangle { <-0.2303, 97.7704, 16.4107>, <-9.06802, 113.6619, 18.4168>, <3.7731, 108.29, 21.4346> }
				triangle { <-0.2303, 97.7704, 16.4107>, <-9.06802, 113.6619, 18.4168>, <-18.5942, 111.1786, 11.6363> }
				triangle { <-0.2303, 97.7704, 16.4107>, <-18.5942, 111.1786, 11.6363>, <-9.06802, 113.6619, 18.4168> }
				triangle { <-0.2303, 97.7704, 16.4107>, <-18.5942, 111.1786, 11.6363>, <-15.09123, 100.5094, 5.9972> }
				triangle { <-0.2303, 97.7704, 16.4107>, <-15.09123, 100.5094, 5.9972>, <-18.5942, 111.1786, 11.6363> }
				triangle { <-0.2303, 97.7704, 16.4107>, <-15.09123, 100.5094, 5.9972>, <-4.1482, 91.8354, 5.6928> }
				triangle { <-0.2303, 97.7704, 16.4107>, <-4.1482, 91.8354, 5.6928>, <-15.09123, 100.5094, 5.9972> }
				triangle { <-0.2303, 97.7704, 16.4107>, <-4.1482, 91.8354, 5.6928>, <3.2033, 90.4426, 8.602> }
				triangle { <-0.2303, 97.7704, 16.4107>, <3.2033, 90.4426, 8.602>, <-4.1482, 91.8354, 5.6928> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <2.6236, 95.8524, 15.8355>, <1.9435, 96.4698, 16.5934>, 0.08119 }
				cylinder { <1.9435, 96.4698, 16.5934>, <1.2634, 97.08722, 17.3514>, 0.08119 }
				cylinder { <1.2634, 97.08722, 17.3514>, <0.5832, 97.7046, 18.1093>, 0.08119 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <0.5832, 97.7046, 18.1093>, <11.5735, 100.1195, 16.3132>, <9.55, 104.9681, 22.4413> }
				triangle { <0.5832, 97.7046, 18.1093>, <9.55, 104.9681, 22.4413>, <11.5735, 100.1195, 16.3132> }
				triangle { <0.5832, 97.7046, 18.1093>, <9.55, 104.9681, 22.4413>, <-0.525, 111.4034, 30.1833> }
				triangle { <0.5832, 97.7046, 18.1093>, <-0.525, 111.4034, 30.1833>, <9.55, 104.9681, 22.4413> }
				triangle { <0.5832, 97.7046, 18.1093>, <-0.525, 111.4034, 30.1833>, <-12.4365, 112.2771, 30.6764> }
				triangle { <0.5832, 97.7046, 18.1093>, <-12.4365, 112.2771, 30.6764>, <-0.525, 111.4034, 30.1833> }
				triangle { <0.5832, 97.7046, 18.1093>, <-12.4365, 112.2771, 30.6764>, <-16.00182, 104.9721, 21.09379> }
				triangle { <0.5832, 97.7046, 18.1093>, <-16.00182, 104.9721, 21.09379>, <-12.4365, 112.2771, 30.6764> }
				triangle { <0.5832, 97.7046, 18.1093>, <-16.00182, 104.9721, 21.09379>, <-10.2259, 97.01832, 11.1713> }
				triangle { <0.5832, 97.7046, 18.1093>, <-10.2259, 97.01832, 11.1713>, <-16.00182, 104.9721, 21.09379> }
				triangle { <0.5832, 97.7046, 18.1093>, <-10.2259, 97.01832, 11.1713>, <-3.3036, 94.3486, 8.1047> }
				triangle { <0.5832, 97.7046, 18.1093>, <-3.3036, 94.3486, 8.1047>, <-10.2259, 97.01832, 11.1713> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <10.9238, 79.7476, 4.2126>, <11.5925, 82.3166, 4.4654>, 0.2424 }
		cylinder { <11.5925, 82.3166, 4.4654>, <12.3869, 84.8495, 4.718>, 0.2424 }
		cylinder { <12.3869, 84.8495, 4.718>, <13.3053, 87.3402, 4.9697>, 0.2424 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <13.3053, 87.3402, 4.9697>, <14.458, 88.7845, 5.1307>, 0.1264 }
			cylinder { <14.458, 88.7845, 5.1307>, <16.00813, 89.7948, 5.2614>, 0.1264 }
			cylinder { <16.00813, 89.7948, 5.2614>, <17.7992, 90.269, 5.3486>, 0.1264 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <17.7992, 90.269, 5.3486>, <18.3399, 90.3981, 5.3736>, 0.1264 }
				cylinder { <18.3399, 90.3981, 5.3736>, <18.8837, 90.5139, 5.3974>, 0.1264 }
				cylinder { <18.8837, 90.5139, 5.3974>, <19.4301, 90.6164, 5.4201>, 0.1264 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <19.4301, 90.6164, 5.4201>, <19.609, 90.6543, 5.3777>, 0.01279 }
				cylinder { <19.609, 90.6543, 5.3777>, <19.7694, 90.6928, 5.2882>, 0.01279 }
				cylinder { <19.7694, 90.6928, 5.2882>, <19.8997, 90.7291, 5.1582>, 0.01279 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <19.8997, 90.7291, 5.1582>, <16.167, 93.2365, 5.6495>, <17.5095, 94.4037, 2.9843> }
				triangle { <19.8997, 90.7291, 5.1582>, <17.5095, 94.4037, 2.9843>, <16.167, 93.2365, 5.6495> }
				triangle { <19.8997, 90.7291, 5.1582>, <17.5095, 94.4037, 2.9843>, <22.04556, 94.9525, -0.3461> }
				triangle { <19.8997, 90.7291, 5.1582>, <22.04556, 94.9525, -0.3461>, <17.5095, 94.4037, 2.9843> }
				triangle { <19.8997, 90.7291, 5.1582>, <22.04556, 94.9525, -0.3461>, <26.5912, 93.5996, -0.5032> }
				triangle { <19.8997, 90.7291, 5.1582>, <26.5912, 93.5996, -0.5032>, <22.04556, 94.9525, -0.3461> }
				triangle { <19.8997, 90.7291, 5.1582>, <26.5912, 93.5996, -0.5032>, <27.03373, 90.9457, 3.6973> }
				triangle { <19.8997, 90.7291, 5.1582>, <27.03373, 90.9457, 3.6973>, <26.5912, 93.5996, -0.5032> }
				triangle { <19.8997, 90.7291, 5.1582>, <27.03373, 90.9457, 3.6973>, <23.9159, 89.3636, 8.000605> }
				triangle { <19.8997, 90.7291, 5.1582>, <23.9159, 89.3636, 8.000605>, <27.03373, 90.9457, 3.6973> }
				triangle { <19.8997, 90.7291, 5.1582>, <23.9159, 89.3636, 8.000605>, <21.01189, 89.5072, 9.3054> }
				triangle { <19.8997, 90.7291, 5.1582>, <21.01189, 89.5072, 9.3054>, <23.9159, 89.3636, 8.000605> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <19.4301, 90.6164, 5.4201>, <19.979, 90.7055, 5.4417>, 0.1264 }
				cylinder { <19.979, 90.7055, 5.4417>, <20.5299, 90.7811, 5.462>, 0.1264 }
				cylinder { <20.5299, 90.7811, 5.462>, <21.08261, 90.8433, 5.4812>, 0.1264 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <21.08261, 90.8433, 5.4812>, <21.261, 90.8589, 5.5372>, 0.01279 }
				cylinder { <21.261, 90.8589, 5.5372>, <21.4185, 90.868, 5.6388>, 0.01279 }
				cylinder { <21.4185, 90.868, 5.6388>, <21.5438, 90.87, 5.7786>, 0.01279 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <21.5438, 90.87, 5.7786>, <21.06443, 94.3023, 2.8714>, <23.6517, 95.119, 4.5764> }
				triangle { <21.5438, 90.87, 5.7786>, <23.6517, 95.119, 4.5764>, <21.06443, 94.3023, 2.8714> }
				triangle { <21.5438, 90.87, 5.7786>, <23.6517, 95.119, 4.5764>, <26.8411, 94.4717, 9.1999> }
				triangle { <21.5438, 90.87, 5.7786>, <26.8411, 94.4717, 9.1999>, <23.6517, 95.119, 4.5764> }
				triangle { <21.5438, 90.87, 5.7786>, <26.8411, 94.4717, 9.1999>, <26.9255, 91.9136, 13.1958> }
				triangle { <21.5438, 90.87, 5.7786>, <26.9255, 91.9136, 13.1958>, <26.8411, 94.4717, 9.1999> }
				triangle { <21.5438, 90.87, 5.7786>, <26.9255, 91.9136, 13.1958>, <22.8087, 89.1337, 12.7398> }
				triangle { <21.5438, 90.87, 5.7786>, <22.8087, 89.1337, 12.7398>, <26.9255, 91.9136, 13.1958> }
				triangle { <21.5438, 90.87, 5.7786>, <22.8087, 89.1337, 12.7398>, <18.6458, 88.3695, 9.1582> }
				triangle { <21.5438, 90.87, 5.7786>, <18.6458, 88.3695, 9.1582>, <22.8087, 89.1337, 12.7398> }
				triangle { <21.5438, 90.87, 5.7786>, <18.6458, 88.3695, 9.1582>, <17.4134, 89.2805, 6.364> }
				triangle { <21.5438, 90.87, 5.7786>, <17.4134, 89.2805, 6.364>, <18.6458, 88.3695, 9.1582> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <21.08261, 90.8433, 5.4812>, <21.2689, 90.8642, 5.4876>, 0.01279 }
				cylinder { <21.2689, 90.8642, 5.4876>, <21.4553, 90.8852, 5.4941>, 0.01279 }
				cylinder { <21.4553, 90.8852, 5.4941>, <21.6417, 90.9062, 5.5005>, 0.01279 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <21.6417, 90.9062, 5.5005>, <18.8948, 93.9827, 3.6429>, <21.8249, 95.05633, 2.915> }
				triangle { <21.6417, 90.9062, 5.5005>, <21.8249, 95.05633, 2.915>, <18.8948, 93.9827, 3.6429> }
				triangle { <21.6417, 90.9062, 5.5005>, <21.8249, 95.05633, 2.915>, <27.4002, 95.01363, 3.8546> }
				triangle { <21.6417, 90.9062, 5.5005>, <27.4002, 95.01363, 3.8546>, <21.8249, 95.05633, 2.915> }
				triangle { <21.6417, 90.9062, 5.5005>, <27.4002, 95.01363, 3.8546>, <30.5633, 92.9139, 6.7012> }
				triangle { <21.6417, 90.9062, 5.5005>, <30.5633, 92.9139, 6.7012>, <27.4002, 95.01363, 3.8546> }
				triangle { <21.6417, 90.9062, 5.5005>, <30.5633, 92.9139, 6.7012>, <27.6581, 89.983, 9.5036> }
				triangle { <21.6417, 90.9062, 5.5005>, <27.6581, 89.983, 9.5036>, <30.5633, 92.9139, 6.7012> }
				triangle { <21.6417, 90.9062, 5.5005>, <27.6581, 89.983, 9.5036>, <22.2909, 88.7097, 10.06424> }
				triangle { <21.6417, 90.9062, 5.5005>, <22.2909, 88.7097, 10.06424>, <27.6581, 89.983, 9.5036> }
				triangle { <21.6417, 90.9062, 5.5005>, <22.2909, 88.7097, 10.06424>, <19.3521, 89.2721, 8.9671> }
				triangle { <21.6417, 90.9062, 5.5005>, <19.3521, 89.2721, 8.9671>, <22.2909, 88.7097, 10.06424> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <13.3053, 87.3402, 4.9697>, <15.4407, 93.1317, 5.5549>, 0.2818 }
			cylinder { <15.4407, 93.1317, 5.5549>, <17.5761, 98.9231, 6.1402>, 0.2818 }
			cylinder { <17.5761, 98.9231, 6.1402>, <19.7115, 104.7146, 6.7254>, 0.2818 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <19.7115, 104.7146, 6.7254>, <20.4233, 106.6451, 6.9205>, 0.2818 }
			cylinder { <20.4233, 106.6451, 6.9205>, <21.1351, 108.5756, 7.1156>, 0.2818 }
			cylinder { <21.1351, 108.5756, 7.1156>, <21.8469, 110.5061, 7.3107>, 0.2818 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <21.8469, 110.5061, 7.3107>, <23.2762, 113.9222, 9.1472>, 0.2818 }
				cylinder { <23.2762, 113.9222, 9.1472>, <24.5196, 116.4359, 12.1839>, 0.2818 }
				cylinder { <24.5196, 116.4359, 12.1839>, <25.4104, 117.71, 16.01394>, 0.2818 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <25.9085, 120.6724, 19.8986>, <26.5001, 117.447, 20.834>, <25.4104, 117.71, 16.01394> }
					triangle { <25.9085, 120.6724, 19.8986>, <25.4104, 117.71, 16.01394>, <26.5001, 117.447, 20.834> }
					triangle { <24.9488, 118.2996, 24.3541>, <24.05408, 114.7251, 23.02089>, <26.5001, 117.447, 20.834> }
					triangle { <24.9488, 118.2996, 24.3541>, <26.5001, 117.447, 20.834>, <24.05408, 114.7251, 23.02089> }
					triangle { <26.5001, 117.447, 20.834>, <25.178, 121.325, 23.413>, <24.9488, 118.2996, 24.3541> }
					triangle { <26.5001, 117.447, 20.834>, <24.9488, 118.2996, 24.3541>, <25.178, 121.325, 23.413> }
					triangle { <25.9085, 120.6724, 19.8986>, <25.178, 121.325, 23.413>, <26.5001, 117.447, 20.834> }
					triangle { <25.9085, 120.6724, 19.8986>, <26.5001, 117.447, 20.834>, <25.178, 121.325, 23.413> }
					triangle { <22.8072, 123.5458, 20.139>, <25.178, 121.325, 23.413>, <25.9085, 120.6724, 19.8986> }
					triangle { <22.8072, 123.5458, 20.139>, <25.9085, 120.6724, 19.8986>, <25.178, 121.325, 23.413> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <24.7808, 119.2598, 20.6309>, <28.07787, 118.5772, 20.09113>, <25.4104, 117.71, 16.01394> }
					triangle { <24.7808, 119.2598, 20.6309>, <25.4104, 117.71, 16.01394>, <28.07787, 118.5772, 20.09113> }
					triangle { <28.3432, 117.4342, 23.8524>, <30.443, 115.2634, 21.3557>, <28.07787, 118.5772, 20.09113> }
					triangle { <28.3432, 117.4342, 23.8524>, <28.07787, 118.5772, 20.09113>, <30.443, 115.2634, 21.3557> }
					triangle { <28.07787, 118.5772, 20.09113>, <25.4942, 118.8008, 24.1792>, <28.3432, 117.4342, 23.8524> }
					triangle { <28.07787, 118.5772, 20.09113>, <28.3432, 117.4342, 23.8524>, <25.4942, 118.8008, 24.1792> }
					triangle { <24.7808, 119.2598, 20.6309>, <25.4942, 118.8008, 24.1792>, <28.07787, 118.5772, 20.09113> }
					triangle { <24.7808, 119.2598, 20.6309>, <28.07787, 118.5772, 20.09113>, <25.4942, 118.8008, 24.1792> }
					triangle { <21.4153, 117.4766, 22.4819>, <25.4942, 118.8008, 24.1792>, <24.7808, 119.2598, 20.6309> }
					triangle { <21.4153, 117.4766, 22.4819>, <24.7808, 119.2598, 20.6309>, <25.4942, 118.8008, 24.1792> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <25.8841, 117.6747, 20.9016>, <27.361, 120.4718, 19.6275>, <25.4104, 117.71, 16.01394> }
					triangle { <25.8841, 117.6747, 20.9016>, <25.4104, 117.71, 16.01394>, <27.361, 120.4718, 19.6275> }
					triangle { <30.02263, 120.2519, 22.5244>, <31.4861, 121.394, 19.07355>, <27.361, 120.4718, 19.6275> }
					triangle { <30.02263, 120.2519, 22.5244>, <27.361, 120.4718, 19.6275>, <31.4861, 121.394, 19.07355> }
					triangle { <27.361, 120.4718, 19.6275>, <28.03852, 118.1303, 23.8104>, <30.02263, 120.2519, 22.5244> }
					triangle { <27.361, 120.4718, 19.6275>, <30.02263, 120.2519, 22.5244>, <28.03852, 118.1303, 23.8104> }
					triangle { <25.8841, 117.6747, 20.9016>, <28.03852, 118.1303, 23.8104>, <27.361, 120.4718, 19.6275> }
					triangle { <25.8841, 117.6747, 20.9016>, <27.361, 120.4718, 19.6275>, <28.03852, 118.1303, 23.8104> }
					triangle { <27.00427, 113.8687, 22.3821>, <28.03852, 118.1303, 23.8104>, <25.8841, 117.6747, 20.9016> }
					triangle { <27.00427, 113.8687, 22.3821>, <25.8841, 117.6747, 20.9016>, <28.03852, 118.1303, 23.8104> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <27.7041, 118.0928, 20.3392>, <25.3335, 120.5303, 20.07973>, <25.4104, 117.71, 16.01394> }
					triangle { <27.7041, 118.0928, 20.3392>, <25.4104, 117.71, 16.01394>, <25.3335, 120.5303, 20.07973> }
					triangle { <27.6817, 122.885, 22.1929>, <25.7516, 124.7019, 19.3069>, <25.3335, 120.5303, 20.07973> }
					triangle { <27.6817, 122.885, 22.1929>, <25.3335, 120.5303, 20.07973>, <25.7516, 124.7019, 19.3069> }
					triangle { <25.3335, 120.5303, 20.07973>, <29.3185, 120.234, 22.8128>, <27.6817, 122.885, 22.1929> }
					triangle { <25.3335, 120.5303, 20.07973>, <27.6817, 122.885, 22.1929>, <29.3185, 120.234, 22.8128> }
					triangle { <27.7041, 118.0928, 20.3392>, <29.3185, 120.234, 22.8128>, <25.3335, 120.5303, 20.07973> }
					triangle { <27.7041, 118.0928, 20.3392>, <25.3335, 120.5303, 20.07973>, <29.3185, 120.234, 22.8128> }
					triangle { <31.9024, 117.6745, 19.9766>, <29.3185, 120.234, 22.8128>, <27.7041, 118.0928, 20.3392> }
					triangle { <31.9024, 117.6745, 19.9766>, <27.7041, 118.0928, 20.3392>, <29.3185, 120.234, 22.8128> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <27.7194, 119.9735, 19.7099>, <24.7935, 118.6326, 20.8366>, <25.4104, 117.71, 16.01394> }
					triangle { <27.7194, 119.9735, 19.7099>, <25.4104, 117.71, 16.01394>, <24.7935, 118.6326, 20.8366> }
					triangle { <24.4985, 121.6602, 23.3408>, <21.08907, 120.5181, 21.7834>, <24.7935, 118.6326, 20.8366> }
					triangle { <24.4985, 121.6602, 23.3408>, <24.7935, 118.6326, 20.8366>, <21.08907, 120.5181, 21.7834> }
					triangle { <24.7935, 118.6326, 20.8366>, <27.5239, 122.2382, 22.5635>, <24.4985, 121.6602, 23.3408> }
					triangle { <24.7935, 118.6326, 20.8366>, <24.4985, 121.6602, 23.3408>, <27.5239, 122.2382, 22.5635> }
					triangle { <27.7194, 119.9735, 19.7099>, <27.5239, 122.2382, 22.5635>, <24.7935, 118.6326, 20.8366> }
					triangle { <27.7194, 119.9735, 19.7099>, <24.7935, 118.6326, 20.8366>, <27.5239, 122.2382, 22.5635> }
					triangle { <29.2694, 123.7456, 18.5694>, <27.5239, 122.2382, 22.5635>, <27.7194, 119.9735, 19.7099> }
					triangle { <29.2694, 123.7456, 18.5694>, <27.7194, 119.9735, 19.7099>, <27.5239, 122.2382, 22.5635> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <21.8469, 110.5061, 7.3107>, <22.5587, 112.4365, 7.5057>, 0.2818 }
			cylinder { <22.5587, 112.4365, 7.5057>, <23.2705, 114.367, 7.7008>, 0.2818 }
			cylinder { <23.2705, 114.367, 7.7008>, <23.9823, 116.2975, 7.8959>, 0.2818 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <23.9823, 116.2975, 7.8959>, <26.1711, 119.7035, 7.06251>, 0.2818 }
				cylinder { <26.1711, 119.7035, 7.06251>, <28.8317, 122.198, 5.1171>, 0.2818 }
				cylinder { <28.8317, 122.198, 5.1171>, <31.6076, 123.4467, 2.3205>, 0.2818 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <35.4695, 125.7597, 0.358>, <34.191, 123.5465, -1.8992>, <31.6076, 123.4467, 2.3205> }
					triangle { <35.4695, 125.7597, 0.358>, <31.6076, 123.4467, 2.3205>, <34.191, 123.5465, -1.8992> }
					triangle { <37.8508, 122.9688, -3.2393>, <35.6419, 119.7338, -3.1369>, <34.191, 123.5465, -1.8992> }
					triangle { <37.8508, 122.9688, -3.2393>, <34.191, 123.5465, -1.8992>, <35.6419, 119.7338, -3.1369> }
					triangle { <34.191, 123.5465, -1.8992>, <38.5873, 125.5386, -1.5234>, <37.8508, 122.9688, -3.2393> }
					triangle { <34.191, 123.5465, -1.8992>, <37.8508, 122.9688, -3.2393>, <38.5873, 125.5386, -1.5234> }
					triangle { <35.4695, 125.7597, 0.358>, <38.5873, 125.5386, -1.5234>, <34.191, 123.5465, -1.8992> }
					triangle { <35.4695, 125.7597, 0.358>, <34.191, 123.5465, -1.8992>, <38.5873, 125.5386, -1.5234> }
					triangle { <38.7184, 126.043, 3.05919>, <38.5873, 125.5386, -1.5234>, <35.4695, 125.7597, 0.358> }
					triangle { <38.7184, 126.043, 3.05919>, <35.4695, 125.7597, 0.358>, <38.5873, 125.5386, -1.5234> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <35.8714, 123.9007, -0.0731>, <33.401, 125.4671, -1.8257>, <31.6076, 123.4467, 2.3205> }
					triangle { <35.8714, 123.9007, -0.0731>, <31.6076, 123.4467, 2.3205>, <33.401, 125.4671, -1.8257> }
					triangle { <35.2638, 124.4508, -5.1456>, <31.3559, 124.2652, -5.3679>, <33.401, 125.4671, -1.8257> }
					triangle { <35.2638, 124.4508, -5.1456>, <33.401, 125.4671, -1.8257>, <31.3559, 124.2652, -5.3679> }
					triangle { <33.401, 125.4671, -1.8257>, <37.6887, 123.7123, -3.2309>, <35.2638, 124.4508, -5.1456> }
					triangle { <33.401, 125.4671, -1.8257>, <35.2638, 124.4508, -5.1456>, <37.6887, 123.7123, -3.2309> }
					triangle { <35.8714, 123.9007, -0.0731>, <37.6887, 123.7123, -3.2309>, <33.401, 125.4671, -1.8257> }
					triangle { <35.8714, 123.9007, -0.0731>, <33.401, 125.4671, -1.8257>, <37.6887, 123.7123, -3.2309> }
					triangle { <38.05019, 120.2712, -0.1814>, <37.6887, 123.7123, -3.2309>, <35.8714, 123.9007, -0.0731> }
					triangle { <38.05019, 120.2712, -0.1814>, <35.8714, 123.9007, -0.0731>, <37.6887, 123.7123, -3.2309> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <34.6795, 123.3343, -1.509>, <34.4081, 126.5302, -0.3513>, <31.6076, 123.4467, 2.3205> }
					triangle { <34.6795, 123.3343, -1.509>, <31.6076, 123.4467, 2.3205>, <34.4081, 126.5302, -0.3513> }
					triangle { <34.8575, 127.7932, -4.05641>, <32.2826, 129.8626, -1.9487>, <34.4081, 126.5302, -0.3513> }
					triangle { <34.8575, 127.7932, -4.05641>, <34.4081, 126.5302, -0.3513>, <32.2826, 129.8626, -1.9487> }
					triangle { <34.4081, 126.5302, -0.3513>, <35.7437, 124.8056, -4.6733>, <34.8575, 127.7932, -4.05641> }
					triangle { <34.4081, 126.5302, -0.3513>, <34.8575, 127.7932, -4.05641>, <35.7437, 124.8056, -4.6733> }
					triangle { <34.6795, 123.3343, -1.509>, <35.7437, 124.8056, -4.6733>, <34.4081, 126.5302, -0.3513> }
					triangle { <34.6795, 123.3343, -1.509>, <34.4081, 126.5302, -0.3513>, <35.7437, 124.8056, -4.6733> }
					triangle { <33.203, 120.9564, -4.6868>, <35.7437, 124.8056, -4.6733>, <34.6795, 123.3343, -1.509> }
					triangle { <33.203, 120.9564, -4.6868>, <34.6795, 123.3343, -1.509>, <35.7437, 124.8056, -4.6733> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <33.5298, 124.838, -1.9788>, <35.8299, 125.2766, 0.5001>, <31.6076, 123.4467, 2.3205> }
					triangle { <33.5298, 124.838, -1.9788>, <31.6076, 123.4467, 2.3205>, <35.8299, 125.2766, 0.5001> }
					triangle { <37.1897, 128.4081, -1.4668>, <37.1499, 128.8428, 2.4272>, <35.8299, 125.2766, 0.5001> }
					triangle { <37.1897, 128.4081, -1.4668>, <35.8299, 125.2766, 0.5001>, <37.1499, 128.8428, 2.4272> }
					triangle { <35.8299, 125.2766, 0.5001>, <35.4222, 127.3178, -3.8707>, <37.1897, 128.4081, -1.4668> }
					triangle { <35.8299, 125.2766, 0.5001>, <37.1897, 128.4081, -1.4668>, <35.4222, 127.3178, -3.8707> }
					triangle { <33.5298, 124.838, -1.9788>, <35.4222, 127.3178, -3.8707>, <35.8299, 125.2766, 0.5001> }
					triangle { <33.5298, 124.838, -1.9788>, <35.8299, 125.2766, 0.5001>, <35.4222, 127.3178, -3.8707> }
					triangle { <30.8304, 127.1582, -4.2726>, <35.4222, 127.3178, -3.8707>, <33.5298, 124.838, -1.9788> }
					triangle { <30.8304, 127.1582, -4.2726>, <33.5298, 124.838, -1.9788>, <35.4222, 127.3178, -3.8707> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <34.02548, 126.3596, -0.8074>, <35.6937, 123.4047, -0.4709>, <31.6076, 123.4467, 2.3205> }
					triangle { <34.02548, 126.3596, -0.8074>, <31.6076, 123.4467, 2.3205>, <35.6937, 123.4047, -0.4709> }
					triangle { <39.06767, 125.3814, -0.9542>, <39.2575, 122.4883, 1.6818>, <35.6937, 123.4047, -0.4709> }
					triangle { <39.06767, 125.3814, -0.9542>, <35.6937, 123.4047, -0.4709>, <39.2575, 122.4883, 1.6818> }
					triangle { <35.6937, 123.4047, -0.4709>, <37.2062, 127.7777, -1.8945>, <39.06767, 125.3814, -0.9542> }
					triangle { <35.6937, 123.4047, -0.4709>, <39.06767, 125.3814, -0.9542>, <37.2062, 127.7777, -1.8945> }
					triangle { <34.02548, 126.3596, -0.8074>, <37.2062, 127.7777, -1.8945>, <35.6937, 123.4047, -0.4709> }
					triangle { <34.02548, 126.3596, -0.8074>, <35.6937, 123.4047, -0.4709>, <37.2062, 127.7777, -1.8945> }
					triangle { <34.2905, 130.3493, 0.5868>, <37.2062, 127.7777, -1.8945>, <34.02548, 126.3596, -0.8074> }
					triangle { <34.2905, 130.3493, 0.5868>, <34.02548, 126.3596, -0.8074>, <37.2062, 127.7777, -1.8945> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <23.9823, 116.2975, 7.8959>, <24.6941, 118.228, 8.09104>, 0.2818 }
			cylinder { <24.6941, 118.228, 8.09104>, <25.4059, 120.1585, 8.2861>, 0.2818 }
			cylinder { <25.4059, 120.1585, 8.2861>, <26.1177, 122.0889, 8.4812>, 0.2818 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <26.1177, 122.0889, 8.4812>, <26.06958, 126.1682, 9.1472>, 0.2818 }
				cylinder { <26.06958, 126.1682, 9.1472>, <24.5561, 129.9189, 9.9999>, 0.2818 }
				cylinder { <24.5561, 129.9189, 9.9999>, <21.7802, 132.8386, 10.925>, 0.2818 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <19.523, 137.1984, 11.03483>, <17.5633, 134.8551, 12.5503>, <21.7802, 132.8386, 10.925> }
					triangle { <19.523, 137.1984, 11.03483>, <21.7802, 132.8386, 10.925>, <17.5633, 134.8551, 12.5503> }
					triangle { <14.4038, 136.7916, 11.2116>, <14.04774, 132.8897, 11.1531>, <17.5633, 134.8551, 12.5503> }
					triangle { <14.4038, 136.7916, 11.2116>, <17.5633, 134.8551, 12.5503>, <14.04774, 132.8897, 11.1531> }
					triangle { <17.5633, 134.8551, 12.5503>, <16.4601, 139.1166, 10.5353>, <14.4038, 136.7916, 11.2116> }
					triangle { <17.5633, 134.8551, 12.5503>, <14.4038, 136.7916, 11.2116>, <16.4601, 139.1166, 10.5353> }
					triangle { <19.523, 137.1984, 11.03483>, <16.4601, 139.1166, 10.5353>, <17.5633, 134.8551, 12.5503> }
					triangle { <19.523, 137.1984, 11.03483>, <17.5633, 134.8551, 12.5503>, <16.4601, 139.1166, 10.5353> }
					triangle { <19.7745, 139.2343, 7.3302>, <16.4601, 139.1166, 10.5353>, <19.523, 137.1984, 11.03483> }
					triangle { <19.7745, 139.2343, 7.3302>, <19.523, 137.1984, 11.03483>, <16.4601, 139.1166, 10.5353> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <18.09001, 136.0362, 10.4029>, <18.9897, 135.8511, 13.6868>, <21.7802, 132.8386, 10.925> }
					triangle { <18.09001, 136.0362, 10.4029>, <21.7802, 132.8386, 10.925>, <18.9897, 135.8511, 13.6868> }
					triangle { <15.2189, 136.48, 14.6411>, <17.0633, 133.9166, 16.9611>, <18.9897, 135.8511, 13.6868> }
					triangle { <15.2189, 136.48, 14.6411>, <18.9897, 135.8511, 13.6868>, <17.0633, 133.9166, 16.9611> }
					triangle { <18.9897, 135.8511, 13.6868>, <14.8656, 137.2683, 11.5841>, <15.2189, 136.48, 14.6411> }
					triangle { <18.9897, 135.8511, 13.6868>, <15.2189, 136.48, 14.6411>, <14.8656, 137.2683, 11.5841> }
					triangle { <18.09001, 136.0362, 10.4029>, <14.8656, 137.2683, 11.5841>, <18.9897, 135.8511, 13.6868> }
					triangle { <18.09001, 136.0362, 10.4029>, <18.9897, 135.8511, 13.6868>, <14.8656, 137.2683, 11.5841> }
					triangle { <15.04882, 134.5793, 7.8415>, <14.8656, 137.2683, 11.5841>, <18.09001, 136.0362, 10.4029> }
					triangle { <15.04882, 134.5793, 7.8415>, <18.09001, 136.0362, 10.4029>, <14.8656, 137.2683, 11.5841> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <17.4636, 134.9642, 11.9069>, <19.9877, 137.1914, 12.4516>, <21.7802, 132.8386, 10.925> }
					triangle { <17.4636, 134.9642, 11.9069>, <21.7802, 132.8386, 10.925>, <19.9877, 137.1914, 12.4516> }
					triangle { <17.841, 138.7423, 15.3689>, <21.6864, 138.5831, 16.1057>, <19.9877, 137.1914, 12.4516> }
					triangle { <17.841, 138.7423, 15.3689>, <19.9877, 137.1914, 12.4516>, <21.6864, 138.5831, 16.1057> }
					triangle { <19.9877, 137.1914, 12.4516>, <15.4617, 137.0186, 14.1612>, <17.841, 138.7423, 15.3689> }
					triangle { <19.9877, 137.1914, 12.4516>, <17.841, 138.7423, 15.3689>, <15.4617, 137.0186, 14.1612> }
					triangle { <17.4636, 134.9642, 11.9069>, <15.4617, 137.0186, 14.1612>, <19.9877, 137.1914, 12.4516> }
					triangle { <17.4636, 134.9642, 11.9069>, <19.9877, 137.1914, 12.4516>, <15.4617, 137.0186, 14.1612> }
					triangle { <14.8985, 132.441, 14.1397>, <15.4617, 137.0186, 14.1612>, <17.4636, 134.9642, 11.9069> }
					triangle { <14.8985, 132.441, 14.1397>, <17.4636, 134.9642, 11.9069>, <15.4617, 137.0186, 14.1612> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <18.5037, 135.4539, 13.4823>, <19.1875, 137.0363, 10.5401>, <21.7802, 132.8386, 10.925> }
					triangle { <18.5037, 135.4539, 13.4823>, <21.7802, 132.8386, 10.925>, <19.1875, 137.0363, 10.5401> }
					triangle { <18.6709, 140.4733, 12.396>, <21.5712, 140.4837, 9.761>, <19.1875, 137.0363, 10.5401> }
					triangle { <18.6709, 140.4733, 12.396>, <19.1875, 137.0363, 10.5401>, <21.5712, 140.4837, 9.761> }
					triangle { <19.1875, 137.0363, 10.5401>, <17.4301, 138.7101, 14.729>, <18.6709, 140.4733, 12.396> }
					triangle { <19.1875, 137.0363, 10.5401>, <18.6709, 140.4733, 12.396>, <17.4301, 138.7101, 14.729> }
					triangle { <18.5037, 135.4539, 13.4823>, <17.4301, 138.7101, 14.729>, <19.1875, 137.0363, 10.5401> }
					triangle { <18.5037, 135.4539, 13.4823>, <19.1875, 137.0363, 10.5401>, <17.4301, 138.7101, 14.729> }
					triangle { <19.53, 135.7544, 17.5797>, <17.4301, 138.7101, 14.729>, <18.5037, 135.4539, 13.4823> }
					triangle { <19.53, 135.7544, 17.5797>, <18.5037, 135.4539, 13.4823>, <17.4301, 138.7101, 14.729> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <19.7956, 136.8555, 12.9352>, <17.6665, 135.5706, 10.602>, <21.7802, 132.8386, 10.925> }
					triangle { <19.7956, 136.8555, 12.9352>, <21.7802, 132.8386, 10.925>, <17.6665, 135.5706, 10.602> }
					triangle { <16.5145, 139.2495, 9.7878>, <16.779, 136.912, 6.6539>, <17.6665, 135.5706, 10.602> }
					triangle { <16.5145, 139.2495, 9.7878>, <17.6665, 135.5706, 10.602>, <16.779, 136.912, 6.6539> }
					triangle { <17.6665, 135.5706, 10.602>, <18.05656, 140.0264, 12.4543>, <16.5145, 139.2495, 9.7878> }
					triangle { <17.6665, 135.5706, 10.602>, <16.5145, 139.2495, 9.7878>, <18.05656, 140.0264, 12.4543> }
					triangle { <19.7956, 136.8555, 12.9352>, <18.05656, 140.0264, 12.4543>, <17.6665, 135.5706, 10.602> }
					triangle { <19.7956, 136.8555, 12.9352>, <17.6665, 135.5706, 10.602>, <18.05656, 140.0264, 12.4543> }
					triangle { <22.589, 140.0163, 13.3076>, <18.05656, 140.0264, 12.4543>, <19.7956, 136.8555, 12.9352> }
					triangle { <22.589, 140.0163, 13.3076>, <19.7956, 136.8555, 12.9352>, <18.05656, 140.0264, 12.4543> }
					pigment { color rgb <0.996, 0.0, 0.996> }}
				}
			}
		}
translate <0,0,0>
} // end New_plant_1

#declare New_plant_4 = union {
	union { // Internode
		cylinder { <0.0, 0.0, 0.0>, <0.02366, 1.9556, -0.04177>, 0.3556 }
		cylinder { <0.02366, 1.9556, -0.04177>, <0.07097, 3.9095, -0.1252>, 0.3556 }
		cylinder { <0.07097, 3.9095, -0.1252>, <0.1419, 5.8605, -0.2505>, 0.3556 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // Internode
		cylinder { <0.1419, 5.8605, -0.2505>, <0.04433, 8.759, -0.3691>, 0.5277 }
		cylinder { <0.04433, 8.759, -0.3691>, <-0.2555, 11.6457, -0.4201>, 0.5277 }
		cylinder { <-0.2555, 11.6457, -0.4201>, <-0.756, 14.5047, -0.403>, 0.5277 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.756, 14.5047, -0.403>, <-1.8249, 16.573, -0.156>, 0.1596 }
			cylinder { <-1.8249, 16.573, -0.156>, <-3.451, 18.1947, 0.299>, 0.1596 }
			cylinder { <-3.451, 18.1947, 0.299>, <-5.4702, 19.2061, 0.9163>, 0.1596 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-5.4702, 19.2061, 0.9163>, <-6.08261, 19.4939, 1.1046>, 0.1596 }
				cylinder { <-6.08261, 19.4939, 1.1046>, <-6.7013, 19.7659, 1.2957>, 0.1596 }
				cylinder { <-6.7013, 19.7659, 1.2957>, <-7.3259, 20.02203, 1.4896>, 0.1596 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.3259, 20.02203, 1.4896>, <-7.6072, 20.1231, 1.4936>, 0.02038 }
				cylinder { <-7.6072, 20.1231, 1.4936>, <-7.8836, 20.209, 1.4187>, 0.02038 }
				cylinder { <-7.8836, 20.209, 1.4187>, <-8.135, 20.2735, 1.2704>, 0.02038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-8.135, 20.2735, 1.2704>, <-13.08964, 23.3493, -0.03606>, <-14.344, 22.8212, -1.5367> }
				triangle { <-8.135, 20.2735, 1.2704>, <-14.344, 22.8212, -1.5367>, <-13.08964, 23.3493, -0.03606> }
				triangle { <-13.08964, 23.3493, -0.03606>, <-17.1516, 25.2403, -1.6717>, <-14.344, 22.8212, -1.5367> }
				triangle { <-13.08964, 23.3493, -0.03606>, <-14.344, 22.8212, -1.5367>, <-17.1516, 25.2403, -1.6717> }
				triangle { <-17.1516, 25.2403, -1.6717>, <-16.6412, 22.4542, -3.7476>, <-14.344, 22.8212, -1.5367> }
				triangle { <-17.1516, 25.2403, -1.6717>, <-14.344, 22.8212, -1.5367>, <-16.6412, 22.4542, -3.7476> }
				triangle { <-14.344, 22.8212, -1.5367>, <-16.6412, 22.4542, -3.7476>, <-8.135, 20.2735, 1.2704> }
				triangle { <-14.344, 22.8212, -1.5367>, <-8.135, 20.2735, 1.2704>, <-16.6412, 22.4542, -3.7476> }
				triangle { <-17.1516, 25.2403, -1.6717>, <-27.06785, 19.00283, 4.4992>, <-31.56, 15.333, 5.7061> }
				triangle { <-17.1516, 25.2403, -1.6717>, <-31.56, 15.333, 5.7061>, <-27.06785, 19.00283, 4.4992> }
				triangle { <-31.56, 15.333, 5.7061>, <-33.07218, 12.1528, 6.03802>, <-29.2287, 12.8459, 6.05276> }
				triangle { <-31.56, 15.333, 5.7061>, <-29.2287, 12.8459, 6.05276>, <-33.07218, 12.1528, 6.03802> }
				triangle { <-29.2287, 12.8459, 6.05276>, <-17.1516, 25.2403, -1.6717>, <-31.56, 15.333, 5.7061> }
				triangle { <-29.2287, 12.8459, 6.05276>, <-31.56, 15.333, 5.7061>, <-17.1516, 25.2403, -1.6717> }
				triangle { <-17.1516, 25.2403, -1.6717>, <-29.2287, 12.8459, 6.05276>, <-16.6412, 22.4542, -3.7476> }
				triangle { <-17.1516, 25.2403, -1.6717>, <-16.6412, 22.4542, -3.7476>, <-29.2287, 12.8459, 6.05276> }
				triangle { <-13.9765, 20.8152, -3.0314>, <-12.3955, 19.5601, -2.8593>, <-8.135, 20.2735, 1.2704> }
				triangle { <-13.9765, 20.8152, -3.0314>, <-8.135, 20.2735, 1.2704>, <-12.3955, 19.5601, -2.8593> }
				triangle { <-13.9765, 20.8152, -3.0314>, <-16.1308, 19.6681, -5.8236>, <-12.3955, 19.5601, -2.8593> }
				triangle { <-13.9765, 20.8152, -3.0314>, <-12.3955, 19.5601, -2.8593>, <-16.1308, 19.6681, -5.8236> }
				triangle { <-13.9765, 20.8152, -3.0314>, <-16.6412, 22.4542, -3.7476>, <-16.1308, 19.6681, -5.8236> }
				triangle { <-13.9765, 20.8152, -3.0314>, <-16.1308, 19.6681, -5.8236>, <-16.6412, 22.4542, -3.7476> }
				triangle { <-8.135, 20.2735, 1.2704>, <-16.6412, 22.4542, -3.7476>, <-13.9765, 20.8152, -3.0314> }
				triangle { <-8.135, 20.2735, 1.2704>, <-13.9765, 20.8152, -3.0314>, <-16.6412, 22.4542, -3.7476> }
				triangle { <-30.9475, 11.9896, 3.2149>, <-26.00624, 13.2076, 0.1812>, <-16.1308, 19.6681, -5.8236> }
				triangle { <-30.9475, 11.9896, 3.2149>, <-16.1308, 19.6681, -5.8236>, <-26.00624, 13.2076, 0.1812> }
				triangle { <-29.2287, 12.8459, 6.05276>, <-33.07218, 12.1528, 6.03802>, <-30.9475, 11.9896, 3.2149> }
				triangle { <-29.2287, 12.8459, 6.05276>, <-30.9475, 11.9896, 3.2149>, <-33.07218, 12.1528, 6.03802> }
				triangle { <-30.9475, 11.9896, 3.2149>, <-16.1308, 19.6681, -5.8236>, <-29.2287, 12.8459, 6.05276> }
				triangle { <-30.9475, 11.9896, 3.2149>, <-29.2287, 12.8459, 6.05276>, <-16.1308, 19.6681, -5.8236> }
				triangle { <-16.6412, 22.4542, -3.7476>, <-29.2287, 12.8459, 6.05276>, <-16.1308, 19.6681, -5.8236> }
				triangle { <-16.6412, 22.4542, -3.7476>, <-16.1308, 19.6681, -5.8236>, <-29.2287, 12.8459, 6.05276> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.3259, 20.02203, 1.4896>, <-7.956, 20.2619, 1.6862>, 0.1596 }
				cylinder { <-7.956, 20.2619, 1.6862>, <-8.5913, 20.4857, 1.8854>, 0.1596 }
				cylinder { <-8.5913, 20.4857, 1.8854>, <-9.2313, 20.693, 2.08704>, 0.1596 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-9.2313, 20.693, 2.08704>, <-9.4688, 20.782, 2.2453>, 0.02038 }
				cylinder { <-9.4688, 20.782, 2.2453>, <-9.6542, 20.8653, 2.4646>, 0.02038 }
				cylinder { <-9.6542, 20.8653, 2.4646>, <-9.7739, 20.9368, 2.729>, 0.02038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-9.7739, 20.9368, 2.729>, <-9.9084, 23.2606, 8.2333>, <-11.5529, 23.1875, 9.4142> }
				triangle { <-9.7739, 20.9368, 2.729>, <-11.5529, 23.1875, 9.4142>, <-9.9084, 23.2606, 8.2333> }
				triangle { <-9.9084, 23.2606, 8.2333>, <-10.7958, 24.8465, 12.6434>, <-11.5529, 23.1875, 9.4142> }
				triangle { <-9.9084, 23.2606, 8.2333>, <-11.5529, 23.1875, 9.4142>, <-10.7958, 24.8465, 12.6434> }
				triangle { <-10.7958, 24.8465, 12.6434>, <-13.825, 23.3574, 11.6745>, <-11.5529, 23.1875, 9.4142> }
				triangle { <-10.7958, 24.8465, 12.6434>, <-11.5529, 23.1875, 9.4142>, <-13.825, 23.3574, 11.6745> }
				triangle { <-11.5529, 23.1875, 9.4142>, <-13.825, 23.3574, 11.6745>, <-9.7739, 20.9368, 2.729> }
				triangle { <-11.5529, 23.1875, 9.4142>, <-9.7739, 20.9368, 2.729>, <-13.825, 23.3574, 11.6745> }
				triangle { <-10.7958, 24.8465, 12.6434>, <-8.3434, 14.8049, 20.9181>, <-9.02675, 10.1815, 24.5597> }
				triangle { <-10.7958, 24.8465, 12.6434>, <-9.02675, 10.1815, 24.5597>, <-8.3434, 14.8049, 20.9181> }
				triangle { <-9.02675, 10.1815, 24.5597>, <-10.1449, 6.935, 25.4082>, <-9.645, 8.2812, 21.7763> }
				triangle { <-9.02675, 10.1815, 24.5597>, <-9.645, 8.2812, 21.7763>, <-10.1449, 6.935, 25.4082> }
				triangle { <-9.645, 8.2812, 21.7763>, <-10.7958, 24.8465, 12.6434>, <-9.02675, 10.1815, 24.5597> }
				triangle { <-9.645, 8.2812, 21.7763>, <-9.02675, 10.1815, 24.5597>, <-10.7958, 24.8465, 12.6434> }
				triangle { <-10.7958, 24.8465, 12.6434>, <-9.645, 8.2812, 21.7763>, <-13.825, 23.3574, 11.6745> }
				triangle { <-10.7958, 24.8465, 12.6434>, <-13.825, 23.3574, 11.6745>, <-9.645, 8.2812, 21.7763> }
				triangle { <-13.734, 22.1153, 8.7166>, <-14.0282, 21.2354, 6.9156>, <-9.7739, 20.9368, 2.729> }
				triangle { <-13.734, 22.1153, 8.7166>, <-9.7739, 20.9368, 2.729>, <-14.0282, 21.2354, 6.9156> }
				triangle { <-13.734, 22.1153, 8.7166>, <-16.8543, 21.8683, 10.7056>, <-14.0282, 21.2354, 6.9156> }
				triangle { <-13.734, 22.1153, 8.7166>, <-14.0282, 21.2354, 6.9156>, <-16.8543, 21.8683, 10.7056> }
				triangle { <-13.734, 22.1153, 8.7166>, <-13.825, 23.3574, 11.6745>, <-16.8543, 21.8683, 10.7056> }
				triangle { <-13.734, 22.1153, 8.7166>, <-16.8543, 21.8683, 10.7056>, <-13.825, 23.3574, 11.6745> }
				triangle { <-9.7739, 20.9368, 2.729>, <-13.825, 23.3574, 11.6745>, <-13.734, 22.1153, 8.7166> }
				triangle { <-9.7739, 20.9368, 2.729>, <-13.734, 22.1153, 8.7166>, <-13.825, 23.3574, 11.6745> }
				triangle { <-12.6618, 8.3945, 23.397>, <-14.6442, 11.7075, 18.9028>, <-16.8543, 21.8683, 10.7056> }
				triangle { <-12.6618, 8.3945, 23.397>, <-16.8543, 21.8683, 10.7056>, <-14.6442, 11.7075, 18.9028> }
				triangle { <-9.645, 8.2812, 21.7763>, <-10.1449, 6.935, 25.4082>, <-12.6618, 8.3945, 23.397> }
				triangle { <-9.645, 8.2812, 21.7763>, <-12.6618, 8.3945, 23.397>, <-10.1449, 6.935, 25.4082> }
				triangle { <-12.6618, 8.3945, 23.397>, <-16.8543, 21.8683, 10.7056>, <-9.645, 8.2812, 21.7763> }
				triangle { <-12.6618, 8.3945, 23.397>, <-9.645, 8.2812, 21.7763>, <-16.8543, 21.8683, 10.7056> }
				triangle { <-13.825, 23.3574, 11.6745>, <-9.645, 8.2812, 21.7763>, <-16.8543, 21.8683, 10.7056> }
				triangle { <-13.825, 23.3574, 11.6745>, <-16.8543, 21.8683, 10.7056>, <-9.645, 8.2812, 21.7763> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-9.2313, 20.693, 2.08704>, <-9.8758, 20.8838, 2.2909>, 0.1596 }
				cylinder { <-9.8758, 20.8838, 2.2909>, <-10.5242, 21.05807, 2.497>, 0.1596 }
				cylinder { <-10.5242, 21.05807, 2.497>, <-11.1763, 21.2155, 2.7052>, 0.1596 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-11.1763, 21.2155, 2.7052>, <-11.4689, 21.2762, 2.715>, 0.02038 }
				cylinder { <-11.4689, 21.2762, 2.715>, <-11.7553, 21.3261, 2.6453>, 0.02038 }
				cylinder { <-11.7553, 21.3261, 2.6453>, <-12.01483, 21.3616, 2.5012>, 0.02038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-12.01483, 21.3616, 2.5012>, <-17.362, 23.7738, 1.3596>, <-18.5465, 23.1453, -0.1589> }
				triangle { <-12.01483, 21.3616, 2.5012>, <-18.5465, 23.1453, -0.1589>, <-17.362, 23.7738, 1.3596> }
				triangle { <-17.362, 23.7738, 1.3596>, <-21.6642, 25.1535, -0.1696>, <-18.5465, 23.1453, -0.1589> }
				triangle { <-17.362, 23.7738, 1.3596>, <-18.5465, 23.1453, -0.1589>, <-21.6642, 25.1535, -0.1696> }
				triangle { <-21.6642, 25.1535, -0.1696>, <-20.7935, 22.5633, -2.3753>, <-18.5465, 23.1453, -0.1589> }
				triangle { <-21.6642, 25.1535, -0.1696>, <-18.5465, 23.1453, -0.1589>, <-20.7935, 22.5633, -2.3753> }
				triangle { <-18.5465, 23.1453, -0.1589>, <-20.7935, 22.5633, -2.3753>, <-12.01483, 21.3616, 2.5012> }
				triangle { <-18.5465, 23.1453, -0.1589>, <-12.01483, 21.3616, 2.5012>, <-20.7935, 22.5633, -2.3753> }
				triangle { <-21.6642, 25.1535, -0.1696>, <-30.5526, 17.3206, 5.7433>, <-34.4785, 13.00982, 6.7957> }
				triangle { <-21.6642, 25.1535, -0.1696>, <-34.4785, 13.00982, 6.7957>, <-30.5526, 17.3206, 5.7433> }
				triangle { <-34.4785, 13.00982, 6.7957>, <-35.5306, 9.6382, 6.9849>, <-31.8207, 10.8584, 7.01653> }
				triangle { <-34.4785, 13.00982, 6.7957>, <-31.8207, 10.8584, 7.01653>, <-35.5306, 9.6382, 6.9849> }
				triangle { <-31.8207, 10.8584, 7.01653>, <-21.6642, 25.1535, -0.1696>, <-34.4785, 13.00982, 6.7957> }
				triangle { <-31.8207, 10.8584, 7.01653>, <-34.4785, 13.00982, 6.7957>, <-21.6642, 25.1535, -0.1696> }
				triangle { <-21.6642, 25.1535, -0.1696>, <-31.8207, 10.8584, 7.01653>, <-20.7935, 22.5633, -2.3753> }
				triangle { <-21.6642, 25.1535, -0.1696>, <-20.7935, 22.5633, -2.3753>, <-31.8207, 10.8584, 7.01653> }
				triangle { <-17.9196, 21.2803, -1.7471>, <-16.1778, 20.2512, -1.6401>, <-12.01483, 21.3616, 2.5012> }
				triangle { <-17.9196, 21.2803, -1.7471>, <-12.01483, 21.3616, 2.5012>, <-16.1778, 20.2512, -1.6401> }
				triangle { <-17.9196, 21.2803, -1.7471>, <-19.9228, 19.9731, -4.5811>, <-16.1778, 20.2512, -1.6401> }
				triangle { <-17.9196, 21.2803, -1.7471>, <-16.1778, 20.2512, -1.6401>, <-19.9228, 19.9731, -4.5811> }
				triangle { <-17.9196, 21.2803, -1.7471>, <-20.7935, 22.5633, -2.3753>, <-19.9228, 19.9731, -4.5811> }
				triangle { <-17.9196, 21.2803, -1.7471>, <-19.9228, 19.9731, -4.5811>, <-20.7935, 22.5633, -2.3753> }
				triangle { <-12.01483, 21.3616, 2.5012>, <-20.7935, 22.5633, -2.3753>, <-17.9196, 21.2803, -1.7471> }
				triangle { <-12.01483, 21.3616, 2.5012>, <-17.9196, 21.2803, -1.7471>, <-20.7935, 22.5633, -2.3753> }
				triangle { <-33.4336, 9.9015, 4.1488>, <-28.7415, 11.933, 1.1554>, <-19.9228, 19.9731, -4.5811> }
				triangle { <-33.4336, 9.9015, 4.1488>, <-19.9228, 19.9731, -4.5811>, <-28.7415, 11.933, 1.1554> }
				triangle { <-31.8207, 10.8584, 7.01653>, <-35.5306, 9.6382, 6.9849>, <-33.4336, 9.9015, 4.1488> }
				triangle { <-31.8207, 10.8584, 7.01653>, <-33.4336, 9.9015, 4.1488>, <-35.5306, 9.6382, 6.9849> }
				triangle { <-33.4336, 9.9015, 4.1488>, <-19.9228, 19.9731, -4.5811>, <-31.8207, 10.8584, 7.01653> }
				triangle { <-33.4336, 9.9015, 4.1488>, <-31.8207, 10.8584, 7.01653>, <-19.9228, 19.9731, -4.5811> }
				triangle { <-20.7935, 22.5633, -2.3753>, <-31.8207, 10.8584, 7.01653>, <-19.9228, 19.9731, -4.5811> }
				triangle { <-20.7935, 22.5633, -2.3753>, <-19.9228, 19.9731, -4.5811>, <-31.8207, 10.8584, 7.01653> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-11.1763, 21.2155, 2.7052>, <-11.4538, 21.2825, 2.7938>, 0.02038 }
				cylinder { <-11.4538, 21.2825, 2.7938>, <-11.7314, 21.3496, 2.8824>, 0.02038 }
				cylinder { <-11.7314, 21.3496, 2.8824>, <-12.00899, 21.4166, 2.971>, 0.02038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-12.00899, 21.4166, 2.971>, <-16.21, 24.1242, 6.2475>, <-18.1914, 23.8059, 5.9694> }
				triangle { <-12.00899, 21.4166, 2.971>, <-18.1914, 23.8059, 5.9694>, <-16.21, 24.1242, 6.2475> }
				triangle { <-16.21, 24.1242, 6.2475>, <-20.09719, 25.8596, 8.3992>, <-18.1914, 23.8059, 5.9694> }
				triangle { <-16.21, 24.1242, 6.2475>, <-18.1914, 23.8059, 5.9694>, <-20.09719, 25.8596, 8.3992> }
				triangle { <-20.09719, 25.8596, 8.3992>, <-21.3984, 23.6842, 5.9688>, <-18.1914, 23.8059, 5.9694> }
				triangle { <-20.09719, 25.8596, 8.3992>, <-18.1914, 23.8059, 5.9694>, <-21.3984, 23.6842, 5.9688> }
				triangle { <-18.1914, 23.8059, 5.9694>, <-21.3984, 23.6842, 5.9688>, <-12.00899, 21.4166, 2.971> }
				triangle { <-18.1914, 23.8059, 5.9694>, <-12.00899, 21.4166, 2.971>, <-21.3984, 23.6842, 5.9688> }
				triangle { <-20.09719, 25.8596, 8.3992>, <-23.3369, 17.3173, 17.9831>, <-25.9786, 12.9853, 21.04247> }
				triangle { <-20.09719, 25.8596, 8.3992>, <-25.9786, 12.9853, 21.04247>, <-23.3369, 17.3173, 17.9831> }
				triangle { <-25.9786, 12.9853, 21.04247>, <-27.07074, 9.6609, 21.5582>, <-24.2696, 10.7646, 19.07054> }
				triangle { <-25.9786, 12.9853, 21.04247>, <-24.2696, 10.7646, 19.07054>, <-27.07074, 9.6609, 21.5582> }
				triangle { <-24.2696, 10.7646, 19.07054>, <-20.09719, 25.8596, 8.3992>, <-25.9786, 12.9853, 21.04247> }
				triangle { <-24.2696, 10.7646, 19.07054>, <-25.9786, 12.9853, 21.04247>, <-20.09719, 25.8596, 8.3992> }
				triangle { <-20.09719, 25.8596, 8.3992>, <-24.2696, 10.7646, 19.07054>, <-21.3984, 23.6842, 5.9688> }
				triangle { <-20.09719, 25.8596, 8.3992>, <-21.3984, 23.6842, 5.9688>, <-24.2696, 10.7646, 19.07054> }
				triangle { <-19.1283, 22.2396, 4.2195>, <-17.9798, 21.1656, 2.9422>, <-12.00899, 21.4166, 2.971> }
				triangle { <-19.1283, 22.2396, 4.2195>, <-12.00899, 21.4166, 2.971>, <-17.9798, 21.1656, 2.9422> }
				triangle { <-19.1283, 22.2396, 4.2195>, <-22.6998, 21.5087, 3.5384>, <-17.9798, 21.1656, 2.9422> }
				triangle { <-19.1283, 22.2396, 4.2195>, <-17.9798, 21.1656, 2.9422>, <-22.6998, 21.5087, 3.5384> }
				triangle { <-19.1283, 22.2396, 4.2195>, <-21.3984, 23.6842, 5.9688>, <-22.6998, 21.5087, 3.5384> }
				triangle { <-19.1283, 22.2396, 4.2195>, <-22.6998, 21.5087, 3.5384>, <-21.3984, 23.6842, 5.9688> }
				triangle { <-12.00899, 21.4166, 2.971>, <-21.3984, 23.6842, 5.9688>, <-19.1283, 22.2396, 4.2195> }
				triangle { <-12.00899, 21.4166, 2.971>, <-19.1283, 22.2396, 4.2195>, <-21.3984, 23.6842, 5.9688> }
				triangle { <-27.5402, 10.3748, 18.126>, <-26.04368, 12.7924, 12.928>, <-22.6998, 21.5087, 3.5384> }
				triangle { <-27.5402, 10.3748, 18.126>, <-22.6998, 21.5087, 3.5384>, <-26.04368, 12.7924, 12.928> }
				triangle { <-24.2696, 10.7646, 19.07054>, <-27.07074, 9.6609, 21.5582>, <-27.5402, 10.3748, 18.126> }
				triangle { <-24.2696, 10.7646, 19.07054>, <-27.5402, 10.3748, 18.126>, <-27.07074, 9.6609, 21.5582> }
				triangle { <-27.5402, 10.3748, 18.126>, <-22.6998, 21.5087, 3.5384>, <-24.2696, 10.7646, 19.07054> }
				triangle { <-27.5402, 10.3748, 18.126>, <-24.2696, 10.7646, 19.07054>, <-22.6998, 21.5087, 3.5384> }
				triangle { <-21.3984, 23.6842, 5.9688>, <-24.2696, 10.7646, 19.07054>, <-22.6998, 21.5087, 3.5384> }
				triangle { <-21.3984, 23.6842, 5.9688>, <-22.6998, 21.5087, 3.5384>, <-24.2696, 10.7646, 19.07054> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.756, 14.5047, -0.403>, <-0.4539, 16.8158, -0.6237>, 0.1596 }
			cylinder { <-0.4539, 16.8158, -0.6237>, <0.5235, 18.8986, -1.05666>, 0.1596 }
			cylinder { <0.5235, 18.8986, -1.05666>, <2.07782, 20.5429, -1.6581>, 0.1596 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <2.07782, 20.5429, -1.6581>, <2.5556, 21.02389, -1.8417>, 0.1596 }
				cylinder { <2.5556, 21.02389, -1.8417>, <3.04473, 21.4921, -2.02847>, 0.1596 }
				cylinder { <3.04473, 21.4921, -2.02847>, <3.5447, 21.9473, -2.2181>, 0.1596 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <3.5447, 21.9473, -2.2181>, <3.775, 22.138, -2.2203>, 0.02038 }
				cylinder { <3.775, 22.138, -2.2203>, <4.005963, 22.3119, -2.1439>, 0.02038 }
				cylinder { <4.005963, 22.3119, -2.1439>, <4.2208, 22.4562, -1.9943>, 0.02038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <4.2208, 22.4562, -1.9943>, <7.8384, 27.01689, -0.6421>, <9.2007, 26.9289, 0.8547> }
				triangle { <4.2208, 22.4562, -1.9943>, <9.2007, 26.9289, 0.8547>, <7.8384, 27.01689, -0.6421> }
				triangle { <7.8384, 27.01689, -0.6421>, <11.01976, 30.1563, 1.02356>, <9.2007, 26.9289, 0.8547> }
				triangle { <7.8384, 27.01689, -0.6421>, <9.2007, 26.9289, 0.8547>, <11.01976, 30.1563, 1.02356> }
				triangle { <11.01976, 30.1563, 1.02356>, <11.4904, 27.3385, 3.06599>, <9.2007, 26.9289, 0.8547> }
				triangle { <11.01976, 30.1563, 1.02356>, <9.2007, 26.9289, 0.8547>, <11.4904, 27.3385, 3.06599> }
				triangle { <9.2007, 26.9289, 0.8547>, <11.4904, 27.3385, 3.06599>, <4.2208, 22.4562, -1.9943> }
				triangle { <9.2007, 26.9289, 0.8547>, <4.2208, 22.4562, -1.9943>, <11.4904, 27.3385, 3.06599> }
				triangle { <11.01976, 30.1563, 1.02356>, <22.4527, 27.7305, -5.1992>, <27.9219, 25.8194, -6.4395> }
				triangle { <11.01976, 30.1563, 1.02356>, <27.9219, 25.8194, -6.4395>, <22.4527, 27.7305, -5.1992> }
				triangle { <27.9219, 25.8194, -6.4395>, <30.4238, 23.3461, -6.8052>, <26.5734, 22.6924, -6.8197> }
				triangle { <27.9219, 25.8194, -6.4395>, <26.5734, 22.6924, -6.8197>, <30.4238, 23.3461, -6.8052> }
				triangle { <26.5734, 22.6924, -6.8197>, <11.01976, 30.1563, 1.02356>, <27.9219, 25.8194, -6.4395> }
				triangle { <26.5734, 22.6924, -6.8197>, <27.9219, 25.8194, -6.4395>, <11.01976, 30.1563, 1.02356> }
				triangle { <11.01976, 30.1563, 1.02356>, <26.5734, 22.6924, -6.8197>, <11.4904, 27.3385, 3.06599> }
				triangle { <11.01976, 30.1563, 1.02356>, <11.4904, 27.3385, 3.06599>, <26.5734, 22.6924, -6.8197> }
				triangle { <9.5395, 24.9001, 2.3253>, <8.4786, 23.1848, 2.1355>, <4.2208, 22.4562, -1.9943> }
				triangle { <9.5395, 24.9001, 2.3253>, <4.2208, 22.4562, -1.9943>, <8.4786, 23.1848, 2.1355> }
				triangle { <9.5395, 24.9001, 2.3253>, <11.9611, 24.5208, 5.1084>, <8.4786, 23.1848, 2.1355> }
				triangle { <9.5395, 24.9001, 2.3253>, <8.4786, 23.1848, 2.1355>, <11.9611, 24.5208, 5.1084> }
				triangle { <9.5395, 24.9001, 2.3253>, <11.4904, 27.3385, 3.06599>, <11.9611, 24.5208, 5.1084> }
				triangle { <9.5395, 24.9001, 2.3253>, <11.9611, 24.5208, 5.1084>, <11.4904, 27.3385, 3.06599> }
				triangle { <4.2208, 22.4562, -1.9943>, <11.4904, 27.3385, 3.06599>, <9.5395, 24.9001, 2.3253> }
				triangle { <4.2208, 22.4562, -1.9943>, <9.5395, 24.9001, 2.3253>, <11.4904, 27.3385, 3.06599> }
				triangle { <28.4867, 22.4381, -3.9885>, <23.4317, 21.8697, -0.951>, <11.9611, 24.5208, 5.1084> }
				triangle { <28.4867, 22.4381, -3.9885>, <11.9611, 24.5208, 5.1084>, <23.4317, 21.8697, -0.951> }
				triangle { <26.5734, 22.6924, -6.8197>, <30.4238, 23.3461, -6.8052>, <28.4867, 22.4381, -3.9885> }
				triangle { <26.5734, 22.6924, -6.8197>, <28.4867, 22.4381, -3.9885>, <30.4238, 23.3461, -6.8052> }
				triangle { <28.4867, 22.4381, -3.9885>, <11.9611, 24.5208, 5.1084>, <26.5734, 22.6924, -6.8197> }
				triangle { <28.4867, 22.4381, -3.9885>, <26.5734, 22.6924, -6.8197>, <11.9611, 24.5208, 5.1084> }
				triangle { <11.4904, 27.3385, 3.06599>, <26.5734, 22.6924, -6.8197>, <11.9611, 24.5208, 5.1084> }
				triangle { <11.4904, 27.3385, 3.06599>, <11.9611, 24.5208, 5.1084>, <26.5734, 22.6924, -6.8197> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <3.5447, 21.9473, -2.2181>, <4.05553, 22.3894, -2.4106>, 0.1596 }
				cylinder { <4.05553, 22.3894, -2.4106>, <4.5766, 22.8179, -2.6059>, 0.1596 }
				cylinder { <4.5766, 22.8179, -2.6059>, <5.1077, 23.2327, -2.8038>, 0.1596 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <5.1077, 23.2327, -2.8038>, <5.3005, 23.3989, -2.9605>, 0.02038 }
				cylinder { <5.3005, 23.3989, -2.9605>, <5.4461, 23.5427, -3.1785>, 0.02038 }
				cylinder { <5.4461, 23.5427, -3.1785>, <5.5339, 23.6538, -3.4418>, 0.02038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <5.5339, 23.6538, -3.4418>, <4.8597, 25.9487, -8.9185>, <6.4289, 26.4524, -10.09682> }
				triangle { <5.5339, 23.6538, -3.4418>, <6.4289, 26.4524, -10.09682>, <4.8597, 25.9487, -8.9185> }
				triangle { <4.8597, 25.9487, -8.9185>, <5.1466, 27.7929, -13.308>, <6.4289, 26.4524, -10.09682> }
				triangle { <4.8597, 25.9487, -8.9185>, <6.4289, 26.4524, -10.09682>, <5.1466, 27.7929, -13.308> }
				triangle { <5.1466, 27.7929, -13.308>, <8.5036, 27.4103, -12.3503>, <6.4289, 26.4524, -10.09682> }
				triangle { <5.1466, 27.7929, -13.308>, <6.4289, 26.4524, -10.09682>, <8.5036, 27.4103, -12.3503> }
				triangle { <6.4289, 26.4524, -10.09682>, <8.5036, 27.4103, -12.3503>, <5.5339, 23.6538, -3.4418> }
				triangle { <6.4289, 26.4524, -10.09682>, <5.5339, 23.6538, -3.4418>, <8.5036, 27.4103, -12.3503> }
				triangle { <5.1466, 27.7929, -13.308>, <6.2346, 17.6121, -21.7037>, <8.4406, 13.5384, -25.3973> }
				triangle { <5.1466, 27.7929, -13.308>, <8.4406, 13.5384, -25.3973>, <6.2346, 17.6121, -21.7037> }
				triangle { <8.4406, 13.5384, -25.3973>, <10.5935, 10.875, -26.2812>, <9.6733, 11.929, -22.6349> }
				triangle { <8.4406, 13.5384, -25.3973>, <9.6733, 11.929, -22.6349>, <10.5935, 10.875, -26.2812> }
				triangle { <9.6733, 11.929, -22.6349>, <5.1466, 27.7929, -13.308>, <8.4406, 13.5384, -25.3973> }
				triangle { <9.6733, 11.929, -22.6349>, <8.4406, 13.5384, -25.3973>, <5.1466, 27.7929, -13.308> }
				triangle { <5.1466, 27.7929, -13.308>, <9.6733, 11.929, -22.6349>, <8.5036, 27.4103, -12.3503> }
				triangle { <5.1466, 27.7929, -13.308>, <8.5036, 27.4103, -12.3503>, <9.6733, 11.929, -22.6349> }
				triangle { <8.8459, 26.1769, -9.4072>, <9.4252, 25.4284, -7.616>, <5.5339, 23.6538, -3.4418> }
				triangle { <8.8459, 26.1769, -9.4072>, <5.5339, 23.6538, -3.4418>, <9.4252, 25.4284, -7.616> }
				triangle { <8.8459, 26.1769, -9.4072>, <11.8605, 27.02775, -11.3926>, <9.4252, 25.4284, -7.616> }
				triangle { <8.8459, 26.1769, -9.4072>, <9.4252, 25.4284, -7.616>, <11.8605, 27.02775, -11.3926> }
				triangle { <8.8459, 26.1769, -9.4072>, <8.5036, 27.4103, -12.3503>, <11.8605, 27.02775, -11.3926> }
				triangle { <8.8459, 26.1769, -9.4072>, <11.8605, 27.02775, -11.3926>, <8.5036, 27.4103, -12.3503> }
				triangle { <5.5339, 23.6538, -3.4418>, <8.5036, 27.4103, -12.3503>, <8.8459, 26.1769, -9.4072> }
				triangle { <5.5339, 23.6538, -3.4418>, <8.8459, 26.1769, -9.4072>, <8.5036, 27.4103, -12.3503> }
				triangle { <12.4689, 13.07937, -24.2481>, <13.2171, 16.8163, -19.7117>, <11.8605, 27.02775, -11.3926> }
				triangle { <12.4689, 13.07937, -24.2481>, <11.8605, 27.02775, -11.3926>, <13.2171, 16.8163, -19.7117> }
				triangle { <9.6733, 11.929, -22.6349>, <10.5935, 10.875, -26.2812>, <12.4689, 13.07937, -24.2481> }
				triangle { <9.6733, 11.929, -22.6349>, <12.4689, 13.07937, -24.2481>, <10.5935, 10.875, -26.2812> }
				triangle { <12.4689, 13.07937, -24.2481>, <11.8605, 27.02775, -11.3926>, <9.6733, 11.929, -22.6349> }
				triangle { <12.4689, 13.07937, -24.2481>, <9.6733, 11.929, -22.6349>, <11.8605, 27.02775, -11.3926> }
				triangle { <8.5036, 27.4103, -12.3503>, <9.6733, 11.929, -22.6349>, <11.8605, 27.02775, -11.3926> }
				triangle { <8.5036, 27.4103, -12.3503>, <11.8605, 27.02775, -11.3926>, <9.6733, 11.929, -22.6349> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <5.1077, 23.2327, -2.8038>, <5.6486, 23.6334, -3.004186>, 0.1596 }
				cylinder { <5.6486, 23.6334, -3.004186>, <6.1989, 24.01997, -3.2069>, 0.1596 }
				cylinder { <6.1989, 24.01997, -3.2069>, <6.7582, 24.392, -3.4119>, 0.1596 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <6.7582, 24.392, -3.4119>, <7.01282, 24.5485, -3.4204>, 0.02038 }
				cylinder { <7.01282, 24.5485, -3.4204>, <7.2654, 24.6919, -3.3496>, 0.02038 }
				cylinder { <7.2654, 24.6919, -3.3496>, <7.4976, 24.8118, -3.2045>, 0.02038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <7.4976, 24.8118, -3.2045>, <11.7097, 28.8838, -2.02415>, <13.04039, 28.6774, -0.5105> }
				triangle { <7.4976, 24.8118, -3.2045>, <13.04039, 28.6774, -0.5105>, <11.7097, 28.8838, -2.02415> }
				triangle { <11.7097, 28.8838, -2.02415>, <15.2904, 31.6251, -0.4702>, <13.04039, 28.6774, -0.5105> }
				triangle { <11.7097, 28.8838, -2.02415>, <13.04039, 28.6774, -0.5105>, <15.2904, 31.6251, -0.4702> }
				triangle { <15.2904, 31.6251, -0.4702>, <15.3559, 28.8677, 1.7035>, <13.04039, 28.6774, -0.5105> }
				triangle { <15.2904, 31.6251, -0.4702>, <13.04039, 28.6774, -0.5105>, <15.3559, 28.8677, 1.7035> }
				triangle { <13.04039, 28.6774, -0.5105>, <15.3559, 28.8677, 1.7035>, <7.4976, 24.8118, -3.2045> }
				triangle { <13.04039, 28.6774, -0.5105>, <7.4976, 24.8118, -3.2045>, <15.3559, 28.8677, 1.7035> }
				triangle { <15.2904, 31.6251, -0.4702>, <26.2991, 27.3468, -6.4557>, <31.4538, 24.6386, -7.55> }
				triangle { <15.2904, 31.6251, -0.4702>, <31.4538, 24.6386, -7.55>, <26.2991, 27.3468, -6.4557> }
				triangle { <31.4538, 24.6386, -7.55>, <33.5884, 21.8274, -7.7762>, <29.6846, 21.715, -7.8012> }
				triangle { <31.4538, 24.6386, -7.55>, <29.6846, 21.715, -7.8012>, <33.5884, 21.8274, -7.7762> }
				triangle { <29.6846, 21.715, -7.8012>, <15.2904, 31.6251, -0.4702>, <31.4538, 24.6386, -7.55> }
				triangle { <29.6846, 21.715, -7.8012>, <31.4538, 24.6386, -7.55>, <15.2904, 31.6251, -0.4702> }
				triangle { <15.2904, 31.6251, -0.4702>, <29.6846, 21.715, -7.8012>, <15.3559, 28.8677, 1.7035> }
				triangle { <15.2904, 31.6251, -0.4702>, <15.3559, 28.8677, 1.7035>, <29.6846, 21.715, -7.8012> }
				triangle { <13.08755, 26.6921, 1.05455>, <11.7987, 25.1337, 0.9321>, <7.4976, 24.8118, -3.2045> }
				triangle { <13.08755, 26.6921, 1.05455>, <7.4976, 24.8118, -3.2045>, <11.7987, 25.1337, 0.9321> }
				triangle { <13.08755, 26.6921, 1.05455>, <15.4214, 26.1103, 3.8772>, <11.7987, 25.1337, 0.9321> }
				triangle { <13.08755, 26.6921, 1.05455>, <11.7987, 25.1337, 0.9321>, <15.4214, 26.1103, 3.8772> }
				triangle { <13.08755, 26.6921, 1.05455>, <15.3559, 28.8677, 1.7035>, <15.4214, 26.1103, 3.8772> }
				triangle { <13.08755, 26.6921, 1.05455>, <15.4214, 26.1103, 3.8772>, <15.3559, 28.8677, 1.7035> }
				triangle { <7.4976, 24.8118, -3.2045>, <15.3559, 28.8677, 1.7035>, <13.08755, 26.6921, 1.05455> }
				triangle { <7.4976, 24.8118, -3.2045>, <13.08755, 26.6921, 1.05455>, <15.3559, 28.8677, 1.7035> }
				triangle { <31.5324, 21.3297, -4.9415>, <26.4353, 21.6115, -1.9343>, <15.4214, 26.1103, 3.8772> }
				triangle { <31.5324, 21.3297, -4.9415>, <15.4214, 26.1103, 3.8772>, <26.4353, 21.6115, -1.9343> }
				triangle { <29.6846, 21.715, -7.8012>, <33.5884, 21.8274, -7.7762>, <31.5324, 21.3297, -4.9415> }
				triangle { <29.6846, 21.715, -7.8012>, <31.5324, 21.3297, -4.9415>, <33.5884, 21.8274, -7.7762> }
				triangle { <31.5324, 21.3297, -4.9415>, <15.4214, 26.1103, 3.8772>, <29.6846, 21.715, -7.8012> }
				triangle { <31.5324, 21.3297, -4.9415>, <29.6846, 21.715, -7.8012>, <15.4214, 26.1103, 3.8772> }
				triangle { <15.3559, 28.8677, 1.7035>, <29.6846, 21.715, -7.8012>, <15.4214, 26.1103, 3.8772> }
				triangle { <15.3559, 28.8677, 1.7035>, <15.4214, 26.1103, 3.8772>, <29.6846, 21.715, -7.8012> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <6.7582, 24.392, -3.4119>, <6.9963, 24.5503, -3.4992>, 0.02038 }
				cylinder { <6.9963, 24.5503, -3.4992>, <7.2344, 24.7087, -3.5864>, 0.02038 }
				cylinder { <7.2344, 24.7087, -3.5864>, <7.4725, 24.867, -3.6737>, 0.02038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <7.4725, 24.867, -3.6737>, <10.4973, 28.8786, -6.9099>, <12.4694, 29.2492, -6.6315> }
				triangle { <7.4725, 24.867, -3.6737>, <12.4694, 29.2492, -6.6315>, <10.4973, 28.8786, -6.9099> }
				triangle { <10.4973, 28.8786, -6.9099>, <13.5592, 31.8562, -9.03347>, <12.4694, 29.2492, -6.6315> }
				triangle { <10.4973, 28.8786, -6.9099>, <12.4694, 29.2492, -6.6315>, <13.5592, 31.8562, -9.03347> }
				triangle { <13.5592, 31.8562, -9.03347>, <15.5271, 30.2242, -6.6258>, <12.4694, 29.2492, -6.6315> }
				triangle { <13.5592, 31.8562, -9.03347>, <12.4694, 29.2492, -6.6315>, <15.5271, 30.2242, -6.6258> }
				triangle { <12.4694, 29.2492, -6.6315>, <15.5271, 30.2242, -6.6258>, <7.4725, 24.867, -3.6737> }
				triangle { <12.4694, 29.2492, -6.6315>, <7.4725, 24.867, -3.6737>, <15.5271, 30.2242, -6.6258> }
				triangle { <13.5592, 31.8562, -9.03347>, <19.4889, 25.0345, -18.7093>, <23.4389, 21.8934, -21.8133> }
				triangle { <13.5592, 31.8562, -9.03347>, <23.4389, 21.8934, -21.8133>, <19.4889, 25.0345, -18.7093> }
				triangle { <23.4389, 21.8934, -21.8133>, <25.5943, 19.144, -22.3654>, <22.5899, 19.2015, -19.8708> }
				triangle { <23.4389, 21.8934, -21.8133>, <22.5899, 19.2015, -19.8708>, <25.5943, 19.144, -22.3654> }
				triangle { <22.5899, 19.2015, -19.8708>, <13.5592, 31.8562, -9.03347>, <23.4389, 21.8934, -21.8133> }
				triangle { <22.5899, 19.2015, -19.8708>, <23.4389, 21.8934, -21.8133>, <13.5592, 31.8562, -9.03347> }
				triangle { <13.5592, 31.8562, -9.03347>, <22.5899, 19.2015, -19.8708>, <15.5271, 30.2242, -6.6258> }
				triangle { <13.5592, 31.8562, -9.03347>, <15.5271, 30.2242, -6.6258>, <22.5899, 19.2015, -19.8708> }
				triangle { <13.8863, 28.07421, -4.8981>, <13.1736, 26.6591, -3.6356>, <7.4725, 24.867, -3.6737> }
				triangle { <13.8863, 28.07421, -4.8981>, <7.4725, 24.867, -3.6737>, <13.1736, 26.6591, -3.6356> }
				triangle { <13.8863, 28.07421, -4.8981>, <17.495, 28.5922, -4.2183>, <13.1736, 26.6591, -3.6356> }
				triangle { <13.8863, 28.07421, -4.8981>, <13.1736, 26.6591, -3.6356>, <17.495, 28.5922, -4.2183> }
				triangle { <13.8863, 28.07421, -4.8981>, <15.5271, 30.2242, -6.6258>, <17.495, 28.5922, -4.2183> }
				triangle { <13.8863, 28.07421, -4.8981>, <17.495, 28.5922, -4.2183>, <15.5271, 30.2242, -6.6258> }
				triangle { <7.4725, 24.867, -3.6737>, <15.5271, 30.2242, -6.6258>, <13.8863, 28.07421, -4.8981> }
				triangle { <7.4725, 24.867, -3.6737>, <13.8863, 28.07421, -4.8981>, <15.5271, 30.2242, -6.6258> }
				triangle { <25.8003, 19.935, -18.9242>, <23.5821, 21.6398, -13.7016>, <17.495, 28.5922, -4.2183> }
				triangle { <25.8003, 19.935, -18.9242>, <17.495, 28.5922, -4.2183>, <23.5821, 21.6398, -13.7016> }
				triangle { <22.5899, 19.2015, -19.8708>, <25.5943, 19.144, -22.3654>, <25.8003, 19.935, -18.9242> }
				triangle { <22.5899, 19.2015, -19.8708>, <25.8003, 19.935, -18.9242>, <25.5943, 19.144, -22.3654> }
				triangle { <25.8003, 19.935, -18.9242>, <17.495, 28.5922, -4.2183>, <22.5899, 19.2015, -19.8708> }
				triangle { <25.8003, 19.935, -18.9242>, <22.5899, 19.2015, -19.8708>, <17.495, 28.5922, -4.2183> }
				triangle { <15.5271, 30.2242, -6.6258>, <22.5899, 19.2015, -19.8708>, <17.495, 28.5922, -4.2183> }
				triangle { <15.5271, 30.2242, -6.6258>, <17.495, 28.5922, -4.2183>, <22.5899, 19.2015, -19.8708> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-0.756, 14.5047, -0.403>, <-2.01297, 17.623, -0.1484>, 0.613 }
		cylinder { <-2.01297, 17.623, -0.1484>, <-3.8842, 20.387, 0.3285>, 0.613 }
		cylinder { <-3.8842, 20.387, 0.3285>, <-6.2789, 22.6622, 1.004623>, 0.613 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-6.2789, 22.6622, 1.004623>, <-8.615, 23.7601, 1.7226>, 0.1826 }
			cylinder { <-8.615, 23.7601, 1.7226>, <-11.1486, 24.03717, 2.549>, 0.1826 }
			cylinder { <-11.1486, 24.03717, 2.549>, <-13.6239, 23.4652, 3.4002>, 0.1826 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-13.6239, 23.4652, 3.4002>, <-14.362, 23.2744, 3.6551>, 0.1826 }
				cylinder { <-14.362, 23.2744, 3.6551>, <-15.09511, 23.06463, 3.9093>, 0.1826 }
				cylinder { <-15.09511, 23.06463, 3.9093>, <-15.8227, 22.8358, 4.1627>, 0.1826 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-15.8227, 22.8358, 4.1627>, <-16.1972, 22.7232, 4.1827>, 0.02669 }
				cylinder { <-16.1972, 22.7232, 4.1827>, <-16.5646, 22.6177, 4.09778>, 0.02669 }
				cylinder { <-16.5646, 22.6177, 4.09778>, <-16.8983, 22.5268, 3.914>, 0.02669 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-16.8983, 22.5268, 3.914>, <-23.6682, 22.2527, 2.9816>, <-24.6401, 21.2493, 1.1311> }
				triangle { <-16.8983, 22.5268, 3.914>, <-24.6401, 21.2493, 1.1311>, <-23.6682, 22.2527, 2.9816> }
				triangle { <-23.6682, 22.2527, 2.9816>, <-28.8604, 21.5772, 1.4381>, <-24.6401, 21.2493, 1.1311> }
				triangle { <-23.6682, 22.2527, 2.9816>, <-24.6401, 21.2493, 1.1311>, <-28.8604, 21.5772, 1.4381> }
				triangle { <-28.8604, 21.5772, 1.4381>, <-26.7608, 19.8408, -1.5162>, <-24.6401, 21.2493, 1.1311> }
				triangle { <-28.8604, 21.5772, 1.4381>, <-24.6401, 21.2493, 1.1311>, <-26.7608, 19.8408, -1.5162> }
				triangle { <-24.6401, 21.2493, 1.1311>, <-26.7608, 19.8408, -1.5162>, <-16.8983, 22.5268, 3.914> }
				triangle { <-24.6401, 21.2493, 1.1311>, <-16.8983, 22.5268, 3.914>, <-26.7608, 19.8408, -1.5162> }
				triangle { <-28.8604, 21.5772, 1.4381>, <-33.2445, 7.9934, 6.5251>, <-34.8403, 1.4116, 6.8539> }
				triangle { <-28.8604, 21.5772, 1.4381>, <-34.8403, 1.4116, 6.8539>, <-33.2445, 7.9934, 6.5251> }
				triangle { <-34.8403, 1.4116, 6.8539>, <-34.09479, -2.5441, 6.4285>, <-30.9934, 0.6582, 6.7503> }
				triangle { <-34.8403, 1.4116, 6.8539>, <-30.9934, 0.6582, 6.7503>, <-34.09479, -2.5441, 6.4285> }
				triangle { <-30.9934, 0.6582, 6.7503>, <-28.8604, 21.5772, 1.4381>, <-34.8403, 1.4116, 6.8539> }
				triangle { <-30.9934, 0.6582, 6.7503>, <-34.8403, 1.4116, 6.8539>, <-28.8604, 21.5772, 1.4381> }
				triangle { <-28.8604, 21.5772, 1.4381>, <-30.9934, 0.6582, 6.7503>, <-26.7608, 19.8408, -1.5162> }
				triangle { <-28.8604, 21.5772, 1.4381>, <-26.7608, 19.8408, -1.5162>, <-30.9934, 0.6582, 6.7503> }
				triangle { <-23.1283, 19.9991, -0.9959>, <-20.8127, 19.8911, -1.03634>, <-16.8983, 22.5268, 3.914> }
				triangle { <-23.1283, 19.9991, -0.9959>, <-16.8983, 22.5268, 3.914>, <-20.8127, 19.8911, -1.03634> }
				triangle { <-23.1283, 19.9991, -0.9959>, <-24.6611, 18.1043, -4.4706>, <-20.8127, 19.8911, -1.03634> }
				triangle { <-23.1283, 19.9991, -0.9959>, <-20.8127, 19.8911, -1.03634>, <-24.6611, 18.1043, -4.4706> }
				triangle { <-23.1283, 19.9991, -0.9959>, <-26.7608, 19.8408, -1.5162>, <-24.6611, 18.1043, -4.4706> }
				triangle { <-23.1283, 19.9991, -0.9959>, <-24.6611, 18.1043, -4.4706>, <-26.7608, 19.8408, -1.5162> }
				triangle { <-16.8983, 22.5268, 3.914>, <-26.7608, 19.8408, -1.5162>, <-23.1283, 19.9991, -0.9959> }
				triangle { <-16.8983, 22.5268, 3.914>, <-23.1283, 19.9991, -0.9959>, <-26.7608, 19.8408, -1.5162> }
				triangle { <-32.3208, -0.6721, 3.3087>, <-28.8773, 4.3815, 0.38>, <-24.6611, 18.1043, -4.4706> }
				triangle { <-32.3208, -0.6721, 3.3087>, <-24.6611, 18.1043, -4.4706>, <-28.8773, 4.3815, 0.38> }
				triangle { <-30.9934, 0.6582, 6.7503>, <-34.09479, -2.5441, 6.4285>, <-32.3208, -0.6721, 3.3087> }
				triangle { <-30.9934, 0.6582, 6.7503>, <-32.3208, -0.6721, 3.3087>, <-34.09479, -2.5441, 6.4285> }
				triangle { <-32.3208, -0.6721, 3.3087>, <-24.6611, 18.1043, -4.4706>, <-30.9934, 0.6582, 6.7503> }
				triangle { <-32.3208, -0.6721, 3.3087>, <-30.9934, 0.6582, 6.7503>, <-24.6611, 18.1043, -4.4706> }
				triangle { <-26.7608, 19.8408, -1.5162>, <-30.9934, 0.6582, 6.7503>, <-24.6611, 18.1043, -4.4706> }
				triangle { <-26.7608, 19.8408, -1.5162>, <-24.6611, 18.1043, -4.4706>, <-30.9934, 0.6582, 6.7503> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-15.8227, 22.8358, 4.1627>, <-16.5446, 22.5882, 4.4151>, 0.1826 }
				cylinder { <-16.5446, 22.5882, 4.4151>, <-17.2601, 22.3219, 4.6665>, 0.1826 }
				cylinder { <-17.2601, 22.3219, 4.6665>, <-17.969, 22.03713, 4.9166>, 0.1826 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-17.969, 22.03713, 4.9166>, <-18.2689, 21.9085, 5.133>, 0.02669 }
				cylinder { <-18.2689, 21.9085, 5.133>, <-18.5017, 21.7995, 5.4283>, 0.02669 }
				cylinder { <-18.5017, 21.7995, 5.4283>, <-18.6506, 21.7178, 5.7811>, 0.02669 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-18.6506, 21.7178, 5.7811>, <-19.7283, 22.5687, 12.4812>, <-21.07662, 21.1508, 13.725> }
				triangle { <-18.6506, 21.7178, 5.7811>, <-21.07662, 21.1508, 13.725>, <-19.7283, 22.5687, 12.4812> }
				triangle { <-19.7283, 22.5687, 12.4812>, <-21.1308, 22.4781, 17.7559>, <-21.07662, 21.1508, 13.725> }
				triangle { <-19.7283, 22.5687, 12.4812>, <-21.07662, 21.1508, 13.725>, <-21.1308, 22.4781, 17.7559> }
				triangle { <-21.1308, 22.4781, 17.7559>, <-23.05186, 19.3041, 16.2107>, <-21.07662, 21.1508, 13.725> }
				triangle { <-21.1308, 22.4781, 17.7559>, <-21.07662, 21.1508, 13.725>, <-23.05186, 19.3041, 16.2107> }
				triangle { <-21.07662, 21.1508, 13.725>, <-23.05186, 19.3041, 16.2107>, <-18.6506, 21.7178, 5.7811> }
				triangle { <-21.07662, 21.1508, 13.725>, <-18.6506, 21.7178, 5.7811>, <-23.05186, 19.3041, 16.2107> }
				triangle { <-21.1308, 22.4781, 17.7559>, <-11.3096, 13.3197, 24.7763>, <-8.4843, 7.9218, 27.7522> }
				triangle { <-21.1308, 22.4781, 17.7559>, <-8.4843, 7.9218, 27.7522>, <-11.3096, 13.3197, 24.7763> }
				triangle { <-8.4843, 7.9218, 27.7522>, <-7.2746, 4.06208, 27.9047>, <-8.09372, 6.3762, 24.1696> }
				triangle { <-8.4843, 7.9218, 27.7522>, <-8.09372, 6.3762, 24.1696>, <-7.2746, 4.06208, 27.9047> }
				triangle { <-8.09372, 6.3762, 24.1696>, <-21.1308, 22.4781, 17.7559>, <-8.4843, 7.9218, 27.7522> }
				triangle { <-8.09372, 6.3762, 24.1696>, <-8.4843, 7.9218, 27.7522>, <-21.1308, 22.4781, 17.7559> }
				triangle { <-21.1308, 22.4781, 17.7559>, <-8.09372, 6.3762, 24.1696>, <-23.05186, 19.3041, 16.2107> }
				triangle { <-21.1308, 22.4781, 17.7559>, <-23.05186, 19.3041, 16.2107>, <-8.09372, 6.3762, 24.1696> }
				triangle { <-22.4597, 18.8655, 12.6124>, <-22.3409, 18.2521, 10.3797>, <-18.6506, 21.7178, 5.7811> }
				triangle { <-22.4597, 18.8655, 12.6124>, <-18.6506, 21.7178, 5.7811>, <-22.3409, 18.2521, 10.3797> }
				triangle { <-22.4597, 18.8655, 12.6124>, <-24.9728, 16.1302, 14.6655>, <-22.3409, 18.2521, 10.3797> }
				triangle { <-22.4597, 18.8655, 12.6124>, <-22.3409, 18.2521, 10.3797>, <-24.9728, 16.1302, 14.6655> }
				triangle { <-22.4597, 18.8655, 12.6124>, <-23.05186, 19.3041, 16.2107>, <-24.9728, 16.1302, 14.6655> }
				triangle { <-22.4597, 18.8655, 12.6124>, <-24.9728, 16.1302, 14.6655>, <-23.05186, 19.3041, 16.2107> }
				triangle { <-18.6506, 21.7178, 5.7811>, <-23.05186, 19.3041, 16.2107>, <-22.4597, 18.8655, 12.6124> }
				triangle { <-18.6506, 21.7178, 5.7811>, <-22.4597, 18.8655, 12.6124>, <-23.05186, 19.3041, 16.2107> }
				triangle { <-10.7896, 4.113, 25.898>, <-15.3053, 6.7178, 21.5622>, <-24.9728, 16.1302, 14.6655> }
				triangle { <-10.7896, 4.113, 25.898>, <-24.9728, 16.1302, 14.6655>, <-15.3053, 6.7178, 21.5622> }
				triangle { <-8.09372, 6.3762, 24.1696>, <-7.2746, 4.06208, 27.9047>, <-10.7896, 4.113, 25.898> }
				triangle { <-8.09372, 6.3762, 24.1696>, <-10.7896, 4.113, 25.898>, <-7.2746, 4.06208, 27.9047> }
				triangle { <-10.7896, 4.113, 25.898>, <-24.9728, 16.1302, 14.6655>, <-8.09372, 6.3762, 24.1696> }
				triangle { <-10.7896, 4.113, 25.898>, <-8.09372, 6.3762, 24.1696>, <-24.9728, 16.1302, 14.6655> }
				triangle { <-23.05186, 19.3041, 16.2107>, <-8.09372, 6.3762, 24.1696>, <-24.9728, 16.1302, 14.6655> }
				triangle { <-23.05186, 19.3041, 16.2107>, <-24.9728, 16.1302, 14.6655>, <-8.09372, 6.3762, 24.1696> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-17.969, 22.03713, 4.9166>, <-18.6706, 21.734, 5.1652>, 0.1826 }
				cylinder { <-18.6706, 21.734, 5.1652>, <-19.3648, 21.4127, 5.4123>, 0.1826 }
				cylinder { <-19.3648, 21.4127, 5.4123>, <-20.05095, 21.07348, 5.6577>, 0.1826 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-20.05095, 21.07348, 5.6577>, <-20.4059, 20.909, 5.6739>, 0.02669 }
				cylinder { <-20.4059, 20.909, 5.6739>, <-20.7559, 20.7573, 5.5856>, 0.02669 }
				cylinder { <-20.7559, 20.7573, 5.5856>, <-21.07567, 20.6293, 5.3992>, 0.02669 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-21.07567, 20.6293, 5.3992>, <-27.7512, 19.458, 4.4822>, <-28.5936, 18.4146, 2.5908> }
				triangle { <-21.07567, 20.6293, 5.3992>, <-28.5936, 18.4146, 2.5908>, <-27.7512, 19.458, 4.4822> }
				triangle { <-27.7512, 19.458, 4.4822>, <-32.8151, 18.1372, 2.9297>, <-28.5936, 18.4146, 2.5908> }
				triangle { <-27.7512, 19.458, 4.4822>, <-28.5936, 18.4146, 2.5908>, <-32.8151, 18.1372, 2.9297> }
				triangle { <-32.8151, 18.1372, 2.9297>, <-30.5257, 16.8468, -0.1108>, <-28.5936, 18.4146, 2.5908> }
				triangle { <-32.8151, 18.1372, 2.9297>, <-28.5936, 18.4146, 2.5908>, <-30.5257, 16.8468, -0.1108> }
				triangle { <-28.5936, 18.4146, 2.5908>, <-30.5257, 16.8468, -0.1108>, <-21.07567, 20.6293, 5.3992> }
				triangle { <-28.5936, 18.4146, 2.5908>, <-21.07567, 20.6293, 5.3992>, <-30.5257, 16.8468, -0.1108> }
				triangle { <-32.8151, 18.1372, 2.9297>, <-35.216, 3.8573, 7.3949>, <-35.8785, -2.8906, 7.4227> }
				triangle { <-32.8151, 18.1372, 2.9297>, <-35.8785, -2.8906, 7.4227>, <-35.216, 3.8573, 7.3949> }
				triangle { <-35.8785, -2.8906, 7.4227>, <-34.5951, -6.6804, 6.8101>, <-31.9655, -3.09545, 7.2686> }
				triangle { <-35.8785, -2.8906, 7.4227>, <-31.9655, -3.09545, 7.2686>, <-34.5951, -6.6804, 6.8101> }
				triangle { <-31.9655, -3.09545, 7.2686>, <-32.8151, 18.1372, 2.9297>, <-35.8785, -2.8906, 7.4227> }
				triangle { <-31.9655, -3.09545, 7.2686>, <-35.8785, -2.8906, 7.4227>, <-32.8151, 18.1372, 2.9297> }
				triangle { <-32.8151, 18.1372, 2.9297>, <-31.9655, -3.09545, 7.2686>, <-30.5257, 16.8468, -0.1108> }
				triangle { <-32.8151, 18.1372, 2.9297>, <-30.5257, 16.8468, -0.1108>, <-31.9655, -3.09545, 7.2686> }
				triangle { <-26.9452, 17.4855, 0.4016>, <-24.6376, 17.7029, 0.3469>, <-21.07567, 20.6293, 5.3992> }
				triangle { <-26.9452, 17.4855, 0.4016>, <-21.07567, 20.6293, 5.3992>, <-24.6376, 17.7029, 0.3469> }
				triangle { <-26.9452, 17.4855, 0.4016>, <-28.2362, 15.5563, -3.1514>, <-24.6376, 17.7029, 0.3469> }
				triangle { <-26.9452, 17.4855, 0.4016>, <-24.6376, 17.7029, 0.3469>, <-28.2362, 15.5563, -3.1514> }
				triangle { <-26.9452, 17.4855, 0.4016>, <-30.5257, 16.8468, -0.1108>, <-28.2362, 15.5563, -3.1514> }
				triangle { <-26.9452, 17.4855, 0.4016>, <-28.2362, 15.5563, -3.1514>, <-30.5257, 16.8468, -0.1108> }
				triangle { <-21.07567, 20.6293, 5.3992>, <-30.5257, 16.8468, -0.1108>, <-26.9452, 17.4855, 0.4016> }
				triangle { <-21.07567, 20.6293, 5.3992>, <-26.9452, 17.4855, 0.4016>, <-30.5257, 16.8468, -0.1108> }
				triangle { <-33.1312, -4.4392, 3.7739>, <-30.454, 1.1732, 1.07047>, <-28.2362, 15.5563, -3.1514> }
				triangle { <-33.1312, -4.4392, 3.7739>, <-28.2362, 15.5563, -3.1514>, <-30.454, 1.1732, 1.07047> }
				triangle { <-31.9655, -3.09545, 7.2686>, <-34.5951, -6.6804, 6.8101>, <-33.1312, -4.4392, 3.7739> }
				triangle { <-31.9655, -3.09545, 7.2686>, <-33.1312, -4.4392, 3.7739>, <-34.5951, -6.6804, 6.8101> }
				triangle { <-33.1312, -4.4392, 3.7739>, <-28.2362, 15.5563, -3.1514>, <-31.9655, -3.09545, 7.2686> }
				triangle { <-33.1312, -4.4392, 3.7739>, <-31.9655, -3.09545, 7.2686>, <-28.2362, 15.5563, -3.1514> }
				triangle { <-30.5257, 16.8468, -0.1108>, <-31.9655, -3.09545, 7.2686>, <-28.2362, 15.5563, -3.1514> }
				triangle { <-30.5257, 16.8468, -0.1108>, <-28.2362, 15.5563, -3.1514>, <-31.9655, -3.09545, 7.2686> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-20.05095, 21.07348, 5.6577>, <-20.3852, 20.9082, 5.7772>, 0.02669 }
				cylinder { <-20.3852, 20.9082, 5.7772>, <-20.7194, 20.7429, 5.8967>, 0.02669 }
				cylinder { <-20.7194, 20.7429, 5.8967>, <-21.05371, 20.5777, 6.01633>, 0.02669 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-21.05371, 20.5777, 6.01633>, <-26.3909, 19.5137, 10.1585>, <-28.0446, 17.955, 9.6988> }
				triangle { <-21.05371, 20.5777, 6.01633>, <-28.0446, 17.955, 9.6988>, <-26.3909, 19.5137, 10.1585> }
				triangle { <-26.3909, 19.5137, 10.1585>, <-30.9126, 18.01933, 12.8267>, <-28.0446, 17.955, 9.6988> }
				triangle { <-26.3909, 19.5137, 10.1585>, <-28.0446, 17.955, 9.6988>, <-30.9126, 18.01933, 12.8267> }
				triangle { <-30.9126, 18.01933, 12.8267>, <-30.9341, 15.6926, 9.5497>, <-28.0446, 17.955, 9.6988> }
				triangle { <-30.9126, 18.01933, 12.8267>, <-28.0446, 17.955, 9.6988>, <-30.9341, 15.6926, 9.5497> }
				triangle { <-28.0446, 17.955, 9.6988>, <-30.9341, 15.6926, 9.5497>, <-21.05371, 20.5777, 6.01633> }
				triangle { <-28.0446, 17.955, 9.6988>, <-21.05371, 20.5777, 6.01633>, <-30.9341, 15.6926, 9.5497> }
				triangle { <-30.9126, 18.01933, 12.8267>, <-27.2182, 6.1187, 21.4491>, <-26.4625, -0.208, 23.7676> }
				triangle { <-30.9126, 18.01933, 12.8267>, <-26.4625, -0.208, 23.7676>, <-27.2182, 6.1187, 21.4491> }
				triangle { <-26.4625, -0.208, 23.7676>, <-25.2125, -4.05071, 23.5303>, <-23.6169, -0.6514, 21.1062> }
				triangle { <-26.4625, -0.208, 23.7676>, <-23.6169, -0.6514, 21.1062>, <-25.2125, -4.05071, 23.5303> }
				triangle { <-23.6169, -0.6514, 21.1062>, <-30.9126, 18.01933, 12.8267>, <-26.4625, -0.208, 23.7676> }
				triangle { <-23.6169, -0.6514, 21.1062>, <-26.4625, -0.208, 23.7676>, <-30.9126, 18.01933, 12.8267> }
				triangle { <-30.9126, 18.01933, 12.8267>, <-23.6169, -0.6514, 21.1062>, <-30.9341, 15.6926, 9.5497> }
				triangle { <-30.9126, 18.01933, 12.8267>, <-30.9341, 15.6926, 9.5497>, <-23.6169, -0.6514, 21.1062> }
				triangle { <-28.06011, 16.2798, 7.3394>, <-26.4202, 16.3494, 5.7019>, <-21.05371, 20.5777, 6.01633> }
				triangle { <-28.06011, 16.2798, 7.3394>, <-21.05371, 20.5777, 6.01633>, <-26.4202, 16.3494, 5.7019> }
				triangle { <-28.06011, 16.2798, 7.3394>, <-30.9557, 13.3659, 6.2728>, <-26.4202, 16.3494, 5.7019> }
				triangle { <-28.06011, 16.2798, 7.3394>, <-26.4202, 16.3494, 5.7019>, <-30.9557, 13.3659, 6.2728> }
				triangle { <-28.06011, 16.2798, 7.3394>, <-30.9341, 15.6926, 9.5497>, <-30.9557, 13.3659, 6.2728> }
				triangle { <-28.06011, 16.2798, 7.3394>, <-30.9557, 13.3659, 6.2728>, <-30.9341, 15.6926, 9.5497> }
				triangle { <-21.05371, 20.5777, 6.01633>, <-30.9341, 15.6926, 9.5497>, <-28.06011, 16.2798, 7.3394> }
				triangle { <-21.05371, 20.5777, 6.01633>, <-28.06011, 16.2798, 7.3394>, <-30.9341, 15.6926, 9.5497> }
				triangle { <-26.4884, -3.000096, 19.8353>, <-27.2631, 1.2792, 14.6331>, <-30.9557, 13.3659, 6.2728> }
				triangle { <-26.4884, -3.000096, 19.8353>, <-30.9557, 13.3659, 6.2728>, <-27.2631, 1.2792, 14.6331> }
				triangle { <-23.6169, -0.6514, 21.1062>, <-25.2125, -4.05071, 23.5303>, <-26.4884, -3.000096, 19.8353> }
				triangle { <-23.6169, -0.6514, 21.1062>, <-26.4884, -3.000096, 19.8353>, <-25.2125, -4.05071, 23.5303> }
				triangle { <-26.4884, -3.000096, 19.8353>, <-30.9557, 13.3659, 6.2728>, <-23.6169, -0.6514, 21.1062> }
				triangle { <-26.4884, -3.000096, 19.8353>, <-23.6169, -0.6514, 21.1062>, <-30.9557, 13.3659, 6.2728> }
				triangle { <-30.9341, 15.6926, 9.5497>, <-23.6169, -0.6514, 21.1062>, <-30.9557, 13.3659, 6.2728> }
				triangle { <-30.9341, 15.6926, 9.5497>, <-30.9557, 13.3659, 6.2728>, <-23.6169, -0.6514, 21.1062> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-6.2789, 22.6622, 1.004623>, <-7.5564, 24.9979, 1.3068>, 0.1826 }
			cylinder { <-7.5564, 24.9979, 1.3068>, <-8.07975, 27.6253, 1.3435>, 0.1826 }
			cylinder { <-8.07975, 27.6253, 1.3435>, <-7.7959, 30.2794, 1.111>, 0.1826 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-7.7959, 30.2794, 1.111>, <-7.6921, 31.07289, 1.03529>, 0.1826 }
				cylinder { <-7.6921, 31.07289, 1.03529>, <-7.5699, 31.8631, 0.9535>, 0.1826 }
				cylinder { <-7.5699, 31.8631, 0.9535>, <-7.4292, 32.6496, 0.8658>, 0.1826 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.4292, 32.6496, 0.8658>, <-7.3303, 33.02406, 0.9236>, 0.02669 }
				cylinder { <-7.3303, 33.02406, 0.9236>, <-7.2081, 33.3626, 1.07788>, 0.02669 }
				cylinder { <-7.2081, 33.3626, 1.07788>, <-7.07171, 33.6408, 1.3172>, 0.02669 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.07171, 33.6408, 1.3172>, <-6.6032, 39.9021, 4.02884>, <-5.123, 40.4225, 5.7357> }
				triangle { <-7.07171, 33.6408, 1.3172>, <-5.123, 40.4225, 5.7357>, <-6.6032, 39.9021, 4.02884> }
				triangle { <-6.6032, 39.9021, 4.02884>, <-5.5621, 44.5216, 6.7443>, <-5.123, 40.4225, 5.7357> }
				triangle { <-6.6032, 39.9021, 4.02884>, <-5.123, 40.4225, 5.7357>, <-5.5621, 44.5216, 6.7443> }
				triangle { <-5.5621, 44.5216, 6.7443>, <-3.03755, 41.8645, 8.3931>, <-5.123, 40.4225, 5.7357> }
				triangle { <-5.5621, 44.5216, 6.7443>, <-5.123, 40.4225, 5.7357>, <-3.03755, 41.8645, 8.3931> }
				triangle { <-5.123, 40.4225, 5.7357>, <-3.03755, 41.8645, 8.3931>, <-7.07171, 33.6408, 1.3172> }
				triangle { <-5.123, 40.4225, 5.7357>, <-7.07171, 33.6408, 1.3172>, <-3.03755, 41.8645, 8.3931> }
				triangle { <-5.5621, 44.5216, 6.7443>, <5.9707, 51.3132, -0.361>, <12.1718, 53.5194, -1.9901> }
				triangle { <-5.5621, 44.5216, 6.7443>, <12.1718, 53.5194, -1.9901>, <5.9707, 51.3132, -0.361> }
				triangle { <12.1718, 53.5194, -1.9901>, <16.09138, 53.04273, -2.8818>, <12.9575, 49.8712, -3.1944> }
				triangle { <12.1718, 53.5194, -1.9901>, <12.9575, 49.8712, -3.1944>, <16.09138, 53.04273, -2.8818> }
				triangle { <12.9575, 49.8712, -3.1944>, <-5.5621, 44.5216, 6.7443>, <12.1718, 53.5194, -1.9901> }
				triangle { <12.9575, 49.8712, -3.1944>, <12.1718, 53.5194, -1.9901>, <-5.5621, 44.5216, 6.7443> }
				triangle { <-5.5621, 44.5216, 6.7443>, <12.9575, 49.8712, -3.1944>, <-3.03755, 41.8645, 8.3931> }
				triangle { <-5.5621, 44.5216, 6.7443>, <-3.03755, 41.8645, 8.3931>, <12.9575, 49.8712, -3.1944> }
				triangle { <-3.3053, 38.5094, 6.9229>, <-3.1698, 36.2885, 6.2712>, <-7.07171, 33.6408, 1.3172> }
				triangle { <-3.3053, 38.5094, 6.9229>, <-7.07171, 33.6408, 1.3172>, <-3.1698, 36.2885, 6.2712> }
				triangle { <-3.3053, 38.5094, 6.9229>, <-0.513, 39.2074, 10.04196>, <-3.1698, 36.2885, 6.2712> }
				triangle { <-3.3053, 38.5094, 6.9229>, <-3.1698, 36.2885, 6.2712>, <-0.513, 39.2074, 10.04196> }
				triangle { <-3.3053, 38.5094, 6.9229>, <-3.03755, 41.8645, 8.3931>, <-0.513, 39.2074, 10.04196> }
				triangle { <-3.3053, 38.5094, 6.9229>, <-0.513, 39.2074, 10.04196>, <-3.03755, 41.8645, 8.3931> }
				triangle { <-7.07171, 33.6408, 1.3172>, <-3.03755, 41.8645, 8.3931>, <-3.3053, 38.5094, 6.9229> }
				triangle { <-7.07171, 33.6408, 1.3172>, <-3.3053, 38.5094, 6.9229>, <-3.03755, 41.8645, 8.3931> }
				triangle { <15.2013, 50.3308, -0.01154>, <11.2218, 45.7864, 3.06849>, <-0.513, 39.2074, 10.04196> }
				triangle { <15.2013, 50.3308, -0.01154>, <-0.513, 39.2074, 10.04196>, <11.2218, 45.7864, 3.06849> }
				triangle { <12.9575, 49.8712, -3.1944>, <16.09138, 53.04273, -2.8818>, <15.2013, 50.3308, -0.01154> }
				triangle { <12.9575, 49.8712, -3.1944>, <15.2013, 50.3308, -0.01154>, <16.09138, 53.04273, -2.8818> }
				triangle { <15.2013, 50.3308, -0.01154>, <-0.513, 39.2074, 10.04196>, <12.9575, 49.8712, -3.1944> }
				triangle { <15.2013, 50.3308, -0.01154>, <12.9575, 49.8712, -3.1944>, <-0.513, 39.2074, 10.04196> }
				triangle { <-3.03755, 41.8645, 8.3931>, <12.9575, 49.8712, -3.1944>, <-0.513, 39.2074, 10.04196> }
				triangle { <-3.03755, 41.8645, 8.3931>, <-0.513, 39.2074, 10.04196>, <12.9575, 49.8712, -3.1944> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.4292, 32.6496, 0.8658>, <-7.2701, 33.4319, 0.7723>, 0.1826 }
				cylinder { <-7.2701, 33.4319, 0.7723>, <-7.09282, 34.2096, 0.6729>, 0.1826 }
				cylinder { <-7.09282, 34.2096, 0.6729>, <-6.8973, 34.9821, 0.5677>, 0.1826 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.8973, 34.9821, 0.5677>, <-6.8384, 35.3397, 0.4194>, 0.02669 }
				cylinder { <-6.8384, 35.3397, 0.4194>, <-6.82, 35.6525, 0.1846>, 0.02669 }
				cylinder { <-6.82, 35.6525, 0.1846>, <-6.8436, 35.898, -0.1194>, 0.02669 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.8436, 35.898, -0.1194>, <-9.5771, 38.6683, -5.7435>, <-8.5841, 40.4238, -6.8869> }
				triangle { <-6.8436, 35.898, -0.1194>, <-8.5841, 40.4238, -6.8869>, <-9.5771, 38.6683, -5.7435> }
				triangle { <-9.5771, 38.6683, -5.7435>, <-11.00512, 41.4482, -10.219>, <-8.5841, 40.4238, -6.8869> }
				triangle { <-9.5771, 38.6683, -5.7435>, <-8.5841, 40.4238, -6.8869>, <-11.00512, 41.4482, -10.219> }
				triangle { <-11.00512, 41.4482, -10.219>, <-7.5396, 43.1547, -9.1099>, <-8.5841, 40.4238, -6.8869> }
				triangle { <-11.00512, 41.4482, -10.219>, <-8.5841, 40.4238, -6.8869>, <-7.5396, 43.1547, -9.1099> }
				triangle { <-8.5841, 40.4238, -6.8869>, <-7.5396, 43.1547, -9.1099>, <-6.8436, 35.898, -0.1194> }
				triangle { <-8.5841, 40.4238, -6.8869>, <-6.8436, 35.898, -0.1194>, <-7.5396, 43.1547, -9.1099> }
				triangle { <-11.00512, 41.4482, -10.219>, <-4.1392, 34.7516, -21.9508>, <0.2121, 33.3308, -26.9529> }
				triangle { <-11.00512, 41.4482, -10.219>, <0.2121, 33.3308, -26.9529>, <-4.1392, 34.7516, -21.9508> }
				triangle { <0.2121, 33.3308, -26.9529>, <3.8791, 32.557, -28.4823>, <2.7176, 32.1247, -24.188> }
				triangle { <0.2121, 33.3308, -26.9529>, <2.7176, 32.1247, -24.188>, <3.8791, 32.557, -28.4823> }
				triangle { <2.7176, 32.1247, -24.188>, <-11.00512, 41.4482, -10.219>, <0.2121, 33.3308, -26.9529> }
				triangle { <2.7176, 32.1247, -24.188>, <0.2121, 33.3308, -26.9529>, <-11.00512, 41.4482, -10.219> }
				triangle { <-11.00512, 41.4482, -10.219>, <2.7176, 32.1247, -24.188>, <-7.5396, 43.1547, -9.1099> }
				triangle { <-11.00512, 41.4482, -10.219>, <-7.5396, 43.1547, -9.1099>, <2.7176, 32.1247, -24.188> }
				triangle { <-6.08903, 41.6525, -6.0884>, <-4.864, 40.9891, -4.235>, <-6.8436, 35.898, -0.1194> }
				triangle { <-6.08903, 41.6525, -6.0884>, <-6.8436, 35.898, -0.1194>, <-4.864, 40.9891, -4.235> }
				triangle { <-6.08903, 41.6525, -6.0884>, <-4.07411, 44.8612, -8.000768>, <-4.864, 40.9891, -4.235> }
				triangle { <-6.08903, 41.6525, -6.0884>, <-4.864, 40.9891, -4.235>, <-4.07411, 44.8612, -8.000768> }
				triangle { <-6.08903, 41.6525, -6.0884>, <-7.5396, 43.1547, -9.1099>, <-4.07411, 44.8612, -8.000768> }
				triangle { <-6.08903, 41.6525, -6.0884>, <-4.07411, 44.8612, -8.000768>, <-7.5396, 43.1547, -9.1099> }
				triangle { <-6.8436, 35.898, -0.1194>, <-7.5396, 43.1547, -9.1099>, <-6.08903, 41.6525, -6.0884> }
				triangle { <-6.8436, 35.898, -0.1194>, <-6.08903, 41.6525, -6.0884>, <-7.5396, 43.1547, -9.1099> }
				triangle { <4.3707, 35.3786, -25.622>, <3.06902, 38.3012, -19.6438>, <-4.07411, 44.8612, -8.000768> }
				triangle { <4.3707, 35.3786, -25.622>, <-4.07411, 44.8612, -8.000768>, <3.06902, 38.3012, -19.6438> }
				triangle { <2.7176, 32.1247, -24.188>, <3.8791, 32.557, -28.4823>, <4.3707, 35.3786, -25.622> }
				triangle { <2.7176, 32.1247, -24.188>, <4.3707, 35.3786, -25.622>, <3.8791, 32.557, -28.4823> }
				triangle { <4.3707, 35.3786, -25.622>, <-4.07411, 44.8612, -8.000768>, <2.7176, 32.1247, -24.188> }
				triangle { <4.3707, 35.3786, -25.622>, <2.7176, 32.1247, -24.188>, <-4.07411, 44.8612, -8.000768> }
				triangle { <-7.5396, 43.1547, -9.1099>, <2.7176, 32.1247, -24.188>, <-4.07411, 44.8612, -8.000768> }
				triangle { <-7.5396, 43.1547, -9.1099>, <-4.07411, 44.8612, -8.000768>, <2.7176, 32.1247, -24.188> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.8973, 34.9821, 0.5677>, <-6.6838, 35.7491, 0.4569>, 0.1826 }
				cylinder { <-6.6838, 35.7491, 0.4569>, <-6.4523, 36.5099, 0.3405>, 0.1826 }
				cylinder { <-6.4523, 36.5099, 0.3405>, <-6.2031, 37.2643, 0.2184>, 0.1826 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.2031, 37.2643, 0.2184>, <-6.0533, 37.6237, 0.2602>, 0.02669 }
				cylinder { <-6.0533, 37.6237, 0.2602>, <-5.8858, 37.9488, 0.4>, 0.02669 }
				cylinder { <-5.8858, 37.9488, 0.4>, <-5.7129, 38.2162, 0.6278>, 0.02669 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.7129, 38.2162, 0.6278>, <-4.3879, 44.4714, 3.05556>, <-2.8565, 44.8602, 4.7523> }
				triangle { <-5.7129, 38.2162, 0.6278>, <-2.8565, 44.8602, 4.7523>, <-4.3879, 44.4714, 3.05556> }
				triangle { <-4.3879, 44.4714, 3.05556>, <-2.7245, 49.02314, 5.5681>, <-2.8565, 44.8602, 4.7523> }
				triangle { <-4.3879, 44.4714, 3.05556>, <-2.8565, 44.8602, 4.7523>, <-2.7245, 49.02314, 5.5681> }
				triangle { <-2.7245, 49.02314, 5.5681>, <-0.6013, 46.1209, 7.3628>, <-2.8565, 44.8602, 4.7523> }
				triangle { <-2.7245, 49.02314, 5.5681>, <-2.8565, 44.8602, 4.7523>, <-0.6013, 46.1209, 7.3628> }
				triangle { <-2.8565, 44.8602, 4.7523>, <-0.6013, 46.1209, 7.3628>, <-5.7129, 38.2162, 0.6278> }
				triangle { <-2.8565, 44.8602, 4.7523>, <-5.7129, 38.2162, 0.6278>, <-0.6013, 46.1209, 7.3628> }
				triangle { <-2.7245, 49.02314, 5.5681>, <9.6701, 53.8076, -1.7187>, <16.1246, 55.05247, -3.3817> }
				triangle { <-2.7245, 49.02314, 5.5681>, <16.1246, 55.05247, -3.3817>, <9.6701, 53.8076, -1.7187> }
				triangle { <16.1246, 55.05247, -3.3817>, <19.943, 53.9948, -4.2096>, <16.3994, 51.2783, -4.4099> }
				triangle { <16.1246, 55.05247, -3.3817>, <16.3994, 51.2783, -4.4099>, <19.943, 53.9948, -4.2096> }
				triangle { <16.3994, 51.2783, -4.4099>, <-2.7245, 49.02314, 5.5681>, <16.1246, 55.05247, -3.3817> }
				triangle { <16.3994, 51.2783, -4.4099>, <16.1246, 55.05247, -3.3817>, <-2.7245, 49.02314, 5.5681> }
				triangle { <-2.7245, 49.02314, 5.5681>, <16.3994, 51.2783, -4.4099>, <-0.6013, 46.1209, 7.3628> }
				triangle { <-2.7245, 49.02314, 5.5681>, <-0.6013, 46.1209, 7.3628>, <16.3994, 51.2783, -4.4099> }
				triangle { <-1.3278, 42.7706, 6.04459>, <-1.5003, 40.5244, 5.4964>, <-5.7129, 38.2162, 0.6278> }
				triangle { <-1.3278, 42.7706, 6.04459>, <-5.7129, 38.2162, 0.6278>, <-1.5003, 40.5244, 5.4964> }
				triangle { <-1.3278, 42.7706, 6.04459>, <1.5219, 43.2187, 9.1576>, <-1.5003, 40.5244, 5.4964> }
				triangle { <-1.3278, 42.7706, 6.04459>, <-1.5003, 40.5244, 5.4964>, <1.5219, 43.2187, 9.1576> }
				triangle { <-1.3278, 42.7706, 6.04459>, <-0.6013, 46.1209, 7.3628>, <1.5219, 43.2187, 9.1576> }
				triangle { <-1.3278, 42.7706, 6.04459>, <1.5219, 43.2187, 9.1576>, <-0.6013, 46.1209, 7.3628> }
				triangle { <-5.7129, 38.2162, 0.6278>, <-0.6013, 46.1209, 7.3628>, <-1.3278, 42.7706, 6.04459> }
				triangle { <-5.7129, 38.2162, 0.6278>, <-1.3278, 42.7706, 6.04459>, <-0.6013, 46.1209, 7.3628> }
				triangle { <18.6725, 51.5698, -1.228>, <14.08656, 47.771, 2.01438>, <1.5219, 43.2187, 9.1576> }
				triangle { <18.6725, 51.5698, -1.228>, <1.5219, 43.2187, 9.1576>, <14.08656, 47.771, 2.01438> }
				triangle { <16.3994, 51.2783, -4.4099>, <19.943, 53.9948, -4.2096>, <18.6725, 51.5698, -1.228> }
				triangle { <16.3994, 51.2783, -4.4099>, <18.6725, 51.5698, -1.228>, <19.943, 53.9948, -4.2096> }
				triangle { <18.6725, 51.5698, -1.228>, <1.5219, 43.2187, 9.1576>, <16.3994, 51.2783, -4.4099> }
				triangle { <18.6725, 51.5698, -1.228>, <16.3994, 51.2783, -4.4099>, <1.5219, 43.2187, 9.1576> }
				triangle { <-0.6013, 46.1209, 7.3628>, <16.3994, 51.2783, -4.4099>, <1.5219, 43.2187, 9.1576> }
				triangle { <-0.6013, 46.1209, 7.3628>, <1.5219, 43.2187, 9.1576>, <16.3994, 51.2783, -4.4099> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.2031, 37.2643, 0.2184>, <-6.08175, 37.6318, 0.159>, 0.02669 }
				cylinder { <-6.08175, 37.6318, 0.159>, <-5.9603, 37.9993, 0.0996>, 0.02669 }
				cylinder { <-5.9603, 37.9993, 0.0996>, <-5.8389, 38.3668, 0.04016>, 0.02669 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.8389, 38.3668, 0.04016>, <-6.0462, 44.6988, -2.5366>, <-4.4358, 46.2985, -2.06475> }
				triangle { <-5.8389, 38.3668, 0.04016>, <-4.4358, 46.2985, -2.06475>, <-6.0462, 44.6988, -2.5366> }
				triangle { <-6.0462, 44.6988, -2.5366>, <-5.4136, 49.8884, -4.1067>, <-4.4358, 46.2985, -2.06475> }
				triangle { <-6.0462, 44.6988, -2.5366>, <-4.4358, 46.2985, -2.06475>, <-5.4136, 49.8884, -4.1067> }
				triangle { <-5.4136, 49.8884, -4.1067>, <-2.2502, 49.2299, -1.7168>, <-4.4358, 46.2985, -2.06475> }
				triangle { <-5.4136, 49.8884, -4.1067>, <-4.4358, 46.2985, -2.06475>, <-2.2502, 49.2299, -1.7168> }
				triangle { <-4.4358, 46.2985, -2.06475>, <-2.2502, 49.2299, -1.7168>, <-5.8389, 38.3668, 0.04016> }
				triangle { <-4.4358, 46.2985, -2.06475>, <-5.8389, 38.3668, 0.04016>, <-2.2502, 49.2299, -1.7168> }
				triangle { <-5.4136, 49.8884, -4.1067>, <3.5701, 49.743, -16.3087>, <8.9809, 50.2108, -20.3682> }
				triangle { <-5.4136, 49.8884, -4.1067>, <8.9809, 50.2108, -20.3682>, <3.5701, 49.743, -16.3087> }
				triangle { <8.9809, 50.2108, -20.3682>, <12.7429, 49.2914, -21.5459>, <10.1891, 46.8026, -18.8513> }
				triangle { <8.9809, 50.2108, -20.3682>, <10.1891, 46.8026, -18.8513>, <12.7429, 49.2914, -21.5459> }
				triangle { <10.1891, 46.8026, -18.8513>, <-5.4136, 49.8884, -4.1067>, <8.9809, 50.2108, -20.3682> }
				triangle { <10.1891, 46.8026, -18.8513>, <8.9809, 50.2108, -20.3682>, <-5.4136, 49.8884, -4.1067> }
				triangle { <-5.4136, 49.8884, -4.1067>, <10.1891, 46.8026, -18.8513>, <-2.2502, 49.2299, -1.7168> }
				triangle { <-5.4136, 49.8884, -4.1067>, <-2.2502, 49.2299, -1.7168>, <10.1891, 46.8026, -18.8513> }
				triangle { <-2.1581, 45.8244, -0.344>, <-1.7439, 43.8032, 0.7135>, <-5.8389, 38.3668, 0.04016> }
				triangle { <-2.1581, 45.8244, -0.344>, <-5.8389, 38.3668, 0.04016>, <-1.7439, 43.8032, 0.7135> }
				triangle { <-2.1581, 45.8244, -0.344>, <0.913, 48.5714, 0.6729>, <-1.7439, 43.8032, 0.7135> }
				triangle { <-2.1581, 45.8244, -0.344>, <-1.7439, 43.8032, 0.7135>, <0.913, 48.5714, 0.6729> }
				triangle { <-2.1581, 45.8244, -0.344>, <-2.2502, 49.2299, -1.7168>, <0.913, 48.5714, 0.6729> }
				triangle { <-2.1581, 45.8244, -0.344>, <0.913, 48.5714, 0.6729>, <-2.2502, 49.2299, -1.7168> }
				triangle { <-5.8389, 38.3668, 0.04016>, <-2.2502, 49.2299, -1.7168>, <-2.1581, 45.8244, -0.344> }
				triangle { <-5.8389, 38.3668, 0.04016>, <-2.1581, 45.8244, -0.344>, <-2.2502, 49.2299, -1.7168> }
				triangle { <12.777, 49.4207, -17.5003>, <10.1499, 48.3734, -11.3378>, <0.913, 48.5714, 0.6729> }
				triangle { <12.777, 49.4207, -17.5003>, <0.913, 48.5714, 0.6729>, <10.1499, 48.3734, -11.3378> }
				triangle { <10.1891, 46.8026, -18.8513>, <12.7429, 49.2914, -21.5459>, <12.777, 49.4207, -17.5003> }
				triangle { <10.1891, 46.8026, -18.8513>, <12.777, 49.4207, -17.5003>, <12.7429, 49.2914, -21.5459> }
				triangle { <12.777, 49.4207, -17.5003>, <0.913, 48.5714, 0.6729>, <10.1891, 46.8026, -18.8513> }
				triangle { <12.777, 49.4207, -17.5003>, <10.1891, 46.8026, -18.8513>, <0.913, 48.5714, 0.6729> }
				triangle { <-2.2502, 49.2299, -1.7168>, <10.1891, 46.8026, -18.8513>, <0.913, 48.5714, 0.6729> }
				triangle { <-2.2502, 49.2299, -1.7168>, <0.913, 48.5714, 0.6729>, <10.1891, 46.8026, -18.8513> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <-6.2789, 22.6622, 1.004623>, <-8.9848, 23.9339, 1.8363>, 0.4231 }
			cylinder { <-8.9848, 23.9339, 1.8363>, <-11.9195, 24.2548, 2.7934>, 0.4231 }
			cylinder { <-11.9195, 24.2548, 2.7934>, <-14.7866, 23.5923, 3.7794>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-14.7866, 23.5923, 3.7794>, <-16.7936, 23.1286, 4.4696>, 0.4231 }
			cylinder { <-16.7936, 23.1286, 4.4696>, <-18.8005, 22.6649, 5.1598>, 0.4231 }
			cylinder { <-18.8005, 22.6649, 5.1598>, <-20.8075, 22.2012, 5.85>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-20.8075, 22.2012, 5.85>, <-22.03669, 23.1421, 7.3742>, 0.4231 }
			cylinder { <-22.03669, 23.1421, 7.3742>, <-23.2658, 24.08303, 8.8984>, 0.4231 }
			cylinder { <-23.2658, 24.08303, 8.8984>, <-24.4949, 25.02394, 10.4226>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-24.4949, 25.02394, 10.4226>, <-27.9517, 26.9003, 12.9127>, 0.4231 }
				cylinder { <-27.9517, 26.9003, 12.9127>, <-32.02408, 28.5243, 14.4776>, 0.4231 }
				cylinder { <-32.02408, 28.5243, 14.4776>, <-36.468, 29.7986, 15.02339>, 0.4231 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-36.468, 29.7986, 15.02339>, <-37.9698, 28.5192, 17.04072>, <-39.4647, 30.7018, 15.7224> }
					triangle { <-36.468, 29.7986, 15.02339>, <-39.4647, 30.7018, 15.7224>, <-37.9698, 28.5192, 17.04072> }
					triangle { <-37.9698, 28.5192, 17.04072>, <-40.2593, 27.316, 17.1583>, <-39.4647, 30.7018, 15.7224> }
					triangle { <-37.9698, 28.5192, 17.04072>, <-39.4647, 30.7018, 15.7224>, <-40.2593, 27.316, 17.1583> }
					triangle { <-40.2593, 27.316, 17.1583>, <-43.7183, 27.3268, 17.1152>, <-43.1829, 28.4398, 17.9378> }
					triangle { <-40.2593, 27.316, 17.1583>, <-43.1829, 28.4398, 17.9378>, <-43.7183, 27.3268, 17.1152> }
					triangle { <-43.1829, 28.4398, 17.9378>, <-42.6259, 30.1803, 17.4708>, <-40.2593, 27.316, 17.1583> }
					triangle { <-43.1829, 28.4398, 17.9378>, <-40.2593, 27.316, 17.1583>, <-42.6259, 30.1803, 17.4708> }
					triangle { <-40.2593, 27.316, 17.1583>, <-42.6259, 30.1803, 17.4708>, <-39.4647, 30.7018, 15.7224> }
					triangle { <-40.2593, 27.316, 17.1583>, <-39.4647, 30.7018, 15.7224>, <-42.6259, 30.1803, 17.4708> }
					triangle { <-39.4647, 30.7018, 15.7224>, <-42.6259, 30.1803, 17.4708>, <-42.4212, 31.5349, 15.9751> }
					triangle { <-39.4647, 30.7018, 15.7224>, <-42.4212, 31.5349, 15.9751>, <-42.6259, 30.1803, 17.4708> }
					triangle { <-42.6259, 30.1803, 17.4708>, <-45.2967, 32.418, 16.7696>, <-42.4212, 31.5349, 15.9751> }
					triangle { <-42.6259, 30.1803, 17.4708>, <-42.4212, 31.5349, 15.9751>, <-45.2967, 32.418, 16.7696> }
					triangle { <-43.1829, 28.4398, 17.9378>, <-45.8243, 29.1826, 18.1518>, <-42.6259, 30.1803, 17.4708> }
					triangle { <-43.1829, 28.4398, 17.9378>, <-42.6259, 30.1803, 17.4708>, <-45.8243, 29.1826, 18.1518> }
					triangle { <-42.6259, 30.1803, 17.4708>, <-45.8243, 29.1826, 18.1518>, <-45.8371, 30.9583, 17.6549> }
					triangle { <-42.6259, 30.1803, 17.4708>, <-45.8371, 30.9583, 17.6549>, <-45.8243, 29.1826, 18.1518> }
					triangle { <-45.8371, 30.9583, 17.6549>, <-45.2967, 32.418, 16.7696>, <-42.6259, 30.1803, 17.4708> }
					triangle { <-45.8371, 30.9583, 17.6549>, <-42.6259, 30.1803, 17.4708>, <-45.2967, 32.418, 16.7696> }
					triangle { <-43.7183, 27.3268, 17.1152>, <-45.8243, 29.1826, 18.1518>, <-43.1829, 28.4398, 17.9378> }
					triangle { <-43.7183, 27.3268, 17.1152>, <-43.1829, 28.4398, 17.9378>, <-45.8243, 29.1826, 18.1518> }
					triangle { <-45.8243, 29.1826, 18.1518>, <-46.3795, 30.4768, 18.1153>, <-45.8371, 30.9583, 17.6549> }
					triangle { <-45.8243, 29.1826, 18.1518>, <-45.8371, 30.9583, 17.6549>, <-46.3795, 30.4768, 18.1153> }
					triangle { <-46.3795, 30.4768, 18.1153>, <-46.7727, 31.9515, 18.03808>, <-45.8371, 30.9583, 17.6549> }
					triangle { <-46.3795, 30.4768, 18.1153>, <-45.8371, 30.9583, 17.6549>, <-46.7727, 31.9515, 18.03808> }
					triangle { <-46.7727, 31.9515, 18.03808>, <-45.2967, 32.418, 16.7696>, <-45.8371, 30.9583, 17.6549> }
					triangle { <-46.7727, 31.9515, 18.03808>, <-45.8371, 30.9583, 17.6549>, <-45.2967, 32.418, 16.7696> }
					triangle { <-46.7727, 31.9515, 18.03808>, <-47.8737, 33.01072, 15.9828>, <-45.2967, 32.418, 16.7696> }
					triangle { <-46.7727, 31.9515, 18.03808>, <-45.2967, 32.418, 16.7696>, <-47.8737, 33.01072, 15.9828> }
					triangle { <-39.4647, 30.7018, 15.7224>, <-37.00129, 32.1003, 16.5659>, <-36.468, 29.7986, 15.02339> }
					triangle { <-39.4647, 30.7018, 15.7224>, <-36.468, 29.7986, 15.02339>, <-37.00129, 32.1003, 16.5659> }
					triangle { <-39.4647, 30.7018, 15.7224>, <-38.3306, 34.2974, 16.5617>, <-37.00129, 32.1003, 16.5659> }
					triangle { <-39.4647, 30.7018, 15.7224>, <-37.00129, 32.1003, 16.5659>, <-38.3306, 34.2974, 16.5617> }
					triangle { <-41.4329, 34.96, 16.9636>, <-41.3662, 35.9734, 16.07848>, <-38.3306, 34.2974, 16.5617> }
					triangle { <-41.4329, 34.96, 16.9636>, <-38.3306, 34.2974, 16.5617>, <-41.3662, 35.9734, 16.07848> }
					triangle { <-38.3306, 34.2974, 16.5617>, <-41.893, 33.08945, 16.6464>, <-41.4329, 34.96, 16.9636> }
					triangle { <-38.3306, 34.2974, 16.5617>, <-41.4329, 34.96, 16.9636>, <-41.893, 33.08945, 16.6464> }
					triangle { <-39.4647, 30.7018, 15.7224>, <-41.893, 33.08945, 16.6464>, <-38.3306, 34.2974, 16.5617> }
					triangle { <-39.4647, 30.7018, 15.7224>, <-38.3306, 34.2974, 16.5617>, <-41.893, 33.08945, 16.6464> }
					triangle { <-42.4212, 31.5349, 15.9751>, <-41.893, 33.08945, 16.6464>, <-39.4647, 30.7018, 15.7224> }
					triangle { <-42.4212, 31.5349, 15.9751>, <-39.4647, 30.7018, 15.7224>, <-41.893, 33.08945, 16.6464> }
					triangle { <-42.4212, 31.5349, 15.9751>, <-45.2967, 32.418, 16.7696>, <-41.893, 33.08945, 16.6464> }
					triangle { <-42.4212, 31.5349, 15.9751>, <-41.893, 33.08945, 16.6464>, <-45.2967, 32.418, 16.7696> }
					triangle { <-41.893, 33.08945, 16.6464>, <-44.05813, 35.7128, 17.286>, <-41.4329, 34.96, 16.9636> }
					triangle { <-41.893, 33.08945, 16.6464>, <-41.4329, 34.96, 16.9636>, <-44.05813, 35.7128, 17.286> }
					triangle { <-44.9986, 34.1081, 17.1276>, <-44.05813, 35.7128, 17.286>, <-41.893, 33.08945, 16.6464> }
					triangle { <-44.9986, 34.1081, 17.1276>, <-41.893, 33.08945, 16.6464>, <-44.05813, 35.7128, 17.286> }
					triangle { <-41.893, 33.08945, 16.6464>, <-45.2967, 32.418, 16.7696>, <-44.9986, 34.1081, 17.1276> }
					triangle { <-41.893, 33.08945, 16.6464>, <-44.9986, 34.1081, 17.1276>, <-45.2967, 32.418, 16.7696> }
					triangle { <-41.4329, 34.96, 16.9636>, <-44.05813, 35.7128, 17.286>, <-41.3662, 35.9734, 16.07848> }
					triangle { <-41.4329, 34.96, 16.9636>, <-41.3662, 35.9734, 16.07848>, <-44.05813, 35.7128, 17.286> }
					triangle { <-44.9986, 34.1081, 17.1276>, <-45.183, 34.9004, 17.5288>, <-44.05813, 35.7128, 17.286> }
					triangle { <-44.9986, 34.1081, 17.1276>, <-44.05813, 35.7128, 17.286>, <-45.183, 34.9004, 17.5288> }
					triangle { <-44.9986, 34.1081, 17.1276>, <-46.2599, 33.8473, 17.7867>, <-45.183, 34.9004, 17.5288> }
					triangle { <-44.9986, 34.1081, 17.1276>, <-45.183, 34.9004, 17.5288>, <-46.2599, 33.8473, 17.7867> }
					triangle { <-44.9986, 34.1081, 17.1276>, <-45.2967, 32.418, 16.7696>, <-46.2599, 33.8473, 17.7867> }
					triangle { <-44.9986, 34.1081, 17.1276>, <-46.2599, 33.8473, 17.7867>, <-45.2967, 32.418, 16.7696> }
					triangle { <-45.2967, 32.418, 16.7696>, <-47.8737, 33.01072, 15.9828>, <-46.2599, 33.8473, 17.7867> }
					triangle { <-45.2967, 32.418, 16.7696>, <-46.2599, 33.8473, 17.7867>, <-47.8737, 33.01072, 15.9828> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-36.468, 29.7986, 15.02339>, <-36.998, 32.491, 15.6804>, <-39.4628, 30.932, 15.2007> }
					triangle { <-36.468, 29.7986, 15.02339>, <-39.4628, 30.932, 15.2007>, <-36.998, 32.491, 15.6804> }
					triangle { <-36.998, 32.491, 15.6804>, <-38.3838, 33.7125, 17.4945>, <-39.4628, 30.932, 15.2007> }
					triangle { <-36.998, 32.491, 15.6804>, <-39.4628, 30.932, 15.2007>, <-38.3838, 33.7125, 17.4945> }
					triangle { <-38.3838, 33.7125, 17.4945>, <-41.3933, 34.6671, 18.9082>, <-41.418, 34.8114, 17.4315> }
					triangle { <-38.3838, 33.7125, 17.4945>, <-41.418, 34.8114, 17.4315>, <-41.3933, 34.6671, 18.9082> }
					triangle { <-41.418, 34.8114, 17.4315>, <-41.8245, 33.5775, 16.06414>, <-38.3838, 33.7125, 17.4945> }
					triangle { <-41.418, 34.8114, 17.4315>, <-38.3838, 33.7125, 17.4945>, <-41.8245, 33.5775, 16.06414> }
					triangle { <-38.3838, 33.7125, 17.4945>, <-41.8245, 33.5775, 16.06414>, <-39.4628, 30.932, 15.2007> }
					triangle { <-38.3838, 33.7125, 17.4945>, <-39.4628, 30.932, 15.2007>, <-41.8245, 33.5775, 16.06414> }
					triangle { <-39.4628, 30.932, 15.2007>, <-41.8245, 33.5775, 16.06414>, <-42.4199, 31.6884, 15.6273> }
					triangle { <-39.4628, 30.932, 15.2007>, <-42.4199, 31.6884, 15.6273>, <-41.8245, 33.5775, 16.06414> }
					triangle { <-41.8245, 33.5775, 16.06414>, <-45.2929, 32.8784, 15.7262>, <-42.4199, 31.6884, 15.6273> }
					triangle { <-41.8245, 33.5775, 16.06414>, <-42.4199, 31.6884, 15.6273>, <-45.2929, 32.8784, 15.7262> }
					triangle { <-41.418, 34.8114, 17.4315>, <-44.06011, 35.4775, 17.8194>, <-41.8245, 33.5775, 16.06414> }
					triangle { <-41.418, 34.8114, 17.4315>, <-41.8245, 33.5775, 16.06414>, <-44.06011, 35.4775, 17.8194> }
					triangle { <-41.8245, 33.5775, 16.06414>, <-44.06011, 35.4775, 17.8194>, <-44.9803, 34.368, 16.6695> }
					triangle { <-41.8245, 33.5775, 16.06414>, <-44.9803, 34.368, 16.6695>, <-44.06011, 35.4775, 17.8194> }
					triangle { <-44.9803, 34.368, 16.6695>, <-45.2929, 32.8784, 15.7262>, <-41.8245, 33.5775, 16.06414> }
					triangle { <-44.9803, 34.368, 16.6695>, <-41.8245, 33.5775, 16.06414>, <-45.2929, 32.8784, 15.7262> }
					triangle { <-41.3933, 34.6671, 18.9082>, <-44.06011, 35.4775, 17.8194>, <-41.418, 34.8114, 17.4315> }
					triangle { <-41.3933, 34.6671, 18.9082>, <-41.418, 34.8114, 17.4315>, <-44.06011, 35.4775, 17.8194> }
					triangle { <-44.06011, 35.4775, 17.8194>, <-45.1813, 35.1123, 17.04876>, <-44.9803, 34.368, 16.6695> }
					triangle { <-44.06011, 35.4775, 17.8194>, <-44.9803, 34.368, 16.6695>, <-45.1813, 35.1123, 17.04876> }
					triangle { <-45.1813, 35.1123, 17.04876>, <-46.2537, 34.5958, 16.09039>, <-44.9803, 34.368, 16.6695> }
					triangle { <-45.1813, 35.1123, 17.04876>, <-44.9803, 34.368, 16.6695>, <-46.2537, 34.5958, 16.09039> }
					triangle { <-46.2537, 34.5958, 16.09039>, <-45.2929, 32.8784, 15.7262>, <-44.9803, 34.368, 16.6695> }
					triangle { <-46.2537, 34.5958, 16.09039>, <-44.9803, 34.368, 16.6695>, <-45.2929, 32.8784, 15.7262> }
					triangle { <-46.2537, 34.5958, 16.09039>, <-47.8763, 32.7038, 16.6784>, <-45.2929, 32.8784, 15.7262> }
					triangle { <-46.2537, 34.5958, 16.09039>, <-45.2929, 32.8784, 15.7262>, <-47.8763, 32.7038, 16.6784> }
					triangle { <-39.4628, 30.932, 15.2007>, <-37.9538, 30.4303, 12.7092>, <-36.468, 29.7986, 15.02339> }
					triangle { <-39.4628, 30.932, 15.2007>, <-36.468, 29.7986, 15.02339>, <-37.9538, 30.4303, 12.7092> }
					triangle { <-39.4628, 30.932, 15.2007>, <-40.1887, 29.9725, 11.5303>, <-37.9538, 30.4303, 12.7092> }
					triangle { <-39.4628, 30.932, 15.2007>, <-37.9538, 30.4303, 12.7092>, <-40.1887, 29.9725, 11.5303> }
					triangle { <-43.1777, 30.967, 12.07908>, <-43.6816, 29.784, 11.6769>, <-40.1887, 29.9725, 11.5303> }
					triangle { <-43.1777, 30.967, 12.07908>, <-40.1887, 29.9725, 11.5303>, <-43.6816, 29.784, 11.6769> }
					triangle { <-40.1887, 29.9725, 11.5303>, <-42.6789, 31.5336, 13.8795>, <-43.1777, 30.967, 12.07908> }
					triangle { <-40.1887, 29.9725, 11.5303>, <-43.1777, 30.967, 12.07908>, <-42.6789, 31.5336, 13.8795> }
					triangle { <-39.4628, 30.932, 15.2007>, <-42.6789, 31.5336, 13.8795>, <-40.1887, 29.9725, 11.5303> }
					triangle { <-39.4628, 30.932, 15.2007>, <-40.1887, 29.9725, 11.5303>, <-42.6789, 31.5336, 13.8795> }
					triangle { <-42.4199, 31.6884, 15.6273>, <-42.6789, 31.5336, 13.8795>, <-39.4628, 30.932, 15.2007> }
					triangle { <-42.4199, 31.6884, 15.6273>, <-39.4628, 30.932, 15.2007>, <-42.6789, 31.5336, 13.8795> }
					triangle { <-42.4199, 31.6884, 15.6273>, <-45.2929, 32.8784, 15.7262>, <-42.6789, 31.5336, 13.8795> }
					triangle { <-42.4199, 31.6884, 15.6273>, <-42.6789, 31.5336, 13.8795>, <-45.2929, 32.8784, 15.7262> }
					triangle { <-42.6789, 31.5336, 13.8795>, <-45.803, 31.7198, 12.4014>, <-43.1777, 30.967, 12.07908> }
					triangle { <-42.6789, 31.5336, 13.8795>, <-43.1777, 30.967, 12.07908>, <-45.803, 31.7198, 12.4014> }
					triangle { <-45.8405, 32.4631, 14.1134>, <-45.803, 31.7198, 12.4014>, <-42.6789, 31.5336, 13.8795> }
					triangle { <-45.8405, 32.4631, 14.1134>, <-42.6789, 31.5336, 13.8795>, <-45.803, 31.7198, 12.4014> }
					triangle { <-42.6789, 31.5336, 13.8795>, <-45.2929, 32.8784, 15.7262>, <-45.8405, 32.4631, 14.1134> }
					triangle { <-42.6789, 31.5336, 13.8795>, <-45.8405, 32.4631, 14.1134>, <-45.2929, 32.8784, 15.7262> }
					triangle { <-43.1777, 30.967, 12.07908>, <-45.803, 31.7198, 12.4014>, <-43.6816, 29.784, 11.6769> }
					triangle { <-43.1777, 30.967, 12.07908>, <-43.6816, 29.784, 11.6769>, <-45.803, 31.7198, 12.4014> }
					triangle { <-45.8405, 32.4631, 14.1134>, <-46.3619, 32.5667, 13.3785>, <-45.803, 31.7198, 12.4014> }
					triangle { <-45.8405, 32.4631, 14.1134>, <-45.803, 31.7198, 12.4014>, <-46.3619, 32.5667, 13.3785> }
					triangle { <-45.8405, 32.4631, 14.1134>, <-46.7597, 33.5048, 14.5174>, <-46.3619, 32.5667, 13.3785> }
					triangle { <-45.8405, 32.4631, 14.1134>, <-46.3619, 32.5667, 13.3785>, <-46.7597, 33.5048, 14.5174> }
					triangle { <-45.8405, 32.4631, 14.1134>, <-45.2929, 32.8784, 15.7262>, <-46.7597, 33.5048, 14.5174> }
					triangle { <-45.8405, 32.4631, 14.1134>, <-46.7597, 33.5048, 14.5174>, <-45.2929, 32.8784, 15.7262> }
					triangle { <-45.2929, 32.8784, 15.7262>, <-47.8763, 32.7038, 16.6784>, <-46.7597, 33.5048, 14.5174> }
					triangle { <-45.2929, 32.8784, 15.7262>, <-46.7597, 33.5048, 14.5174>, <-47.8763, 32.7038, 16.6784> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-36.468, 29.7986, 15.02339>, <-38.2199, 29.4462, 12.8397>, <-39.6115, 30.3821, 15.2736> }
					triangle { <-36.468, 29.7986, 15.02339>, <-39.6115, 30.3821, 15.2736>, <-38.2199, 29.4462, 12.8397> }
					triangle { <-38.2199, 29.4462, 12.8397>, <-39.9073, 30.9393, 11.5643>, <-39.6115, 30.3821, 15.2736> }
					triangle { <-38.2199, 29.4462, 12.8397>, <-39.6115, 30.3821, 15.2736>, <-39.9073, 30.9393, 11.5643> }
					triangle { <-39.9073, 30.9393, 11.5643>, <-42.894, 32.6713, 11.3482>, <-43.08357, 31.3398, 11.9755> }
					triangle { <-39.9073, 30.9393, 11.5643>, <-43.08357, 31.3398, 11.9755>, <-42.894, 32.6713, 11.3482> }
					triangle { <-43.08357, 31.3398, 11.9755>, <-42.9125, 30.7681, 13.7648>, <-39.9073, 30.9393, 11.5643> }
					triangle { <-43.08357, 31.3398, 11.9755>, <-39.9073, 30.9393, 11.5643>, <-42.9125, 30.7681, 13.7648> }
					triangle { <-39.9073, 30.9393, 11.5643>, <-42.9125, 30.7681, 13.7648>, <-39.6115, 30.3821, 15.2736> }
					triangle { <-39.9073, 30.9393, 11.5643>, <-39.6115, 30.3821, 15.2736>, <-42.9125, 30.7681, 13.7648> }
					triangle { <-39.6115, 30.3821, 15.2736>, <-42.9125, 30.7681, 13.7648>, <-42.519, 31.3218, 15.6759> }
					triangle { <-39.6115, 30.3821, 15.2736>, <-42.519, 31.3218, 15.6759>, <-42.9125, 30.7681, 13.7648> }
					triangle { <-42.9125, 30.7681, 13.7648>, <-45.5903, 31.7787, 15.872>, <-42.519, 31.3218, 15.6759> }
					triangle { <-42.9125, 30.7681, 13.7648>, <-42.519, 31.3218, 15.6759>, <-45.5903, 31.7787, 15.872> }
					triangle { <-43.08357, 31.3398, 11.9755>, <-45.676, 32.1892, 12.3392>, <-42.9125, 30.7681, 13.7648> }
					triangle { <-43.08357, 31.3398, 11.9755>, <-42.9125, 30.7681, 13.7648>, <-45.676, 32.1892, 12.3392> }
					triangle { <-42.9125, 30.7681, 13.7648>, <-45.676, 32.1892, 12.3392>, <-45.9973, 31.9078, 14.133> }
					triangle { <-42.9125, 30.7681, 13.7648>, <-45.9973, 31.9078, 14.133>, <-45.676, 32.1892, 12.3392> }
					triangle { <-45.9973, 31.9078, 14.133>, <-45.5903, 31.7787, 15.872>, <-42.9125, 30.7681, 13.7648> }
					triangle { <-45.9973, 31.9078, 14.133>, <-42.9125, 30.7681, 13.7648>, <-45.5903, 31.7787, 15.872> }
					triangle { <-42.894, 32.6713, 11.3482>, <-45.676, 32.1892, 12.3392>, <-43.08357, 31.3398, 11.9755> }
					triangle { <-42.894, 32.6713, 11.3482>, <-43.08357, 31.3398, 11.9755>, <-45.676, 32.1892, 12.3392> }
					triangle { <-45.676, 32.1892, 12.3392>, <-46.5158, 31.9979, 13.4539>, <-45.9973, 31.9078, 14.133> }
					triangle { <-45.676, 32.1892, 12.3392>, <-45.9973, 31.9078, 14.133>, <-46.5158, 31.9979, 13.4539> }
					triangle { <-46.5158, 31.9979, 13.4539>, <-47.2505, 31.69, 14.758>, <-45.9973, 31.9078, 14.133> }
					triangle { <-46.5158, 31.9979, 13.4539>, <-45.9973, 31.9078, 14.133>, <-47.2505, 31.69, 14.758> }
					triangle { <-47.2505, 31.69, 14.758>, <-45.5903, 31.7787, 15.872>, <-45.9973, 31.9078, 14.133> }
					triangle { <-47.2505, 31.69, 14.758>, <-45.9973, 31.9078, 14.133>, <-45.5903, 31.7787, 15.872> }
					triangle { <-47.2505, 31.69, 14.758>, <-47.678, 33.4369, 16.5811>, <-45.5903, 31.7787, 15.872> }
					triangle { <-47.2505, 31.69, 14.758>, <-45.5903, 31.7787, 15.872>, <-47.678, 33.4369, 16.5811> }
					triangle { <-39.6115, 30.3821, 15.2736>, <-38.219, 27.9766, 16.2789>, <-36.468, 29.7986, 15.02339> }
					triangle { <-39.6115, 30.3821, 15.2736>, <-36.468, 29.7986, 15.02339>, <-38.219, 27.9766, 16.2789> }
					triangle { <-39.6115, 30.3821, 15.2736>, <-40.0037, 27.797, 18.1166>, <-38.219, 27.9766, 16.2789> }
					triangle { <-39.6115, 30.3821, 15.2736>, <-38.219, 27.9766, 16.2789>, <-40.0037, 27.797, 18.1166> }
					triangle { <-43.04903, 28.7567, 18.2883>, <-42.9244, 29.03059, 19.6015>, <-40.0037, 27.797, 18.1166> }
					triangle { <-43.04903, 28.7567, 18.2883>, <-40.0037, 27.797, 18.1166>, <-42.9244, 29.03059, 19.6015> }
					triangle { <-40.0037, 27.797, 18.1166>, <-42.7807, 29.9442, 16.762>, <-43.04903, 28.7567, 18.2883> }
					triangle { <-40.0037, 27.797, 18.1166>, <-43.04903, 28.7567, 18.2883>, <-42.7807, 29.9442, 16.762> }
					triangle { <-39.6115, 30.3821, 15.2736>, <-42.7807, 29.9442, 16.762>, <-40.0037, 27.797, 18.1166> }
					triangle { <-39.6115, 30.3821, 15.2736>, <-40.0037, 27.797, 18.1166>, <-42.7807, 29.9442, 16.762> }
					triangle { <-42.519, 31.3218, 15.6759>, <-42.7807, 29.9442, 16.762>, <-39.6115, 30.3821, 15.2736> }
					triangle { <-42.519, 31.3218, 15.6759>, <-39.6115, 30.3821, 15.2736>, <-42.7807, 29.9442, 16.762> }
					triangle { <-42.519, 31.3218, 15.6759>, <-45.5903, 31.7787, 15.872>, <-42.7807, 29.9442, 16.762> }
					triangle { <-42.519, 31.3218, 15.6759>, <-42.7807, 29.9442, 16.762>, <-45.5903, 31.7787, 15.872> }
					triangle { <-42.7807, 29.9442, 16.762>, <-45.6742, 29.5095, 18.6107>, <-43.04903, 28.7567, 18.2883> }
					triangle { <-42.7807, 29.9442, 16.762>, <-43.04903, 28.7567, 18.2883>, <-45.6742, 29.5095, 18.6107> }
					triangle { <-45.9637, 30.7077, 17.2088>, <-45.6742, 29.5095, 18.6107>, <-42.7807, 29.9442, 16.762> }
					triangle { <-45.9637, 30.7077, 17.2088>, <-42.7807, 29.9442, 16.762>, <-45.6742, 29.5095, 18.6107> }
					triangle { <-42.7807, 29.9442, 16.762>, <-45.5903, 31.7787, 15.872>, <-45.9637, 30.7077, 17.2088> }
					triangle { <-42.7807, 29.9442, 16.762>, <-45.9637, 30.7077, 17.2088>, <-45.5903, 31.7787, 15.872> }
					triangle { <-43.04903, 28.7567, 18.2883>, <-45.6742, 29.5095, 18.6107>, <-42.9244, 29.03059, 19.6015> }
					triangle { <-43.04903, 28.7567, 18.2883>, <-42.9244, 29.03059, 19.6015>, <-45.6742, 29.5095, 18.6107> }
					triangle { <-45.9637, 30.7077, 17.2088>, <-46.5146, 30.1826, 17.7023>, <-45.6742, 29.5095, 18.6107> }
					triangle { <-45.9637, 30.7077, 17.2088>, <-45.6742, 29.5095, 18.6107>, <-46.5146, 30.1826, 17.7023> }
					triangle { <-45.9637, 30.7077, 17.2088>, <-47.25, 30.912, 16.5788>, <-46.5146, 30.1826, 17.7023> }
					triangle { <-45.9637, 30.7077, 17.2088>, <-46.5146, 30.1826, 17.7023>, <-47.25, 30.912, 16.5788> }
					triangle { <-45.9637, 30.7077, 17.2088>, <-45.5903, 31.7787, 15.872>, <-47.25, 30.912, 16.5788> }
					triangle { <-45.9637, 30.7077, 17.2088>, <-47.25, 30.912, 16.5788>, <-45.5903, 31.7787, 15.872> }
					triangle { <-45.5903, 31.7787, 15.872>, <-47.678, 33.4369, 16.5811>, <-47.25, 30.912, 16.5788> }
					triangle { <-45.5903, 31.7787, 15.872>, <-47.25, 30.912, 16.5788>, <-47.678, 33.4369, 16.5811> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <-20.8075, 22.2012, 5.85>, <-22.8145, 21.7375, 6.5402>, 0.4231 }
			cylinder { <-22.8145, 21.7375, 6.5402>, <-24.8214, 21.2737, 7.2304>, 0.4231 }
			cylinder { <-24.8214, 21.2737, 7.2304>, <-26.8284, 20.81, 7.9205>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-26.8284, 20.81, 7.9205>, <-28.6191, 20.2689, 6.8161>, 0.4231 }
			cylinder { <-28.6191, 20.2689, 6.8161>, <-30.4099, 19.7279, 5.7116>, 0.4231 }
			cylinder { <-30.4099, 19.7279, 5.7116>, <-32.2006, 19.1868, 4.6071>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-32.2006, 19.1868, 4.6071>, <-36.1612, 17.272, 3.08485>, 0.4231 }
				cylinder { <-36.1612, 17.272, 3.08485>, <-40.00784, 14.7166, 2.4982>, 0.4231 }
				cylinder { <-40.00784, 14.7166, 2.4982>, <-43.5098, 11.6738, 2.8825>, 0.4231 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-43.5098, 11.6738, 2.8825>, <-46.1149, 12.6976, 3.2391>, <-46.0823, 9.7591, 2.9221> }
					triangle { <-43.5098, 11.6738, 2.8825>, <-46.0823, 9.7591, 2.9221>, <-46.1149, 12.6976, 3.2391> }
					triangle { <-46.1149, 12.6976, 3.2391>, <-48.05381, 12.2783, 4.9029>, <-46.0823, 9.7591, 2.9221> }
					triangle { <-46.1149, 12.6976, 3.2391>, <-46.0823, 9.7591, 2.9221>, <-48.05381, 12.2783, 4.9029> }
					triangle { <-48.05381, 12.2783, 4.9029>, <-50.6009, 10.324, 6.191>, <-50.5957, 10.2988, 4.7073> }
					triangle { <-48.05381, 12.2783, 4.9029>, <-50.5957, 10.2988, 4.7073>, <-50.6009, 10.324, 6.191> }
					triangle { <-50.5957, 10.2988, 4.7073>, <-49.649, 9.2227, 3.4812>, <-48.05381, 12.2783, 4.9029> }
					triangle { <-50.5957, 10.2988, 4.7073>, <-48.05381, 12.2783, 4.9029>, <-49.649, 9.2227, 3.4812> }
					triangle { <-48.05381, 12.2783, 4.9029>, <-49.649, 9.2227, 3.4812>, <-46.0823, 9.7591, 2.9221> }
					triangle { <-48.05381, 12.2783, 4.9029>, <-46.0823, 9.7591, 2.9221>, <-49.649, 9.2227, 3.4812> }
					triangle { <-46.0823, 9.7591, 2.9221>, <-49.649, 9.2227, 3.4812>, <-48.3418, 7.6891, 3.2509> }
					triangle { <-46.0823, 9.7591, 2.9221>, <-48.3418, 7.6891, 3.2509>, <-49.649, 9.2227, 3.4812> }
					triangle { <-49.649, 9.2227, 3.4812>, <-50.889, 5.9032, 3.2069>, <-48.3418, 7.6891, 3.2509> }
					triangle { <-49.649, 9.2227, 3.4812>, <-48.3418, 7.6891, 3.2509>, <-50.889, 5.9032, 3.2069> }
					triangle { <-50.5957, 10.2988, 4.7073>, <-52.6069, 8.4445, 5.00888>, <-49.649, 9.2227, 3.4812> }
					triangle { <-50.5957, 10.2988, 4.7073>, <-49.649, 9.2227, 3.4812>, <-52.6069, 8.4445, 5.00888> }
					triangle { <-49.649, 9.2227, 3.4812>, <-52.6069, 8.4445, 5.00888>, <-52.06056, 7.01297, 3.9831> }
					triangle { <-49.649, 9.2227, 3.4812>, <-52.06056, 7.01297, 3.9831>, <-52.6069, 8.4445, 5.00888> }
					triangle { <-52.06056, 7.01297, 3.9831>, <-50.889, 5.9032, 3.2069>, <-49.649, 9.2227, 3.4812> }
					triangle { <-52.06056, 7.01297, 3.9831>, <-49.649, 9.2227, 3.4812>, <-50.889, 5.9032, 3.2069> }
					triangle { <-50.6009, 10.324, 6.191>, <-52.6069, 8.4445, 5.00888>, <-50.5957, 10.2988, 4.7073> }
					triangle { <-50.6009, 10.324, 6.191>, <-50.5957, 10.2988, 4.7073>, <-52.6069, 8.4445, 5.00888> }
					triangle { <-52.6069, 8.4445, 5.00888>, <-52.8285, 7.2608, 4.2779>, <-52.06056, 7.01297, 3.9831> }
					triangle { <-52.6069, 8.4445, 5.00888>, <-52.06056, 7.01297, 3.9831>, <-52.8285, 7.2608, 4.2779> }
					triangle { <-52.8285, 7.2608, 4.2779>, <-52.8791, 6.02746, 3.3771>, <-52.06056, 7.01297, 3.9831> }
					triangle { <-52.8285, 7.2608, 4.2779>, <-52.06056, 7.01297, 3.9831>, <-52.8791, 6.02746, 3.3771> }
					triangle { <-52.8791, 6.02746, 3.3771>, <-50.889, 5.9032, 3.2069>, <-52.06056, 7.01297, 3.9831> }
					triangle { <-52.8791, 6.02746, 3.3771>, <-52.06056, 7.01297, 3.9831>, <-50.889, 5.9032, 3.2069> }
					triangle { <-52.8791, 6.02746, 3.3771>, <-52.2168, 3.6813, 4.1613>, <-50.889, 5.9032, 3.2069> }
					triangle { <-52.8791, 6.02746, 3.3771>, <-50.889, 5.9032, 3.2069>, <-52.2168, 3.6813, 4.1613> }
					triangle { <-46.0823, 9.7591, 2.9221>, <-44.6173, 10.629, 0.5068>, <-43.5098, 11.6738, 2.8825> }
					triangle { <-46.0823, 9.7591, 2.9221>, <-43.5098, 11.6738, 2.8825>, <-44.6173, 10.629, 0.5068> }
					triangle { <-46.0823, 9.7591, 2.9221>, <-45.3193, 8.4332, -0.6245>, <-44.6173, 10.629, 0.5068> }
					triangle { <-46.0823, 9.7591, 2.9221>, <-44.6173, 10.629, 0.5068>, <-45.3193, 8.4332, -0.6245> }
					triangle { <-47.8072, 6.4697, -0.2005>, <-47.04666, 5.3917, -0.4731>, <-45.3193, 8.4332, -0.6245> }
					triangle { <-47.8072, 6.4697, -0.2005>, <-45.3193, 8.4332, -0.6245>, <-47.04666, 5.3917, -0.4731> }
					triangle { <-45.3193, 8.4332, -0.6245>, <-48.1855, 7.2919, 1.5293>, <-47.8072, 6.4697, -0.2005> }
					triangle { <-45.3193, 8.4332, -0.6245>, <-47.8072, 6.4697, -0.2005>, <-48.1855, 7.2919, 1.5293> }
					triangle { <-46.0823, 9.7591, 2.9221>, <-48.1855, 7.2919, 1.5293>, <-45.3193, 8.4332, -0.6245> }
					triangle { <-46.0823, 9.7591, 2.9221>, <-45.3193, 8.4332, -0.6245>, <-48.1855, 7.2919, 1.5293> }
					triangle { <-48.3418, 7.6891, 3.2509>, <-48.1855, 7.2919, 1.5293>, <-46.0823, 9.7591, 2.9221> }
					triangle { <-48.3418, 7.6891, 3.2509>, <-46.0823, 9.7591, 2.9221>, <-48.1855, 7.2919, 1.5293> }
					triangle { <-48.3418, 7.6891, 3.2509>, <-50.889, 5.9032, 3.2069>, <-48.1855, 7.2919, 1.5293> }
					triangle { <-48.3418, 7.6891, 3.2509>, <-48.1855, 7.2919, 1.5293>, <-50.889, 5.9032, 3.2069> }
					triangle { <-48.1855, 7.2919, 1.5293>, <-49.876, 4.6722, 0.02647>, <-47.8072, 6.4697, -0.2005> }
					triangle { <-48.1855, 7.2919, 1.5293>, <-47.8072, 6.4697, -0.2005>, <-49.876, 4.6722, 0.02647> }
					triangle { <-50.6815, 5.1308, 1.6468>, <-49.876, 4.6722, 0.02647>, <-48.1855, 7.2919, 1.5293> }
					triangle { <-50.6815, 5.1308, 1.6468>, <-48.1855, 7.2919, 1.5293>, <-49.876, 4.6722, 0.02647> }
					triangle { <-48.1855, 7.2919, 1.5293>, <-50.889, 5.9032, 3.2069>, <-50.6815, 5.1308, 1.6468> }
					triangle { <-48.1855, 7.2919, 1.5293>, <-50.6815, 5.1308, 1.6468>, <-50.889, 5.9032, 3.2069> }
					triangle { <-47.8072, 6.4697, -0.2005>, <-49.876, 4.6722, 0.02647>, <-47.04666, 5.3917, -0.4731> }
					triangle { <-47.8072, 6.4697, -0.2005>, <-47.04666, 5.3917, -0.4731>, <-49.876, 4.6722, 0.02647> }
					triangle { <-50.6815, 5.1308, 1.6468>, <-50.9785, 4.7054, 0.9027>, <-49.876, 4.6722, 0.02647> }
					triangle { <-50.6815, 5.1308, 1.6468>, <-49.876, 4.6722, 0.02647>, <-50.9785, 4.7054, 0.9027> }
					triangle { <-50.6815, 5.1308, 1.6468>, <-52.08634, 4.9322, 1.9306>, <-50.9785, 4.7054, 0.9027> }
					triangle { <-50.6815, 5.1308, 1.6468>, <-50.9785, 4.7054, 0.9027>, <-52.08634, 4.9322, 1.9306> }
					triangle { <-50.6815, 5.1308, 1.6468>, <-50.889, 5.9032, 3.2069>, <-52.08634, 4.9322, 1.9306> }
					triangle { <-50.6815, 5.1308, 1.6468>, <-52.08634, 4.9322, 1.9306>, <-50.889, 5.9032, 3.2069> }
					triangle { <-50.889, 5.9032, 3.2069>, <-52.2168, 3.6813, 4.1613>, <-52.08634, 4.9322, 1.9306> }
					triangle { <-50.889, 5.9032, 3.2069>, <-52.08634, 4.9322, 1.9306>, <-52.2168, 3.6813, 4.1613> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-43.5098, 11.6738, 2.8825>, <-43.9846, 9.9274, 0.7176>, <-45.7095, 9.3459, 3.0463> }
					triangle { <-43.5098, 11.6738, 2.8825>, <-45.7095, 9.3459, 3.0463>, <-43.9846, 9.9274, 0.7176> }
					triangle { <-43.9846, 9.9274, 0.7176>, <-46.04532, 9.2591, -0.7002>, <-45.7095, 9.3459, 3.0463> }
					triangle { <-43.9846, 9.9274, 0.7176>, <-45.7095, 9.3459, 3.0463>, <-46.04532, 9.2591, -0.7002> }
					triangle { <-46.04532, 9.2591, -0.7002>, <-49.08823, 7.6624, -1.09791>, <-48.1216, 6.8113, -0.3606> }
					triangle { <-46.04532, 9.2591, -0.7002>, <-48.1216, 6.8113, -0.3606>, <-49.08823, 7.6624, -1.09791> }
					triangle { <-48.1216, 6.8113, -0.3606>, <-47.6901, 6.7145, 1.4728>, <-46.04532, 9.2591, -0.7002> }
					triangle { <-48.1216, 6.8113, -0.3606>, <-46.04532, 9.2591, -0.7002>, <-47.6901, 6.7145, 1.4728> }
					triangle { <-46.04532, 9.2591, -0.7002>, <-47.6901, 6.7145, 1.4728>, <-45.7095, 9.3459, 3.0463> }
					triangle { <-46.04532, 9.2591, -0.7002>, <-45.7095, 9.3459, 3.0463>, <-47.6901, 6.7145, 1.4728> }
					triangle { <-45.7095, 9.3459, 3.0463>, <-47.6901, 6.7145, 1.4728>, <-48.09332, 7.4136, 3.3337> }
					triangle { <-45.7095, 9.3459, 3.0463>, <-48.09332, 7.4136, 3.3337>, <-47.6901, 6.7145, 1.4728> }
					triangle { <-47.6901, 6.7145, 1.4728>, <-50.1436, 5.07662, 3.4552>, <-48.09332, 7.4136, 3.3337> }
					triangle { <-47.6901, 6.7145, 1.4728>, <-48.09332, 7.4136, 3.3337>, <-50.1436, 5.07662, 3.4552> }
					triangle { <-48.1216, 6.8113, -0.3606>, <-50.2571, 5.09481, -0.1004>, <-47.6901, 6.7145, 1.4728> }
					triangle { <-48.1216, 6.8113, -0.3606>, <-47.6901, 6.7145, 1.4728>, <-50.2571, 5.09481, -0.1004> }
					triangle { <-47.6901, 6.7145, 1.4728>, <-50.2571, 5.09481, -0.1004>, <-50.3343, 4.7388, 1.7071> }
					triangle { <-47.6901, 6.7145, 1.4728>, <-50.3343, 4.7388, 1.7071>, <-50.2571, 5.09481, -0.1004> }
					triangle { <-50.3343, 4.7388, 1.7071>, <-50.1436, 5.07662, 3.4552>, <-47.6901, 6.7145, 1.4728> }
					triangle { <-50.3343, 4.7388, 1.7071>, <-47.6901, 6.7145, 1.4728>, <-50.1436, 5.07662, 3.4552> }
					triangle { <-49.08823, 7.6624, -1.09791>, <-50.2571, 5.09481, -0.1004>, <-48.1216, 6.8113, -0.3606> }
					triangle { <-49.08823, 7.6624, -1.09791>, <-48.1216, 6.8113, -0.3606>, <-50.2571, 5.09481, -0.1004> }
					triangle { <-50.2571, 5.09481, -0.1004>, <-50.6355, 4.3251, 1.017>, <-50.3343, 4.7388, 1.7071> }
					triangle { <-50.2571, 5.09481, -0.1004>, <-50.3343, 4.7388, 1.7071>, <-50.6355, 4.3251, 1.017> }
					triangle { <-50.6355, 4.3251, 1.017>, <-50.8744, 3.5884, 2.3343>, <-50.3343, 4.7388, 1.7071> }
					triangle { <-50.6355, 4.3251, 1.017>, <-50.3343, 4.7388, 1.7071>, <-50.8744, 3.5884, 2.3343> }
					triangle { <-50.8744, 3.5884, 2.3343>, <-50.1436, 5.07662, 3.4552>, <-50.3343, 4.7388, 1.7071> }
					triangle { <-50.8744, 3.5884, 2.3343>, <-50.3343, 4.7388, 1.7071>, <-50.1436, 5.07662, 3.4552> }
					triangle { <-50.8744, 3.5884, 2.3343>, <-52.7138, 4.2323, 3.9957>, <-50.1436, 5.07662, 3.4552> }
					triangle { <-50.8744, 3.5884, 2.3343>, <-50.1436, 5.07662, 3.4552>, <-52.7138, 4.2323, 3.9957> }
					triangle { <-45.7095, 9.3459, 3.0463>, <-43.02034, 9.2662, 4.2701>, <-43.5098, 11.6738, 2.8825> }
					triangle { <-45.7095, 9.3459, 3.0463>, <-43.5098, 11.6738, 2.8825>, <-43.02034, 9.2662, 4.2701> }
					triangle { <-45.7095, 9.3459, 3.0463>, <-43.9733, 7.7327, 6.09631>, <-43.02034, 9.2662, 4.2701> }
					triangle { <-45.7095, 9.3459, 3.0463>, <-43.02034, 9.2662, 4.2701>, <-43.9733, 7.7327, 6.09631> }
					triangle { <-46.4298, 5.6865, 6.1506>, <-46.6958, 5.9867, 7.4367>, <-43.9733, 7.7327, 6.09631> }
					triangle { <-46.4298, 5.6865, 6.1506>, <-43.9733, 7.7327, 6.09631>, <-46.6958, 5.9867, 7.4367> }
					triangle { <-43.9733, 7.7327, 6.09631>, <-47.1627, 6.4937, 4.5311>, <-46.4298, 5.6865, 6.1506> }
					triangle { <-43.9733, 7.7327, 6.09631>, <-46.4298, 5.6865, 6.1506>, <-47.1627, 6.4937, 4.5311> }
					triangle { <-45.7095, 9.3459, 3.0463>, <-47.1627, 6.4937, 4.5311>, <-43.9733, 7.7327, 6.09631> }
					triangle { <-45.7095, 9.3459, 3.0463>, <-43.9733, 7.7327, 6.09631>, <-47.1627, 6.4937, 4.5311> }
					triangle { <-48.09332, 7.4136, 3.3337>, <-47.1627, 6.4937, 4.5311>, <-45.7095, 9.3459, 3.0463> }
					triangle { <-48.09332, 7.4136, 3.3337>, <-45.7095, 9.3459, 3.0463>, <-47.1627, 6.4937, 4.5311> }
					triangle { <-48.09332, 7.4136, 3.3337>, <-50.1436, 5.07662, 3.4552>, <-47.1627, 6.4937, 4.5311> }
					triangle { <-48.09332, 7.4136, 3.3337>, <-47.1627, 6.4937, 4.5311>, <-50.1436, 5.07662, 3.4552> }
					triangle { <-47.1627, 6.4937, 4.5311>, <-48.4986, 3.889, 6.3776>, <-46.4298, 5.6865, 6.1506> }
					triangle { <-47.1627, 6.4937, 4.5311>, <-46.4298, 5.6865, 6.1506>, <-48.4986, 3.889, 6.3776> }
					triangle { <-49.5502, 4.2363, 4.8748>, <-48.4986, 3.889, 6.3776>, <-47.1627, 6.4937, 4.5311> }
					triangle { <-49.5502, 4.2363, 4.8748>, <-47.1627, 6.4937, 4.5311>, <-48.4986, 3.889, 6.3776> }
					triangle { <-47.1627, 6.4937, 4.5311>, <-50.1436, 5.07662, 3.4552>, <-49.5502, 4.2363, 4.8748> }
					triangle { <-47.1627, 6.4937, 4.5311>, <-49.5502, 4.2363, 4.8748>, <-50.1436, 5.07662, 3.4552> }
					triangle { <-46.4298, 5.6865, 6.1506>, <-48.4986, 3.889, 6.3776>, <-46.6958, 5.9867, 7.4367> }
					triangle { <-46.4298, 5.6865, 6.1506>, <-46.6958, 5.9867, 7.4367>, <-48.4986, 3.889, 6.3776> }
					triangle { <-49.5502, 4.2363, 4.8748>, <-49.4442, 3.5083, 5.4054>, <-48.4986, 3.889, 6.3776> }
					triangle { <-49.5502, 4.2363, 4.8748>, <-48.4986, 3.889, 6.3776>, <-49.4442, 3.5083, 5.4054> }
					triangle { <-49.5502, 4.2363, 4.8748>, <-50.3638, 3.2383, 4.2151>, <-49.4442, 3.5083, 5.4054> }
					triangle { <-49.5502, 4.2363, 4.8748>, <-49.4442, 3.5083, 5.4054>, <-50.3638, 3.2383, 4.2151> }
					triangle { <-49.5502, 4.2363, 4.8748>, <-50.1436, 5.07662, 3.4552>, <-50.3638, 3.2383, 4.2151> }
					triangle { <-49.5502, 4.2363, 4.8748>, <-50.3638, 3.2383, 4.2151>, <-50.1436, 5.07662, 3.4552> }
					triangle { <-50.1436, 5.07662, 3.4552>, <-52.7138, 4.2323, 3.9957>, <-50.3638, 3.2383, 4.2151> }
					triangle { <-50.1436, 5.07662, 3.4552>, <-50.3638, 3.2383, 4.2151>, <-52.7138, 4.2323, 3.9957> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-43.5098, 11.6738, 2.8825>, <-43.4319, 9.8347, 5.02108>, <-45.9395, 9.6635, 3.4658> }
					triangle { <-43.5098, 11.6738, 2.8825>, <-45.9395, 9.6635, 3.4658>, <-43.4319, 9.8347, 5.02108> }
					triangle { <-43.4319, 9.8347, 5.02108>, <-43.6602, 7.2668, 5.2596>, <-45.9395, 9.6635, 3.4658> }
					triangle { <-43.4319, 9.8347, 5.02108>, <-45.9395, 9.6635, 3.4658>, <-43.6602, 7.2668, 5.2596> }
					triangle { <-43.6602, 7.2668, 5.2596>, <-45.5187, 4.3497, 5.2008>, <-46.2434, 5.4403, 5.8991> }
					triangle { <-43.6602, 7.2668, 5.2596>, <-46.2434, 5.4403, 5.8991>, <-45.5187, 4.3497, 5.2008> }
					triangle { <-46.2434, 5.4403, 5.8991>, <-47.3611, 6.8125, 5.2471>, <-43.6602, 7.2668, 5.2596> }
					triangle { <-46.2434, 5.4403, 5.8991>, <-43.6602, 7.2668, 5.2596>, <-47.3611, 6.8125, 5.2471> }
					triangle { <-43.6602, 7.2668, 5.2596>, <-47.3611, 6.8125, 5.2471>, <-45.9395, 9.6635, 3.4658> }
					triangle { <-43.6602, 7.2668, 5.2596>, <-45.9395, 9.6635, 3.4658>, <-47.3611, 6.8125, 5.2471> }
					triangle { <-45.9395, 9.6635, 3.4658>, <-47.3611, 6.8125, 5.2471>, <-48.2466, 7.6253, 3.6133> }
					triangle { <-45.9395, 9.6635, 3.4658>, <-48.2466, 7.6253, 3.6133>, <-47.3611, 6.8125, 5.2471> }
					triangle { <-47.3611, 6.8125, 5.2471>, <-50.6035, 5.7118, 4.2943>, <-48.2466, 7.6253, 3.6133> }
					triangle { <-47.3611, 6.8125, 5.2471>, <-48.2466, 7.6253, 3.6133>, <-50.6035, 5.7118, 4.2943> }
					triangle { <-46.2434, 5.4403, 5.8991>, <-48.3023, 3.6178, 6.01946>, <-47.3611, 6.8125, 5.2471> }
					triangle { <-46.2434, 5.4403, 5.8991>, <-47.3611, 6.8125, 5.2471>, <-48.3023, 3.6178, 6.01946> }
					triangle { <-47.3611, 6.8125, 5.2471>, <-48.3023, 3.6178, 6.01946>, <-49.752, 4.5262, 5.3315> }
					triangle { <-47.3611, 6.8125, 5.2471>, <-49.752, 4.5262, 5.3315>, <-48.3023, 3.6178, 6.01946> }
					triangle { <-49.752, 4.5262, 5.3315>, <-50.6035, 5.7118, 4.2943>, <-47.3611, 6.8125, 5.2471> }
					triangle { <-49.752, 4.5262, 5.3315>, <-47.3611, 6.8125, 5.2471>, <-50.6035, 5.7118, 4.2943> }
					triangle { <-45.5187, 4.3497, 5.2008>, <-48.3023, 3.6178, 6.01946>, <-46.2434, 5.4403, 5.8991> }
					triangle { <-45.5187, 4.3497, 5.2008>, <-46.2434, 5.4403, 5.8991>, <-48.3023, 3.6178, 6.01946> }
					triangle { <-48.3023, 3.6178, 6.01946>, <-49.6821, 3.8369, 5.8394>, <-49.752, 4.5262, 5.3315> }
					triangle { <-48.3023, 3.6178, 6.01946>, <-49.752, 4.5262, 5.3315>, <-49.6821, 3.8369, 5.8394> }
					triangle { <-49.6821, 3.8369, 5.8394>, <-51.1228, 4.2867, 5.5998>, <-49.752, 4.5262, 5.3315> }
					triangle { <-49.6821, 3.8369, 5.8394>, <-49.752, 4.5262, 5.3315>, <-51.1228, 4.2867, 5.5998> }
					triangle { <-51.1228, 4.2867, 5.5998>, <-50.6035, 5.7118, 4.2943>, <-49.752, 4.5262, 5.3315> }
					triangle { <-51.1228, 4.2867, 5.5998>, <-49.752, 4.5262, 5.3315>, <-50.6035, 5.7118, 4.2943> }
					triangle { <-51.1228, 4.2867, 5.5998>, <-52.4072, 3.8088, 3.4364>, <-50.6035, 5.7118, 4.2943> }
					triangle { <-51.1228, 4.2867, 5.5998>, <-50.6035, 5.7118, 4.2943>, <-52.4072, 3.8088, 3.4364> }
					triangle { <-45.9395, 9.6635, 3.4658>, <-45.8725, 12.5353, 4.162>, <-43.5098, 11.6738, 2.8825> }
					triangle { <-45.9395, 9.6635, 3.4658>, <-43.5098, 11.6738, 2.8825>, <-45.8725, 12.5353, 4.162> }
					triangle { <-45.9395, 9.6635, 3.4658>, <-48.4279, 12.5838, 3.9121>, <-45.8725, 12.5353, 4.162> }
					triangle { <-45.9395, 9.6635, 3.4658>, <-45.8725, 12.5353, 4.162>, <-48.4279, 12.5838, 3.9121> }
					triangle { <-50.6841, 10.3398, 4.2259>, <-51.415, 10.8876, 3.2356>, <-48.4279, 12.5838, 3.9121> }
					triangle { <-50.6841, 10.3398, 4.2259>, <-48.4279, 12.5838, 3.9121>, <-51.415, 10.8876, 3.2356> }
					triangle { <-48.4279, 12.5838, 3.9121>, <-49.3312, 8.9368, 4.113>, <-50.6841, 10.3398, 4.2259> }
					triangle { <-48.4279, 12.5838, 3.9121>, <-50.6841, 10.3398, 4.2259>, <-49.3312, 8.9368, 4.113> }
					triangle { <-45.9395, 9.6635, 3.4658>, <-49.3312, 8.9368, 4.113>, <-48.4279, 12.5838, 3.9121> }
					triangle { <-45.9395, 9.6635, 3.4658>, <-48.4279, 12.5838, 3.9121>, <-49.3312, 8.9368, 4.113> }
					triangle { <-48.2466, 7.6253, 3.6133>, <-49.3312, 8.9368, 4.113>, <-45.9395, 9.6635, 3.4658> }
					triangle { <-48.2466, 7.6253, 3.6133>, <-45.9395, 9.6635, 3.4658>, <-49.3312, 8.9368, 4.113> }
					triangle { <-48.2466, 7.6253, 3.6133>, <-50.6035, 5.7118, 4.2943>, <-49.3312, 8.9368, 4.113> }
					triangle { <-48.2466, 7.6253, 3.6133>, <-49.3312, 8.9368, 4.113>, <-50.6035, 5.7118, 4.2943> }
					triangle { <-49.3312, 8.9368, 4.113>, <-52.7529, 8.5423, 4.4529>, <-50.6841, 10.3398, 4.2259> }
					triangle { <-49.3312, 8.9368, 4.113>, <-50.6841, 10.3398, 4.2259>, <-52.7529, 8.5423, 4.4529> }
					triangle { <-51.8955, 6.8841, 4.4668>, <-52.7529, 8.5423, 4.4529>, <-49.3312, 8.9368, 4.113> }
					triangle { <-51.8955, 6.8841, 4.4668>, <-49.3312, 8.9368, 4.113>, <-52.7529, 8.5423, 4.4529> }
					triangle { <-49.3312, 8.9368, 4.113>, <-50.6035, 5.7118, 4.2943>, <-51.8955, 6.8841, 4.4668> }
					triangle { <-49.3312, 8.9368, 4.113>, <-51.8955, 6.8841, 4.4668>, <-50.6035, 5.7118, 4.2943> }
					triangle { <-50.6841, 10.3398, 4.2259>, <-52.7529, 8.5423, 4.4529>, <-51.415, 10.8876, 3.2356> }
					triangle { <-50.6841, 10.3398, 4.2259>, <-51.415, 10.8876, 3.2356>, <-52.7529, 8.5423, 4.4529> }
					triangle { <-51.8955, 6.8841, 4.4668>, <-52.6971, 7.1728, 4.7782>, <-52.7529, 8.5423, 4.4529> }
					triangle { <-51.8955, 6.8841, 4.4668>, <-52.7529, 8.5423, 4.4529>, <-52.6971, 7.1728, 4.7782> }
					triangle { <-51.8955, 6.8841, 4.4668>, <-52.4149, 5.7164, 5.145>, <-52.6971, 7.1728, 4.7782> }
					triangle { <-51.8955, 6.8841, 4.4668>, <-52.6971, 7.1728, 4.7782>, <-52.4149, 5.7164, 5.145> }
					triangle { <-51.8955, 6.8841, 4.4668>, <-50.6035, 5.7118, 4.2943>, <-52.4149, 5.7164, 5.145> }
					triangle { <-51.8955, 6.8841, 4.4668>, <-52.4149, 5.7164, 5.145>, <-50.6035, 5.7118, 4.2943> }
					triangle { <-50.6035, 5.7118, 4.2943>, <-52.4072, 3.8088, 3.4364>, <-52.4149, 5.7164, 5.145> }
					triangle { <-50.6035, 5.7118, 4.2943>, <-52.4149, 5.7164, 5.145>, <-52.4072, 3.8088, 3.4364> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <-6.2789, 22.6622, 1.004623>, <-7.7587, 25.3676, 1.3547>, 0.4231 }
			cylinder { <-7.7587, 25.3676, 1.3547>, <-8.3648, 28.4109, 1.3972>, 0.4231 }
			cylinder { <-8.3648, 28.4109, 1.3972>, <-8.03604, 31.4851, 1.1279>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-8.03604, 31.4851, 1.1279>, <-7.8058, 33.6371, 0.9394>, 0.4231 }
			cylinder { <-7.8058, 33.6371, 0.9394>, <-7.5757, 35.789, 0.7508>, 0.4231 }
			cylinder { <-7.5757, 35.789, 0.7508>, <-7.3456, 37.9409, 0.5623>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-7.3456, 37.9409, 0.5623>, <-8.6925, 39.4476, -0.2345>, 0.4231 }
			cylinder { <-8.6925, 39.4476, -0.2345>, <-10.03944, 40.9543, -1.03143>, 0.4231 }
			cylinder { <-10.03944, 40.9543, -1.03143>, <-11.3863, 42.461, -1.8283>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-11.3863, 42.461, -1.8283>, <-13.9247, 46.2808, -2.6258>, 0.4231 }
				cylinder { <-13.9247, 46.2808, -2.6258>, <-15.9631, 50.4628, -2.4653>, 0.4231 }
				cylinder { <-15.9631, 50.4628, -2.4653>, <-17.3794, 54.7565, -1.3565>, 0.4231 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-17.3794, 54.7565, -1.3565>, <-16.741, 56.8562, -3.1301>, <-18.4707, 57.7375, -0.9013> }
					triangle { <-17.3794, 54.7565, -1.3565>, <-18.4707, 57.7375, -0.9013>, <-16.741, 56.8562, -3.1301> }
					triangle { <-16.741, 56.8562, -3.1301>, <-15.6413, 59.19, -2.9118>, <-18.4707, 57.7375, -0.9013> }
					triangle { <-16.741, 56.8562, -3.1301>, <-18.4707, 57.7375, -0.9013>, <-15.6413, 59.19, -2.9118> }
					triangle { <-15.6413, 59.19, -2.9118>, <-15.67, 62.4929, -1.884>, <-16.9665, 62.103, -2.4917> }
					triangle { <-15.6413, 59.19, -2.9118>, <-16.9665, 62.103, -2.4917>, <-15.67, 62.4929, -1.884> }
					triangle { <-16.9665, 62.103, -2.4917>, <-18.4968, 61.2874, -1.7498>, <-15.6413, 59.19, -2.9118> }
					triangle { <-16.9665, 62.103, -2.4917>, <-15.6413, 59.19, -2.9118>, <-18.4968, 61.2874, -1.7498> }
					triangle { <-15.6413, 59.19, -2.9118>, <-18.4968, 61.2874, -1.7498>, <-18.4707, 57.7375, -0.9013> }
					triangle { <-15.6413, 59.19, -2.9118>, <-18.4707, 57.7375, -0.9013>, <-18.4968, 61.2874, -1.7498> }
					triangle { <-18.4707, 57.7375, -0.9013>, <-18.4968, 61.2874, -1.7498>, <-19.3675, 60.5654, -0.06623> }
					triangle { <-18.4707, 57.7375, -0.9013>, <-19.3675, 60.5654, -0.06623>, <-18.4968, 61.2874, -1.7498> }
					triangle { <-18.4968, 61.2874, -1.7498>, <-20.4657, 63.4579, 0.2612>, <-19.3675, 60.5654, -0.06623> }
					triangle { <-18.4968, 61.2874, -1.7498>, <-19.3675, 60.5654, -0.06623>, <-20.4657, 63.4579, 0.2612> }
					triangle { <-16.9665, 62.103, -2.4917>, <-17.7628, 64.6265, -1.7351>, <-18.4968, 61.2874, -1.7498> }
					triangle { <-16.9665, 62.103, -2.4917>, <-18.4968, 61.2874, -1.7498>, <-17.7628, 64.6265, -1.7351> }
					triangle { <-18.4968, 61.2874, -1.7498>, <-17.7628, 64.6265, -1.7351>, <-19.3234, 64.3457, -0.794> }
					triangle { <-18.4968, 61.2874, -1.7498>, <-19.3234, 64.3457, -0.794>, <-17.7628, 64.6265, -1.7351> }
					triangle { <-19.3234, 64.3457, -0.794>, <-20.4657, 63.4579, 0.2612>, <-18.4968, 61.2874, -1.7498> }
					triangle { <-19.3234, 64.3457, -0.794>, <-18.4968, 61.2874, -1.7498>, <-20.4657, 63.4579, 0.2612> }
					triangle { <-15.67, 62.4929, -1.884>, <-17.7628, 64.6265, -1.7351>, <-16.9665, 62.103, -2.4917> }
					triangle { <-15.67, 62.4929, -1.884>, <-16.9665, 62.103, -2.4917>, <-17.7628, 64.6265, -1.7351> }
					triangle { <-17.7628, 64.6265, -1.7351>, <-18.9978, 65.03331, -1.1932>, <-19.3234, 64.3457, -0.794> }
					triangle { <-17.7628, 64.6265, -1.7351>, <-19.3234, 64.3457, -0.794>, <-18.9978, 65.03331, -1.1932> }
					triangle { <-18.9978, 65.03331, -1.1932>, <-20.3928, 65.2576, -0.611>, <-19.3234, 64.3457, -0.794> }
					triangle { <-18.9978, 65.03331, -1.1932>, <-19.3234, 64.3457, -0.794>, <-20.3928, 65.2576, -0.611> }
					triangle { <-20.3928, 65.2576, -0.611>, <-20.4657, 63.4579, 0.2612>, <-19.3234, 64.3457, -0.794> }
					triangle { <-20.3928, 65.2576, -0.611>, <-19.3234, 64.3457, -0.794>, <-20.4657, 63.4579, 0.2612> }
					triangle { <-20.3928, 65.2576, -0.611>, <-20.8324, 65.6622, 1.8791>, <-20.4657, 63.4579, 0.2612> }
					triangle { <-20.3928, 65.2576, -0.611>, <-20.4657, 63.4579, 0.2612>, <-20.8324, 65.6622, 1.8791> }
					triangle { <-18.4707, 57.7375, -0.9013>, <-20.02979, 55.4796, -2.000257>, <-17.3794, 54.7565, -1.3565> }
					triangle { <-18.4707, 57.7375, -0.9013>, <-17.3794, 54.7565, -1.3565>, <-20.02979, 55.4796, -2.000257> }
					triangle { <-18.4707, 57.7375, -0.9013>, <-22.1463, 56.5566, -1.02314>, <-20.02979, 55.4796, -2.000257> }
					triangle { <-18.4707, 57.7375, -0.9013>, <-20.02979, 55.4796, -2.000257>, <-22.1463, 56.5566, -1.02314> }
					triangle { <-22.9233, 59.5798, -0.3298>, <-23.642, 59.1859, 0.7394>, <-22.1463, 56.5566, -1.02314> }
					triangle { <-22.9233, 59.5798, -0.3298>, <-22.1463, 56.5566, -1.02314>, <-23.642, 59.1859, 0.7394> }
					triangle { <-22.1463, 56.5566, -1.02314>, <-21.04407, 60.102, -0.4132>, <-22.9233, 59.5798, -0.3298> }
					triangle { <-22.1463, 56.5566, -1.02314>, <-22.9233, 59.5798, -0.3298>, <-21.04407, 60.102, -0.4132> }
					triangle { <-18.4707, 57.7375, -0.9013>, <-21.04407, 60.102, -0.4132>, <-22.1463, 56.5566, -1.02314> }
					triangle { <-18.4707, 57.7375, -0.9013>, <-22.1463, 56.5566, -1.02314>, <-21.04407, 60.102, -0.4132> }
					triangle { <-19.3675, 60.5654, -0.06623>, <-21.04407, 60.102, -0.4132>, <-18.4707, 57.7375, -0.9013> }
					triangle { <-19.3675, 60.5654, -0.06623>, <-18.4707, 57.7375, -0.9013>, <-21.04407, 60.102, -0.4132> }
					triangle { <-19.3675, 60.5654, -0.06623>, <-20.4657, 63.4579, 0.2612>, <-21.04407, 60.102, -0.4132> }
					triangle { <-19.3675, 60.5654, -0.06623>, <-21.04407, 60.102, -0.4132>, <-20.4657, 63.4579, 0.2612> }
					triangle { <-21.04407, 60.102, -0.4132>, <-23.76, 62.1163, 0.3252>, <-22.9233, 59.5798, -0.3298> }
					triangle { <-21.04407, 60.102, -0.4132>, <-22.9233, 59.5798, -0.3298>, <-23.76, 62.1163, 0.3252> }
					triangle { <-22.185, 63.1182, 0.3044>, <-23.76, 62.1163, 0.3252>, <-21.04407, 60.102, -0.4132> }
					triangle { <-22.185, 63.1182, 0.3044>, <-21.04407, 60.102, -0.4132>, <-23.76, 62.1163, 0.3252> }
					triangle { <-21.04407, 60.102, -0.4132>, <-20.4657, 63.4579, 0.2612>, <-22.185, 63.1182, 0.3044> }
					triangle { <-21.04407, 60.102, -0.4132>, <-22.185, 63.1182, 0.3044>, <-20.4657, 63.4579, 0.2612> }
					triangle { <-22.9233, 59.5798, -0.3298>, <-23.76, 62.1163, 0.3252>, <-23.642, 59.1859, 0.7394> }
					triangle { <-22.9233, 59.5798, -0.3298>, <-23.642, 59.1859, 0.7394>, <-23.76, 62.1163, 0.3252> }
					triangle { <-22.185, 63.1182, 0.3044>, <-23.06046, 63.3328, 0.2024>, <-23.76, 62.1163, 0.3252> }
					triangle { <-22.185, 63.1182, 0.3044>, <-23.76, 62.1163, 0.3252>, <-23.06046, 63.3328, 0.2024> }
					triangle { <-22.185, 63.1182, 0.3044>, <-22.1339, 64.5289, -0.01289>, <-23.06046, 63.3328, 0.2024> }
					triangle { <-22.185, 63.1182, 0.3044>, <-23.06046, 63.3328, 0.2024>, <-22.1339, 64.5289, -0.01289> }
					triangle { <-22.185, 63.1182, 0.3044>, <-20.4657, 63.4579, 0.2612>, <-22.1339, 64.5289, -0.01289> }
					triangle { <-22.185, 63.1182, 0.3044>, <-22.1339, 64.5289, -0.01289>, <-20.4657, 63.4579, 0.2612> }
					triangle { <-20.4657, 63.4579, 0.2612>, <-20.8324, 65.6622, 1.8791>, <-22.1339, 64.5289, -0.01289> }
					triangle { <-20.4657, 63.4579, 0.2612>, <-22.1339, 64.5289, -0.01289>, <-20.8324, 65.6622, 1.8791> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-17.3794, 54.7565, -1.3565>, <-20.152, 55.2019, -1.08115>, <-18.5428, 57.5739, -0.3598> }
					triangle { <-17.3794, 54.7565, -1.3565>, <-18.5428, 57.5739, -0.3598>, <-20.152, 55.2019, -1.08115> }
					triangle { <-20.152, 55.2019, -1.08115>, <-21.8518, 56.9122, -2.02405>, <-18.5428, 57.5739, -0.3598> }
					triangle { <-20.152, 55.2019, -1.08115>, <-18.5428, 57.5739, -0.3598>, <-21.8518, 56.9122, -2.02405> }
					triangle { <-21.8518, 56.9122, -2.02405>, <-23.1961, 60.09433, -2.2085>, <-22.914, 59.7055, -0.8044> }
					triangle { <-21.8518, 56.9122, -2.02405>, <-22.914, 59.7055, -0.8044>, <-23.1961, 60.09433, -2.2085> }
					triangle { <-22.914, 59.7055, -0.8044>, <-21.3454, 59.8353, 0.2347>, <-21.8518, 56.9122, -2.02405> }
					triangle { <-22.914, 59.7055, -0.8044>, <-21.8518, 56.9122, -2.02405>, <-21.3454, 59.8353, 0.2347> }
					triangle { <-21.8518, 56.9122, -2.02405>, <-21.3454, 59.8353, 0.2347>, <-18.5428, 57.5739, -0.3598> }
					triangle { <-21.8518, 56.9122, -2.02405>, <-18.5428, 57.5739, -0.3598>, <-21.3454, 59.8353, 0.2347> }
					triangle { <-18.5428, 57.5739, -0.3598>, <-21.3454, 59.8353, 0.2347>, <-19.4155, 60.4563, 0.2947> }
					triangle { <-18.5428, 57.5739, -0.3598>, <-19.4155, 60.4563, 0.2947>, <-21.3454, 59.8353, 0.2347> }
					triangle { <-21.3454, 59.8353, 0.2347>, <-20.6097, 63.1308, 1.3441>, <-19.4155, 60.4563, 0.2947> }
					triangle { <-21.3454, 59.8353, 0.2347>, <-19.4155, 60.4563, 0.2947>, <-20.6097, 63.1308, 1.3441> }
					triangle { <-22.914, 59.7055, -0.8044>, <-23.6863, 62.2835, -0.2284>, <-21.3454, 59.8353, 0.2347> }
					triangle { <-22.914, 59.7055, -0.8044>, <-21.3454, 59.8353, 0.2347>, <-23.6863, 62.2835, -0.2284> }
					triangle { <-21.3454, 59.8353, 0.2347>, <-23.6863, 62.2835, -0.2284>, <-22.3035, 62.9535, 0.7909> }
					triangle { <-21.3454, 59.8353, 0.2347>, <-22.3035, 62.9535, 0.7909>, <-23.6863, 62.2835, -0.2284> }
					triangle { <-22.3035, 62.9535, 0.7909>, <-20.6097, 63.1308, 1.3441>, <-21.3454, 59.8353, 0.2347> }
					triangle { <-22.3035, 62.9535, 0.7909>, <-21.3454, 59.8353, 0.2347>, <-20.6097, 63.1308, 1.3441> }
					triangle { <-23.1961, 60.09433, -2.2085>, <-23.6863, 62.2835, -0.2284>, <-22.914, 59.7055, -0.8044> }
					triangle { <-23.1961, 60.09433, -2.2085>, <-22.914, 59.7055, -0.8044>, <-23.6863, 62.2835, -0.2284> }
					triangle { <-23.6863, 62.2835, -0.2284>, <-23.1267, 63.1823, 0.7008>, <-22.3035, 62.9535, 0.7909> }
					triangle { <-23.6863, 62.2835, -0.2284>, <-22.3035, 62.9535, 0.7909>, <-23.1267, 63.1823, 0.7008> }
					triangle { <-23.1267, 63.1823, 0.7008>, <-22.3681, 63.9969, 1.7477>, <-22.3035, 62.9535, 0.7909> }
					triangle { <-23.1267, 63.1823, 0.7008>, <-22.3035, 62.9535, 0.7909>, <-22.3681, 63.9969, 1.7477> }
					triangle { <-22.3681, 63.9969, 1.7477>, <-20.6097, 63.1308, 1.3441>, <-22.3035, 62.9535, 0.7909> }
					triangle { <-22.3681, 63.9969, 1.7477>, <-22.3035, 62.9535, 0.7909>, <-20.6097, 63.1308, 1.3441> }
					triangle { <-22.3681, 63.9969, 1.7477>, <-20.7364, 65.8803, 1.1571>, <-20.6097, 63.1308, 1.3441> }
					triangle { <-22.3681, 63.9969, 1.7477>, <-20.6097, 63.1308, 1.3441>, <-20.7364, 65.8803, 1.1571> }
					triangle { <-18.5428, 57.5739, -0.3598>, <-17.3389, 55.498, 1.3656>, <-17.3794, 54.7565, -1.3565> }
					triangle { <-18.5428, 57.5739, -0.3598>, <-17.3794, 54.7565, -1.3565>, <-17.3389, 55.498, 1.3656> }
					triangle { <-18.5428, 57.5739, -0.3598>, <-16.584, 57.3621, 2.9624>, <-17.3389, 55.498, 1.3656> }
					triangle { <-18.5428, 57.5739, -0.3598>, <-17.3389, 55.498, 1.3656>, <-16.584, 57.3621, 2.9624> }
					triangle { <-17.72, 60.2869, 3.5783>, <-16.476, 60.7666, 3.7714>, <-16.584, 57.3621, 2.9624> }
					triangle { <-17.72, 60.2869, 3.5783>, <-16.584, 57.3621, 2.9624>, <-16.476, 60.7666, 3.7714> }
					triangle { <-16.584, 57.3621, 2.9624>, <-18.7716, 60.2454, 1.9339>, <-17.72, 60.2869, 3.5783> }
					triangle { <-16.584, 57.3621, 2.9624>, <-17.72, 60.2869, 3.5783>, <-18.7716, 60.2454, 1.9339> }
					triangle { <-18.5428, 57.5739, -0.3598>, <-18.7716, 60.2454, 1.9339>, <-16.584, 57.3621, 2.9624> }
					triangle { <-18.5428, 57.5739, -0.3598>, <-16.584, 57.3621, 2.9624>, <-18.7716, 60.2454, 1.9339> }
					triangle { <-19.4155, 60.4563, 0.2947>, <-18.7716, 60.2454, 1.9339>, <-18.5428, 57.5739, -0.3598> }
					triangle { <-19.4155, 60.4563, 0.2947>, <-18.5428, 57.5739, -0.3598>, <-18.7716, 60.2454, 1.9339> }
					triangle { <-19.4155, 60.4563, 0.2947>, <-20.6097, 63.1308, 1.3441>, <-18.7716, 60.2454, 1.9339> }
					triangle { <-19.4155, 60.4563, 0.2947>, <-18.7716, 60.2454, 1.9339>, <-20.6097, 63.1308, 1.3441> }
					triangle { <-18.7716, 60.2454, 1.9339>, <-18.5566, 62.8233, 4.2333>, <-17.72, 60.2869, 3.5783> }
					triangle { <-18.7716, 60.2454, 1.9339>, <-17.72, 60.2869, 3.5783>, <-18.5566, 62.8233, 4.2333> }
					triangle { <-19.7571, 63.2563, 2.8708>, <-18.5566, 62.8233, 4.2333>, <-18.7716, 60.2454, 1.9339> }
					triangle { <-19.7571, 63.2563, 2.8708>, <-18.7716, 60.2454, 1.9339>, <-18.5566, 62.8233, 4.2333> }
					triangle { <-18.7716, 60.2454, 1.9339>, <-20.6097, 63.1308, 1.3441>, <-19.7571, 63.2563, 2.8708> }
					triangle { <-18.7716, 60.2454, 1.9339>, <-19.7571, 63.2563, 2.8708>, <-20.6097, 63.1308, 1.3441> }
					triangle { <-17.72, 60.2869, 3.5783>, <-18.5566, 62.8233, 4.2333>, <-16.476, 60.7666, 3.7714> }
					triangle { <-17.72, 60.2869, 3.5783>, <-16.476, 60.7666, 3.7714>, <-18.5566, 62.8233, 4.2333> }
					triangle { <-19.7571, 63.2563, 2.8708>, <-19.6517, 63.5479, 3.7232>, <-18.5566, 62.8233, 4.2333> }
					triangle { <-19.7571, 63.2563, 2.8708>, <-18.5566, 62.8233, 4.2333>, <-19.6517, 63.5479, 3.7232> }
					triangle { <-19.7571, 63.2563, 2.8708>, <-20.8788, 64.1537, 3.04312>, <-19.6517, 63.5479, 3.7232> }
					triangle { <-19.7571, 63.2563, 2.8708>, <-19.6517, 63.5479, 3.7232>, <-20.8788, 64.1537, 3.04312> }
					triangle { <-19.7571, 63.2563, 2.8708>, <-20.6097, 63.1308, 1.3441>, <-20.8788, 64.1537, 3.04312> }
					triangle { <-19.7571, 63.2563, 2.8708>, <-20.8788, 64.1537, 3.04312>, <-20.6097, 63.1308, 1.3441> }
					triangle { <-20.6097, 63.1308, 1.3441>, <-20.7364, 65.8803, 1.1571>, <-20.8788, 64.1537, 3.04312> }
					triangle { <-20.6097, 63.1308, 1.3441>, <-20.8788, 64.1537, 3.04312>, <-20.7364, 65.8803, 1.1571> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-17.3794, 54.7565, -1.3565>, <-16.4351, 55.8763, 1.05509>, <-18.03782, 57.7853, -0.5333> }
					triangle { <-17.3794, 54.7565, -1.3565>, <-18.03782, 57.7853, -0.5333>, <-16.4351, 55.8763, 1.05509> }
					triangle { <-16.4351, 55.8763, 1.05509>, <-17.518, 57.01525, 3.1126>, <-18.03782, 57.7853, -0.5333> }
					triangle { <-16.4351, 55.8763, 1.05509>, <-18.03782, 57.7853, -0.5333>, <-17.518, 57.01525, 3.1126> }
					triangle { <-17.518, 57.01525, 3.1126>, <-19.143, 59.665, 4.6308>, <-18.04716, 60.1353, 3.7475> }
					triangle { <-17.518, 57.01525, 3.1126>, <-18.04716, 60.1353, 3.7475>, <-19.143, 59.665, 4.6308> }
					triangle { <-18.04716, 60.1353, 3.7475>, <-18.00724, 60.5066, 1.8988>, <-17.518, 57.01525, 3.1126> }
					triangle { <-18.04716, 60.1353, 3.7475>, <-17.518, 57.01525, 3.1126>, <-18.00724, 60.5066, 1.8988> }
					triangle { <-17.518, 57.01525, 3.1126>, <-18.00724, 60.5066, 1.8988>, <-18.03782, 57.7853, -0.5333> }
					triangle { <-17.518, 57.01525, 3.1126>, <-18.03782, 57.7853, -0.5333>, <-18.00724, 60.5066, 1.8988> }
					triangle { <-18.03782, 57.7853, -0.5333>, <-18.00724, 60.5066, 1.8988>, <-19.07887, 60.5973, 0.179> }
					triangle { <-18.03782, 57.7853, -0.5333>, <-19.07887, 60.5973, 0.179>, <-18.00724, 60.5066, 1.8988> }
					triangle { <-18.00724, 60.5066, 1.8988>, <-19.5998, 63.5535, 0.9972>, <-19.07887, 60.5973, 0.179> }
					triangle { <-18.00724, 60.5066, 1.8988>, <-19.07887, 60.5973, 0.179>, <-19.5998, 63.5535, 0.9972> }
					triangle { <-18.04716, 60.1353, 3.7475>, <-18.9878, 62.6429, 4.3814>, <-18.00724, 60.5066, 1.8988> }
					triangle { <-18.04716, 60.1353, 3.7475>, <-18.00724, 60.5066, 1.8988>, <-18.9878, 62.6429, 4.3814> }
					triangle { <-18.00724, 60.5066, 1.8988>, <-18.9878, 62.6429, 4.3814>, <-19.2318, 63.4614, 2.7472> }
					triangle { <-18.00724, 60.5066, 1.8988>, <-19.2318, 63.4614, 2.7472>, <-18.9878, 62.6429, 4.3814> }
					triangle { <-19.2318, 63.4614, 2.7472>, <-19.5998, 63.5535, 0.9972>, <-18.00724, 60.5066, 1.8988> }
					triangle { <-19.2318, 63.4614, 2.7472>, <-18.00724, 60.5066, 1.8988>, <-19.5998, 63.5535, 0.9972> }
					triangle { <-19.143, 59.665, 4.6308>, <-18.9878, 62.6429, 4.3814>, <-18.04716, 60.1353, 3.7475> }
					triangle { <-19.143, 59.665, 4.6308>, <-18.04716, 60.1353, 3.7475>, <-18.9878, 62.6429, 4.3814> }
					triangle { <-18.9878, 62.6429, 4.3814>, <-19.1293, 63.7666, 3.5438>, <-19.2318, 63.4614, 2.7472> }
					triangle { <-18.9878, 62.6429, 4.3814>, <-19.2318, 63.4614, 2.7472>, <-19.1293, 63.7666, 3.5438> }
					triangle { <-19.1293, 63.7666, 3.5438>, <-19.2122, 64.8513, 2.4705>, <-19.2318, 63.4614, 2.7472> }
					triangle { <-19.1293, 63.7666, 3.5438>, <-19.2318, 63.4614, 2.7472>, <-19.2122, 64.8513, 2.4705> }
					triangle { <-19.2122, 64.8513, 2.4705>, <-19.5998, 63.5535, 0.9972>, <-19.2318, 63.4614, 2.7472> }
					triangle { <-19.2122, 64.8513, 2.4705>, <-19.2318, 63.4614, 2.7472>, <-19.5998, 63.5535, 0.9972> }
					triangle { <-19.2122, 64.8513, 2.4705>, <-21.4097, 65.5985, 1.3885>, <-19.5998, 63.5535, 0.9972> }
					triangle { <-19.2122, 64.8513, 2.4705>, <-19.5998, 63.5535, 0.9972>, <-21.4097, 65.5985, 1.3885> }
					triangle { <-18.03782, 57.7853, -0.5333>, <-16.00613, 56.9373, -2.5055>, <-17.3794, 54.7565, -1.3565> }
					triangle { <-18.03782, 57.7853, -0.5333>, <-17.3794, 54.7565, -1.3565>, <-16.00613, 56.9373, -2.5055> }
					triangle { <-18.03782, 57.7853, -0.5333>, <-16.3731, 59.1613, -3.7356>, <-16.00613, 56.9373, -2.5055> }
					triangle { <-18.03782, 57.7853, -0.5333>, <-16.00613, 56.9373, -2.5055>, <-16.3731, 59.1613, -3.7356> }
					triangle { <-17.3688, 62.04124, -2.7664>, <-18.00434, 62.2527, -3.9353>, <-16.3731, 59.1613, -3.7356> }
					triangle { <-17.3688, 62.04124, -2.7664>, <-16.3731, 59.1613, -3.7356>, <-18.00434, 62.2527, -3.9353> }
					triangle { <-16.3731, 59.1613, -3.7356>, <-18.07004, 61.265, -1.1179>, <-17.3688, 62.04124, -2.7664> }
					triangle { <-16.3731, 59.1613, -3.7356>, <-17.3688, 62.04124, -2.7664>, <-18.07004, 61.265, -1.1179> }
					triangle { <-18.03782, 57.7853, -0.5333>, <-18.07004, 61.265, -1.1179>, <-16.3731, 59.1613, -3.7356> }
					triangle { <-18.03782, 57.7853, -0.5333>, <-16.3731, 59.1613, -3.7356>, <-18.07004, 61.265, -1.1179> }
					triangle { <-19.07887, 60.5973, 0.179>, <-18.07004, 61.265, -1.1179>, <-18.03782, 57.7853, -0.5333> }
					triangle { <-19.07887, 60.5973, 0.179>, <-18.03782, 57.7853, -0.5333>, <-18.07004, 61.265, -1.1179> }
					triangle { <-19.07887, 60.5973, 0.179>, <-19.5998, 63.5535, 0.9972>, <-18.07004, 61.265, -1.1179> }
					triangle { <-19.07887, 60.5973, 0.179>, <-18.07004, 61.265, -1.1179>, <-19.5998, 63.5535, 0.9972> }
					triangle { <-18.07004, 61.265, -1.1179>, <-18.2055, 64.5776, -2.1114>, <-17.3688, 62.04124, -2.7664> }
					triangle { <-18.07004, 61.265, -1.1179>, <-17.3688, 62.04124, -2.7664>, <-18.2055, 64.5776, -2.1114> }
					triangle { <-18.9573, 64.3688, -0.4155>, <-18.2055, 64.5776, -2.1114>, <-18.07004, 61.265, -1.1179> }
					triangle { <-18.9573, 64.3688, -0.4155>, <-18.07004, 61.265, -1.1179>, <-18.2055, 64.5776, -2.1114> }
					triangle { <-18.07004, 61.265, -1.1179>, <-19.5998, 63.5535, 0.9972>, <-18.9573, 64.3688, -0.4155> }
					triangle { <-18.07004, 61.265, -1.1179>, <-18.9573, 64.3688, -0.4155>, <-19.5998, 63.5535, 0.9972> }
					triangle { <-17.3688, 62.04124, -2.7664>, <-18.2055, 64.5776, -2.1114>, <-18.00434, 62.2527, -3.9353> }
					triangle { <-17.3688, 62.04124, -2.7664>, <-18.00434, 62.2527, -3.9353>, <-18.2055, 64.5776, -2.1114> }
					triangle { <-18.9573, 64.3688, -0.4155>, <-18.5994, 65.07728, -0.8545>, <-18.2055, 64.5776, -2.1114> }
					triangle { <-18.9573, 64.3688, -0.4155>, <-18.2055, 64.5776, -2.1114>, <-18.5994, 65.07728, -0.8545> }
					triangle { <-18.9573, 64.3688, -0.4155>, <-18.985, 65.413, 0.5855>, <-18.5994, 65.07728, -0.8545> }
					triangle { <-18.9573, 64.3688, -0.4155>, <-18.5994, 65.07728, -0.8545>, <-18.985, 65.413, 0.5855> }
					triangle { <-18.9573, 64.3688, -0.4155>, <-19.5998, 63.5535, 0.9972>, <-18.985, 65.413, 0.5855> }
					triangle { <-18.9573, 64.3688, -0.4155>, <-18.985, 65.413, 0.5855>, <-19.5998, 63.5535, 0.9972> }
					triangle { <-19.5998, 63.5535, 0.9972>, <-21.4097, 65.5985, 1.3885>, <-18.985, 65.413, 0.5855> }
					triangle { <-19.5998, 63.5535, 0.9972>, <-18.985, 65.413, 0.5855>, <-21.4097, 65.5985, 1.3885> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <-7.3456, 37.9409, 0.5623>, <-7.1154, 40.0929, 0.3738>, 0.4231 }
			cylinder { <-7.1154, 40.0929, 0.3738>, <-6.8853, 42.2448, 0.1853>, 0.4231 }
			cylinder { <-6.8853, 42.2448, 0.1853>, <-6.6551, 44.3967, -0.00322>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-6.6551, 44.3967, -0.00322>, <-5.8377, 45.8626, 1.376>, 0.4231 }
			cylinder { <-5.8377, 45.8626, 1.376>, <-5.02038, 47.3285, 2.7553>, 0.4231 }
			cylinder { <-5.02038, 47.3285, 2.7553>, <-4.2029, 48.7943, 4.1346>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-4.2029, 48.7943, 4.1346>, <-1.969, 52.3497, 6.1444>, 0.4231 }
				cylinder { <-1.969, 52.3497, 6.1444>, <0.6134, 56.1061, 7.08793>, 0.4231 }
				cylinder { <0.6134, 56.1061, 7.08793>, <3.3896, 59.8385, 6.9086>, 0.4231 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <3.3896, 59.8385, 6.9086>, <2.2836, 62.3407, 7.5997>, <5.1909, 62.4859, 7.08672> }
					triangle { <3.3896, 59.8385, 6.9086>, <5.1909, 62.4859, 7.08672>, <2.2836, 62.3407, 7.5997> }
					triangle { <2.2836, 62.3407, 7.5997>, <2.1945, 64.6869, 6.5084>, <5.1909, 62.4859, 7.08672> }
					triangle { <2.2836, 62.3407, 7.5997>, <5.1909, 62.4859, 7.08672>, <2.1945, 64.6869, 6.5084> }
					triangle { <2.1945, 64.6869, 6.5084>, <3.6784, 67.6515, 5.5205>, <4.1252, 67.2472, 6.8767> }
					triangle { <2.1945, 64.6869, 6.5084>, <4.1252, 67.2472, 6.8767>, <3.6784, 67.6515, 5.5205> }
					triangle { <4.1252, 67.2472, 6.8767>, <5.5142, 66.104, 7.4433>, <2.1945, 64.6869, 6.5084> }
					triangle { <4.1252, 67.2472, 6.8767>, <2.1945, 64.6869, 6.5084>, <5.5142, 66.104, 7.4433> }
					triangle { <2.1945, 64.6869, 6.5084>, <5.5142, 66.104, 7.4433>, <5.1909, 62.4859, 7.08672> }
					triangle { <2.1945, 64.6869, 6.5084>, <5.1909, 62.4859, 7.08672>, <5.5142, 66.104, 7.4433> }
					triangle { <5.1909, 62.4859, 7.08672>, <5.5142, 66.104, 7.4433>, <7.06148, 64.9255, 6.8677> }
					triangle { <5.1909, 62.4859, 7.08672>, <7.06148, 64.9255, 6.8677>, <5.5142, 66.104, 7.4433> }
					triangle { <5.5142, 66.104, 7.4433>, <8.7633, 67.5147, 7.1504>, <7.06148, 64.9255, 6.8677> }
					triangle { <5.5142, 66.104, 7.4433>, <7.06148, 64.9255, 6.8677>, <8.7633, 67.5147, 7.1504> }
					triangle { <4.1252, 67.2472, 6.8767>, <5.7989, 69.4222, 6.6704>, <5.5142, 66.104, 7.4433> }
					triangle { <4.1252, 67.2472, 6.8767>, <5.5142, 66.104, 7.4433>, <5.7989, 69.4222, 6.6704> }
					triangle { <5.5142, 66.104, 7.4433>, <5.7989, 69.4222, 6.6704>, <7.4681, 68.7486, 7.07066> }
					triangle { <5.5142, 66.104, 7.4433>, <7.4681, 68.7486, 7.07066>, <5.7989, 69.4222, 6.6704> }
					triangle { <7.4681, 68.7486, 7.07066>, <8.7633, 67.5147, 7.1504>, <5.5142, 66.104, 7.4433> }
					triangle { <7.4681, 68.7486, 7.07066>, <5.5142, 66.104, 7.4433>, <8.7633, 67.5147, 7.1504> }
					triangle { <3.6784, 67.6515, 5.5205>, <5.7989, 69.4222, 6.6704>, <4.1252, 67.2472, 6.8767> }
					triangle { <3.6784, 67.6515, 5.5205>, <4.1252, 67.2472, 6.8767>, <5.7989, 69.4222, 6.6704> }
					triangle { <5.7989, 69.4222, 6.6704>, <7.1397, 69.5423, 7.0854>, <7.4681, 68.7486, 7.07066> }
					triangle { <5.7989, 69.4222, 6.6704>, <7.4681, 68.7486, 7.07066>, <7.1397, 69.5423, 7.0854> }
					triangle { <7.1397, 69.5423, 7.0854>, <8.5781, 69.4573, 7.5943>, <7.4681, 68.7486, 7.07066> }
					triangle { <7.1397, 69.5423, 7.0854>, <7.4681, 68.7486, 7.07066>, <8.5781, 69.4573, 7.5943> }
					triangle { <8.5781, 69.4573, 7.5943>, <8.7633, 67.5147, 7.1504>, <7.4681, 68.7486, 7.07066> }
					triangle { <8.5781, 69.4573, 7.5943>, <7.4681, 68.7486, 7.07066>, <8.7633, 67.5147, 7.1504> }
					triangle { <8.5781, 69.4573, 7.5943>, <10.6095, 69.244, 6.04961>, <8.7633, 67.5147, 7.1504> }
					triangle { <8.5781, 69.4573, 7.5943>, <8.7633, 67.5147, 7.1504>, <10.6095, 69.244, 6.04961> }
					triangle { <5.1909, 62.4859, 7.08672>, <5.05807, 60.3504, 9.1258>, <3.3896, 59.8385, 6.9086> }
					triangle { <5.1909, 62.4859, 7.08672>, <3.3896, 59.8385, 6.9086>, <5.05807, 60.3504, 9.1258> }
					triangle { <5.1909, 62.4859, 7.08672>, <7.4788, 60.9131, 9.772>, <5.05807, 60.3504, 9.1258> }
					triangle { <5.1909, 62.4859, 7.08672>, <5.05807, 60.3504, 9.1258>, <7.4788, 60.9131, 9.772> }
					triangle { <9.2181, 63.5879, 9.5593>, <10.3358, 62.8813, 9.3016>, <7.4788, 60.9131, 9.772> }
					triangle { <9.2181, 63.5879, 9.5593>, <7.4788, 60.9131, 9.772>, <10.3358, 62.8813, 9.3016> }
					triangle { <7.4788, 60.9131, 9.772>, <7.9339, 64.3453, 8.2988>, <9.2181, 63.5879, 9.5593> }
					triangle { <7.4788, 60.9131, 9.772>, <9.2181, 63.5879, 9.5593>, <7.9339, 64.3453, 8.2988> }
					triangle { <5.1909, 62.4859, 7.08672>, <7.9339, 64.3453, 8.2988>, <7.4788, 60.9131, 9.772> }
					triangle { <5.1909, 62.4859, 7.08672>, <7.4788, 60.9131, 9.772>, <7.9339, 64.3453, 8.2988> }
					triangle { <7.06148, 64.9255, 6.8677>, <7.9339, 64.3453, 8.2988>, <5.1909, 62.4859, 7.08672> }
					triangle { <7.06148, 64.9255, 6.8677>, <5.1909, 62.4859, 7.08672>, <7.9339, 64.3453, 8.2988> }
					triangle { <7.06148, 64.9255, 6.8677>, <8.7633, 67.5147, 7.1504>, <7.9339, 64.3453, 8.2988> }
					triangle { <7.06148, 64.9255, 6.8677>, <7.9339, 64.3453, 8.2988>, <8.7633, 67.5147, 7.1504> }
					triangle { <7.9339, 64.3453, 8.2988>, <10.8581, 65.7928, 9.4534>, <9.2181, 63.5879, 9.5593> }
					triangle { <7.9339, 64.3453, 8.2988>, <9.2181, 63.5879, 9.5593>, <10.8581, 65.7928, 9.4534> }
					triangle { <9.9499, 66.9625, 8.3169>, <10.8581, 65.7928, 9.4534>, <7.9339, 64.3453, 8.2988> }
					triangle { <9.9499, 66.9625, 8.3169>, <7.9339, 64.3453, 8.2988>, <10.8581, 65.7928, 9.4534> }
					triangle { <7.9339, 64.3453, 8.2988>, <8.7633, 67.5147, 7.1504>, <9.9499, 66.9625, 8.3169> }
					triangle { <7.9339, 64.3453, 8.2988>, <9.9499, 66.9625, 8.3169>, <8.7633, 67.5147, 7.1504> }
					triangle { <9.2181, 63.5879, 9.5593>, <10.8581, 65.7928, 9.4534>, <10.3358, 62.8813, 9.3016> }
					triangle { <9.2181, 63.5879, 9.5593>, <10.3358, 62.8813, 9.3016>, <10.8581, 65.7928, 9.4534> }
					triangle { <9.9499, 66.9625, 8.3169>, <10.5669, 67.08379, 8.9706>, <10.8581, 65.7928, 9.4534> }
					triangle { <9.9499, 66.9625, 8.3169>, <10.8581, 65.7928, 9.4534>, <10.5669, 67.08379, 8.9706> }
					triangle { <9.9499, 66.9625, 8.3169>, <10.04698, 68.4036, 8.4023>, <10.5669, 67.08379, 8.9706> }
					triangle { <9.9499, 66.9625, 8.3169>, <10.5669, 67.08379, 8.9706>, <10.04698, 68.4036, 8.4023> }
					triangle { <9.9499, 66.9625, 8.3169>, <8.7633, 67.5147, 7.1504>, <10.04698, 68.4036, 8.4023> }
					triangle { <9.9499, 66.9625, 8.3169>, <10.04698, 68.4036, 8.4023>, <8.7633, 67.5147, 7.1504> }
					triangle { <8.7633, 67.5147, 7.1504>, <10.6095, 69.244, 6.04961>, <10.04698, 68.4036, 8.4023> }
					triangle { <8.7633, 67.5147, 7.1504>, <10.04698, 68.4036, 8.4023>, <10.6095, 69.244, 6.04961> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <3.3896, 59.8385, 6.9086>, <5.676, 59.8637, 8.5619>, <5.5549, 62.1992, 6.7545> }
					triangle { <3.3896, 59.8385, 6.9086>, <5.5549, 62.1992, 6.7545>, <5.676, 59.8637, 8.5619> }
					triangle { <5.676, 59.8637, 8.5619>, <6.7022, 61.5148, 10.2719>, <5.5549, 62.1992, 6.7545> }
					triangle { <5.676, 59.8637, 8.5619>, <5.5549, 62.1992, 6.7545>, <6.7022, 61.5148, 10.2719> }
					triangle { <6.7022, 61.5148, 10.2719>, <8.3191, 64.4665, 11.07223>, <8.9334, 63.8154, 9.8886> }
					triangle { <6.7022, 61.5148, 10.2719>, <8.9334, 63.8154, 9.8886>, <8.3191, 64.4665, 11.07223> }
					triangle { <8.9334, 63.8154, 9.8886>, <8.5078, 63.9066, 8.05342>, <6.7022, 61.5148, 10.2719> }
					triangle { <8.9334, 63.8154, 9.8886>, <6.7022, 61.5148, 10.2719>, <8.5078, 63.9066, 8.05342> }
					triangle { <6.7022, 61.5148, 10.2719>, <8.5078, 63.9066, 8.05342>, <5.5549, 62.1992, 6.7545> }
					triangle { <6.7022, 61.5148, 10.2719>, <5.5549, 62.1992, 6.7545>, <8.5078, 63.9066, 8.05342> }
					triangle { <5.5549, 62.1992, 6.7545>, <8.5078, 63.9066, 8.05342>, <7.3042, 64.7343, 6.6462> }
					triangle { <5.5549, 62.1992, 6.7545>, <7.3042, 64.7343, 6.6462>, <8.5078, 63.9066, 8.05342> }
					triangle { <8.5078, 63.9066, 8.05342>, <9.4915, 66.9411, 6.486>, <7.3042, 64.7343, 6.6462> }
					triangle { <8.5078, 63.9066, 8.05342>, <7.3042, 64.7343, 6.6462>, <9.4915, 66.9411, 6.486> }
					triangle { <8.9334, 63.8154, 9.8886>, <10.4859, 66.08605, 9.793>, <8.5078, 63.9066, 8.05342> }
					triangle { <8.9334, 63.8154, 9.8886>, <8.5078, 63.9066, 8.05342>, <10.4859, 66.08605, 9.793> }
					triangle { <8.5078, 63.9066, 8.05342>, <10.4859, 66.08605, 9.793>, <10.3115, 66.681, 8.05652> }
					triangle { <8.5078, 63.9066, 8.05342>, <10.3115, 66.681, 8.05652>, <10.4859, 66.08605, 9.793> }
					triangle { <10.3115, 66.681, 8.05652>, <9.4915, 66.9411, 6.486>, <8.5078, 63.9066, 8.05342> }
					triangle { <10.3115, 66.681, 8.05652>, <8.5078, 63.9066, 8.05342>, <9.4915, 66.9411, 6.486> }
					triangle { <8.3191, 64.4665, 11.07223>, <10.4859, 66.08605, 9.793>, <8.9334, 63.8154, 9.8886> }
					triangle { <8.3191, 64.4665, 11.07223>, <8.9334, 63.8154, 9.8886>, <10.4859, 66.08605, 9.793> }
					triangle { <10.4859, 66.08605, 9.793>, <10.902, 66.8198, 8.6649>, <10.3115, 66.681, 8.05652> }
					triangle { <10.4859, 66.08605, 9.793>, <10.3115, 66.681, 8.05652>, <10.902, 66.8198, 8.6649> }
					triangle { <10.902, 66.8198, 8.6649>, <11.2308, 67.4711, 7.3221>, <10.3115, 66.681, 8.05652> }
					triangle { <10.902, 66.8198, 8.6649>, <10.3115, 66.681, 8.05652>, <11.2308, 67.4711, 7.3221> }
					triangle { <11.2308, 67.4711, 7.3221>, <9.4915, 66.9411, 6.486>, <10.3115, 66.681, 8.05652> }
					triangle { <11.2308, 67.4711, 7.3221>, <10.3115, 66.681, 8.05652>, <9.4915, 66.9411, 6.486> }
					triangle { <11.2308, 67.4711, 7.3221>, <10.1241, 69.6264, 6.4925>, <9.4915, 66.9411, 6.486> }
					triangle { <11.2308, 67.4711, 7.3221>, <9.4915, 66.9411, 6.486>, <10.1241, 69.6264, 6.4925> }
					triangle { <5.5549, 62.1992, 6.7545>, <5.3065, 59.9598, 4.8415>, <3.3896, 59.8385, 6.9086> }
					triangle { <5.5549, 62.1992, 6.7545>, <3.3896, 59.8385, 6.9086>, <5.3065, 59.9598, 4.8415> }
					triangle { <5.5549, 62.1992, 6.7545>, <6.2478, 61.5043, 3.01868>, <5.3065, 59.9598, 4.8415> }
					triangle { <5.5549, 62.1992, 6.7545>, <5.3065, 59.9598, 4.8415>, <6.2478, 61.5043, 3.01868> }
					triangle { <8.172, 64.0564, 3.1146>, <7.5155, 64.6326, 2.08895>, <6.2478, 61.5043, 3.01868> }
					triangle { <8.172, 64.0564, 3.1146>, <6.2478, 61.5043, 3.01868>, <7.5155, 64.6326, 2.08895> }
					triangle { <6.2478, 61.5043, 3.01868>, <7.853, 64.2485, 5.03111>, <8.172, 64.0564, 3.1146> }
					triangle { <6.2478, 61.5043, 3.01868>, <8.172, 64.0564, 3.1146>, <7.853, 64.2485, 5.03111> }
					triangle { <5.5549, 62.1992, 6.7545>, <7.853, 64.2485, 5.03111>, <6.2478, 61.5043, 3.01868> }
					triangle { <5.5549, 62.1992, 6.7545>, <6.2478, 61.5043, 3.01868>, <7.853, 64.2485, 5.03111> }
					triangle { <7.3042, 64.7343, 6.6462>, <7.853, 64.2485, 5.03111>, <5.5549, 62.1992, 6.7545> }
					triangle { <7.3042, 64.7343, 6.6462>, <5.5549, 62.1992, 6.7545>, <7.853, 64.2485, 5.03111> }
					triangle { <7.3042, 64.7343, 6.6462>, <9.4915, 66.9411, 6.486>, <7.853, 64.2485, 5.03111> }
					triangle { <7.3042, 64.7343, 6.6462>, <7.853, 64.2485, 5.03111>, <9.4915, 66.9411, 6.486> }
					triangle { <7.853, 64.2485, 5.03111>, <9.812, 66.2613, 3.008709>, <8.172, 64.0564, 3.1146> }
					triangle { <7.853, 64.2485, 5.03111>, <8.172, 64.0564, 3.1146>, <9.812, 66.2613, 3.008709> }
					triangle { <9.8978, 66.8315, 4.7841>, <9.812, 66.2613, 3.008709>, <7.853, 64.2485, 5.03111> }
					triangle { <9.8978, 66.8315, 4.7841>, <7.853, 64.2485, 5.03111>, <9.812, 66.2613, 3.008709> }
					triangle { <7.853, 64.2485, 5.03111>, <9.4915, 66.9411, 6.486>, <9.8978, 66.8315, 4.7841> }
					triangle { <7.853, 64.2485, 5.03111>, <9.8978, 66.8315, 4.7841>, <9.4915, 66.9411, 6.486> }
					triangle { <8.172, 64.0564, 3.1146>, <9.812, 66.2613, 3.008709>, <7.5155, 64.6326, 2.08895> }
					triangle { <8.172, 64.0564, 3.1146>, <7.5155, 64.6326, 2.08895>, <9.812, 66.2613, 3.008709> }
					triangle { <9.8978, 66.8315, 4.7841>, <10.4455, 66.9386, 4.06906>, <9.812, 66.2613, 3.008709> }
					triangle { <9.8978, 66.8315, 4.7841>, <9.812, 66.2613, 3.008709>, <10.4455, 66.9386, 4.06906> }
					triangle { <9.8978, 66.8315, 4.7841>, <11.03517, 67.522, 5.3525>, <10.4455, 66.9386, 4.06906> }
					triangle { <9.8978, 66.8315, 4.7841>, <10.4455, 66.9386, 4.06906>, <11.03517, 67.522, 5.3525> }
					triangle { <9.8978, 66.8315, 4.7841>, <9.4915, 66.9411, 6.486>, <11.03517, 67.522, 5.3525> }
					triangle { <9.8978, 66.8315, 4.7841>, <11.03517, 67.522, 5.3525>, <9.4915, 66.9411, 6.486> }
					triangle { <9.4915, 66.9411, 6.486>, <10.1241, 69.6264, 6.4925>, <11.03517, 67.522, 5.3525> }
					triangle { <9.4915, 66.9411, 6.486>, <11.03517, 67.522, 5.3525>, <10.1241, 69.6264, 6.4925> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <3.3896, 59.8385, 6.9086>, <4.544, 60.5068, 4.4221>, <5.129, 62.5048, 6.5201> }
					triangle { <3.3896, 59.8385, 6.9086>, <5.129, 62.5048, 6.5201>, <4.544, 60.5068, 4.4221> }
					triangle { <4.544, 60.5068, 4.4221>, <6.9355, 61.01949, 3.5727>, <5.129, 62.5048, 6.5201> }
					triangle { <4.544, 60.5068, 4.4221>, <5.129, 62.5048, 6.5201>, <6.9355, 61.01949, 3.5727> }
					triangle { <6.9355, 61.01949, 3.5727>, <9.732, 63.04538, 3.3667>, <8.4813, 63.8316, 3.2262> }
					triangle { <6.9355, 61.01949, 3.5727>, <8.4813, 63.8316, 3.2262>, <9.732, 63.04538, 3.3667> }
					triangle { <8.4813, 63.8316, 3.2262>, <7.3417, 64.604, 4.5154>, <6.9355, 61.01949, 3.5727> }
					triangle { <8.4813, 63.8316, 3.2262>, <6.9355, 61.01949, 3.5727>, <7.3417, 64.604, 4.5154> }
					triangle { <6.9355, 61.01949, 3.5727>, <7.3417, 64.604, 4.5154>, <5.129, 62.5048, 6.5201> }
					triangle { <6.9355, 61.01949, 3.5727>, <5.129, 62.5048, 6.5201>, <7.3417, 64.604, 4.5154> }
					triangle { <5.129, 62.5048, 6.5201>, <7.3417, 64.604, 4.5154>, <7.0202, 64.9381, 6.49> }
					triangle { <5.129, 62.5048, 6.5201>, <7.0202, 64.9381, 6.49>, <7.3417, 64.604, 4.5154> }
					triangle { <7.3417, 64.604, 4.5154>, <8.6395, 67.5523, 6.01735>, <7.0202, 64.9381, 6.49> }
					triangle { <7.3417, 64.604, 4.5154>, <7.0202, 64.9381, 6.49>, <8.6395, 67.5523, 6.01735> }
					triangle { <8.4813, 63.8316, 3.2262>, <10.1757, 66.0004, 3.2087>, <7.3417, 64.604, 4.5154> }
					triangle { <8.4813, 63.8316, 3.2262>, <7.3417, 64.604, 4.5154>, <10.1757, 66.0004, 3.2087> }
					triangle { <7.3417, 64.604, 4.5154>, <10.1757, 66.0004, 3.2087>, <9.4881, 67.1226, 4.5001> }
					triangle { <7.3417, 64.604, 4.5154>, <9.4881, 67.1226, 4.5001>, <10.1757, 66.0004, 3.2087> }
					triangle { <9.4881, 67.1226, 4.5001>, <8.6395, 67.5523, 6.01735>, <7.3417, 64.604, 4.5154> }
					triangle { <9.4881, 67.1226, 4.5001>, <7.3417, 64.604, 4.5154>, <8.6395, 67.5523, 6.01735> }
					triangle { <9.732, 63.04538, 3.3667>, <10.1757, 66.0004, 3.2087>, <8.4813, 63.8316, 3.2262> }
					triangle { <9.732, 63.04538, 3.3667>, <8.4813, 63.8316, 3.2262>, <10.1757, 66.0004, 3.2087> }
					triangle { <10.1757, 66.0004, 3.2087>, <10.00483, 67.2547, 3.8266>, <9.4881, 67.1226, 4.5001> }
					triangle { <10.1757, 66.0004, 3.2087>, <9.4881, 67.1226, 4.5001>, <10.00483, 67.2547, 3.8266> }
					triangle { <10.00483, 67.2547, 3.8266>, <9.6291, 68.5306, 4.579>, <9.4881, 67.1226, 4.5001> }
					triangle { <10.00483, 67.2547, 3.8266>, <9.4881, 67.1226, 4.5001>, <9.6291, 68.5306, 4.579> }
					triangle { <9.6291, 68.5306, 4.579>, <8.6395, 67.5523, 6.01735>, <9.4881, 67.1226, 4.5001> }
					triangle { <9.6291, 68.5306, 4.579>, <9.4881, 67.1226, 4.5001>, <8.6395, 67.5523, 6.01735> }
					triangle { <9.6291, 68.5306, 4.579>, <10.692, 69.2189, 6.8049>, <8.6395, 67.5523, 6.01735> }
					triangle { <9.6291, 68.5306, 4.579>, <8.6395, 67.5523, 6.01735>, <10.692, 69.2189, 6.8049> }
					triangle { <5.129, 62.5048, 6.5201>, <2.1786, 62.3727, 6.638>, <3.3896, 59.8385, 6.9086> }
					triangle { <5.129, 62.5048, 6.5201>, <3.3896, 59.8385, 6.9086>, <2.1786, 62.3727, 6.638> }
					triangle { <5.129, 62.5048, 6.5201>, <2.1806, 64.7501, 7.6088>, <2.1786, 62.3727, 6.638> }
					triangle { <5.129, 62.5048, 6.5201>, <2.1786, 62.3727, 6.638>, <2.1806, 64.7501, 7.6088> }
					triangle { <4.2222, 67.198, 7.3556>, <3.9727, 67.5817, 8.6227>, <2.1806, 64.7501, 7.6088> }
					triangle { <4.2222, 67.198, 7.3556>, <2.1806, 64.7501, 7.6088>, <3.9727, 67.5817, 8.6227> }
					triangle { <2.1806, 64.7501, 7.6088>, <5.6112, 65.9959, 6.6944>, <4.2222, 67.198, 7.3556> }
					triangle { <2.1806, 64.7501, 7.6088>, <4.2222, 67.198, 7.3556>, <5.6112, 65.9959, 6.6944> }
					triangle { <5.129, 62.5048, 6.5201>, <5.6112, 65.9959, 6.6944>, <2.1806, 64.7501, 7.6088> }
					triangle { <5.129, 62.5048, 6.5201>, <2.1806, 64.7501, 7.6088>, <5.6112, 65.9959, 6.6944> }
					triangle { <7.0202, 64.9381, 6.49>, <5.6112, 65.9959, 6.6944>, <5.129, 62.5048, 6.5201> }
					triangle { <7.0202, 64.9381, 6.49>, <5.129, 62.5048, 6.5201>, <5.6112, 65.9959, 6.6944> }
					triangle { <7.0202, 64.9381, 6.49>, <8.6395, 67.5523, 6.01735>, <5.6112, 65.9959, 6.6944> }
					triangle { <7.0202, 64.9381, 6.49>, <5.6112, 65.9959, 6.6944>, <8.6395, 67.5523, 6.01735> }
					triangle { <5.6112, 65.9959, 6.6944>, <5.8622, 69.4029, 7.2496>, <4.2222, 67.198, 7.3556> }
					triangle { <5.6112, 65.9959, 6.6944>, <4.2222, 67.198, 7.3556>, <5.8622, 69.4029, 7.2496> }
					triangle { <7.4553, 68.7329, 6.5439>, <5.8622, 69.4029, 7.2496>, <5.6112, 65.9959, 6.6944> }
					triangle { <7.4553, 68.7329, 6.5439>, <5.6112, 65.9959, 6.6944>, <5.8622, 69.4029, 7.2496> }
					triangle { <5.6112, 65.9959, 6.6944>, <8.6395, 67.5523, 6.01735>, <7.4553, 68.7329, 6.5439> }
					triangle { <5.6112, 65.9959, 6.6944>, <7.4553, 68.7329, 6.5439>, <8.6395, 67.5523, 6.01735> }
					triangle { <4.2222, 67.198, 7.3556>, <5.8622, 69.4029, 7.2496>, <3.9727, 67.5817, 8.6227> }
					triangle { <4.2222, 67.198, 7.3556>, <3.9727, 67.5817, 8.6227>, <5.8622, 69.4029, 7.2496> }
					triangle { <7.4553, 68.7329, 6.5439>, <7.08281, 69.5597, 6.564>, <5.8622, 69.4029, 7.2496> }
					triangle { <7.4553, 68.7329, 6.5439>, <5.8622, 69.4029, 7.2496>, <7.08281, 69.5597, 6.564> }
					triangle { <7.4553, 68.7329, 6.5439>, <8.3768, 69.5185, 5.7522>, <7.08281, 69.5597, 6.564> }
					triangle { <7.4553, 68.7329, 6.5439>, <7.08281, 69.5597, 6.564>, <8.3768, 69.5185, 5.7522> }
					triangle { <7.4553, 68.7329, 6.5439>, <8.6395, 67.5523, 6.01735>, <8.3768, 69.5185, 5.7522> }
					triangle { <7.4553, 68.7329, 6.5439>, <8.3768, 69.5185, 5.7522>, <8.6395, 67.5523, 6.01735> }
					triangle { <8.6395, 67.5523, 6.01735>, <10.692, 69.2189, 6.8049>, <8.3768, 69.5185, 5.7522> }
					triangle { <8.6395, 67.5523, 6.01735>, <8.3768, 69.5185, 5.7522>, <10.692, 69.2189, 6.8049> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		}
	union { // Internode
		cylinder { <-6.2789, 22.6622, 1.004623>, <-7.3318, 23.8065, 1.3777>, 0.2907 }
		cylinder { <-7.3318, 23.8065, 1.3777>, <-8.2962, 25.00985, 1.8013>, 0.2907 }
		cylinder { <-8.2962, 25.00985, 1.8013>, <-9.1669, 26.2655, 2.273>, 0.2907 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-9.1669, 26.2655, 2.273>, <-9.4993, 27.3831, 2.7895>, 0.08695 }
			cylinder { <-9.4993, 27.3831, 2.7895>, <-9.4363, 28.5041, 3.3943>, 0.08695 }
			cylinder { <-9.4363, 28.5041, 3.3943>, <-8.9842, 29.5154, 4.02634>, 0.08695 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-8.9842, 29.5154, 4.02634>, <-8.8401, 29.8149, 4.2157>, 0.08695 }
				cylinder { <-8.8401, 29.8149, 4.2157>, <-8.6874, 30.1104, 4.4049>, 0.08695 }
				cylinder { <-8.6874, 30.1104, 4.4049>, <-8.5264, 30.4016, 4.5936>, 0.08695 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-8.5264, 30.4016, 4.5936>, <-8.4949, 30.4558, 4.6563>, 0.006048 }
				cylinder { <-8.4949, 30.4558, 4.6563>, <-8.4715, 30.4929, 4.7335>, 0.006048 }
				cylinder { <-8.4715, 30.4929, 4.7335>, <-8.458, 30.51, 4.8195>, 0.006048 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-8.458, 30.51, 4.8195>, <-8.2343, 32.3485, 7.4967>, <-7.9848, 31.9323, 8.4878> }
				triangle { <-8.458, 30.51, 4.8195>, <-7.9848, 31.9323, 8.4878>, <-8.2343, 32.3485, 7.4967> }
				triangle { <-8.2343, 32.3485, 7.4967>, <-7.9578, 33.4303, 9.8428>, <-7.9848, 31.9323, 8.4878> }
				triangle { <-8.2343, 32.3485, 7.4967>, <-7.9848, 31.9323, 8.4878>, <-7.9578, 33.4303, 9.8428> }
				triangle { <-7.9578, 33.4303, 9.8428>, <-7.6165, 31.5748, 10.159>, <-7.9848, 31.9323, 8.4878> }
				triangle { <-7.9578, 33.4303, 9.8428>, <-7.9848, 31.9323, 8.4878>, <-7.6165, 31.5748, 10.159> }
				triangle { <-7.9848, 31.9323, 8.4878>, <-7.6165, 31.5748, 10.159>, <-8.458, 30.51, 4.8195> }
				triangle { <-7.9848, 31.9323, 8.4878>, <-8.458, 30.51, 4.8195>, <-7.6165, 31.5748, 10.159> }
				triangle { <-7.9578, 33.4303, 9.8428>, <-0.9503, 34.9356, 10.6489>, <2.1505, 34.7887, 11.5318> }
				triangle { <-7.9578, 33.4303, 9.8428>, <2.1505, 34.7887, 11.5318>, <-0.9503, 34.9356, 10.6489> }
				triangle { <2.1505, 34.7887, 11.5318>, <3.8779, 33.9457, 11.6645>, <2.3563, 33.4283, 10.2705> }
				triangle { <2.1505, 34.7887, 11.5318>, <2.3563, 33.4283, 10.2705>, <3.8779, 33.9457, 11.6645> }
				triangle { <2.3563, 33.4283, 10.2705>, <-7.9578, 33.4303, 9.8428>, <2.1505, 34.7887, 11.5318> }
				triangle { <2.3563, 33.4283, 10.2705>, <2.1505, 34.7887, 11.5318>, <-7.9578, 33.4303, 9.8428> }
				triangle { <-7.9578, 33.4303, 9.8428>, <2.3563, 33.4283, 10.2705>, <-7.6165, 31.5748, 10.159> }
				triangle { <-7.9578, 33.4303, 9.8428>, <-7.6165, 31.5748, 10.159>, <2.3563, 33.4283, 10.2705> }
				triangle { <-7.7391, 30.5963, 8.7155>, <-7.7701, 29.8251, 7.9268>, <-8.458, 30.51, 4.8195> }
				triangle { <-7.7391, 30.5963, 8.7155>, <-8.458, 30.51, 4.8195>, <-7.7701, 29.8251, 7.9268> }
				triangle { <-7.7391, 30.5963, 8.7155>, <-7.2752, 29.7193, 10.4752>, <-7.7701, 29.8251, 7.9268> }
				triangle { <-7.7391, 30.5963, 8.7155>, <-7.7701, 29.8251, 7.9268>, <-7.2752, 29.7193, 10.4752> }
				triangle { <-7.7391, 30.5963, 8.7155>, <-7.6165, 31.5748, 10.159>, <-7.2752, 29.7193, 10.4752> }
				triangle { <-7.7391, 30.5963, 8.7155>, <-7.2752, 29.7193, 10.4752>, <-7.6165, 31.5748, 10.159> }
				triangle { <-8.458, 30.51, 4.8195>, <-7.6165, 31.5748, 10.159>, <-7.7391, 30.5963, 8.7155> }
				triangle { <-8.458, 30.51, 4.8195>, <-7.7391, 30.5963, 8.7155>, <-7.6165, 31.5748, 10.159> }
				triangle { <2.56, 32.562, 11.9112>, <-0.2404, 31.07619, 11.3067>, <-7.2752, 29.7193, 10.4752> }
				triangle { <2.56, 32.562, 11.9112>, <-7.2752, 29.7193, 10.4752>, <-0.2404, 31.07619, 11.3067> }
				triangle { <2.3563, 33.4283, 10.2705>, <3.8779, 33.9457, 11.6645>, <2.56, 32.562, 11.9112> }
				triangle { <2.3563, 33.4283, 10.2705>, <2.56, 32.562, 11.9112>, <3.8779, 33.9457, 11.6645> }
				triangle { <2.56, 32.562, 11.9112>, <-7.2752, 29.7193, 10.4752>, <2.3563, 33.4283, 10.2705> }
				triangle { <2.56, 32.562, 11.9112>, <2.3563, 33.4283, 10.2705>, <-7.2752, 29.7193, 10.4752> }
				triangle { <-7.6165, 31.5748, 10.159>, <2.3563, 33.4283, 10.2705>, <-7.2752, 29.7193, 10.4752> }
				triangle { <-7.6165, 31.5748, 10.159>, <-7.2752, 29.7193, 10.4752>, <2.3563, 33.4283, 10.2705> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-8.5264, 30.4016, 4.5936>, <-8.3571, 30.6884, 4.7818>, 0.08695 }
				cylinder { <-8.3571, 30.6884, 4.7818>, <-8.1796, 30.9707, 4.9695>, 0.08695 }
				cylinder { <-8.1796, 30.9707, 4.9695>, <-7.994, 31.2482, 5.1563>, 0.08695 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.994, 31.2482, 5.1563>, <-7.9481, 31.3211, 5.1775>, 0.006048 }
				cylinder { <-7.9481, 31.3211, 5.1775>, <-7.9025, 31.3972, 5.1751>, 0.006048 }
				cylinder { <-7.9025, 31.3972, 5.1751>, <-7.8606, 31.471, 5.1492>, 0.006048 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.8606, 31.471, 5.1492>, <-7.344, 34.1325, 3.3472>, <-6.4911, 34.8119, 3.5165> }
				triangle { <-7.8606, 31.471, 5.1492>, <-6.4911, 34.8119, 3.5165>, <-7.344, 34.1325, 3.3472> }
				triangle { <-7.344, 34.1325, 3.3472>, <-6.572, 36.3172, 2.1718>, <-6.4911, 34.8119, 3.5165> }
				triangle { <-7.344, 34.1325, 3.3472>, <-6.4911, 34.8119, 3.5165>, <-6.572, 36.3172, 2.1718> }
				triangle { <-6.572, 36.3172, 2.1718>, <-5.2607, 36.05368, 3.5393>, <-6.4911, 34.8119, 3.5165> }
				triangle { <-6.572, 36.3172, 2.1718>, <-6.4911, 34.8119, 3.5165>, <-5.2607, 36.05368, 3.5393> }
				triangle { <-6.4911, 34.8119, 3.5165>, <-5.2607, 36.05368, 3.5393>, <-7.8606, 31.471, 5.1492> }
				triangle { <-6.4911, 34.8119, 3.5165>, <-7.8606, 31.471, 5.1492>, <-5.2607, 36.05368, 3.5393> }
				triangle { <-6.572, 36.3172, 2.1718>, <-1.7954, 34.4071, -2.8836>, <0.9649, 33.8508, -4.4604> }
				triangle { <-6.572, 36.3172, 2.1718>, <0.9649, 33.8508, -4.4604>, <-1.7954, 34.4071, -2.8836> }
				triangle { <0.9649, 33.8508, -4.4604>, <2.7085, 33.06079, -4.6791>, <1.1929, 32.3599, -3.3609> }
				triangle { <0.9649, 33.8508, -4.4604>, <1.1929, 32.3599, -3.3609>, <2.7085, 33.06079, -4.6791> }
				triangle { <1.1929, 32.3599, -3.3609>, <-6.572, 36.3172, 2.1718>, <0.9649, 33.8508, -4.4604> }
				triangle { <1.1929, 32.3599, -3.3609>, <0.9649, 33.8508, -4.4604>, <-6.572, 36.3172, 2.1718> }
				triangle { <-6.572, 36.3172, 2.1718>, <1.1929, 32.3599, -3.3609>, <-5.2607, 36.05368, 3.5393> }
				triangle { <-6.572, 36.3172, 2.1718>, <-5.2607, 36.05368, 3.5393>, <1.1929, 32.3599, -3.3609> }
				triangle { <-5.5469, 34.6221, 4.5012>, <-5.5606, 33.774, 5.2071>, <-7.8606, 31.471, 5.1492> }
				triangle { <-5.5469, 34.6221, 4.5012>, <-7.8606, 31.471, 5.1492>, <-5.5606, 33.774, 5.2071> }
				triangle { <-5.5469, 34.6221, 4.5012>, <-3.9493, 35.79, 4.9069>, <-5.5606, 33.774, 5.2071> }
				triangle { <-5.5469, 34.6221, 4.5012>, <-5.5606, 33.774, 5.2071>, <-3.9493, 35.79, 4.9069> }
				triangle { <-5.5469, 34.6221, 4.5012>, <-5.2607, 36.05368, 3.5393>, <-3.9493, 35.79, 4.9069> }
				triangle { <-5.5469, 34.6221, 4.5012>, <-3.9493, 35.79, 4.9069>, <-5.2607, 36.05368, 3.5393> }
				triangle { <-7.8606, 31.471, 5.1492>, <-5.2607, 36.05368, 3.5393>, <-5.5469, 34.6221, 4.5012> }
				triangle { <-7.8606, 31.471, 5.1492>, <-5.5469, 34.6221, 4.5012>, <-5.2607, 36.05368, 3.5393> }
				triangle { <2.5386, 33.5345, -2.8193>, <0.9321, 33.8588, -0.03907>, <-3.9493, 35.79, 4.9069> }
				triangle { <2.5386, 33.5345, -2.8193>, <-3.9493, 35.79, 4.9069>, <0.9321, 33.8588, -0.03907> }
				triangle { <1.1929, 32.3599, -3.3609>, <2.7085, 33.06079, -4.6791>, <2.5386, 33.5345, -2.8193> }
				triangle { <1.1929, 32.3599, -3.3609>, <2.5386, 33.5345, -2.8193>, <2.7085, 33.06079, -4.6791> }
				triangle { <2.5386, 33.5345, -2.8193>, <-3.9493, 35.79, 4.9069>, <1.1929, 32.3599, -3.3609> }
				triangle { <2.5386, 33.5345, -2.8193>, <1.1929, 32.3599, -3.3609>, <-3.9493, 35.79, 4.9069> }
				triangle { <-5.2607, 36.05368, 3.5393>, <1.1929, 32.3599, -3.3609>, <-3.9493, 35.79, 4.9069> }
				triangle { <-5.2607, 36.05368, 3.5393>, <-3.9493, 35.79, 4.9069>, <1.1929, 32.3599, -3.3609> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.994, 31.2482, 5.1563>, <-7.8085, 31.5258, 5.3432>, 0.08695 }
				cylinder { <-7.8085, 31.5258, 5.3432>, <-7.6229, 31.8033, 5.5301>, 0.08695 }
				cylinder { <-7.6229, 31.8033, 5.5301>, <-7.4373, 32.08086, 5.717>, 0.08695 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.4373, 32.08086, 5.717>, <-7.4004, 32.132, 5.7793>, 0.006048 }
				cylinder { <-7.4004, 32.132, 5.7793>, <-7.3721, 32.1663, 5.856>, 0.006048 }
				cylinder { <-7.3721, 32.1663, 5.856>, <-7.3547, 32.1813, 5.9417>, 0.006048 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.3547, 32.1813, 5.9417>, <-6.9247, 33.9613, 8.6332>, <-6.6696, 33.5151, 9.6098> }
				triangle { <-7.3547, 32.1813, 5.9417>, <-6.6696, 33.5151, 9.6098>, <-6.9247, 33.9613, 8.6332> }
				triangle { <-6.9247, 33.9613, 8.6332>, <-6.5016, 34.9879, 10.9822>, <-6.6696, 33.5151, 9.6098> }
				triangle { <-6.9247, 33.9613, 8.6332>, <-6.6696, 33.5151, 9.6098>, <-6.5016, 34.9879, 10.9822> }
				triangle { <-6.5016, 34.9879, 10.9822>, <-6.2697, 33.1099, 11.2627>, <-6.6696, 33.5151, 9.6098> }
				triangle { <-6.5016, 34.9879, 10.9822>, <-6.6696, 33.5151, 9.6098>, <-6.2697, 33.1099, 11.2627> }
				triangle { <-6.6696, 33.5151, 9.6098>, <-6.2697, 33.1099, 11.2627>, <-7.3547, 32.1813, 5.9417> }
				triangle { <-6.6696, 33.5151, 9.6098>, <-7.3547, 32.1813, 5.9417>, <-6.2697, 33.1099, 11.2627> }
				triangle { <-6.5016, 34.9879, 10.9822>, <0.6109, 36.03179, 11.5681>, <3.7235, 35.6745, 12.3426> }
				triangle { <-6.5016, 34.9879, 10.9822>, <3.7235, 35.6745, 12.3426>, <0.6109, 36.03179, 11.5681> }
				triangle { <3.7235, 35.6745, 12.3426>, <5.3968, 34.7214, 12.4055>, <3.7997, 34.3228, 11.05772> }
				triangle { <3.7235, 35.6745, 12.3426>, <3.7997, 34.3228, 11.05772>, <5.3968, 34.7214, 12.4055> }
				triangle { <3.7997, 34.3228, 11.05772>, <-6.5016, 34.9879, 10.9822>, <3.7235, 35.6745, 12.3426> }
				triangle { <3.7997, 34.3228, 11.05772>, <3.7235, 35.6745, 12.3426>, <-6.5016, 34.9879, 10.9822> }
				triangle { <-6.5016, 34.9879, 10.9822>, <3.7997, 34.3228, 11.05772>, <-6.2697, 33.1099, 11.2627> }
				triangle { <-6.5016, 34.9879, 10.9822>, <-6.2697, 33.1099, 11.2627>, <3.7997, 34.3228, 11.05772> }
				triangle { <-6.5026, 32.163, 9.8117>, <-6.6092, 31.4072, 9.01469>, <-7.3547, 32.1813, 5.9417> }
				triangle { <-6.5026, 32.163, 9.8117>, <-7.3547, 32.1813, 5.9417>, <-6.6092, 31.4072, 9.01469> }
				triangle { <-6.5026, 32.163, 9.8117>, <-6.03779, 31.2319, 11.5432>, <-6.6092, 31.4072, 9.01469> }
				triangle { <-6.5026, 32.163, 9.8117>, <-6.6092, 31.4072, 9.01469>, <-6.03779, 31.2319, 11.5432> }
				triangle { <-6.5026, 32.163, 9.8117>, <-6.2697, 33.1099, 11.2627>, <-6.03779, 31.2319, 11.5432> }
				triangle { <-6.5026, 32.163, 9.8117>, <-6.03779, 31.2319, 11.5432>, <-6.2697, 33.1099, 11.2627> }
				triangle { <-7.3547, 32.1813, 5.9417>, <-6.2697, 33.1099, 11.2627>, <-6.5026, 32.163, 9.8117> }
				triangle { <-7.3547, 32.1813, 5.9417>, <-6.5026, 32.163, 9.8117>, <-6.2697, 33.1099, 11.2627> }
				triangle { <4.001906, 33.4208, 12.6792>, <1.09336, 32.1255, 12.1515>, <-6.03779, 31.2319, 11.5432> }
				triangle { <4.001906, 33.4208, 12.6792>, <-6.03779, 31.2319, 11.5432>, <1.09336, 32.1255, 12.1515> }
				triangle { <3.7997, 34.3228, 11.05772>, <5.3968, 34.7214, 12.4055>, <4.001906, 33.4208, 12.6792> }
				triangle { <3.7997, 34.3228, 11.05772>, <4.001906, 33.4208, 12.6792>, <5.3968, 34.7214, 12.4055> }
				triangle { <4.001906, 33.4208, 12.6792>, <-6.03779, 31.2319, 11.5432>, <3.7997, 34.3228, 11.05772> }
				triangle { <4.001906, 33.4208, 12.6792>, <3.7997, 34.3228, 11.05772>, <-6.03779, 31.2319, 11.5432> }
				triangle { <-6.2697, 33.1099, 11.2627>, <3.7997, 34.3228, 11.05772>, <-6.03779, 31.2319, 11.5432> }
				triangle { <-6.2697, 33.1099, 11.2627>, <-6.03779, 31.2319, 11.5432>, <3.7997, 34.3228, 11.05772> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.4373, 32.08086, 5.717>, <-7.3943, 32.1452, 5.7603>, 0.006048 }
				cylinder { <-7.3943, 32.1452, 5.7603>, <-7.3513, 32.2095, 5.8036>, 0.006048 }
				cylinder { <-7.3513, 32.2095, 5.8036>, <-7.3083, 32.2739, 5.847>, 0.006048 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.3083, 32.2739, 5.847>, <-6.3241, 35.3152, 6.4625>, <-5.6608, 35.5687, 7.3073> }
				triangle { <-7.3083, 32.2739, 5.847>, <-5.6608, 35.5687, 7.3073>, <-6.3241, 35.3152, 6.4625> }
				triangle { <-6.3241, 35.3152, 6.4625>, <-5.3173, 37.5595, 7.2997>, <-5.6608, 35.5687, 7.3073> }
				triangle { <-6.3241, 35.3152, 6.4625>, <-5.6608, 35.5687, 7.3073>, <-5.3173, 37.5595, 7.2997> }
				triangle { <-5.3173, 37.5595, 7.2997>, <-4.6362, 36.2702, 8.538>, <-5.6608, 35.5687, 7.3073> }
				triangle { <-5.3173, 37.5595, 7.2997>, <-5.6608, 35.5687, 7.3073>, <-4.6362, 36.2702, 8.538> }
				triangle { <-5.6608, 35.5687, 7.3073>, <-4.6362, 36.2702, 8.538>, <-7.3083, 32.2739, 5.847> }
				triangle { <-5.6608, 35.5687, 7.3073>, <-7.3083, 32.2739, 5.847>, <-4.6362, 36.2702, 8.538> }
				triangle { <-5.3173, 37.5595, 7.2997>, <1.1952, 38.2007, 4.2671>, <4.3872, 38.1805, 3.7907> }
				triangle { <-5.3173, 37.5595, 7.2997>, <4.3872, 38.1805, 3.7907>, <1.1952, 38.2007, 4.2671> }
				triangle { <4.3872, 38.1805, 3.7907>, <6.1295, 37.3592, 3.7503>, <4.2741, 36.3202, 3.6892> }
				triangle { <4.3872, 38.1805, 3.7907>, <4.2741, 36.3202, 3.6892>, <6.1295, 37.3592, 3.7503> }
				triangle { <4.2741, 36.3202, 3.6892>, <-5.3173, 37.5595, 7.2997>, <4.3872, 38.1805, 3.7907> }
				triangle { <4.2741, 36.3202, 3.6892>, <4.3872, 38.1805, 3.7907>, <-5.3173, 37.5595, 7.2997> }
				triangle { <-5.3173, 37.5595, 7.2997>, <4.2741, 36.3202, 3.6892>, <-4.6362, 36.2702, 8.538> }
				triangle { <-5.3173, 37.5595, 7.2997>, <-4.6362, 36.2702, 8.538>, <4.2741, 36.3202, 3.6892> }
				triangle { <-5.1704, 34.6405, 8.1989>, <-5.3978, 33.5619, 8.1466>, <-7.3083, 32.2739, 5.847> }
				triangle { <-5.1704, 34.6405, 8.1989>, <-7.3083, 32.2739, 5.847>, <-5.3978, 33.5619, 8.1466> }
				triangle { <-5.1704, 34.6405, 8.1989>, <-3.9551, 34.981, 9.7763>, <-5.3978, 33.5619, 8.1466> }
				triangle { <-5.1704, 34.6405, 8.1989>, <-5.3978, 33.5619, 8.1466>, <-3.9551, 34.981, 9.7763> }
				triangle { <-5.1704, 34.6405, 8.1989>, <-4.6362, 36.2702, 8.538>, <-3.9551, 34.981, 9.7763> }
				triangle { <-5.1704, 34.6405, 8.1989>, <-3.9551, 34.981, 9.7763>, <-4.6362, 36.2702, 8.538> }
				triangle { <-7.3083, 32.2739, 5.847>, <-4.6362, 36.2702, 8.538>, <-5.1704, 34.6405, 8.1989> }
				triangle { <-7.3083, 32.2739, 5.847>, <-5.1704, 34.6405, 8.1989>, <-4.6362, 36.2702, 8.538> }
				triangle { <5.2045, 36.6335, 5.2767>, <2.6118, 35.5191, 6.8428>, <-3.9551, 34.981, 9.7763> }
				triangle { <5.2045, 36.6335, 5.2767>, <-3.9551, 34.981, 9.7763>, <2.6118, 35.5191, 6.8428> }
				triangle { <4.2741, 36.3202, 3.6892>, <6.1295, 37.3592, 3.7503>, <5.2045, 36.6335, 5.2767> }
				triangle { <4.2741, 36.3202, 3.6892>, <5.2045, 36.6335, 5.2767>, <6.1295, 37.3592, 3.7503> }
				triangle { <5.2045, 36.6335, 5.2767>, <-3.9551, 34.981, 9.7763>, <4.2741, 36.3202, 3.6892> }
				triangle { <5.2045, 36.6335, 5.2767>, <4.2741, 36.3202, 3.6892>, <-3.9551, 34.981, 9.7763> }
				triangle { <-4.6362, 36.2702, 8.538>, <4.2741, 36.3202, 3.6892>, <-3.9551, 34.981, 9.7763> }
				triangle { <-4.6362, 36.2702, 8.538>, <-3.9551, 34.981, 9.7763>, <4.2741, 36.3202, 3.6892> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-9.1669, 26.2655, 2.273>, <-10.153, 27.04966, 2.4708>, 0.08695 }
			cylinder { <-10.153, 27.04966, 2.4708>, <-11.3314, 27.5373, 2.4703>, 0.08695 }
			cylinder { <-11.3314, 27.5373, 2.4703>, <-12.5831, 27.6792, 2.2716>, 0.08695 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-12.5831, 27.6792, 2.2716>, <-12.9587, 27.7135, 2.2076>, 0.08695 }
				cylinder { <-12.9587, 27.7135, 2.2076>, <-13.3343, 27.7395, 2.1392>, 0.08695 }
				cylinder { <-13.3343, 27.7395, 2.1392>, <-13.7095, 27.7572, 2.0665>, 0.08695 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-13.7095, 27.7572, 2.0665>, <-13.7888, 27.7719, 2.02971>, 0.006048 }
				cylinder { <-13.7888, 27.7719, 2.02971>, <-13.8548, 27.7963, 1.9756>, 0.006048 }
				cylinder { <-13.8548, 27.7963, 1.9756>, <-13.9026, 27.8286, 1.9082>, 0.006048 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-13.9026, 27.8286, 1.9082>, <-16.4255, 29.3061, 0.4767>, <-16.4895, 29.4549, -0.6149> }
				triangle { <-13.9026, 27.8286, 1.9082>, <-16.4895, 29.4549, -0.6149>, <-16.4255, 29.3061, 0.4767> }
				triangle { <-16.4255, 29.3061, 0.4767>, <-18.2166, 30.4088, -1.04877>, <-16.4895, 29.4549, -0.6149> }
				triangle { <-16.4255, 29.3061, 0.4767>, <-16.4895, 29.4549, -0.6149>, <-18.2166, 30.4088, -1.04877> }
				triangle { <-18.2166, 30.4088, -1.04877>, <-16.8706, 29.8309, -2.2791>, <-16.4895, 29.4549, -0.6149> }
				triangle { <-18.2166, 30.4088, -1.04877>, <-16.4895, 29.4549, -0.6149>, <-16.8706, 29.8309, -2.2791> }
				triangle { <-16.4895, 29.4549, -0.6149>, <-16.8706, 29.8309, -2.2791>, <-13.9026, 27.8286, 1.9082> }
				triangle { <-16.4895, 29.4549, -0.6149>, <-13.9026, 27.8286, 1.9082>, <-16.8706, 29.8309, -2.2791> }
				triangle { <-18.2166, 30.4088, -1.04877>, <-22.6157, 25.1416, -3.2681>, <-24.03625, 22.865, -5.06137> }
				triangle { <-18.2166, 30.4088, -1.04877>, <-24.03625, 22.865, -5.06137>, <-22.6157, 25.1416, -3.2681> }
				triangle { <-24.03625, 22.865, -5.06137>, <-24.06148, 21.253, -6.1163>, <-22.5518, 21.7876, -4.7159> }
				triangle { <-24.03625, 22.865, -5.06137>, <-22.5518, 21.7876, -4.7159>, <-24.06148, 21.253, -6.1163> }
				triangle { <-22.5518, 21.7876, -4.7159>, <-18.2166, 30.4088, -1.04877>, <-24.03625, 22.865, -5.06137> }
				triangle { <-22.5518, 21.7876, -4.7159>, <-24.03625, 22.865, -5.06137>, <-18.2166, 30.4088, -1.04877> }
				triangle { <-18.2166, 30.4088, -1.04877>, <-22.5518, 21.7876, -4.7159>, <-16.8706, 29.8309, -2.2791> }
				triangle { <-18.2166, 30.4088, -1.04877>, <-16.8706, 29.8309, -2.2791>, <-22.5518, 21.7876, -4.7159> }
				triangle { <-15.5204, 29.03886, -1.5007>, <-14.595, 28.5202, -1.1965>, <-13.9026, 27.8286, 1.9082> }
				triangle { <-15.5204, 29.03886, -1.5007>, <-13.9026, 27.8286, 1.9082>, <-14.595, 28.5202, -1.1965> }
				triangle { <-15.5204, 29.03886, -1.5007>, <-15.5247, 29.2529, -3.5095>, <-14.595, 28.5202, -1.1965> }
				triangle { <-15.5204, 29.03886, -1.5007>, <-14.595, 28.5202, -1.1965>, <-15.5247, 29.2529, -3.5095> }
				triangle { <-15.5204, 29.03886, -1.5007>, <-16.8706, 29.8309, -2.2791>, <-15.5247, 29.2529, -3.5095> }
				triangle { <-15.5204, 29.03886, -1.5007>, <-15.5247, 29.2529, -3.5095>, <-16.8706, 29.8309, -2.2791> }
				triangle { <-13.9026, 27.8286, 1.9082>, <-16.8706, 29.8309, -2.2791>, <-15.5204, 29.03886, -1.5007> }
				triangle { <-13.9026, 27.8286, 1.9082>, <-15.5204, 29.03886, -1.5007>, <-16.8706, 29.8309, -2.2791> }
				triangle { <-22.4211, 22.1715, -6.5378>, <-19.8162, 23.9395, -5.8273>, <-15.5247, 29.2529, -3.5095> }
				triangle { <-22.4211, 22.1715, -6.5378>, <-15.5247, 29.2529, -3.5095>, <-19.8162, 23.9395, -5.8273> }
				triangle { <-22.5518, 21.7876, -4.7159>, <-24.06148, 21.253, -6.1163>, <-22.4211, 22.1715, -6.5378> }
				triangle { <-22.5518, 21.7876, -4.7159>, <-22.4211, 22.1715, -6.5378>, <-24.06148, 21.253, -6.1163> }
				triangle { <-22.4211, 22.1715, -6.5378>, <-15.5247, 29.2529, -3.5095>, <-22.5518, 21.7876, -4.7159> }
				triangle { <-22.4211, 22.1715, -6.5378>, <-22.5518, 21.7876, -4.7159>, <-15.5247, 29.2529, -3.5095> }
				triangle { <-16.8706, 29.8309, -2.2791>, <-22.5518, 21.7876, -4.7159>, <-15.5247, 29.2529, -3.5095> }
				triangle { <-16.8706, 29.8309, -2.2791>, <-15.5247, 29.2529, -3.5095>, <-22.5518, 21.7876, -4.7159> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-13.7095, 27.7572, 2.0665>, <-14.08416, 27.7665, 1.9895>, 0.08695 }
				cylinder { <-14.08416, 27.7665, 1.9895>, <-14.458, 27.7674, 1.9083>, 0.08695 }
				cylinder { <-14.458, 27.7674, 1.9083>, <-14.8309, 27.7601, 1.8229>, 0.08695 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-14.8309, 27.7601, 1.8229>, <-14.9187, 27.7476, 1.8243>, 0.006048 }
				cylinder { <-14.9187, 27.7476, 1.8243>, <-15.00153, 27.7252, 1.847>, 0.006048 }
				cylinder { <-15.00153, 27.7252, 1.847>, <-15.07335, 27.6946, 1.8891>, 0.006048 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-15.07335, 27.6946, 1.8891>, <-16.9805, 27.03876, 4.4445>, <-17.9631, 26.5463, 4.3454> }
				triangle { <-15.07335, 27.6946, 1.8891>, <-17.9631, 26.5463, 4.3454>, <-16.9805, 27.03876, 4.4445> }
				triangle { <-16.9805, 27.03876, 4.4445>, <-18.7853, 26.3435, 6.1795>, <-17.9631, 26.5463, 4.3454> }
				triangle { <-16.9805, 27.03876, 4.4445>, <-17.9631, 26.5463, 4.3454>, <-18.7853, 26.3435, 6.1795> }
				triangle { <-18.7853, 26.3435, 6.1795>, <-19.5331, 25.7943, 4.5066>, <-17.9631, 26.5463, 4.3454> }
				triangle { <-18.7853, 26.3435, 6.1795>, <-17.9631, 26.5463, 4.3454>, <-19.5331, 25.7943, 4.5066> }
				triangle { <-17.9631, 26.5463, 4.3454>, <-19.5331, 25.7943, 4.5066>, <-15.07335, 27.6946, 1.8891> }
				triangle { <-17.9631, 26.5463, 4.3454>, <-15.07335, 27.6946, 1.8891>, <-19.5331, 25.7943, 4.5066> }
				triangle { <-18.7853, 26.3435, 6.1795>, <-17.4732, 19.4722, 7.9361>, <-17.615, 16.2518, 8.09431> }
				triangle { <-18.7853, 26.3435, 6.1795>, <-17.615, 16.2518, 8.09431>, <-17.4732, 19.4722, 7.9361> }
				triangle { <-17.615, 16.2518, 8.09431>, <-17.5792, 14.4755, 7.3489>, <-16.7863, 16.2186, 6.4222> }
				triangle { <-17.615, 16.2518, 8.09431>, <-16.7863, 16.2186, 6.4222>, <-17.5792, 14.4755, 7.3489> }
				triangle { <-16.7863, 16.2186, 6.4222>, <-18.7853, 26.3435, 6.1795>, <-17.615, 16.2518, 8.09431> }
				triangle { <-16.7863, 16.2186, 6.4222>, <-17.615, 16.2518, 8.09431>, <-18.7853, 26.3435, 6.1795> }
				triangle { <-18.7853, 26.3435, 6.1795>, <-16.7863, 16.2186, 6.4222>, <-19.5331, 25.7943, 4.5066> }
				triangle { <-18.7853, 26.3435, 6.1795>, <-19.5331, 25.7943, 4.5066>, <-16.7863, 16.2186, 6.4222> }
				triangle { <-18.5016, 26.1508, 3.1409>, <-17.9975, 26.2918, 2.1693>, <-15.07335, 27.6946, 1.8891> }
				triangle { <-18.5016, 26.1508, 3.1409>, <-15.07335, 27.6946, 1.8891>, <-17.9975, 26.2918, 2.1693> }
				triangle { <-18.5016, 26.1508, 3.1409>, <-20.2809, 25.2451, 2.8337>, <-17.9975, 26.2918, 2.1693> }
				triangle { <-18.5016, 26.1508, 3.1409>, <-17.9975, 26.2918, 2.1693>, <-20.2809, 25.2451, 2.8337> }
				triangle { <-18.5016, 26.1508, 3.1409>, <-19.5331, 25.7943, 4.5066>, <-20.2809, 25.2451, 2.8337> }
				triangle { <-18.5016, 26.1508, 3.1409>, <-20.2809, 25.2451, 2.8337>, <-19.5331, 25.7943, 4.5066> }
				triangle { <-15.07335, 27.6946, 1.8891>, <-19.5331, 25.7943, 4.5066>, <-18.5016, 26.1508, 3.1409> }
				triangle { <-15.07335, 27.6946, 1.8891>, <-18.5016, 26.1508, 3.1409>, <-19.5331, 25.7943, 4.5066> }
				triangle { <-18.5124, 15.5928, 6.08684>, <-19.02865, 18.3299, 4.4565>, <-20.2809, 25.2451, 2.8337> }
				triangle { <-18.5124, 15.5928, 6.08684>, <-20.2809, 25.2451, 2.8337>, <-19.02865, 18.3299, 4.4565> }
				triangle { <-16.7863, 16.2186, 6.4222>, <-17.5792, 14.4755, 7.3489>, <-18.5124, 15.5928, 6.08684> }
				triangle { <-16.7863, 16.2186, 6.4222>, <-18.5124, 15.5928, 6.08684>, <-17.5792, 14.4755, 7.3489> }
				triangle { <-18.5124, 15.5928, 6.08684>, <-20.2809, 25.2451, 2.8337>, <-16.7863, 16.2186, 6.4222> }
				triangle { <-18.5124, 15.5928, 6.08684>, <-16.7863, 16.2186, 6.4222>, <-20.2809, 25.2451, 2.8337> }
				triangle { <-19.5331, 25.7943, 4.5066>, <-16.7863, 16.2186, 6.4222>, <-20.2809, 25.2451, 2.8337> }
				triangle { <-19.5331, 25.7943, 4.5066>, <-20.2809, 25.2451, 2.8337>, <-16.7863, 16.2186, 6.4222> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-14.8309, 27.7601, 1.8229>, <-15.2037, 27.7527, 1.7375>, 0.08695 }
				cylinder { <-15.2037, 27.7527, 1.7375>, <-15.5766, 27.7453, 1.6521>, 0.08695 }
				cylinder { <-15.5766, 27.7453, 1.6521>, <-15.9494, 27.7379, 1.5667>, 0.08695 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-15.9494, 27.7379, 1.5667>, <-16.02833, 27.7471, 1.527>, 0.006048 }
				cylinder { <-16.02833, 27.7471, 1.527>, <-16.09383, 27.7665, 1.4704>, 0.006048 }
				cylinder { <-16.09383, 27.7665, 1.4704>, <-16.1412, 27.7947, 1.401>, 0.006048 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-16.1412, 27.7947, 1.401>, <-18.7027, 29.08895, -0.1355>, <-18.7388, 29.2192, -1.2308> }
				triangle { <-16.1412, 27.7947, 1.401>, <-18.7388, 29.2192, -1.2308>, <-18.7027, 29.08895, -0.1355> }
				triangle { <-18.7027, 29.08895, -0.1355>, <-20.5072, 30.05472, -1.7361>, <-18.7388, 29.2192, -1.2308> }
				triangle { <-18.7027, 29.08895, -0.1355>, <-18.7388, 29.2192, -1.2308>, <-20.5072, 30.05472, -1.7361> }
				triangle { <-20.5072, 30.05472, -1.7361>, <-19.08607, 29.5484, -2.9123>, <-18.7388, 29.2192, -1.2308> }
				triangle { <-20.5072, 30.05472, -1.7361>, <-18.7388, 29.2192, -1.2308>, <-19.08607, 29.5484, -2.9123> }
				triangle { <-18.7388, 29.2192, -1.2308>, <-19.08607, 29.5484, -2.9123>, <-16.1412, 27.7947, 1.401> }
				triangle { <-18.7388, 29.2192, -1.2308>, <-16.1412, 27.7947, 1.401>, <-19.08607, 29.5484, -2.9123> }
				triangle { <-20.5072, 30.05472, -1.7361>, <-24.4839, 24.488, -4.02106>, <-25.6945, 22.1022, -5.826> }
				triangle { <-20.5072, 30.05472, -1.7361>, <-25.6945, 22.1022, -5.826>, <-24.4839, 24.488, -4.02106> }
				triangle { <-25.6945, 22.1022, -5.826>, <-25.5811, 20.4784, -6.8569>, <-24.1572, 21.1267, -5.4153> }
				triangle { <-25.6945, 22.1022, -5.826>, <-24.1572, 21.1267, -5.4153>, <-25.5811, 20.4784, -6.8569> }
				triangle { <-24.1572, 21.1267, -5.4153>, <-20.5072, 30.05472, -1.7361>, <-25.6945, 22.1022, -5.826> }
				triangle { <-24.1572, 21.1267, -5.4153>, <-25.6945, 22.1022, -5.826>, <-20.5072, 30.05472, -1.7361> }
				triangle { <-20.5072, 30.05472, -1.7361>, <-24.1572, 21.1267, -5.4153>, <-19.08607, 29.5484, -2.9123> }
				triangle { <-20.5072, 30.05472, -1.7361>, <-19.08607, 29.5484, -2.9123>, <-24.1572, 21.1267, -5.4153> }
				triangle { <-17.7155, 28.8547, -2.07764>, <-16.7699, 28.4004, -1.7351>, <-16.1412, 27.7947, 1.401> }
				triangle { <-17.7155, 28.8547, -2.07764>, <-16.1412, 27.7947, 1.401>, <-16.7699, 28.4004, -1.7351> }
				triangle { <-17.7155, 28.8547, -2.07764>, <-17.6648, 29.04226, -4.08842>, <-16.7699, 28.4004, -1.7351> }
				triangle { <-17.7155, 28.8547, -2.07764>, <-16.7699, 28.4004, -1.7351>, <-17.6648, 29.04226, -4.08842> }
				triangle { <-17.7155, 28.8547, -2.07764>, <-19.08607, 29.5484, -2.9123>, <-17.6648, 29.04226, -4.08842> }
				triangle { <-17.7155, 28.8547, -2.07764>, <-17.6648, 29.04226, -4.08842>, <-19.08607, 29.5484, -2.9123> }
				triangle { <-16.1412, 27.7947, 1.401>, <-19.08607, 29.5484, -2.9123>, <-17.7155, 28.8547, -2.07764> }
				triangle { <-16.1412, 27.7947, 1.401>, <-17.7155, 28.8547, -2.07764>, <-19.08607, 29.5484, -2.9123> }
				triangle { <-23.9891, 21.4947, -7.2374>, <-21.5278, 23.4351, -6.4673>, <-17.6648, 29.04226, -4.08842> }
				triangle { <-23.9891, 21.4947, -7.2374>, <-17.6648, 29.04226, -4.08842>, <-21.5278, 23.4351, -6.4673> }
				triangle { <-24.1572, 21.1267, -5.4153>, <-25.5811, 20.4784, -6.8569>, <-23.9891, 21.4947, -7.2374> }
				triangle { <-24.1572, 21.1267, -5.4153>, <-23.9891, 21.4947, -7.2374>, <-25.5811, 20.4784, -6.8569> }
				triangle { <-23.9891, 21.4947, -7.2374>, <-17.6648, 29.04226, -4.08842>, <-24.1572, 21.1267, -5.4153> }
				triangle { <-23.9891, 21.4947, -7.2374>, <-24.1572, 21.1267, -5.4153>, <-17.6648, 29.04226, -4.08842> }
				triangle { <-19.08607, 29.5484, -2.9123>, <-24.1572, 21.1267, -5.4153>, <-17.6648, 29.04226, -4.08842> }
				triangle { <-19.08607, 29.5484, -2.9123>, <-17.6648, 29.04226, -4.08842>, <-24.1572, 21.1267, -5.4153> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-15.9494, 27.7379, 1.5667>, <-16.03595, 27.7362, 1.5469>, 0.006048 }
				cylinder { <-16.03595, 27.7362, 1.5469>, <-16.1224, 27.7345, 1.5271>, 0.006048 }
				cylinder { <-16.1224, 27.7345, 1.5271>, <-16.2088, 27.7328, 1.5073>, 0.006048 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-16.2088, 27.7328, 1.5073>, <-19.4077, 27.8855, 2.09161>, <-20.1659, 27.7688, 1.2982> }
				triangle { <-16.2088, 27.7328, 1.5073>, <-20.1659, 27.7688, 1.2982>, <-19.4077, 27.8855, 2.09161> }
				triangle { <-19.4077, 27.8855, 2.09161>, <-22.00538, 27.9357, 2.1164>, <-20.1659, 27.7688, 1.2982> }
				triangle { <-19.4077, 27.8855, 2.09161>, <-20.1659, 27.7688, 1.2982>, <-22.00538, 27.9357, 2.1164> }
				triangle { <-22.00538, 27.9357, 2.1164>, <-21.5781, 27.6264, 0.2776>, <-20.1659, 27.7688, 1.2982> }
				triangle { <-22.00538, 27.9357, 2.1164>, <-20.1659, 27.7688, 1.2982>, <-21.5781, 27.6264, 0.2776> }
				triangle { <-20.1659, 27.7688, 1.2982>, <-21.5781, 27.6264, 0.2776>, <-16.2088, 27.7328, 1.5073> }
				triangle { <-20.1659, 27.7688, 1.2982>, <-16.2088, 27.7328, 1.5073>, <-21.5781, 27.6264, 0.2776> }
				triangle { <-22.00538, 27.9357, 2.1164>, <-24.2312, 21.112, 2.8265>, <-25.3606, 18.1575, 2.1854> }
				triangle { <-22.00538, 27.9357, 2.1164>, <-25.3606, 18.1575, 2.1854>, <-24.2312, 21.112, 2.8265> }
				triangle { <-25.3606, 18.1575, 2.1854>, <-25.3549, 16.4575, 1.2786>, <-23.6914, 17.7735, 1.4438> }
				triangle { <-25.3606, 18.1575, 2.1854>, <-23.6914, 17.7735, 1.4438>, <-25.3549, 16.4575, 1.2786> }
				triangle { <-23.6914, 17.7735, 1.4438>, <-22.00538, 27.9357, 2.1164>, <-25.3606, 18.1575, 2.1854> }
				triangle { <-23.6914, 17.7735, 1.4438>, <-25.3606, 18.1575, 2.1854>, <-22.00538, 27.9357, 2.1164> }
				triangle { <-22.00538, 27.9357, 2.1164>, <-23.6914, 17.7735, 1.4438>, <-21.5781, 27.6264, 0.2776> }
				triangle { <-22.00538, 27.9357, 2.1164>, <-21.5781, 27.6264, 0.2776>, <-23.6914, 17.7735, 1.4438> }
				triangle { <-19.8582, 27.5461, -0.02569>, <-18.8266, 27.4649, -0.4091>, <-16.2088, 27.7328, 1.5073> }
				triangle { <-19.8582, 27.5461, -0.02569>, <-16.2088, 27.7328, 1.5073>, <-18.8266, 27.4649, -0.4091> }
				triangle { <-19.8582, 27.5461, -0.02569>, <-21.1508, 27.3172, -1.5611>, <-18.8266, 27.4649, -0.4091> }
				triangle { <-19.8582, 27.5461, -0.02569>, <-18.8266, 27.4649, -0.4091>, <-21.1508, 27.3172, -1.5611> }
				triangle { <-19.8582, 27.5461, -0.02569>, <-21.5781, 27.6264, 0.2776>, <-21.1508, 27.3172, -1.5611> }
				triangle { <-19.8582, 27.5461, -0.02569>, <-21.1508, 27.3172, -1.5611>, <-21.5781, 27.6264, 0.2776> }
				triangle { <-16.2088, 27.7328, 1.5073>, <-21.5781, 27.6264, 0.2776>, <-19.8582, 27.5461, -0.02569> }
				triangle { <-16.2088, 27.7328, 1.5073>, <-19.8582, 27.5461, -0.02569>, <-21.5781, 27.6264, 0.2776> }
				triangle { <-24.8479, 17.7863, -0.02112>, <-23.3425, 20.4687, -0.9981>, <-21.1508, 27.3172, -1.5611> }
				triangle { <-24.8479, 17.7863, -0.02112>, <-21.1508, 27.3172, -1.5611>, <-23.3425, 20.4687, -0.9981> }
				triangle { <-23.6914, 17.7735, 1.4438>, <-25.3549, 16.4575, 1.2786>, <-24.8479, 17.7863, -0.02112> }
				triangle { <-23.6914, 17.7735, 1.4438>, <-24.8479, 17.7863, -0.02112>, <-25.3549, 16.4575, 1.2786> }
				triangle { <-24.8479, 17.7863, -0.02112>, <-21.1508, 27.3172, -1.5611>, <-23.6914, 17.7735, 1.4438> }
				triangle { <-24.8479, 17.7863, -0.02112>, <-23.6914, 17.7735, 1.4438>, <-21.1508, 27.3172, -1.5611> }
				triangle { <-21.5781, 27.6264, 0.2776>, <-23.6914, 17.7735, 1.4438>, <-21.1508, 27.3172, -1.5611> }
				triangle { <-21.5781, 27.6264, 0.2776>, <-21.1508, 27.3172, -1.5611>, <-23.6914, 17.7735, 1.4438> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <-9.1669, 26.2655, 2.273>, <-9.9759, 28.9852, 3.53>, 0.4231 }
			cylinder { <-9.9759, 28.9852, 3.53>, <-9.8226, 31.7132, 5.001802>, 0.4231 }
			cylinder { <-9.8226, 31.7132, 5.001802>, <-8.7224, 34.174, 6.5396>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-8.7224, 34.174, 6.5396>, <-7.9523, 35.8966, 7.6162>, 0.4231 }
			cylinder { <-7.9523, 35.8966, 7.6162>, <-7.1822, 37.6192, 8.6927>, 0.4231 }
			cylinder { <-7.1822, 37.6192, 8.6927>, <-6.4121, 39.3418, 9.7692>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-6.4121, 39.3418, 9.7692>, <-6.8153, 41.4627, 9.5273>, 0.4231 }
			cylinder { <-6.8153, 41.4627, 9.5273>, <-7.2185, 43.5836, 9.2854>, 0.4231 }
			cylinder { <-7.2185, 43.5836, 9.2854>, <-7.6217, 45.7045, 9.04351>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-7.6217, 45.7045, 9.04351>, <-8.5072, 50.2323, 9.6644>, 0.4231 }
				cylinder { <-8.5072, 50.2323, 9.6644>, <-9.3611, 54.4717, 11.3875>, 0.4231 }
				cylinder { <-9.3611, 54.4717, 11.3875>, <-10.1322, 58.1685, 14.1095>, 0.4231 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-10.1322, 58.1685, 14.1095>, <-8.2516, 60.2712, 14.04404>, <-10.6039, 60.9022, 15.7187> }
					triangle { <-10.1322, 58.1685, 14.1095>, <-10.6039, 60.9022, 15.7187>, <-8.2516, 60.2712, 14.04404> }
					triangle { <-8.2516, 60.2712, 14.04404>, <-6.9088, 61.6055, 15.8103>, <-10.6039, 60.9022, 15.7187> }
					triangle { <-8.2516, 60.2712, 14.04404>, <-10.6039, 60.9022, 15.7187>, <-6.9088, 61.6055, 15.8103> }
					triangle { <-6.9088, 61.6055, 15.8103>, <-6.6952, 63.9171, 18.375>, <-7.5753, 64.3997, 17.2821> }
					triangle { <-6.9088, 61.6055, 15.8103>, <-7.5753, 64.3997, 17.2821>, <-6.6952, 63.9171, 18.375> }
					triangle { <-7.5753, 64.3997, 17.2821>, <-9.4109, 64.1261, 16.9455>, <-6.9088, 61.6055, 15.8103> }
					triangle { <-7.5753, 64.3997, 17.2821>, <-6.9088, 61.6055, 15.8103>, <-9.4109, 64.1261, 16.9455> }
					triangle { <-6.9088, 61.6055, 15.8103>, <-9.4109, 64.1261, 16.9455>, <-10.6039, 60.9022, 15.7187> }
					triangle { <-6.9088, 61.6055, 15.8103>, <-10.6039, 60.9022, 15.7187>, <-9.4109, 64.1261, 16.9455> }
					triangle { <-10.6039, 60.9022, 15.7187>, <-9.4109, 64.1261, 16.9455>, <-11.133, 63.2814, 17.605> }
					triangle { <-10.6039, 60.9022, 15.7187>, <-11.133, 63.2814, 17.605>, <-9.4109, 64.1261, 16.9455> }
					triangle { <-9.4109, 64.1261, 16.9455>, <-11.5676, 65.9944, 19.06458>, <-11.133, 63.2814, 17.605> }
					triangle { <-9.4109, 64.1261, 16.9455>, <-11.133, 63.2814, 17.605>, <-11.5676, 65.9944, 19.06458> }
					triangle { <-7.5753, 64.3997, 17.2821>, <-8.04976, 66.5168, 18.9754>, <-9.4109, 64.1261, 16.9455> }
					triangle { <-7.5753, 64.3997, 17.2821>, <-9.4109, 64.1261, 16.9455>, <-8.04976, 66.5168, 18.9754> }
					triangle { <-9.4109, 64.1261, 16.9455>, <-8.04976, 66.5168, 18.9754>, <-9.8884, 66.6163, 19.07192> }
					triangle { <-9.4109, 64.1261, 16.9455>, <-9.8884, 66.6163, 19.07192>, <-8.04976, 66.5168, 18.9754> }
					triangle { <-9.8884, 66.6163, 19.07192>, <-11.5676, 65.9944, 19.06458>, <-9.4109, 64.1261, 16.9455> }
					triangle { <-9.8884, 66.6163, 19.07192>, <-9.4109, 64.1261, 16.9455>, <-11.5676, 65.9944, 19.06458> }
					triangle { <-6.6952, 63.9171, 18.375>, <-8.04976, 66.5168, 18.9754>, <-7.5753, 64.3997, 17.2821> }
					triangle { <-6.6952, 63.9171, 18.375>, <-7.5753, 64.3997, 17.2821>, <-8.04976, 66.5168, 18.9754> }
					triangle { <-8.04976, 66.5168, 18.9754>, <-9.2637, 67.1847, 19.2294>, <-9.8884, 66.6163, 19.07192> }
					triangle { <-8.04976, 66.5168, 18.9754>, <-9.8884, 66.6163, 19.07192>, <-9.2637, 67.1847, 19.2294> }
					triangle { <-9.2637, 67.1847, 19.2294>, <-10.6732, 67.759, 19.367>, <-9.8884, 66.6163, 19.07192> }
					triangle { <-9.2637, 67.1847, 19.2294>, <-9.8884, 66.6163, 19.07192>, <-10.6732, 67.759, 19.367> }
					triangle { <-10.6732, 67.759, 19.367>, <-11.5676, 65.9944, 19.06458>, <-9.8884, 66.6163, 19.07192> }
					triangle { <-10.6732, 67.759, 19.367>, <-9.8884, 66.6163, 19.07192>, <-11.5676, 65.9944, 19.06458> }
					triangle { <-10.6732, 67.759, 19.367>, <-12.1755, 67.3359, 21.3974>, <-11.5676, 65.9944, 19.06458> }
					triangle { <-10.6732, 67.759, 19.367>, <-11.5676, 65.9944, 19.06458>, <-12.1755, 67.3359, 21.3974> }
					triangle { <-10.6039, 60.9022, 15.7187>, <-11.8837, 60.1658, 13.1582>, <-10.1322, 58.1685, 14.1095> }
					triangle { <-10.6039, 60.9022, 15.7187>, <-10.1322, 58.1685, 14.1095>, <-11.8837, 60.1658, 13.1582> }
					triangle { <-10.6039, 60.9022, 15.7187>, <-13.9026, 61.6012, 13.8348>, <-11.8837, 60.1658, 13.1582> }
					triangle { <-10.6039, 60.9022, 15.7187>, <-11.8837, 60.1658, 13.1582>, <-13.9026, 61.6012, 13.8348> }
					triangle { <-14.2174, 64.1408, 15.7522>, <-15.436, 63.7297, 16.1534>, <-13.9026, 61.6012, 13.8348> }
					triangle { <-14.2174, 64.1408, 15.7522>, <-13.9026, 61.6012, 13.8348>, <-15.436, 63.7297, 16.1534> }
					triangle { <-13.9026, 61.6012, 13.8348>, <-12.4775, 63.7722, 16.5575>, <-14.2174, 64.1408, 15.7522> }
					triangle { <-13.9026, 61.6012, 13.8348>, <-14.2174, 64.1408, 15.7522>, <-12.4775, 63.7722, 16.5575> }
					triangle { <-10.6039, 60.9022, 15.7187>, <-12.4775, 63.7722, 16.5575>, <-13.9026, 61.6012, 13.8348> }
					triangle { <-10.6039, 60.9022, 15.7187>, <-13.9026, 61.6012, 13.8348>, <-12.4775, 63.7722, 16.5575> }
					triangle { <-11.133, 63.2814, 17.605>, <-12.4775, 63.7722, 16.5575>, <-10.6039, 60.9022, 15.7187> }
					triangle { <-11.133, 63.2814, 17.605>, <-10.6039, 60.9022, 15.7187>, <-12.4775, 63.7722, 16.5575> }
					triangle { <-11.133, 63.2814, 17.605>, <-11.5676, 65.9944, 19.06458>, <-12.4775, 63.7722, 16.5575> }
					triangle { <-11.133, 63.2814, 17.605>, <-12.4775, 63.7722, 16.5575>, <-11.5676, 65.9944, 19.06458> }
					triangle { <-12.4775, 63.7722, 16.5575>, <-14.6729, 66.3247, 17.3601>, <-14.2174, 64.1408, 15.7522> }
					triangle { <-12.4775, 63.7722, 16.5575>, <-14.2174, 64.1408, 15.7522>, <-14.6729, 66.3247, 17.3601> }
					triangle { <-13.1121, 66.4566, 18.3756>, <-14.6729, 66.3247, 17.3601>, <-12.4775, 63.7722, 16.5575> }
					triangle { <-13.1121, 66.4566, 18.3756>, <-12.4775, 63.7722, 16.5575>, <-14.6729, 66.3247, 17.3601> }
					triangle { <-12.4775, 63.7722, 16.5575>, <-11.5676, 65.9944, 19.06458>, <-13.1121, 66.4566, 18.3756> }
					triangle { <-12.4775, 63.7722, 16.5575>, <-13.1121, 66.4566, 18.3756>, <-11.5676, 65.9944, 19.06458> }
					triangle { <-14.2174, 64.1408, 15.7522>, <-14.6729, 66.3247, 17.3601>, <-15.436, 63.7297, 16.1534> }
					triangle { <-14.2174, 64.1408, 15.7522>, <-15.436, 63.7297, 16.1534>, <-14.6729, 66.3247, 17.3601> }
					triangle { <-13.1121, 66.4566, 18.3756>, <-13.7504, 67.05454, 18.1352>, <-14.6729, 66.3247, 17.3601> }
					triangle { <-13.1121, 66.4566, 18.3756>, <-14.6729, 66.3247, 17.3601>, <-13.7504, 67.05454, 18.1352> }
					triangle { <-13.1121, 66.4566, 18.3756>, <-12.596, 67.7032, 18.8981>, <-13.7504, 67.05454, 18.1352> }
					triangle { <-13.1121, 66.4566, 18.3756>, <-13.7504, 67.05454, 18.1352>, <-12.596, 67.7032, 18.8981> }
					triangle { <-13.1121, 66.4566, 18.3756>, <-11.5676, 65.9944, 19.06458>, <-12.596, 67.7032, 18.8981> }
					triangle { <-13.1121, 66.4566, 18.3756>, <-12.596, 67.7032, 18.8981>, <-11.5676, 65.9944, 19.06458> }
					triangle { <-11.5676, 65.9944, 19.06458>, <-12.1755, 67.3359, 21.3974>, <-12.596, 67.7032, 18.8981> }
					triangle { <-11.5676, 65.9944, 19.06458>, <-12.596, 67.7032, 18.8981>, <-12.1755, 67.3359, 21.3974> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-10.1322, 58.1685, 14.1095>, <-12.5005, 59.6444, 13.6916>, <-10.9673, 60.595, 16.033> }
					triangle { <-10.1322, 58.1685, 14.1095>, <-10.9673, 60.595, 16.033>, <-12.5005, 59.6444, 13.6916> }
					triangle { <-12.5005, 59.6444, 13.6916>, <-13.08319, 62.1415, 13.3332>, <-10.9673, 60.595, 16.033> }
					triangle { <-12.5005, 59.6444, 13.6916>, <-10.9673, 60.595, 16.033>, <-13.08319, 62.1415, 13.3332> }
					triangle { <-13.08319, 62.1415, 13.3332>, <-13.4083, 65.3928, 14.469>, <-13.9481, 64.4192, 15.4503> }
					triangle { <-13.08319, 62.1415, 13.3332>, <-13.9481, 64.4192, 15.4503>, <-13.4083, 65.3928, 14.469> }
					triangle { <-13.9481, 64.4192, 15.4503>, <-13.1095, 63.4413, 16.8279>, <-13.08319, 62.1415, 13.3332> }
					triangle { <-13.9481, 64.4192, 15.4503>, <-13.08319, 62.1415, 13.3332>, <-13.1095, 63.4413, 16.8279> }
					triangle { <-13.08319, 62.1415, 13.3332>, <-13.1095, 63.4413, 16.8279>, <-10.9673, 60.595, 16.033> }
					triangle { <-13.08319, 62.1415, 13.3332>, <-10.9673, 60.595, 16.033>, <-13.1095, 63.4413, 16.8279> }
					triangle { <-10.9673, 60.595, 16.033>, <-13.1095, 63.4413, 16.8279>, <-11.3752, 63.07663, 17.8145> }
					triangle { <-10.9673, 60.595, 16.033>, <-11.3752, 63.07663, 17.8145>, <-13.1095, 63.4413, 16.8279> }
					triangle { <-13.1095, 63.4413, 16.8279>, <-12.2944, 65.3801, 19.693>, <-11.3752, 63.07663, 17.8145> }
					triangle { <-13.1095, 63.4413, 16.8279>, <-11.3752, 63.07663, 17.8145>, <-12.2944, 65.3801, 19.693> }
					triangle { <-13.9481, 64.4192, 15.4503>, <-14.3014, 66.6387, 17.03889>, <-13.1095, 63.4413, 16.8279> }
					triangle { <-13.9481, 64.4192, 15.4503>, <-13.1095, 63.4413, 16.8279>, <-14.3014, 66.6387, 17.03889> }
					triangle { <-13.1095, 63.4413, 16.8279>, <-14.3014, 66.6387, 17.03889>, <-13.4878, 66.1898, 18.6315> }
					triangle { <-13.1095, 63.4413, 16.8279>, <-13.4878, 66.1898, 18.6315>, <-14.3014, 66.6387, 17.03889> }
					triangle { <-13.4878, 66.1898, 18.6315>, <-12.2944, 65.3801, 19.693>, <-13.1095, 63.4413, 16.8279> }
					triangle { <-13.4878, 66.1898, 18.6315>, <-13.1095, 63.4413, 16.8279>, <-12.2944, 65.3801, 19.693> }
					triangle { <-13.4083, 65.3928, 14.469>, <-14.3014, 66.6387, 17.03889>, <-13.9481, 64.4192, 15.4503> }
					triangle { <-13.4083, 65.3928, 14.469>, <-13.9481, 64.4192, 15.4503>, <-14.3014, 66.6387, 17.03889> }
					triangle { <-14.3014, 66.6387, 17.03889>, <-14.08487, 66.7718, 18.4244>, <-13.4878, 66.1898, 18.6315> }
					triangle { <-14.3014, 66.6387, 17.03889>, <-13.4878, 66.1898, 18.6315>, <-14.08487, 66.7718, 18.4244> }
					triangle { <-14.08487, 66.7718, 18.4244>, <-13.7776, 66.7044, 19.9199>, <-13.4878, 66.1898, 18.6315> }
					triangle { <-14.08487, 66.7718, 18.4244>, <-13.4878, 66.1898, 18.6315>, <-13.7776, 66.7044, 19.9199> }
					triangle { <-13.7776, 66.7044, 19.9199>, <-12.2944, 65.3801, 19.693>, <-13.4878, 66.1898, 18.6315> }
					triangle { <-13.7776, 66.7044, 19.9199>, <-13.4878, 66.1898, 18.6315>, <-12.2944, 65.3801, 19.693> }
					triangle { <-13.7776, 66.7044, 19.9199>, <-11.691, 67.7454, 20.9784>, <-12.2944, 65.3801, 19.693> }
					triangle { <-13.7776, 66.7044, 19.9199>, <-12.2944, 65.3801, 19.693>, <-11.691, 67.7454, 20.9784> }
					triangle { <-10.9673, 60.595, 16.033>, <-11.2687, 57.7208, 16.6531>, <-10.1322, 58.1685, 14.1095> }
					triangle { <-10.9673, 60.595, 16.033>, <-10.1322, 58.1685, 14.1095>, <-11.2687, 57.7208, 16.6531> }
					triangle { <-10.9673, 60.595, 16.033>, <-10.9988, 58.3007, 19.1401>, <-11.2687, 57.7208, 16.6531> }
					triangle { <-10.9673, 60.595, 16.033>, <-11.2687, 57.7208, 16.6531>, <-10.9988, 58.3007, 19.1401> }
					triangle { <-11.5996, 60.9472, 20.8312>, <-10.5398, 60.718, 21.6307>, <-10.9988, 58.3007, 19.1401> }
					triangle { <-11.5996, 60.9472, 20.8312>, <-10.9988, 58.3007, 19.1401>, <-10.5398, 60.718, 21.6307> }
					triangle { <-10.9988, 58.3007, 19.1401>, <-11.686, 61.9996, 19.1891>, <-11.5996, 60.9472, 20.8312> }
					triangle { <-10.9988, 58.3007, 19.1401>, <-11.5996, 60.9472, 20.8312>, <-11.686, 61.9996, 19.1891> }
					triangle { <-10.9673, 60.595, 16.033>, <-11.686, 61.9996, 19.1891>, <-10.9988, 58.3007, 19.1401> }
					triangle { <-10.9673, 60.595, 16.033>, <-10.9988, 58.3007, 19.1401>, <-11.686, 61.9996, 19.1891> }
					triangle { <-11.3752, 63.07663, 17.8145>, <-11.686, 61.9996, 19.1891>, <-10.9673, 60.595, 16.033> }
					triangle { <-11.3752, 63.07663, 17.8145>, <-10.9673, 60.595, 16.033>, <-11.686, 61.9996, 19.1891> }
					triangle { <-11.3752, 63.07663, 17.8145>, <-12.2944, 65.3801, 19.693>, <-11.686, 61.9996, 19.1891> }
					triangle { <-11.3752, 63.07663, 17.8145>, <-11.686, 61.9996, 19.1891>, <-12.2944, 65.3801, 19.693> }
					triangle { <-11.686, 61.9996, 19.1891>, <-12.05518, 63.1311, 22.4391>, <-11.5996, 60.9472, 20.8312> }
					triangle { <-11.686, 61.9996, 19.1891>, <-11.5996, 60.9472, 20.8312>, <-12.05518, 63.1311, 22.4391> }
					triangle { <-12.2987, 64.5281, 21.2252>, <-12.05518, 63.1311, 22.4391>, <-11.686, 61.9996, 19.1891> }
					triangle { <-12.2987, 64.5281, 21.2252>, <-11.686, 61.9996, 19.1891>, <-12.05518, 63.1311, 22.4391> }
					triangle { <-11.686, 61.9996, 19.1891>, <-12.2944, 65.3801, 19.693>, <-12.2987, 64.5281, 21.2252> }
					triangle { <-11.686, 61.9996, 19.1891>, <-12.2987, 64.5281, 21.2252>, <-12.2944, 65.3801, 19.693> }
					triangle { <-11.5996, 60.9472, 20.8312>, <-12.05518, 63.1311, 22.4391>, <-10.5398, 60.718, 21.6307> }
					triangle { <-11.5996, 60.9472, 20.8312>, <-10.5398, 60.718, 21.6307>, <-12.05518, 63.1311, 22.4391> }
					triangle { <-12.2987, 64.5281, 21.2252>, <-12.5632, 64.3957, 22.08272>, <-12.05518, 63.1311, 22.4391> }
					triangle { <-12.2987, 64.5281, 21.2252>, <-12.05518, 63.1311, 22.4391>, <-12.5632, 64.3957, 22.08272> }
					triangle { <-12.2987, 64.5281, 21.2252>, <-13.1255, 65.6861, 21.4877>, <-12.5632, 64.3957, 22.08272> }
					triangle { <-12.2987, 64.5281, 21.2252>, <-12.5632, 64.3957, 22.08272>, <-13.1255, 65.6861, 21.4877> }
					triangle { <-12.2987, 64.5281, 21.2252>, <-12.2944, 65.3801, 19.693>, <-13.1255, 65.6861, 21.4877> }
					triangle { <-12.2987, 64.5281, 21.2252>, <-13.1255, 65.6861, 21.4877>, <-12.2944, 65.3801, 19.693> }
					triangle { <-12.2944, 65.3801, 19.693>, <-11.691, 67.7454, 20.9784>, <-13.1255, 65.6861, 21.4877> }
					triangle { <-12.2944, 65.3801, 19.693>, <-13.1255, 65.6861, 21.4877>, <-11.691, 67.7454, 20.9784> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-10.1322, 58.1685, 14.1095>, <-10.2705, 57.7498, 16.8965>, <-10.4096, 60.6112, 16.169> }
					triangle { <-10.1322, 58.1685, 14.1095>, <-10.4096, 60.6112, 16.169>, <-10.2705, 57.7498, 16.8965> }
					triangle { <-10.2705, 57.7498, 16.8965>, <-11.9364, 58.3714, 18.7784>, <-10.4096, 60.6112, 16.169> }
					triangle { <-10.2705, 57.7498, 16.8965>, <-10.4096, 60.6112, 16.169>, <-11.9364, 58.3714, 18.7784> }
					triangle { <-11.9364, 58.3714, 18.7784>, <-13.4539, 60.6661, 20.8757>, <-11.9921, 60.9031, 20.7798> }
					triangle { <-11.9364, 58.3714, 18.7784>, <-11.9921, 60.9031, 20.7798>, <-13.4539, 60.6661, 20.8757> }
					triangle { <-11.9921, 60.9031, 20.7798>, <-10.9668, 61.8899, 19.5419>, <-11.9364, 58.3714, 18.7784> }
					triangle { <-11.9921, 60.9031, 20.7798>, <-11.9364, 58.3714, 18.7784>, <-10.9668, 61.8899, 19.5419> }
					triangle { <-11.9364, 58.3714, 18.7784>, <-10.9668, 61.8899, 19.5419>, <-10.4096, 60.6112, 16.169> }
					triangle { <-11.9364, 58.3714, 18.7784>, <-10.4096, 60.6112, 16.169>, <-10.9668, 61.8899, 19.5419> }
					triangle { <-10.4096, 60.6112, 16.169>, <-10.9668, 61.8899, 19.5419>, <-11.00349, 63.08742, 17.9052> }
					triangle { <-10.4096, 60.6112, 16.169>, <-11.00349, 63.08742, 17.9052>, <-10.9668, 61.8899, 19.5419> }
					triangle { <-10.9668, 61.8899, 19.5419>, <-11.179, 65.4125, 19.965>, <-11.00349, 63.08742, 17.9052> }
					triangle { <-10.9668, 61.8899, 19.5419>, <-11.00349, 63.08742, 17.9052>, <-11.179, 65.4125, 19.965> }
					triangle { <-11.9921, 60.9031, 20.7798>, <-12.5313, 63.1172, 22.323>, <-10.9668, 61.8899, 19.5419> }
					triangle { <-11.9921, 60.9031, 20.7798>, <-10.9668, 61.8899, 19.5419>, <-12.5313, 63.1172, 22.323> }
					triangle { <-10.9668, 61.8899, 19.5419>, <-12.5313, 63.1172, 22.323>, <-11.7498, 64.5114, 21.4034> }
					triangle { <-10.9668, 61.8899, 19.5419>, <-11.7498, 64.5114, 21.4034>, <-12.5313, 63.1172, 22.323> }
					triangle { <-11.7498, 64.5114, 21.4034>, <-11.179, 65.4125, 19.965>, <-10.9668, 61.8899, 19.5419> }
					triangle { <-11.7498, 64.5114, 21.4034>, <-10.9668, 61.8899, 19.5419>, <-11.179, 65.4125, 19.965> }
					triangle { <-13.4539, 60.6661, 20.8757>, <-12.5313, 63.1172, 22.323>, <-11.9921, 60.9031, 20.7798> }
					triangle { <-13.4539, 60.6661, 20.8757>, <-11.9921, 60.9031, 20.7798>, <-12.5313, 63.1172, 22.323> }
					triangle { <-12.5313, 63.1172, 22.323>, <-11.9862, 64.4124, 22.2234>, <-11.7498, 64.5114, 21.4034> }
					triangle { <-12.5313, 63.1172, 22.323>, <-11.7498, 64.5114, 21.4034>, <-11.9862, 64.4124, 22.2234> }
					triangle { <-11.9862, 64.4124, 22.2234>, <-11.2848, 65.7395, 21.9366>, <-11.7498, 64.5114, 21.4034> }
					triangle { <-11.9862, 64.4124, 22.2234>, <-11.7498, 64.5114, 21.4034>, <-11.2848, 65.7395, 21.9366> }
					triangle { <-11.2848, 65.7395, 21.9366>, <-11.179, 65.4125, 19.965>, <-11.7498, 64.5114, 21.4034> }
					triangle { <-11.2848, 65.7395, 21.9366>, <-11.7498, 64.5114, 21.4034>, <-11.179, 65.4125, 19.965> }
					triangle { <-11.2848, 65.7395, 21.9366>, <-12.4346, 67.7238, 20.797>, <-11.179, 65.4125, 19.965> }
					triangle { <-11.2848, 65.7395, 21.9366>, <-11.179, 65.4125, 19.965>, <-12.4346, 67.7238, 20.797> }
					triangle { <-10.4096, 60.6112, 16.169>, <-7.9218, 59.7772, 14.8082>, <-10.1322, 58.1685, 14.1095> }
					triangle { <-10.4096, 60.6112, 16.169>, <-10.1322, 58.1685, 14.1095>, <-7.9218, 59.7772, 14.8082> }
					triangle { <-10.4096, 60.6112, 16.169>, <-7.1263, 62.2164, 14.919>, <-7.9218, 59.7772, 14.8082> }
					triangle { <-10.4096, 60.6112, 16.169>, <-7.9218, 59.7772, 14.8082>, <-7.1263, 62.2164, 14.919> }
					triangle { <-7.7929, 64.6304, 16.9071>, <-7.7058, 65.5256, 15.904>, <-7.1263, 62.2164, 14.919> }
					triangle { <-7.7929, 64.6304, 16.9071>, <-7.1263, 62.2164, 14.919>, <-7.7058, 65.5256, 15.904> }
					triangle { <-7.1263, 62.2164, 14.919>, <-9.3672, 63.6805, 17.5632>, <-7.7929, 64.6304, 16.9071> }
					triangle { <-7.1263, 62.2164, 14.919>, <-7.7929, 64.6304, 16.9071>, <-9.3672, 63.6805, 17.5632> }
					triangle { <-10.4096, 60.6112, 16.169>, <-9.3672, 63.6805, 17.5632>, <-7.1263, 62.2164, 14.919> }
					triangle { <-10.4096, 60.6112, 16.169>, <-7.1263, 62.2164, 14.919>, <-9.3672, 63.6805, 17.5632> }
					triangle { <-11.00349, 63.08742, 17.9052>, <-9.3672, 63.6805, 17.5632>, <-10.4096, 60.6112, 16.169> }
					triangle { <-11.00349, 63.08742, 17.9052>, <-10.4096, 60.6112, 16.169>, <-9.3672, 63.6805, 17.5632> }
					triangle { <-11.00349, 63.08742, 17.9052>, <-11.179, 65.4125, 19.965>, <-9.3672, 63.6805, 17.5632> }
					triangle { <-11.00349, 63.08742, 17.9052>, <-9.3672, 63.6805, 17.5632>, <-11.179, 65.4125, 19.965> }
					triangle { <-9.3672, 63.6805, 17.5632>, <-8.2484, 66.8143, 18.515>, <-7.7929, 64.6304, 16.9071> }
					triangle { <-9.3672, 63.6805, 17.5632>, <-7.7929, 64.6304, 16.9071>, <-8.2484, 66.8143, 18.515> }
					triangle { <-9.7611, 66.3306, 19.4961>, <-8.2484, 66.8143, 18.515>, <-9.3672, 63.6805, 17.5632> }
					triangle { <-9.7611, 66.3306, 19.4961>, <-9.3672, 63.6805, 17.5632>, <-8.2484, 66.8143, 18.515> }
					triangle { <-9.3672, 63.6805, 17.5632>, <-11.179, 65.4125, 19.965>, <-9.7611, 66.3306, 19.4961> }
					triangle { <-9.3672, 63.6805, 17.5632>, <-9.7611, 66.3306, 19.4961>, <-11.179, 65.4125, 19.965> }
					triangle { <-7.7929, 64.6304, 16.9071>, <-8.2484, 66.8143, 18.515>, <-7.7058, 65.5256, 15.904> }
					triangle { <-7.7929, 64.6304, 16.9071>, <-7.7058, 65.5256, 15.904>, <-8.2484, 66.8143, 18.515> }
					triangle { <-9.7611, 66.3306, 19.4961>, <-9.08497, 66.9169, 19.6438>, <-8.2484, 66.8143, 18.515> }
					triangle { <-9.7611, 66.3306, 19.4961>, <-8.2484, 66.8143, 18.515>, <-9.08497, 66.9169, 19.6438> }
					triangle { <-9.7611, 66.3306, 19.4961>, <-10.04147, 66.8128, 20.831>, <-9.08497, 66.9169, 19.6438> }
					triangle { <-9.7611, 66.3306, 19.4961>, <-9.08497, 66.9169, 19.6438>, <-10.04147, 66.8128, 20.831> }
					triangle { <-9.7611, 66.3306, 19.4961>, <-11.179, 65.4125, 19.965>, <-10.04147, 66.8128, 20.831> }
					triangle { <-9.7611, 66.3306, 19.4961>, <-10.04147, 66.8128, 20.831>, <-11.179, 65.4125, 19.965> }
					triangle { <-11.179, 65.4125, 19.965>, <-12.4346, 67.7238, 20.797>, <-10.04147, 66.8128, 20.831> }
					triangle { <-11.179, 65.4125, 19.965>, <-10.04147, 66.8128, 20.831>, <-12.4346, 67.7238, 20.797> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <-6.4121, 39.3418, 9.7692>, <-5.642, 41.06448, 10.8457>, 0.4231 }
			cylinder { <-5.642, 41.06448, 10.8457>, <-4.8718, 42.787, 11.9222>, 0.4231 }
			cylinder { <-4.8718, 42.787, 11.9222>, <-4.1017, 44.5096, 12.9988>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-4.1017, 44.5096, 12.9988>, <-3.7619, 44.8204, 15.1218>, 0.4231 }
			cylinder { <-3.7619, 44.8204, 15.1218>, <-3.422, 45.1312, 17.2448>, 0.4231 }
			cylinder { <-3.422, 45.1312, 17.2448>, <-3.08221, 45.4419, 19.3678>, 0.4231 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-3.08221, 45.4419, 19.3678>, <-1.3902, 46.5924, 23.5492>, 0.4231 }
				cylinder { <-1.3902, 46.5924, 23.5492>, <1.164, 48.1584, 27.1121>, 0.4231 }
				cylinder { <1.164, 48.1584, 27.1121>, <4.4274, 50.0461, 29.8428>, 0.4231 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <4.4274, 50.0461, 29.8428>, <3.7198, 52.3067, 31.376>, <6.4509, 51.3428, 31.9662> }
					triangle { <4.4274, 50.0461, 29.8428>, <6.4509, 51.3428, 31.9662>, <3.7198, 52.3067, 31.376> }
					triangle { <3.7198, 52.3067, 31.376>, <4.7084, 54.6704, 31.7484>, <6.4509, 51.3428, 31.9662> }
					triangle { <3.7198, 52.3067, 31.376>, <6.4509, 51.3428, 31.9662>, <4.7084, 54.6704, 31.7484> }
					triangle { <4.7084, 54.6704, 31.7484>, <7.1089, 56.8076, 33.02781>, <6.7278, 55.7672, 34.01498> }
					triangle { <4.7084, 54.6704, 31.7484>, <6.7278, 55.7672, 34.01498>, <7.1089, 56.8076, 33.02781> }
					triangle { <6.7278, 55.7672, 34.01498>, <7.3613, 54.01125, 34.2842>, <4.7084, 54.6704, 31.7484> }
					triangle { <6.7278, 55.7672, 34.01498>, <4.7084, 54.6704, 31.7484>, <7.3613, 54.01125, 34.2842> }
					triangle { <4.7084, 54.6704, 31.7484>, <7.3613, 54.01125, 34.2842>, <6.4509, 51.3428, 31.9662> }
					triangle { <4.7084, 54.6704, 31.7484>, <6.4509, 51.3428, 31.9662>, <7.3613, 54.01125, 34.2842> }
					triangle { <6.4509, 51.3428, 31.9662>, <7.3613, 54.01125, 34.2842>, <8.6811, 52.5907, 33.6889> }
					triangle { <6.4509, 51.3428, 31.9662>, <8.6811, 52.5907, 33.6889>, <7.3613, 54.01125, 34.2842> }
					triangle { <7.3613, 54.01125, 34.2842>, <10.5565, 53.844, 35.8318>, <8.6811, 52.5907, 33.6889> }
					triangle { <7.3613, 54.01125, 34.2842>, <8.6811, 52.5907, 33.6889>, <10.5565, 53.844, 35.8318> }
					triangle { <6.7278, 55.7672, 34.01498>, <8.7266, 56.8813, 35.544>, <7.3613, 54.01125, 34.2842> }
					triangle { <6.7278, 55.7672, 34.01498>, <7.3613, 54.01125, 34.2842>, <8.7266, 56.8813, 35.544> }
					triangle { <7.3613, 54.01125, 34.2842>, <8.7266, 56.8813, 35.544>, <9.7832, 55.4478, 36.02239> }
					triangle { <7.3613, 54.01125, 34.2842>, <9.7832, 55.4478, 36.02239>, <8.7266, 56.8813, 35.544> }
					triangle { <9.7832, 55.4478, 36.02239>, <10.5565, 53.844, 35.8318>, <7.3613, 54.01125, 34.2842> }
					triangle { <9.7832, 55.4478, 36.02239>, <7.3613, 54.01125, 34.2842>, <10.5565, 53.844, 35.8318> }
					triangle { <7.1089, 56.8076, 33.02781>, <8.7266, 56.8813, 35.544>, <6.7278, 55.7672, 34.01498> }
					triangle { <7.1089, 56.8076, 33.02781>, <6.7278, 55.7672, 34.01498>, <8.7266, 56.8813, 35.544> }
					triangle { <8.7266, 56.8813, 35.544>, <9.6781, 56.2327, 36.3555>, <9.7832, 55.4478, 36.02239> }
					triangle { <8.7266, 56.8813, 35.544>, <9.7832, 55.4478, 36.02239>, <9.6781, 56.2327, 36.3555> }
					triangle { <9.6781, 56.2327, 36.3555>, <10.6193, 55.3384, 37.1614>, <9.7832, 55.4478, 36.02239> }
					triangle { <9.6781, 56.2327, 36.3555>, <9.7832, 55.4478, 36.02239>, <10.6193, 55.3384, 37.1614> }
					triangle { <10.6193, 55.3384, 37.1614>, <10.5565, 53.844, 35.8318>, <9.7832, 55.4478, 36.02239> }
					triangle { <10.6193, 55.3384, 37.1614>, <9.7832, 55.4478, 36.02239>, <10.5565, 53.844, 35.8318> }
					triangle { <10.6193, 55.3384, 37.1614>, <13.03971, 54.8592, 36.4754>, <10.5565, 53.844, 35.8318> }
					triangle { <10.6193, 55.3384, 37.1614>, <10.5565, 53.844, 35.8318>, <13.03971, 54.8592, 36.4754> }
					triangle { <6.4509, 51.3428, 31.9662>, <4.8573, 48.8881, 32.3798>, <4.4274, 50.0461, 29.8428> }
					triangle { <6.4509, 51.3428, 31.9662>, <4.4274, 50.0461, 29.8428>, <4.8573, 48.8881, 32.3798> }
					triangle { <6.4509, 51.3428, 31.9662>, <6.7035, 48.03778, 33.9491>, <4.8573, 48.8881, 32.3798> }
					triangle { <6.4509, 51.3428, 31.9662>, <4.8573, 48.8881, 32.3798>, <6.7035, 48.03778, 33.9491> }
					triangle { <8.8729, 49.5324, 35.7613>, <9.7813, 48.564, 35.5327>, <6.7035, 48.03778, 33.9491> }
					triangle { <8.8729, 49.5324, 35.7613>, <6.7035, 48.03778, 33.9491>, <9.7813, 48.564, 35.5327> }
					triangle { <6.7035, 48.03778, 33.9491>, <8.5818, 51.1917, 34.7746>, <8.8729, 49.5324, 35.7613> }
					triangle { <6.7035, 48.03778, 33.9491>, <8.8729, 49.5324, 35.7613>, <8.5818, 51.1917, 34.7746> }
					triangle { <6.4509, 51.3428, 31.9662>, <8.5818, 51.1917, 34.7746>, <6.7035, 48.03778, 33.9491> }
					triangle { <6.4509, 51.3428, 31.9662>, <6.7035, 48.03778, 33.9491>, <8.5818, 51.1917, 34.7746> }
					triangle { <8.6811, 52.5907, 33.6889>, <8.5818, 51.1917, 34.7746>, <6.4509, 51.3428, 31.9662> }
					triangle { <8.6811, 52.5907, 33.6889>, <6.4509, 51.3428, 31.9662>, <8.5818, 51.1917, 34.7746> }
					triangle { <8.6811, 52.5907, 33.6889>, <10.5565, 53.844, 35.8318>, <8.5818, 51.1917, 34.7746> }
					triangle { <8.6811, 52.5907, 33.6889>, <8.5818, 51.1917, 34.7746>, <10.5565, 53.844, 35.8318> }
					triangle { <8.5818, 51.1917, 34.7746>, <10.8008, 50.6475, 37.3744>, <8.8729, 49.5324, 35.7613> }
					triangle { <8.5818, 51.1917, 34.7746>, <8.8729, 49.5324, 35.7613>, <10.8008, 50.6475, 37.3744> }
					triangle { <10.8578, 52.4304, 36.824>, <10.8008, 50.6475, 37.3744>, <8.5818, 51.1917, 34.7746> }
					triangle { <10.8578, 52.4304, 36.824>, <8.5818, 51.1917, 34.7746>, <10.8008, 50.6475, 37.3744> }
					triangle { <8.5818, 51.1917, 34.7746>, <10.5565, 53.844, 35.8318>, <10.8578, 52.4304, 36.824> }
					triangle { <8.5818, 51.1917, 34.7746>, <10.8578, 52.4304, 36.824>, <10.5565, 53.844, 35.8318> }
					triangle { <8.8729, 49.5324, 35.7613>, <10.8008, 50.6475, 37.3744>, <9.7813, 48.564, 35.5327> }
					triangle { <8.8729, 49.5324, 35.7613>, <9.7813, 48.564, 35.5327>, <10.8008, 50.6475, 37.3744> }
					triangle { <10.8578, 52.4304, 36.824>, <11.08323, 52.00986, 37.5954>, <10.8008, 50.6475, 37.3744> }
					triangle { <10.8578, 52.4304, 36.824>, <10.8008, 50.6475, 37.3744>, <11.08323, 52.00986, 37.5954> }
					triangle { <10.8578, 52.4304, 36.824>, <11.2215, 53.5286, 37.6928>, <11.08323, 52.00986, 37.5954> }
					triangle { <10.8578, 52.4304, 36.824>, <11.08323, 52.00986, 37.5954>, <11.2215, 53.5286, 37.6928> }
					triangle { <10.8578, 52.4304, 36.824>, <10.5565, 53.844, 35.8318>, <11.2215, 53.5286, 37.6928> }
					triangle { <10.8578, 52.4304, 36.824>, <11.2215, 53.5286, 37.6928>, <10.5565, 53.844, 35.8318> }
					triangle { <10.5565, 53.844, 35.8318>, <13.03971, 54.8592, 36.4754>, <11.2215, 53.5286, 37.6928> }
					triangle { <10.5565, 53.844, 35.8318>, <11.2215, 53.5286, 37.6928>, <13.03971, 54.8592, 36.4754> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <4.4274, 50.0461, 29.8428>, <5.5449, 48.4345, 31.8716>, <6.856, 51.07563, 31.6668> }
					triangle { <4.4274, 50.0461, 29.8428>, <6.856, 51.07563, 31.6668>, <5.5449, 48.4345, 31.8716> }
					triangle { <5.5449, 48.4345, 31.8716>, <5.9397, 48.6788, 34.4187>, <6.856, 51.07563, 31.6668> }
					triangle { <5.5449, 48.4345, 31.8716>, <6.856, 51.07563, 31.6668>, <5.9397, 48.6788, 34.4187> }
					triangle { <5.9397, 48.6788, 34.4187>, <7.5708, 50.06812, 37.1347>, <8.5228, 49.7176, 36.0517> }
					triangle { <5.9397, 48.6788, 34.4187>, <8.5228, 49.7176, 36.0517>, <7.5708, 50.06812, 37.1347> }
					triangle { <8.5228, 49.7176, 36.0517>, <9.08674, 50.6757, 34.528>, <5.9397, 48.6788, 34.4187> }
					triangle { <8.5228, 49.7176, 36.0517>, <5.9397, 48.6788, 34.4187>, <9.08674, 50.6757, 34.528> }
					triangle { <5.9397, 48.6788, 34.4187>, <9.08674, 50.6757, 34.528>, <6.856, 51.07563, 31.6668> }
					triangle { <5.9397, 48.6788, 34.4187>, <6.856, 51.07563, 31.6668>, <9.08674, 50.6757, 34.528> }
					triangle { <6.856, 51.07563, 31.6668>, <9.08674, 50.6757, 34.528>, <8.9512, 52.4125, 33.4893> }
					triangle { <6.856, 51.07563, 31.6668>, <8.9512, 52.4125, 33.4893>, <9.08674, 50.6757, 34.528> }
					triangle { <9.08674, 50.6757, 34.528>, <11.3667, 53.3095, 35.2331>, <8.9512, 52.4125, 33.4893> }
					triangle { <9.08674, 50.6757, 34.528>, <8.9512, 52.4125, 33.4893>, <11.3667, 53.3095, 35.2331> }
					triangle { <8.5228, 49.7176, 36.0517>, <10.3866, 50.9208, 37.6806>, <9.08674, 50.6757, 34.528> }
					triangle { <8.5228, 49.7176, 36.0517>, <9.08674, 50.6757, 34.528>, <10.3866, 50.9208, 37.6806> }
					triangle { <9.08674, 50.6757, 34.528>, <10.3866, 50.9208, 37.6806>, <11.2267, 52.1412, 36.5829> }
					triangle { <9.08674, 50.6757, 34.528>, <11.2267, 52.1412, 36.5829>, <10.3866, 50.9208, 37.6806> }
					triangle { <11.2267, 52.1412, 36.5829>, <11.3667, 53.3095, 35.2331>, <9.08674, 50.6757, 34.528> }
					triangle { <11.2267, 52.1412, 36.5829>, <9.08674, 50.6757, 34.528>, <11.3667, 53.3095, 35.2331> }
					triangle { <7.5708, 50.06812, 37.1347>, <10.3866, 50.9208, 37.6806>, <8.5228, 49.7176, 36.0517> }
					triangle { <7.5708, 50.06812, 37.1347>, <8.5228, 49.7176, 36.0517>, <10.3866, 50.9208, 37.6806> }
					triangle { <10.3866, 50.9208, 37.6806>, <11.456, 51.7639, 37.3199>, <11.2267, 52.1412, 36.5829> }
					triangle { <10.3866, 50.9208, 37.6806>, <11.2267, 52.1412, 36.5829>, <11.456, 51.7639, 37.3199> }
					triangle { <11.456, 51.7639, 37.3199>, <12.5387, 52.6596, 36.7194>, <11.2267, 52.1412, 36.5829> }
					triangle { <11.456, 51.7639, 37.3199>, <11.2267, 52.1412, 36.5829>, <12.5387, 52.6596, 36.7194> }
					triangle { <12.5387, 52.6596, 36.7194>, <11.3667, 53.3095, 35.2331>, <11.2267, 52.1412, 36.5829> }
					triangle { <12.5387, 52.6596, 36.7194>, <11.2267, 52.1412, 36.5829>, <11.3667, 53.3095, 35.2331> }
					triangle { <12.5387, 52.6596, 36.7194>, <12.4995, 55.2155, 36.8746>, <11.3667, 53.3095, 35.2331> }
					triangle { <12.5387, 52.6596, 36.7194>, <11.3667, 53.3095, 35.2331>, <12.4995, 55.2155, 36.8746> }
					triangle { <6.856, 51.07563, 31.6668>, <7.08321, 50.08783, 28.8903>, <4.4274, 50.0461, 29.8428> }
					triangle { <6.856, 51.07563, 31.6668>, <4.4274, 50.0461, 29.8428>, <7.08321, 50.08783, 28.8903> }
					triangle { <6.856, 51.07563, 31.6668>, <9.118, 51.6241, 28.5843>, <7.08321, 50.08783, 28.8903> }
					triangle { <6.856, 51.07563, 31.6668>, <7.08321, 50.08783, 28.8903>, <9.118, 51.6241, 28.5843> }
					triangle { <11.2639, 52.8204, 30.631>, <11.3449, 53.9673, 29.9288>, <9.118, 51.6241, 28.5843> }
					triangle { <11.2639, 52.8204, 30.631>, <9.118, 51.6241, 28.5843>, <11.3449, 53.9673, 29.9288> }
					triangle { <9.118, 51.6241, 28.5843>, <10.09726, 52.3892, 32.1358>, <11.2639, 52.8204, 30.631> }
					triangle { <9.118, 51.6241, 28.5843>, <11.2639, 52.8204, 30.631>, <10.09726, 52.3892, 32.1358> }
					triangle { <6.856, 51.07563, 31.6668>, <10.09726, 52.3892, 32.1358>, <9.118, 51.6241, 28.5843> }
					triangle { <6.856, 51.07563, 31.6668>, <9.118, 51.6241, 28.5843>, <10.09726, 52.3892, 32.1358> }
					triangle { <8.9512, 52.4125, 33.4893>, <10.09726, 52.3892, 32.1358>, <6.856, 51.07563, 31.6668> }
					triangle { <8.9512, 52.4125, 33.4893>, <6.856, 51.07563, 31.6668>, <10.09726, 52.3892, 32.1358> }
					triangle { <8.9512, 52.4125, 33.4893>, <11.3667, 53.3095, 35.2331>, <10.09726, 52.3892, 32.1358> }
					triangle { <8.9512, 52.4125, 33.4893>, <10.09726, 52.3892, 32.1358>, <11.3667, 53.3095, 35.2331> }
					triangle { <10.09726, 52.3892, 32.1358>, <13.1917, 53.9355, 32.2441>, <11.2639, 52.8204, 30.631> }
					triangle { <10.09726, 52.3892, 32.1358>, <11.2639, 52.8204, 30.631>, <13.1917, 53.9355, 32.2441> }
					triangle { <12.52, 53.688, 33.9681>, <13.1917, 53.9355, 32.2441>, <10.09726, 52.3892, 32.1358> }
					triangle { <12.52, 53.688, 33.9681>, <10.09726, 52.3892, 32.1358>, <13.1917, 53.9355, 32.2441> }
					triangle { <10.09726, 52.3892, 32.1358>, <11.3667, 53.3095, 35.2331>, <12.52, 53.688, 33.9681> }
					triangle { <10.09726, 52.3892, 32.1358>, <12.52, 53.688, 33.9681>, <11.3667, 53.3095, 35.2331> }
					triangle { <11.2639, 52.8204, 30.631>, <13.1917, 53.9355, 32.2441>, <11.3449, 53.9673, 29.9288> }
					triangle { <11.2639, 52.8204, 30.631>, <11.3449, 53.9673, 29.9288>, <13.1917, 53.9355, 32.2441> }
					triangle { <12.52, 53.688, 33.9681>, <13.3562, 53.8061, 33.6372>, <13.1917, 53.9355, 32.2441> }
					triangle { <12.52, 53.688, 33.9681>, <13.1917, 53.9355, 32.2441>, <13.3562, 53.8061, 33.6372> }
					triangle { <12.52, 53.688, 33.9681>, <13.3531, 53.5349, 35.1411>, <13.3562, 53.8061, 33.6372> }
					triangle { <12.52, 53.688, 33.9681>, <13.3562, 53.8061, 33.6372>, <13.3531, 53.5349, 35.1411> }
					triangle { <12.52, 53.688, 33.9681>, <11.3667, 53.3095, 35.2331>, <13.3531, 53.5349, 35.1411> }
					triangle { <12.52, 53.688, 33.9681>, <13.3531, 53.5349, 35.1411>, <11.3667, 53.3095, 35.2331> }
					triangle { <11.3667, 53.3095, 35.2331>, <12.4995, 55.2155, 36.8746>, <13.3531, 53.5349, 35.1411> }
					triangle { <11.3667, 53.3095, 35.2331>, <13.3531, 53.5349, 35.1411>, <12.4995, 55.2155, 36.8746> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <4.4274, 50.0461, 29.8428>, <6.7706, 51.02732, 28.6145>, <6.6814, 51.6005, 31.5127> }
					triangle { <4.4274, 50.0461, 29.8428>, <6.6814, 51.6005, 31.5127>, <6.7706, 51.02732, 28.6145> }
					triangle { <6.7706, 51.02732, 28.6145>, <9.3155, 50.7169, 28.9755>, <6.6814, 51.6005, 31.5127> }
					triangle { <6.7706, 51.02732, 28.6145>, <6.6814, 51.6005, 31.5127>, <9.3155, 50.7169, 28.9755> }
					triangle { <9.3155, 50.7169, 28.9755>, <12.2254, 51.2163, 30.7782>, <11.4188, 52.4592, 30.6954> }
					triangle { <9.3155, 50.7169, 28.9755>, <11.4188, 52.4592, 30.6954>, <12.2254, 51.2163, 30.7782> }
					triangle { <11.4188, 52.4592, 30.6954>, <10.00025, 53.09909, 31.761>, <9.3155, 50.7169, 28.9755> }
					triangle { <11.4188, 52.4592, 30.6954>, <9.3155, 50.7169, 28.9755>, <10.00025, 53.09909, 31.761> }
					triangle { <9.3155, 50.7169, 28.9755>, <10.00025, 53.09909, 31.761>, <6.6814, 51.6005, 31.5127> }
					triangle { <9.3155, 50.7169, 28.9755>, <6.6814, 51.6005, 31.5127>, <10.00025, 53.09909, 31.761> }
					triangle { <6.6814, 51.6005, 31.5127>, <10.00025, 53.09909, 31.761>, <8.8347, 52.7625, 33.3865> }
					triangle { <6.6814, 51.6005, 31.5127>, <8.8347, 52.7625, 33.3865>, <10.00025, 53.09909, 31.761> }
					triangle { <10.00025, 53.09909, 31.761>, <11.01744, 54.3592, 34.9248>, <8.8347, 52.7625, 33.3865> }
					triangle { <10.00025, 53.09909, 31.761>, <8.8347, 52.7625, 33.3865>, <11.01744, 54.3592, 34.9248> }
					triangle { <11.4188, 52.4592, 30.6954>, <13.3409, 53.4874, 32.3757>, <10.00025, 53.09909, 31.761> }
					triangle { <11.4188, 52.4592, 30.6954>, <10.00025, 53.09909, 31.761>, <13.3409, 53.4874, 32.3757> }
					triangle { <10.00025, 53.09909, 31.761>, <13.3409, 53.4874, 32.3757>, <12.3802, 54.2128, 33.7724> }
					triangle { <10.00025, 53.09909, 31.761>, <12.3802, 54.2128, 33.7724>, <13.3409, 53.4874, 32.3757> }
					triangle { <12.3802, 54.2128, 33.7724>, <11.01744, 54.3592, 34.9248>, <10.00025, 53.09909, 31.761> }
					triangle { <12.3802, 54.2128, 33.7724>, <10.00025, 53.09909, 31.761>, <11.01744, 54.3592, 34.9248> }
					triangle { <12.2254, 51.2163, 30.7782>, <13.3409, 53.4874, 32.3757>, <11.4188, 52.4592, 30.6954> }
					triangle { <12.2254, 51.2163, 30.7782>, <11.4188, 52.4592, 30.6954>, <13.3409, 53.4874, 32.3757> }
					triangle { <13.3409, 53.4874, 32.3757>, <13.1755, 54.3492, 33.4777>, <12.3802, 54.2128, 33.7724> }
					triangle { <13.3409, 53.4874, 32.3757>, <12.3802, 54.2128, 33.7724>, <13.1755, 54.3492, 33.4777> }
					triangle { <13.1755, 54.3492, 33.4777>, <12.7767, 55.2673, 34.6324>, <12.3802, 54.2128, 33.7724> }
					triangle { <13.1755, 54.3492, 33.4777>, <12.3802, 54.2128, 33.7724>, <12.7767, 55.2673, 34.6324> }
					triangle { <12.7767, 55.2673, 34.6324>, <11.01744, 54.3592, 34.9248>, <12.3802, 54.2128, 33.7724> }
					triangle { <12.7767, 55.2673, 34.6324>, <12.3802, 54.2128, 33.7724>, <11.01744, 54.3592, 34.9248> }
					triangle { <12.7767, 55.2673, 34.6324>, <12.7324, 54.5156, 37.08012>, <11.01744, 54.3592, 34.9248> }
					triangle { <12.7767, 55.2673, 34.6324>, <11.01744, 54.3592, 34.9248>, <12.7324, 54.5156, 37.08012> }
					triangle { <6.6814, 51.6005, 31.5127>, <4.111, 52.744, 30.6062>, <4.4274, 50.0461, 29.8428> }
					triangle { <6.6814, 51.6005, 31.5127>, <4.4274, 50.0461, 29.8428>, <4.111, 52.744, 30.6062> }
					triangle { <6.6814, 51.6005, 31.5127>, <4.1703, 54.3101, 32.6405>, <4.111, 52.744, 30.6062> }
					triangle { <6.6814, 51.6005, 31.5127>, <4.111, 52.744, 30.6062>, <4.1703, 54.3101, 32.6405> }
					triangle { <6.5631, 55.5027, 34.3946>, <5.817, 55.4436, 35.5147>, <4.1703, 54.3101, 32.6405> }
					triangle { <6.5631, 55.5027, 34.3946>, <4.1703, 54.3101, 32.6405>, <5.817, 55.4436, 35.5147> }
					triangle { <4.1703, 54.3101, 32.6405>, <7.7865, 54.165, 33.6697>, <6.5631, 55.5027, 34.3946> }
					triangle { <4.1703, 54.3101, 32.6405>, <6.5631, 55.5027, 34.3946>, <7.7865, 54.165, 33.6697> }
					triangle { <6.6814, 51.6005, 31.5127>, <7.7865, 54.165, 33.6697>, <4.1703, 54.3101, 32.6405> }
					triangle { <6.6814, 51.6005, 31.5127>, <4.1703, 54.3101, 32.6405>, <7.7865, 54.165, 33.6697> }
					triangle { <8.8347, 52.7625, 33.3865>, <7.7865, 54.165, 33.6697>, <6.6814, 51.6005, 31.5127> }
					triangle { <8.8347, 52.7625, 33.3865>, <6.6814, 51.6005, 31.5127>, <7.7865, 54.165, 33.6697> }
					triangle { <8.8347, 52.7625, 33.3865>, <11.01744, 54.3592, 34.9248>, <7.7865, 54.165, 33.6697> }
					triangle { <8.8347, 52.7625, 33.3865>, <7.7865, 54.165, 33.6697>, <11.01744, 54.3592, 34.9248> }
					triangle { <7.7865, 54.165, 33.6697>, <8.491, 56.6178, 36.00777>, <6.5631, 55.5027, 34.3946> }
					triangle { <7.7865, 54.165, 33.6697>, <6.5631, 55.5027, 34.3946>, <8.491, 56.6178, 36.00777> }
					triangle { <10.02763, 55.6406, 35.597>, <8.491, 56.6178, 36.00777>, <7.7865, 54.165, 33.6697> }
					triangle { <10.02763, 55.6406, 35.597>, <7.7865, 54.165, 33.6697>, <8.491, 56.6178, 36.00777> }
					triangle { <7.7865, 54.165, 33.6697>, <11.01744, 54.3592, 34.9248>, <10.02763, 55.6406, 35.597> }
					triangle { <7.7865, 54.165, 33.6697>, <10.02763, 55.6406, 35.597>, <11.01744, 54.3592, 34.9248> }
					triangle { <6.5631, 55.5027, 34.3946>, <8.491, 56.6178, 36.00777>, <5.817, 55.4436, 35.5147> }
					triangle { <6.5631, 55.5027, 34.3946>, <5.817, 55.4436, 35.5147>, <8.491, 56.6178, 36.00777> }
					triangle { <10.02763, 55.6406, 35.597>, <9.8902, 56.4698, 35.9381>, <8.491, 56.6178, 36.00777> }
					triangle { <10.02763, 55.6406, 35.597>, <8.491, 56.6178, 36.00777>, <9.8902, 56.4698, 35.9381> }
					triangle { <10.02763, 55.6406, 35.597>, <11.3686, 56.1761, 35.6868>, <9.8902, 56.4698, 35.9381> }
					triangle { <10.02763, 55.6406, 35.597>, <9.8902, 56.4698, 35.9381>, <11.3686, 56.1761, 35.6868> }
					triangle { <10.02763, 55.6406, 35.597>, <11.01744, 54.3592, 34.9248>, <11.3686, 56.1761, 35.6868> }
					triangle { <10.02763, 55.6406, 35.597>, <11.3686, 56.1761, 35.6868>, <11.01744, 54.3592, 34.9248> }
					triangle { <11.01744, 54.3592, 34.9248>, <12.7324, 54.5156, 37.08012>, <11.3686, 56.1761, 35.6868> }
					triangle { <11.01744, 54.3592, 34.9248>, <11.3686, 56.1761, 35.6868>, <12.7324, 54.5156, 37.08012> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <-9.1669, 26.2655, 2.273>, <-14.106, 33.3889, 4.9489>, 0.4123 }
			cylinder { <-14.106, 33.3889, 4.9489>, <-19.04515, 40.5123, 7.6249>, 0.4123 }
			cylinder { <-19.04515, 40.5123, 7.6249>, <-23.9842, 47.6357, 10.3008>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-23.9842, 47.6357, 10.3008>, <-25.1367, 49.2979, 10.9252>, 0.4123 }
			cylinder { <-25.1367, 49.2979, 10.9252>, <-26.2891, 50.96, 11.5496>, 0.4123 }
			cylinder { <-26.2891, 50.96, 11.5496>, <-27.4416, 52.6221, 12.174>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-27.4416, 52.6221, 12.174>, <-28.3688, 53.04293, 14.02981>, 0.4123 }
			cylinder { <-28.3688, 53.04293, 14.02981>, <-29.296, 53.4637, 15.8855>, 0.4123 }
			cylinder { <-29.296, 53.4637, 15.8855>, <-30.2232, 53.8844, 17.7413>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-30.2232, 53.8844, 17.7413>, <-31.8136, 55.8061, 21.5298>, 0.4123 }
				cylinder { <-31.8136, 55.8061, 21.5298>, <-32.9121, 58.6327, 24.903>, 0.4123 }
				cylinder { <-32.9121, 58.6327, 24.903>, <-33.4529, 62.1947, 27.6587>, 0.4123 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-33.4529, 62.1947, 27.6587>, <-36.07431, 63.1482, 28.08449>, <-34.07335, 64.5396, 29.7567> }
					triangle { <-33.4529, 62.1947, 27.6587>, <-34.07335, 64.5396, 29.7567>, <-36.07431, 63.1482, 28.08449> }
					triangle { <-36.07431, 63.1482, 28.08449>, <-37.2467, 65.4529, 27.9533>, <-34.07335, 64.5396, 29.7567> }
					triangle { <-36.07431, 63.1482, 28.08449>, <-34.07335, 64.5396, 29.7567>, <-37.2467, 65.4529, 27.9533> }
					triangle { <-37.2467, 65.4529, 27.9533>, <-37.8349, 68.6495, 29.1379>, <-37.7984, 67.6599, 30.2431> }
					triangle { <-37.2467, 65.4529, 27.9533>, <-37.7984, 67.6599, 30.2431>, <-37.8349, 68.6495, 29.1379> }
					triangle { <-37.7984, 67.6599, 30.2431>, <-36.3614, 66.9621, 31.246>, <-37.2467, 65.4529, 27.9533> }
					triangle { <-37.7984, 67.6599, 30.2431>, <-37.2467, 65.4529, 27.9533>, <-36.3614, 66.9621, 31.246> }
					triangle { <-37.2467, 65.4529, 27.9533>, <-36.3614, 66.9621, 31.246>, <-34.07335, 64.5396, 29.7567> }
					triangle { <-37.2467, 65.4529, 27.9533>, <-34.07335, 64.5396, 29.7567>, <-36.3614, 66.9621, 31.246> }
					triangle { <-34.07335, 64.5396, 29.7567>, <-36.3614, 66.9621, 31.246>, <-34.3605, 67.01176, 31.5746> }
					triangle { <-34.07335, 64.5396, 29.7567>, <-34.3605, 67.01176, 31.5746>, <-36.3614, 66.9621, 31.246> }
					triangle { <-36.3614, 66.9621, 31.246>, <-35.04782, 69.2168, 33.6592>, <-34.3605, 67.01176, 31.5746> }
					triangle { <-36.3614, 66.9621, 31.246>, <-34.3605, 67.01176, 31.5746>, <-35.04782, 69.2168, 33.6592> }
					triangle { <-37.7984, 67.6599, 30.2431>, <-38.04632, 69.8728, 31.8605>, <-36.3614, 66.9621, 31.246> }
					triangle { <-37.7984, 67.6599, 30.2431>, <-36.3614, 66.9621, 31.246>, <-38.04632, 69.8728, 31.8605> }
					triangle { <-36.3614, 66.9621, 31.246>, <-38.04632, 69.8728, 31.8605>, <-36.6692, 69.7027, 33.07497> }
					triangle { <-36.3614, 66.9621, 31.246>, <-36.6692, 69.7027, 33.07497>, <-38.04632, 69.8728, 31.8605> }
					triangle { <-36.6692, 69.7027, 33.07497>, <-35.04782, 69.2168, 33.6592>, <-36.3614, 66.9621, 31.246> }
					triangle { <-36.6692, 69.7027, 33.07497>, <-36.3614, 66.9621, 31.246>, <-35.04782, 69.2168, 33.6592> }
					triangle { <-37.8349, 68.6495, 29.1379>, <-38.04632, 69.8728, 31.8605>, <-37.7984, 67.6599, 30.2431> }
					triangle { <-37.8349, 68.6495, 29.1379>, <-37.7984, 67.6599, 30.2431>, <-38.04632, 69.8728, 31.8605> }
					triangle { <-38.04632, 69.8728, 31.8605>, <-37.4078, 70.1414, 33.08714>, <-36.6692, 69.7027, 33.07497> }
					triangle { <-38.04632, 69.8728, 31.8605>, <-36.6692, 69.7027, 33.07497>, <-37.4078, 70.1414, 33.08714> }
					triangle { <-37.4078, 70.1414, 33.08714>, <-36.6074, 70.2392, 34.3853>, <-36.6692, 69.7027, 33.07497> }
					triangle { <-37.4078, 70.1414, 33.08714>, <-36.6692, 69.7027, 33.07497>, <-36.6074, 70.2392, 34.3853> }
					triangle { <-36.6074, 70.2392, 34.3853>, <-35.04782, 69.2168, 33.6592>, <-36.6692, 69.7027, 33.07497> }
					triangle { <-36.6074, 70.2392, 34.3853>, <-36.6692, 69.7027, 33.07497>, <-35.04782, 69.2168, 33.6592> }
					triangle { <-36.6074, 70.2392, 34.3853>, <-34.5494, 71.7377, 34.6628>, <-35.04782, 69.2168, 33.6592> }
					triangle { <-36.6074, 70.2392, 34.3853>, <-35.04782, 69.2168, 33.6592>, <-34.5494, 71.7377, 34.6628> }
					triangle { <-34.07335, 64.5396, 29.7567>, <-33.5466, 61.7119, 30.4371>, <-33.4529, 62.1947, 27.6587> }
					triangle { <-34.07335, 64.5396, 29.7567>, <-33.4529, 62.1947, 27.6587>, <-33.5466, 61.7119, 30.4371> }
					triangle { <-34.07335, 64.5396, 29.7567>, <-32.58, 62.5045, 32.6804>, <-33.5466, 61.7119, 30.4371> }
					triangle { <-34.07335, 64.5396, 29.7567>, <-33.5466, 61.7119, 30.4371>, <-32.58, 62.5045, 32.6804> }
					triangle { <-33.109, 65.09411, 34.48>, <-31.8187, 65.1319, 34.8654>, <-32.58, 62.5045, 32.6804> }
					triangle { <-33.109, 65.09411, 34.48>, <-32.58, 62.5045, 32.6804>, <-31.8187, 65.1319, 34.8654> }
					triangle { <-32.58, 62.5045, 32.6804>, <-33.9597, 65.9929, 32.9701>, <-33.109, 65.09411, 34.48> }
					triangle { <-32.58, 62.5045, 32.6804>, <-33.109, 65.09411, 34.48>, <-33.9597, 65.9929, 32.9701> }
					triangle { <-34.07335, 64.5396, 29.7567>, <-33.9597, 65.9929, 32.9701>, <-32.58, 62.5045, 32.6804> }
					triangle { <-34.07335, 64.5396, 29.7567>, <-32.58, 62.5045, 32.6804>, <-33.9597, 65.9929, 32.9701> }
					triangle { <-34.3605, 67.01176, 31.5746>, <-33.9597, 65.9929, 32.9701>, <-34.07335, 64.5396, 29.7567> }
					triangle { <-34.3605, 67.01176, 31.5746>, <-34.07335, 64.5396, 29.7567>, <-33.9597, 65.9929, 32.9701> }
					triangle { <-34.3605, 67.01176, 31.5746>, <-35.04782, 69.2168, 33.6592>, <-33.9597, 65.9929, 32.9701> }
					triangle { <-34.3605, 67.01176, 31.5746>, <-33.9597, 65.9929, 32.9701>, <-35.04782, 69.2168, 33.6592> }
					triangle { <-33.9597, 65.9929, 32.9701>, <-33.4369, 67.2536, 36.1507>, <-33.109, 65.09411, 34.48> }
					triangle { <-33.9597, 65.9929, 32.9701>, <-33.109, 65.09411, 34.48>, <-33.4369, 67.2536, 36.1507> }
					triangle { <-34.3589, 68.4888, 35.09754>, <-33.4369, 67.2536, 36.1507>, <-33.9597, 65.9929, 32.9701> }
					triangle { <-34.3589, 68.4888, 35.09754>, <-33.9597, 65.9929, 32.9701>, <-33.4369, 67.2536, 36.1507> }
					triangle { <-33.9597, 65.9929, 32.9701>, <-35.04782, 69.2168, 33.6592>, <-34.3589, 68.4888, 35.09754> }
					triangle { <-33.9597, 65.9929, 32.9701>, <-34.3589, 68.4888, 35.09754>, <-35.04782, 69.2168, 33.6592> }
					triangle { <-33.109, 65.09411, 34.48>, <-33.4369, 67.2536, 36.1507>, <-31.8187, 65.1319, 34.8654> }
					triangle { <-33.109, 65.09411, 34.48>, <-31.8187, 65.1319, 34.8654>, <-33.4369, 67.2536, 36.1507> }
					triangle { <-34.3589, 68.4888, 35.09754>, <-34.2853, 68.3671, 35.9934>, <-33.4369, 67.2536, 36.1507> }
					triangle { <-34.3589, 68.4888, 35.09754>, <-33.4369, 67.2536, 36.1507>, <-34.2853, 68.3671, 35.9934> }
					triangle { <-34.3589, 68.4888, 35.09754>, <-35.2692, 69.4788, 35.6308>, <-34.2853, 68.3671, 35.9934> }
					triangle { <-34.3589, 68.4888, 35.09754>, <-34.2853, 68.3671, 35.9934>, <-35.2692, 69.4788, 35.6308> }
					triangle { <-34.3589, 68.4888, 35.09754>, <-35.04782, 69.2168, 33.6592>, <-35.2692, 69.4788, 35.6308> }
					triangle { <-34.3589, 68.4888, 35.09754>, <-35.2692, 69.4788, 35.6308>, <-35.04782, 69.2168, 33.6592> }
					triangle { <-35.04782, 69.2168, 33.6592>, <-34.5494, 71.7377, 34.6628>, <-35.2692, 69.4788, 35.6308> }
					triangle { <-35.04782, 69.2168, 33.6592>, <-35.2692, 69.4788, 35.6308>, <-34.5494, 71.7377, 34.6628> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-33.4529, 62.1947, 27.6587>, <-32.609, 61.9308, 30.3382>, <-33.5209, 64.6685, 29.6984> }
					triangle { <-33.4529, 62.1947, 27.6587>, <-33.5209, 64.6685, 29.6984>, <-32.609, 61.9308, 30.3382> }
					triangle { <-32.609, 61.9308, 30.3382>, <-33.6718, 62.3538, 32.6609>, <-33.5209, 64.6685, 29.6984> }
					triangle { <-32.609, 61.9308, 30.3382>, <-33.5209, 64.6685, 29.6984>, <-33.6718, 62.3538, 32.6609> }
					triangle { <-33.6718, 62.3538, 32.6609>, <-34.8496, 64.459, 35.1404>, <-33.5697, 64.9518, 34.5735> }
					triangle { <-33.6718, 62.3538, 32.6609>, <-33.5697, 64.9518, 34.5735>, <-34.8496, 64.459, 35.1404> }
					triangle { <-33.5697, 64.9518, 34.5735>, <-33.2044, 66.0304, 33.07003>, <-33.6718, 62.3538, 32.6609> }
					triangle { <-33.5697, 64.9518, 34.5735>, <-33.6718, 62.3538, 32.6609>, <-33.2044, 66.0304, 33.07003> }
					triangle { <-33.6718, 62.3538, 32.6609>, <-33.2044, 66.0304, 33.07003>, <-33.5209, 64.6685, 29.6984> }
					triangle { <-33.6718, 62.3538, 32.6609>, <-33.5209, 64.6685, 29.6984>, <-33.2044, 66.0304, 33.07003> }
					triangle { <-33.5209, 64.6685, 29.6984>, <-33.2044, 66.0304, 33.07003>, <-33.9923, 67.09773, 31.5357> }
					triangle { <-33.5209, 64.6685, 29.6984>, <-33.9923, 67.09773, 31.5357>, <-33.2044, 66.0304, 33.07003> }
					triangle { <-33.2044, 66.0304, 33.07003>, <-33.943, 69.4747, 33.5426>, <-33.9923, 67.09773, 31.5357> }
					triangle { <-33.2044, 66.0304, 33.07003>, <-33.9923, 67.09773, 31.5357>, <-33.943, 69.4747, 33.5426> }
					triangle { <-33.5697, 64.9518, 34.5735>, <-34.00174, 67.1218, 36.2103>, <-33.2044, 66.0304, 33.07003> }
					triangle { <-33.5697, 64.9518, 34.5735>, <-33.2044, 66.0304, 33.07003>, <-34.00174, 67.1218, 36.2103> }
					triangle { <-33.2044, 66.0304, 33.07003>, <-34.00174, 67.1218, 36.2103>, <-33.839, 68.5754, 35.08758> }
					triangle { <-33.2044, 66.0304, 33.07003>, <-33.839, 68.5754, 35.08758>, <-34.00174, 67.1218, 36.2103> }
					triangle { <-33.839, 68.5754, 35.08758>, <-33.943, 69.4747, 33.5426>, <-33.2044, 66.0304, 33.07003> }
					triangle { <-33.839, 68.5754, 35.08758>, <-33.2044, 66.0304, 33.07003>, <-33.943, 69.4747, 33.5426> }
					triangle { <-34.8496, 64.459, 35.1404>, <-34.00174, 67.1218, 36.2103>, <-33.5697, 64.9518, 34.5735> }
					triangle { <-34.8496, 64.459, 35.1404>, <-33.5697, 64.9518, 34.5735>, <-34.00174, 67.1218, 36.2103> }
					triangle { <-34.00174, 67.1218, 36.2103>, <-33.7769, 68.4858, 35.9397>, <-33.839, 68.5754, 35.08758> }
					triangle { <-34.00174, 67.1218, 36.2103>, <-33.839, 68.5754, 35.08758>, <-33.7769, 68.4858, 35.9397> }
					triangle { <-33.7769, 68.4858, 35.9397>, <-33.4731, 69.8981, 35.4413>, <-33.839, 68.5754, 35.08758> }
					triangle { <-33.7769, 68.4858, 35.9397>, <-33.839, 68.5754, 35.08758>, <-33.4731, 69.8981, 35.4413> }
					triangle { <-33.4731, 69.8981, 35.4413>, <-33.943, 69.4747, 33.5426>, <-33.839, 68.5754, 35.08758> }
					triangle { <-33.4731, 69.8981, 35.4413>, <-33.839, 68.5754, 35.08758>, <-33.943, 69.4747, 33.5426> }
					triangle { <-33.4731, 69.8981, 35.4413>, <-35.2859, 71.5658, 34.7405>, <-33.943, 69.4747, 33.5426> }
					triangle { <-33.4731, 69.8981, 35.4413>, <-33.943, 69.4747, 33.5426>, <-35.2859, 71.5658, 34.7405> }
					triangle { <-33.5209, 64.6685, 29.6984>, <-31.4881, 64.219, 27.6004>, <-33.4529, 62.1947, 27.6587> }
					triangle { <-33.5209, 64.6685, 29.6984>, <-33.4529, 62.1947, 27.6587>, <-31.4881, 64.219, 27.6004> }
					triangle { <-33.5209, 64.6685, 29.6984>, <-31.1835, 66.7643, 27.4482>, <-31.4881, 64.219, 27.6004> }
					triangle { <-33.5209, 64.6685, 29.6984>, <-31.4881, 64.219, 27.6004>, <-31.1835, 66.7643, 27.4482> }
					triangle { <-31.6298, 69.1348, 29.5472>, <-32.04216, 69.9672, 28.5714>, <-31.1835, 66.7643, 27.4482> }
					triangle { <-31.6298, 69.1348, 29.5472>, <-31.1835, 66.7643, 27.4482>, <-32.04216, 69.9672, 28.5714> }
					triangle { <-31.1835, 66.7643, 27.4482>, <-32.6978, 67.9565, 30.6797>, <-31.6298, 69.1348, 29.5472> }
					triangle { <-31.1835, 66.7643, 27.4482>, <-31.6298, 69.1348, 29.5472>, <-32.6978, 67.9565, 30.6797> }
					triangle { <-33.5209, 64.6685, 29.6984>, <-32.6978, 67.9565, 30.6797>, <-31.1835, 66.7643, 27.4482> }
					triangle { <-33.5209, 64.6685, 29.6984>, <-31.1835, 66.7643, 27.4482>, <-32.6978, 67.9565, 30.6797> }
					triangle { <-33.9923, 67.09773, 31.5357>, <-32.6978, 67.9565, 30.6797>, <-33.5209, 64.6685, 29.6984> }
					triangle { <-33.9923, 67.09773, 31.5357>, <-33.5209, 64.6685, 29.6984>, <-32.6978, 67.9565, 30.6797> }
					triangle { <-33.9923, 67.09773, 31.5357>, <-33.943, 69.4747, 33.5426>, <-32.6978, 67.9565, 30.6797> }
					triangle { <-33.9923, 67.09773, 31.5357>, <-32.6978, 67.9565, 30.6797>, <-33.943, 69.4747, 33.5426> }
					triangle { <-32.6978, 67.9565, 30.6797>, <-31.9577, 71.2944, 31.2179>, <-31.6298, 69.1348, 29.5472> }
					triangle { <-32.6978, 67.9565, 30.6797>, <-31.6298, 69.1348, 29.5472>, <-31.9577, 71.2944, 31.2179> }
					triangle { <-32.9541, 70.6048, 32.638>, <-31.9577, 71.2944, 31.2179>, <-32.6978, 67.9565, 30.6797> }
					triangle { <-32.9541, 70.6048, 32.638>, <-32.6978, 67.9565, 30.6797>, <-31.9577, 71.2944, 31.2179> }
					triangle { <-32.6978, 67.9565, 30.6797>, <-33.943, 69.4747, 33.5426>, <-32.9541, 70.6048, 32.638> }
					triangle { <-32.6978, 67.9565, 30.6797>, <-32.9541, 70.6048, 32.638>, <-33.943, 69.4747, 33.5426> }
					triangle { <-31.6298, 69.1348, 29.5472>, <-31.9577, 71.2944, 31.2179>, <-32.04216, 69.9672, 28.5714> }
					triangle { <-31.6298, 69.1348, 29.5472>, <-32.04216, 69.9672, 28.5714>, <-31.9577, 71.2944, 31.2179> }
					triangle { <-32.9541, 70.6048, 32.638>, <-32.3923, 71.3124, 32.5578>, <-31.9577, 71.2944, 31.2179> }
					triangle { <-32.9541, 70.6048, 32.638>, <-31.9577, 71.2944, 31.2179>, <-32.3923, 71.3124, 32.5578> }
					triangle { <-32.9541, 70.6048, 32.638>, <-32.8797, 71.1095, 33.9918>, <-32.3923, 71.3124, 32.5578> }
					triangle { <-32.9541, 70.6048, 32.638>, <-32.3923, 71.3124, 32.5578>, <-32.8797, 71.1095, 33.9918> }
					triangle { <-32.9541, 70.6048, 32.638>, <-33.943, 69.4747, 33.5426>, <-32.8797, 71.1095, 33.9918> }
					triangle { <-32.9541, 70.6048, 32.638>, <-32.8797, 71.1095, 33.9918>, <-33.943, 69.4747, 33.5426> }
					triangle { <-33.943, 69.4747, 33.5426>, <-35.2859, 71.5658, 34.7405>, <-32.8797, 71.1095, 33.9918> }
					triangle { <-33.943, 69.4747, 33.5426>, <-32.8797, 71.1095, 33.9918>, <-35.2859, 71.5658, 34.7405> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-33.4529, 62.1947, 27.6587>, <-32.1827, 64.6138, 26.9538>, <-33.909, 64.8891, 29.3372> }
					triangle { <-33.4529, 62.1947, 27.6587>, <-33.909, 64.8891, 29.3372>, <-32.1827, 64.6138, 26.9538> }
					triangle { <-32.1827, 64.6138, 26.9538>, <-30.6299, 66.3035, 28.1525>, <-33.909, 64.8891, 29.3372> }
					triangle { <-32.1827, 64.6138, 26.9538>, <-33.909, 64.8891, 29.3372>, <-30.6299, 66.3035, 28.1525> }
					triangle { <-30.6299, 66.3035, 28.1525>, <-30.04706, 68.7848, 30.4914>, <-31.3237, 69.00965, 29.7691> }
					triangle { <-30.6299, 66.3035, 28.1525>, <-31.3237, 69.00965, 29.7691>, <-30.04706, 68.7848, 30.4914> }
					triangle { <-31.3237, 69.00965, 29.7691>, <-33.0665, 68.3609, 30.0846>, <-30.6299, 66.3035, 28.1525> }
					triangle { <-31.3237, 69.00965, 29.7691>, <-30.6299, 66.3035, 28.1525>, <-33.0665, 68.3609, 30.0846> }
					triangle { <-30.6299, 66.3035, 28.1525>, <-33.0665, 68.3609, 30.0846>, <-33.909, 64.8891, 29.3372> }
					triangle { <-30.6299, 66.3035, 28.1525>, <-33.909, 64.8891, 29.3372>, <-33.0665, 68.3609, 30.0846> }
					triangle { <-33.909, 64.8891, 29.3372>, <-33.0665, 68.3609, 30.0846>, <-34.251, 67.2447, 31.2949> }
					triangle { <-33.909, 64.8891, 29.3372>, <-34.251, 67.2447, 31.2949>, <-33.0665, 68.3609, 30.0846> }
					triangle { <-33.0665, 68.3609, 30.0846>, <-34.7193, 69.9158, 32.8201>, <-34.251, 67.2447, 31.2949> }
					triangle { <-33.0665, 68.3609, 30.0846>, <-34.251, 67.2447, 31.2949>, <-34.7193, 69.9158, 32.8201> }
					triangle { <-31.3237, 69.00965, 29.7691>, <-31.6264, 71.1061, 31.5263>, <-33.0665, 68.3609, 30.0846> }
					triangle { <-31.3237, 69.00965, 29.7691>, <-33.0665, 68.3609, 30.0846>, <-31.6264, 71.1061, 31.5263> }
					triangle { <-33.0665, 68.3609, 30.0846>, <-31.6264, 71.1061, 31.5263>, <-33.3032, 70.8519, 32.2501> }
					triangle { <-33.0665, 68.3609, 30.0846>, <-33.3032, 70.8519, 32.2501>, <-31.6264, 71.1061, 31.5263> }
					triangle { <-33.3032, 70.8519, 32.2501>, <-34.7193, 69.9158, 32.8201>, <-33.0665, 68.3609, 30.0846> }
					triangle { <-33.3032, 70.8519, 32.2501>, <-33.0665, 68.3609, 30.0846>, <-34.7193, 69.9158, 32.8201> }
					triangle { <-30.04706, 68.7848, 30.4914>, <-31.6264, 71.1061, 31.5263>, <-31.3237, 69.00965, 29.7691> }
					triangle { <-30.04706, 68.7848, 30.4914>, <-31.3237, 69.00965, 29.7691>, <-31.6264, 71.1061, 31.5263> }
					triangle { <-31.6264, 71.1061, 31.5263>, <-32.7938, 71.5406, 32.1841>, <-33.3032, 70.8519, 32.2501> }
					triangle { <-31.6264, 71.1061, 31.5263>, <-33.3032, 70.8519, 32.2501>, <-32.7938, 71.5406, 32.1841> }
					triangle { <-32.7938, 71.5406, 32.1841>, <-34.1607, 71.8374, 32.7996>, <-33.3032, 70.8519, 32.2501> }
					triangle { <-32.7938, 71.5406, 32.1841>, <-33.3032, 70.8519, 32.2501>, <-34.1607, 71.8374, 32.7996> }
					triangle { <-34.1607, 71.8374, 32.7996>, <-34.7193, 69.9158, 32.8201>, <-33.3032, 70.8519, 32.2501> }
					triangle { <-34.1607, 71.8374, 32.7996>, <-33.3032, 70.8519, 32.2501>, <-34.7193, 69.9158, 32.8201> }
					triangle { <-34.1607, 71.8374, 32.7996>, <-34.7684, 71.2717, 35.2221>, <-34.7193, 69.9158, 32.8201> }
					triangle { <-34.1607, 71.8374, 32.7996>, <-34.7193, 69.9158, 32.8201>, <-34.7684, 71.2717, 35.2221> }
					triangle { <-33.909, 64.8891, 29.3372>, <-35.7955, 63.7415, 27.3723>, <-33.4529, 62.1947, 27.6587> }
					triangle { <-33.909, 64.8891, 29.3372>, <-33.4529, 62.1947, 27.6587>, <-35.7955, 63.7415, 27.3723> }
					triangle { <-33.909, 64.8891, 29.3372>, <-37.7185, 64.7995, 28.7053>, <-35.7955, 63.7415, 27.3723> }
					triangle { <-33.909, 64.8891, 29.3372>, <-35.7955, 63.7415, 27.3723>, <-37.7185, 64.7995, 28.7053> }
					triangle { <-37.8863, 67.3559, 30.6187>, <-38.7853, 66.7442, 31.4142>, <-37.7185, 64.7995, 28.7053> }
					triangle { <-37.8863, 67.3559, 30.6187>, <-37.7185, 64.7995, 28.7053>, <-38.7853, 66.7442, 31.4142> }
					triangle { <-37.7185, 64.7995, 28.7053>, <-35.9406, 67.3902, 30.7752>, <-37.8863, 67.3559, 30.6187> }
					triangle { <-37.7185, 64.7995, 28.7053>, <-37.8863, 67.3559, 30.6187>, <-35.9406, 67.3902, 30.7752> }
					triangle { <-33.909, 64.8891, 29.3372>, <-35.9406, 67.3902, 30.7752>, <-37.7185, 64.7995, 28.7053> }
					triangle { <-33.909, 64.8891, 29.3372>, <-37.7185, 64.7995, 28.7053>, <-35.9406, 67.3902, 30.7752> }
					triangle { <-34.251, 67.2447, 31.2949>, <-35.9406, 67.3902, 30.7752>, <-33.909, 64.8891, 29.3372> }
					triangle { <-34.251, 67.2447, 31.2949>, <-33.909, 64.8891, 29.3372>, <-35.9406, 67.3902, 30.7752> }
					triangle { <-34.251, 67.2447, 31.2949>, <-34.7193, 69.9158, 32.8201>, <-35.9406, 67.3902, 30.7752> }
					triangle { <-34.251, 67.2447, 31.2949>, <-35.9406, 67.3902, 30.7752>, <-34.7193, 69.9158, 32.8201> }
					triangle { <-35.9406, 67.3902, 30.7752>, <-38.2142, 69.5155, 32.2895>, <-37.8863, 67.3559, 30.6187> }
					triangle { <-35.9406, 67.3902, 30.7752>, <-37.8863, 67.3559, 30.6187>, <-38.2142, 69.5155, 32.2895> }
					triangle { <-36.4656, 70.0192, 32.7058>, <-38.2142, 69.5155, 32.2895>, <-35.9406, 67.3902, 30.7752> }
					triangle { <-36.4656, 70.0192, 32.7058>, <-35.9406, 67.3902, 30.7752>, <-38.2142, 69.5155, 32.2895> }
					triangle { <-35.9406, 67.3902, 30.7752>, <-34.7193, 69.9158, 32.8201>, <-36.4656, 70.0192, 32.7058> }
					triangle { <-35.9406, 67.3902, 30.7752>, <-36.4656, 70.0192, 32.7058>, <-34.7193, 69.9158, 32.8201> }
					triangle { <-37.8863, 67.3559, 30.6187>, <-38.2142, 69.5155, 32.2895>, <-38.7853, 66.7442, 31.4142> }
					triangle { <-37.8863, 67.3559, 30.6187>, <-38.7853, 66.7442, 31.4142>, <-38.2142, 69.5155, 32.2895> }
					triangle { <-36.4656, 70.0192, 32.7058>, <-37.2566, 70.4631, 32.701>, <-38.2142, 69.5155, 32.2895> }
					triangle { <-36.4656, 70.0192, 32.7058>, <-38.2142, 69.5155, 32.2895>, <-37.2566, 70.4631, 32.701> }
					triangle { <-36.4656, 70.0192, 32.7058>, <-36.07337, 71.3756, 33.02115>, <-37.2566, 70.4631, 32.701> }
					triangle { <-36.4656, 70.0192, 32.7058>, <-37.2566, 70.4631, 32.701>, <-36.07337, 71.3756, 33.02115> }
					triangle { <-36.4656, 70.0192, 32.7058>, <-34.7193, 69.9158, 32.8201>, <-36.07337, 71.3756, 33.02115> }
					triangle { <-36.4656, 70.0192, 32.7058>, <-36.07337, 71.3756, 33.02115>, <-34.7193, 69.9158, 32.8201> }
					triangle { <-34.7193, 69.9158, 32.8201>, <-34.7684, 71.2717, 35.2221>, <-36.07337, 71.3756, 33.02115> }
					triangle { <-34.7193, 69.9158, 32.8201>, <-36.07337, 71.3756, 33.02115>, <-34.7684, 71.2717, 35.2221> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <-27.4416, 52.6221, 12.174>, <-28.594, 54.2843, 12.7984>, 0.4123 }
			cylinder { <-28.594, 54.2843, 12.7984>, <-29.7465, 55.9464, 13.4228>, 0.4123 }
			cylinder { <-29.7465, 55.9464, 13.4228>, <-30.899, 57.6085, 14.04719>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <-30.899, 57.6085, 14.04719>, <-30.6272, 59.6817, 13.7172>, 0.4123 }
			cylinder { <-30.6272, 59.6817, 13.7172>, <-30.3554, 61.7548, 13.3873>, 0.4123 }
			cylinder { <-30.3554, 61.7548, 13.3873>, <-30.08373, 63.828, 13.05742>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <-30.08373, 63.828, 13.05742>, <-30.5984, 68.2483, 12.1797>, 0.4123 }
				cylinder { <-30.5984, 68.2483, 12.1797>, <-32.1794, 72.3816, 11.1841>, 0.4123 }
				cylinder { <-32.1794, 72.3816, 11.1841>, <-34.7318, 75.98, 10.13>, 0.4123 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-34.7318, 75.98, 10.13>, <-34.9353, 78.05615, 12.0301>, <-36.2822, 78.7116, 9.482> }
					triangle { <-34.7318, 75.98, 10.13>, <-36.2822, 78.7116, 9.482>, <-34.9353, 78.05615, 12.0301> }
					triangle { <-34.9353, 78.05615, 12.0301>, <-36.876, 79.3619, 13.1401>, <-36.2822, 78.7116, 9.482> }
					triangle { <-34.9353, 78.05615, 12.0301>, <-36.2822, 78.7116, 9.482>, <-36.876, 79.3619, 13.1401> }
					triangle { <-36.876, 79.3619, 13.1401>, <-39.4625, 81.6567, 13.03671>, <-38.2644, 82.1575, 12.3185> }
					triangle { <-36.876, 79.3619, 13.1401>, <-38.2644, 82.1575, 12.3185>, <-39.4625, 81.6567, 13.03671> }
					triangle { <-38.2644, 82.1575, 12.3185>, <-37.6816, 81.9117, 10.5416>, <-36.876, 79.3619, 13.1401> }
					triangle { <-38.2644, 82.1575, 12.3185>, <-36.876, 79.3619, 13.1401>, <-37.6816, 81.9117, 10.5416> }
					triangle { <-36.876, 79.3619, 13.1401>, <-37.6816, 81.9117, 10.5416>, <-36.2822, 78.7116, 9.482> }
					triangle { <-36.876, 79.3619, 13.1401>, <-36.2822, 78.7116, 9.482>, <-37.6816, 81.9117, 10.5416> }
					triangle { <-36.2822, 78.7116, 9.482>, <-37.6816, 81.9117, 10.5416>, <-38.09697, 81.08807, 8.7352> }
					triangle { <-36.2822, 78.7116, 9.482>, <-38.09697, 81.08807, 8.7352>, <-37.6816, 81.9117, 10.5416> }
					triangle { <-37.6816, 81.9117, 10.5416>, <-39.5039, 83.7992, 8.1439>, <-38.09697, 81.08807, 8.7352> }
					triangle { <-37.6816, 81.9117, 10.5416>, <-38.09697, 81.08807, 8.7352>, <-39.5039, 83.7992, 8.1439> }
					triangle { <-38.2644, 82.1575, 12.3185>, <-39.8934, 84.2722, 11.6483>, <-37.6816, 81.9117, 10.5416> }
					triangle { <-38.2644, 82.1575, 12.3185>, <-37.6816, 81.9117, 10.5416>, <-39.8934, 84.2722, 11.6483> }
					triangle { <-37.6816, 81.9117, 10.5416>, <-39.8934, 84.2722, 11.6483>, <-39.7419, 84.3972, 9.8149> }
					triangle { <-37.6816, 81.9117, 10.5416>, <-39.7419, 84.3972, 9.8149>, <-39.8934, 84.2722, 11.6483> }
					triangle { <-39.7419, 84.3972, 9.8149>, <-39.5039, 83.7992, 8.1439>, <-37.6816, 81.9117, 10.5416> }
					triangle { <-39.7419, 84.3972, 9.8149>, <-37.6816, 81.9117, 10.5416>, <-39.5039, 83.7992, 8.1439> }
					triangle { <-39.4625, 81.6567, 13.03671>, <-39.8934, 84.2722, 11.6483>, <-38.2644, 82.1575, 12.3185> }
					triangle { <-39.4625, 81.6567, 13.03671>, <-38.2644, 82.1575, 12.3185>, <-39.8934, 84.2722, 11.6483> }
					triangle { <-39.8934, 84.2722, 11.6483>, <-39.9863, 84.9558, 10.4201>, <-39.7419, 84.3972, 9.8149> }
					triangle { <-39.8934, 84.2722, 11.6483>, <-39.7419, 84.3972, 9.8149>, <-39.9863, 84.9558, 10.4201> }
					triangle { <-39.9863, 84.9558, 10.4201>, <-39.9368, 85.5493, 9.01284>, <-39.7419, 84.3972, 9.8149> }
					triangle { <-39.9863, 84.9558, 10.4201>, <-39.7419, 84.3972, 9.8149>, <-39.9368, 85.5493, 9.01284> }
					triangle { <-39.9368, 85.5493, 9.01284>, <-39.5039, 83.7992, 8.1439>, <-39.7419, 84.3972, 9.8149> }
					triangle { <-39.9368, 85.5493, 9.01284>, <-39.7419, 84.3972, 9.8149>, <-39.5039, 83.7992, 8.1439> }
					triangle { <-39.9368, 85.5493, 9.01284>, <-41.743, 85.1368, 7.2449>, <-39.5039, 83.7992, 8.1439> }
					triangle { <-39.9368, 85.5493, 9.01284>, <-39.5039, 83.7992, 8.1439>, <-41.743, 85.1368, 7.2449> }
					triangle { <-36.2822, 78.7116, 9.482>, <-33.5674, 78.00692, 8.5495>, <-34.7318, 75.98, 10.13> }
					triangle { <-36.2822, 78.7116, 9.482>, <-34.7318, 75.98, 10.13>, <-33.5674, 78.00692, 8.5495> }
					triangle { <-36.2822, 78.7116, 9.482>, <-33.976, 79.4672, 6.4771>, <-33.5674, 78.00692, 8.5495> }
					triangle { <-36.2822, 78.7116, 9.482>, <-33.5674, 78.00692, 8.5495>, <-33.976, 79.4672, 6.4771> }
					triangle { <-35.8515, 82.00083, 5.9405>, <-36.08195, 81.6049, 4.6736>, <-33.976, 79.4672, 6.4771> }
					triangle { <-35.8515, 82.00083, 5.9405>, <-33.976, 79.4672, 6.4771>, <-36.08195, 81.6049, 4.6736> }
					triangle { <-33.976, 79.4672, 6.4771>, <-36.8813, 81.6034, 7.5508>, <-35.8515, 82.00083, 5.9405> }
					triangle { <-33.976, 79.4672, 6.4771>, <-35.8515, 82.00083, 5.9405>, <-36.8813, 81.6034, 7.5508> }
					triangle { <-36.2822, 78.7116, 9.482>, <-36.8813, 81.6034, 7.5508>, <-33.976, 79.4672, 6.4771> }
					triangle { <-36.2822, 78.7116, 9.482>, <-33.976, 79.4672, 6.4771>, <-36.8813, 81.6034, 7.5508> }
					triangle { <-38.09697, 81.08807, 8.7352>, <-36.8813, 81.6034, 7.5508>, <-36.2822, 78.7116, 9.482> }
					triangle { <-38.09697, 81.08807, 8.7352>, <-36.2822, 78.7116, 9.482>, <-36.8813, 81.6034, 7.5508> }
					triangle { <-38.09697, 81.08807, 8.7352>, <-39.5039, 83.7992, 8.1439>, <-36.8813, 81.6034, 7.5508> }
					triangle { <-38.09697, 81.08807, 8.7352>, <-36.8813, 81.6034, 7.5508>, <-39.5039, 83.7992, 8.1439> }
					triangle { <-36.8813, 81.6034, 7.5508>, <-37.399, 84.1824, 5.3015>, <-35.8515, 82.00083, 5.9405> }
					triangle { <-36.8813, 81.6034, 7.5508>, <-35.8515, 82.00083, 5.9405>, <-37.399, 84.1824, 5.3015> }
					triangle { <-38.6165, 84.2868, 6.7127>, <-37.399, 84.1824, 5.3015>, <-36.8813, 81.6034, 7.5508> }
					triangle { <-38.6165, 84.2868, 6.7127>, <-36.8813, 81.6034, 7.5508>, <-37.399, 84.1824, 5.3015> }
					triangle { <-36.8813, 81.6034, 7.5508>, <-39.5039, 83.7992, 8.1439>, <-38.6165, 84.2868, 6.7127> }
					triangle { <-36.8813, 81.6034, 7.5508>, <-38.6165, 84.2868, 6.7127>, <-39.5039, 83.7992, 8.1439> }
					triangle { <-35.8515, 82.00083, 5.9405>, <-37.399, 84.1824, 5.3015>, <-36.08195, 81.6049, 4.6736> }
					triangle { <-35.8515, 82.00083, 5.9405>, <-36.08195, 81.6049, 4.6736>, <-37.399, 84.1824, 5.3015> }
					triangle { <-38.6165, 84.2868, 6.7127>, <-38.2965, 84.895, 6.1207>, <-37.399, 84.1824, 5.3015> }
					triangle { <-38.6165, 84.2868, 6.7127>, <-37.399, 84.1824, 5.3015>, <-38.2965, 84.895, 6.1207> }
					triangle { <-38.6165, 84.2868, 6.7127>, <-39.2126, 85.5232, 7.1702>, <-38.2965, 84.895, 6.1207> }
					triangle { <-38.6165, 84.2868, 6.7127>, <-38.2965, 84.895, 6.1207>, <-39.2126, 85.5232, 7.1702> }
					triangle { <-38.6165, 84.2868, 6.7127>, <-39.5039, 83.7992, 8.1439>, <-39.2126, 85.5232, 7.1702> }
					triangle { <-38.6165, 84.2868, 6.7127>, <-39.2126, 85.5232, 7.1702>, <-39.5039, 83.7992, 8.1439> }
					triangle { <-39.5039, 83.7992, 8.1439>, <-41.743, 85.1368, 7.2449>, <-39.2126, 85.5232, 7.1702> }
					triangle { <-39.5039, 83.7992, 8.1439>, <-39.2126, 85.5232, 7.1702>, <-41.743, 85.1368, 7.2449> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-34.7318, 75.98, 10.13>, <-34.00914, 77.4915, 7.8595>, <-36.5424, 78.4079, 9.07555> }
					triangle { <-34.7318, 75.98, 10.13>, <-36.5424, 78.4079, 9.07555>, <-34.00914, 77.4915, 7.8595> }
					triangle { <-34.00914, 77.4915, 7.8595>, <-33.5933, 79.9984, 7.3639>, <-36.5424, 78.4079, 9.07555> }
					triangle { <-34.00914, 77.4915, 7.8595>, <-36.5424, 78.4079, 9.07555>, <-33.5933, 79.9984, 7.3639> }
					triangle { <-33.5933, 79.9984, 7.3639>, <-34.698, 83.248, 6.9319>, <-35.5906, 82.277, 6.2518> }
					triangle { <-33.5933, 79.9984, 7.3639>, <-35.5906, 82.277, 6.2518>, <-34.698, 83.248, 6.9319> }
					triangle { <-35.5906, 82.277, 6.2518>, <-37.06173, 81.28, 6.8838>, <-33.5933, 79.9984, 7.3639> }
					triangle { <-35.5906, 82.277, 6.2518>, <-33.5933, 79.9984, 7.3639>, <-37.06173, 81.28, 6.8838> }
					triangle { <-33.5933, 79.9984, 7.3639>, <-37.06173, 81.28, 6.8838>, <-36.5424, 78.4079, 9.07555> }
					triangle { <-33.5933, 79.9984, 7.3639>, <-36.5424, 78.4079, 9.07555>, <-37.06173, 81.28, 6.8838> }
					triangle { <-36.5424, 78.4079, 9.07555>, <-37.06173, 81.28, 6.8838>, <-38.2704, 80.8856, 8.4642> }
					triangle { <-36.5424, 78.4079, 9.07555>, <-38.2704, 80.8856, 8.4642>, <-37.06173, 81.28, 6.8838> }
					triangle { <-37.06173, 81.28, 6.8838>, <-40.02436, 83.192, 7.3308>, <-38.2704, 80.8856, 8.4642> }
					triangle { <-37.06173, 81.28, 6.8838>, <-38.2704, 80.8856, 8.4642>, <-40.02436, 83.192, 7.3308> }
					triangle { <-35.5906, 82.277, 6.2518>, <-37.1329, 84.4929, 5.7171>, <-37.06173, 81.28, 6.8838> }
					triangle { <-35.5906, 82.277, 6.2518>, <-37.06173, 81.28, 6.8838>, <-37.1329, 84.4929, 5.7171> }
					triangle { <-37.06173, 81.28, 6.8838>, <-37.1329, 84.4929, 5.7171>, <-38.8175, 84.02409, 6.3024> }
					triangle { <-37.06173, 81.28, 6.8838>, <-38.8175, 84.02409, 6.3024>, <-37.1329, 84.4929, 5.7171> }
					triangle { <-38.8175, 84.02409, 6.3024>, <-40.02436, 83.192, 7.3308>, <-37.06173, 81.28, 6.8838> }
					triangle { <-38.8175, 84.02409, 6.3024>, <-37.06173, 81.28, 6.8838>, <-40.02436, 83.192, 7.3308> }
					triangle { <-34.698, 83.248, 6.9319>, <-37.1329, 84.4929, 5.7171>, <-35.5906, 82.277, 6.2518> }
					triangle { <-34.698, 83.248, 6.9319>, <-35.5906, 82.277, 6.2518>, <-37.1329, 84.4929, 5.7171> }
					triangle { <-37.1329, 84.4929, 5.7171>, <-38.5359, 84.6156, 5.7466>, <-38.8175, 84.02409, 6.3024> }
					triangle { <-37.1329, 84.4929, 5.7171>, <-38.8175, 84.02409, 6.3024>, <-38.5359, 84.6156, 5.7466> }
					triangle { <-38.5359, 84.6156, 5.7466>, <-40.05868, 84.5359, 5.8484>, <-38.8175, 84.02409, 6.3024> }
					triangle { <-38.5359, 84.6156, 5.7466>, <-38.8175, 84.02409, 6.3024>, <-40.05868, 84.5359, 5.8484> }
					triangle { <-40.05868, 84.5359, 5.8484>, <-40.02436, 83.192, 7.3308>, <-38.8175, 84.02409, 6.3024> }
					triangle { <-40.05868, 84.5359, 5.8484>, <-38.8175, 84.02409, 6.3024>, <-40.02436, 83.192, 7.3308> }
					triangle { <-40.05868, 84.5359, 5.8484>, <-41.3961, 85.5417, 7.7869>, <-40.02436, 83.192, 7.3308> }
					triangle { <-40.05868, 84.5359, 5.8484>, <-40.02436, 83.192, 7.3308>, <-41.3961, 85.5417, 7.7869> }
					triangle { <-36.5424, 78.4079, 9.07555>, <-37.09578, 75.5351, 8.655>, <-34.7318, 75.98, 10.13> }
					triangle { <-36.5424, 78.4079, 9.07555>, <-34.7318, 75.98, 10.13>, <-37.09578, 75.5351, 8.655> }
					triangle { <-36.5424, 78.4079, 9.07555>, <-39.6005, 76.09796, 8.5947>, <-37.09578, 75.5351, 8.655> }
					triangle { <-36.5424, 78.4079, 9.07555>, <-37.09578, 75.5351, 8.655>, <-39.6005, 76.09796, 8.5947> }
					triangle { <-41.214, 78.7437, 7.8067>, <-42.1475, 78.4954, 8.7459>, <-39.6005, 76.09796, 8.5947> }
					triangle { <-41.214, 78.7437, 7.8067>, <-39.6005, 76.09796, 8.5947>, <-42.1475, 78.4954, 8.7459> }
					triangle { <-39.6005, 76.09796, 8.5947>, <-39.5829, 79.8059, 7.9565>, <-41.214, 78.7437, 7.8067> }
					triangle { <-39.6005, 76.09796, 8.5947>, <-41.214, 78.7437, 7.8067>, <-39.5829, 79.8059, 7.9565> }
					triangle { <-36.5424, 78.4079, 9.07555>, <-39.5829, 79.8059, 7.9565>, <-39.6005, 76.09796, 8.5947> }
					triangle { <-36.5424, 78.4079, 9.07555>, <-39.6005, 76.09796, 8.5947>, <-39.5829, 79.8059, 7.9565> }
					triangle { <-38.2704, 80.8856, 8.4642>, <-39.5829, 79.8059, 7.9565>, <-36.5424, 78.4079, 9.07555> }
					triangle { <-38.2704, 80.8856, 8.4642>, <-36.5424, 78.4079, 9.07555>, <-39.5829, 79.8059, 7.9565> }
					triangle { <-38.2704, 80.8856, 8.4642>, <-40.02436, 83.192, 7.3308>, <-39.5829, 79.8059, 7.9565> }
					triangle { <-38.2704, 80.8856, 8.4642>, <-39.5829, 79.8059, 7.9565>, <-40.02436, 83.192, 7.3308> }
					triangle { <-39.5829, 79.8059, 7.9565>, <-42.7615, 80.9253, 7.1676>, <-41.214, 78.7437, 7.8067> }
					triangle { <-39.5829, 79.8059, 7.9565>, <-41.214, 78.7437, 7.8067>, <-42.7615, 80.9253, 7.1676> }
					triangle { <-41.5358, 82.3321, 7.1087>, <-42.7615, 80.9253, 7.1676>, <-39.5829, 79.8059, 7.9565> }
					triangle { <-41.5358, 82.3321, 7.1087>, <-39.5829, 79.8059, 7.9565>, <-42.7615, 80.9253, 7.1676> }
					triangle { <-39.5829, 79.8059, 7.9565>, <-40.02436, 83.192, 7.3308>, <-41.5358, 82.3321, 7.1087> }
					triangle { <-39.5829, 79.8059, 7.9565>, <-41.5358, 82.3321, 7.1087>, <-40.02436, 83.192, 7.3308> }
					triangle { <-41.214, 78.7437, 7.8067>, <-42.7615, 80.9253, 7.1676>, <-42.1475, 78.4954, 8.7459> }
					triangle { <-41.214, 78.7437, 7.8067>, <-42.1475, 78.4954, 8.7459>, <-42.7615, 80.9253, 7.1676> }
					triangle { <-41.5358, 82.3321, 7.1087>, <-42.3489, 82.1988, 6.7292>, <-42.7615, 80.9253, 7.1676> }
					triangle { <-41.5358, 82.3321, 7.1087>, <-42.7615, 80.9253, 7.1676>, <-42.3489, 82.1988, 6.7292> }
					triangle { <-41.5358, 82.3321, 7.1087>, <-41.6927, 83.5002, 6.2695>, <-42.3489, 82.1988, 6.7292> }
					triangle { <-41.5358, 82.3321, 7.1087>, <-42.3489, 82.1988, 6.7292>, <-41.6927, 83.5002, 6.2695> }
					triangle { <-41.5358, 82.3321, 7.1087>, <-40.02436, 83.192, 7.3308>, <-41.6927, 83.5002, 6.2695> }
					triangle { <-41.5358, 82.3321, 7.1087>, <-41.6927, 83.5002, 6.2695>, <-40.02436, 83.192, 7.3308> }
					triangle { <-40.02436, 83.192, 7.3308>, <-41.3961, 85.5417, 7.7869>, <-41.6927, 83.5002, 6.2695> }
					triangle { <-40.02436, 83.192, 7.3308>, <-41.6927, 83.5002, 6.2695>, <-41.3961, 85.5417, 7.7869> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-34.7318, 75.98, 10.13>, <-37.4717, 75.5486, 9.6115>, <-36.7525, 78.4155, 9.6099> }
					triangle { <-34.7318, 75.98, 10.13>, <-36.7525, 78.4155, 9.6099>, <-37.4717, 75.5486, 9.6115> }
					triangle { <-37.4717, 75.5486, 9.6115>, <-39.1163, 76.1838, 7.7154>, <-36.7525, 78.4155, 9.6099> }
					triangle { <-37.4717, 75.5486, 9.6115>, <-36.7525, 78.4155, 9.6099>, <-39.1163, 76.1838, 7.7154> }
					triangle { <-39.1163, 76.1838, 7.7154>, <-41.00628, 78.4887, 5.9597>, <-41.1099, 78.7055, 7.4241> }
					triangle { <-39.1163, 76.1838, 7.7154>, <-41.1099, 78.7055, 7.4241>, <-41.00628, 78.4887, 5.9597> }
					triangle { <-41.1099, 78.7055, 7.4241>, <-40.02858, 79.6842, 8.62>, <-39.1163, 76.1838, 7.7154> }
					triangle { <-41.1099, 78.7055, 7.4241>, <-39.1163, 76.1838, 7.7154>, <-40.02858, 79.6842, 8.62> }
					triangle { <-39.1163, 76.1838, 7.7154>, <-40.02858, 79.6842, 8.62>, <-36.7525, 78.4155, 9.6099> }
					triangle { <-39.1163, 76.1838, 7.7154>, <-36.7525, 78.4155, 9.6099>, <-40.02858, 79.6842, 8.62> }
					triangle { <-36.7525, 78.4155, 9.6099>, <-40.02858, 79.6842, 8.62>, <-38.4104, 80.8906, 8.8205> }
					triangle { <-36.7525, 78.4155, 9.6099>, <-38.4104, 80.8906, 8.8205>, <-40.02858, 79.6842, 8.62> }
					triangle { <-40.02858, 79.6842, 8.62>, <-40.4444, 83.2071, 8.3997>, <-38.4104, 80.8906, 8.8205> }
					triangle { <-40.02858, 79.6842, 8.62>, <-38.4104, 80.8906, 8.8205>, <-40.4444, 83.2071, 8.3997> }
					triangle { <-41.1099, 78.7055, 7.4241>, <-42.5822, 80.9188, 6.7114>, <-40.02858, 79.6842, 8.62> }
					triangle { <-41.1099, 78.7055, 7.4241>, <-40.02858, 79.6842, 8.62>, <-42.5822, 80.9188, 6.7114> }
					triangle { <-40.02858, 79.6842, 8.62>, <-42.5822, 80.9188, 6.7114>, <-41.7862, 82.3066, 7.6282> }
					triangle { <-40.02858, 79.6842, 8.62>, <-41.7862, 82.3066, 7.6282>, <-42.5822, 80.9188, 6.7114> }
					triangle { <-41.7862, 82.3066, 7.6282>, <-40.4444, 83.2071, 8.3997>, <-40.02858, 79.6842, 8.62> }
					triangle { <-41.7862, 82.3066, 7.6282>, <-40.02858, 79.6842, 8.62>, <-40.4444, 83.2071, 8.3997> }
					triangle { <-41.00628, 78.4887, 5.9597>, <-42.5822, 80.9188, 6.7114>, <-41.1099, 78.7055, 7.4241> }
					triangle { <-41.00628, 78.4887, 5.9597>, <-41.1099, 78.7055, 7.4241>, <-42.5822, 80.9188, 6.7114> }
					triangle { <-42.5822, 80.9188, 6.7114>, <-42.5661, 82.2067, 7.2821>, <-41.7862, 82.3066, 7.6282> }
					triangle { <-42.5822, 80.9188, 6.7114>, <-41.7862, 82.3066, 7.6282>, <-42.5661, 82.2067, 7.2821> }
					triangle { <-42.5661, 82.2067, 7.2821>, <-42.386, 83.5251, 8.0334>, <-41.7862, 82.3066, 7.6282> }
					triangle { <-42.5661, 82.2067, 7.2821>, <-41.7862, 82.3066, 7.6282>, <-42.386, 83.5251, 8.0334> }
					triangle { <-42.386, 83.5251, 8.0334>, <-40.4444, 83.2071, 8.3997>, <-41.7862, 82.3066, 7.6282> }
					triangle { <-42.386, 83.5251, 8.0334>, <-41.7862, 82.3066, 7.6282>, <-40.4444, 83.2071, 8.3997> }
					triangle { <-42.386, 83.5251, 8.0334>, <-41.116, 85.5316, 7.07441>, <-40.4444, 83.2071, 8.3997> }
					triangle { <-42.386, 83.5251, 8.0334>, <-40.4444, 83.2071, 8.3997>, <-41.116, 85.5316, 7.07441> }
					triangle { <-36.7525, 78.4155, 9.6099>, <-35.7335, 77.5535, 12.2472>, <-34.7318, 75.98, 10.13> }
					triangle { <-36.7525, 78.4155, 9.6099>, <-34.7318, 75.98, 10.13>, <-35.7335, 77.5535, 12.2472> }
					triangle { <-36.7525, 78.4155, 9.6099>, <-35.9678, 79.9805, 13.05296>, <-35.7335, 77.5535, 12.2472> }
					triangle { <-36.7525, 78.4155, 9.6099>, <-35.7335, 77.5535, 12.2472>, <-35.9678, 79.9805, 13.05296> }
					triangle { <-37.8651, 82.3933, 12.1566>, <-36.8894, 83.2924, 12.39>, <-35.9678, 79.9805, 13.05296> }
					triangle { <-37.8651, 82.3933, 12.1566>, <-35.9678, 79.9805, 13.05296>, <-36.8894, 83.2924, 12.39> }
					triangle { <-35.9678, 79.9805, 13.05296>, <-38.2963, 81.4623, 10.4956>, <-37.8651, 82.3933, 12.1566> }
					triangle { <-35.9678, 79.9805, 13.05296>, <-37.8651, 82.3933, 12.1566>, <-38.2963, 81.4623, 10.4956> }
					triangle { <-36.7525, 78.4155, 9.6099>, <-38.2963, 81.4623, 10.4956>, <-35.9678, 79.9805, 13.05296> }
					triangle { <-36.7525, 78.4155, 9.6099>, <-35.9678, 79.9805, 13.05296>, <-38.2963, 81.4623, 10.4956> }
					triangle { <-38.4104, 80.8906, 8.8205>, <-38.2963, 81.4623, 10.4956>, <-36.7525, 78.4155, 9.6099> }
					triangle { <-38.4104, 80.8906, 8.8205>, <-36.7525, 78.4155, 9.6099>, <-38.2963, 81.4623, 10.4956> }
					triangle { <-38.4104, 80.8906, 8.8205>, <-40.4444, 83.2071, 8.3997>, <-38.2963, 81.4623, 10.4956> }
					triangle { <-38.4104, 80.8906, 8.8205>, <-38.2963, 81.4623, 10.4956>, <-40.4444, 83.2071, 8.3997> }
					triangle { <-38.2963, 81.4623, 10.4956>, <-39.4126, 84.5749, 11.5175>, <-37.8651, 82.3933, 12.1566> }
					triangle { <-38.2963, 81.4623, 10.4956>, <-37.8651, 82.3933, 12.1566>, <-39.4126, 84.5749, 11.5175> }
					triangle { <-40.1773, 84.1074, 9.88>, <-39.4126, 84.5749, 11.5175>, <-38.2963, 81.4623, 10.4956> }
					triangle { <-40.1773, 84.1074, 9.88>, <-38.2963, 81.4623, 10.4956>, <-39.4126, 84.5749, 11.5175> }
					triangle { <-38.2963, 81.4623, 10.4956>, <-40.4444, 83.2071, 8.3997>, <-40.1773, 84.1074, 9.88> }
					triangle { <-38.2963, 81.4623, 10.4956>, <-40.1773, 84.1074, 9.88>, <-40.4444, 83.2071, 8.3997> }
					triangle { <-37.8651, 82.3933, 12.1566>, <-39.4126, 84.5749, 11.5175>, <-36.8894, 83.2924, 12.39> }
					triangle { <-37.8651, 82.3933, 12.1566>, <-36.8894, 83.2924, 12.39>, <-39.4126, 84.5749, 11.5175> }
					triangle { <-40.1773, 84.1074, 9.88>, <-40.419, 84.6833, 10.5379>, <-39.4126, 84.5749, 11.5175> }
					triangle { <-40.1773, 84.1074, 9.88>, <-39.4126, 84.5749, 11.5175>, <-40.419, 84.6833, 10.5379> }
					triangle { <-40.1773, 84.1074, 9.88>, <-41.4658, 84.5866, 9.4287>, <-40.419, 84.6833, 10.5379> }
					triangle { <-40.1773, 84.1074, 9.88>, <-40.419, 84.6833, 10.5379>, <-41.4658, 84.5866, 9.4287> }
					triangle { <-40.1773, 84.1074, 9.88>, <-40.4444, 83.2071, 8.3997>, <-41.4658, 84.5866, 9.4287> }
					triangle { <-40.1773, 84.1074, 9.88>, <-41.4658, 84.5866, 9.4287>, <-40.4444, 83.2071, 8.3997> }
					triangle { <-40.4444, 83.2071, 8.3997>, <-41.116, 85.5316, 7.07441>, <-41.4658, 84.5866, 9.4287> }
					triangle { <-40.4444, 83.2071, 8.3997>, <-41.4658, 84.5866, 9.4287>, <-41.116, 85.5316, 7.07441> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		}
	union { // Internode
		cylinder { <-0.756, 14.5047, -0.403>, <-0.801, 18.8512, -0.6146>, 0.7912 }
		cylinder { <-0.801, 18.8512, -0.6146>, <-0.1391, 23.1295, -1.05723>, 0.7912 }
		cylinder { <-0.1391, 23.1295, -1.05723>, <1.2101, 27.2138, -1.7178>, 0.7912 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <1.2101, 27.2138, -1.7178>, <3.2144, 29.9427, -2.5252>, 0.2373 }
			cylinder { <3.2144, 29.9427, -2.5252>, <5.9415, 31.8582, -3.53>, 0.2373 }
			cylinder { <5.9415, 31.8582, -3.53>, <9.1161, 32.7669, -4.6308>, 0.2373 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <9.1161, 32.7669, -4.6308>, <10.075, 33.01482, -4.962>, 0.2373 }
				cylinder { <10.075, 33.01482, -4.962>, <11.03971, 33.2377, -5.2937>, 0.2373 }
				cylinder { <11.03971, 33.2377, -5.2937>, <12.00972, 33.4355, -5.6259>, 0.2373 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <12.00972, 33.4355, -5.6259>, <12.6568, 33.5649, -5.6615>, 0.04505 }
				cylinder { <12.6568, 33.5649, -5.6615>, <13.2902, 33.689, -5.5197>, 0.04505 }
				cylinder { <13.2902, 33.689, -5.5197>, <13.8641, 33.799, -5.211>, 0.04505 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <13.8641, 33.799, -5.211>, <21.8238, 37.5226, -3.8979>, <23.5827, 36.8252, -1.5543> }
				triangle { <13.8641, 33.799, -5.211>, <23.5827, 36.8252, -1.5543>, <21.8238, 37.5226, -3.8979> }
				triangle { <21.8238, 37.5226, -3.8979>, <28.2259, 39.784, -1.8509>, <23.5827, 36.8252, -1.5543> }
				triangle { <21.8238, 37.5226, -3.8979>, <23.5827, 36.8252, -1.5543>, <28.2259, 39.784, -1.8509> }
				triangle { <28.2259, 39.784, -1.8509>, <26.9216, 36.3014, 1.8138>, <23.5827, 36.8252, -1.5543> }
				triangle { <28.2259, 39.784, -1.8509>, <23.5827, 36.8252, -1.5543>, <26.9216, 36.3014, 1.8138> }
				triangle { <23.5827, 36.8252, -1.5543>, <26.9216, 36.3014, 1.8138>, <13.8641, 33.799, -5.211> }
				triangle { <23.5827, 36.8252, -1.5543>, <13.8641, 33.799, -5.211>, <26.9216, 36.3014, 1.8138> }
				triangle { <28.2259, 39.784, -1.8509>, <41.4087, 27.2462, -9.3712>, <47.2284, 20.6929, -10.2545> }
				triangle { <28.2259, 39.784, -1.8509>, <47.2284, 20.6929, -10.2545>, <41.4087, 27.2462, -9.3712> }
				triangle { <47.2284, 20.6929, -10.2545>, <48.7794, 15.6742, -10.00867>, <43.2686, 17.488, -10.2463> }
				triangle { <47.2284, 20.6929, -10.2545>, <43.2686, 17.488, -10.2463>, <48.7794, 15.6742, -10.00867> }
				triangle { <43.2686, 17.488, -10.2463>, <28.2259, 39.784, -1.8509>, <47.2284, 20.6929, -10.2545> }
				triangle { <43.2686, 17.488, -10.2463>, <47.2284, 20.6929, -10.2545>, <28.2259, 39.784, -1.8509> }
				triangle { <28.2259, 39.784, -1.8509>, <43.2686, 17.488, -10.2463>, <26.9216, 36.3014, 1.8138> }
				triangle { <28.2259, 39.784, -1.8509>, <26.9216, 36.3014, 1.8138>, <43.2686, 17.488, -10.2463> }
				triangle { <22.6436, 34.3178, 1.08428>, <20.05007, 32.7863, 1.08621>, <13.8641, 33.799, -5.211> }
				triangle { <22.6436, 34.3178, 1.08428>, <13.8641, 33.799, -5.211>, <20.05007, 32.7863, 1.08621> }
				triangle { <22.6436, 34.3178, 1.08428>, <25.6174, 32.8188, 5.4787>, <20.05007, 32.7863, 1.08621> }
				triangle { <22.6436, 34.3178, 1.08428>, <20.05007, 32.7863, 1.08621>, <25.6174, 32.8188, 5.4787> }
				triangle { <22.6436, 34.3178, 1.08428>, <26.9216, 36.3014, 1.8138>, <25.6174, 32.8188, 5.4787> }
				triangle { <22.6436, 34.3178, 1.08428>, <25.6174, 32.8188, 5.4787>, <26.9216, 36.3014, 1.8138> }
				triangle { <13.8641, 33.799, -5.211>, <26.9216, 36.3014, 1.8138>, <22.6436, 34.3178, 1.08428> }
				triangle { <13.8641, 33.799, -5.211>, <22.6436, 34.3178, 1.08428>, <26.9216, 36.3014, 1.8138> }
				triangle { <45.6633, 16.5138, -5.8567>, <38.6958, 20.00239, -1.7483>, <25.6174, 32.8188, 5.4787> }
				triangle { <45.6633, 16.5138, -5.8567>, <25.6174, 32.8188, 5.4787>, <38.6958, 20.00239, -1.7483> }
				triangle { <43.2686, 17.488, -10.2463>, <48.7794, 15.6742, -10.00867>, <45.6633, 16.5138, -5.8567> }
				triangle { <43.2686, 17.488, -10.2463>, <45.6633, 16.5138, -5.8567>, <48.7794, 15.6742, -10.00867> }
				triangle { <45.6633, 16.5138, -5.8567>, <25.6174, 32.8188, 5.4787>, <43.2686, 17.488, -10.2463> }
				triangle { <45.6633, 16.5138, -5.8567>, <43.2686, 17.488, -10.2463>, <25.6174, 32.8188, 5.4787> }
				triangle { <26.9216, 36.3014, 1.8138>, <43.2686, 17.488, -10.2463>, <25.6174, 32.8188, 5.4787> }
				triangle { <26.9216, 36.3014, 1.8138>, <25.6174, 32.8188, 5.4787>, <43.2686, 17.488, -10.2463> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <12.00972, 33.4355, -5.6259>, <12.9844, 33.6081, -5.9584>, 0.2373 }
				cylinder { <12.9844, 33.6081, -5.9584>, <13.9633, 33.7555, -6.2909>, 0.2373 }
				cylinder { <13.9633, 33.7555, -6.2909>, <14.9456, 33.8774, -6.6233>, 0.2373 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <14.9456, 33.8774, -6.6233>, <15.4894, 33.9431, -6.9931>, 0.04505 }
				cylinder { <15.4894, 33.9431, -6.9931>, <15.9158, 33.9925, -7.4956>, 0.04505 }
				cylinder { <15.9158, 33.9925, -7.4956>, <16.1939, 34.02217, -8.09436>, 0.04505 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <16.1939, 34.02217, -8.09436>, <16.7929, 36.1462, -16.7011>, <19.179, 35.4303, -18.3942> }
				triangle { <16.1939, 34.02217, -8.09436>, <19.179, 35.4303, -18.3942>, <16.7929, 36.1462, -16.7011> }
				triangle { <16.7929, 36.1462, -16.7011>, <18.3622, 37.2826, -23.5228>, <19.179, 35.4303, -18.3942> }
				triangle { <16.7929, 36.1462, -16.7011>, <19.179, 35.4303, -18.3942>, <18.3622, 37.2826, -23.5228> }
				triangle { <18.3622, 37.2826, -23.5228>, <22.5225, 34.6951, -21.7181>, <19.179, 35.4303, -18.3942> }
				triangle { <18.3622, 37.2826, -23.5228>, <19.179, 35.4303, -18.3942>, <22.5225, 34.6951, -21.7181> }
				triangle { <19.179, 35.4303, -18.3942>, <22.5225, 34.6951, -21.7181>, <16.1939, 34.02217, -8.09436> }
				triangle { <19.179, 35.4303, -18.3942>, <16.1939, 34.02217, -8.09436>, <22.5225, 34.6951, -21.7181> }
				triangle { <18.3622, 37.2826, -23.5228>, <12.508, 21.3439, -33.4839>, <12.4827, 13.6616, -37.7938> }
				triangle { <18.3622, 37.2826, -23.5228>, <12.4827, 13.6616, -37.7938>, <12.508, 21.3439, -33.4839> }
				triangle { <12.4827, 13.6616, -37.7938>, <13.4317, 8.514, -38.2988>, <13.03721, 11.388, -33.2689> }
				triangle { <12.4827, 13.6616, -37.7938>, <13.03721, 11.388, -33.2689>, <13.4317, 8.514, -38.2988> }
				triangle { <13.03721, 11.388, -33.2689>, <18.3622, 37.2826, -23.5228>, <12.4827, 13.6616, -37.7938> }
				triangle { <13.03721, 11.388, -33.2689>, <12.4827, 13.6616, -37.7938>, <18.3622, 37.2826, -23.5228> }
				triangle { <18.3622, 37.2826, -23.5228>, <13.03721, 11.388, -33.2689>, <22.5225, 34.6951, -21.7181> }
				triangle { <18.3622, 37.2826, -23.5228>, <22.5225, 34.6951, -21.7181>, <13.03721, 11.388, -33.2689> }
				triangle { <22.1744, 33.5673, -17.09482>, <22.4509, 32.6271, -14.2466>, <16.1939, 34.02217, -8.09436> }
				triangle { <22.1744, 33.5673, -17.09482>, <16.1939, 34.02217, -8.09436>, <22.4509, 32.6271, -14.2466> }
				triangle { <22.1744, 33.5673, -17.09482>, <26.6828, 32.1075, -19.9133>, <22.4509, 32.6271, -14.2466> }
				triangle { <22.1744, 33.5673, -17.09482>, <22.4509, 32.6271, -14.2466>, <26.6828, 32.1075, -19.9133> }
				triangle { <22.1744, 33.5673, -17.09482>, <22.5225, 34.6951, -21.7181>, <26.6828, 32.1075, -19.9133> }
				triangle { <22.1744, 33.5673, -17.09482>, <26.6828, 32.1075, -19.9133>, <22.5225, 34.6951, -21.7181> }
				triangle { <16.1939, 34.02217, -8.09436>, <22.5225, 34.6951, -21.7181>, <22.1744, 33.5673, -17.09482> }
				triangle { <16.1939, 34.02217, -8.09436>, <22.1744, 33.5673, -17.09482>, <22.5225, 34.6951, -21.7181> }
				triangle { <17.475, 10.5565, -35.6281>, <21.1614, 15.9618, -29.73>, <26.6828, 32.1075, -19.9133> }
				triangle { <17.475, 10.5565, -35.6281>, <26.6828, 32.1075, -19.9133>, <21.1614, 15.9618, -29.73> }
				triangle { <13.03721, 11.388, -33.2689>, <13.4317, 8.514, -38.2988>, <17.475, 10.5565, -35.6281> }
				triangle { <13.03721, 11.388, -33.2689>, <17.475, 10.5565, -35.6281>, <13.4317, 8.514, -38.2988> }
				triangle { <17.475, 10.5565, -35.6281>, <26.6828, 32.1075, -19.9133>, <13.03721, 11.388, -33.2689> }
				triangle { <17.475, 10.5565, -35.6281>, <13.03721, 11.388, -33.2689>, <26.6828, 32.1075, -19.9133> }
				triangle { <22.5225, 34.6951, -21.7181>, <13.03721, 11.388, -33.2689>, <26.6828, 32.1075, -19.9133> }
				triangle { <22.5225, 34.6951, -21.7181>, <26.6828, 32.1075, -19.9133>, <13.03721, 11.388, -33.2689> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <14.9456, 33.8774, -6.6233>, <15.931, 33.974, -6.9553>, 0.2373 }
				cylinder { <15.931, 33.974, -6.9553>, <16.9187, 34.04498, -7.2867>, 0.2373 }
				cylinder { <16.9187, 34.04498, -7.2867>, <17.9081, 34.09041, -7.6175>, 0.2373 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <17.9081, 34.09041, -7.6175>, <18.5671, 34.1268, -7.6521>, 0.04505 }
				cylinder { <18.5671, 34.1268, -7.6521>, <19.211, 34.1682, -7.5096>, 0.04505 }
				cylinder { <19.211, 34.1682, -7.5096>, <19.7934, 34.2117, -7.2002>, 0.04505 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <19.7934, 34.2117, -7.2002>, <28.1888, 36.8506, -5.9751>, <29.824, 36.02578, -3.5839> }
				triangle { <19.7934, 34.2117, -7.2002>, <29.824, 36.02578, -3.5839>, <28.1888, 36.8506, -5.9751> }
				triangle { <28.1888, 36.8506, -5.9751>, <34.8351, 38.2936, -3.9665>, <29.824, 36.02578, -3.5839> }
				triangle { <28.1888, 36.8506, -5.9751>, <29.824, 36.02578, -3.5839>, <34.8351, 38.2936, -3.9665> }
				triangle { <34.8351, 38.2936, -3.9665>, <33.04386, 35.2008, -0.1604>, <29.824, 36.02578, -3.5839> }
				triangle { <34.8351, 38.2936, -3.9665>, <29.824, 36.02578, -3.5839>, <33.04386, 35.2008, -0.1604> }
				triangle { <29.824, 36.02578, -3.5839>, <33.04386, 35.2008, -0.1604>, <19.7934, 34.2117, -7.2002> }
				triangle { <29.824, 36.02578, -3.5839>, <19.7934, 34.2117, -7.2002>, <33.04386, 35.2008, -0.1604> }
				triangle { <34.8351, 38.2936, -3.9665>, <46.1736, 23.7088, -10.7681>, <51.02749, 16.3766, -11.2903> }
				triangle { <34.8351, 38.2936, -3.9665>, <51.02749, 16.3766, -11.2903>, <46.1736, 23.7088, -10.7681> }
				triangle { <51.02749, 16.3766, -11.2903>, <51.8634, 11.2081, -10.7993>, <46.6598, 13.7568, -11.1772> }
				triangle { <51.02749, 16.3766, -11.2903>, <46.6598, 13.7568, -11.1772>, <51.8634, 11.2081, -10.7993> }
				triangle { <46.6598, 13.7568, -11.1772>, <34.8351, 38.2936, -3.9665>, <51.02749, 16.3766, -11.2903> }
				triangle { <46.6598, 13.7568, -11.1772>, <51.02749, 16.3766, -11.2903>, <34.8351, 38.2936, -3.9665> }
				triangle { <34.8351, 38.2936, -3.9665>, <46.6598, 13.7568, -11.1772>, <33.04386, 35.2008, -0.1604> }
				triangle { <34.8351, 38.2936, -3.9665>, <33.04386, 35.2008, -0.1604>, <46.6598, 13.7568, -11.1772> }
				triangle { <28.5342, 33.7989, -0.8434>, <25.7526, 32.6444, -0.7988>, <19.7934, 34.2117, -7.2002> }
				triangle { <28.5342, 33.7989, -0.8434>, <19.7934, 34.2117, -7.2002>, <25.7526, 32.6444, -0.7988> }
				triangle { <28.5342, 33.7989, -0.8434>, <31.2525, 32.108, 3.6457>, <25.7526, 32.6444, -0.7988> }
				triangle { <28.5342, 33.7989, -0.8434>, <25.7526, 32.6444, -0.7988>, <31.2525, 32.108, 3.6457> }
				triangle { <28.5342, 33.7989, -0.8434>, <33.04386, 35.2008, -0.1604>, <31.2525, 32.108, 3.6457> }
				triangle { <28.5342, 33.7989, -0.8434>, <31.2525, 32.108, 3.6457>, <33.04386, 35.2008, -0.1604> }
				triangle { <19.7934, 34.2117, -7.2002>, <33.04386, 35.2008, -0.1604>, <28.5342, 33.7989, -0.8434> }
				triangle { <19.7934, 34.2117, -7.2002>, <28.5342, 33.7989, -0.8434>, <33.04386, 35.2008, -0.1604> }
				triangle { <48.8779, 12.6653, -6.7229>, <42.4477, 17.2758, -2.8513>, <31.2525, 32.108, 3.6457> }
				triangle { <48.8779, 12.6653, -6.7229>, <31.2525, 32.108, 3.6457>, <42.4477, 17.2758, -2.8513> }
				triangle { <46.6598, 13.7568, -11.1772>, <51.8634, 11.2081, -10.7993>, <48.8779, 12.6653, -6.7229> }
				triangle { <46.6598, 13.7568, -11.1772>, <48.8779, 12.6653, -6.7229>, <51.8634, 11.2081, -10.7993> }
				triangle { <48.8779, 12.6653, -6.7229>, <31.2525, 32.108, 3.6457>, <46.6598, 13.7568, -11.1772> }
				triangle { <48.8779, 12.6653, -6.7229>, <46.6598, 13.7568, -11.1772>, <31.2525, 32.108, 3.6457> }
				triangle { <33.04386, 35.2008, -0.1604>, <46.6598, 13.7568, -11.1772>, <31.2525, 32.108, 3.6457> }
				triangle { <33.04386, 35.2008, -0.1604>, <31.2525, 32.108, 3.6457>, <46.6598, 13.7568, -11.1772> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <17.9081, 34.09041, -7.6175>, <18.5343, 34.1191, -7.8268>, 0.04505 }
				cylinder { <18.5343, 34.1191, -7.8268>, <19.1605, 34.1479, -8.03611>, 0.04505 }
				cylinder { <19.1605, 34.1479, -8.03611>, <19.7867, 34.1766, -8.2454>, 0.04505 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <19.7867, 34.1766, -8.2454>, <26.4869, 36.5005, -13.5983>, <29.3403, 35.6827, -13.08695> }
				triangle { <19.7867, 34.1766, -8.2454>, <29.3403, 35.6827, -13.08695>, <26.4869, 36.5005, -13.5983> }
				triangle { <26.4869, 36.5005, -13.5983>, <32.5384, 37.7271, -17.08614>, <29.3403, 35.6827, -13.08695> }
				triangle { <26.4869, 36.5005, -13.5983>, <29.3403, 35.6827, -13.08695>, <32.5384, 37.7271, -17.08614> }
				triangle { <32.5384, 37.7271, -17.08614>, <34.03463, 34.8308, -13.00773>, <29.3403, 35.6827, -13.08695> }
				triangle { <32.5384, 37.7271, -17.08614>, <29.3403, 35.6827, -13.08695>, <34.03463, 34.8308, -13.00773> }
				triangle { <29.3403, 35.6827, -13.08695>, <34.03463, 34.8308, -13.00773>, <19.7867, 34.1766, -8.2454> }
				triangle { <29.3403, 35.6827, -13.08695>, <19.7867, 34.1766, -8.2454>, <34.03463, 34.8308, -13.00773> }
				triangle { <32.5384, 37.7271, -17.08614>, <35.356, 22.4797, -29.2152>, <38.2834, 14.9392, -32.7031> }
				triangle { <32.5384, 37.7271, -17.08614>, <38.2834, 14.9392, -32.7031>, <35.356, 22.4797, -29.2152> }
				triangle { <38.2834, 14.9392, -32.7031>, <39.1829, 9.7581, -32.702>, <35.3325, 12.5082, -29.3365> }
				triangle { <38.2834, 14.9392, -32.7031>, <35.3325, 12.5082, -29.3365>, <39.1829, 9.7581, -32.702> }
				triangle { <35.3325, 12.5082, -29.3365>, <32.5384, 37.7271, -17.08614>, <38.2834, 14.9392, -32.7031> }
				triangle { <35.3325, 12.5082, -29.3365>, <38.2834, 14.9392, -32.7031>, <32.5384, 37.7271, -17.08614> }
				triangle { <32.5384, 37.7271, -17.08614>, <35.3325, 12.5082, -29.3365>, <34.03463, 34.8308, -13.00773> }
				triangle { <32.5384, 37.7271, -17.08614>, <34.03463, 34.8308, -13.00773>, <35.3325, 12.5082, -29.3365> }
				triangle { <30.4176, 33.5973, -10.1504>, <28.5217, 32.5615, -8.05168>, <19.7867, 34.1766, -8.2454> }
				triangle { <30.4176, 33.5973, -10.1504>, <19.7867, 34.1766, -8.2454>, <28.5217, 32.5615, -8.05168> }
				triangle { <30.4176, 33.5973, -10.1504>, <35.5308, 31.9345, -8.9293>, <28.5217, 32.5615, -8.05168> }
				triangle { <30.4176, 33.5973, -10.1504>, <28.5217, 32.5615, -8.05168>, <35.5308, 31.9345, -8.9293> }
				triangle { <30.4176, 33.5973, -10.1504>, <34.03463, 34.8308, -13.00773>, <35.5308, 31.9345, -8.9293> }
				triangle { <30.4176, 33.5973, -10.1504>, <35.5308, 31.9345, -8.9293>, <34.03463, 34.8308, -13.00773> }
				triangle { <19.7867, 34.1766, -8.2454>, <34.03463, 34.8308, -13.00773>, <30.4176, 33.5973, -10.1504> }
				triangle { <19.7867, 34.1766, -8.2454>, <30.4176, 33.5973, -10.1504>, <34.03463, 34.8308, -13.00773> }
				triangle { <40.07886, 11.4636, -27.809>, <38.468, 16.4554, -20.7321>, <35.5308, 31.9345, -8.9293> }
				triangle { <40.07886, 11.4636, -27.809>, <35.5308, 31.9345, -8.9293>, <38.468, 16.4554, -20.7321> }
				triangle { <35.3325, 12.5082, -29.3365>, <39.1829, 9.7581, -32.702>, <40.07886, 11.4636, -27.809> }
				triangle { <35.3325, 12.5082, -29.3365>, <40.07886, 11.4636, -27.809>, <39.1829, 9.7581, -32.702> }
				triangle { <40.07886, 11.4636, -27.809>, <35.5308, 31.9345, -8.9293>, <35.3325, 12.5082, -29.3365> }
				triangle { <40.07886, 11.4636, -27.809>, <35.3325, 12.5082, -29.3365>, <35.5308, 31.9345, -8.9293> }
				triangle { <34.03463, 34.8308, -13.00773>, <35.3325, 12.5082, -29.3365>, <35.5308, 31.9345, -8.9293> }
				triangle { <34.03463, 34.8308, -13.00773>, <35.5308, 31.9345, -8.9293>, <35.3325, 12.5082, -29.3365> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <1.2101, 27.2138, -1.7178>, <1.2552, 30.6888, -1.9139>, 0.2373 }
			cylinder { <1.2552, 30.6888, -1.9139>, <0.2618, 34.02119, -1.7579>, 0.2373 }
			cylinder { <0.2618, 34.02119, -1.7579>, <-1.6699, 36.8745, -1.2655>, 0.2373 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-1.6699, 36.8745, -1.2655>, <-2.269, 37.7156, -1.1105>, 0.2373 }
				cylinder { <-2.269, 37.7156, -1.1105>, <-2.8873, 38.5414, -0.9484>, 0.2373 }
				cylinder { <-2.8873, 38.5414, -0.9484>, <-3.5244, 39.3512, -0.7792>, 0.2373 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-3.5244, 39.3512, -0.7792>, <-3.9685, 39.8365, -0.843>, 0.04505 }
				cylinder { <-3.9685, 39.8365, -0.843>, <-4.4212, 40.2593, -1.07327>, 0.04505 }
				cylinder { <-4.4212, 40.2593, -1.07327>, <-4.8498, 40.5891, -1.4531>, 0.04505 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-4.8498, 40.5891, -1.4531>, <-9.2358, 47.6834, -4.5159>, <-11.283, 47.508, -6.7183> }
				triangle { <-4.8498, 40.5891, -1.4531>, <-11.283, 47.508, -6.7183>, <-9.2358, 47.6834, -4.5159> }
				triangle { <-9.2358, 47.6834, -4.5159>, <-13.2837, 52.5483, -7.7155>, <-11.283, 47.508, -6.7183> }
				triangle { <-9.2358, 47.6834, -4.5159>, <-11.283, 47.508, -6.7183>, <-13.2837, 52.5483, -7.7155> }
				triangle { <-13.2837, 52.5483, -7.7155>, <-14.602, 48.09246, -10.09643>, <-11.283, 47.508, -6.7183> }
				triangle { <-13.2837, 52.5483, -7.7155>, <-11.283, 47.508, -6.7183>, <-14.602, 48.09246, -10.09643> }
				triangle { <-11.283, 47.508, -6.7183>, <-14.602, 48.09246, -10.09643>, <-4.8498, 40.5891, -1.4531> }
				triangle { <-11.283, 47.508, -6.7183>, <-4.8498, 40.5891, -1.4531>, <-14.602, 48.09246, -10.09643> }
				triangle { <-13.2837, 52.5483, -7.7155>, <-30.5208, 52.8136, 1.7897>, <-38.9523, 51.4608, 3.9518> }
				triangle { <-13.2837, 52.5483, -7.7155>, <-38.9523, 51.4608, 3.9518>, <-30.5208, 52.8136, 1.7897> }
				triangle { <-38.9523, 51.4608, 3.9518>, <-43.149, 48.4708, 5.001241>, <-37.6197, 46.7129, 5.2298> }
				triangle { <-38.9523, 51.4608, 3.9518>, <-37.6197, 46.7129, 5.2298>, <-43.149, 48.4708, 5.001241> }
				triangle { <-37.6197, 46.7129, 5.2298>, <-13.2837, 52.5483, -7.7155>, <-38.9523, 51.4608, 3.9518> }
				triangle { <-37.6197, 46.7129, 5.2298>, <-38.9523, 51.4608, 3.9518>, <-13.2837, 52.5483, -7.7155> }
				triangle { <-13.2837, 52.5483, -7.7155>, <-37.6197, 46.7129, 5.2298>, <-14.602, 48.09246, -10.09643> }
				triangle { <-13.2837, 52.5483, -7.7155>, <-14.602, 48.09246, -10.09643>, <-37.6197, 46.7129, 5.2298> }
				triangle { <-12.2321, 44.2998, -8.4325>, <-11.02867, 41.6234, -7.7538>, <-4.8498, 40.5891, -1.4531> }
				triangle { <-12.2321, 44.2998, -8.4325>, <-4.8498, 40.5891, -1.4531>, <-11.02867, 41.6234, -7.7538> }
				triangle { <-12.2321, 44.2998, -8.4325>, <-15.9202, 43.6366, -12.4772>, <-11.02867, 41.6234, -7.7538> }
				triangle { <-12.2321, 44.2998, -8.4325>, <-11.02867, 41.6234, -7.7538>, <-15.9202, 43.6366, -12.4772> }
				triangle { <-12.2321, 44.2998, -8.4325>, <-14.602, 48.09246, -10.09643>, <-15.9202, 43.6366, -12.4772> }
				triangle { <-12.2321, 44.2998, -8.4325>, <-15.9202, 43.6366, -12.4772>, <-14.602, 48.09246, -10.09643> }
				triangle { <-4.8498, 40.5891, -1.4531>, <-14.602, 48.09246, -10.09643>, <-12.2321, 44.2998, -8.4325> }
				triangle { <-4.8498, 40.5891, -1.4531>, <-12.2321, 44.2998, -8.4325>, <-14.602, 48.09246, -10.09643> }
				triangle { <-40.5342, 46.1138, 1.09479>, <-33.2627, 43.5454, -3.1624>, <-15.9202, 43.6366, -12.4772> }
				triangle { <-40.5342, 46.1138, 1.09479>, <-15.9202, 43.6366, -12.4772>, <-33.2627, 43.5454, -3.1624> }
				triangle { <-37.6197, 46.7129, 5.2298>, <-43.149, 48.4708, 5.001241>, <-40.5342, 46.1138, 1.09479> }
				triangle { <-37.6197, 46.7129, 5.2298>, <-40.5342, 46.1138, 1.09479>, <-43.149, 48.4708, 5.001241> }
				triangle { <-40.5342, 46.1138, 1.09479>, <-15.9202, 43.6366, -12.4772>, <-37.6197, 46.7129, 5.2298> }
				triangle { <-40.5342, 46.1138, 1.09479>, <-37.6197, 46.7129, 5.2298>, <-15.9202, 43.6366, -12.4772> }
				triangle { <-14.602, 48.09246, -10.09643>, <-37.6197, 46.7129, 5.2298>, <-15.9202, 43.6366, -12.4772> }
				triangle { <-14.602, 48.09246, -10.09643>, <-15.9202, 43.6366, -12.4772>, <-37.6197, 46.7129, 5.2298> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-3.5244, 39.3512, -0.7792>, <-4.18, 40.1447, -0.603>, 0.2373 }
				cylinder { <-4.18, 40.1447, -0.603>, <-4.8536, 40.9213, -0.4199>, 0.2373 }
				cylinder { <-4.8536, 40.9213, -0.4199>, <-5.5449, 41.6807, -0.2301>, 0.2373 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-5.5449, 41.6807, -0.2301>, <-5.911, 42.1525, 0.05275>, 0.04505 }
				cylinder { <-5.911, 42.1525, 0.05275>, <-6.1794, 42.5815, 0.4778>, 0.04505 }
				cylinder { <-6.1794, 42.5815, 0.4778>, <-6.3305, 42.9365, 1.01441>, 0.04505 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.3305, 42.9365, 1.01441>, <-4.768, 47.3553, 8.5629>, <-6.9526, 48.6811, 10.1573> }
				triangle { <-6.3305, 42.9365, 1.01441>, <-6.9526, 48.6811, 10.1573>, <-4.768, 47.3553, 8.5629> }
				triangle { <-4.768, 47.3553, 8.5629>, <-4.7321, 51.07796, 14.5987>, <-6.9526, 48.6811, 10.1573> }
				triangle { <-4.768, 47.3553, 8.5629>, <-6.9526, 48.6811, 10.1573>, <-4.7321, 51.07796, 14.5987> }
				triangle { <-4.7321, 51.07796, 14.5987>, <-9.7683, 51.01406, 13.2228>, <-6.9526, 48.6811, 10.1573> }
				triangle { <-4.7321, 51.07796, 14.5987>, <-6.9526, 48.6811, 10.1573>, <-9.7683, 51.01406, 13.2228> }
				triangle { <-6.9526, 48.6811, 10.1573>, <-9.7683, 51.01406, 13.2228>, <-6.3305, 42.9365, 1.01441> }
				triangle { <-6.9526, 48.6811, 10.1573>, <-6.3305, 42.9365, 1.01441>, <-9.7683, 51.01406, 13.2228> }
				triangle { <-4.7321, 51.07796, 14.5987>, <-8.3416, 38.3694, 29.1933>, <-12.3863, 33.7314, 35.496> }
				triangle { <-4.7321, 51.07796, 14.5987>, <-12.3863, 33.7314, 35.496>, <-8.3416, 38.3694, 29.1933> }
				triangle { <-12.3863, 33.7314, 35.496>, <-16.1011, 30.5069, 37.3551>, <-14.5833, 31.03311, 31.7752> }
				triangle { <-12.3863, 33.7314, 35.496>, <-14.5833, 31.03311, 31.7752>, <-16.1011, 30.5069, 37.3551> }
				triangle { <-14.5833, 31.03311, 31.7752>, <-4.7321, 51.07796, 14.5987>, <-12.3863, 33.7314, 35.496> }
				triangle { <-14.5833, 31.03311, 31.7752>, <-12.3863, 33.7314, 35.496>, <-4.7321, 51.07796, 14.5987> }
				triangle { <-4.7321, 51.07796, 14.5987>, <-14.5833, 31.03311, 31.7752>, <-9.7683, 51.01406, 13.2228> }
				triangle { <-4.7321, 51.07796, 14.5987>, <-9.7683, 51.01406, 13.2228>, <-14.5833, 31.03311, 31.7752> }
				triangle { <-10.5787, 48.6351, 9.1667>, <-11.6173, 47.2684, 6.6916>, <-6.3305, 42.9365, 1.01441> }
				triangle { <-10.5787, 48.6351, 9.1667>, <-6.3305, 42.9365, 1.01441>, <-11.6173, 47.2684, 6.6916> }
				triangle { <-10.5787, 48.6351, 9.1667>, <-14.8045, 50.9501, 11.8469>, <-11.6173, 47.2684, 6.6916> }
				triangle { <-10.5787, 48.6351, 9.1667>, <-11.6173, 47.2684, 6.6916>, <-14.8045, 50.9501, 11.8469> }
				triangle { <-10.5787, 48.6351, 9.1667>, <-9.7683, 51.01406, 13.2228>, <-14.8045, 50.9501, 11.8469> }
				triangle { <-10.5787, 48.6351, 9.1667>, <-14.8045, 50.9501, 11.8469>, <-9.7683, 51.01406, 13.2228> }
				triangle { <-6.3305, 42.9365, 1.01441>, <-9.7683, 51.01406, 13.2228>, <-10.5787, 48.6351, 9.1667> }
				triangle { <-6.3305, 42.9365, 1.01441>, <-10.5787, 48.6351, 9.1667>, <-9.7683, 51.01406, 13.2228> }
				triangle { <-18.4298, 33.6547, 33.8449>, <-18.8169, 38.2365, 26.3314>, <-14.8045, 50.9501, 11.8469> }
				triangle { <-18.4298, 33.6547, 33.8449>, <-14.8045, 50.9501, 11.8469>, <-18.8169, 38.2365, 26.3314> }
				triangle { <-14.5833, 31.03311, 31.7752>, <-16.1011, 30.5069, 37.3551>, <-18.4298, 33.6547, 33.8449> }
				triangle { <-14.5833, 31.03311, 31.7752>, <-18.4298, 33.6547, 33.8449>, <-16.1011, 30.5069, 37.3551> }
				triangle { <-18.4298, 33.6547, 33.8449>, <-14.8045, 50.9501, 11.8469>, <-14.5833, 31.03311, 31.7752> }
				triangle { <-18.4298, 33.6547, 33.8449>, <-14.5833, 31.03311, 31.7752>, <-14.8045, 50.9501, 11.8469> }
				triangle { <-9.7683, 51.01406, 13.2228>, <-14.5833, 31.03311, 31.7752>, <-14.8045, 50.9501, 11.8469> }
				triangle { <-9.7683, 51.01406, 13.2228>, <-14.8045, 50.9501, 11.8469>, <-14.5833, 31.03311, 31.7752> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-5.5449, 41.6807, -0.2301>, <-6.2533, 42.4222, -0.03364>, 0.2373 }
				cylinder { <-6.2533, 42.4222, -0.03364>, <-6.9786, 43.1455, 0.1693>, 0.2373 }
				cylinder { <-6.9786, 43.1455, 0.1693>, <-7.7203, 43.8502, 0.3787>, 0.2373 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.7203, 43.8502, 0.3787>, <-8.2281, 44.2713, 0.3393>, 0.04505 }
				cylinder { <-8.2281, 44.2713, 0.3393>, <-8.7375, 44.637, 0.1309>, 0.04505 }
				cylinder { <-8.7375, 44.637, 0.1309>, <-9.2118, 44.9208, -0.2313>, 0.04505 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-9.2118, 44.9208, -0.2313>, <-14.5727, 51.4676, -2.9421>, <-16.5986, 51.1096, -5.142> }
				triangle { <-9.2118, 44.9208, -0.2313>, <-16.5986, 51.1096, -5.142>, <-14.5727, 51.4676, -2.9421> }
				triangle { <-14.5727, 51.4676, -2.9421>, <-19.2905, 55.8623, -5.8949>, <-16.5986, 51.1096, -5.142> }
				triangle { <-14.5727, 51.4676, -2.9421>, <-16.5986, 51.1096, -5.142>, <-19.2905, 55.8623, -5.8949> }
				triangle { <-19.2905, 55.8623, -5.8949>, <-20.0018, 51.3797, -8.4758>, <-16.5986, 51.1096, -5.142> }
				triangle { <-19.2905, 55.8623, -5.8949>, <-16.5986, 51.1096, -5.142>, <-20.0018, 51.3797, -8.4758> }
				triangle { <-16.5986, 51.1096, -5.142>, <-20.0018, 51.3797, -8.4758>, <-9.2118, 44.9208, -0.2313> }
				triangle { <-16.5986, 51.1096, -5.142>, <-9.2118, 44.9208, -0.2313>, <-20.0018, 51.3797, -8.4758> }
				triangle { <-19.2905, 55.8623, -5.8949>, <-36.2967, 53.2904, 3.6816>, <-44.4354, 50.6793, 5.8121> }
				triangle { <-19.2905, 55.8623, -5.8949>, <-44.4354, 50.6793, 5.8121>, <-36.2967, 53.2904, 3.6816> }
				triangle { <-44.4354, 50.6793, 5.8121>, <-48.1648, 47.08935, 6.7377>, <-42.4428, 46.1099, 6.8618> }
				triangle { <-44.4354, 50.6793, 5.8121>, <-42.4428, 46.1099, 6.8618>, <-48.1648, 47.08935, 6.7377> }
				triangle { <-42.4428, 46.1099, 6.8618>, <-19.2905, 55.8623, -5.8949>, <-44.4354, 50.6793, 5.8121> }
				triangle { <-42.4428, 46.1099, 6.8618>, <-44.4354, 50.6793, 5.8121>, <-19.2905, 55.8623, -5.8949> }
				triangle { <-19.2905, 55.8623, -5.8949>, <-42.4428, 46.1099, 6.8618>, <-20.0018, 51.3797, -8.4758> }
				triangle { <-19.2905, 55.8623, -5.8949>, <-20.0018, 51.3797, -8.4758>, <-42.4428, 46.1099, 6.8618> }
				triangle { <-17.1107, 47.8821, -7.000293>, <-15.54, 45.3712, -6.452>, <-9.2118, 44.9208, -0.2313> }
				triangle { <-17.1107, 47.8821, -7.000293>, <-9.2118, 44.9208, -0.2313>, <-15.54, 45.3712, -6.452> }
				triangle { <-17.1107, 47.8821, -7.000293>, <-20.713, 46.897, -11.05667>, <-15.54, 45.3712, -6.452> }
				triangle { <-17.1107, 47.8821, -7.000293>, <-15.54, 45.3712, -6.452>, <-20.713, 46.897, -11.05667> }
				triangle { <-17.1107, 47.8821, -7.000293>, <-20.0018, 51.3797, -8.4758>, <-20.713, 46.897, -11.05667> }
				triangle { <-17.1107, 47.8821, -7.000293>, <-20.713, 46.897, -11.05667>, <-20.0018, 51.3797, -8.4758> }
				triangle { <-9.2118, 44.9208, -0.2313>, <-20.0018, 51.3797, -8.4758>, <-17.1107, 47.8821, -7.000293> }
				triangle { <-9.2118, 44.9208, -0.2313>, <-17.1107, 47.8821, -7.000293>, <-20.0018, 51.3797, -8.4758> }
				triangle { <-45.2889, 45.3002, 2.715>, <-37.7762, 43.9665, -1.6865>, <-20.713, 46.897, -11.05667> }
				triangle { <-45.2889, 45.3002, 2.715>, <-20.713, 46.897, -11.05667>, <-37.7762, 43.9665, -1.6865> }
				triangle { <-42.4428, 46.1099, 6.8618>, <-48.1648, 47.08935, 6.7377>, <-45.2889, 45.3002, 2.715> }
				triangle { <-42.4428, 46.1099, 6.8618>, <-45.2889, 45.3002, 2.715>, <-48.1648, 47.08935, 6.7377> }
				triangle { <-45.2889, 45.3002, 2.715>, <-20.713, 46.897, -11.05667>, <-42.4428, 46.1099, 6.8618> }
				triangle { <-45.2889, 45.3002, 2.715>, <-42.4428, 46.1099, 6.8618>, <-20.713, 46.897, -11.05667> }
				triangle { <-20.0018, 51.3797, -8.4758>, <-42.4428, 46.1099, 6.8618>, <-20.713, 46.897, -11.05667> }
				triangle { <-20.0018, 51.3797, -8.4758>, <-20.713, 46.897, -11.05667>, <-42.4428, 46.1099, 6.8618> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.7203, 43.8502, 0.3787>, <-8.1896, 44.2961, 0.5112>, 0.04505 }
				cylinder { <-8.1896, 44.2961, 0.5112>, <-8.659, 44.7421, 0.6437>, 0.04505 }
				cylinder { <-8.659, 44.7421, 0.6437>, <-9.1284, 45.188, 0.7762>, 0.04505 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-9.1284, 45.188, 0.7762>, <-12.6841, 52.3826, 4.5896>, <-15.5131, 53.2746, 4.06626> }
				triangle { <-9.1284, 45.188, 0.7762>, <-15.5131, 53.2746, 4.06626>, <-12.6841, 52.3826, 4.5896> }
				triangle { <-12.6841, 52.3826, 4.5896>, <-16.53, 57.8325, 6.9975>, <-15.5131, 53.2746, 4.06626> }
				triangle { <-12.6841, 52.3826, 4.5896>, <-15.5131, 53.2746, 4.06626>, <-16.53, 57.8325, 6.9975> }
				triangle { <-16.53, 57.8325, 6.9975>, <-19.808, 55.3351, 3.7915>, <-15.5131, 53.2746, 4.06626> }
				triangle { <-16.53, 57.8325, 6.9975>, <-15.5131, 53.2746, 4.06626>, <-19.808, 55.3351, 3.7915> }
				triangle { <-15.5131, 53.2746, 4.06626>, <-19.808, 55.3351, 3.7915>, <-9.1284, 45.188, 0.7762> }
				triangle { <-15.5131, 53.2746, 4.06626>, <-9.1284, 45.188, 0.7762>, <-19.808, 55.3351, 3.7915> }
				triangle { <-16.53, 57.8325, 6.9975>, <-26.5377, 51.315, 22.647>, <-32.9624, 48.2692, 27.8472> }
				triangle { <-16.53, 57.8325, 6.9975>, <-32.9624, 48.2692, 27.8472>, <-26.5377, 51.315, 22.647> }
				triangle { <-32.9624, 48.2692, 27.8472>, <-36.7043, 44.8461, 29.2378>, <-32.3104, 43.741, 25.6062> }
				triangle { <-32.9624, 48.2692, 27.8472>, <-32.3104, 43.741, 25.6062>, <-36.7043, 44.8461, 29.2378> }
				triangle { <-32.3104, 43.741, 25.6062>, <-16.53, 57.8325, 6.9975>, <-32.9624, 48.2692, 27.8472> }
				triangle { <-32.3104, 43.741, 25.6062>, <-32.9624, 48.2692, 27.8472>, <-16.53, 57.8325, 6.9975> }
				triangle { <-16.53, 57.8325, 6.9975>, <-32.3104, 43.741, 25.6062>, <-19.808, 55.3351, 3.7915> }
				triangle { <-16.53, 57.8325, 6.9975>, <-19.808, 55.3351, 3.7915>, <-32.3104, 43.741, 25.6062> }
				triangle { <-17.8732, 51.4765, 1.7579>, <-17.1422, 48.9862, 0.2294>, <-9.1284, 45.188, 0.7762> }
				triangle { <-17.8732, 51.4765, 1.7579>, <-9.1284, 45.188, 0.7762>, <-17.1422, 48.9862, 0.2294> }
				triangle { <-17.8732, 51.4765, 1.7579>, <-23.0861, 52.8378, 0.5855>, <-17.1422, 48.9862, 0.2294> }
				triangle { <-17.8732, 51.4765, 1.7579>, <-17.1422, 48.9862, 0.2294>, <-23.0861, 52.8378, 0.5855> }
				triangle { <-17.8732, 51.4765, 1.7579>, <-19.808, 55.3351, 3.7915>, <-23.0861, 52.8378, 0.5855> }
				triangle { <-17.8732, 51.4765, 1.7579>, <-23.0861, 52.8378, 0.5855>, <-19.808, 55.3351, 3.7915> }
				triangle { <-9.1284, 45.188, 0.7762>, <-19.808, 55.3351, 3.7915>, <-17.8732, 51.4765, 1.7579> }
				triangle { <-9.1284, 45.188, 0.7762>, <-17.8732, 51.4765, 1.7579>, <-19.808, 55.3351, 3.7915> }
				triangle { <-36.896, 45.2724, 24.0>, <-33.356, 46.1204, 15.9785>, <-23.0861, 52.8378, 0.5855> }
				triangle { <-36.896, 45.2724, 24.0>, <-23.0861, 52.8378, 0.5855>, <-33.356, 46.1204, 15.9785> }
				triangle { <-32.3104, 43.741, 25.6062>, <-36.7043, 44.8461, 29.2378>, <-36.896, 45.2724, 24.0> }
				triangle { <-32.3104, 43.741, 25.6062>, <-36.896, 45.2724, 24.0>, <-36.7043, 44.8461, 29.2378> }
				triangle { <-36.896, 45.2724, 24.0>, <-23.0861, 52.8378, 0.5855>, <-32.3104, 43.741, 25.6062> }
				triangle { <-36.896, 45.2724, 24.0>, <-32.3104, 43.741, 25.6062>, <-23.0861, 52.8378, 0.5855> }
				triangle { <-19.808, 55.3351, 3.7915>, <-32.3104, 43.741, 25.6062>, <-23.0861, 52.8378, 0.5855> }
				triangle { <-19.808, 55.3351, 3.7915>, <-23.0861, 52.8378, 0.5855>, <-32.3104, 43.741, 25.6062> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <1.2101, 27.2138, -1.7178>, <1.781, 29.6638, -2.213>, 0.4661 }
		cylinder { <1.781, 29.6638, -2.213>, <2.1225, 32.1338, -2.8094>, 0.4661 }
		cylinder { <2.1225, 32.1338, -2.8094>, <2.2312, 34.6001, -3.5012>, 0.4661 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <2.2312, 34.6001, -3.5012>, <1.7185, 36.4266, -4.2597>, 0.1392 }
			cylinder { <1.7185, 36.4266, -4.2597>, <0.6583, 37.9298, -5.1487>, 0.1392 }
			cylinder { <0.6583, 37.9298, -5.1487>, <-0.8423, 38.958, -6.07867>, 0.1392 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-0.8423, 38.958, -6.07867>, <-1.3009, 39.254, -6.3574>, 0.1392 }
				cylinder { <-1.3009, 39.254, -6.3574>, <-1.7677, 39.5373, -6.6357>, 0.1392 }
				cylinder { <-1.7677, 39.5373, -6.6357>, <-2.2424, 39.8079, -6.9135>, 0.1392 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-2.2424, 39.8079, -6.9135>, <-2.3899, 39.8886, -7.06705>, 0.01552 }
				cylinder { <-2.3899, 39.8886, -7.06705>, <-2.4979, 39.9437, -7.2597>, 0.01552 }
				cylinder { <-2.4979, 39.9437, -7.2597>, <-2.5585, 39.9691, -7.4777>, 0.01552 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-2.5585, 39.9691, -7.4777>, <-4.5599, 42.4091, -11.6297>, <-4.6095, 41.6764, -13.2379> }
				triangle { <-2.5585, 39.9691, -7.4777>, <-4.6095, 41.6764, -13.2379>, <-4.5599, 42.4091, -11.6297> }
				triangle { <-4.5599, 42.4091, -11.6297>, <-5.9802, 43.7578, -15.3024>, <-4.6095, 41.6764, -13.2379> }
				triangle { <-4.5599, 42.4091, -11.6297>, <-4.6095, 41.6764, -13.2379>, <-5.9802, 43.7578, -15.3024> }
				triangle { <-5.9802, 43.7578, -15.3024>, <-4.9102, 40.9549, -15.9273>, <-4.6095, 41.6764, -13.2379> }
				triangle { <-5.9802, 43.7578, -15.3024>, <-4.6095, 41.6764, -13.2379>, <-4.9102, 40.9549, -15.9273> }
				triangle { <-4.6095, 41.6764, -13.2379>, <-4.9102, 40.9549, -15.9273>, <-2.5585, 39.9691, -7.4777> }
				triangle { <-4.6095, 41.6764, -13.2379>, <-2.5585, 39.9691, -7.4777>, <-4.9102, 40.9549, -15.9273> }
				triangle { <-5.9802, 43.7578, -15.3024>, <-16.849, 39.9663, -16.305>, <-21.00818, 37.2034, -17.6465> }
				triangle { <-5.9802, 43.7578, -15.3024>, <-21.00818, 37.2034, -17.6465>, <-16.849, 39.9663, -16.305> }
				triangle { <-21.00818, 37.2034, -17.6465>, <-22.6667, 34.6101, -17.8716>, <-20.07599, 35.1186, -15.7164> }
				triangle { <-21.00818, 37.2034, -17.6465>, <-20.07599, 35.1186, -15.7164>, <-22.6667, 34.6101, -17.8716> }
				triangle { <-20.07599, 35.1186, -15.7164>, <-5.9802, 43.7578, -15.3024>, <-21.00818, 37.2034, -17.6465> }
				triangle { <-20.07599, 35.1186, -15.7164>, <-21.00818, 37.2034, -17.6465>, <-5.9802, 43.7578, -15.3024> }
				triangle { <-5.9802, 43.7578, -15.3024>, <-20.07599, 35.1186, -15.7164>, <-4.9102, 40.9549, -15.9273> }
				triangle { <-5.9802, 43.7578, -15.3024>, <-4.9102, 40.9549, -15.9273>, <-20.07599, 35.1186, -15.7164> }
				triangle { <-3.8391, 39.6583, -13.6877>, <-3.1048, 38.5971, -12.4794>, <-2.5585, 39.9691, -7.4777> }
				triangle { <-3.8391, 39.6583, -13.6877>, <-2.5585, 39.9691, -7.4777>, <-3.1048, 38.5971, -12.4794> }
				triangle { <-3.8391, 39.6583, -13.6877>, <-3.8402, 38.152, -16.5521>, <-3.1048, 38.5971, -12.4794> }
				triangle { <-3.8391, 39.6583, -13.6877>, <-3.1048, 38.5971, -12.4794>, <-3.8402, 38.152, -16.5521> }
				triangle { <-3.8391, 39.6583, -13.6877>, <-4.9102, 40.9549, -15.9273>, <-3.8402, 38.152, -16.5521> }
				triangle { <-3.8391, 39.6583, -13.6877>, <-3.8402, 38.152, -16.5521>, <-4.9102, 40.9549, -15.9273> }
				triangle { <-2.5585, 39.9691, -7.4777>, <-4.9102, 40.9549, -15.9273>, <-3.8391, 39.6583, -13.6877> }
				triangle { <-2.5585, 39.9691, -7.4777>, <-3.8391, 39.6583, -13.6877>, <-4.9102, 40.9549, -15.9273> }
				triangle { <-19.7242, 33.8399, -18.3963>, <-14.6234, 34.1363, -17.6046>, <-3.8402, 38.152, -16.5521> }
				triangle { <-19.7242, 33.8399, -18.3963>, <-3.8402, 38.152, -16.5521>, <-14.6234, 34.1363, -17.6046> }
				triangle { <-20.07599, 35.1186, -15.7164>, <-22.6667, 34.6101, -17.8716>, <-19.7242, 33.8399, -18.3963> }
				triangle { <-20.07599, 35.1186, -15.7164>, <-19.7242, 33.8399, -18.3963>, <-22.6667, 34.6101, -17.8716> }
				triangle { <-19.7242, 33.8399, -18.3963>, <-3.8402, 38.152, -16.5521>, <-20.07599, 35.1186, -15.7164> }
				triangle { <-19.7242, 33.8399, -18.3963>, <-20.07599, 35.1186, -15.7164>, <-3.8402, 38.152, -16.5521> }
				triangle { <-4.9102, 40.9549, -15.9273>, <-20.07599, 35.1186, -15.7164>, <-3.8402, 38.152, -16.5521> }
				triangle { <-4.9102, 40.9549, -15.9273>, <-3.8402, 38.152, -16.5521>, <-20.07599, 35.1186, -15.7164> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-2.2424, 39.8079, -6.9135>, <-2.7246, 40.06553, -7.1905>, 0.1392 }
				cylinder { <-2.7246, 40.06553, -7.1905>, <-3.2141, 40.3099, -7.4667>, 0.1392 }
				cylinder { <-3.2141, 40.3099, -7.4667>, <-3.7107, 40.5411, -7.7418>, 0.1392 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-3.7107, 40.5411, -7.7418>, <-3.9109, 40.64, -7.7862>, 0.01552 }
				cylinder { <-3.9109, 40.64, -7.7862>, <-4.1123, 40.7448, -7.7696>, 0.01552 }
				cylinder { <-4.1123, 40.7448, -7.7696>, <-4.3004, 40.8479, -7.6933>, 0.01552 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-4.3004, 40.8479, -7.6933>, <-7.1292, 43.9636, -4.6129>, <-8.8719, 44.182, -4.8147> }
				triangle { <-4.3004, 40.8479, -7.6933>, <-8.8719, 44.182, -4.8147>, <-7.1292, 43.9636, -4.6129> }
				triangle { <-7.1292, 43.9636, -4.6129>, <-9.9437, 46.2427, -2.5611>, <-8.8719, 44.182, -4.8147> }
				triangle { <-7.1292, 43.9636, -4.6129>, <-8.8719, 44.182, -4.8147>, <-9.9437, 46.2427, -2.5611> }
				triangle { <-9.9437, 46.2427, -2.5611>, <-11.592, 44.8441, -4.7334>, <-8.8719, 44.182, -4.8147> }
				triangle { <-9.9437, 46.2427, -2.5611>, <-8.8719, 44.182, -4.8147>, <-11.592, 44.8441, -4.7334> }
				triangle { <-8.8719, 44.182, -4.8147>, <-11.592, 44.8441, -4.7334>, <-4.3004, 40.8479, -7.6933> }
				triangle { <-8.8719, 44.182, -4.8147>, <-4.3004, 40.8479, -7.6933>, <-11.592, 44.8441, -4.7334> }
				triangle { <-9.9437, 46.2427, -2.5611>, <-14.5656, 39.4021, 5.523>, <-17.7739, 36.2561, 8.08072> }
				triangle { <-9.9437, 46.2427, -2.5611>, <-17.7739, 36.2561, 8.08072>, <-14.5656, 39.4021, 5.523> }
				triangle { <-17.7739, 36.2561, 8.08072>, <-19.4783, 33.7056, 8.4221>, <-16.9005, 34.08078, 6.2245> }
				triangle { <-17.7739, 36.2561, 8.08072>, <-16.9005, 34.08078, 6.2245>, <-19.4783, 33.7056, 8.4221> }
				triangle { <-16.9005, 34.08078, 6.2245>, <-9.9437, 46.2427, -2.5611>, <-17.7739, 36.2561, 8.08072> }
				triangle { <-16.9005, 34.08078, 6.2245>, <-17.7739, 36.2561, 8.08072>, <-9.9437, 46.2427, -2.5611> }
				triangle { <-9.9437, 46.2427, -2.5611>, <-16.9005, 34.08078, 6.2245>, <-11.592, 44.8441, -4.7334> }
				triangle { <-9.9437, 46.2427, -2.5611>, <-11.592, 44.8441, -4.7334>, <-16.9005, 34.08078, 6.2245> }
				triangle { <-10.05871, 43.175, -6.3787>, <-9.3708, 42.06151, -7.5671>, <-4.3004, 40.8479, -7.6933> }
				triangle { <-10.05871, 43.175, -6.3787>, <-4.3004, 40.8479, -7.6933>, <-9.3708, 42.06151, -7.5671> }
				triangle { <-10.05871, 43.175, -6.3787>, <-13.2403, 43.4455, -6.9057>, <-9.3708, 42.06151, -7.5671> }
				triangle { <-10.05871, 43.175, -6.3787>, <-9.3708, 42.06151, -7.5671>, <-13.2403, 43.4455, -6.9057> }
				triangle { <-10.05871, 43.175, -6.3787>, <-11.592, 44.8441, -4.7334>, <-13.2403, 43.4455, -6.9057> }
				triangle { <-10.05871, 43.175, -6.3787>, <-13.2403, 43.4455, -6.9057>, <-11.592, 44.8441, -4.7334> }
				triangle { <-4.3004, 40.8479, -7.6933>, <-11.592, 44.8441, -4.7334>, <-10.05871, 43.175, -6.3787> }
				triangle { <-4.3004, 40.8479, -7.6933>, <-10.05871, 43.175, -6.3787>, <-11.592, 44.8441, -4.7334> }
				triangle { <-19.7519, 34.5778, 5.474>, <-17.994, 36.493, 1.004781>, <-13.2403, 43.4455, -6.9057> }
				triangle { <-19.7519, 34.5778, 5.474>, <-13.2403, 43.4455, -6.9057>, <-17.994, 36.493, 1.004781> }
				triangle { <-16.9005, 34.08078, 6.2245>, <-19.4783, 33.7056, 8.4221>, <-19.7519, 34.5778, 5.474> }
				triangle { <-16.9005, 34.08078, 6.2245>, <-19.7519, 34.5778, 5.474>, <-19.4783, 33.7056, 8.4221> }
				triangle { <-19.7519, 34.5778, 5.474>, <-13.2403, 43.4455, -6.9057>, <-16.9005, 34.08078, 6.2245> }
				triangle { <-19.7519, 34.5778, 5.474>, <-16.9005, 34.08078, 6.2245>, <-13.2403, 43.4455, -6.9057> }
				triangle { <-11.592, 44.8441, -4.7334>, <-16.9005, 34.08078, 6.2245>, <-13.2403, 43.4455, -6.9057> }
				triangle { <-11.592, 44.8441, -4.7334>, <-13.2403, 43.4455, -6.9057>, <-16.9005, 34.08078, 6.2245> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-3.7107, 40.5411, -7.7418>, <-4.2139, 40.7589, -8.01569>, 0.1392 }
				cylinder { <-4.2139, 40.7589, -8.01569>, <-4.7235, 40.9631, -8.2881>, 0.1392 }
				cylinder { <-4.7235, 40.9631, -8.2881>, <-5.2392, 41.1537, -8.559>, 0.1392 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-5.2392, 41.1537, -8.559>, <-5.4014, 41.2057, -8.7101>, 0.01552 }
				cylinder { <-5.4014, 41.2057, -8.7101>, <-5.5225, 41.2353, -8.9006>, 0.01552 }
				cylinder { <-5.5225, 41.2353, -8.9006>, <-5.5937, 41.2403, -9.1168>, 0.01552 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.5937, 41.2403, -9.1168>, <-8.0451, 43.1606, -13.3002>, <-8.05476, 42.3377, -14.8649> }
				triangle { <-5.5937, 41.2403, -9.1168>, <-8.05476, 42.3377, -14.8649>, <-8.0451, 43.1606, -13.3002> }
				triangle { <-8.0451, 43.1606, -13.3002>, <-9.76, 44.1033, -16.9739>, <-8.05476, 42.3377, -14.8649> }
				triangle { <-8.0451, 43.1606, -13.3002>, <-8.05476, 42.3377, -14.8649>, <-9.76, 44.1033, -16.9739> }
				triangle { <-9.76, 44.1033, -16.9739>, <-8.353, 41.4318, -17.4982>, <-8.05476, 42.3377, -14.8649> }
				triangle { <-9.76, 44.1033, -16.9739>, <-8.05476, 42.3377, -14.8649>, <-8.353, 41.4318, -17.4982> }
				triangle { <-8.05476, 42.3377, -14.8649>, <-8.353, 41.4318, -17.4982>, <-5.5937, 41.2403, -9.1168> }
				triangle { <-8.05476, 42.3377, -14.8649>, <-5.5937, 41.2403, -9.1168>, <-8.353, 41.4318, -17.4982> }
				triangle { <-9.76, 44.1033, -16.9739>, <-20.06341, 38.8847, -17.3154>, <-23.8674, 35.5344, -18.3341> }
				triangle { <-9.76, 44.1033, -16.9739>, <-23.8674, 35.5344, -18.3341>, <-20.06341, 38.8847, -17.3154> }
				triangle { <-23.8674, 35.5344, -18.3341>, <-25.1768, 32.7395, -18.3541>, <-22.6008, 33.7009, -16.3403> }
				triangle { <-23.8674, 35.5344, -18.3341>, <-22.6008, 33.7009, -16.3403>, <-25.1768, 32.7395, -18.3541> }
				triangle { <-22.6008, 33.7009, -16.3403>, <-9.76, 44.1033, -16.9739>, <-23.8674, 35.5344, -18.3341> }
				triangle { <-22.6008, 33.7009, -16.3403>, <-23.8674, 35.5344, -18.3341>, <-9.76, 44.1033, -16.9739> }
				triangle { <-9.76, 44.1033, -16.9739>, <-22.6008, 33.7009, -16.3403>, <-8.353, 41.4318, -17.4982> }
				triangle { <-9.76, 44.1033, -16.9739>, <-8.353, 41.4318, -17.4982>, <-22.6008, 33.7009, -16.3403> }
				triangle { <-7.04174, 40.4142, -15.2423>, <-6.1316, 39.5273, -14.01325>, <-5.5937, 41.2403, -9.1168> }
				triangle { <-7.04174, 40.4142, -15.2423>, <-5.5937, 41.2403, -9.1168>, <-6.1316, 39.5273, -14.01325> }
				triangle { <-7.04174, 40.4142, -15.2423>, <-6.946, 38.7602, -18.02246>, <-6.1316, 39.5273, -14.01325> }
				triangle { <-7.04174, 40.4142, -15.2423>, <-6.1316, 39.5273, -14.01325>, <-6.946, 38.7602, -18.02246> }
				triangle { <-7.04174, 40.4142, -15.2423>, <-8.353, 41.4318, -17.4982>, <-6.946, 38.7602, -18.02246> }
				triangle { <-7.04174, 40.4142, -15.2423>, <-6.946, 38.7602, -18.02246>, <-8.353, 41.4318, -17.4982> }
				triangle { <-5.5937, 41.2403, -9.1168>, <-8.353, 41.4318, -17.4982>, <-7.04174, 40.4142, -15.2423> }
				triangle { <-5.5937, 41.2403, -9.1168>, <-7.04174, 40.4142, -15.2423>, <-8.353, 41.4318, -17.4982> }
				triangle { <-22.179, 32.3286, -18.9632>, <-17.1369, 33.3278, -18.4059>, <-6.946, 38.7602, -18.02246> }
				triangle { <-22.179, 32.3286, -18.9632>, <-6.946, 38.7602, -18.02246>, <-17.1369, 33.3278, -18.4059> }
				triangle { <-22.6008, 33.7009, -16.3403>, <-25.1768, 32.7395, -18.3541>, <-22.179, 32.3286, -18.9632> }
				triangle { <-22.6008, 33.7009, -16.3403>, <-22.179, 32.3286, -18.9632>, <-25.1768, 32.7395, -18.3541> }
				triangle { <-22.179, 32.3286, -18.9632>, <-6.946, 38.7602, -18.02246>, <-22.6008, 33.7009, -16.3403> }
				triangle { <-22.179, 32.3286, -18.9632>, <-22.6008, 33.7009, -16.3403>, <-6.946, 38.7602, -18.02246> }
				triangle { <-8.353, 41.4318, -17.4982>, <-22.6008, 33.7009, -16.3403>, <-6.946, 38.7602, -18.02246> }
				triangle { <-8.353, 41.4318, -17.4982>, <-6.946, 38.7602, -18.02246>, <-22.6008, 33.7009, -16.3403> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-5.2392, 41.1537, -8.559>, <-5.4308, 41.2245, -8.6597>, 0.01552 }
				cylinder { <-5.4308, 41.2245, -8.6597>, <-5.6224, 41.2953, -8.7603>, 0.01552 }
				cylinder { <-5.6224, 41.2953, -8.7603>, <-5.8139, 41.366, -8.8609>, 0.01552 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.8139, 41.366, -8.8609>, <-9.9652, 44.4304, -9.619>, <-11.1423, 44.1452, -10.9069> }
				triangle { <-5.8139, 41.366, -8.8609>, <-11.1423, 44.1452, -10.9069>, <-9.9652, 44.4304, -9.619> }
				triangle { <-9.9652, 44.4304, -9.619>, <-13.4294, 46.4307, -10.7694>, <-11.1423, 44.1452, -10.9069> }
				triangle { <-9.9652, 44.4304, -9.619>, <-11.1423, 44.1452, -10.9069>, <-13.4294, 46.4307, -10.7694> }
				triangle { <-13.4294, 46.4307, -10.7694>, <-13.2402, 44.1101, -12.762>, <-11.1423, 44.1452, -10.9069> }
				triangle { <-13.4294, 46.4307, -10.7694>, <-11.1423, 44.1452, -10.9069>, <-13.2402, 44.1101, -12.762> }
				triangle { <-11.1423, 44.1452, -10.9069>, <-13.2402, 44.1101, -12.762>, <-5.8139, 41.366, -8.8609> }
				triangle { <-11.1423, 44.1452, -10.9069>, <-5.8139, 41.366, -8.8609>, <-13.2402, 44.1101, -12.762> }
				triangle { <-13.4294, 46.4307, -10.7694>, <-22.2479, 41.2537, -5.3894>, <-26.3529, 38.2753, -4.3845> }
				triangle { <-13.4294, 46.4307, -10.7694>, <-26.3529, 38.2753, -4.3845>, <-22.2479, 41.2537, -5.3894> }
				triangle { <-26.3529, 38.2753, -4.3845>, <-27.865, 35.589, -4.2277>, <-24.4771, 35.9476, -4.3234> }
				triangle { <-26.3529, 38.2753, -4.3845>, <-24.4771, 35.9476, -4.3234>, <-27.865, 35.589, -4.2277> }
				triangle { <-24.4771, 35.9476, -4.3234>, <-13.4294, 46.4307, -10.7694>, <-26.3529, 38.2753, -4.3845> }
				triangle { <-24.4771, 35.9476, -4.3234>, <-26.3529, 38.2753, -4.3845>, <-13.4294, 46.4307, -10.7694> }
				triangle { <-13.4294, 46.4307, -10.7694>, <-24.4771, 35.9476, -4.3234>, <-13.2402, 44.1101, -12.762> }
				triangle { <-13.4294, 46.4307, -10.7694>, <-13.2402, 44.1101, -12.762>, <-24.4771, 35.9476, -4.3234> }
				triangle { <-11.00609, 42.4743, -12.3416>, <-9.7078, 41.2744, -12.329>, <-5.8139, 41.366, -8.8609> }
				triangle { <-11.00609, 42.4743, -12.3416>, <-5.8139, 41.366, -8.8609>, <-9.7078, 41.2744, -12.329> }
				triangle { <-11.00609, 42.4743, -12.3416>, <-13.05094, 41.7895, -14.7547>, <-9.7078, 41.2744, -12.329> }
				triangle { <-11.00609, 42.4743, -12.3416>, <-9.7078, 41.2744, -12.329>, <-13.05094, 41.7895, -14.7547> }
				triangle { <-11.00609, 42.4743, -12.3416>, <-13.2402, 44.1101, -12.762>, <-13.05094, 41.7895, -14.7547> }
				triangle { <-11.00609, 42.4743, -12.3416>, <-13.05094, 41.7895, -14.7547>, <-13.2402, 44.1101, -12.762> }
				triangle { <-5.8139, 41.366, -8.8609>, <-13.2402, 44.1101, -12.762>, <-11.00609, 42.4743, -12.3416> }
				triangle { <-5.8139, 41.366, -8.8609>, <-11.00609, 42.4743, -12.3416>, <-13.2402, 44.1101, -12.762> }
				triangle { <-26.1258, 35.4906, -6.7757>, <-21.8542, 36.4268, -9.5341>, <-13.05094, 41.7895, -14.7547> }
				triangle { <-26.1258, 35.4906, -6.7757>, <-13.05094, 41.7895, -14.7547>, <-21.8542, 36.4268, -9.5341> }
				triangle { <-24.4771, 35.9476, -4.3234>, <-27.865, 35.589, -4.2277>, <-26.1258, 35.4906, -6.7757> }
				triangle { <-24.4771, 35.9476, -4.3234>, <-26.1258, 35.4906, -6.7757>, <-27.865, 35.589, -4.2277> }
				triangle { <-26.1258, 35.4906, -6.7757>, <-13.05094, 41.7895, -14.7547>, <-24.4771, 35.9476, -4.3234> }
				triangle { <-26.1258, 35.4906, -6.7757>, <-24.4771, 35.9476, -4.3234>, <-13.05094, 41.7895, -14.7547> }
				triangle { <-13.2402, 44.1101, -12.762>, <-24.4771, 35.9476, -4.3234>, <-13.05094, 41.7895, -14.7547> }
				triangle { <-13.2402, 44.1101, -12.762>, <-13.05094, 41.7895, -14.7547>, <-24.4771, 35.9476, -4.3234> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <2.2312, 34.6001, -3.5012>, <2.9084, 36.506, -3.7897>, 0.1392 }
			cylinder { <2.9084, 36.506, -3.7897>, <4.1077, 38.1599, -3.7864>, 0.1392 }
			cylinder { <4.1077, 38.1599, -3.7864>, <5.7082, 39.395, -3.4914>, 0.1392 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <5.7082, 39.395, -3.4914>, <6.1957, 39.7542, -3.3964>, 0.1392 }
				cylinder { <6.1957, 39.7542, -3.3964>, <6.6903, 40.1017, -3.295>, 0.1392 }
				cylinder { <6.6903, 40.1017, -3.295>, <7.1917, 40.4373, -3.1873>, 0.1392 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <7.1917, 40.4373, -3.1873>, <7.3487, 40.5737, -3.09474>, 0.01552 }
				cylinder { <7.3487, 40.5737, -3.09474>, <7.4652, 40.7118, -2.9562>, 0.01552 }
				cylinder { <7.4652, 40.7118, -2.9562>, <7.5328, 40.8416, -2.7818>, 0.01552 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <7.5328, 40.8416, -2.7818>, <9.821, 44.9098, -0.4555>, <9.8474, 45.1174, 1.2999> }
				triangle { <7.5328, 40.8416, -2.7818>, <9.8474, 45.1174, 1.2999>, <9.821, 44.9098, -0.4555> }
				triangle { <9.821, 44.9098, -0.4555>, <11.4303, 47.8483, 2.01461>, <9.8474, 45.1174, 1.2999> }
				triangle { <9.821, 44.9098, -0.4555>, <9.8474, 45.1174, 1.2999>, <11.4303, 47.8483, 2.01461> }
				triangle { <11.4303, 47.8483, 2.01461>, <10.1498, 45.8753, 3.9791>, <9.8474, 45.1174, 1.2999> }
				triangle { <11.4303, 47.8483, 2.01461>, <9.8474, 45.1174, 1.2999>, <10.1498, 45.8753, 3.9791> }
				triangle { <9.8474, 45.1174, 1.2999>, <10.1498, 45.8753, 3.9791>, <7.5328, 40.8416, -2.7818> }
				triangle { <9.8474, 45.1174, 1.2999>, <7.5328, 40.8416, -2.7818>, <10.1498, 45.8753, 3.9791> }
				triangle { <11.4303, 47.8483, 2.01461>, <21.9736, 44.2565, 5.08832>, <25.9231, 42.2631, 7.764> }
				triangle { <11.4303, 47.8483, 2.01461>, <25.9231, 42.2631, 7.764>, <21.9736, 44.2565, 5.08832> }
				triangle { <25.9231, 42.2631, 7.764>, <27.3693, 40.03835, 9.3407>, <24.78, 39.5633, 7.1761> }
				triangle { <25.9231, 42.2631, 7.764>, <24.78, 39.5633, 7.1761>, <27.3693, 40.03835, 9.3407> }
				triangle { <24.78, 39.5633, 7.1761>, <11.4303, 47.8483, 2.01461>, <25.9231, 42.2631, 7.764> }
				triangle { <24.78, 39.5633, 7.1761>, <25.9231, 42.2631, 7.764>, <11.4303, 47.8483, 2.01461> }
				triangle { <11.4303, 47.8483, 2.01461>, <24.78, 39.5633, 7.1761>, <10.1498, 45.8753, 3.9791> }
				triangle { <11.4303, 47.8483, 2.01461>, <10.1498, 45.8753, 3.9791>, <24.78, 39.5633, 7.1761> }
				triangle { <8.9255, 43.6969, 2.7144>, <8.07963, 42.2266, 2.2162>, <7.5328, 40.8416, -2.7818> }
				triangle { <8.9255, 43.6969, 2.7144>, <7.5328, 40.8416, -2.7818>, <8.07963, 42.2266, 2.2162> }
				triangle { <8.9255, 43.6969, 2.7144>, <8.8693, 43.9024, 5.9437>, <8.07963, 42.2266, 2.2162> }
				triangle { <8.9255, 43.6969, 2.7144>, <8.07963, 42.2266, 2.2162>, <8.8693, 43.9024, 5.9437> }
				triangle { <8.9255, 43.6969, 2.7144>, <10.1498, 45.8753, 3.9791>, <8.8693, 43.9024, 5.9437> }
				triangle { <8.9255, 43.6969, 2.7144>, <8.8693, 43.9024, 5.9437>, <10.1498, 45.8753, 3.9791> }
				triangle { <7.5328, 40.8416, -2.7818>, <10.1498, 45.8753, 3.9791>, <8.9255, 43.6969, 2.7144> }
				triangle { <7.5328, 40.8416, -2.7818>, <8.9255, 43.6969, 2.7144>, <10.1498, 45.8753, 3.9791> }
				triangle { <24.3865, 39.8955, 10.1215>, <19.3102, 40.1528, 9.1745>, <8.8693, 43.9024, 5.9437> }
				triangle { <24.3865, 39.8955, 10.1215>, <8.8693, 43.9024, 5.9437>, <19.3102, 40.1528, 9.1745> }
				triangle { <24.78, 39.5633, 7.1761>, <27.3693, 40.03835, 9.3407>, <24.3865, 39.8955, 10.1215> }
				triangle { <24.78, 39.5633, 7.1761>, <24.3865, 39.8955, 10.1215>, <27.3693, 40.03835, 9.3407> }
				triangle { <24.3865, 39.8955, 10.1215>, <8.8693, 43.9024, 5.9437>, <24.78, 39.5633, 7.1761> }
				triangle { <24.3865, 39.8955, 10.1215>, <24.78, 39.5633, 7.1761>, <8.8693, 43.9024, 5.9437> }
				triangle { <10.1498, 45.8753, 3.9791>, <24.78, 39.5633, 7.1761>, <8.8693, 43.9024, 5.9437> }
				triangle { <10.1498, 45.8753, 3.9791>, <8.8693, 43.9024, 5.9437>, <24.78, 39.5633, 7.1761> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <7.1917, 40.4373, -3.1873>, <7.6995, 40.761, -3.07337>, 0.1392 }
				cylinder { <7.6995, 40.761, -3.07337>, <8.2136, 41.07244, -2.9531>, 0.1392 }
				cylinder { <8.2136, 41.07244, -2.9531>, <8.7335, 41.3714, -2.8267>, 0.1392 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <8.7335, 41.3714, -2.8267>, <8.942, 41.4623, -2.8356>, 0.01552 }
				cylinder { <8.942, 41.4623, -2.8356>, <9.1509, 41.5264, -2.8995>, 0.01552 }
				cylinder { <9.1509, 41.5264, -2.8995>, <9.345, 41.5591, -3.01401>, 0.01552 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <9.345, 41.5591, -3.01401>, <12.3473, 42.3798, -7.1986>, <14.1062, 42.5282, -7.09975> }
				triangle { <9.345, 41.5591, -3.01401>, <14.1062, 42.5282, -7.09975>, <12.3473, 42.3798, -7.1986> }
				triangle { <12.3473, 42.3798, -7.1986>, <15.2907, 43.02398, -10.0704>, <14.1062, 42.5282, -7.09975> }
				triangle { <12.3473, 42.3798, -7.1986>, <14.1062, 42.5282, -7.09975>, <15.2907, 43.02398, -10.0704> }
				triangle { <15.2907, 43.02398, -10.0704>, <16.8686, 42.8274, -7.4506>, <14.1062, 42.5282, -7.09975> }
				triangle { <15.2907, 43.02398, -10.0704>, <14.1062, 42.5282, -7.09975>, <16.8686, 42.8274, -7.4506> }
				triangle { <14.1062, 42.5282, -7.09975>, <16.8686, 42.8274, -7.4506>, <9.345, 41.5591, -3.01401> }
				triangle { <14.1062, 42.5282, -7.09975>, <9.345, 41.5591, -3.01401>, <16.8686, 42.8274, -7.4506> }
				triangle { <15.2907, 43.02398, -10.0704>, <19.1529, 32.63, -13.32>, <22.03459, 28.3639, -13.7984> }
				triangle { <15.2907, 43.02398, -10.0704>, <22.03459, 28.3639, -13.7984>, <19.1529, 32.63, -13.32> }
				triangle { <22.03459, 28.3639, -13.7984>, <23.5169, 25.8777, -12.7269>, <21.02929, 27.5481, -11.1031> }
				triangle { <22.03459, 28.3639, -13.7984>, <21.02929, 27.5481, -11.1031>, <23.5169, 25.8777, -12.7269> }
				triangle { <21.02929, 27.5481, -11.1031>, <15.2907, 43.02398, -10.0704>, <22.03459, 28.3639, -13.7984> }
				triangle { <21.02929, 27.5481, -11.1031>, <22.03459, 28.3639, -13.7984>, <15.2907, 43.02398, -10.0704> }
				triangle { <15.2907, 43.02398, -10.0704>, <21.02929, 27.5481, -11.1031>, <16.8686, 42.8274, -7.4506> }
				triangle { <15.2907, 43.02398, -10.0704>, <16.8686, 42.8274, -7.4506>, <21.02929, 27.5481, -11.1031> }
				triangle { <15.2423, 42.3867, -5.2135>, <14.4933, 42.1125, -3.6358>, <9.345, 41.5591, -3.01401> }
				triangle { <15.2423, 42.3867, -5.2135>, <9.345, 41.5591, -3.01401>, <14.4933, 42.1125, -3.6358> }
				triangle { <15.2423, 42.3867, -5.2135>, <18.4466, 42.6308, -4.8309>, <14.4933, 42.1125, -3.6358> }
				triangle { <15.2423, 42.3867, -5.2135>, <14.4933, 42.1125, -3.6358>, <18.4466, 42.6308, -4.8309> }
				triangle { <15.2423, 42.3867, -5.2135>, <16.8686, 42.8274, -7.4506>, <18.4466, 42.6308, -4.8309> }
				triangle { <15.2423, 42.3867, -5.2135>, <18.4466, 42.6308, -4.8309>, <16.8686, 42.8274, -7.4506> }
				triangle { <9.345, 41.5591, -3.01401>, <16.8686, 42.8274, -7.4506>, <15.2423, 42.3867, -5.2135> }
				triangle { <9.345, 41.5591, -3.01401>, <15.2423, 42.3867, -5.2135>, <16.8686, 42.8274, -7.4506> }
				triangle { <23.9281, 28.1281, -10.6547>, <22.4351, 32.2212, -7.8709>, <18.4466, 42.6308, -4.8309> }
				triangle { <23.9281, 28.1281, -10.6547>, <18.4466, 42.6308, -4.8309>, <22.4351, 32.2212, -7.8709> }
				triangle { <21.02929, 27.5481, -11.1031>, <23.5169, 25.8777, -12.7269>, <23.9281, 28.1281, -10.6547> }
				triangle { <21.02929, 27.5481, -11.1031>, <23.9281, 28.1281, -10.6547>, <23.5169, 25.8777, -12.7269> }
				triangle { <23.9281, 28.1281, -10.6547>, <18.4466, 42.6308, -4.8309>, <21.02929, 27.5481, -11.1031> }
				triangle { <23.9281, 28.1281, -10.6547>, <21.02929, 27.5481, -11.1031>, <18.4466, 42.6308, -4.8309> }
				triangle { <16.8686, 42.8274, -7.4506>, <21.02929, 27.5481, -11.1031>, <18.4466, 42.6308, -4.8309> }
				triangle { <16.8686, 42.8274, -7.4506>, <18.4466, 42.6308, -4.8309>, <21.02929, 27.5481, -11.1031> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <8.7335, 41.3714, -2.8267>, <9.2589, 41.6578, -2.6943>, 0.1392 }
				cylinder { <9.2589, 41.6578, -2.6943>, <9.7896, 41.9314, -2.5559>, 0.1392 }
				cylinder { <9.7896, 41.9314, -2.5559>, <10.3252, 42.1921, -2.4116>, 0.1392 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <10.3252, 42.1921, -2.4116>, <10.4945, 42.3016, -2.3058>, 0.01552 }
				cylinder { <10.4945, 42.3016, -2.3058>, <10.6219, 42.4158, -2.1556>, 0.01552 }
				cylinder { <10.6219, 42.4158, -2.1556>, <10.6982, 42.5265, -1.9719>, 0.01552 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <10.6982, 42.5265, -1.9719>, <13.3932, 46.1322, 0.6612>, <13.3715, 46.2436, 2.4255> }
				triangle { <10.6982, 42.5265, -1.9719>, <13.3715, 46.2436, 2.4255>, <13.3932, 46.1322, 0.6612> }
				triangle { <13.3932, 46.1322, 0.6612>, <15.2629, 48.7016, 3.3497>, <13.3715, 46.2436, 2.4255> }
				triangle { <13.3932, 46.1322, 0.6612>, <13.3715, 46.2436, 2.4255>, <15.2629, 48.7016, 3.3497> }
				triangle { <15.2629, 48.7016, 3.3497>, <13.655, 46.8157, 5.1524>, <13.3715, 46.2436, 2.4255> }
				triangle { <15.2629, 48.7016, 3.3497>, <13.3715, 46.2436, 2.4255>, <13.655, 46.8157, 5.1524> }
				triangle { <13.3715, 46.2436, 2.4255>, <13.655, 46.8157, 5.1524>, <10.6982, 42.5265, -1.9719> }
				triangle { <13.3715, 46.2436, 2.4255>, <10.6982, 42.5265, -1.9719>, <13.655, 46.8157, 5.1524> }
				triangle { <15.2629, 48.7016, 3.3497>, <25.1113, 43.5986, 6.5867>, <28.6516, 40.9669, 9.2834> }
				triangle { <15.2629, 48.7016, 3.3497>, <28.6516, 40.9669, 9.2834>, <25.1113, 43.5986, 6.5867> }
				triangle { <28.6516, 40.9669, 9.2834>, <29.7289, 38.4926, 10.7816>, <27.1945, 38.4752, 8.503> }
				triangle { <28.6516, 40.9669, 9.2834>, <27.1945, 38.4752, 8.503>, <29.7289, 38.4926, 10.7816> }
				triangle { <27.1945, 38.4752, 8.503>, <15.2629, 48.7016, 3.3497>, <28.6516, 40.9669, 9.2834> }
				triangle { <27.1945, 38.4752, 8.503>, <28.6516, 40.9669, 9.2834>, <15.2629, 48.7016, 3.3497> }
				triangle { <15.2629, 48.7016, 3.3497>, <27.1945, 38.4752, 8.503>, <13.655, 46.8157, 5.1524> }
				triangle { <15.2629, 48.7016, 3.3497>, <13.655, 46.8157, 5.1524>, <27.1945, 38.4752, 8.503> }
				triangle { <12.2138, 44.8858, 3.7235>, <11.2065, 43.5674, 3.1129>, <10.6982, 42.5265, -1.9719> }
				triangle { <12.2138, 44.8858, 3.7235>, <10.6982, 42.5265, -1.9719>, <11.2065, 43.5674, 3.1129> }
				triangle { <12.2138, 44.8858, 3.7235>, <12.04723, 44.9298, 6.9552>, <11.2065, 43.5674, 3.1129> }
				triangle { <12.2138, 44.8858, 3.7235>, <11.2065, 43.5674, 3.1129>, <12.04723, 44.9298, 6.9552> }
				triangle { <12.2138, 44.8858, 3.7235>, <13.655, 46.8157, 5.1524>, <12.04723, 44.9298, 6.9552> }
				triangle { <12.2138, 44.8858, 3.7235>, <12.04723, 44.9298, 6.9552>, <13.655, 46.8157, 5.1524> }
				triangle { <10.6982, 42.5265, -1.9719>, <13.655, 46.8157, 5.1524>, <12.2138, 44.8858, 3.7235> }
				triangle { <10.6982, 42.5265, -1.9719>, <12.2138, 44.8858, 3.7235>, <13.655, 46.8157, 5.1524> }
				triangle { <26.7222, 38.7038, 11.4467>, <21.767, 39.6759, 10.3364>, <12.04723, 44.9298, 6.9552> }
				triangle { <26.7222, 38.7038, 11.4467>, <12.04723, 44.9298, 6.9552>, <21.767, 39.6759, 10.3364> }
				triangle { <27.1945, 38.4752, 8.503>, <29.7289, 38.4926, 10.7816>, <26.7222, 38.7038, 11.4467> }
				triangle { <27.1945, 38.4752, 8.503>, <26.7222, 38.7038, 11.4467>, <29.7289, 38.4926, 10.7816> }
				triangle { <26.7222, 38.7038, 11.4467>, <12.04723, 44.9298, 6.9552>, <27.1945, 38.4752, 8.503> }
				triangle { <26.7222, 38.7038, 11.4467>, <27.1945, 38.4752, 8.503>, <12.04723, 44.9298, 6.9552> }
				triangle { <13.655, 46.8157, 5.1524>, <27.1945, 38.4752, 8.503>, <12.04723, 44.9298, 6.9552> }
				triangle { <13.655, 46.8157, 5.1524>, <12.04723, 44.9298, 6.9552>, <27.1945, 38.4752, 8.503> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <10.3252, 42.1921, -2.4116>, <10.5242, 42.289, -2.358>, 0.01552 }
				cylinder { <10.5242, 42.289, -2.358>, <10.7231, 42.3858, -2.3043>, 0.01552 }
				cylinder { <10.7231, 42.3858, -2.3043>, <10.9221, 42.4827, -2.2507>, 0.01552 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <10.9221, 42.4827, -2.2507>, <15.3257, 45.1447, -3.09905>, <16.5048, 45.4746, -1.8237> }
				triangle { <10.9221, 42.4827, -2.2507>, <16.5048, 45.4746, -1.8237>, <15.3257, 45.1447, -3.09905> }
				triangle { <15.3257, 45.1447, -3.09905>, <18.967, 47.1611, -3.07545>, <16.5048, 45.4746, -1.8237> }
				triangle { <15.3257, 45.1447, -3.09905>, <16.5048, 45.4746, -1.8237>, <18.967, 47.1611, -3.07545> }
				triangle { <18.967, 47.1611, -3.07545>, <18.6347, 46.2368, -0.1725>, <16.5048, 45.4746, -1.8237> }
				triangle { <18.967, 47.1611, -3.07545>, <16.5048, 45.4746, -1.8237>, <18.6347, 46.2368, -0.1725> }
				triangle { <16.5048, 45.4746, -1.8237>, <18.6347, 46.2368, -0.1725>, <10.9221, 42.4827, -2.2507> }
				triangle { <16.5048, 45.4746, -1.8237>, <10.9221, 42.4827, -2.2507>, <18.6347, 46.2368, -0.1725> }
				triangle { <18.967, 47.1611, -3.07545>, <27.2083, 39.2441, -4.7823>, <31.03272, 35.8536, -4.000571> }
				triangle { <18.967, 47.1611, -3.07545>, <31.03272, 35.8536, -4.000571>, <27.2083, 39.2441, -4.7823> }
				triangle { <31.03272, 35.8536, -4.000571>, <32.3166, 33.3635, -2.7053>, <28.9723, 33.9946, -2.8872> }
				triangle { <31.03272, 35.8536, -4.000571>, <28.9723, 33.9946, -2.8872>, <32.3166, 33.3635, -2.7053> }
				triangle { <28.9723, 33.9946, -2.8872>, <18.967, 47.1611, -3.07545>, <31.03272, 35.8536, -4.000571> }
				triangle { <28.9723, 33.9946, -2.8872>, <31.03272, 35.8536, -4.000571>, <18.967, 47.1611, -3.07545> }
				triangle { <18.967, 47.1611, -3.07545>, <28.9723, 33.9946, -2.8872>, <18.6347, 46.2368, -0.1725> }
				triangle { <18.967, 47.1611, -3.07545>, <18.6347, 46.2368, -0.1725>, <28.9723, 33.9946, -2.8872> }
				triangle { <16.2656, 44.8091, 0.2663>, <14.8738, 43.8876, 0.8488>, <10.9221, 42.4827, -2.2507> }
				triangle { <16.2656, 44.8091, 0.2663>, <10.9221, 42.4827, -2.2507>, <14.8738, 43.8876, 0.8488> }
				triangle { <16.2656, 44.8091, 0.2663>, <18.3024, 45.3125, 2.7303>, <14.8738, 43.8876, 0.8488> }
				triangle { <16.2656, 44.8091, 0.2663>, <14.8738, 43.8876, 0.8488>, <18.3024, 45.3125, 2.7303> }
				triangle { <16.2656, 44.8091, 0.2663>, <18.6347, 46.2368, -0.1725>, <18.3024, 45.3125, 2.7303> }
				triangle { <16.2656, 44.8091, 0.2663>, <18.3024, 45.3125, 2.7303>, <18.6347, 46.2368, -0.1725> }
				triangle { <10.9221, 42.4827, -2.2507>, <18.6347, 46.2368, -0.1725>, <16.2656, 44.8091, 0.2663> }
				triangle { <10.9221, 42.4827, -2.2507>, <16.2656, 44.8091, 0.2663>, <18.6347, 46.2368, -0.1725> }
				triangle { <30.6339, 34.7445, -0.517>, <26.5171, 37.3215, 1.2557>, <18.3024, 45.3125, 2.7303> }
				triangle { <30.6339, 34.7445, -0.517>, <18.3024, 45.3125, 2.7303>, <26.5171, 37.3215, 1.2557> }
				triangle { <28.9723, 33.9946, -2.8872>, <32.3166, 33.3635, -2.7053>, <30.6339, 34.7445, -0.517> }
				triangle { <28.9723, 33.9946, -2.8872>, <30.6339, 34.7445, -0.517>, <32.3166, 33.3635, -2.7053> }
				triangle { <30.6339, 34.7445, -0.517>, <18.3024, 45.3125, 2.7303>, <28.9723, 33.9946, -2.8872> }
				triangle { <30.6339, 34.7445, -0.517>, <28.9723, 33.9946, -2.8872>, <18.3024, 45.3125, 2.7303> }
				triangle { <18.6347, 46.2368, -0.1725>, <28.9723, 33.9946, -2.8872>, <18.3024, 45.3125, 2.7303> }
				triangle { <18.6347, 46.2368, -0.1725>, <18.3024, 45.3125, 2.7303>, <28.9723, 33.9946, -2.8872> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <2.2312, 34.6001, -3.5012>, <2.29, 35.6698, -3.776>, 0.201 }
		cylinder { <2.29, 35.6698, -3.776>, <2.3607, 36.7445, -4.02691>, 0.201 }
		cylinder { <2.3607, 36.7445, -4.02691>, <2.4432, 37.8238, -4.2537>, 0.201 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <2.4432, 37.8238, -4.2537>, <2.6121, 38.6171, -4.1858>, 0.05549 }
			cylinder { <2.6121, 38.6171, -4.1858>, <2.872, 39.3293, -3.8898>, 0.05549 }
			cylinder { <2.872, 39.3293, -3.8898>, <3.1967, 39.8886, -3.3957>, 0.05549 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <3.1967, 39.8886, -3.3957>, <3.2941, 40.05639, -3.2474>, 0.05549 }
				cylinder { <3.2941, 40.05639, -3.2474>, <3.3915, 40.2241, -3.09924>, 0.05549 }
				cylinder { <3.3915, 40.2241, -3.09924>, <3.489, 40.3919, -2.951>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <3.489, 40.3919, -2.951>, <3.4942, 40.4173, -2.9258>, 0.002463 }
				cylinder { <3.4942, 40.4173, -2.9258>, <3.4899, 40.4415, -2.8993>, 0.002463 }
				cylinder { <3.4899, 40.4415, -2.8993>, <3.4764, 40.4627, -2.8734>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <3.4764, 40.4627, -2.8734>, <3.2742, 42.1909, -1.7382>, <2.8141, 42.2469, -1.208> }
				triangle { <3.4764, 40.4627, -2.8734>, <2.8141, 42.2469, -1.208>, <3.2742, 42.1909, -1.7382> }
				triangle { <3.2742, 42.1909, -1.7382>, <2.9111, 43.4237, -0.6903>, <2.8141, 42.2469, -1.208> }
				triangle { <3.2742, 42.1909, -1.7382>, <2.8141, 42.2469, -1.208>, <2.9111, 43.4237, -0.6903> }
				triangle { <2.9111, 43.4237, -0.6903>, <2.1592, 42.5247, -0.3485>, <2.8141, 42.2469, -1.208> }
				triangle { <2.9111, 43.4237, -0.6903>, <2.8141, 42.2469, -1.208>, <2.1592, 42.5247, -0.3485> }
				triangle { <2.8141, 42.2469, -1.208>, <2.1592, 42.5247, -0.3485>, <3.4764, 40.4627, -2.8734> }
				triangle { <2.8141, 42.2469, -1.208>, <3.4764, 40.4627, -2.8734>, <2.1592, 42.5247, -0.3485> }
				triangle { <2.9111, 43.4237, -0.6903>, <5.4747, 42.7785, 3.07787>, <6.08502, 42.2602, 4.9755> }
				triangle { <2.9111, 43.4237, -0.6903>, <6.08502, 42.2602, 4.9755>, <5.4747, 42.7785, 3.07787> }
				triangle { <6.08502, 42.2602, 4.9755>, <6.2557, 41.4772, 5.9081>, <6.08296, 41.1273, 4.6077> }
				triangle { <6.08502, 42.2602, 4.9755>, <6.08296, 41.1273, 4.6077>, <6.2557, 41.4772, 5.9081> }
				triangle { <6.08296, 41.1273, 4.6077>, <2.9111, 43.4237, -0.6903>, <6.08502, 42.2602, 4.9755> }
				triangle { <6.08296, 41.1273, 4.6077>, <6.08502, 42.2602, 4.9755>, <2.9111, 43.4237, -0.6903> }
				triangle { <2.9111, 43.4237, -0.6903>, <6.08296, 41.1273, 4.6077>, <2.1592, 42.5247, -0.3485> }
				triangle { <2.9111, 43.4237, -0.6903>, <2.1592, 42.5247, -0.3485>, <6.08296, 41.1273, 4.6077> }
				triangle { <2.2726, 41.5997, -0.9618>, <2.2515, 40.9684, -1.2733>, <3.4764, 40.4627, -2.8734> }
				triangle { <2.2726, 41.5997, -0.9618>, <3.4764, 40.4627, -2.8734>, <2.2515, 40.9684, -1.2733> }
				triangle { <2.2726, 41.5997, -0.9618>, <1.4072, 41.6258, -0.006667>, <2.2515, 40.9684, -1.2733> }
				triangle { <2.2726, 41.5997, -0.9618>, <2.2515, 40.9684, -1.2733>, <1.4072, 41.6258, -0.006667> }
				triangle { <2.2726, 41.5997, -0.9618>, <2.1592, 42.5247, -0.3485>, <1.4072, 41.6258, -0.006667> }
				triangle { <2.2726, 41.5997, -0.9618>, <1.4072, 41.6258, -0.006667>, <2.1592, 42.5247, -0.3485> }
				triangle { <3.4764, 40.4627, -2.8734>, <2.1592, 42.5247, -0.3485>, <2.2726, 41.5997, -0.9618> }
				triangle { <3.4764, 40.4627, -2.8734>, <2.2726, 41.5997, -0.9618>, <2.1592, 42.5247, -0.3485> }
				triangle { <5.1826, 41.1815, 5.3857>, <3.9106, 40.9087, 3.7889>, <1.4072, 41.6258, -0.006667> }
				triangle { <5.1826, 41.1815, 5.3857>, <1.4072, 41.6258, -0.006667>, <3.9106, 40.9087, 3.7889> }
				triangle { <6.08296, 41.1273, 4.6077>, <6.2557, 41.4772, 5.9081>, <5.1826, 41.1815, 5.3857> }
				triangle { <6.08296, 41.1273, 4.6077>, <5.1826, 41.1815, 5.3857>, <6.2557, 41.4772, 5.9081> }
				triangle { <5.1826, 41.1815, 5.3857>, <1.4072, 41.6258, -0.006667>, <6.08296, 41.1273, 4.6077> }
				triangle { <5.1826, 41.1815, 5.3857>, <6.08296, 41.1273, 4.6077>, <1.4072, 41.6258, -0.006667> }
				triangle { <2.1592, 42.5247, -0.3485>, <6.08296, 41.1273, 4.6077>, <1.4072, 41.6258, -0.006667> }
				triangle { <2.1592, 42.5247, -0.3485>, <1.4072, 41.6258, -0.006667>, <6.08296, 41.1273, 4.6077> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <3.489, 40.3919, -2.951>, <3.5864, 40.5597, -2.8027>, 0.05549 }
				cylinder { <3.5864, 40.5597, -2.8027>, <3.6838, 40.7275, -2.6545>, 0.05549 }
				cylinder { <3.6838, 40.7275, -2.6545>, <3.7812, 40.8953, -2.5062>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <3.7812, 40.8953, -2.5062>, <3.8037, 40.9177, -2.4891>, 0.002463 }
				cylinder { <3.8037, 40.9177, -2.4891>, <3.8328, 40.9361, -2.4779>, 0.002463 }
				cylinder { <3.8328, 40.9361, -2.4779>, <3.8662, 40.9491, -2.4736>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <3.8662, 40.9491, -2.4736>, <5.7535, 41.5846, -3.06555>, <6.2362, 41.8209, -2.6103> }
				triangle { <3.8662, 40.9491, -2.4736>, <6.2362, 41.8209, -2.6103>, <5.7535, 41.5846, -3.06555> }
				triangle { <5.7535, 41.5846, -3.06555>, <7.3032, 42.142, -3.2588>, <6.2362, 41.8209, -2.6103> }
				triangle { <5.7535, 41.5846, -3.06555>, <6.2362, 41.8209, -2.6103>, <7.3032, 42.142, -3.2588> }
				triangle { <7.3032, 42.142, -3.2588>, <7.1179, 42.219, -2.05462>, <6.2362, 41.8209, -2.6103> }
				triangle { <7.3032, 42.142, -3.2588>, <6.2362, 41.8209, -2.6103>, <7.1179, 42.219, -2.05462> }
				triangle { <6.2362, 41.8209, -2.6103>, <7.1179, 42.219, -2.05462>, <3.8662, 40.9491, -2.4736> }
				triangle { <6.2362, 41.8209, -2.6103>, <3.8662, 40.9491, -2.4736>, <7.1179, 42.219, -2.05462> }
				triangle { <7.3032, 42.142, -3.2588>, <10.1079, 38.5438, -2.6465>, <11.4243, 37.1966, -1.8131> }
				triangle { <7.3032, 42.142, -3.2588>, <11.4243, 37.1966, -1.8131>, <10.1079, 38.5438, -2.6465> }
				triangle { <11.4243, 37.1966, -1.8131>, <11.7892, 36.3871, -0.9626>, <10.5061, 36.7714, -1.1846> }
				triangle { <11.4243, 37.1966, -1.8131>, <10.5061, 36.7714, -1.1846>, <11.7892, 36.3871, -0.9626> }
				triangle { <10.5061, 36.7714, -1.1846>, <7.3032, 42.142, -3.2588>, <11.4243, 37.1966, -1.8131> }
				triangle { <10.5061, 36.7714, -1.1846>, <11.4243, 37.1966, -1.8131>, <7.3032, 42.142, -3.2588> }
				triangle { <7.3032, 42.142, -3.2588>, <10.5061, 36.7714, -1.1846>, <7.1179, 42.219, -2.05462> }
				triangle { <7.3032, 42.142, -3.2588>, <7.1179, 42.219, -2.05462>, <10.5061, 36.7714, -1.1846> }
				triangle { <6.1028, 41.8764, -1.7433>, <5.5016, 41.6894, -1.4278>, <3.8662, 40.9491, -2.4736> }
				triangle { <6.1028, 41.8764, -1.7433>, <3.8662, 40.9491, -2.4736>, <5.5016, 41.6894, -1.4278> }
				triangle { <6.1028, 41.8764, -1.7433>, <6.9326, 42.2961, -0.8504>, <5.5016, 41.6894, -1.4278> }
				triangle { <6.1028, 41.8764, -1.7433>, <5.5016, 41.6894, -1.4278>, <6.9326, 42.2961, -0.8504> }
				triangle { <6.1028, 41.8764, -1.7433>, <7.1179, 42.219, -2.05462>, <6.9326, 42.2961, -0.8504> }
				triangle { <6.1028, 41.8764, -1.7433>, <6.9326, 42.2961, -0.8504>, <7.1179, 42.219, -2.05462> }
				triangle { <3.8662, 40.9491, -2.4736>, <7.1179, 42.219, -2.05462>, <6.1028, 41.8764, -1.7433> }
				triangle { <3.8662, 40.9491, -2.4736>, <6.1028, 41.8764, -1.7433>, <7.1179, 42.219, -2.05462> }
				triangle { <11.2019, 37.2891, -0.3681>, <9.7225, 38.7042, -0.1417>, <6.9326, 42.2961, -0.8504> }
				triangle { <11.2019, 37.2891, -0.3681>, <6.9326, 42.2961, -0.8504>, <9.7225, 38.7042, -0.1417> }
				triangle { <10.5061, 36.7714, -1.1846>, <11.7892, 36.3871, -0.9626>, <11.2019, 37.2891, -0.3681> }
				triangle { <10.5061, 36.7714, -1.1846>, <11.2019, 37.2891, -0.3681>, <11.7892, 36.3871, -0.9626> }
				triangle { <11.2019, 37.2891, -0.3681>, <6.9326, 42.2961, -0.8504>, <10.5061, 36.7714, -1.1846> }
				triangle { <11.2019, 37.2891, -0.3681>, <10.5061, 36.7714, -1.1846>, <6.9326, 42.2961, -0.8504> }
				triangle { <7.1179, 42.219, -2.05462>, <10.5061, 36.7714, -1.1846>, <6.9326, 42.2961, -0.8504> }
				triangle { <7.1179, 42.219, -2.05462>, <6.9326, 42.2961, -0.8504>, <10.5061, 36.7714, -1.1846> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <3.7812, 40.8953, -2.5062>, <3.8786, 41.06308, -2.358>, 0.05549 }
				cylinder { <3.8786, 41.06308, -2.358>, <3.976, 41.2308, -2.2097>, 0.05549 }
				cylinder { <3.976, 41.2308, -2.2097>, <4.07349, 41.3986, -2.06153>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <4.07349, 41.3986, -2.06153>, <4.07874, 41.424, -2.0364>, 0.002463 }
				cylinder { <4.07874, 41.424, -2.0364>, <4.07444, 41.4482, -2.00991>, 0.002463 }
				cylinder { <4.07444, 41.4482, -2.00991>, <4.0609, 41.4694, -1.9839>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <4.0609, 41.4694, -1.9839>, <3.8587, 43.1976, -0.8487>, <3.3986, 43.2536, -0.3185> }
				triangle { <4.0609, 41.4694, -1.9839>, <3.3986, 43.2536, -0.3185>, <3.8587, 43.1976, -0.8487> }
				triangle { <3.8587, 43.1976, -0.8487>, <3.4956, 44.4304, 0.199>, <3.3986, 43.2536, -0.3185> }
				triangle { <3.8587, 43.1976, -0.8487>, <3.3986, 43.2536, -0.3185>, <3.4956, 44.4304, 0.199> }
				triangle { <3.4956, 44.4304, 0.199>, <2.7437, 43.5314, 0.5409>, <3.3986, 43.2536, -0.3185> }
				triangle { <3.4956, 44.4304, 0.199>, <3.3986, 43.2536, -0.3185>, <2.7437, 43.5314, 0.5409> }
				triangle { <3.3986, 43.2536, -0.3185>, <2.7437, 43.5314, 0.5409>, <4.0609, 41.4694, -1.9839> }
				triangle { <3.3986, 43.2536, -0.3185>, <4.0609, 41.4694, -1.9839>, <2.7437, 43.5314, 0.5409> }
				triangle { <3.4956, 44.4304, 0.199>, <6.05925, 43.7852, 3.9673>, <6.6695, 43.2669, 5.865> }
				triangle { <3.4956, 44.4304, 0.199>, <6.6695, 43.2669, 5.865>, <6.05925, 43.7852, 3.9673> }
				triangle { <6.6695, 43.2669, 5.865>, <6.8402, 42.4839, 6.7975>, <6.6674, 42.134, 5.4971> }
				triangle { <6.6695, 43.2669, 5.865>, <6.6674, 42.134, 5.4971>, <6.8402, 42.4839, 6.7975> }
				triangle { <6.6674, 42.134, 5.4971>, <3.4956, 44.4304, 0.199>, <6.6695, 43.2669, 5.865> }
				triangle { <6.6674, 42.134, 5.4971>, <6.6695, 43.2669, 5.865>, <3.4956, 44.4304, 0.199> }
				triangle { <3.4956, 44.4304, 0.199>, <6.6674, 42.134, 5.4971>, <2.7437, 43.5314, 0.5409> }
				triangle { <3.4956, 44.4304, 0.199>, <2.7437, 43.5314, 0.5409>, <6.6674, 42.134, 5.4971> }
				triangle { <2.8571, 42.6064, -0.07241>, <2.836, 41.9751, -0.3838>, <4.0609, 41.4694, -1.9839> }
				triangle { <2.8571, 42.6064, -0.07241>, <4.0609, 41.4694, -1.9839>, <2.836, 41.9751, -0.3838> }
				triangle { <2.8571, 42.6064, -0.07241>, <1.9917, 42.6325, 0.8827>, <2.836, 41.9751, -0.3838> }
				triangle { <2.8571, 42.6064, -0.07241>, <2.836, 41.9751, -0.3838>, <1.9917, 42.6325, 0.8827> }
				triangle { <2.8571, 42.6064, -0.07241>, <2.7437, 43.5314, 0.5409>, <1.9917, 42.6325, 0.8827> }
				triangle { <2.8571, 42.6064, -0.07241>, <1.9917, 42.6325, 0.8827>, <2.7437, 43.5314, 0.5409> }
				triangle { <4.0609, 41.4694, -1.9839>, <2.7437, 43.5314, 0.5409>, <2.8571, 42.6064, -0.07241> }
				triangle { <4.0609, 41.4694, -1.9839>, <2.8571, 42.6064, -0.07241>, <2.7437, 43.5314, 0.5409> }
				triangle { <5.7671, 42.1882, 6.2752>, <4.4951, 41.9154, 4.6783>, <1.9917, 42.6325, 0.8827> }
				triangle { <5.7671, 42.1882, 6.2752>, <1.9917, 42.6325, 0.8827>, <4.4951, 41.9154, 4.6783> }
				triangle { <6.6674, 42.134, 5.4971>, <6.8402, 42.4839, 6.7975>, <5.7671, 42.1882, 6.2752> }
				triangle { <6.6674, 42.134, 5.4971>, <5.7671, 42.1882, 6.2752>, <6.8402, 42.4839, 6.7975> }
				triangle { <5.7671, 42.1882, 6.2752>, <1.9917, 42.6325, 0.8827>, <6.6674, 42.134, 5.4971> }
				triangle { <5.7671, 42.1882, 6.2752>, <6.6674, 42.134, 5.4971>, <1.9917, 42.6325, 0.8827> }
				triangle { <2.7437, 43.5314, 0.5409>, <6.6674, 42.134, 5.4971>, <1.9917, 42.6325, 0.8827> }
				triangle { <2.7437, 43.5314, 0.5409>, <1.9917, 42.6325, 0.8827>, <6.6674, 42.134, 5.4971> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <4.07349, 41.3986, -2.06153>, <4.08791, 41.4234, -2.03959>, 0.002463 }
				cylinder { <4.08791, 41.4234, -2.03959>, <4.1023, 41.4483, -2.01766>, 0.002463 }
				cylinder { <4.1023, 41.4483, -2.01766>, <4.1167, 41.4731, -1.9957>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <4.1167, 41.4731, -1.9957>, <5.3809, 43.02906, -1.4506>, <5.3774, 43.3153, -0.8072> }
				triangle { <4.1167, 41.4731, -1.9957>, <5.3774, 43.3153, -0.8072>, <5.3809, 43.02906, -1.4506> }
				triangle { <5.3809, 43.02906, -1.4506>, <6.2612, 44.2527, -0.7599>, <5.3774, 43.3153, -0.8072> }
				triangle { <5.3809, 43.02906, -1.4506>, <5.3774, 43.3153, -0.8072>, <6.2612, 44.2527, -0.7599> }
				triangle { <6.2612, 44.2527, -0.7599>, <5.5195, 43.8891, 0.1389>, <5.3774, 43.3153, -0.8072> }
				triangle { <6.2612, 44.2527, -0.7599>, <5.3774, 43.3153, -0.8072>, <5.5195, 43.8891, 0.1389> }
				triangle { <5.3774, 43.3153, -0.8072>, <5.5195, 43.8891, 0.1389>, <4.1167, 41.4731, -1.9957> }
				triangle { <5.3774, 43.3153, -0.8072>, <4.1167, 41.4731, -1.9957>, <5.5195, 43.8891, 0.1389> }
				triangle { <6.2612, 44.2527, -0.7599>, <9.8548, 42.2945, 1.3469>, <11.1006, 41.5076, 2.7861> }
				triangle { <6.2612, 44.2527, -0.7599>, <11.1006, 41.5076, 2.7861>, <9.8548, 42.2945, 1.3469> }
				triangle { <11.1006, 41.5076, 2.7861>, <11.3847, 40.743, 3.7061>, <10.386, 40.5548, 2.8059> }
				triangle { <11.1006, 41.5076, 2.7861>, <10.386, 40.5548, 2.8059>, <11.3847, 40.743, 3.7061> }
				triangle { <10.386, 40.5548, 2.8059>, <6.2612, 44.2527, -0.7599>, <11.1006, 41.5076, 2.7861> }
				triangle { <10.386, 40.5548, 2.8059>, <11.1006, 41.5076, 2.7861>, <6.2612, 44.2527, -0.7599> }
				triangle { <6.2612, 44.2527, -0.7599>, <10.386, 40.5548, 2.8059>, <5.5195, 43.8891, 0.1389> }
				triangle { <6.2612, 44.2527, -0.7599>, <5.5195, 43.8891, 0.1389>, <10.386, 40.5548, 2.8059> }
				triangle { <4.8433, 43.05361, -0.16>, <4.3722, 42.5345, -0.2281>, <4.1167, 41.4731, -1.9957> }
				triangle { <4.8433, 43.05361, -0.16>, <4.1167, 41.4731, -1.9957>, <4.3722, 42.5345, -0.2281> }
				triangle { <4.8433, 43.05361, -0.16>, <4.7777, 43.5255, 1.03791>, <4.3722, 42.5345, -0.2281> }
				triangle { <4.8433, 43.05361, -0.16>, <4.3722, 42.5345, -0.2281>, <4.7777, 43.5255, 1.03791> }
				triangle { <4.8433, 43.05361, -0.16>, <5.5195, 43.8891, 0.1389>, <4.7777, 43.5255, 1.03791> }
				triangle { <4.8433, 43.05361, -0.16>, <4.7777, 43.5255, 1.03791>, <5.5195, 43.8891, 0.1389> }
				triangle { <4.1167, 41.4731, -1.9957>, <5.5195, 43.8891, 0.1389>, <4.8433, 43.05361, -0.16> }
				triangle { <4.1167, 41.4731, -1.9957>, <4.8433, 43.05361, -0.16>, <5.5195, 43.8891, 0.1389> }
				triangle { <10.2105, 41.07139, 3.8648>, <8.312, 41.5382, 3.2167>, <4.7777, 43.5255, 1.03791> }
				triangle { <10.2105, 41.07139, 3.8648>, <4.7777, 43.5255, 1.03791>, <8.312, 41.5382, 3.2167> }
				triangle { <10.386, 40.5548, 2.8059>, <11.3847, 40.743, 3.7061>, <10.2105, 41.07139, 3.8648> }
				triangle { <10.386, 40.5548, 2.8059>, <10.2105, 41.07139, 3.8648>, <11.3847, 40.743, 3.7061> }
				triangle { <10.2105, 41.07139, 3.8648>, <4.7777, 43.5255, 1.03791>, <10.386, 40.5548, 2.8059> }
				triangle { <10.2105, 41.07139, 3.8648>, <10.386, 40.5548, 2.8059>, <4.7777, 43.5255, 1.03791> }
				triangle { <5.5195, 43.8891, 0.1389>, <10.386, 40.5548, 2.8059>, <4.7777, 43.5255, 1.03791> }
				triangle { <5.5195, 43.8891, 0.1389>, <4.7777, 43.5255, 1.03791>, <10.386, 40.5548, 2.8059> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <2.4432, 37.8238, -4.2537>, <2.3898, 38.5389, -4.6388>, 0.05549 }
			cylinder { <2.3898, 38.5389, -4.6388>, <2.2274, 39.1025, -5.203>, 0.05549 }
			cylinder { <2.2274, 39.1025, -5.203>, <1.9727, 39.4579, -5.8894>, 0.05549 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <1.9727, 39.4579, -5.8894>, <1.8962, 39.5646, -6.09537>, 0.05549 }
				cylinder { <1.8962, 39.5646, -6.09537>, <1.8198, 39.6712, -6.3013>, 0.05549 }
				cylinder { <1.8198, 39.6712, -6.3013>, <1.7434, 39.7778, -6.5072>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <1.7434, 39.7778, -6.5072>, <1.7411, 39.7915, -6.5405>, 0.002463 }
				cylinder { <1.7411, 39.7915, -6.5405>, <1.7481, 39.8022, -6.5744>, 0.002463 }
				cylinder { <1.7481, 39.8022, -6.5744>, <1.7638, 39.809, -6.6062>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <1.7638, 39.809, -6.6062>, <2.1806, 40.8885, -8.3316>, <2.6276, 40.6598, -8.8255> }
				triangle { <1.7638, 39.809, -6.6062>, <2.6276, 40.6598, -8.8255>, <2.1806, 40.8885, -8.3316> }
				triangle { <2.1806, 40.8885, -8.3316>, <2.6872, 41.5313, -9.7738>, <2.6276, 40.6598, -8.8255> }
				triangle { <2.1806, 40.8885, -8.3316>, <2.6276, 40.6598, -8.8255>, <2.6872, 41.5313, -9.7738> }
				triangle { <2.6872, 41.5313, -9.7738>, <3.2893, 40.4716, -9.7039>, <2.6276, 40.6598, -8.8255> }
				triangle { <2.6872, 41.5313, -9.7738>, <2.6276, 40.6598, -8.8255>, <3.2893, 40.4716, -9.7039> }
				triangle { <2.6276, 40.6598, -8.8255>, <3.2893, 40.4716, -9.7039>, <1.7638, 39.809, -6.6062> }
				triangle { <2.6276, 40.6598, -8.8255>, <1.7638, 39.809, -6.6062>, <3.2893, 40.4716, -9.7039> }
				triangle { <2.6872, 41.5313, -9.7738>, <-0.05716, 39.8122, -13.04507>, <-0.7942, 38.6724, -14.5941> }
				triangle { <2.6872, 41.5313, -9.7738>, <-0.7942, 38.6724, -14.5941>, <-0.05716, 39.8122, -13.04507> }
				triangle { <-0.7942, 38.6724, -14.5941>, <-1.1057, 37.6155, -15.1399>, <-0.9459, 37.7944, -13.8035> }
				triangle { <-0.7942, 38.6724, -14.5941>, <-0.9459, 37.7944, -13.8035>, <-1.1057, 37.6155, -15.1399> }
				triangle { <-0.9459, 37.7944, -13.8035>, <2.6872, 41.5313, -9.7738>, <-0.7942, 38.6724, -14.5941> }
				triangle { <-0.9459, 37.7944, -13.8035>, <-0.7942, 38.6724, -14.5941>, <2.6872, 41.5313, -9.7738> }
				triangle { <2.6872, 41.5313, -9.7738>, <-0.9459, 37.7944, -13.8035>, <3.2893, 40.4716, -9.7039> }
				triangle { <2.6872, 41.5313, -9.7738>, <3.2893, 40.4716, -9.7039>, <-0.9459, 37.7944, -13.8035> }
				triangle { <3.06121, 39.8968, -8.7752>, <2.9996, 39.4473, -8.2366>, <1.7638, 39.809, -6.6062> }
				triangle { <3.06121, 39.8968, -8.7752>, <1.7638, 39.809, -6.6062>, <2.9996, 39.4473, -8.2366> }
				triangle { <3.06121, 39.8968, -8.7752>, <3.8915, 39.4119, -9.634>, <2.9996, 39.4473, -8.2366> }
				triangle { <3.06121, 39.8968, -8.7752>, <2.9996, 39.4473, -8.2366>, <3.8915, 39.4119, -9.634> }
				triangle { <3.06121, 39.8968, -8.7752>, <3.2893, 40.4716, -9.7039>, <3.8915, 39.4119, -9.634> }
				triangle { <3.06121, 39.8968, -8.7752>, <3.8915, 39.4119, -9.634>, <3.2893, 40.4716, -9.7039> }
				triangle { <1.7638, 39.809, -6.6062>, <3.2893, 40.4716, -9.7039>, <3.06121, 39.8968, -8.7752> }
				triangle { <1.7638, 39.809, -6.6062>, <3.06121, 39.8968, -8.7752>, <3.2893, 40.4716, -9.7039> }
				triangle { <-0.07163, 37.4007, -14.5102>, <1.1953, 37.6081, -12.8997>, <3.8915, 39.4119, -9.634> }
				triangle { <-0.07163, 37.4007, -14.5102>, <3.8915, 39.4119, -9.634>, <1.1953, 37.6081, -12.8997> }
				triangle { <-0.9459, 37.7944, -13.8035>, <-1.1057, 37.6155, -15.1399>, <-0.07163, 37.4007, -14.5102> }
				triangle { <-0.9459, 37.7944, -13.8035>, <-0.07163, 37.4007, -14.5102>, <-1.1057, 37.6155, -15.1399> }
				triangle { <-0.07163, 37.4007, -14.5102>, <3.8915, 39.4119, -9.634>, <-0.9459, 37.7944, -13.8035> }
				triangle { <-0.07163, 37.4007, -14.5102>, <-0.9459, 37.7944, -13.8035>, <3.8915, 39.4119, -9.634> }
				triangle { <3.2893, 40.4716, -9.7039>, <-0.9459, 37.7944, -13.8035>, <3.8915, 39.4119, -9.634> }
				triangle { <3.2893, 40.4716, -9.7039>, <3.8915, 39.4119, -9.634>, <-0.9459, 37.7944, -13.8035> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <1.7434, 39.7778, -6.5072>, <1.667, 39.8844, -6.7131>, 0.05549 }
				cylinder { <1.667, 39.8844, -6.7131>, <1.5905, 39.9911, -6.919>, 0.05549 }
				cylinder { <1.5905, 39.9911, -6.919>, <1.5141, 40.09772, -7.125>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <1.5141, 40.09772, -7.125>, <1.4945, 40.1144, -7.1504>, 0.002463 }
				cylinder { <1.4945, 40.1144, -7.1504>, <1.4682, 40.1308, -7.1688>, 0.002463 }
				cylinder { <1.4682, 40.1308, -7.1688>, <1.4369, 40.1457, -7.179>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <1.4369, 40.1457, -7.179>, <-0.3186, 41.2326, -6.9492>, <-0.7754, 41.3344, -7.4754> }
				triangle { <1.4369, 40.1457, -7.179>, <-0.7754, 41.3344, -7.4754>, <-0.3186, 41.2326, -6.9492> }
				triangle { <-0.3186, 41.2326, -6.9492>, <-1.7639, 42.03998, -7.04282>, <-0.7754, 41.3344, -7.4754> }
				triangle { <-0.3186, 41.2326, -6.9492>, <-0.7754, 41.3344, -7.4754>, <-1.7639, 42.03998, -7.04282> }
				triangle { <-1.7639, 42.03998, -7.04282>, <-1.6064, 41.6005, -8.1708>, <-0.7754, 41.3344, -7.4754> }
				triangle { <-1.7639, 42.03998, -7.04282>, <-0.7754, 41.3344, -7.4754>, <-1.6064, 41.6005, -8.1708> }
				triangle { <-0.7754, 41.3344, -7.4754>, <-1.6064, 41.6005, -8.1708>, <1.4369, 40.1457, -7.179> }
				triangle { <-0.7754, 41.3344, -7.4754>, <1.4369, 40.1457, -7.179>, <-1.6064, 41.6005, -8.1708> }
				triangle { <-1.7639, 42.03998, -7.04282>, <-5.08031, 38.9481, -6.2487>, <-6.6037, 37.5874, -6.5128> }
				triangle { <-1.7639, 42.03998, -7.04282>, <-6.6037, 37.5874, -6.5128>, <-5.08031, 38.9481, -6.2487> }
				triangle { <-6.6037, 37.5874, -6.5128>, <-7.1086, 36.5677, -6.9788>, <-5.777, 36.8173, -6.8901> }
				triangle { <-6.6037, 37.5874, -6.5128>, <-5.777, 36.8173, -6.8901>, <-7.1086, 36.5677, -6.9788> }
				triangle { <-5.777, 36.8173, -6.8901>, <-1.7639, 42.03998, -7.04282>, <-6.6037, 37.5874, -6.5128> }
				triangle { <-5.777, 36.8173, -6.8901>, <-6.6037, 37.5874, -6.5128>, <-1.7639, 42.03998, -7.04282> }
				triangle { <-1.7639, 42.03998, -7.04282>, <-5.777, 36.8173, -6.8901>, <-1.6064, 41.6005, -8.1708> }
				triangle { <-1.7639, 42.03998, -7.04282>, <-1.6064, 41.6005, -8.1708>, <-5.777, 36.8173, -6.8901> }
				triangle { <-0.662, 41.01805, -8.2876>, <-0.1043, 40.6349, -8.4833>, <1.4369, 40.1457, -7.179> }
				triangle { <-0.662, 41.01805, -8.2876>, <1.4369, 40.1457, -7.179>, <-0.1043, 40.6349, -8.4833> }
				triangle { <-0.662, 41.01805, -8.2876>, <-1.4488, 41.1611, -9.2989>, <-0.1043, 40.6349, -8.4833> }
				triangle { <-0.662, 41.01805, -8.2876>, <-0.1043, 40.6349, -8.4833>, <-1.4488, 41.1611, -9.2989> }
				triangle { <-0.662, 41.01805, -8.2876>, <-1.6064, 41.6005, -8.1708>, <-1.4488, 41.1611, -9.2989> }
				triangle { <-0.662, 41.01805, -8.2876>, <-1.4488, 41.1611, -9.2989>, <-1.6064, 41.6005, -8.1708> }
				triangle { <1.4369, 40.1457, -7.179>, <-1.6064, 41.6005, -8.1708>, <-0.662, 41.01805, -8.2876> }
				triangle { <1.4369, 40.1457, -7.179>, <-0.662, 41.01805, -8.2876>, <-1.6064, 41.6005, -8.1708> }
				triangle { <-6.4146, 37.06011, -7.8665>, <-4.7525, 38.03416, -8.5951>, <-1.4488, 41.1611, -9.2989> }
				triangle { <-6.4146, 37.06011, -7.8665>, <-1.4488, 41.1611, -9.2989>, <-4.7525, 38.03416, -8.5951> }
				triangle { <-5.777, 36.8173, -6.8901>, <-7.1086, 36.5677, -6.9788>, <-6.4146, 37.06011, -7.8665> }
				triangle { <-5.777, 36.8173, -6.8901>, <-6.4146, 37.06011, -7.8665>, <-7.1086, 36.5677, -6.9788> }
				triangle { <-6.4146, 37.06011, -7.8665>, <-1.4488, 41.1611, -9.2989>, <-5.777, 36.8173, -6.8901> }
				triangle { <-6.4146, 37.06011, -7.8665>, <-5.777, 36.8173, -6.8901>, <-1.4488, 41.1611, -9.2989> }
				triangle { <-1.6064, 41.6005, -8.1708>, <-5.777, 36.8173, -6.8901>, <-1.4488, 41.1611, -9.2989> }
				triangle { <-1.6064, 41.6005, -8.1708>, <-1.4488, 41.1611, -9.2989>, <-5.777, 36.8173, -6.8901> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <1.5141, 40.09772, -7.125>, <1.4377, 40.2043, -7.3309>, 0.05549 }
				cylinder { <1.4377, 40.2043, -7.3309>, <1.3612, 40.3109, -7.5368>, 0.05549 }
				cylinder { <1.3612, 40.3109, -7.5368>, <1.2848, 40.4175, -7.7428>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <1.2848, 40.4175, -7.7428>, <1.2826, 40.4312, -7.7761>, 0.002463 }
				cylinder { <1.2826, 40.4312, -7.7761>, <1.2895, 40.4419, -7.8099>, 0.002463 }
				cylinder { <1.2895, 40.4419, -7.8099>, <1.3052, 40.4487, -7.8418>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <1.3052, 40.4487, -7.8418>, <1.7221, 41.5282, -9.5672>, <2.169, 41.2995, -10.06117> }
				triangle { <1.3052, 40.4487, -7.8418>, <2.169, 41.2995, -10.06117>, <1.7221, 41.5282, -9.5672> }
				triangle { <1.7221, 41.5282, -9.5672>, <2.2286, 42.171, -11.00939>, <2.169, 41.2995, -10.06117> }
				triangle { <1.7221, 41.5282, -9.5672>, <2.169, 41.2995, -10.06117>, <2.2286, 42.171, -11.00939> }
				triangle { <2.2286, 42.171, -11.00939>, <2.8308, 41.1113, -10.9395>, <2.169, 41.2995, -10.06117> }
				triangle { <2.2286, 42.171, -11.00939>, <2.169, 41.2995, -10.06117>, <2.8308, 41.1113, -10.9395> }
				triangle { <2.169, 41.2995, -10.06117>, <2.8308, 41.1113, -10.9395>, <1.3052, 40.4487, -7.8418> }
				triangle { <2.169, 41.2995, -10.06117>, <1.3052, 40.4487, -7.8418>, <2.8308, 41.1113, -10.9395> }
				triangle { <2.2286, 42.171, -11.00939>, <-0.5157, 40.452, -14.2806>, <-1.2528, 39.3121, -15.8297> }
				triangle { <2.2286, 42.171, -11.00939>, <-1.2528, 39.3121, -15.8297>, <-0.5157, 40.452, -14.2806> }
				triangle { <-1.2528, 39.3121, -15.8297>, <-1.5643, 38.2552, -16.3755>, <-1.4045, 38.4341, -15.03915> }
				triangle { <-1.2528, 39.3121, -15.8297>, <-1.4045, 38.4341, -15.03915>, <-1.5643, 38.2552, -16.3755> }
				triangle { <-1.4045, 38.4341, -15.03915>, <2.2286, 42.171, -11.00939>, <-1.2528, 39.3121, -15.8297> }
				triangle { <-1.4045, 38.4341, -15.03915>, <-1.2528, 39.3121, -15.8297>, <2.2286, 42.171, -11.00939> }
				triangle { <2.2286, 42.171, -11.00939>, <-1.4045, 38.4341, -15.03915>, <2.8308, 41.1113, -10.9395> }
				triangle { <2.2286, 42.171, -11.00939>, <2.8308, 41.1113, -10.9395>, <-1.4045, 38.4341, -15.03915> }
				triangle { <2.6026, 40.5366, -10.01085>, <2.541, 40.08708, -9.4722>, <1.3052, 40.4487, -7.8418> }
				triangle { <2.6026, 40.5366, -10.01085>, <1.3052, 40.4487, -7.8418>, <2.541, 40.08708, -9.4722> }
				triangle { <2.6026, 40.5366, -10.01085>, <3.4329, 40.05169, -10.8696>, <2.541, 40.08708, -9.4722> }
				triangle { <2.6026, 40.5366, -10.01085>, <2.541, 40.08708, -9.4722>, <3.4329, 40.05169, -10.8696> }
				triangle { <2.6026, 40.5366, -10.01085>, <2.8308, 41.1113, -10.9395>, <3.4329, 40.05169, -10.8696> }
				triangle { <2.6026, 40.5366, -10.01085>, <3.4329, 40.05169, -10.8696>, <2.8308, 41.1113, -10.9395> }
				triangle { <1.3052, 40.4487, -7.8418>, <2.8308, 41.1113, -10.9395>, <2.6026, 40.5366, -10.01085> }
				triangle { <1.3052, 40.4487, -7.8418>, <2.6026, 40.5366, -10.01085>, <2.8308, 41.1113, -10.9395> }
				triangle { <-0.5302, 38.04052, -15.7458>, <0.7367, 38.2478, -14.1352>, <3.4329, 40.05169, -10.8696> }
				triangle { <-0.5302, 38.04052, -15.7458>, <3.4329, 40.05169, -10.8696>, <0.7367, 38.2478, -14.1352> }
				triangle { <-1.4045, 38.4341, -15.03915>, <-1.5643, 38.2552, -16.3755>, <-0.5302, 38.04052, -15.7458> }
				triangle { <-1.4045, 38.4341, -15.03915>, <-0.5302, 38.04052, -15.7458>, <-1.5643, 38.2552, -16.3755> }
				triangle { <-0.5302, 38.04052, -15.7458>, <3.4329, 40.05169, -10.8696>, <-1.4045, 38.4341, -15.03915> }
				triangle { <-0.5302, 38.04052, -15.7458>, <-1.4045, 38.4341, -15.03915>, <3.4329, 40.05169, -10.8696> }
				triangle { <2.8308, 41.1113, -10.9395>, <-1.4045, 38.4341, -15.03915>, <3.4329, 40.05169, -10.8696> }
				triangle { <2.8308, 41.1113, -10.9395>, <3.4329, 40.05169, -10.8696>, <-1.4045, 38.4341, -15.03915> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <1.2848, 40.4175, -7.7428>, <1.2735, 40.4333, -7.7732>, 0.002463 }
				cylinder { <1.2735, 40.4333, -7.7732>, <1.2622, 40.4491, -7.8037>, 0.002463 }
				cylinder { <1.2622, 40.4491, -7.8037>, <1.2509, 40.4649, -7.8342>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <1.2509, 40.4649, -7.8342>, <0.2107, 41.8384, -8.9951>, <0.2362, 41.8393, -9.6989> }
				triangle { <1.2509, 40.4649, -7.8342>, <0.2362, 41.8393, -9.6989>, <0.2107, 41.8384, -8.9951> }
				triangle { <0.2107, 41.8384, -8.9951>, <-0.5026, 42.7971, -10.1446>, <0.2362, 41.8393, -9.6989> }
				triangle { <0.2107, 41.8384, -8.9951>, <0.2362, 41.8393, -9.6989>, <-0.5026, 42.7971, -10.1446> }
				triangle { <-0.5026, 42.7971, -10.1446>, <0.1503, 42.00027, -10.7996>, <0.2362, 41.8393, -9.6989> }
				triangle { <-0.5026, 42.7971, -10.1446>, <0.2362, 41.8393, -9.6989>, <0.1503, 42.00027, -10.7996> }
				triangle { <0.2362, 41.8393, -9.6989>, <0.1503, 42.00027, -10.7996>, <1.2509, 40.4649, -7.8342> }
				triangle { <0.2362, 41.8393, -9.6989>, <1.2509, 40.4649, -7.8342>, <0.1503, 42.00027, -10.7996> }
				triangle { <-0.5026, 42.7971, -10.1446>, <-4.4059, 40.7054, -11.4001>, <-5.7965, 39.5988, -12.4413> }
				triangle { <-0.5026, 42.7971, -10.1446>, <-5.7965, 39.5988, -12.4413>, <-4.4059, 40.7054, -11.4001> }
				triangle { <-5.7965, 39.5988, -12.4413>, <-6.2171, 38.58, -12.9864>, <-5.2293, 38.6248, -12.05606> }
				triangle { <-5.7965, 39.5988, -12.4413>, <-5.2293, 38.6248, -12.05606>, <-6.2171, 38.58, -12.9864> }
				triangle { <-5.2293, 38.6248, -12.05606>, <-0.5026, 42.7971, -10.1446>, <-5.7965, 39.5988, -12.4413> }
				triangle { <-5.2293, 38.6248, -12.05606>, <-5.7965, 39.5988, -12.4413>, <-0.5026, 42.7971, -10.1446> }
				triangle { <-0.5026, 42.7971, -10.1446>, <-5.2293, 38.6248, -12.05606>, <0.1503, 42.00027, -10.7996> }
				triangle { <-0.5026, 42.7971, -10.1446>, <0.1503, 42.00027, -10.7996>, <-5.2293, 38.6248, -12.05606> }
				triangle { <0.7064, 41.2655, -10.1704>, <1.0988, 40.7546, -9.8858>, <1.2509, 40.4649, -7.8342> }
				triangle { <0.7064, 41.2655, -10.1704>, <1.2509, 40.4649, -7.8342>, <1.0988, 40.7546, -9.8858> }
				triangle { <0.7064, 41.2655, -10.1704>, <0.8033, 41.2033, -11.4545>, <1.0988, 40.7546, -9.8858> }
				triangle { <0.7064, 41.2655, -10.1704>, <1.0988, 40.7546, -9.8858>, <0.8033, 41.2033, -11.4545> }
				triangle { <0.7064, 41.2655, -10.1704>, <0.1503, 42.00027, -10.7996>, <0.8033, 41.2033, -11.4545> }
				triangle { <0.7064, 41.2655, -10.1704>, <0.8033, 41.2033, -11.4545>, <0.1503, 42.00027, -10.7996> }
				triangle { <1.2509, 40.4649, -7.8342>, <0.1503, 42.00027, -10.7996>, <0.7064, 41.2655, -10.1704> }
				triangle { <1.2509, 40.4649, -7.8342>, <0.7064, 41.2655, -10.1704>, <0.1503, 42.00027, -10.7996> }
				triangle { <-5.01297, 38.6425, -13.2272>, <-3.04778, 39.04788, -12.7624>, <0.8033, 41.2033, -11.4545> }
				triangle { <-5.01297, 38.6425, -13.2272>, <0.8033, 41.2033, -11.4545>, <-3.04778, 39.04788, -12.7624> }
				triangle { <-5.2293, 38.6248, -12.05606>, <-6.2171, 38.58, -12.9864>, <-5.01297, 38.6425, -13.2272> }
				triangle { <-5.2293, 38.6248, -12.05606>, <-5.01297, 38.6425, -13.2272>, <-6.2171, 38.58, -12.9864> }
				triangle { <-5.01297, 38.6425, -13.2272>, <0.8033, 41.2033, -11.4545>, <-5.2293, 38.6248, -12.05606> }
				triangle { <-5.01297, 38.6425, -13.2272>, <-5.2293, 38.6248, -12.05606>, <0.8033, 41.2033, -11.4545> }
				triangle { <0.1503, 42.00027, -10.7996>, <-5.2293, 38.6248, -12.05606>, <0.8033, 41.2033, -11.4545> }
				triangle { <0.1503, 42.00027, -10.7996>, <0.8033, 41.2033, -11.4545>, <-5.2293, 38.6248, -12.05606> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // primary inflorescence
		union { // Primary inflorescence stalk (peduncle)
			cylinder { <2.4432, 37.8238, -4.2537>, <3.1203, 46.6768, -6.1148>, 0.4123 }
			cylinder { <3.1203, 46.6768, -6.1148>, <3.7974, 55.5299, -7.9759>, 0.4123 }
			cylinder { <3.7974, 55.5299, -7.9759>, <4.4745, 64.3829, -9.837>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <4.4745, 64.3829, -9.837>, <4.6324, 66.4486, -10.2713>, 0.4123 }
			cylinder { <4.6324, 66.4486, -10.2713>, <4.7904, 68.5143, -10.7055>, 0.4123 }
			cylinder { <4.7904, 68.5143, -10.7055>, <4.9484, 70.5801, -11.1398>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <4.9484, 70.5801, -11.1398>, <3.689, 72.2015, -10.6245>, 0.4123 }
			cylinder { <3.689, 72.2015, -10.6245>, <2.4296, 73.8229, -10.1092>, 0.4123 }
			cylinder { <2.4296, 73.8229, -10.1092>, <1.1702, 75.4443, -9.5939>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <1.1702, 75.4443, -9.5939>, <-0.5622, 79.4291, -8.2921>, 0.4123 }
				cylinder { <-0.5622, 79.4291, -8.2921>, <-1.2245, 83.6854, -6.8707>, 0.4123 }
				cylinder { <-1.2245, 83.6854, -6.8707>, <-0.777, 87.958, -5.415>, 0.4123 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <-0.777, 87.958, -5.415>, <-1.6773, 90.02979, -7.1058>, <-0.7765, 91.02324, -4.4718> }
					triangle { <-0.777, 87.958, -5.415>, <-0.7765, 91.02324, -4.4718>, <-1.6773, 90.02979, -7.1058> }
					triangle { <-1.6773, 90.02979, -7.1058>, <-0.6699, 92.2262, -8.03538>, <-0.7765, 91.02324, -4.4718> }
					triangle { <-1.6773, 90.02979, -7.1058>, <-0.7765, 91.02324, -4.4718>, <-0.6699, 92.2262, -8.03538> }
					triangle { <-0.6699, 92.2262, -8.03538>, <0.4337, 95.4816, -7.6469>, <-0.8377, 95.2496, -6.9178> }
					triangle { <-0.6699, 92.2262, -8.03538>, <-0.8377, 95.2496, -6.9178>, <0.4337, 95.4816, -7.6469> }
					triangle { <-0.8377, 95.2496, -6.9178>, <-1.1796, 94.5794, -5.1883>, <-0.6699, 92.2262, -8.03538> }
					triangle { <-0.8377, 95.2496, -6.9178>, <-0.6699, 92.2262, -8.03538>, <-1.1796, 94.5794, -5.1883> }
					triangle { <-0.6699, 92.2262, -8.03538>, <-1.1796, 94.5794, -5.1883>, <-0.7765, 91.02324, -4.4718> }
					triangle { <-0.6699, 92.2262, -8.03538>, <-0.7765, 91.02324, -4.4718>, <-1.1796, 94.5794, -5.1883> }
					triangle { <-0.7765, 91.02324, -4.4718>, <-1.1796, 94.5794, -5.1883>, <-0.3678, 93.9043, -3.4565> }
					triangle { <-0.7765, 91.02324, -4.4718>, <-0.3678, 93.9043, -3.4565>, <-1.1796, 94.5794, -5.1883> }
					triangle { <-1.1796, 94.5794, -5.1883>, <-0.4829, 96.886, -2.5755>, <-0.3678, 93.9043, -3.4565> }
					triangle { <-1.1796, 94.5794, -5.1883>, <-0.3678, 93.9043, -3.4565>, <-0.4829, 96.886, -2.5755> }
					triangle { <-0.8377, 95.2496, -6.9178>, <-0.4616, 97.8198, -6.008392>, <-1.1796, 94.5794, -5.1883> }
					triangle { <-0.8377, 95.2496, -6.9178>, <-1.1796, 94.5794, -5.1883>, <-0.4616, 97.8198, -6.008392> }
					triangle { <-1.1796, 94.5794, -5.1883>, <-0.4616, 97.8198, -6.008392>, <-0.6127, 97.6785, -4.1761> }
					triangle { <-1.1796, 94.5794, -5.1883>, <-0.6127, 97.6785, -4.1761>, <-0.4616, 97.8198, -6.008392> }
					triangle { <-0.6127, 97.6785, -4.1761>, <-0.4829, 96.886, -2.5755>, <-1.1796, 94.5794, -5.1883> }
					triangle { <-0.6127, 97.6785, -4.1761>, <-1.1796, 94.5794, -5.1883>, <-0.4829, 96.886, -2.5755> }
					triangle { <0.4337, 95.4816, -7.6469>, <-0.4616, 97.8198, -6.008392>, <-0.8377, 95.2496, -6.9178> }
					triangle { <0.4337, 95.4816, -7.6469>, <-0.8377, 95.2496, -6.9178>, <-0.4616, 97.8198, -6.008392> }
					triangle { <-0.4616, 97.8198, -6.008392>, <-0.6928, 98.3391, -4.7194>, <-0.6127, 97.6785, -4.1761> }
					triangle { <-0.4616, 97.8198, -6.008392>, <-0.6127, 97.6785, -4.1761>, <-0.6928, 98.3391, -4.7194> }
					triangle { <-0.6928, 98.3391, -4.7194>, <-0.9984, 98.6929, -3.2645>, <-0.6127, 97.6785, -4.1761> }
					triangle { <-0.6928, 98.3391, -4.7194>, <-0.6127, 97.6785, -4.1761>, <-0.9984, 98.6929, -3.2645> }
					triangle { <-0.9984, 98.6929, -3.2645>, <-0.4829, 96.886, -2.5755>, <-0.6127, 97.6785, -4.1761> }
					triangle { <-0.9984, 98.6929, -3.2645>, <-0.6127, 97.6785, -4.1761>, <-0.4829, 96.886, -2.5755> }
					triangle { <-0.9984, 98.6929, -3.2645>, <0.814, 99.06781, -1.4946>, <-0.4829, 96.886, -2.5755> }
					triangle { <-0.9984, 98.6929, -3.2645>, <-0.4829, 96.886, -2.5755>, <0.814, 99.06781, -1.4946> }
					triangle { <-0.7765, 91.02324, -4.4718>, <-2.7584, 88.977, -3.6837>, <-0.777, 87.958, -5.415> }
					triangle { <-0.7765, 91.02324, -4.4718>, <-0.777, 87.958, -5.415>, <-2.7584, 88.977, -3.6837> }
					triangle { <-0.7765, 91.02324, -4.4718>, <-3.08272, 90.2431, -1.4732>, <-2.7584, 88.977, -3.6837> }
					triangle { <-0.7765, 91.02324, -4.4718>, <-2.7584, 88.977, -3.6837>, <-3.08272, 90.2431, -1.4732> }
					triangle { <-2.7044, 93.3098, -0.6507>, <-2.2783, 92.9628, 0.5793>, <-3.08272, 90.2431, -1.4732> }
					triangle { <-2.7044, 93.3098, -0.6507>, <-3.08272, 90.2431, -1.4732>, <-2.2783, 92.9628, 0.5793> }
					triangle { <-3.08272, 90.2431, -1.4732>, <-1.6509, 93.6319, -2.2625>, <-2.7044, 93.3098, -0.6507> }
					triangle { <-3.08272, 90.2431, -1.4732>, <-2.7044, 93.3098, -0.6507>, <-1.6509, 93.6319, -2.2625> }
					triangle { <-0.7765, 91.02324, -4.4718>, <-1.6509, 93.6319, -2.2625>, <-3.08272, 90.2431, -1.4732> }
					triangle { <-0.7765, 91.02324, -4.4718>, <-3.08272, 90.2431, -1.4732>, <-1.6509, 93.6319, -2.2625> }
					triangle { <-0.3678, 93.9043, -3.4565>, <-1.6509, 93.6319, -2.2625>, <-0.7765, 91.02324, -4.4718> }
					triangle { <-0.3678, 93.9043, -3.4565>, <-0.7765, 91.02324, -4.4718>, <-1.6509, 93.6319, -2.2625> }
					triangle { <-0.3678, 93.9043, -3.4565>, <-0.4829, 96.886, -2.5755>, <-1.6509, 93.6319, -2.2625> }
					triangle { <-0.3678, 93.9043, -3.4565>, <-1.6509, 93.6319, -2.2625>, <-0.4829, 96.886, -2.5755> }
					triangle { <-1.6509, 93.6319, -2.2625>, <-2.433, 95.9001, 0.2318>, <-2.7044, 93.3098, -0.6507> }
					triangle { <-1.6509, 93.6319, -2.2625>, <-2.7044, 93.3098, -0.6507>, <-2.433, 95.9001, 0.2318> }
					triangle { <-1.4619, 96.7295, -1.1297>, <-2.433, 95.9001, 0.2318>, <-1.6509, 93.6319, -2.2625> }
					triangle { <-1.4619, 96.7295, -1.1297>, <-1.6509, 93.6319, -2.2625>, <-2.433, 95.9001, 0.2318> }
					triangle { <-1.6509, 93.6319, -2.2625>, <-0.4829, 96.886, -2.5755>, <-1.4619, 96.7295, -1.1297> }
					triangle { <-1.6509, 93.6319, -2.2625>, <-1.4619, 96.7295, -1.1297>, <-0.4829, 96.886, -2.5755> }
					triangle { <-2.7044, 93.3098, -0.6507>, <-2.433, 95.9001, 0.2318>, <-2.2783, 92.9628, 0.5793> }
					triangle { <-2.7044, 93.3098, -0.6507>, <-2.2783, 92.9628, 0.5793>, <-2.433, 95.9001, 0.2318> }
					triangle { <-1.4619, 96.7295, -1.1297>, <-2.02828, 97.03872, -0.4922>, <-2.433, 95.9001, 0.2318> }
					triangle { <-1.4619, 96.7295, -1.1297>, <-2.433, 95.9001, 0.2318>, <-2.02828, 97.03872, -0.4922> }
					triangle { <-1.4619, 96.7295, -1.1297>, <-1.5707, 98.1355, -1.4528>, <-2.02828, 97.03872, -0.4922> }
					triangle { <-1.4619, 96.7295, -1.1297>, <-2.02828, 97.03872, -0.4922>, <-1.5707, 98.1355, -1.4528> }
					triangle { <-1.4619, 96.7295, -1.1297>, <-0.4829, 96.886, -2.5755>, <-1.5707, 98.1355, -1.4528> }
					triangle { <-1.4619, 96.7295, -1.1297>, <-1.5707, 98.1355, -1.4528>, <-0.4829, 96.886, -2.5755> }
					triangle { <-0.4829, 96.886, -2.5755>, <0.814, 99.06781, -1.4946>, <-1.5707, 98.1355, -1.4528> }
					triangle { <-0.4829, 96.886, -2.5755>, <-1.5707, 98.1355, -1.4528>, <0.814, 99.06781, -1.4946> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-0.777, 87.958, -5.415>, <-2.1031, 88.6868, -3.03336>, <-0.3904, 90.8522, -4.08871> }
					triangle { <-0.777, 87.958, -5.415>, <-0.3904, 90.8522, -4.08871>, <-2.1031, 88.6868, -3.03336> }
					triangle { <-2.1031, 88.6868, -3.03336>, <-3.6994, 90.5949, -2.3163>, <-0.3904, 90.8522, -4.08871> }
					triangle { <-2.1031, 88.6868, -3.03336>, <-0.3904, 90.8522, -4.08871>, <-3.6994, 90.5949, -2.3163> }
					triangle { <-3.6994, 90.5949, -2.3163>, <-4.3481, 93.9057, -1.5517>, <-3.07522, 93.4478, -0.9416> }
					triangle { <-3.6994, 90.5949, -2.3163>, <-3.07522, 93.4478, -0.9416>, <-4.3481, 93.9057, -1.5517> }
					triangle { <-3.07522, 93.4478, -0.9416>, <-1.3182, 93.3795, -1.6241>, <-3.6994, 90.5949, -2.3163> }
					triangle { <-3.07522, 93.4478, -0.9416>, <-3.6994, 90.5949, -2.3163>, <-1.3182, 93.3795, -1.6241> }
					triangle { <-3.6994, 90.5949, -2.3163>, <-1.3182, 93.3795, -1.6241>, <-0.3904, 90.8522, -4.08871> }
					triangle { <-3.6994, 90.5949, -2.3163>, <-0.3904, 90.8522, -4.08871>, <-1.3182, 93.3795, -1.6241> }
					triangle { <-0.3904, 90.8522, -4.08871>, <-1.3182, 93.3795, -1.6241>, <-0.1104, 93.7903, -3.201> }
					triangle { <-0.3904, 90.8522, -4.08871>, <-0.1104, 93.7903, -3.201>, <-1.3182, 93.3795, -1.6241> }
					triangle { <-1.3182, 93.3795, -1.6241>, <0.2892, 96.544, -1.8092>, <-0.1104, 93.7903, -3.201> }
					triangle { <-1.3182, 93.3795, -1.6241>, <-0.1104, 93.7903, -3.201>, <0.2892, 96.544, -1.8092> }
					triangle { <-3.07522, 93.4478, -0.9416>, <-2.8278, 96.07502, -0.1599>, <-1.3182, 93.3795, -1.6241> }
					triangle { <-3.07522, 93.4478, -0.9416>, <-1.3182, 93.3795, -1.6241>, <-2.8278, 96.07502, -0.1599> }
					triangle { <-1.3182, 93.3795, -1.6241>, <-2.8278, 96.07502, -0.1599>, <-1.1473, 96.5639, -0.7405> }
					triangle { <-1.3182, 93.3795, -1.6241>, <-1.1473, 96.5639, -0.7405>, <-2.8278, 96.07502, -0.1599> }
					triangle { <-1.1473, 96.5639, -0.7405>, <0.2892, 96.544, -1.8092>, <-1.3182, 93.3795, -1.6241> }
					triangle { <-1.1473, 96.5639, -0.7405>, <-1.3182, 93.3795, -1.6241>, <0.2892, 96.544, -1.8092> }
					triangle { <-4.3481, 93.9057, -1.5517>, <-2.8278, 96.07502, -0.1599>, <-3.07522, 93.4478, -0.9416> }
					triangle { <-4.3481, 93.9057, -1.5517>, <-3.07522, 93.4478, -0.9416>, <-2.8278, 96.07502, -0.1599> }
					triangle { <-2.8278, 96.07502, -0.1599>, <-1.6729, 96.8813, -0.1395>, <-1.1473, 96.5639, -0.7405> }
					triangle { <-2.8278, 96.07502, -0.1599>, <-1.1473, 96.5639, -0.7405>, <-1.6729, 96.8813, -0.1395> }
					triangle { <-1.6729, 96.8813, -0.1395>, <-0.3152, 97.5795, -0.2069>, <-1.1473, 96.5639, -0.7405> }
					triangle { <-1.6729, 96.8813, -0.1395>, <-1.1473, 96.5639, -0.7405>, <-0.3152, 97.5795, -0.2069> }
					triangle { <-0.3152, 97.5795, -0.2069>, <0.2892, 96.544, -1.8092>, <-1.1473, 96.5639, -0.7405> }
					triangle { <-0.3152, 97.5795, -0.2069>, <-1.1473, 96.5639, -0.7405>, <0.2892, 96.544, -1.8092> }
					triangle { <-0.3152, 97.5795, -0.2069>, <0.2992, 99.2958, -2.005563>, <0.2892, 96.544, -1.8092> }
					triangle { <-0.3152, 97.5795, -0.2069>, <0.2892, 96.544, -1.8092>, <0.2992, 99.2958, -2.005563> }
					triangle { <-0.3904, 90.8522, -4.08871>, <1.5283, 88.61, -3.9244>, <-0.777, 87.958, -5.415> }
					triangle { <-0.3904, 90.8522, -4.08871>, <-0.777, 87.958, -5.415>, <1.5283, 88.61, -3.9244> }
					triangle { <-0.3904, 90.8522, -4.08871>, <3.4218, 90.3353, -3.7436>, <1.5283, 88.61, -3.9244> }
					triangle { <-0.3904, 90.8522, -4.08871>, <1.5283, 88.61, -3.9244>, <3.4218, 90.3353, -3.7436> }
					triangle { <3.5229, 93.3446, -2.6674>, <4.4341, 93.6837, -3.5999>, <3.4218, 90.3353, -3.7436> }
					triangle { <3.5229, 93.3446, -2.6674>, <3.4218, 90.3353, -3.7436>, <4.4341, 93.6837, -3.5999> }
					triangle { <3.4218, 90.3353, -3.7436>, <1.5765, 93.4637, -2.7613>, <3.5229, 93.3446, -2.6674> }
					triangle { <3.4218, 90.3353, -3.7436>, <3.5229, 93.3446, -2.6674>, <1.5765, 93.4637, -2.7613> }
					triangle { <-0.3904, 90.8522, -4.08871>, <1.5765, 93.4637, -2.7613>, <3.4218, 90.3353, -3.7436> }
					triangle { <-0.3904, 90.8522, -4.08871>, <3.4218, 90.3353, -3.7436>, <1.5765, 93.4637, -2.7613> }
					triangle { <-0.1104, 93.7903, -3.201>, <1.5765, 93.4637, -2.7613>, <-0.3904, 90.8522, -4.08871> }
					triangle { <-0.1104, 93.7903, -3.201>, <-0.3904, 90.8522, -4.08871>, <1.5765, 93.4637, -2.7613> }
					triangle { <-0.1104, 93.7903, -3.201>, <0.2892, 96.544, -1.8092>, <1.5765, 93.4637, -2.7613> }
					triangle { <-0.1104, 93.7903, -3.201>, <1.5765, 93.4637, -2.7613>, <0.2892, 96.544, -1.8092> }
					triangle { <1.5765, 93.4637, -2.7613>, <3.7942, 95.935, -1.7848>, <3.5229, 93.3446, -2.6674> }
					triangle { <1.5765, 93.4637, -2.7613>, <3.5229, 93.3446, -2.6674>, <3.7942, 95.935, -1.7848> }
					triangle { <2.03289, 96.533, -1.6275>, <3.7942, 95.935, -1.7848>, <1.5765, 93.4637, -2.7613> }
					triangle { <2.03289, 96.533, -1.6275>, <1.5765, 93.4637, -2.7613>, <3.7942, 95.935, -1.7848> }
					triangle { <1.5765, 93.4637, -2.7613>, <0.2892, 96.544, -1.8092>, <2.03289, 96.533, -1.6275> }
					triangle { <1.5765, 93.4637, -2.7613>, <2.03289, 96.533, -1.6275>, <0.2892, 96.544, -1.8092> }
					triangle { <3.5229, 93.3446, -2.6674>, <3.7942, 95.935, -1.7848>, <4.4341, 93.6837, -3.5999> }
					triangle { <3.5229, 93.3446, -2.6674>, <4.4341, 93.6837, -3.5999>, <3.7942, 95.935, -1.7848> }
					triangle { <2.03289, 96.533, -1.6275>, <2.813, 96.7865, -1.2403>, <3.7942, 95.935, -1.7848> }
					triangle { <2.03289, 96.533, -1.6275>, <3.7942, 95.935, -1.7848>, <2.813, 96.7865, -1.2403> }
					triangle { <2.03289, 96.533, -1.6275>, <1.6072, 97.5389, -0.6786>, <2.813, 96.7865, -1.2403> }
					triangle { <2.03289, 96.533, -1.6275>, <2.813, 96.7865, -1.2403>, <1.6072, 97.5389, -0.6786> }
					triangle { <2.03289, 96.533, -1.6275>, <0.2892, 96.544, -1.8092>, <1.6072, 97.5389, -0.6786> }
					triangle { <2.03289, 96.533, -1.6275>, <1.6072, 97.5389, -0.6786>, <0.2892, 96.544, -1.8092> }
					triangle { <0.2892, 96.544, -1.8092>, <0.2992, 99.2958, -2.005563>, <1.6072, 97.5389, -0.6786> }
					triangle { <0.2892, 96.544, -1.8092>, <1.6072, 97.5389, -0.6786>, <0.2992, 99.2958, -2.005563> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <-0.777, 87.958, -5.415>, <1.8254, 88.8993, -4.8649>, <-0.2244, 91.01388, -4.6141> }
					triangle { <-0.777, 87.958, -5.415>, <-0.2244, 91.01388, -4.6141>, <1.8254, 88.8993, -4.8649> }
					triangle { <1.8254, 88.8993, -4.8649>, <2.9795, 90.08525, -2.8736>, <-0.2244, 91.01388, -4.6141> }
					triangle { <1.8254, 88.8993, -4.8649>, <-0.2244, 91.01388, -4.6141>, <2.9795, 90.08525, -2.8736> }
					triangle { <2.9795, 90.08525, -2.8736>, <3.5123, 92.8463, -0.8588>, <3.4605, 93.2236, -2.2931> }
					triangle { <2.9795, 90.08525, -2.8736>, <3.4605, 93.2236, -2.2931>, <3.5123, 92.8463, -0.8588> }
					triangle { <3.4605, 93.2236, -2.2931>, <2.008196, 93.6433, -3.4209>, <2.9795, 90.08525, -2.8736> }
					triangle { <3.4605, 93.2236, -2.2931>, <2.9795, 90.08525, -2.8736>, <2.008196, 93.6433, -3.4209> }
					triangle { <2.9795, 90.08525, -2.8736>, <2.008196, 93.6433, -3.4209>, <-0.2244, 91.01388, -4.6141> }
					triangle { <2.9795, 90.08525, -2.8736>, <-0.2244, 91.01388, -4.6141>, <2.008196, 93.6433, -3.4209> }
					triangle { <-0.2244, 91.01388, -4.6141>, <2.008196, 93.6433, -3.4209>, <0.0001842, 93.898, -3.5513> }
					triangle { <-0.2244, 91.01388, -4.6141>, <0.0001842, 93.898, -3.5513>, <2.008196, 93.6433, -3.4209> }
					triangle { <2.008196, 93.6433, -3.4209>, <0.6212, 96.8673, -2.8601>, <0.0001842, 93.898, -3.5513> }
					triangle { <2.008196, 93.6433, -3.4209>, <0.0001842, 93.898, -3.5513>, <0.6212, 96.8673, -2.8601> }
					triangle { <3.4605, 93.2236, -2.2931>, <3.6525, 95.797, -1.3362>, <2.008196, 93.6433, -3.4209> }
					triangle { <3.4605, 93.2236, -2.2931>, <2.008196, 93.6433, -3.4209>, <3.6525, 95.797, -1.3362> }
					triangle { <2.008196, 93.6433, -3.4209>, <3.6525, 95.797, -1.3362>, <2.2506, 96.6849, -2.1402> }
					triangle { <2.008196, 93.6433, -3.4209>, <2.2506, 96.6849, -2.1402>, <3.6525, 95.797, -1.3362> }
					triangle { <2.2506, 96.6849, -2.1402>, <0.6212, 96.8673, -2.8601>, <2.008196, 93.6433, -3.4209> }
					triangle { <2.2506, 96.6849, -2.1402>, <2.008196, 93.6433, -3.4209>, <0.6212, 96.8673, -2.8601> }
					triangle { <3.5123, 92.8463, -0.8588>, <3.6525, 95.797, -1.3362>, <3.4605, 93.2236, -2.2931> }
					triangle { <3.5123, 92.8463, -0.8588>, <3.4605, 93.2236, -2.2931>, <3.6525, 95.797, -1.3362> }
					triangle { <3.6525, 95.797, -1.3362>, <2.9847, 96.9537, -1.7839>, <2.2506, 96.6849, -2.1402> }
					triangle { <3.6525, 95.797, -1.3362>, <2.2506, 96.6849, -2.1402>, <2.9847, 96.9537, -1.7839> }
					triangle { <2.9847, 96.9537, -1.7839>, <2.1551, 98.07241, -2.4129>, <2.2506, 96.6849, -2.1402> }
					triangle { <2.9847, 96.9537, -1.7839>, <2.2506, 96.6849, -2.1402>, <2.1551, 98.07241, -2.4129> }
					triangle { <2.1551, 98.07241, -2.4129>, <0.6212, 96.8673, -2.8601>, <2.2506, 96.6849, -2.1402> }
					triangle { <2.1551, 98.07241, -2.4129>, <2.2506, 96.6849, -2.1402>, <0.6212, 96.8673, -2.8601> }
					triangle { <2.1551, 98.07241, -2.4129>, <0.07792, 99.08028, -1.3049>, <0.6212, 96.8673, -2.8601> }
					triangle { <2.1551, 98.07241, -2.4129>, <0.6212, 96.8673, -2.8601>, <0.07792, 99.08028, -1.3049> }
					triangle { <-0.2244, 91.01388, -4.6141>, <-0.7402, 90.0139, -7.3473>, <-0.777, 87.958, -5.415> }
					triangle { <-0.2244, 91.01388, -4.6141>, <-0.777, 87.958, -5.415>, <-0.7402, 90.0139, -7.3473> }
					triangle { <-0.2244, 91.01388, -4.6141>, <-1.7631, 92.2998, -7.9153>, <-0.7402, 90.0139, -7.3473> }
					triangle { <-0.2244, 91.01388, -4.6141>, <-0.7402, 90.0139, -7.3473>, <-1.7631, 92.2998, -7.9153> }
					triangle { <-1.2975, 95.239, -6.7455>, <-2.5963, 95.5513, -6.9201>, <-1.7631, 92.2998, -7.9153> }
					triangle { <-1.2975, 95.239, -6.7455>, <-1.7631, 92.2998, -7.9153>, <-2.5963, 95.5513, -6.9201> }
					triangle { <-1.7631, 92.2998, -7.9153>, <-0.4219, 94.4931, -5.168>, <-1.2975, 95.239, -6.7455> }
					triangle { <-1.7631, 92.2998, -7.9153>, <-1.2975, 95.239, -6.7455>, <-0.4219, 94.4931, -5.168> }
					triangle { <-0.2244, 91.01388, -4.6141>, <-0.4219, 94.4931, -5.168>, <-1.7631, 92.2998, -7.9153> }
					triangle { <-0.2244, 91.01388, -4.6141>, <-1.7631, 92.2998, -7.9153>, <-0.4219, 94.4931, -5.168> }
					triangle { <0.0001842, 93.898, -3.5513>, <-0.4219, 94.4931, -5.168>, <-0.2244, 91.01388, -4.6141> }
					triangle { <0.0001842, 93.898, -3.5513>, <-0.2244, 91.01388, -4.6141>, <-0.4219, 94.4931, -5.168> }
					triangle { <0.0001842, 93.898, -3.5513>, <0.6212, 96.8673, -2.8601>, <-0.4219, 94.4931, -5.168> }
					triangle { <0.0001842, 93.898, -3.5513>, <-0.4219, 94.4931, -5.168>, <0.6212, 96.8673, -2.8601> }
					triangle { <-0.4219, 94.4931, -5.168>, <-1.02618, 97.8294, -5.8629>, <-1.2975, 95.239, -6.7455> }
					triangle { <-0.4219, 94.4931, -5.168>, <-1.2975, 95.239, -6.7455>, <-1.02618, 97.8294, -5.8629> }
					triangle { <-0.09253, 97.6513, -4.2562>, <-1.02618, 97.8294, -5.8629>, <-0.4219, 94.4931, -5.168> }
					triangle { <-0.09253, 97.6513, -4.2562>, <-0.4219, 94.4931, -5.168>, <-1.02618, 97.8294, -5.8629> }
					triangle { <-0.4219, 94.4931, -5.168>, <0.6212, 96.8673, -2.8601>, <-0.09253, 97.6513, -4.2562> }
					triangle { <-0.4219, 94.4931, -5.168>, <-0.09253, 97.6513, -4.2562>, <0.6212, 96.8673, -2.8601> }
					triangle { <-1.2975, 95.239, -6.7455>, <-1.02618, 97.8294, -5.8629>, <-2.5963, 95.5513, -6.9201> }
					triangle { <-1.2975, 95.239, -6.7455>, <-2.5963, 95.5513, -6.9201>, <-1.02618, 97.8294, -5.8629> }
					triangle { <-0.09253, 97.6513, -4.2562>, <-0.1847, 98.3305, -4.8503>, <-1.02618, 97.8294, -5.8629> }
					triangle { <-0.09253, 97.6513, -4.2562>, <-1.02618, 97.8294, -5.8629>, <-0.1847, 98.3305, -4.8503> }
					triangle { <-0.09253, 97.6513, -4.2562>, <0.7968, 98.6624, -3.7271>, <-0.1847, 98.3305, -4.8503> }
					triangle { <-0.09253, 97.6513, -4.2562>, <-0.1847, 98.3305, -4.8503>, <0.7968, 98.6624, -3.7271> }
					triangle { <-0.09253, 97.6513, -4.2562>, <0.6212, 96.8673, -2.8601>, <0.7968, 98.6624, -3.7271> }
					triangle { <-0.09253, 97.6513, -4.2562>, <0.7968, 98.6624, -3.7271>, <0.6212, 96.8673, -2.8601> }
					triangle { <0.6212, 96.8673, -2.8601>, <0.07792, 99.08028, -1.3049>, <0.7968, 98.6624, -3.7271> }
					triangle { <0.6212, 96.8673, -2.8601>, <0.7968, 98.6624, -3.7271>, <0.07792, 99.08028, -1.3049> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		union { // Primary inflorescence internode
			cylinder { <4.9484, 70.5801, -11.1398>, <5.1064, 72.6458, -11.574>, 0.4123 }
			cylinder { <5.1064, 72.6458, -11.574>, <5.2644, 74.7115, -12.00833>, 0.4123 }
			cylinder { <5.2644, 74.7115, -12.00833>, <5.4224, 76.7772, -12.4425>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // Primary inflorescence internode
			cylinder { <5.4224, 76.7772, -12.4425>, <7.09631, 78.07253, -12.4115>, 0.4123 }
			cylinder { <7.09631, 78.07253, -12.4115>, <8.7702, 79.3678, -12.3805>, 0.4123 }
			cylinder { <8.7702, 79.3678, -12.3805>, <10.4441, 80.6631, -12.3495>, 0.4123 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // primary pedicel and flower/fruit
			union { // Primary flower stalk
				cylinder { <10.4441, 80.6631, -12.3495>, <13.5836, 83.8173, -13.2262>, 0.4123 }
				cylinder { <13.5836, 83.8173, -13.2262>, <16.08772, 87.161, -14.9937>, 0.4123 }
				cylinder { <16.08772, 87.161, -14.9937>, <17.8061, 90.4938, -17.5459>, 0.4123 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Primary flower petal, first row
				mesh { // Primary flower petal, first row 3D object
					triangle { <17.8061, 90.4938, -17.5459>, <17.9496, 93.07769, -16.4212>, <19.2096, 92.9287, -19.09073> }
					triangle { <17.8061, 90.4938, -17.5459>, <19.2096, 92.9287, -19.09073>, <17.9496, 93.07769, -16.4212> }
					triangle { <17.9496, 93.07769, -16.4212>, <17.2095, 95.4514, -17.1431>, <19.2096, 92.9287, -19.09073> }
					triangle { <17.9496, 93.07769, -16.4212>, <19.2096, 92.9287, -19.09073>, <17.2095, 95.4514, -17.1431> }
					triangle { <17.2095, 95.4514, -17.1431>, <17.5079, 98.2698, -19.1267>, <18.8348, 97.7803, -18.677> }
					triangle { <17.2095, 95.4514, -17.1431>, <18.8348, 97.7803, -18.677>, <17.5079, 98.2698, -19.1267> }
					triangle { <18.8348, 97.7803, -18.677>, <19.9948, 96.4799, -19.3986>, <17.2095, 95.4514, -17.1431> }
					triangle { <18.8348, 97.7803, -18.677>, <17.2095, 95.4514, -17.1431>, <19.9948, 96.4799, -19.3986> }
					triangle { <17.2095, 95.4514, -17.1431>, <19.9948, 96.4799, -19.3986>, <19.2096, 92.9287, -19.09073> }
					triangle { <17.2095, 95.4514, -17.1431>, <19.2096, 92.9287, -19.09073>, <19.9948, 96.4799, -19.3986> }
					triangle { <19.2096, 92.9287, -19.09073>, <19.9948, 96.4799, -19.3986>, <20.3114, 95.1615, -20.9071> }
					triangle { <19.2096, 92.9287, -19.09073>, <20.3114, 95.1615, -20.9071>, <19.9948, 96.4799, -19.3986> }
					triangle { <19.9948, 96.4799, -19.3986>, <21.7383, 97.5459, -22.3066>, <20.3114, 95.1615, -20.9071> }
					triangle { <19.9948, 96.4799, -19.3986>, <20.3114, 95.1615, -20.9071>, <21.7383, 97.5459, -22.3066> }
					triangle { <18.8348, 97.7803, -18.677>, <19.8116, 99.7705, -20.3078>, <19.9948, 96.4799, -19.3986> }
					triangle { <18.8348, 97.7803, -18.677>, <19.9948, 96.4799, -19.3986>, <19.8116, 99.7705, -20.3078> }
					triangle { <19.9948, 96.4799, -19.3986>, <19.8116, 99.7705, -20.3078>, <21.03667, 98.9121, -21.3859> }
					triangle { <19.9948, 96.4799, -19.3986>, <21.03667, 98.9121, -21.3859>, <19.8116, 99.7705, -20.3078> }
					triangle { <21.03667, 98.9121, -21.3859>, <21.7383, 97.5459, -22.3066>, <19.9948, 96.4799, -19.3986> }
					triangle { <21.03667, 98.9121, -21.3859>, <19.9948, 96.4799, -19.3986>, <21.7383, 97.5459, -22.3066> }
					triangle { <17.5079, 98.2698, -19.1267>, <19.8116, 99.7705, -20.3078>, <18.8348, 97.7803, -18.677> }
					triangle { <17.5079, 98.2698, -19.1267>, <18.8348, 97.7803, -18.677>, <19.8116, 99.7705, -20.3078> }
					triangle { <19.8116, 99.7705, -20.3078>, <20.9283, 99.7354, -21.1657>, <21.03667, 98.9121, -21.3859> }
					triangle { <19.8116, 99.7705, -20.3078>, <21.03667, 98.9121, -21.3859>, <20.9283, 99.7354, -21.1657> }
					triangle { <20.9283, 99.7354, -21.1657>, <22.1601, 99.4832, -22.03429>, <21.03667, 98.9121, -21.3859> }
					triangle { <20.9283, 99.7354, -21.1657>, <21.03667, 98.9121, -21.3859>, <22.1601, 99.4832, -22.03429> }
					triangle { <22.1601, 99.4832, -22.03429>, <21.7383, 97.5459, -22.3066>, <21.03667, 98.9121, -21.3859> }
					triangle { <22.1601, 99.4832, -22.03429>, <21.03667, 98.9121, -21.3859>, <21.7383, 97.5459, -22.3066> }
					triangle { <22.1601, 99.4832, -22.03429>, <22.04668, 99.1015, -24.564>, <21.7383, 97.5459, -22.3066> }
					triangle { <22.1601, 99.4832, -22.03429>, <21.7383, 97.5459, -22.3066>, <22.04668, 99.1015, -24.564> }
					triangle { <19.2096, 92.9287, -19.09073>, <20.6131, 90.7599, -17.6546>, <17.8061, 90.4938, -17.5459> }
					triangle { <19.2096, 92.9287, -19.09073>, <17.8061, 90.4938, -17.5459>, <20.6131, 90.7599, -17.6546> }
					triangle { <19.2096, 92.9287, -19.09073>, <22.5749, 91.0432, -19.2872>, <20.6131, 90.7599, -17.6546> }
					triangle { <19.2096, 92.9287, -19.09073>, <20.6131, 90.7599, -17.6546>, <22.5749, 91.0432, -19.2872> }
					triangle { <23.6267, 93.5234, -21.00957>, <23.9967, 92.7102, -22.01793>, <22.5749, 91.0432, -19.2872> }
					triangle { <23.6267, 93.5234, -21.00957>, <22.5749, 91.0432, -19.2872>, <23.9967, 92.7102, -22.01793> }
					triangle { <22.5749, 91.0432, -19.2872>, <21.9282, 94.4498, -20.7479>, <23.6267, 93.5234, -21.00957> }
					triangle { <22.5749, 91.0432, -19.2872>, <23.6267, 93.5234, -21.00957>, <21.9282, 94.4498, -20.7479> }
					triangle { <19.2096, 92.9287, -19.09073>, <21.9282, 94.4498, -20.7479>, <22.5749, 91.0432, -19.2872> }
					triangle { <19.2096, 92.9287, -19.09073>, <22.5749, 91.0432, -19.2872>, <21.9282, 94.4498, -20.7479> }
					triangle { <20.3114, 95.1615, -20.9071>, <21.9282, 94.4498, -20.7479>, <19.2096, 92.9287, -19.09073> }
					triangle { <20.3114, 95.1615, -20.9071>, <19.2096, 92.9287, -19.09073>, <21.9282, 94.4498, -20.7479> }
					triangle { <20.3114, 95.1615, -20.9071>, <21.7383, 97.5459, -22.3066>, <21.9282, 94.4498, -20.7479> }
					triangle { <20.3114, 95.1615, -20.9071>, <21.9282, 94.4498, -20.7479>, <21.7383, 97.5459, -22.3066> }
					triangle { <21.9282, 94.4498, -20.7479>, <24.6685, 95.544, -22.5569>, <23.6267, 93.5234, -21.00957> }
					triangle { <21.9282, 94.4498, -20.7479>, <23.6267, 93.5234, -21.00957>, <24.6685, 95.544, -22.5569> }
					triangle { <23.3218, 96.8367, -22.5576>, <24.6685, 95.544, -22.5569>, <21.9282, 94.4498, -20.7479> }
					triangle { <23.3218, 96.8367, -22.5576>, <21.9282, 94.4498, -20.7479>, <24.6685, 95.544, -22.5569> }
					triangle { <21.9282, 94.4498, -20.7479>, <21.7383, 97.5459, -22.3066>, <23.3218, 96.8367, -22.5576> }
					triangle { <21.9282, 94.4498, -20.7479>, <23.3218, 96.8367, -22.5576>, <21.7383, 97.5459, -22.3066> }
					triangle { <23.6267, 93.5234, -21.00957>, <24.6685, 95.544, -22.5569>, <23.9967, 92.7102, -22.01793> }
					triangle { <23.6267, 93.5234, -21.00957>, <23.9967, 92.7102, -22.01793>, <24.6685, 95.544, -22.5569> }
					triangle { <23.3218, 96.8367, -22.5576>, <24.2185, 96.8723, -22.6893>, <24.6685, 95.544, -22.5569> }
					triangle { <23.3218, 96.8367, -22.5576>, <24.6685, 95.544, -22.5569>, <24.2185, 96.8723, -22.6893> }
					triangle { <23.3218, 96.8367, -22.5576>, <23.5702, 98.2561, -22.6872>, <24.2185, 96.8723, -22.6893> }
					triangle { <23.3218, 96.8367, -22.5576>, <24.2185, 96.8723, -22.6893>, <23.5702, 98.2561, -22.6872> }
					triangle { <23.3218, 96.8367, -22.5576>, <21.7383, 97.5459, -22.3066>, <23.5702, 98.2561, -22.6872> }
					triangle { <23.3218, 96.8367, -22.5576>, <23.5702, 98.2561, -22.6872>, <21.7383, 97.5459, -22.3066> }
					triangle { <21.7383, 97.5459, -22.3066>, <22.04668, 99.1015, -24.564>, <23.5702, 98.2561, -22.6872> }
					triangle { <21.7383, 97.5459, -22.3066>, <23.5702, 98.2561, -22.6872>, <22.04668, 99.1015, -24.564> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <17.8061, 90.4938, -17.5459>, <20.4659, 90.2272, -18.4492>, <19.1229, 92.6149, -19.5588> }
					triangle { <17.8061, 90.4938, -17.5459>, <19.1229, 92.6149, -19.5588>, <20.4659, 90.2272, -18.4492> }
					triangle { <20.4659, 90.2272, -18.4492>, <22.5889, 91.7087, -18.4086>, <19.1229, 92.6149, -19.5588> }
					triangle { <20.4659, 90.2272, -18.4492>, <19.1229, 92.6149, -19.5588>, <22.5889, 91.7087, -18.4086> }
					triangle { <22.5889, 91.7087, -18.4086>, <24.4199, 94.4471, -19.4647>, <23.7515, 93.77, -20.6035> }
					triangle { <22.5889, 91.7087, -18.4086>, <23.7515, 93.77, -20.6035>, <24.4199, 94.4471, -19.4647> }
					triangle { <23.7515, 93.77, -20.6035>, <22.01958, 93.9602, -21.3257>, <22.5889, 91.7087, -18.4086> }
					triangle { <23.7515, 93.77, -20.6035>, <22.5889, 91.7087, -18.4086>, <22.01958, 93.9602, -21.3257> }
					triangle { <22.5889, 91.7087, -18.4086>, <22.01958, 93.9602, -21.3257>, <19.1229, 92.6149, -19.5588> }
					triangle { <22.5889, 91.7087, -18.4086>, <19.1229, 92.6149, -19.5588>, <22.01958, 93.9602, -21.3257> }
					triangle { <19.1229, 92.6149, -19.5588>, <22.01958, 93.9602, -21.3257>, <20.2536, 94.9523, -21.2192> }
					triangle { <19.1229, 92.6149, -19.5588>, <20.2536, 94.9523, -21.2192>, <22.01958, 93.9602, -21.3257> }
					triangle { <22.01958, 93.9602, -21.3257>, <21.5649, 96.9183, -23.2429>, <20.2536, 94.9523, -21.2192> }
					triangle { <22.01958, 93.9602, -21.3257>, <20.2536, 94.9523, -21.2192>, <21.5649, 96.9183, -23.2429> }
					triangle { <23.7515, 93.77, -20.6035>, <24.7572, 95.8649, -22.07826>, <22.01958, 93.9602, -21.3257> }
					triangle { <23.7515, 93.77, -20.6035>, <22.01958, 93.9602, -21.3257>, <24.7572, 95.8649, -22.07826> }
					triangle { <22.01958, 93.9602, -21.3257>, <24.7572, 95.8649, -22.07826>, <23.2926, 96.5262, -22.9826> }
					triangle { <22.01958, 93.9602, -21.3257>, <23.2926, 96.5262, -22.9826>, <24.7572, 95.8649, -22.07826> }
					triangle { <23.2926, 96.5262, -22.9826>, <21.5649, 96.9183, -23.2429>, <22.01958, 93.9602, -21.3257> }
					triangle { <23.2926, 96.5262, -22.9826>, <22.01958, 93.9602, -21.3257>, <21.5649, 96.9183, -23.2429> }
					triangle { <24.4199, 94.4471, -19.4647>, <24.7572, 95.8649, -22.07826>, <23.7515, 93.77, -20.6035> }
					triangle { <24.4199, 94.4471, -19.4647>, <23.7515, 93.77, -20.6035>, <24.7572, 95.8649, -22.07826> }
					triangle { <24.7572, 95.8649, -22.07826>, <24.1388, 96.5835, -23.1201>, <23.2926, 96.5262, -22.9826> }
					triangle { <24.7572, 95.8649, -22.07826>, <23.2926, 96.5262, -22.9826>, <24.1388, 96.5835, -23.1201> }
					triangle { <24.1388, 96.5835, -23.1201>, <23.2883, 97.2357, -24.2094>, <23.2926, 96.5262, -22.9826> }
					triangle { <24.1388, 96.5835, -23.1201>, <23.2926, 96.5262, -22.9826>, <23.2883, 97.2357, -24.2094> }
					triangle { <23.2883, 97.2357, -24.2094>, <21.5649, 96.9183, -23.2429>, <23.2926, 96.5262, -22.9826> }
					triangle { <23.2883, 97.2357, -24.2094>, <23.2926, 96.5262, -22.9826>, <21.5649, 96.9183, -23.2429> }
					triangle { <23.2883, 97.2357, -24.2094>, <22.1622, 99.5199, -23.9398>, <21.5649, 96.9183, -23.2429> }
					triangle { <23.2883, 97.2357, -24.2094>, <21.5649, 96.9183, -23.2429>, <22.1622, 99.5199, -23.9398> }
					triangle { <19.1229, 92.6149, -19.5588>, <17.2299, 90.4722, -20.308>, <17.8061, 90.4938, -17.5459> }
					triangle { <19.1229, 92.6149, -19.5588>, <17.8061, 90.4938, -17.5459>, <17.2299, 90.4722, -20.308> }
					triangle { <19.1229, 92.6149, -19.5588>, <16.4154, 91.9615, -22.235>, <17.2299, 90.4722, -20.308> }
					triangle { <19.1229, 92.6149, -19.5588>, <17.2299, 90.4722, -20.308>, <16.4154, 91.9615, -22.235> }
					triangle { <17.8143, 94.291, -23.9206>, <16.6514, 94.9638, -24.0206>, <16.4154, 91.9615, -22.235> }
					triangle { <17.8143, 94.291, -23.9206>, <16.4154, 91.9615, -22.235>, <16.6514, 94.9638, -24.0206> }
					triangle { <16.4154, 91.9615, -22.235>, <19.2101, 94.459, -22.5659>, <17.8143, 94.291, -23.9206> }
					triangle { <16.4154, 91.9615, -22.235>, <17.8143, 94.291, -23.9206>, <19.2101, 94.459, -22.5659> }
					triangle { <19.1229, 92.6149, -19.5588>, <19.2101, 94.459, -22.5659>, <16.4154, 91.9615, -22.235> }
					triangle { <19.1229, 92.6149, -19.5588>, <16.4154, 91.9615, -22.235>, <19.2101, 94.459, -22.5659> }
					triangle { <20.2536, 94.9523, -21.2192>, <19.2101, 94.459, -22.5659>, <19.1229, 92.6149, -19.5588> }
					triangle { <20.2536, 94.9523, -21.2192>, <19.1229, 92.6149, -19.5588>, <19.2101, 94.459, -22.5659> }
					triangle { <20.2536, 94.9523, -21.2192>, <21.5649, 96.9183, -23.2429>, <19.2101, 94.459, -22.5659> }
					triangle { <20.2536, 94.9523, -21.2192>, <19.2101, 94.459, -22.5659>, <21.5649, 96.9183, -23.2429> }
					triangle { <19.2101, 94.459, -22.5659>, <18.8561, 96.3116, -25.4679>, <17.8143, 94.291, -23.9206> }
					triangle { <19.2101, 94.459, -22.5659>, <17.8143, 94.291, -23.9206>, <18.8561, 96.3116, -25.4679> }
					triangle { <20.4012, 96.8167, -24.5501>, <18.8561, 96.3116, -25.4679>, <19.2101, 94.459, -22.5659> }
					triangle { <20.4012, 96.8167, -24.5501>, <19.2101, 94.459, -22.5659>, <18.8561, 96.3116, -25.4679> }
					triangle { <19.2101, 94.459, -22.5659>, <21.5649, 96.9183, -23.2429>, <20.4012, 96.8167, -24.5501> }
					triangle { <19.2101, 94.459, -22.5659>, <20.4012, 96.8167, -24.5501>, <21.5649, 96.9183, -23.2429> }
					triangle { <17.8143, 94.291, -23.9206>, <18.8561, 96.3116, -25.4679>, <16.6514, 94.9638, -24.0206> }
					triangle { <17.8143, 94.291, -23.9206>, <16.6514, 94.9638, -24.0206>, <18.8561, 96.3116, -25.4679> }
					triangle { <20.4012, 96.8167, -24.5501>, <20.1413, 96.8862, -25.4164>, <18.8561, 96.3116, -25.4679> }
					triangle { <20.4012, 96.8167, -24.5501>, <18.8561, 96.3116, -25.4679>, <20.1413, 96.8862, -25.4164> }
					triangle { <20.4012, 96.8167, -24.5501>, <21.5751, 97.3655, -25.1935>, <20.1413, 96.8862, -25.4164> }
					triangle { <20.4012, 96.8167, -24.5501>, <20.1413, 96.8862, -25.4164>, <21.5751, 97.3655, -25.1935> }
					triangle { <20.4012, 96.8167, -24.5501>, <21.5649, 96.9183, -23.2429>, <21.5751, 97.3655, -25.1935> }
					triangle { <20.4012, 96.8167, -24.5501>, <21.5751, 97.3655, -25.1935>, <21.5649, 96.9183, -23.2429> }
					triangle { <21.5649, 96.9183, -23.2429>, <22.1622, 99.5199, -23.9398>, <21.5751, 97.3655, -25.1935> }
					triangle { <21.5649, 96.9183, -23.2429>, <21.5751, 97.3655, -25.1935>, <22.1622, 99.5199, -23.9398> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				mesh { // Primary flower petal, first row 3D object
					triangle { <17.8061, 90.4938, -17.5459>, <16.4979, 91.1092, -19.9691>, <18.7139, 92.9708, -19.3695> }
					triangle { <17.8061, 90.4938, -17.5459>, <18.7139, 92.9708, -19.3695>, <16.4979, 91.1092, -19.9691> }
					triangle { <16.4979, 91.1092, -19.9691>, <17.2197, 91.3902, -22.4396>, <18.7139, 92.9708, -19.3695> }
					triangle { <16.4979, 91.1092, -19.9691>, <18.7139, 92.9708, -19.3695>, <17.2197, 91.3902, -22.4396> }
					triangle { <17.2197, 91.3902, -22.4396>, <18.8272, 93.1132, -24.9722>, <18.06328, 94.03159, -24.09185> }
					triangle { <17.2197, 91.3902, -22.4396>, <18.06328, 94.03159, -24.09185>, <18.8272, 93.1132, -24.9722> }
					triangle { <18.06328, 94.03159, -24.09185>, <18.5272, 94.8819, -22.4735>, <17.2197, 91.3902, -22.4396> }
					triangle { <18.06328, 94.03159, -24.09185>, <17.2197, 91.3902, -22.4396>, <18.5272, 94.8819, -22.4735> }
					triangle { <17.2197, 91.3902, -22.4396>, <18.5272, 94.8819, -22.4735>, <18.7139, 92.9708, -19.3695> }
					triangle { <17.2197, 91.3902, -22.4396>, <18.7139, 92.9708, -19.3695>, <18.5272, 94.8819, -22.4735> }
					triangle { <18.7139, 92.9708, -19.3695>, <18.5272, 94.8819, -22.4735>, <19.981, 95.1895, -21.09299> }
					triangle { <18.7139, 92.9708, -19.3695>, <19.981, 95.1895, -21.09299>, <18.5272, 94.8819, -22.4735> }
					triangle { <18.5272, 94.8819, -22.4735>, <20.747, 97.6301, -22.8641>, <19.981, 95.1895, -21.09299> }
					triangle { <18.5272, 94.8819, -22.4735>, <19.981, 95.1895, -21.09299>, <20.747, 97.6301, -22.8641> }
					triangle { <18.06328, 94.03159, -24.09185>, <19.2053, 96.00783, -25.6296>, <18.5272, 94.8819, -22.4735> }
					triangle { <18.06328, 94.03159, -24.09185>, <18.5272, 94.8819, -22.4735>, <19.2053, 96.00783, -25.6296> }
					triangle { <18.5272, 94.8819, -22.4735>, <19.2053, 96.00783, -25.6296>, <19.9598, 97.1579, -24.4016> }
					triangle { <18.5272, 94.8819, -22.4735>, <19.9598, 97.1579, -24.4016>, <19.2053, 96.00783, -25.6296> }
					triangle { <19.9598, 97.1579, -24.4016>, <20.747, 97.6301, -22.8641>, <18.5272, 94.8819, -22.4735> }
					triangle { <19.9598, 97.1579, -24.4016>, <18.5272, 94.8819, -22.4735>, <20.747, 97.6301, -22.8641> }
					triangle { <18.8272, 93.1132, -24.9722>, <19.2053, 96.00783, -25.6296>, <18.06328, 94.03159, -24.09185> }
					triangle { <18.8272, 93.1132, -24.9722>, <18.06328, 94.03159, -24.09185>, <19.2053, 96.00783, -25.6296> }
					triangle { <19.2053, 96.00783, -25.6296>, <19.7182, 97.2543, -25.2204>, <19.9598, 97.1579, -24.4016> }
					triangle { <19.2053, 96.00783, -25.6296>, <19.9598, 97.1579, -24.4016>, <19.7182, 97.2543, -25.2204> }
					triangle { <19.7182, 97.2543, -25.2204>, <20.2253, 98.5401, -24.5685>, <19.9598, 97.1579, -24.4016> }
					triangle { <19.7182, 97.2543, -25.2204>, <19.9598, 97.1579, -24.4016>, <20.2253, 98.5401, -24.5685> }
					triangle { <20.2253, 98.5401, -24.5685>, <20.747, 97.6301, -22.8641>, <19.9598, 97.1579, -24.4016> }
					triangle { <20.2253, 98.5401, -24.5685>, <19.9598, 97.1579, -24.4016>, <20.747, 97.6301, -22.8641> }
					triangle { <20.2253, 98.5401, -24.5685>, <22.7075, 99.04544, -24.1923>, <20.747, 97.6301, -22.8641> }
					triangle { <20.2253, 98.5401, -24.5685>, <20.747, 97.6301, -22.8641>, <22.7075, 99.04544, -24.1923> }
					triangle { <18.7139, 92.9708, -19.3695>, <17.1083, 93.1491, -16.8944>, <17.8061, 90.4938, -17.5459> }
					triangle { <18.7139, 92.9708, -19.3695>, <17.8061, 90.4938, -17.5459>, <17.1083, 93.1491, -16.8944> }
					triangle { <18.7139, 92.9708, -19.3695>, <18.1039, 95.483, -16.4996>, <17.1083, 93.1491, -16.8944> }
					triangle { <18.7139, 92.9708, -19.3695>, <17.1083, 93.1491, -16.8944>, <18.1039, 95.483, -16.4996> }
					triangle { <19.2765, 97.7069, -18.4754>, <20.1992, 98.07722, -17.5662>, <18.1039, 95.483, -16.4996> }
					triangle { <19.2765, 97.7069, -18.4754>, <18.1039, 95.483, -16.4996>, <20.1992, 98.07722, -17.5662> }
					triangle { <18.1039, 95.483, -16.4996>, <19.4307, 96.3844, -19.9032>, <19.2765, 97.7069, -18.4754> }
					triangle { <18.1039, 95.483, -16.4996>, <19.2765, 97.7069, -18.4754>, <19.4307, 96.3844, -19.9032> }
					triangle { <18.7139, 92.9708, -19.3695>, <19.4307, 96.3844, -19.9032>, <18.1039, 95.483, -16.4996> }
					triangle { <18.7139, 92.9708, -19.3695>, <18.1039, 95.483, -16.4996>, <19.4307, 96.3844, -19.9032> }
					triangle { <19.981, 95.1895, -21.09299>, <19.4307, 96.3844, -19.9032>, <18.7139, 92.9708, -19.3695> }
					triangle { <19.981, 95.1895, -21.09299>, <18.7139, 92.9708, -19.3695>, <19.4307, 96.3844, -19.9032> }
					triangle { <19.981, 95.1895, -21.09299>, <20.747, 97.6301, -22.8641>, <19.4307, 96.3844, -19.9032> }
					triangle { <19.981, 95.1895, -21.09299>, <19.4307, 96.3844, -19.9032>, <20.747, 97.6301, -22.8641> }
					triangle { <19.4307, 96.3844, -19.9032>, <20.3183, 99.7275, -20.02279>, <19.2765, 97.7069, -18.4754> }
					triangle { <19.4307, 96.3844, -19.9032>, <19.2765, 97.7069, -18.4754>, <20.3183, 99.7275, -20.02279> }
					triangle { <20.5986, 98.9134, -21.6791>, <20.3183, 99.7275, -20.02279>, <19.4307, 96.3844, -19.9032> }
					triangle { <20.5986, 98.9134, -21.6791>, <19.4307, 96.3844, -19.9032>, <20.3183, 99.7275, -20.02279> }
					triangle { <19.4307, 96.3844, -19.9032>, <20.747, 97.6301, -22.8641>, <20.5986, 98.9134, -21.6791> }
					triangle { <19.4307, 96.3844, -19.9032>, <20.5986, 98.9134, -21.6791>, <20.747, 97.6301, -22.8641> }
					triangle { <19.2765, 97.7069, -18.4754>, <20.3183, 99.7275, -20.02279>, <20.1992, 98.07722, -17.5662> }
					triangle { <19.2765, 97.7069, -18.4754>, <20.1992, 98.07722, -17.5662>, <20.3183, 99.7275, -20.02279> }
					triangle { <20.5986, 98.9134, -21.6791>, <20.4722, 99.7742, -21.4222>, <20.3183, 99.7275, -20.02279> }
					triangle { <20.5986, 98.9134, -21.6791>, <20.3183, 99.7275, -20.02279>, <20.4722, 99.7742, -21.4222> }
					triangle { <20.5986, 98.9134, -21.6791>, <20.5485, 99.62, -22.9407>, <20.4722, 99.7742, -21.4222> }
					triangle { <20.5986, 98.9134, -21.6791>, <20.4722, 99.7742, -21.4222>, <20.5485, 99.62, -22.9407> }
					triangle { <20.5986, 98.9134, -21.6791>, <20.747, 97.6301, -22.8641>, <20.5485, 99.62, -22.9407> }
					triangle { <20.5986, 98.9134, -21.6791>, <20.5485, 99.62, -22.9407>, <20.747, 97.6301, -22.8641> }
					triangle { <20.747, 97.6301, -22.8641>, <22.7075, 99.04544, -24.1923>, <20.5485, 99.62, -22.9407> }
					triangle { <20.747, 97.6301, -22.8641>, <20.5485, 99.62, -22.9407>, <22.7075, 99.04544, -24.1923> }
					pigment { color rgb <0.996, 0.996, 0.0> }}
				}
			}
		}
	union { // Internode
		cylinder { <-0.756, 14.5047, -0.403>, <-1.4243, 18.9018, -0.333>, 0.8087 }
		cylinder { <-1.4243, 18.9018, -0.333>, <-1.9934, 23.3119, -0.2194>, 0.8087 }
		cylinder { <-1.9934, 23.3119, -0.2194>, <-2.4629, 27.7324, -0.06216>, 0.8087 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-2.4629, 27.7324, -0.06216>, <-1.7315, 31.5413, 0.5615>, 0.2678 }
			cylinder { <-1.7315, 31.5413, 0.5615>, <0.0722, 34.8707, 1.6072>, 0.2678 }
			cylinder { <0.0722, 34.8707, 1.6072>, <2.7661, 37.3845, 2.9692>, 0.2678 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <2.7661, 37.3845, 2.9692>, <3.5917, 38.1163, 3.3835>, 0.2678 }
				cylinder { <3.5917, 38.1163, 3.3835>, <4.4344, 38.8253, 3.8033>, 0.2678 }
				cylinder { <4.4344, 38.8253, 3.8033>, <5.2934, 39.511, 4.2282>, 0.2678 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <5.2934, 39.511, 4.2282>, <5.7964, 39.9664, 4.7264>, 0.05739 }
				cylinder { <5.7964, 39.9664, 4.7264>, <6.1522, 40.3543, 5.3832>, 0.05739 }
				cylinder { <6.1522, 40.3543, 5.3832>, <6.3353, 40.6467, 6.151>, 0.05739 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <6.3353, 40.6467, 6.151>, <9.5705, 47.2943, 12.9256>, <9.6037, 46.6511, 16.2634> }
				triangle { <6.3353, 40.6467, 6.151>, <9.6037, 46.6511, 16.2634>, <9.5705, 47.2943, 12.9256> }
				triangle { <9.5705, 47.2943, 12.9256>, <11.8436, 51.6217, 19.2628>, <9.6037, 46.6511, 16.2634> }
				triangle { <9.5705, 47.2943, 12.9256>, <9.6037, 46.6511, 16.2634>, <11.8436, 51.6217, 19.2628> }
				triangle { <11.8436, 51.6217, 19.2628>, <10.02557, 46.5415, 21.6308>, <9.6037, 46.6511, 16.2634> }
				triangle { <11.8436, 51.6217, 19.2628>, <9.6037, 46.6511, 16.2634>, <10.02557, 46.5415, 21.6308> }
				triangle { <9.6037, 46.6511, 16.2634>, <10.02557, 46.5415, 21.6308>, <6.3353, 40.6467, 6.151> }
				triangle { <9.6037, 46.6511, 16.2634>, <6.3353, 40.6467, 6.151>, <10.02557, 46.5415, 21.6308> }
				triangle { <11.8436, 51.6217, 19.2628>, <32.995, 46.2932, 23.4847>, <41.142, 42.2332, 27.4813> }
				triangle { <11.8436, 51.6217, 19.2628>, <41.142, 42.2332, 27.4813>, <32.995, 46.2932, 23.4847> }
				triangle { <41.142, 42.2332, 27.4813>, <44.5702, 37.692, 29.1685>, <39.7321, 37.3687, 24.7603> }
				triangle { <41.142, 42.2332, 27.4813>, <39.7321, 37.3687, 24.7603>, <44.5702, 37.692, 29.1685> }
				triangle { <39.7321, 37.3687, 24.7603>, <11.8436, 51.6217, 19.2628>, <41.142, 42.2332, 27.4813> }
				triangle { <39.7321, 37.3687, 24.7603>, <41.142, 42.2332, 27.4813>, <11.8436, 51.6217, 19.2628> }
				triangle { <11.8436, 51.6217, 19.2628>, <39.7321, 37.3687, 24.7603>, <10.02557, 46.5415, 21.6308> }
				triangle { <11.8436, 51.6217, 19.2628>, <10.02557, 46.5415, 21.6308>, <39.7321, 37.3687, 24.7603> }
				triangle { <8.2947, 42.9933, 17.9683>, <7.09788, 40.3852, 16.1461>, <6.3353, 40.6467, 6.151> }
				triangle { <8.2947, 42.9933, 17.9683>, <6.3353, 40.6467, 6.151>, <7.09788, 40.3852, 16.1461> }
				triangle { <8.2947, 42.9933, 17.9683>, <8.2074, 41.4613, 23.9988>, <7.09788, 40.3852, 16.1461> }
				triangle { <8.2947, 42.9933, 17.9683>, <7.09788, 40.3852, 16.1461>, <8.2074, 41.4613, 23.9988> }
				triangle { <8.2947, 42.9933, 17.9683>, <10.02557, 46.5415, 21.6308>, <8.2074, 41.4613, 23.9988> }
				triangle { <8.2947, 42.9933, 17.9683>, <8.2074, 41.4613, 23.9988>, <10.02557, 46.5415, 21.6308> }
				triangle { <6.3353, 40.6467, 6.151>, <10.02557, 46.5415, 21.6308>, <8.2947, 42.9933, 17.9683> }
				triangle { <6.3353, 40.6467, 6.151>, <8.2947, 42.9933, 17.9683>, <10.02557, 46.5415, 21.6308> }
				triangle { <38.9603, 36.137, 30.3228>, <29.2133, 35.7264, 28.4101>, <8.2074, 41.4613, 23.9988> }
				triangle { <38.9603, 36.137, 30.3228>, <8.2074, 41.4613, 23.9988>, <29.2133, 35.7264, 28.4101> }
				triangle { <39.7321, 37.3687, 24.7603>, <44.5702, 37.692, 29.1685>, <38.9603, 36.137, 30.3228> }
				triangle { <39.7321, 37.3687, 24.7603>, <38.9603, 36.137, 30.3228>, <44.5702, 37.692, 29.1685> }
				triangle { <38.9603, 36.137, 30.3228>, <8.2074, 41.4613, 23.9988>, <39.7321, 37.3687, 24.7603> }
				triangle { <38.9603, 36.137, 30.3228>, <39.7321, 37.3687, 24.7603>, <8.2074, 41.4613, 23.9988> }
				triangle { <10.02557, 46.5415, 21.6308>, <39.7321, 37.3687, 24.7603>, <8.2074, 41.4613, 23.9988> }
				triangle { <10.02557, 46.5415, 21.6308>, <8.2074, 41.4613, 23.9988>, <39.7321, 37.3687, 24.7603> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <5.2934, 39.511, 4.2282>, <6.1684, 40.1732, 4.658>, 0.2678 }
				cylinder { <6.1684, 40.1732, 4.658>, <7.05887, 40.8113, 5.0926>, 0.2678 }
				cylinder { <7.05887, 40.8113, 5.0926>, <7.9641, 41.4251, 5.5315>, 0.2678 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <7.9641, 41.4251, 5.5315>, <8.6757, 41.8642, 5.6279>, 0.05739 }
				cylinder { <8.6757, 41.8642, 5.6279>, <9.4007, 42.2724, 5.5004>, 0.05739 }
				cylinder { <9.4007, 42.2724, 5.5004>, <10.08661, 42.62, 5.158>, 0.05739 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <10.08661, 42.62, 5.158>, <15.4554, 47.3976, -1.835>, <18.7586, 48.1039, -1.4539> }
				triangle { <10.08661, 42.62, 5.158>, <18.7586, 48.1039, -1.4539>, <15.4554, 47.3976, -1.835> }
				triangle { <15.4554, 47.3976, -1.835>, <20.7951, 51.07164, -6.53>, <18.7586, 48.1039, -1.4539> }
				triangle { <15.4554, 47.3976, -1.835>, <18.7586, 48.1039, -1.4539>, <20.7951, 51.07164, -6.53> }
				triangle { <20.7951, 51.07164, -6.53>, <23.9152, 49.6286, -1.7442>, <18.7586, 48.1039, -1.4539> }
				triangle { <20.7951, 51.07164, -6.53>, <18.7586, 48.1039, -1.4539>, <23.9152, 49.6286, -1.7442> }
				triangle { <18.7586, 48.1039, -1.4539>, <23.9152, 49.6286, -1.7442>, <10.08661, 42.62, 5.158> }
				triangle { <18.7586, 48.1039, -1.4539>, <10.08661, 42.62, 5.158>, <23.9152, 49.6286, -1.7442> }
				triangle { <20.7951, 51.07164, -6.53>, <31.05058, 35.247, -18.2776>, <37.745, 28.617, -21.4489> }
				triangle { <20.7951, 51.07164, -6.53>, <37.745, 28.617, -21.4489>, <31.05058, 35.247, -18.2776> }
				triangle { <37.745, 28.617, -21.4489>, <41.305, 23.9082, -20.8365>, <36.1346, 25.2815, -17.0517> }
				triangle { <37.745, 28.617, -21.4489>, <36.1346, 25.2815, -17.0517>, <41.305, 23.9082, -20.8365> }
				triangle { <36.1346, 25.2815, -17.0517>, <20.7951, 51.07164, -6.53>, <37.745, 28.617, -21.4489> }
				triangle { <36.1346, 25.2815, -17.0517>, <37.745, 28.617, -21.4489>, <20.7951, 51.07164, -6.53> }
				triangle { <20.7951, 51.07164, -6.53>, <36.1346, 25.2815, -17.0517>, <23.9152, 49.6286, -1.7442> }
				triangle { <20.7951, 51.07164, -6.53>, <23.9152, 49.6286, -1.7442>, <36.1346, 25.2815, -17.0517> }
				triangle { <21.0051, 47.06501, 1.9918>, <19.6987, 45.4351, 4.6736>, <10.08661, 42.62, 5.158> }
				triangle { <21.0051, 47.06501, 1.9918>, <10.08661, 42.62, 5.158>, <19.6987, 45.4351, 4.6736> }
				triangle { <21.0051, 47.06501, 1.9918>, <27.0353, 48.1856, 3.04156>, <19.6987, 45.4351, 4.6736> }
				triangle { <21.0051, 47.06501, 1.9918>, <19.6987, 45.4351, 4.6736>, <27.0353, 48.1856, 3.04156> }
				triangle { <21.0051, 47.06501, 1.9918>, <23.9152, 49.6286, -1.7442>, <27.0353, 48.1856, 3.04156> }
				triangle { <21.0051, 47.06501, 1.9918>, <27.0353, 48.1856, 3.04156>, <23.9152, 49.6286, -1.7442> }
				triangle { <10.08661, 42.62, 5.158>, <23.9152, 49.6286, -1.7442>, <21.0051, 47.06501, 1.9918> }
				triangle { <10.08661, 42.62, 5.158>, <21.0051, 47.06501, 1.9918>, <23.9152, 49.6286, -1.7442> }
				triangle { <41.4892, 26.8854, -15.7059>, <37.5403, 32.2456, -8.3231>, <27.0353, 48.1856, 3.04156> }
				triangle { <41.4892, 26.8854, -15.7059>, <27.0353, 48.1856, 3.04156>, <37.5403, 32.2456, -8.3231> }
				triangle { <36.1346, 25.2815, -17.0517>, <41.305, 23.9082, -20.8365>, <41.4892, 26.8854, -15.7059> }
				triangle { <36.1346, 25.2815, -17.0517>, <41.4892, 26.8854, -15.7059>, <41.305, 23.9082, -20.8365> }
				triangle { <41.4892, 26.8854, -15.7059>, <27.0353, 48.1856, 3.04156>, <36.1346, 25.2815, -17.0517> }
				triangle { <41.4892, 26.8854, -15.7059>, <36.1346, 25.2815, -17.0517>, <27.0353, 48.1856, 3.04156> }
				triangle { <23.9152, 49.6286, -1.7442>, <36.1346, 25.2815, -17.0517>, <27.0353, 48.1856, 3.04156> }
				triangle { <23.9152, 49.6286, -1.7442>, <27.0353, 48.1856, 3.04156>, <36.1346, 25.2815, -17.0517> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <7.9641, 41.4251, 5.5315>, <8.8837, 42.01405, 5.9746>, 0.2678 }
				cylinder { <8.8837, 42.01405, 5.9746>, <9.8171, 42.5778, 6.4215>, 0.2678 }
				cylinder { <9.8171, 42.5778, 6.4215>, <10.7637, 43.1161, 6.8721>, 0.2678 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <10.7637, 43.1161, 6.8721>, <11.3269, 43.47, 7.3879>, 0.05739 }
				cylinder { <11.3269, 43.47, 7.3879>, <11.7364, 43.7676, 8.06046>, 0.05739 }
				cylinder { <11.7364, 43.7676, 8.06046>, <11.9626, 43.9873, 8.8408>, 0.05739 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <11.9626, 43.9873, 8.8408>, <16.1114, 49.733, 15.935>, <16.08117, 48.897, 19.2297> }
				triangle { <11.9626, 43.9873, 8.8408>, <16.08117, 48.897, 19.2297>, <16.1114, 49.733, 15.935> }
				triangle { <16.1114, 49.733, 15.935>, <18.9914, 53.3382, 22.4743>, <16.08117, 48.897, 19.2297> }
				triangle { <16.1114, 49.733, 15.935>, <16.08117, 48.897, 19.2297>, <18.9914, 53.3382, 22.4743> }
				triangle { <18.9914, 53.3382, 22.4743>, <16.522, 48.4179, 24.5753>, <16.08117, 48.897, 19.2297> }
				triangle { <18.9914, 53.3382, 22.4743>, <16.08117, 48.897, 19.2297>, <16.522, 48.4179, 24.5753> }
				triangle { <16.08117, 48.897, 19.2297>, <16.522, 48.4179, 24.5753>, <11.9626, 43.9873, 8.8408> }
				triangle { <16.08117, 48.897, 19.2297>, <11.9626, 43.9873, 8.8408>, <16.522, 48.4179, 24.5753> }
				triangle { <18.9914, 53.3382, 22.4743>, <39.2609, 44.9833, 26.07133>, <46.8144, 39.6404, 29.7086> }
				triangle { <18.9914, 53.3382, 22.4743>, <46.8144, 39.6404, 29.7086>, <39.2609, 44.9833, 26.07133> }
				triangle { <46.8144, 39.6404, 29.7086>, <49.6111, 34.5896, 31.0831>, <44.7428, 35.1766, 26.7358> }
				triangle { <46.8144, 39.6404, 29.7086>, <44.7428, 35.1766, 26.7358>, <49.6111, 34.5896, 31.0831> }
				triangle { <44.7428, 35.1766, 26.7358>, <18.9914, 53.3382, 22.4743>, <46.8144, 39.6404, 29.7086> }
				triangle { <44.7428, 35.1766, 26.7358>, <46.8144, 39.6404, 29.7086>, <18.9914, 53.3382, 22.4743> }
				triangle { <18.9914, 53.3382, 22.4743>, <44.7428, 35.1766, 26.7358>, <16.522, 48.4179, 24.5753> }
				triangle { <18.9914, 53.3382, 22.4743>, <16.522, 48.4179, 24.5753>, <44.7428, 35.1766, 26.7358> }
				triangle { <14.3031, 45.3544, 20.7425>, <12.753, 43.04154, 18.7924>, <11.9626, 43.9873, 8.8408> }
				triangle { <14.3031, 45.3544, 20.7425>, <11.9626, 43.9873, 8.8408>, <12.753, 43.04154, 18.7924> }
				triangle { <14.3031, 45.3544, 20.7425>, <14.05256, 43.4977, 26.6764>, <12.753, 43.04154, 18.7924> }
				triangle { <14.3031, 45.3544, 20.7425>, <12.753, 43.04154, 18.7924>, <14.05256, 43.4977, 26.6764> }
				triangle { <14.3031, 45.3544, 20.7425>, <16.522, 48.4179, 24.5753>, <14.05256, 43.4977, 26.6764> }
				triangle { <14.3031, 45.3544, 20.7425>, <14.05256, 43.4977, 26.6764>, <16.522, 48.4179, 24.5753> }
				triangle { <11.9626, 43.9873, 8.8408>, <16.522, 48.4179, 24.5753>, <14.3031, 45.3544, 20.7425> }
				triangle { <11.9626, 43.9873, 8.8408>, <14.3031, 45.3544, 20.7425>, <16.522, 48.4179, 24.5753> }
				triangle { <43.8511, 33.7362, 32.2298>, <34.1245, 34.7492, 30.4415>, <14.05256, 43.4977, 26.6764> }
				triangle { <43.8511, 33.7362, 32.2298>, <14.05256, 43.4977, 26.6764>, <34.1245, 34.7492, 30.4415> }
				triangle { <44.7428, 35.1766, 26.7358>, <49.6111, 34.5896, 31.0831>, <43.8511, 33.7362, 32.2298> }
				triangle { <44.7428, 35.1766, 26.7358>, <43.8511, 33.7362, 32.2298>, <49.6111, 34.5896, 31.0831> }
				triangle { <43.8511, 33.7362, 32.2298>, <14.05256, 43.4977, 26.6764>, <44.7428, 35.1766, 26.7358> }
				triangle { <43.8511, 33.7362, 32.2298>, <44.7428, 35.1766, 26.7358>, <14.05256, 43.4977, 26.6764> }
				triangle { <16.522, 48.4179, 24.5753>, <44.7428, 35.1766, 26.7358>, <14.05256, 43.4977, 26.6764> }
				triangle { <16.522, 48.4179, 24.5753>, <14.05256, 43.4977, 26.6764>, <44.7428, 35.1766, 26.7358> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <10.7637, 43.1161, 6.8721>, <11.4398, 43.5006, 7.1939>, 0.05739 }
				cylinder { <11.4398, 43.5006, 7.1939>, <12.1159, 43.8851, 7.5157>, 0.05739 }
				cylinder { <12.1159, 43.8851, 7.5157>, <12.792, 44.2696, 7.8375>, 0.05739 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <12.792, 44.2696, 7.8375>, <20.3759, 50.824, 8.1166>, <22.5534, 51.0076, 10.7205> }
				triangle { <12.792, 44.2696, 7.8375>, <22.5534, 51.0076, 10.7205>, <20.3759, 50.824, 8.1166> }
				triangle { <20.3759, 50.824, 8.1166>, <26.7177, 55.4854, 9.5679>, <22.5534, 51.0076, 10.7205> }
				triangle { <20.3759, 50.824, 8.1166>, <22.5534, 51.0076, 10.7205>, <26.7177, 55.4854, 9.5679> }
				triangle { <26.7177, 55.4854, 9.5679>, <26.423, 52.02161, 14.3256>, <22.5534, 51.0076, 10.7205> }
				triangle { <26.7177, 55.4854, 9.5679>, <22.5534, 51.0076, 10.7205>, <26.423, 52.02161, 14.3256> }
				triangle { <22.5534, 51.0076, 10.7205>, <26.423, 52.02161, 14.3256>, <12.792, 44.2696, 7.8375> }
				triangle { <22.5534, 51.0076, 10.7205>, <12.792, 44.2696, 7.8375>, <26.423, 52.02161, 14.3256> }
				triangle { <26.7177, 55.4854, 9.5679>, <44.6218, 44.4752, 2.3695>, <52.887, 38.9588, 2.07647> }
				triangle { <26.7177, 55.4854, 9.5679>, <52.887, 38.9588, 2.07647>, <44.6218, 44.4752, 2.3695> }
				triangle { <52.887, 38.9588, 2.07647>, <56.07627, 34.05614, 3.08342>, <49.5328, 34.3627, 2.9012> }
				triangle { <52.887, 38.9588, 2.07647>, <49.5328, 34.3627, 2.9012>, <56.07627, 34.05614, 3.08342> }
				triangle { <49.5328, 34.3627, 2.9012>, <26.7177, 55.4854, 9.5679>, <52.887, 38.9588, 2.07647> }
				triangle { <49.5328, 34.3627, 2.9012>, <52.887, 38.9588, 2.07647>, <26.7177, 55.4854, 9.5679> }
				triangle { <26.7177, 55.4854, 9.5679>, <49.5328, 34.3627, 2.9012>, <26.423, 52.02161, 14.3256> }
				triangle { <26.7177, 55.4854, 9.5679>, <26.423, 52.02161, 14.3256>, <49.5328, 34.3627, 2.9012> }
				triangle { <22.3411, 48.5136, 14.1461>, <19.975, 46.1132, 14.5872>, <12.792, 44.2696, 7.8375> }
				triangle { <22.3411, 48.5136, 14.1461>, <12.792, 44.2696, 7.8375>, <19.975, 46.1132, 14.5872> }
				triangle { <22.3411, 48.5136, 14.1461>, <26.1282, 48.5578, 19.08347>, <19.975, 46.1132, 14.5872> }
				triangle { <22.3411, 48.5136, 14.1461>, <19.975, 46.1132, 14.5872>, <26.1282, 48.5578, 19.08347> }
				triangle { <22.3411, 48.5136, 14.1461>, <26.423, 52.02161, 14.3256>, <26.1282, 48.5578, 19.08347> }
				triangle { <22.3411, 48.5136, 14.1461>, <26.1282, 48.5578, 19.08347>, <26.423, 52.02161, 14.3256> }
				triangle { <12.792, 44.2696, 7.8375>, <26.423, 52.02161, 14.3256>, <22.3411, 48.5136, 14.1461> }
				triangle { <12.792, 44.2696, 7.8375>, <22.3411, 48.5136, 14.1461>, <26.423, 52.02161, 14.3256> }
				triangle { <52.5333, 34.8022, 7.7858>, <44.00879, 37.2705, 12.2657>, <26.1282, 48.5578, 19.08347> }
				triangle { <52.5333, 34.8022, 7.7858>, <26.1282, 48.5578, 19.08347>, <44.00879, 37.2705, 12.2657> }
				triangle { <49.5328, 34.3627, 2.9012>, <56.07627, 34.05614, 3.08342>, <52.5333, 34.8022, 7.7858> }
				triangle { <49.5328, 34.3627, 2.9012>, <52.5333, 34.8022, 7.7858>, <56.07627, 34.05614, 3.08342> }
				triangle { <52.5333, 34.8022, 7.7858>, <26.1282, 48.5578, 19.08347>, <49.5328, 34.3627, 2.9012> }
				triangle { <52.5333, 34.8022, 7.7858>, <49.5328, 34.3627, 2.9012>, <26.1282, 48.5578, 19.08347> }
				triangle { <26.423, 52.02161, 14.3256>, <49.5328, 34.3627, 2.9012>, <26.1282, 48.5578, 19.08347> }
				triangle { <26.423, 52.02161, 14.3256>, <26.1282, 48.5578, 19.08347>, <49.5328, 34.3627, 2.9012> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-2.4629, 27.7324, -0.06216>, <-3.9819, 31.3373, -0.4221>, 0.2678 }
			cylinder { <-3.9819, 31.3373, -0.4221>, <-6.4517, 34.2792, -1.2447>, 0.2678 }
			cylinder { <-6.4517, 34.2792, -1.2447>, <-9.6232, 36.2611, -2.4468>, 0.2678 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-9.6232, 36.2611, -2.4468>, <-10.5871, 36.8307, -2.8148>, 0.2678 }
				cylinder { <-10.5871, 36.8307, -2.8148>, <-11.5628, 37.3748, -3.1899>, 0.2678 }
				cylinder { <-11.5628, 37.3748, -3.1899>, <-12.5498, 37.8932, -3.572>, 0.2678 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-12.5498, 37.8932, -3.572>, <-13.1408, 38.2668, -4.04074>, 0.05739 }
				cylinder { <-13.1408, 38.2668, -4.04074>, <-13.575, 38.6166, -4.6712>, 0.05739 }
				cylinder { <-13.575, 38.6166, -4.6712>, <-13.8211, 38.9173, -5.4179>, 0.05739 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-13.8211, 38.9173, -5.4179>, <-18.4294, 45.1974, -11.7327>, <-18.3519, 44.7977, -15.1076> }
				triangle { <-13.8211, 38.9173, -5.4179>, <-18.3519, 44.7977, -15.1076>, <-18.4294, 45.1974, -11.7327> }
				triangle { <-18.4294, 45.1974, -11.7327>, <-21.6072, 49.3859, -17.7669>, <-18.3519, 44.7977, -15.1076> }
				triangle { <-18.4294, 45.1974, -11.7327>, <-18.3519, 44.7977, -15.1076>, <-21.6072, 49.3859, -17.7669> }
				triangle { <-21.6072, 49.3859, -17.7669>, <-18.7814, 44.9795, -20.4724>, <-18.3519, 44.7977, -15.1076> }
				triangle { <-21.6072, 49.3859, -17.7669>, <-18.3519, 44.7977, -15.1076>, <-18.7814, 44.9795, -20.4724> }
				triangle { <-18.3519, 44.7977, -15.1076>, <-18.7814, 44.9795, -20.4724>, <-13.8211, 38.9173, -5.4179> }
				triangle { <-18.3519, 44.7977, -15.1076>, <-13.8211, 38.9173, -5.4179>, <-18.7814, 44.9795, -20.4724> }
				triangle { <-21.6072, 49.3859, -17.7669>, <-41.2007, 40.04853, -22.5105>, <-48.3442, 34.6606, -26.8432> }
				triangle { <-21.6072, 49.3859, -17.7669>, <-48.3442, 34.6606, -26.8432>, <-41.2007, 40.04853, -22.5105> }
				triangle { <-48.3442, 34.6606, -26.8432>, <-50.7557, 29.6313, -28.871>, <-45.9248, 30.02136, -24.4604> }
				triangle { <-48.3442, 34.6606, -26.8432>, <-45.9248, 30.02136, -24.4604>, <-50.7557, 29.6313, -28.871> }
				triangle { <-45.9248, 30.02136, -24.4604>, <-21.6072, 49.3859, -17.7669>, <-48.3442, 34.6606, -26.8432> }
				triangle { <-45.9248, 30.02136, -24.4604>, <-48.3442, 34.6606, -26.8432>, <-21.6072, 49.3859, -17.7669> }
				triangle { <-21.6072, 49.3859, -17.7669>, <-45.9248, 30.02136, -24.4604>, <-18.7814, 44.9795, -20.4724> }
				triangle { <-21.6072, 49.3859, -17.7669>, <-18.7814, 44.9795, -20.4724>, <-45.9248, 30.02136, -24.4604> }
				triangle { <-16.3173, 41.625, -17.05554>, <-14.5864, 39.2046, -15.4122>, <-13.8211, 38.9173, -5.4179> }
				triangle { <-16.3173, 41.625, -17.05554>, <-13.8211, 38.9173, -5.4179>, <-14.5864, 39.2046, -15.4122> }
				triangle { <-16.3173, 41.625, -17.05554>, <-15.9556, 40.5731, -23.1779>, <-14.5864, 39.2046, -15.4122> }
				triangle { <-16.3173, 41.625, -17.05554>, <-14.5864, 39.2046, -15.4122>, <-15.9556, 40.5731, -23.1779> }
				triangle { <-16.3173, 41.625, -17.05554>, <-18.7814, 44.9795, -20.4724>, <-15.9556, 40.5731, -23.1779> }
				triangle { <-16.3173, 41.625, -17.05554>, <-15.9556, 40.5731, -23.1779>, <-18.7814, 44.9795, -20.4724> }
				triangle { <-13.8211, 38.9173, -5.4179>, <-18.7814, 44.9795, -20.4724>, <-16.3173, 41.625, -17.05554> }
				triangle { <-13.8211, 38.9173, -5.4179>, <-16.3173, 41.625, -17.05554>, <-18.7814, 44.9795, -20.4724> }
				triangle { <-44.9532, 29.3729, -30.08985>, <-35.3231, 30.8831, -28.1379>, <-15.9556, 40.5731, -23.1779> }
				triangle { <-44.9532, 29.3729, -30.08985>, <-15.9556, 40.5731, -23.1779>, <-35.3231, 30.8831, -28.1379> }
				triangle { <-45.9248, 30.02136, -24.4604>, <-50.7557, 29.6313, -28.871>, <-44.9532, 29.3729, -30.08985> }
				triangle { <-45.9248, 30.02136, -24.4604>, <-44.9532, 29.3729, -30.08985>, <-50.7557, 29.6313, -28.871> }
				triangle { <-44.9532, 29.3729, -30.08985>, <-15.9556, 40.5731, -23.1779>, <-45.9248, 30.02136, -24.4604> }
				triangle { <-44.9532, 29.3729, -30.08985>, <-45.9248, 30.02136, -24.4604>, <-15.9556, 40.5731, -23.1779> }
				triangle { <-18.7814, 44.9795, -20.4724>, <-45.9248, 30.02136, -24.4604>, <-15.9556, 40.5731, -23.1779> }
				triangle { <-18.7814, 44.9795, -20.4724>, <-15.9556, 40.5731, -23.1779>, <-45.9248, 30.02136, -24.4604> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-12.5498, 37.8932, -3.572>, <-13.5474, 38.3856, -3.9608>, 0.2678 }
				cylinder { <-13.5474, 38.3856, -3.9608>, <-14.5551, 38.8517, -4.356>, 0.2678 }
				cylinder { <-14.5551, 38.8517, -4.356>, <-15.5723, 39.2911, -4.7575>, 0.2678 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-15.5723, 39.2911, -4.7575>, <-16.3608, 39.5768, -4.8282>, 0.05739 }
				cylinder { <-16.3608, 39.5768, -4.8282>, <-17.1544, 39.8138, -4.6776>, 0.05739 }
				cylinder { <-17.1544, 39.8138, -4.6776>, <-17.8954, 39.9849, -4.3168>, 0.05739 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-17.8954, 39.9849, -4.3168>, <-24.09474, 43.02625, 2.9543>, <-27.4753, 43.04882, 2.5992> }
				triangle { <-17.8954, 39.9849, -4.3168>, <-27.4753, 43.04882, 2.5992>, <-24.09474, 43.02625, 2.9543> }
				triangle { <-24.09474, 43.02625, 2.9543>, <-30.0512, 45.1589, 7.8559>, <-27.4753, 43.04882, 2.5992> }
				triangle { <-24.09474, 43.02625, 2.9543>, <-27.4753, 43.04882, 2.5992>, <-30.0512, 45.1589, 7.8559> }
				triangle { <-30.0512, 45.1589, 7.8559>, <-32.8347, 43.4334, 2.9574>, <-27.4753, 43.04882, 2.5992> }
				triangle { <-30.0512, 45.1589, 7.8559>, <-27.4753, 43.04882, 2.5992>, <-32.8347, 43.4334, 2.9574> }
				triangle { <-27.4753, 43.04882, 2.5992>, <-32.8347, 43.4334, 2.9574>, <-17.8954, 39.9849, -4.3168> }
				triangle { <-27.4753, 43.04882, 2.5992>, <-17.8954, 39.9849, -4.3168>, <-32.8347, 43.4334, 2.9574> }
				triangle { <-30.0512, 45.1589, 7.8559>, <-36.6703, 26.7494, 18.3856>, <-41.8009, 18.6563, 21.03317> }
				triangle { <-30.0512, 45.1589, 7.8559>, <-41.8009, 18.6563, 21.03317>, <-36.6703, 26.7494, 18.3856> }
				triangle { <-41.8009, 18.6563, 21.03317>, <-44.2981, 13.3603, 20.06489>, <-39.5594, 16.05039, 16.4246> }
				triangle { <-41.8009, 18.6563, 21.03317>, <-39.5594, 16.05039, 16.4246>, <-44.2981, 13.3603, 20.06489> }
				triangle { <-39.5594, 16.05039, 16.4246>, <-30.0512, 45.1589, 7.8559>, <-41.8009, 18.6563, 21.03317> }
				triangle { <-39.5594, 16.05039, 16.4246>, <-41.8009, 18.6563, 21.03317>, <-30.0512, 45.1589, 7.8559> }
				triangle { <-30.0512, 45.1589, 7.8559>, <-39.5594, 16.05039, 16.4246>, <-32.8347, 43.4334, 2.9574> }
				triangle { <-30.0512, 45.1589, 7.8559>, <-32.8347, 43.4334, 2.9574>, <-39.5594, 16.05039, 16.4246> }
				triangle { <-29.4795, 41.8064, -0.9276>, <-27.8803, 40.6795, -3.7076>, <-17.8954, 39.9849, -4.3168> }
				triangle { <-29.4795, 41.8064, -0.9276>, <-17.8954, 39.9849, -4.3168>, <-27.8803, 40.6795, -3.7076> }
				triangle { <-29.4795, 41.8064, -0.9276>, <-35.6182, 41.7078, -1.941>, <-27.8803, 40.6795, -3.7076> }
				triangle { <-29.4795, 41.8064, -0.9276>, <-27.8803, 40.6795, -3.7076>, <-35.6182, 41.7078, -1.941> }
				triangle { <-29.4795, 41.8064, -0.9276>, <-32.8347, 43.4334, 2.9574>, <-35.6182, 41.7078, -1.941> }
				triangle { <-29.4795, 41.8064, -0.9276>, <-35.6182, 41.7078, -1.941>, <-32.8347, 43.4334, 2.9574> }
				triangle { <-17.8954, 39.9849, -4.3168>, <-32.8347, 43.4334, 2.9574>, <-29.4795, 41.8064, -0.9276> }
				triangle { <-17.8954, 39.9849, -4.3168>, <-29.4795, 41.8064, -0.9276>, <-32.8347, 43.4334, 2.9574> }
				triangle { <-45.1412, 16.5857, 15.1549>, <-42.4601, 23.1603, 8.1967>, <-35.6182, 41.7078, -1.941> }
				triangle { <-45.1412, 16.5857, 15.1549>, <-35.6182, 41.7078, -1.941>, <-42.4601, 23.1603, 8.1967> }
				triangle { <-39.5594, 16.05039, 16.4246>, <-44.2981, 13.3603, 20.06489>, <-45.1412, 16.5857, 15.1549> }
				triangle { <-39.5594, 16.05039, 16.4246>, <-45.1412, 16.5857, 15.1549>, <-44.2981, 13.3603, 20.06489> }
				triangle { <-45.1412, 16.5857, 15.1549>, <-35.6182, 41.7078, -1.941>, <-39.5594, 16.05039, 16.4246> }
				triangle { <-45.1412, 16.5857, 15.1549>, <-39.5594, 16.05039, 16.4246>, <-35.6182, 41.7078, -1.941> }
				triangle { <-32.8347, 43.4334, 2.9574>, <-39.5594, 16.05039, 16.4246>, <-35.6182, 41.7078, -1.941> }
				triangle { <-32.8347, 43.4334, 2.9574>, <-35.6182, 41.7078, -1.941>, <-39.5594, 16.05039, 16.4246> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-15.5723, 39.2911, -4.7575>, <-16.5983, 39.7036, -5.1649>, 0.2678 }
				cylinder { <-16.5983, 39.7036, -5.1649>, <-17.6325, 40.08906, -5.5781>, 0.2678 }
				cylinder { <-17.6325, 40.08906, -5.5781>, <-18.6743, 40.4471, -5.9968>, 0.2678 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-18.6743, 40.4471, -5.9968>, <-19.303, 40.7102, -6.4907>, 0.05739 }
				cylinder { <-19.303, 40.7102, -6.4907>, <-19.7709, 40.9618, -7.1436>, 0.05739 }
				cylinder { <-19.7709, 40.9618, -7.1436>, <-20.04394, 41.1835, -7.9084>, 0.05739 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-20.04394, 41.1835, -7.9084>, <-25.3588, 46.4148, -14.612>, <-25.1783, 45.8373, -17.957> }
				triangle { <-20.04394, 41.1835, -7.9084>, <-25.1783, 45.8373, -17.957>, <-25.3588, 46.4148, -14.612> }
				triangle { <-25.3588, 46.4148, -14.612>, <-28.9797, 49.7859, -20.9031>, <-25.1783, 45.8373, -17.957> }
				triangle { <-25.3588, 46.4148, -14.612>, <-25.1783, 45.8373, -17.957>, <-28.9797, 49.7859, -20.9031> }
				triangle { <-28.9797, 49.7859, -20.9031>, <-25.5487, 45.6533, -23.3262>, <-25.1783, 45.8373, -17.957> }
				triangle { <-28.9797, 49.7859, -20.9031>, <-25.1783, 45.8373, -17.957>, <-25.5487, 45.6533, -23.3262> }
				triangle { <-25.1783, 45.8373, -17.957>, <-25.5487, 45.6533, -23.3262>, <-20.04394, 41.1835, -7.9084> }
				triangle { <-25.1783, 45.8373, -17.957>, <-20.04394, 41.1835, -7.9084>, <-25.5487, 45.6533, -23.3262> }
				triangle { <-28.9797, 49.7859, -20.9031>, <-47.07152, 37.6381, -25.2295>, <-53.3628, 31.09858, -29.2895> }
				triangle { <-28.9797, 49.7859, -20.9031>, <-53.3628, 31.09858, -29.2895>, <-47.07152, 37.6381, -25.2295> }
				triangle { <-53.3628, 31.09858, -29.2895>, <-55.04775, 25.6827, -31.03639>, <-50.3786, 26.9711, -26.6224> }
				triangle { <-53.3628, 31.09858, -29.2895>, <-50.3786, 26.9711, -26.6224>, <-55.04775, 25.6827, -31.03639> }
				triangle { <-50.3786, 26.9711, -26.6224>, <-28.9797, 49.7859, -20.9031>, <-53.3628, 31.09858, -29.2895> }
				triangle { <-50.3786, 26.9711, -26.6224>, <-53.3628, 31.09858, -29.2895>, <-28.9797, 49.7859, -20.9031> }
				triangle { <-28.9797, 49.7859, -20.9031>, <-50.3786, 26.9711, -26.6224>, <-25.5487, 45.6533, -23.3262> }
				triangle { <-28.9797, 49.7859, -20.9031>, <-25.5487, 45.6533, -23.3262>, <-50.3786, 26.9711, -26.6224> }
				triangle { <-22.708, 42.8619, -19.7016>, <-20.6926, 40.7945, -17.9074>, <-20.04394, 41.1835, -7.9084> }
				triangle { <-22.708, 42.8619, -19.7016>, <-20.04394, 41.1835, -7.9084>, <-20.6926, 40.7945, -17.9074> }
				triangle { <-22.708, 42.8619, -19.7016>, <-22.1177, 41.5208, -25.7493>, <-20.6926, 40.7945, -17.9074> }
				triangle { <-22.708, 42.8619, -19.7016>, <-20.6926, 40.7945, -17.9074>, <-22.1177, 41.5208, -25.7493> }
				triangle { <-22.708, 42.8619, -19.7016>, <-25.5487, 45.6533, -23.3262>, <-22.1177, 41.5208, -25.7493> }
				triangle { <-22.708, 42.8619, -19.7016>, <-22.1177, 41.5208, -25.7493>, <-25.5487, 45.6533, -23.3262> }
				triangle { <-20.04394, 41.1835, -7.9084>, <-25.5487, 45.6533, -23.3262>, <-22.708, 42.8619, -19.7016> }
				triangle { <-20.04394, 41.1835, -7.9084>, <-22.708, 42.8619, -19.7016>, <-25.5487, 45.6533, -23.3262> }
				triangle { <-49.2456, 26.1395, -32.1972>, <-39.9349, 29.04248, -30.2695>, <-22.1177, 41.5208, -25.7493> }
				triangle { <-49.2456, 26.1395, -32.1972>, <-22.1177, 41.5208, -25.7493>, <-39.9349, 29.04248, -30.2695> }
				triangle { <-50.3786, 26.9711, -26.6224>, <-55.04775, 25.6827, -31.03639>, <-49.2456, 26.1395, -32.1972> }
				triangle { <-50.3786, 26.9711, -26.6224>, <-49.2456, 26.1395, -32.1972>, <-55.04775, 25.6827, -31.03639> }
				triangle { <-49.2456, 26.1395, -32.1972>, <-22.1177, 41.5208, -25.7493>, <-50.3786, 26.9711, -26.6224> }
				triangle { <-49.2456, 26.1395, -32.1972>, <-50.3786, 26.9711, -26.6224>, <-22.1177, 41.5208, -25.7493> }
				triangle { <-25.5487, 45.6533, -23.3262>, <-50.3786, 26.9711, -26.6224>, <-22.1177, 41.5208, -25.7493> }
				triangle { <-25.5487, 45.6533, -23.3262>, <-22.1177, 41.5208, -25.7493>, <-50.3786, 26.9711, -26.6224> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-18.6743, 40.4471, -5.9968>, <-19.4184, 40.7028, -6.2958>, 0.05739 }
				cylinder { <-19.4184, 40.7028, -6.2958>, <-20.1625, 40.9585, -6.5949>, 0.05739 }
				cylinder { <-20.1625, 40.9585, -6.5949>, <-20.9066, 41.2142, -6.8939>, 0.05739 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-20.9066, 41.2142, -6.8939>, <-29.6987, 46.03466, -6.7684>, <-31.8856, 45.9398, -9.369> }
				triangle { <-20.9066, 41.2142, -6.8939>, <-31.8856, 45.9398, -9.369>, <-29.6987, 46.03466, -6.7684> }
				triangle { <-29.6987, 46.03466, -6.7684>, <-36.888, 49.3519, -7.9357>, <-31.8856, 45.9398, -9.369> }
				triangle { <-29.6987, 46.03466, -6.7684>, <-31.8856, 45.9398, -9.369>, <-36.888, 49.3519, -7.9357> }
				triangle { <-36.888, 49.3519, -7.9357>, <-35.9086, 46.3701, -12.9228>, <-31.8856, 45.9398, -9.369> }
				triangle { <-36.888, 49.3519, -7.9357>, <-31.8856, 45.9398, -9.369>, <-35.9086, 46.3701, -12.9228> }
				triangle { <-31.8856, 45.9398, -9.369>, <-35.9086, 46.3701, -12.9228>, <-20.9066, 41.2142, -6.8939> }
				triangle { <-31.8856, 45.9398, -9.369>, <-20.9066, 41.2142, -6.8939>, <-35.9086, 46.3701, -12.9228> }
				triangle { <-36.888, 49.3519, -7.9357>, <-52.02945, 34.3524, -1.6627>, <-58.9508, 27.218, -1.8197> }
				triangle { <-36.888, 49.3519, -7.9357>, <-58.9508, 27.218, -1.8197>, <-52.02945, 34.3524, -1.6627> }
				triangle { <-58.9508, 27.218, -1.8197>, <-61.04789, 21.8385, -3.1924>, <-54.7133, 23.4976, -2.9403> }
				triangle { <-58.9508, 27.218, -1.8197>, <-54.7133, 23.4976, -2.9403>, <-61.04789, 21.8385, -3.1924> }
				triangle { <-54.7133, 23.4976, -2.9403>, <-36.888, 49.3519, -7.9357>, <-58.9508, 27.218, -1.8197> }
				triangle { <-54.7133, 23.4976, -2.9403>, <-58.9508, 27.218, -1.8197>, <-36.888, 49.3519, -7.9357> }
				triangle { <-36.888, 49.3519, -7.9357>, <-54.7133, 23.4976, -2.9403>, <-35.9086, 46.3701, -12.9228> }
				triangle { <-36.888, 49.3519, -7.9357>, <-35.9086, 46.3701, -12.9228>, <-54.7133, 23.4976, -2.9403> }
				triangle { <-31.1804, 43.7929, -12.9597>, <-28.3667, 41.9794, -13.5508>, <-20.9066, 41.2142, -6.8939> }
				triangle { <-31.1804, 43.7929, -12.9597>, <-20.9066, 41.2142, -6.8939>, <-28.3667, 41.9794, -13.5508> }
				triangle { <-31.1804, 43.7929, -12.9597>, <-34.9292, 43.3883, -17.9099>, <-28.3667, 41.9794, -13.5508> }
				triangle { <-31.1804, 43.7929, -12.9597>, <-28.3667, 41.9794, -13.5508>, <-34.9292, 43.3883, -17.9099> }
				triangle { <-31.1804, 43.7929, -12.9597>, <-35.9086, 46.3701, -12.9228>, <-34.9292, 43.3883, -17.9099> }
				triangle { <-31.1804, 43.7929, -12.9597>, <-34.9292, 43.3883, -17.9099>, <-35.9086, 46.3701, -12.9228> }
				triangle { <-20.9066, 41.2142, -6.8939>, <-35.9086, 46.3701, -12.9228>, <-31.1804, 43.7929, -12.9597> }
				triangle { <-20.9066, 41.2142, -6.8939>, <-31.1804, 43.7929, -12.9597>, <-35.9086, 46.3701, -12.9228> }
				triangle { <-57.7755, 23.6399, -7.8042>, <-49.9922, 28.1503, -12.03584>, <-34.9292, 43.3883, -17.9099> }
				triangle { <-57.7755, 23.6399, -7.8042>, <-34.9292, 43.3883, -17.9099>, <-49.9922, 28.1503, -12.03584> }
				triangle { <-54.7133, 23.4976, -2.9403>, <-61.04789, 21.8385, -3.1924>, <-57.7755, 23.6399, -7.8042> }
				triangle { <-54.7133, 23.4976, -2.9403>, <-57.7755, 23.6399, -7.8042>, <-61.04789, 21.8385, -3.1924> }
				triangle { <-57.7755, 23.6399, -7.8042>, <-34.9292, 43.3883, -17.9099>, <-54.7133, 23.4976, -2.9403> }
				triangle { <-57.7755, 23.6399, -7.8042>, <-54.7133, 23.4976, -2.9403>, <-34.9292, 43.3883, -17.9099> }
				triangle { <-35.9086, 46.3701, -12.9228>, <-54.7133, 23.4976, -2.9403>, <-34.9292, 43.3883, -17.9099> }
				triangle { <-35.9086, 46.3701, -12.9228>, <-34.9292, 43.3883, -17.9099>, <-54.7133, 23.4976, -2.9403> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-2.4629, 27.7324, -0.06216>, <-2.2025, 30.3822, 0.2649>, 0.4877 }
		cylinder { <-2.2025, 30.3822, 0.2649>, <-1.4112, 32.8871, 0.8085>, 0.4877 }
		cylinder { <-1.4112, 32.8871, 0.8085>, <-0.1274, 35.1253, 1.5421>, 0.4877 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.1274, 35.1253, 1.5421>, <1.3813, 36.4627, 2.2992>, 0.1468 }
			cylinder { <1.3813, 36.4627, 2.2992>, <3.2161, 37.2054, 3.1481>, 0.1468 }
			cylinder { <3.2161, 37.2054, 3.1481>, <5.1915, 37.2785, 4.003072>, 0.1468 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <5.1915, 37.2785, 4.003072>, <5.7849, 37.2846, 4.2586>, 0.1468 }
				cylinder { <5.7849, 37.2846, 4.2586>, <6.3787, 37.2749, 4.513>, 0.1468 }
				cylinder { <6.3787, 37.2749, 4.513>, <6.9726, 37.2494, 4.7662>, 0.1468 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <6.9726, 37.2494, 4.7662>, <7.1702, 37.2347, 4.9235>, 0.01725 }
				cylinder { <7.1702, 37.2347, 4.9235>, <7.3184, 37.2165, 5.1277>, 0.01725 }
				cylinder { <7.3184, 37.2165, 5.1277>, <7.4066, 37.1959, 5.364>, 0.01725 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <7.4066, 37.1959, 5.364>, <10.8265, 38.1312, 9.5657>, <10.5846, 37.3729, 11.2508> }
				triangle { <7.4066, 37.1959, 5.364>, <10.5846, 37.3729, 11.2508>, <10.8265, 38.1312, 9.5657> }
				triangle { <10.8265, 38.1312, 9.5657>, <13.09575, 38.4177, 13.3103>, <10.5846, 37.3729, 11.2508> }
				triangle { <10.8265, 38.1312, 9.5657>, <10.5846, 37.3729, 11.2508>, <13.09575, 38.4177, 13.3103> }
				triangle { <13.09575, 38.4177, 13.3103>, <10.6503, 36.4412, 14.05162>, <10.5846, 37.3729, 11.2508> }
				triangle { <13.09575, 38.4177, 13.3103>, <10.5846, 37.3729, 11.2508>, <10.6503, 36.4412, 14.05162> }
				triangle { <10.5846, 37.3729, 11.2508>, <10.6503, 36.4412, 14.05162>, <7.4066, 37.1959, 5.364> }
				triangle { <10.5846, 37.3729, 11.2508>, <7.4066, 37.1959, 5.364>, <10.6503, 36.4412, 14.05162> }
				triangle { <13.09575, 38.4177, 13.3103>, <20.8826, 29.05262, 13.4642>, <23.215, 24.2427, 14.5282> }
				triangle { <13.09575, 38.4177, 13.3103>, <23.215, 24.2427, 14.5282>, <20.8826, 29.05262, 13.4642> }
				triangle { <23.215, 24.2427, 14.5282>, <23.3112, 20.9918, 14.625>, <21.106, 22.9509, 12.574> }
				triangle { <23.215, 24.2427, 14.5282>, <21.106, 22.9509, 12.574>, <23.3112, 20.9918, 14.625> }
				triangle { <21.106, 22.9509, 12.574>, <13.09575, 38.4177, 13.3103>, <23.215, 24.2427, 14.5282> }
				triangle { <21.106, 22.9509, 12.574>, <23.215, 24.2427, 14.5282>, <13.09575, 38.4177, 13.3103> }
				triangle { <13.09575, 38.4177, 13.3103>, <21.106, 22.9509, 12.574>, <10.6503, 36.4412, 14.05162> }
				triangle { <13.09575, 38.4177, 13.3103>, <10.6503, 36.4412, 14.05162>, <21.106, 22.9509, 12.574> }
				triangle { <8.8238, 35.9498, 11.7846>, <7.5007, 35.443, 10.5739>, <7.4066, 37.1959, 5.364> }
				triangle { <8.8238, 35.9498, 11.7846>, <7.4066, 37.1959, 5.364>, <7.5007, 35.443, 10.5739> }
				triangle { <8.8238, 35.9498, 11.7846>, <8.2048, 34.4646, 14.7929>, <7.5007, 35.443, 10.5739> }
				triangle { <8.8238, 35.9498, 11.7846>, <7.5007, 35.443, 10.5739>, <8.2048, 34.4646, 14.7929> }
				triangle { <8.8238, 35.9498, 11.7846>, <10.6503, 36.4412, 14.05162>, <8.2048, 34.4646, 14.7929> }
				triangle { <8.8238, 35.9498, 11.7846>, <8.2048, 34.4646, 14.7929>, <10.6503, 36.4412, 14.05162> }
				triangle { <7.4066, 37.1959, 5.364>, <10.6503, 36.4412, 14.05162>, <8.8238, 35.9498, 11.7846> }
				triangle { <7.4066, 37.1959, 5.364>, <8.8238, 35.9498, 11.7846>, <10.6503, 36.4412, 14.05162> }
				triangle { <20.2804, 21.8709, 15.4178>, <15.7961, 24.9413, 15.00623>, <8.2048, 34.4646, 14.7929> }
				triangle { <20.2804, 21.8709, 15.4178>, <8.2048, 34.4646, 14.7929>, <15.7961, 24.9413, 15.00623> }
				triangle { <21.106, 22.9509, 12.574>, <23.3112, 20.9918, 14.625>, <20.2804, 21.8709, 15.4178> }
				triangle { <21.106, 22.9509, 12.574>, <20.2804, 21.8709, 15.4178>, <23.3112, 20.9918, 14.625> }
				triangle { <20.2804, 21.8709, 15.4178>, <8.2048, 34.4646, 14.7929>, <21.106, 22.9509, 12.574> }
				triangle { <20.2804, 21.8709, 15.4178>, <21.106, 22.9509, 12.574>, <8.2048, 34.4646, 14.7929> }
				triangle { <10.6503, 36.4412, 14.05162>, <21.106, 22.9509, 12.574>, <8.2048, 34.4646, 14.7929> }
				triangle { <10.6503, 36.4412, 14.05162>, <8.2048, 34.4646, 14.7929>, <21.106, 22.9509, 12.574> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <6.9726, 37.2494, 4.7662>, <7.5662, 37.2081, 5.01798>, 0.1468 }
				cylinder { <7.5662, 37.2081, 5.01798>, <8.1592, 37.151, 5.2682>, 0.1468 }
				cylinder { <8.1592, 37.151, 5.2682>, <8.7511, 37.07823, 5.5167>, 0.1468 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <8.7511, 37.07823, 5.5167>, <9.001143, 37.05578, 5.5486>, 0.01725 }
				cylinder { <9.001143, 37.05578, 5.5486>, <9.2511, 37.04101, 5.5129>, 0.01725 }
				cylinder { <9.2511, 37.04101, 5.5129>, <9.4831, 37.03499, 5.4121>, 0.01725 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <9.4831, 37.03499, 5.4121>, <13.5101, 38.4462, 1.9457>, <15.2115, 37.6887, 2.01457> }
				triangle { <9.4831, 37.03499, 5.4121>, <15.2115, 37.6887, 2.01457>, <13.5101, 38.4462, 1.9457> }
				triangle { <13.5101, 38.4462, 1.9457>, <17.1406, 39.0653, -0.4395>, <15.2115, 37.6887, 2.01457> }
				triangle { <13.5101, 38.4462, 1.9457>, <15.2115, 37.6887, 2.01457>, <17.1406, 39.0653, -0.4395> }
				triangle { <17.1406, 39.0653, -0.4395>, <18.01428, 36.8135, 1.7059>, <15.2115, 37.6887, 2.01457> }
				triangle { <17.1406, 39.0653, -0.4395>, <15.2115, 37.6887, 2.01457>, <18.01428, 36.8135, 1.7059> }
				triangle { <15.2115, 37.6887, 2.01457>, <18.01428, 36.8135, 1.7059>, <9.4831, 37.03499, 5.4121> }
				triangle { <15.2115, 37.6887, 2.01457>, <9.4831, 37.03499, 5.4121>, <18.01428, 36.8135, 1.7059> }
				triangle { <17.1406, 39.0653, -0.4395>, <17.01049, 30.7343, -9.3245>, <18.00611, 26.2647, -12.2806> }
				triangle { <17.1406, 39.0653, -0.4395>, <18.00611, 26.2647, -12.2806>, <17.01049, 30.7343, -9.3245> }
				triangle { <18.00611, 26.2647, -12.2806>, <18.1273, 23.05233, -12.7828>, <16.1652, 24.6943, -10.2605> }
				triangle { <18.00611, 26.2647, -12.2806>, <16.1652, 24.6943, -10.2605>, <18.1273, 23.05233, -12.7828> }
				triangle { <16.1652, 24.6943, -10.2605>, <17.1406, 39.0653, -0.4395>, <18.00611, 26.2647, -12.2806> }
				triangle { <16.1652, 24.6943, -10.2605>, <18.00611, 26.2647, -12.2806>, <17.1406, 39.0653, -0.4395> }
				triangle { <17.1406, 39.0653, -0.4395>, <16.1652, 24.6943, -10.2605>, <18.01428, 36.8135, 1.7059> }
				triangle { <17.1406, 39.0653, -0.4395>, <18.01428, 36.8135, 1.7059>, <16.1652, 24.6943, -10.2605> }
				triangle { <15.8405, 36.06754, 3.5593>, <14.6982, 35.3838, 4.8635>, <9.4831, 37.03499, 5.4121> }
				triangle { <15.8405, 36.06754, 3.5593>, <9.4831, 37.03499, 5.4121>, <14.6982, 35.3838, 4.8635> }
				triangle { <15.8405, 36.06754, 3.5593>, <18.8879, 34.5618, 3.8514>, <14.6982, 35.3838, 4.8635> }
				triangle { <15.8405, 36.06754, 3.5593>, <14.6982, 35.3838, 4.8635>, <18.8879, 34.5618, 3.8514> }
				triangle { <15.8405, 36.06754, 3.5593>, <18.01428, 36.8135, 1.7059>, <18.8879, 34.5618, 3.8514> }
				triangle { <15.8405, 36.06754, 3.5593>, <18.8879, 34.5618, 3.8514>, <18.01428, 36.8135, 1.7059> }
				triangle { <9.4831, 37.03499, 5.4121>, <18.01428, 36.8135, 1.7059>, <15.8405, 36.06754, 3.5593> }
				triangle { <9.4831, 37.03499, 5.4121>, <15.8405, 36.06754, 3.5593>, <18.01428, 36.8135, 1.7059> }
				triangle { <19.05446, 23.5627, -9.706>, <18.8276, 26.0508, -4.862>, <18.8879, 34.5618, 3.8514> }
				triangle { <19.05446, 23.5627, -9.706>, <18.8879, 34.5618, 3.8514>, <18.8276, 26.0508, -4.862> }
				triangle { <16.1652, 24.6943, -10.2605>, <18.1273, 23.05233, -12.7828>, <19.05446, 23.5627, -9.706> }
				triangle { <16.1652, 24.6943, -10.2605>, <19.05446, 23.5627, -9.706>, <18.1273, 23.05233, -12.7828> }
				triangle { <19.05446, 23.5627, -9.706>, <18.8879, 34.5618, 3.8514>, <16.1652, 24.6943, -10.2605> }
				triangle { <19.05446, 23.5627, -9.706>, <16.1652, 24.6943, -10.2605>, <18.8879, 34.5618, 3.8514> }
				triangle { <18.01428, 36.8135, 1.7059>, <16.1652, 24.6943, -10.2605>, <18.8879, 34.5618, 3.8514> }
				triangle { <18.01428, 36.8135, 1.7059>, <18.8879, 34.5618, 3.8514>, <16.1652, 24.6943, -10.2605> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <8.7511, 37.07823, 5.5167>, <9.3417, 36.9897, 5.7633>, 0.1468 }
				cylinder { <9.3417, 36.9897, 5.7633>, <9.9306, 36.8856, 6.007978>, 0.1468 }
				cylinder { <9.9306, 36.8856, 6.007978>, <10.5174, 36.7659, 6.2504>, 0.1468 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <10.5174, 36.7659, 6.2504>, <10.7123, 36.7157, 6.4037>, 0.01725 }
				cylinder { <10.7123, 36.7157, 6.4037>, <10.8582, 36.6658, 6.6044>, 0.01725 }
				cylinder { <10.8582, 36.6658, 6.6044>, <10.9444, 36.6198, 6.8377>, 0.01725 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <10.9444, 36.6198, 6.8377>, <14.4885, 36.8405, 11.03478>, <14.1584, 36.02422, 12.6773> }
				triangle { <10.9444, 36.6198, 6.8377>, <14.1584, 36.02422, 12.6773>, <14.4885, 36.8405, 11.03478> }
				triangle { <14.4885, 36.8405, 11.03478>, <16.8019, 36.6005, 14.7555>, <14.1584, 36.02422, 12.6773> }
				triangle { <14.4885, 36.8405, 11.03478>, <14.1584, 36.02422, 12.6773>, <16.8019, 36.6005, 14.7555> }
				triangle { <16.8019, 36.6005, 14.7555>, <14.1176, 34.9298, 15.4191>, <14.1584, 36.02422, 12.6773> }
				triangle { <16.8019, 36.6005, 14.7555>, <14.1584, 36.02422, 12.6773>, <14.1176, 34.9298, 15.4191> }
				triangle { <14.1584, 36.02422, 12.6773>, <14.1176, 34.9298, 15.4191>, <10.9444, 36.6198, 6.8377> }
				triangle { <14.1584, 36.02422, 12.6773>, <10.9444, 36.6198, 6.8377>, <14.1176, 34.9298, 15.4191> }
				triangle { <16.8019, 36.6005, 14.7555>, <23.2567, 26.2828, 14.2596>, <24.927, 21.1496, 15.01284> }
				triangle { <16.8019, 36.6005, 14.7555>, <24.927, 21.1496, 15.01284>, <23.2567, 26.2828, 14.2596> }
				triangle { <24.927, 21.1496, 15.01284>, <24.585, 17.9152, 14.9226>, <22.6496, 20.269, 13.01956> }
				triangle { <24.927, 21.1496, 15.01284>, <22.6496, 20.269, 13.01956>, <24.585, 17.9152, 14.9226> }
				triangle { <22.6496, 20.269, 13.01956>, <16.8019, 36.6005, 14.7555>, <24.927, 21.1496, 15.01284> }
				triangle { <22.6496, 20.269, 13.01956>, <24.927, 21.1496, 15.01284>, <16.8019, 36.6005, 14.7555> }
				triangle { <16.8019, 36.6005, 14.7555>, <22.6496, 20.269, 13.01956>, <14.1176, 34.9298, 15.4191> }
				triangle { <16.8019, 36.6005, 14.7555>, <14.1176, 34.9298, 15.4191>, <22.6496, 20.269, 13.01956> }
				triangle { <12.2258, 34.8213, 13.155>, <10.838, 34.5683, 11.9371>, <10.9444, 36.6198, 6.8377> }
				triangle { <12.2258, 34.8213, 13.155>, <10.9444, 36.6198, 6.8377>, <10.838, 34.5683, 11.9371> }
				triangle { <12.2258, 34.8213, 13.155>, <11.4334, 33.2591, 16.08264>, <10.838, 34.5683, 11.9371> }
				triangle { <12.2258, 34.8213, 13.155>, <10.838, 34.5683, 11.9371>, <11.4334, 33.2591, 16.08264> }
				triangle { <12.2258, 34.8213, 13.155>, <14.1176, 34.9298, 15.4191>, <11.4334, 33.2591, 16.08264> }
				triangle { <12.2258, 34.8213, 13.155>, <11.4334, 33.2591, 16.08264>, <14.1176, 34.9298, 15.4191> }
				triangle { <10.9444, 36.6198, 6.8377>, <14.1176, 34.9298, 15.4191>, <12.2258, 34.8213, 13.155> }
				triangle { <10.9444, 36.6198, 6.8377>, <12.2258, 34.8213, 13.155>, <14.1176, 34.9298, 15.4191> }
				triangle { <21.706, 19.1448, 15.809>, <17.6735, 22.8077, 15.6398>, <11.4334, 33.2591, 16.08264> }
				triangle { <21.706, 19.1448, 15.809>, <11.4334, 33.2591, 16.08264>, <17.6735, 22.8077, 15.6398> }
				triangle { <22.6496, 20.269, 13.01956>, <24.585, 17.9152, 14.9226>, <21.706, 19.1448, 15.809> }
				triangle { <22.6496, 20.269, 13.01956>, <21.706, 19.1448, 15.809>, <24.585, 17.9152, 14.9226> }
				triangle { <21.706, 19.1448, 15.809>, <11.4334, 33.2591, 16.08264>, <22.6496, 20.269, 13.01956> }
				triangle { <21.706, 19.1448, 15.809>, <22.6496, 20.269, 13.01956>, <11.4334, 33.2591, 16.08264> }
				triangle { <14.1176, 34.9298, 15.4191>, <22.6496, 20.269, 13.01956>, <11.4334, 33.2591, 16.08264> }
				triangle { <14.1176, 34.9298, 15.4191>, <11.4334, 33.2591, 16.08264>, <22.6496, 20.269, 13.01956> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <10.5174, 36.7659, 6.2504>, <10.7472, 36.719, 6.3454>, 0.01725 }
				cylinder { <10.7472, 36.719, 6.3454>, <10.977, 36.6721, 6.4403>, 0.01725 }
				cylinder { <10.977, 36.6721, 6.4403>, <11.2067, 36.6253, 6.5353>, 0.01725 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <11.2067, 36.6253, 6.5353>, <16.6642, 37.1052, 6.9939>, <17.6582, 36.1527, 8.2501> }
				triangle { <11.2067, 36.6253, 6.5353>, <17.6582, 36.1527, 8.2501>, <16.6642, 37.1052, 6.9939> }
				triangle { <16.6642, 37.1052, 6.9939>, <20.9514, 36.9804, 7.9201>, <17.6582, 36.1527, 8.2501> }
				triangle { <16.6642, 37.1052, 6.9939>, <17.6582, 36.1527, 8.2501>, <20.9514, 36.9804, 7.9201> }
				triangle { <20.9514, 36.9804, 7.9201>, <19.6567, 34.9016, 10.027>, <17.6582, 36.1527, 8.2501> }
				triangle { <20.9514, 36.9804, 7.9201>, <17.6582, 36.1527, 8.2501>, <19.6567, 34.9016, 10.027> }
				triangle { <17.6582, 36.1527, 8.2501>, <19.6567, 34.9016, 10.027>, <11.2067, 36.6253, 6.5353> }
				triangle { <17.6582, 36.1527, 8.2501>, <11.2067, 36.6253, 6.5353>, <19.6567, 34.9016, 10.027> }
				triangle { <20.9514, 36.9804, 7.9201>, <25.6926, 27.7555, 1.5335>, <27.695, 22.8828, 0.1357> }
				triangle { <20.9514, 36.9804, 7.9201>, <27.695, 22.8828, 0.1357>, <25.6926, 27.7555, 1.5335> }
				triangle { <27.695, 22.8828, 0.1357>, <27.5822, 19.6442, -0.1568>, <24.7352, 21.8025, 0.2231> }
				triangle { <27.695, 22.8828, 0.1357>, <24.7352, 21.8025, 0.2231>, <27.5822, 19.6442, -0.1568> }
				triangle { <24.7352, 21.8025, 0.2231>, <20.9514, 36.9804, 7.9201>, <27.695, 22.8828, 0.1357> }
				triangle { <24.7352, 21.8025, 0.2231>, <27.695, 22.8828, 0.1357>, <20.9514, 36.9804, 7.9201> }
				triangle { <20.9514, 36.9804, 7.9201>, <24.7352, 21.8025, 0.2231>, <19.6567, 34.9016, 10.027> }
				triangle { <20.9514, 36.9804, 7.9201>, <19.6567, 34.9016, 10.027>, <24.7352, 21.8025, 0.2231> }
				triangle { <16.726, 34.6559, 9.767>, <14.9034, 34.278, 9.8593>, <11.2067, 36.6253, 6.5353> }
				triangle { <16.726, 34.6559, 9.767>, <11.2067, 36.6253, 6.5353>, <14.9034, 34.278, 9.8593> }
				triangle { <16.726, 34.6559, 9.767>, <18.362, 32.8228, 12.1338>, <14.9034, 34.278, 9.8593> }
				triangle { <16.726, 34.6559, 9.767>, <14.9034, 34.278, 9.8593>, <18.362, 32.8228, 12.1338> }
				triangle { <16.726, 34.6559, 9.767>, <19.6567, 34.9016, 10.027>, <18.362, 32.8228, 12.1338> }
				triangle { <16.726, 34.6559, 9.767>, <18.362, 32.8228, 12.1338>, <19.6567, 34.9016, 10.027> }
				triangle { <11.2067, 36.6253, 6.5353>, <19.6567, 34.9016, 10.027>, <16.726, 34.6559, 9.767> }
				triangle { <11.2067, 36.6253, 6.5353>, <16.726, 34.6559, 9.767>, <19.6567, 34.9016, 10.027> }
				triangle { <26.1414, 20.3883, 2.664>, <22.9997, 23.4316, 5.9158>, <18.362, 32.8228, 12.1338> }
				triangle { <26.1414, 20.3883, 2.664>, <18.362, 32.8228, 12.1338>, <22.9997, 23.4316, 5.9158> }
				triangle { <24.7352, 21.8025, 0.2231>, <27.5822, 19.6442, -0.1568>, <26.1414, 20.3883, 2.664> }
				triangle { <24.7352, 21.8025, 0.2231>, <26.1414, 20.3883, 2.664>, <27.5822, 19.6442, -0.1568> }
				triangle { <26.1414, 20.3883, 2.664>, <18.362, 32.8228, 12.1338>, <24.7352, 21.8025, 0.2231> }
				triangle { <26.1414, 20.3883, 2.664>, <24.7352, 21.8025, 0.2231>, <18.362, 32.8228, 12.1338> }
				triangle { <19.6567, 34.9016, 10.027>, <24.7352, 21.8025, 0.2231>, <18.362, 32.8228, 12.1338> }
				triangle { <19.6567, 34.9016, 10.027>, <18.362, 32.8228, 12.1338>, <24.7352, 21.8025, 0.2231> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.1274, 35.1253, 1.5421>, <0.3209, 37.2006, 1.9034>, 0.1468 }
			cylinder { <0.3209, 37.2006, 1.9034>, <0.1419, 39.3447, 2.000662>, 0.1468 }
			cylinder { <0.1419, 39.3447, 2.000662>, <-0.6464, 41.3411, 1.8239>, 0.1468 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-0.6464, 41.3411, 1.8239>, <-0.8962, 41.934, 1.7647>, 0.1468 }
				cylinder { <-0.8962, 41.934, 1.7647>, <-1.1592, 42.5205, 1.6993>, 0.1468 }
				cylinder { <-1.1592, 42.5205, 1.6993>, <-1.4352, 43.1003, 1.6278>, 0.1468 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-1.4352, 43.1003, 1.6278>, <-1.5127, 43.3242, 1.539>, 0.01725 }
				cylinder { <-1.5127, 43.3242, 1.539>, <-1.5542, 43.5286, 1.3958>, 0.01725 }
				cylinder { <-1.5542, 43.5286, 1.3958>, <-1.5566, 43.6988, 1.2086>, 0.01725 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-1.5566, 43.6988, 1.2086>, <-1.5633, 48.7143, -1.04272>, <-1.5967, 48.9926, -2.8852> }
				triangle { <-1.5566, 43.6988, 1.2086>, <-1.5967, 48.9926, -2.8852>, <-1.5633, 48.7143, -1.04272> }
				triangle { <-1.5633, 48.7143, -1.04272>, <-1.5842, 52.3478, -3.5025>, <-1.5967, 48.9926, -2.8852> }
				triangle { <-1.5633, 48.7143, -1.04272>, <-1.5967, 48.9926, -2.8852>, <-1.5842, 52.3478, -3.5025> }
				triangle { <-1.5842, 52.3478, -3.5025>, <-1.6434, 49.9575, -5.675>, <-1.5967, 48.9926, -2.8852> }
				triangle { <-1.5842, 52.3478, -3.5025>, <-1.5967, 48.9926, -2.8852>, <-1.6434, 49.9575, -5.675> }
				triangle { <-1.5967, 48.9926, -2.8852>, <-1.6434, 49.9575, -5.675>, <-1.5566, 43.6988, 1.2086> }
				triangle { <-1.5967, 48.9926, -2.8852>, <-1.5566, 43.6988, 1.2086>, <-1.6434, 49.9575, -5.675> }
				triangle { <-1.5842, 52.3478, -3.5025>, <-13.2431, 54.962, -5.869>, <-18.06993, 55.4229, -8.3583> }
				triangle { <-1.5842, 52.3478, -3.5025>, <-18.06993, 55.4229, -8.3583>, <-13.2431, 54.962, -5.869> }
				triangle { <-18.06993, 55.4229, -8.3583>, <-20.6929, 54.2683, -9.899>, <-18.4701, 52.34, -7.8378> }
				triangle { <-18.06993, 55.4229, -8.3583>, <-18.4701, 52.34, -7.8378>, <-20.6929, 54.2683, -9.899> }
				triangle { <-18.4701, 52.34, -7.8378>, <-1.5842, 52.3478, -3.5025>, <-18.06993, 55.4229, -8.3583> }
				triangle { <-18.4701, 52.34, -7.8378>, <-18.06993, 55.4229, -8.3583>, <-1.5842, 52.3478, -3.5025> }
				triangle { <-1.5842, 52.3478, -3.5025>, <-18.4701, 52.34, -7.8378>, <-1.6434, 49.9575, -5.675> }
				triangle { <-1.5842, 52.3478, -3.5025>, <-1.6434, 49.9575, -5.675>, <-18.4701, 52.34, -7.8378> }
				triangle { <-1.6394, 47.2716, -4.4494>, <-1.6438, 45.4636, -3.9973>, <-1.5566, 43.6988, 1.2086> }
				triangle { <-1.6394, 47.2716, -4.4494>, <-1.5566, 43.6988, 1.2086>, <-1.6438, 45.4636, -3.9973> }
				triangle { <-1.6394, 47.2716, -4.4494>, <-1.7025, 47.5673, -7.8475>, <-1.6438, 45.4636, -3.9973> }
				triangle { <-1.6394, 47.2716, -4.4494>, <-1.6438, 45.4636, -3.9973>, <-1.7025, 47.5673, -7.8475> }
				triangle { <-1.6394, 47.2716, -4.4494>, <-1.6434, 49.9575, -5.675>, <-1.7025, 47.5673, -7.8475> }
				triangle { <-1.6394, 47.2716, -4.4494>, <-1.7025, 47.5673, -7.8475>, <-1.6434, 49.9575, -5.675> }
				triangle { <-1.5566, 43.6988, 1.2086>, <-1.6434, 49.9575, -5.675>, <-1.6394, 47.2716, -4.4494> }
				triangle { <-1.5566, 43.6988, 1.2086>, <-1.6394, 47.2716, -4.4494>, <-1.6434, 49.9575, -5.675> }
				triangle { <-18.1409, 52.5546, -10.9653>, <-13.3662, 49.9903, -10.3878>, <-1.7025, 47.5673, -7.8475> }
				triangle { <-18.1409, 52.5546, -10.9653>, <-1.7025, 47.5673, -7.8475>, <-13.3662, 49.9903, -10.3878> }
				triangle { <-18.4701, 52.34, -7.8378>, <-20.6929, 54.2683, -9.899>, <-18.1409, 52.5546, -10.9653> }
				triangle { <-18.4701, 52.34, -7.8378>, <-18.1409, 52.5546, -10.9653>, <-20.6929, 54.2683, -9.899> }
				triangle { <-18.1409, 52.5546, -10.9653>, <-1.7025, 47.5673, -7.8475>, <-18.4701, 52.34, -7.8378> }
				triangle { <-18.1409, 52.5546, -10.9653>, <-18.4701, 52.34, -7.8378>, <-1.7025, 47.5673, -7.8475> }
				triangle { <-1.6434, 49.9575, -5.675>, <-18.4701, 52.34, -7.8378>, <-1.7025, 47.5673, -7.8475> }
				triangle { <-1.6434, 49.9575, -5.675>, <-1.7025, 47.5673, -7.8475>, <-18.4701, 52.34, -7.8378> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-1.4352, 43.1003, 1.6278>, <-1.724, 43.6731, 1.5502>, 0.1468 }
				cylinder { <-1.724, 43.6731, 1.5502>, <-2.02544, 44.2384, 1.4666>, 0.1468 }
				cylinder { <-2.02544, 44.2384, 1.4666>, <-2.3393, 44.796, 1.377>, 0.1468 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-2.3393, 44.796, 1.377>, <-2.4843, 45.00145, 1.405>, 0.01725 }
				cylinder { <-2.4843, 45.00145, 1.405>, <-2.641, 45.179, 1.494>, 0.01725 }
				cylinder { <-2.641, 45.179, 1.494>, <-2.7979, 45.3159, 1.6377>, 0.01725 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-2.7979, 45.3159, 1.6377>, <-4.7605, 47.5038, 6.2837>, <-6.2695, 48.5968, 6.3248> }
				triangle { <-2.7979, 45.3159, 1.6377>, <-6.2695, 48.5968, 6.3248>, <-4.7605, 47.5038, 6.2837> }
				triangle { <-4.7605, 47.5038, 6.2837>, <-6.858, 49.5576, 9.545>, <-6.2695, 48.5968, 6.3248> }
				triangle { <-4.7605, 47.5038, 6.2837>, <-6.2695, 48.5968, 6.3248>, <-6.858, 49.5576, 9.545> }
				triangle { <-6.858, 49.5576, 9.545>, <-8.5682, 50.3508, 6.9215>, <-6.2695, 48.5968, 6.3248> }
				triangle { <-6.858, 49.5576, 9.545>, <-6.2695, 48.5968, 6.3248>, <-8.5682, 50.3508, 6.9215> }
				triangle { <-6.2695, 48.5968, 6.3248>, <-8.5682, 50.3508, 6.9215>, <-2.7979, 45.3159, 1.6377> }
				triangle { <-6.2695, 48.5968, 6.3248>, <-2.7979, 45.3159, 1.6377>, <-8.5682, 50.3508, 6.9215> }
				triangle { <-6.858, 49.5576, 9.545>, <-15.7662, 42.1302, 13.2654>, <-20.649, 39.8225, 14.00034> }
				triangle { <-6.858, 49.5576, 9.545>, <-20.649, 39.8225, 14.00034>, <-15.7662, 42.1302, 13.2654> }
				triangle { <-20.649, 39.8225, 14.00034>, <-23.4117, 38.4296, 12.9932>, <-20.3768, 38.658, 11.08395> }
				triangle { <-20.649, 39.8225, 14.00034>, <-20.3768, 38.658, 11.08395>, <-23.4117, 38.4296, 12.9932> }
				triangle { <-20.3768, 38.658, 11.08395>, <-6.858, 49.5576, 9.545>, <-20.649, 39.8225, 14.00034> }
				triangle { <-20.3768, 38.658, 11.08395>, <-20.649, 39.8225, 14.00034>, <-6.858, 49.5576, 9.545> }
				triangle { <-6.858, 49.5576, 9.545>, <-20.3768, 38.658, 11.08395>, <-8.5682, 50.3508, 6.9215> }
				triangle { <-6.858, 49.5576, 9.545>, <-8.5682, 50.3508, 6.9215>, <-20.3768, 38.658, 11.08395> }
				triangle { <-7.5008, 49.1679, 4.4359>, <-7.08643, 48.5825, 2.7158>, <-2.7979, 45.3159, 1.6377> }
				triangle { <-7.5008, 49.1679, 4.4359>, <-2.7979, 45.3159, 1.6377>, <-7.08643, 48.5825, 2.7158> }
				triangle { <-7.5008, 49.1679, 4.4359>, <-10.2784, 51.144, 4.298>, <-7.08643, 48.5825, 2.7158> }
				triangle { <-7.5008, 49.1679, 4.4359>, <-7.08643, 48.5825, 2.7158>, <-10.2784, 51.144, 4.298> }
				triangle { <-7.5008, 49.1679, 4.4359>, <-8.5682, 50.3508, 6.9215>, <-10.2784, 51.144, 4.298> }
				triangle { <-7.5008, 49.1679, 4.4359>, <-10.2784, 51.144, 4.298>, <-8.5682, 50.3508, 6.9215> }
				triangle { <-2.7979, 45.3159, 1.6377>, <-8.5682, 50.3508, 6.9215>, <-7.5008, 49.1679, 4.4359> }
				triangle { <-2.7979, 45.3159, 1.6377>, <-7.5008, 49.1679, 4.4359>, <-8.5682, 50.3508, 6.9215> }
				triangle { <-22.7012, 40.7744, 10.8521>, <-19.3234, 43.78, 7.8086>, <-10.2784, 51.144, 4.298> }
				triangle { <-22.7012, 40.7744, 10.8521>, <-10.2784, 51.144, 4.298>, <-19.3234, 43.78, 7.8086> }
				triangle { <-20.3768, 38.658, 11.08395>, <-23.4117, 38.4296, 12.9932>, <-22.7012, 40.7744, 10.8521> }
				triangle { <-20.3768, 38.658, 11.08395>, <-22.7012, 40.7744, 10.8521>, <-23.4117, 38.4296, 12.9932> }
				triangle { <-22.7012, 40.7744, 10.8521>, <-10.2784, 51.144, 4.298>, <-20.3768, 38.658, 11.08395> }
				triangle { <-22.7012, 40.7744, 10.8521>, <-20.3768, 38.658, 11.08395>, <-10.2784, 51.144, 4.298> }
				triangle { <-8.5682, 50.3508, 6.9215>, <-20.3768, 38.658, 11.08395>, <-10.2784, 51.144, 4.298> }
				triangle { <-8.5682, 50.3508, 6.9215>, <-10.2784, 51.144, 4.298>, <-20.3768, 38.658, 11.08395> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-2.3393, 44.796, 1.377>, <-2.6655, 45.3455, 1.2814>, 0.1468 }
				cylinder { <-2.6655, 45.3455, 1.2814>, <-3.0038, 45.8865, 1.18>, 0.1468 }
				cylinder { <-3.0038, 45.8865, 1.18>, <-3.3539, 46.4189, 1.07276>, 0.1468 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-3.3539, 46.4189, 1.07276>, <-3.4595, 46.6248, 0.9704>, 0.01725 }
				cylinder { <-3.4595, 46.6248, 0.9704>, <-3.5259, 46.8132, 0.8152>, 0.01725 }
				cylinder { <-3.5259, 46.8132, 0.8152>, <-3.5482, 46.9706, 0.6184>, 0.01725 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-3.5482, 46.9706, 0.6184>, <-4.1942, 51.8028, -1.9225>, <-4.2373, 51.9685, -3.7783> }
				triangle { <-3.5482, 46.9706, 0.6184>, <-4.2373, 51.9685, -3.7783>, <-4.1942, 51.8028, -1.9225> }
				triangle { <-4.1942, 51.8028, -1.9225>, <-4.6657, 55.254, -4.5909>, <-4.2373, 51.9685, -3.7783> }
				triangle { <-4.1942, 51.8028, -1.9225>, <-4.2373, 51.9685, -3.7783>, <-4.6657, 55.254, -4.5909> }
				triangle { <-4.6657, 55.254, -4.5909>, <-4.3716, 52.7576, -6.6201>, <-4.2373, 51.9685, -3.7783> }
				triangle { <-4.6657, 55.254, -4.5909>, <-4.2373, 51.9685, -3.7783>, <-4.3716, 52.7576, -6.6201> }
				triangle { <-4.2373, 51.9685, -3.7783>, <-4.3716, 52.7576, -6.6201>, <-3.5482, 46.9706, 0.6184> }
				triangle { <-4.2373, 51.9685, -3.7783>, <-3.5482, 46.9706, 0.6184>, <-4.3716, 52.7576, -6.6201> }
				triangle { <-4.6657, 55.254, -4.5909>, <-16.5336, 56.1341, -7.188>, <-21.3411, 55.7976, -9.7338> }
				triangle { <-4.6657, 55.254, -4.5909>, <-21.3411, 55.7976, -9.7338>, <-16.5336, 56.1341, -7.188> }
				triangle { <-21.3411, 55.7976, -9.7338>, <-23.7625, 54.2142, -11.2226>, <-21.3319, 52.7236, -9.03668> }
				triangle { <-21.3411, 55.7976, -9.7338>, <-21.3319, 52.7236, -9.03668>, <-23.7625, 54.2142, -11.2226> }
				triangle { <-21.3319, 52.7236, -9.03668>, <-4.6657, 55.254, -4.5909>, <-21.3411, 55.7976, -9.7338> }
				triangle { <-21.3319, 52.7236, -9.03668>, <-21.3411, 55.7976, -9.7338>, <-4.6657, 55.254, -4.5909> }
				triangle { <-4.6657, 55.254, -4.5909>, <-21.3319, 52.7236, -9.03668>, <-4.3716, 52.7576, -6.6201> }
				triangle { <-4.6657, 55.254, -4.5909>, <-4.3716, 52.7576, -6.6201>, <-21.3319, 52.7236, -9.03668> }
				triangle { <-4.0256, 50.171, -5.2394>, <-3.7942, 48.4077, -4.6823>, <-3.5482, 46.9706, 0.6184> }
				triangle { <-4.0256, 50.171, -5.2394>, <-3.5482, 46.9706, 0.6184>, <-3.7942, 48.4077, -4.6823> }
				triangle { <-4.0256, 50.171, -5.2394>, <-4.07749, 50.2612, -8.6494>, <-3.7942, 48.4077, -4.6823> }
				triangle { <-4.0256, 50.171, -5.2394>, <-3.7942, 48.4077, -4.6823>, <-4.07749, 50.2612, -8.6494> }
				triangle { <-4.0256, 50.171, -5.2394>, <-4.3716, 52.7576, -6.6201>, <-4.07749, 50.2612, -8.6494> }
				triangle { <-4.0256, 50.171, -5.2394>, <-4.07749, 50.2612, -8.6494>, <-4.3716, 52.7576, -6.6201> }
				triangle { <-3.5482, 46.9706, 0.6184>, <-4.3716, 52.7576, -6.6201>, <-4.0256, 50.171, -5.2394> }
				triangle { <-3.5482, 46.9706, 0.6184>, <-4.0256, 50.171, -5.2394>, <-4.3716, 52.7576, -6.6201> }
				triangle { <-20.9881, 52.8019, -12.1689>, <-15.9218, 50.9416, -11.4089>, <-4.07749, 50.2612, -8.6494> }
				triangle { <-20.9881, 52.8019, -12.1689>, <-4.07749, 50.2612, -8.6494>, <-15.9218, 50.9416, -11.4089> }
				triangle { <-21.3319, 52.7236, -9.03668>, <-23.7625, 54.2142, -11.2226>, <-20.9881, 52.8019, -12.1689> }
				triangle { <-21.3319, 52.7236, -9.03668>, <-20.9881, 52.8019, -12.1689>, <-23.7625, 54.2142, -11.2226> }
				triangle { <-20.9881, 52.8019, -12.1689>, <-4.07749, 50.2612, -8.6494>, <-21.3319, 52.7236, -9.03668> }
				triangle { <-20.9881, 52.8019, -12.1689>, <-21.3319, 52.7236, -9.03668>, <-4.07749, 50.2612, -8.6494> }
				triangle { <-4.3716, 52.7576, -6.6201>, <-21.3319, 52.7236, -9.03668>, <-4.07749, 50.2612, -8.6494> }
				triangle { <-4.3716, 52.7576, -6.6201>, <-4.07749, 50.2612, -8.6494>, <-21.3319, 52.7236, -9.03668> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-3.3539, 46.4189, 1.07276>, <-3.491, 46.6273, 1.03076>, 0.01725 }
				cylinder { <-3.491, 46.6273, 1.03076>, <-3.6281, 46.8357, 0.9887>, 0.01725 }
				cylinder { <-3.6281, 46.8357, 0.9887>, <-3.7652, 47.04424, 0.9467>, 0.01725 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-3.7652, 47.04424, 0.9467>, <-6.2195, 51.8002, 2.2041>, <-7.1902, 52.7935, 0.9613> }
				triangle { <-3.7652, 47.04424, 0.9467>, <-7.1902, 52.7935, 0.9613>, <-6.2195, 51.8002, 2.2041> }
				triangle { <-6.2195, 51.8002, 2.2041>, <-8.4002, 55.5977, 2.4816>, <-7.1902, 52.7935, 0.9613> }
				triangle { <-6.2195, 51.8002, 2.2041>, <-7.1902, 52.7935, 0.9613>, <-8.4002, 55.5977, 2.4816> }
				triangle { <-8.4002, 55.5977, 2.4816>, <-8.8073, 54.7095, -0.5976>, <-7.1902, 52.7935, 0.9613> }
				triangle { <-8.4002, 55.5977, 2.4816>, <-7.1902, 52.7935, 0.9613>, <-8.8073, 54.7095, -0.5976> }
				triangle { <-7.1902, 52.7935, 0.9613>, <-8.8073, 54.7095, -0.5976>, <-3.7652, 47.04424, 0.9467> }
				triangle { <-7.1902, 52.7935, 0.9613>, <-3.7652, 47.04424, 0.9467>, <-8.8073, 54.7095, -0.5976> }
				triangle { <-8.4002, 55.5977, 2.4816>, <-20.0085, 52.85, 4.9443>, <-25.3509, 51.8993, 4.4335> }
				triangle { <-8.4002, 55.5977, 2.4816>, <-25.3509, 51.8993, 4.4335>, <-20.0085, 52.85, 4.9443> }
				triangle { <-25.3509, 51.8993, 4.4335>, <-27.9527, 50.4049, 3.175>, <-24.5867, 49.1515, 3.09158> }
				triangle { <-25.3509, 51.8993, 4.4335>, <-24.5867, 49.1515, 3.09158>, <-27.9527, 50.4049, 3.175> }
				triangle { <-24.5867, 49.1515, 3.09158>, <-8.4002, 55.5977, 2.4816>, <-25.3509, 51.8993, 4.4335> }
				triangle { <-24.5867, 49.1515, 3.09158>, <-25.3509, 51.8993, 4.4335>, <-8.4002, 55.5977, 2.4816> }
				triangle { <-8.4002, 55.5977, 2.4816>, <-24.5867, 49.1515, 3.09158>, <-8.8073, 54.7095, -0.5976> }
				triangle { <-8.4002, 55.5977, 2.4816>, <-8.8073, 54.7095, -0.5976>, <-24.5867, 49.1515, 3.09158> }
				triangle { <-7.4833, 52.154, -1.2557>, <-6.7732, 50.5923, -1.9836>, <-3.7652, 47.04424, 0.9467> }
				triangle { <-7.4833, 52.154, -1.2557>, <-3.7652, 47.04424, 0.9467>, <-6.7732, 50.5923, -1.9836> }
				triangle { <-7.4833, 52.154, -1.2557>, <-9.2144, 53.8213, -3.6769>, <-6.7732, 50.5923, -1.9836> }
				triangle { <-7.4833, 52.154, -1.2557>, <-6.7732, 50.5923, -1.9836>, <-9.2144, 53.8213, -3.6769> }
				triangle { <-7.4833, 52.154, -1.2557>, <-8.8073, 54.7095, -0.5976>, <-9.2144, 53.8213, -3.6769> }
				triangle { <-7.4833, 52.154, -1.2557>, <-9.2144, 53.8213, -3.6769>, <-8.8073, 54.7095, -0.5976> }
				triangle { <-3.7652, 47.04424, 0.9467>, <-8.8073, 54.7095, -0.5976>, <-7.4833, 52.154, -1.2557> }
				triangle { <-3.7652, 47.04424, 0.9467>, <-7.4833, 52.154, -1.2557>, <-8.8073, 54.7095, -0.5976> }
				triangle { <-25.8394, 50.8335, 0.7384>, <-20.8552, 51.00261, -1.4605>, <-9.2144, 53.8213, -3.6769> }
				triangle { <-25.8394, 50.8335, 0.7384>, <-9.2144, 53.8213, -3.6769>, <-20.8552, 51.00261, -1.4605> }
				triangle { <-24.5867, 49.1515, 3.09158>, <-27.9527, 50.4049, 3.175>, <-25.8394, 50.8335, 0.7384> }
				triangle { <-24.5867, 49.1515, 3.09158>, <-25.8394, 50.8335, 0.7384>, <-27.9527, 50.4049, 3.175> }
				triangle { <-25.8394, 50.8335, 0.7384>, <-9.2144, 53.8213, -3.6769>, <-24.5867, 49.1515, 3.09158> }
				triangle { <-25.8394, 50.8335, 0.7384>, <-24.5867, 49.1515, 3.09158>, <-9.2144, 53.8213, -3.6769> }
				triangle { <-8.8073, 54.7095, -0.5976>, <-24.5867, 49.1515, 3.09158>, <-9.2144, 53.8213, -3.6769> }
				triangle { <-8.8073, 54.7095, -0.5976>, <-9.2144, 53.8213, -3.6769>, <-24.5867, 49.1515, 3.09158> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-0.1274, 35.1253, 1.5421>, <0.393, 36.06021, 1.8218>, 0.201 }
		cylinder { <0.393, 36.06021, 1.8218>, <0.9044, 37.00655, 2.07876>, 0.201 }
		cylinder { <0.9044, 37.00655, 2.07876>, <1.4064, 37.9638, 2.3126>, 0.201 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <1.4064, 37.9638, 2.3126>, <1.6675, 38.7328, 2.259>, 0.05549 }
			cylinder { <1.6675, 38.7328, 2.259>, <1.7939, 39.4887, 1.985>, 0.05549 }
			cylinder { <1.7939, 39.4887, 1.985>, <1.7728, 40.1552, 1.5184>, 0.05549 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <1.7728, 40.1552, 1.5184>, <1.7665, 40.3551, 1.3784>, 0.05549 }
				cylinder { <1.7665, 40.3551, 1.3784>, <1.7602, 40.5551, 1.2384>, 0.05549 }
				cylinder { <1.7602, 40.5551, 1.2384>, <1.7538, 40.755, 1.09851>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <1.7538, 40.755, 1.09851>, <1.7608, 40.7805, 1.0739>, 0.002463 }
				cylinder { <1.7608, 40.7805, 1.0739>, <1.7752, 40.8001, 1.04717>, 0.002463 }
				cylinder { <1.7752, 40.8001, 1.04717>, <1.796, 40.8124, 1.02027>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <1.796, 40.8124, 1.02027>, <2.786, 42.2351, -0.1252>, <3.1726, 42.06805, -0.6897> }
				triangle { <1.796, 40.8124, 1.02027>, <3.1726, 42.06805, -0.6897>, <2.786, 42.2351, -0.1252> }
				triangle { <2.786, 42.2351, -0.1252>, <3.6632, 43.147, -1.1968>, <3.1726, 42.06805, -0.6897> }
				triangle { <2.786, 42.2351, -0.1252>, <3.1726, 42.06805, -0.6897>, <3.6632, 43.147, -1.1968> }
				triangle { <3.6632, 43.147, -1.1968>, <3.8182, 42.00428, -1.5974>, <3.1726, 42.06805, -0.6897> }
				triangle { <3.6632, 43.147, -1.1968>, <3.1726, 42.06805, -0.6897>, <3.8182, 42.00428, -1.5974> }
				triangle { <3.1726, 42.06805, -0.6897>, <3.8182, 42.00428, -1.5974>, <1.796, 40.8124, 1.02027> }
				triangle { <3.1726, 42.06805, -0.6897>, <1.796, 40.8124, 1.02027>, <3.8182, 42.00428, -1.5974> }
				triangle { <3.6632, 43.147, -1.1968>, <0.8917, 44.07032, -4.754>, <-0.02279, 44.01913, -6.5988> }
				triangle { <3.6632, 43.147, -1.1968>, <-0.02279, 44.01913, -6.5988>, <0.8917, 44.07032, -4.754> }
				triangle { <-0.02279, 44.01913, -6.5988>, <-0.6348, 43.4751, -7.5161>, <-0.5818, 43.03275, -6.2336> }
				triangle { <-0.02279, 44.01913, -6.5988>, <-0.5818, 43.03275, -6.2336>, <-0.6348, 43.4751, -7.5161> }
				triangle { <-0.5818, 43.03275, -6.2336>, <3.6632, 43.147, -1.1968>, <-0.02279, 44.01913, -6.5988> }
				triangle { <-0.5818, 43.03275, -6.2336>, <-0.02279, 44.01913, -6.5988>, <3.6632, 43.147, -1.1968> }
				triangle { <3.6632, 43.147, -1.1968>, <-0.5818, 43.03275, -6.2336>, <3.8182, 42.00428, -1.5974> }
				triangle { <3.6632, 43.147, -1.1968>, <3.8182, 42.00428, -1.5974>, <-0.5818, 43.03275, -6.2336> }
				triangle { <3.2842, 41.2452, -0.9781>, <2.9967, 40.6809, -0.67>, <1.796, 40.8124, 1.02027> }
				triangle { <3.2842, 41.2452, -0.9781>, <1.796, 40.8124, 1.02027>, <2.9967, 40.6809, -0.67> }
				triangle { <3.2842, 41.2452, -0.9781>, <3.9732, 40.8615, -1.998>, <2.9967, 40.6809, -0.67> }
				triangle { <3.2842, 41.2452, -0.9781>, <2.9967, 40.6809, -0.67>, <3.9732, 40.8615, -1.998> }
				triangle { <3.2842, 41.2452, -0.9781>, <3.8182, 42.00428, -1.5974>, <3.9732, 40.8615, -1.998> }
				triangle { <3.2842, 41.2452, -0.9781>, <3.9732, 40.8615, -1.998>, <3.8182, 42.00428, -1.5974> }
				triangle { <1.796, 40.8124, 1.02027>, <3.8182, 42.00428, -1.5974>, <3.2842, 41.2452, -0.9781> }
				triangle { <1.796, 40.8124, 1.02027>, <3.2842, 41.2452, -0.9781>, <3.8182, 42.00428, -1.5974> }
				triangle { <0.1631, 42.6478, -7.07957>, <1.214, 41.6933, -5.5872>, <3.9732, 40.8615, -1.998> }
				triangle { <0.1631, 42.6478, -7.07957>, <3.9732, 40.8615, -1.998>, <1.214, 41.6933, -5.5872> }
				triangle { <-0.5818, 43.03275, -6.2336>, <-0.6348, 43.4751, -7.5161>, <0.1631, 42.6478, -7.07957> }
				triangle { <-0.5818, 43.03275, -6.2336>, <0.1631, 42.6478, -7.07957>, <-0.6348, 43.4751, -7.5161> }
				triangle { <0.1631, 42.6478, -7.07957>, <3.9732, 40.8615, -1.998>, <-0.5818, 43.03275, -6.2336> }
				triangle { <0.1631, 42.6478, -7.07957>, <-0.5818, 43.03275, -6.2336>, <3.9732, 40.8615, -1.998> }
				triangle { <3.8182, 42.00428, -1.5974>, <-0.5818, 43.03275, -6.2336>, <3.9732, 40.8615, -1.998> }
				triangle { <3.8182, 42.00428, -1.5974>, <3.9732, 40.8615, -1.998>, <-0.5818, 43.03275, -6.2336> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <1.7538, 40.755, 1.09851>, <1.7475, 40.955, 0.9585>, 0.05549 }
				cylinder { <1.7475, 40.955, 0.9585>, <1.7412, 41.1549, 0.8185>, 0.05549 }
				cylinder { <1.7412, 41.1549, 0.8185>, <1.7348, 41.3549, 0.6785>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <1.7348, 41.3549, 0.6785>, <1.726, 41.3864, 0.6632>, 0.002463 }
				cylinder { <1.726, 41.3864, 0.6632>, <1.71, 41.4176, 0.6544>, 0.002463 }
				cylinder { <1.71, 41.4176, 0.6544>, <1.688, 41.4461, 0.6527>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <1.688, 41.4461, 0.6527>, <0.4442, 42.9375, 1.391>, <0.124, 43.4072, 0.9751> }
				triangle { <1.688, 41.4461, 0.6527>, <0.124, 43.4072, 0.9751>, <0.4442, 42.9375, 1.391> }
				triangle { <0.4442, 42.9375, 1.391>, <-0.578, 44.2047, 1.7054>, <0.124, 43.4072, 0.9751> }
				triangle { <0.4442, 42.9375, 1.391>, <0.124, 43.4072, 0.9751>, <-0.578, 44.2047, 1.7054> }
				triangle { <-0.578, 44.2047, 1.7054>, <-0.4598, 44.225, 0.4904>, <0.124, 43.4072, 0.9751> }
				triangle { <-0.578, 44.2047, 1.7054>, <0.124, 43.4072, 0.9751>, <-0.4598, 44.225, 0.4904> }
				triangle { <0.124, 43.4072, 0.9751>, <-0.4598, 44.225, 0.4904>, <1.688, 41.4461, 0.6527> }
				triangle { <0.124, 43.4072, 0.9751>, <1.688, 41.4461, 0.6527>, <-0.4598, 44.225, 0.4904> }
				triangle { <-0.578, 44.2047, 1.7054>, <-4.8715, 42.593, 1.3098>, <-6.7464, 42.1516, 0.5803> }
				triangle { <-0.578, 44.2047, 1.7054>, <-6.7464, 42.1516, 0.5803>, <-4.8715, 42.593, 1.3098> }
				triangle { <-6.7464, 42.1516, 0.5803>, <-7.5324, 41.6815, -0.24>, <-6.2238, 41.3408, -0.1185> }
				triangle { <-6.7464, 42.1516, 0.5803>, <-6.2238, 41.3408, -0.1185>, <-7.5324, 41.6815, -0.24> }
				triangle { <-6.2238, 41.3408, -0.1185>, <-0.578, 44.2047, 1.7054>, <-6.7464, 42.1516, 0.5803> }
				triangle { <-6.2238, 41.3408, -0.1185>, <-6.7464, 42.1516, 0.5803>, <-0.578, 44.2047, 1.7054> }
				triangle { <-0.578, 44.2047, 1.7054>, <-6.2238, 41.3408, -0.1185>, <-0.4598, 44.225, 0.4904> }
				triangle { <-0.578, 44.2047, 1.7054>, <-0.4598, 44.225, 0.4904>, <-6.2238, 41.3408, -0.1185> }
				triangle { <0.2091, 43.4219, 0.1004>, <0.6049, 42.9652, -0.2612>, <1.688, 41.4461, 0.6527> }
				triangle { <0.2091, 43.4219, 0.1004>, <1.688, 41.4461, 0.6527>, <0.6049, 42.9652, -0.2612> }
				triangle { <0.2091, 43.4219, 0.1004>, <-0.3417, 44.2454, -0.7244>, <0.6049, 42.9652, -0.2612> }
				triangle { <0.2091, 43.4219, 0.1004>, <0.6049, 42.9652, -0.2612>, <-0.3417, 44.2454, -0.7244> }
				triangle { <0.2091, 43.4219, 0.1004>, <-0.4598, 44.225, 0.4904>, <-0.3417, 44.2454, -0.7244> }
				triangle { <0.2091, 43.4219, 0.1004>, <-0.3417, 44.2454, -0.7244>, <-0.4598, 44.225, 0.4904> }
				triangle { <1.688, 41.4461, 0.6527>, <-0.4598, 44.225, 0.4904>, <0.2091, 43.4219, 0.1004> }
				triangle { <1.688, 41.4461, 0.6527>, <0.2091, 43.4219, 0.1004>, <-0.4598, 44.225, 0.4904> }
				triangle { <-6.6046, 42.1761, -0.8775>, <-4.6257, 42.6354, -1.2171>, <-0.3417, 44.2454, -0.7244> }
				triangle { <-6.6046, 42.1761, -0.8775>, <-0.3417, 44.2454, -0.7244>, <-4.6257, 42.6354, -1.2171> }
				triangle { <-6.2238, 41.3408, -0.1185>, <-7.5324, 41.6815, -0.24>, <-6.6046, 42.1761, -0.8775> }
				triangle { <-6.2238, 41.3408, -0.1185>, <-6.6046, 42.1761, -0.8775>, <-7.5324, 41.6815, -0.24> }
				triangle { <-6.6046, 42.1761, -0.8775>, <-0.3417, 44.2454, -0.7244>, <-6.2238, 41.3408, -0.1185> }
				triangle { <-6.6046, 42.1761, -0.8775>, <-6.2238, 41.3408, -0.1185>, <-0.3417, 44.2454, -0.7244> }
				triangle { <-0.4598, 44.225, 0.4904>, <-6.2238, 41.3408, -0.1185>, <-0.3417, 44.2454, -0.7244> }
				triangle { <-0.4598, 44.225, 0.4904>, <-0.3417, 44.2454, -0.7244>, <-6.2238, 41.3408, -0.1185> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <1.7348, 41.3549, 0.6785>, <1.7285, 41.5548, 0.5385>, 0.05549 }
				cylinder { <1.7285, 41.5548, 0.5385>, <1.7222, 41.7548, 0.3985>, 0.05549 }
				cylinder { <1.7222, 41.7548, 0.3985>, <1.7159, 41.9547, 0.2585>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <1.7159, 41.9547, 0.2585>, <1.7228, 41.9802, 0.2339>, 0.002463 }
				cylinder { <1.7228, 41.9802, 0.2339>, <1.7372, 41.9998, 0.2072>, 0.002463 }
				cylinder { <1.7372, 41.9998, 0.2072>, <1.758, 42.01213, 0.1803>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <1.758, 42.01213, 0.1803>, <2.748, 43.4348, -0.9651>, <3.1346, 43.2677, -1.5296> }
				triangle { <1.758, 42.01213, 0.1803>, <3.1346, 43.2677, -1.5296>, <2.748, 43.4348, -0.9651> }
				triangle { <2.748, 43.4348, -0.9651>, <3.6252, 44.3467, -2.03674>, <3.1346, 43.2677, -1.5296> }
				triangle { <2.748, 43.4348, -0.9651>, <3.1346, 43.2677, -1.5296>, <3.6252, 44.3467, -2.03674> }
				triangle { <3.6252, 44.3467, -2.03674>, <3.7802, 43.2039, -2.4373>, <3.1346, 43.2677, -1.5296> }
				triangle { <3.6252, 44.3467, -2.03674>, <3.1346, 43.2677, -1.5296>, <3.7802, 43.2039, -2.4373> }
				triangle { <3.1346, 43.2677, -1.5296>, <3.7802, 43.2039, -2.4373>, <1.758, 42.01213, 0.1803> }
				triangle { <3.1346, 43.2677, -1.5296>, <1.758, 42.01213, 0.1803>, <3.7802, 43.2039, -2.4373> }
				triangle { <3.6252, 44.3467, -2.03674>, <0.8537, 45.27, -5.5939>, <-0.06076, 45.2188, -7.4387> }
				triangle { <3.6252, 44.3467, -2.03674>, <-0.06076, 45.2188, -7.4387>, <0.8537, 45.27, -5.5939> }
				triangle { <-0.06076, 45.2188, -7.4387>, <-0.6728, 44.6748, -8.356>, <-0.6198, 44.2324, -7.07353> }
				triangle { <-0.06076, 45.2188, -7.4387>, <-0.6198, 44.2324, -7.07353>, <-0.6728, 44.6748, -8.356> }
				triangle { <-0.6198, 44.2324, -7.07353>, <3.6252, 44.3467, -2.03674>, <-0.06076, 45.2188, -7.4387> }
				triangle { <-0.6198, 44.2324, -7.07353>, <-0.06076, 45.2188, -7.4387>, <3.6252, 44.3467, -2.03674> }
				triangle { <3.6252, 44.3467, -2.03674>, <-0.6198, 44.2324, -7.07353>, <3.7802, 43.2039, -2.4373> }
				triangle { <3.6252, 44.3467, -2.03674>, <3.7802, 43.2039, -2.4373>, <-0.6198, 44.2324, -7.07353> }
				triangle { <3.2462, 42.4449, -1.818>, <2.9588, 41.8806, -1.5099>, <1.758, 42.01213, 0.1803> }
				triangle { <3.2462, 42.4449, -1.818>, <1.758, 42.01213, 0.1803>, <2.9588, 41.8806, -1.5099> }
				triangle { <3.2462, 42.4449, -1.818>, <3.9352, 42.06122, -2.8379>, <2.9588, 41.8806, -1.5099> }
				triangle { <3.2462, 42.4449, -1.818>, <2.9588, 41.8806, -1.5099>, <3.9352, 42.06122, -2.8379> }
				triangle { <3.2462, 42.4449, -1.818>, <3.7802, 43.2039, -2.4373>, <3.9352, 42.06122, -2.8379> }
				triangle { <3.2462, 42.4449, -1.818>, <3.9352, 42.06122, -2.8379>, <3.7802, 43.2039, -2.4373> }
				triangle { <1.758, 42.01213, 0.1803>, <3.7802, 43.2039, -2.4373>, <3.2462, 42.4449, -1.818> }
				triangle { <1.758, 42.01213, 0.1803>, <3.2462, 42.4449, -1.818>, <3.7802, 43.2039, -2.4373> }
				triangle { <0.1252, 43.8475, -7.9194>, <1.1761, 42.893, -6.4271>, <3.9352, 42.06122, -2.8379> }
				triangle { <0.1252, 43.8475, -7.9194>, <3.9352, 42.06122, -2.8379>, <1.1761, 42.893, -6.4271> }
				triangle { <-0.6198, 44.2324, -7.07353>, <-0.6728, 44.6748, -8.356>, <0.1252, 43.8475, -7.9194> }
				triangle { <-0.6198, 44.2324, -7.07353>, <0.1252, 43.8475, -7.9194>, <-0.6728, 44.6748, -8.356> }
				triangle { <0.1252, 43.8475, -7.9194>, <3.9352, 42.06122, -2.8379>, <-0.6198, 44.2324, -7.07353> }
				triangle { <0.1252, 43.8475, -7.9194>, <-0.6198, 44.2324, -7.07353>, <3.9352, 42.06122, -2.8379> }
				triangle { <3.7802, 43.2039, -2.4373>, <-0.6198, 44.2324, -7.07353>, <3.9352, 42.06122, -2.8379> }
				triangle { <3.7802, 43.2039, -2.4373>, <3.9352, 42.06122, -2.8379>, <-0.6198, 44.2324, -7.07353> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <1.7159, 41.9547, 0.2585>, <1.7149, 41.9843, 0.2378>, 0.002463 }
				cylinder { <1.7149, 41.9843, 0.2378>, <1.714, 42.01395, 0.2171>, 0.002463 }
				cylinder { <1.714, 42.01395, 0.2171>, <1.713, 42.04354, 0.1964>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <1.713, 42.04354, 0.1964>, <1.4013, 44.04927, -0.2463>, <1.5096, 44.3192, -0.8877> }
				triangle { <1.713, 42.04354, 0.1964>, <1.5096, 44.3192, -0.8877>, <1.4013, 44.04927, -0.2463> }
				triangle { <1.4013, 44.04927, -0.2463>, <1.2361, 45.5788, -0.8648>, <1.5096, 44.3192, -0.8877> }
				triangle { <1.4013, 44.04927, -0.2463>, <1.5096, 44.3192, -0.8877>, <1.2361, 45.5788, -0.8648> }
				triangle { <1.2361, 45.5788, -0.8648>, <1.6219, 44.9228, -1.8193>, <1.5096, 44.3192, -0.8877> }
				triangle { <1.2361, 45.5788, -0.8648>, <1.5096, 44.3192, -0.8877>, <1.6219, 44.9228, -1.8193> }
				triangle { <1.5096, 44.3192, -0.8877>, <1.6219, 44.9228, -1.8193>, <1.713, 42.04354, 0.1964> }
				triangle { <1.5096, 44.3192, -0.8877>, <1.713, 42.04354, 0.1964>, <1.6219, 44.9228, -1.8193> }
				triangle { <1.2361, 45.5788, -0.8648>, <-2.9829, 45.8394, -2.6868>, <-4.5482, 45.8665, -4.02526> }
				triangle { <1.2361, 45.5788, -0.8648>, <-4.5482, 45.8665, -4.02526>, <-2.9829, 45.8394, -2.6868> }
				triangle { <-4.5482, 45.8665, -4.02526>, <-5.2467, 45.3961, -4.9211>, <-4.4316, 44.6836, -4.1019> }
				triangle { <-4.5482, 45.8665, -4.02526>, <-4.4316, 44.6836, -4.1019>, <-5.2467, 45.3961, -4.9211> }
				triangle { <-4.4316, 44.6836, -4.1019>, <1.2361, 45.5788, -0.8648>, <-4.5482, 45.8665, -4.02526> }
				triangle { <-4.4316, 44.6836, -4.1019>, <-4.5482, 45.8665, -4.02526>, <1.2361, 45.5788, -0.8648> }
				triangle { <1.2361, 45.5788, -0.8648>, <-4.4316, 44.6836, -4.1019>, <1.6219, 44.9228, -1.8193> }
				triangle { <1.2361, 45.5788, -0.8648>, <1.6219, 44.9228, -1.8193>, <-4.4316, 44.6836, -4.1019> }
				triangle { <1.7874, 43.8468, -1.575>, <1.926, 43.157, -1.5445>, <1.713, 42.04354, 0.1964> }
				triangle { <1.7874, 43.8468, -1.575>, <1.713, 42.04354, 0.1964>, <1.926, 43.157, -1.5445> }
				triangle { <1.7874, 43.8468, -1.575>, <2.007795, 44.2667, -2.7738>, <1.926, 43.157, -1.5445> }
				triangle { <1.7874, 43.8468, -1.575>, <1.926, 43.157, -1.5445>, <2.007795, 44.2667, -2.7738> }
				triangle { <1.7874, 43.8468, -1.575>, <1.6219, 44.9228, -1.8193>, <2.007795, 44.2667, -2.7738> }
				triangle { <1.7874, 43.8468, -1.575>, <2.007795, 44.2667, -2.7738>, <1.6219, 44.9228, -1.8193> }
				triangle { <1.713, 42.04354, 0.1964>, <1.6219, 44.9228, -1.8193>, <1.7874, 43.8468, -1.575> }
				triangle { <1.713, 42.04354, 0.1964>, <1.7874, 43.8468, -1.575>, <1.6219, 44.9228, -1.8193> }
				triangle { <-4.08521, 45.0793, -5.1707>, <-2.1803, 44.4748, -4.6722>, <2.007795, 44.2667, -2.7738> }
				triangle { <-4.08521, 45.0793, -5.1707>, <2.007795, 44.2667, -2.7738>, <-2.1803, 44.4748, -4.6722> }
				triangle { <-4.4316, 44.6836, -4.1019>, <-5.2467, 45.3961, -4.9211>, <-4.08521, 45.0793, -5.1707> }
				triangle { <-4.4316, 44.6836, -4.1019>, <-4.08521, 45.0793, -5.1707>, <-5.2467, 45.3961, -4.9211> }
				triangle { <-4.08521, 45.0793, -5.1707>, <2.007795, 44.2667, -2.7738>, <-4.4316, 44.6836, -4.1019> }
				triangle { <-4.08521, 45.0793, -5.1707>, <-4.4316, 44.6836, -4.1019>, <2.007795, 44.2667, -2.7738> }
				triangle { <1.6219, 44.9228, -1.8193>, <-4.4316, 44.6836, -4.1019>, <2.007795, 44.2667, -2.7738> }
				triangle { <1.6219, 44.9228, -1.8193>, <2.007795, 44.2667, -2.7738>, <-4.4316, 44.6836, -4.1019> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <1.4064, 37.9638, 2.3126>, <1.847, 38.5326, 2.6931>, 0.05549 }
			cylinder { <1.847, 38.5326, 2.6931>, <2.3141, 38.9084, 3.2436>, 0.05549 }
			cylinder { <2.3141, 38.9084, 3.2436>, <2.7607, 39.05319, 3.9084>, 0.05549 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <2.7607, 39.05319, 3.9084>, <2.8946, 39.09662, 4.1079>, 0.05549 }
				cylinder { <2.8946, 39.09662, 4.1079>, <3.02864, 39.14, 4.3073>, 0.05549 }
				cylinder { <3.02864, 39.14, 4.3073>, <3.1626, 39.1834, 4.5068>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <3.1626, 39.1834, 4.5068>, <3.1738, 39.1926, 4.5399>, 0.002463 }
				cylinder { <3.1738, 39.1926, 4.5399>, <3.1756, 39.2039, 4.5741>, 0.002463 }
				cylinder { <3.1756, 39.2039, 4.5741>, <3.1678, 39.2165, 4.6071>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <3.1678, 39.2165, 4.6071>, <3.4839, 40.2842, 6.3611>, <3.01701, 40.2981, 6.8881> }
				triangle { <3.1678, 39.2165, 4.6071>, <3.01701, 40.2981, 6.8881>, <3.4839, 40.2842, 6.3611> }
				triangle { <3.4839, 40.2842, 6.3611>, <3.4791, 41.03581, 7.8391>, <3.01701, 40.2981, 6.8881> }
				triangle { <3.4839, 40.2842, 6.3611>, <3.01701, 40.2981, 6.8881>, <3.4791, 41.03581, 7.8391> }
				triangle { <3.4791, 41.03581, 7.8391>, <2.413, 40.4413, 7.8153>, <3.01701, 40.2981, 6.8881> }
				triangle { <3.4791, 41.03581, 7.8391>, <3.01701, 40.2981, 6.8881>, <2.413, 40.4413, 7.8153> }
				triangle { <3.01701, 40.2981, 6.8881>, <2.413, 40.4413, 7.8153>, <3.1678, 39.2165, 4.6071> }
				triangle { <3.01701, 40.2981, 6.8881>, <3.1678, 39.2165, 4.6071>, <2.413, 40.4413, 7.8153> }
				triangle { <3.4791, 41.03581, 7.8391>, <5.1509, 38.01563, 10.884>, <5.2941, 36.596, 12.3695> }
				triangle { <3.4791, 41.03581, 7.8391>, <5.2941, 36.596, 12.3695>, <5.1509, 38.01563, 10.884> }
				triangle { <5.2941, 36.596, 12.3695>, <5.05032, 35.5081, 12.888>, <4.9177, 35.7988, 11.5684> }
				triangle { <5.2941, 36.596, 12.3695>, <4.9177, 35.7988, 11.5684>, <5.05032, 35.5081, 12.888> }
				triangle { <4.9177, 35.7988, 11.5684>, <3.4791, 41.03581, 7.8391>, <5.2941, 36.596, 12.3695> }
				triangle { <4.9177, 35.7988, 11.5684>, <5.2941, 36.596, 12.3695>, <3.4791, 41.03581, 7.8391> }
				triangle { <3.4791, 41.03581, 7.8391>, <4.9177, 35.7988, 11.5684>, <2.413, 40.4413, 7.8153> }
				triangle { <3.4791, 41.03581, 7.8391>, <2.413, 40.4413, 7.8153>, <4.9177, 35.7988, 11.5684> }
				triangle { <2.2494, 39.8701, 6.8709>, <2.03411, 39.4757, 6.3286>, <3.1678, 39.2165, 4.6071> }
				triangle { <2.2494, 39.8701, 6.8709>, <3.1678, 39.2165, 4.6071>, <2.03411, 39.4757, 6.3286> }
				triangle { <2.2494, 39.8701, 6.8709>, <1.347, 39.8469, 7.7914>, <2.03411, 39.4757, 6.3286> }
				triangle { <2.2494, 39.8701, 6.8709>, <2.03411, 39.4757, 6.3286>, <1.347, 39.8469, 7.7914> }
				triangle { <2.2494, 39.8701, 6.8709>, <2.413, 40.4413, 7.8153>, <1.347, 39.8469, 7.7914> }
				triangle { <2.2494, 39.8701, 6.8709>, <1.347, 39.8469, 7.7914>, <2.413, 40.4413, 7.8153> }
				triangle { <3.1678, 39.2165, 4.6071>, <2.413, 40.4413, 7.8153>, <2.2494, 39.8701, 6.8709> }
				triangle { <3.1678, 39.2165, 4.6071>, <2.2494, 39.8701, 6.8709>, <2.413, 40.4413, 7.8153> }
				triangle { <4.01486, 35.8827, 12.3408>, <2.9335, 36.7791, 10.8344>, <1.347, 39.8469, 7.7914> }
				triangle { <4.01486, 35.8827, 12.3408>, <1.347, 39.8469, 7.7914>, <2.9335, 36.7791, 10.8344> }
				triangle { <4.9177, 35.7988, 11.5684>, <5.05032, 35.5081, 12.888>, <4.01486, 35.8827, 12.3408> }
				triangle { <4.9177, 35.7988, 11.5684>, <4.01486, 35.8827, 12.3408>, <5.05032, 35.5081, 12.888> }
				triangle { <4.01486, 35.8827, 12.3408>, <1.347, 39.8469, 7.7914>, <4.9177, 35.7988, 11.5684> }
				triangle { <4.01486, 35.8827, 12.3408>, <4.9177, 35.7988, 11.5684>, <1.347, 39.8469, 7.7914> }
				triangle { <2.413, 40.4413, 7.8153>, <4.9177, 35.7988, 11.5684>, <1.347, 39.8469, 7.7914> }
				triangle { <2.413, 40.4413, 7.8153>, <1.347, 39.8469, 7.7914>, <4.9177, 35.7988, 11.5684> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <3.1626, 39.1834, 4.5068>, <3.2965, 39.2269, 4.7062>, 0.05549 }
				cylinder { <3.2965, 39.2269, 4.7062>, <3.4305, 39.2703, 4.9057>, 0.05549 }
				cylinder { <3.4305, 39.2703, 4.9057>, <3.5645, 39.3137, 5.1051>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <3.5645, 39.3137, 5.1051>, <3.5915, 39.3169, 5.1289>, 0.002463 }
				cylinder { <3.5915, 39.3169, 5.1289>, <3.6237, 39.3167, 5.1453>, 0.002463 }
				cylinder { <3.6237, 39.3167, 5.1453>, <3.6588, 39.3129, 5.153>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <3.6588, 39.3129, 5.153>, <5.7037, 39.3491, 4.788>, <6.1812, 39.1794, 5.2771> }
				triangle { <3.6588, 39.3129, 5.153>, <6.1812, 39.1794, 5.2771>, <5.7037, 39.3491, 4.788> }
				triangle { <5.7037, 39.3491, 4.788>, <7.3608, 39.2925, 4.7694>, <6.1812, 39.1794, 5.2771> }
				triangle { <5.7037, 39.3491, 4.788>, <6.1812, 39.1794, 5.2771>, <7.3608, 39.2925, 4.7694> }
				triangle { <7.3608, 39.2925, 4.7694>, <7.07413, 38.9507, 5.9058>, <6.1812, 39.1794, 5.2771> }
				triangle { <7.3608, 39.2925, 4.7694>, <6.1812, 39.1794, 5.2771>, <7.07413, 38.9507, 5.9058> }
				triangle { <6.1812, 39.1794, 5.2771>, <7.07413, 38.9507, 5.9058>, <3.6588, 39.3129, 5.153> }
				triangle { <6.1812, 39.1794, 5.2771>, <3.6588, 39.3129, 5.153>, <7.07413, 38.9507, 5.9058> }
				triangle { <7.3608, 39.2925, 4.7694>, <8.5424, 34.9704, 3.7151>, <9.1576, 33.00997, 3.8578> }
				triangle { <7.3608, 39.2925, 4.7694>, <9.1576, 33.00997, 3.8578>, <8.5424, 34.9704, 3.7151> }
				triangle { <9.1576, 33.00997, 3.8578>, <9.09279, 31.8576, 4.2818>, <8.07908, 32.7606, 4.2976> }
				triangle { <9.1576, 33.00997, 3.8578>, <8.07908, 32.7606, 4.2976>, <9.09279, 31.8576, 4.2818> }
				triangle { <8.07908, 32.7606, 4.2976>, <7.3608, 39.2925, 4.7694>, <9.1576, 33.00997, 3.8578> }
				triangle { <8.07908, 32.7606, 4.2976>, <9.1576, 33.00997, 3.8578>, <7.3608, 39.2925, 4.7694> }
				triangle { <7.3608, 39.2925, 4.7694>, <8.07908, 32.7606, 4.2976>, <7.07413, 38.9507, 5.9058> }
				triangle { <7.3608, 39.2925, 4.7694>, <7.07413, 38.9507, 5.9058>, <8.07908, 32.7606, 4.2976> }
				triangle { <5.9747, 38.9333, 6.09536>, <5.3138, 38.8843, 6.3335>, <3.6588, 39.3129, 5.153> }
				triangle { <5.9747, 38.9333, 6.09536>, <3.6588, 39.3129, 5.153>, <5.3138, 38.8843, 6.3335> }
				triangle { <5.9747, 38.9333, 6.09536>, <6.7874, 38.6089, 7.0422>, <5.3138, 38.8843, 6.3335> }
				triangle { <5.9747, 38.9333, 6.09536>, <5.3138, 38.8843, 6.3335>, <6.7874, 38.6089, 7.0422> }
				triangle { <5.9747, 38.9333, 6.09536>, <7.07413, 38.9507, 5.9058>, <6.7874, 38.6089, 7.0422> }
				triangle { <5.9747, 38.9333, 6.09536>, <6.7874, 38.6089, 7.0422>, <7.07413, 38.9507, 5.9058> }
				triangle { <3.6588, 39.3129, 5.153>, <7.07413, 38.9507, 5.9058>, <5.9747, 38.9333, 6.09536> }
				triangle { <3.6588, 39.3129, 5.153>, <5.9747, 38.9333, 6.09536>, <7.07413, 38.9507, 5.9058> }
				triangle { <8.8135, 32.5998, 5.2215>, <7.946, 34.2595, 6.07886>, <6.7874, 38.6089, 7.0422> }
				triangle { <8.8135, 32.5998, 5.2215>, <6.7874, 38.6089, 7.0422>, <7.946, 34.2595, 6.07886> }
				triangle { <8.07908, 32.7606, 4.2976>, <9.09279, 31.8576, 4.2818>, <8.8135, 32.5998, 5.2215> }
				triangle { <8.07908, 32.7606, 4.2976>, <8.8135, 32.5998, 5.2215>, <9.09279, 31.8576, 4.2818> }
				triangle { <8.8135, 32.5998, 5.2215>, <6.7874, 38.6089, 7.0422>, <8.07908, 32.7606, 4.2976> }
				triangle { <8.8135, 32.5998, 5.2215>, <8.07908, 32.7606, 4.2976>, <6.7874, 38.6089, 7.0422> }
				triangle { <7.07413, 38.9507, 5.9058>, <8.07908, 32.7606, 4.2976>, <6.7874, 38.6089, 7.0422> }
				triangle { <7.07413, 38.9507, 5.9058>, <6.7874, 38.6089, 7.0422>, <8.07908, 32.7606, 4.2976> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <3.5645, 39.3137, 5.1051>, <3.6985, 39.3572, 5.3046>, 0.05549 }
				cylinder { <3.6985, 39.3572, 5.3046>, <3.8324, 39.4006, 5.504>, 0.05549 }
				cylinder { <3.8324, 39.4006, 5.504>, <3.9664, 39.4441, 5.7035>, 0.05549 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <3.9664, 39.4441, 5.7035>, <3.9776, 39.4532, 5.7366>, 0.002463 }
				cylinder { <3.9776, 39.4532, 5.7366>, <3.9794, 39.4646, 5.7708>, 0.002463 }
				cylinder { <3.9794, 39.4646, 5.7708>, <3.9717, 39.4771, 5.8038>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <3.9717, 39.4771, 5.8038>, <4.2877, 40.5448, 7.5578>, <3.8208, 40.5587, 8.0849> }
				triangle { <3.9717, 39.4771, 5.8038>, <3.8208, 40.5587, 8.0849>, <4.2877, 40.5448, 7.5578> }
				triangle { <4.2877, 40.5448, 7.5578>, <4.2829, 41.2964, 9.03589>, <3.8208, 40.5587, 8.0849> }
				triangle { <4.2877, 40.5448, 7.5578>, <3.8208, 40.5587, 8.0849>, <4.2829, 41.2964, 9.03589> }
				triangle { <4.2829, 41.2964, 9.03589>, <3.2169, 40.7019, 9.01202>, <3.8208, 40.5587, 8.0849> }
				triangle { <4.2829, 41.2964, 9.03589>, <3.8208, 40.5587, 8.0849>, <3.2169, 40.7019, 9.01202> }
				triangle { <3.8208, 40.5587, 8.0849>, <3.2169, 40.7019, 9.01202>, <3.9717, 39.4771, 5.8038> }
				triangle { <3.8208, 40.5587, 8.0849>, <3.9717, 39.4771, 5.8038>, <3.2169, 40.7019, 9.01202> }
				triangle { <4.2829, 41.2964, 9.03589>, <5.9548, 38.2762, 12.08077>, <6.09796, 36.8566, 13.5662> }
				triangle { <4.2829, 41.2964, 9.03589>, <6.09796, 36.8566, 13.5662>, <5.9548, 38.2762, 12.08077> }
				triangle { <6.09796, 36.8566, 13.5662>, <5.8541, 35.7687, 14.08476>, <5.7216, 36.05943, 12.7651> }
				triangle { <6.09796, 36.8566, 13.5662>, <5.7216, 36.05943, 12.7651>, <5.8541, 35.7687, 14.08476> }
				triangle { <5.7216, 36.05943, 12.7651>, <4.2829, 41.2964, 9.03589>, <6.09796, 36.8566, 13.5662> }
				triangle { <5.7216, 36.05943, 12.7651>, <6.09796, 36.8566, 13.5662>, <4.2829, 41.2964, 9.03589> }
				triangle { <4.2829, 41.2964, 9.03589>, <5.7216, 36.05943, 12.7651>, <3.2169, 40.7019, 9.01202> }
				triangle { <4.2829, 41.2964, 9.03589>, <3.2169, 40.7019, 9.01202>, <5.7216, 36.05943, 12.7651> }
				triangle { <3.05328, 40.1307, 8.06771>, <2.8379, 39.7363, 7.5253>, <3.9717, 39.4771, 5.8038> }
				triangle { <3.05328, 40.1307, 8.06771>, <3.9717, 39.4771, 5.8038>, <2.8379, 39.7363, 7.5253> }
				triangle { <3.05328, 40.1307, 8.06771>, <2.1508, 40.1075, 8.9881>, <2.8379, 39.7363, 7.5253> }
				triangle { <3.05328, 40.1307, 8.06771>, <2.8379, 39.7363, 7.5253>, <2.1508, 40.1075, 8.9881> }
				triangle { <3.05328, 40.1307, 8.06771>, <3.2169, 40.7019, 9.01202>, <2.1508, 40.1075, 8.9881> }
				triangle { <3.05328, 40.1307, 8.06771>, <2.1508, 40.1075, 8.9881>, <3.2169, 40.7019, 9.01202> }
				triangle { <3.9717, 39.4771, 5.8038>, <3.2169, 40.7019, 9.01202>, <3.05328, 40.1307, 8.06771> }
				triangle { <3.9717, 39.4771, 5.8038>, <3.05328, 40.1307, 8.06771>, <3.2169, 40.7019, 9.01202> }
				triangle { <4.8186, 36.1433, 13.5375>, <3.7373, 37.0398, 12.03112>, <2.1508, 40.1075, 8.9881> }
				triangle { <4.8186, 36.1433, 13.5375>, <2.1508, 40.1075, 8.9881>, <3.7373, 37.0398, 12.03112> }
				triangle { <5.7216, 36.05943, 12.7651>, <5.8541, 35.7687, 14.08476>, <4.8186, 36.1433, 13.5375> }
				triangle { <5.7216, 36.05943, 12.7651>, <4.8186, 36.1433, 13.5375>, <5.8541, 35.7687, 14.08476> }
				triangle { <4.8186, 36.1433, 13.5375>, <2.1508, 40.1075, 8.9881>, <5.7216, 36.05943, 12.7651> }
				triangle { <4.8186, 36.1433, 13.5375>, <5.7216, 36.05943, 12.7651>, <2.1508, 40.1075, 8.9881> }
				triangle { <3.2169, 40.7019, 9.01202>, <5.7216, 36.05943, 12.7651>, <2.1508, 40.1075, 8.9881> }
				triangle { <3.2169, 40.7019, 9.01202>, <2.1508, 40.1075, 8.9881>, <5.7216, 36.05943, 12.7651> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <3.9664, 39.4441, 5.7035>, <3.9862, 39.4505, 5.733>, 0.002463 }
				cylinder { <3.9862, 39.4505, 5.733>, <4.0061, 39.4569, 5.7625>, 0.002463 }
				cylinder { <4.0061, 39.4569, 5.7625>, <4.02592, 39.4633, 5.792>, 0.002463 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <4.02592, 39.4633, 5.792>, <5.7003, 40.05597, 6.8697>, <5.7256, 40.04077, 7.5734> }
				triangle { <4.02592, 39.4633, 5.792>, <5.7256, 40.04077, 7.5734>, <5.7003, 40.05597, 6.8697> }
				triangle { <5.7003, 40.05597, 6.8697>, <6.8807, 40.462, 7.9611>, <5.7256, 40.04077, 7.5734> }
				triangle { <5.7003, 40.05597, 6.8697>, <5.7256, 40.04077, 7.5734>, <6.8807, 40.462, 7.9611> }
				triangle { <6.8807, 40.462, 7.9611>, <5.9551, 40.08882, 8.6642>, <5.7256, 40.04077, 7.5734> }
				triangle { <6.8807, 40.462, 7.9611>, <5.7256, 40.04077, 7.5734>, <5.9551, 40.08882, 8.6642> }
				triangle { <5.7256, 40.04077, 7.5734>, <5.9551, 40.08882, 8.6642>, <4.02592, 39.4633, 5.792> }
				triangle { <5.7256, 40.04077, 7.5734>, <4.02592, 39.4633, 5.792>, <5.9551, 40.08882, 8.6642> }
				triangle { <6.8807, 40.462, 7.9611>, <9.2158, 36.6093, 8.9055>, <9.9004, 34.9028, 9.8335> }
				triangle { <6.8807, 40.462, 7.9611>, <9.9004, 34.9028, 9.8335>, <9.2158, 36.6093, 8.9055> }
				triangle { <9.9004, 34.9028, 9.8335>, <9.7693, 33.7913, 10.3429>, <8.8875, 34.3767, 9.4926> }
				triangle { <9.9004, 34.9028, 9.8335>, <8.8875, 34.3767, 9.4926>, <9.7693, 33.7913, 10.3429> }
				triangle { <8.8875, 34.3767, 9.4926>, <6.8807, 40.462, 7.9611>, <9.9004, 34.9028, 9.8335> }
				triangle { <8.8875, 34.3767, 9.4926>, <9.9004, 34.9028, 9.8335>, <6.8807, 40.462, 7.9611> }
				triangle { <6.8807, 40.462, 7.9611>, <8.8875, 34.3767, 9.4926>, <5.9551, 40.08882, 8.6642> }
				triangle { <6.8807, 40.462, 7.9611>, <5.9551, 40.08882, 8.6642>, <8.8875, 34.3767, 9.4926> }
				triangle { <5.05919, 39.772, 8.07959>, <4.4414, 39.5483, 7.8258>, <4.02592, 39.4633, 5.792> }
				triangle { <5.05919, 39.772, 8.07959>, <4.02592, 39.4633, 5.792>, <4.4414, 39.5483, 7.8258> }
				triangle { <5.05919, 39.772, 8.07959>, <5.02945, 39.7155, 9.3672>, <4.4414, 39.5483, 7.8258> }
				triangle { <5.05919, 39.772, 8.07959>, <4.4414, 39.5483, 7.8258>, <5.02945, 39.7155, 9.3672> }
				triangle { <5.05919, 39.772, 8.07959>, <5.9551, 40.08882, 8.6642>, <5.02945, 39.7155, 9.3672> }
				triangle { <5.05919, 39.772, 8.07959>, <5.02945, 39.7155, 9.3672>, <5.9551, 40.08882, 8.6642> }
				triangle { <4.02592, 39.4633, 5.792>, <5.9551, 40.08882, 8.6642>, <5.05919, 39.772, 8.07959> }
				triangle { <4.02592, 39.4633, 5.792>, <5.05919, 39.772, 8.07959>, <5.9551, 40.08882, 8.6642> }
				triangle { <8.7896, 34.4549, 10.6772>, <7.2905, 35.833, 10.3678>, <5.02945, 39.7155, 9.3672> }
				triangle { <8.7896, 34.4549, 10.6772>, <5.02945, 39.7155, 9.3672>, <7.2905, 35.833, 10.3678> }
				triangle { <8.8875, 34.3767, 9.4926>, <9.7693, 33.7913, 10.3429>, <8.7896, 34.4549, 10.6772> }
				triangle { <8.8875, 34.3767, 9.4926>, <8.7896, 34.4549, 10.6772>, <9.7693, 33.7913, 10.3429> }
				triangle { <8.7896, 34.4549, 10.6772>, <5.02945, 39.7155, 9.3672>, <8.8875, 34.3767, 9.4926> }
				triangle { <8.7896, 34.4549, 10.6772>, <8.8875, 34.3767, 9.4926>, <5.02945, 39.7155, 9.3672> }
				triangle { <5.9551, 40.08882, 8.6642>, <8.8875, 34.3767, 9.4926>, <5.02945, 39.7155, 9.3672> }
				triangle { <5.9551, 40.08882, 8.6642>, <5.02945, 39.7155, 9.3672>, <8.8875, 34.3767, 9.4926> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-2.4629, 27.7324, -0.06216>, <-2.9319, 29.3282, -0.134>, 0.3027 }
		cylinder { <-2.9319, 29.3282, -0.134>, <-3.676, 30.8041, -0.334>, 0.3027 }
		cylinder { <-3.676, 30.8041, -0.334>, <-4.6667, 32.1032, -0.6543>, 0.3027 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-4.6667, 32.1032, -0.6543>, <-5.7226, 32.8379, -1.04841>, 0.09172 }
			cylinder { <-5.7226, 32.8379, -1.04841>, <-6.9271, 33.1835, -1.538>, 0.09172 }
			cylinder { <-6.9271, 33.1835, -1.538>, <-8.1587, 33.1049, -2.07375>, 0.09172 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-8.1587, 33.1049, -2.07375>, <-8.5273, 33.07156, -2.2348>, 0.09172 }
				cylinder { <-8.5273, 33.07156, -2.2348>, <-8.8947, 33.02832, -2.3962>, 0.09172 }
				cylinder { <-8.8947, 33.02832, -2.3962>, <-9.2607, 32.9752, -2.5578>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-9.2607, 32.9752, -2.5578>, <-9.3366, 32.9647, -2.6201>, 0.006731 }
				cylinder { <-9.3366, 32.9647, -2.6201>, <-9.3934, 32.9573, -2.7005>, 0.006731 }
				cylinder { <-9.3934, 32.9573, -2.7005>, <-9.427, 32.9537, -2.7933>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-9.427, 32.9537, -2.7933>, <-11.6437, 33.4846, -5.3619>, <-11.4339, 33.1447, -6.4555> }
				triangle { <-9.427, 32.9537, -2.7933>, <-11.4339, 33.1447, -6.4555>, <-11.6437, 33.4846, -5.3619> }
				triangle { <-11.6437, 33.4846, -5.3619>, <-13.08912, 33.691, -7.6817>, <-11.4339, 33.1447, -6.4555> }
				triangle { <-11.6437, 33.4846, -5.3619>, <-11.4339, 33.1447, -6.4555>, <-13.08912, 33.691, -7.6817> }
				triangle { <-13.08912, 33.691, -7.6817>, <-11.4038, 32.7401, -8.2546>, <-11.4339, 33.1447, -6.4555> }
				triangle { <-13.08912, 33.691, -7.6817>, <-11.4339, 33.1447, -6.4555>, <-11.4038, 32.7401, -8.2546> }
				triangle { <-11.4339, 33.1447, -6.4555>, <-11.4038, 32.7401, -8.2546>, <-9.427, 32.9537, -2.7933> }
				triangle { <-11.4339, 33.1447, -6.4555>, <-9.427, 32.9537, -2.7933>, <-11.4038, 32.7401, -8.2546> }
				triangle { <-13.08912, 33.691, -7.6817>, <-17.06606, 27.2435, -8.3955>, <-18.08247, 24.1426, -9.3667> }
				triangle { <-13.08912, 33.691, -7.6817>, <-18.08247, 24.1426, -9.3667>, <-17.06606, 27.2435, -8.3955> }
				triangle { <-18.08247, 24.1426, -9.3667>, <-17.8516, 22.1404, -9.6297>, <-16.6543, 23.4151, -8.223> }
				triangle { <-18.08247, 24.1426, -9.3667>, <-16.6543, 23.4151, -8.223>, <-17.8516, 22.1404, -9.6297> }
				triangle { <-16.6543, 23.4151, -8.223>, <-13.08912, 33.691, -7.6817>, <-18.08247, 24.1426, -9.3667> }
				triangle { <-16.6543, 23.4151, -8.223>, <-18.08247, 24.1426, -9.3667>, <-13.08912, 33.691, -7.6817> }
				triangle { <-13.08912, 33.691, -7.6817>, <-16.6543, 23.4151, -8.223>, <-11.4038, 32.7401, -8.2546> }
				triangle { <-13.08912, 33.691, -7.6817>, <-11.4038, 32.7401, -8.2546>, <-16.6543, 23.4151, -8.223> }
				triangle { <-10.2205, 32.4601, -6.8679>, <-9.3517, 32.1914, -6.141>, <-9.427, 32.9537, -2.7933> }
				triangle { <-10.2205, 32.4601, -6.8679>, <-9.427, 32.9537, -2.7933>, <-9.3517, 32.1914, -6.141> }
				triangle { <-10.2205, 32.4601, -6.8679>, <-9.7185, 31.7893, -8.8274>, <-9.3517, 32.1914, -6.141> }
				triangle { <-10.2205, 32.4601, -6.8679>, <-9.3517, 32.1914, -6.141>, <-9.7185, 31.7893, -8.8274> }
				triangle { <-10.2205, 32.4601, -6.8679>, <-11.4038, 32.7401, -8.2546>, <-9.7185, 31.7893, -8.8274> }
				triangle { <-10.2205, 32.4601, -6.8679>, <-9.7185, 31.7893, -8.8274>, <-11.4038, 32.7401, -8.2546> }
				triangle { <-9.427, 32.9537, -2.7933>, <-11.4038, 32.7401, -8.2546>, <-10.2205, 32.4601, -6.8679> }
				triangle { <-9.427, 32.9537, -2.7933>, <-10.2205, 32.4601, -6.8679>, <-11.4038, 32.7401, -8.2546> }
				triangle { <-16.0601, 23.00164, -10.05414>, <-13.5606, 25.2658, -9.587>, <-9.7185, 31.7893, -8.8274> }
				triangle { <-16.0601, 23.00164, -10.05414>, <-9.7185, 31.7893, -8.8274>, <-13.5606, 25.2658, -9.587> }
				triangle { <-16.6543, 23.4151, -8.223>, <-17.8516, 22.1404, -9.6297>, <-16.0601, 23.00164, -10.05414> }
				triangle { <-16.6543, 23.4151, -8.223>, <-16.0601, 23.00164, -10.05414>, <-17.8516, 22.1404, -9.6297> }
				triangle { <-16.0601, 23.00164, -10.05414>, <-9.7185, 31.7893, -8.8274>, <-16.6543, 23.4151, -8.223> }
				triangle { <-16.0601, 23.00164, -10.05414>, <-16.6543, 23.4151, -8.223>, <-9.7185, 31.7893, -8.8274> }
				triangle { <-11.4038, 32.7401, -8.2546>, <-16.6543, 23.4151, -8.223>, <-9.7185, 31.7893, -8.8274> }
				triangle { <-11.4038, 32.7401, -8.2546>, <-9.7185, 31.7893, -8.8274>, <-16.6543, 23.4151, -8.223> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-9.2607, 32.9752, -2.5578>, <-9.6251, 32.9124, -2.7196>, 0.09172 }
				cylinder { <-9.6251, 32.9124, -2.7196>, <-9.9877, 32.8398, -2.8813>, 0.09172 }
				cylinder { <-9.9877, 32.8398, -2.8813>, <-10.3482, 32.7576, -3.043>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-10.3482, 32.7576, -3.043>, <-10.4436, 32.7362, -3.05698>, 0.006731 }
				cylinder { <-10.4436, 32.7362, -3.05698>, <-10.5393, 32.7152, -3.0444>, 0.006731 }
				cylinder { <-10.5393, 32.7152, -3.0444>, <-10.6282, 32.696, -3.006156>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-10.6282, 32.696, -3.006156>, <-13.2284, 32.988, -0.7818>, <-14.2128, 32.3741, -0.8794> }
				triangle { <-10.6282, 32.696, -3.006156>, <-14.2128, 32.3741, -0.8794>, <-13.2284, 32.988, -0.7818> }
				triangle { <-13.2284, 32.988, -0.7818>, <-15.5176, 32.8955, 0.7229>, <-14.2128, 32.3741, -0.8794> }
				triangle { <-13.2284, 32.988, -0.7818>, <-14.2128, 32.3741, -0.8794>, <-15.5176, 32.8955, 0.7229> }
				triangle { <-15.5176, 32.8955, 0.7229>, <-15.8659, 31.5659, -0.7546>, <-14.2128, 32.3741, -0.8794> }
				triangle { <-15.5176, 32.8955, 0.7229>, <-14.2128, 32.3741, -0.8794>, <-15.8659, 31.5659, -0.7546> }
				triangle { <-14.2128, 32.3741, -0.8794>, <-15.8659, 31.5659, -0.7546>, <-10.6282, 32.696, -3.006156> }
				triangle { <-14.2128, 32.3741, -0.8794>, <-10.6282, 32.696, -3.006156>, <-15.8659, 31.5659, -0.7546> }
				triangle { <-15.5176, 32.8955, 0.7229>, <-14.6519, 27.2297, 5.7273>, <-14.8543, 24.2074, 7.2819> }
				triangle { <-15.5176, 32.8955, 0.7229>, <-14.8543, 24.2074, 7.2819>, <-14.6519, 27.2297, 5.7273> }
				triangle { <-14.8543, 24.2074, 7.2819>, <-14.6397, 22.1893, 7.3935>, <-13.5849, 23.5318, 5.9369> }
				triangle { <-14.8543, 24.2074, 7.2819>, <-13.5849, 23.5318, 5.9369>, <-14.6397, 22.1893, 7.3935> }
				triangle { <-13.5849, 23.5318, 5.9369>, <-15.5176, 32.8955, 0.7229>, <-14.8543, 24.2074, 7.2819> }
				triangle { <-13.5849, 23.5318, 5.9369>, <-14.8543, 24.2074, 7.2819>, <-15.5176, 32.8955, 0.7229> }
				triangle { <-15.5176, 32.8955, 0.7229>, <-13.5849, 23.5318, 5.9369>, <-15.8659, 31.5659, -0.7546> }
				triangle { <-15.5176, 32.8955, 0.7229>, <-15.8659, 31.5659, -0.7546>, <-13.5849, 23.5318, 5.9369> }
				triangle { <-14.4636, 31.4168, -1.9433>, <-13.7021, 31.1797, -2.7913>, <-10.6282, 32.696, -3.006156> }
				triangle { <-14.4636, 31.4168, -1.9433>, <-10.6282, 32.696, -3.006156>, <-13.7021, 31.1797, -2.7913> }
				triangle { <-14.4636, 31.4168, -1.9433>, <-16.2142, 30.2363, -2.2322>, <-13.7021, 31.1797, -2.7913> }
				triangle { <-14.4636, 31.4168, -1.9433>, <-13.7021, 31.1797, -2.7913>, <-16.2142, 30.2363, -2.2322> }
				triangle { <-14.4636, 31.4168, -1.9433>, <-15.8659, 31.5659, -0.7546>, <-16.2142, 30.2363, -2.2322> }
				triangle { <-14.4636, 31.4168, -1.9433>, <-16.2142, 30.2363, -2.2322>, <-15.8659, 31.5659, -0.7546> }
				triangle { <-10.6282, 32.696, -3.006156>, <-15.8659, 31.5659, -0.7546>, <-14.4636, 31.4168, -1.9433> }
				triangle { <-10.6282, 32.696, -3.006156>, <-14.4636, 31.4168, -1.9433>, <-15.8659, 31.5659, -0.7546> }
				triangle { <-15.2723, 22.6118, 5.5088>, <-15.3764, 24.4641, 2.6539>, <-16.2142, 30.2363, -2.2322> }
				triangle { <-15.2723, 22.6118, 5.5088>, <-16.2142, 30.2363, -2.2322>, <-15.3764, 24.4641, 2.6539> }
				triangle { <-13.5849, 23.5318, 5.9369>, <-14.6397, 22.1893, 7.3935>, <-15.2723, 22.6118, 5.5088> }
				triangle { <-13.5849, 23.5318, 5.9369>, <-15.2723, 22.6118, 5.5088>, <-14.6397, 22.1893, 7.3935> }
				triangle { <-15.2723, 22.6118, 5.5088>, <-16.2142, 30.2363, -2.2322>, <-13.5849, 23.5318, 5.9369> }
				triangle { <-15.2723, 22.6118, 5.5088>, <-13.5849, 23.5318, 5.9369>, <-16.2142, 30.2363, -2.2322> }
				triangle { <-15.8659, 31.5659, -0.7546>, <-13.5849, 23.5318, 5.9369>, <-16.2142, 30.2363, -2.2322> }
				triangle { <-15.8659, 31.5659, -0.7546>, <-16.2142, 30.2363, -2.2322>, <-13.5849, 23.5318, 5.9369> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-10.3482, 32.7576, -3.043>, <-10.7088, 32.6753, -3.2046>, 0.09172 }
				cylinder { <-10.7088, 32.6753, -3.2046>, <-11.06941, 32.593, -3.3663>, 0.09172 }
				cylinder { <-11.06941, 32.593, -3.3663>, <-11.4299, 32.5108, -3.5279>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-11.4299, 32.5108, -3.5279>, <-11.5046, 32.4933, -3.5901>, 0.006731 }
				cylinder { <-11.5046, 32.4933, -3.5901>, <-11.5602, 32.4798, -3.6705>, 0.006731 }
				cylinder { <-11.5602, 32.4798, -3.6705>, <-11.5929, 32.4713, -3.7633>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-11.5929, 32.4713, -3.7633>, <-13.8237, 32.7772, -6.3563>, <-13.5845, 32.421, -7.4385> }
				triangle { <-11.5929, 32.4713, -3.7633>, <-13.5845, 32.421, -7.4385>, <-13.8237, 32.7772, -6.3563> }
				triangle { <-13.8237, 32.7772, -6.3563>, <-15.2647, 32.8188, -8.6876>, <-13.5845, 32.421, -7.4385> }
				triangle { <-13.8237, 32.7772, -6.3563>, <-13.5845, 32.421, -7.4385>, <-15.2647, 32.8188, -8.6876> }
				triangle { <-15.2647, 32.8188, -8.6876>, <-13.5155, 31.9677, -9.2249>, <-13.5845, 32.421, -7.4385> }
				triangle { <-15.2647, 32.8188, -8.6876>, <-13.5845, 32.421, -7.4385>, <-13.5155, 31.9677, -9.2249> }
				triangle { <-13.5845, 32.421, -7.4385>, <-13.5155, 31.9677, -9.2249>, <-11.5929, 32.4713, -3.7633> }
				triangle { <-13.5845, 32.421, -7.4385>, <-11.5929, 32.4713, -3.7633>, <-13.5155, 31.9677, -9.2249> }
				triangle { <-15.2647, 32.8188, -8.6876>, <-18.7939, 26.09986, -9.231>, <-19.5929, 22.9107, -10.116> }
				triangle { <-15.2647, 32.8188, -8.6876>, <-19.5929, 22.9107, -10.116>, <-18.7939, 26.09986, -9.231> }
				triangle { <-19.5929, 22.9107, -10.116>, <-19.2261, 20.9219, -10.3194>, <-18.1265, 22.3144, -8.9451> }
				triangle { <-19.5929, 22.9107, -10.116>, <-18.1265, 22.3144, -8.9451>, <-19.2261, 20.9219, -10.3194> }
				triangle { <-18.1265, 22.3144, -8.9451>, <-15.2647, 32.8188, -8.6876>, <-19.5929, 22.9107, -10.116> }
				triangle { <-18.1265, 22.3144, -8.9451>, <-19.5929, 22.9107, -10.116>, <-15.2647, 32.8188, -8.6876> }
				triangle { <-15.2647, 32.8188, -8.6876>, <-18.1265, 22.3144, -8.9451>, <-13.5155, 31.9677, -9.2249> }
				triangle { <-15.2647, 32.8188, -8.6876>, <-13.5155, 31.9677, -9.2249>, <-18.1265, 22.3144, -8.9451> }
				triangle { <-12.3251, 31.8082, -7.8254>, <-11.4449, 31.6198, -7.08709>, <-11.5929, 32.4713, -3.7633> }
				triangle { <-12.3251, 31.8082, -7.8254>, <-11.5929, 32.4713, -3.7633>, <-11.4449, 31.6198, -7.08709> }
				triangle { <-12.3251, 31.8082, -7.8254>, <-11.7664, 31.1167, -9.7622>, <-11.4449, 31.6198, -7.08709> }
				triangle { <-12.3251, 31.8082, -7.8254>, <-11.4449, 31.6198, -7.08709>, <-11.7664, 31.1167, -9.7622> }
				triangle { <-12.3251, 31.8082, -7.8254>, <-13.5155, 31.9677, -9.2249>, <-11.7664, 31.1167, -9.7622> }
				triangle { <-12.3251, 31.8082, -7.8254>, <-11.7664, 31.1167, -9.7622>, <-13.5155, 31.9677, -9.2249> }
				triangle { <-11.5929, 32.4713, -3.7633>, <-13.5155, 31.9677, -9.2249>, <-12.3251, 31.8082, -7.8254> }
				triangle { <-11.5929, 32.4713, -3.7633>, <-12.3251, 31.8082, -7.8254>, <-13.5155, 31.9677, -9.2249> }
				triangle { <-17.494, 21.8894, -10.7607>, <-15.1556, 24.3296, -10.3485>, <-11.7664, 31.1167, -9.7622> }
				triangle { <-17.494, 21.8894, -10.7607>, <-11.7664, 31.1167, -9.7622>, <-15.1556, 24.3296, -10.3485> }
				triangle { <-18.1265, 22.3144, -8.9451>, <-19.2261, 20.9219, -10.3194>, <-17.494, 21.8894, -10.7607> }
				triangle { <-18.1265, 22.3144, -8.9451>, <-17.494, 21.8894, -10.7607>, <-19.2261, 20.9219, -10.3194> }
				triangle { <-17.494, 21.8894, -10.7607>, <-11.7664, 31.1167, -9.7622>, <-18.1265, 22.3144, -8.9451> }
				triangle { <-17.494, 21.8894, -10.7607>, <-18.1265, 22.3144, -8.9451>, <-11.7664, 31.1167, -9.7622> }
				triangle { <-13.5155, 31.9677, -9.2249>, <-18.1265, 22.3144, -8.9451>, <-11.7664, 31.1167, -9.7622> }
				triangle { <-13.5155, 31.9677, -9.2249>, <-11.7664, 31.1167, -9.7622>, <-18.1265, 22.3144, -8.9451> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-11.4299, 32.5108, -3.5279>, <-11.5181, 32.4906, -3.5674>, 0.006731 }
				cylinder { <-11.5181, 32.4906, -3.5674>, <-11.6063, 32.4705, -3.607>, 0.006731 }
				cylinder { <-11.6063, 32.4705, -3.607>, <-11.6945, 32.4504, -3.6465>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-11.6945, 32.4504, -3.6465>, <-15.1179, 32.5247, -3.9088>, <-15.6957, 31.9903, -4.7667> }
				triangle { <-11.6945, 32.4504, -3.6465>, <-15.6957, 31.9903, -4.7667>, <-15.1179, 32.5247, -3.9088> }
				triangle { <-15.1179, 32.5247, -3.9088>, <-17.7852, 32.3187, -4.5057>, <-15.6957, 31.9903, -4.7667> }
				triangle { <-15.1179, 32.5247, -3.9088>, <-15.6957, 31.9903, -4.7667>, <-17.7852, 32.3187, -4.5057> }
				triangle { <-17.7852, 32.3187, -4.5057>, <-16.8866, 31.2658, -5.9742>, <-15.6957, 31.9903, -4.7667> }
				triangle { <-17.7852, 32.3187, -4.5057>, <-15.6957, 31.9903, -4.7667>, <-16.8866, 31.2658, -5.9742> }
				triangle { <-15.6957, 31.9903, -4.7667>, <-16.8866, 31.2658, -5.9742>, <-11.6945, 32.4504, -3.6465> }
				triangle { <-15.6957, 31.9903, -4.7667>, <-11.6945, 32.4504, -3.6465>, <-16.8866, 31.2658, -5.9742> }
				triangle { <-17.7852, 32.3187, -4.5057>, <-20.2808, 25.8818, -1.3068>, <-21.2925, 22.6646, -0.8394> }
				triangle { <-17.7852, 32.3187, -4.5057>, <-21.2925, 22.6646, -0.8394>, <-20.2808, 25.8818, -1.3068> }
				triangle { <-21.2925, 22.6646, -0.8394>, <-21.06758, 20.6461, -0.9185>, <-19.3979, 22.1449, -0.9714> }
				triangle { <-21.2925, 22.6646, -0.8394>, <-19.3979, 22.1449, -0.9714>, <-21.06758, 20.6461, -0.9185> }
				triangle { <-19.3979, 22.1449, -0.9714>, <-17.7852, 32.3187, -4.5057>, <-21.2925, 22.6646, -0.8394> }
				triangle { <-19.3979, 22.1449, -0.9714>, <-21.2925, 22.6646, -0.8394>, <-17.7852, 32.3187, -4.5057> }
				triangle { <-17.7852, 32.3187, -4.5057>, <-19.3979, 22.1449, -0.9714>, <-16.8866, 31.2658, -5.9742> }
				triangle { <-17.7852, 32.3187, -4.5057>, <-16.8866, 31.2658, -5.9742>, <-19.3979, 22.1449, -0.9714> }
				triangle { <-15.04879, 31.2323, -5.824>, <-13.8959, 31.09282, -5.906>, <-11.6945, 32.4504, -3.6465> }
				triangle { <-15.04879, 31.2323, -5.824>, <-11.6945, 32.4504, -3.6465>, <-13.8959, 31.09282, -5.906> }
				triangle { <-15.04879, 31.2323, -5.824>, <-15.988, 30.2129, -7.4427>, <-13.8959, 31.09282, -5.906> }
				triangle { <-15.04879, 31.2323, -5.824>, <-13.8959, 31.09282, -5.906>, <-15.988, 30.2129, -7.4427> }
				triangle { <-15.04879, 31.2323, -5.824>, <-16.8866, 31.2658, -5.9742>, <-15.988, 30.2129, -7.4427> }
				triangle { <-15.04879, 31.2323, -5.824>, <-15.988, 30.2129, -7.4427>, <-16.8866, 31.2658, -5.9742> }
				triangle { <-11.6945, 32.4504, -3.6465>, <-16.8866, 31.2658, -5.9742>, <-15.04879, 31.2323, -5.824> }
				triangle { <-11.6945, 32.4504, -3.6465>, <-15.04879, 31.2323, -5.824>, <-16.8866, 31.2658, -5.9742> }
				triangle { <-20.2142, 21.4012, -2.6016>, <-18.4118, 23.6918, -4.3613>, <-15.988, 30.2129, -7.4427> }
				triangle { <-20.2142, 21.4012, -2.6016>, <-15.988, 30.2129, -7.4427>, <-18.4118, 23.6918, -4.3613> }
				triangle { <-19.3979, 22.1449, -0.9714>, <-21.06758, 20.6461, -0.9185>, <-20.2142, 21.4012, -2.6016> }
				triangle { <-19.3979, 22.1449, -0.9714>, <-20.2142, 21.4012, -2.6016>, <-21.06758, 20.6461, -0.9185> }
				triangle { <-20.2142, 21.4012, -2.6016>, <-15.988, 30.2129, -7.4427>, <-19.3979, 22.1449, -0.9714> }
				triangle { <-20.2142, 21.4012, -2.6016>, <-19.3979, 22.1449, -0.9714>, <-15.988, 30.2129, -7.4427> }
				triangle { <-16.8866, 31.2658, -5.9742>, <-19.3979, 22.1449, -0.9714>, <-15.988, 30.2129, -7.4427> }
				triangle { <-16.8866, 31.2658, -5.9742>, <-15.988, 30.2129, -7.4427>, <-19.3979, 22.1449, -0.9714> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-4.6667, 32.1032, -0.6543>, <-5.1313, 33.362, -0.7517>, 0.09172 }
			cylinder { <-5.1313, 33.362, -0.7517>, <-5.2128, 34.7029, -0.6778>, 0.09172 }
			cylinder { <-5.2128, 34.7029, -0.6778>, <-4.9032, 35.9904, -0.4401>, 0.09172 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-4.9032, 35.9904, -0.4401>, <-4.8015, 36.3738, -0.3653>, 0.09172 }
				cylinder { <-4.8015, 36.3738, -0.3653>, <-4.6911, 36.754, -0.287>, 0.09172 }
				cylinder { <-4.6911, 36.754, -0.287>, <-4.5721, 37.1309, -0.2052>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-4.5721, 37.1309, -0.2052>, <-4.5544, 37.2178, -0.1618>, 0.006731 }
				cylinder { <-4.5544, 37.2178, -0.1618>, <-4.5494, 37.293, -0.09816>, 0.006731 }
				cylinder { <-4.5494, 37.293, -0.09816>, <-4.5574, 37.3513, -0.01885>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-4.5574, 37.3513, -0.01885>, <-4.9918, 40.2967, 1.6927>, <-4.9878, 40.3562, 2.8554> }
				triangle { <-4.5574, 37.3513, -0.01885>, <-4.9878, 40.3562, 2.8554>, <-4.9918, 40.2967, 1.6927> }
				triangle { <-4.9918, 40.2967, 1.6927>, <-5.2929, 42.3804, 3.4479>, <-4.9878, 40.3562, 2.8554> }
				triangle { <-4.9918, 40.2967, 1.6927>, <-4.9878, 40.3562, 2.8554>, <-5.2929, 42.3804, 3.4479> }
				triangle { <-5.2929, 42.3804, 3.4479>, <-5.0328, 40.7802, 4.6497>, <-4.9878, 40.3562, 2.8554> }
				triangle { <-5.2929, 42.3804, 3.4479>, <-4.9878, 40.3562, 2.8554>, <-5.0328, 40.7802, 4.6497> }
				triangle { <-4.9878, 40.3562, 2.8554>, <-5.0328, 40.7802, 4.6497>, <-4.5574, 37.3513, -0.01885> }
				triangle { <-4.9878, 40.3562, 2.8554>, <-4.5574, 37.3513, -0.01885>, <-5.0328, 40.7802, 4.6497> }
				triangle { <-5.2929, 42.3804, 3.4479>, <1.6915, 44.884, 5.134>, <4.6455, 45.4443, 6.7315> }
				triangle { <-5.2929, 42.3804, 3.4479>, <4.6455, 45.4443, 6.7315>, <1.6915, 44.884, 5.134> }
				triangle { <4.6455, 45.4443, 6.7315>, <6.3773, 44.8729, 7.629>, <5.1663, 43.6162, 6.2179> }
				triangle { <4.6455, 45.4443, 6.7315>, <5.1663, 43.6162, 6.2179>, <6.3773, 44.8729, 7.629> }
				triangle { <5.1663, 43.6162, 6.2179>, <-5.2929, 42.3804, 3.4479>, <4.6455, 45.4443, 6.7315> }
				triangle { <5.1663, 43.6162, 6.2179>, <4.6455, 45.4443, 6.7315>, <-5.2929, 42.3804, 3.4479> }
				triangle { <-5.2929, 42.3804, 3.4479>, <5.1663, 43.6162, 6.2179>, <-5.0328, 40.7802, 4.6497> }
				triangle { <-5.2929, 42.3804, 3.4479>, <-5.0328, 40.7802, 4.6497>, <5.1663, 43.6162, 6.2179> }
				triangle { <-4.8005, 39.204, 3.7207>, <-4.638, 38.1205, 3.3271>, <-4.5574, 37.3513, -0.01885> }
				triangle { <-4.8005, 39.204, 3.7207>, <-4.5574, 37.3513, -0.01885>, <-4.638, 38.1205, 3.3271> }
				triangle { <-4.8005, 39.204, 3.7207>, <-4.7726, 39.18, 5.8515>, <-4.638, 38.1205, 3.3271> }
				triangle { <-4.8005, 39.204, 3.7207>, <-4.638, 38.1205, 3.3271>, <-4.7726, 39.18, 5.8515> }
				triangle { <-4.8005, 39.204, 3.7207>, <-5.0328, 40.7802, 4.6497>, <-4.7726, 39.18, 5.8515> }
				triangle { <-4.8005, 39.204, 3.7207>, <-4.7726, 39.18, 5.8515>, <-5.0328, 40.7802, 4.6497> }
				triangle { <-4.5574, 37.3513, -0.01885>, <-5.0328, 40.7802, 4.6497>, <-4.8005, 39.204, 3.7207> }
				triangle { <-4.5574, 37.3513, -0.01885>, <-4.8005, 39.204, 3.7207>, <-5.0328, 40.7802, 4.6497> }
				triangle { <4.9577, 43.5241, 8.1737>, <2.2327, 41.5556, 7.6336>, <-4.7726, 39.18, 5.8515> }
				triangle { <4.9577, 43.5241, 8.1737>, <-4.7726, 39.18, 5.8515>, <2.2327, 41.5556, 7.6336> }
				triangle { <5.1663, 43.6162, 6.2179>, <6.3773, 44.8729, 7.629>, <4.9577, 43.5241, 8.1737> }
				triangle { <5.1663, 43.6162, 6.2179>, <4.9577, 43.5241, 8.1737>, <6.3773, 44.8729, 7.629> }
				triangle { <4.9577, 43.5241, 8.1737>, <-4.7726, 39.18, 5.8515>, <5.1663, 43.6162, 6.2179> }
				triangle { <4.9577, 43.5241, 8.1737>, <5.1663, 43.6162, 6.2179>, <-4.7726, 39.18, 5.8515> }
				triangle { <-5.0328, 40.7802, 4.6497>, <5.1663, 43.6162, 6.2179>, <-4.7726, 39.18, 5.8515> }
				triangle { <-5.0328, 40.7802, 4.6497>, <-4.7726, 39.18, 5.8515>, <5.1663, 43.6162, 6.2179> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-4.5721, 37.1309, -0.2052>, <-4.4444, 37.5042, -0.12>, 0.09172 }
				cylinder { <-4.4444, 37.5042, -0.12>, <-4.3083, 37.8737, -0.03151>, 0.09172 }
				cylinder { <-4.3083, 37.8737, -0.03151>, <-4.1637, 38.2391, 0.06031>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-4.1637, 38.2391, 0.06031>, <-4.1192, 38.3272, 0.05783>, 0.006731 }
				cylinder { <-4.1192, 38.3272, 0.05783>, <-4.06894, 38.4077, 0.0306>, 0.006731 }
				cylinder { <-4.06894, 38.4077, 0.0306>, <-4.0164, 38.4747, -0.01942>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-4.0164, 38.4747, -0.01942>, <-3.01964, 40.2852, -2.7621>, <-2.1847, 41.09509, -2.7128> }
				triangle { <-4.0164, 38.4747, -0.01942>, <-2.1847, 41.09509, -2.7128>, <-3.01964, 40.2852, -2.7621> }
				triangle { <-3.01964, 40.2852, -2.7621>, <-1.9213, 41.9392, -4.6518>, <-2.1847, 41.09509, -2.7128> }
				triangle { <-3.01964, 40.2852, -2.7621>, <-2.1847, 41.09509, -2.7128>, <-1.9213, 41.9392, -4.6518> }
				triangle { <-1.9213, 41.9392, -4.6518>, <-0.9232, 42.4167, -2.9641>, <-2.1847, 41.09509, -2.7128> }
				triangle { <-1.9213, 41.9392, -4.6518>, <-2.1847, 41.09509, -2.7128>, <-0.9232, 42.4167, -2.9641> }
				triangle { <-2.1847, 41.09509, -2.7128>, <-0.9232, 42.4167, -2.9641>, <-4.0164, 38.4747, -0.01942> }
				triangle { <-2.1847, 41.09509, -2.7128>, <-4.0164, 38.4747, -0.01942>, <-0.9232, 42.4167, -2.9641> }
				triangle { <-1.9213, 41.9392, -4.6518>, <4.2336, 38.3991, -7.3866>, <7.4553, 37.4622, -7.9651> }
				triangle { <-1.9213, 41.9392, -4.6518>, <7.4553, 37.4622, -7.9651>, <4.2336, 38.3991, -7.3866> }
				triangle { <7.4553, 37.4622, -7.9651>, <9.2924, 36.7899, -7.4135>, <7.4043, 36.54, -6.2262> }
				triangle { <7.4553, 37.4622, -7.9651>, <7.4043, 36.54, -6.2262>, <9.2924, 36.7899, -7.4135> }
				triangle { <7.4043, 36.54, -6.2262>, <-1.9213, 41.9392, -4.6518>, <7.4553, 37.4622, -7.9651> }
				triangle { <7.4043, 36.54, -6.2262>, <7.4553, 37.4622, -7.9651>, <-1.9213, 41.9392, -4.6518> }
				triangle { <-1.9213, 41.9392, -4.6518>, <7.4043, 36.54, -6.2262>, <-0.9232, 42.4167, -2.9641> }
				triangle { <-1.9213, 41.9392, -4.6518>, <-0.9232, 42.4167, -2.9641>, <7.4043, 36.54, -6.2262> }
				triangle { <-1.4661, 41.4389, -1.4977>, <-1.6622, 40.9347, -0.4668>, <-4.0164, 38.4747, -0.01942> }
				triangle { <-1.4661, 41.4389, -1.4977>, <-4.0164, 38.4747, -0.01942>, <-1.6622, 40.9347, -0.4668> }
				triangle { <-1.4661, 41.4389, -1.4977>, <0.07484, 42.8943, -1.2764>, <-1.6622, 40.9347, -0.4668> }
				triangle { <-1.4661, 41.4389, -1.4977>, <-1.6622, 40.9347, -0.4668>, <0.07484, 42.8943, -1.2764> }
				triangle { <-1.4661, 41.4389, -1.4977>, <-0.9232, 42.4167, -2.9641>, <0.07484, 42.8943, -1.2764> }
				triangle { <-1.4661, 41.4389, -1.4977>, <0.07484, 42.8943, -1.2764>, <-0.9232, 42.4167, -2.9641> }
				triangle { <-4.0164, 38.4747, -0.01942>, <-0.9232, 42.4167, -2.9641>, <-1.4661, 41.4389, -1.4977> }
				triangle { <-4.0164, 38.4747, -0.01942>, <-1.4661, 41.4389, -1.4977>, <-0.9232, 42.4167, -2.9641> }
				triangle { <8.653, 38.03534, -5.9399>, <6.3096, 39.3924, -3.8763>, <0.07484, 42.8943, -1.2764> }
				triangle { <8.653, 38.03534, -5.9399>, <0.07484, 42.8943, -1.2764>, <6.3096, 39.3924, -3.8763> }
				triangle { <7.4043, 36.54, -6.2262>, <9.2924, 36.7899, -7.4135>, <8.653, 38.03534, -5.9399> }
				triangle { <7.4043, 36.54, -6.2262>, <8.653, 38.03534, -5.9399>, <9.2924, 36.7899, -7.4135> }
				triangle { <8.653, 38.03534, -5.9399>, <0.07484, 42.8943, -1.2764>, <7.4043, 36.54, -6.2262> }
				triangle { <8.653, 38.03534, -5.9399>, <7.4043, 36.54, -6.2262>, <0.07484, 42.8943, -1.2764> }
				triangle { <-0.9232, 42.4167, -2.9641>, <7.4043, 36.54, -6.2262>, <0.07484, 42.8943, -1.2764> }
				triangle { <-0.9232, 42.4167, -2.9641>, <0.07484, 42.8943, -1.2764>, <7.4043, 36.54, -6.2262> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-4.1637, 38.2391, 0.06031>, <-4.01913, 38.6046, 0.1521>, 0.09172 }
				cylinder { <-4.01913, 38.6046, 0.1521>, <-3.8745, 38.97, 0.2439>, 0.09172 }
				cylinder { <-3.8745, 38.97, 0.2439>, <-3.7299, 39.3355, 0.3357>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-3.7299, 39.3355, 0.3357>, <-3.7062, 39.4197, 0.3815>, 0.006731 }
				cylinder { <-3.7062, 39.4197, 0.3815>, <-3.6958, 39.4926, 0.4473>, 0.006731 }
				cylinder { <-3.6958, 39.4926, 0.4473>, <-3.6996, 39.5489, 0.5283>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-3.6996, 39.5489, 0.5283>, <-3.9265, 42.4658, 2.3267>, <-3.9133, 42.4909, 3.4906> }
				triangle { <-3.6996, 39.5489, 0.5283>, <-3.9133, 42.4909, 3.4906>, <-3.9265, 42.4658, 2.3267> }
				triangle { <-3.9265, 42.4658, 2.3267>, <-4.07851, 44.5129, 4.1431>, <-3.9133, 42.4909, 3.4906> }
				triangle { <-3.9265, 42.4658, 2.3267>, <-3.9133, 42.4909, 3.4906>, <-4.07851, 44.5129, 4.1431> }
				triangle { <-4.07851, 44.5129, 4.1431>, <-3.9215, 42.8645, 5.2966>, <-3.9133, 42.4909, 3.4906> }
				triangle { <-4.07851, 44.5129, 4.1431>, <-3.9133, 42.4909, 3.4906>, <-3.9215, 42.8645, 5.2966> }
				triangle { <-3.9133, 42.4909, 3.4906>, <-3.9215, 42.8645, 5.2966>, <-3.6996, 39.5489, 0.5283> }
				triangle { <-3.9133, 42.4909, 3.4906>, <-3.6996, 39.5489, 0.5283>, <-3.9215, 42.8645, 5.2966> }
				triangle { <-4.07851, 44.5129, 4.1431>, <3.06658, 46.4905, 5.8554>, <6.05876, 46.8038, 7.4494> }
				triangle { <-4.07851, 44.5129, 4.1431>, <6.05876, 46.8038, 7.4494>, <3.06658, 46.4905, 5.8554> }
				triangle { <6.05876, 46.8038, 7.4494>, <7.752, 46.09122, 8.3188>, <6.4527, 44.9605, 6.88> }
				triangle { <6.05876, 46.8038, 7.4494>, <6.4527, 44.9605, 6.88>, <7.752, 46.09122, 8.3188> }
				triangle { <6.4527, 44.9605, 6.88>, <-4.07851, 44.5129, 4.1431>, <6.05876, 46.8038, 7.4494> }
				triangle { <6.4527, 44.9605, 6.88>, <6.05876, 46.8038, 7.4494>, <-4.07851, 44.5129, 4.1431> }
				triangle { <-4.07851, 44.5129, 4.1431>, <6.4527, 44.9605, 6.88>, <-3.9215, 42.8645, 5.2966> }
				triangle { <-4.07851, 44.5129, 4.1431>, <-3.9215, 42.8645, 5.2966>, <6.4527, 44.9605, 6.88> }
				triangle { <-3.8002, 41.304, 4.3211>, <-3.713, 40.2239, 3.8955>, <-3.6996, 39.5489, 0.5283> }
				triangle { <-3.8002, 41.304, 4.3211>, <-3.6996, 39.5489, 0.5283>, <-3.713, 40.2239, 3.8955> }
				triangle { <-3.8002, 41.304, 4.3211>, <-3.7645, 41.2161, 6.4501>, <-3.713, 40.2239, 3.8955> }
				triangle { <-3.8002, 41.304, 4.3211>, <-3.713, 40.2239, 3.8955>, <-3.7645, 41.2161, 6.4501> }
				triangle { <-3.8002, 41.304, 4.3211>, <-3.9215, 42.8645, 5.2966>, <-3.7645, 41.2161, 6.4501> }
				triangle { <-3.8002, 41.304, 4.3211>, <-3.7645, 41.2161, 6.4501>, <-3.9215, 42.8645, 5.2966> }
				triangle { <-3.6996, 39.5489, 0.5283>, <-3.9215, 42.8645, 5.2966>, <-3.8002, 41.304, 4.3211> }
				triangle { <-3.6996, 39.5489, 0.5283>, <-3.8002, 41.304, 4.3211>, <-3.9215, 42.8645, 5.2966> }
				triangle { <6.2471, 44.8257, 8.8336>, <3.3931, 43.06179, 8.2547>, <-3.7645, 41.2161, 6.4501> }
				triangle { <6.2471, 44.8257, 8.8336>, <-3.7645, 41.2161, 6.4501>, <3.3931, 43.06179, 8.2547> }
				triangle { <6.4527, 44.9605, 6.88>, <7.752, 46.09122, 8.3188>, <6.2471, 44.8257, 8.8336> }
				triangle { <6.4527, 44.9605, 6.88>, <6.2471, 44.8257, 8.8336>, <7.752, 46.09122, 8.3188> }
				triangle { <6.2471, 44.8257, 8.8336>, <-3.7645, 41.2161, 6.4501>, <6.4527, 44.9605, 6.88> }
				triangle { <6.2471, 44.8257, 8.8336>, <6.4527, 44.9605, 6.88>, <-3.7645, 41.2161, 6.4501> }
				triangle { <-3.9215, 42.8645, 5.2966>, <6.4527, 44.9605, 6.88>, <-3.7645, 41.2161, 6.4501> }
				triangle { <-3.9215, 42.8645, 5.2966>, <-3.7645, 41.2161, 6.4501>, <6.4527, 44.9605, 6.88> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-3.7299, 39.3355, 0.3357>, <-3.6945, 39.4249, 0.3582>, 0.006731 }
				cylinder { <-3.6945, 39.4249, 0.3582>, <-3.6592, 39.5143, 0.3807>, 0.006731 }
				cylinder { <-3.6592, 39.5143, 0.3807>, <-3.6238, 39.6037, 0.4031>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-3.6238, 39.6037, 0.4031>, <-2.754, 42.8779, -0.16>, <-2.2856, 43.5557, 0.6624> }
				triangle { <-3.6238, 39.6037, 0.4031>, <-2.2856, 43.5557, 0.6624>, <-2.754, 42.8779, -0.16> }
				triangle { <-2.754, 42.8779, -0.16>, <-1.9212, 45.4893, -0.1561>, <-2.2856, 43.5557, 0.6624> }
				triangle { <-2.754, 42.8779, -0.16>, <-2.2856, 43.5557, 0.6624>, <-1.9212, 45.4893, -0.1561> }
				triangle { <-1.9212, 45.4893, -0.1561>, <-1.5418, 44.8664, 1.7254>, <-2.2856, 43.5557, 0.6624> }
				triangle { <-1.9212, 45.4893, -0.1561>, <-2.2856, 43.5557, 0.6624>, <-1.5418, 44.8664, 1.7254> }
				triangle { <-2.2856, 43.5557, 0.6624>, <-1.5418, 44.8664, 1.7254>, <-3.6238, 39.6037, 0.4031> }
				triangle { <-2.2856, 43.5557, 0.6624>, <-3.6238, 39.6037, 0.4031>, <-1.5418, 44.8664, 1.7254> }
				triangle { <-1.9212, 45.4893, -0.1561>, <5.5171, 45.4449, -1.7572>, <8.907, 45.5435, -1.4557> }
				triangle { <-1.9212, 45.4893, -0.1561>, <8.907, 45.5435, -1.4557>, <5.5171, 45.4449, -1.7572> }
				triangle { <8.907, 45.5435, -1.4557>, <10.6979, 44.9188, -0.7249>, <8.8067, 43.7105, -0.7436> }
				triangle { <8.907, 45.5435, -1.4557>, <8.8067, 43.7105, -0.7436>, <10.6979, 44.9188, -0.7249> }
				triangle { <8.8067, 43.7105, -0.7436>, <-1.9212, 45.4893, -0.1561>, <8.907, 45.5435, -1.4557> }
				triangle { <8.8067, 43.7105, -0.7436>, <8.907, 45.5435, -1.4557>, <-1.9212, 45.4893, -0.1561> }
				triangle { <-1.9212, 45.4893, -0.1561>, <8.8067, 43.7105, -0.7436>, <-1.5418, 44.8664, 1.7254> }
				triangle { <-1.9212, 45.4893, -0.1561>, <-1.5418, 44.8664, 1.7254>, <8.8067, 43.7105, -0.7436> }
				triangle { <-2.01249, 43.1072, 2.01721>, <-2.238, 42.0308, 2.3989>, <-3.6238, 39.6037, 0.4031> }
				triangle { <-2.01249, 43.1072, 2.01721>, <-3.6238, 39.6037, 0.4031>, <-2.238, 42.0308, 2.3989> }
				triangle { <-2.01249, 43.1072, 2.01721>, <-1.1624, 44.2435, 3.6071>, <-2.238, 42.0308, 2.3989> }
				triangle { <-2.01249, 43.1072, 2.01721>, <-2.238, 42.0308, 2.3989>, <-1.1624, 44.2435, 3.6071> }
				triangle { <-2.01249, 43.1072, 2.01721>, <-1.5418, 44.8664, 1.7254>, <-1.1624, 44.2435, 3.6071> }
				triangle { <-2.01249, 43.1072, 2.01721>, <-1.1624, 44.2435, 3.6071>, <-1.5418, 44.8664, 1.7254> }
				triangle { <-3.6238, 39.6037, 0.4031>, <-1.5418, 44.8664, 1.7254>, <-2.01249, 43.1072, 2.01721> }
				triangle { <-3.6238, 39.6037, 0.4031>, <-2.01249, 43.1072, 2.01721>, <-1.5418, 44.8664, 1.7254> }
				triangle { <9.3623, 44.796, 0.8022>, <6.3063, 44.1493, 2.1566>, <-1.1624, 44.2435, 3.6071> }
				triangle { <9.3623, 44.796, 0.8022>, <-1.1624, 44.2435, 3.6071>, <6.3063, 44.1493, 2.1566> }
				triangle { <8.8067, 43.7105, -0.7436>, <10.6979, 44.9188, -0.7249>, <9.3623, 44.796, 0.8022> }
				triangle { <8.8067, 43.7105, -0.7436>, <9.3623, 44.796, 0.8022>, <10.6979, 44.9188, -0.7249> }
				triangle { <9.3623, 44.796, 0.8022>, <-1.1624, 44.2435, 3.6071>, <8.8067, 43.7105, -0.7436> }
				triangle { <9.3623, 44.796, 0.8022>, <8.8067, 43.7105, -0.7436>, <-1.1624, 44.2435, 3.6071> }
				triangle { <-1.5418, 44.8664, 1.7254>, <8.8067, 43.7105, -0.7436>, <-1.1624, 44.2435, 3.6071> }
				triangle { <-1.5418, 44.8664, 1.7254>, <-1.1624, 44.2435, 3.6071>, <8.8067, 43.7105, -0.7436> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-2.4629, 27.7324, -0.06216>, <-3.07372, 32.5541, -0.1078>, 0.8837 }
		cylinder { <-3.07372, 32.5541, -0.1078>, <-3.7806, 37.3556, -0.3708>, 0.8837 }
		cylinder { <-3.7806, 37.3556, -0.3708>, <-4.582, 42.1254, -0.8505>, 0.8837 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-4.582, 42.1254, -0.8505>, <-5.7851, 45.9229, -2.4772>, 0.2933 }
			cylinder { <-5.7851, 45.9229, -2.4772>, <-7.3602, 48.912, -5.1415>, 0.2933 }
			cylinder { <-7.3602, 48.912, -5.1415>, <-9.1485, 50.7909, -8.5747>, 0.2933 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-9.1485, 50.7909, -8.5747>, <-9.6877, 51.3261, -9.6183>, 0.2933 }
				cylinder { <-9.6877, 51.3261, -9.6183>, <-10.2293, 51.8326, -10.6749>, 0.2933 }
				cylinder { <-10.2293, 51.8326, -10.6749>, <-10.773, 52.3099, -11.744>, 0.2933 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-10.773, 52.3099, -11.744>, <-10.9391, 52.6997, -12.6607>, 0.06885 }
				cylinder { <-10.9391, 52.6997, -12.6607>, <-10.8341, 53.07756, -13.5913>, 0.06885 }
				cylinder { <-10.8341, 53.07756, -13.5913>, <-10.4655, 53.416, -14.4685>, 0.06885 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-10.4655, 53.416, -14.4685>, <-9.9079, 59.8778, -23.3327>, <-7.3099, 59.4637, -25.9676> }
				triangle { <-10.4655, 53.416, -14.4685>, <-7.3099, 59.4637, -25.9676>, <-9.9079, 59.8778, -23.3327> }
				triangle { <-9.9079, 59.8778, -23.3327>, <-8.2652, 64.1862, -30.7886>, <-7.3099, 59.4637, -25.9676> }
				triangle { <-9.9079, 59.8778, -23.3327>, <-7.3099, 59.4637, -25.9676>, <-8.2652, 64.1862, -30.7886> }
				triangle { <-8.2652, 64.1862, -30.7886>, <-3.6803, 59.6468, -30.6136>, <-7.3099, 59.4637, -25.9676> }
				triangle { <-8.2652, 64.1862, -30.7886>, <-7.3099, 59.4637, -25.9676>, <-3.6803, 59.6468, -30.6136> }
				triangle { <-7.3099, 59.4637, -25.9676>, <-3.6803, 59.6468, -30.6136>, <-10.4655, 53.416, -14.4685> }
				triangle { <-7.3099, 59.4637, -25.9676>, <-10.4655, 53.416, -14.4685>, <-3.6803, 59.6468, -30.6136> }
				triangle { <-8.2652, 64.1862, -30.7886>, <-19.7927, 52.2248, -48.572>, <-21.9218, 45.7103, -57.03392> }
				triangle { <-8.2652, 64.1862, -30.7886>, <-21.9218, 45.7103, -57.03392>, <-19.7927, 52.2248, -48.572> }
				triangle { <-21.9218, 45.7103, -57.03392>, <-21.9954, 40.00945, -60.1566>, <-21.4275, 40.8569, -53.05166> }
				triangle { <-21.9218, 45.7103, -57.03392>, <-21.4275, 40.8569, -53.05166>, <-21.9954, 40.00945, -60.1566> }
				triangle { <-21.4275, 40.8569, -53.05166>, <-8.2652, 64.1862, -30.7886>, <-21.9218, 45.7103, -57.03392> }
				triangle { <-21.4275, 40.8569, -53.05166>, <-21.9218, 45.7103, -57.03392>, <-8.2652, 64.1862, -30.7886> }
				triangle { <-8.2652, 64.1862, -30.7886>, <-21.4275, 40.8569, -53.05166>, <-3.6803, 59.6468, -30.6136> }
				triangle { <-8.2652, 64.1862, -30.7886>, <-3.6803, 59.6468, -30.6136>, <-21.4275, 40.8569, -53.05166> }
				triangle { <-4.00883, 56.1953, -25.8416>, <-3.6725, 53.7042, -23.09482>, <-10.4655, 53.416, -14.4685> }
				triangle { <-4.00883, 56.1953, -25.8416>, <-10.4655, 53.416, -14.4685>, <-3.6725, 53.7042, -23.09482> }
				triangle { <-4.00883, 56.1953, -25.8416>, <0.9044, 55.1074, -30.4386>, <-3.6725, 53.7042, -23.09482> }
				triangle { <-4.00883, 56.1953, -25.8416>, <-3.6725, 53.7042, -23.09482>, <0.9044, 55.1074, -30.4386> }
				triangle { <-4.00883, 56.1953, -25.8416>, <-3.6803, 59.6468, -30.6136>, <0.9044, 55.1074, -30.4386> }
				triangle { <-4.00883, 56.1953, -25.8416>, <0.9044, 55.1074, -30.4386>, <-3.6803, 59.6468, -30.6136> }
				triangle { <-10.4655, 53.416, -14.4685>, <-3.6803, 59.6468, -30.6136>, <-4.00883, 56.1953, -25.8416> }
				triangle { <-10.4655, 53.416, -14.4685>, <-4.00883, 56.1953, -25.8416>, <-3.6803, 59.6468, -30.6136> }
				triangle { <-16.4199, 40.2631, -56.8239>, <-10.2562, 42.7828, -48.208>, <0.9044, 55.1074, -30.4386> }
				triangle { <-16.4199, 40.2631, -56.8239>, <0.9044, 55.1074, -30.4386>, <-10.2562, 42.7828, -48.208> }
				triangle { <-21.4275, 40.8569, -53.05166>, <-21.9954, 40.00945, -60.1566>, <-16.4199, 40.2631, -56.8239> }
				triangle { <-21.4275, 40.8569, -53.05166>, <-16.4199, 40.2631, -56.8239>, <-21.9954, 40.00945, -60.1566> }
				triangle { <-16.4199, 40.2631, -56.8239>, <0.9044, 55.1074, -30.4386>, <-21.4275, 40.8569, -53.05166> }
				triangle { <-16.4199, 40.2631, -56.8239>, <-21.4275, 40.8569, -53.05166>, <0.9044, 55.1074, -30.4386> }
				triangle { <-3.6803, 59.6468, -30.6136>, <-21.4275, 40.8569, -53.05166>, <0.9044, 55.1074, -30.4386> }
				triangle { <-3.6803, 59.6468, -30.6136>, <0.9044, 55.1074, -30.4386>, <-21.4275, 40.8569, -53.05166> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-10.773, 52.3099, -11.744>, <-11.3184, 52.7579, -12.8248>, 0.2933 }
				cylinder { <-11.3184, 52.7579, -12.8248>, <-11.8652, 53.1763, -13.9167>, 0.2933 }
				cylinder { <-11.8652, 53.1763, -13.9167>, <-12.4131, 53.5648, -15.01911>, 0.2933 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-12.4131, 53.5648, -15.01911>, <-13.07003, 53.8278, -15.7396>, 0.06885 }
				cylinder { <-13.07003, 53.8278, -15.7396>, <-13.9075, 54.03106, -16.266>, 0.06885 }
				cylinder { <-13.9075, 54.03106, -16.266>, <-14.865, 54.1596, -16.5603>, 0.06885 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-14.865, 54.1596, -16.5603>, <-25.4514, 56.8803, -15.48>, <-27.8992, 56.5975, -18.2714> }
				triangle { <-14.865, 54.1596, -16.5603>, <-27.8992, 56.5975, -18.2714>, <-25.4514, 56.8803, -15.48> }
				triangle { <-25.4514, 56.8803, -15.48>, <-34.01847, 58.642, -16.07333>, <-27.8992, 56.5975, -18.2714> }
				triangle { <-25.4514, 56.8803, -15.48>, <-27.8992, 56.5975, -18.2714>, <-34.01847, 58.642, -16.07333> }
				triangle { <-34.01847, 58.642, -16.07333>, <-32.4888, 56.526, -21.9759>, <-27.8992, 56.5975, -18.2714> }
				triangle { <-34.01847, 58.642, -16.07333>, <-27.8992, 56.5975, -18.2714>, <-32.4888, 56.526, -21.9759> }
				triangle { <-27.8992, 56.5975, -18.2714>, <-32.4888, 56.526, -21.9759>, <-14.865, 54.1596, -16.5603> }
				triangle { <-27.8992, 56.5975, -18.2714>, <-14.865, 54.1596, -16.5603>, <-32.4888, 56.526, -21.9759> }
				triangle { <-34.01847, 58.642, -16.07333>, <-45.8578, 37.8959, -11.4219>, <-51.3704, 28.5815, -12.6168> }
				triangle { <-34.01847, 58.642, -16.07333>, <-51.3704, 28.5815, -12.6168>, <-45.8578, 37.8959, -11.4219> }
				triangle { <-51.3704, 28.5815, -12.6168>, <-52.2813, 22.5769, -14.9348>, <-45.9661, 25.9624, -14.5118> }
				triangle { <-51.3704, 28.5815, -12.6168>, <-45.9661, 25.9624, -14.5118>, <-52.2813, 22.5769, -14.9348> }
				triangle { <-45.9661, 25.9624, -14.5118>, <-34.01847, 58.642, -16.07333>, <-51.3704, 28.5815, -12.6168> }
				triangle { <-45.9661, 25.9624, -14.5118>, <-51.3704, 28.5815, -12.6168>, <-34.01847, 58.642, -16.07333> }
				triangle { <-34.01847, 58.642, -16.07333>, <-45.9661, 25.9624, -14.5118>, <-32.4888, 56.526, -21.9759> }
				triangle { <-34.01847, 58.642, -16.07333>, <-32.4888, 56.526, -21.9759>, <-45.9661, 25.9624, -14.5118> }
				triangle { <-26.7978, 55.07406, -22.5212>, <-23.371, 54.00254, -23.5075>, <-14.865, 54.1596, -16.5603> }
				triangle { <-26.7978, 55.07406, -22.5212>, <-14.865, 54.1596, -16.5603>, <-23.371, 54.00254, -23.5075> }
				triangle { <-26.7978, 55.07406, -22.5212>, <-30.9591, 54.41, -27.8784>, <-23.371, 54.00254, -23.5075> }
				triangle { <-26.7978, 55.07406, -22.5212>, <-23.371, 54.00254, -23.5075>, <-30.9591, 54.41, -27.8784> }
				triangle { <-26.7978, 55.07406, -22.5212>, <-32.4888, 56.526, -21.9759>, <-30.9591, 54.41, -27.8784> }
				triangle { <-26.7978, 55.07406, -22.5212>, <-30.9591, 54.41, -27.8784>, <-32.4888, 56.526, -21.9759> }
				triangle { <-14.865, 54.1596, -16.5603>, <-32.4888, 56.526, -21.9759>, <-26.7978, 55.07406, -22.5212> }
				triangle { <-14.865, 54.1596, -16.5603>, <-26.7978, 55.07406, -22.5212>, <-32.4888, 56.526, -21.9759> }
				triangle { <-49.5348, 26.04234, -19.6999>, <-42.6761, 33.4946, -23.6993>, <-30.9591, 54.41, -27.8784> }
				triangle { <-49.5348, 26.04234, -19.6999>, <-30.9591, 54.41, -27.8784>, <-42.6761, 33.4946, -23.6993> }
				triangle { <-45.9661, 25.9624, -14.5118>, <-52.2813, 22.5769, -14.9348>, <-49.5348, 26.04234, -19.6999> }
				triangle { <-45.9661, 25.9624, -14.5118>, <-49.5348, 26.04234, -19.6999>, <-52.2813, 22.5769, -14.9348> }
				triangle { <-49.5348, 26.04234, -19.6999>, <-30.9591, 54.41, -27.8784>, <-45.9661, 25.9624, -14.5118> }
				triangle { <-49.5348, 26.04234, -19.6999>, <-45.9661, 25.9624, -14.5118>, <-30.9591, 54.41, -27.8784> }
				triangle { <-32.4888, 56.526, -21.9759>, <-45.9661, 25.9624, -14.5118>, <-30.9591, 54.41, -27.8784> }
				triangle { <-32.4888, 56.526, -21.9759>, <-30.9591, 54.41, -27.8784>, <-45.9661, 25.9624, -14.5118> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-12.4131, 53.5648, -15.01911>, <-12.9618, 53.9231, -16.1312>, 0.2933 }
				cylinder { <-12.9618, 53.9231, -16.1312>, <-13.5109, 54.2511, -17.2525>, 0.2933 }
				cylinder { <-13.5109, 54.2511, -17.2525>, <-14.06008, 54.5486, -18.3822>, 0.2933 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-14.06008, 54.5486, -18.3822>, <-14.2304, 54.8027, -19.3446>, 0.06885 }
				cylinder { <-14.2304, 54.8027, -19.3446>, <-14.129, 55.05985, -20.3159>, 0.06885 }
				cylinder { <-14.129, 55.05985, -20.3159>, <-13.7634, 55.3013, -21.2258>, 0.06885 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-13.7634, 55.3013, -21.2258>, <-13.4097, 60.5555, -30.8647>, <-10.7388, 59.9566, -33.3889> }
				triangle { <-13.7634, 55.3013, -21.2258>, <-10.7388, 59.9566, -33.3889>, <-13.4097, 60.5555, -30.8647> }
				triangle { <-13.4097, 60.5555, -30.8647>, <-11.8741, 63.9322, -38.8077>, <-10.7388, 59.9566, -33.3889> }
				triangle { <-13.4097, 60.5555, -30.8647>, <-10.7388, 59.9566, -33.3889>, <-11.8741, 63.9322, -38.8077> }
				triangle { <-11.8741, 63.9322, -38.8077>, <-7.03309, 59.7458, -37.9732>, <-10.7388, 59.9566, -33.3889> }
				triangle { <-11.8741, 63.9322, -38.8077>, <-10.7388, 59.9566, -33.3889>, <-7.03309, 59.7458, -37.9732> }
				triangle { <-10.7388, 59.9566, -33.3889>, <-7.03309, 59.7458, -37.9732>, <-13.7634, 55.3013, -21.2258> }
				triangle { <-10.7388, 59.9566, -33.3889>, <-13.7634, 55.3013, -21.2258>, <-7.03309, 59.7458, -37.9732> }
				triangle { <-11.8741, 63.9322, -38.8077>, <-22.3105, 49.03872, -54.9777>, <-23.8782, 41.3438, -62.5213> }
				triangle { <-11.8741, 63.9322, -38.8077>, <-23.8782, 41.3438, -62.5213>, <-22.3105, 49.03872, -54.9777> }
				triangle { <-23.8782, 41.3438, -62.5213>, <-23.551, 35.2861, -64.857>, <-23.1783, 37.09946, -57.9219> }
				triangle { <-23.8782, 41.3438, -62.5213>, <-23.1783, 37.09946, -57.9219>, <-23.551, 35.2861, -64.857> }
				triangle { <-23.1783, 37.09946, -57.9219>, <-11.8741, 63.9322, -38.8077>, <-23.8782, 41.3438, -62.5213> }
				triangle { <-23.1783, 37.09946, -57.9219>, <-23.8782, 41.3438, -62.5213>, <-11.8741, 63.9322, -38.8077> }
				triangle { <-11.8741, 63.9322, -38.8077>, <-23.1783, 37.09946, -57.9219>, <-7.03309, 59.7458, -37.9732> }
				triangle { <-11.8741, 63.9322, -38.8077>, <-7.03309, 59.7458, -37.9732>, <-23.1783, 37.09946, -57.9219> }
				triangle { <-7.2533, 56.9424, -32.7881>, <-6.8259, 54.862, -29.7299>, <-13.7634, 55.3013, -21.2258> }
				triangle { <-7.2533, 56.9424, -32.7881>, <-13.7634, 55.3013, -21.2258>, <-6.8259, 54.862, -29.7299> }
				triangle { <-7.2533, 56.9424, -32.7881>, <-2.192, 55.5594, -37.1387>, <-6.8259, 54.862, -29.7299> }
				triangle { <-7.2533, 56.9424, -32.7881>, <-6.8259, 54.862, -29.7299>, <-2.192, 55.5594, -37.1387> }
				triangle { <-7.2533, 56.9424, -32.7881>, <-7.03309, 59.7458, -37.9732>, <-2.192, 55.5594, -37.1387> }
				triangle { <-7.2533, 56.9424, -32.7881>, <-2.192, 55.5594, -37.1387>, <-7.03309, 59.7458, -37.9732> }
				triangle { <-13.7634, 55.3013, -21.2258>, <-7.03309, 59.7458, -37.9732>, <-7.2533, 56.9424, -32.7881> }
				triangle { <-13.7634, 55.3013, -21.2258>, <-7.2533, 56.9424, -32.7881>, <-7.03309, 59.7458, -37.9732> }
				triangle { <-18.06904, 36.3201, -61.5199>, <-12.2411, 40.331, -53.242>, <-2.192, 55.5594, -37.1387> }
				triangle { <-18.06904, 36.3201, -61.5199>, <-2.192, 55.5594, -37.1387>, <-12.2411, 40.331, -53.242> }
				triangle { <-23.1783, 37.09946, -57.9219>, <-23.551, 35.2861, -64.857>, <-18.06904, 36.3201, -61.5199> }
				triangle { <-23.1783, 37.09946, -57.9219>, <-18.06904, 36.3201, -61.5199>, <-23.551, 35.2861, -64.857> }
				triangle { <-18.06904, 36.3201, -61.5199>, <-2.192, 55.5594, -37.1387>, <-23.1783, 37.09946, -57.9219> }
				triangle { <-18.06904, 36.3201, -61.5199>, <-23.1783, 37.09946, -57.9219>, <-2.192, 55.5594, -37.1387> }
				triangle { <-7.03309, 59.7458, -37.9732>, <-23.1783, 37.09946, -57.9219>, <-2.192, 55.5594, -37.1387> }
				triangle { <-7.03309, 59.7458, -37.9732>, <-2.192, 55.5594, -37.1387>, <-23.1783, 37.09946, -57.9219> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-14.06008, 54.5486, -18.3822>, <-14.4897, 54.7813, -19.266>, 0.06885 }
				cylinder { <-14.4897, 54.7813, -19.266>, <-14.9193, 55.01407, -20.1498>, 0.06885 }
				cylinder { <-14.9193, 55.01407, -20.1498>, <-15.349, 55.2467, -21.03363>, 0.06885 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-15.349, 55.2467, -21.03363>, <-22.8287, 59.7042, -27.7287>, <-22.6427, 59.4124, -31.436> }
				triangle { <-15.349, 55.2467, -21.03363>, <-22.6427, 59.4124, -31.436>, <-22.8287, 59.7042, -27.7287> }
				triangle { <-22.8287, 59.7042, -27.7287>, <-27.9574, 62.6732, -34.1887>, <-22.6427, 59.4124, -31.436> }
				triangle { <-22.8287, 59.7042, -27.7287>, <-22.6427, 59.4124, -31.436>, <-27.9574, 62.6732, -34.1887> }
				triangle { <-27.9574, 62.6732, -34.1887>, <-23.2572, 59.5303, -37.3012>, <-22.6427, 59.4124, -31.436> }
				triangle { <-27.9574, 62.6732, -34.1887>, <-22.6427, 59.4124, -31.436>, <-23.2572, 59.5303, -37.3012> }
				triangle { <-22.6427, 59.4124, -31.436>, <-23.2572, 59.5303, -37.3012>, <-15.349, 55.2467, -21.03363> }
				triangle { <-22.6427, 59.4124, -31.436>, <-15.349, 55.2467, -21.03363>, <-23.2572, 59.5303, -37.3012> }
				triangle { <-27.9574, 62.6732, -34.1887>, <-43.705, 44.8894, -39.4762>, <-48.6365, 36.4703, -44.3107> }
				triangle { <-27.9574, 62.6732, -34.1887>, <-48.6365, 36.4703, -44.3107>, <-43.705, 44.8894, -39.4762> }
				triangle { <-48.6365, 36.4703, -44.3107>, <-48.9201, 30.4129, -46.6529>, <-44.1456, 32.8016, -41.8549> }
				triangle { <-48.6365, 36.4703, -44.3107>, <-44.1456, 32.8016, -41.8549>, <-48.9201, 30.4129, -46.6529> }
				triangle { <-44.1456, 32.8016, -41.8549>, <-27.9574, 62.6732, -34.1887>, <-48.6365, 36.4703, -44.3107> }
				triangle { <-44.1456, 32.8016, -41.8549>, <-48.6365, 36.4703, -44.3107>, <-27.9574, 62.6732, -34.1887> }
				triangle { <-27.9574, 62.6732, -34.1887>, <-44.1456, 32.8016, -41.8549>, <-23.2572, 59.5303, -37.3012> }
				triangle { <-27.9574, 62.6732, -34.1887>, <-23.2572, 59.5303, -37.3012>, <-44.1456, 32.8016, -41.8549> }
				triangle { <-19.2586, 57.1495, -33.677>, <-16.4365, 55.4298, -31.9617>, <-15.349, 55.2467, -21.03363> }
				triangle { <-19.2586, 57.1495, -33.677>, <-15.349, 55.2467, -21.03363>, <-16.4365, 55.4298, -31.9617> }
				triangle { <-19.2586, 57.1495, -33.677>, <-18.557, 56.3874, -40.4138>, <-16.4365, 55.4298, -31.9617> }
				triangle { <-19.2586, 57.1495, -33.677>, <-16.4365, 55.4298, -31.9617>, <-18.557, 56.3874, -40.4138> }
				triangle { <-19.2586, 57.1495, -33.677>, <-23.2572, 59.5303, -37.3012>, <-18.557, 56.3874, -40.4138> }
				triangle { <-19.2586, 57.1495, -33.677>, <-18.557, 56.3874, -40.4138>, <-23.2572, 59.5303, -37.3012> }
				triangle { <-15.349, 55.2467, -21.03363>, <-23.2572, 59.5303, -37.3012>, <-19.2586, 57.1495, -33.677> }
				triangle { <-15.349, 55.2467, -21.03363>, <-19.2586, 57.1495, -33.677>, <-23.2572, 59.5303, -37.3012> }
				triangle { <-42.9962, 32.6988, -48.04578>, <-33.9285, 38.3521, -45.9502>, <-18.557, 56.3874, -40.4138> }
				triangle { <-42.9962, 32.6988, -48.04578>, <-18.557, 56.3874, -40.4138>, <-33.9285, 38.3521, -45.9502> }
				triangle { <-44.1456, 32.8016, -41.8549>, <-48.9201, 30.4129, -46.6529>, <-42.9962, 32.6988, -48.04578> }
				triangle { <-44.1456, 32.8016, -41.8549>, <-42.9962, 32.6988, -48.04578>, <-48.9201, 30.4129, -46.6529> }
				triangle { <-42.9962, 32.6988, -48.04578>, <-18.557, 56.3874, -40.4138>, <-44.1456, 32.8016, -41.8549> }
				triangle { <-42.9962, 32.6988, -48.04578>, <-44.1456, 32.8016, -41.8549>, <-18.557, 56.3874, -40.4138> }
				triangle { <-23.2572, 59.5303, -37.3012>, <-44.1456, 32.8016, -41.8549>, <-18.557, 56.3874, -40.4138> }
				triangle { <-23.2572, 59.5303, -37.3012>, <-18.557, 56.3874, -40.4138>, <-44.1456, 32.8016, -41.8549> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-4.582, 42.1254, -0.8505>, <-4.7264, 46.3469, -0.0305>, 0.2933 }
			cylinder { <-4.7264, 46.3469, -0.0305>, <-4.291, 50.1412, 1.9515>, 0.2933 }
			cylinder { <-4.291, 50.1412, 1.9515>, <-3.3198, 53.1251, 4.8956>, 0.2933 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-3.3198, 53.1251, 4.8956>, <-3.01716, 53.9975, 5.7976>, 0.2933 }
				cylinder { <-3.01716, 53.9975, 5.7976>, <-2.7033, 54.8465, 6.7179>, 0.2933 }
				cylinder { <-2.7033, 54.8465, 6.7179>, <-2.3785, 55.6717, 7.6559>, 0.2933 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-2.3785, 55.6717, 7.6559>, <-2.3773, 56.264, 8.4739>, 0.06885 }
				cylinder { <-2.3773, 56.264, 8.4739>, <-2.6292, 56.7602, 9.3166>, 0.06885 }
				cylinder { <-2.6292, 56.7602, 9.3166>, <-3.1159, 57.1244, 10.1231>, 0.06885 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-3.1159, 57.1244, 10.1231>, <-6.02297, 64.6457, 17.5809>, <-8.4314, 63.9318, 20.3292> }
				triangle { <-3.1159, 57.1244, 10.1231>, <-8.4314, 63.9318, 20.3292>, <-6.02297, 64.6457, 17.5809> }
				triangle { <-6.02297, 64.6457, 17.5809>, <-9.2133, 69.5487, 24.1102>, <-8.4314, 63.9318, 20.3292> }
				triangle { <-6.02297, 64.6457, 17.5809>, <-8.4314, 63.9318, 20.3292>, <-9.2133, 69.5487, 24.1102> }
				triangle { <-9.2133, 69.5487, 24.1102>, <-12.07413, 63.8269, 24.9674>, <-8.4314, 63.9318, 20.3292> }
				triangle { <-9.2133, 69.5487, 24.1102>, <-8.4314, 63.9318, 20.3292>, <-12.07413, 63.8269, 24.9674> }
				triangle { <-8.4314, 63.9318, 20.3292>, <-12.07413, 63.8269, 24.9674>, <-3.1159, 57.1244, 10.1231> }
				triangle { <-8.4314, 63.9318, 20.3292>, <-3.1159, 57.1244, 10.1231>, <-12.07413, 63.8269, 24.9674> }
				triangle { <-9.2133, 69.5487, 24.1102>, <4.9795, 65.6467, 43.4892>, <8.8256, 61.9419, 52.979> }
				triangle { <-9.2133, 69.5487, 24.1102>, <8.8256, 61.9419, 52.979>, <4.9795, 65.6467, 43.4892> }
				triangle { <8.8256, 61.9419, 52.979>, <10.6386, 57.2909, 57.1429>, <10.05858, 56.5155, 50.0307> }
				triangle { <8.8256, 61.9419, 52.979>, <10.05858, 56.5155, 50.0307>, <10.6386, 57.2909, 57.1429> }
				triangle { <10.05858, 56.5155, 50.0307>, <-9.2133, 69.5487, 24.1102>, <8.8256, 61.9419, 52.979> }
				triangle { <10.05858, 56.5155, 50.0307>, <8.8256, 61.9419, 52.979>, <-9.2133, 69.5487, 24.1102> }
				triangle { <-9.2133, 69.5487, 24.1102>, <10.05858, 56.5155, 50.0307>, <-12.07413, 63.8269, 24.9674> }
				triangle { <-9.2133, 69.5487, 24.1102>, <-12.07413, 63.8269, 24.9674>, <10.05858, 56.5155, 50.0307> }
				triangle { <-10.4912, 59.8121, 20.9463>, <-9.9136, 56.8641, 18.7466>, <-3.1159, 57.1244, 10.1231> }
				triangle { <-10.4912, 59.8121, 20.9463>, <-3.1159, 57.1244, 10.1231>, <-9.9136, 56.8641, 18.7466> }
				triangle { <-10.4912, 59.8121, 20.9463>, <-14.9349, 58.1051, 25.8245>, <-9.9136, 56.8641, 18.7466> }
				triangle { <-10.4912, 59.8121, 20.9463>, <-9.9136, 56.8641, 18.7466>, <-14.9349, 58.1051, 25.8245> }
				triangle { <-10.4912, 59.8121, 20.9463>, <-12.07413, 63.8269, 24.9674>, <-14.9349, 58.1051, 25.8245> }
				triangle { <-10.4912, 59.8121, 20.9463>, <-14.9349, 58.1051, 25.8245>, <-12.07413, 63.8269, 24.9674> }
				triangle { <-3.1159, 57.1244, 10.1231>, <-12.07413, 63.8269, 24.9674>, <-10.4912, 59.8121, 20.9463> }
				triangle { <-3.1159, 57.1244, 10.1231>, <-10.4912, 59.8121, 20.9463>, <-12.07413, 63.8269, 24.9674> }
				triangle { <5.3927, 55.07575, 54.00753>, <-0.9708, 53.7454, 45.272>, <-14.9349, 58.1051, 25.8245> }
				triangle { <5.3927, 55.07575, 54.00753>, <-14.9349, 58.1051, 25.8245>, <-0.9708, 53.7454, 45.272> }
				triangle { <10.05858, 56.5155, 50.0307>, <10.6386, 57.2909, 57.1429>, <5.3927, 55.07575, 54.00753> }
				triangle { <10.05858, 56.5155, 50.0307>, <5.3927, 55.07575, 54.00753>, <10.6386, 57.2909, 57.1429> }
				triangle { <5.3927, 55.07575, 54.00753>, <-14.9349, 58.1051, 25.8245>, <10.05858, 56.5155, 50.0307> }
				triangle { <5.3927, 55.07575, 54.00753>, <10.05858, 56.5155, 50.0307>, <-14.9349, 58.1051, 25.8245> }
				triangle { <-12.07413, 63.8269, 24.9674>, <10.05858, 56.5155, 50.0307>, <-14.9349, 58.1051, 25.8245> }
				triangle { <-12.07413, 63.8269, 24.9674>, <-14.9349, 58.1051, 25.8245>, <10.05858, 56.5155, 50.0307> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-2.3785, 55.6717, 7.6559>, <-2.04292, 56.4725, 8.6111>, 0.2933 }
				cylinder { <-2.04292, 56.4725, 8.6111>, <-1.6967, 57.2485, 9.5829>, 0.2933 }
				cylinder { <-1.6967, 57.2485, 9.5829>, <-1.3402, 57.9991, 10.5707>, 0.2933 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-1.3402, 57.9991, 10.5707>, <-0.8276, 58.5949, 11.2048>, 0.06885 }
				cylinder { <-0.8276, 58.5949, 11.2048>, <-0.1186, 59.1562, 11.6544>, 0.06885 }
				cylinder { <-0.1186, 59.1562, 11.6544>, <0.7356, 59.6421, 11.8868>, 0.06885 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <0.7356, 59.6421, 11.8868>, <9.9009, 65.3787, 9.9559>, <12.2163, 66.4498, 12.668> }
				triangle { <0.7356, 59.6421, 11.8868>, <12.2163, 66.4498, 12.668>, <9.9009, 65.3787, 9.9559> }
				triangle { <9.9009, 65.3787, 9.9559>, <17.4127, 69.8978, 9.9174>, <12.2163, 66.4498, 12.668> }
				triangle { <9.9009, 65.3787, 9.9559>, <12.2163, 66.4498, 12.668>, <17.4127, 69.8978, 9.9174> }
				triangle { <17.4127, 69.8978, 9.9174>, <16.4589, 68.5866, 16.1647>, <12.2163, 66.4498, 12.668> }
				triangle { <17.4127, 69.8978, 9.9174>, <12.2163, 66.4498, 12.668>, <16.4589, 68.5866, 16.1647> }
				triangle { <12.2163, 66.4498, 12.668>, <16.4589, 68.5866, 16.1647>, <0.7356, 59.6421, 11.8868> }
				triangle { <12.2163, 66.4498, 12.668>, <0.7356, 59.6421, 11.8868>, <16.4589, 68.5866, 16.1647> }
				triangle { <17.4127, 69.8978, 9.9174>, <35.4738, 53.6146, 8.9906>, <43.6623, 47.00382, 11.7872> }
				triangle { <17.4127, 69.8978, 9.9174>, <43.6623, 47.00382, 11.7872>, <35.4738, 53.6146, 8.9906> }
				triangle { <43.6623, 47.00382, 11.7872>, <46.3914, 42.1866, 15.1937>, <39.3377, 43.1962, 14.3287> }
				triangle { <43.6623, 47.00382, 11.7872>, <39.3377, 43.1962, 14.3287>, <46.3914, 42.1866, 15.1937> }
				triangle { <39.3377, 43.1962, 14.3287>, <17.4127, 69.8978, 9.9174>, <43.6623, 47.00382, 11.7872> }
				triangle { <39.3377, 43.1962, 14.3287>, <43.6623, 47.00382, 11.7872>, <17.4127, 69.8978, 9.9174> }
				triangle { <17.4127, 69.8978, 9.9174>, <39.3377, 43.1962, 14.3287>, <16.4589, 68.5866, 16.1647> }
				triangle { <17.4127, 69.8978, 9.9174>, <16.4589, 68.5866, 16.1647>, <39.3377, 43.1962, 14.3287> }
				triangle { <11.5295, 65.5057, 17.166>, <8.6038, 63.5954, 18.4522>, <0.7356, 59.6421, 11.8868> }
				triangle { <11.5295, 65.5057, 17.166>, <0.7356, 59.6421, 11.8868>, <8.6038, 63.5954, 18.4522> }
				triangle { <11.5295, 65.5057, 17.166>, <15.505, 67.2753, 22.412>, <8.6038, 63.5954, 18.4522> }
				triangle { <11.5295, 65.5057, 17.166>, <8.6038, 63.5954, 18.4522>, <15.505, 67.2753, 22.412> }
				triangle { <11.5295, 65.5057, 17.166>, <16.4589, 68.5866, 16.1647>, <15.505, 67.2753, 22.412> }
				triangle { <11.5295, 65.5057, 17.166>, <15.505, 67.2753, 22.412>, <16.4589, 68.5866, 16.1647> }
				triangle { <0.7356, 59.6421, 11.8868>, <16.4589, 68.5866, 16.1647>, <11.5295, 65.5057, 17.166> }
				triangle { <0.7356, 59.6421, 11.8868>, <11.5295, 65.5057, 17.166>, <16.4589, 68.5866, 16.1647> }
				triangle { <42.5177, 45.4303, 19.2839>, <33.4899, 50.8872, 21.9849>, <15.505, 67.2753, 22.412> }
				triangle { <42.5177, 45.4303, 19.2839>, <15.505, 67.2753, 22.412>, <33.4899, 50.8872, 21.9849> }
				triangle { <39.3377, 43.1962, 14.3287>, <46.3914, 42.1866, 15.1937>, <42.5177, 45.4303, 19.2839> }
				triangle { <39.3377, 43.1962, 14.3287>, <42.5177, 45.4303, 19.2839>, <46.3914, 42.1866, 15.1937> }
				triangle { <42.5177, 45.4303, 19.2839>, <15.505, 67.2753, 22.412>, <39.3377, 43.1962, 14.3287> }
				triangle { <42.5177, 45.4303, 19.2839>, <39.3377, 43.1962, 14.3287>, <15.505, 67.2753, 22.412> }
				triangle { <16.4589, 68.5866, 16.1647>, <39.3377, 43.1962, 14.3287>, <15.505, 67.2753, 22.412> }
				triangle { <16.4589, 68.5866, 16.1647>, <15.505, 67.2753, 22.412>, <39.3377, 43.1962, 14.3287> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-1.3402, 57.9991, 10.5707>, <-0.9736, 58.724, 11.5739>, 0.2933 }
				cylinder { <-0.9736, 58.724, 11.5739>, <-0.597, 59.4227, 12.5919>, 0.2933 }
				cylinder { <-0.597, 59.4227, 12.5919>, <-0.2107, 60.09487, 13.6241>, 0.2933 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-0.2107, 60.09487, 13.6241>, <-0.1632, 60.5718, 14.513>, 0.06885 }
				cylinder { <-0.1632, 60.5718, 14.513>, <-0.3739, 60.9653, 15.4189>, 0.06885 }
				cylinder { <-0.3739, 60.9653, 15.4189>, <-0.8274, 61.2468, 16.2761>, 0.06885 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-0.8274, 61.2468, 16.2761>, <-3.1761, 67.8658, 24.7208>, <-5.59, 66.9358, 27.3988> }
				triangle { <-0.8274, 61.2468, 16.2761>, <-5.59, 66.9358, 27.3988>, <-3.1761, 67.8658, 24.7208> }
				triangle { <-3.1761, 67.8658, 24.7208>, <-5.9795, 72.03504, 31.9048>, <-5.59, 66.9358, 27.3988> }
				triangle { <-3.1761, 67.8658, 24.7208>, <-5.59, 66.9358, 27.3988>, <-5.9795, 72.03504, 31.9048> }
				triangle { <-5.9795, 72.03504, 31.9048>, <-9.1753, 66.4294, 32.05523>, <-5.59, 66.9358, 27.3988> }
				triangle { <-5.9795, 72.03504, 31.9048>, <-5.59, 66.9358, 27.3988>, <-9.1753, 66.4294, 32.05523> }
				triangle { <-5.59, 66.9358, 27.3988>, <-9.1753, 66.4294, 32.05523>, <-0.8274, 61.2468, 16.2761> }
				triangle { <-5.59, 66.9358, 27.3988>, <-0.8274, 61.2468, 16.2761>, <-9.1753, 66.4294, 32.05523> }
				triangle { <-5.9795, 72.03504, 31.9048>, <8.1829, 64.7518, 50.3054>, <11.9102, 59.5941, 59.1417> }
				triangle { <-5.9795, 72.03504, 31.9048>, <11.9102, 59.5941, 59.1417>, <8.1829, 64.7518, 50.3054> }
				triangle { <11.9102, 59.5941, 59.1417>, <13.4852, 54.3306, 62.6161>, <12.7717, 54.5457, 55.477> }
				triangle { <11.9102, 59.5941, 59.1417>, <12.7717, 54.5457, 55.477>, <13.4852, 54.3306, 62.6161> }
				triangle { <12.7717, 54.5457, 55.477>, <-5.9795, 72.03504, 31.9048>, <11.9102, 59.5941, 59.1417> }
				triangle { <12.7717, 54.5457, 55.477>, <11.9102, 59.5941, 59.1417>, <-5.9795, 72.03504, 31.9048> }
				triangle { <-5.9795, 72.03504, 31.9048>, <12.7717, 54.5457, 55.477>, <-9.1753, 66.4294, 32.05523> }
				triangle { <-5.9795, 72.03504, 31.9048>, <-9.1753, 66.4294, 32.05523>, <12.7717, 54.5457, 55.477> }
				triangle { <-7.891, 62.8998, 27.5071>, <-7.5223, 60.2423, 24.9254>, <-0.8274, 61.2468, 16.2761> }
				triangle { <-7.891, 62.8998, 27.5071>, <-0.8274, 61.2468, 16.2761>, <-7.5223, 60.2423, 24.9254> }
				triangle { <-7.891, 62.8998, 27.5071>, <-12.3711, 60.8239, 32.2056>, <-7.5223, 60.2423, 24.9254> }
				triangle { <-7.891, 62.8998, 27.5071>, <-7.5223, 60.2423, 24.9254>, <-12.3711, 60.8239, 32.2056> }
				triangle { <-7.891, 62.8998, 27.5071>, <-9.1753, 66.4294, 32.05523>, <-12.3711, 60.8239, 32.2056> }
				triangle { <-7.891, 62.8998, 27.5071>, <-12.3711, 60.8239, 32.2056>, <-9.1753, 66.4294, 32.05523> }
				triangle { <-0.8274, 61.2468, 16.2761>, <-9.1753, 66.4294, 32.05523>, <-7.891, 62.8998, 27.5071> }
				triangle { <-0.8274, 61.2468, 16.2761>, <-7.891, 62.8998, 27.5071>, <-9.1753, 66.4294, 32.05523> }
				triangle { <8.07536, 52.8675, 59.3222>, <1.5357, 53.09234, 50.6183>, <-12.3711, 60.8239, 32.2056> }
				triangle { <8.07536, 52.8675, 59.3222>, <-12.3711, 60.8239, 32.2056>, <1.5357, 53.09234, 50.6183> }
				triangle { <12.7717, 54.5457, 55.477>, <13.4852, 54.3306, 62.6161>, <8.07536, 52.8675, 59.3222> }
				triangle { <12.7717, 54.5457, 55.477>, <8.07536, 52.8675, 59.3222>, <13.4852, 54.3306, 62.6161> }
				triangle { <8.07536, 52.8675, 59.3222>, <-12.3711, 60.8239, 32.2056>, <12.7717, 54.5457, 55.477> }
				triangle { <8.07536, 52.8675, 59.3222>, <12.7717, 54.5457, 55.477>, <-12.3711, 60.8239, 32.2056> }
				triangle { <-9.1753, 66.4294, 32.05523>, <12.7717, 54.5457, 55.477>, <-12.3711, 60.8239, 32.2056> }
				triangle { <-9.1753, 66.4294, 32.05523>, <-12.3711, 60.8239, 32.2056>, <12.7717, 54.5457, 55.477> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-0.2107, 60.09487, 13.6241>, <0.09143, 60.6206, 14.4316>, 0.06885 }
				cylinder { <0.09143, 60.6206, 14.4316>, <0.3936, 61.1464, 15.2391>, 0.06885 }
				cylinder { <0.3936, 61.1464, 15.2391>, <0.6958, 61.6722, 16.04664>, 0.06885 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <0.6958, 61.6722, 16.04664>, <6.1083, 69.5182, 21.5042>, <5.9061, 69.906, 25.2019> }
				triangle { <0.6958, 61.6722, 16.04664>, <5.9061, 69.906, 25.2019>, <6.1083, 69.5182, 21.5042> }
				triangle { <6.1083, 69.5182, 21.5042>, <9.7869, 75.1793, 27.09625>, <5.9061, 69.906, 25.2019> }
				triangle { <6.1083, 69.5182, 21.5042>, <5.9061, 69.906, 25.2019>, <9.7869, 75.1793, 27.09625> }
				triangle { <9.7869, 75.1793, 27.09625>, <6.2581, 71.3504, 30.91>, <5.9061, 69.906, 25.2019> }
				triangle { <9.7869, 75.1793, 27.09625>, <5.9061, 69.906, 25.2019>, <6.2581, 71.3504, 30.91> }
				triangle { <5.9061, 69.906, 25.2019>, <6.2581, 71.3504, 30.91>, <0.6958, 61.6722, 16.04664> }
				triangle { <5.9061, 69.906, 25.2019>, <0.6958, 61.6722, 16.04664>, <6.2581, 71.3504, 30.91> }
				triangle { <9.7869, 75.1793, 27.09625>, <30.2615, 64.8299, 35.2133>, <37.4922, 59.5652, 41.4242> }
				triangle { <9.7869, 75.1793, 27.09625>, <37.4922, 59.5652, 41.4242>, <30.2615, 64.8299, 35.2133> }
				triangle { <37.4922, 59.5652, 41.4242>, <39.6445, 54.5008, 44.885>, <34.5127, 54.2384, 39.8732> }
				triangle { <37.4922, 59.5652, 41.4242>, <34.5127, 54.2384, 39.8732>, <39.6445, 54.5008, 44.885> }
				triangle { <34.5127, 54.2384, 39.8732>, <9.7869, 75.1793, 27.09625>, <37.4922, 59.5652, 41.4242> }
				triangle { <34.5127, 54.2384, 39.8732>, <37.4922, 59.5652, 41.4242>, <9.7869, 75.1793, 27.09625> }
				triangle { <9.7869, 75.1793, 27.09625>, <34.5127, 54.2384, 39.8732>, <6.2581, 71.3504, 30.91> }
				triangle { <9.7869, 75.1793, 27.09625>, <6.2581, 71.3504, 30.91>, <34.5127, 54.2384, 39.8732> }
				triangle { <3.3654, 67.1492, 27.9478>, <1.3092, 64.3109, 26.6909>, <0.6958, 61.6722, 16.04664> }
				triangle { <3.3654, 67.1492, 27.9478>, <0.6958, 61.6722, 16.04664>, <1.3092, 64.3109, 26.6909> }
				triangle { <3.3654, 67.1492, 27.9478>, <2.7294, 67.5214, 34.7237>, <1.3092, 64.3109, 26.6909> }
				triangle { <3.3654, 67.1492, 27.9478>, <1.3092, 64.3109, 26.6909>, <2.7294, 67.5214, 34.7237> }
				triangle { <3.3654, 67.1492, 27.9478>, <6.2581, 71.3504, 30.91>, <2.7294, 67.5214, 34.7237> }
				triangle { <3.3654, 67.1492, 27.9478>, <2.7294, 67.5214, 34.7237>, <6.2581, 71.3504, 30.91> }
				triangle { <0.6958, 61.6722, 16.04664>, <6.2581, 71.3504, 30.91>, <3.3654, 67.1492, 27.9478> }
				triangle { <0.6958, 61.6722, 16.04664>, <3.3654, 67.1492, 27.9478>, <6.2581, 71.3504, 30.91> }
				triangle { <33.2576, 54.9705, 46.00078>, <22.9216, 56.8657, 43.1459>, <2.7294, 67.5214, 34.7237> }
				triangle { <33.2576, 54.9705, 46.00078>, <2.7294, 67.5214, 34.7237>, <22.9216, 56.8657, 43.1459> }
				triangle { <34.5127, 54.2384, 39.8732>, <39.6445, 54.5008, 44.885>, <33.2576, 54.9705, 46.00078> }
				triangle { <34.5127, 54.2384, 39.8732>, <33.2576, 54.9705, 46.00078>, <39.6445, 54.5008, 44.885> }
				triangle { <33.2576, 54.9705, 46.00078>, <2.7294, 67.5214, 34.7237>, <34.5127, 54.2384, 39.8732> }
				triangle { <33.2576, 54.9705, 46.00078>, <34.5127, 54.2384, 39.8732>, <2.7294, 67.5214, 34.7237> }
				triangle { <6.2581, 71.3504, 30.91>, <34.5127, 54.2384, 39.8732>, <2.7294, 67.5214, 34.7237> }
				triangle { <6.2581, 71.3504, 30.91>, <2.7294, 67.5214, 34.7237>, <34.5127, 54.2384, 39.8732> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-4.582, 42.1254, -0.8505>, <-4.993, 43.6622, -1.3415>, 0.3027 }
		cylinder { <-4.993, 43.6622, -1.3415>, <-5.5203, 45.02744, -2.1352>, 0.3027 }
		cylinder { <-5.5203, 45.02744, -2.1352>, <-6.1384, 46.1545, -3.1932>, 0.3027 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-6.1384, 46.1545, -3.1932>, <-6.7004, 46.7124, -4.2808>, 0.09172 }
			cylinder { <-6.7004, 46.7124, -4.2808>, <-7.2681, 46.8609, -5.4915>, 0.09172 }
			cylinder { <-7.2681, 46.8609, -5.4915>, <-7.7842, 46.585, -6.7029>, 0.09172 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-7.7842, 46.585, -6.7029>, <-7.9372, 46.4927, -7.06485>, 0.09172 }
				cylinder { <-7.9372, 46.4927, -7.06485>, <-8.08824, 46.3907, -7.425>, 0.09172 }
				cylinder { <-8.08824, 46.3907, -7.425>, <-8.2371, 46.2793, -7.7832>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-8.2371, 46.2793, -7.7832>, <-8.2484, 46.256, -7.8784>, 0.006731 }
				cylinder { <-8.2484, 46.256, -7.8784>, <-8.2338, 46.2382, -7.9744>, 0.006731 }
				cylinder { <-8.2338, 46.2382, -7.9744>, <-8.1942, 46.2274, -8.06426>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-8.1942, 46.2274, -8.06426>, <-8.08741, 46.3567, -11.4944>, <-7.1552, 46.02608, -12.1085> }
				triangle { <-8.1942, 46.2274, -8.06426>, <-7.1552, 46.02608, -12.1085>, <-8.08741, 46.3567, -11.4944> }
				triangle { <-8.08741, 46.3567, -11.4944>, <-7.563, 46.2873, -14.1838>, <-7.1552, 46.02608, -12.1085> }
				triangle { <-8.08741, 46.3567, -11.4944>, <-7.1552, 46.02608, -12.1085>, <-7.563, 46.2873, -14.1838> }
				triangle { <-7.563, 46.2873, -14.1838>, <-5.8639, 45.5874, -13.35>, <-7.1552, 46.02608, -12.1085> }
				triangle { <-7.563, 46.2873, -14.1838>, <-7.1552, 46.02608, -12.1085>, <-5.8639, 45.5874, -13.35> }
				triangle { <-7.1552, 46.02608, -12.1085>, <-5.8639, 45.5874, -13.35>, <-8.1942, 46.2274, -8.06426> }
				triangle { <-7.1552, 46.02608, -12.1085>, <-8.1942, 46.2274, -8.06426>, <-5.8639, 45.5874, -13.35> }
				triangle { <-7.563, 46.2873, -14.1838>, <-9.3471, 39.2996, -16.6095>, <-9.1273, 36.05864, -17.6291> }
				triangle { <-7.563, 46.2873, -14.1838>, <-9.1273, 36.05864, -17.6291>, <-9.3471, 39.2996, -16.6095> }
				triangle { <-9.1273, 36.05864, -17.6291>, <-8.5934, 34.1082, -17.4238>, <-8.8101, 35.5819, -15.7451> }
				triangle { <-9.1273, 36.05864, -17.6291>, <-8.8101, 35.5819, -15.7451>, <-8.5934, 34.1082, -17.4238> }
				triangle { <-8.8101, 35.5819, -15.7451>, <-7.563, 46.2873, -14.1838>, <-9.1273, 36.05864, -17.6291> }
				triangle { <-8.8101, 35.5819, -15.7451>, <-9.1273, 36.05864, -17.6291>, <-7.563, 46.2873, -14.1838> }
				triangle { <-7.563, 46.2873, -14.1838>, <-8.8101, 35.5819, -15.7451>, <-5.8639, 45.5874, -13.35> }
				triangle { <-7.563, 46.2873, -14.1838>, <-5.8639, 45.5874, -13.35>, <-8.8101, 35.5819, -15.7451> }
				triangle { <-5.9318, 45.5221, -11.5081>, <-5.7765, 45.4047, -10.3603>, <-8.1942, 46.2274, -8.06426> }
				triangle { <-5.9318, 45.5221, -11.5081>, <-8.1942, 46.2274, -8.06426>, <-5.7765, 45.4047, -10.3603> }
				triangle { <-5.9318, 45.5221, -11.5081>, <-4.1647, 44.8874, -12.5161>, <-5.7765, 45.4047, -10.3603> }
				triangle { <-5.9318, 45.5221, -11.5081>, <-5.7765, 45.4047, -10.3603>, <-4.1647, 44.8874, -12.5161> }
				triangle { <-5.9318, 45.5221, -11.5081>, <-5.8639, 45.5874, -13.35>, <-4.1647, 44.8874, -12.5161> }
				triangle { <-5.9318, 45.5221, -11.5081>, <-4.1647, 44.8874, -12.5161>, <-5.8639, 45.5874, -13.35> }
				triangle { <-8.1942, 46.2274, -8.06426>, <-5.8639, 45.5874, -13.35>, <-5.9318, 45.5221, -11.5081> }
				triangle { <-8.1942, 46.2274, -8.06426>, <-5.9318, 45.5221, -11.5081>, <-5.8639, 45.5874, -13.35> }
				triangle { <-7.08827, 35.2186, -16.6284>, <-5.8127, 37.8437, -14.8751>, <-4.1647, 44.8874, -12.5161> }
				triangle { <-7.08827, 35.2186, -16.6284>, <-4.1647, 44.8874, -12.5161>, <-5.8127, 37.8437, -14.8751> }
				triangle { <-8.8101, 35.5819, -15.7451>, <-8.5934, 34.1082, -17.4238>, <-7.08827, 35.2186, -16.6284> }
				triangle { <-8.8101, 35.5819, -15.7451>, <-7.08827, 35.2186, -16.6284>, <-8.5934, 34.1082, -17.4238> }
				triangle { <-7.08827, 35.2186, -16.6284>, <-4.1647, 44.8874, -12.5161>, <-8.8101, 35.5819, -15.7451> }
				triangle { <-7.08827, 35.2186, -16.6284>, <-8.8101, 35.5819, -15.7451>, <-4.1647, 44.8874, -12.5161> }
				triangle { <-5.8639, 45.5874, -13.35>, <-8.8101, 35.5819, -15.7451>, <-4.1647, 44.8874, -12.5161> }
				triangle { <-5.8639, 45.5874, -13.35>, <-4.1647, 44.8874, -12.5161>, <-8.8101, 35.5819, -15.7451> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-8.2371, 46.2793, -7.7832>, <-8.384, 46.1585, -8.1392>, 0.09172 }
				cylinder { <-8.384, 46.1585, -8.1392>, <-8.5285, 46.0284, -8.4928>, 0.09172 }
				cylinder { <-8.5285, 46.0284, -8.4928>, <-8.6708, 45.8889, -8.8438>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-8.6708, 45.8889, -8.8438>, <-8.7282, 45.8531, -8.9158>, 0.006731 }
				cylinder { <-8.7282, 45.8531, -8.9158>, <-8.804, 45.8182, -8.9686>, 0.006731 }
				cylinder { <-8.804, 45.8182, -8.9686>, <-8.8927, 45.7868, -8.9984>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-8.8927, 45.7868, -8.9984>, <-12.3224, 45.7377, -9.1669>, <-12.9099, 44.9806, -9.828> }
				triangle { <-8.8927, 45.7868, -8.9984>, <-12.9099, 44.9806, -9.828>, <-12.3224, 45.7377, -9.1669> }
				triangle { <-12.3224, 45.7377, -9.1669>, <-14.9988, 45.3381, -9.6035>, <-12.9099, 44.9806, -9.828> }
				triangle { <-12.3224, 45.7377, -9.1669>, <-12.9099, 44.9806, -9.828>, <-14.9988, 45.3381, -9.6035> }
				triangle { <-14.9988, 45.3381, -9.6035>, <-14.1147, 43.936, -10.7547>, <-12.9099, 44.9806, -9.828> }
				triangle { <-14.9988, 45.3381, -9.6035>, <-12.9099, 44.9806, -9.828>, <-14.1147, 43.936, -10.7547> }
				triangle { <-12.9099, 44.9806, -9.828>, <-14.1147, 43.936, -10.7547>, <-8.8927, 45.7868, -8.9984> }
				triangle { <-12.9099, 44.9806, -9.828>, <-8.8927, 45.7868, -8.9984>, <-14.1147, 43.936, -10.7547> }
				triangle { <-14.9988, 45.3381, -9.6035>, <-17.2705, 39.9892, -4.692>, <-18.199, 37.0092, -3.3321> }
				triangle { <-14.9988, 45.3381, -9.6035>, <-18.199, 37.0092, -3.3321>, <-17.2705, 39.9892, -4.692> }
				triangle { <-18.199, 37.0092, -3.3321>, <-17.9318, 35.04969, -2.863>, <-16.2974, 36.5001, -3.3744> }
				triangle { <-18.199, 37.0092, -3.3321>, <-16.2974, 36.5001, -3.3744>, <-17.9318, 35.04969, -2.863> }
				triangle { <-16.2974, 36.5001, -3.3744>, <-14.9988, 45.3381, -9.6035>, <-18.199, 37.0092, -3.3321> }
				triangle { <-16.2974, 36.5001, -3.3744>, <-18.199, 37.0092, -3.3321>, <-14.9988, 45.3381, -9.6035> }
				triangle { <-14.9988, 45.3381, -9.6035>, <-16.2974, 36.5001, -3.3744>, <-14.1147, 43.936, -10.7547> }
				triangle { <-14.9988, 45.3381, -9.6035>, <-14.1147, 43.936, -10.7547>, <-16.2974, 36.5001, -3.3744> }
				triangle { <-12.2733, 43.9711, -10.6569>, <-11.1201, 43.8309, -10.7325>, <-8.8927, 45.7868, -8.9984> }
				triangle { <-12.2733, 43.9711, -10.6569>, <-8.8927, 45.7868, -8.9984>, <-11.1201, 43.8309, -10.7325> }
				triangle { <-12.2733, 43.9711, -10.6569>, <-13.2306, 42.534, -11.9059>, <-11.1201, 43.8309, -10.7325> }
				triangle { <-12.2733, 43.9711, -10.6569>, <-11.1201, 43.8309, -10.7325>, <-13.2306, 42.534, -11.9059> }
				triangle { <-12.2733, 43.9711, -10.6569>, <-14.1147, 43.936, -10.7547>, <-13.2306, 42.534, -11.9059> }
				triangle { <-12.2733, 43.9711, -10.6569>, <-13.2306, 42.534, -11.9059>, <-14.1147, 43.936, -10.7547> }
				triangle { <-8.8927, 45.7868, -8.9984>, <-14.1147, 43.936, -10.7547>, <-12.2733, 43.9711, -10.6569> }
				triangle { <-8.8927, 45.7868, -8.9984>, <-12.2733, 43.9711, -10.6569>, <-14.1147, 43.936, -10.7547> }
				triangle { <-17.1381, 35.3267, -4.7135>, <-15.4316, 37.07296, -7.08642>, <-13.2306, 42.534, -11.9059> }
				triangle { <-17.1381, 35.3267, -4.7135>, <-13.2306, 42.534, -11.9059>, <-15.4316, 37.07296, -7.08642> }
				triangle { <-16.2974, 36.5001, -3.3744>, <-17.9318, 35.04969, -2.863>, <-17.1381, 35.3267, -4.7135> }
				triangle { <-16.2974, 36.5001, -3.3744>, <-17.1381, 35.3267, -4.7135>, <-17.9318, 35.04969, -2.863> }
				triangle { <-17.1381, 35.3267, -4.7135>, <-13.2306, 42.534, -11.9059>, <-16.2974, 36.5001, -3.3744> }
				triangle { <-17.1381, 35.3267, -4.7135>, <-16.2974, 36.5001, -3.3744>, <-13.2306, 42.534, -11.9059> }
				triangle { <-14.1147, 43.936, -10.7547>, <-16.2974, 36.5001, -3.3744>, <-13.2306, 42.534, -11.9059> }
				triangle { <-14.1147, 43.936, -10.7547>, <-13.2306, 42.534, -11.9059>, <-16.2974, 36.5001, -3.3744> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-8.6708, 45.8889, -8.8438>, <-8.8131, 45.7495, -9.1948>, 0.09172 }
				cylinder { <-8.8131, 45.7495, -9.1948>, <-8.9554, 45.61, -9.5459>, 0.09172 }
				cylinder { <-8.9554, 45.61, -9.5459>, <-9.09767, 45.4706, -9.8969>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-9.09767, 45.4706, -9.8969>, <-9.1073, 45.4406, -9.9905>, 0.006731 }
				cylinder { <-9.1073, 45.4406, -9.9905>, <-9.09129, 45.417, -10.085>, 0.006731 }
				cylinder { <-9.09129, 45.417, -10.085>, <-9.05058, 45.4014, -10.1735>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-9.05058, 45.4014, -10.1735>, <-8.9163, 45.3057, -13.6038>, <-7.9691, 44.9635, -14.1878> }
				triangle { <-9.05058, 45.4014, -10.1735>, <-7.9691, 44.9635, -14.1878>, <-8.9163, 45.3057, -13.6038> }
				triangle { <-8.9163, 45.3057, -13.6038>, <-8.3655, 45.07381, -16.2789>, <-7.9691, 44.9635, -14.1878> }
				triangle { <-8.9163, 45.3057, -13.6038>, <-7.9691, 44.9635, -14.1878>, <-8.3655, 45.07381, -16.2789> }
				triangle { <-8.3655, 45.07381, -16.2789>, <-6.6538, 44.4829, -15.3881>, <-7.9691, 44.9635, -14.1878> }
				triangle { <-8.3655, 45.07381, -16.2789>, <-7.9691, 44.9635, -14.1878>, <-6.6538, 44.4829, -15.3881> }
				triangle { <-7.9691, 44.9635, -14.1878>, <-6.6538, 44.4829, -15.3881>, <-9.05058, 45.4014, -10.1735> }
				triangle { <-7.9691, 44.9635, -14.1878>, <-9.05058, 45.4014, -10.1735>, <-6.6538, 44.4829, -15.3881> }
				triangle { <-8.3655, 45.07381, -16.2789>, <-9.9172, 37.8891, -18.2458>, <-9.5911, 34.5958, -19.04533> }
				triangle { <-8.3655, 45.07381, -16.2789>, <-9.5911, 34.5958, -19.04533>, <-9.9172, 37.8891, -18.2458> }
				triangle { <-9.5911, 34.5958, -19.04533>, <-9.000978, 32.6805, -18.7066>, <-9.277, 34.2552, -17.1315> }
				triangle { <-9.5911, 34.5958, -19.04533>, <-9.277, 34.2552, -17.1315>, <-9.000978, 32.6805, -18.7066> }
				triangle { <-9.277, 34.2552, -17.1315>, <-8.3655, 45.07381, -16.2789>, <-9.5911, 34.5958, -19.04533> }
				triangle { <-9.277, 34.2552, -17.1315>, <-9.5911, 34.5958, -19.04533>, <-8.3655, 45.07381, -16.2789> }
				triangle { <-8.3655, 45.07381, -16.2789>, <-9.277, 34.2552, -17.1315>, <-6.6538, 44.4829, -15.3881> }
				triangle { <-8.3655, 45.07381, -16.2789>, <-6.6538, 44.4829, -15.3881>, <-9.277, 34.2552, -17.1315> }
				triangle { <-6.7367, 44.5381, -13.5465>, <-6.5884, 44.5021, -12.3923>, <-9.05058, 45.4014, -10.1735> }
				triangle { <-6.7367, 44.5381, -13.5465>, <-9.05058, 45.4014, -10.1735>, <-6.5884, 44.5021, -12.3923> }
				triangle { <-6.7367, 44.5381, -13.5465>, <-4.9421, 43.892, -14.4973>, <-6.5884, 44.5021, -12.3923> }
				triangle { <-6.7367, 44.5381, -13.5465>, <-6.5884, 44.5021, -12.3923>, <-4.9421, 43.892, -14.4973> }
				triangle { <-6.7367, 44.5381, -13.5465>, <-6.6538, 44.4829, -15.3881>, <-4.9421, 43.892, -14.4973> }
				triangle { <-6.7367, 44.5381, -13.5465>, <-4.9421, 43.892, -14.4973>, <-6.6538, 44.4829, -15.3881> }
				triangle { <-9.05058, 45.4014, -10.1735>, <-6.6538, 44.4829, -15.3881>, <-6.7367, 44.5381, -13.5465> }
				triangle { <-9.05058, 45.4014, -10.1735>, <-6.7367, 44.5381, -13.5465>, <-6.6538, 44.4829, -15.3881> }
				triangle { <-7.5371, 33.8867, -17.9763>, <-6.3569, 36.6601, -16.3929>, <-4.9421, 43.892, -14.4973> }
				triangle { <-7.5371, 33.8867, -17.9763>, <-4.9421, 43.892, -14.4973>, <-6.3569, 36.6601, -16.3929> }
				triangle { <-9.277, 34.2552, -17.1315>, <-9.000978, 32.6805, -18.7066>, <-7.5371, 33.8867, -17.9763> }
				triangle { <-9.277, 34.2552, -17.1315>, <-7.5371, 33.8867, -17.9763>, <-9.000978, 32.6805, -18.7066> }
				triangle { <-7.5371, 33.8867, -17.9763>, <-4.9421, 43.892, -14.4973>, <-9.277, 34.2552, -17.1315> }
				triangle { <-7.5371, 33.8867, -17.9763>, <-9.277, 34.2552, -17.1315>, <-4.9421, 43.892, -14.4973> }
				triangle { <-6.6538, 44.4829, -15.3881>, <-9.277, 34.2552, -17.1315>, <-4.9421, 43.892, -14.4973> }
				triangle { <-6.6538, 44.4829, -15.3881>, <-4.9421, 43.892, -14.4973>, <-9.277, 34.2552, -17.1315> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-9.09767, 45.4706, -9.8969>, <-9.1324, 45.4365, -9.9827>, 0.006731 }
				cylinder { <-9.1324, 45.4365, -9.9827>, <-9.1672, 45.4023, -10.06866>, 0.006731 }
				cylinder { <-9.1672, 45.4023, -10.06866>, <-9.202, 45.3682, -10.1545>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-9.202, 45.3682, -10.1545>, <-11.504, 44.9203, -12.6634>, <-11.2844, 44.2845, -13.6136> }
				triangle { <-9.202, 45.3682, -10.1545>, <-11.2844, 44.2845, -13.6136>, <-11.504, 44.9203, -12.6634> }
				triangle { <-11.504, 44.9203, -12.6634>, <-13.00403, 44.3009, -14.8723>, <-11.2844, 44.2845, -13.6136> }
				triangle { <-11.504, 44.9203, -12.6634>, <-11.2844, 44.2845, -13.6136>, <-13.00403, 44.3009, -14.8723> }
				triangle { <-13.00403, 44.3009, -14.8723>, <-11.2507, 43.3602, -15.2092>, <-11.2844, 44.2845, -13.6136> }
				triangle { <-13.00403, 44.3009, -14.8723>, <-11.2844, 44.2845, -13.6136>, <-11.2507, 43.3602, -15.2092> }
				triangle { <-11.2844, 44.2845, -13.6136>, <-11.2507, 43.3602, -15.2092>, <-9.202, 45.3682, -10.1545> }
				triangle { <-11.2844, 44.2845, -13.6136>, <-9.202, 45.3682, -10.1545>, <-11.2507, 43.3602, -15.2092> }
				triangle { <-13.00403, 44.3009, -14.8723>, <-16.3972, 37.6407, -13.45>, <-17.1481, 34.3202, -13.4044> }
				triangle { <-13.00403, 44.3009, -14.8723>, <-17.1481, 34.3202, -13.4044>, <-16.3972, 37.6407, -13.45> }
				triangle { <-17.1481, 34.3202, -13.4044>, <-16.7429, 32.3572, -13.06734>, <-15.6397, 34.08843, -12.1602> }
				triangle { <-17.1481, 34.3202, -13.4044>, <-15.6397, 34.08843, -12.1602>, <-16.7429, 32.3572, -13.06734> }
				triangle { <-15.6397, 34.08843, -12.1602>, <-13.00403, 44.3009, -14.8723>, <-17.1481, 34.3202, -13.4044> }
				triangle { <-15.6397, 34.08843, -12.1602>, <-17.1481, 34.3202, -13.4044>, <-13.00403, 44.3009, -14.8723> }
				triangle { <-13.00403, 44.3009, -14.8723>, <-15.6397, 34.08843, -12.1602>, <-11.2507, 43.3602, -15.2092> }
				triangle { <-13.00403, 44.3009, -14.8723>, <-11.2507, 43.3602, -15.2092>, <-15.6397, 34.08843, -12.1602> }
				triangle { <-10.02202, 43.6072, -13.8562>, <-9.1195, 43.6408, -13.1215>, <-9.202, 45.3682, -10.1545> }
				triangle { <-10.02202, 43.6072, -13.8562>, <-9.202, 45.3682, -10.1545>, <-9.1195, 43.6408, -13.1215> }
				triangle { <-10.02202, 43.6072, -13.8562>, <-9.4974, 42.4195, -15.5461>, <-9.1195, 43.6408, -13.1215> }
				triangle { <-10.02202, 43.6072, -13.8562>, <-9.1195, 43.6408, -13.1215>, <-9.4974, 42.4195, -15.5461> }
				triangle { <-10.02202, 43.6072, -13.8562>, <-11.2507, 43.3602, -15.2092>, <-9.4974, 42.4195, -15.5461> }
				triangle { <-10.02202, 43.6072, -13.8562>, <-9.4974, 42.4195, -15.5461>, <-11.2507, 43.3602, -15.2092> }
				triangle { <-9.202, 45.3682, -10.1545>, <-11.2507, 43.3602, -15.2092>, <-10.02202, 43.6072, -13.8562> }
				triangle { <-9.202, 45.3682, -10.1545>, <-10.02202, 43.6072, -13.8562>, <-11.2507, 43.3602, -15.2092> }
				triangle { <-15.04415, 33.1913, -13.8087>, <-12.7503, 35.684, -14.1508>, <-9.4974, 42.4195, -15.5461> }
				triangle { <-15.04415, 33.1913, -13.8087>, <-9.4974, 42.4195, -15.5461>, <-12.7503, 35.684, -14.1508> }
				triangle { <-15.6397, 34.08843, -12.1602>, <-16.7429, 32.3572, -13.06734>, <-15.04415, 33.1913, -13.8087> }
				triangle { <-15.6397, 34.08843, -12.1602>, <-15.04415, 33.1913, -13.8087>, <-16.7429, 32.3572, -13.06734> }
				triangle { <-15.04415, 33.1913, -13.8087>, <-9.4974, 42.4195, -15.5461>, <-15.6397, 34.08843, -12.1602> }
				triangle { <-15.04415, 33.1913, -13.8087>, <-15.6397, 34.08843, -12.1602>, <-9.4974, 42.4195, -15.5461> }
				triangle { <-11.2507, 43.3602, -15.2092>, <-15.6397, 34.08843, -12.1602>, <-9.4974, 42.4195, -15.5461> }
				triangle { <-11.2507, 43.3602, -15.2092>, <-9.4974, 42.4195, -15.5461>, <-15.6397, 34.08843, -12.1602> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-6.1384, 46.1545, -3.1932>, <-6.5251, 47.3265, -3.729>, 0.09172 }
			cylinder { <-6.5251, 47.3265, -3.729>, <-6.7598, 48.6412, -3.8917>, 0.09172 }
			cylinder { <-6.7598, 48.6412, -3.8917>, <-6.8189, 49.966, -3.6648>, 0.09172 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-6.8189, 49.966, -3.6648>, <-6.8324, 50.3619, -3.5879>, 0.09172 }
				cylinder { <-6.8324, 50.3619, -3.5879>, <-6.8418, 50.7562, -3.5021>, 0.09172 }
				cylinder { <-6.8418, 50.7562, -3.5021>, <-6.8469, 51.1486, -3.4076>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.8469, 51.1486, -3.4076>, <-6.8719, 51.2382, -3.3745>, 0.006731 }
				cylinder { <-6.8719, 51.2382, -3.3745>, <-6.9189, 51.3149, -3.3339>, 0.006731 }
				cylinder { <-6.9189, 51.3149, -3.3339>, <-6.9845, 51.3731, -3.2886>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.9845, 51.3731, -3.2886>, <-8.7454, 54.26, -2.6894>, <-9.5441, 54.3474, -1.8469> }
				triangle { <-6.9845, 51.3731, -3.2886>, <-9.5441, 54.3474, -1.8469>, <-8.7454, 54.26, -2.6894> }
				triangle { <-8.7454, 54.26, -2.6894>, <-10.3594, 56.3163, -1.8648>, <-9.5441, 54.3474, -1.8469> }
				triangle { <-8.7454, 54.26, -2.6894>, <-9.5441, 54.3474, -1.8469>, <-10.3594, 56.3163, -1.8648> }
				triangle { <-10.3594, 56.3163, -1.8648>, <-10.8447, 54.8029, -0.6212>, <-9.5441, 54.3474, -1.8469> }
				triangle { <-10.3594, 56.3163, -1.8648>, <-9.5441, 54.3474, -1.8469>, <-10.8447, 54.8029, -0.6212> }
				triangle { <-9.5441, 54.3474, -1.8469>, <-10.8447, 54.8029, -0.6212>, <-6.9845, 51.3731, -3.2886> }
				triangle { <-9.5441, 54.3474, -1.8469>, <-6.9845, 51.3731, -3.2886>, <-10.8447, 54.8029, -0.6212> }
				triangle { <-10.3594, 56.3163, -1.8648>, <-6.6988, 59.8822, 3.7724>, <-5.7098, 60.9189, 6.8609> }
				triangle { <-10.3594, 56.3163, -1.8648>, <-5.7098, 60.9189, 6.8609>, <-6.6988, 59.8822, 3.7724> }
				triangle { <-5.7098, 60.9189, 6.8609>, <-5.01914, 60.6364, 8.7515>, <-4.8109, 59.1782, 7.05826> }
				triangle { <-5.7098, 60.9189, 6.8609>, <-4.8109, 59.1782, 7.05826>, <-5.01914, 60.6364, 8.7515> }
				triangle { <-4.8109, 59.1782, 7.05826>, <-10.3594, 56.3163, -1.8648>, <-5.7098, 60.9189, 6.8609> }
				triangle { <-4.8109, 59.1782, 7.05826>, <-5.7098, 60.9189, 6.8609>, <-10.3594, 56.3163, -1.8648> }
				triangle { <-10.3594, 56.3163, -1.8648>, <-4.8109, 59.1782, 7.05826>, <-10.8447, 54.8029, -0.6212> }
				triangle { <-10.3594, 56.3163, -1.8648>, <-10.8447, 54.8029, -0.6212>, <-4.8109, 59.1782, 7.05826> }
				triangle { <-9.8936, 53.2577, -0.9515>, <-9.4055, 52.2018, -0.9981>, <-6.9845, 51.3731, -3.2886> }
				triangle { <-9.8936, 53.2577, -0.9515>, <-6.9845, 51.3731, -3.2886>, <-9.4055, 52.2018, -0.9981> }
				triangle { <-9.8936, 53.2577, -0.9515>, <-11.3301, 53.2895, 0.6222>, <-9.4055, 52.2018, -0.9981> }
				triangle { <-9.8936, 53.2577, -0.9515>, <-9.4055, 52.2018, -0.9981>, <-11.3301, 53.2895, 0.6222> }
				triangle { <-9.8936, 53.2577, -0.9515>, <-10.8447, 54.8029, -0.6212>, <-11.3301, 53.2895, 0.6222> }
				triangle { <-9.8936, 53.2577, -0.9515>, <-11.3301, 53.2895, 0.6222>, <-10.8447, 54.8029, -0.6212> }
				triangle { <-6.9845, 51.3731, -3.2886>, <-10.8447, 54.8029, -0.6212>, <-9.8936, 53.2577, -0.9515> }
				triangle { <-6.9845, 51.3731, -3.2886>, <-9.8936, 53.2577, -0.9515>, <-10.8447, 54.8029, -0.6212> }
				triangle { <-6.2922, 59.1028, 8.3533>, <-7.7084, 56.7343, 6.3591>, <-11.3301, 53.2895, 0.6222> }
				triangle { <-6.2922, 59.1028, 8.3533>, <-11.3301, 53.2895, 0.6222>, <-7.7084, 56.7343, 6.3591> }
				triangle { <-4.8109, 59.1782, 7.05826>, <-5.01914, 60.6364, 8.7515>, <-6.2922, 59.1028, 8.3533> }
				triangle { <-4.8109, 59.1782, 7.05826>, <-6.2922, 59.1028, 8.3533>, <-5.01914, 60.6364, 8.7515> }
				triangle { <-6.2922, 59.1028, 8.3533>, <-11.3301, 53.2895, 0.6222>, <-4.8109, 59.1782, 7.05826> }
				triangle { <-6.2922, 59.1028, 8.3533>, <-4.8109, 59.1782, 7.05826>, <-11.3301, 53.2895, 0.6222> }
				triangle { <-10.8447, 54.8029, -0.6212>, <-4.8109, 59.1782, 7.05826>, <-11.3301, 53.2895, 0.6222> }
				triangle { <-10.8447, 54.8029, -0.6212>, <-11.3301, 53.2895, 0.6222>, <-4.8109, 59.1782, 7.05826> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.8469, 51.1486, -3.4076>, <-6.8478, 51.5388, -3.3045>, 0.09172 }
				cylinder { <-6.8478, 51.5388, -3.3045>, <-6.8445, 51.9266, -3.1926>, 0.09172 }
				cylinder { <-6.8445, 51.9266, -3.1926>, <-6.837, 52.3117, -3.07228>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.837, 52.3117, -3.07228>, <-6.8114, 52.4055, -3.05471>, 0.006731 }
				cylinder { <-6.8114, 52.4055, -3.05471>, <-6.7639, 52.4919, -3.0503>, 0.006731 }
				cylinder { <-6.7639, 52.4919, -3.0503>, <-6.6979, 52.5648, -3.05937>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.6979, 52.5648, -3.05937>, <-4.2686, 54.4381, -4.603>, <-3.7744, 55.3653, -4.1015> }
				triangle { <-6.6979, 52.5648, -3.05937>, <-3.7744, 55.3653, -4.1015>, <-4.2686, 54.4381, -4.603> }
				triangle { <-4.2686, 54.4381, -4.603>, <-2.3352, 56.1925, -5.438>, <-3.7744, 55.3653, -4.1015> }
				triangle { <-4.2686, 54.4381, -4.603>, <-3.7744, 55.3653, -4.1015>, <-2.3352, 56.1925, -5.438> }
				triangle { <-2.3352, 56.1925, -5.438>, <-2.8139, 56.8553, -3.593>, <-3.7744, 55.3653, -4.1015> }
				triangle { <-2.3352, 56.1925, -5.438>, <-3.7744, 55.3653, -4.1015>, <-2.8139, 56.8553, -3.593> }
				triangle { <-3.7744, 55.3653, -4.1015>, <-2.8139, 56.8553, -3.593>, <-6.6979, 52.5648, -3.05937> }
				triangle { <-3.7744, 55.3653, -4.1015>, <-6.6979, 52.5648, -3.05937>, <-2.8139, 56.8553, -3.593> }
				triangle { <-2.3352, 56.1925, -5.438>, <4.3167, 53.5541, -2.8527>, <7.1291, 53.09902, -0.9884> }
				triangle { <-2.3352, 56.1925, -5.438>, <7.1291, 53.09902, -0.9884>, <4.3167, 53.5541, -2.8527> }
				triangle { <7.1291, 53.09902, -0.9884>, <8.142, 52.7242, 0.7333>, <5.9877, 52.2217, 0.3549> }
				triangle { <7.1291, 53.09902, -0.9884>, <5.9877, 52.2217, 0.3549>, <8.142, 52.7242, 0.7333> }
				triangle { <5.9877, 52.2217, 0.3549>, <-2.3352, 56.1925, -5.438>, <7.1291, 53.09902, -0.9884> }
				triangle { <5.9877, 52.2217, 0.3549>, <7.1291, 53.09902, -0.9884>, <-2.3352, 56.1925, -5.438> }
				triangle { <-2.3352, 56.1925, -5.438>, <5.9877, 52.2217, 0.3549>, <-2.8139, 56.8553, -3.593> }
				triangle { <-2.3352, 56.1925, -5.438>, <-2.8139, 56.8553, -3.593>, <5.9877, 52.2217, 0.3549> }
				triangle { <-4.119, 55.8425, -2.7731>, <-4.9195, 55.3395, -2.09381>, <-6.6979, 52.5648, -3.05937> }
				triangle { <-4.119, 55.8425, -2.7731>, <-6.6979, 52.5648, -3.05937>, <-4.9195, 55.3395, -2.09381> }
				triangle { <-4.119, 55.8425, -2.7731>, <-3.2925, 57.5181, -1.748>, <-4.9195, 55.3395, -2.09381> }
				triangle { <-4.119, 55.8425, -2.7731>, <-4.9195, 55.3395, -2.09381>, <-3.2925, 57.5181, -1.748> }
				triangle { <-4.119, 55.8425, -2.7731>, <-2.8139, 56.8553, -3.593>, <-3.2925, 57.5181, -1.748> }
				triangle { <-4.119, 55.8425, -2.7731>, <-3.2925, 57.5181, -1.748>, <-2.8139, 56.8553, -3.593> }
				triangle { <-6.6979, 52.5648, -3.05937>, <-2.8139, 56.8553, -3.593>, <-4.119, 55.8425, -2.7731> }
				triangle { <-6.6979, 52.5648, -3.05937>, <-4.119, 55.8425, -2.7731>, <-2.8139, 56.8553, -3.593> }
				triangle { <6.5547, 53.8943, 1.2255>, <3.3211, 54.9327, 0.9848>, <-3.2925, 57.5181, -1.748> }
				triangle { <6.5547, 53.8943, 1.2255>, <-3.2925, 57.5181, -1.748>, <3.3211, 54.9327, 0.9848> }
				triangle { <5.9877, 52.2217, 0.3549>, <8.142, 52.7242, 0.7333>, <6.5547, 53.8943, 1.2255> }
				triangle { <5.9877, 52.2217, 0.3549>, <6.5547, 53.8943, 1.2255>, <8.142, 52.7242, 0.7333> }
				triangle { <6.5547, 53.8943, 1.2255>, <-3.2925, 57.5181, -1.748>, <5.9877, 52.2217, 0.3549> }
				triangle { <6.5547, 53.8943, 1.2255>, <5.9877, 52.2217, 0.3549>, <-3.2925, 57.5181, -1.748> }
				triangle { <-2.8139, 56.8553, -3.593>, <5.9877, 52.2217, 0.3549>, <-3.2925, 57.5181, -1.748> }
				triangle { <-2.8139, 56.8553, -3.593>, <-3.2925, 57.5181, -1.748>, <5.9877, 52.2217, 0.3549> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.837, 52.3117, -3.07228>, <-6.8295, 52.6969, -2.9518>, 0.09172 }
				cylinder { <-6.8295, 52.6969, -2.9518>, <-6.8219, 53.0821, -2.8314>, 0.09172 }
				cylinder { <-6.8219, 53.0821, -2.8314>, <-6.8144, 53.4672, -2.711>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.8144, 53.4672, -2.711>, <-6.8365, 53.5551, -2.6718>, 0.006731 }
				cylinder { <-6.8365, 53.5551, -2.6718>, <-6.8808, 53.6303, -2.6257>, 0.006731 }
				cylinder { <-6.8808, 53.6303, -2.6257>, <-6.9443, 53.6873, -2.5761>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.9443, 53.6873, -2.5761>, <-8.612, 56.5793, -1.7703>, <-9.4016, 56.6341, -0.9166> }
				triangle { <-6.9443, 53.6873, -2.5761>, <-9.4016, 56.6341, -0.9166>, <-8.612, 56.5793, -1.7703> }
				triangle { <-8.612, 56.5793, -1.7703>, <-10.1566, 58.6234, -0.7962>, <-9.4016, 56.6341, -0.9166> }
				triangle { <-8.612, 56.5793, -1.7703>, <-9.4016, 56.6341, -0.9166>, <-10.1566, 58.6234, -0.7962> }
				triangle { <-10.1566, 58.6234, -0.7962>, <-10.679, 57.04567, 0.3484>, <-9.4016, 56.6341, -0.9166> }
				triangle { <-10.1566, 58.6234, -0.7962>, <-9.4016, 56.6341, -0.9166>, <-10.679, 57.04567, 0.3484> }
				triangle { <-9.4016, 56.6341, -0.9166>, <-10.679, 57.04567, 0.3484>, <-6.9443, 53.6873, -2.5761> }
				triangle { <-9.4016, 56.6341, -0.9166>, <-6.9443, 53.6873, -2.5761>, <-10.679, 57.04567, 0.3484> }
				triangle { <-10.1566, 58.6234, -0.7962>, <-6.3489, 61.6942, 5.03187>, <-5.3067, 62.4925, 8.1733> }
				triangle { <-10.1566, 58.6234, -0.7962>, <-5.3067, 62.4925, 8.1733>, <-6.3489, 61.6942, 5.03187> }
				triangle { <-5.3067, 62.4925, 8.1733>, <-4.6114, 62.06391, 10.03452>, <-4.4599, 60.7163, 8.2462> }
				triangle { <-5.3067, 62.4925, 8.1733>, <-4.4599, 60.7163, 8.2462>, <-4.6114, 62.06391, 10.03452> }
				triangle { <-4.4599, 60.7163, 8.2462>, <-10.1566, 58.6234, -0.7962>, <-5.3067, 62.4925, 8.1733> }
				triangle { <-4.4599, 60.7163, 8.2462>, <-5.3067, 62.4925, 8.1733>, <-10.1566, 58.6234, -0.7962> }
				triangle { <-10.1566, 58.6234, -0.7962>, <-4.4599, 60.7163, 8.2462>, <-10.679, 57.04567, 0.3484> }
				triangle { <-10.1566, 58.6234, -0.7962>, <-10.679, 57.04567, 0.3484>, <-4.4599, 60.7163, 8.2462> }
				triangle { <-9.7778, 55.4981, -0.09246>, <-9.3225, 54.4335, -0.2136>, <-6.9443, 53.6873, -2.5761> }
				triangle { <-9.7778, 55.4981, -0.09246>, <-6.9443, 53.6873, -2.5761>, <-9.3225, 54.4335, -0.2136> }
				triangle { <-9.7778, 55.4981, -0.09246>, <-11.2014, 55.4679, 1.4931>, <-9.3225, 54.4335, -0.2136> }
				triangle { <-9.7778, 55.4981, -0.09246>, <-9.3225, 54.4335, -0.2136>, <-11.2014, 55.4679, 1.4931> }
				triangle { <-9.7778, 55.4981, -0.09246>, <-10.679, 57.04567, 0.3484>, <-11.2014, 55.4679, 1.4931> }
				triangle { <-9.7778, 55.4981, -0.09246>, <-11.2014, 55.4679, 1.4931>, <-10.679, 57.04567, 0.3484> }
				triangle { <-6.9443, 53.6873, -2.5761>, <-10.679, 57.04567, 0.3484>, <-9.7778, 55.4981, -0.09246> }
				triangle { <-6.9443, 53.6873, -2.5761>, <-9.7778, 55.4981, -0.09246>, <-10.679, 57.04567, 0.3484> }
				triangle { <-5.9335, 60.5991, 9.5468>, <-7.4355, 58.4124, 7.4127>, <-11.2014, 55.4679, 1.4931> }
				triangle { <-5.9335, 60.5991, 9.5468>, <-11.2014, 55.4679, 1.4931>, <-7.4355, 58.4124, 7.4127> }
				triangle { <-4.4599, 60.7163, 8.2462>, <-4.6114, 62.06391, 10.03452>, <-5.9335, 60.5991, 9.5468> }
				triangle { <-4.4599, 60.7163, 8.2462>, <-5.9335, 60.5991, 9.5468>, <-4.6114, 62.06391, 10.03452> }
				triangle { <-5.9335, 60.5991, 9.5468>, <-11.2014, 55.4679, 1.4931>, <-4.4599, 60.7163, 8.2462> }
				triangle { <-5.9335, 60.5991, 9.5468>, <-4.4599, 60.7163, 8.2462>, <-11.2014, 55.4679, 1.4931> }
				triangle { <-10.679, 57.04567, 0.3484>, <-4.4599, 60.7163, 8.2462>, <-11.2014, 55.4679, 1.4931> }
				triangle { <-10.679, 57.04567, 0.3484>, <-11.2014, 55.4679, 1.4931>, <-4.4599, 60.7163, 8.2462> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.8144, 53.4672, -2.711>, <-6.8126, 53.5614, -2.6816>, 0.006731 }
				cylinder { <-6.8126, 53.5614, -2.6816>, <-6.8107, 53.6557, -2.6521>, 0.006731 }
				cylinder { <-6.8107, 53.6557, -2.6521>, <-6.8089, 53.7499, -2.6227>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.8089, 53.7499, -2.6227>, <-6.1002, 57.1031, -2.8407>, <-6.3881, 57.8633, -2.007281> }
				triangle { <-6.8089, 53.7499, -2.6227>, <-6.3881, 57.8633, -2.007281>, <-6.1002, 57.1031, -2.8407> }
				triangle { <-6.1002, 57.1031, -2.8407>, <-5.7447, 59.8094, -2.5906>, <-6.3881, 57.8633, -2.007281> }
				triangle { <-6.1002, 57.1031, -2.8407>, <-6.3881, 57.8633, -2.007281>, <-5.7447, 59.8094, -2.5906> }
				triangle { <-5.7447, 59.8094, -2.5906>, <-6.7007, 59.2962, -0.889>, <-6.3881, 57.8633, -2.007281> }
				triangle { <-5.7447, 59.8094, -2.5906>, <-6.3881, 57.8633, -2.007281>, <-6.7007, 59.2962, -0.889> }
				triangle { <-6.3881, 57.8633, -2.007281>, <-6.7007, 59.2962, -0.889>, <-6.8089, 53.7499, -2.6227> }
				triangle { <-6.3881, 57.8633, -2.007281>, <-6.8089, 53.7499, -2.6227>, <-6.7007, 59.2962, -0.889> }
				triangle { <-5.7447, 59.8094, -2.5906>, <0.7323, 60.8462, 1.2651>, <2.967, 61.461, 3.7592> }
				triangle { <-5.7447, 59.8094, -2.5906>, <2.967, 61.461, 3.7592>, <0.7323, 60.8462, 1.2651> }
				triangle { <2.967, 61.461, 3.7592>, <3.8195, 61.1307, 5.5745>, <2.5781, 59.6515, 4.4309> }
				triangle { <2.967, 61.461, 3.7592>, <2.5781, 59.6515, 4.4309>, <3.8195, 61.1307, 5.5745> }
				triangle { <2.5781, 59.6515, 4.4309>, <-5.7447, 59.8094, -2.5906>, <2.967, 61.461, 3.7592> }
				triangle { <2.5781, 59.6515, 4.4309>, <2.967, 61.461, 3.7592>, <-5.7447, 59.8094, -2.5906> }
				triangle { <-5.7447, 59.8094, -2.5906>, <2.5781, 59.6515, 4.4309>, <-6.7007, 59.2962, -0.889> }
				triangle { <-5.7447, 59.8094, -2.5906>, <-6.7007, 59.2962, -0.889>, <2.5781, 59.6515, 4.4309> }
				triangle { <-7.07642, 57.4938, -0.7821>, <-7.4003, 56.4051, -0.5266>, <-6.8089, 53.7499, -2.6227> }
				triangle { <-7.07642, 57.4938, -0.7821>, <-6.8089, 53.7499, -2.6227>, <-7.4003, 56.4051, -0.5266> }
				triangle { <-7.07642, 57.4938, -0.7821>, <-7.6566, 58.783, 0.8125>, <-7.4003, 56.4051, -0.5266> }
				triangle { <-7.07642, 57.4938, -0.7821>, <-7.4003, 56.4051, -0.5266>, <-7.6566, 58.783, 0.8125> }
				triangle { <-7.07642, 57.4938, -0.7821>, <-6.7007, 59.2962, -0.889>, <-7.6566, 58.783, 0.8125> }
				triangle { <-7.07642, 57.4938, -0.7821>, <-7.6566, 58.783, 0.8125>, <-6.7007, 59.2962, -0.889> }
				triangle { <-6.8089, 53.7499, -2.6227>, <-6.7007, 59.2962, -0.889>, <-7.07642, 57.4938, -0.7821> }
				triangle { <-6.8089, 53.7499, -2.6227>, <-7.07642, 57.4938, -0.7821>, <-6.7007, 59.2962, -0.889> }
				triangle { <1.8199, 60.8452, 5.801>, <-1.256, 59.7787, 4.8044>, <-7.6566, 58.783, 0.8125> }
				triangle { <1.8199, 60.8452, 5.801>, <-7.6566, 58.783, 0.8125>, <-1.256, 59.7787, 4.8044> }
				triangle { <2.5781, 59.6515, 4.4309>, <3.8195, 61.1307, 5.5745>, <1.8199, 60.8452, 5.801> }
				triangle { <2.5781, 59.6515, 4.4309>, <1.8199, 60.8452, 5.801>, <3.8195, 61.1307, 5.5745> }
				triangle { <1.8199, 60.8452, 5.801>, <-7.6566, 58.783, 0.8125>, <2.5781, 59.6515, 4.4309> }
				triangle { <1.8199, 60.8452, 5.801>, <2.5781, 59.6515, 4.4309>, <-7.6566, 58.783, 0.8125> }
				triangle { <-6.7007, 59.2962, -0.889>, <2.5781, 59.6515, 4.4309>, <-7.6566, 58.783, 0.8125> }
				triangle { <-6.7007, 59.2962, -0.889>, <-7.6566, 58.783, 0.8125>, <2.5781, 59.6515, 4.4309> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-4.582, 42.1254, -0.8505>, <-4.7409, 43.7799, -0.7545>, 0.3027 }
		cylinder { <-4.7409, 43.7799, -0.7545>, <-4.7794, 45.4063, -0.4008>, 0.3027 }
		cylinder { <-4.7794, 45.4063, -0.4008>, <-4.6964, 46.9567, 0.1999>, 0.3027 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-4.6964, 46.9567, 0.1999>, <-4.4544, 48.00002, 1.01425>, 0.09172 }
			cylinder { <-4.4544, 48.00002, 1.01425>, <-4.062, 48.7282, 2.07523>, 0.09172 }
			cylinder { <-4.062, 48.7282, 2.07523>, <-3.5586, 49.06793, 3.2757>, 0.09172 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-3.5586, 49.06793, 3.2757>, <-3.4056, 49.1602, 3.6376>, 0.09172 }
				cylinder { <-3.4056, 49.1602, 3.6376>, <-3.2508, 49.243, 4.001079>, 0.09172 }
				cylinder { <-3.2508, 49.243, 4.001079>, <-3.09422, 49.3161, 4.3658>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-3.09422, 49.3161, 4.3658>, <-3.08113, 49.3304, 4.4626>, 0.006731 }
				cylinder { <-3.08113, 49.3304, 4.4626>, <-3.0942, 49.3401, 4.5599>, 0.006731 }
				cylinder { <-3.0942, 49.3401, 4.5599>, <-3.1325, 49.3445, 4.6508>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-3.1325, 49.3445, 4.6508>, <-3.4986, 50.5127, 7.8595>, <-4.2766, 50.07248, 8.6052> }
				triangle { <-3.1325, 49.3445, 4.6508>, <-4.2766, 50.07248, 8.6052>, <-3.4986, 50.5127, 7.8595> }
				triangle { <-3.4986, 50.5127, 7.8595>, <-4.1295, 51.1153, 10.4579>, <-4.2766, 50.07248, 8.6052> }
				triangle { <-3.4986, 50.5127, 7.8595>, <-4.2766, 50.07248, 8.6052>, <-4.1295, 51.1153, 10.4579> }
				triangle { <-4.1295, 51.1153, 10.4579>, <-5.3867, 49.6042, 10.00158>, <-4.2766, 50.07248, 8.6052> }
				triangle { <-4.1295, 51.1153, 10.4579>, <-4.2766, 50.07248, 8.6052>, <-5.3867, 49.6042, 10.00158> }
				triangle { <-4.2766, 50.07248, 8.6052>, <-5.3867, 49.6042, 10.00158>, <-3.1325, 49.3445, 4.6508> }
				triangle { <-4.2766, 50.07248, 8.6052>, <-3.1325, 49.3445, 4.6508>, <-5.3867, 49.6042, 10.00158> }
				triangle { <-4.1295, 51.1153, 10.4579>, <-0.021, 46.4725, 14.8692>, <0.9223, 43.8938, 16.8823> }
				triangle { <-4.1295, 51.1153, 10.4579>, <0.9223, 43.8938, 16.8823>, <-0.021, 46.4725, 14.8692> }
				triangle { <0.9223, 43.8938, 16.8823>, <1.1706, 41.9304, 17.3453>, <0.9273, 42.7585, 15.2736> }
				triangle { <0.9223, 43.8938, 16.8823>, <0.9273, 42.7585, 15.2736>, <1.1706, 41.9304, 17.3453> }
				triangle { <0.9273, 42.7585, 15.2736>, <-4.1295, 51.1153, 10.4579>, <0.9223, 43.8938, 16.8823> }
				triangle { <0.9273, 42.7585, 15.2736>, <0.9223, 43.8938, 16.8823>, <-4.1295, 51.1153, 10.4579> }
				triangle { <-4.1295, 51.1153, 10.4579>, <0.9273, 42.7585, 15.2736>, <-5.3867, 49.6042, 10.00158> }
				triangle { <-4.1295, 51.1153, 10.4579>, <-5.3867, 49.6042, 10.00158>, <0.9273, 42.7585, 15.2736> }
				triangle { <-5.1819, 48.9844, 8.2766>, <-5.2085, 48.4576, 7.2388>, <-3.1325, 49.3445, 4.6508> }
				triangle { <-5.1819, 48.9844, 8.2766>, <-3.1325, 49.3445, 4.6508>, <-5.2085, 48.4576, 7.2388> }
				triangle { <-5.1819, 48.9844, 8.2766>, <-6.644, 48.09307, 9.5451>, <-5.2085, 48.4576, 7.2388> }
				triangle { <-5.1819, 48.9844, 8.2766>, <-5.2085, 48.4576, 7.2388>, <-6.644, 48.09307, 9.5451> }
				triangle { <-5.1819, 48.9844, 8.2766>, <-5.3867, 49.6042, 10.00158>, <-6.644, 48.09307, 9.5451> }
				triangle { <-5.1819, 48.9844, 8.2766>, <-6.644, 48.09307, 9.5451>, <-5.3867, 49.6042, 10.00158> }
				triangle { <-3.1325, 49.3445, 4.6508>, <-5.3867, 49.6042, 10.00158>, <-5.1819, 48.9844, 8.2766> }
				triangle { <-3.1325, 49.3445, 4.6508>, <-5.1819, 48.9844, 8.2766>, <-5.3867, 49.6042, 10.00158> }
				triangle { <-0.5864, 42.08052, 16.3347>, <-2.6361, 43.3293, 13.92>, <-6.644, 48.09307, 9.5451> }
				triangle { <-0.5864, 42.08052, 16.3347>, <-6.644, 48.09307, 9.5451>, <-2.6361, 43.3293, 13.92> }
				triangle { <0.9273, 42.7585, 15.2736>, <1.1706, 41.9304, 17.3453>, <-0.5864, 42.08052, 16.3347> }
				triangle { <0.9273, 42.7585, 15.2736>, <-0.5864, 42.08052, 16.3347>, <1.1706, 41.9304, 17.3453> }
				triangle { <-0.5864, 42.08052, 16.3347>, <-6.644, 48.09307, 9.5451>, <0.9273, 42.7585, 15.2736> }
				triangle { <-0.5864, 42.08052, 16.3347>, <0.9273, 42.7585, 15.2736>, <-6.644, 48.09307, 9.5451> }
				triangle { <-5.3867, 49.6042, 10.00158>, <0.9273, 42.7585, 15.2736>, <-6.644, 48.09307, 9.5451> }
				triangle { <-5.3867, 49.6042, 10.00158>, <-6.644, 48.09307, 9.5451>, <0.9273, 42.7585, 15.2736> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-3.09422, 49.3161, 4.3658>, <-2.9359, 49.3795, 4.7316>, 0.09172 }
				cylinder { <-2.9359, 49.3795, 4.7316>, <-2.776, 49.4331, 5.09832>, 0.09172 }
				cylinder { <-2.776, 49.4331, 5.09832>, <-2.6146, 49.477, 5.4656>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-2.6146, 49.477, 5.4656>, <-2.5528, 49.4903, 5.5414>, 0.006731 }
				cylinder { <-2.5528, 49.4903, 5.5414>, <-2.473, 49.5051, 5.5976>, 0.006731 }
				cylinder { <-2.473, 49.5051, 5.5976>, <-2.381, 49.5204, 5.6302>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-2.381, 49.5204, 5.6302>, <0.7999, 50.8139, 5.5863>, <1.5843, 50.5854, 6.4157> }
				triangle { <-2.381, 49.5204, 5.6302>, <1.5843, 50.5854, 6.4157>, <0.7999, 50.8139, 5.5863> }
				triangle { <0.7999, 50.8139, 5.5863>, <3.3978, 51.606, 5.9559>, <1.5843, 50.5854, 6.4157> }
				triangle { <0.7999, 50.8139, 5.5863>, <1.5843, 50.5854, 6.4157>, <3.3978, 51.606, 5.9559> }
				triangle { <3.3978, 51.606, 5.9559>, <3.03055, 50.4223, 7.5485>, <1.5843, 50.5854, 6.4157> }
				triangle { <3.3978, 51.606, 5.9559>, <1.5843, 50.5854, 6.4157>, <3.03055, 50.4223, 7.5485> }
				triangle { <1.5843, 50.5854, 6.4157>, <3.03055, 50.4223, 7.5485>, <-2.381, 49.5204, 5.6302> }
				triangle { <1.5843, 50.5854, 6.4157>, <-2.381, 49.5204, 5.6302>, <3.03055, 50.4223, 7.5485> }
				triangle { <3.3978, 51.606, 5.9559>, <7.8132, 46.2292, 2.8755>, <9.8733, 43.5471, 2.4823> }
				triangle { <3.3978, 51.606, 5.9559>, <9.8733, 43.5471, 2.4823>, <7.8132, 46.2292, 2.8755> }
				triangle { <9.8733, 43.5471, 2.4823>, <10.3887, 41.5912, 2.6816>, <8.3014, 42.4064, 2.8062> }
				triangle { <9.8733, 43.5471, 2.4823>, <8.3014, 42.4064, 2.8062>, <10.3887, 41.5912, 2.6816> }
				triangle { <8.3014, 42.4064, 2.8062>, <3.3978, 51.606, 5.9559>, <9.8733, 43.5471, 2.4823> }
				triangle { <8.3014, 42.4064, 2.8062>, <9.8733, 43.5471, 2.4823>, <3.3978, 51.606, 5.9559> }
				triangle { <3.3978, 51.606, 5.9559>, <8.3014, 42.4064, 2.8062>, <3.03055, 50.4223, 7.5485> }
				triangle { <3.3978, 51.606, 5.9559>, <3.03055, 50.4223, 7.5485>, <8.3014, 42.4064, 2.8062> }
				triangle { <1.3199, 49.7331, 7.5623>, <0.3004, 49.204, 7.7523>, <-2.381, 49.5204, 5.6302> }
				triangle { <1.3199, 49.7331, 7.5623>, <-2.381, 49.5204, 5.6302>, <0.3004, 49.204, 7.7523> }
				triangle { <1.3199, 49.7331, 7.5623>, <2.6632, 49.2385, 9.1411>, <0.3004, 49.204, 7.7523> }
				triangle { <1.3199, 49.7331, 7.5623>, <0.3004, 49.204, 7.7523>, <2.6632, 49.2385, 9.1411> }
				triangle { <1.3199, 49.7331, 7.5623>, <3.03055, 50.4223, 7.5485>, <2.6632, 49.2385, 9.1411> }
				triangle { <1.3199, 49.7331, 7.5623>, <2.6632, 49.2385, 9.1411>, <3.03055, 50.4223, 7.5485> }
				triangle { <-2.381, 49.5204, 5.6302>, <3.03055, 50.4223, 7.5485>, <1.3199, 49.7331, 7.5623> }
				triangle { <-2.381, 49.5204, 5.6302>, <1.3199, 49.7331, 7.5623>, <3.03055, 50.4223, 7.5485> }
				triangle { <9.4326, 42.1267, 4.3934>, <7.04929, 43.767, 6.1881>, <2.6632, 49.2385, 9.1411> }
				triangle { <9.4326, 42.1267, 4.3934>, <2.6632, 49.2385, 9.1411>, <7.04929, 43.767, 6.1881> }
				triangle { <8.3014, 42.4064, 2.8062>, <10.3887, 41.5912, 2.6816>, <9.4326, 42.1267, 4.3934> }
				triangle { <8.3014, 42.4064, 2.8062>, <9.4326, 42.1267, 4.3934>, <10.3887, 41.5912, 2.6816> }
				triangle { <9.4326, 42.1267, 4.3934>, <2.6632, 49.2385, 9.1411>, <8.3014, 42.4064, 2.8062> }
				triangle { <9.4326, 42.1267, 4.3934>, <8.3014, 42.4064, 2.8062>, <2.6632, 49.2385, 9.1411> }
				triangle { <3.03055, 50.4223, 7.5485>, <8.3014, 42.4064, 2.8062>, <2.6632, 49.2385, 9.1411> }
				triangle { <3.03055, 50.4223, 7.5485>, <2.6632, 49.2385, 9.1411>, <8.3014, 42.4064, 2.8062> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-2.6146, 49.477, 5.4656>, <-2.4533, 49.5209, 5.8329>, 0.09172 }
				cylinder { <-2.4533, 49.5209, 5.8329>, <-2.2919, 49.5648, 6.2003>, 0.09172 }
				cylinder { <-2.2919, 49.5648, 6.2003>, <-2.1305, 49.6087, 6.5676>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-2.1305, 49.6087, 6.5676>, <-2.1163, 49.6161, 6.665>, 0.006731 }
				cylinder { <-2.1163, 49.6161, 6.665>, <-2.1284, 49.6197, 6.763>, 0.006731 }
				cylinder { <-2.1284, 49.6197, 6.763>, <-2.1659, 49.6191, 6.8543>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-2.1659, 49.6191, 6.8543>, <-2.4733, 50.5812, 10.1367>, <-3.2591, 50.1156, 10.8586> }
				triangle { <-2.1659, 49.6191, 6.8543>, <-3.2591, 50.1156, 10.8586>, <-2.4733, 50.5812, 10.1367> }
				triangle { <-2.4733, 50.5812, 10.1367>, <-3.06701, 51.02775, 12.7751>, <-3.2591, 50.1156, 10.8586> }
				triangle { <-2.4733, 50.5812, 10.1367>, <-3.2591, 50.1156, 10.8586>, <-3.06701, 51.02775, 12.7751> }
				triangle { <-3.06701, 51.02775, 12.7751>, <-4.373, 49.5887, 12.2308>, <-3.2591, 50.1156, 10.8586> }
				triangle { <-3.06701, 51.02775, 12.7751>, <-3.2591, 50.1156, 10.8586>, <-4.373, 49.5887, 12.2308> }
				triangle { <-3.2591, 50.1156, 10.8586>, <-4.373, 49.5887, 12.2308>, <-2.1659, 49.6191, 6.8543> }
				triangle { <-3.2591, 50.1156, 10.8586>, <-2.1659, 49.6191, 6.8543>, <-4.373, 49.5887, 12.2308> }
				triangle { <-3.06701, 51.02775, 12.7751>, <0.9294, 45.9801, 16.8303>, <1.808, 43.2458, 18.6589> }
				triangle { <-3.06701, 51.02775, 12.7751>, <1.808, 43.2458, 18.6589>, <0.9294, 45.9801, 16.8303> }
				triangle { <1.808, 43.2458, 18.6589>, <1.9996, 41.2493, 18.9881>, <1.7669, 42.2207, 16.9783> }
				triangle { <1.808, 43.2458, 18.6589>, <1.7669, 42.2207, 16.9783>, <1.9996, 41.2493, 18.9881> }
				triangle { <1.7669, 42.2207, 16.9783>, <-3.06701, 51.02775, 12.7751>, <1.808, 43.2458, 18.6589> }
				triangle { <1.7669, 42.2207, 16.9783>, <1.808, 43.2458, 18.6589>, <-3.06701, 51.02775, 12.7751> }
				triangle { <-3.06701, 51.02775, 12.7751>, <1.7669, 42.2207, 16.9783>, <-4.373, 49.5887, 12.2308> }
				triangle { <-3.06701, 51.02775, 12.7751>, <-4.373, 49.5887, 12.2308>, <1.7669, 42.2207, 16.9783> }
				triangle { <-4.1994, 49.0796, 10.4667>, <-4.2495, 48.6242, 9.3965>, <-2.1659, 49.6191, 6.8543> }
				triangle { <-4.1994, 49.0796, 10.4667>, <-2.1659, 49.6191, 6.8543>, <-4.2495, 48.6242, 9.3965> }
				triangle { <-4.1994, 49.0796, 10.4667>, <-5.6789, 48.1497, 11.6866>, <-4.2495, 48.6242, 9.3965> }
				triangle { <-4.1994, 49.0796, 10.4667>, <-4.2495, 48.6242, 9.3965>, <-5.6789, 48.1497, 11.6866> }
				triangle { <-4.1994, 49.0796, 10.4667>, <-4.373, 49.5887, 12.2308>, <-5.6789, 48.1497, 11.6866> }
				triangle { <-4.1994, 49.0796, 10.4667>, <-5.6789, 48.1497, 11.6866>, <-4.373, 49.5887, 12.2308> }
				triangle { <-2.1659, 49.6191, 6.8543>, <-4.373, 49.5887, 12.2308>, <-4.1994, 49.0796, 10.4667> }
				triangle { <-2.1659, 49.6191, 6.8543>, <-4.1994, 49.0796, 10.4667>, <-4.373, 49.5887, 12.2308> }
				triangle { <0.2408, 41.519, 18.00587>, <-1.787, 42.987, 15.6983>, <-5.6789, 48.1497, 11.6866> }
				triangle { <0.2408, 41.519, 18.00587>, <-5.6789, 48.1497, 11.6866>, <-1.787, 42.987, 15.6983> }
				triangle { <1.7669, 42.2207, 16.9783>, <1.9996, 41.2493, 18.9881>, <0.2408, 41.519, 18.00587> }
				triangle { <1.7669, 42.2207, 16.9783>, <0.2408, 41.519, 18.00587>, <1.9996, 41.2493, 18.9881> }
				triangle { <0.2408, 41.519, 18.00587>, <-5.6789, 48.1497, 11.6866>, <1.7669, 42.2207, 16.9783> }
				triangle { <0.2408, 41.519, 18.00587>, <1.7669, 42.2207, 16.9783>, <-5.6789, 48.1497, 11.6866> }
				triangle { <-4.373, 49.5887, 12.2308>, <1.7669, 42.2207, 16.9783>, <-5.6789, 48.1497, 11.6866> }
				triangle { <-4.373, 49.5887, 12.2308>, <-5.6789, 48.1497, 11.6866>, <1.7669, 42.2207, 16.9783> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-2.1305, 49.6087, 6.5676>, <-2.0911, 49.6194, 6.6575>, 0.006731 }
				cylinder { <-2.0911, 49.6194, 6.6575>, <-2.05163, 49.6301, 6.7473>, 0.006731 }
				cylinder { <-2.05163, 49.6301, 6.7473>, <-2.01216, 49.6409, 6.8372>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-2.01216, 49.6409, 6.8372>, <0.1251, 50.9127, 9.2054>, <0.09893, 50.5806, 10.3209> }
				triangle { <-2.01216, 49.6409, 6.8372>, <0.09893, 50.5806, 10.3209>, <0.1251, 50.9127, 9.2054> }
				triangle { <0.1251, 50.9127, 9.2054>, <1.6035, 51.6398, 11.3959>, <0.09893, 50.5806, 10.3209> }
				triangle { <0.1251, 50.9127, 9.2054>, <0.09893, 50.5806, 10.3209>, <1.6035, 51.6398, 11.3959> }
				triangle { <1.6035, 51.6398, 11.3959>, <0.3115, 50.2727, 12.1268>, <0.09893, 50.5806, 10.3209> }
				triangle { <1.6035, 51.6398, 11.3959>, <0.09893, 50.5806, 10.3209>, <0.3115, 50.2727, 12.1268> }
				triangle { <0.09893, 50.5806, 10.3209>, <0.3115, 50.2727, 12.1268>, <-2.01216, 49.6409, 6.8372> }
				triangle { <0.09893, 50.5806, 10.3209>, <-2.01216, 49.6409, 6.8372>, <0.3115, 50.2727, 12.1268> }
				triangle { <1.6035, 51.6398, 11.3959>, <7.3242, 46.6549, 11.9618>, <9.2634, 44.02977, 12.9313> }
				triangle { <1.6035, 51.6398, 11.3959>, <9.2634, 44.02977, 12.9313>, <7.3242, 46.6549, 11.9618> }
				triangle { <9.2634, 44.02977, 12.9313>, <9.6439, 42.06132, 13.2653>, <8.03382, 42.8665, 11.9252> }
				triangle { <9.2634, 44.02977, 12.9313>, <8.03382, 42.8665, 11.9252>, <9.6439, 42.06132, 13.2653> }
				triangle { <8.03382, 42.8665, 11.9252>, <1.6035, 51.6398, 11.3959>, <9.2634, 44.02977, 12.9313> }
				triangle { <8.03382, 42.8665, 11.9252>, <9.2634, 44.02977, 12.9313>, <1.6035, 51.6398, 11.3959> }
				triangle { <1.6035, 51.6398, 11.3959>, <8.03382, 42.8665, 11.9252>, <0.3115, 50.2727, 12.1268> }
				triangle { <1.6035, 51.6398, 11.3959>, <0.3115, 50.2727, 12.1268>, <8.03382, 42.8665, 11.9252> }
				triangle { <-0.8313, 49.5963, 10.8471>, <-1.632, 49.05355, 10.1994>, <-2.01216, 49.6409, 6.8372> }
				triangle { <-0.8313, 49.5963, 10.8471>, <-2.01216, 49.6409, 6.8372>, <-1.632, 49.05355, 10.1994> }
				triangle { <-0.8313, 49.5963, 10.8471>, <-0.9805, 48.9056, 12.8577>, <-1.632, 49.05355, 10.1994> }
				triangle { <-0.8313, 49.5963, 10.8471>, <-1.632, 49.05355, 10.1994>, <-0.9805, 48.9056, 12.8577> }
				triangle { <-0.8313, 49.5963, 10.8471>, <0.3115, 50.2727, 12.1268>, <-0.9805, 48.9056, 12.8577> }
				triangle { <-0.8313, 49.5963, 10.8471>, <-0.9805, 48.9056, 12.8577>, <0.3115, 50.2727, 12.1268> }
				triangle { <-2.01216, 49.6409, 6.8372>, <0.3115, 50.2727, 12.1268>, <-0.8313, 49.5963, 10.8471> }
				triangle { <-2.01216, 49.6409, 6.8372>, <-0.8313, 49.5963, 10.8471>, <0.3115, 50.2727, 12.1268> }
				triangle { <7.7129, 42.3892, 13.8084>, <4.6367, 43.8114, 13.4821>, <-0.9805, 48.9056, 12.8577> }
				triangle { <7.7129, 42.3892, 13.8084>, <-0.9805, 48.9056, 12.8577>, <4.6367, 43.8114, 13.4821> }
				triangle { <8.03382, 42.8665, 11.9252>, <9.6439, 42.06132, 13.2653>, <7.7129, 42.3892, 13.8084> }
				triangle { <8.03382, 42.8665, 11.9252>, <7.7129, 42.3892, 13.8084>, <9.6439, 42.06132, 13.2653> }
				triangle { <7.7129, 42.3892, 13.8084>, <-0.9805, 48.9056, 12.8577>, <8.03382, 42.8665, 11.9252> }
				triangle { <7.7129, 42.3892, 13.8084>, <8.03382, 42.8665, 11.9252>, <-0.9805, 48.9056, 12.8577> }
				triangle { <0.3115, 50.2727, 12.1268>, <8.03382, 42.8665, 11.9252>, <-0.9805, 48.9056, 12.8577> }
				triangle { <0.3115, 50.2727, 12.1268>, <-0.9805, 48.9056, 12.8577>, <8.03382, 42.8665, 11.9252> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-4.6964, 46.9567, 0.1999>, <-4.8111, 48.2929, 0.3075>, 0.09172 }
			cylinder { <-4.8111, 48.2929, 0.3075>, <-5.09586, 49.5774, 0.02649>, 0.09172 }
			cylinder { <-5.09586, 49.5774, 0.02649>, <-5.522, 50.6806, -0.6149>, 0.09172 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-5.522, 50.6806, -0.6149>, <-5.6526, 51.00591, -0.8149>, 0.09172 }
				cylinder { <-5.6526, 51.00591, -0.8149>, <-5.7859, 51.3253, -1.02256>, 0.09172 }
				cylinder { <-5.7859, 51.3253, -1.02256>, <-5.9218, 51.6387, -1.2375>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-5.9218, 51.6387, -1.2375>, <-5.93, 51.7155, -1.299>, 0.006731 }
				cylinder { <-5.93, 51.7155, -1.299>, <-5.9126, 51.7869, -1.3649>, 0.006731 }
				cylinder { <-5.9126, 51.7869, -1.3649>, <-5.8708, 51.8476, -1.4306>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.8708, 51.8476, -1.4306>, <-5.2826, 54.8284, -3.03154>, <-4.5225, 54.934, -3.9069> }
				triangle { <-5.8708, 51.8476, -1.4306>, <-4.5225, 54.934, -3.9069>, <-5.2826, 54.8284, -3.03154> }
				triangle { <-5.2826, 54.8284, -3.03154>, <-4.5055, 56.959, -4.5709>, <-4.5225, 54.934, -3.9069> }
				triangle { <-5.2826, 54.8284, -3.03154>, <-4.5225, 54.934, -3.9069>, <-4.5055, 56.959, -4.5709> }
				triangle { <-4.5055, 56.959, -4.5709>, <-3.4112, 55.4255, -5.2943>, <-4.5225, 54.934, -3.9069> }
				triangle { <-4.5055, 56.959, -4.5709>, <-4.5225, 54.934, -3.9069>, <-3.4112, 55.4255, -5.2943> }
				triangle { <-4.5225, 54.934, -3.9069>, <-3.4112, 55.4255, -5.2943>, <-5.8708, 51.8476, -1.4306> }
				triangle { <-4.5225, 54.934, -3.9069>, <-5.8708, 51.8476, -1.4306>, <-3.4112, 55.4255, -5.2943> }
				triangle { <-4.5055, 56.959, -4.5709>, <-8.8659, 56.8949, -10.8061>, <-9.9715, 56.4414, -13.9942> }
				triangle { <-4.5055, 56.959, -4.5709>, <-9.9715, 56.4414, -13.9942>, <-8.8659, 56.8949, -10.8061> }
				triangle { <-9.9715, 56.4414, -13.9942>, <-10.3843, 55.3333, -15.6473>, <-10.1398, 54.5265, -13.5673> }
				triangle { <-9.9715, 56.4414, -13.9942>, <-10.1398, 54.5265, -13.5673>, <-10.3843, 55.3333, -15.6473> }
				triangle { <-10.1398, 54.5265, -13.5673>, <-4.5055, 56.959, -4.5709>, <-9.9715, 56.4414, -13.9942> }
				triangle { <-10.1398, 54.5265, -13.5673>, <-9.9715, 56.4414, -13.9942>, <-4.5055, 56.959, -4.5709> }
				triangle { <-4.5055, 56.959, -4.5709>, <-10.1398, 54.5265, -13.5673>, <-3.4112, 55.4255, -5.2943> }
				triangle { <-4.5055, 56.959, -4.5709>, <-3.4112, 55.4255, -5.2943>, <-10.1398, 54.5265, -13.5673> }
				triangle { <-3.7346, 53.8299, -4.4278>, <-3.7944, 52.7428, -4.01536>, <-5.8708, 51.8476, -1.4306> }
				triangle { <-3.7346, 53.8299, -4.4278>, <-5.8708, 51.8476, -1.4306>, <-3.7944, 52.7428, -4.01536> }
				triangle { <-3.7346, 53.8299, -4.4278>, <-2.3168, 53.892, -6.01771>, <-3.7944, 52.7428, -4.01536> }
				triangle { <-3.7346, 53.8299, -4.4278>, <-3.7944, 52.7428, -4.01536>, <-2.3168, 53.892, -6.01771> }
				triangle { <-3.7346, 53.8299, -4.4278>, <-3.4112, 55.4255, -5.2943>, <-2.3168, 53.892, -6.01771> }
				triangle { <-3.7346, 53.8299, -4.4278>, <-2.3168, 53.892, -6.01771>, <-3.4112, 55.4255, -5.2943> }
				triangle { <-5.8708, 51.8476, -1.4306>, <-3.4112, 55.4255, -5.2943>, <-3.7346, 53.8299, -4.4278> }
				triangle { <-5.8708, 51.8476, -1.4306>, <-3.7346, 53.8299, -4.4278>, <-3.4112, 55.4255, -5.2943> }
				triangle { <-8.6583, 54.6011, -14.8622>, <-6.5897, 53.7052, -12.3107>, <-2.3168, 53.892, -6.01771> }
				triangle { <-8.6583, 54.6011, -14.8622>, <-2.3168, 53.892, -6.01771>, <-6.5897, 53.7052, -12.3107> }
				triangle { <-10.1398, 54.5265, -13.5673>, <-10.3843, 55.3333, -15.6473>, <-8.6583, 54.6011, -14.8622> }
				triangle { <-10.1398, 54.5265, -13.5673>, <-8.6583, 54.6011, -14.8622>, <-10.3843, 55.3333, -15.6473> }
				triangle { <-8.6583, 54.6011, -14.8622>, <-2.3168, 53.892, -6.01771>, <-10.1398, 54.5265, -13.5673> }
				triangle { <-8.6583, 54.6011, -14.8622>, <-10.1398, 54.5265, -13.5673>, <-2.3168, 53.892, -6.01771> }
				triangle { <-3.4112, 55.4255, -5.2943>, <-10.1398, 54.5265, -13.5673>, <-2.3168, 53.892, -6.01771> }
				triangle { <-3.4112, 55.4255, -5.2943>, <-2.3168, 53.892, -6.01771>, <-10.1398, 54.5265, -13.5673> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-5.9218, 51.6387, -1.2375>, <-6.06031, 51.9458, -1.4597>, 0.09172 }
				cylinder { <-6.06031, 51.9458, -1.4597>, <-6.2012, 52.2465, -1.6891>, 0.09172 }
				cylinder { <-6.2012, 52.2465, -1.6891>, <-6.3445, 52.5407, -1.9255>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.3445, 52.5407, -1.9255>, <-6.4021, 52.6071, -1.9704>, 0.006731 }
				cylinder { <-6.4021, 52.6071, -1.9704>, <-6.4781, 52.6632, -1.9991>, 0.006731 }
				cylinder { <-6.4781, 52.6632, -1.9991>, <-6.5669, 52.7049, -2.009659>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.5669, 52.7049, -2.009659>, <-9.6137, 53.9208, -0.9933>, <-10.3856, 54.3832, -1.7321> }
				triangle { <-6.5669, 52.7049, -2.009659>, <-10.3856, 54.3832, -1.7321>, <-9.6137, 53.9208, -0.9933> }
				triangle { <-9.6137, 53.9208, -0.9933>, <-12.1118, 54.9923, -0.6408>, <-10.3856, 54.3832, -1.7321> }
				triangle { <-9.6137, 53.9208, -0.9933>, <-10.3856, 54.3832, -1.7321>, <-12.1118, 54.9923, -0.6408> }
				triangle { <-12.1118, 54.9923, -0.6408>, <-11.799, 55.1591, -2.6275>, <-10.3856, 54.3832, -1.7321> }
				triangle { <-12.1118, 54.9923, -0.6408>, <-10.3856, 54.3832, -1.7321>, <-11.799, 55.1591, -2.6275> }
				triangle { <-10.3856, 54.3832, -1.7321>, <-11.799, 55.1591, -2.6275>, <-6.5669, 52.7049, -2.009659> }
				triangle { <-10.3856, 54.3832, -1.7321>, <-6.5669, 52.7049, -2.009659>, <-11.799, 55.1591, -2.6275> }
				triangle { <-12.1118, 54.9923, -0.6408>, <-17.1153, 49.382, -1.8178>, <-19.4283, 47.3388, -3.2556> }
				triangle { <-12.1118, 54.9923, -0.6408>, <-19.4283, 47.3388, -3.2556>, <-17.1153, 49.382, -1.8178> }
				triangle { <-19.4283, 47.3388, -3.2556>, <-20.1155, 46.08385, -4.6992>, <-17.9585, 46.5726, -4.3184> }
				triangle { <-19.4283, 47.3388, -3.2556>, <-17.9585, 46.5726, -4.3184>, <-20.1155, 46.08385, -4.6992> }
				triangle { <-17.9585, 46.5726, -4.3184>, <-12.1118, 54.9923, -0.6408>, <-19.4283, 47.3388, -3.2556> }
				triangle { <-17.9585, 46.5726, -4.3184>, <-19.4283, 47.3388, -3.2556>, <-12.1118, 54.9923, -0.6408> }
				triangle { <-12.1118, 54.9923, -0.6408>, <-17.9585, 46.5726, -4.3184>, <-11.799, 55.1591, -2.6275> }
				triangle { <-12.1118, 54.9923, -0.6408>, <-11.799, 55.1591, -2.6275>, <-17.9585, 46.5726, -4.3184> }
				triangle { <-10.1603, 54.5033, -3.1624>, <-9.1882, 54.1477, -3.6952>, <-6.5669, 52.7049, -2.009659> }
				triangle { <-10.1603, 54.5033, -3.1624>, <-6.5669, 52.7049, -2.009659>, <-9.1882, 54.1477, -3.6952> }
				triangle { <-10.1603, 54.5033, -3.1624>, <-11.4861, 55.3259, -4.6141>, <-9.1882, 54.1477, -3.6952> }
				triangle { <-10.1603, 54.5033, -3.1624>, <-9.1882, 54.1477, -3.6952>, <-11.4861, 55.3259, -4.6141> }
				triangle { <-10.1603, 54.5033, -3.1624>, <-11.799, 55.1591, -2.6275>, <-11.4861, 55.3259, -4.6141> }
				triangle { <-10.1603, 54.5033, -3.1624>, <-11.4861, 55.3259, -4.6141>, <-11.799, 55.1591, -2.6275> }
				triangle { <-6.5669, 52.7049, -2.009659>, <-11.799, 55.1591, -2.6275>, <-10.1603, 54.5033, -3.1624> }
				triangle { <-6.5669, 52.7049, -2.009659>, <-10.1603, 54.5033, -3.1624>, <-11.799, 55.1591, -2.6275> }
				triangle { <-19.05292, 47.539, -5.6396>, <-16.4645, 49.729, -5.9501>, <-11.4861, 55.3259, -4.6141> }
				triangle { <-19.05292, 47.539, -5.6396>, <-11.4861, 55.3259, -4.6141>, <-16.4645, 49.729, -5.9501> }
				triangle { <-17.9585, 46.5726, -4.3184>, <-20.1155, 46.08385, -4.6992>, <-19.05292, 47.539, -5.6396> }
				triangle { <-17.9585, 46.5726, -4.3184>, <-19.05292, 47.539, -5.6396>, <-20.1155, 46.08385, -4.6992> }
				triangle { <-19.05292, 47.539, -5.6396>, <-11.4861, 55.3259, -4.6141>, <-17.9585, 46.5726, -4.3184> }
				triangle { <-19.05292, 47.539, -5.6396>, <-17.9585, 46.5726, -4.3184>, <-11.4861, 55.3259, -4.6141> }
				triangle { <-11.799, 55.1591, -2.6275>, <-17.9585, 46.5726, -4.3184>, <-11.4861, 55.3259, -4.6141> }
				triangle { <-11.799, 55.1591, -2.6275>, <-11.4861, 55.3259, -4.6141>, <-17.9585, 46.5726, -4.3184> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.3445, 52.5407, -1.9255>, <-6.4877, 52.8348, -2.1618>, 0.09172 }
				cylinder { <-6.4877, 52.8348, -2.1618>, <-6.631, 53.1289, -2.3982>, 0.09172 }
				cylinder { <-6.631, 53.1289, -2.3982>, <-6.7743, 53.423, -2.6346>, 0.09172 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.7743, 53.423, -2.6346>, <-6.7842, 53.4953, -2.7011>, 0.006731 }
				cylinder { <-6.7842, 53.4953, -2.7011>, <-6.7684, 53.5626, -2.7715>, 0.006731 }
				cylinder { <-6.7684, 53.5626, -2.7715>, <-6.7278, 53.6201, -2.8408>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.7278, 53.6201, -2.8408>, <-6.2145, 56.5045, -4.6327>, <-5.4499, 56.5748, -5.5078> }
				triangle { <-6.7278, 53.6201, -2.8408>, <-5.4499, 56.5748, -5.5078>, <-6.2145, 56.5045, -4.6327> }
				triangle { <-6.2145, 56.5045, -4.6327>, <-5.4875, 58.5508, -6.3052>, <-5.4499, 56.5748, -5.5078> }
				triangle { <-6.2145, 56.5045, -4.6327>, <-5.4499, 56.5748, -5.5078>, <-5.4875, 58.5508, -6.3052> }
				triangle { <-5.4875, 58.5508, -6.3052>, <-4.3411, 57.0067, -6.9168>, <-5.4499, 56.5748, -5.5078> }
				triangle { <-5.4875, 58.5508, -6.3052>, <-5.4499, 56.5748, -5.5078>, <-4.3411, 57.0067, -6.9168> }
				triangle { <-5.4499, 56.5748, -5.5078>, <-4.3411, 57.0067, -6.9168>, <-6.7278, 53.6201, -2.8408> }
				triangle { <-5.4499, 56.5748, -5.5078>, <-6.7278, 53.6201, -2.8408>, <-4.3411, 57.0067, -6.9168> }
				triangle { <-5.4875, 58.5508, -6.3052>, <-9.7868, 57.9396, -12.5532>, <-10.8491, 57.2417, -15.7117> }
				triangle { <-5.4875, 58.5508, -6.3052>, <-10.8491, 57.2417, -15.7117>, <-9.7868, 57.9396, -12.5532> }
				triangle { <-10.8491, 57.2417, -15.7117>, <-11.2133, 56.01413, -17.2902>, <-10.9638, 55.3552, -15.1594> }
				triangle { <-10.8491, 57.2417, -15.7117>, <-10.9638, 55.3552, -15.1594>, <-11.2133, 56.01413, -17.2902> }
				triangle { <-10.9638, 55.3552, -15.1594>, <-5.4875, 58.5508, -6.3052>, <-10.8491, 57.2417, -15.7117> }
				triangle { <-10.9638, 55.3552, -15.1594>, <-10.8491, 57.2417, -15.7117>, <-5.4875, 58.5508, -6.3052> }
				triangle { <-5.4875, 58.5508, -6.3052>, <-10.9638, 55.3552, -15.1594>, <-4.3411, 57.0067, -6.9168> }
				triangle { <-5.4875, 58.5508, -6.3052>, <-4.3411, 57.0067, -6.9168>, <-10.9638, 55.3552, -15.1594> }
				triangle { <-4.6246, 55.463, -5.9482>, <-4.6555, 54.4045, -5.4646>, <-6.7278, 53.6201, -2.8408> }
				triangle { <-4.6246, 55.463, -5.9482>, <-6.7278, 53.6201, -2.8408>, <-4.6555, 54.4045, -5.4646> }
				triangle { <-4.6246, 55.463, -5.9482>, <-3.1948, 55.4625, -7.5285>, <-4.6555, 54.4045, -5.4646> }
				triangle { <-4.6246, 55.463, -5.9482>, <-4.6555, 54.4045, -5.4646>, <-3.1948, 55.4625, -7.5285> }
				triangle { <-4.6246, 55.463, -5.9482>, <-4.3411, 57.0067, -6.9168>, <-3.1948, 55.4625, -7.5285> }
				triangle { <-4.6246, 55.463, -5.9482>, <-3.1948, 55.4625, -7.5285>, <-4.3411, 57.0067, -6.9168> }
				triangle { <-6.7278, 53.6201, -2.8408>, <-4.3411, 57.0067, -6.9168>, <-4.6246, 55.463, -5.9482> }
				triangle { <-6.7278, 53.6201, -2.8408>, <-4.6246, 55.463, -5.9482>, <-4.3411, 57.0067, -6.9168> }
				triangle { <-9.4735, 55.3887, -16.4458>, <-7.4024, 54.7278, -13.8255>, <-3.1948, 55.4625, -7.5285> }
				triangle { <-9.4735, 55.3887, -16.4458>, <-3.1948, 55.4625, -7.5285>, <-7.4024, 54.7278, -13.8255> }
				triangle { <-10.9638, 55.3552, -15.1594>, <-11.2133, 56.01413, -17.2902>, <-9.4735, 55.3887, -16.4458> }
				triangle { <-10.9638, 55.3552, -15.1594>, <-9.4735, 55.3887, -16.4458>, <-11.2133, 56.01413, -17.2902> }
				triangle { <-9.4735, 55.3887, -16.4458>, <-3.1948, 55.4625, -7.5285>, <-10.9638, 55.3552, -15.1594> }
				triangle { <-9.4735, 55.3887, -16.4458>, <-10.9638, 55.3552, -15.1594>, <-3.1948, 55.4625, -7.5285> }
				triangle { <-4.3411, 57.0067, -6.9168>, <-10.9638, 55.3552, -15.1594>, <-3.1948, 55.4625, -7.5285> }
				triangle { <-4.3411, 57.0067, -6.9168>, <-3.1948, 55.4625, -7.5285>, <-10.9638, 55.3552, -15.1594> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.7743, 53.423, -2.6346>, <-6.8093, 53.495, -2.6924>, 0.006731 }
				cylinder { <-6.8093, 53.495, -2.6924>, <-6.8444, 53.5669, -2.7502>, 0.006731 }
				cylinder { <-6.8444, 53.5669, -2.7502>, <-6.8794, 53.6389, -2.808>, 0.006731 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.8794, 53.6389, -2.808>, <-8.8028, 56.3633, -3.6277>, <-8.7675, 56.8667, -4.6768> }
				triangle { <-6.8794, 53.6389, -2.808>, <-8.7675, 56.8667, -4.6768>, <-8.8028, 56.3633, -3.6277> }
				triangle { <-8.8028, 56.3633, -3.6277>, <-10.1277, 58.507, -4.7058>, <-8.7675, 56.8667, -4.6768> }
				triangle { <-8.8028, 56.3633, -3.6277>, <-8.7675, 56.8667, -4.6768>, <-10.1277, 58.507, -4.7058> }
				triangle { <-10.1277, 58.507, -4.7058>, <-8.9427, 57.8741, -6.2117>, <-8.7675, 56.8667, -4.6768> }
				triangle { <-10.1277, 58.507, -4.7058>, <-8.7675, 56.8667, -4.6768>, <-8.9427, 57.8741, -6.2117> }
				triangle { <-8.7675, 56.8667, -4.6768>, <-8.9427, 57.8741, -6.2117>, <-6.8794, 53.6389, -2.808> }
				triangle { <-8.7675, 56.8667, -4.6768>, <-6.8794, 53.6389, -2.808>, <-8.9427, 57.8741, -6.2117> }
				triangle { <-10.1277, 58.507, -4.7058>, <-16.2623, 55.7566, -8.269>, <-18.4007, 54.6599, -10.6808> }
				triangle { <-10.1277, 58.507, -4.7058>, <-18.4007, 54.6599, -10.6808>, <-16.2623, 55.7566, -8.269> }
				triangle { <-18.4007, 54.6599, -10.6808>, <-18.9501, 53.4737, -12.2372>, <-17.3214, 53.01509, -10.7628> }
				triangle { <-18.4007, 54.6599, -10.6808>, <-17.3214, 53.01509, -10.7628>, <-18.9501, 53.4737, -12.2372> }
				triangle { <-17.3214, 53.01509, -10.7628>, <-10.1277, 58.507, -4.7058>, <-18.4007, 54.6599, -10.6808> }
				triangle { <-17.3214, 53.01509, -10.7628>, <-18.4007, 54.6599, -10.6808>, <-10.1277, 58.507, -4.7058> }
				triangle { <-10.1277, 58.507, -4.7058>, <-17.3214, 53.01509, -10.7628>, <-8.9427, 57.8741, -6.2117> }
				triangle { <-10.1277, 58.507, -4.7058>, <-8.9427, 57.8741, -6.2117>, <-17.3214, 53.01509, -10.7628> }
				triangle { <-7.9143, 56.411, -5.7611>, <-7.1912, 55.5026, -5.6757>, <-6.8794, 53.6389, -2.808> }
				triangle { <-7.9143, 56.411, -5.7611>, <-6.8794, 53.6389, -2.808>, <-7.1912, 55.5026, -5.6757> }
				triangle { <-7.9143, 56.411, -5.7611>, <-7.7576, 57.2412, -7.7176>, <-7.1912, 55.5026, -5.6757> }
				triangle { <-7.9143, 56.411, -5.7611>, <-7.1912, 55.5026, -5.6757>, <-7.7576, 57.2412, -7.7176> }
				triangle { <-7.9143, 56.411, -5.7611>, <-8.9427, 57.8741, -6.2117>, <-7.7576, 57.2412, -7.7176> }
				triangle { <-7.9143, 56.411, -5.7611>, <-7.7576, 57.2412, -7.7176>, <-8.9427, 57.8741, -6.2117> }
				triangle { <-6.8794, 53.6389, -2.808>, <-8.9427, 57.8741, -6.2117>, <-7.9143, 56.411, -5.7611> }
				triangle { <-6.8794, 53.6389, -2.808>, <-7.9143, 56.411, -5.7611>, <-8.9427, 57.8741, -6.2117> }
				triangle { <-16.9787, 53.9004, -12.4878>, <-13.7975, 54.4401, -11.4013>, <-7.7576, 57.2412, -7.7176> }
				triangle { <-16.9787, 53.9004, -12.4878>, <-7.7576, 57.2412, -7.7176>, <-13.7975, 54.4401, -11.4013> }
				triangle { <-17.3214, 53.01509, -10.7628>, <-18.9501, 53.4737, -12.2372>, <-16.9787, 53.9004, -12.4878> }
				triangle { <-17.3214, 53.01509, -10.7628>, <-16.9787, 53.9004, -12.4878>, <-18.9501, 53.4737, -12.2372> }
				triangle { <-16.9787, 53.9004, -12.4878>, <-7.7576, 57.2412, -7.7176>, <-17.3214, 53.01509, -10.7628> }
				triangle { <-16.9787, 53.9004, -12.4878>, <-17.3214, 53.01509, -10.7628>, <-7.7576, 57.2412, -7.7176> }
				triangle { <-8.9427, 57.8741, -6.2117>, <-17.3214, 53.01509, -10.7628>, <-7.7576, 57.2412, -7.7176> }
				triangle { <-8.9427, 57.8741, -6.2117>, <-7.7576, 57.2412, -7.7176>, <-17.3214, 53.01509, -10.7628> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-4.582, 42.1254, -0.8505>, <-5.2644, 45.693, -0.955>, 0.6606 }
		cylinder { <-5.2644, 45.693, -0.955>, <-6.02622, 49.2429, -0.8046>, 0.6606 }
		cylinder { <-6.02622, 49.2429, -0.8046>, <-6.8633, 52.7557, -0.4002>, 0.6606 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-6.8633, 52.7557, -0.4002>, <-7.7492, 55.2676, 0.7705>, 0.1983 }
			cylinder { <-7.7492, 55.2676, 0.7705>, <-8.7612, 57.2251, 2.6702>, 0.1983 }
			cylinder { <-8.7612, 57.2251, 2.6702>, <-9.7973, 58.4306, 5.107>, 0.1983 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-9.7973, 58.4306, 5.107>, <-10.1074, 58.7731, 5.8475>, 0.1983 }
				cylinder { <-10.1074, 58.7731, 5.8475>, <-10.4165, 59.09623, 6.5971>, 0.1983 }
				cylinder { <-10.4165, 59.09623, 6.5971>, <-10.7245, 59.3997, 7.3553>, 0.1983 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-10.7245, 59.3997, 7.3553>, <-10.9966, 59.5313, 7.7044>, 0.03148 }
				cylinder { <-10.9966, 59.5313, 7.7044>, <-11.358, 59.6245, 7.9762>, 0.03148 }
				cylinder { <-11.358, 59.6245, 7.9762>, <-11.7826, 59.6725, 8.151>, 0.03148 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-11.7826, 59.6725, 8.151>, <-17.2192, 62.9127, 12.03712>, <-19.534, 61.9387, 12.2143> }
				triangle { <-11.7826, 59.6725, 8.151>, <-19.534, 61.9387, 12.2143>, <-17.2192, 62.9127, 12.03712> }
				triangle { <-17.2192, 62.9127, 12.03712>, <-22.1292, 64.7033, 14.8338>, <-19.534, 61.9387, 12.2143> }
				triangle { <-17.2192, 62.9127, 12.03712>, <-19.534, 61.9387, 12.2143>, <-22.1292, 64.7033, 14.8338> }
				triangle { <-22.1292, 64.7033, 14.8338>, <-23.3424, 60.979, 12.9093>, <-19.534, 61.9387, 12.2143> }
				triangle { <-22.1292, 64.7033, 14.8338>, <-19.534, 61.9387, 12.2143>, <-23.3424, 60.979, 12.9093> }
				triangle { <-19.534, 61.9387, 12.2143>, <-23.3424, 60.979, 12.9093>, <-11.7826, 59.6725, 8.151> }
				triangle { <-19.534, 61.9387, 12.2143>, <-11.7826, 59.6725, 8.151>, <-23.3424, 60.979, 12.9093> }
				triangle { <-22.1292, 64.7033, 14.8338>, <-22.2206, 57.3349, 29.5462>, <-23.6931, 52.7053, 35.07903> }
				triangle { <-22.1292, 64.7033, 14.8338>, <-23.6931, 52.7053, 35.07903>, <-22.2206, 57.3349, 29.5462> }
				triangle { <-23.6931, 52.7053, 35.07903>, <-23.9347, 48.7417, 36.9636>, <-21.2253, 49.8584, 33.0948> }
				triangle { <-23.6931, 52.7053, 35.07903>, <-21.2253, 49.8584, 33.0948>, <-23.9347, 48.7417, 36.9636> }
				triangle { <-21.2253, 49.8584, 33.0948>, <-22.1292, 64.7033, 14.8338>, <-23.6931, 52.7053, 35.07903> }
				triangle { <-21.2253, 49.8584, 33.0948>, <-23.6931, 52.7053, 35.07903>, <-22.1292, 64.7033, 14.8338> }
				triangle { <-22.1292, 64.7033, 14.8338>, <-21.2253, 49.8584, 33.0948>, <-23.3424, 60.979, 12.9093> }
				triangle { <-22.1292, 64.7033, 14.8338>, <-23.3424, 60.979, 12.9093>, <-21.2253, 49.8584, 33.0948> }
				triangle { <-20.4075, 59.2572, 10.8286>, <-18.8691, 57.8477, 9.4197>, <-11.7826, 59.6725, 8.151> }
				triangle { <-20.4075, 59.2572, 10.8286>, <-11.7826, 59.6725, 8.151>, <-18.8691, 57.8477, 9.4197> }
				triangle { <-20.4075, 59.2572, 10.8286>, <-24.5555, 57.2548, 10.9847>, <-18.8691, 57.8477, 9.4197> }
				triangle { <-20.4075, 59.2572, 10.8286>, <-18.8691, 57.8477, 9.4197>, <-24.5555, 57.2548, 10.9847> }
				triangle { <-20.4075, 59.2572, 10.8286>, <-23.3424, 60.979, 12.9093>, <-24.5555, 57.2548, 10.9847> }
				triangle { <-20.4075, 59.2572, 10.8286>, <-24.5555, 57.2548, 10.9847>, <-23.3424, 60.979, 12.9093> }
				triangle { <-11.7826, 59.6725, 8.151>, <-23.3424, 60.979, 12.9093>, <-20.4075, 59.2572, 10.8286> }
				triangle { <-11.7826, 59.6725, 8.151>, <-20.4075, 59.2572, 10.8286>, <-23.3424, 60.979, 12.9093> }
				triangle { <-25.1489, 48.2362, 32.7695>, <-24.7439, 49.5884, 25.5432>, <-24.5555, 57.2548, 10.9847> }
				triangle { <-25.1489, 48.2362, 32.7695>, <-24.5555, 57.2548, 10.9847>, <-24.7439, 49.5884, 25.5432> }
				triangle { <-21.2253, 49.8584, 33.0948>, <-23.9347, 48.7417, 36.9636>, <-25.1489, 48.2362, 32.7695> }
				triangle { <-21.2253, 49.8584, 33.0948>, <-25.1489, 48.2362, 32.7695>, <-23.9347, 48.7417, 36.9636> }
				triangle { <-25.1489, 48.2362, 32.7695>, <-24.5555, 57.2548, 10.9847>, <-21.2253, 49.8584, 33.0948> }
				triangle { <-25.1489, 48.2362, 32.7695>, <-21.2253, 49.8584, 33.0948>, <-24.5555, 57.2548, 10.9847> }
				triangle { <-23.3424, 60.979, 12.9093>, <-21.2253, 49.8584, 33.0948>, <-24.5555, 57.2548, 10.9847> }
				triangle { <-23.3424, 60.979, 12.9093>, <-24.5555, 57.2548, 10.9847>, <-21.2253, 49.8584, 33.0948> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-10.7245, 59.3997, 7.3553>, <-11.03125, 59.6834, 8.1217>, 0.1983 }
				cylinder { <-11.03125, 59.6834, 8.1217>, <-11.3364, 59.9472, 8.8957>, 0.1983 }
				cylinder { <-11.3364, 59.9472, 8.8957>, <-11.6399, 60.1909, 9.6769>, 0.1983 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-11.6399, 60.1909, 9.6769>, <-11.6796, 60.3382, 10.1127>, 0.03148 }
				cylinder { <-11.6796, 60.3382, 10.1127>, <-11.5956, 60.4933, 10.5394>, 0.03148 }
				cylinder { <-11.5956, 60.4933, 10.5394>, <-11.394, 60.6449, 10.9262>, 0.03148 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-11.394, 60.6449, 10.9262>, <-6.4326, 64.3714, 15.00731>, <-6.4538, 64.3575, 17.5248> }
				triangle { <-11.394, 60.6449, 10.9262>, <-6.4538, 64.3575, 17.5248>, <-6.4326, 64.3714, 15.00731> }
				triangle { <-6.4326, 64.3714, 15.00731>, <-2.9814, 66.9645, 19.06944>, <-6.4538, 64.3575, 17.5248> }
				triangle { <-6.4326, 64.3714, 15.00731>, <-6.4538, 64.3575, 17.5248>, <-2.9814, 66.9645, 19.06944> }
				triangle { <-2.9814, 66.9645, 19.06944>, <-5.906, 64.7717, 21.4536>, <-6.4538, 64.3575, 17.5248> }
				triangle { <-2.9814, 66.9645, 19.06944>, <-6.4538, 64.3575, 17.5248>, <-5.906, 64.7717, 21.4536> }
				triangle { <-6.4538, 64.3575, 17.5248>, <-5.906, 64.7717, 21.4536>, <-11.394, 60.6449, 10.9262> }
				triangle { <-6.4538, 64.3575, 17.5248>, <-11.394, 60.6449, 10.9262>, <-5.906, 64.7717, 21.4536> }
				triangle { <-2.9814, 66.9645, 19.06944>, <8.6996, 56.09079, 23.07831>, <12.5853, 50.9342, 26.6172> }
				triangle { <-2.9814, 66.9645, 19.06944>, <12.5853, 50.9342, 26.6172>, <8.6996, 56.09079, 23.07831> }
				triangle { <12.5853, 50.9342, 26.6172>, <13.1547, 46.9979, 28.4886>, <9.6966, 48.1106, 25.2699> }
				triangle { <12.5853, 50.9342, 26.6172>, <9.6966, 48.1106, 25.2699>, <13.1547, 46.9979, 28.4886> }
				triangle { <9.6966, 48.1106, 25.2699>, <-2.9814, 66.9645, 19.06944>, <12.5853, 50.9342, 26.6172> }
				triangle { <9.6966, 48.1106, 25.2699>, <12.5853, 50.9342, 26.6172>, <-2.9814, 66.9645, 19.06944> }
				triangle { <-2.9814, 66.9645, 19.06944>, <9.6966, 48.1106, 25.2699>, <-5.906, 64.7717, 21.4536> }
				triangle { <-2.9814, 66.9645, 19.06944>, <-5.906, 64.7717, 21.4536>, <9.6966, 48.1106, 25.2699> }
				triangle { <-8.5596, 62.7787, 19.2414>, <-10.4101, 61.3892, 18.2498>, <-11.394, 60.6449, 10.9262> }
				triangle { <-8.5596, 62.7787, 19.2414>, <-11.394, 60.6449, 10.9262>, <-10.4101, 61.3892, 18.2498> }
				triangle { <-8.5596, 62.7787, 19.2414>, <-8.8307, 62.579, 23.8378>, <-10.4101, 61.3892, 18.2498> }
				triangle { <-8.5596, 62.7787, 19.2414>, <-10.4101, 61.3892, 18.2498>, <-8.8307, 62.579, 23.8378> }
				triangle { <-8.5596, 62.7787, 19.2414>, <-5.906, 64.7717, 21.4536>, <-8.8307, 62.579, 23.8378> }
				triangle { <-8.5596, 62.7787, 19.2414>, <-8.8307, 62.579, 23.8378>, <-5.906, 64.7717, 21.4536> }
				triangle { <-11.394, 60.6449, 10.9262>, <-5.906, 64.7717, 21.4536>, <-8.5596, 62.7787, 19.2414> }
				triangle { <-11.394, 60.6449, 10.9262>, <-8.5596, 62.7787, 19.2414>, <-5.906, 64.7717, 21.4536> }
				triangle { <9.07577, 48.3029, 29.4782>, <2.6164, 51.5298, 28.03742>, <-8.8307, 62.579, 23.8378> }
				triangle { <9.07577, 48.3029, 29.4782>, <-8.8307, 62.579, 23.8378>, <2.6164, 51.5298, 28.03742> }
				triangle { <9.6966, 48.1106, 25.2699>, <13.1547, 46.9979, 28.4886>, <9.07577, 48.3029, 29.4782> }
				triangle { <9.6966, 48.1106, 25.2699>, <9.07577, 48.3029, 29.4782>, <13.1547, 46.9979, 28.4886> }
				triangle { <9.07577, 48.3029, 29.4782>, <-8.8307, 62.579, 23.8378>, <9.6966, 48.1106, 25.2699> }
				triangle { <9.07577, 48.3029, 29.4782>, <9.6966, 48.1106, 25.2699>, <-8.8307, 62.579, 23.8378> }
				triangle { <-5.906, 64.7717, 21.4536>, <9.6966, 48.1106, 25.2699>, <-8.8307, 62.579, 23.8378> }
				triangle { <-5.906, 64.7717, 21.4536>, <-8.8307, 62.579, 23.8378>, <9.6966, 48.1106, 25.2699> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-11.6399, 60.1909, 9.6769>, <-11.9415, 60.4144, 10.4649>, 0.1983 }
				cylinder { <-11.9415, 60.4144, 10.4649>, <-12.2411, 60.6174, 11.2592>, 0.1983 }
				cylinder { <-12.2411, 60.6174, 11.2592>, <-12.5384, 60.8, 12.05929>, 0.1983 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-12.5384, 60.8, 12.05929>, <-12.8051, 60.87, 12.4297>, 0.03148 }
				cylinder { <-12.8051, 60.87, 12.4297>, <-13.1617, 60.9083, 12.7204>, 0.03148 }
				cylinder { <-13.1617, 60.9083, 12.7204>, <-13.5824, 60.9122, 12.9105>, 0.03148 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-13.5824, 60.9122, 12.9105>, <-19.03119, 63.3354, 17.3373>, <-21.2957, 62.2396, 17.4353> }
				triangle { <-13.5824, 60.9122, 12.9105>, <-21.2957, 62.2396, 17.4353>, <-19.03119, 63.3354, 17.3373> }
				triangle { <-19.03119, 63.3354, 17.3373>, <-23.9254, 64.4972, 20.4731>, <-21.2957, 62.2396, 17.4353> }
				triangle { <-19.03119, 63.3354, 17.3373>, <-21.2957, 62.2396, 17.4353>, <-23.9254, 64.4972, 20.4731> }
				triangle { <-23.9254, 64.4972, 20.4731>, <-25.03649, 61.01791, 18.08447>, <-21.2957, 62.2396, 17.4353> }
				triangle { <-23.9254, 64.4972, 20.4731>, <-21.2957, 62.2396, 17.4353>, <-25.03649, 61.01791, 18.08447> }
				triangle { <-21.2957, 62.2396, 17.4353>, <-25.03649, 61.01791, 18.08447>, <-13.5824, 60.9122, 12.9105> }
				triangle { <-21.2957, 62.2396, 17.4353>, <-13.5824, 60.9122, 12.9105>, <-25.03649, 61.01791, 18.08447> }
				triangle { <-23.9254, 64.4972, 20.4731>, <-23.2514, 55.1944, 34.02901>, <-24.3547, 49.7899, 38.9061> }
				triangle { <-23.9254, 64.4972, 20.4731>, <-24.3547, 49.7899, 38.9061>, <-23.2514, 55.1944, 34.02901> }
				triangle { <-24.3547, 49.7899, 38.9061>, <-24.3689, 45.5993, 40.2325>, <-21.8293, 47.3583, 36.4891> }
				triangle { <-24.3547, 49.7899, 38.9061>, <-21.8293, 47.3583, 36.4891>, <-24.3689, 45.5993, 40.2325> }
				triangle { <-21.8293, 47.3583, 36.4891>, <-23.9254, 64.4972, 20.4731>, <-24.3547, 49.7899, 38.9061> }
				triangle { <-21.8293, 47.3583, 36.4891>, <-24.3547, 49.7899, 38.9061>, <-23.9254, 64.4972, 20.4731> }
				triangle { <-23.9254, 64.4972, 20.4731>, <-21.8293, 47.3583, 36.4891>, <-25.03649, 61.01791, 18.08447> }
				triangle { <-23.9254, 64.4972, 20.4731>, <-25.03649, 61.01791, 18.08447>, <-21.8293, 47.3583, 36.4891> }
				triangle { <-22.09573, 59.7345, 15.7154>, <-20.5422, 58.6035, 14.08879>, <-13.5824, 60.9122, 12.9105> }
				triangle { <-22.09573, 59.7345, 15.7154>, <-13.5824, 60.9122, 12.9105>, <-20.5422, 58.6035, 14.08879> }
				triangle { <-22.09573, 59.7345, 15.7154>, <-26.1475, 57.5385, 15.6958>, <-20.5422, 58.6035, 14.08879> }
				triangle { <-22.09573, 59.7345, 15.7154>, <-20.5422, 58.6035, 14.08879>, <-26.1475, 57.5385, 15.6958> }
				triangle { <-22.09573, 59.7345, 15.7154>, <-25.03649, 61.01791, 18.08447>, <-26.1475, 57.5385, 15.6958> }
				triangle { <-22.09573, 59.7345, 15.7154>, <-26.1475, 57.5385, 15.6958>, <-25.03649, 61.01791, 18.08447> }
				triangle { <-13.5824, 60.9122, 12.9105>, <-25.03649, 61.01791, 18.08447>, <-22.09573, 59.7345, 15.7154> }
				triangle { <-13.5824, 60.9122, 12.9105>, <-22.09573, 59.7345, 15.7154>, <-25.03649, 61.01791, 18.08447> }
				triangle { <-25.688, 45.6147, 36.03972>, <-25.5625, 47.9574, 29.06058>, <-26.1475, 57.5385, 15.6958> }
				triangle { <-25.688, 45.6147, 36.03972>, <-26.1475, 57.5385, 15.6958>, <-25.5625, 47.9574, 29.06058> }
				triangle { <-21.8293, 47.3583, 36.4891>, <-24.3689, 45.5993, 40.2325>, <-25.688, 45.6147, 36.03972> }
				triangle { <-21.8293, 47.3583, 36.4891>, <-25.688, 45.6147, 36.03972>, <-24.3689, 45.5993, 40.2325> }
				triangle { <-25.688, 45.6147, 36.03972>, <-26.1475, 57.5385, 15.6958>, <-21.8293, 47.3583, 36.4891> }
				triangle { <-25.688, 45.6147, 36.03972>, <-21.8293, 47.3583, 36.4891>, <-26.1475, 57.5385, 15.6958> }
				triangle { <-25.03649, 61.01791, 18.08447>, <-21.8293, 47.3583, 36.4891>, <-26.1475, 57.5385, 15.6958> }
				triangle { <-25.03649, 61.01791, 18.08447>, <-26.1475, 57.5385, 15.6958>, <-21.8293, 47.3583, 36.4891> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-12.5384, 60.8, 12.05929>, <-12.6957, 60.8966, 12.4825>, 0.03148 }
				cylinder { <-12.6957, 60.8966, 12.4825>, <-12.853, 60.9931, 12.9057>, 0.03148 }
				cylinder { <-12.853, 60.9931, 12.9057>, <-13.01038, 61.08977, 13.3289>, 0.03148 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-13.01038, 61.08977, 13.3289>, <-13.2949, 64.6574, 19.8365>, <-14.9661, 64.08679, 21.6309> }
				triangle { <-13.01038, 61.08977, 13.3289>, <-14.9661, 64.08679, 21.6309>, <-13.2949, 64.6574, 19.8365> }
				triangle { <-13.2949, 64.6574, 19.8365>, <-14.2999, 66.8711, 25.2425>, <-14.9661, 64.08679, 21.6309> }
				triangle { <-13.2949, 64.6574, 19.8365>, <-14.9661, 64.08679, 21.6309>, <-14.2999, 66.8711, 25.2425> }
				triangle { <-14.2999, 66.8711, 25.2425>, <-17.2922, 63.7187, 24.8497>, <-14.9661, 64.08679, 21.6309> }
				triangle { <-14.2999, 66.8711, 25.2425>, <-14.9661, 64.08679, 21.6309>, <-17.2922, 63.7187, 24.8497> }
				triangle { <-14.9661, 64.08679, 21.6309>, <-17.2922, 63.7187, 24.8497>, <-13.01038, 61.08977, 13.3289> }
				triangle { <-14.9661, 64.08679, 21.6309>, <-13.01038, 61.08977, 13.3289>, <-17.2922, 63.7187, 24.8497> }
				triangle { <-14.2999, 66.8711, 25.2425>, <-5.7387, 57.6636, 35.858>, <-3.9114, 52.6398, 40.9211> }
				triangle { <-14.2999, 66.8711, 25.2425>, <-3.9114, 52.6398, 40.9211>, <-5.7387, 57.6636, 35.858> }
				triangle { <-3.9114, 52.6398, 40.9211>, <-3.6393, 48.5566, 42.5253>, <-4.24, 49.7094, 37.8491> }
				triangle { <-3.9114, 52.6398, 40.9211>, <-4.24, 49.7094, 37.8491>, <-3.6393, 48.5566, 42.5253> }
				triangle { <-4.24, 49.7094, 37.8491>, <-14.2999, 66.8711, 25.2425>, <-3.9114, 52.6398, 40.9211> }
				triangle { <-4.24, 49.7094, 37.8491>, <-3.9114, 52.6398, 40.9211>, <-14.2999, 66.8711, 25.2425> }
				triangle { <-14.2999, 66.8711, 25.2425>, <-4.24, 49.7094, 37.8491>, <-17.2922, 63.7187, 24.8497> }
				triangle { <-14.2999, 66.8711, 25.2425>, <-17.2922, 63.7187, 24.8497>, <-4.24, 49.7094, 37.8491> }
				triangle { <-17.1206, 61.817, 21.3481>, <-17.3645, 60.3701, 19.3023>, <-13.01038, 61.08977, 13.3289> }
				triangle { <-17.1206, 61.817, 21.3481>, <-13.01038, 61.08977, 13.3289>, <-17.3645, 60.3701, 19.3023> }
				triangle { <-17.1206, 61.817, 21.3481>, <-20.2845, 60.5663, 24.4569>, <-17.3645, 60.3701, 19.3023> }
				triangle { <-17.1206, 61.817, 21.3481>, <-17.3645, 60.3701, 19.3023>, <-20.2845, 60.5663, 24.4569> }
				triangle { <-17.1206, 61.817, 21.3481>, <-17.2922, 63.7187, 24.8497>, <-20.2845, 60.5663, 24.4569> }
				triangle { <-17.1206, 61.817, 21.3481>, <-20.2845, 60.5663, 24.4569>, <-17.2922, 63.7187, 24.8497> }
				triangle { <-13.01038, 61.08977, 13.3289>, <-17.2922, 63.7187, 24.8497>, <-17.1206, 61.817, 21.3481> }
				triangle { <-13.01038, 61.08977, 13.3289>, <-17.1206, 61.817, 21.3481>, <-17.2922, 63.7187, 24.8497> }
				triangle { <-7.5022, 48.8569, 40.4497>, <-11.9628, 51.1066, 35.04098>, <-20.2845, 60.5663, 24.4569> }
				triangle { <-7.5022, 48.8569, 40.4497>, <-20.2845, 60.5663, 24.4569>, <-11.9628, 51.1066, 35.04098> }
				triangle { <-4.24, 49.7094, 37.8491>, <-3.6393, 48.5566, 42.5253>, <-7.5022, 48.8569, 40.4497> }
				triangle { <-4.24, 49.7094, 37.8491>, <-7.5022, 48.8569, 40.4497>, <-3.6393, 48.5566, 42.5253> }
				triangle { <-7.5022, 48.8569, 40.4497>, <-20.2845, 60.5663, 24.4569>, <-4.24, 49.7094, 37.8491> }
				triangle { <-7.5022, 48.8569, 40.4497>, <-4.24, 49.7094, 37.8491>, <-20.2845, 60.5663, 24.4569> }
				triangle { <-17.2922, 63.7187, 24.8497>, <-4.24, 49.7094, 37.8491>, <-20.2845, 60.5663, 24.4569> }
				triangle { <-17.2922, 63.7187, 24.8497>, <-20.2845, 60.5663, 24.4569>, <-4.24, 49.7094, 37.8491> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-6.8633, 52.7557, -0.4002>, <-7.2503, 55.5852, -0.9562>, 0.1983 }
			cylinder { <-7.2503, 55.5852, -0.9562>, <-7.3149, 58.146, -2.3358>, 0.1983 }
			cylinder { <-7.3149, 58.146, -2.3358>, <-7.05078, 60.1795, -4.3998>, 0.1983 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-7.05078, 60.1795, -4.3998>, <-6.9641, 60.7745, -5.03247>, 0.1983 }
				cylinder { <-6.9641, 60.7745, -5.03247>, <-6.8701, 61.3543, -5.6781>, 0.1983 }
				cylinder { <-6.8701, 61.3543, -5.6781>, <-6.7689, 61.9184, -6.3364>, 0.1983 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.7689, 61.9184, -6.3364>, <-6.6022, 62.2291, -6.6346>, 0.03148 }
				cylinder { <-6.6022, 62.2291, -6.6346>, <-6.3346, 62.5295, -6.8611>, 0.03148 }
				cylinder { <-6.3346, 62.5295, -6.8611>, <-5.9854, 62.798, -6.9994>, 0.03148 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.9854, 62.798, -6.9994>, <-2.7683, 68.8716, -9.8134>, <-0.2745, 69.09434, -10.07715> }
				triangle { <-5.9854, 62.798, -6.9994>, <-0.2745, 69.09434, -10.07715>, <-2.7683, 68.8716, -9.8134> }
				triangle { <-2.7683, 68.8716, -9.8134>, <0.6795, 73.2165, -11.9039>, <-0.2745, 69.09434, -10.07715> }
				triangle { <-2.7683, 68.8716, -9.8134>, <-0.2745, 69.09434, -10.07715>, <0.6795, 73.2165, -11.9039> }
				triangle { <0.6795, 73.2165, -11.9039>, <3.5213, 70.106, -10.7661>, <-0.2745, 69.09434, -10.07715> }
				triangle { <0.6795, 73.2165, -11.9039>, <-0.2745, 69.09434, -10.07715>, <3.5213, 70.106, -10.7661> }
				triangle { <-0.2745, 69.09434, -10.07715>, <3.5213, 70.106, -10.7661>, <-5.9854, 62.798, -6.9994> }
				triangle { <-0.2745, 69.09434, -10.07715>, <-5.9854, 62.798, -6.9994>, <3.5213, 70.106, -10.7661> }
				triangle { <0.6795, 73.2165, -11.9039>, <3.2888, 70.01875, -27.8326>, <6.3834, 67.8414, -34.1489> }
				triangle { <0.6795, 73.2165, -11.9039>, <6.3834, 67.8414, -34.1489>, <3.2888, 70.01875, -27.8326> }
				triangle { <6.3834, 67.8414, -34.1489>, <8.2682, 64.9098, -36.8272>, <5.5473, 63.8411, -32.9528> }
				triangle { <6.3834, 67.8414, -34.1489>, <5.5473, 63.8411, -32.9528>, <8.2682, 64.9098, -36.8272> }
				triangle { <5.5473, 63.8411, -32.9528>, <0.6795, 73.2165, -11.9039>, <6.3834, 67.8414, -34.1489> }
				triangle { <5.5473, 63.8411, -32.9528>, <6.3834, 67.8414, -34.1489>, <0.6795, 73.2165, -11.9039> }
				triangle { <0.6795, 73.2165, -11.9039>, <5.5473, 63.8411, -32.9528>, <3.5213, 70.106, -10.7661> }
				triangle { <0.6795, 73.2165, -11.9039>, <3.5213, 70.106, -10.7661>, <5.5473, 63.8411, -32.9528> }
				triangle { <1.7716, 66.8548, -9.2579>, <1.09658, 64.6414, -8.266>, <-5.9854, 62.798, -6.9994> }
				triangle { <1.7716, 66.8548, -9.2579>, <-5.9854, 62.798, -6.9994>, <1.09658, 64.6414, -8.266> }
				triangle { <1.7716, 66.8548, -9.2579>, <6.3632, 66.9956, -9.6283>, <1.09658, 64.6414, -8.266> }
				triangle { <1.7716, 66.8548, -9.2579>, <1.09658, 64.6414, -8.266>, <6.3632, 66.9956, -9.6283> }
				triangle { <1.7716, 66.8548, -9.2579>, <3.5213, 70.106, -10.7661>, <6.3632, 66.9956, -9.6283> }
				triangle { <1.7716, 66.8548, -9.2579>, <6.3632, 66.9956, -9.6283>, <3.5213, 70.106, -10.7661> }
				triangle { <-5.9854, 62.798, -6.9994>, <3.5213, 70.106, -10.7661>, <1.7716, 66.8548, -9.2579> }
				triangle { <-5.9854, 62.798, -6.9994>, <1.7716, 66.8548, -9.2579>, <3.5213, 70.106, -10.7661> }
				triangle { <9.7937, 64.1088, -32.7835>, <9.1999, 63.5489, -25.466>, <6.3632, 66.9956, -9.6283> }
				triangle { <9.7937, 64.1088, -32.7835>, <6.3632, 66.9956, -9.6283>, <9.1999, 63.5489, -25.466> }
				triangle { <5.5473, 63.8411, -32.9528>, <8.2682, 64.9098, -36.8272>, <9.7937, 64.1088, -32.7835> }
				triangle { <5.5473, 63.8411, -32.9528>, <9.7937, 64.1088, -32.7835>, <8.2682, 64.9098, -36.8272> }
				triangle { <9.7937, 64.1088, -32.7835>, <6.3632, 66.9956, -9.6283>, <5.5473, 63.8411, -32.9528> }
				triangle { <9.7937, 64.1088, -32.7835>, <5.5473, 63.8411, -32.9528>, <6.3632, 66.9956, -9.6283> }
				triangle { <3.5213, 70.106, -10.7661>, <5.5473, 63.8411, -32.9528>, <6.3632, 66.9956, -9.6283> }
				triangle { <3.5213, 70.106, -10.7661>, <6.3632, 66.9956, -9.6283>, <5.5473, 63.8411, -32.9528> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.7689, 61.9184, -6.3364>, <-6.6604, 62.4664, -7.007078>, 0.1983 }
				cylinder { <-6.6604, 62.4664, -7.007078>, <-6.5448, 62.9982, -7.6895>, 0.1983 }
				cylinder { <-6.5448, 62.9982, -7.6895>, <-6.4221, 63.5132, -8.3834>, 0.1983 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.4221, 63.5132, -8.3834>, <-6.4746, 63.7527, -8.7746>, 0.03148 }
				cylinder { <-6.4746, 63.7527, -8.7746>, <-6.6406, 63.9419, -9.1617>, 0.03148 }
				cylinder { <-6.6406, 63.9419, -9.1617>, <-6.9082, 64.06712, -9.5166>, 0.03148 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.9082, 64.06712, -9.5166>, <-13.212, 65.9738, -12.9493>, <-13.3159, 66.5129, -15.4063> }
				triangle { <-6.9082, 64.06712, -9.5166>, <-13.3159, 66.5129, -15.4063>, <-13.212, 65.9738, -12.9493> }
				triangle { <-13.212, 65.9738, -12.9493>, <-17.6601, 67.5643, -16.5299>, <-13.3159, 66.5129, -15.4063> }
				triangle { <-13.212, 65.9738, -12.9493>, <-13.3159, 66.5129, -15.4063>, <-17.6601, 67.5643, -16.5299> }
				triangle { <-17.6601, 67.5643, -16.5299>, <-14.1915, 67.4742, -19.1768>, <-13.3159, 66.5129, -15.4063> }
				triangle { <-17.6601, 67.5643, -16.5299>, <-13.3159, 66.5129, -15.4063>, <-14.1915, 67.4742, -19.1768> }
				triangle { <-13.3159, 66.5129, -15.4063>, <-14.1915, 67.4742, -19.1768>, <-6.9082, 64.06712, -9.5166> }
				triangle { <-13.3159, 66.5129, -15.4063>, <-6.9082, 64.06712, -9.5166>, <-14.1915, 67.4742, -19.1768> }
				triangle { <-17.6601, 67.5643, -16.5299>, <-23.4636, 53.7736, -23.3778>, <-24.8215, 48.3227, -28.1377> }
				triangle { <-17.6601, 67.5643, -16.5299>, <-24.8215, 48.3227, -28.1377>, <-23.4636, 53.7736, -23.3778> }
				triangle { <-24.8215, 48.3227, -28.1377>, <-23.6732, 45.05083, -30.8388>, <-20.9127, 46.8656, -27.2832> }
				triangle { <-24.8215, 48.3227, -28.1377>, <-20.9127, 46.8656, -27.2832>, <-23.6732, 45.05083, -30.8388> }
				triangle { <-20.9127, 46.8656, -27.2832>, <-17.6601, 67.5643, -16.5299>, <-24.8215, 48.3227, -28.1377> }
				triangle { <-20.9127, 46.8656, -27.2832>, <-24.8215, 48.3227, -28.1377>, <-17.6601, 67.5643, -16.5299> }
				triangle { <-17.6601, 67.5643, -16.5299>, <-20.9127, 46.8656, -27.2832>, <-14.1915, 67.4742, -19.1768> }
				triangle { <-17.6601, 67.5643, -16.5299>, <-14.1915, 67.4742, -19.1768>, <-20.9127, 46.8656, -27.2832> }
				triangle { <-10.8185, 66.448, -17.3122>, <-8.4946, 65.8513, -16.5491>, <-6.9082, 64.06712, -9.5166> }
				triangle { <-10.8185, 66.448, -17.3122>, <-6.9082, 64.06712, -9.5166>, <-8.4946, 65.8513, -16.5491> }
				triangle { <-10.8185, 66.448, -17.3122>, <-10.7229, 67.3841, -21.8238>, <-8.4946, 65.8513, -16.5491> }
				triangle { <-10.8185, 66.448, -17.3122>, <-8.4946, 65.8513, -16.5491>, <-10.7229, 67.3841, -21.8238> }
				triangle { <-10.8185, 66.448, -17.3122>, <-14.1915, 67.4742, -19.1768>, <-10.7229, 67.3841, -21.8238> }
				triangle { <-10.8185, 66.448, -17.3122>, <-10.7229, 67.3841, -21.8238>, <-14.1915, 67.4742, -19.1768> }
				triangle { <-6.9082, 64.06712, -9.5166>, <-14.1915, 67.4742, -19.1768>, <-10.8185, 66.448, -17.3122> }
				triangle { <-6.9082, 64.06712, -9.5166>, <-10.8185, 66.448, -17.3122>, <-14.1915, 67.4742, -19.1768> }
				triangle { <-20.6591, 48.2146, -31.3141>, <-16.2488, 53.5862, -28.8835>, <-10.7229, 67.3841, -21.8238> }
				triangle { <-20.6591, 48.2146, -31.3141>, <-10.7229, 67.3841, -21.8238>, <-16.2488, 53.5862, -28.8835> }
				triangle { <-20.9127, 46.8656, -27.2832>, <-23.6732, 45.05083, -30.8388>, <-20.6591, 48.2146, -31.3141> }
				triangle { <-20.9127, 46.8656, -27.2832>, <-20.6591, 48.2146, -31.3141>, <-23.6732, 45.05083, -30.8388> }
				triangle { <-20.6591, 48.2146, -31.3141>, <-10.7229, 67.3841, -21.8238>, <-20.9127, 46.8656, -27.2832> }
				triangle { <-20.6591, 48.2146, -31.3141>, <-20.9127, 46.8656, -27.2832>, <-10.7229, 67.3841, -21.8238> }
				triangle { <-14.1915, 67.4742, -19.1768>, <-20.9127, 46.8656, -27.2832>, <-10.7229, 67.3841, -21.8238> }
				triangle { <-14.1915, 67.4742, -19.1768>, <-10.7229, 67.3841, -21.8238>, <-20.9127, 46.8656, -27.2832> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.4221, 63.5132, -8.3834>, <-6.2924, 64.01135, -9.08837>, 0.1983 }
				cylinder { <-6.2924, 64.01135, -9.08837>, <-6.1558, 64.4921, -9.8039>, 0.1983 }
				cylinder { <-6.1558, 64.4921, -9.8039>, <-6.01241, 64.9554, -10.5296>, 0.1983 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.01241, 64.9554, -10.5296>, <-5.8242, 65.2146, -10.8621>, 0.03148 }
				cylinder { <-5.8242, 65.2146, -10.8621>, <-5.5374, 65.4693, -11.1192>, 0.03148 }
				cylinder { <-5.5374, 65.4693, -11.1192>, <-5.1728, 65.701, -11.2821>, 0.03148 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.1728, 65.701, -11.2821>, <-1.6087, 71.1863, -14.7986>, <0.8984, 71.2637, -15.01382> }
				triangle { <-5.1728, 65.701, -11.2821>, <0.8984, 71.2637, -15.01382>, <-1.6087, 71.1863, -14.7986> }
				triangle { <-1.6087, 71.1863, -14.7986>, <2.08768, 75.05069, -17.3558>, <0.8984, 71.2637, -15.01382> }
				triangle { <-1.6087, 71.1863, -14.7986>, <0.8984, 71.2637, -15.01382>, <2.08768, 75.05069, -17.3558> }
				triangle { <2.08768, 75.05069, -17.3558>, <4.753, 72.00781, -15.7179>, <0.8984, 71.2637, -15.01382> }
				triangle { <2.08768, 75.05069, -17.3558>, <0.8984, 71.2637, -15.01382>, <4.753, 72.00781, -15.7179> }
				triangle { <0.8984, 71.2637, -15.01382>, <4.753, 72.00781, -15.7179>, <-5.1728, 65.701, -11.2821> }
				triangle { <0.8984, 71.2637, -15.01382>, <-5.1728, 65.701, -11.2821>, <4.753, 72.00781, -15.7179> }
				triangle { <2.08768, 75.05069, -17.3558>, <4.9338, 69.582, -32.612>, <8.07723, 66.4257, -38.4745> }
				triangle { <2.08768, 75.05069, -17.3558>, <8.07723, 66.4257, -38.4745>, <4.9338, 69.582, -32.612> }
				triangle { <8.07723, 66.4257, -38.4745>, <9.8884, 63.07547, -40.669>, <7.02687, 62.6676, -36.7701> }
				triangle { <8.07723, 66.4257, -38.4745>, <7.02687, 62.6676, -36.7701>, <9.8884, 63.07547, -40.669> }
				triangle { <7.02687, 62.6676, -36.7701>, <2.08768, 75.05069, -17.3558>, <8.07723, 66.4257, -38.4745> }
				triangle { <7.02687, 62.6676, -36.7701>, <8.07723, 66.4257, -38.4745>, <2.08768, 75.05069, -17.3558> }
				triangle { <2.08768, 75.05069, -17.3558>, <7.02687, 62.6676, -36.7701>, <4.753, 72.00781, -15.7179> }
				triangle { <2.08768, 75.05069, -17.3558>, <4.753, 72.00781, -15.7179>, <7.02687, 62.6676, -36.7701> }
				triangle { <2.8175, 69.07291, -13.8345>, <2.01612, 67.04806, -12.571>, <-5.1728, 65.701, -11.2821> }
				triangle { <2.8175, 69.07291, -13.8345>, <-5.1728, 65.701, -11.2821>, <2.01612, 67.04806, -12.571> }
				triangle { <2.8175, 69.07291, -13.8345>, <7.4184, 68.9649, -14.08003>, <2.01612, 67.04806, -12.571> }
				triangle { <2.8175, 69.07291, -13.8345>, <2.01612, 67.04806, -12.571>, <7.4184, 68.9649, -14.08003> }
				triangle { <2.8175, 69.07291, -13.8345>, <4.753, 72.00781, -15.7179>, <7.4184, 68.9649, -14.08003> }
				triangle { <2.8175, 69.07291, -13.8345>, <7.4184, 68.9649, -14.08003>, <4.753, 72.00781, -15.7179> }
				triangle { <-5.1728, 65.701, -11.2821>, <4.753, 72.00781, -15.7179>, <2.8175, 69.07291, -13.8345> }
				triangle { <-5.1728, 65.701, -11.2821>, <2.8175, 69.07291, -13.8345>, <4.753, 72.00781, -15.7179> }
				triangle { <11.2756, 62.7742, -36.509>, <10.4778, 63.2528, -29.2051>, <7.4184, 68.9649, -14.08003> }
				triangle { <11.2756, 62.7742, -36.509>, <7.4184, 68.9649, -14.08003>, <10.4778, 63.2528, -29.2051> }
				triangle { <7.02687, 62.6676, -36.7701>, <9.8884, 63.07547, -40.669>, <11.2756, 62.7742, -36.509> }
				triangle { <7.02687, 62.6676, -36.7701>, <11.2756, 62.7742, -36.509>, <9.8884, 63.07547, -40.669> }
				triangle { <11.2756, 62.7742, -36.509>, <7.4184, 68.9649, -14.08003>, <7.02687, 62.6676, -36.7701> }
				triangle { <11.2756, 62.7742, -36.509>, <7.02687, 62.6676, -36.7701>, <7.4184, 68.9649, -14.08003> }
				triangle { <4.753, 72.00781, -15.7179>, <7.02687, 62.6676, -36.7701>, <7.4184, 68.9649, -14.08003> }
				triangle { <4.753, 72.00781, -15.7179>, <7.4184, 68.9649, -14.08003>, <7.02687, 62.6676, -36.7701> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.01241, 64.9554, -10.5296>, <-5.9365, 65.2004, -10.9135>, 0.03148 }
				cylinder { <-5.9365, 65.2004, -10.9135>, <-5.8606, 65.4455, -11.2974>, 0.03148 }
				cylinder { <-5.8606, 65.4455, -11.2974>, <-5.7847, 65.6905, -11.6813>, 0.03148 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-5.7847, 65.6905, -11.6813>, <-7.4531, 70.3179, -17.2455>, <-5.7971, 70.9525, -19.03265> }
				triangle { <-5.7847, 65.6905, -11.6813>, <-5.7971, 70.9525, -19.03265>, <-7.4531, 70.3179, -17.2455> }
				triangle { <-7.4531, 70.3179, -17.2455>, <-7.8179, 73.8526, -21.9899>, <-5.7971, 70.9525, -19.03265> }
				triangle { <-7.4531, 70.3179, -17.2455>, <-5.7971, 70.9525, -19.03265>, <-7.8179, 73.8526, -21.9899> }
				triangle { <-7.8179, 73.8526, -21.9899>, <-3.719, 72.3612, -22.1317>, <-5.7971, 70.9525, -19.03265> }
				triangle { <-7.8179, 73.8526, -21.9899>, <-5.7971, 70.9525, -19.03265>, <-3.719, 72.3612, -22.1317> }
				triangle { <-5.7971, 70.9525, -19.03265>, <-3.719, 72.3612, -22.1317>, <-5.7847, 65.6905, -11.6813> }
				triangle { <-5.7971, 70.9525, -19.03265>, <-5.7847, 65.6905, -11.6813>, <-3.719, 72.3612, -22.1317> }
				triangle { <-7.8179, 73.8526, -21.9899>, <-11.9135, 64.3211, -34.7623>, <-11.5688, 60.2304, -40.8746> }
				triangle { <-7.8179, 73.8526, -21.9899>, <-11.5688, 60.2304, -40.8746>, <-11.9135, 64.3211, -34.7623> }
				triangle { <-11.5688, 60.2304, -40.8746>, <-10.07562, 56.9056, -43.3315>, <-9.8124, 57.169, -38.4924> }
				triangle { <-11.5688, 60.2304, -40.8746>, <-9.8124, 57.169, -38.4924>, <-10.07562, 56.9056, -43.3315> }
				triangle { <-9.8124, 57.169, -38.4924>, <-7.8179, 73.8526, -21.9899>, <-11.5688, 60.2304, -40.8746> }
				triangle { <-9.8124, 57.169, -38.4924>, <-11.5688, 60.2304, -40.8746>, <-7.8179, 73.8526, -21.9899> }
				triangle { <-7.8179, 73.8526, -21.9899>, <-9.8124, 57.169, -38.4924>, <-3.719, 72.3612, -22.1317> }
				triangle { <-7.8179, 73.8526, -21.9899>, <-3.719, 72.3612, -22.1317>, <-9.8124, 57.169, -38.4924> }
				triangle { <-2.8458, 69.8786, -19.1347>, <-1.8785, 68.2896, -17.4383>, <-5.7847, 65.6905, -11.6813> }
				triangle { <-2.8458, 69.8786, -19.1347>, <-5.7847, 65.6905, -11.6813>, <-1.8785, 68.2896, -17.4383> }
				triangle { <-2.8458, 69.8786, -19.1347>, <0.3799, 70.8698, -22.2734>, <-1.8785, 68.2896, -17.4383> }
				triangle { <-2.8458, 69.8786, -19.1347>, <-1.8785, 68.2896, -17.4383>, <0.3799, 70.8698, -22.2734> }
				triangle { <-2.8458, 69.8786, -19.1347>, <-3.719, 72.3612, -22.1317>, <0.3799, 70.8698, -22.2734> }
				triangle { <-2.8458, 69.8786, -19.1347>, <0.3799, 70.8698, -22.2734>, <-3.719, 72.3612, -22.1317> }
				triangle { <-5.7847, 65.6905, -11.6813>, <-3.719, 72.3612, -22.1317>, <-2.8458, 69.8786, -19.1347> }
				triangle { <-5.7847, 65.6905, -11.6813>, <-2.8458, 69.8786, -19.1347>, <-3.719, 72.3612, -22.1317> }
				triangle { <-6.65, 58.4407, -41.04474>, <-3.3877, 61.2189, -35.05721>, <0.3799, 70.8698, -22.2734> }
				triangle { <-6.65, 58.4407, -41.04474>, <0.3799, 70.8698, -22.2734>, <-3.3877, 61.2189, -35.05721> }
				triangle { <-9.8124, 57.169, -38.4924>, <-10.07562, 56.9056, -43.3315>, <-6.65, 58.4407, -41.04474> }
				triangle { <-9.8124, 57.169, -38.4924>, <-6.65, 58.4407, -41.04474>, <-10.07562, 56.9056, -43.3315> }
				triangle { <-6.65, 58.4407, -41.04474>, <0.3799, 70.8698, -22.2734>, <-9.8124, 57.169, -38.4924> }
				triangle { <-6.65, 58.4407, -41.04474>, <-9.8124, 57.169, -38.4924>, <0.3799, 70.8698, -22.2734> }
				triangle { <-3.719, 72.3612, -22.1317>, <-9.8124, 57.169, -38.4924>, <0.3799, 70.8698, -22.2734> }
				triangle { <-3.719, 72.3612, -22.1317>, <0.3799, 70.8698, -22.2734>, <-9.8124, 57.169, -38.4924> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-6.8633, 52.7557, -0.4002>, <-6.985, 53.1425, -0.2653>, 0.0777 }
		cylinder { <-6.985, 53.1425, -0.2653>, <-7.1239, 53.4842, -0.04945>, 0.0777 }
		cylinder { <-7.1239, 53.4842, -0.04945>, <-7.2734, 53.7641, 0.2367>, 0.0777 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-7.2734, 53.7641, 0.2367>, <-7.384, 53.8864, 0.501>, 0.02124 }
			cylinder { <-7.384, 53.8864, 0.501>, <-7.4853, 53.9145, 0.7943>, 0.02124 }
			cylinder { <-7.4853, 53.9145, 0.7943>, <-7.5668, 53.8455, 1.08707>, 0.02124 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-7.5668, 53.8455, 1.08707>, <-7.5912, 53.8248, 1.1748>, 0.02124 }
				cylinder { <-7.5912, 53.8248, 1.1748>, <-7.6157, 53.8042, 1.2626>, 0.02124 }
				cylinder { <-7.6157, 53.8042, 1.2626>, <-7.6402, 53.7835, 1.3504>, 0.02124 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.6402, 53.7835, 1.3504>, <-7.6428, 53.7821, 1.3548>, 0.0003609 }
				cylinder { <-7.6428, 53.7821, 1.3548>, <-7.6465, 53.7806, 1.3582>, 0.0003609 }
				cylinder { <-7.6465, 53.7806, 1.3582>, <-7.6511, 53.7791, 1.3605>, 0.0003609 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.6511, 53.7791, 1.3605>, <-8.2058, 53.7421, 1.9291>, <-8.4309, 53.5959, 1.904> }
				triangle { <-7.6511, 53.7791, 1.3605>, <-8.4309, 53.5959, 1.904>, <-8.2058, 53.7421, 1.9291> }
				triangle { <-8.2058, 53.7421, 1.9291>, <-8.7015, 53.6457, 2.3137>, <-8.4309, 53.5959, 1.904> }
				triangle { <-8.2058, 53.7421, 1.9291>, <-8.4309, 53.5959, 1.904>, <-8.7015, 53.6457, 2.3137> }
				triangle { <-8.7015, 53.6457, 2.3137>, <-8.8043, 53.3909, 1.9357>, <-8.4309, 53.5959, 1.904> }
				triangle { <-8.7015, 53.6457, 2.3137>, <-8.4309, 53.5959, 1.904>, <-8.8043, 53.3909, 1.9357> }
				triangle { <-8.4309, 53.5959, 1.904>, <-8.8043, 53.3909, 1.9357>, <-7.6511, 53.7791, 1.3605> }
				triangle { <-8.4309, 53.5959, 1.904>, <-7.6511, 53.7791, 1.3605>, <-8.8043, 53.3909, 1.9357> }
				triangle { <-8.7015, 53.6457, 2.3137>, <-8.3613, 52.1808, 3.2318>, <-8.3563, 51.4327, 3.4805> }
				triangle { <-8.7015, 53.6457, 2.3137>, <-8.3563, 51.4327, 3.4805>, <-8.3613, 52.1808, 3.2318> }
				triangle { <-8.3563, 51.4327, 3.4805>, <-8.2917, 50.9694, 3.4286>, <-8.0876, 51.3381, 3.1246> }
				triangle { <-8.3563, 51.4327, 3.4805>, <-8.0876, 51.3381, 3.1246>, <-8.2917, 50.9694, 3.4286> }
				triangle { <-8.0876, 51.3381, 3.1246>, <-8.7015, 53.6457, 2.3137>, <-8.3563, 51.4327, 3.4805> }
				triangle { <-8.0876, 51.3381, 3.1246>, <-8.3563, 51.4327, 3.4805>, <-8.7015, 53.6457, 2.3137> }
				triangle { <-8.7015, 53.6457, 2.3137>, <-8.0876, 51.3381, 3.1246>, <-8.8043, 53.3909, 1.9357> }
				triangle { <-8.7015, 53.6457, 2.3137>, <-8.8043, 53.3909, 1.9357>, <-8.0876, 51.3381, 3.1246> }
				triangle { <-8.5049, 53.4124, 1.6319>, <-8.3456, 53.3956, 1.415>, <-7.6511, 53.7791, 1.3605> }
				triangle { <-8.5049, 53.4124, 1.6319>, <-7.6511, 53.7791, 1.3605>, <-8.3456, 53.3956, 1.415> }
				triangle { <-8.5049, 53.4124, 1.6319>, <-8.9071, 53.1361, 1.5577>, <-8.3456, 53.3956, 1.415> }
				triangle { <-8.5049, 53.4124, 1.6319>, <-8.3456, 53.3956, 1.415>, <-8.9071, 53.1361, 1.5577> }
				triangle { <-8.5049, 53.4124, 1.6319>, <-8.8043, 53.3909, 1.9357>, <-8.9071, 53.1361, 1.5577> }
				triangle { <-8.5049, 53.4124, 1.6319>, <-8.9071, 53.1361, 1.5577>, <-8.8043, 53.3909, 1.9357> }
				triangle { <-7.6511, 53.7791, 1.3605>, <-8.8043, 53.3909, 1.9357>, <-8.5049, 53.4124, 1.6319> }
				triangle { <-7.6511, 53.7791, 1.3605>, <-8.5049, 53.4124, 1.6319>, <-8.8043, 53.3909, 1.9357> }
				triangle { <-8.4797, 51.1269, 3.02694>, <-8.5752, 51.6508, 2.4455>, <-8.9071, 53.1361, 1.5577> }
				triangle { <-8.4797, 51.1269, 3.02694>, <-8.9071, 53.1361, 1.5577>, <-8.5752, 51.6508, 2.4455> }
				triangle { <-8.0876, 51.3381, 3.1246>, <-8.2917, 50.9694, 3.4286>, <-8.4797, 51.1269, 3.02694> }
				triangle { <-8.0876, 51.3381, 3.1246>, <-8.4797, 51.1269, 3.02694>, <-8.2917, 50.9694, 3.4286> }
				triangle { <-8.4797, 51.1269, 3.02694>, <-8.9071, 53.1361, 1.5577>, <-8.0876, 51.3381, 3.1246> }
				triangle { <-8.4797, 51.1269, 3.02694>, <-8.0876, 51.3381, 3.1246>, <-8.9071, 53.1361, 1.5577> }
				triangle { <-8.8043, 53.3909, 1.9357>, <-8.0876, 51.3381, 3.1246>, <-8.9071, 53.1361, 1.5577> }
				triangle { <-8.8043, 53.3909, 1.9357>, <-8.9071, 53.1361, 1.5577>, <-8.0876, 51.3381, 3.1246> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.6402, 53.7835, 1.3504>, <-7.6646, 53.7628, 1.4382>, 0.02124 }
				cylinder { <-7.6646, 53.7628, 1.4382>, <-7.6891, 53.7421, 1.526>, 0.02124 }
				cylinder { <-7.6891, 53.7421, 1.526>, <-7.7135, 53.7215, 1.6138>, 0.02124 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.7135, 53.7215, 1.6138>, <-7.7135, 53.7206, 1.6191>, 0.0003609 }
				cylinder { <-7.7135, 53.7206, 1.6191>, <-7.7122, 53.7201, 1.6242>, 0.0003609 }
				cylinder { <-7.7122, 53.7201, 1.6242>, <-7.7096, 53.72, 1.6288>, 0.0003609 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.7096, 53.72, 1.6288>, <-7.1814, 53.9629, 2.1714>, <-7.1485, 53.8391, 2.4086> }
				triangle { <-7.7096, 53.72, 1.6288>, <-7.1485, 53.8391, 2.4086>, <-7.1814, 53.9629, 2.1714> }
				triangle { <-7.1814, 53.9629, 2.1714>, <-6.797, 54.0726, 2.6645>, <-7.1485, 53.8391, 2.4086> }
				triangle { <-7.1814, 53.9629, 2.1714>, <-7.1485, 53.8391, 2.4086>, <-6.797, 54.0726, 2.6645> }
				triangle { <-6.797, 54.0726, 2.6645>, <-7.04213, 53.6975, 2.7972>, <-7.1485, 53.8391, 2.4086> }
				triangle { <-6.797, 54.0726, 2.6645>, <-7.1485, 53.8391, 2.4086>, <-7.04213, 53.6975, 2.7972> }
				triangle { <-7.1485, 53.8391, 2.4086>, <-7.04213, 53.6975, 2.7972>, <-7.7096, 53.72, 1.6288> }
				triangle { <-7.1485, 53.8391, 2.4086>, <-7.7096, 53.72, 1.6288>, <-7.04213, 53.6975, 2.7972> }
				triangle { <-6.797, 54.0726, 2.6645>, <-5.3633, 53.07585, 2.4291>, <-4.8348, 52.4931, 2.482> }
				triangle { <-6.797, 54.0726, 2.6645>, <-4.8348, 52.4931, 2.482>, <-5.3633, 53.07585, 2.4291> }
				triangle { <-4.8348, 52.4931, 2.482>, <-4.6953, 52.04426, 2.4582>, <-5.1192, 52.2406, 2.2305> }
				triangle { <-4.8348, 52.4931, 2.482>, <-5.1192, 52.2406, 2.2305>, <-4.6953, 52.04426, 2.4582> }
				triangle { <-5.1192, 52.2406, 2.2305>, <-6.797, 54.0726, 2.6645>, <-4.8348, 52.4931, 2.482> }
				triangle { <-5.1192, 52.2406, 2.2305>, <-4.8348, 52.4931, 2.482>, <-6.797, 54.0726, 2.6645> }
				triangle { <-6.797, 54.0726, 2.6645>, <-5.1192, 52.2406, 2.2305>, <-7.04213, 53.6975, 2.7972> }
				triangle { <-6.797, 54.0726, 2.6645>, <-7.04213, 53.6975, 2.7972>, <-5.1192, 52.2406, 2.2305> }
				triangle { <-7.325, 53.569, 2.5042>, <-7.5147, 53.4527, 2.352>, <-7.7096, 53.72, 1.6288> }
				triangle { <-7.325, 53.569, 2.5042>, <-7.7096, 53.72, 1.6288>, <-7.5147, 53.4527, 2.352> }
				triangle { <-7.325, 53.569, 2.5042>, <-7.2872, 53.3224, 2.93>, <-7.5147, 53.4527, 2.352> }
				triangle { <-7.325, 53.569, 2.5042>, <-7.5147, 53.4527, 2.352>, <-7.2872, 53.3224, 2.93> }
				triangle { <-7.325, 53.569, 2.5042>, <-7.04213, 53.6975, 2.7972>, <-7.2872, 53.3224, 2.93> }
				triangle { <-7.325, 53.569, 2.5042>, <-7.2872, 53.3224, 2.93>, <-7.04213, 53.6975, 2.7972> }
				triangle { <-7.7096, 53.72, 1.6288>, <-7.04213, 53.6975, 2.7972>, <-7.325, 53.569, 2.5042> }
				triangle { <-7.7096, 53.72, 1.6288>, <-7.325, 53.569, 2.5042>, <-7.04213, 53.6975, 2.7972> }
				triangle { <-5.1289, 52.04303, 2.6413>, <-5.873, 52.2956, 2.7052>, <-7.2872, 53.3224, 2.93> }
				triangle { <-5.1289, 52.04303, 2.6413>, <-7.2872, 53.3224, 2.93>, <-5.873, 52.2956, 2.7052> }
				triangle { <-5.1192, 52.2406, 2.2305>, <-4.6953, 52.04426, 2.4582>, <-5.1289, 52.04303, 2.6413> }
				triangle { <-5.1192, 52.2406, 2.2305>, <-5.1289, 52.04303, 2.6413>, <-4.6953, 52.04426, 2.4582> }
				triangle { <-5.1289, 52.04303, 2.6413>, <-7.2872, 53.3224, 2.93>, <-5.1192, 52.2406, 2.2305> }
				triangle { <-5.1289, 52.04303, 2.6413>, <-5.1192, 52.2406, 2.2305>, <-7.2872, 53.3224, 2.93> }
				triangle { <-7.04213, 53.6975, 2.7972>, <-5.1192, 52.2406, 2.2305>, <-7.2872, 53.3224, 2.93> }
				triangle { <-7.04213, 53.6975, 2.7972>, <-7.2872, 53.3224, 2.93>, <-5.1192, 52.2406, 2.2305> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.7135, 53.7215, 1.6138>, <-7.738, 53.7008, 1.7017>, 0.02124 }
				cylinder { <-7.738, 53.7008, 1.7017>, <-7.7624, 53.6801, 1.7895>, 0.02124 }
				cylinder { <-7.7624, 53.6801, 1.7895>, <-7.7869, 53.6594, 1.8773>, 0.02124 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.7869, 53.6594, 1.8773>, <-7.7896, 53.658, 1.8816>, 0.0003609 }
				cylinder { <-7.7896, 53.658, 1.8816>, <-7.7933, 53.6565, 1.8851>, 0.0003609 }
				cylinder { <-7.7933, 53.6565, 1.8851>, <-7.7978, 53.655, 1.8873>, 0.0003609 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.7978, 53.655, 1.8873>, <-8.3526, 53.618, 2.4559>, <-8.5777, 53.4718, 2.4308> }
				triangle { <-7.7978, 53.655, 1.8873>, <-8.5777, 53.4718, 2.4308>, <-8.3526, 53.618, 2.4559> }
				triangle { <-8.3526, 53.618, 2.4559>, <-8.8482, 53.5217, 2.8405>, <-8.5777, 53.4718, 2.4308> }
				triangle { <-8.3526, 53.618, 2.4559>, <-8.5777, 53.4718, 2.4308>, <-8.8482, 53.5217, 2.8405> }
				triangle { <-8.8482, 53.5217, 2.8405>, <-8.951, 53.2669, 2.4625>, <-8.5777, 53.4718, 2.4308> }
				triangle { <-8.8482, 53.5217, 2.8405>, <-8.5777, 53.4718, 2.4308>, <-8.951, 53.2669, 2.4625> }
				triangle { <-8.5777, 53.4718, 2.4308>, <-8.951, 53.2669, 2.4625>, <-7.7978, 53.655, 1.8873> }
				triangle { <-8.5777, 53.4718, 2.4308>, <-7.7978, 53.655, 1.8873>, <-8.951, 53.2669, 2.4625> }
				triangle { <-8.8482, 53.5217, 2.8405>, <-8.5081, 52.05679, 3.7586>, <-8.5031, 51.3086, 4.007377> }
				triangle { <-8.8482, 53.5217, 2.8405>, <-8.5031, 51.3086, 4.007377>, <-8.5081, 52.05679, 3.7586> }
				triangle { <-8.5031, 51.3086, 4.007377>, <-8.4385, 50.8453, 3.9554>, <-8.2343, 51.214, 3.6514> }
				triangle { <-8.5031, 51.3086, 4.007377>, <-8.2343, 51.214, 3.6514>, <-8.4385, 50.8453, 3.9554> }
				triangle { <-8.2343, 51.214, 3.6514>, <-8.8482, 53.5217, 2.8405>, <-8.5031, 51.3086, 4.007377> }
				triangle { <-8.2343, 51.214, 3.6514>, <-8.5031, 51.3086, 4.007377>, <-8.8482, 53.5217, 2.8405> }
				triangle { <-8.8482, 53.5217, 2.8405>, <-8.2343, 51.214, 3.6514>, <-8.951, 53.2669, 2.4625> }
				triangle { <-8.8482, 53.5217, 2.8405>, <-8.951, 53.2669, 2.4625>, <-8.2343, 51.214, 3.6514> }
				triangle { <-8.6517, 53.2883, 2.1587>, <-8.4924, 53.2715, 1.9418>, <-7.7978, 53.655, 1.8873> }
				triangle { <-8.6517, 53.2883, 2.1587>, <-7.7978, 53.655, 1.8873>, <-8.4924, 53.2715, 1.9418> }
				triangle { <-8.6517, 53.2883, 2.1587>, <-9.05385, 53.0121, 2.08456>, <-8.4924, 53.2715, 1.9418> }
				triangle { <-8.6517, 53.2883, 2.1587>, <-8.4924, 53.2715, 1.9418>, <-9.05385, 53.0121, 2.08456> }
				triangle { <-8.6517, 53.2883, 2.1587>, <-8.951, 53.2669, 2.4625>, <-9.05385, 53.0121, 2.08456> }
				triangle { <-8.6517, 53.2883, 2.1587>, <-9.05385, 53.0121, 2.08456>, <-8.951, 53.2669, 2.4625> }
				triangle { <-7.7978, 53.655, 1.8873>, <-8.951, 53.2669, 2.4625>, <-8.6517, 53.2883, 2.1587> }
				triangle { <-7.7978, 53.655, 1.8873>, <-8.6517, 53.2883, 2.1587>, <-8.951, 53.2669, 2.4625> }
				triangle { <-8.6264, 51.00289, 3.5537>, <-8.7219, 51.5268, 2.9723>, <-9.05385, 53.0121, 2.08456> }
				triangle { <-8.6264, 51.00289, 3.5537>, <-9.05385, 53.0121, 2.08456>, <-8.7219, 51.5268, 2.9723> }
				triangle { <-8.2343, 51.214, 3.6514>, <-8.4385, 50.8453, 3.9554>, <-8.6264, 51.00289, 3.5537> }
				triangle { <-8.2343, 51.214, 3.6514>, <-8.6264, 51.00289, 3.5537>, <-8.4385, 50.8453, 3.9554> }
				triangle { <-8.6264, 51.00289, 3.5537>, <-9.05385, 53.0121, 2.08456>, <-8.2343, 51.214, 3.6514> }
				triangle { <-8.6264, 51.00289, 3.5537>, <-8.2343, 51.214, 3.6514>, <-9.05385, 53.0121, 2.08456> }
				triangle { <-8.951, 53.2669, 2.4625>, <-8.2343, 51.214, 3.6514>, <-9.05385, 53.0121, 2.08456> }
				triangle { <-8.951, 53.2669, 2.4625>, <-9.05385, 53.0121, 2.08456>, <-8.2343, 51.214, 3.6514> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.7869, 53.6594, 1.8773>, <-7.7883, 53.6582, 1.8822>, 0.0003609 }
				cylinder { <-7.7883, 53.6582, 1.8822>, <-7.7897, 53.6571, 1.8872>, 0.0003609 }
				cylinder { <-7.7897, 53.6571, 1.8872>, <-7.7911, 53.6559, 1.8922>, 0.0003609 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.7911, 53.6559, 1.8922>, <-7.7896, 53.7236, 2.6845>, <-7.9387, 53.5662, 2.8447> }
				triangle { <-7.7911, 53.6559, 1.8922>, <-7.9387, 53.5662, 2.8447>, <-7.7896, 53.7236, 2.6845> }
				triangle { <-7.7896, 53.7236, 2.6845>, <-7.8605, 53.6949, 3.3146>, <-7.9387, 53.5662, 2.8447> }
				triangle { <-7.7896, 53.7236, 2.6845>, <-7.9387, 53.5662, 2.8447>, <-7.8605, 53.6949, 3.3146> }
				triangle { <-7.8605, 53.6949, 3.3146>, <-8.1433, 53.3581, 3.1565>, <-7.9387, 53.5662, 2.8447> }
				triangle { <-7.8605, 53.6949, 3.3146>, <-7.9387, 53.5662, 2.8447>, <-8.1433, 53.3581, 3.1565> }
				triangle { <-7.9387, 53.5662, 2.8447>, <-8.1433, 53.3581, 3.1565>, <-7.7911, 53.6559, 1.8922> }
				triangle { <-7.9387, 53.5662, 2.8447>, <-7.7911, 53.6559, 1.8922>, <-8.1433, 53.3581, 3.1565> }
				triangle { <-7.8605, 53.6949, 3.3146>, <-6.7212, 52.4874, 3.9047>, <-6.4087, 51.8145, 4.1715> }
				triangle { <-7.8605, 53.6949, 3.3146>, <-6.4087, 51.8145, 4.1715>, <-6.7212, 52.4874, 3.9047> }
				triangle { <-6.4087, 51.8145, 4.1715>, <-6.3119, 51.3544, 4.1498>, <-6.4432, 51.6541, 3.7461> }
				triangle { <-6.4087, 51.8145, 4.1715>, <-6.4432, 51.6541, 3.7461>, <-6.3119, 51.3544, 4.1498> }
				triangle { <-6.4432, 51.6541, 3.7461>, <-7.8605, 53.6949, 3.3146>, <-6.4087, 51.8145, 4.1715> }
				triangle { <-6.4432, 51.6541, 3.7461>, <-6.4087, 51.8145, 4.1715>, <-7.8605, 53.6949, 3.3146> }
				triangle { <-7.8605, 53.6949, 3.3146>, <-6.4432, 51.6541, 3.7461>, <-8.1433, 53.3581, 3.1565> }
				triangle { <-7.8605, 53.6949, 3.3146>, <-8.1433, 53.3581, 3.1565>, <-6.4432, 51.6541, 3.7461> }
				triangle { <-8.1423, 53.3237, 2.7309>, <-8.1741, 53.2656, 2.4695>, <-7.7911, 53.6559, 1.8922> }
				triangle { <-8.1423, 53.3237, 2.7309>, <-7.7911, 53.6559, 1.8922>, <-8.1741, 53.2656, 2.4695> }
				triangle { <-8.1423, 53.3237, 2.7309>, <-8.426, 53.02136, 2.9985>, <-8.1741, 53.2656, 2.4695> }
				triangle { <-8.1423, 53.3237, 2.7309>, <-8.1741, 53.2656, 2.4695>, <-8.426, 53.02136, 2.9985> }
				triangle { <-8.1423, 53.3237, 2.7309>, <-8.1433, 53.3581, 3.1565>, <-8.426, 53.02136, 2.9985> }
				triangle { <-8.1423, 53.3237, 2.7309>, <-8.426, 53.02136, 2.9985>, <-8.1433, 53.3581, 3.1565> }
				triangle { <-7.7911, 53.6559, 1.8922>, <-8.1433, 53.3581, 3.1565>, <-8.1423, 53.3237, 2.7309> }
				triangle { <-7.7911, 53.6559, 1.8922>, <-8.1423, 53.3237, 2.7309>, <-8.1433, 53.3581, 3.1565> }
				triangle { <-6.748, 51.4103, 3.9818>, <-7.3093, 51.7868, 3.5759>, <-8.426, 53.02136, 2.9985> }
				triangle { <-6.748, 51.4103, 3.9818>, <-8.426, 53.02136, 2.9985>, <-7.3093, 51.7868, 3.5759> }
				triangle { <-6.4432, 51.6541, 3.7461>, <-6.3119, 51.3544, 4.1498>, <-6.748, 51.4103, 3.9818> }
				triangle { <-6.4432, 51.6541, 3.7461>, <-6.748, 51.4103, 3.9818>, <-6.3119, 51.3544, 4.1498> }
				triangle { <-6.748, 51.4103, 3.9818>, <-8.426, 53.02136, 2.9985>, <-6.4432, 51.6541, 3.7461> }
				triangle { <-6.748, 51.4103, 3.9818>, <-6.4432, 51.6541, 3.7461>, <-8.426, 53.02136, 2.9985> }
				triangle { <-8.1433, 53.3581, 3.1565>, <-6.4432, 51.6541, 3.7461>, <-8.426, 53.02136, 2.9985> }
				triangle { <-8.1433, 53.3581, 3.1565>, <-8.426, 53.02136, 2.9985>, <-6.4432, 51.6541, 3.7461> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-7.2734, 53.7641, 0.2367>, <-7.3696, 54.02949, 0.3687>, 0.02124 }
			cylinder { <-7.3696, 54.02949, 0.3687>, <-7.4435, 54.3292, 0.4105>, 0.02124 }
			cylinder { <-7.4435, 54.3292, 0.4105>, <-7.4874, 54.6331, 0.3582>, 0.02124 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-7.4874, 54.6331, 0.3582>, <-7.5006, 54.7243, 0.3425>, 0.02124 }
				cylinder { <-7.5006, 54.7243, 0.3425>, <-7.5138, 54.8155, 0.3267>, 0.02124 }
				cylinder { <-7.5138, 54.8155, 0.3267>, <-7.527, 54.9067, 0.311>, 0.02124 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.527, 54.9067, 0.311>, <-7.5264, 54.9119, 0.3106>, 0.0003609 }
				cylinder { <-7.5264, 54.9119, 0.3106>, <-7.5245, 54.9169, 0.3107>, 0.0003609 }
				cylinder { <-7.5245, 54.9169, 0.3107>, <-7.5214, 54.9212, 0.3112>, 0.0003609 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.5214, 54.9212, 0.3112>, <-7.3519, 55.6795, 0.4802>, <-7.1031, 55.7814, 0.46> }
				triangle { <-7.5214, 54.9212, 0.3112>, <-7.1031, 55.7814, 0.46>, <-7.3519, 55.6795, 0.4802> }
				triangle { <-7.3519, 55.6795, 0.4802>, <-7.1136, 56.2578, 0.5883>, <-7.1031, 55.7814, 0.46> }
				triangle { <-7.3519, 55.6795, 0.4802>, <-7.1031, 55.7814, 0.46>, <-7.1136, 56.2578, 0.5883> }
				triangle { <-7.1136, 56.2578, 0.5883>, <-6.7421, 56.00938, 0.4518>, <-7.1031, 55.7814, 0.46> }
				triangle { <-7.1136, 56.2578, 0.5883>, <-7.1031, 55.7814, 0.46>, <-6.7421, 56.00938, 0.4518> }
				triangle { <-7.1031, 55.7814, 0.46>, <-6.7421, 56.00938, 0.4518>, <-7.5214, 54.9212, 0.3112> }
				triangle { <-7.1031, 55.7814, 0.46>, <-7.5214, 54.9212, 0.3112>, <-6.7421, 56.00938, 0.4518> }
				triangle { <-7.1136, 56.2578, 0.5883>, <-7.1293, 57.1153, -0.9507>, <-6.9068, 57.4373, -1.6351> }
				triangle { <-7.1136, 56.2578, 0.5883>, <-6.9068, 57.4373, -1.6351>, <-7.1293, 57.1153, -0.9507> }
				triangle { <-6.9068, 57.4373, -1.6351>, <-6.719, 57.4279, -2.06658>, <-6.8997, 57.0153, -1.8074> }
				triangle { <-6.9068, 57.4373, -1.6351>, <-6.8997, 57.0153, -1.8074>, <-6.719, 57.4279, -2.06658> }
				triangle { <-6.8997, 57.0153, -1.8074>, <-7.1136, 56.2578, 0.5883>, <-6.9068, 57.4373, -1.6351> }
				triangle { <-6.8997, 57.0153, -1.8074>, <-6.9068, 57.4373, -1.6351>, <-7.1136, 56.2578, 0.5883> }
				triangle { <-7.1136, 56.2578, 0.5883>, <-6.8997, 57.0153, -1.8074>, <-6.7421, 56.00938, 0.4518> }
				triangle { <-7.1136, 56.2578, 0.5883>, <-6.7421, 56.00938, 0.4518>, <-6.8997, 57.0153, -1.8074> }
				triangle { <-6.8356, 55.6025, 0.3616>, <-6.8467, 55.3416, 0.2945>, <-7.5214, 54.9212, 0.3112> }
				triangle { <-6.8356, 55.6025, 0.3616>, <-7.5214, 54.9212, 0.3112>, <-6.8467, 55.3416, 0.2945> }
				triangle { <-6.8356, 55.6025, 0.3616>, <-6.3706, 55.7609, 0.3153>, <-6.8467, 55.3416, 0.2945> }
				triangle { <-6.8356, 55.6025, 0.3616>, <-6.8467, 55.3416, 0.2945>, <-6.3706, 55.7609, 0.3153> }
				triangle { <-6.8356, 55.6025, 0.3616>, <-6.7421, 56.00938, 0.4518>, <-6.3706, 55.7609, 0.3153> }
				triangle { <-6.8356, 55.6025, 0.3616>, <-6.3706, 55.7609, 0.3153>, <-6.7421, 56.00938, 0.4518> }
				triangle { <-7.5214, 54.9212, 0.3112>, <-6.7421, 56.00938, 0.4518>, <-6.8356, 55.6025, 0.3616> }
				triangle { <-7.5214, 54.9212, 0.3112>, <-6.8356, 55.6025, 0.3616>, <-6.7421, 56.00938, 0.4518> }
				triangle { <-6.461, 57.1392, -1.7989>, <-6.3566, 56.5985, -1.2347>, <-6.3706, 55.7609, 0.3153> }
				triangle { <-6.461, 57.1392, -1.7989>, <-6.3706, 55.7609, 0.3153>, <-6.3566, 56.5985, -1.2347> }
				triangle { <-6.8997, 57.0153, -1.8074>, <-6.719, 57.4279, -2.06658>, <-6.461, 57.1392, -1.7989> }
				triangle { <-6.8997, 57.0153, -1.8074>, <-6.461, 57.1392, -1.7989>, <-6.719, 57.4279, -2.06658> }
				triangle { <-6.461, 57.1392, -1.7989>, <-6.3706, 55.7609, 0.3153>, <-6.8997, 57.0153, -1.8074> }
				triangle { <-6.461, 57.1392, -1.7989>, <-6.8997, 57.0153, -1.8074>, <-6.3706, 55.7609, 0.3153> }
				triangle { <-6.7421, 56.00938, 0.4518>, <-6.8997, 57.0153, -1.8074>, <-6.3706, 55.7609, 0.3153> }
				triangle { <-6.7421, 56.00938, 0.4518>, <-6.3706, 55.7609, 0.3153>, <-6.8997, 57.0153, -1.8074> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.527, 54.9067, 0.311>, <-7.5402, 54.9979, 0.2953>, 0.02124 }
				cylinder { <-7.5402, 54.9979, 0.2953>, <-7.5534, 55.0891, 0.2796>, 0.02124 }
				cylinder { <-7.5534, 55.0891, 0.2796>, <-7.5666, 55.1802, 0.2639>, 0.02124 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.5666, 55.1802, 0.2639>, <-7.5686, 55.185, 0.2626>, 0.0003609 }
				cylinder { <-7.5686, 55.185, 0.2626>, <-7.5718, 55.1889, 0.261>, 0.0003609 }
				cylinder { <-7.5718, 55.1889, 0.261>, <-7.5759, 55.1917, 0.2592>, 0.0003609 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.5759, 55.1917, 0.2592>, <-8.3404, 55.3914, 0.169>, <-8.4196, 55.602, 0.02069> }
				triangle { <-7.5759, 55.1917, 0.2592>, <-8.4196, 55.602, 0.02069>, <-8.3404, 55.3914, 0.169> }
				triangle { <-8.3404, 55.3914, 0.169>, <-8.912, 55.6323, 0.03456>, <-8.4196, 55.602, 0.02069> }
				triangle { <-8.3404, 55.3914, 0.169>, <-8.4196, 55.602, 0.02069>, <-8.912, 55.6323, 0.03456> }
				triangle { <-8.912, 55.6323, 0.03456>, <-8.6172, 55.9143, -0.1933>, <-8.4196, 55.602, 0.02069> }
				triangle { <-8.912, 55.6323, 0.03456>, <-8.4196, 55.602, 0.02069>, <-8.6172, 55.9143, -0.1933> }
				triangle { <-8.4196, 55.602, 0.02069>, <-8.6172, 55.9143, -0.1933>, <-7.5759, 55.1917, 0.2592> }
				triangle { <-8.4196, 55.602, 0.02069>, <-7.5759, 55.1917, 0.2592>, <-8.6172, 55.9143, -0.1933> }
				triangle { <-8.912, 55.6323, 0.03456>, <-9.4279, 54.9102, -1.4875>, <-9.5848, 54.7971, -2.2518> }
				triangle { <-8.912, 55.6323, 0.03456>, <-9.5848, 54.7971, -2.2518>, <-9.4279, 54.9102, -1.4875> }
				triangle { <-9.5848, 54.7971, -2.2518>, <-9.4733, 54.776, -2.7086>, <-9.1364, 54.7426, -2.3143> }
				triangle { <-9.5848, 54.7971, -2.2518>, <-9.1364, 54.7426, -2.3143>, <-9.4733, 54.776, -2.7086> }
				triangle { <-9.1364, 54.7426, -2.3143>, <-8.912, 55.6323, 0.03456>, <-9.5848, 54.7971, -2.2518> }
				triangle { <-9.1364, 54.7426, -2.3143>, <-9.5848, 54.7971, -2.2518>, <-8.912, 55.6323, 0.03456> }
				triangle { <-8.912, 55.6323, 0.03456>, <-9.1364, 54.7426, -2.3143>, <-8.6172, 55.9143, -0.1933> }
				triangle { <-8.912, 55.6323, 0.03456>, <-8.6172, 55.9143, -0.1933>, <-9.1364, 54.7426, -2.3143> }
				triangle { <-8.2073, 55.8051, -0.1434>, <-7.9395, 55.7749, -0.1409>, <-7.5759, 55.1917, 0.2592> }
				triangle { <-8.2073, 55.8051, -0.1434>, <-7.5759, 55.1917, 0.2592>, <-7.9395, 55.7749, -0.1409> }
				triangle { <-8.2073, 55.8051, -0.1434>, <-8.3224, 56.1963, -0.4213>, <-7.9395, 55.7749, -0.1409> }
				triangle { <-8.2073, 55.8051, -0.1434>, <-7.9395, 55.7749, -0.1409>, <-8.3224, 56.1963, -0.4213> }
				triangle { <-8.2073, 55.8051, -0.1434>, <-8.6172, 55.9143, -0.1933>, <-8.3224, 56.1963, -0.4213> }
				triangle { <-8.2073, 55.8051, -0.1434>, <-8.3224, 56.1963, -0.4213>, <-8.6172, 55.9143, -0.1933> }
				triangle { <-7.5759, 55.1917, 0.2592>, <-8.6172, 55.9143, -0.1933>, <-8.2073, 55.8051, -0.1434> }
				triangle { <-7.5759, 55.1917, 0.2592>, <-8.2073, 55.8051, -0.1434>, <-8.6172, 55.9143, -0.1933> }
				triangle { <-9.2311, 55.1355, -2.5254>, <-8.8147, 55.4967, -1.9617>, <-8.3224, 56.1963, -0.4213> }
				triangle { <-9.2311, 55.1355, -2.5254>, <-8.3224, 56.1963, -0.4213>, <-8.8147, 55.4967, -1.9617> }
				triangle { <-9.1364, 54.7426, -2.3143>, <-9.4733, 54.776, -2.7086>, <-9.2311, 55.1355, -2.5254> }
				triangle { <-9.1364, 54.7426, -2.3143>, <-9.2311, 55.1355, -2.5254>, <-9.4733, 54.776, -2.7086> }
				triangle { <-9.2311, 55.1355, -2.5254>, <-8.3224, 56.1963, -0.4213>, <-9.1364, 54.7426, -2.3143> }
				triangle { <-9.2311, 55.1355, -2.5254>, <-9.1364, 54.7426, -2.3143>, <-8.3224, 56.1963, -0.4213> }
				triangle { <-8.6172, 55.9143, -0.1933>, <-9.1364, 54.7426, -2.3143>, <-8.3224, 56.1963, -0.4213> }
				triangle { <-8.6172, 55.9143, -0.1933>, <-8.3224, 56.1963, -0.4213>, <-9.1364, 54.7426, -2.3143> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.5666, 55.1802, 0.2639>, <-7.5798, 55.2714, 0.2482>, 0.02124 }
				cylinder { <-7.5798, 55.2714, 0.2482>, <-7.5929, 55.3626, 0.2324>, 0.02124 }
				cylinder { <-7.5929, 55.3626, 0.2324>, <-7.6061, 55.4538, 0.2167>, 0.02124 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-7.6061, 55.4538, 0.2167>, <-7.6055, 55.459, 0.2163>, 0.0003609 }
				cylinder { <-7.6055, 55.459, 0.2163>, <-7.6036, 55.464, 0.2164>, 0.0003609 }
				cylinder { <-7.6036, 55.464, 0.2164>, <-7.6006, 55.4682, 0.2169>, 0.0003609 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.6006, 55.4682, 0.2169>, <-7.431, 56.2266, 0.3859>, <-7.1823, 56.3285, 0.3657> }
				triangle { <-7.6006, 55.4682, 0.2169>, <-7.1823, 56.3285, 0.3657>, <-7.431, 56.2266, 0.3859> }
				triangle { <-7.431, 56.2266, 0.3859>, <-7.1927, 56.8049, 0.4941>, <-7.1823, 56.3285, 0.3657> }
				triangle { <-7.431, 56.2266, 0.3859>, <-7.1823, 56.3285, 0.3657>, <-7.1927, 56.8049, 0.4941> }
				triangle { <-7.1927, 56.8049, 0.4941>, <-6.8212, 56.5564, 0.3575>, <-7.1823, 56.3285, 0.3657> }
				triangle { <-7.1927, 56.8049, 0.4941>, <-7.1823, 56.3285, 0.3657>, <-6.8212, 56.5564, 0.3575> }
				triangle { <-7.1823, 56.3285, 0.3657>, <-6.8212, 56.5564, 0.3575>, <-7.6006, 55.4682, 0.2169> }
				triangle { <-7.1823, 56.3285, 0.3657>, <-7.6006, 55.4682, 0.2169>, <-6.8212, 56.5564, 0.3575> }
				triangle { <-7.1927, 56.8049, 0.4941>, <-7.2085, 57.6624, -1.04504>, <-6.986, 57.9844, -1.7294> }
				triangle { <-7.1927, 56.8049, 0.4941>, <-6.986, 57.9844, -1.7294>, <-7.2085, 57.6624, -1.04504> }
				triangle { <-6.986, 57.9844, -1.7294>, <-6.7982, 57.975, -2.1608>, <-6.9789, 57.5624, -1.9017> }
				triangle { <-6.986, 57.9844, -1.7294>, <-6.9789, 57.5624, -1.9017>, <-6.7982, 57.975, -2.1608> }
				triangle { <-6.9789, 57.5624, -1.9017>, <-7.1927, 56.8049, 0.4941>, <-6.986, 57.9844, -1.7294> }
				triangle { <-6.9789, 57.5624, -1.9017>, <-6.986, 57.9844, -1.7294>, <-7.1927, 56.8049, 0.4941> }
				triangle { <-7.1927, 56.8049, 0.4941>, <-6.9789, 57.5624, -1.9017>, <-6.8212, 56.5564, 0.3575> }
				triangle { <-7.1927, 56.8049, 0.4941>, <-6.8212, 56.5564, 0.3575>, <-6.9789, 57.5624, -1.9017> }
				triangle { <-6.9148, 56.1496, 0.2674>, <-6.9258, 55.8887, 0.2002>, <-7.6006, 55.4682, 0.2169> }
				triangle { <-6.9148, 56.1496, 0.2674>, <-7.6006, 55.4682, 0.2169>, <-6.9258, 55.8887, 0.2002> }
				triangle { <-6.9148, 56.1496, 0.2674>, <-6.4497, 56.308, 0.221>, <-6.9258, 55.8887, 0.2002> }
				triangle { <-6.9148, 56.1496, 0.2674>, <-6.9258, 55.8887, 0.2002>, <-6.4497, 56.308, 0.221> }
				triangle { <-6.9148, 56.1496, 0.2674>, <-6.8212, 56.5564, 0.3575>, <-6.4497, 56.308, 0.221> }
				triangle { <-6.9148, 56.1496, 0.2674>, <-6.4497, 56.308, 0.221>, <-6.8212, 56.5564, 0.3575> }
				triangle { <-7.6006, 55.4682, 0.2169>, <-6.8212, 56.5564, 0.3575>, <-6.9148, 56.1496, 0.2674> }
				triangle { <-7.6006, 55.4682, 0.2169>, <-6.9148, 56.1496, 0.2674>, <-6.8212, 56.5564, 0.3575> }
				triangle { <-6.5402, 57.6863, -1.8932>, <-6.4357, 57.1456, -1.329>, <-6.4497, 56.308, 0.221> }
				triangle { <-6.5402, 57.6863, -1.8932>, <-6.4497, 56.308, 0.221>, <-6.4357, 57.1456, -1.329> }
				triangle { <-6.9789, 57.5624, -1.9017>, <-6.7982, 57.975, -2.1608>, <-6.5402, 57.6863, -1.8932> }
				triangle { <-6.9789, 57.5624, -1.9017>, <-6.5402, 57.6863, -1.8932>, <-6.7982, 57.975, -2.1608> }
				triangle { <-6.5402, 57.6863, -1.8932>, <-6.4497, 56.308, 0.221>, <-6.9789, 57.5624, -1.9017> }
				triangle { <-6.5402, 57.6863, -1.8932>, <-6.9789, 57.5624, -1.9017>, <-6.4497, 56.308, 0.221> }
				triangle { <-6.8212, 56.5564, 0.3575>, <-6.9789, 57.5624, -1.9017>, <-6.4497, 56.308, 0.221> }
				triangle { <-6.8212, 56.5564, 0.3575>, <-6.4497, 56.308, 0.221>, <-6.9789, 57.5624, -1.9017> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-7.6061, 55.4538, 0.2167>, <-7.6069, 55.459, 0.2158>, 0.0003609 }
				cylinder { <-7.6069, 55.459, 0.2158>, <-7.6076, 55.4641, 0.215>, 0.0003609 }
				cylinder { <-7.6076, 55.4641, 0.215>, <-7.6084, 55.4693, 0.2141>, 0.0003609 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-7.6084, 55.4693, 0.2141>, <-8.01184, 56.1542, 0.1913>, <-7.902, 56.3854, 0.1066> }
				triangle { <-7.6084, 55.4693, 0.2141>, <-7.902, 56.3854, 0.1066>, <-8.01184, 56.1542, 0.1913> }
				triangle { <-8.01184, 56.1542, 0.1913>, <-8.2403, 56.7437, 0.1346>, <-7.902, 56.3854, 0.1066> }
				triangle { <-8.01184, 56.1542, 0.1913>, <-7.902, 56.3854, 0.1066>, <-8.2403, 56.7437, 0.1346> }
				triangle { <-8.2403, 56.7437, 0.1346>, <-7.7983, 56.7823, -0.01217>, <-7.902, 56.3854, 0.1066> }
				triangle { <-8.2403, 56.7437, 0.1346>, <-7.902, 56.3854, 0.1066>, <-7.7983, 56.7823, -0.01217> }
				triangle { <-7.902, 56.3854, 0.1066>, <-7.7983, 56.7823, -0.01217>, <-7.6084, 55.4693, 0.2141> }
				triangle { <-7.902, 56.3854, 0.1066>, <-7.6084, 55.4693, 0.2141>, <-7.7983, 56.7823, -0.01217> }
				triangle { <-8.2403, 56.7437, 0.1346>, <-8.824, 56.9107, -1.5194>, <-8.8767, 57.0971, -2.2837> }
				triangle { <-8.2403, 56.7437, 0.1346>, <-8.8767, 57.0971, -2.2837>, <-8.824, 56.9107, -1.5194> }
				triangle { <-8.8767, 57.0971, -2.2837>, <-8.7288, 57.09896, -2.7305>, <-8.5778, 56.7623, -2.3644> }
				triangle { <-8.8767, 57.0971, -2.2837>, <-8.5778, 56.7623, -2.3644>, <-8.7288, 57.09896, -2.7305> }
				triangle { <-8.5778, 56.7623, -2.3644>, <-8.2403, 56.7437, 0.1346>, <-8.8767, 57.0971, -2.2837> }
				triangle { <-8.5778, 56.7623, -2.3644>, <-8.8767, 57.0971, -2.2837>, <-8.2403, 56.7437, 0.1346> }
				triangle { <-8.2403, 56.7437, 0.1346>, <-8.5778, 56.7623, -2.3644>, <-7.7983, 56.7823, -0.01217> }
				triangle { <-8.2403, 56.7437, 0.1346>, <-7.7983, 56.7823, -0.01217>, <-8.5778, 56.7623, -2.3644> }
				triangle { <-7.5838, 56.4133, 0.000981>, <-7.4107, 56.2068, -0.008275>, <-7.6084, 55.4693, 0.2141> }
				triangle { <-7.5838, 56.4133, 0.000981>, <-7.6084, 55.4693, 0.2141>, <-7.4107, 56.2068, -0.008275> }
				triangle { <-7.5838, 56.4133, 0.000981>, <-7.3563, 56.8209, -0.1589>, <-7.4107, 56.2068, -0.008275> }
				triangle { <-7.5838, 56.4133, 0.000981>, <-7.4107, 56.2068, -0.008275>, <-7.3563, 56.8209, -0.1589> }
				triangle { <-7.5838, 56.4133, 0.000981>, <-7.7983, 56.7823, -0.01217>, <-7.3563, 56.8209, -0.1589> }
				triangle { <-7.5838, 56.4133, 0.000981>, <-7.3563, 56.8209, -0.1589>, <-7.7983, 56.7823, -0.01217> }
				triangle { <-7.6084, 55.4693, 0.2141>, <-7.7983, 56.7823, -0.01217>, <-7.5838, 56.4133, 0.000981> }
				triangle { <-7.6084, 55.4693, 0.2141>, <-7.5838, 56.4133, 0.000981>, <-7.7983, 56.7823, -0.01217> }
				triangle { <-8.3463, 57.1434, -2.4598>, <-7.9047, 56.991, -1.8247>, <-7.3563, 56.8209, -0.1589> }
				triangle { <-8.3463, 57.1434, -2.4598>, <-7.3563, 56.8209, -0.1589>, <-7.9047, 56.991, -1.8247> }
				triangle { <-8.5778, 56.7623, -2.3644>, <-8.7288, 57.09896, -2.7305>, <-8.3463, 57.1434, -2.4598> }
				triangle { <-8.5778, 56.7623, -2.3644>, <-8.3463, 57.1434, -2.4598>, <-8.7288, 57.09896, -2.7305> }
				triangle { <-8.3463, 57.1434, -2.4598>, <-7.3563, 56.8209, -0.1589>, <-8.5778, 56.7623, -2.3644> }
				triangle { <-8.3463, 57.1434, -2.4598>, <-8.5778, 56.7623, -2.3644>, <-7.3563, 56.8209, -0.1589> }
				triangle { <-7.7983, 56.7823, -0.01217>, <-8.5778, 56.7623, -2.3644>, <-7.3563, 56.8209, -0.1589> }
				triangle { <-7.7983, 56.7823, -0.01217>, <-7.3563, 56.8209, -0.1589>, <-8.5778, 56.7623, -2.3644> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-6.8633, 52.7557, -0.4002>, <-7.1816, 54.61, -0.2598>, 0.343 }
		cylinder { <-7.1816, 54.61, -0.2598>, <-7.3818, 56.4847, -0.1896>, 0.343 }
		cylinder { <-7.3818, 56.4847, -0.1896>, <-7.4629, 58.3696, -0.19>, 0.343 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-7.4629, 58.3696, -0.19>, <-7.1185, 59.8142, -0.4305>, 0.1025 }
			cylinder { <-7.1185, 59.8142, -0.4305>, <-6.3997, 61.05452, -0.8869>, 0.1025 }
			cylinder { <-6.3997, 61.05452, -0.8869>, <-5.3792, 61.9653, -1.5131>, 0.1025 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-5.3792, 61.9653, -1.5131>, <-5.06725, 62.2296, -1.7041>, 0.1025 }
				cylinder { <-5.06725, 62.2296, -1.7041>, <-4.7497, 62.4849, -1.8982>, 0.1025 }
				cylinder { <-4.7497, 62.4849, -1.8982>, <-4.4267, 62.731, -2.09534>, 0.1025 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-4.4267, 62.731, -2.09534>, <-4.3248, 62.7966, -2.1189>, 0.008416 }
				cylinder { <-4.3248, 62.7966, -2.1189>, <-4.2168, 62.8558, -2.1105>, 0.008416 }
				cylinder { <-4.2168, 62.8558, -2.1105>, <-4.1104, 62.9041, -2.07076>, 0.008416 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-4.1104, 62.9041, -2.07076>, <-1.3084, 65.518, -1.8183>, <-0.2662, 65.3618, -1.05392> }
				triangle { <-4.1104, 62.9041, -2.07076>, <-0.2662, 65.3618, -1.05392>, <-1.3084, 65.518, -1.8183> }
				triangle { <-1.3084, 65.518, -1.8183>, <1.1493, 67.2662, -1.2733>, <-0.2662, 65.3618, -1.05392> }
				triangle { <-1.3084, 65.518, -1.8183>, <-0.2662, 65.3618, -1.05392>, <1.1493, 67.2662, -1.2733> }
				triangle { <1.1493, 67.2662, -1.2733>, <1.4894, 65.4516, 0.02425>, <-0.2662, 65.3618, -1.05392> }
				triangle { <1.1493, 67.2662, -1.2733>, <-0.2662, 65.3618, -1.05392>, <1.4894, 65.4516, 0.02425> }
				triangle { <-0.2662, 65.3618, -1.05392>, <1.4894, 65.4516, 0.02425>, <-4.1104, 62.9041, -2.07076> }
				triangle { <-0.2662, 65.3618, -1.05392>, <-4.1104, 62.9041, -2.07076>, <1.4894, 65.4516, 0.02425> }
				triangle { <1.1493, 67.2662, -1.2733>, <7.2504, 64.699, -6.6192>, <10.3407, 63.00959, -8.06501> }
				triangle { <1.1493, 67.2662, -1.2733>, <10.3407, 63.00959, -8.06501>, <7.2504, 64.699, -6.6192> }
				triangle { <10.3407, 63.00959, -8.06501>, <11.6529, 61.2201, -8.5566>, <9.1982, 61.1275, -8.04293> }
				triangle { <10.3407, 63.00959, -8.06501>, <9.1982, 61.1275, -8.04293>, <11.6529, 61.2201, -8.5566> }
				triangle { <9.1982, 61.1275, -8.04293>, <1.1493, 67.2662, -1.2733>, <10.3407, 63.00959, -8.06501> }
				triangle { <9.1982, 61.1275, -8.04293>, <10.3407, 63.00959, -8.06501>, <1.1493, 67.2662, -1.2733> }
				triangle { <1.1493, 67.2662, -1.2733>, <9.1982, 61.1275, -8.04293>, <1.4894, 65.4516, 0.02425> }
				triangle { <1.1493, 67.2662, -1.2733>, <1.4894, 65.4516, 0.02425>, <9.1982, 61.1275, -8.04293> }
				triangle { <-0.02146, 64.05535, -0.1196>, <-0.8459, 63.0501, -0.05359>, <-4.1104, 62.9041, -2.07076> }
				triangle { <-0.02146, 64.05535, -0.1196>, <-4.1104, 62.9041, -2.07076>, <-0.8459, 63.0501, -0.05359> }
				triangle { <-0.02146, 64.05535, -0.1196>, <1.8294, 63.6369, 1.3218>, <-0.8459, 63.0501, -0.05359> }
				triangle { <-0.02146, 64.05535, -0.1196>, <-0.8459, 63.0501, -0.05359>, <1.8294, 63.6369, 1.3218> }
				triangle { <-0.02146, 64.05535, -0.1196>, <1.4894, 65.4516, 0.02425>, <1.8294, 63.6369, 1.3218> }
				triangle { <-0.02146, 64.05535, -0.1196>, <1.8294, 63.6369, 1.3218>, <1.4894, 65.4516, 0.02425> }
				triangle { <-4.1104, 62.9041, -2.07076>, <1.4894, 65.4516, 0.02425>, <-0.02146, 64.05535, -0.1196> }
				triangle { <-4.1104, 62.9041, -2.07076>, <-0.02146, 64.05535, -0.1196>, <1.4894, 65.4516, 0.02425> }
				triangle { <10.7487, 60.832, -6.5079>, <7.9576, 60.9246, -3.9202>, <1.8294, 63.6369, 1.3218> }
				triangle { <10.7487, 60.832, -6.5079>, <1.8294, 63.6369, 1.3218>, <7.9576, 60.9246, -3.9202> }
				triangle { <9.1982, 61.1275, -8.04293>, <11.6529, 61.2201, -8.5566>, <10.7487, 60.832, -6.5079> }
				triangle { <9.1982, 61.1275, -8.04293>, <10.7487, 60.832, -6.5079>, <11.6529, 61.2201, -8.5566> }
				triangle { <10.7487, 60.832, -6.5079>, <1.8294, 63.6369, 1.3218>, <9.1982, 61.1275, -8.04293> }
				triangle { <10.7487, 60.832, -6.5079>, <9.1982, 61.1275, -8.04293>, <1.8294, 63.6369, 1.3218> }
				triangle { <1.4894, 65.4516, 0.02425>, <9.1982, 61.1275, -8.04293>, <1.8294, 63.6369, 1.3218> }
				triangle { <1.4894, 65.4516, 0.02425>, <1.8294, 63.6369, 1.3218>, <9.1982, 61.1275, -8.04293> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-4.4267, 62.731, -2.09534>, <-4.09859, 62.9678, -2.2952>, 0.1025 }
				cylinder { <-4.09859, 62.9678, -2.2952>, <-3.7654, 63.195, -2.4978>, 0.1025 }
				cylinder { <-3.7654, 63.195, -2.4978>, <-3.4274, 63.4126, -2.703>, 0.1025 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-3.4274, 63.4126, -2.703>, <-3.355, 63.4692, -2.7855>, 0.008416 }
				cylinder { <-3.355, 63.4692, -2.7855>, <-3.308, 63.5189, -2.8882>, 0.008416 }
				cylinder { <-3.308, 63.5189, -2.8882>, <-3.2897, 63.5579, -3.00396>, 0.008416 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-3.2897, 63.5579, -3.00396>, <-4.2574, 65.02348, -6.419>, <-3.3962, 65.2008, -7.379> }
				triangle { <-3.2897, 63.5579, -3.00396>, <-3.3962, 65.2008, -7.379>, <-4.2574, 65.02348, -6.419> }
				triangle { <-4.2574, 65.02348, -6.419>, <-4.5169, 66.1315, -9.2649>, <-3.3962, 65.2008, -7.379> }
				triangle { <-4.2574, 65.02348, -6.419>, <-3.3962, 65.2008, -7.379>, <-4.5169, 66.1315, -9.2649> }
				triangle { <-4.5169, 66.1315, -9.2649>, <-2.327, 65.6147, -9.09332>, <-3.3962, 65.2008, -7.379> }
				triangle { <-4.5169, 66.1315, -9.2649>, <-3.3962, 65.2008, -7.379>, <-2.327, 65.6147, -9.09332> }
				triangle { <-3.3962, 65.2008, -7.379>, <-2.327, 65.6147, -9.09332>, <-3.2897, 63.5579, -3.00396> }
				triangle { <-3.3962, 65.2008, -7.379>, <-3.2897, 63.5579, -3.00396>, <-2.327, 65.6147, -9.09332> }
				triangle { <-4.5169, 66.1315, -9.2649>, <-5.7778, 59.4737, -14.4104>, <-5.2232, 56.6575, -16.9116> }
				triangle { <-4.5169, 66.1315, -9.2649>, <-5.2232, 56.6575, -16.9116>, <-5.7778, 59.4737, -14.4104> }
				triangle { <-5.2232, 56.6575, -16.9116>, <-4.2131, 54.7713, -17.678>, <-4.2149, 55.5554, -15.2941> }
				triangle { <-5.2232, 56.6575, -16.9116>, <-4.2149, 55.5554, -15.2941>, <-4.2131, 54.7713, -17.678> }
				triangle { <-4.2149, 55.5554, -15.2941>, <-4.5169, 66.1315, -9.2649>, <-5.2232, 56.6575, -16.9116> }
				triangle { <-4.2149, 55.5554, -15.2941>, <-5.2232, 56.6575, -16.9116>, <-4.5169, 66.1315, -9.2649> }
				triangle { <-4.5169, 66.1315, -9.2649>, <-4.2149, 55.5554, -15.2941>, <-2.327, 65.6147, -9.09332> }
				triangle { <-4.5169, 66.1315, -9.2649>, <-2.327, 65.6147, -9.09332>, <-4.2149, 55.5554, -15.2941> }
				triangle { <-1.8194, 64.8287, -7.2554>, <-1.2791, 64.3206, -6.1856>, <-3.2897, 63.5579, -3.00396> }
				triangle { <-1.8194, 64.8287, -7.2554>, <-3.2897, 63.5579, -3.00396>, <-1.2791, 64.3206, -6.1856> }
				triangle { <-1.8194, 64.8287, -7.2554>, <-0.1371, 65.09789, -8.9216>, <-1.2791, 64.3206, -6.1856> }
				triangle { <-1.8194, 64.8287, -7.2554>, <-1.2791, 64.3206, -6.1856>, <-0.1371, 65.09789, -8.9216> }
				triangle { <-1.8194, 64.8287, -7.2554>, <-2.327, 65.6147, -9.09332>, <-0.1371, 65.09789, -8.9216> }
				triangle { <-1.8194, 64.8287, -7.2554>, <-0.1371, 65.09789, -8.9216>, <-2.327, 65.6147, -9.09332> }
				triangle { <-3.2897, 63.5579, -3.00396>, <-2.327, 65.6147, -9.09332>, <-1.8194, 64.8287, -7.2554> }
				triangle { <-3.2897, 63.5579, -3.00396>, <-1.8194, 64.8287, -7.2554>, <-2.327, 65.6147, -9.09332> }
				triangle { <-2.5953, 56.03738, -16.7056>, <-1.2228, 58.3987, -14.0534>, <-0.1371, 65.09789, -8.9216> }
				triangle { <-2.5953, 56.03738, -16.7056>, <-0.1371, 65.09789, -8.9216>, <-1.2228, 58.3987, -14.0534> }
				triangle { <-4.2149, 55.5554, -15.2941>, <-4.2131, 54.7713, -17.678>, <-2.5953, 56.03738, -16.7056> }
				triangle { <-4.2149, 55.5554, -15.2941>, <-2.5953, 56.03738, -16.7056>, <-4.2131, 54.7713, -17.678> }
				triangle { <-2.5953, 56.03738, -16.7056>, <-0.1371, 65.09789, -8.9216>, <-4.2149, 55.5554, -15.2941> }
				triangle { <-2.5953, 56.03738, -16.7056>, <-4.2149, 55.5554, -15.2941>, <-0.1371, 65.09789, -8.9216> }
				triangle { <-2.327, 65.6147, -9.09332>, <-4.2149, 55.5554, -15.2941>, <-0.1371, 65.09789, -8.9216> }
				triangle { <-2.327, 65.6147, -9.09332>, <-0.1371, 65.09789, -8.9216>, <-4.2149, 55.5554, -15.2941> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-3.4274, 63.4126, -2.703>, <-3.08947, 63.6302, -2.9082>, 0.1025 }
				cylinder { <-3.08947, 63.6302, -2.9082>, <-2.7514, 63.8478, -3.1134>, 0.1025 }
				cylinder { <-2.7514, 63.8478, -3.1134>, <-2.4135, 64.06544, -3.3187>, 0.1025 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-2.4135, 64.06544, -3.3187>, <-2.3076, 64.1235, -3.3444>, 0.008416 }
				cylinder { <-2.3076, 64.1235, -3.3444>, <-2.1961, 64.1759, -3.3379>, 0.008416 }
				cylinder { <-2.1961, 64.1759, -3.3379>, <-2.08691, 64.2189, -3.2997>, 0.008416 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-2.08691, 64.2189, -3.2997>, <0.8749, 66.6578, -3.1372>, <1.9048, 66.4648, -2.3645> }
				triangle { <-2.08691, 64.2189, -3.2997>, <1.9048, 66.4648, -2.3645>, <0.8749, 66.6578, -3.1372> }
				triangle { <0.8749, 66.6578, -3.1372>, <3.4383, 68.2661, -2.651>, <1.9048, 66.4648, -2.3645> }
				triangle { <0.8749, 66.6578, -3.1372>, <1.9048, 66.4648, -2.3645>, <3.4383, 68.2661, -2.651> }
				triangle { <3.4383, 68.2661, -2.651>, <3.6622, 66.4835, -1.2855>, <1.9048, 66.4648, -2.3645> }
				triangle { <3.4383, 68.2661, -2.651>, <1.9048, 66.4648, -2.3645>, <3.6622, 66.4835, -1.2855> }
				triangle { <1.9048, 66.4648, -2.3645>, <3.6622, 66.4835, -1.2855>, <-2.08691, 64.2189, -3.2997> }
				triangle { <1.9048, 66.4648, -2.3645>, <-2.08691, 64.2189, -3.2997>, <3.6622, 66.4835, -1.2855> }
				triangle { <3.4383, 68.2661, -2.651>, <9.3668, 65.1195, -7.8801>, <12.3445, 63.1849, -9.253> }
				triangle { <3.4383, 68.2661, -2.651>, <12.3445, 63.1849, -9.253>, <9.3668, 65.1195, -7.8801> }
				triangle { <12.3445, 63.1849, -9.253>, <13.5409, 61.2988, -9.6738>, <11.08511, 61.3811, -9.1639> }
				triangle { <12.3445, 63.1849, -9.253>, <11.08511, 61.3811, -9.1639>, <13.5409, 61.2988, -9.6738> }
				triangle { <11.08511, 61.3811, -9.1639>, <3.4383, 68.2661, -2.651>, <12.3445, 63.1849, -9.253> }
				triangle { <11.08511, 61.3811, -9.1639>, <12.3445, 63.1849, -9.253>, <3.4383, 68.2661, -2.651> }
				triangle { <3.4383, 68.2661, -2.651>, <11.08511, 61.3811, -9.1639>, <3.6622, 66.4835, -1.2855> }
				triangle { <3.4383, 68.2661, -2.651>, <3.6622, 66.4835, -1.2855>, <11.08511, 61.3811, -9.1639> }
				triangle { <2.06595, 65.1813, -1.3814>, <1.1793, 64.2334, -1.2802>, <-2.08691, 64.2189, -3.2997> }
				triangle { <2.06595, 65.1813, -1.3814>, <-2.08691, 64.2189, -3.2997>, <1.1793, 64.2334, -1.2802> }
				triangle { <2.06595, 65.1813, -1.3814>, <3.886, 64.7009, 0.07982>, <1.1793, 64.2334, -1.2802> }
				triangle { <2.06595, 65.1813, -1.3814>, <1.1793, 64.2334, -1.2802>, <3.886, 64.7009, 0.07982> }
				triangle { <2.06595, 65.1813, -1.3814>, <3.6622, 66.4835, -1.2855>, <3.886, 64.7009, 0.07982> }
				triangle { <2.06595, 65.1813, -1.3814>, <3.886, 64.7009, 0.07982>, <3.6622, 66.4835, -1.2855> }
				triangle { <-2.08691, 64.2189, -3.2997>, <3.6622, 66.4835, -1.2855>, <2.06595, 65.1813, -1.3814> }
				triangle { <-2.08691, 64.2189, -3.2997>, <2.06595, 65.1813, -1.3814>, <3.6622, 66.4835, -1.2855> }
				triangle { <12.6131, 61.04574, -7.6145>, <9.8324, 61.4116, -5.04005>, <3.886, 64.7009, 0.07982> }
				triangle { <12.6131, 61.04574, -7.6145>, <3.886, 64.7009, 0.07982>, <9.8324, 61.4116, -5.04005> }
				triangle { <11.08511, 61.3811, -9.1639>, <13.5409, 61.2988, -9.6738>, <12.6131, 61.04574, -7.6145> }
				triangle { <11.08511, 61.3811, -9.1639>, <12.6131, 61.04574, -7.6145>, <13.5409, 61.2988, -9.6738> }
				triangle { <12.6131, 61.04574, -7.6145>, <3.886, 64.7009, 0.07982>, <11.08511, 61.3811, -9.1639> }
				triangle { <12.6131, 61.04574, -7.6145>, <11.08511, 61.3811, -9.1639>, <3.886, 64.7009, 0.07982> }
				triangle { <3.6622, 66.4835, -1.2855>, <11.08511, 61.3811, -9.1639>, <3.886, 64.7009, 0.07982> }
				triangle { <3.6622, 66.4835, -1.2855>, <3.886, 64.7009, 0.07982>, <11.08511, 61.3811, -9.1639> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-2.4135, 64.06544, -3.3187>, <-2.321, 64.1249, -3.3748>, 0.008416 }
				cylinder { <-2.321, 64.1249, -3.3748>, <-2.2286, 64.1844, -3.4309>, 0.008416 }
				cylinder { <-2.2286, 64.1844, -3.4309>, <-2.1361, 64.2439, -3.4871>, 0.008416 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-2.1361, 64.2439, -3.4871>, <-0.5151, 66.7146, -5.9397>, <0.7737, 66.8729, -6.0313> }
				triangle { <-2.1361, 64.2439, -3.4871>, <0.7737, 66.8729, -6.0313>, <-0.5151, 66.7146, -5.9397> }
				triangle { <-0.5151, 66.7146, -5.9397>, <1.2377, 68.5147, -7.695>, <0.7737, 66.8729, -6.0313> }
				triangle { <-0.5151, 66.7146, -5.9397>, <0.7737, 66.8729, -6.0313>, <1.2377, 68.5147, -7.695> }
				triangle { <1.2377, 68.5147, -7.695>, <2.7307, 67.3774, -6.4421>, <0.7737, 66.8729, -6.0313> }
				triangle { <1.2377, 68.5147, -7.695>, <0.7737, 66.8729, -6.0313>, <2.7307, 67.3774, -6.4421> }
				triangle { <0.7737, 66.8729, -6.0313>, <2.7307, 67.3774, -6.4421>, <-2.1361, 64.2439, -3.4871> }
				triangle { <0.7737, 66.8729, -6.0313>, <-2.1361, 64.2439, -3.4871>, <2.7307, 67.3774, -6.4421> }
				triangle { <1.2377, 68.5147, -7.695>, <3.3837, 63.9571, -14.5518>, <5.3185, 61.8032, -17.02407> }
				triangle { <1.2377, 68.5147, -7.695>, <5.3185, 61.8032, -17.02407>, <3.3837, 63.9571, -14.5518> }
				triangle { <5.3185, 61.8032, -17.02407>, <6.4866, 59.9577, -17.6526>, <4.9404, 60.09996, -15.6811> }
				triangle { <5.3185, 61.8032, -17.02407>, <4.9404, 60.09996, -15.6811>, <6.4866, 59.9577, -17.6526> }
				triangle { <4.9404, 60.09996, -15.6811>, <1.2377, 68.5147, -7.695>, <5.3185, 61.8032, -17.02407> }
				triangle { <4.9404, 60.09996, -15.6811>, <5.3185, 61.8032, -17.02407>, <1.2377, 68.5147, -7.695> }
				triangle { <1.2377, 68.5147, -7.695>, <4.9404, 60.09996, -15.6811>, <2.7307, 67.3774, -6.4421> }
				triangle { <1.2377, 68.5147, -7.695>, <2.7307, 67.3774, -6.4421>, <4.9404, 60.09996, -15.6811> }
				triangle { <1.8486, 66.05408, -5.1292>, <1.5152, 65.1679, -4.2357>, <-2.1361, 64.2439, -3.4871> }
				triangle { <1.8486, 66.05408, -5.1292>, <-2.1361, 64.2439, -3.4871>, <1.5152, 65.1679, -4.2357> }
				triangle { <1.8486, 66.05408, -5.1292>, <4.2236, 66.2401, -5.1892>, <1.5152, 65.1679, -4.2357> }
				triangle { <1.8486, 66.05408, -5.1292>, <1.5152, 65.1679, -4.2357>, <4.2236, 66.2401, -5.1892> }
				triangle { <1.8486, 66.05408, -5.1292>, <2.7307, 67.3774, -6.4421>, <4.2236, 66.2401, -5.1892> }
				triangle { <1.8486, 66.05408, -5.1292>, <4.2236, 66.2401, -5.1892>, <2.7307, 67.3774, -6.4421> }
				triangle { <-2.1361, 64.2439, -3.4871>, <2.7307, 67.3774, -6.4421>, <1.8486, 66.05408, -5.1292> }
				triangle { <-2.1361, 64.2439, -3.4871>, <1.8486, 66.05408, -5.1292>, <2.7307, 67.3774, -6.4421> }
				triangle { <7.11, 60.4385, -15.5205>, <6.4891, 61.5915, -11.9457>, <4.2236, 66.2401, -5.1892> }
				triangle { <7.11, 60.4385, -15.5205>, <4.2236, 66.2401, -5.1892>, <6.4891, 61.5915, -11.9457> }
				triangle { <4.9404, 60.09996, -15.6811>, <6.4866, 59.9577, -17.6526>, <7.11, 60.4385, -15.5205> }
				triangle { <4.9404, 60.09996, -15.6811>, <7.11, 60.4385, -15.5205>, <6.4866, 59.9577, -17.6526> }
				triangle { <7.11, 60.4385, -15.5205>, <4.2236, 66.2401, -5.1892>, <4.9404, 60.09996, -15.6811> }
				triangle { <7.11, 60.4385, -15.5205>, <4.9404, 60.09996, -15.6811>, <4.2236, 66.2401, -5.1892> }
				triangle { <2.7307, 67.3774, -6.4421>, <4.9404, 60.09996, -15.6811>, <4.2236, 66.2401, -5.1892> }
				triangle { <2.7307, 67.3774, -6.4421>, <4.2236, 66.2401, -5.1892>, <4.9404, 60.09996, -15.6811> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-7.4629, 58.3696, -0.19>, <-7.9302, 59.7794, 0.04973>, 0.1025 }
			cylinder { <-7.9302, 59.7794, 0.04973>, <-8.7529, 60.9536, 0.5055>, 0.1025 }
			cylinder { <-8.7529, 60.9536, 0.5055>, <-9.8479, 61.7736, 1.1312>, 0.1025 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-9.8479, 61.7736, 1.1312>, <-10.1814, 62.01035, 1.3222>, 0.1025 }
				cylinder { <-10.1814, 62.01035, 1.3222>, <-10.5197, 62.2375, 1.5162>, 0.1025 }
				cylinder { <-10.5197, 62.2375, 1.5162>, <-10.8626, 62.455, 1.7131>, 0.1025 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-10.8626, 62.455, 1.7131>, <-10.9698, 62.5116, 1.7367>, 0.008416 }
				cylinder { <-10.9698, 62.5116, 1.7367>, <-11.08252, 62.5613, 1.7283>, 0.008416 }
				cylinder { <-11.08252, 62.5613, 1.7283>, <-11.1926, 62.6003, 1.6885>, 0.008416 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-11.1926, 62.6003, 1.6885>, <-14.2088, 64.9637, 1.4349>, <-15.2337, 64.7183, 0.6706> }
				triangle { <-11.1926, 62.6003, 1.6885>, <-15.2337, 64.7183, 0.6706>, <-14.2088, 64.9637, 1.4349> }
				triangle { <-14.2088, 64.9637, 1.4349>, <-16.8077, 66.4941, 0.8891>, <-15.2337, 64.7183, 0.6706> }
				triangle { <-14.2088, 64.9637, 1.4349>, <-15.2337, 64.7183, 0.6706>, <-16.8077, 66.4941, 0.8891> }
				triangle { <-16.8077, 66.4941, 0.8891>, <-16.9906, 64.6564, -0.4075>, <-15.2337, 64.7183, 0.6706> }
				triangle { <-16.8077, 66.4941, 0.8891>, <-15.2337, 64.7183, 0.6706>, <-16.9906, 64.6564, -0.4075> }
				triangle { <-15.2337, 64.7183, 0.6706>, <-16.9906, 64.6564, -0.4075>, <-11.1926, 62.6003, 1.6885> }
				triangle { <-15.2337, 64.7183, 0.6706>, <-11.1926, 62.6003, 1.6885>, <-16.9906, 64.6564, -0.4075> }
				triangle { <-16.8077, 66.4941, 0.8891>, <-22.6658, 63.4149, 6.2363>, <-25.5996, 61.4669, 7.683> }
				triangle { <-16.8077, 66.4941, 0.8891>, <-25.5996, 61.4669, 7.683>, <-22.6658, 63.4149, 6.2363> }
				triangle { <-25.5996, 61.4669, 7.683>, <-26.7533, 59.5716, 8.1755>, <-24.2996, 59.6899, 7.6617> }
				triangle { <-25.5996, 61.4669, 7.683>, <-24.2996, 59.6899, 7.6617>, <-26.7533, 59.5716, 8.1755> }
				triangle { <-24.2996, 59.6899, 7.6617>, <-16.8077, 66.4941, 0.8891>, <-25.5996, 61.4669, 7.683> }
				triangle { <-24.2996, 59.6899, 7.6617>, <-25.5996, 61.4669, 7.683>, <-16.8077, 66.4941, 0.8891> }
				triangle { <-16.8077, 66.4941, 0.8891>, <-24.2996, 59.6899, 7.6617>, <-16.9906, 64.6564, -0.4075> }
				triangle { <-16.8077, 66.4941, 0.8891>, <-16.9906, 64.6564, -0.4075>, <-24.2996, 59.6899, 7.6617> }
				triangle { <-15.3653, 63.3951, -0.263>, <-14.4575, 62.4643, -0.3286>, <-11.1926, 62.6003, 1.6885> }
				triangle { <-15.3653, 63.3951, -0.263>, <-11.1926, 62.6003, 1.6885>, <-14.4575, 62.4643, -0.3286> }
				triangle { <-15.3653, 63.3951, -0.263>, <-17.1735, 62.8186, -1.7043>, <-14.4575, 62.4643, -0.3286> }
				triangle { <-15.3653, 63.3951, -0.263>, <-14.4575, 62.4643, -0.3286>, <-17.1735, 62.8186, -1.7043> }
				triangle { <-15.3653, 63.3951, -0.263>, <-16.9906, 64.6564, -0.4075>, <-17.1735, 62.8186, -1.7043> }
				triangle { <-15.3653, 63.3951, -0.263>, <-17.1735, 62.8186, -1.7043>, <-16.9906, 64.6564, -0.4075> }
				triangle { <-11.1926, 62.6003, 1.6885>, <-16.9906, 64.6564, -0.4075>, <-15.3653, 63.3951, -0.263> }
				triangle { <-11.1926, 62.6003, 1.6885>, <-15.3653, 63.3951, -0.263>, <-16.9906, 64.6564, -0.4075> }
				triangle { <-25.819, 59.2616, 6.1269>, <-23.04623, 59.5924, 3.5391>, <-17.1735, 62.8186, -1.7043> }
				triangle { <-25.819, 59.2616, 6.1269>, <-17.1735, 62.8186, -1.7043>, <-23.04623, 59.5924, 3.5391> }
				triangle { <-24.2996, 59.6899, 7.6617>, <-26.7533, 59.5716, 8.1755>, <-25.819, 59.2616, 6.1269> }
				triangle { <-24.2996, 59.6899, 7.6617>, <-25.819, 59.2616, 6.1269>, <-26.7533, 59.5716, 8.1755> }
				triangle { <-25.819, 59.2616, 6.1269>, <-17.1735, 62.8186, -1.7043>, <-24.2996, 59.6899, 7.6617> }
				triangle { <-25.819, 59.2616, 6.1269>, <-24.2996, 59.6899, 7.6617>, <-17.1735, 62.8186, -1.7043> }
				triangle { <-16.9906, 64.6564, -0.4075>, <-24.2996, 59.6899, 7.6617>, <-17.1735, 62.8186, -1.7043> }
				triangle { <-16.9906, 64.6564, -0.4075>, <-17.1735, 62.8186, -1.7043>, <-24.2996, 59.6899, 7.6617> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-10.8626, 62.455, 1.7131>, <-11.2099, 62.6628, 1.9129>, 0.1025 }
				cylinder { <-11.2099, 62.6628, 1.9129>, <-11.5614, 62.8606, 2.1154>, 0.1025 }
				cylinder { <-11.5614, 62.8606, 2.1154>, <-11.9168, 63.04855, 2.3206>, 0.1025 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-11.9168, 63.04855, 2.3206>, <-11.9937, 63.0988, 2.403>, 0.008416 }
				cylinder { <-11.9937, 63.0988, 2.403>, <-12.04491, 63.1442, 2.5057>, 0.008416 }
				cylinder { <-12.04491, 63.1442, 2.5057>, <-12.06649, 63.1816, 2.6214>, 0.008416 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-12.06649, 63.1816, 2.6214>, <-11.2283, 64.7264, 6.03585>, <-12.1016, 64.8297, 6.9957> }
				triangle { <-12.06649, 63.1816, 2.6214>, <-12.1016, 64.8297, 6.9957>, <-11.2283, 64.7264, 6.03585> }
				triangle { <-11.2283, 64.7264, 6.03585>, <-11.06499, 65.854, 8.8812>, <-12.1016, 64.8297, 6.9957> }
				triangle { <-11.2283, 64.7264, 6.03585>, <-12.1016, 64.8297, 6.9957>, <-11.06499, 65.854, 8.8812> }
				triangle { <-11.06499, 65.854, 8.8812>, <-13.2024, 65.1509, 8.7098>, <-12.1016, 64.8297, 6.9957> }
				triangle { <-11.06499, 65.854, 8.8812>, <-12.1016, 64.8297, 6.9957>, <-13.2024, 65.1509, 8.7098> }
				triangle { <-12.1016, 64.8297, 6.9957>, <-13.2024, 65.1509, 8.7098>, <-12.06649, 63.1816, 2.6214> }
				triangle { <-12.1016, 64.8297, 6.9957>, <-12.06649, 63.1816, 2.6214>, <-13.2024, 65.1509, 8.7098> }
				triangle { <-11.06499, 65.854, 8.8812>, <-9.237, 59.3315, 14.02978>, <-9.5477, 56.4793, 16.5323> }
				triangle { <-11.06499, 65.854, 8.8812>, <-9.5477, 56.4793, 16.5323>, <-9.237, 59.3315, 14.02978> }
				triangle { <-9.5477, 56.4793, 16.5323>, <-10.3921, 54.5136, 17.2996>, <-10.4575, 55.2939, 14.9153> }
				triangle { <-9.5477, 56.4793, 16.5323>, <-10.4575, 55.2939, 14.9153>, <-10.3921, 54.5136, 17.2996> }
				triangle { <-10.4575, 55.2939, 14.9153>, <-11.06499, 65.854, 8.8812>, <-9.5477, 56.4793, 16.5323> }
				triangle { <-10.4575, 55.2939, 14.9153>, <-9.5477, 56.4793, 16.5323>, <-11.06499, 65.854, 8.8812> }
				triangle { <-11.06499, 65.854, 8.8812>, <-10.4575, 55.2939, 14.9153>, <-13.2024, 65.1509, 8.7098> }
				triangle { <-11.06499, 65.854, 8.8812>, <-13.2024, 65.1509, 8.7098>, <-10.4575, 55.2939, 14.9153> }
				triangle { <-13.6405, 64.3234, 6.8723>, <-14.1352, 63.7702, 5.8027>, <-12.06649, 63.1816, 2.6214> }
				triangle { <-13.6405, 64.3234, 6.8723>, <-12.06649, 63.1816, 2.6214>, <-14.1352, 63.7702, 5.8027> }
				triangle { <-13.6405, 64.3234, 6.8723>, <-15.3398, 64.4478, 8.5384>, <-14.1352, 63.7702, 5.8027> }
				triangle { <-13.6405, 64.3234, 6.8723>, <-14.1352, 63.7702, 5.8027>, <-15.3398, 64.4478, 8.5384> }
				triangle { <-13.6405, 64.3234, 6.8723>, <-13.2024, 65.1509, 8.7098>, <-15.3398, 64.4478, 8.5384> }
				triangle { <-13.6405, 64.3234, 6.8723>, <-15.3398, 64.4478, 8.5384>, <-13.2024, 65.1509, 8.7098> }
				triangle { <-12.06649, 63.1816, 2.6214>, <-13.2024, 65.1509, 8.7098>, <-13.6405, 64.3234, 6.8723> }
				triangle { <-12.06649, 63.1816, 2.6214>, <-13.6405, 64.3234, 6.8723>, <-13.2024, 65.1509, 8.7098> }
				triangle { <-12.1126, 55.6356, 16.3266>, <-13.6828, 57.8691, 13.6733>, <-15.3398, 64.4478, 8.5384> }
				triangle { <-12.1126, 55.6356, 16.3266>, <-15.3398, 64.4478, 8.5384>, <-13.6828, 57.8691, 13.6733> }
				triangle { <-10.4575, 55.2939, 14.9153>, <-10.3921, 54.5136, 17.2996>, <-12.1126, 55.6356, 16.3266> }
				triangle { <-10.4575, 55.2939, 14.9153>, <-12.1126, 55.6356, 16.3266>, <-10.3921, 54.5136, 17.2996> }
				triangle { <-12.1126, 55.6356, 16.3266>, <-15.3398, 64.4478, 8.5384>, <-10.4575, 55.2939, 14.9153> }
				triangle { <-12.1126, 55.6356, 16.3266>, <-10.4575, 55.2939, 14.9153>, <-15.3398, 64.4478, 8.5384> }
				triangle { <-13.2024, 65.1509, 8.7098>, <-10.4575, 55.2939, 14.9153>, <-15.3398, 64.4478, 8.5384> }
				triangle { <-13.2024, 65.1509, 8.7098>, <-15.3398, 64.4478, 8.5384>, <-10.4575, 55.2939, 14.9153> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-11.9168, 63.04855, 2.3206>, <-12.2722, 63.2364, 2.5257>, 0.1025 }
				cylinder { <-12.2722, 63.2364, 2.5257>, <-12.6276, 63.4242, 2.7308>, 0.1025 }
				cylinder { <-12.6276, 63.4242, 2.7308>, <-12.9831, 63.6121, 2.9359>, 0.1025 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-12.9831, 63.6121, 2.9359>, <-13.09354, 63.6609, 2.9616>, 0.008416 }
				cylinder { <-13.09354, 63.6609, 2.9616>, <-13.2092, 63.7036, 2.9551>, 0.008416 }
				cylinder { <-13.2092, 63.7036, 2.9551>, <-13.3216, 63.737, 2.9168>, 0.008416 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-13.3216, 63.737, 2.9168>, <-16.4821, 65.9124, 2.7533>, <-17.4915, 65.6312, 1.9807> }
				triangle { <-13.3216, 63.737, 2.9168>, <-17.4915, 65.6312, 1.9807>, <-16.4821, 65.9124, 2.7533> }
				triangle { <-16.4821, 65.9124, 2.7533>, <-19.1741, 67.2944, 2.2663>, <-17.4915, 65.6312, 1.9807> }
				triangle { <-16.4821, 65.9124, 2.7533>, <-17.4915, 65.6312, 1.9807>, <-19.1741, 67.2944, 2.2663> }
				triangle { <-19.1741, 67.2944, 2.2663>, <-19.244, 65.4985, 0.9018>, <-17.4915, 65.6312, 1.9807> }
				triangle { <-19.1741, 67.2944, 2.2663>, <-17.4915, 65.6312, 1.9807>, <-19.244, 65.4985, 0.9018> }
				triangle { <-17.4915, 65.6312, 1.9807>, <-19.244, 65.4985, 0.9018>, <-13.3216, 63.737, 2.9168> }
				triangle { <-17.4915, 65.6312, 1.9807>, <-13.3216, 63.737, 2.9168>, <-19.244, 65.4985, 0.9018> }
				triangle { <-19.1741, 67.2944, 2.2663>, <-24.8105, 63.6526, 7.4971>, <-27.6111, 61.47, 8.871> }
				triangle { <-19.1741, 67.2944, 2.2663>, <-27.6111, 61.47, 8.871>, <-24.8105, 63.6526, 7.4971> }
				triangle { <-27.6111, 61.47, 8.871>, <-28.6411, 59.4884, 9.2927>, <-26.2014, 59.781, 8.7827> }
				triangle { <-27.6111, 61.47, 8.871>, <-26.2014, 59.781, 8.7827>, <-28.6411, 59.4884, 9.2927> }
				triangle { <-26.2014, 59.781, 8.7827>, <-19.1741, 67.2944, 2.2663>, <-27.6111, 61.47, 8.871> }
				triangle { <-26.2014, 59.781, 8.7827>, <-27.6111, 61.47, 8.871>, <-19.1741, 67.2944, 2.2663> }
				triangle { <-19.1741, 67.2944, 2.2663>, <-26.2014, 59.781, 8.7827>, <-19.244, 65.4985, 0.9018> }
				triangle { <-19.1741, 67.2944, 2.2663>, <-19.244, 65.4985, 0.9018>, <-26.2014, 59.781, 8.7827> }
				triangle { <-17.5418, 64.3382, 0.9983>, <-16.5771, 63.4699, 0.8974>, <-13.3216, 63.737, 2.9168> }
				triangle { <-17.5418, 64.3382, 0.9983>, <-13.3216, 63.737, 2.9168>, <-16.5771, 63.4699, 0.8974> }
				triangle { <-17.5418, 64.3382, 0.9983>, <-19.3138, 63.7025, -0.4627>, <-16.5771, 63.4699, 0.8974> }
				triangle { <-17.5418, 64.3382, 0.9983>, <-16.5771, 63.4699, 0.8974>, <-19.3138, 63.7025, -0.4627> }
				triangle { <-17.5418, 64.3382, 0.9983>, <-19.244, 65.4985, 0.9018>, <-19.3138, 63.7025, -0.4627> }
				triangle { <-17.5418, 64.3382, 0.9983>, <-19.3138, 63.7025, -0.4627>, <-19.244, 65.4985, 0.9018> }
				triangle { <-13.3216, 63.737, 2.9168>, <-19.244, 65.4985, 0.9018>, <-17.5418, 64.3382, 0.9983> }
				triangle { <-13.3216, 63.737, 2.9168>, <-17.5418, 64.3382, 0.9983>, <-19.244, 65.4985, 0.9018> }
				triangle { <-27.6949, 59.3149, 7.2335>, <-24.9558, 59.9171, 4.6587>, <-19.3138, 63.7025, -0.4627> }
				triangle { <-27.6949, 59.3149, 7.2335>, <-19.3138, 63.7025, -0.4627>, <-24.9558, 59.9171, 4.6587> }
				triangle { <-26.2014, 59.781, 8.7827>, <-28.6411, 59.4884, 9.2927>, <-27.6949, 59.3149, 7.2335> }
				triangle { <-26.2014, 59.781, 8.7827>, <-27.6949, 59.3149, 7.2335>, <-28.6411, 59.4884, 9.2927> }
				triangle { <-27.6949, 59.3149, 7.2335>, <-19.3138, 63.7025, -0.4627>, <-26.2014, 59.781, 8.7827> }
				triangle { <-27.6949, 59.3149, 7.2335>, <-26.2014, 59.781, 8.7827>, <-19.3138, 63.7025, -0.4627> }
				triangle { <-19.244, 65.4985, 0.9018>, <-26.2014, 59.781, 8.7827>, <-19.3138, 63.7025, -0.4627> }
				triangle { <-19.244, 65.4985, 0.9018>, <-19.3138, 63.7025, -0.4627>, <-26.2014, 59.781, 8.7827> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-12.9831, 63.6121, 2.9359>, <-13.08032, 63.6635, 2.992>, 0.008416 }
				cylinder { <-13.08032, 63.6635, 2.992>, <-13.1775, 63.7149, 3.04816>, 0.008416 }
				cylinder { <-13.1775, 63.7149, 3.04816>, <-13.2747, 63.7662, 3.1042>, 0.008416 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-13.2747, 63.7662, 3.1042>, <-15.102, 66.08972, 5.5557>, <-16.3997, 66.1367, 5.6473> }
				triangle { <-13.2747, 63.7662, 3.1042>, <-16.3997, 66.1367, 5.6473>, <-15.102, 66.08972, 5.5557> }
				triangle { <-15.102, 66.08972, 5.5557>, <-17.00311, 67.7334, 7.3103>, <-16.3997, 66.1367, 5.6473> }
				triangle { <-15.102, 66.08972, 5.5557>, <-16.3997, 66.1367, 5.6473>, <-17.00311, 67.7334, 7.3103> }
				triangle { <-17.00311, 67.7334, 7.3103>, <-18.3928, 66.4715, 6.05793>, <-16.3997, 66.1367, 5.6473> }
				triangle { <-17.00311, 67.7334, 7.3103>, <-16.3997, 66.1367, 5.6473>, <-18.3928, 66.4715, 6.05793> }
				triangle { <-16.3997, 66.1367, 5.6473>, <-18.3928, 66.4715, 6.05793>, <-13.2747, 63.7662, 3.1042> }
				triangle { <-16.3997, 66.1367, 5.6473>, <-13.2747, 63.7662, 3.1042>, <-18.3928, 66.4715, 6.05793> }
				triangle { <-17.00311, 67.7334, 7.3103>, <-18.7499, 63.0116, 14.1692>, <-20.4925, 60.7006, 16.6425> }
				triangle { <-17.00311, 67.7334, 7.3103>, <-20.4925, 60.7006, 16.6425>, <-18.7499, 63.0116, 14.1692> }
				triangle { <-20.4925, 60.7006, 16.6425>, <-21.4978, 58.7619, 17.272>, <-19.9695, 59.03547, 15.3003> }
				triangle { <-20.4925, 60.7006, 16.6425>, <-19.9695, 59.03547, 15.3003>, <-21.4978, 58.7619, 17.272> }
				triangle { <-19.9695, 59.03547, 15.3003>, <-17.00311, 67.7334, 7.3103>, <-20.4925, 60.7006, 16.6425> }
				triangle { <-19.9695, 59.03547, 15.3003>, <-20.4925, 60.7006, 16.6425>, <-17.00311, 67.7334, 7.3103> }
				triangle { <-17.00311, 67.7334, 7.3103>, <-19.9695, 59.03547, 15.3003>, <-18.3928, 66.4715, 6.05793> }
				triangle { <-17.00311, 67.7334, 7.3103>, <-18.3928, 66.4715, 6.05793>, <-19.9695, 59.03547, 15.3003> }
				triangle { <-17.4003, 65.2282, 4.7455>, <-16.992, 64.3735, 3.8525>, <-13.2747, 63.7662, 3.1042> }
				triangle { <-17.4003, 65.2282, 4.7455>, <-13.2747, 63.7662, 3.1042>, <-16.992, 64.3735, 3.8525> }
				triangle { <-17.4003, 65.2282, 4.7455>, <-19.7826, 65.2095, 4.8055>, <-16.992, 64.3735, 3.8525> }
				triangle { <-17.4003, 65.2282, 4.7455>, <-16.992, 64.3735, 3.8525>, <-19.7826, 65.2095, 4.8055> }
				triangle { <-17.4003, 65.2282, 4.7455>, <-18.3928, 66.4715, 6.05793>, <-19.7826, 65.2095, 4.8055> }
				triangle { <-17.4003, 65.2282, 4.7455>, <-19.7826, 65.2095, 4.8055>, <-18.3928, 66.4715, 6.05793> }
				triangle { <-13.2747, 63.7662, 3.1042>, <-18.3928, 66.4715, 6.05793>, <-17.4003, 65.2282, 4.7455> }
				triangle { <-13.2747, 63.7662, 3.1042>, <-17.4003, 65.2282, 4.7455>, <-18.3928, 66.4715, 6.05793> }
				triangle { <-22.1602, 59.1863, 15.1396>, <-21.6405, 60.3868, 11.5643>, <-19.7826, 65.2095, 4.8055> }
				triangle { <-22.1602, 59.1863, 15.1396>, <-19.7826, 65.2095, 4.8055>, <-21.6405, 60.3868, 11.5643> }
				triangle { <-19.9695, 59.03547, 15.3003>, <-21.4978, 58.7619, 17.272>, <-22.1602, 59.1863, 15.1396> }
				triangle { <-19.9695, 59.03547, 15.3003>, <-22.1602, 59.1863, 15.1396>, <-21.4978, 58.7619, 17.272> }
				triangle { <-22.1602, 59.1863, 15.1396>, <-19.7826, 65.2095, 4.8055>, <-19.9695, 59.03547, 15.3003> }
				triangle { <-22.1602, 59.1863, 15.1396>, <-19.9695, 59.03547, 15.3003>, <-19.7826, 65.2095, 4.8055> }
				triangle { <-18.3928, 66.4715, 6.05793>, <-19.9695, 59.03547, 15.3003>, <-19.7826, 65.2095, 4.8055> }
				triangle { <-18.3928, 66.4715, 6.05793>, <-19.7826, 65.2095, 4.8055>, <-19.9695, 59.03547, 15.3003> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // Internode
		cylinder { <-7.4629, 58.3696, -0.19>, <-7.4882, 58.9565, -0.1902>, 0.1067 }
		cylinder { <-7.4882, 58.9565, -0.1902>, <-7.5134, 59.5433, -0.1903>, 0.1067 }
		cylinder { <-7.5134, 59.5433, -0.1903>, <-7.5387, 60.1302, -0.1905>, 0.1067 }
		pigment { color rgb <0.1953, 0.3906, 0.1953> }}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-7.5387, 60.1302, -0.1905>, <-7.6667, 60.4745, -0.2137>, 0.02509 }
			cylinder { <-7.6667, 60.4745, -0.2137>, <-7.894, 60.7606, -0.2579>, 0.02509 }
			cylinder { <-7.894, 60.7606, -0.2579>, <-8.1976, 60.9596, -0.3184>, 0.02509 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-8.1976, 60.9596, -0.3184>, <-8.2887, 61.01941, -0.3366>, 0.02509 }
				cylinder { <-8.2887, 61.01941, -0.3366>, <-8.3798, 61.07913, -0.3547>, 0.02509 }
				cylinder { <-8.3798, 61.07913, -0.3547>, <-8.4709, 61.1388, -0.3729>, 0.02509 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-8.4709, 61.1388, -0.3729>, <-8.4764, 61.1427, -0.376>, 0.0005038 }
				cylinder { <-8.4764, 61.1427, -0.376>, <-8.4809, 61.1461, -0.3808>, 0.0005038 }
				cylinder { <-8.4809, 61.1461, -0.3808>, <-8.484, 61.1489, -0.3869>, 0.0005038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-8.484, 61.1489, -0.3869>, <-8.9524, 61.7798, -0.902>, <-9.0158, 61.737, -1.2112> }
				triangle { <-8.484, 61.1489, -0.3869>, <-9.0158, 61.737, -1.2112>, <-8.9524, 61.7798, -0.902> }
				triangle { <-8.9524, 61.7798, -0.902>, <-9.3097, 62.1993, -1.4106>, <-9.0158, 61.737, -1.2112> }
				triangle { <-8.9524, 61.7798, -0.902>, <-9.0158, 61.737, -1.2112>, <-9.3097, 62.1993, -1.4106> }
				triangle { <-9.3097, 62.1993, -1.4106>, <-9.1572, 61.7516, -1.6953>, <-9.0158, 61.737, -1.2112> }
				triangle { <-9.3097, 62.1993, -1.4106>, <-9.0158, 61.737, -1.2112>, <-9.1572, 61.7516, -1.6953> }
				triangle { <-9.0158, 61.737, -1.2112>, <-9.1572, 61.7516, -1.6953>, <-8.484, 61.1489, -0.3869> }
				triangle { <-9.0158, 61.737, -1.2112>, <-8.484, 61.1489, -0.3869>, <-9.1572, 61.7516, -1.6953> }
				triangle { <-9.3097, 62.1993, -1.4106>, <-11.2925, 61.5657, -1.4338>, <-12.08942, 61.1468, -1.673> }
				triangle { <-9.3097, 62.1993, -1.4106>, <-12.08942, 61.1468, -1.673>, <-11.2925, 61.5657, -1.4338> }
				triangle { <-12.08942, 61.1468, -1.673>, <-12.407, 60.7064, -1.793>, <-11.8774, 60.6896, -1.4827> }
				triangle { <-12.08942, 61.1468, -1.673>, <-11.8774, 60.6896, -1.4827>, <-12.407, 60.7064, -1.793> }
				triangle { <-11.8774, 60.6896, -1.4827>, <-9.3097, 62.1993, -1.4106>, <-12.08942, 61.1468, -1.673> }
				triangle { <-11.8774, 60.6896, -1.4827>, <-12.08942, 61.1468, -1.673>, <-9.3097, 62.1993, -1.4106> }
				triangle { <-9.3097, 62.1993, -1.4106>, <-11.8774, 60.6896, -1.4827>, <-9.1572, 61.7516, -1.6953> }
				triangle { <-9.3097, 62.1993, -1.4106>, <-9.1572, 61.7516, -1.6953>, <-11.8774, 60.6896, -1.4827> }
				triangle { <-8.9059, 61.4146, -1.4162>, <-8.7449, 61.1709, -1.2892>, <-8.484, 61.1489, -0.3869> }
				triangle { <-8.9059, 61.4146, -1.4162>, <-8.484, 61.1489, -0.3869>, <-8.7449, 61.1709, -1.2892> }
				triangle { <-8.9059, 61.4146, -1.4162>, <-9.004665, 61.3038, -1.98>, <-8.7449, 61.1709, -1.2892> }
				triangle { <-8.9059, 61.4146, -1.4162>, <-8.7449, 61.1709, -1.2892>, <-9.004665, 61.3038, -1.98> }
				triangle { <-8.9059, 61.4146, -1.4162>, <-9.1572, 61.7516, -1.6953>, <-9.004665, 61.3038, -1.98> }
				triangle { <-8.9059, 61.4146, -1.4162>, <-9.004665, 61.3038, -1.98>, <-9.1572, 61.7516, -1.6953> }
				triangle { <-8.484, 61.1489, -0.3869>, <-9.1572, 61.7516, -1.6953>, <-8.9059, 61.4146, -1.4162> }
				triangle { <-8.484, 61.1489, -0.3869>, <-8.9059, 61.4146, -1.4162>, <-9.1572, 61.7516, -1.6953> }
				triangle { <-11.9063, 60.6095, -2.01471>, <-10.9752, 60.6344, -2.02603>, <-9.004665, 61.3038, -1.98> }
				triangle { <-11.9063, 60.6095, -2.01471>, <-9.004665, 61.3038, -1.98>, <-10.9752, 60.6344, -2.02603> }
				triangle { <-11.8774, 60.6896, -1.4827>, <-12.407, 60.7064, -1.793>, <-11.9063, 60.6095, -2.01471> }
				triangle { <-11.8774, 60.6896, -1.4827>, <-11.9063, 60.6095, -2.01471>, <-12.407, 60.7064, -1.793> }
				triangle { <-11.9063, 60.6095, -2.01471>, <-9.004665, 61.3038, -1.98>, <-11.8774, 60.6896, -1.4827> }
				triangle { <-11.9063, 60.6095, -2.01471>, <-11.8774, 60.6896, -1.4827>, <-9.004665, 61.3038, -1.98> }
				triangle { <-9.1572, 61.7516, -1.6953>, <-11.8774, 60.6896, -1.4827>, <-9.004665, 61.3038, -1.98> }
				triangle { <-9.1572, 61.7516, -1.6953>, <-9.004665, 61.3038, -1.98>, <-11.8774, 60.6896, -1.4827> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-8.4709, 61.1388, -0.3729>, <-8.562, 61.1985, -0.3911>, 0.02509 }
				cylinder { <-8.562, 61.1985, -0.3911>, <-8.6531, 61.2582, -0.4092>, 0.02509 }
				cylinder { <-8.6531, 61.2582, -0.4092>, <-8.7442, 61.318, -0.4274>, 0.02509 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-8.7442, 61.318, -0.4274>, <-8.7505, 61.3218, -0.4266>, 0.0005038 }
				cylinder { <-8.7505, 61.3218, -0.4266>, <-8.7564, 61.3252, -0.424>, 0.0005038 }
				cylinder { <-8.7564, 61.3252, -0.424>, <-8.7617, 61.3279, -0.4195>, 0.0005038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-8.7617, 61.3279, -0.4195>, <-9.1203, 61.7121, 0.3592>, <-9.4304, 61.7772, 0.3922> }
				triangle { <-8.7617, 61.3279, -0.4195>, <-9.4304, 61.7772, 0.3922>, <-9.1203, 61.7121, 0.3592> }
				triangle { <-9.1203, 61.7121, 0.3592>, <-9.5201, 62.01159, 0.9185>, <-9.4304, 61.7772, 0.3922> }
				triangle { <-9.1203, 61.7121, 0.3592>, <-9.4304, 61.7772, 0.3922>, <-9.5201, 62.01159, 0.9185> }
				triangle { <-9.5201, 62.01159, 0.9185>, <-9.8975, 61.9112, 0.5281>, <-9.4304, 61.7772, 0.3922> }
				triangle { <-9.5201, 62.01159, 0.9185>, <-9.4304, 61.7772, 0.3922>, <-9.8975, 61.9112, 0.5281> }
				triangle { <-9.4304, 61.7772, 0.3922>, <-9.8975, 61.9112, 0.5281>, <-8.7617, 61.3279, -0.4195> }
				triangle { <-9.4304, 61.7772, 0.3922>, <-8.7617, 61.3279, -0.4195>, <-9.8975, 61.9112, 0.5281> }
				triangle { <-9.5201, 62.01159, 0.9185>, <-10.2469, 60.429, 2.05911>, <-10.8044, 59.777, 2.422> }
				triangle { <-9.5201, 62.01159, 0.9185>, <-10.8044, 59.777, 2.422>, <-10.2469, 60.429, 2.05911> }
				triangle { <-10.8044, 59.777, 2.422>, <-11.1448, 59.3381, 2.3954>, <-10.7411, 59.5024, 1.9629> }
				triangle { <-10.8044, 59.777, 2.422>, <-10.7411, 59.5024, 1.9629>, <-11.1448, 59.3381, 2.3954> }
				triangle { <-10.7411, 59.5024, 1.9629>, <-9.5201, 62.01159, 0.9185>, <-10.8044, 59.777, 2.422> }
				triangle { <-10.7411, 59.5024, 1.9629>, <-10.8044, 59.777, 2.422>, <-9.5201, 62.01159, 0.9185> }
				triangle { <-9.5201, 62.01159, 0.9185>, <-10.7411, 59.5024, 1.9629>, <-9.8975, 61.9112, 0.5281> }
				triangle { <-9.5201, 62.01159, 0.9185>, <-9.8975, 61.9112, 0.5281>, <-10.7411, 59.5024, 1.9629> }
				triangle { <-9.702, 61.7049, 0.1112>, <-9.6335, 61.5756, -0.1716>, <-8.7617, 61.3279, -0.4195> }
				triangle { <-9.702, 61.7049, 0.1112>, <-8.7617, 61.3279, -0.4195>, <-9.6335, 61.5756, -0.1716> }
				triangle { <-9.702, 61.7049, 0.1112>, <-10.2748, 61.8108, 0.1378>, <-9.6335, 61.5756, -0.1716> }
				triangle { <-9.702, 61.7049, 0.1112>, <-9.6335, 61.5756, -0.1716>, <-10.2748, 61.8108, 0.1378> }
				triangle { <-9.702, 61.7049, 0.1112>, <-9.8975, 61.9112, 0.5281>, <-10.2748, 61.8108, 0.1378> }
				triangle { <-9.702, 61.7049, 0.1112>, <-10.2748, 61.8108, 0.1378>, <-9.8975, 61.9112, 0.5281> }
				triangle { <-8.7617, 61.3279, -0.4195>, <-9.8975, 61.9112, 0.5281>, <-9.702, 61.7049, 0.1112> }
				triangle { <-8.7617, 61.3279, -0.4195>, <-9.702, 61.7049, 0.1112>, <-9.8975, 61.9112, 0.5281> }
				triangle { <-11.2572, 59.6566, 1.9536>, <-11.03172, 60.2202, 1.2471>, <-10.2748, 61.8108, 0.1378> }
				triangle { <-11.2572, 59.6566, 1.9536>, <-10.2748, 61.8108, 0.1378>, <-11.03172, 60.2202, 1.2471> }
				triangle { <-10.7411, 59.5024, 1.9629>, <-11.1448, 59.3381, 2.3954>, <-11.2572, 59.6566, 1.9536> }
				triangle { <-10.7411, 59.5024, 1.9629>, <-11.2572, 59.6566, 1.9536>, <-11.1448, 59.3381, 2.3954> }
				triangle { <-11.2572, 59.6566, 1.9536>, <-10.2748, 61.8108, 0.1378>, <-10.7411, 59.5024, 1.9629> }
				triangle { <-11.2572, 59.6566, 1.9536>, <-10.7411, 59.5024, 1.9629>, <-10.2748, 61.8108, 0.1378> }
				triangle { <-9.8975, 61.9112, 0.5281>, <-10.7411, 59.5024, 1.9629>, <-10.2748, 61.8108, 0.1378> }
				triangle { <-9.8975, 61.9112, 0.5281>, <-10.2748, 61.8108, 0.1378>, <-10.7411, 59.5024, 1.9629> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-8.7442, 61.318, -0.4274>, <-8.8353, 61.3777, -0.4456>, 0.02509 }
				cylinder { <-8.8353, 61.3777, -0.4456>, <-8.9264, 61.4374, -0.4637>, 0.02509 }
				cylinder { <-8.9264, 61.4374, -0.4637>, <-9.0175, 61.4971, -0.4819>, 0.02509 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-9.0175, 61.4971, -0.4819>, <-9.02298, 61.501, -0.485>, 0.0005038 }
				cylinder { <-9.02298, 61.501, -0.485>, <-9.02744, 61.5044, -0.4897>, 0.0005038 }
				cylinder { <-9.02744, 61.5044, -0.4897>, <-9.03057, 61.5072, -0.4958>, 0.0005038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-9.03057, 61.5072, -0.4958>, <-9.4989, 62.1382, -1.01099>, <-9.5623, 62.09536, -1.3201> }
				triangle { <-9.03057, 61.5072, -0.4958>, <-9.5623, 62.09536, -1.3201>, <-9.4989, 62.1382, -1.01099> }
				triangle { <-9.4989, 62.1382, -1.01099>, <-9.8563, 62.5577, -1.5195>, <-9.5623, 62.09536, -1.3201> }
				triangle { <-9.4989, 62.1382, -1.01099>, <-9.5623, 62.09536, -1.3201>, <-9.8563, 62.5577, -1.5195> }
				triangle { <-9.8563, 62.5577, -1.5195>, <-9.7037, 62.1099, -1.8043>, <-9.5623, 62.09536, -1.3201> }
				triangle { <-9.8563, 62.5577, -1.5195>, <-9.5623, 62.09536, -1.3201>, <-9.7037, 62.1099, -1.8043> }
				triangle { <-9.5623, 62.09536, -1.3201>, <-9.7037, 62.1099, -1.8043>, <-9.03057, 61.5072, -0.4958> }
				triangle { <-9.5623, 62.09536, -1.3201>, <-9.03057, 61.5072, -0.4958>, <-9.7037, 62.1099, -1.8043> }
				triangle { <-9.8563, 62.5577, -1.5195>, <-11.8391, 61.924, -1.5427>, <-12.6359, 61.5051, -1.782> }
				triangle { <-9.8563, 62.5577, -1.5195>, <-12.6359, 61.5051, -1.782>, <-11.8391, 61.924, -1.5427> }
				triangle { <-12.6359, 61.5051, -1.782>, <-12.9535, 61.06473, -1.9019>, <-12.4239, 61.04793, -1.5917> }
				triangle { <-12.6359, 61.5051, -1.782>, <-12.4239, 61.04793, -1.5917>, <-12.9535, 61.06473, -1.9019> }
				triangle { <-12.4239, 61.04793, -1.5917>, <-9.8563, 62.5577, -1.5195>, <-12.6359, 61.5051, -1.782> }
				triangle { <-12.4239, 61.04793, -1.5917>, <-12.6359, 61.5051, -1.782>, <-9.8563, 62.5577, -1.5195> }
				triangle { <-9.8563, 62.5577, -1.5195>, <-12.4239, 61.04793, -1.5917>, <-9.7037, 62.1099, -1.8043> }
				triangle { <-9.8563, 62.5577, -1.5195>, <-9.7037, 62.1099, -1.8043>, <-12.4239, 61.04793, -1.5917> }
				triangle { <-9.4524, 61.7729, -1.5251>, <-9.2914, 61.5292, -1.3982>, <-9.03057, 61.5072, -0.4958> }
				triangle { <-9.4524, 61.7729, -1.5251>, <-9.03057, 61.5072, -0.4958>, <-9.2914, 61.5292, -1.3982> }
				triangle { <-9.4524, 61.7729, -1.5251>, <-9.5512, 61.6621, -2.08904>, <-9.2914, 61.5292, -1.3982> }
				triangle { <-9.4524, 61.7729, -1.5251>, <-9.2914, 61.5292, -1.3982>, <-9.5512, 61.6621, -2.08904> }
				triangle { <-9.4524, 61.7729, -1.5251>, <-9.7037, 62.1099, -1.8043>, <-9.5512, 61.6621, -2.08904> }
				triangle { <-9.4524, 61.7729, -1.5251>, <-9.5512, 61.6621, -2.08904>, <-9.7037, 62.1099, -1.8043> }
				triangle { <-9.03057, 61.5072, -0.4958>, <-9.7037, 62.1099, -1.8043>, <-9.4524, 61.7729, -1.5251> }
				triangle { <-9.03057, 61.5072, -0.4958>, <-9.4524, 61.7729, -1.5251>, <-9.7037, 62.1099, -1.8043> }
				triangle { <-12.4528, 60.9678, -2.1236>, <-11.5217, 60.9927, -2.1349>, <-9.5512, 61.6621, -2.08904> }
				triangle { <-12.4528, 60.9678, -2.1236>, <-9.5512, 61.6621, -2.08904>, <-11.5217, 60.9927, -2.1349> }
				triangle { <-12.4239, 61.04793, -1.5917>, <-12.9535, 61.06473, -1.9019>, <-12.4528, 60.9678, -2.1236> }
				triangle { <-12.4239, 61.04793, -1.5917>, <-12.4528, 60.9678, -2.1236>, <-12.9535, 61.06473, -1.9019> }
				triangle { <-12.4528, 60.9678, -2.1236>, <-9.5512, 61.6621, -2.08904>, <-12.4239, 61.04793, -1.5917> }
				triangle { <-12.4528, 60.9678, -2.1236>, <-12.4239, 61.04793, -1.5917>, <-9.5512, 61.6621, -2.08904> }
				triangle { <-9.7037, 62.1099, -1.8043>, <-12.4239, 61.04793, -1.5917>, <-9.5512, 61.6621, -2.08904> }
				triangle { <-9.7037, 62.1099, -1.8043>, <-9.5512, 61.6621, -2.08904>, <-12.4239, 61.04793, -1.5917> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-9.0175, 61.4971, -0.4819>, <-9.02359, 61.5011, -0.4831>, 0.0005038 }
				cylinder { <-9.02359, 61.5011, -0.4831>, <-9.02969, 61.5051, -0.4843>, 0.0005038 }
				cylinder { <-9.02969, 61.5051, -0.4843>, <-9.03578, 61.5091, -0.4855>, 0.0005038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-9.03578, 61.5091, -0.4855>, <-9.6886, 62.1605, -0.3059>, <-9.9343, 62.2165, -0.5007> }
				triangle { <-9.03578, 61.5091, -0.4855>, <-9.9343, 62.2165, -0.5007>, <-9.6886, 62.1605, -0.3059> }
				triangle { <-9.6886, 62.1605, -0.3059>, <-10.2627, 62.642, -0.2746>, <-9.9343, 62.2165, -0.5007> }
				triangle { <-9.6886, 62.1605, -0.3059>, <-9.9343, 62.2165, -0.5007>, <-10.2627, 62.642, -0.2746> }
				triangle { <-10.2627, 62.642, -0.2746>, <-10.3474, 62.3691, -0.747>, <-9.9343, 62.2165, -0.5007> }
				triangle { <-10.2627, 62.642, -0.2746>, <-9.9343, 62.2165, -0.5007>, <-10.3474, 62.3691, -0.747> }
				triangle { <-9.9343, 62.2165, -0.5007>, <-10.3474, 62.3691, -0.747>, <-9.03578, 61.5091, -0.4855> }
				triangle { <-9.9343, 62.2165, -0.5007>, <-9.03578, 61.5091, -0.4855>, <-10.3474, 62.3691, -0.747> }
				triangle { <-10.2627, 62.642, -0.2746>, <-11.8507, 61.6345, 0.6179>, <-12.6423, 61.1614, 0.7493> }
				triangle { <-10.2627, 62.642, -0.2746>, <-12.6423, 61.1614, 0.7493>, <-11.8507, 61.6345, 0.6179> }
				triangle { <-12.6423, 61.1614, 0.7493>, <-12.9881, 60.7328, 0.6717>, <-12.383, 60.7256, 0.5673> }
				triangle { <-12.6423, 61.1614, 0.7493>, <-12.383, 60.7256, 0.5673>, <-12.9881, 60.7328, 0.6717> }
				triangle { <-12.383, 60.7256, 0.5673>, <-10.2627, 62.642, -0.2746>, <-12.6423, 61.1614, 0.7493> }
				triangle { <-12.383, 60.7256, 0.5673>, <-12.6423, 61.1614, 0.7493>, <-10.2627, 62.642, -0.2746> }
				triangle { <-10.2627, 62.642, -0.2746>, <-12.383, 60.7256, 0.5673>, <-10.3474, 62.3691, -0.747> }
				triangle { <-10.2627, 62.642, -0.2746>, <-10.3474, 62.3691, -0.747>, <-12.383, 60.7256, 0.5673> }
				triangle { <-9.9954, 62.02004, -0.8408>, <-9.8039, 61.7893, -0.9484>, <-9.03578, 61.5091, -0.4855> }
				triangle { <-9.9954, 62.02004, -0.8408>, <-9.03578, 61.5091, -0.4855>, <-9.8039, 61.7893, -0.9484> }
				triangle { <-9.9954, 62.02004, -0.8408>, <-10.4322, 62.09619, -1.2195>, <-9.8039, 61.7893, -0.9484> }
				triangle { <-9.9954, 62.02004, -0.8408>, <-9.8039, 61.7893, -0.9484>, <-10.4322, 62.09619, -1.2195> }
				triangle { <-9.9954, 62.02004, -0.8408>, <-10.3474, 62.3691, -0.747>, <-10.4322, 62.09619, -1.2195> }
				triangle { <-9.9954, 62.02004, -0.8408>, <-10.4322, 62.09619, -1.2195>, <-10.3474, 62.3691, -0.747> }
				triangle { <-9.03578, 61.5091, -0.4855>, <-10.3474, 62.3691, -0.747>, <-9.9954, 62.02004, -0.8408> }
				triangle { <-9.03578, 61.5091, -0.4855>, <-9.9954, 62.02004, -0.8408>, <-10.3474, 62.3691, -0.747> }
				triangle { <-12.744, 60.8339, 0.1824>, <-12.02703, 61.06694, -0.3647>, <-10.4322, 62.09619, -1.2195> }
				triangle { <-12.744, 60.8339, 0.1824>, <-10.4322, 62.09619, -1.2195>, <-12.02703, 61.06694, -0.3647> }
				triangle { <-12.383, 60.7256, 0.5673>, <-12.9881, 60.7328, 0.6717>, <-12.744, 60.8339, 0.1824> }
				triangle { <-12.383, 60.7256, 0.5673>, <-12.744, 60.8339, 0.1824>, <-12.9881, 60.7328, 0.6717> }
				triangle { <-12.744, 60.8339, 0.1824>, <-10.4322, 62.09619, -1.2195>, <-12.383, 60.7256, 0.5673> }
				triangle { <-12.744, 60.8339, 0.1824>, <-12.383, 60.7256, 0.5673>, <-10.4322, 62.09619, -1.2195> }
				triangle { <-10.3474, 62.3691, -0.747>, <-12.383, 60.7256, 0.5673>, <-10.4322, 62.09619, -1.2195> }
				triangle { <-10.3474, 62.3691, -0.747>, <-10.4322, 62.09619, -1.2195>, <-12.383, 60.7256, 0.5673> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-7.5387, 60.1302, -0.1905>, <-7.4407, 60.4842, -0.1673>, 0.02509 }
			cylinder { <-7.4407, 60.4842, -0.1673>, <-7.2388, 60.7888, -0.1233>, 0.02509 }
			cylinder { <-7.2388, 60.7888, -0.1233>, <-6.9534, 61.01329, -0.06294>, 0.02509 }
			pigment { color rgb <0.1953, 0.3906, 0.1953> }}
		union { // compound leaf
			union { // Petiole
				cylinder { <-6.9534, 61.01329, -0.06294>, <-6.8678, 61.08062, -0.04481>, 0.02509 }
				cylinder { <-6.8678, 61.08062, -0.04481>, <-6.7822, 61.1479, -0.02668>, 0.02509 }
				cylinder { <-6.7822, 61.1479, -0.02668>, <-6.6966, 61.2152, -0.008551>, 0.02509 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.6966, 61.2152, -0.008551>, <-6.6914, 61.2196, -0.005451>, 0.0005038 }
				cylinder { <-6.6914, 61.2196, -0.005451>, <-6.6873, 61.2234, -0.000689>, 0.0005038 }
				cylinder { <-6.6873, 61.2234, -0.000689>, <-6.6844, 61.2265, 0.00539>, 0.0005038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.6844, 61.2265, 0.00539>, <-6.272, 61.8955, 0.5202>, <-6.2051, 61.8584, 0.8294> }
				triangle { <-6.6844, 61.2265, 0.00539>, <-6.2051, 61.8584, 0.8294>, <-6.272, 61.8955, 0.5202> }
				triangle { <-6.272, 61.8955, 0.5202>, <-5.9519, 62.3444, 1.0286>, <-6.2051, 61.8584, 0.8294> }
				triangle { <-6.272, 61.8955, 0.5202>, <-6.2051, 61.8584, 0.8294>, <-5.9519, 62.3444, 1.0286> }
				triangle { <-5.9519, 62.3444, 1.0286>, <-6.06554, 61.8853, 1.3135>, <-6.2051, 61.8584, 0.8294> }
				triangle { <-5.9519, 62.3444, 1.0286>, <-6.2051, 61.8584, 0.8294>, <-6.06554, 61.8853, 1.3135> }
				triangle { <-6.2051, 61.8584, 0.8294>, <-6.06554, 61.8853, 1.3135>, <-6.6844, 61.2265, 0.00539> }
				triangle { <-6.2051, 61.8584, 0.8294>, <-6.6844, 61.2265, 0.00539>, <-6.06554, 61.8853, 1.3135> }
				triangle { <-5.9519, 62.3444, 1.0286>, <-3.9221, 61.8834, 1.05203>, <-3.09224, 61.5346, 1.2914> }
				triangle { <-5.9519, 62.3444, 1.0286>, <-3.09224, 61.5346, 1.2914>, <-3.9221, 61.8834, 1.05203> }
				triangle { <-3.09224, 61.5346, 1.2914>, <-2.7379, 61.1231, 1.4116>, <-3.2642, 61.06081, 1.1014> }
				triangle { <-3.09224, 61.5346, 1.2914>, <-3.2642, 61.06081, 1.1014>, <-2.7379, 61.1231, 1.4116> }
				triangle { <-3.2642, 61.06081, 1.1014>, <-5.9519, 62.3444, 1.0286>, <-3.09224, 61.5346, 1.2914> }
				triangle { <-3.2642, 61.06081, 1.1014>, <-3.09224, 61.5346, 1.2914>, <-5.9519, 62.3444, 1.0286> }
				triangle { <-5.9519, 62.3444, 1.0286>, <-3.2642, 61.06081, 1.1014>, <-6.06554, 61.8853, 1.3135> }
				triangle { <-5.9519, 62.3444, 1.0286>, <-6.06554, 61.8853, 1.3135>, <-3.2642, 61.06081, 1.1014> }
				triangle { <-6.2869, 61.5279, 1.03457>, <-6.4264, 61.2712, 0.9077>, <-6.6844, 61.2265, 0.00539> }
				triangle { <-6.2869, 61.5279, 1.03457>, <-6.6844, 61.2265, 0.00539>, <-6.4264, 61.2712, 0.9077> }
				triangle { <-6.2869, 61.5279, 1.03457>, <-6.179, 61.4262, 1.5984>, <-6.4264, 61.2712, 0.9077> }
				triangle { <-6.2869, 61.5279, 1.03457>, <-6.4264, 61.2712, 0.9077>, <-6.179, 61.4262, 1.5984> }
				triangle { <-6.2869, 61.5279, 1.03457>, <-6.06554, 61.8853, 1.3135>, <-6.179, 61.4262, 1.5984> }
				triangle { <-6.2869, 61.5279, 1.03457>, <-6.179, 61.4262, 1.5984>, <-6.06554, 61.8853, 1.3135> }
				triangle { <-6.6844, 61.2265, 0.00539>, <-6.06554, 61.8853, 1.3135>, <-6.2869, 61.5279, 1.03457> }
				triangle { <-6.6844, 61.2265, 0.00539>, <-6.2869, 61.5279, 1.03457>, <-6.06554, 61.8853, 1.3135> }
				triangle { <-3.2284, 60.9837, 1.6333>, <-4.1582, 60.9285, 1.6447>, <-6.179, 61.4262, 1.5984> }
				triangle { <-3.2284, 60.9837, 1.6333>, <-6.179, 61.4262, 1.5984>, <-4.1582, 60.9285, 1.6447> }
				triangle { <-3.2642, 61.06081, 1.1014>, <-2.7379, 61.1231, 1.4116>, <-3.2284, 60.9837, 1.6333> }
				triangle { <-3.2642, 61.06081, 1.1014>, <-3.2284, 60.9837, 1.6333>, <-2.7379, 61.1231, 1.4116> }
				triangle { <-3.2284, 60.9837, 1.6333>, <-6.179, 61.4262, 1.5984>, <-3.2642, 61.06081, 1.1014> }
				triangle { <-3.2284, 60.9837, 1.6333>, <-3.2642, 61.06081, 1.1014>, <-6.179, 61.4262, 1.5984> }
				triangle { <-6.06554, 61.8853, 1.3135>, <-3.2642, 61.06081, 1.1014>, <-6.179, 61.4262, 1.5984> }
				triangle { <-6.06554, 61.8853, 1.3135>, <-6.179, 61.4262, 1.5984>, <-3.2642, 61.06081, 1.1014> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.6966, 61.2152, -0.008551>, <-6.6109, 61.2826, 0.009579>, 0.02509 }
				cylinder { <-6.6109, 61.2826, 0.009579>, <-6.5253, 61.3499, 0.02771>, 0.02509 }
				cylinder { <-6.5253, 61.3499, 0.02771>, <-6.4397, 61.4172, 0.04584>, 0.02509 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			union { // Petiole
				cylinder { <-6.4397, 61.4172, 0.04584>, <-6.4338, 61.4216, 0.04508>, 0.0005038 }
				cylinder { <-6.4338, 61.4216, 0.04508>, <-6.4281, 61.4255, 0.04239>, 0.0005038 }
				cylinder { <-6.4281, 61.4255, 0.04239>, <-6.4231, 61.4286, 0.03799>, 0.0005038 }
				pigment { color rgb <0.1953, 0.3906, 0.1953> }}
			mesh { // Leaf 3D object
				triangle { <-6.4231, 61.4286, 0.03799>, <-6.09882, 61.8418, -0.741>, <-5.7955, 61.9333, -0.7741> }
				triangle { <-6.4231, 61.4286, 0.03799>, <-5.7955, 61.9333, -0.7741>, <-6.09882, 61.8418, -0.741> }
				triangle { <-6.09882, 61.8418, -0.741>, <-5.7262, 62.1743, -1.3005>, <-5.7955, 61.9333, -0.7741> }
				triangle { <-6.09882, 61.8418, -0.741>, <-5.7955, 61.9333, -0.7741>, <-5.7262, 62.1743, -1.3005> }
				triangle { <-5.7262, 62.1743, -1.3005>, <-5.3416, 62.1069, -0.91>, <-5.7955, 61.9333, -0.7741> }
				triangle { <-5.7262, 62.1743, -1.3005>, <-5.7955, 61.9333, -0.7741>, <-5.3416, 62.1069, -0.91> }
				triangle { <-5.7955, 61.9333, -0.7741>, <-5.3416, 62.1069, -0.91>, <-6.4231, 61.4286, 0.03799> }
				triangle { <-5.7955, 61.9333, -0.7741>, <-6.4231, 61.4286, 0.03799>, <-5.3416, 62.1069, -0.91> }
				triangle { <-5.7262, 62.1743, -1.3005>, <-4.8662, 60.6594, -2.4403>, <-4.2547, 60.05764, -2.8029> }
				triangle { <-5.7262, 62.1743, -1.3005>, <-4.2547, 60.05764, -2.8029>, <-4.8662, 60.6594, -2.4403> }
				triangle { <-4.2547, 60.05764, -2.8029>, <-3.8778, 59.6496, -2.7761>, <-4.2942, 59.7788, -2.3437> }
				triangle { <-4.2547, 60.05764, -2.8029>, <-4.2942, 59.7788, -2.3437>, <-3.8778, 59.6496, -2.7761> }
				triangle { <-4.2942, 59.7788, -2.3437>, <-5.7262, 62.1743, -1.3005>, <-4.2547, 60.05764, -2.8029> }
				triangle { <-4.2942, 59.7788, -2.3437>, <-4.2547, 60.05764, -2.8029>, <-5.7262, 62.1743, -1.3005> }
				triangle { <-5.7262, 62.1743, -1.3005>, <-4.2942, 59.7788, -2.3437>, <-5.3416, 62.1069, -0.91> }
				triangle { <-5.7262, 62.1743, -1.3005>, <-5.3416, 62.1069, -0.91>, <-4.2942, 59.7788, -2.3437> }
				triangle { <-5.5186, 61.8848, -0.493>, <-5.5758, 61.7502, -0.21>, <-6.4231, 61.4286, 0.03799> }
				triangle { <-5.5186, 61.8848, -0.493>, <-6.4231, 61.4286, 0.03799>, <-5.5758, 61.7502, -0.21> }
				triangle { <-5.5186, 61.8848, -0.493>, <-4.9571, 62.0395, -0.5196>, <-5.5758, 61.7502, -0.21> }
				triangle { <-5.5186, 61.8848, -0.493>, <-5.5758, 61.7502, -0.21>, <-4.9571, 62.0395, -0.5196> }
				triangle { <-5.5186, 61.8848, -0.493>, <-5.3416, 62.1069, -0.91>, <-4.9571, 62.0395, -0.5196> }
				triangle { <-5.5186, 61.8848, -0.493>, <-4.9571, 62.0395, -0.5196>, <-5.3416, 62.1069, -0.91> }
				triangle { <-6.4231, 61.4286, 0.03799>, <-5.3416, 62.1069, -0.91>, <-5.5186, 61.8848, -0.493> }
				triangle { <-6.4231, 61.4286, 0.03799>, <-5.5186, 61.8848, -0.493>, <-5.3416, 62.1069, -0.91> }
				triangle { <-3.7932, 59.9767, -2.3344>, <-4.06638, 60.5192, -1.6282>, <-4.9571, 62.0395, -0.5196> }
				triangle { <-3.7932, 59.9767, -2.3344>, <-4.9571, 62.0395, -0.5196>, <-4.06638, 60.5192, -1.6282> }
				triangle { <-4.2942, 59.7788, -2.3437>, <-3.8778, 59.6496, -2.7761>, <-3.7932, 59.9767, -2.3344> }
				triangle { <-4.2942, 59.7788, -2.3437>, <-3.7932, 59.9767, -2.3344>, <-3.8778, 59.6496, -2.7761> }
				triangle { <-3.7932, 59.9767, -2.3344>, <-4.9571, 62.0395, -0.5196>, <-4.2942, 59.7788, -2.3437> }
				triangle { <-3.7932, 59.9767, -2.3344>, <-4.2942, 59.7788, -2.3437>, <-4.9571, 62.0395, -0.5196> }
				triangle { <-5.3416, 62.1069, -0.91>, <-4.2942, 59.7788, -2.3437>, <-4.9571, 62.0395, -0.5196> }
				triangle { <-5.3416, 62.1069, -0.91>, <-4.9571, 62.0395, -0.5196>, <-4.2942, 59.7788, -2.3437> }
				pigment { color rgb <0.1953, 0.9765, 0.1953> }}
			union { // Petiole
				cylinder { <-6.4397, 61.4172, 0.04584>, <-6.3541, 61.4846