
#include "colors.inc"
#include "textures.inc"      
#include "consts.inc"
#include "stones.inc" 
#include "glass.inc" 
#include "functions.inc"
#include "dh-herotree.inc"


#declare r_finerend=1;              //what to render
#declare r_athmosphere=1;
#declare r_radiosity=1;
#declare r_fakeveget=1;
#declare r_planet=1;   
#declare r_objects=1;       
#declare p_radius=50000;            
#declare p_rotation=<-2.9,8,0>;       //dont affects positions of objects!
#declare cam_pos=<7.5, 19.5, -93>;    
#declare cam_look=<9, 6, 00>;       
#declare vx=vrotate(x,p_rotation); 
#declare vy=vrotate(y,p_rotation); 
#declare vz=vrotate(z,p_rotation); 
#declare p_zerovec=vrotate(<0,p_radius,0>,p_rotation)-<0,p_radius,0>;
#declare px=p_zerovec.x;  
#declare py=p_zerovec.y; 
#declare pz=p_zerovec.z;
#declare s_position=<(455-400)/1.86 ,p_radius,(300-267)/1.86>; 
#declare sx=s_position.x;  
#declare sy=s_position.y; 
#declare sz=s_position.z; 
 
 #declare ts_leafsize=.5;       //initializing Tree Sub Constants
 #declare ts_leaves_br=3;
 #declare ts_treetype=1;
 #declare ts_lengthf=.5;   
 #declare ts_doubranchprob=0;
 #declare ts_gravity=<0,-.02,0>;
 #declare ts_staging=.5;
 #declare ts_angularity=.5;        
 #declare ts_spline=1;
 #declare ts_wood=1; //parse wood

// The Planetfunctions

  #declare fnear=   // Terrain shape function
  function{
    pigment {
    bozo
    turbulence 0.7
    octaves 5
    omega .3
    lambda 2.5
      color_map {
        [0.0 color rgb 0.0]
        [0.5 color rgb 0.8]
        [0.8 color rgb 0.9]
        [1.0 color rgb 1.0]
      }
      scale 58 
      translate <0,0, 0>
    }
  } 

  #undef fnveg
  #declare fnveg=   // vegetation shape function
  function{ 
    pigment {
    bozo
    turbulence 0.9
    octaves 5
    omega .99
    lambda 3.5
      color_map {
        [0.0 color rgb 0.0]
        [0.4 color rgb 0.3]
        [0.5 color rgb 0.7]
        [1.0 color rgb 1.0]
      }
      scale 15 
      translate <0,0, 0>
    }
  } 

  #declare fnvegmod=   // vegetation modification function
  function{ 
    pigment {
    bozo
    turbulence 0.9
    octaves 2
    omega .4
    lambda 2.5
      color_map {
        [0.0 color rgb 0.0]
        [0.4 color rgb 0.0]
        [0.8 color rgb 1.0]
        [1.0 color rgb 1.0]
      }
      scale 9 
      translate <0,0, -8>
    }
  } 


  #declare fnWat=   // water shape function
  function{
    pigment {
    bozo
    turbulence 0.0001
    octaves 1
    omega .1
    lambda 1.1
    color_map {
        [0.0 color rgb 0.0]
        [0.2 color rgb 0.5]
        [0.6 color rgb 0.8]
        [1.0 color rgb 1.0]
    }  scale 1   
      translate <0, 0, 0>
    }
  }
          
  #declare fnbugw=function{
  pow(atan(1/sqrt(.0001+pow((x+z*z/3),2)/8+z*z/8)),2)*cos(x+2+z*z/3)*.3}                  
  
  #declare fnheckw=function{
  pow(atan(1/sqrt(.0001+pow((x+abs(z)*3),2)/8+z*z/8)),2)*cos(x+2+abs(z)*3)*.3}  

  #declare fninflator=function{
  pow(atan(1/sqrt(.00001+pow(x/z,2)+pow(y/z,2))),.5)}  
  
  #declare fndeflator=function{
  1-pow(atan(1/sqrt(.00001+pow(x/z,2)+pow(y/z,2))),2)}  
 
  
                       
  #macro positer(vektor)
   #local Norm=<0,0,0>;
   #local vek0=vektor;
   #local vek1=trace(planet,vektor,y,Norm);
   #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
     #declare vek0=vek1;
    #else     
     #local vek1=trace(planet,vektor,-y,Norm);;
     #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
      #local vek0=vek1;
     #else     
      #local vek0=(vek0*2+vektor)/3;
     #end
    #end
   vek0
  #end

//   
 // radiosity (global illumination) settings
global_settings {    
max_trace_level   4+r_athmosphere*5+r_finerend*2+r_planet+r_objects+r_fakeveget

#if (r_radiosity)
  assumed_gamma 1.5
  radiosity {
    pretrace_start 0.06
    pretrace_end   0.012
    count 150
    always_sample off
    
    nearest_count 8
    error_bound 0.4
    recursion_limit 1

    low_error_factor .4
    gray_threshold 0.0
    minimum_reuse 0.04
    brightness 1
     media on
    adc_bailout 0.05}  }       //.0039
#else 
 adc_bailout 0.05     //.0039
}
 light_source { cam_pos, color rgb <2,2,2.2>*.3 //*1.5
  parallel
  point_at cam_look 
  shadowless
  media_interaction off   }
#end    



camera {                //                The Camera
  location cam_pos
  direction <0, 0, 1.5>
  sky <0,1,0>
  look_at cam_look
}



//
// Light source (Sun)

union{                                             /// union geocentric world
light_source {
  <0, 190000,0> color rgb 8 //10 
#if (r_finerend>1)  
  area_light  x*1667,y*1200,3,1
  adaptive 0
  //circular                   
  //orient   
  media_attenuation on
#end          
#if (r_athmosphere)
  looks_like{
    sphere { <0,0,0>,1 hollow on                
	interior {    media {method 3	samples 4 intervals 4 scattering {1, color rgb 0.00050 extinction 0} 
			density { spherical } }	} 
    pigment {color rgb 1  transmit 1}
    finish {reflection 0 diffuse 0 ambient 0}   
    scale 2000 }   }
#else
  looks_like{ sphere {<0,0,0>,2000 pigment{rgb <1,.6,.15>*1} finish { ambient 6}}}

#end    
  rotate <61,16,0>            //86//77    -35   -10
}

 
#if (r_athmosphere) 
// the athmosphere
 sphere { <0,0,0>,1
    hollow on                
  
	interior {
		media {
			method 3 samples 2 intervals 2 scattering {4, color rgb < 0.2, 0.5, 0.8>*0.002 extinction 5}   
			density { spherical } 
		}  		

	} 
    pigment {color rgb 0  transmit 1}
    finish {reflection 0 diffuse 0 ambient 0}   
    scale p_radius*1.0400
}        
// The Clouds    
    sphere { <0,0,0>,1.03
    hollow on                
  
	interior {
		media {
			method 3 samples 2 intervals 9 scattering {4, color rgb .006 extinction 7}                   
			density {
						        average
			        density_map{
			        [.50 spherical]
			        [.5        
			        bozo
                                        turbulence 0.5
                                        octaves 5
                                        omega .4 //49876
                                        lambda 4.5 //2.5432
                                        color_map {
                                          [0.0 color rgb 0]    
                                          [0.74 color rgb 0]
                                          [0.85 color rgb .5 ]
                                          [1.0 color rgb 1 ]  
                                          } scale 0.009  scale <1,.3,1> translate <10,0,0>       
    
                                ]}
                                } } 
		}  		
	 
    pigment {color rgb 0  transmit 1}
    finish {reflection 0 diffuse 0 ambient 0}   
    scale p_radius*1.04/1.03
  }
#else
#include "skies.inc"
sphere{ <0,0,0>,500000
hollow on  
interior{ ior 1}  
pigment {
        average
        pigment_map {
            [0.5 rgb <0.7, 0.6, 0.5> ]
            [0.8 P_Cloud1 scale 8000 ]
        }
    } finish {reflection 0 diffuse 0 ambient 2} hollow on }
#end
   
                       
    // the planet                   
  #declare planet=union{
  #if (r_planet) 
  isosurface {
    function { f_sphere(x, y, z, p_radius+34-(fnear(x, y, z).gray)*47) }
    max_gradient 4
    accuracy 0.02 
    contained_by { sphere { <0, 0, 0>, p_radius+26 } }  
    
   texture {
   pigment {      
             bozo              //attention: use almost the same as for fnear (the "height"field)!!
    turbulence 0.9 
    octaves 8      
    omega .499
    lambda 2.6  
        color_map {
        [0.0 color rgb 1]       //attention: zero is top, one is bottom
        [0.2 color rgb 0.3]
        [0.3 color rgb 0.3]
        [0.3 color rgb <0.35,0.3,.25>] 
        [0.4 color rgb <0.35,0.3,.25>]
        [0.41 color rgb <.15,0.35,0.25>]
        [0.5 color rgb <.15,0.35,0.25>]
        [0.51 color rgb <0.2,0.35,0.15>]
        [0.6 color rgb <0.2, 0.35, 0.15>] 
        [0.6 color rgb <.45, 0.4, 0.3>] 
        [0.7 color rgb <.45, 0.4, 0.3>] 
        [1.0 color rgb 0.3] //1]
     } scale 58 }            //attention: use almost the same as for fnear (the "height"field)!!
  finish { phong .5 phong_size 230 diffuse 0.5 }
  normal { granite 0.35 scale 0.0003  }          
} rotate p_rotation}  
   // The water surface
  isosurface {
     function { f_sphere(x, y, z, p_radius)+fnWat(x/2, y/2, z/2).gray*.2-
     fnbugw((x-sx)*1,y,(z-sz)*1)+fnheckw((x-sx)*1+20,y,(z-sz)*1) }          
    max_gradient 2
    accuracy 0.02
    contained_by { sphere { <0, 0, 0>, p_radius } }  
#if (r_finerend)  
    interior{ior Water_Ior media{absorption rgb<.2,.2,.2> }}
    pigment { rgb <.1,0.2,.3>*.3 filter .3 transmit .3}
#else
    pigment { rgb <.1,0.2,.3>*.3}
#end  
    finish {phong 1 phong_size 230 reflection .32 diffuse .38 ambient 0 }
    translate -s_position 
    rotate <0,-10,0>                           //rotate bug wave to assumed moving direction
    translate s_position
  }
  #else
   sphere  { <0,0,0>,p_radius pigment{ color rgb .5}}
  #end

 }  
                    
                  
   object{planet}  
                                                                   

 
 #if (r_objects) 
  #include "../cadpov/m_fairytree_tex.pov" 


  union{
 #include "../cadpov/fairyboat.pov"
 
 union{                                         
 #include "../spatch/kutte.pov"
 texture { Stone }
 rotate <0,90,0>
 scale <140,-140,140>
 rotate <-90,0,0>
 translate <-434.113030, -47.283650, 46.503049>}
 
   rotate <90,0,0>
   rotate <0,-10,0>
scale <.015,-.015,.015>
translate positer(s_position)
}



#declare ts_gravity=<0,-.11,0>;                                                                                                            
 #declare ts_spline=15;
 #declare ts_leaves_br=5;
#declare ts_leafsize=1;
#declare ts_doubranchprob=.55; 

#local pos1=<(420-400)/1.86 ,p_radius,(300-480)/1.86>;
#local pos2=positer(pos1);

   
// treetype: 1 faked leaves 2 leaves 3 clean 4 faked pine 5 pine with needles 6 normal tree with needles
    //tree(posvec,dir_vec,help_rot_vec,br_rad,br_leng,x_ang,rot_ang,stage,angularity,staging,lfactor,treetype)
  
    //tree right boarder
   tree(positer(<(439-400)/1.86 ,p_radius,(300-418)/1.86 >),<-.1,2,0>,<.5,0,1>,.40,1.38,47,135,240,1,1,0.2,2)       



#declare leaf2ob=height_field { gif "blatt-eiche.gif"  smooth        // smooth surface normal
  water_level 90/256 // truncate/clip below N (0.0 ... 1.0)
  
   translate <0,0-90/256,0> scale <1,.05,1> rotate <0,-45,0> 
  }
   #declare t_ltree=
  texture {
    pigment {
      bozo
      color_map {  
        [0.0 color rgb 1]
        [0.1 color rgb <0.5, 0.7, 0.20>]
        [0.2 color rgb <0.2, 0.5, 0.10> ]
        [0.4 color rgb <0.4, 0.6, 0.15>*2 ]
        [0.9 color rgb <0.4, 0.6, 0.15> ]
        [1 color rgb <0.4, 0.2, 0.05>*2 ]
      }
      scale 0.05
      warp { turbulence 0.9 }
    }
    finish {
      specular .5
      diffuse 0.7  
      ambient 0  
    }
    normal {
      wrinkles 0.2
      scale 0.05
    }
  } 

  #declare ts_gravity=<-.001,-.1,0>;                                                                                                            
 #declare ts_spline=10;
 #declare ts_leaves_br=5;
#declare ts_leafsize=.4;
 #declare ts_doubranchprob=.68;
    //bush 
   tree(positer(<(406.2-400)/1.86 ,p_radius,(300-425)/1.86 >),<0,.03,0>,<0,0,1>,.08,.35,32,110,180,1,.5,-.1,2)

 union{
 union{
 #include "../cadpov/fairytow.pov"
 interior { ior 1.5}  }
 #include "../cadpov/fairywater.pov"
 #include "../cadpov/fairywatfog.pov"
 #include "../cadpov/fairytragw.pov"
 
   rotate <90,0,0>
   rotate <0,-140,0>
scale <.003,-.003,.003>
translate positer(<(418-400)/1.86 ,p_radius,(300-185)/1.86 >)
}



   union{
 #include "../cadpov/fairytree.pov"
 #include "../cadpov/fairytree_tru.pov"
 #include "../cadpov/stonerose.pov"
  #include "..\poser\sitha1.inc"
  #include "..\poser\sitha1hair.inc"


 #declare ts_gravity=<0,0,-0.1>;  
 #declare ts_doubranchprob=.2; 
  #declare ts_spline=15;
  #declare ts_leafsize=8;
  #declare ts_leaves_br=1;     
 #declare ts_treetype=2;
 #declare ts_lengthf=.15;
 #declare ts_staging=.7;
 #declare ts_angularity=.5;  
 #declare ts_wood=1; //parse wood
 union{
blob{   threshold 1  
   sphere{<-0.398423, 1.245990, 2474.499570>,50*1.5,3 } 
  twood(<-0.398423, 1.245990, 2474.499570>,<0,0,300>,<0,-1,0>,40,150,50,120,190)

  texture{T_Grnt9 scale 20 }
  }        
  #declare ts_wood=0; //parse leaves
  #debug "parsing leaves \n"
  twood(<-0.398423, 1.245990, 2474.499570>,<0,0,300>,<0,-1,0>,40,150,50,120,190)
  }
  
  union{ 
  union{
  #include "..\spatch\schleier1.pov"
  texture { segeltuch }
  rotate <0,187,0>
  translate <0.04,-.23,.26>
  rotate <-1,0,2>
  scale 3.03
  }
 
  object{ sitha1 }
  object{ sitha1hair }
  scale <1,-1,1>
  rotate <-90,0,0>
  scale 36

  translate <-0.398423, -434.200864, 2220.267570>}
  
  
  
   rotate <90,0,0>
   rotate <0,-140,0>
scale <.005,-.005,.005>
translate positer(<(399-400)/1.86 ,p_radius,(300-425)/1.86 >)+<1.5,-1.5,0>
} 

  #declare pos1=positer(<(399-400)/1.86 ,p_radius,(300-427)/1.86 >);      
 
   #declare xcnt=4;
   #while (xcnt>0)     
   
  #declare gs_detailed=1;
  #declare ycnt=4+xcnt*3;
  #while (ycnt>0)   
   #debug concat("  parsing gras ",str(ycnt,4,0),"\n")
   #declare pos2=positer(pos1+vrotate(<0,0,xcnt/3>,<0,360*ycnt/(7+xcnt*3),0>));
   #declare pos2=pos2+<pos2.x-pos1.x,0,0>;
   bgras(pos2,(1.5-xcnt*.2),.5,.05,12)
   #declare ycnt=ycnt-1;
  #end 
    #declare xcnt=xcnt-1;
   #end 
 
   
  #end   

#local pos1=<(420-400)/1.86 ,p_radius,(300-480)/1.86>;
#local pos2=positer(pos1);
#declare px=pos2.x+5;
#declare pz=pos2.z+9;

                                                   
  #if (r_fakeveget)
 isosurface {
   
     function { f_sphere(x, y, z, p_radius+34)+(fnear(x, y+.8+fnvegmod(x,y,z).gray, z).gray)*47+.8+fnvegmod(x,y,z).gray-fnveg(x*6, (y+fnvegmod(x,y,z).gray)/15, z*6).gray*1.4 } //   
    max_gradient 5//2//7 
    accuracy 0.002 //.02
    contained_by { sphere { <0, 0, 0>, p_radius+26 } }  
    
  texture {
    pigment {
      agate
      color_map {  
 
        [0.0 color rgb <0.2, 0.5, 0.10> ]
        [0.3 color rgb <0.2, 0.6, 0.2> ]
        [0.5 color rgb <0.4, 0.3, 0.05> ]
        [0.7 color rgb <0.4, 0.6, 0.15> ]
        [0.9 color rgb <0.3, 0.7, 0.2> ]
        [1 color rgb <0.05, 0.3, 0.2> ]
      } warp { turbulence 0.9 }
      scale 15 
       }
    finish {
      diffuse 0.7  phong .5 phong_size 230 //0.5
      }
    normal {
      wrinkles 0.6 turbulence 0.9
      scale 0.5
    }  } rotate p_rotation   }   
 #end                        


 translate <0,-p_radius,0>
 }
  
               
 
