// Persistence of Vision Ray Tracer Scene Description File
// File: julia.inc
// Vers: 3.5
// Desc: CreateFractal macro
// Date: 2003/03/30
// Auth: Maurizio Tomasi
//

#version 3.5;

/* Create a random julia fractal fully contained in box { -0.5, 0.5 } */

#macro CreateFractal (RndSeed)
    //#local Delta = 0.6;
    #local Obj =
        julia_fractal {
            <-0.033 + 0.01 * (rand(RndSeed) - 0.5),
             -0.6 + 0.1 * (rand(RndSeed) - 0.5), //Delta * (rand(RndSeed) - 0.5),
             -0.9 + 0.04 * (rand(RndSeed) - 0.5), //Delta * (rand(RndSeed) - 0.5),
             -0.025 + 0.01 * (rand(RndSeed) - 0.5)>
            quaternion
            cube
            max_iteration 4
            precision 50
        }
        
    object
    {
        Obj
        
        #local Pt1 = min_extent (Obj);
        #local Pt2 = max_extent (Obj);
        
        scale <1/(Pt2.x - Pt1.x), 1/(Pt2.y - Pt1.y), 1/(Pt2.z - Pt1.z)>
        rotate 90*y
    }
#end
