// Persistence of Vision Ray Tracer Scene Description File
// File: cards.inc, cards.png
// Vers: 3.5
// Desc: card house mesh
// Date: 04/02/03
// Auth: J Moore
//
// textures for jack, queen, king and back of card adapted from Pysol 4.80
// original copyright below
//
//   Copyright (C) 1997 John Fitzgibbon
//   Copyright (C) 1997 Jochen Tuchbreiter <whynot@mabi.de>
//   Copyright (C) 1998 Markus F.X.J. Oberhumer <markus.oberhumer@jk.uni-linz.ac.at>
//
// This cardset is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the license, or (at your option) any later version.

#declare sc=0.08;
#declare t_cardface=
texture {
	uv_mapping pigment {image_map {png "cardtext.png" interpolate 2}}
	finish {specular 0.4 roughness 0.05 ambient 1.2}
	scale <13*sc, 5*sc*1.5, 1>
}

#declare t_cardside=
texture {
	pigment {rgb 1}
	finish {specular 0.4 roughness 0.05 ambient 1.2}
}

#declare cardhouse1=
mesh {
	#include "cardmesh1.inc"
}

#declare cardhouse2=
mesh {
	#include "cardmesh2.inc"
}

//--------------------------------------------------------------------------------------
//
// create mesh of a single card
//   use cardhouse_mesh_maker.pov to create single meshes of cardhouses
//   to reduce system resources usage
// usage-
//
//   mesh {card (suit, card, back, scale, transform {transformations})}
//
//   suit= 0 to 3
//   card= 0 (ace) to 12 (king)
//   back= texture of back of card (0 to 0 until somebody adds more to cardtext.png")
//   scale= scaling value for x axis of card (y axis will be 1.5 times this value)
//   transform{...}= transformations of card

#macro corner(tr1, tr2)
	
	#local t_cardface=
	texture {
		uv_mapping pigment {image_map {png "cardtext.png" interpolate 2}}
		finish {specular 0.4 roughness 0.05}
		scale <13*sc, 5*sc*1.5, 1>
	}

	#local t_cardside=
	texture {
		pigment {rgb 1}
		finish {specular 0.4 roughness 0.05}
	}
	
	#local tr=transform {tr1 tr2}
	#local p00=<0, 0, -0.01*sc>;
	#local p10=<0.05*sc, 0, -0.01*sc>;
	#local p20=vtransform (<0.05*sc, 0, -0.01*sc>, transform {rotate z*30});
	#local p30=vtransform (<0.05*sc, 0, -0.01*sc>, transform {rotate z*60});
	#local p40=<0, 0.05*sc, -0.01*sc>;
	
	#local p01=<0, 0, 0.01*sc>;
	#local p11=<0.05*sc, 0, 0.01*sc>;
	#local p21=vtransform (<0.05*sc, 0, 0.01*sc>, transform {rotate z*30});
	#local p31=vtransform (<0.05*sc, 0, 0.01*sc>, transform {rotate z*60});
	#local p41=<0, 0.05*sc, 0.01*sc>;
	
	//front
	triangle {
		vtransform (p00, tr),
		vtransform (p10, tr),
		vtransform (p20, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (p00, tr),
		vtransform (p20, tr),
		vtransform (p30, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (p00, tr),
		vtransform (p30, tr),
		vtransform (p40, tr)
		texture {t_cardside}
	}
	
	//back
	triangle {
		vtransform (p01, tr),
		vtransform (p11, tr),
		vtransform (p21, tr)
		uv_vectors
		<bk*sx+vtransform (p01, tr1).x, 4*sy+vtransform (p01, tr1).y>,
		<bk*sx+vtransform (p11, tr1).x, 4*sy+vtransform (p11, tr1).y>,
		<bk*sx+vtransform (p21, tr1).x, 4*sy+vtransform (p21, tr1).y>
		texture {t_cardface}
	}
	triangle {
		vtransform (p01, tr),
		vtransform (p21, tr),
		vtransform (p31, tr)
		uv_vectors
		<bk*sx+vtransform (p01, tr1).x, 4*sy+vtransform (p01, tr1).y>,
		<bk*sx+vtransform (p21, tr1).x, 4*sy+vtransform (p21, tr1).y>,
		<bk*sx+vtransform (p31, tr1).x, 4*sy+vtransform (p31, tr1).y>
		texture {t_cardface}
	}
	triangle {
		vtransform (p01, tr),
		vtransform (p31, tr),
		vtransform (p41, tr)
		uv_vectors
		<bk*sx+vtransform (p01, tr1).x, 4*sy+vtransform (p01, tr1).y>,
		<bk*sx+vtransform (p31, tr1).x, 4*sy+vtransform (p31, tr1).y>,
		<bk*sx+vtransform (p41, tr1).x, 4*sy+vtransform (p41, tr1).y>
		texture {t_cardface}
	}
	
	//1st z block
	triangle {
		vtransform (p10, tr),
		vtransform (p20, tr),
		vtransform (p11, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (p20, tr),
		vtransform (p21, tr),
		vtransform  (p11, tr)
		texture {t_cardside}
	}
	
	//2nd z block
	triangle {
		vtransform (p20, tr),
		vtransform (p30, tr),
		vtransform (p21, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (p30, tr),
		vtransform (p31, tr),
		vtransform (p21, tr)
		texture {t_cardside}
	}
	
	//3nd z block
	triangle {
		vtransform (p30, tr),
		vtransform (p40, tr),
		vtransform (p31, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (p40, tr),
		vtransform (p41, tr),
		vtransform (p31, tr)
		texture {t_cardside}
	}
	
#end

#macro card(st, cd, bk, sc, tr)

	#local sx=sc;
	#local sy=sc*1.5;
	#local sz=sc*0.01;
	
	#local t_cardface=
	texture {
		uv_mapping pigment {image_map {png "cardtext.png" interpolate 2}}
		finish {specular 0.4 roughness 0.05}
		scale <13*sc, 5*sc*1.5, 1>
	}

	#local t_cardside=
	texture {
		pigment {rgb 1}
		finish {specular 0.4 roughness 0.05}
	}
	
	//top left corner
	corner (transform {rotate z*90 translate <sx*0.05, sy-sx*0.05, 0>}, tr)
	
	//top right corner
	corner (transform {translate <sx*0.95, sy-sx*0.05, 0>} tr)
	
	//bottom left corner
	corner (transform {rotate z*180 translate <sx*0.05, sx*0.05, 0>}, tr)
	
	//bottom right corner
	corner (transform {rotate z*270 translate <sx*0.95, sx*0.05, 0>}, tr)
	
	//back
	triangle {
		vtransform (<sx*0.05, 0+sx*0.05, sz>, tr),
		vtransform (<sx*0.95, 0+sx*0.05, sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr)
		uv_vectors
		<bk*sx+sx*0.05, 4*sy+sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>
		texture {t_cardface}
	}
	triangle {
		vtransform (<sx*0.05, 0+sx*0.05, sz>, tr),
		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr)
		uv_vectors
		<bk*sx+sx*0.05, 4*sy+sx*0.05>,
		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>
		texture {t_cardface}
	}
	
	//left back
	triangle {
		vtransform (<0, 0+sx*0.05, sz>, tr),
		vtransform (<sx*0.05, 0+sx*0.05, sz>, tr),
		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr)
		uv_vectors
		<bk*sx, 4*sy+sx*0.05>,
		<bk*sx+sx*0.05, 4*sy+sx*0.05>,
		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>
		texture {t_cardface}
	}
	triangle {
		vtransform (<0, 0+sx*0.05, sz>, tr),
		vtransform (<0, sy-sx*0.05, sz>, tr),
		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr)
		uv_vectors
		<bk*sx, 4*sy+sx*0.05>,
		<bk*sx, 4*sy+sy-sx*0.05>,
		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>
		texture {t_cardface}
	}
	
	//right back
	triangle {
		vtransform (<sx, sx*0.05, sz>, tr),
		vtransform (<sx*0.95, sx*0.05, sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr)
		uv_vectors
		<bk*sx+sx, 4*sy+sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>
		texture {t_cardface}
	}
	triangle {
		vtransform (<sx, sx*0.05, sz>, tr),
		vtransform (<sx, sy-sx*0.05, sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr)
		uv_vectors
		<bk*sx+sx, 4*sy+sx*0.05>,
		<bk*sx+sx, 4*sy+sy-sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>
		texture {t_cardface}
	}
	
	//top back
	triangle {
		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr),
		vtransform (<sx*0.95, sy, sz>, tr)
		uv_vectors
		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sy>
		texture {t_cardface}
	}
	triangle {
		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr),
		vtransform (<sx*0.05, sy, sz>, tr),
		vtransform (<sx*0.95, sy, sz>, tr)
		uv_vectors
		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>,
		<bk*sx+sx*0.05, 4*sy+sy>,
		<bk*sx+sx*0.95, 4*sy+sy>
		texture {t_cardface}
	}
	
	//bottom back -fix
	triangle {
		vtransform (<sx*0.05, sx*0.05, sz>, tr),
		vtransform (<sx*0.95, sx*0.05, sz>, tr),
		vtransform (<sx*0.95, 0, sz>, tr)
		uv_vectors
		<bk*sx+sx*0.05, 4*sy+sx*0.05>,
		<bk*sx+sx*0.95, 4*sy+sx*0.05>,
		<bk*sx+sx*0.95, 4*sy>
		texture {t_cardface}
	}
	triangle {
		vtransform (<sx*0.05, sx*0.05, sz>, tr),
		vtransform (<sx*0.05, 0, sz>, tr),
		vtransform (<sx*0.95, 0, sz>, tr)
		uv_vectors
		<bk*sx+sx*0.05, 4*sy+sx*0.05>,
		<bk*sx+sx*0.05, 4*sy>,
		<bk*sx+sx*0.95, 4*sy>
		texture {t_cardface}
	}
	
	//face
	triangle {
		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr)
		uv_vectors
		<cd*sx, st*sy>,
		<cd*sx+sx, st*sy>,
		<cd*sx+sx, st*sy+sy>
		texture {t_cardface}
	}
	triangle {
		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr)
		uv_vectors
		<cd*sx, st*sy>,
		<cd*sx, st*sy+sy>,
		<cd*sx+sx, st*sy+sy>
		texture {t_cardface}
	}
	
	//left front
	triangle {
		vtransform (<0, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (<0, 0+sx*0.05, -sz>, tr),
		vtransform (<0, sy-sx*0.05, -sz>, tr),
		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr)
		texture {t_cardside}
	}
	
	//right front
	triangle {
		vtransform (<sx, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (<sx, 0+sx*0.05, -sz>, tr),
		vtransform (<sx, sy-sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr)
		texture {t_cardside}
	}
	
	//top front
	triangle {
		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, sy, -sz>, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr),
		vtransform (<sx*0.05, sy, -sz>, tr),
		vtransform (<sx*0.95, sy, -sz>, tr)
		texture {t_cardside}
	}
	
	//bottom front
	triangle {
		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.95, 0, -sz>, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),
		vtransform (<sx*0.05, 0, -sz>, tr),
		vtransform (<sx*0.95, 0, -sz>, tr)
		texture {t_cardside}
	}
	
	//left
	triangle {
		vtransform (<0, sx*0.05, -sz>, tr),
		vtransform (<0, sx*0.05, sz>, tr),
		vtransform (<0, sy-sx*0.05, sz>, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (<0, sx*0.05, -sz>, tr),
		vtransform (<0, sy-sx*0.05, -sz>, tr),
		vtransform (<0, sy-sx*0.05, sz>, tr)
		texture {t_cardside}
	}
	
	//right
	triangle {
		vtransform (<sx, sx*0.05, -sz>, tr),
		vtransform (<sx, sx*0.05, sz>, tr),
		vtransform (<sx, sy-sx*0.05, sz>, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (<sx, sx*0.05, -sz>, tr),
		vtransform (<sx, sy-sx*0.05, -sz>, tr),
		vtransform (<sx, sy-sx*0.05, sz>, tr)
		texture {t_cardside}
	}
	
	//top
	triangle {
		vtransform (<sx*0.05, sy, -sz>, tr),
		vtransform (<sx*0.95, sy, -sz>, tr),
		vtransform (<sx*0.95, sy, sz>, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (<sx*0.05, sy, -sz>, tr),
		vtransform (<sx*0.05, sy, sz>, tr),
		vtransform (<sx*0.95, sy, sz>, tr)
		texture {t_cardside}
	}
	
	//bottom
	triangle {
		vtransform (<sx*0.05, 0, -sz>, tr),
		vtransform (<sx*0.95, 0, -sz>, tr),
		vtransform (<sx*0.95, 0, sz>, tr)
		texture {t_cardside}
	}
	triangle {
		vtransform (<sx*0.05, 0, -sz>, tr),
		vtransform (<sx*0.05, 0, sz>, tr),
		vtransform (<sx*0.95, 0, sz>, tr)
		texture {t_cardside}
	}

#end