// Persistence of Vision Ray Tracer Scene Description File
// File: hsh.pov
// Vers: 3.5
// Desc: Home (bitter)Sweet Home
// Date: 4/05/03
// Auth: James Moore
//
//--------------------------------------------------------

#include "shapes.inc"
#include "rand.inc"
#include "cardhouse.inc"
#include "bum.inc"
#declare sd=seed(11);

//--------------------------------------------------------
//	global settings
//--------------------------------------------------------

#declare hqrad=yes;
#declare cloudsamples=15;
#declare cloudintervals=1;
#declare hazesamples=15;
#declare hazeintervals=1;
global_settings {
	max_trace_level 10
	#if (hqrad)
		ambient_light 0.1
		radiosity {
			count 75
			error_bound 1
			pretrace_start 0.08
	    	pretrace_end 0.004
			distance_maximum 0.04
			brightness 1.4
			normal on
			media on
		}
	#else
		ambient_light 0.1
		radiosity {
			count 50
			error_bound 1.8
			pretrace_start 0.08
	    	pretrace_end 0.01
			distance_maximum 0.04
			brightness 1
			normal on
			media on
		}		
	#end
}

//--------------------------------------------------------
//	textures
//--------------------------------------------------------

#declare t_brick=
texture {
	pigment {
		brick
		pigment {rgbt 1}
		pigment {
			wrinkles
			warp {turbulence 0.5 omega 0.8 lambda 8}
			scale 5
			color_map {
				[0 rgb <0.7, 0.4, 0.3>]
				[0.5 rgb <0.8, 0.6, 0.5>]
				[1 rgb <0.45, 0.2, 0.1>]
			}
		}
		turbulence 0.2
		translate z*-1.5
	}
	normal {granite 0.1 scale 5}
	finish {specular 0.1 roughness 0.5}
	scale 0.03
}

#declare t_dirt=
texture {
	pigment {
		wrinkles
		warp {turbulence 0.1 omega 0.8 lambda 1}
		color_map {
			[0 rgbf <0.2, 0.15, 0, 0.9>]
			[0.5 rgbf 1]
		}
	}
	normal {wrinkles warp {turbulence 0.1 omega 0.8 lambda 1} scale 5}
	finish {specular 0.1 roughness 0.5}
}
		
#declare t_mortar=
texture {
	pigment {
		wrinkles scale 0.3
		color_map {
			[0 rgb 0.8]
			[1 rgb 0.65]
		}
	}
	normal {granite 0.1 turbulence 0.3 scale 0.1}
	finish {specular 0.1 roughness 0.5}
}

#declare m_window=
material {
	texture {
		pigment {rgbf <0.8, 0.9, 0.85, 0.85>}
		finish {specular 1 roughness 0.001 ambient 0 diffuse 0 reflection 0.1}
	}
	interior {ior 1.5 fade_distance 1.0 fade_power 2}
}

#declare t_rust=
texture {
	pigment {
		wrinkles
		turbulence 0.3 omega 0.7
		color_map {
			[0 rgb <0.6, 0.3, 0.1>]
			[1 rgb <0.5, 0.2, 0.05>]
		}
	}
	normal {granite 0.1 scale 0.05}
	finish {phong 0.1 phong_size 0.1 ambient 0}
}

#declare t_metal=
texture {
	pigment {rgb 0.1}
	finish {specular 0.2 roughness 0.1 metallic}
}

#declare t_rustmetal=
texture {
	wrinkles scale 0.2
	turbulence 0.3 omega 0.7
	texture_map {
		[0 t_rust]
		[0.4 t_metal]
		[0.6 t_metal]
		[1 t_rust]
	}
}

#declare t_step=
texture {
	pigment {
		wrinkles scale 0.2
		turbulence 0.3 omega 0.7
		color_map {
			[0 rgb <0.55, 0.25, 0.075>]
			[0.4 rgb 0.1]
			[0.6 rgb 0.1]
			[1 rgb <0.55, 0.25, 0.075>]
		}
	}
	finish {specular 0.2 roughness 0.1 metallic}
}

#declare t_ruststep=
texture {
	leopard
	scale 0.008
	texture_map {
		[0 t_step]
		[0.25 t_step]
		[0.25 pigment {rgbt 1}]
	}
}

#declare t_winframe=
texture {
	pigment {rgb <0.7, 0.5, 0.4>}
	finish {specular 0.2 roughness 0.1 metallic}
}

#declare t_rustframe=
texture {
	wrinkles scale 0.2
	turbulence 0.3 omega 0.7
	texture_map {
		[0 t_rust]
		[0.4 t_winframe]
		[0.7 t_winframe]
		[1 t_rust]
	}
}

#declare t_door=
texture {
	pigment {
		wrinkles scale 0.2
		turbulence 0.3 omega 0.7
		color_map {
			[0 rgb <0.55, 0.25, 0.075>]
			[0.4 rgb <0.7, 0.5, 0.4>]
			[0.6 rgb <0.7, 0.5, 0.4>]
			[1 rgb <0.55, 0.25, 0.075>]
		}
	}
	finish {specular 0.2 roughness 0.1 metallic}
}

#declare t_dump=
texture {
	pigment {rgb <0.15, 0.15, 0.25>}
	normal {dents 0.8 scale 0.8}
	finish {specular 0.2 roughness 0.1 metallic brilliance 2 reflection 0.05}
}

#declare t_rustdump=
texture {
	bozo scale 0.2
	turbulence 0.3 omega 0.7
	texture_map {
		[0 t_rust]
		[0.3 t_dump]
		[0.7 t_dump]
		[1 t_rust]
	}
}

#declare t_fence=
texture {
	pigment {
		wood
		turbulence 0.2 omega 0.8
		scale <0.1, 0.5, 0.1>
		color_map {
			[0 rgb <0.6, 0.5, 0.45>*0.5]
			[1 rgb <0.8, 0.7, 0.5>*0.25]
		}
	}
	normal {granite 0.1 scale 0.1}
	finish {phong 0.1 phong_size 20}
}

#declare t_canlabel1=
texture {
	pigment {
		image_map {png "canlabel1.png" interpolate 2 map_type 2}
		scale <1, 0.15, 1>
		rotate y*-90
	}
	normal {dents scale 0.05}
	finish {metallic specular 0.1 roughness 0.02 brilliance 2 reflection 0.05}
}

#declare t_canlabel2=
texture {
	pigment {
		image_map {png "canlabel2.png" interpolate 2 map_type 2}
		scale <1, 0.15, 1>
		rotate y*-90
	}
	normal {dents scale 0.05}
	finish {metallic specular 0.1 roughness 0.02 brilliance 2 reflection 0.05}
}

#declare t_beer=
texture {
	pigment {rgbf <0.7, 0.5, 0.1, 0.6>}
	finish {specular 1 roughness 0.001 reflection 0.1}
}

#declare t_wine=
texture {
	pigment {rgbf <0.4, 0.72, 0.4, 0.6>}
	finish {specular 1 roughness 0.001 reflection 0.1}
}

#declare p_paper=
pigment {
	wrinkles scale 0.3
	color_map {
		[0 rgb 0.8]
		[1 rgb <0.7, 0.7, 0.6>]
	}
}

#declare p_ink=
pigment {
	marble
	frequency 0.5
	turbulence 1 omega 0.8 lambda 1.5
	rotate y*90
	scale 0.1
	color_map {
		[0 rgb <0.75, 0.75, 0.7>]
		[0.5 rgb 0.8]
		[0.9 rgb 0.35]
		[1 rgb 0.25]
	}
}
	
#declare t_writing=
texture {
	pigment {
		average
		pigment_map {
			[0.5 p_paper]
			[1 p_ink]
		}
	}
	normal {wrinkles 0.1}
	finish {specular 0.1 roughness 0.8}
}

#declare t_blank=
texture {
	pigment {p_paper}
	normal {wrinkles 0.1}
	finish {specular 0.1 roughness 0.8}
}

#declare t_page=
texture {
	boxed
	scale <0.3, 1, 0.4>*1.7
	texture_map {
		[0 t_blank]
		[0.1 t_writing]
	}
}

#declare t_box=
texture {
	pigment {
		wrinkles
		scale 0.3
		color_map {
			[0 rgb <0.9, 0.7, 0.5>]
			[0.5 rgb <0.9, 0.7, 0.5>*0.65]
			[1 rgb <0.9, 0.7, 0.5>]
		}
	}
	normal {wrinkles 0.2 scale 0.4}
	finish {phong 0.05 phong_size 30 ambient 0.001}
}

#declare t_paint=
texture {
	pigment {red 0.2}
}

#declare t_flap=
texture {
	material_map {
		png "flap.png" interpolate 2
		texture {t_paint}
		texture {t_box}
	}
	translate <-0.5, 0, 0>
	scale <0.8, 0.4, 1>
	rotate x*90
}

#declare t_bldgint=
texture {
	pigment {rgb <0.9, 0.9, 0.85>*0.2}
	finish {specular 0.5 roughness 0.15}
}

//--------------------------------------------------------
//	objects
//--------------------------------------------------------

#declare gnd=
plane {y, 0
	texture {
		pigment {
			granite
			scale 0.1
			color_map {
				[0 rgb 0.1]
				[0.1 rgb 0.1]
				[0.3 rgb 0.2]
				[1 rgb 0.2]
			}
		}
		normal {granite 0.15 scale 0.1}
		finish {phong 0.5 phong_size 30 specular 0.2 roughness 0.05}
	}
	texture {
		pigment {
			wrinkles scale 2
			warp {turbulence 0.1 omega 0.8 lambda 1}
			color_map {
				[0.25 rgbt 1]
				[1 rgbf <0.2, 0.15, 0, 0.5>]
			}
		}
		normal {wrinkles warp {turbulence 0.1 omega 0.8 lambda 1} scale 5}
		finish {specular 0.1 roughness 0.5}
	}
}

//--------------------------------------------------------

sky_sphere {
	pigment {
		planar
		color_map {
			[0.4 rgb 0.05]
			[1 blue 0.1]
		}
	}
}

#declare d_air=
density {
	wrinkles
	density_map {
		[0 rgb 0.01]
		[1 rgb 0.025]
	}
}
//#declare d_air=density {rgb 0.1}

#declare d_clouds=
density {
	wrinkles
	scale 0.01
	warp {turbulence 0.1 omega 0.3 lambda 8}
	scale 75
	density_map {
		[0 rgb 0]
		[0.5 rgb 0]
		[0.7 rgb 0.1]
		[1 rgb 0.2]
	}
}

#declare haze=
sphere {0, 50
	hollow
	pigment {rgbt 1}
	interior {
		media {
			method 3
			intervals hazeintervals
			samples hazesamples, hazesamples
			scattering {2, 1}
			absorption 0.1
			density {d_air}
		}
	}
	scale <1, 0.5, 1>
}

#declare clouds=
sphere {0, 50
	hollow
	double_illuminate
	pigment {rgbt 1}
	interior {
		media {
			method 3
			intervals cloudintervals
			samples cloudsamples, cloudsamples
			scattering {4, 1}
			absorption <0.75, 0.75, 0.5>
			density {
				spherical
				density_map {
					[0 rgb 0]
					[0.1 d_clouds]
					[0.5 d_clouds]
					[0.55 rgb 0]
					[1 rgb 0]
				}
				rotate x*10
				scale 50
			}
		}
	}
	scale <1, 0.5, 1>
}

//--------------------------------------------------------

#declare window=
union {
	
	//sill
	box {<-0.05, 0.425, 0>, <0.06, 0.5, 0.5> texture {t_brick} texture {t_dirt}}
	
	//window
	difference {
		box {<-0.02, 1, 0>, <0, 1.5, 0.5>}
		box {<-1, 1.02, 0.02>, <1, 1.48, 0.48>}
		texture {t_rustframe}
	}
	difference {
		box {<0, 0.5, 0>, <0.02, 1.01, 0.5>}
		box {<-1, 0.52, 0.02>, <1, 0.99, 0.48>}
		texture {t_rustframe}
	}
	box {<-0.01, 0.99, -0.01>, <-0.005, 1.51, 0.51> material {m_window}}
	box {<0.005, 0.49, -0.01>, <0.01, 1, 0.51> material {m_window}}
	
	//bars
	union {
		cylinder {<-0.08, 0.4, 0.05>, <-0.08, 1.6, 0.05>, 0.01}
		cylinder {<-0.08, 0.4, 0.15>, <-0.08, 1.6, 0.15>, 0.01}
		cylinder {<-0.08, 0.4, 0.25>, <-0.08, 1.6, 0.25>, 0.01}
		cylinder {<-0.08, 0.4, 0.35>, <-0.08, 1.6, 0.35>, 0.01}
		cylinder {<-0.08, 0.4, 0.45>, <-0.08, 1.6, 0.45>, 0.01}
		cylinder {<-0.08, 0.7, 0>, <-0.08, 0.7, 0.5>, 0.01}
		cylinder {<-0.08, 0.7, 0.5>, <0, 0.7, 0.6>, 0.01}
		cylinder {<-0.08, 0.7, 0>, <0, 0.7, -0.1>, 0.01}
		cylinder {<-0.08, 1.3, 0>, <-0.08, 1.3, 0.5>, 0.01}
		cylinder {<-0.08, 1.3, 0>, <0, 1.3, -0.1>, 0.01}
		cylinder {<-0.08, 1.3, 0.5>, <0, 1.3, 0.6>, 0.01}
		texture {t_rustmetal}
	}
}

//--------------------------------------------------------

#declare bldg1min= <-5, 0, -5>;
#declare bldg1max= <5, 10, 8>;
#declare bldg2min= <-5, 0, -5>;
#declare bldg2max= <5, 10, 8>;
#declare mortaroffset= <0.01, 0, 0.01>;
#declare baseoffset= <0.015, 0.26, 0.015>;

#declare bldg1=
union {
	
	//main bldg object
	difference {
		union {
			
			//bricks
			object {
				Round_Box_Merge (bldg1min, bldg1max, 0.005)
				texture {t_brick translate y*baseoffset.y}
				texture {t_dirt}
			}
			
			//mortar
			box {bldg1min+mortaroffset, bldg1max-mortaroffset
				texture {t_mortar}
			}
			
			//base
			object {
				Round_Box_Merge (bldg1min-baseoffset, <bldg1max.x+baseoffset.x, baseoffset.y, bldg1max.z+baseoffset.z>, 0.01)
				texture {t_mortar}
				texture {t_dirt}
			}
		}
		
		//interior of building
		union {
			box {bldg1min+0.06, bldg1max-0.06}
			box {<bldg1min.x+0.06, 3.2, bldg1min.z+0.06>, <bldg1max.x-0.06, 3.4, bldg1max.z-0.06>}
			texture {t_bldgint}
		}
		
		//doorway
		object {
			Round_Box_Merge (<-0.5, 0, -1>, <0.5, 1.85, 1>, 0.005)
			texture {t_brick}
			rotate y*-90 translate <bldg1max.x, 0.75, 4>
		}
		
		//cutout for windows - transformations here = transformations of windows
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} rotate y*180 translate <bldg1max.x, 0.75, -3>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} rotate y*180 translate <bldg1max.x, 0.75, 2>}
	}
	
	//windows
	object {window rotate y*180 translate <bldg1max.x-0.03, 0.75, -3>}
	object {window rotate y*180 translate <bldg1max.x-0.03, 0.75, 2>}
	
	//emitting media for interior lights - faster than additional light source
	box {<bldg1min.x+0.06, 0.01, bldg1min.z+0.06>, <bldg1max.x-0.06, 3.19, bldg1max.z-0.06>
		hollow
		pigment {rgbt 1}
		interior {
			media {
				method 3
				intervals 1
				samples 3, 3
				emission <1, 1, 0.9>
				density {rgb 0.05}
			}
		}
		translate <-7, 0, 0>
	}
	
	//steps, door & light
	union {
		
		//frame and door
		union {
			Round_Box_Merge (<-0.5, 1.75, -0.02>, <0.5, 1.85, 0.02>, 0.005)
			Round_Box_Merge (<-0.5, 0, -0.02>, <-0.4, 1.85, 0.02>, 0.005)
			Round_Box_Merge (<0.5, 0, -0.02>, <0.4, 1.85, 0.02>, 0.005)
			//Round_Box_Merge (<-0.39, 0.01, -0.01>, <0.39, 1.74, 0.01>, 0.005)
			union {
				object {
					Round_Box_Merge (<-0.78, 0.01, -0.01>, <0, 1.74, 0.01>, 0.005)
					texture {t_door}
					texture {t_dirt}
				}
				
				union {
					//knob
					box {<-0.35, 0.875-0.1, -0.011>, <-0.25, 0.875+0.1, 0.011>}
					cylinder {<-0.3, 0.85, -0.075>, <-0.3, 0.85, 0.075>, 0.02}
					Round_Cylinder_Merge (<-0.3, 0.85, -0.075>, <-0.3, 0.85, -0.045>, 0.03, 0.01)
					Round_Cylinder_Merge (<-0.3, 0.85, 0.075>, <-0.3, 0.85, 0.045>, 0.03, 0.01)
			
					//lock
					cylinder {<-0.3, 0.93, -0.02>, <-0.3, 0.93, 0.02>, 0.025}
			
					pigment {rgb 0.9}
					finish {metallic brilliance 5 specular 0.3 roughness 0.05 reflection 0.2}
					translate <-0.39, -0.1, 0>
				}
				rotate y*-120
				translate x*0.39
			}
				
			//box {<-0.4, 0, -0.001>, <0.4, 1.75, 0> pigment {rgb 0}}	//box to keep light from shining through
			texture {t_door}
			texture {t_dirt}
		}
		
		//hinges
		union {
			cylinder {<0.4, 1.44-0.03, -0.01>, <0.4, 1.44+0.03, -0.01>, 0.015}
			cylinder {<0.4, 0.875-0.03, -0.01>, <0.4, 0.875+0.03, -0.01>, 0.015}
			cylinder {<0.4, 0.31-0.03 -0.01>, <0.4, 0.31+0.03, -0.01>, 0.015}
			pigment {rgb 0.9}
			finish {metallic brilliance 5 specular 0.3 roughness 0.05 reflection 0.2}
		}
		
		//steps
		union {
			Round_Box_Merge (<-0.6, -1, -1.2>, <0.8, 0, 0>, 0.02)
			Round_Box_Merge (<-0.8, -1, -1.2>, <0.8, -0.15, 0>, 0.02)
			Round_Box_Merge (<-1, -1, -1.2>, <0.8, -0.3, 0>, 0.02)
			Round_Box_Merge (<-1.2, -1, -1.2>, <0.8, -0.45, 0>, 0.02)
			Round_Box_Merge (<-1.4, -1, -1.2>, <0.8, -0.6, 0>, 0.02)
			Round_Box_Merge (<-1.6, -1, -1.2>, <0.8, -0.76, 0>, 0.02)
			texture {
				pigment {
					wrinkles scale 0.3
					color_map {
						[0 rgb 0.65]
						[1 rgb 0.5]
					}
				}
				normal {
					average
					normal_map {
						[0.1 granite turbulence 0.3 scale 0.1]
						[1 dents 0.8 turbulence 0.2 omega 0.8 lambda 1.2 scale 0.5]
					}
				}
				finish {specular 0.1 roughness 0.5}
			}
			texture {t_dirt}
		}
		
		//railing
		union {
			cylinder {<0.75, 0.875, 0>, <0.75, 0.875, -1.15>, 0.03}
			sphere {<0.75, 0.875, -1.15>, 0.03}
			cylinder {<0.75, 0.875, -1.15>, <-0.6, 0.875, -1.15>, 0.03}
			sphere {<-0.6, 0.875, -1.15>, 0.03}
			cylinder {<-0.6, 0.875, -1.15>, <-1.6, 0.125, -1.15>, 0.03}
			sphere {<-1.6, 0.125, -1.15>, 0.03}
			
			cylinder {<0.75, 0.4, 0>, <0.75, 0.4, -1.15>, 0.03}
			sphere {<0.75, 0.4, -1.15>, 0.03}
			cylinder {<0.75, 0.4, -1.15>, <-0.6, 0.4, -1.15>, 0.03}
			sphere {<-0.6, 0.4, -1.15>, 0.03}
			cylinder {<-0.6, 0.4, -1.15>, <-1.5, -0.2, -1.15>, 0.03}
			
			cylinder {<0.75, -1, -0.2>, <0.75, 0.875, -0.2>, 0.03}
			cylinder {<0.75, -1, -0.9>, <0.75, 0.875, -0.9>, 0.03}
			cylinder {<0.5, -1, -1.15>, <0.5, 0.875, -1.15>, 0.03}
			cylinder {<-0.4, -1, -1.15>, <-0.4, 0.875, -1.15>, 0.03}
			cylinder {<-0.95, -1, -1.15>, <-0.95, 0.6125, -1.15>, 0.03}
			cylinder {<-1.5, -1, -1.15>, <-1.5, 0.2, -1.15>, 0.03}
			
			texture {t_rustmetal}
		}
		
		//light
		union {
			Round_Box_Merge (<-0.04, -0.05, 0.2>, <0.04, 0.05, 0.13>, 0.01)
			cone {<0, 0.035, 0>, 0.015, <0, 0.035, 0.15>, 0.03}
			cylinder {<0, 0.01, 0>, <0, 0.065, 0>, 0.06}
			difference {
				sphere {0, 0.1}
				sphere {0, 0.098 pigment {rgb 1}}
				clipped_by {plane {y, 0 inverse}}
				scale <1, 0.33, 1>
			}
			light_source {y*-0.06 color rgb <0.25, 0.25, 0.2>
				fade_distance 5
				fade_power 1
				media_attenuation off
				media_interaction on
				looks_like {
					sphere {0, 0.1
						hollow
						pigment {rgbf <0.8, 0.9, 0.85, 0.85>}
						finish {specular 1 roughness 0.001 ambient 0 diffuse 0 reflection 0.1}
						interior {
							ior 1.5
							media {
								method 3
								intervals 1
								samples 1, 1
								emission 5
							}
						}
					}
				}
			}			
			pigment {rgb 0.1}
			translate <-0.7, 1.7, -0.15>
		}
		
		//transformations
		rotate y*-90 translate <bldg1max.x, 0.75, 4>
	}
}

//--------------------------------------------------------

#declare bldg2=
union {

	//main bldg object
	difference {
		union {
			
			//bricks
			object {
				Round_Box_Merge (bldg1min, bldg1max, 0.005)
				texture {t_brick translate y*baseoffset.y}
				texture {t_dirt}
			}
			
			//mortar
			box {bldg1min+mortaroffset, bldg1max-mortaroffset
				texture {t_mortar}
			}
			
			//base
			object {
				Round_Box_Merge (bldg1min-baseoffset, <bldg1max.x+baseoffset.x, baseoffset.y, bldg1max.z+baseoffset.z>, 0.01)
				texture {t_mortar}
				texture {t_dirt}
			}
		}
		
		//interior of building
		box {bldg1min+0.06, bldg1max-0.06
			texture {t_bldgint}
		}
		
		//cutout for windows - transformations here = transformations of windows
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 2.3, 2>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 4.6, 2>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 6.9, 2>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 2.3, -2>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 4.6, -2>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 6.9, -2>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 2.3, 6>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 4.6, 6>}
		box {<-1, 0.5, 0>, <1, 1.5, 0.5> texture {t_brick} translate <bldg1min.x, 6.9, 6>}
	}
	
	//windows
	object {window translate <bldg1min.x+0.03, 2.3, 2>}
	object {window translate <bldg1min.x+0.03, 4.6, 2>}
	object {window translate <bldg1min.x+0.03, 6.9, 2>}
	object {window translate <bldg1min.x+0.03, 2.3, -2>}
	object {window translate <bldg1min.x+0.03, 4.6, -2>}
	object {window translate <bldg1min.x+0.03, 6.9, -2>}
	object {window translate <bldg1min.x+0.03, 2.3, 6>}
	object {window translate <bldg1min.x+0.03, 4.6, 6>}
	object {window translate <bldg1min.x+0.03, 6.9, 6>}
	
	//fire escape
	#declare ladderangle=60;
	#declare stepangle=90-ladderangle;
	#declare fire_esc=
	union {
		
		//floor
		union {
			cylinder {<0.6, 2.3, -0.92>, <0.6, 2.3, 2.2>, 0.02}
			cylinder {<0.5, 2.3, -0.92>, <0.5, 2.3, 2.2>, 0.02}
			cylinder {<0.4, 2.3, -0.92>, <0.4, 2.3, 2.2>, 0.02}
			cylinder {<0.3, 2.3, -0.92>, <0.3, 2.3, 2.2>, 0.02}
			cylinder {<0.2, 2.3, -0.92>, <0.2, 2.3, 2.2>, 0.02}
			cylinder {<0.1, 2.3, -0.92>, <0.1, 2.3, 2.2>, 0.02}
			cylinder {<0, 2.3, -0.92>, <0, 2.3, 2.2>, 0.02}
			cylinder {<-0.1, 2.3, -0.92>, <-0.1, 2.3, 2.2>, 0.02}
			cylinder {<-0.2, 2.3, -0.92>, <-0.2, 2.3, 2.2>, 0.02}
			cylinder {<-0.3, 2.3, -0.92>, <-0.3, 2.3, 2.2>, 0.02}
			cylinder {<-0.4, 2.3, -0.92>, <-0.4, 2.3, 2.2>, 0.02}
			cylinder {<-0.5, 2.3, -0.92>, <-0.5, 2.3, 2.2>, 0.02}
			cylinder {<-0.6, 2.3, -0.92>, <-0.6, 2.3, 2.2>, 0.02}
			clipped_by {box {<-0.65, 0, -0.1>, <0.05, 10, 1.4> inverse}}
		}
		
		sphere {<-0.7, 2.3, -0.9>, 0.02}
		sphere {<-0.7, 2.3, 2.2>, 0.02}
		sphere {<0.7, 2.3, -0.9>, 0.02}
		sphere {<0.7, 2.3, 2.2>, 0.02}
		cylinder {<-0.7, 2.3, -0.9>, <-0.7, 2.3, 2.2>, 0.02}
		cylinder {<0.7, 2.3, -0.9>, <0.7, 2.3, 2.2>, 0.02}		
		cylinder {<-0.7, 2.3, -0.9>, <0.7, 2.3, -0.9>, 0.02}
		cylinder {<-0.7, 2.3, 2.2>, <0.7, 2.3, 2.2>, 0.02}
		
		cylinder {<-0.7, 2.3, -0.1>, <0.7, 1.5, -0.1>, 0.02}
		cylinder {<-0.7, 2.3, 1.4>, <0.7, 1.5, 1.4>, 0.02}
		cylinder {<-0.7, 2.3, 2.2>, <0.7, 1.5, 2.2>, 0.02}
		cylinder {<-0.7, 2.3, -0.9>, <0.7, 1.5, -0.9>, 0.02}
		
		cylinder {<-0.7, 2.28, -0.1>, <0.7, 2.28, -0.1>, 0.02}
		cylinder {<-0.7, 2.28, 1.4>, <0.7, 2.28, 1.4>, 0.02}
		cylinder {<-0.7, 2.28, 2.2>, <0.7, 2.28, 2.2>, 0.02}
		cylinder {<-0.7, 2.28, -0.9>, <0.7, 2.28, -0.9>, 0.02}
		
		//rail
		cylinder {<-0.7, 3.1, -0.9>, <0.7, 3.1, -0.9>, 0.02}
		cylinder {<-0.7, 3.1, 2.2>, <0.7, 3.1, 2.2>, 0.02}
		sphere {<-0.7, 3.1, -0.9>, 0.02}
		sphere {<-0.7, 3.1, 2.2>, 0.02}
		cylinder {<-0.7, 3.1, -0.9>, <-0.7, 3.1, 2.2>, 0.02}
		
		#declare c=0.6;
		#while (c>-0.7)
			cylinder {<0, 2.3, -0.9>, <0, 3.1, -0.9>, 0.02 translate x*c}
			cylinder {<0, 2.3, 2.2>, <0, 3.1, 2.2>, 0.02 translate x*c}
			#declare c=c-0.1;
		#end
		
		#declare c=-0.9;
		#while (c<2.3)
			cylinder {<-0.7, 2.3, 0>, <-0.7, 3.1, 0>, 0.02 translate z*c}
			#declare c=c+0.1;
		#end
						
		//ladder
		union {
			
			//laddersides
			difference {
				box {<-0.3, -0.07, -4>, <0.3, 0.07, 4>}
				box {<-0.27, -1, -5>, <0.27, 1, 5>}
				plane {z, 0 rotate x*-stepangle}
				plane {-z, 0 rotate x*-stepangle translate z*2.7}
			}
			
			//ladder steps
			box {<-0.27, -0.1, -0.01>, <0.27, 0.1, 0.01> texture {t_ruststep} rotate x*-stepangle translate z*0.3}
			box {<-0.27, -0.1, -0.01>, <0.27, 0.1, 0.01> texture {t_ruststep} rotate x*-stepangle translate z*0.6}
			box {<-0.27, -0.1, -0.01>, <0.27, 0.1, 0.01> texture {t_ruststep} rotate x*-stepangle translate z*0.9}
			box {<-0.27, -0.1, -0.01>, <0.27, 0.1, 0.01> texture {t_ruststep} rotate x*-stepangle translate z*1.2}
			box {<-0.27, -0.1, -0.01>, <0.27, 0.1, 0.01> texture {t_ruststep} rotate x*-stepangle translate z*1.5}
			box {<-0.27, -0.1, -0.01>, <0.27, 0.1, 0.01> texture {t_ruststep} rotate x*-stepangle translate z*1.8}
			box {<-0.27, -0.1, -0.01>, <0.27, 0.1, 0.01> texture {t_ruststep} rotate x*-stepangle translate z*2.1}
			box {<-0.27, -0.1, -0.01>, <0.27, 0.1, 0.01> texture {t_ruststep} rotate x*-stepangle translate z*2.4}
			
			//railing
			cylinder {<-0.285, 0, 2.6>, <-0.285, 0.3, 2.3>, 0.02}
			sphere {<-0.285, 0.3, 2.3>, 0.02}
			cylinder {<-0.285, 0, 1.5>, <-0.285, 0.3, 1.5>, 0.02}
			cylinder {<-0.285, 0, 0.5>, <-0.285, 0.3, 0.7>, 0.02}
			sphere {<-0.285, 0.3, 0.7>, 0.02}
			cylinder {<-0.285, 0.3, 2.3>, <-0.285, 0.3, 0.7>, 0.02}
			
			cylinder {<0.285, 0, 2.6>, <0.285, 0.3, 2.3>, 0.02}
			sphere {<0.285, 0.3, 2.3>, 0.02}
			cylinder {<0.285, 0, 1.5>, <0.285, 0.3, 1.5>, 0.02}
			cylinder {<0.285, 0, 0.5>, <0.285, 0.3, 0.7>, 0.02}
			sphere {<0.285, 0.3, 0.7>, 0.02}
			cylinder {<0.285, 0.3, 2.3>, <0.285, 0.3, 0.7>, 0.02}
			
			rotate x*-ladderangle
			translate x*-0.3
		}
		
		texture {t_rustmetal}
		translate x*(bldg1min.x-0.6)
	}
	
	object {fire_esc translate <0, 0, 2>}
	object {fire_esc translate <0, 2.3, 2>}
	object {fire_esc translate <0, 4.6, 2>}
	object {fire_esc translate <0, 6.9, 2>}
}

//--------------------------------------------------------

#declare dumpster=
union {
	
	//main shape
	difference {
		Round_Box_Merge (<-1, 0, -0.75>, <1, 1.4, 0.75>, 0.02)
		box {<-10, 0, -10>, <10, 1, 0> rotate x*-5 translate <0, 1.4, 0.75>}
		Round_Box_Merge (<-0.98, 0.05, -0.73>, <0.98, 1.38, 0.73>, 0.02)
		Round_Box_Merge (<-0.96, 0.05, -0.71>, <0.96, 2, 0.71>, 0.02)
		box {<-2, 0.7, -0.65>, <2, 1.2, 0>}
	}
	
	//slots on sides
	difference {
		Round_Box_Merge (<-1.1, 0.3, -0.73>, <-1, 0.5, 0.73>, 0.015)
		Round_Box_Merge (<-1.08, 0.32, -1>, <0, 0.48, 1>, 0.015)
	}
	difference {
		Round_Box_Merge (<1.1, 0.3, -0.73>, <1, 0.5, 0.73>, 0.015)
		Round_Box_Merge (<1.08, 0.32, -1>, <0, 0.48, 1>, 0.015)
	}
	
	//side doors
	difference {
		Round_Box_Merge (<-1.04, 0.68, -0.67>, <1.04, 1.22, 0.02>, 0.015)
		box {<-1, 0, -1>, <1, 2, 1>}
	}
	difference {
		box {<-1.05, 0.66, -0.67>, <1.05, 1.24, 0.67>}
		box {<-1.04, 0.68, -1>, <1.04, 1.22, 1>}
		box {<-1, 0, -1>, <1, 2, 1>}
		box {<-2, 0.68, -1>, <2, 1.22, 1>}
	}
	difference {
		Round_Box_Merge (<-1.08, 0.8, -0.65>, <1.08, 0.9, -0.62>, 0.005)
		box {<-1.07, 0.81, -1>, <1.07, 0.89, 1>}
		box {<-1, 0, -1>, <1, 2, 1>}
	}
	
	//lid
	union {
		Round_Box_Merge (<-0.98, 0, -1.48>, <0.02, 0.031, 0>, 0.015)
		difference {
			Round_Box_Merge (<-0.4, 0.02, -1.45>, <-0.6, 0.07, -1.42>, 0.01)
			box {<-0.41, 0, -2>, <-0.59, 0.055, 0>}
		}
		rotate x*9
		translate <0, 1.4, 0.75>
	}
	union {
		Round_Box_Merge (<0.98, 0, -1.48>, <0.02, 0.031, 0>, 0.015)
		difference {
			Round_Box_Merge (<0.4, 0.02, -1.45>, <0.6, 0.07, -1.42>, 0.01)
			box {<0.41, 0, -2>, <0.59, 0.055, 0>}
		}
		rotate x*101
		translate <0, 1.4, 0.75>
	}
	
	//garbage
	object {
		Round_Box_Merge (<-0.05, 0, -0.02>, <0.05, 1, 0.02>, 0.001)
		rotate y*30
		rotate x*-5
		translate <-0.4, 0.6, -0.5>
		texture {
			pigment {
				wood
				scale 0.1
				turbulence 0.1
				color_map {
					[0 rgb <0.4, 0.3, 0.2>]
					[1 rgb <0.6, 0.4, 0.2>]
				}
			}
			normal {granite 0.1 scale 0.1}
			finish {phong 0.1 phong_size 20}
		}
		texture {t_dirt scale 0.3}
	}
	box {<-0.2, 0, -0.2>, <0.2, 0.5, 0.2>
		texture {t_box}
		texture {t_dirt scale 0.3}
		rotate <18, 85, 61>
		translate <0.5, 1, 0.2>
	}
	box {<-0.2, 0, -0.2>, <0.2, 0.5, 0.2>
		texture {t_box}
		texture {t_dirt scale 0.3}
		rotate <35, 15, 10>
		translate <-0.6, 0.95, -0.3>
	}
	sphere {0, 0.2
		scale <1.2, 1, 1.3>
		texture {
			pigment {rgb 0.15}
			normal {dents 1 scale 0.1}
			finish {phong 0.4 phong_size 20}
		}
		texture {t_dirt scale 0.3}
		translate <0.75, 1.15, -0.4>
	}
	sphere {0, 0.2
		scale <1.3, 1, 1.2>
		texture {
			pigment {rgb 0.25}
			normal {dents 1 scale 0.1}
			finish {phong 0.4 phong_size 20}
		}
		texture {t_dirt scale 0.3}
		translate <0.25, 1.1, -0.1>
	}
	
	//label
	bicubic_patch {
		type 1 flatness 0.001
		u_steps 4 v_steps 4
		<1, 1.25, 0.05>, <0.1, 1.25, 0>, <0.67, 1.25, 0>, <0.9, 1.15, -0.2>
		<0, 1.1, 0.05>, <0.33, 1, 0>, <0.67, 1, 0>, <1, 1.25, 0>
		<0, 0.5, 0>, <0.33, 0.5, 0>, <0.67, 0.5, 0>, <1, 0.5, 0>
		<0, 0, 0>, <0.33, 0, 0>, <0.67, 0, 0>, <1, 0, 0>
		texture {
			pigment {
				image_map {png "dumplabel.png" map_type 0 interpolate 2}
				scale <1, 1.25, 1>
			}
			finish {specular 0.2 roughness 0.1 metallic brilliance 2}
		}
		texture {t_dirt}
		scale <0.1, 0.15, 0.1>
		translate <-0.8, 1, -0.751>
	}
	
	texture {t_rustdump}
}

//--------------------------------------------------------

#declare trashcan=
union {
	difference {
		cone {<0, 0, 0>, 0.2, <0, 0.75, 0>, 0.25}
		#declare c=0;
		#while (c<360)
			cylinder {<0, 0.05, 0>, <0, 0.65, 0>, 0.01
				scale <1.5, 1, 0.5>
				translate z*0.2
				rotate x*degrees(asin(0.05/VDist(<0, 0, 0.2>, <0, 0.75, 0.25>) ))
				rotate y*c
			}
			#declare c=c+10;
		#end
		cone {<0, 0.01, 0>, 0.19, <0, 0.76, 0>, 0.24}
		torus {0.25, 0.01 translate y*0.68}
	}
	torus {0.25, 0.007 translate y*0.75}
	torus {0.05, 0.005 scale <0.6, 1, 1.25> rotate z*90 translate <-0.24, 0.65, 0>}
	torus {0.05, 0.005 scale <0.6, 1, 1.25> rotate z*90 translate <0.24, 0.65, 0>}
	texture {
		pigment {rgb 0.75}
		normal {dents 0.5 scale 0.2}
		finish {metallic brilliance 5 specular 0.3 roughness 0.05 reflection 0.2}
	}
	texture {t_dirt}
}

#declare trashcanlid=
union {
	difference {
		cylinder {<0, 0, 0>, <0, 0.03, 0>, 0.26}
		cylinder {<0, -1, 0>, <0, 1, 0>, 0.25}
	}
	difference {
		cone {<0, 0.03, 0>, 0.26, <0, 0.05, 0>, 0.1}
		cone {<0, 0.029, 0>, 0.25, <0, 0.04, 0>, 0.09}
	}
	torus {0.25, 0.01}
	torus {0.05, 0.005 scale <1.25, 1, 0.6> translate <0, 0.055, 0.03>}
	texture {
		pigment {rgb 0.75}
		normal {dents 0.5 scale 0.2}
		finish {metallic brilliance 5 specular 0.3 roughness 0.05 reflection 0.2}
	}
	texture {t_dirt}
}

#declare pizzabox=
union {
	difference {
		box {<-0.15, 0, -0.15>, <0.15, 0.02, 0.15>}
		box {<-0.145, 0.005, -0.145>, <0.145, 1, 0.145>}
	}
	union {
		box {<0, -0.005, -0.15>, <0.3, 0, 0.15>
			texture {
				pigment {
					image_map {
						png "pizza.png"
						interpolate 2 once map_type 0
					}
					scale 0.3
					rotate x*90
					rotate y*90
					translate z*0.15
				}
				finish {specular 0.2 roughness 0.1}
			}
			texture {t_dirt scale 0.1}
		}
		box {<-0.005, -0.015, -0.145>, <0, 0, 0.145> rotate z*45 translate x*0.3}
		box {<0, -0.015, 0>, <0.29, 0, 0.005> rotate x*45 translate z*-0.15}
		box {<0, -0.015, -0.005>, <0.29, 0, 0> rotate x*-45 translate z*0.15}
		rotate z*40
		translate <-0.15, 0.015, 0>
	}
	texture {
		pigment {rgb 1}
		finish {specular 0.2 roughness 0.1}
	}
	texture {t_dirt scale 0.3}
	rotate z*15
	rotate x*-10
	translate y*0.73
}

//--------------------------------------------------------

#declare fence=
union {
	#declare minc=-2;
	#declare maxc=5;
	#declare c=minc;
	#declare wid=0.2;
	#declare thick=0.04;
	#while (c<maxc)
		object {
			#declare p1=<0, RRand(0.02, 0.05, sd), RRand(-0.01, 0.01, sd)>;
			#declare p2=<wid+RRand(-0.04, 0.04, sd), RRand(1.95, 2, sd), p1.z+thick>;
			#declare ofs=RRand(0.005, 0.015, sd);
			Round_Box_Merge (p1, p2, 0.01)
			translate x*c
			texture {t_fence}
			texture {t_dirt}
		}
		#declare c=c+p2.x-p1.x+ofs;
	#end
	object {Round_Box_Merge (<minc, 0, -0.02>, <minc+(maxc-minc)*0.02, 2.01, 0>, 0.01)
		texture {t_fence}
		texture {t_dirt}
	}
	object {Round_Box_Merge (<minc+(maxc-minc)*0.98, 0, -0.02>, <maxc, 2.01, 0>, 0.01)
		texture {t_fence}
		texture {t_dirt}
	}
	object {Round_Box_Merge (<minc+(maxc-minc)*0.27, 0, -0.02>, <minc+(maxc-minc)*0.29, 2.01, 0>, 0.01)
		texture {t_fence}
		texture {t_dirt}
	}
	object {Round_Box_Merge (<minc+(maxc-minc)*0.66, 0, -0.02>, <minc+(maxc-minc)*0.68, 2.01, 0>, 0.01)
		texture {t_fence}
		texture {t_dirt}
	}
	object {
		Round_Box_Merge (<minc, 0.35, -0.015>, <minc+(maxc-minc)*0.27, 0.5, 0>, 0.005)
		texture {t_fence rotate z*90}
		texture {t_dirt}
	}
	object {
		Round_Box_Merge (<minc+(maxc-minc)*0.29, 0.35, -0.015>, <minc+(maxc-minc)*0.66, 0.5, 0>, 0.005)
		texture {t_fence rotate z*90}
		texture {t_dirt}
	}
	object {
		Round_Box_Merge (<minc+(maxc-minc)*0.68, 0.35, -0.015>, <maxc, 0.5, 0>, 0.005)
		texture {t_fence rotate z*90}
		texture {t_dirt}
	}
	object {
		Round_Box_Merge (<minc, 1.5, -0.015>, <minc+(maxc-minc)*0.27, 1.65, 0>, 0.005)
		texture {t_fence rotate z*90}
		texture {t_dirt}
	}
	object {
		Round_Box_Merge (<minc+(maxc-minc)*0.29, 1.5, -0.015>, <minc+(maxc-minc)*0.66, 1.65, 0>, 0.005)
		texture {t_fence rotate z*90}
		texture {t_dirt}
	}
	object {
		Round_Box_Merge (<minc+(maxc-minc)*0.68, 1.5, -0.015>, <maxc, 1.65, 0>, 0.005)
		texture {t_fence rotate z*90}
		texture {t_dirt}
	}
}

//--------------------------------------------------------

#declare fire=
union {
	difference {
		cylinder {<0, 0, 0>, <0, 0.87, 0>, 0.3}
		cylinder {<0, 0.01, 0>, <0, 1, 0>, 0.29}
	}
	torus {0.3, 0.01}
	torus {0.3, 0.01 translate y*0.87}
	torus {0.3, 0.01 translate y*0.29}
	torus {0.3, 0.01 translate y*0.58}
		
	light_source {<0, 0.86, 0> color rgb <0.4, 0.2, 0>
		media_interaction on
		media_attenuation on
		fade_distance 1
		fade_power 4
		looks_like {
			cylinder {<0, -1, 0>, <0, 1, 0>, 1
				hollow
				pigment {rgbt 1}
				interior {
					media {
						method 1
						intervals 10
						samples 3, 10
						emission 2
						density {
							wrinkles
							density_map {
								[0 rgb 0]
								[0.3 rgb <1, 0, 0>]
								[0.8 rgb <1, 1, 0>]
							}
						}
						density {
							cylindrical
							turbulence 3
							density_map {
								[0 rgb 0]
								[0.3 rgb 1]
							}
						}
						density {
							planar
							turbulence 0.1
							density_map {
								[0 rgb 0]
								[0.2 rgb 0]
								[0.4 rgb 1]
								[1 rgb 2]
							}
						}
					}
				}
				scale <0.2, 0.3, 0.2>
				translate y*-0.09
			}
		}
	}
	
	texture {
		pigment {rgb 0.5}
		normal {dents 0.8 scale 0.2}
		finish {metallic brilliance 3 specular 0.3 roughness 0.05 reflection 0.05}
	}	
	texture {t_dirt scale 0.1}
}

//--------------------------------------------------------

#macro can(t_label)
#local t_can=
texture {
	pigment {rgb 0.75}
	finish {metallic brilliance 5 specular 0.3 roughness 0.05 reflection 0.2}
}

union {
	difference {
		cylinder {<0, 0, 0>, <0, 0.15, 0>, 0.035}
		torus {0.035, 0.008 scale <1, 1, 1> texture {t_can}}
		torus {0.035, 0.006 scale <1, 1.5, 1> translate y*0.15}
		sphere {0, 0.027 scale <1, 0.25, 1> texture {t_can}}
	}
	difference {
		cylinder {<0, 0.15, 0>, <0, 0.155, 0>, 0.03}
		cylinder {<0, 0.151, 0>, <0, 1, 0>, 0.028}
		cylinder {<0, 0.1502, 0.005>, <0, 1, 0.005>, 0.012 scale <1, 1, 1.3>}
		cylinder {<0, 0.1502, -0.01>, <0, 1, -0.01>, 0.012 scale <1.5, 1, 1>}
		cylinder {<0, 0.1501, -0.01>, <0, 1, -0.01>, 0.008 scale <1.5, 1, 1> pigment {rgb 0}}
		texture {t_can}
	}
	difference {
		union {
			cylinder {<0, 0, 0.005>, <0, 0.003, 0.005>, 0.01}
			cylinder {<0, 0, -0.005>, <0, 0.003, -0.005>, 0.01 scale <1, 1, 0.75>}
			box {<-0.01, 0, -0.005>, <0.01, 0.003, 0.005>}
		}
		cylinder {<0, -1, 0.013>, <0, 1, 0.013>, 0.007 scale <1, 1, 0.5>}
		cylinder {<0, -1, -0.005>, <0, 1, -0.005>, 0.007 scale <1, 1, 0.75>}
		texture {t_can}
		rotate x*-10
		translate y*0.155
	}
	texture {t_label}
}
#end

//--------------------------------------------------------

#macro frame(pt1, pt2, pt3, pt4, rad1, rad2)
	union {
		
		//sides
		cylinder {pt1-z*rad2, pt4-z*rad2, rad1}
		cylinder {pt2+z*rad2, pt3+z*rad2, rad1}
		cylinder {pt1-x*rad2, pt2-x*rad2, rad1}
		cylinder {pt3+x*rad2, pt4+x*rad2, rad1}
		
		//save y values
		#declare y1=pt1.y;
		#declare y2=pt2.y;
		#declare y3=pt3.y;
		#declare y4=pt4.y;
		#declare pt1=pt1*<1, 0, 1>;
		#declare pt2=pt2*<1, 0, 1>;
		#declare pt3=pt3*<1, 0, 1>;
		#declare pt4=pt4*<1, 0, 1>;
		
		//corners
		torus {rad2, rad1
			clipped_by {
				object {Wedge(VRotationD(pt2, pt4, pt1)) inverse}
				object {Wedge(VRotationD(pt2, pt4, pt1)) inverse rotate y*-90}
			}
			translate pt1+y*y1
		}
		torus {rad2, rad1
			clipped_by {
				object {Wedge(VRotationD(pt1, pt3, pt2)) inverse}
				object {Wedge(VRotationD(pt1, pt3, pt2)) inverse rotate y*90}
			}
			translate pt2+y*y2
		}
		torus {rad2, rad1
			clipped_by {
				object {Wedge(VRotationD(pt2, pt4, pt3)) inverse}
				object {Wedge(VRotationD(pt2, pt4, pt3)) inverse rotate y*90}
				rotate y*90
			}
			translate pt3+y*y3
		}
		torus {rad2, rad1
			clipped_by {
				object {Wedge(VRotationD(pt3, pt1, pt4)) inverse}
				object {Wedge(VRotationD(pt3, pt1, pt4)) inverse rotate y*-90}
				rotate y*-90
			}
			translate pt4+y*y4
		}
	}
#end

#declare rad1=0.005;
#declare rad2=0.02;

#declare cart=
union {
	
	//y
	frame(<0, 0, -0.25>, <0, 0, 0.25>, <0.8, 0, 0.25>, <0.8, 0, -0.25>, rad1*2, rad2)
	frame(
		vtransform(<0, 0.0625, -0.25> transform {rotate z*10}),
		vtransform(<0, 0.0625, 0.25> transform {rotate z*10}),
		<0.8, 0.05, 0.25>,
		<0.8, 0.05, -0.25>,
		rad1, rad2
	)
	frame(
		vtransform(<0, 0.0625*2, -0.25> transform {rotate z*10}),
		vtransform(<0, 0.0625*2, 0.25> transform {rotate z*10}),
		<0.8, 0.05*2, 0.25>,
		<0.8, 0.05*2, -0.25>,
		rad1, rad2
	)
	frame(
		vtransform(<0, 0.0625*3, -0.25> transform {rotate z*10}),
		vtransform(<0, 0.0625*3, 0.25> transform {rotate z*10}),
		<0.8, 0.05*3, 0.25>,
		<0.8, 0.05*3, -0.25>,
		rad1, rad2
	)
	frame(
		vtransform(<0, 0.0625*4, -0.25> transform {rotate z*10}),
		vtransform(<0, 0.0625*4, 0.25> transform {rotate z*10}),
		<0.8, 0.05*4, 0.25>,
		<0.8, 0.05*4, -0.25>,
		rad1, rad2
	)
	frame(
		vtransform(<0, 0.0625*5, -0.25> transform {rotate z*10}),
		vtransform(<0, 0.0625*5, 0.25> transform {rotate z*10}),
		<0.8, 0.05*5, 0.25>,
		<0.8, 0.05*5, -0.25>,
		rad1, rad2
	)
	frame(
		vtransform(<0, 0.0625*6, -0.25> transform {rotate z*10}),
		vtransform(<0, 0.0625*6, 0.25> transform {rotate z*10}),
		<0.8, 0.05*6, 0.25>,
		<0.8, 0.05*6, -0.25>,
		rad1*2, rad2
	)
	frame(
		vtransform(<0, 0.0625*7, -0.25> transform {rotate z*10}),
		vtransform(<0, 0.0625*7, 0.25> transform {rotate z*10}),
		<0.8, 0.05*7, 0.25>,
		<0.8, 0.05*7, -0.25>,
		rad1, rad2
	)
	frame(
		vtransform(<0, 0.5, -0.25> transform {rotate z*10}),
		vtransform(<0, 0.5, 0.25> transform {rotate z*10}),
		<0.8, 0.4, 0.25>,
		<0.8, 0.4, -0.25>,
		rad1*2, rad2
	)
	
	//x
	union {
		object {
			frame(<0, 0, -0.25>, <0, 0, 0.25>, <0, 1, 0.25>, <0, 1, -0.25>, rad1, rad2)
			rotate z*10
		}
		object {
			frame(<0.05, 0, -0.25>, <0.05, 0, 0.25>, <0.05, 1, 0.25>, <0.05, 1, -0.25>, rad1, rad2)
			rotate z*6
		}
		object {
			frame(<0.1, 0, -0.25>, <0.1, 0, 0.25>, <0.1, 1, 0.25>, <0.1, 1, -0.25>, rad1, rad2)
			rotate z*3
		}
		#declare cx=0.15;
		#declare maxx=0.81;
		#while (cx<maxx)
			object {
				frame(
					<cx, 0, -0.25>,
					<cx, 0, 0.25>,
					<cx, 1, 0.25>,
					<cx, 1, -0.25>,
					rad1, rad2
				)
			}
			#declare cx=cx+0.05;
		#end
		
		//z
		#declare cz=-0.25;
		#declare maxz=0.26;
		#while (cz<maxz)
			frame(
				<-rad2, 0, cz>,
				<0.8-rad2, 0, cz>,
				<0.8-rad2, 0.4+rad2, cz>,
				vtransform(<-rad2, 0.5+rad2, cz> transform {rotate z*10}),
				rad1, rad2
			)
			#declare cz=cz+0.05;
		#end
		
		clipped_by {
			plane {y, 0 rotate z*-(90-(degrees(atan(cosd(10)*cosd(10)/(0.5*cosd(10)-0.4))))+1) translate y*0.49}
		}
	}
	
	//wheels & bottom
	#declare wheel=
	union {
		cylinder {<0, 0, -0.016>, <0, 0, 0.016>, 0.06 pigment {rgb 0.2} finish {phong 0.3 phong_size 30}}
		union {
			cylinder {<0, 0, -0.018>, <0, 0, 0.018>, 0.01 scale <1, 4, 1> translate <-0.02, 0.04, 0>}
			cylinder {<0, 0, -0.018>, <0, 0, 0.018>, 0.03 scale <0.7, 0.5, 1>}
			box {<-0.02, 0, -0.018>, <0.02, 0.08, 0.018>
				clipped_by {
					cylinder {<0, 0, -1>, <0, 0, 1>, 0.01 inverse scale <1, 2.5, 1> translate <0.02, 0.04, 0>}
				}
			}
			clipped_by {box {<-1, -1, -0.015>, <1, 0.075, 0.017> inverse}}
		}
		cylinder {<0, 0.08, 0>, <-0.01, 0.13, 0>, 0.0135}
		sphere {0, 0.01 scale <1, 1, 0.2> translate z*-0.018}
		sphere {0, 0.01 scale <1, 1, 0.2> translate z*0.018}
	}
	
	object {wheel translate <0.1, -0.34, -0.2>}
	object {wheel translate <0.1, -0.34, 0.2>}
	object {wheel translate <0.6, -0.34, -0.2>}
	object {wheel translate <0.6, -0.34, 0.2>}
	
	torus {0.2, 0.015
		clipped_by {plane {-x, 0}}
		translate <0.4, -0.015, 0>
	}
	torus {0.195/2, 0.015
		rotate x*90
		clipped_by {plane {x, 0}}
		translate <0.1, -0.1125, -0.2>
	}
	torus {0.195/2, 0.015
		rotate x*90
		clipped_by {plane {x, 0}}
		translate <0.1, -0.1125, 0.2>
	}
	cylinder {<0.1, -0.015, -0.2>, <0.4, -0.015, -0.2>, 0.015}
	cylinder {<0.1, -0.015, 0.2>, <0.4, -0.015, 0.2>, 0.015}
	cylinder {<0.1, -0.21, -0.2>, <0.6, -0.21, -0.2>, 0.015}
	cylinder {<0.1, -0.21, 0.2>, <0.6, -0.21, 0.2>, 0.015}
	torus {0.2, 0.015
		clipped_by {plane {-x, 0}}
		scale <0.5, 1, 1>
		translate <0.6, -0.21, 0>
	}
	
	//handle
	union {
		cylinder {<0, 0.02, -0.27>, <0, 0.5, -0.27>, 0.015}
		cylinder {<0, 0.02, 0.27>, <0, 0.5, 0.27>, 0.015}
		sphere {<0, 0.02, -0.27>, 0.015}
		sphere {<0, 0.02, 0.27>, 0.015}
		intersection {
			torus {0.2, 0.015 rotate x*90 scale <1, 0.5, 1>}
			box {<0, 0, -1>, 1}
			translate <-0.2, 0.5, -0.27>
		}
		intersection {
			torus {0.2, 0.015 rotate x*90 scale <1, 0.5, 1>}
			box {<0, 0, -1>, 1}
			translate <-0.2, 0.5, 0.27>
		}
		union {
			cylinder {<-0.2, 0.6, -0.27>, <-0.2, 0.6, 0.27>, 0.015}
			sphere {0, 0.015 scale <1, 1, 0.5> translate <-0.2, 0.6, -0.27>}
			sphere {0, 0.015 scale <1, 1, 0.5> translate <-0.2, 0.6, 0.27>}
			pigment {red 1} finish {specular 0.3 roughness 0.1}
		}
		rotate z*10
		translate <-0.015, -0.015, 0>
	}
	
	//add items in basket here
	
	texture {
		pigment {rgb 0.75}
		normal {dents 0.5 scale 0.2}
		finish {metallic brilliance 5 specular 0.3 roughness 0.05 reflection 0.2}
	}
	texture {t_dirt}
	translate <0, 0.4, 0>
}

//--------------------------------------------------------

#macro bottle(txt, labelon, label)
	merge {
		Round_Cylinder_Merge(<0, 0.0001, 0>, <0, 0.12, 0>, 0.035, 0.005)
		sphere {<0, 0.12, 0>, 0.035}
		Round_Cone_Merge(<0, 0.14, 0>, 0.02, <0, 0.22, 0>, 0.015, 0.005)
		torus {0.015, 0.002 translate y*0.22}
		texture {txt}
		#if (labelon=on)
			texture {
				pigment {
					image_map {png label interpolate 2 once map_type 0}
					scale <0.088, 0.08, 1>
					translate y*0.02
				}
			}
		#end
		rotate y*90
	}
#end

//--------------------------------------------------------

#macro broken_bottle(txt)
	union {
		object {bottle(txt, off, "")
			clipped_by {
				height_field {
					function 100, 100 {f_granite(x*3, y, z*3)}
					inverse
					translate <-0.5, 0, -0.5>
					scale <0.3, 0.1, 0.3>
					translate y*0.075
					rotate y*45
				}
			}
			rotate x*93
			translate y*0.035
		}
		object {bottle(txt, off, "")
			clipped_by {
				height_field {
					function 100, 100 {f_granite(x*3, y, z*3)}
					translate <-0.5, 0, -0.5>
					scale <0.3, 0.05, 0.3>
					translate y*0.02
					rotate y*45
				}
			}
			translate <-0.02, 0, -0.3>
		}
		#local mx=10;
		#local sz=0.01;
		#local minx=-0.2;
		#local maxx=0.2;
		#local minz=-0.4;
		#local maxz=0.02;
		#local c=0;
		#while (c<mx)
			intersection {
				box {-sz, sz rotate RRand(0, 360, sd)}
				box {-sz, sz rotate RRand(0, 360, sd)}
				box {-sz, sz rotate RRand(0, 360, sd)}
				texture {txt}
				interior {ior 1.5 caustics 0.6}
				scale <1, 1, 3>
				rotate y*RRand(-65, 65, sd)
				translate VRand_In_Box(<minx, 0, minz>, <maxx, 0.001, maxz>, sd)
			}
			#declare c=c+1;
		#end
	}
#end

//--------------------------------------------------------

#declare paper1=
bicubic_patch {
	type 1 flatness 0.001
	u_steps 8 v_steps 8
	/*<-0.6, 0, 0.8>, <-0.2, 0, 0.8>, <0.2, 0, 0.8>, <0.6, 0, 0.8>
	<-0.6, 0, 0.3>, <-0.2, 0, 0.3>, <0.2, 0, 0.3>, <0.6, 0, 0.3>
	<-0.6, 0, -0.3>, <-0.2, 0, -0.3>, <0.2, 0, -0.3>, <0.6, 0, -0.3>
	<-0.6, 0, -0.8>, <-0.2, 0, -0.8>, <0.2, 0, -0.8>, <0.6, 0, -0.8>*/
	
	<-0.6, 0, 0.8>, <-0.2, 0.05, 0.8>, <0.2, 0, 0.8>, <0.6, 0.1, 0.8>
	<-0.6, 0.1, 0.3>, <-0.2, 0, 0.3>, <0.2, 0.1, 0.3>, <0.6, 0, 0.3>
	<-0.6, 0, -0.3>, <-0.2, 0, -0.3>, <0.2, 0, -0.3>, <0.6, 0, -0.3>
	<-0.6, 0, -0.8>, <-0.2, 0.1, -0.8>, <0.2, -0.02, -0.8>, <0.6, 0.06, -0.8>
	
	texture {t_page}
	scale 0.3
}

#declare paper2=
bicubic_patch {
	type 1 flatness 0.001
	u_steps 8 v_steps 8
	
	<-0.6, 0, 0.8>, <-0.2, 0, 0.8>, <0.2, 0.02, 0.8>, <0.6, 0, 0.8>
	<-0.6, 0.05, 0.3>, <-0.2, 0.1, 0.3>, <0.2, 0, 0.3>, <0.6, 0.05, 0.3>
	<-0.6, 0, -0.3>, <-0.2, 0.15, -0.3>, <0.2, 0.05, -0.3>, <0.6, 0, -0.3>
	<-0.6, 0.02, -0.8>, <-0.2, 0, -0.8>, <0.2, 0.05, -0.8>, <0.6, 0, -0.8>
	
	texture {t_page}
	scale 0.25
}

#declare paper3=
bicubic_patch {
	type 1 flatness 0.001
	u_steps 8 v_steps 8
	
	<-0.6, 0, 0.8>, <-0.2, 0.2, 0.8>, <0.2, 0.1, 0.8>, <0.6, 0, 0.8>
	<-0.6, 0.05, 0.3>, <-0.2, 0.15, 0.3>, <0.2, 0, 0.3>, <0.6, 0, 0.3>
	<-0.6, 0, -0.3>, <-0.2, 0.15, -0.3>, <0.2, 0.07, -0.3>, <0.6, 0, -0.3>
	<-0.6, 0, -0.8>, <-0.2, 0.1, -0.75>, <0.2, 0, -0.8>, <0.6, 0.01, -0.8>
	
	texture {t_page}
	scale 0.25
}

#declare paper4=
bicubic_patch {
	type 1 flatness 0.0001
	u_steps 8 v_steps 8
	
	<-0.6, 0, 0.8>, <-0.2, 0.1, 0.8>, <0, -0.05, 0.8>, <0.4, 0.25, 0.8>
	<-0.6, 0, 0.3>, <-0.2, 0, 0.3>, <0.2, 0.02, 0.3>, <0.6, 0.1, 0.3>
	<-0.6, 0, -0.3>, <-0.2, 0.1, -0.3>, <0.2, 0, -0.3>, <0.6, 0, -0.3>
	<-0.6, 0.07, -0.8>, <-0.2, 0, -0.8>, <0.2, 0.05, -0.8>, <0.6, 0, -0.8>
	
	texture {t_page}
	rotate y*25
	scale 0.3
	translate <-0.21, 0.001, 0>
}

#declare newspaper=
union {
	object {paper2 translate <-0.15, 0.001, 0>}
	object {paper3 translate <0.15, 0.001, 0>}
	object {paper2 translate <-0.15, 0.005, 0> rotate y*10}
	object {paper3 translate <0.15, 0.005, 0> rotate y*10}
	object {paper2 translate <-0.16, 0.01, 0> rotate y*20}
	object {paper3 translate <0.14, 0.01, 0> rotate y*20}
}

//--------------------------------------------------------

#declare bx=
union {

	//top
	bicubic_patch {
		type 1 flatness 0.001
		u_steps 8 v_steps 8
		<-0.4, 0.8, 1.5>, <-0.1, 0.8, 1.5>, <0.1, 0.8, 1.5>, <0.4, 0.8, 1.5>
		<-0.4, 0.8, 1>, <-0.1, 0.4, 1>, <0.1, 0.8, 1>, <0.35, 0.6, 1>
		<-0.4, 0.8, 0.5>, <-0.1, 0.6, 0.5>, <0.1, 0.8, 0.5>, <0.4, 0.7, 0.5>	
		<-0.4, 0.8, 0>, <-0.1, 0.75, 0>, <0.1, 0.755, 0>, <0.4, 0.8, 0>
		texture {t_box}
	}
	
	//top flap
	bicubic_patch {
		type 1 flatness 0.001
		u_steps 8 v_steps 8
		<-0.4, 0, 0.4>, <-0.1, 0, 0.4>, <0.1, 0, 0.4>, <0.4, 0, 0.4>
		<-0.4, 0, 0.25>, <-0.1, 0, 0.25>, <0.1, 0, 0.25>, <0.35, 0, 0.25>
		<-0.4, 0, 0.15>, <-0.1, 0, 0.15>, <0.1, 0, 0.15>, <0.4, 0, 0.15>	
		<-0.4, 0, 0>, <-0.1, -0.1, 0.02>, <0.1, -0.075, 0>, <0.4, 0, 0>
		texture {t_flap}
		rotate x*-45
		translate y*0.799
	}
	
	//right
	bicubic_patch {
		type 1 flatness 0.001
		u_steps 8 v_steps 8
		<0.4, 0, 0>, <0.4, 0, 0.5>, <0.4, 0, 1>, <0.4, 0, 1.5>
		<0.35, 0.3, 0>, <0.4, 0.3, 0.5>, <0.4, 0.3, 1>, <0.4, 0.3, 1.5>
		<0.5, 0.5, 0>, <0.4, 0.5, 0.5>, <0.4, 0.5, 1>, <0.4, 0.5, 1.5>
		<0.4, 0.8, 0>, <0.4, 0.7, 0.5>, <0.35, 0.6, 1>, <0.4, 0.8, 1.5>
		texture {t_box}
	}
	
	//right flap
	bicubic_patch {
		type 1 flatness 0.001
		u_steps 8 v_steps 8
		<0, 0, 0>, <0, 0, 0.15>, <0, 0, 0.25>, <0.1, 0.05, 0.4>
		<-0.05, 0.3, 0>, <0, 0.3, 0.15>, <0, 0.3, 0.25>, <0, 0.3, 0.4>
		<0.1, 0.5, 0>, <0, 0.5, 0.15>, <0, 0.5, 0.25>, <0, 0.5, 0.4>
		<0, 0.8, 0>, <0, 0.8, 0.15>, <-0.05, 0.8, 0.25>, <0, 0.8, 0.4>
		texture {t_box}
		rotate y*45
		translate x*0.399
	}
	
	//left
	bicubic_patch {
		type 1 flatness 0.001
		u_steps 8 v_steps 8
		<-0.4, 0, 0>, <-0.4, 0, 0.5>, <-0.4, 0, 1>, <-0.4, 0, 1.5>
		<-0.5, 0.3, 0>, <-0.4, 0.3, 0.5>, <-0.4, 0.3, 1>, <-0.4, 0.3, 1.5>
		<-0.35, 0.5, 0>, <-0.4, 0.5, 0.5>, <-0.4, 0.5, 1>, <-0.4, 0.4, 1.5>
		<-0.4, 0.8, 0>, <-0.4, 0.8, 0.5>, <-0.4, 0.8, 1>, <-0.4, 0.8, 1.5>
		texture {t_box}
	}
	
	//left flap
	bicubic_patch {
		type 1 flatness 0.001
		u_steps 8 v_steps 8
		<0, 0, 0>, <0, 0, 0.15>, <0, 0, 0.25>, <0, 0, 0.4>
		<-0.1, 0.3, 0>, <0, 0.3, 0.15>, <0, 0.3, 0.25>, <0, 0.3, 0.4>
		<0.04, 0.5, 0>, <0, 0.5, 0.15>, <0, 0.5, 0.25>, <0, 0.4, 0.4>
		<0, 0.8, 0>, <0, 0.8, 0.15>, <0, 0.8, 0.25>, <0, 0.8, 0.4>
		texture {t_box}
		rotate y*-60
		translate x*-0.388
	}
	
	//bottom
	box {<-0.4, 0, 0>, <0.4, 0.001, 1.5>
		texture {t_box}
	}
	
	//bottom flap
	bicubic_patch {
		type 1 flatness 0.001
		u_steps 8 v_steps 8
		<-0.4, 0, 0>, <-0.1, 0, 0>, <0.1, 0, 0>, <0.4, 0, 0>
		<-0.4, 0, 0.15>, <-0.1, 0, 0.15>, <0.1, 0, 0.15>, <0.4, 0, 0.15>
		<-0.4, 0, 0.35>, <-0.1, 0, 0.25>, <0.1, 0, 0.25>, <0.4, 0, 0.25>
		<-0.4, 0.02, -0.4>, <-0.38, 0, -0.4>, <0.1, 0, -0.4>, <0.4, 0.025, -0.4>
		texture {t_box}
	}
	
	//back
	box {<-0.4, 0, 1.49>, <0.4, 0.8, 1.5>
		texture {t_box}
	}
}

//--------------------------------------------------------

#declare moon=
light_source {<-5, 25, 60> color rgb 0.2
	media_interaction on
	media_attenuation on
	looks_like {
		sphere {0, 1
			pigment {image_map {jpeg "moon.jpg" interpolate 2 map_type 1}}
			finish {ambient 14 diffuse 0}
			scale 3
			rotate y*-80 rotate z*30 
		}
	}
}

//--------------------------------------------------------
//	object placements
//--------------------------------------------------------

#declare cam=2;
#declare frontlightcol=rgb <0.2, 0.2, 0.25>;

light_source {<3.5, 4, -6> frontlightcol media_interaction off fade_distance 10 fade_power 2}
light_source {<-3.5, 4, -6> frontlightcol media_interaction off fade_distance 10 fade_power 2}
object {gnd}
object {haze}
object {clouds}
object {moon}
object {bldg1 translate <-7, 0, 0>}
object {bldg2 translate <9, 0, 0>}
object {fence translate z*6}
union {
	object {dumpster rotate y*-75 translate x*-1}
	union {
		object {trashcan}
		object {trashcanlid translate y*0.755}
		rotate y*20
		translate <-1.5, 0, -1.75>
	}
	union {
		object {trashcan rotate y*30}
		object {pizzabox}
		object {trashcanlid rotate x*103 translate <0, 0.255, -0.33>}
		rotate y*-70
		translate <-0.9, 0, -1.8>
	}
	object {can(t_canlabel2) rotate x*-90 rotate y*40 translate <-0.9, 0.035, -2.1> texture {t_dirt scale 0.1}}
	object {can(t_canlabel1) rotate x*-90 rotate y*70 translate <0, 0.035, 0.35> texture {t_dirt scale 0.1}}
	translate z*-1.7
}
object {broken_bottle(t_wine) rotate y*-45 translate <3.4, 0, -2.2>}
object {broken_bottle(t_beer) rotate y*-45 translate <0, 0, 5.5>}
object {bottle(t_wine, on, "canlabel2.png") rotate y*45 rotate z*90 translate <0.15, 0.435, -2.9>}
object {bottle(t_beer, on, "canlabel1.png") rotate y*45 translate <-1.5, 0, -3.8>}
object {can(t_canlabel2) rotate y*-170 rotate x*-90 rotate y*15 translate <3.7, 0.035, -1.7> texture {t_dirt scale 0.1}}
object {bx rotate y*30 translate <1.8, 0, 0>}
object {fire translate <3.25, 0, -1.5>}
object {cart rotate y*-70 translate <-0.05, 0, -3>}
object {paper1 rotate y*-20 translate <2.4, 0.001, -1>}
object {newspaper rotate y*-40 translate <-0.6, 0.001, -4.2>}
object {paper4 translate <3.98, 0, -2.1>}
box {<0, 0, 0>, <0.5, 1, 0.01>
	pigment {
		image_map {gif "joker.gif" interpolate 2 once map_type 0}
		scale <0.5, 1, 1>
	}
	finish {ambient 2.5}
	rotate y*-90
	translate <-2.05, 1.25, -3.5>
}

#if (cam=2)
	object {cardhouse1 rotate y*55 translate <1.3, 0, -3.7>}
	union {
		object {bum scale 2}
		mesh {card(3,0,0,0.08,transform {rotate <83, -16, 5> translate <0.04, 0.502, 0.63>})}
		translate z*-1.5
		rotate y*-125
		translate <1.3, 0, -3.7>
	}
#else
	object {cardhouse1 rotate y*55 translate <1.6, 0, -3.7>}
	object {cardhouse2 rotate y*10 translate <-2, 0.75, 4>}
	union {
		object {bum scale 2}
		mesh {card(3,0,0,0.08,transform {rotate <83, -16, 5> translate <0.04, 0.502, 0.63>})}
		translate z*-1.5
		rotate y*-80
		translate <1.6, 0, -3.7>
	}
#end


//--------------------------------------------------------
//	cameras
//--------------------------------------------------------

#if (cam=0)
	//16x9 aspect
	//+w960 +h540
	camera {
		up <0, 1, 0>
		right <16/9, 0, 0>
		angle 60
		location <3, 1.2, -8>
		look_at <0.25, 1, 0>
	}
#end
#if (cam=1)
	//4x3 aspect
	//+w800 +h600
	camera {
		up y
		right <4/3, 0, 0>
		//angle 67
		angle 69
		location <2.5, 1.2, -7>
		look_at <0.2, 1, 0>
	}
#end
#if (cam=2)
	//4x3 aspect
	//+w800 +h600
	camera {
		up y
		right <4/3, 0, 0>
		//angle 67
		angle 73
		location <1.3, 1.2, -7>
		look_at <0.4, 1, 0>
	}
#end
#if (cam=3)
	//4x3 aspect
	//+w800 +h600
	camera {
		up y
		right <4/3, 0, 0>
		//angle 67
		angle 69
		location <2, 1.2, -7>
		look_at <0.2, 1, 0>
	}
#end
#if (cam=8)
	//test cam
	camera {
		up y
		right 4/3*x
		angle 67
		location <0, 12, 0>
		look_at 0
	}
#end
#if (cam=9)
	//test cam
	camera {
		up y
		right 4/3*x
		angle 67
		location <0, 1.5, 4>
		look_at <2, 1.5, 1>
	}
#end