////////////////////////////////////////////////////////////////////////////////
//
// Carrot.inc -- Nose carrots for SnoBuild.pov (IRTC 3-4/2003)
//               by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

#macro Carrot()
  union {
    #local i = 0;
    #while (i < CNoseSegments)
      #local RCurrent = CNoseLargeRadius - CNoseSegmentStep * i;
      #local XCurrent = CNoseSegmentSize * i;
      sphere {
        < 0, 0, 0 >,
        RCurrent
        scale <CNoseSegmentSize * 2 / RCurrent, 1, 1 >
        translate < XCurrent, 0, 0 >
      }
      #local i = i + 1;
    #end
    texture { Tx_Carrot }
    scale 1 / CNoseLength
  }
#end
