////////////////////////////////////////////////////////////////////////////////
//
// Coal.inc -- Coal for SnoBuild.pov (IRTC 3-4/2003)
//             by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

#declare Coal =
  superellipsoid {
    <.6, .6>
    scale < 1, 1, .4 >
    texture { Tx_Coal }
  }

#macro PlaceCoal(center, r, xAngle, yAngle, xScale, yScale, zScale, totalScale)
  #local xa = radians(xAngle);
  #local ya = radians(yAngle);
  object {
    Coal
    scale  totalScale
    rotate y * yAngle
    rotate x * xAngle
    translate < center.x - (r * sin(ya) * cos(xa)) * xScale,
                center.y - (r * sin(xa)) * yScale,
                center.z - (r * cos(xa) * cos(ya)) * zScale >
  }
#end
