////////////////////////////////////////////////////////////////////////////////
//
// GroundSnow.inc -- Ground snow for SnoBuild.pov (IRTC 3-4/2003)
//                   by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

#macro GroundSnow()
  difference {
    height_field {
      function 1000,1000 {
        pigment {
          granite
        }
      }
      smooth
      scale     < 1000, 20, 1000 >
      translate < -500,  0, -500 >
    }
    union {
      sphere {
        < 0, 0, 0 >,
        LSMHeadRadius
      }
      cylinder {
        < 0, 0,   0 >,
        < 0, 0, 100 >,
        LSMHeadRadius
      }
      sphere {
        < 0, 0, 100 >,
        LSMHeadRadius
      }
      cylinder {
        <   0, 0, 100 >,
        < -20, 0, 150 >,
        LSMHeadRadius
      }
      sphere {
        < -20, 0, 150>,
        LSMHeadRadius
      }
      cylinder {
        < -20, 0, 150 >,
        < -70, 0, 250 >,
        LSMHeadRadius
      }
      translate < 35, LSMHeadRadius + 0.5, 0 >
    }
    texture { Tx_Snow }
  }
#end
