////////////////////////////////////////////////////////////////////////////////
//
// LSnowman.inc -- Large snowman for SnoBuild.pov (IRTC 3-4/2003)
//                 by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

#declare LargeSnowman =
  union {
    union {
      sphere {
        < 0, LSMBottomCenterY, 0 >,
        LSMBottomRadius
      }
      sphere {
        < 0, LSMMiddleCenterY, 0 >,
        LSMMiddleRadius
      }
      sphere {
        < 0, LSMHeadCenterY, 0 >,
        LSMHeadRadius
      }
      object {
        Carrot()
        scale   9
        rotate 90 * y
        translate < 0, LSMHeadCenterY, -(LSMHeadRadius - 1) >
      }
      texture { Tx_Snow }
    }
    PlaceCoal( < 0, LSMBottomCenterY, 0 >, LSMBottomRadius,   0,   0, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMBottomCenterY, 0 >, LSMBottomRadius, -15,   0, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMBottomCenterY, 0 >, LSMBottomRadius, -30,   0, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMMiddleCenterY, 0 >, LSMMiddleRadius,  30,   0, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMMiddleCenterY, 0 >, LSMMiddleRadius,  15,   0, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMMiddleCenterY, 0 >, LSMMiddleRadius,   0,   0, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMHeadCenterY,   0 >, LSMHeadRadius,   -20,  20, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMHeadCenterY,   0 >, LSMHeadRadius,   -20, -20, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMHeadCenterY,   0 >, LSMHeadRadius,    15, -30, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMHeadCenterY,   0 >, LSMHeadRadius,    25, -15, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMHeadCenterY,   0 >, LSMHeadRadius,    30,   0, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMHeadCenterY,   0 >, LSMHeadRadius,    25,  15, 1, 1, 1, 1 )
    PlaceCoal( < 0, LSMHeadCenterY,   0 >, LSMHeadRadius,    15,  30, 1, 1, 1, 1 )
  }
