////////////////////////////////////////////////////////////////////////////////
//
// SSnowman.inc -- Small snowman for SnoBuild.pov (IRTC 3-4/2003)
//                 by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

#macro BCTemplate(r)
  #local sep = 1.1;
  intersection {
    difference {
      cylinder {
        < -r / 2, 0, 0 >,
        <  r / 2, 0, 0 >,
        r
      }
      union {
        sphere {
          < 0, 0, 0 >,
          r * sep
          scale     < 1 / sep, 1, 1 >
          translate < -r / 2,  0, 0 >
        }
        sphere {
          < 0, 0, 0 >,
          r * sep
          scale     < 1 / sep, 1, 1 >
          translate < r / 2,   0, 0 >
        }
      }
    }
    plane { -z (-r * 0.6) }
  }
#end


#macro SSM(headAngle, lArmAngle, rArmAngle)

  #local BottomRadius  = SSMBottomRadius * RVar(SSMScaleVariance);
  #local MiddleRadius  = SSMMiddleRadius * RVar(SSMScaleVariance);
  #local HeadRadius    = SSMHeadRadius   * RVar(SSMScaleVariance);
  
  #local BottomX       = RVar(SSMLopsideFactor);
  #local BottomY       = RVar(SSMLopsideFactor);
  #local BottomZ       = RVar(SSMLopsideFactor);
  
  #local MiddleX       = RVar(SSMLopsideFactor);
  #local MiddleY       = RVar(SSMLopsideFactor);
  #local MiddleZ       = RVar(SSMLopsideFactor);
  
  #local HeadX         = RVar(SSMLopsideFactor);
  #local HeadY         = RVar(SSMLopsideFactor);
  #local HeadZ         = RVar(SSMLopsideFactor);
  
  #local BottomCenterY = BottomRadius * BottomY;
  #local MiddleCenterY = BottomCenterY * 2 + MiddleRadius * MiddleY - SSMLowerOverlap;
  #local HeadCenterY   = MiddleCenterY + (MiddleRadius * MiddleY) + (HeadRadius * HeadY) - SSMUpperOverlap;

  intersection {
    union {
      difference {
        sphere {
          < 0, 0, 0 >, BottomRadius
        }
        object {
          BCTemplate(BottomRadius)
        }
        scale < BottomX, BottomY, BottomZ >
        translate < 0, BottomCenterY, 0 >
        texture { Tx_Snow }
      }
      union {
        sphere {
          < 0, 0, 0 >, MiddleRadius
          scale < MiddleX, MiddleY, MiddleZ >
          texture { Tx_Snow }
        }
        object {
          RightArm(rand(RS))
          rotate < rArmAngle, 0, 0 >
          translate < -(MiddleRadius * MiddleX - 0.1), 0, 0 >
        }
        object {
          LeftArm(rand(RS))
          rotate < lArmAngle, 0, 0 >
          translate < MiddleRadius * MiddleX - 0.1, 0, 0 >
        }
        translate < 0, MiddleCenterY, 0 >
      }
      union {
        sphere {
          < 0, 0, 0 >, HeadRadius
          texture { Tx_Snow }
          scale < HeadX, HeadY, HeadZ >
        }
        object {
          Carrot()
          scale .9
          rotate 90*y
          translate < 0, 0, -(HeadRadius * HeadZ - 0.1) >
        }
        object {
          Hat()
          scale SSMHeadRadius * max(HeadX, HeadZ)
          translate < 0, SSMHeadRadius * HeadY * .5, 0 >
        }
        rotate headAngle*x
        translate < 0, HeadCenterY, 0 >
      }
      PlaceCoal( < 0, BottomCenterY, 0 >, BottomRadius,   0,   0, BottomX, BottomY, BottomZ, 1 / SSMScaleFactor )
      PlaceCoal( < 0, BottomCenterY, 0 >, BottomRadius, -15,   0, BottomX, BottomY, BottomZ, 1 / SSMScaleFactor )
      PlaceCoal( < 0, BottomCenterY, 0 >, BottomRadius, -30,   0, BottomX, BottomY, BottomZ, 1 / SSMScaleFactor )

      PlaceCoal( < 0, MiddleCenterY, 0 >, MiddleRadius, -30,   0, MiddleX, MiddleY, MiddleZ, 1 / SSMScaleFactor )
      PlaceCoal( < 0, MiddleCenterY, 0 >, MiddleRadius, -15,   0, MiddleX, MiddleX, MiddleZ, 1 / SSMScaleFactor )
      PlaceCoal( < 0, MiddleCenterY, 0 >, MiddleRadius,   0,   0, MiddleX, MiddleX, MiddleZ, 1 / SSMScaleFactor )
      PlaceCoal( < 0, MiddleCenterY, 0 >, MiddleRadius,  15,   0, MiddleX, MiddleX, MiddleZ, 1 / SSMScaleFactor )
      PlaceCoal( < 0, MiddleCenterY, 0 >, MiddleRadius,  30,   0, MiddleX, MiddleY, MiddleZ, 1 / SSMScaleFactor )

      PlaceCoal( < 0, HeadCenterY,   0 >, HeadRadius,   -20,  20, HeadX,   HeadY,   HeadZ,   1 / SSMScaleFactor )
      PlaceCoal( < 0, HeadCenterY,   0 >, HeadRadius,   -20, -20, HeadX,   HeadY,   HeadZ,   1 / SSMScaleFactor )

      PlaceCoal( < 0, HeadCenterY,   0 >, HeadRadius,    15, -30, HeadX,   HeadY,   HeadZ,   1 / SSMScaleFactor )
      PlaceCoal( < 0, HeadCenterY,   0 >, HeadRadius,    25, -15, HeadX,   HeadY,   HeadZ,   1 / SSMScaleFactor )
      PlaceCoal( < 0, HeadCenterY,   0 >, HeadRadius,    30,   0, HeadX,   HeadY,   HeadZ,   1 / SSMScaleFactor )
      PlaceCoal( < 0, HeadCenterY,   0 >, HeadRadius,    25,  15, HeadX,   HeadY,   HeadZ,   1 / SSMScaleFactor )
      PlaceCoal( < 0, HeadCenterY,   0 >, HeadRadius,    15,  30, HeadX,   HeadY,   HeadZ,   1 / SSMScaleFactor )
    }
    plane { -y, -SSMSitDepth texture { Tx_Snow } }
    translate < 0, -SSMSitDepth, 0 >
  }
  
#end
