////////////////////////////////////////////////////////////////////////////////
//
// Scaffold.inc -- Scaffolding for SnoBuild.pov (IRTC 3-4/2003)
//                 by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

#macro Scaffold(scfWidth, scfDepth, scfHeight, numVerticals, numBraces, boardOverhang)

  #local frameWidth  = scfWidth - ScfBarDiameter;
  #local frameX      = ScfBarRadius;
  #local frameHeight = scfHeight - ScfBarRadius - ScfBoardHeight;

  union {
    union {
      #local i = 0;
      #while (i < numVerticals)
        cylinder {
          < frameWidth / (numVerticals - 1) * i,           0, 0 >,
          < frameWidth / (numVerticals - 1) * i, frameHeight, 0 >,
          ScfBarRadius
        }
        cylinder {
          < frameWidth / (numVerticals - 1) * i,           0, scfDepth >,
          < frameWidth / (numVerticals - 1) * i, frameHeight, scfDepth >,
          ScfBarRadius
        }
        #local i = i + 1;
      #end
      cylinder {
        <          0, frameHeight, 0 >,
        < frameWidth, frameHeight, 0 >,
        ScfBarRadius
      }
      cylinder {
        < 0, frameHeight,        0 >,
        < 0, frameHeight, scfDepth >,
        ScfBarRadius
      }
      cylinder {
        <          0, frameHeight, scfDepth >,
        < frameWidth, frameHeight, scfDepth >,
        ScfBarRadius
      }
      cylinder {
        < frameWidth, frameHeight,        0 >,
        < frameWidth, frameHeight, scfDepth >,
        ScfBarRadius
      }
      sphere {
        < 0, frameHeight, 0 >,
        ScfBarRadius
      }
      sphere {
        < frameWidth, frameHeight, 0 >,
        ScfBarRadius
      }
      sphere {
        < 0, frameHeight, scfDepth >,
        ScfBarRadius
      }
      sphere {
        < frameWidth, frameHeight, scfDepth >,
        ScfBarRadius
      }
      #local i = 1;
      #local d = 1;
      #while (i <= numBraces)
        #local y0 = (frameHeight / (numBraces + 1)) * i;
        #local y1 = (frameHeight / (numBraces + 1)) * (i + 1);
        #local j = 0;
        #while (j < numVerticals)
          #local x0 = frameWidth / (numVerticals - 1) * j;
          cylinder {
            < x0, y0,        0 >,
            < x0, y0, scfDepth >,
            ScfBarRadius
          }
          #local j = j + 1;
        #end
        #local j = 0;
        #while (j < numVerticals - 1)
          #local x0 = frameWidth / (numVerticals - 1) * j;
          #local x1 = frameWidth / (numVerticals - 1) * (j + 1);
          #if (d = 0)
            cylinder {
              < x0, y0, 0 >,
              < x1, y1, 0 >,
              ScfBarRadius
            }
            cylinder {
              < x0, y1, scfDepth >,
              < x1, y0, scfDepth >,
              ScfBarRadius
            }
          #else
            cylinder {
              < x0, y1, 0 >,
              < x1, y0, 0 >,
              ScfBarRadius
            }
            cylinder {
              < x0, y0, scfDepth >,
              < x1, y1, scfDepth >,
              ScfBarRadius
            }
          #end
          #local d = 1 - d; 
          #local j = j + 1;
        #end
        #local i = i + 1;
      #end
      texture { Tx_Scaffold_Metal }
    }
    union {
      #local numBoards = floor((scfDepth - ScfBarDiameter) / ScfBoardWidth);
      #local boardGap = ((scfDepth - ScfBarDiameter) - numBoards * ScfBoardWidth) / (numBoards - 1);
      #local i = 0;
      #while (i < numBoards)
        box {
          <             -boardOverhang, frameHeight + ScfBarRadius,                  ScfBarRadius + (ScfBoardWidth + boardGap) * i >,
          < frameWidth + boardOverhang, frameHeight + ScfBarRadius + ScfBoardHeight, ScfBarRadius + (ScfBoardWidth + boardGap) * i + ScfBoardWidth >
        }
        #local i = i + 1;
      #end
      texture { Tx_Scaffold_Wood }
    }
    translate < frameX, 0, 0 >
  }
#end
