////////////////////////////////////////////////////////////////////////////////
//
// Snowfall.inc -- Falling snow for SnoBuild.pov (IRTC 3-4/2003)
//                 by Peter D. Dunlap
//
////////////////////////////////////////////////////////////////////////////////

#macro Snowfall(minZ, maxZ, numSteps, mapBaseNear, mapWidthNear, mapBaseFar, mapWidthFar, smear)
  #local rStream = seed(2332);
  union {
    #local i = 0;
    #while (i < numSteps)
      #local map1 = mapBaseNear + (mapBaseFar - mapBaseNear) / (numSteps - 1) * i;
      #local map2 = map1 + mapWidthNear + (mapWidthFar - mapWidthNear) / (numSteps - 1) * i;
      box {
        < -1000,    0, -.001 >,
        <  1000, 1000,  .001 >
        hollow
        no_shadow
        no_reflection
        texture {
          pigment {
            granite
            color_map {
              [ 0.00 rgbt < 1, 1, 1, 1 > ]
              [ map1 rgbt < 1, 1, 1, 1 > ]
              [ map2 rgbt < 1, 1, 1, 0 > ]
              [ 1.00 rgbt < 1, 1, 1, 0 > ]
            }
          }
          finish {
            ambient 1
            diffuse 0
          }
          scale  < 1, smear, 1 >
          rotate < 0, 0, 90 * rand(rStream) - 45 >
        }
        translate < 0, 0, minZ + (maxZ - minZ ) / ( numSteps - 1) * i >
      }
      #local i = i + 1;
    #end
  }
#end
