// Blob macro
// Copyright (C) 2003 Nicolas P. Rougier (rougier@loria.fr)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------
// Persistence of Vision Ray Tracer Scene Description File
// File: blob.inc
// Vers: 3.5
// Desc: A blob 
// Date: 06/2003
// Auth: Nicolas Rougier
// Cmd : 
// ---------------------------------------------------------------------------
#include "transforms.inc"

// ==== Cartoon texture by T.J.Viking ==== //
//  (see news:povray.advanced-users, thread on toon rendering)
#macro
cartoon_texture(cam_loc, edge,edge_color,base_color,light_hardness,light_ambience,obj_center)
texture {
  pigment {
    slope obj_center-cam_loc
    color_map {
      [0.00 color rgb base_color ]
      [0.5-edge-0.01 color rgb base_color ]
      [0.5-edge color rgb edge_color ]
      [0.5+edge color rgb edge_color ]
      [0.5+edge+0.01 color rgb base_color ]
      [1.00 color rgb base_color ]
    }
  }
  finish {
    //reflection reflx
    specular 0 ambient light_ambience diffuse 1 brilliance 1-light_hardness
  }
}
#end

// ==== Some quick spheric to cartesian conversion macro ==== //
#macro spheric (rho,theta,phi)
<rho*sin(theta)*sin(phi), rho*cos(theta), rho*sin(theta)*cos(phi)>
#end


// ==== The blobby macro ==== //
#macro blobby (rseed, cam_loc, _edge, _size, _eye_size, _position, _rotation, _look_at, _color, _fast)
union {
  #local left_eye_pos   = spheric (1.25*_size, pi/3+pi/12, pi+pi/8);
  #local right_eye_pos  = spheric (1.25*_size, pi/3+pi/12, pi-pi/8);
  #local eye_radius     = .7*_size;
  #local st             = seed (rseed);
  // Body
  #if (_fast)
    sphere {
      0,1.5*_size
      cartoon_texture(cam_loc, 0.13*_edge,<0,0,0>,_color, 0.8, 0.2, _position)
    }
  #else
    difference {
      blob {
	threshold .5
	#local i=0;
	#while (i< 200)
	  #local rho=1*_size;
	  #local theta=rand(st)*2*pi;
	  #local phi=rand(st)*2*pi;
	  sphere {spheric(rho, theta, phi), .8*_size, .75}
	  #local i=i+1;
	#end
	sphere {left_eye_pos,  .65*_size, -2.5}
	sphere {right_eye_pos, .65*_size, -2.5}
	cartoon_texture(cam_loc, 0.13*_edge,<0,0,0>,_color, 0.8, 0.2, _position)
      }
      sphere {
	0, eye_radius*1.01
	Axial_Scale_Trans(left_eye_pos, .5)
	translate left_eye_pos
	texture {pigment {rgb _color} finish {specular 0 ambient .2  diffuse 1 brilliance .2}}
      }
      sphere {
	0, eye_radius*1.01
	Axial_Scale_Trans(right_eye_pos, .5)
	translate right_eye_pos
	texture {pigment {rgb _color} finish {specular 0 ambient .2  diffuse 1 brilliance .2}}	
      }      
    }
  #end
  
  // Left eye
  #declare left_eye =
  sphere {
    0, eye_radius
    Axial_Scale_Trans(left_eye_pos, .5)
    translate left_eye_pos
    cartoon_texture(cam_loc,0.13*_edge,<0,0,0>,<1,1,1>,0.8,0.2, _position+left_eye_pos)
  }
  object {left_eye}
  // Here we search for where to look for left eye...
  #local Normal=<0, 0, 0>;
  #local Where = trace (left_eye,
                        vrotate (_look_at -_position, -_rotation),
                        left_eye_pos-vrotate (_look_at -_position, -_rotation),
                        Normal);  
  #if (Normal.x = 0 & Normal.y = 0 & Normal.z = 0)
    #warning "Left eye not placed\n"
  #else
    sphere {
      0, 0.045*_eye_size
      Axial_Scale_Trans(Normal, .25)
      translate Where
      texture {pigment {rgb 0} finish {specular 0 ambient .2  diffuse 1 brilliance .2}}
      no_shadow
    }
  #end
  
  // Right eye
  #declare right_eye =
  sphere {
    0, eye_radius
    Axial_Scale_Trans(right_eye_pos, .5)
    translate right_eye_pos
    cartoon_texture(cam_loc,0.13*_edge,<0,0,0>,<1,1,1>,0.8,0.2, _position+right_eye_pos)
  }
  object {right_eye}
  // Here we search for where to look for right eye...
  #local Normal=<0, 0, 0>;
  #local Where = trace (right_eye,
                        vrotate (_look_at -_position, -_rotation),
                        right_eye_pos-vrotate (_look_at -_position, -_rotation),
                        Normal);
  #if (Normal.x = 0 & Normal.y = 0 & Normal.z = 0)
    #warning "Right eye not placed\n"
  #else
    sphere {
      0, 0.045*_eye_size
      Axial_Scale_Trans(Normal, .25)
      translate Where
      texture {pigment {rgb 0} finish {specular 0 ambient .2  diffuse 1 brilliance .2}}
      no_shadow
    }
  #end
  scale 1.0/1.8
  rotate _rotation
  translate _position
}
#end
