// mausoleos.inc
// mausoleos para la escena "Camposanto", hecha para la IRTC
// luisvaloyes, Bogot, Colombia
// www.luisvaloyes.uni.cc

#include "puertas.inc"

//texturas para los mausoleos
#declare marmolejo01 = texture {
pigment {bozo color_map {[.1 rgb <.7,.7,.6>][.4 rgb <.8,.75,.66>][.7 rgb <.66,.6,.5>][.85 rgb <.75,.7,.62>]} scale .025}
normal {granite 1} finish {reflection .01 specular .3 ambient .2}}

#declare marmolejo01b = texture {
pigment {bozo color_map {[.1 rgb <.7,.7,.6>][.4 rgb <.8,.75,.66>][.65 rgb <.8,.75,.66>][.7 rgb <0,.5,.2>][.75 rgb <.8,.75,.66>]
[.85 rgb <.75,.7,.62>]} scale <.25,2,.25>}
normal {granite 1} finish {specular .3 ambient .2}}

#declare marmolejo02 = texture {
pigment {bozo color_map {[.1 rgb <.8,.7,.6>][.4 rgb <.9,.75,.66>][.7 rgb <.76,.6,.5>][.85 rgb <.85,.7,.62>]} scale .025}
normal {granite 1} finish {reflection .01 specular .3 ambient .2}}

#declare marmolejo02b = texture {
pigment {bozo color_map {[.1 rgb <.8,.7,.6>][.4 rgb <.9,.75,.66>][.65 rgb <.9,.75,.66>][.7 rgb <0,.5,.2>][.75 rgb <.9,.75,.66>]
[.85 rgb <.85,.7,.62>]} scale <.25,2,.25>}
normal {granite 1} finish {specular .3 ambient .2}}

#declare marmolejo03 = texture {
pigment {bozo color_map {[.1 rgb <.6,.6,.6>][.4 rgb <.7,.7,.7>][.7 rgb <.67,.67,.67>][.85 rgb <.75,.7,.72>]} scale .025}
normal {granite 1} finish {reflection .01 specular .3 ambient .2}}

#declare marmolejo03b = texture {
pigment {bozo color_map {[.1 rgb <.6,.6,.6>][.4 rgb <.7,.7,.7>][.7 rgb <.67,.67,.67>][.7 rgb <0,.5,.2>][.75 rgb <.67,.67,.67>]
[.85 rgb <.75,.7,.72>]} scale <.25,2,.25>}
normal {granite 1} finish {specular .3 ambient .2}}

//los mausoleos

#declare mausoleo01 = union {
//la base
union {box {<-.5,0,-.5><.5,1,.5> scale <31,1.5,46>}
box {<-.5,0,-.5><.5,1,.5> scale <28,1.5,43> translate <0,1.5,0>}
box {<-.5,0,-.5><.5,1,.5> scale <25,1.5,40> translate <0,3,0>}
texture {marmolejo01b}}
// columnas
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <11,4.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <-11,4.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <-11,4.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <11,4.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1,20,1> translate <11,5.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1,20,1> translate <-11,5.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1,20,1> translate <-11,5.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1,20,1> translate <11,5.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <11,25.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <-11,25.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <-11,25.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <11,25.5,-18.5>}
// muros
box {<-.5,0,-.5><.5,1,.5> scale <22,22,2> translate <0,4.5,-16>}
box {<-.5,0,-.5><.5,1,.5> scale <6,22,2> translate <8,4.5,16>}
box {<-.5,0,-.5><.5,1,.5> scale <6,22,2> translate <-8,4.5,16>}
box {<-.5,0,-.5><.5,1,.5> scale <10,2,2> translate <0,24.5,16>}
box {<-.5,0,-.5><.5,1,.5> scale <2,22,37> translate <10,4.5,0>}
box {<-.5,0,-.5><.5,1,.5> scale <2,22,37> translate <-10,4.5,0>}
// vigas
box {<-.5,0,-.5><.5,1,.5> scale <3,3,40> translate <11,26.5,0>}
box {<-.5,0,-.5><.5,1,.5> scale <3,3,40> translate <-11,26.5,0>}
box {<-.5,0,-.5><.5,1,.5> scale <25,3,3> translate <0,26.5,18.5>}
box {<-.5,0,-.5><.5,1,.5> scale <25,3,3> translate <0,26.5,-18.5>}
//friso frontal
difference {union {
prism {linear_sweep linear_spline -1, 1, 4, < 12.5, 0>, < -12.5,  0>, < 0, 10>,<12.5, 0>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <3,3,3> translate <0,0,4>}}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,4,2> translate <0,0,4>}
rotate <-90,0,0> translate <0,29.5,19>}
text {ttf "gothice_.ttf", "Colombia", 1, 0 rotate <0,180,0> scale <3,3,1> translate <8,28,20.5>}
//friso posterior
prism {linear_sweep linear_spline -1, 1, 4, < 12.5, 0>, < -12.5,  0>, < 0, 10>,<12.5, 0> rotate <-90,0,0> translate <0,29.5,-19>}
//la puerta
object {puerta01 translate <0,4.5,16>}
// techo
union {
cylinder {<0,-.5,0><0,.5,0> 1 scale <1,36,1> rotate <90,0,0> pigment {rgb <.8,.35,0>}}
box {<0,-.5,-.5><1,.5,.5> scale <13,.5,36> rotate <0,0,-38> translate <.5,0,0> pigment {rgb <.8,.35,0>} 
normal {bump_map {gif "tejado01.gif" map_type 0 bump_size 50} scale 2 rotate <0,0,-128>}}
box {<-1,-.5,-.5><0,.5,.5> scale <13,.5,36> rotate <0,0,38> translate <-.5,0,0> pigment {rgb <.8,.35,0>} 
normal {bump_map {gif "tejado01.gif" map_type 0 bump_size 50} scale 2 rotate <0,0,128>}}
translate <0,37.5,0>}
texture {marmolejo01}}

#declare mausoleo02 = union {
//la base
union {
box {<-.5,0,-.5><.5,1,.5> scale <25,4.5,40>}
box {<-.5,0,-.5><.5,1,.5> scale <10,4.5,3> translate <0,0,21.5>}
box {<-.5,0,-.5><.5,1,.5> scale <.5,5.5,4.5> translate <5.25,0,20.75>}
box {<-.5,0,-.5><.5,1,.5> scale <.5,5.5,4.5> translate <-5.25,0,20.75>}
box {<-.5,0,-.5><.5,1,.5> scale <10,3,3> translate <0,0,24.5>}
box {<-.5,0,-.5><.5,1,.5> scale <.5,4,3> translate <5.25,0,24.5>}
box {<-.5,0,-.5><.5,1,.5> scale <.5,4,3> translate <-5.25,0,24.5>}
box {<-.5,0,-.5><.5,1,.5> scale <10,1.5,3> translate <0,0,27.5>}
box {<-.5,0,-.5><.5,1,.5> scale <.5,2.5,3> translate <5.25,0,27.5>}
box {<-.5,0,-.5><.5,1,.5> scale <.5,2.5,3> translate <-5.25,0,27.5>}
texture {marmolejo02b}}
//las columnas
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <11,4.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <-11,4.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <-11,4.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <11,4.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1,20,1> translate <11,5.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1,20,1> translate <-11,5.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1,20,1> translate <-11,5.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1,20,1> translate <11,5.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <11,25.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <-11,25.5,18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <-11,25.5,-18.5>}
cylinder {<0,0,0><0,1,0> 1 scale <1.5,1,1.5> translate <11,25.5,-18.5>}
//los muros secundarios
box {<-.5,0,-.5><.5,1,.5> scale <25,22,2> translate <0,4.5,-17.5>}
box {<-.5,0,-.5><.5,1,.5> scale <2,22,37> translate <11.5,4.5,0>}
box {<-.5,0,-.5><.5,1,.5> scale <2,22,37> translate <-11.5,4.5,0>}
//el muro frontal
difference {union {box {<-.5,0,-.5><.5,1,.5> scale <25,22,2>} box {<-.5,0,-.5><.5,1,.5> scale <11,17,3.5>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <5.5,3.5,3.5> rotate <90,0,0> translate <0,17,0>}}
union { box {<-.5,0,-.5><.5,1,.5> scale <10,17,4>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <5,4,3> rotate <90,0,0> translate <0,17,0>}}
translate <0,4.5,17.5>}
// vigas
box {<-.5,0,-.5><.5,1,.5> scale <3,2,40> translate <11,26.5,0>}
box {<-.5,0,-.5><.5,1,.5> scale <3,2,40> translate <-11,26.5,0>}
box {<-.5,0,-.5><.5,1,.5> scale <25,2,3> translate <0,26.5,18.5>}
box {<-.5,0,-.5><.5,1,.5> scale <25,2,3> translate <0,26.5,-18.5>}
//friso frontal
difference {union{
prism {linear_sweep linear_spline -1.5, 1.5, 4, < 12.5, 0>, < -12.5,  0>, < 0, 10>,<12.5, 0>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <9,3,7> translate <0,0,10>}}
union {difference{
prism {linear_sweep linear_spline -2,0, 4, < 12.5, 0>, < -12.5,  0>, < 0, 10>,<12.5, 0> scale .8}
cylinder {<0,-.5,0><0,.5,0> 1 scale <9,3,7> translate <0,0,10>}
translate <0,-.5,0>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <7.5,4,5.5> translate <0,0,10>}
box {<-1,-.5,-.5><0,.5,.5> scale <15,15,15> rotate <0,-35,0> translate <0,0,18.5> }
box {<0,-.5,-.5><1,.5,.5> scale <15,15,15> rotate <0,35,0> translate <0,0,18.5> }}
rotate <-90,0,0> translate <0,28.5,18.5>}
text {ttf "latinwd.ttf","IRTC", 1, 0 scale <3,3,1> rotate <0,180,0> translate <7,29,19.5>}
//cruz sobre el friso
union {
sphere {<0,0,0> 1 scale <1.5,1,1.5>}
box {<-.5,0,-.5><.5,1,.5> scale <1,6,1>}
box {<-.5,0,-.5><.5,1,.5> scale <4,1,1> translate <0,3.5,0>}
translate <0,32.5,18.5>}
// friso posterior
difference {
prism {linear_sweep linear_spline -1, 1, 4, < 12.5, 0>, < -12.5,  0>, < 0, 10>,<12.5, 0>}
union {cylinder {<0,-.5,0><0,.5,0> 1 scale <7.5,4,5.5> translate <0,0,10>}
box {<-1,-.5,-.5><0,.5,.5> scale <15,15,15> rotate <0,-35,0> translate <0,0,18.5> }
box {<0,-.5,-.5><1,.5,.5> scale <15,15,15> rotate <0,35,0> translate <0,0,18.5> }}
rotate <-90,0,0> translate <0,28.5,-18.5>}
//la puerta
object {puerta02 translate <0,4.5,17.5>}
// techo
union {
box {<-.5,-.5,-.5><.5,.5,.5> scale <12,.5,36> pigment {rgb <.7,.2,0>}}
cylinder {<0,-.5,0><0,.5,0> 1 scale <1,36,1> rotate <90,0,0> translate <6,0,0> pigment {rgb <.7,.2,0>}}
cylinder {<0,-.5,0><0,.5,0> 1 scale <1,36,1> rotate <90,0,0> translate <-6,0,0> pigment {rgb <.7,.2,0>}}
box {<0,-.5,-.5><1,.5,.5> scale <6,.5,36> rotate <0,0,-38> translate <6,0,0> pigment {rgb <.7,.2,0>} 
normal {bump_map {gif "tejado01.gif" map_type 0 bump_size 50} scale 2 rotate <0,0,-128>}}
box {<-1,-.5,-.5><0,.5,.5> scale <6,.5,36> rotate <0,0,38> translate <-6,0,0> pigment {rgb <.7,.2,0>} 
normal {bump_map {gif "tejado01.gif" map_type 0 bump_size 50} scale 2 rotate <0,0,128>}}
translate <0,32,0> }
texture {marmolejo02}}

#declare mausoleo03 = union {
//la base
union {
box {<-.5,0,-.5><.5,1,.5> scale <27,3,42>}
box {<-.5,0,-.5><.5,1,.5> scale <10,1.5,3> translate <0,0,21.5>}
cylinder {<0,0,0><0,1,0> 1 scale <2,1.5,1.5> translate <5,0,21.5>}
cylinder {<0,0,0><0,1,0> 1 scale <2,1.5,1.5> translate <-5,0,21.5>}
texture {marmolejo03b}}
//muros
box {<-.5,0,-.5><.5,1,.5> scale <7.5,22,2> translate <8.75,3,19>}
box {<-.5,0,-.5><.5,1,.5> scale <7.5,22,2> translate <-8.75,3,19>}
box {<-.5,0,-.5><.5,1,.5> scale <25,22,2> translate <0,3,-19>}
box {<-.5,0,-.5><.5,1,.5> scale <10,7,2> translate <0,23,19>}
box {<-.5,0,-.5><.5,1,.5> scale <21,2,2> translate <0,25,19>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,2,2> rotate <90,0,0> translate <10.5,25,19>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,2,2> rotate <90,0,0> translate <-10.5,25,19>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,2,3.5> rotate <90,0,0> translate <5,26.5,19>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,2,3.5> rotate <90,0,0> translate <-5,26.5,19>}
text {ttf "maturasc.ttf","luisvaloyes", 1, 0 rotate <0,180,0> scale <3,3,1> translate <7,24.5,20.5>}
box {<-.5,0,-.5><.5,1,.5> scale <3,1,2> translate <0,30,19>}
box {<-.5,0,-.5><.5,1,.5> scale <2,22,36> translate <11.5,3,0>}
box {<-.5,0,-.5><.5,1,.5> scale <2,22,36> translate <-11.5,3,0>}
box {<-.5,0,-.5><.5,1,.5> scale <25,22,2> translate <0,3,-19>}
box {<-.5,0,-.5><.5,1,.5> scale <10,7,2> translate <0,23,-19>}
box {<-.5,0,-.5><.5,1,.5> scale <21,2,2> translate <0,25,-19>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,2,2> rotate <90,0,0> translate <10.5,25,-19>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,2,2> rotate <90,0,0> translate <-10.5,25,-19>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,2,3.5> rotate <90,0,0> translate <5,26.5,-19>}
cylinder {<0,-.5,0><0,.5,0> 1 scale <2,2,3.5> rotate <90,0,0> translate <-5,26.5,-19>}
//la cruz
box {<-.5,0,-.5><.5,1,.5> scale <.5,3,.5> translate <0,31,19>}
box {<-.5,0,-.5><.5,1,.5> scale <1.75,.5,.5> translate <0,33,19>}
//las copas
cylinder {<0,0,0><0,1,0> 1 translate <8.75,26.5,19>}
lathe {quadratic_spline 8, <1,0>, <.6,.3>, <.2,.4>, <.2,.8>, <.5,1>, <.7,1.5>, <.9,1.9>, <1,2.1> pigment {rgb<.6,.55,.4>} finish 
{metallic brilliance .1 specular .1 roughness .3 reflection .1 phong .05} translate <8.75,27.5,19>}
cylinder {<0,0,0><0,1,0> 1 translate <-8.75,26.5,19>}
lathe {quadratic_spline 8, <1,0>, <.6,.3>, <.2,.4>, <.2,.8>, <.5,1>, <.7,1.5>, <.9,1.9>, <1,2.1> pigment {rgb<.6,.55,.4>} finish {metallic brilliance .1 specular .1 roughness .3 reflection .1 phong .05} translate <-8.75,27.5,19>}
object {puerta03 translate <0,3,19>}
light_source {<0,18,0> rgb <1,.75,0>} 
cone {<0,0,0> 5 <0,1,0> 0 open scale <1,3,1> rotate <-90,0,0> translate <0,18,1> 
pigment {rgb 1} finish {metallic reflection 1 specular 1}}
// techo
union {
cylinder {<0,-.5,0><0,.5,0> 1 scale <1,36,1> rotate <90,0,0> pigment {rgb <.8,.35,0>}}
box {<0,-.5,-.5><1,.5,.5> scale <11,.5,36> rotate <0,0,-15> translate <.5,0,0> pigment {rgb <.8,.35,0>} 
normal {bump_map {gif "tejado01.gif" map_type 0 bump_size 50} scale 2 rotate <0,0,-105>}}
box {<-1,-.5,-.5><0,.5,.5> scale <11,.5,36> rotate <0,0,15> translate <-.5,0,0> pigment {rgb <.8,.35,0>} 
normal {bump_map {gif "tejado01.gif" map_type 0 bump_size 50} scale 2 rotate <0,0,105>}}
translate <0,28,0>}
texture {marmolejo03}}