// Persistence of Vision Ray Tracer Scene Description File
// File: jumper.pov
// Vers: 3.5
// Desc: File for Irtc May-June 2003 - topic "Mistery"
// Start Date: 23/05/2003
// End Date :29/06/2003
// Auth: Bruno Gimeno

#declare lamp_mode = 2 ;

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "rad_def.inc"
#include "woods.inc"
#include "objects.inc"
/* // meshes are not included, sorry
#include "hombre1.inc"	#include "saltador.inc"
#include "falconet.inc"	#include "discobolo.inc"
#include "archer.inc"	#include "pensador3.inc"
#include "chico.inc"	#include "chico1.inc"
#include "chico.inc"	#include "mujer2.inc"
#include "mujer.inc"	#include "hombre.inc"
*/

global_settings {

radiosity { Rad_Settings(Radiosity_Default, off, off)            
           save_file "jumper"
       //  load_file "jumper"
          }  
}


sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

camera { // vista final
 location <0,0,0>
 look_at  <0,0,5> 
 rotate y*55
 translate <0,14,-22>
}
/*
// detalle pensador2 y sofa
camera { location <0,0,0> look_at <0,0,5> rotate x*20 rotate y*130  translate <50,14,10> }
// detalle2 pensador2 y sofa
camera { location <0,0,0> look_at <0,0,5> rotate x*10 rotate y*100 translate <53,8,-8> } 
// detalle2 pensador2 y sofa
camera { location <0,0,0> look_at <0,0,5> rotate x*10 rotate y*100 translate <53,8,-8> }
// vista frontal desde el sur
camera { location <0,0,0> look_at <0,0,5> translate <180,15,-120> }
// detalle seal salida
camera { location <0,0,0> look_at  <0,0,5> direction 20*z rotate y*76 translate <0,14,-22> }
// vista top
camera { location <0,0,0> look_at  <0,-1,0> translate <0,250,0> }
// vista papelera
camera { location <28,6,18>  look_at <25,3,24.5> }
// vista altillo - parte superior

//camera { location <120,35,10>  look_at <200,10,-25> }

//camera { location <120,35,-15>  look_at <200,10,25> }
// vista altillo - parte inferior
camera { location <155,15,25>  look_at <195,10,-25> }

// vista columna - parte inferior
camera { location <90,31,4>  look_at <155,12,0> }
// vista mujer con tejano y camiseta blanca
camera { location <27,14,3>  look_at <36,5,-5> }
*/
#declare TECHO = 45 ;

object {lamp translate <-10,TECHO-.5,10>}
object {lamp translate <-10,TECHO-.5,-10>}

object {lamp translate <40,TECHO-.5,10>}
object {lamp translate <40,TECHO-.5,-10>}

object {lamp translate <90,TECHO-.5,10>}
object {lamp translate <90,TECHO-.5,-10>}

object {lamp translate <140,TECHO-.5,10>}
object {lamp translate <140,TECHO-.5,-10>}


object {lamp translate <175,TECHO-.5,-17.5>} // luces del altillo
object {lamp translate <175,24,-17.5>} // luces del altillo

object {lamp translate <180,TECHO-.5,30>}
object {lamp translate <180,TECHO-.5,50>}
object {lamp translate <180,TECHO-.5,70>}

light_source {
 <800,4200,-5000> colour rgb 1.075
 parallel
 point_at <0,0,0> 
}

union {
// techo
 union {
   box {<-95,TECHO,-35>,<200,TECHO+1,30> }
   box {<160,TECHO,30>,<200,TECHO+1,190> }
 pigment {Gray50}
 }
 
// pared norte con hueco puerta sala 1 y ventanas, color cielo
union {
  
 box {<-35,21,25>,<-20,TECHO,30>}
 
 difference {   
   union {
      box {<-20,0,25>,<159.999,TECHO,27.5>}
      box {<-20,0,27.5>,<159.999,TECHO,30> pigment {White} }    
   }
   #declare num_Windows_1 = 0 ; // cero numero de ventanas
   #while (num_Windows_1>0)
   object {
    box {<-20,7,21>,<0,35,31>}
    translate x*30*num_Windows_1
   }
   #declare num_Windows_1 = num_Windows_1-1 ;
   #end  
 }  
  texture { 
   pigment {
    agate
    agate_turb 0.6
    color_map {
        [0.05  color rgb <188,190,182>/255]
        [0.6  color White]
        [0.9  color rgb <126,170,222>/255]
      }
   } 
  scale 10
 }
 }

// pared sur sala 1  detrs de la cmara, 
union { 
 difference {
   box {<-35,0,-35>,<200,TECHO,-37.5>}
   #declare num_Windows_2 = 5 ;
   #while (num_Windows_2>0)
   object {
    box {<-25,10,-30>,<0,35,-45>}
    translate x*30*num_Windows_2
   }
   #declare num_Windows_2 = num_Windows_2-1 ;
   #end  
 }
box {<-35,0,-34.7>,<200,.5,-37>}

union { 
 cylinder {<-36,11,-36>,<177,11,-36>,.2}
 cylinder {<-36,12,-36>,<177,12,-36>,.2}
 cylinder {<-36,13,-36>,<177,13,-36>,.2}
 cylinder {<-36,14,-36>,<177,14,-36>,.2}
 cylinder {<-36,15,-36>,<177,15,-36>,.2}
 cylinder {<-36,16,-36>,<177,16,-36>,.2} 
 pigment {Black}
 } 
}
// pared patio interior oeste
difference { 
 box {<155,-100,25.5>,<160,180,190>} 
 #declare num_Windows_3 = 5 ; 
   #while (num_Windows_3>0)
   #declare num_floors_3= 6 ;
   #while (num_floors_3>0)
   object {
    box {<150,7,5>,<161,35,30>}
    translate y*-120
    translate y*40*num_floors_3
    translate z*30*num_Windows_3
   }
   #declare num_floors_3= num_floors_3-1 ;
   #end
   #declare num_Windows_3 = num_Windows_3-1 ;
   #end   
}

// pared patio interior este
difference { 
 box {<155,-100,25.5>,<160,180,190>} 
 #declare num_Windows_3 = 5 ;
   #while (num_Windows_3>0)
   #declare num_floors_3= 6 ;
   #while (num_floors_3>0)
   object {
    box {<150,7,5>,<161,35,30>}
    translate z*30*num_Windows_3
    translate y*-120
    translate y*40*num_floors_3
   }
   #declare num_floors_3= num_floors_3-1 ;
   #end
   #declare num_Windows_3 = num_Windows_3-1 ;
   #end
   translate x*-180
   pigment {rgb <1,0,0>}
}
// pared oeste sala 1
 box {<-36,0,-35>,<-35,TECHO,45>} 
 
// pared norte sala 2 // a la derecha de esta imgen
 box {<-95,0,95>,<-25,TECHO,100>} 
 
// pared oeste sala 1  
 difference { 
 box {<200,0,-35>,<215,TECHO,190>}
 box {<199,25.5,-34>,<202,39,-24>}
 }

box {<-20,TECHO-.25,23>,<162,TECHO,25>} // moldura techo en pared norte
box {<-35,TECHO-.25,-33>,<200,TECHO,-37.5>} // moldura techo en pared sur
box {<198,TECHO-.25,-33>,<215,TECHO,100>} // moldura techo en pared oeste

union { // rodapis visibles, en pared norte y oeste
   box {<-20,0,24.9>,<160,.6,26> }
   box {<199.9,0,-35>,<215,.6,190>}
   texture {T_Wood10 translate x*-33} 
   }

 pigment {White}  
 finish { brilliance 2           
         specular .2 
         roughness .05 
         diffuse .5
         conserve_energy
          }
}


object {Papelera translate <25,0,24.35> }
object {Papelera translate <87,0,24.35> }
object {Papelera translate <149,0,24.35> }
object {Papelera rotate y*90 translate <199.35,0,5> }

object {Peana rotate y*90 translate <-18,0,0>}

object {Rotulo_Est translate <22,0,-1>}
object {Rotulo_Est rotate y*180 translate <38,0,11>}
object {Peana translate <30,0,5>}

object {Rotulo_Est translate <72,0,-1>}
object {Rotulo_Est rotate y*180 translate <88,0,11>}
object {Peana translate <80,0,5>}

object {Rotulo_Est translate <122,0,-1>}
object {Rotulo_Est rotate y*180 translate <138,0,11>}
object {Peana translate <130,0,5>}

object {Rotulo_Est translate <172,0,-1>}
object {Rotulo_Est rotate y*180 translate <188,0,11>}
object {Peana translate <180,0,5>}

object {Bench translate <78,0,-16>}
object {Bench translate <140,0,-16>}
object {Bench translate <16,0,-16>}
object {Ancient_Title translate y*5}
object {OTHERS_TITLE translate <30,11,24.75>}
object {Exit_Sign rotate y*90 translate <199.9,16,29>}
object {Altillo}
object {Cuadro_1 rotate y*90 translate <199,12,-15>}
object {Cuadro_2 rotate y*180 translate <176,12,-34>}
object {Enchufe translate <21,2,25>}
object {Enchufe translate <118,2,25>}
object {Title_53178349
        rotate y*90
        translate <149.99,0,-.5> 
       }
object {Vase}
/*
// estatuas
object{ saltador rotate y*90 scale 18 translate <30,3,5> }
object{ falconet scale 15 rotate y*180 translate <80,2,5> }
object{ discobolo scale 15 rotate y*180 translate <130,2,5> }
object{ archer scale 15 rotate y*180 translate <180,2,5> }

// hombre con pantalones negros y chaqueta marron oscura caminando junto a la pared celeste
object{ hombre1 scale 15 rotate y*-100 translate <105,0,18> }

// hombre sentado en el banco meditando
object{ pensador3 scale 15.2 translate <78,0,-12.75> }

// figura en altillo
object{ chico1 scale 15 rotate y*90 translate <157,25.5,-8> }

// muchacho acuclillado frente al Saltador
object{ chico scale 15 rotate y*82 translate <18,0,3> }

// mujer con tejanos y camiseta cerca del saltador
object{ mujer scale 15 rotate y*-90 translate <36,0,-5> }

// mujer con camiseta roja y short junto a saltador
object{ mujer2 scale 15 rotate y*180 translate <27,0,12> }

// hombre empleado museo
object{ hombre rotate y*105 scale 15 translate <156,0,-7> }
*/