// Persistence Of Vision raytracer version 3.5 
// test file
// Ron Gow

#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "skies.inc" 
#include "math.inc"
#include "woods.inc"

#declare RAD = 0;
#declare MED = 1;
#declare FOG = 1;
#declare BGD = 1;
#declare TRS = 0;
#declare RNG = 1;
#declare VAL = 1;
#declare GRS = 0;

#declare sunpos = <400,130,-155>;
#declare campos = <-13,5.6,-15.5>;
#declare seepos = <5,3.8,5>;

camera { 
    location campos
    look_at seepos
    angle 80
} 

global_settings{
	adc_bailout 0.0039
	ambient_light rgb <.8,.8,.8>
	hf_gray_16 0
	irid_wavelength rgb <68,46,36>/255
	max_intersections 64
	max_trace_level 5
	number_of_waves 10
	#if(RAD)  
	    radiosity{ 
	    load_file "lites.rad"
	    always_sample on
		pretrace_start 0.08
        pretrace_end   0.02
        error_bound 0.9
        low_error_factor 0.9
        count 190
        nearest_count 10
        recursion_limit 1
        gray_threshold .02
        minimum_reuse 0.017
        brightness 0.540
        adc_bailout 0.01
        media on
        normal on
        //save_file "lites.rad"
	}
	#end  
} 

light_source { sunpos White fade_power 3.3 fade_distance 675}
 
sky_sphere {
    pigment {
        image_map {
            jpeg "ss_red_dusk"
            interpolate 2
            map_type 1
        }
        rotate -y*140
        translate y*.005
    }
    scale <2,1,2>
}

#if (FOG)
fog {
    distance 110
    color rgb <.550,.440,.400>
    fog_type 2
    fog_offset 6.85
    fog_alt 7.1
    turbulence .65
}
#end 


//  ********************************************************

#declare growth = texture {
    pigment { function { abs(y) }
        turbulence .35 
        octaves 4
        color_map { 
            [0.00 rgbf <0.484, 0.465, 0.2, .85>]
            [0.30 rgbf <0.541, 0.560, 0.2, .05>]
            [0.93 rgbf <0.570, 0.650, 0.3, .50>]
            [1.00 rgbf <0.495, 0.432, 0.2, 1.0>]
        }
    }
    scale 1.5
    normal { crackle .65 scale .1 }
    translate -y*.25
}
#declare rock = texture {
    pigment { agate 
        turbulence .65 
        color_map { 
            [0.00 rgbf <0.525, 0.490, 0.325, .08> ]
            [0.22 rgbf <0.100, 0.095, 0.100, .10> ]
            [0.28 rgbf <0.415, 0.390, 0.320, .15> ]
            [0.85 rgbf <0.515, 0.445, 0.350, .15> ]
            [1.00 rgbf <0.400, 0.390, 0.370, .01 >]
        }
     }
    normal { granite 1 scale 1.5 turbulence 1}
    finish { ambient .075 phong .15 phong_size 60 }
    scale <2,5,2>
    translate -y*.25
}

#declare grass = texture {
    pigment { slope { -y 0, .5 altitude y -.85, .35 
        }
        turbulence .5 
        octaves 5
        color_map { 
            [0.00 rgb <0.596, 0.570, 0.282> ]
            [0.15 rgb <0.551, 0.573, 0.312> ]
            [0.65 rgb <0.492, 0.529, 0.252> ]          
            [1.00 rgb <0.454, 0.553, 0.239> ]
        } 
     } 
    normal { granite .5 scale .005 }
}

#declare ground = texture {
    pigment { bozo
        turbulence .5 
        octaves 5
        color_map { 
            [0.00 rgb <0.555, 0.500, 0.410> ]
            [0.15 rgb <0.520, 0.460, 0.280> ]
            [0.65 rgb <0.495, 0.425, 0.200> ]          
            [0.95 rgb <0.455, 0.380, 0.255> ]
            [1.00 rgb <0.495, 0.380, 0.130> ]
        } 
    } 
    normal { granite .5 scale .005 }
    finish { ambient .02 diffuse .8 }
}
#declare grasstex = texture {
    pigment { agate 
        color_map {
            [0.00 rgb <.56,.7,.2> ]
            [0.20 rgb <.50,.71,.12> ]
            [0.60 rgb <.60,.67,.2> ]
            [1.00 rgb <.60,.57,.1> ]
        }
    }
    finish { ambient 0 diffuse .8 phong .5 roughness .07 }
}
#declare groundtex = texture {
    slope { -y 0, .5 }
    texture_map {
        [0.00 ground]
        [0.35 grass ]
        [0.65 grasstex ]
        [0.85 rock  ]
        [1.00 growth]
    }
}
//  ********************************************************
//  **********************  Lights  ************************
//  ********************************************************

#declare Glow = sphere { <0,0,0>, 1.2 hollow 
    pigment { color rgbt <1, 1, 1, 1 > }
    interior { 
        media {
            scattering {  3, <.025,.02,.002> extinction .15 }
            intervals 25
            samples 1.5,1.5
            confidence 0.98
            variance 1/1024
            density { spherical
                color_map {
                    [0.00 rgbf <.015,.005,.000, 1.00>]
                    [0.15 rgbf <.235,.115,.001, 0.80>]
                    [0.50 rgbf <.505,.425,.003, 0.60>]
                    [1.00 rgbf <.725,.580,.025, 0.15>]
                }
                scale 1.2
            }
        }
        media {
            emission <.225,.210,.055> 
            density {  spherical 
                color_map {
                    [0.00 rgb <.000,.000,.000>]
                    [0.10 rgb <.045,.015,.010>]
                    [0.25 rgb <.245,.135,.025>]
                    [1.00 rgb <.485,.280,.035>]
                }
                turbulence .65
            }
        }
    }
    inverse
    no_shadow
}

#declare E_Light = light_group { 
    light_source { <.2,0,.2> rgb <1.2, 1, .95> fade_power 11 fade_distance 1.5} 
    object { Glow } 
}
#declare Spook = union {
    #if(MED)
        object { E_Light }
    #else
        sphere { <0,1,0> .5 pigment { rgb .7 } }
    #end
    light_source { <0,0,0> rgb<.65,.5,.1> fade_power 1.9 fade_distance 9 }
}
//  ********************************************************
//  ************************  Stones  **********************
//  ********************************************************

#declare R_Stone = array[6] 
{
    height_field {
        jpeg "hf_stone" 
        water_level .01 
        smooth
        translate <-.5,-.015,-.5>
        scale <2,3.5,2>
    } ,
    height_field {
        jpeg "hf_stone1"
        water_level .01 
        smooth
        translate <-.5,-.015,-.5>
        scale <2,3,2>
    } ,
    height_field {
        jpeg "hf_stone2"
        water_level .01 
        smooth
        translate <-.5,-.015,-.5>
        scale <2,3,2>
    } ,
    height_field {
        jpeg "hf_stone3" 
        water_level .01 
        smooth
        translate <-.5,-.015,-.5>
        scale <2,3,2>
    } ,
    height_field {
        jpeg "hf_stone4" 
        water_level .01 
        smooth
        translate <-.5,-.015,-.5>
        scale <2,3,2>
    } ,
    height_field {
        jpeg "hf_stone5" 
        water_level .01 
        smooth
        translate <-.5,-.015,-.5>
        scale <2,3,2>
    } 
} 


#declare h_stone = height_field {
    jpeg "hf_flatrock" 
    water_level .01 
    smooth
    translate <-.5,-.015,-.5>
}

#declare h_stone1 = height_field {
    jpeg "hf_flatrock1"  
    water_level .01 
    smooth
    translate <-.5,-.015,-.5>
}

#declare h_stone2 = height_field {
    jpeg "hf_flatrock2"  
    water_level .01 
    smooth
    translate <-.5,-.015,-.5>
}

#declare h_stone3 = height_field {
    jpeg "hf_flatrock3" 
    water_level .02 
    smooth
    translate <-.5,-.15,-.5>
}

#declare c_stone = intersection {
    object { h_stone  scale <6,1,6> translate <0,-.35,0> } 
    object { h_stone  scale <6,1,6> rotate z*180 translate <0,.35,0> }
    rotate -x*90
    scale <.8,1.35,.8>
}
#declare c_stone1 = intersection {
    object { h_stone1  scale <6,1,6> translate <0,-.35,0> } 
    object { h_stone1  scale <6,1,6> rotate z*180 translate <0,.35,0> }
    rotate x*90
    scale <.8,1.5,.8>
}

#declare c_stone2 = intersection {
    object { h_stone2  scale <8,1,8> translate <0,-.35,0> } 
    object { h_stone2 rotate z*180 scale <8,1,8> translate <0,.35,0> }
    rotate x*90
    texture { rock }
    scale <.78,1,.45>
}

#declare c_stone3 = intersection {
    object { h_stone3  scale <5,1.1,6> translate <0,-.35,0> } 
    object { h_stone3 rotate z*180 scale <5,1.1,6> translate <0,.35,0> }
    scale <.6,1.1,.75>
}

#declare Arch = union {
    object { c_stone2 scale <1,1.1,3> rotate -x*8 translate <0,0,2> }
    object { c_stone1 scale <1,1,1.8> rotate x*3 translate <0,-.1,-2.5> }
    object { c_stone scale <1,1,2> rotate <84,3,1> translate <0,3.78,-.2> }
    translate y*4
}
#declare Table = union {
    object { R_Stone[4] scale <1.3,.7,1.2> rotate <-2,-130,2> translate <-11.75,1.6,3.75> }
    object { c_stone3 scale <1,1.1,1.2>*2.3 rotate <-6,-17,-7> translate <-8,2.2,0> }
}

#declare CR=20.5;
#declare cs=seed(11042);
#declare Ring = union{
    object { Arch scale <1.55,1.45,1.55> rotate <0,-0,0> translate < CR+.5,-.1,0> }
    #declare rcnt=21;
    #while(rcnt<352)
        #declare rngpos = rand(cs)*41;
        object { R_Stone[rand(cs)*6] 
            scale <1.8,2,1.9>+rand(cs)
            rotate y*rand(cs)*160 
            translate <CR+rand(cs),0,0>
            rotate <rand(cs)*6,rcnt,rand(cs)*5> 
        }
        #declare rcnt=rcnt+rngpos;
    #end 
    object { Table }  
    object { R_Stone[2] scale <1.6,1.6,1.5> rotate <-2,-30,2> translate <-10.6,1.2,-17.65> }
    texture { rock } 
}

//  ********************************************************
//  ***********************  Terrain  **********************
//  ********************************************************

#declare vale = height_field {
    jpeg "hf_low_rise"
    water_level .01 
    smooth
    translate <-.5,-.015,-.5>
    rotate y*45
    scale <180,-2,200>
    translate <40,.5,20>
}
#declare hills = height_field {
    jpeg "hf_eroded_hill"
    water_level .01 
    smooth
    translate <-.5,-.02,-.5>
}

#declare hills1 = object { hills scale <370,20,260> rotate y*105 
    translate <220,-1,110> texture { groundtex }} 
#declare hills2 = object { hills scale <355,33,250> rotate -y*145 
    translate <20,-1.5,245> texture { groundtex }}

//  ********************************************************
//  ************************  Grass  ***********************
//  ********************************************************
#if(GRS)
#declare Grass = object {
    #include ".\tests\gt_makegrass\fgrass1.inc"
    scale <.05,.065,.05>
    texture { grasstex }
}
#macro Lay_Grass( Surface )

union {
    #local gs=seed(152);
    #local dpth = 52;
    #local stx = -14;
    #local stz = -12;
    #local wid = 2.5;
    #local cntx = 0;
    #while (cntx<dpth)
        #local cntz = 0;
        #while (cntz<dpth) 
            #local Norm = <0,0,0>;
            #local hgt = trace( Surface,<stx+(cntx*wid),1,stz+(cntz*wid)>,<0,-1,0> );
            #local ignore = trace ( c_stone3,<stx+(cntx*wid),1,stz+(cntz*wid)>,<0,-1,0>, Norm );
            #if (vlength( Norm )=0) 
                object { Grass rotate y*(-88+rand(gs)*175) 
                    translate <stx+(cntx*wid),hgt.y,stz+(cntz*wid)> 
                } 
            #end
            #local cntz=cntz+1;
        #end
        #local cntx=cntx+1;
    #end
    translate <0,0,0>
}

#end 
#end

//  ********************************************************
//  ************************  Trees  ***********************
//  ********************************************************
#if(TRS)
#declare Tree = array[4] 
#declare Tree[0] = object { 
    #include ".\tests\tomtreem\RG.inc"
    #include ".\tests\tomtreem\TOMTREEm.inc"
    object{TREE  scale 30 }
}
#declare Tree[1] = object { 
    #include ".\tests\tomtreem\RG1.inc"
    #include ".\tests\tomtreem\TOMTREEm.inc"
    object{TREE  scale 31 }
}
#declare Tree[2] = object { 
    #include ".\tests\tomtreem\RG2.inc"
    #include ".\tests\tomtreem\TOMTREEm.inc"
    object{TREE  scale 32  }
}
#declare Tree[3] = object { 
    #include ".\tests\tomtreem\RG3.inc"
    #include ".\tests\tomtreem\TOMTREEm.inc"
    object{TREE  scale 33 rotate -y*35 }
}
#end

//  ********************************************************
//  ************************  Scene  ***********************
//  ********************************************************
#declare rs=seed(69);
union {
    object { Spook scale 1.5 rotate rand(rs)*340 translate <-14.5,7.3,-13.9> }
    object { Spook scale 1.7 rotate rand(rs)*340 translate < 13.05,8.4,-5.6> }
    object { Spook scale 1.7 rotate rand(rs)*340 translate <-9.7,2.3,-2.5> }
    object { Spook scale 1.6 rotate rand(rs)*340 translate < -10.3,4.7,10> }
    object { Spook scale 1.2 rotate rand(rs)*340 translate < 13.6,9.2,10> }
    translate <5,0,2>
}

#if (RNG)
    object { Ring rotate <0,-1,0> translate <6,-1.5,3.5> }
#end

#if(VAL)
object { vale texture { ground }}

#if(GRS)
light_group {
    light_source { <-8,20,-35> rgb<.5,.6,.45> shadowless }
    Lay_Grass( vale )
    global_lights
} 
#end
#end

#if (BGD)
object { hills1 }
object { hills2 }
#end

#if(TRS)
#declare tx1 =-9;
#declare tx2 =110;
#declare tz1 =98;
#declare tz2 =8;
#declare cnt =0;
#declare rt=seed(3); 
#while(cnt<30)
    #local trx = tx1+rand(rt)*165;
    #local trz = tz1+rand(rt)*95;
    #local try = trace( hills2,<trx,25,trz>,<0,-1,0> ).y;
    #local trs = rand(rt)*4;
        object { Tree[trs]
        rotate y*rand(rt)*320
        scale .5+rand(rt)
        translate <trx,try,trz> 
    }
    #declare cnt = cnt+1;
#end
#declare cnt =0;
#while(cnt<45)
    #local trx = tx2+rand(rt)*115;
    #local trz = tz2+rand(rt)*175;
    #local try = trace( hills1,<trx,20,trz>,<0,-1,0> ).y;
    #local trs = rand(rt)*4;
        object { Tree[trs]
        rotate y*rand(rt)*320
        scale .5+rand(rt)
        translate <trx,try,trz> 
    }
    #declare cnt = cnt+1;
#end    
#end   
    
