
// Persistence of Vision Ray Tracer Scene Description File
// File: mg_tz03.inc
// Vers: 3.5
// Desc: include file for tzolkin
// Date: started may,07 2003
// Auth: marjorie

//Viejos y Nuevos
// >>> ArenaGold 
#declare ArenaGold = color rgb<1.00,0.706,0.125>;
#declare BlancoArena = color rgb<1.00,0.914,0.749>;
#declare Cadmio = color rgb <0.925,0.780,0.071>;
#declare CadmioOscuro = color rgb <0.89453, 0.61328, 0.21484>;
#declare CadmioSat = color rgb <0.92969, 0.74219, 0.48828>;
#declare Carton = color rgb <0.72266, 0.66016, 0.60156>;
#declare Guayaba = color rgb <0.86719, 0.66016, 0.52734>;
#declare Ocre = color rgb <0.702,0.580,0.000>;
#declare Napoles = color rgb <0.91797, 0.87109, 0.55078>;
#declare MarronOscuro = color rgb <0.28516, 0.21484, 0.17188>;
#declare Marron = color rgb <0.416,0.310,0.118>;
#declare Marfil = color rgb <0.99219, 0.98828, 0.91797>;
#declare Malva = color rgbf <0.690,0.588,0.471,0.500>;
#declare VinoTinto = color rgb <0.459,0.200,0.129>;

//sub-escala rojo-amarillo subscale red to yellow


#declare rj1 = color red 0.549019608 green 0.176470588 blue 0.180392157;
#declare rj2 = color red 0.631372549 green 0.184313725 blue 0.133333333 ;
#declare rj3 = color red 0.749019608 green 0.168627451 blue 0.058823529 ;
#declare rj4 = color red 0.890196078 green 0.250980392 blue 0.164705882 ;
#declare rj5 = color red 0.905882353 green 0.192156863 blue 0.058823529;
#declare rj6 = color red 0.847058824 green 0.392156863 blue 0.129411765;
#declare rj7 = color red 0.807843137 green 0.415686275 blue 0 ;
#declare rj8 = color red 0.91372549 green 0.447058824 blue 0.192156863;
#declare rj9 = color red 0.909803922 green 0.501960784 blue 0.070588235;
#declare rj10 = color red 1 green 0.509803922 blue 0.007843137 ;
#declare rj11 = color red 1 green 0.607843137 blue 0 ;
#declare rj12 = color red 1 green 0.643137255 blue 0.11372549;
#declare rj13 = color red 1 green 0.737254902 blue 0;
#declare rj14 = color red 1 green 0.788235294 blue 0;
#declare rj15 = color red 1 green 0.776470588 blue 0.047058824 ;
#declare rj16 = color red 0.964705882 green 0.741176471 blue 0.003921569;
#declare rj17 = color red 0.984313725 green 0.866666667 blue 0.529411765;
#declare rj18 = color red 1 green 0.984313725 blue 0.22745098;
#declare rj19 = color red 1 green 0.890196078 blue 0.117647059 ;
#declare rj20 = color red 0.97254902 green 0.91372549 blue 0.411764706 ;
#declare rj21 = color red 0.909803922 green 0.874509804 blue 0 ;
#declare rj22 = color red 0.917647059 green 0.796078431 blue 0.019607843 ;
#declare rj23 = color red 0.82745098 green 0.682352941 blue 0.223529412;


//sub-escalas (varias) marron-rojo-amarillo  subscale brown-red-yellow

#declare um_brw01 = color rgb <0.545,0.259,0.075>;
#declare um_brw02 = color rgb <0.596,0.310,0.094>;
#declare um_brw03 = color rgb <0.396,0.337,0.078>;
#declare um_brw04 = color rgb <0.541,0.020,0.000>;
#declare um_brw05 = color rgb <0.631,0.251,0.141>;
#declare um_red01 = color rgb <0.792,0.224,0.110>;
#declare um_red02 = color rgb <0.949,0.467,0.165>;
#declare um_red03 = color rgb <0.624,0.086,0.016>;
#declare um_red04 = color rgb <0.624,0.082,0.000>;
#declare um_ylw01 = color rgb <0.984,0.392,0.282>;
#declare um_ylw02 = color rgb <0.992,0.808,0.447>;
#declare um_ylw03 = color rgb <0.980,0.647,0.333>;
#declare um_ylw04 = color rgb <0.984,0.757,0.369>;
#declare um_ylw05 = color rgb <0.941,0.945,0.525>;

//Verdes - Greens


#declare vd1 = color red 0.152941176 green 0.145098039 blue 0.137254902;
#declare vd2 = color red 0.2 green 0.301960784 blue 0.160784314;
#declare vd3 = color red 0.17254902 green 0.439215686 blue 0.211764706;
#declare vd4 = color red 0.294117647 green 0.57254902 blue 0.290196078;
#declare vd5 = color red 0.298039216 green 0.650980392 blue 0.180392157;
#declare vd6 = color red 0.462745098 green 0.780392157 blue 0.188235294;
#declare vd7 = color red 0.529411765 green 0.803921569 blue 0.22745098 ;
#declare vd8 = color red 0.780392157 green 0.925490196 blue 0.615686275;
#declare vd9 = color red 0.976470588 green 0.968627451 blue 0.788235294;
#declare vd10 = color red 0.878431373 green 0.909803922 blue 0.341176471;
#declare vd11 = color red 0.635294118 green 0.654901961 blue 0.211764706;
#declare vd12 = color red 0.564705882 green 0.592156863 blue 0.219607843;
#declare VerdeOliva = color rgb <0.404,0.443,0.125>;
#declare VerdeOlivaGris = color rgb <0.42578, 0.45703, 0.36719>;
#declare VerdeOlivaPlano = color rgb <0.45703, 0.51563, 0.36328>;


//Grises Grays

#declare GrisAzulado = color rgb <0.64453, 0.68359, 0.69141>;
#declare GrisTurquesa = color rgb <0.60156, 0.64453, 0.63281>;
#declare GrisVerde = color rgb <0.69141, 0.70313, 0.58984>;
#declare GrisVioleta = color rgb <0.8125, 0.80469, 0.8125>;



//Colores Frios - Cold  Blues


#declare agua = color red 0.423529412 green 0.623529412 blue 0.623529412 ;
#declare agua2 = color red 0.180392157 green 0.411764706 blue 0.51372549 ;
#declare agua3= color rgb <0.145,0.337,0.333>;
#declare agua4= color rgb <0.157,0.134,0.369>; 
#declare AzulCeruleo = color rgb <0.53516, 0.63281, 0.71094>;
#declare AzulCeruleoClaro = color rgb <0.58594, 0.66016, 0.71875>;
#declare AzulMarino = color rgb <0.129,0.165,0.459>;
#declare Humo = color rgb <0.88281, 0.90234, 0.89844>;
#declare HumoClaro = color rgb <0.92578, 0.94141, 0.92969>;
#declare lapislazuli = color red 0.35294 green 0.596078 blue 0.603922 ;


//Colores y dems


#declare jungla02=color rgb <0.122,0.361,0.059>;
#declare jungla03=color rgb <0.380,0.475,0.078>;
#declare jungla04=color rgb <0.435,0.475,0.314>;
#declare jungla05=color rgb <0.545,0.518,0.090>;
#declare jungla06=color rgb <0.608,0.580,0.102>;
#declare jungla07=color rgb <0.651,0.529,0.110>;
#declare jungla08=color rgb <0.820,0.667,0.129>;
#declare jungla09=color rgb <0.878,0.859,0.698>;
#declare jungla10=color rgb <0.957,0.890,0.784>;
#declare jungla11=color rgb <0.941,0.890,0.792>;

//from mg_asia
#declare norm_geo=
normal {
  granite        
  slope_map {
    [0    <0.5, 1>]   
    [0.25 <0.5,-1>]   
    [0.5  <0.5,-1>]   
    [0.75 <0.25, -0.5>]   
    [6    <0.5, 1>]   
  }
}
#declare para_tierra=

color_map{
[0.15 jungla02]
[0.30 jungla03]
[0.45 jungla04]
[0.60 jungla05]
[0.75 jungla04]
[0.90 jungla07]
[1.00 jungla03]
}

//From Homeagain  //modified paredes_all
#declare tierra=
texture{
  pigment {
    bozo//agate
    turbulence 0.8
    lambda 1.4
    omega 0.75
    octaves 2
    scale 0.13
    color_map {para_tierra}//CadmioSat 
  }
  normal {
    norm_geo//granite 0.25
  }
  finish{
    brilliance 1.3
    //ambient 0.4 
    //diffuse 0.4 
  }  
}	 


#declare tex02_01=
texture {
  pigment{
    Brown+Gold transmit .5
  }
  normal {
    granite 0.35 
  }
  finish {
    ambient 0.35 
    diffuse 0.44
  }
}   

#declare paredes_all=
texture{
  pigment {
    CadmioSat 
  }
  normal {
    norm_geo//granite 0.25
  }
  finish{
    ambient 0.4 
    diffuse 0.4 
  }  
}	 

#declare paredes_all02=
texture{
  pigment {
    BlancoArena//Ocre//Carton//CadmioSat 
  }
  normal {
    norm_geo//granite 0.25
  }
  finish{
    ambient 0.4 
    diffuse 0.4 
  }  
}	 


#declare paredes_all03=
texture{
  pigment {
    GrisVerde//
  }
  normal {
    norm_geo//granite 0.25
  }
  finish{
    ambient 0.4 
    diffuse 0.4 
  }  
}	 






#declare R=seed(260);
#declare terr_general=
texture{ 
pigment {
wrinkles
turbulence rand(R)//0.6
//lambda

color_map{
[0.15 color jungla02 ]
[0.25 color jungla03]
[0.29 color jungla04]
[0.33 color jungla06]
[0.40 color jungla07]
[0.63 color jungla08]
[0.70 color jungla09]
[1.00 color jungla11]



}}
//from docs
normal {
      gradient y//y
      frequency rand(R)//3
      turbulence .5
      normal_map {
        [0.00 granite]
        [0.25 spotted turbulence .35]
        [0.50 marble turbulence .5]
        [0.75 bozo turbulence .25]
        [1.00 granite]
      }
    }
finish {ambient 0.4 diffuse 0.5}
}



#declare por_encima=
texture{
pigment{
agate
turbulence 0.20
color_map{
[0.10 jungla06 transmit 0.5 filter 0.5]
[0.11 Clear]
[0.50 jungla06 transmit 0.5 filter 0.5]
[0.60 jungla07 transmit 0.5 filter 0.5]
[0.65 Clear]
[1.00 jungla07 transmit 0.5 filter 0.5]


}

}
normal{
gradient y
   normal_map{
      [0.00 marble turbulence .5]
      [0.25 spotted turbulence .35]
      [0.50 marble turbulence .5]
      [0.75 bozo turbulence .25]
      [1.00 marble turbulence .5]

   }

}

//OJO falta finish!!!!
}


#declare where=
union{
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,40>}
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,50>}
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,20>} 
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,10>}
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} }
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,-10>}
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,-20>}
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,-30>}
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,-40>}
cylinder { -50*x,  50*x,  0.15   pigment {White} finish {phong 1.0} translate <0,0,-50>}



cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <50,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <40,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <30,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <20,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <10,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} }
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <-10,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <-20,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <-30,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <-40,0,0>}
cylinder { -50*z,  50*z,  0.15   pigment {Green} finish {phong 1.0} translate <-50,0,0>}
// create a regular point light source



}




#declare um_sto_cry = texture {
  pigment {
    bozo
    turbulence -3
    octaves 2
    lambda 6
    color_map {
      [0.0 0.2 color rgbf <0.776,0.290,0.263,0.6> color rgbf <0.776,0.290,0.263,0.700>]
      [0.2 1.0 color rgbf <0.556863, 0.137255, 0.137255,.7> color rgbf <1, 0.663, 0.349,.7>]
    }
  }
  finish {
    ambient 0.3
    diffuse 0.7
    reflection 0.6
    brilliance 2
    specular 0.45
    roughness 0.1
  }
  normal {
    dents 1.0
    scale <.25, .25, .25>
  }
}


//Oro


#declare rj9 = color red 0.909803922 green 0.501960784 blue 0.070588235;
#declare Oro = texture {
  pigment {
    Carton//rj9
  }
  finish {
    ambient 0//0.1
    brilliance 3//6
    diffuse 0.9
    metallic
    specular 0.25//0.80
    roughness 0.0015//1/120
    reflection 0.6//0.8
  }
}


#declare cuadricula = texture {
  pigment {
    gradient y
    frequency 80
    color_map {
      [0.25 Gray20 filter 1]
      [0.50 Clear]
      [0.75 Gray70 filter 1]
      [1.00 Clear]
    }
  }
}
texture {
  pigment {
    gradient x
    frequency 80
    color_map {
      [0.25 Gray20 filter 1]
      [0.50 Clear]
      [0.75 Gray70 filter 1]
      [1.00 Clear]
    }
  }
  normal {
    bumps 0.1
  }
  finish {
    diffuse 1 ambient 0.0
  }
}


#declare tierratex=
texture{
  pigment{
		granite
		color_map{
			[0.0 color rgb <0.8,0.75,0.65>]
			[0.2 color rgbf <0.44531, 0.45313, 0.44922,0.5>]   
			[0.4 color rgbf <0.44531, 0.45313, 0.44922,0.5>]
			[0.8 color rgbf <0.7,0.5,0.4,0.3>]
			[0.9 color rgbf <0.6,0.5,0.4,0.3>]
			[1.0 color rgbf <0.6,0.4,0.2,0.3>]
		}
	scale <1,2,1>
	turbulence 0.5
	octaves 10
	omega 0.7
	} 
 
  normal{
  bump_map{  
    tga "Grain.tga" 
    map_type 0   
    interpolate 4                       
    bump_size 3.0 
  }                        
                         
}
finish { phong 0.4 
ambient 0//0.5 
diffuse 0.6//0.4
}//0.3 crand
 }