// Persistence of Vision Ray Tracer Scene Description File
// File: carpet.inc
// Vers: 3.5
// Desc: Carpet textures and objects
// Date: 2003/05/13
// Auth: Maurizio Tomasi
//

#version 3.5;

#declare CarpetNormal1 =
normal
{
    quilted 5
    scale 0.005
}

#declare CarpetTexture1 =
texture 
{
    pigment 
    {
        spotted
        color_map 
        {
            [0.5 color rgb <0.10, 0.10, 0.30>]
            [0.5 color rgb <0.00, 0.15, 0.05>]
            [1.0 color rgb <0.00, 0.05, 0.00>]
        }
        
        translate -0.5
        scale 0.13
    }
}
texture 
{
    pigment 
    {
        spotted
        warp { turbulence 0.1 }
        color_map 
        {
            [0.5 color rgb <0.10, 0.10, 0.30> transmit 1]
            [0.5 color rgb <0.50, 0.15, 0.10>]
            [1.0 color rgb <0.30, 0.05, 0.00>]
        }
      
        scale 0.05
    }
}
texture 
{
    pigment 
    {
        bozo
        color_map 
        {
            [0.6 color rgb <0.10, 0.10, 0.30> transmit 1]
            [0.6 color rgb <0.40, 0.45, 0.10>]
            [1.0 color rgb <0.30, 0.35, 0.00>]
        }
      
      translate 0.5
      scale 0.08
    }
}

#declare CarpetTexture2 =
texture 
{
    pigment 
    {
        spotted
        color_map 
        {
            [0.5 color rgb <0.10, 0.10, 0.30>]
            [0.5 color rgb <0.00, 0.15, 0.05>]
            [1.0 color rgb <0.00, 0.05, 0.00>]
        }
        
        translate -0.5
        scale 0.16
    }
}
texture 
{
    pigment 
    {
        spotted
        warp { turbulence 0.1 }
        color_map 
        {
            [0.5 color rgb <0.10, 0.10, 0.30> transmit 1]
            [0.5 color rgb <0.50, 0.15, 0.10>]
            [1.0 color rgb <0.30, 0.05, 0.00>]
        }
      
        scale 0.08
    }
}

#macro CreateCarpet (Pt1, Pt2, BorderThickness, 
                     OuterTexture, InnerTexture,
                     ThreadTexture, ThreadLength, 
                     ThreadRadius, NumOfThreads)

    #local InnerPt1 = Pt1 + BorderThickness * <1, 0, 1>;
    #local InnerPt2 = Pt2 - BorderThickness * <1, 0, 1>;

    union
    {
        difference
        {
            box { Pt1, Pt2 }
            box { InnerPt1 - 0.1*y, InnerPt2 + 0.1*y }
            
            texture { OuterTexture normal { CarpetNormal1 } }
        }
        
        box
        { 
            InnerPt1, InnerPt2 
        
            texture { InnerTexture normal { CarpetNormal1 } }
        }
        
        // Threads
        
        #local Threads =
        union
        {
            #local Seed = seed (6344);
            
            #local StartPoint = <Pt1.x, (Pt1.y + Pt2.y)/2, 0>;
            #local DeltaX = (Pt2.x - Pt1.x)/NumOfThreads;
            #local Count = 0;
            #while (Count <= NumOfThreads)
                #local CurPoint = StartPoint + Count * DeltaX * x;
                sphere_sweep
                {
                    b_spline
                    5,
                    
                    CurPoint - ThreadLength*z, ThreadRadius,
                    CurPoint, ThreadRadius,
                    CurPoint + 0.5*DeltaX*RRand(-1.0, 1.0, Seed)*x + 0.5*ThreadLength*z, ThreadRadius,
                    CurPoint + 0.5*DeltaX*RRand(-1.0, 1.0, Seed)*x + ThreadLength*z, ThreadRadius,
                    CurPoint + 0.5*DeltaX*RRand(-1.0, 1.0, Seed)*x + 2*ThreadLength*z, ThreadRadius
                }
                
                #declare Count = Count + 1;
            #end
            
            texture { ThreadTexture }
        }
        
        object { Threads translate Pt2.z * z }
        object { Threads scale <1, 1, -1> translate Pt1.z * z }
    }

#end