// Persistence of Vision Ray Tracer Scene Description File
// File: fl_table.inc
// Vers: 3.5
// Desc: Table with flowers
// Date: 2003/05/31
// Auth: Maurizio Tomasi

#include "woods.inc"

#local CurY = 0.0;

#local Table =
union
{
    // Base
    
    #local NextHeight = 0.05;
    cylinder
    {
        <0, 0, 0>, <0, NextHeight, 0>, 0.60
        translate CurY*y
    }
    torus
    {
        0.60, NextHeight/2
        translate (CurY + NextHeight/2)*y
    }
    #declare CurY = CurY + NextHeight;

    #declare NextHeight = 0.02;
    cylinder
    {
        <0, 0, 0>, <0, NextHeight, 0>, 0.58
        translate CurY*y
    }
    #declare CurY = CurY + NextHeight;

    #declare NextHeight = 0.02;
    cylinder
    {
        <0, 0, 0>, <0, NextHeight, 0>, 0.56
        translate CurY*y
    }
    #declare CurY = CurY + NextHeight;

    // Column
    
    #declare NextHeight = 0.04;
    cylinder
    {
        <0, 0, 0>, <0, NextHeight, 0>, 0.20
        translate CurY*y
    }
    #declare CurY = CurY + NextHeight;

    #declare NextHeight = 0.1;
    cylinder
    {
        <0, 0, 0>, <0, NextHeight, 0>, 0.15
        translate CurY*y
    }
    #declare CurY = CurY + NextHeight;
    
    #declare NextHeight = 0.05;
    torus
    {
        0.15 - NextHeight, NextHeight/2
        translate (CurY + NextHeight/2)*y
    }
    #declare CurY = CurY + NextHeight;
    
    #declare NextHeight = 0.05;
    torus
    {
        0.085, NextHeight/2
        translate CurY*y
    }
    #declare CurY = CurY + NextHeight;

    #declare NextHeight = 1.5;    
    blob
    {
        #local TwistNum = 10;
        #local SpiralRadius = 0.03;
        #local SphereRadius = 0.08;
        
        threshold 0.1*SphereRadius
        
        cylinder
        {
            <0, 0, 0>, <0, NextHeight, 0>, 3*SpiralRadius, SphereRadius
        }
        #local Count = 0;
        #while (Count < 1)
            sphere 
            {
                SpiralRadius * <cos(2*pi*TwistNum*Count), 0, sin(2*pi*TwistNum*Count)> 
                + y*Count*NextHeight, 
                SphereRadius, 5*SphereRadius
            }
            #declare Count = Count + 0.01/NextHeight;
        #end
        
        translate CurY*y
    }
    #declare CurY = CurY + NextHeight;

    #declare NextHeight = 0.1;
    cylinder
    {
        <0, 0, 0>, <0, NextHeight, 0>, 0.1
        translate CurY*y
    }
    #declare CurY = CurY + NextHeight;

    // Top
    
    #declare NextHeight = 0.08;
    cylinder
    {
        <0, 0, 0>, <0, NextHeight, 0>, 0.50
        translate CurY*y
    }
    torus
    {
        0.50, NextHeight/2
        translate (CurY + NextHeight/2)*y
    }
    #declare CurY = CurY + NextHeight;

   texture {T_Wood14 scale 0.4 rotate 90*x}
}

// Vase
#local VaseTexture = texture {
    normal
    {
        quilted 1.5
        scale 0.075
        rotate <30, -6, 15>
    }
    
    pigment { rgb <0.5, 0.4, 0.2> * 1.5 }
}

// Leaves
#local LeafTexture = texture {
    finish {
        specular 0.7
        roughness 0.02
    }
    
    pigment
    { 
        bozo
        color_map
        {
            [0.5 rgb <0, 0.4, 0>]
            [0.6 rgb <0.2, 0.5, 0.1>]
        }
        
        scale 1.0
    }
}

// Stems
#local StemTexture = texture {
    pigment { rgb <0, 0.5, 0> }
}

// Flowers
#local FlowerTexture = texture {
    pigment { rgb <0.2, 0.2, 1> * 3.0 }
}

// Flowers
#local GroundTexture = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.03
        phong_size 1.0
    }
    pigment { rgb <0.3, 0.1, 0.1> }
}

#include "fl_vase.inc"

#declare TableWithFlowers =
union
{
    object { VaseWithFlowers translate 34*y scale 0.030 translate CurY*y}
    object { Table }
}
