// Persistence of Vision Ray Tracer Scene Description File
// File: flame.inc
// Vers: 3.5
// Desc: Candle flame
// Date: 2003/06/08 (it was previously definedin file lamp.inc)
// Auth: Maurizio Tomasi

#ifndef (__LAMP_INC__)
#declare __LAMP_INC__ = 1;

// Candle flame

#declare FlameRadiusFn = function(y) { 25/16 * sqrt(5*abs(y)) * pow(1 - y, 2) }
#declare CandleFlameFn = function { x*x + z*z - FlameRadiusFn (y) }

#declare CandleFlame =
isosurface 
{
    function { CandleFlameFn (x, y, z) }
    contained_by { box { <-1, 0, -1>, <1, 1, 1> } }
    max_gradient 12
    accuracy 0.01
}

#macro CreateCandleFlame (Color1, Color2, Emission)

    #local DensityFn = function { (FlameRadiusFn(y) - x*x - z*z) / (0.01 + FlameRadiusFn(y)) }

    object
    {
        CandleFlame
        hollow on
        
        pigment { color rgbt 1 }
        
        interior
        {
            media
            {
                method 2
                variance 1.0/64
                confidence 0.80
                emission Emission
                density
                {
                    function { DensityFn (x, y, z) }
                    color_map
                    {
                        [0.3 color rgb Color1]
                        [0.6 color rgb Color2]
                    }
                }
            }
        }
    }
    
#end

#end // __LAMP_INC__
