// Persistence of Vision Ray Tracer Scene Description File
// File: lamp.pov
// Vers: 3.5
// Desc: Lamp on the wall, glass, candlestick and candleplate
// Date: 2003/05/11
// Auth: Maurizio Tomasi

#include "flame.inc"

#local BrassTexture =
texture
{
    pigment 
    { 
        granite
        color_map
        {
            [0.4 color rgb <0.50, 0.50, 0.0> * 0.7]
            [0.7 color rgb <0.40, 0.40, 0.0> * 0.7]
            [1.0 color rgb <0.35, 0.35, 0.1> * 0.7]
        }
    }
    
    finish 
    { 
        specular 0.8
        roughness 0.02
        reflection
        { 
            0.2
            metallic 
        } 
    }
}
texture
{
    // Dark spots
    pigment
    {
        bozo
        color_map
        {
            [0.50 color rgb 1 transmit 1]
            [0.51 color rgb <0.5, 0.5, 0.35> * 0.75 transmit 0]
            [0.52 color rgb <0.5, 0.5, 0.35> * 0.75 transmit 0]
            [0.53 color rgb 1 transmit 1]
        }
        
        scale 0.04
    }
}

#local GlassTexture =
texture
{
    pigment { color rgb <0.95, 0.95, 0.92> transmit 0.95 }

    finish 
    { 
        diffuse 0
        specular 0.6
        roughness 0.09
        reflection 
        { 
            0.2, 1.0
            fresnel on
        }
        conserve_energy
    }
}

#local Candleplate =
height_field
{
    png "candleplate.png"
    smooth
    water_level 0.001
    
    rotate -90*x
    translate -0.5
    scale <0.3, 0.3 * 755 / 608, 0.015>
}

#local HalfCandlestick =
height_field
{
    png "candlestick.png"
    smooth
    water_level 0.001
    
    rotate -90*x
    translate <-0.5, -0.5, 0>
}

#local Candlestick =
union
{
    object { HalfCandlestick }
    object { HalfCandlestick scale <1, 1, -1> }
    
    translate 0.5*x
    scale <0.3, 0.3 * 253 / 808, 0.02>
}

#include "glass_bowl.inc"

#declare Lamp =
union
{
    object
    {
        Candleplate
        texture { BrassTexture }

        rotate -90*y
        translate -0.02*x
    }

    object 
    { 
        Candlestick
        texture { BrassTexture } 
        translate -0.01*x
    }
    
    union
    {
        // Glass
        union
        {
            object 
            { 
                GlassBowl1 
                
                hollow on
                
                texture { GlassTexture } 
                interior { ior 1.35 } 
            }
            
            object
            {
                GlassBowl1
                scale <0.98, 1, 0.98>
                
                hollow on
                
                pigment { color rgbt 1 }
                interior { ior 1.0/1.35 }
            }

            translate 0.1*y
        }
                
        // Candle

        union
        {
            cylinder
            {
                <0, 0, 0>, <0, 1, 0>, 0.5
                
                pigment { color rgb <0.8, 0.8, 0.75> }
                no_shadow
            }

            object
            {
                CreateCandleFlame (<1.0, 0.4, 0.0>, <0.3, 0.2, 0.2>, 4)
                
                scale <0.25, 1, 0.25> * 2
                translate 1*y
            }
            
            scale <1, 1.5, 1> * 0.35
            translate 0.15*y
        } 

        // Base
        object { GlassBowl2 texture { BrassTexture } }
        
        scale 0.075
        translate <0.270, 0.02, 0>
    }
}
