// Persistence of Vision Ray Tracer Scene Description File
// File: miles.inc
// Vers: MegaPOV 1.0
// Desc: Miles sleeping in his bed
// Date: 2003/06/12
// Auth: Maurizio Tomasi

#ifndef (__MILES_INC__)
#declare __MILES_INC__ = 1;

//#version unofficial megapov 1.0;
/*
// Taken from the MegaPOV help file
#macro WriteClothFile(filename, n1, n2, nlng, ks, ht)
    #debug "\nWriting new cth file\n"
    
    // Write the header
    #fopen file filename write
    #write (file, n1, ", ", n2, ", ", nlng, ", ", ks, ",\n")
    
    #local l1 = nlng*(n1-1);
    #local l2 = nlng*(n2-1);
    #local st = seed(1234);
    #local i=0;
    
    // Write the cloth definition
    #while (i < n1)
        #local j=0;
        
        #while (j < n2)
            #local tempx = -l1/2 + i*nlng;
            #local tempz = -l2/2 + j*nlng;
            #local vtemp = <tempx, 0, tempz>;

            #local vtemp = vaxis_rotate(vtemp, z, -20);
            #local tempy = ht + (-1+2*rand(st))*nlng*0.1;
            #local vtemp = vtemp + tempy*y + .2*x;
            #write(file, vtemp.x, ",", vtemp.y, ",", vtemp.z, ", 0.0, 0.0, 0.0,\n")

            #set j=j+1;
        #end
        
        #set i=i+1;
    #end
    
    #fclose file
#end
*/

#declare Bed =
height_field
{
    png "bed_hf.png"
    smooth
    water_level 0.01
    scale <4, 1.5, 2>
    translate <-2, 0, -1>
    translate 1*x
}

//WriteClothFile ("bedspread.cth", 60, 35, 3.5/40, 6, 3.5)
/*
simcloth {
    environment Bed
    friction 0
    gravity -0.8*y
    damping 0.9
    intervals 0.03
    iterations 50
    input "bedspread.cth"
    output "bedspread.cth"
    mesh_output "bedspread.msh"
    smooth_mesh on
    uv_mesh on
}
*/

#declare Bedspread =
  mesh {
    #include "bedspread.msh"
    uv_mapping
    texture {
      pigment {
        checker color rgb <0.5, 0.2, 0.05> color rgb <0.4, 0.4, 0.05>
        scale <0.03, 0.07, 0.07>
      }
    }
  }

#local CurtainTexture =
texture
{
    uv_mapping
    pigment { image_map { jpeg "curtain_t.jpg" interpolate 2 } }
}

#local LeftCurtainWithTex =
object
{
    LeftCurtain
    rotate -90*y
    scale <1, 1, 0.85>

    texture { CurtainTexture }
}

#local RightCurtainWithTex =
object
{
    RightCurtain
    rotate -90*y
    scale <1, 1, 0.85>

    texture { CurtainTexture }
}

#local MetalTexture =
texture
{
    pigment { color rgb <0.2, 0.2, 0.1> }
    
    finish { specular 0.7 roughness 0.03 metallic }
}

#include "miles_head.inc"
#include "pillow.inc"

union
{
    object
    {
        //Bed
        Bedspread 
        scale 0.85
        //translate 0.2*y
    }
    
    object
    {
        Pillow
        pigment { color rgb <1, 1, 0.5> }
        
        rotate -90*y
        rotate 30*z
        scale 0.4
        translate <2.35, 1.0, 0.1>
    }
    
    // Bed head
    height_field
    {
        png "bedhead.png"
        smooth
        water_level 0.01

        translate <-0.5, 0, -0.5>        
        rotate 90*y
        rotate 90*z
        translate 0.5*y
        scale <0.05, 4.0, 1.8>
        translate <2.7, -1.0, 0>
        
        texture { MetalTexture }
    }
    
    // Bed tail
    height_field
    {
        png "bedtail.png"
        smooth
        water_level 0.01

        translate <-0.5, 0, -0.5>        
        rotate 90*y
        rotate 90*z
        translate 0.5*y
        scale <0.05, 1.0, 1.4>
        translate <-1.05, 0.1, 0>

        texture { MetalTexture }
    }

    light_group
    {
        union
        {
            object { LeftCurtainWithTex translate <-1.3, 0, 0.8> }
            object { LeftCurtainWithTex rotate -90*y translate <-1.3, 0, 0.9> }
    
            object { RightCurtainWithTex translate <-1.3, 0, -0.9> }
            
            scale <1, 1.35, 1>
        }
        
        light_source
        {
            <-2, 0.5, -1.5>
            color rgb <0.1, 0.1, 0.3> * 0.1
        }
        
        global_lights on
    }
        
    // Bed roof
    box
    {
        <-1.1, 3, -1>, <2, 3.1, 1>
        pigment { color rgb 0 }
    }
    
    object 
    { 
        miles 
        translate -0.510919*y 
        scale 3
        rotate -130*z 
        rotate 180*x
        rotate 30*y
        //translate <0.8, 1.35, 0>
        translate <1.9, 1.0, 0.1>
    }

    rotate -90*y    
    translate <1.2, 0, 11.3>
}


#ifdef (USE_TRUCK)
    
    #include "truck.inc"
    
    object
    {
        Truck
        
        scale 0.5
        translate <1.2, 0.0, 10>
    }
#end // USE_TRUCK


#end // __MILES_INC__
