// POV-Ray 3.5 Scene File
// File: mtscrew.pov
// Vers: 1.0
// Desc: The Turn of the Screw
// Date: 2003/05/09
// Auth: Maurizio Tomasi
//

#declare USE_LAMPS = 1;
#declare USE_CARPETS = 1;
#declare USE_PARQUET = 1;
#declare USE_BIG_VASE = 1;
#declare USE_TABLE = 1;
#declare USE_BANISTERS = 1;
#declare USE_STAIRWAY = 1;
#declare USE_QUINT = 1;
#declare USE_PAINTING = 1;
#declare USE_TABLE_WITH_VASE = 1;
#declare USE_GIRL = 1;
#declare USE_MILES = 1;
#declare USE_TRUCK = 1;
#declare USE_AREA_LIGHTS = 1;
#declare USE_RADIOSITY = 1;

#declare CAMERA_NUM = 1;

#include "colors.inc" // Needed by "woods.inc"
#include "curtain_l.inc"
#include "curtain_r.inc"
    

global_settings 
{
    max_trace_level 20
    max_intersections 128
    assumed_gamma 1.0
  
#ifdef (USE_RADIOSITY)
    ambient_light 0

    radiosity
    {
        brightness 1.0 // it was 1.4
        normal true
    }
#end
}

// ---------------------------------------------
// Camera

#switch (CAMERA_NUM)

#case(1) // Default view
    #declare Location = <2.01, 2.01, -6.01>;
    #declare Direction = 1.4*z;
    #declare Right = x*image_width/image_height;
    #declare LookAt = <0.0, 0.5, 0.0>;
#break

#case(2) // See who is Peter Quint
    #declare Location = <2.0, 2.0, 0.0>;
    #declare Direction = -0.5*x;
    #declare Right = z*image_width/image_height;
    #declare LookAt = <-2.0, 1.0, 0.0>;
#break

#case(3) // Miles' room
    #declare Location = <3.0, 2.0, 12>;
    #declare Direction = -0.5*x;
    #declare Right = z*image_width/image_height;
    #declare LookAt = <-2.0, 2.0, 12>;
#break

#case(4) // The lamp and Peter Quint (similar to #2)
    #declare Location = <2.0, 2.0, -3.0>;
    #declare Direction = -1*x;
    #declare Right = z*image_width/image_height;
    #declare LookAt = <-2.0, 2.0, -3.0>;
#break

#case(5) // Side view of the lamp
    #declare Location = <0.0, 2.0, -5.0>;
    #declare Direction = 1.5*z;
    #declare Right = x*image_width/image_height;
    #declare LookAt = <0.0, 2.0, 5.0>;
#break

#case(6) // Side view of the table
    #declare Location = <0.0, 1.0, -5.0>;
    #declare Direction = 1.5*z;
    #declare Right = x*image_width/image_height;
    #declare LookAt = <0.0, 1.0, 5.0>;
#break

#case(7) // Above view of the table
    #declare Location = <0.5, 3.0, -3.9>;
    #declare Direction = -1.5*y;
    #declare Right = -x*image_width/image_height;
    #declare LookAt = <0.5, 1.0, -3.9>;
#break

#case(8) // See who is the lady
    #declare Location = <1.0, 1.5, 6>;
    #declare Direction = -1.5*z;
    #declare Right = -x*image_width/image_height;
    #declare LookAt = <1.0, 1.5, -3.0>;
#break

#case(9) // Look straight into Miles' room
    #declare Location = <1.5, 1.5, 2>;
    #declare Direction = 1.5*z;
    #declare Right = x*image_width/image_height;
    #declare LookAt = <1.5, 1.5, 6.0>;
#break
#end

camera 
{
    location  Location
    direction Direction
    right     Right
    look_at   LookAt
}

// ---------------------------------------------
// Light sources

light_source 
{
    // Moonlight through the stairway window
    <-20, 5, -40>
    color rgb <0.2, 0.2, 1.0> * 1.2
    spotlight
    point_at <-3.5, 0.75, 0.5>
    radius 1.5
    falloff 2.5
    
    #ifdef (USE_AREA_LIGHTS)
        area_light x, y, 3, 3
        adaptive 1
        jitter
    #end
}

light_source 
{
    // Light through Miles' window

    <-1, 1.5, 13>
    color rgb <0.1, 0.1, 0.3> * 3.0
    fade_power 2.0
    fade_distance 1.5
    
    #ifdef (USE_AREA_LIGHTS)
        area_light z, y, 3, 3
        adaptive 1
        jitter
    #end
}

#ifndef (USE_GIRL)
    light_source
    {
        // Candle hold by the young lady
        
        <2.0, 2.0, -6.0>
        color rgb <0.7, 0.65, 0.4> * 0.4 * 0.66
        fade_power 2
        fade_distance 1.5
        
        #ifdef (USE_AREA_LIGHTS)
            area_light 0.15*x, 0.15*y, 3, 3
            adaptive 1
            jitter
        #end
    }
#else
    light_source
    {
        // Faint light coming from the observer
        
        <2.0, 2.0, -6.0>
        color rgb <0.7, 0.65, 0.4> * 0.4 * 0.1
        fade_power 2
        fade_distance 2.5
        
        #ifdef (USE_AREA_LIGHTS)
            area_light 0.15*x, 0.15*y, 3, 3
            adaptive 1
            jitter
        #end
    }
#end

light_source
{
    // Light in Miles' room
    
    <-1, 5, 7.1>
    color rgb <0.6, 0.6, 0.8> * 0.05
}

sky_sphere
{
    pigment
    {
        gradient y
        color_map
        {
            [0.3 color <0.35, 0.20, 0.35>]
            [0.5 color <0.05, 0.05, 0.10>]
        }
        
        scale 2
        translate -1
    }
}

// ---------------------------------------------

#include "walls.inc"

// ---------------------------------------------
// Lamps

#ifdef (USE_LAMPS)

    #include "lamp.inc"
    
    #macro CreateLamp (ZPos, AreaAxis1, AreaAxis2)
        object 
        { 
            Lamp
    
            translate <0.015, 2, ZPos>
        }
        
        light_source
        {
            <0.29, 2.07, ZPos>
            color rgb <1, 0.6, 0.2> * 0.35 * 0.66
            fade_power 2
            fade_distance 1.2 //1.8
            
            #ifdef (USE_AREA_LIGHTS)
                area_light AreaAxis1, AreaAxis2, 2, 2
                adaptive 1
                jitter
            #end
        }
        
        // Halo
        sphere
        {
            0, 1
            hollow on
            
            pigment { color rgbt 1 }
            
            interior
            {
                media
                {
                    emission <0.7, 0.6, 0.1> * 0.25
                    method 2
                    variance 1.0/64
                    confidence 0.80
                    
                    density
                    {
                        spherical
                    }
                }                
            }
            
            scale 0.25
            
            translate <0.29, 2.07, ZPos>
        }
    #end
    
    // Nearer lamp
    CreateLamp (-3.5, vnormalize (<-1, 1, 0>)/30, z/30)

    // Farther lamp
    CreateLamp (3.5, vnormalize (<1, 1, 0>)/30, z/30)

#end // USE_LAMPS

// ---------------------------------------------
// Carpets

#ifdef (USE_CARPETS)
    
    #include "carpet.inc"

    #local ThreadTexture =
    texture
    {
        pigment { color rgb <0.7, 0.7, 0.65> * 0.75 }
    }
    
    #local OuterTexture =
    texture 
    { 
        pigment { color rgb <0.2, 0.05, 0.05> } 
    }
    
    #local InnerTexture =
    texture 
    { 
        CarpetTexture1 
        scale 0.3 
        rotate 90*x 
    }
        
    CreateCarpet (<0.7, -0.01, -4.5>, <2.3, 0.01, -1.67>, 0.1,
        OuterTexture, InnerTexture, ThreadTexture, 0.3, 0.0035, 150)

    #local OuterTexture =
    texture 
    { 
        pigment { color rgb <0.05, 0.05, 0.2> } 
    }
    
    #local InnerTexture =
    texture 
    { 
        CarpetTexture2
        scale 0.3
        rotate 90*x 
    }

    CreateCarpet (<0.8, -0.01, 1.67>, <2.2, 0.01, 6.0>, 0.1,
        OuterTexture, InnerTexture, ThreadTexture, 0.3, 0.0035, 150)

#end // USE_CARPETS

// ---------------------------------------------
// Vases

#ifdef (USE_BIG_VASE)

    #include "vase.inc"
    
    #local Zigzag =
    pigment
    {
        gradient y
        color_map
        {
            [0.2 color rgb <0.3, 0, 0> transmit 1]
            [0.2 color rgb <0.3, 0, 0> transmit 0]
            [0.3 color rgb <0.3, 0, 0> transmit 0]
            [0.3 color rgb <0.3, 0, 0> transmit 1]
            [0.5 color rgb <0.3, 0, 0> transmit 1]
            [0.5 color rgb <0.3, 0, 0> transmit 0]
            [0.6 color rgb <0.3, 0, 0> transmit 0]
            [0.6 color rgb <0.3, 0, 0> transmit 1]
            [0.6 color rgb <0.3, 0, 0> transmit 1]
            [0.9 color rgb <0.3, 0, 0> transmit 0]
            [0.9 color rgb <0.3, 0, 0> transmit 0]
            [1.0 color rgb <0.3, 0, 0> transmit 1]
        }
        
        scale 0.2
    }

    #local VaseNormal =
    normal
    {
        bumps 0.1
        scale 0.075
    }
    
    #local VaseFinish1 =
    finish
    {
        specular 0.4 roughness 0.03
        reflection { 0.1 }
    }

    #local VaseFinish2 =
    finish
    {
        specular 0.2 roughness 0.03
        reflection { 0.04 }
    }

    #local ZigzagTexture =
    texture
    {
        pigment { color rgb <0.6, 0.6, 1> }
        finish { VaseFinish1 }
    }
    texture
    {
        pigment { Zigzag rotate 45*z}
        finish { VaseFinish2 }
    }
    texture
    {
        pigment { Zigzag rotate -45*z}
        finish { VaseFinish2 }
    }
    
    #local VaseTexture =
    texture
    {
        gradient y
        texture_map
        {
            [0.72 ZigzagTexture]
            [0.72 pigment { color rgb <0.3, 0, 0> }]
            [0.76 pigment { color rgb <0.3, 0, 0> }]
            [0.76 pigment { color rgb <0.6, 0.6, 1> }]
        }
        
        scale 4
    }

    #declare VaseObject =
    union
    {
        object
        {
            VaseBase
            
            texture
            {
                pigment { color rgb <0.14, 0.14, 0.18> }
                
                normal { wrinkles 0.8 scale 0.005 }
            }
        }
    
        object
        {
            Vase
            texture { VaseTexture }
        }
        scale 0.4
    }
    
    object { VaseObject translate <-3, -1, 2.25> }

#end // USE_BIG_VASE


// ---------------------------------------------
// Table

#ifdef (USE_TABLE)

    #include "table.inc"

    #declare CandleBrass =
    texture
    {
        pigment 
        { 
            granite
            color_map
            {
                [0.4 color rgb <0.50, 0.50, 0.0> * 0.7]
                [0.7 color rgb <0.40, 0.40, 0.0> * 0.7]
                [1.0 color rgb <0.35, 0.35, 0.1> * 0.7]
            }
        }
        
        finish 
        { 
            specular 0.8
            roughness 0.02
            reflection
            { 
                0.4 
                metallic 
            } 
        }
    }
    
    #declare CandleVax =
    texture
    {
        pigment { color rgb <0.8, 0.8, 0.75> }
    }

    #declare CandleThread =
    texture
    {
        pigment { color rgb 1 * 2 }
    }

    #include "candle1.inc"

    #declare CandleThread =
    texture
    {
        pigment 
        { 
            gradient y
            color_map
            {
                [0.50 color rgb 1 * 2]
                [0.60 color rgb <0.7, 0.7, 0.2>]
                [0.70 color rgb 0]
            }
            
            scale 0.4
        }
    }

    #include "candle2.inc"

    union
    {
        object { Table }
        
        object { Candle1 rotate -10*y scale <1, 1, -1> * 0.1 translate <0.4, 2.2, -0.3> }
        object { Candle2 rotate 40*y scale 0.1 translate <0.85, 2.2, -0.2> }
        
        scale 0.4
        translate <0, 0, -3.9>
    }

#end // USE_TABLE


// ---------------------------------------------
// Painting ("The Island of the Dead")

#ifdef (USE_PAINTING)

    #local PaintingAspectRatio = 710.0 / 1200.0;

    #macro CreateSweepBox (Width, Height, Radius, Thickness)
        difference
        {
            box
            {
                <-CurWidth/2, -CurWidth/2 * PaintingAspectRatio, -Thickness/2>,
                < CurWidth/2,  CurWidth/2 * PaintingAspectRatio,  Thickness/2>
            }

            box
            {
                <-CurWidth/2 + Radius, -CurWidth/2 * PaintingAspectRatio + Radius, -Thickness>,
                < CurWidth/2 - Radius,  CurWidth/2 * PaintingAspectRatio - Radius,  Thickness>
            }
        }
    #end
    
    union
    {
        #local CurWidth = 2.5;

        // Painting
        box
        {
            <-CurWidth/2, -CurWidth/2 * PaintingAspectRatio, -0.05>,
            < CurWidth/2,  CurWidth/2 * PaintingAspectRatio,  0.00>
            
            texture
            {
                pigment
                {
                    image_map
                    {
                        jpeg "painting1.jpg"
                        once
                    }
                    
                    translate <-0.5, -0.5, 0>
                    scale <CurWidth, CurWidth * PaintingAspectRatio, 1> * 0.98
                }
            }
        }
        
        // Frame
        union
        {
            #local Thickness = 0.02;
            CreateSweepBox (CurWidth, CurWidth * PaintingAspectRatio, Thickness, 0.02)
            #declare CurWidth = CurWidth - 2 * Thickness;
            
            #local Thickness = 0.01;
            CreateSweepBox (CurWidth, CurWidth * PaintingAspectRatio, Thickness, 0.03)
            #declare CurWidth = CurWidth - 2 * Thickness;
            
            #local Thickness = 0.02;
            CreateSweepBox (CurWidth, CurWidth * PaintingAspectRatio, Thickness, 0.04)
            #declare CurWidth = CurWidth - 2 * Thickness;

            #local Thickness = 0.01;
            CreateSweepBox (CurWidth, CurWidth * PaintingAspectRatio, Thickness, 0.03)
            #declare CurWidth = CurWidth - 2 * Thickness;

            #local Thickness = 0.02;
            CreateSweepBox (CurWidth, CurWidth * PaintingAspectRatio, Thickness, 0.02)
            #declare CurWidth = CurWidth - 2 * Thickness;

            #local Thickness = 0.02;
            CreateSweepBox (CurWidth, CurWidth * PaintingAspectRatio, Thickness, 0.03)
            #declare CurWidth = CurWidth - 2 * Thickness;
            
            texture
            {
                pigment { color rgb <0.45, 0.4, 0> }
                
                finish
                {
                    reflection 0.2 roughness 0.03
                }
            }
            
            translate -0.05*z
        }
        
        translate <-1.9, 2.0, 3>
    }

#end // USE_PAINTING

// ---------------------------------------------
// Silhouette of Peter Quint

#ifdef (USE_QUINT)

    #local AspectRatio = 706/266;
    object
    {
        box
        {
            <0, 0, 0>, <1, 1, 0.01>
        }
        
        pigment
        {
            image_map
            {
                png "leopold.png"
                
                //interpolate 2
            }
        }
            
        scale <1.0, AspectRatio, 1.0>
        rotate -110*y
        
        translate <-3.3, -1.5, 1>
    }
    
    // Window curtains
    
    object
    {
        LeftCurtain
        pigment { color rgb 0 }
        
        rotate 90*y
        scale 1.5
        translate <-3.8, -1.5, -1.8>
    }
    
    object
    {
        RightCurtain
        pigment { color rgb 0 }
        
        rotate 90*y
        scale 1.5
        translate <-3.8, -1.5, 2.1>
    }
    
    // Window frame
    
    union
    {
        cylinder
        {
            <-4, 0, -0.6>, <-4, 2, -0.6>, 0.02
            translate 0.3*z
        }

        cylinder
        {
            <-4, 1, -2>, <-4, 1, 2>, 0.015
        }
        
        cylinder
        {
            <-4, 0.5, -2>, <-4, 0.5, 2>, 0.015
        }

        pigment { color rgb 0 }
    }
    

#end // USE_QUINT

// ---------------------------------------------
// The young lady

#ifndef (USE_GIRL)
    object
    {
        union
        {
            // Skirt
            cone
            {
                <0, 1, 0>, 0.2, <0, 0, 0>, 0.3
            }
    
            // Torso
            cylinder
            {
                <0, 1, 0>, <0, 1.6, 0>, 0.2
            }
    
            // Head        
            sphere
            {
                <0, 0, 0>, 0.15
                scale <1, 1.3, 1>
                translate 1.8*y
            }
            
            // Right arm
            cylinder
            {
                <0, 1.5, 0>, <0.6, 1.6, 0>, 0.08
            }
            
            cylinder
            {
                // At <0.7, 2, 0> there is the right hand
                // (the one that holds the candle)
                <0.6, 1.55, 0>, <0.7, 2., 0>, 0.06
            }
            
            // Left arm
            cylinder
            {
                <-0.2, 1.5, 0>, <-0.5, 1.2, 0>, 0.08
            }
            
            cylinder
            {
                <-0.5, 1.2, 0>, <-0.4, 0.9, 0.2>, 0.06
            }
        }
            
        translate <-0.7, -2, 0>
        // Now the right hand (holding the candle) is exactly at <0,0,0>    
        
        translate <2.0, 2.0, -6.0>
        pigment { color rgb 0 }
        
        no_shadow
        no_image
    }
#end // ! USE_GIRL

// ---------------------------------------------
// Table with vase

#ifdef (USE_TABLE_WITH_VASE)
    
    #include "fl_table.inc"
    
    object
    {
        TableWithFlowers
        scale 0.45
        translate <0.35, 0, 6.1>
    }
    
#end // USE_TABLE_WITH_VASE

// ---------------------------------------------
// The Girl

#ifdef (USE_GIRL)

    #include "girl.inc"
    #include "flame.inc"

    #local GirlTransf =
    transform
    {
        scale 2.75
        scale <-1, 1, 1>
        rotate -90*y
        translate <0.5, 0, 0>
    }
    
    #declare CandleTopPoint = <0.011099,0.619704,0.212531>;
    light_source
    {
        // Candle hold by the young lady
        
        CandleTopPoint
        color rgb <0.7, 0.65, 0.1> * 0.4 * 0.66
        fade_power 2
        fade_distance 1.5
        
        #ifdef (USE_AREA_LIGHTS)
            area_light 0.15*x, 0.15*y, 3, 3
            adaptive 1
            jitter
        #end
        
        transform { GirlTransf }
    }
    
    union
    {
        object
        { 
            CreateCandleFlame (<1.0, 0.4, 0.0>, <0.3, 0.2, 0.2>, 1.0)
            
            scale <0.13, 1, 0.13> * 0.025
        }
        
        // Halo
        sphere
        {
            0, 1
            hollow on
            
            pigment { color rgbt 1 }
            
            interior
            {
                media
                {
                    emission <0.7, 0.6, 0.1> * 0.3
                    
                    density
                    {
                        spherical
                    }
                }                
            }
            
            scale 0.067
            translate 0.025/2*y
        }

        no_shadow
        
        // This gives the feeling that the girl is walking backwards
        rotate 15*x
        
        translate CandleTopPoint + 0.005*y
        transform { GirlTransf }
    }
        
    object 
    { 
        girl 
        
        transform { GirlTransf }
    }
#end // USE_GIRL


// ---------------------------------------------
// Sleepin' Miles

#ifdef (USE_MILES)
    
    #include "miles.inc"
    
#end

