// Persistence of Vision Ray Tracer Scene Description File
// File: table2.inc
// Vers: 3.5
// Desc: Table
// Date: 2003/05/25
// Auth: Maurizio Tomasi
//

#version 3.5;

#include "rand.inc"
#include "new-wood.inc"

#local GraniteTexture =
texture
{
    pigment
    {
        granite
        color_map
        {
            [0.1 color rgb <0.3, 0.2, 0.1> * 0.1]
            [0.7 color rgb <0.3, 0.2, 0.1>]
            [0.7 color rgb <0.5, 0.5, 0.4>]
            [1.0 color rgb <0.5, 0.5, 0.4> * 0.4]
        }
    }
    
    finish
    {
        specular 0.4
        roughness 0.3
        
        reflection { 0.1 }
    }
    
    scale 0.4
}

// These points define the table shape
#local Vertexes = array[13]
{
    <-1.0,  1.2>,
    < 0.0,  1.5>,
    < 1.0,  1.3>,
    < 1.0,  1.0>,
    < 1.3,  0.0>,
    < 1.0, -1.0>,
    < 1.0, -1.3>,
    < 0.0, -1.5>,
    <-1.0, -1.2>,

    <-1.0,  1.2>,
    < 0.0,  1.5>,
    < 1.0,  1.3>,
    < 1.0,  1.0>,
}


#local TablePlane =
prism
{
    cubic_spline
    0.0, 0.1, dimension_size (Vertexes, 1)
    
    #local Count = 0;
    #while (Count < dimension_size (Vertexes, 1))
        Vertexes[Count]
        #local Count = Count + 1;
    #end
}

#local TablePlaneBorder =
sphere_sweep
{
    cubic_spline
    dimension_size (Vertexes, 1),
    
    #local Count = 0;
    #while (Count < dimension_size (Vertexes, 1))
        <Vertexes[Count].x, 0.05, Vertexes[Count].y>, 0.05
        #local Count = Count + 1;
    #end
}

#declare GranitePlane =
intersection
{
    union
    {
        object { TablePlane }
        object { TablePlaneBorder }
    }
    
    box
    {
        <0, 0, -1.5>, <1.5, 0.1, 1.5>
    }
}

#local TableBase =
intersection
{
    object { TablePlane }
    box { <0, 0, 0>, <1.5, 0.1, 1.5> }
    
    scale <0.95, 15, 0.95> 
    translate 0.5*y
    texture 
    { 
        Wood2[1] 
        rotate -30*x
    }
}

#local DrawerBase =
intersection
{
    object { TablePlane scale <1, 35, 1> }
    box { <0, 0.05, 0>, <1.5, 0.3, 0.8> }
}

#local HandlePlaque =
intersection
{
    object { DrawerBase }
    box { <1.1, 0.15, 0.45>, <1.5, 0.25, 0.68> }
    translate 0.005*x
}

#local DrawerHandle =
union
{
    object 
    { 
        HandlePlaque 
        
        texture
        {
            pigment { color rgb <0.64, 0.58, 0.0> * 0.7 }
            finish { specular 0.8 roughness 0.1 }
            normal { bozo 3 scale 0.005 }
        }
    }
    
    // Handle
    
    difference
    {
        union
        {
            cylinder
            {
                <0, 0.005, 0>, <0, 0.015, 0>, 0.1 
            }

            cylinder
            {
                <0, 0.010, 0>, <0, 0.020, 0>, 0.0925
            }
        }
        
        cylinder
        {
            <0, -0.1, 0>, <0, 0.1, 0>, 0.085
        }
        
        translate <1.15, 0.20, 0.56>
        
        texture
        {
            pigment { color rgb <0.64, 0.58, 0.0> * 0.7 }
            finish { specular 0.8 roughness 0.1 }
        }
    }
}

#local Drawer =
union
{
    object { DrawerBase }
    object { DrawerHandle }
}

#local DrawerCase =
union
{
    difference
    {
        object { TableBase }

        #local Count = 0.8;
        #while (Count <= 1.6)
            object { Drawer translate Count*y }
            #declare Count = Count + 0.4;
        #end

        cutaway_textures
    }

    #local DrawerSeed = seed (15230);
    
    #local Count = 0.8;
    #while (Count <= 1.6)
        object 
        { 
            Drawer 
            //scale 0.995 * <0, 1, 1> + <1, 0, 0>
            translate Count*y+RRand (-0.07, -0.03, DrawerSeed)*x 
            texture 
            { 
                Wood1[2] 
                rotate -30*x
                
                scale RRand(0.7, 0.9, DrawerSeed)
                translate 3*VRand(DrawerSeed)
            }
        }
        #declare Count = Count + 0.4;
    #end
    
    // Front legs
    
    cone
    {
        <1.0, 2.0, 1.3>, 0.1, <1.0, 0.0, 1.3>, 0.05
        texture
        {
            Wood1[1]
            rotate 90*x
            scale RRand(0.9, 1.0, DrawerSeed)
            translate VRand(DrawerSeed)
        }
    }

    cone
    {
        <1.0, 2.0, -1.3>, 0.1, <1.0, 0.0, -1.3>, 0.05
        texture
        {
            Wood1[1]
            rotate 90*x
            scale RRand(0.9, 1.0, DrawerSeed)
            translate VRand(DrawerSeed)
        }
    }
}

// ---------------------------------------------
// Vase

#include "stems.inc"
#include "rose.inc"
#include "vase2.inc"

#local Vase =
object
{
    SmallVase
    scale 0.5
    
    texture
    {
        pigment { color rgb <0.03, 0.04, 0.02> }
        finish 
        { 
            diffuse 0
            specular 0.6
            roughness 0.09
            reflection { 0.2, 1.0 fresnel on } 
            conserve_energy
        }
    }
}

#local RoseSeed = seed (16);

#local Roses =
union
{
    object 
    {
        RoseStems
        
        pigment { color rgb <0.1, 0.2, 0.1> }
    }
    
    object 
    { 
        // Front
        #local Color1 = color rgb <1, 0.1, 0.2>;
        #local Color2 = color rgb 1.2;
        CreateRose (10, RoseSeed, 40, Color1, Color2)

        rotate 90*x
        rotate -5*y
        scale 0.85
        translate < 0.00, 3.72,  0.95> 
    }
    
    object 
    { 
        // Left
        #local Color1 = color rgb <1.3, 0.3, 0.1>;
        #local Color2 = color rgb 1.4;
        CreateRose (10, RoseSeed, 50, Color1, Color2)

        rotate -55*z
        rotate -20*y
        scale 0.90
        translate < 0.93, 3.37,  0.30> 
    }

    object 
    { 
        #local Color1 = color rgb <1.5, 0.4, 0>;
        #local Color2 = color rgb 1.1;
        CreateRose (10, RoseSeed, 45, Color1, Color2)

        rotate 90*z
        rotate 60*y
        scale 0.65
        translate <-0.78, 2.99,  0.70> 
    }
    
    object 
    { 
        #local Color1 = color rgb <1, 0, 0>;
        #local Color2 = color rgb 1.2;
        CreateRose (10, RoseSeed, 48, Color1, Color2)

        rotate 40*z
        rotate -10*y
        scale 0.95
        translate <-0.35, 2.94, -0.42> 
    }
}


// ---------------------------------------------
// Putting all together...

#declare Table =
union
{
    union
    {
        object { GranitePlane scale <1, 0.33, 1> translate 0.167*y }
        object { GranitePlane scale <1.02, 0.67, 1.02> translate 0.1*y }
        object { GranitePlane scale <1.04, 1, 1.04> }
        
        texture { GraniteTexture }

        translate 2*y
    }

    object { DrawerCase }
    object { DrawerCase scale <1, 1, -1> }

    // Vase
    union
    {
        object { Vase scale 1.2 }
        object { Roses scale 0.5 rotate 150*y translate 0.9*y }
        
        scale 0.3
        translate <0.5, 2.2, 0.6>
    }
}
