// Persistence of Vision Ray Tracer Scene Description File
// File: trunk.inc
// Vers: 3.5
// Desc: Trunk placed in front of the bed tail
// Date: 2003/06/17 (anniversary of the imprisonment of Enzo Tortora)
// Auth: Maurizio Tomasi

#ifndef (__TRUCK_INC)
#declare __TRUCK_INC = 1;

#version 3.5;

#local TruckBaseHeight = 1.0;
#local TruckTopHeight = 0.3;
#local TruckWidth = 2.0;
#local TruckThickness = 1.0;

#local TruckCylRadius = (4 * pow (TruckTopHeight, 2.0) + pow (TruckThickness, 2.0)) / (8 * TruckTopHeight);
#local TruckCylCenterY = TruckBaseHeight + (TruckTopHeight - TruckCylRadius);

#local TruckTopBox =
box
{
    <-TruckWidth, TruckBaseHeight, -TruckThickness/2>, 
    <TruckWidth, TruckBaseHeight + TruckTopHeight, TruckThickness/2>
}

#local TruckWoodTexture = 
texture
{
    pigment
    {
        wood
        color_map
        {
            [0.4 color rgb <0.5, 0.04, 0.04>]
            [0.8 color rgb <0.1, 0.01, 0.01>]
        }

        warp { turbulence 0.3 }
    }
    
    normal
    {
        wood
        warp { turbulence 0.3 }
    }

    finish
    {
        specular 0.3 roughness 0.05
    }
    
    rotate 90*y
    scale 0.02
}

#local TruckWoodPart =
union
{
    // Boards
    
    #local MeanBoardHeight = TruckBaseHeight / 4;
    
    #local BoardSeed = seed (6234);
    #local CurPosY = 0.0;
    #while (CurPosY < TruckBaseHeight)
    
        #local BoardHeight = RRand (MeanBoardHeight * 0.7, MeanBoardHeight * 1.3, BoardSeed);
        
        box
        {
            <-TruckWidth/2, CurPosY, -TruckThickness/2>, 
            <TruckWidth/2, min (CurPosY + BoardHeight, TruckBaseHeight), TruckThickness/2>
    
            texture { TruckWoodTexture }
        }
        
        #declare CurPosY = CurPosY + BoardHeight * 1.05;
    #end
    

    intersection
    {
        object { TruckTopBox }
        
        cylinder
        {
            <-TruckWidth/2, TruckCylCenterY, 0>, <TruckWidth/2, TruckCylCenterY, 0>, TruckCylRadius
        }
        
        texture { TruckWoodTexture }
    }
}

#local TruckBordSize = 0.1;
#local TruckBordThickness = 0.02;
#local TruckKeyholeWidth = 0.25;
#local TruckKeyholeHeight = 0.20;
#local TruckKeyholePosY = TruckBaseHeight * 0.7;
#local TruckKeyholeRadius = 0.03;

#local TruckMetalBorder1 =
union
{
    box
    {
        <-TruckWidth/2, 0, -TruckThickness/2 - TruckBordThickness>,
        <TruckWidth/2, TruckBordSize, -TruckThickness/2>
    }
    
    box
    {
        <-TruckWidth/2, TruckBaseHeight - TruckBordSize, -TruckThickness/2 - TruckBordThickness>,
        <TruckWidth/2, TruckBaseHeight, -TruckThickness/2>
    }
    
    box
    {
        <-TruckWidth/2 - TruckBordThickness, 0, -TruckThickness/2 - TruckBordThickness>,
        <-TruckWidth/2 + TruckBordSize, TruckBaseHeight, -TruckThickness/2>
    }
    
    box
    {
        <TruckWidth/2 - TruckBordSize, 0, -TruckThickness/2 - TruckBordThickness>,
        <TruckWidth/2 + TruckBordThickness, TruckBaseHeight, -TruckThickness/2>
    }
}

#local TruckMetalBorder2 =
union
{
    box
    {
        <TruckWidth/2, 0, -TruckThickness/2>,
        <TruckWidth/2 + TruckBordThickness, TruckBordSize, TruckThickness/2>
    }

    box
    {
        <TruckWidth/2, TruckBaseHeight - TruckBordSize, -TruckThickness/2>,
        <TruckWidth/2 + TruckBordThickness, TruckBaseHeight, TruckThickness/2>
    }

    box
    {
        <TruckWidth/2, 0, -TruckThickness/2>,
        <TruckWidth/2 + TruckBordThickness, TruckBaseHeight, -TruckThickness/2 + TruckBordSize>
    }

    box
    {
        <TruckWidth/2, 0, TruckThickness/2 - TruckBordSize>,
        <TruckWidth/2 + TruckBordThickness, TruckBaseHeight, TruckThickness/2>
    }
}

#local TruckMetalBorders =
union
{
    object { TruckMetalBorder1 }
    object { TruckMetalBorder1 scale <1, 1, -1> }

    object { TruckMetalBorder2 }
    object { TruckMetalBorder2 scale <-1, 1, 1> }
    
    intersection
    {
        object { TruckTopBox }

        box
        {
            <-TruckWidth/2 + TruckBordSize, 
              TruckBaseHeight + TruckBordThickness, 
             -TruckThickness/2>,
             
            < TruckWidth/2 - TruckBordSize, 
              TruckBaseHeight + TruckTopHeight + TruckBordThickness, 
              TruckThickness/2>
              
            inverse
        }
        
        cylinder
        {
            <-TruckWidth/2 - TruckBordThickness, TruckCylCenterY, 0>, 
            <TruckWidth/2 + TruckBordThickness, TruckCylCenterY, 0>, 
            TruckCylRadius + TruckBordThickness
        }
        
        cylinder
        {
            <-TruckWidth/2 - 2 * TruckBordThickness, TruckCylCenterY, 0>, 
            <TruckWidth/2 + 2 * TruckBordThickness, TruckCylCenterY, 0>, 
            TruckCylRadius - TruckBordSize
            
            inverse
        }
    }
    
    // Keyhole
    
    box
    {
        <-TruckKeyholeWidth/2, -TruckKeyholeHeight/2, -TruckThickness/2 - TruckBordThickness>
        <TruckKeyholeWidth/2, TruckKeyholeHeight/2, -TruckThickness/2>
        
        translate TruckKeyholePosY * y
    }

    texture
    {
        pigment { color rgb <0.05, 0.05, 0.1> }
        normal { bozo 1.5 scale TruckBordSize / 4 }
        finish { specular 0.6 roughness 0.09 metallic }
    }
}

#declare Truck =
difference
{
    union
    {
        object { TruckWoodPart }
        object { TruckMetalBorders }
    }
    
    union
    {
        cylinder
        {
            <0, TruckKeyholePosY + TruckKeyholeRadius, -TruckThickness/2 - 2 * TruckBordThickness>
            <0, TruckKeyholePosY + TruckKeyholeRadius, -TruckThickness/2 + 2 * TruckBordThickness>,
            TruckKeyholeRadius
        }
        
        box
        {
            <-TruckKeyholeRadius/2, 
              TruckKeyholePosY - 2 * TruckKeyholeRadius, 
              -TruckThickness/2 - 2 * TruckBordThickness>,
              
            < TruckKeyholeRadius/2, 
              TruckKeyholePosY + TruckKeyholeRadius, 
             -TruckThickness/2 + 2 * TruckBordThickness>
        }
        
        pigment { color rgb 0 }
    }
}

#end // __TRUCK_INC


