// Persistence of Vision Ray Tracer Scene Description File
// File: case.inc
// Vers: 3.5
// Desc: Contains the medals case object for prize.pov
// Date: June 23, 2003
// Auth: Philip Chan

#ifdef(Case_Inc_Temp)
// do nothing
#else
#declare Case_Inc_Temp=version;

#ifdef(View_POV_Include_Stack)
#debug "including case.inc\n"
#end

// Silver metal texture
#declare T_Case = texture {
	pigment { colour rgb <0.85, 0.85, 0.85> }
	finish {
		ambient 0.3
		diffuse 0.6
		brilliance 2
		specular 1.0
		roughness 0.02
		reflection 0.1
		metallic
	}
}

// hinge
#declare Hinge = union {
	// case mount
	box { <-0.4, 0.2, 0>, <0.4, 0.415, 0.30> }
	// hinge body
	difference {
		union {
			cylinder { <-0.4, 0.475, 0>, <-0.208, 0.475, 0>, 0.075 }
			cylinder { <0.008, 0.475, 0>, <0.192, 0.475, 0>, 0.075 }
		}
		cylinder { <-0.5, 0.475, 0>, <0.2, 0.475, 0>, 0.06 }
		box { <-0.5, 0.415, 0.75>, <0.2, 0.44, 0> }
	}
	// pin
	cylinder { <-0.415, 0.475, 0>, <0.415, 0.475, 0>, 0.06 }
	// "caps" for pin
	union {
		difference {
			sphere { <0, 0, 0>, 1
				scale <0.05, 0.075, 0.075>
			}
			plane { x, 0 }
		}
		difference {
			sphere { <0, 0, 0>, 1
				scale <0.15, 0.075, 0.075>
			}
			plane { -x, 0 }
		}
		translate <-0.42, 0.475, 0>
	}
}

// inside of case
#declare Case_Inside = union {
	box { <-6.5, -0.5, 0>, <6.5, 0.5, 6> }  // chopped on x-axis
	box { <-8, -0.5, 1.5>, <8, 0.5, 4.5> }  // chopped on z-axis
	cylinder { <-6.5, -0.5, 1.5>, <-6.5, 0.5, 1.5>, 1.5 }
	cylinder { <6.5, -0.5, 1.5>, <6.5, 0.5, 1.5>, 1.5 }
	cylinder { <-6.5, -0.5, 4.5>, <-6.5, 0.5, 4.5>, 1.5 }
	cylinder { <6.5, -0.5, 4.5>, <6.5, 0.5, 4.5>, 1.5 }
}

// one side of the case
#declare Case_Side = union {
	// metal portion - bottom
	box { <-6.60, -0.75, 1.10>, <6.60, -0.5, 4.60> } // flat part
	// rounded edges, going counter-clockwise
	union {
		sphere { <-6.60, 0, 1.40>, 1.5 }
		cylinder { <-6.60, 0, 1.40>, <6.60, 0, 1.40>, 1.5 }
		sphere { <6.60, 0, 1.40>, 1.5 }
		cylinder { <6.60, 0, 1.40>, <6.60, 0, 4.60>, 1.5 }
		sphere { <6.60, 0, 4.60>, 1.5 }
		cylinder { <6.60, 0, 4.60>, <-6.60, 0, 4.60>, 1.5 }
		sphere { <-6.60, 0, 4.60>, 1.5 }
		cylinder { <-6.60, 0, 4.60>, <-6.60, 0, 1.40>, 1.5 }
		scale <1, 1/6, 1>
		translate -y*0.5
	}
	// metal portion - body
	difference {
		union {
			box { <-6.60, -0.5, -0.10>, <6.60, 0.5, 6.10> }  // chopped on x-axis
			box { <-8.10, -0.5, 1.40>, <8.10, 0.5, 4.60> }  // chopped on z-axis
			cylinder { <-6.60, -0.5, 1.40>, <-6.60, 0.5, 1.40>, 1.5 }
			cylinder { <6.60, -0.5, 1.40>, <6.60, 0.5, 1.40>, 1.5 }
			cylinder { <-6.60, -0.5, 4.60>, <-6.60, 0.5, 4.60>, 1.5 }
			cylinder { <6.60, -0.5, 4.60>, <6.60, 0.5, 4.60>, 1.5 }			
		}
		object { Case_Inside translate y*0.1 }
	}
	// hinges
	object { Hinge translate <-3.5, 0, -0.3> }
	object { Hinge translate <3.5, 0, -0.3> }
	// inside portion of case
	union {
		difference {
			object { Case_Inside 
				translate -y*0.05
			}
			// cutaways for Awards
			object { Award_Shape
				translate <-5, 0.45, 3>
			}
			object { Award_Shape
				translate <0, 0.45, 3>
			}
			object { Award_Shape
				translate <5, 0.45, 3>
			}
		}
		torus { 2.15, 0.1
			translate <-5, 0.35, 3>
		}
		torus { 2.15, 0.1
			translate <0, 0.35, 3>
		}
		torus { 2.15, 0.1
			translate <5, 0.35, 3>
		}
		pigment { colour Red }
		finish {
			specular 0.07
			roughness 0.1
			diffuse 0.9
		}
		normal {
			granite -0.025
			turbulence <0.5, 0.75, 0.75>
			octaves 7
			lambda 0.5
			omega 0.2
			sine_wave
			scale <0.3, 0.3, 0.2>
    }
	}
	//pigment { colour rgb <0.75, 0.75, 0.75> }
}

// rim for case
#declare Rim = difference {
	union {
		box { <-6.60, 0.5, -0.10>, <6.60, 0.6, 6.10> }  // chopped on x-axis
		box { <-8.10, 0.5, 1.40>, <8.10, 0.6, 4.60> }  // chopped on z-axis
		cylinder { <-6.60, 0.5, 1.40>, <-6.60, 0.6, 1.40>, 1.5 }
		cylinder { <6.60, 0.5, 1.40>, <6.60, 0.6, 1.40>, 1.5 }
		cylinder { <-6.60, 0.5, 4.60>, <-6.60, 0.6, 4.60>, 1.5 }
		cylinder { <6.60, 0.5, 4.60>, <6.60, 0.6, 4.60>, 1.5 }			
	}
	union {
		box { <-6.55, 0.4, -0.05>, <6.55, 0.7, 6.05> }  // chopped on x-axis
		box { <-8.05, 0.4, 1.45>, <8.05, 0.7, 4.45> }  // chopped on z-axis
		cylinder { <-6.55, 0.4, 1.45>, <-6.55, 0.7, 1.45>, 1.5 }
		cylinder { <6.55, 0.4, 1.45>, <6.55, 0.7, 1.45>, 1.5 }
		cylinder { <-6.55, 0.4, 4.55>, <-6.55, 0.7, 4.55>, 1.5 }
		cylinder { <6.55, 0.4, 4.55>, <6.55, 0.7, 4.55>, 1.5 }			
	}
	plane { -y, 0
		rotate -x*degrees( atan2( 0.1, 3.2 ) )
		translate <0, 0.5, 1.4>
	}
}

#declare Case = union {
	// bottom side
	union {
		object { Case_Side }
		object { Rim }
		translate z*0.3
	}
	// top side
	difference {
		object { Case_Side rotate y*180 }
		object { Rim
			translate -y*0.5  // move to origin for rotation
			rotate -x*180
			scale 1.00001  // so the rim is wider
			translate y*0.5  // move back into position
		}
		translate z*-0.3
	}
	// latch
	prism {
		linear_spline
		-0.01, 0.01, 12
		<-0.5, 0.4>, <-0.5, 0.5>, <-0.25, 0.7>, <0.25, 0.7>, <0.5, 0.5>, <0.5, 0.4>, <-0.5, 0.4>,
		<-0.3, 0.5>, <-0.15, 0.6>, <0.15, 0.6>, <0.3, 0.5>, <-0.3, 0.5>
		rotate -x*90
		translate z*-6.375
	}
	// Awards
	object { Award( T_3rd, T_3rd_text, Third_text )
		rotate y*69.30
		translate <-5, 0.5, 3.3>
	}
	object { Award( T_2nd, T_2nd_text, Second_text )
		rotate y*198.24
		translate <0, 0.5, 3.3>
	}
	texture { T_Case }
}

#version Case_Inc_Temp;
#end
