// Persistence of Vision Ray Tracer Scene Description File
// File: pc_woods.inc
// Vers: 3.5
// Desc: Contains modified wood textures for prize.pov
// Date: June 25, 2003
// Auth: Philip Chan

#ifdef(PC_Woods_Inc_Temp)
// do nothing
#else
#declare PC_Woods_Inc_Temp=version;

#ifdef(View_POV_Include_Stack)
#debug "including pc_woods.inc\n"
#end

#include "woods.inc"

//----- Hardwood Floor textures -----\\
#declare P_WoodGrain1A_PC1 = pigment {
	wood
	turbulence 0.06
	octaves 4
	scale <0.05, .05, 1>
}
#declare P_WoodGrain1B_PC1 = pigment {
	wood
	turbulence <0.2, 0.6, 1>
	octaves 5
	lambda 2.75
	scale <0.18, .6, 1>
	rotate <7, 10, 3>
	translate -x*2
}
#declare M_Wood13A_PC1 = color_map { 
	[0.0, 0.1 color rgb <0.96, 0.56, 0.32>
	          color rgb <0.96, 0.56, 0.32>]
	[0.1, 0.9 color rgb <0.96, 0.56, 0.32>
	          color rgb <1.00, 0.91, 0.42>]
	[0.9, 1.0 color rgb <1.00, 0.91, 0.42>
	          color rgb <0.96, 0.56, 0.32>]
}
#declare M_Wood13B_PC1 = color_map { 
	[0.0, 0.4 color rgbt <1.00, 1.00, 1.00, 1.00>
	          color rgbt <1.00, 0.91, 0.42, 0.30>]
	[0.4, 0.5 color rgbt <1.00, 0.91, 0.42, 0.00>
	          color rgbt <1.00, 0.91, 0.42, 0.30>]
	[0.5, 1.0 color rgbt <1.00, 0.91, 0.42, 0.30>
	          color rgbt <1.00, 1.00, 1.00, 1.00> ] 
}
#declare T_Wood23_PC1 = texture {  pigment{ P_WoodGrain1A_PC1 color_map { M_Wood13A_PC1 }}}
	texture {  pigment{ P_WoodGrain1B_PC1 color_map { M_Wood13B_PC1 }}}

#declare P_WoodGrain1A_PC2 = pigment {
	wood
	turbulence 0.05
	octaves 3
	scale <0.06, .06, 1>
}
#declare P_WoodGrain1B_PC2 = pigment {
	wood
	turbulence <0.1, 0.5, 1>
	octaves 6
	lambda 3.00
	scale <0.12, .4, 1>
	rotate <3, 12, 7>
	translate -x*2
}
#declare M_Wood13A_PC2 = color_map { 
	[0.0, 0.1 color rgb <0.84, 0.49, 0.28>
	          color rgb <0.84, 0.49, 0.28>]
	[0.1, 0.9 color rgb <0.84, 0.49, 0.28>
	          color rgb <1.00, 0.78, 0.36>]
	[0.9, 1.0 color rgb <1.00, 0.78, 0.36>
	          color rgb <0.84, 0.49, 0.28>]
}
#declare M_Wood13B_PC2 = color_map { 
	[0.0, 0.4 color rgbt <1.00, 1.00, 1.00, 1.00>
	          color rgbt <1.00, 0.78, 0.36, 0.30>]
	[0.4, 0.5 color rgbt <1.00, 0.78, 0.36, 0.00>
	          color rgbt <1.00, 0.78, 0.36, 0.30>]
	[0.5, 1.0 color rgbt <1.00, 0.78, 0.36, 0.30>
	          color rgbt <1.00, 1.00, 1.00, 1.00> ] 
}
#declare T_Wood23_PC2 = texture {  pigment{ P_WoodGrain1A_PC2 color_map { M_Wood13A_PC2 }}}
	texture {  pigment{ P_WoodGrain1B_PC2 color_map { M_Wood13B_PC2 }}}

#declare P_WoodGrain1A_PC3 = pigment {
	wood
	turbulence 0.04
	octaves 3
	scale <0.05, .05, 1>
}
#declare P_WoodGrain1B_PC3 = pigment {
	wood
	turbulence <0.1, 0.5, 1>
	octaves 5
	lambda 3.25
	scale <0.15, .5, 1>
	rotate <5, 10, 5>
	translate -x*2
}
#declare M_Wood13A_PC3 = color_map { 
	[0.0, 0.1 color rgb <0.90, 0.53, 0.30>
	          color rgb <0.90, 0.53, 0.30>]
	[0.1, 0.9 color rgb <0.90, 0.53, 0.30>
	          color rgb <1.00, 0.85, 0.39>]
	[0.9, 1.0 color rgb <1.00, 0.85, 0.39>
	          color rgb <0.90, 0.53, 0.30>]
}
#declare M_Wood13B_PC3 = color_map { 
	[0.0, 0.4 color rgbt <1.00, 1.00, 1.00, 1.00>
	          color rgbt <1.00, 0.85, 0.39, 0.30>]
	[0.4, 0.5 color rgbt <1.00, 0.85, 0.39, 0.00>
	          color rgbt <1.00, 0.85, 0.39, 0.30>]
	[0.5, 1.0 color rgbt <1.00, 0.85, 0.39, 0.30>
	          color rgbt <1.00, 1.00, 1.00, 1.00> ] 
}
#declare T_Wood23_PC3 = texture {  pigment{ P_WoodGrain1A_PC3 color_map { M_Wood13A_PC3 }}}
	texture {  pigment{ P_WoodGrain1B_PC3 color_map { M_Wood13B_PC3 }}}
//----- End of Hardwood Floor textures -----\\

#declare Flecks = texture {
	pigment {
		granite
		octaves 4
		lambda 0.25
		omega 1
    turbulence <0.5, 1, 1>
		color_map {
            [ 0.000  0.270 color rgbt <0.2, 0.1, 0.0, 1.0> color rgbt <0.2, 0.1, 0.0, 1.0> ]
            [ 0.270  0.280 color rgbt <0.2, 0.1, 0.0, 0.1> color rgbt <0.2, 0.1, 0.0, 0.1> ]
            [ 0.280  0.470 color rgbt <0.2, 0.1, 0.0, 1.0> color rgbt <0.2, 0.1, 0.0, 1.0> ]
            [ 0.470  0.480 color rgbt <0.2, 0.1, 0.0, 0.1> color rgbt <0.2, 0.1, 0.0, 0.1> ]
            [ 0.480  0.680 color rgbt <0.2, 0.1, 0.0, 1.0> color rgbt <0.2, 0.1, 0.0, 1.0> ]
            [ 0.680  0.690 color rgbt <0.2, 0.1, 0.0, 0.1> color rgbt <0.2, 0.1, 0.0, 0.1> ]
            [ 0.690  0.880 color rgbt <0.2, 0.1, 0.0, 1.0> color rgbt <0.2, 0.1, 0.0, 1.0> ]
            [ 0.880  0.890 color rgbt <0.2, 0.1, 0.0, 0.1> color rgbt <0.2, 0.1, 0.0, 0.1> ]
            [ 0.890  1.000 color rgbt <0.2, 0.1, 0.0, 1.0> color rgbt <0.2, 0.1, 0.0, 1.0> ]
		}
    scale <0.75, 0.1, 0.1>
	}
}

#declare M_Wood15A_PC = 
colour_map {
    [0.00 0.25   color rgb < 0.504, 0.310, 0.078> * 0.7 * 1.1
                 color rgb < 0.531, 0.325, 0.090> * 0.8 * 1.1 ]
    [0.25 0.40   color rgb < 0.531, 0.325, 0.090> * 0.8 * 1.1
                 color rgb < 0.547, 0.333, 0.090> * 0.5 * 1.1 ]
    [0.40 0.50   color rgb < 0.547, 0.333, 0.090> * 0.5 * 1.1
                 color rgb < 0.504, 0.310, 0.075> * 0.6 * 1.1 ]
    [0.50 0.70   color rgb < 0.504, 0.310, 0.075> * 0.6 * 1.1 
                 color rgb < 0.559, 0.322, 0.102> * 0.4 * 1.1 ]
    [0.70 0.98   color rgb < 0.559, 0.322, 0.102> * 0.4 * 1.1
                 color rgb < 0.531, 0.325, 0.086> * 0.4 * 1.1 ]
    [0.98 1.00   color rgb < 0.531, 0.325, 0.086> * 0.4 * 1.1
                 color rgb < 0.504, 0.310, 0.078> * 0.7 * 1.1 ]
}
#declare M_Wood15B_PC = 
colour_map {
    [0.00 0.25   color rgbt < 0.404, 0.210, 0.078, 0.20> * 1.1
                 color rgbt < 0.431, 0.225, 0.090, 0.80> * 1.1]
    [0.25 0.40   color rgbt < 0.431, 0.225, 0.090, 0.80> * 1.1
                 color rgbt < 0.447, 0.233, 0.090, 0.20> * 1.1]
    [0.40 0.50   color rgbt < 0.447, 0.233, 0.090, 0.20> * 1.1
                 color rgbt < 0.404, 0.210, 0.075, 0.60> * 1.1]
    [0.50 0.70   color rgbt < 0.404, 0.210, 0.075, 0.60> * 1.1
                 color rgbt < 0.459, 0.222, 0.102, 0.20> * 1.1]
    [0.70 0.98   color rgbt < 0.459, 0.222, 0.102, 0.20> * 1.1
                 color rgbt < 0.431, 0.225, 0.086, 0.40> * 1.1]
    [0.98 1.00   color rgbt < 0.431, 0.225, 0.086, 0.40> * 1.1
                 color rgbt < 0.404, 0.210, 0.078, 0.10> * 1.1]
}

#declare T_Wood25_PC1 =
    texture {  pigment{ P_WoodGrain1A color_map { M_Wood15A_PC }}}
    texture {  pigment{ P_WoodGrain1B color_map { M_Wood15B_PC }}}
		texture {  Flecks rotate y*90 }

#declare T_Wood25_PC2 =
    texture {  pigment{ P_WoodGrain1A color_map { M_Wood15A_PC }}}
    texture {  pigment{ P_WoodGrain1B color_map { M_Wood15B_PC }}}

#version PC_Woods_Inc_Temp;
#end
