// Persistence of Vision Ray Tracer Scene Description File
// File: prize.pov
// Vers: 3.5
// Desc: Scene file for "The Prize" - IRTC Mystery round, May-June 2003
// Date: June 25, 2003
// Auth: Philip Chan

// -uv +w1024 +h768 +a0.2 +r4

#include "award.inc"
#include "case.inc"
#include "book.inc"
#include "pc_woods.inc"
#include "woods.inc"
#include "fieldcam.inc"
#include "logo.inc"

//----- Rendering Parameters -----\\
#declare realistic_lighting = false;  // enables light group for realistic lighting
#declare brightness_factor = 0;  // added onto radiosity brightness value

#declare rad_quality = true;  // enable radiosity quality factor variables
#declare rad_up_factor = 3*rad_quality;  // percentage increase for "higher is better" values
#declare rad_down_factor = 0.75*rad_quality;  // percentage decrease for "lower is better" values
//----- End of Rendering Parameters -----\\

//----- Lighting -----\\
// radiosity
global_settings {
	ambient_light 0
	radiosity {
		pretrace_start 0.08*( 1 - rad_down_factor )
		pretrace_end   0.04*( 1 - rad_down_factor )
		count floor( 35*( 1 + rad_up_factor ) )
		
		nearest_count floor( 5*( 1 + rad_up_factor ) )
		error_bound 1.3
		recursion_limit 3
		
		low_error_factor 0.5*( 1 - rad_down_factor )
		gray_threshold 0.0
		minimum_reuse 0.015*( 1 - rad_down_factor )
		brightness 2 + brightness_factor
		
		adc_bailout 0.01/2
	}
}

// light in hallway
light_source {
	<-61.5, 42, 86>
	colour <1.0, 1.0, 0.9>*2
}
//----- End of Lighting -----\\

//----- Camera -----\\
#declare CamPos = <0, 30, -40>;
#declare CamLook = <0, 18, -20>;
camera {
	FieldCam (CamPos, CamLook)
	perspective
	location CamPos
	transform { NoFall }
	look_at CamLook
}
//----- End of Camera -----\\

//----- Room Textures -----\\
// Wall texture
#declare T_Wall = texture {
	pigment {
		granite
		colour_map {
			[ 0.00 colour rgb 0.7 ]
			[ 0.20 colour rgb 1.0 ]
			[ 1.00 colour rgb 1.0 ]
		}
	}
}
//----- End of Room Textures -----\\

//----- Room and Hallway -----\\
// create light_group for realistic lighting option
#if ( realistic_lighting )
	// hallway light_group
	light_group {
		light_source {
			<-61.5, 42, 86>
			colour White
		}
#end
// hallway and ceiling planes
union {
	plane { x, -70 }
	plane { -y, -50 }
	texture { T_Wall }
}
// floor plane
union {
	plane { y, 0.99 }
	// room floor
	#declare fseed = seed(48500);
	#declare gutter = 0.00;
	#declare j = -75;
	#while ( j < 75 )
		#declare i = -50;
		#while ( i < 50 )
			#declare len = 12 + 12*rand(fseed);
			#if ( 50 - (len + i) < 12 )  // if there's less than 12 units left, go all the way to wall
				#declare len = 50 - i;
			#end
			box { <i, -100, j>, <i + len - gutter, 1, j + 5 - gutter>
				texture {
					#switch ( rand(fseed) )
						#range( 0, 1/3 )
							T_Wood23_PC1
						#break
						#range( 1/3, 2/3 )
							T_Wood23_PC2
						#break
						#range( 2/3, 1 )
							T_Wood23_PC3
						#break
					#end
					scale 20 + 10*rand(fseed)
					rotate y*90
					translate <10000*rand(fseed), 10000*rand(fseed), 10000*rand(fseed)>
				}
				finish {
					reflection 0.05
					specular 0.1
					roughness 0.02
					diffuse 0.4
				}
			}
			#declare i = i + len;
		#end
		#declare j = j + 5;
	#end
	// hallway floor
	#declare j = 50;
	#while ( j < 150 )
		#declare i = -70;
		#while ( i != -50 )
			#declare len = 12 + 12*rand(fseed);
			#if ( -50 - (len + i) < 12 )  // if there's less than 12 units left, go all the way to wall
				#declare len = -50 - i;
			#end
			box { <i, -100, j>, <i + len - gutter, 1, j + 5 - gutter>
				texture {
					#switch ( rand(fseed) )
						#range( 0, 1/3 )
							T_Wood23_PC1
						#break
						#range( 1/3, 2/3 )
							T_Wood23_PC2
						#break
						#range( 2/3, 1 )
							T_Wood23_PC3
						#break
					#end
					scale 20 + 10*rand(fseed)
					rotate y*90
					translate <10000*rand(fseed), 10000*rand(fseed), 10000*rand(fseed)>
				}
				finish {
					reflection 0.05
					specular 0.1
					roughness 0.02
					diffuse 0.4
				}
			}
			#declare i = i + len;
		#end
		#declare j = j + 5;
	#end
	// texture for hallway plane
	texture { T_Wood23
		scale 25
		rotate y*90
	}
}
// end light_group for realistic option
#if ( realistic_lighting )
		global_lights off
	}
#end 

#declare Door_Opening = box { <-53, 0, 58>, <-49, 46, 73> }

// room
union {
	difference {
		box { <-52, -2, -77>, <52, 52, 77> }
		box { <-50, 0, -75>, <50, 50, 75> }
		object { Door_Opening
			texture { T_Wood27 }
		}
		texture { T_Wall }
	}
	// door frame
	union {
		difference {
			box { <-52.5, 0, 57>, <-49.5, 47, 74> }
			object { Door_Opening }
		}
		box { <-51.25, 0, 72.5>, <-50.75, 47, 73> }
		texture { T_Wood27 }
	}
	// light switch
	union {
		box { <-50, 19, 54.5>, <-49.75, 21, 55> }
		box { <-50, 19.9, 54.6>, <-49.25, 20.1, 54.7>
			translate <49.75, -20, 0>  // move left middle to origin
			rotate -z*15
			translate <-49.75, 20, 0>  // put back into place
		}
		pigment { colour Yellow }
	}
}

// door
union {
	box { <-50.75, 1.5, 73>, <-50, 47, 58>
		texture { T_Wood30 }
	}
	// knob
	union {
		cylinder { <-50.75, 20, 61>, <-50.00, 20, 61>, 0.6 }
		cylinder { <-51, 20, 61>, <-49.75, 20, 61>, 0.15 }
		cone { <-51.75, 20, 61>, 0.6, <-51, 20, 61>, 0.4 }
		cone { <-49.75, 20, 61>, 0.4, <-49, 20, 61>, 0.6 }
		cylinder { <-50.375, 20, 57.9>, <-50.375, 20, 58>, 0.25 }
		texture { T_3rd }
	}
	translate <50, 0, -73>  // bring far right corner to origin for rotation
	rotate -y*18
	translate <-50, 0, 73>  // put door back in place
}
//----- End of Room and Floor -----\\

#declare POV = object {
	Center_Object( text { ttf "ariblk.ttf", "Persistence of Vision", 0.1, 0 rotate z*90 }, x+y+z )
}
#declare POVRay35 = object {
	Center_Object( text { ttf "ariblk.ttf", "POV-Ray 3.5", 0.1, 0 rotate z*90 }, x+y )
}
#declare POVRay = object {
	Center_Object( text { ttf "ariblk.ttf", "POV-Ray", 0.1, 0 rotate z*90 }, x+y )
}

// bookshelf
union {
	difference {
		box { <-26, 0, 68>, <-6, 37, 75> }
		box { <-25, 2, 67>, <-7, 8, 74> }
		box { <-25, 9, 67>, <-7, 15, 74> }
		box { <-25, 16, 67>, <-7, 22, 74> }
		box { <-25, 23, 67>, <-7, 29, 74> }
		box { <-25, 30, 67>, <-7, 36, 74> }
		texture { T_Wood30 }
	}
	// books
	#declare bseed = seed(23216);
	#declare j = 2;
	#declare i = -25;
	#while ( j <= 30 )
		#declare i = -25;
		#while ( i < -7 )
			#declare height = 3 + 2*rand(bseed);
			#declare depth = 0.4*height + 0.2*height*rand(bseed);
			#declare len = 0.05*height + 0.2*height*rand(bseed);
			#if ( -7 - (len + i) < 0.15 )  // if there's less than 0.15 units left, go all the way to end
				#declare len = -7 - i;
			#end
			#declare colour1 = rgb <rand(bseed), rand(bseed), rand(bseed)>*0.95;
			#declare colour2 = rgb <rand(bseed), rand(bseed), rand(bseed)>*0.95;
			#declare colour3 = rgb <rand(bseed), rand(bseed), rand(bseed)>*0.95;
			difference {
				// body
				box { <i, j, 74 - depth>, <i + len, j + height, 74>
					pigment {
						gradient y
						colour_map {
							[0.00 colour colour1 ]
							[0.50 colour colour1 ]
							[0.50 colour colour2 ]
							[1.00 colour colour2 ]
						}
						scale 4*height
						translate y*3*height*rand(bseed)
					}
				}
				// pages
				box { <i + 0.05*len, j + height - 0.05*len, 74 - depth + 0.05*len>, <i + 0.95*len, j + height + 1, 75>
					pigment { colour White }
				}
				// text
				#switch ( height / len )
					#range ( 0, 8 )
						object { POVRay
							scale len*( 0.6 + 0.1*rand(bseed) )
							translate <i + len/2, j + height/2 + 0.1*height*rand(bseed), 74 - depth>
							pigment { colour colour3 }
						}
					#break
					#range ( 8, 12 )
						object { POVRay35
							scale len*( 0.6 + 0.1*rand(bseed) )
							translate <i + len/2, j + height/2 + 0.15*height*rand(bseed), 74 - depth>
							pigment { colour colour3 }
						}
					#break
					#else
						object { POV
							scale len*( 0.6 + 0.1*rand(bseed) )
							translate <i + len/2, j + height/2 + 0.2*height*rand(bseed), 74 - depth>
							pigment { colour colour3 }
						}
					#break
				#end
			}
			#declare i = i + len;
		#end
		#declare j = j + 7;
	#end
}

// safe
union {
	// body
	difference {
		box { <-5, 0, 60>, <10, 12, 75> }
		box { <-3, 2, 61>, <8, 10, 73> }
		box { <-4, 1, 59>, <9, 11, 61.1> }
	}
	// door
	union {
		box { <-4, 1, 60>, <9, 11, 61> }
		box { <-3, 2, 61>, <8, 10, 63> }
		// dial
		cylinder { <2.5, 6, 59.75>, <2.5, 6, 60>, 1.25
			pigment { colour Black }
		}
		cone { <2.5, 6, 59>, 0.75, <2.5, 6, 59.75>, 1
			pigment { colour rgb <0.75, 0.75, 0.75> }
		}
		// keyhole
		cylinder { <-1.5, 6, 59.85>, <-1.5, 6, 60>, 0.4
			pigment { colour rgb <0.75, 0.75, 0.75> }
		}
		translate <-9, 0, -61>  // bring far right to origin for rotation
		rotate -y*45
		translate <9, 0, 61>  // put back into place
	}
	pigment { colour rgb <0.5, 0.5, 0.5> }
	translate <-1, 1, 0>
}

#declare Handle = difference {
	cylinder { <0, -0.2, 0>, <0, 0.2, 0>, 1.5
		scale <1, 0.75, 0.25>
	}
	cylinder { <0, -1, 0>, <0, 1, 0>, 1.25
		scale <1, 0.75, 0.25>
	}
	pigment { colour rgb <0.75, 0.75, 0.75> }
}	

// far table
union {
	// top (sticks out from body a bit)
	box { <8, 17, 53>, <50, 18, 75> }
	// body and drawers
	difference {
		box { <9, 0, 54>, <49, 18, 74> }
		box { <21, -1, 53>, <37, 16, 75> }
		box { <11, -1, 53>, <47, 4, 75> }
	}
	// drawer handles (left)
	object { Handle
		translate <16, 15, 54>
	}
	object { Handle
		translate <16, 11, 54>
	}
	object { Handle
		translate <16, 7, 54>
	}
	// drawer handles (right)
	object { Handle
		translate <42, 15, 54>
	}
	object { Handle
		translate <42, 11, 54>
	}
	texture { T_Wood25_PC2
		scale 25
		rotate y*90
	}
	finish { diffuse 0.8 }
}

// computer
difference {
	// body
	box { <43, 18, 62>, <48, 28, 72> }
	// cut out an interior section
	box { <43.05, 18.05, 62.05>, <47.95, 27.95, 65>
		pigment { colour Black }
	}
	// air holes
	#declare i = 43.9;
	#declare scale_factor = 1;
	#while ( i <= 47.1 )
		#declare j = 18.9;
		#while ( j < 25 )
			#declare stagger_i = 0.2*( floor( (j-18.9)/0.8 ) = (j-18.9)/0.8 );
			cylinder { <i + stagger_i, j, 61>, <i + stagger_i, j, 62.02 + 0.1*scale_factor>, 0.025 + 0.05*scale_factor }
			#declare j = j + 0.4;
		#end
		#declare i = i + 0.4;
		#declare scale_factor = scale_factor - 0.125;
	#end
	pigment { colour White }
}
	
// monitor
union {
	difference {
		union {
			cylinder { <30, 18, 67>, <30, 18.5, 67>, 4 }
			box { <25, 18.5, 62>, <35, 28, 72> }
		}
		// cutout for screen
		box { <26, 20, 61>, <34, 27, 62.5>
			pigment { colour Black }
			finish {
				reflection 0.1
			}
		}
		// cutout for controls and LED (last)
		cylinder { <30, 18.8, 61>, <30, 18.8, 62.3>, 0.5 }
		cylinder { <29, 18.8, 61>, <29, 18.8, 62.1>, 0.15 }
		cylinder { <31, 18.8, 61>, <31, 18.8, 62.1>, 0.15 }
		sphere { <0, 0, 0>, 1
			scale <0.05, 0.05, 0.025>
			translate <31.75, 18.8, 62>
		}
	}
	// controls
	cylinder { <30, 18.8, 61.9>, <30, 18.8, 62.3>, 0.45 }
	sphere { <0, 0, 0>, 1
		scale <0.14, 0.14, 0.12>
		translate <29, 18.8, 62.1>
	}
	sphere { <0, 0, 0>, 1
		scale <0.14, 0.14, 0.12>
		translate <31, 18.8, 62.1>
	}
	// LED light_source
	light_source {
		<31.75, 18.8, 62.0125>
		colour <1, 0.8, 0.5>
		fade_distance 0.05
		fade_power 2
	}
	// LED
	sphere { <31.75, 18.8, 62.25>, 0.025
		no_shadow
		pigment { colour rgb <3, 2.5, 1.5> }
	}
	// logo
	object { Povray_Logo_Prism
		scale 0.5
		pigment { colour Black }
		translate <33, 19.25, 61.9>
	}
	text { ttf "ariblk.ttf", "POV-Ray", 0.1, 0
		scale <0.5, 0.5, 1>
		pigment { colour Black }
		translate <26, 19.25, 62>
	}	
	pigment { colour White }
}
// keyboard
union {
	box { <24, 17, 57>, <35, 18.5, 60> }  // extends below table for rotation
	// keys
	box { <24.44, 18.5, 57.44>, <31.04, 18.7, 59.64> }  // main section
	box { <31.26, 18.5, 57.44>, <32.58, 18.7, 57.88> }  // arrows
	box { <31.70, 18.5, 57.88>, <32.14, 18.7, 58.32> }
	box { <31.26, 18.5, 58.76>, <32.58, 18.7, 59.64> }  // home, end, etc.
	box { <32.80, 18.5, 57.44>, <34.56, 18.7, 59.64> }  // num pad
	translate <0, -18, -57>  // move bottom near to origin for rotation
	rotate x*-5
	translate <0, 17.9, 57>
	pigment { colour White }
}
// wire
sphere_sweep {
	cubic_spline
	10,
	<29, 18.25, 58.5>, 0.075,
	<29, 18.25, 60>, 0.075,
	<30, 18.075, 61>, 0.075,
	<33, 18.075, 62>, 0.075,
	<36.5, 18.075, 66>, 0.075,
	<41, 18.075, 69>, 0.075, 
	<42, 18.075, 70.5>, 0.075,
	<44, 18.075, 73.5>, 0.075,
	<46, 18.075, 74>, 0.075,
	<47, 18.3, 73>, 0.075
	pigment { colour rgb <0.75, 0.75, 0.75> }
}
// mouse
sphere { <0, 0, 0>, 1
	scale <0.75, 0.75, 1.5>
	translate <38, 18, 59>
	pigment { colour White }
}
// wire
sphere_sweep {
	cubic_spline
	10,
	<38.375, 18.375, 59>, 0.075,
	<38.375, 18.375, 59.75>, 0.075,
	<38.5, 18.075, 64>, 0.075,
	<39, 18.075, 67>, 0.075,
	<40.2, 18.075, 69.5>, 0.075,
	<41.8, 18.075, 72>, 0.075,
	<42.9, 18.075, 73.5>, 0.075,
	<45, 18.075, 74>, 0.075,
	<45.5, 18.075, 74.5>, 0.075,
	<48, 18.2, 73>, 0.075
	pigment { colour rgb <0.75, 0.75, 0.75> }
}

// caps for chair posts
#declare cap = prism {
	linear_spline
	conic_sweep
	0.5, 1, 5
	<-0.5, -0.5>, <0.5, -0.5>, <0.5, 0.5>, <-0.5, 0.5>, <-0.5, -0.5>
	translate -y*1
	rotate x*180
	scale <1, 0.5, 1>
}

// chair
union {
	// base
	difference {
		box { <-5, 0, -5>, <5, 10, 5> }  // base
		box { <-4, -1, -5.1>, <4, 9, 5.1> }  // base chopped on x-axis
		box { <-5.1, -1, -4>, <5.1, 9, 4> }  // base chopped on z-axis
	}
	// base struts
	difference {
		box { <-4.7, 3.5, -4.7>, <4.7, 4.2, 4.7> }
		box { <-4.3, 2, -4.3>, <4.3, 5, 4.3> }
	}
	union {
		box { <-7.1, 3.5, -0.2>, <7.1, 4.2, 0.2> }
		box { <-0.2, 3.5, -7.1>, <0.2, 4.2, 7.1> }
		rotate y*45
	}
	// back posts
	difference {
		box { <-5, 10, -5>, <5, 20, -4> }  // back
		box { <-4, 10, -6>, <4, 21, -3> }  // back, cut out middle
	}
	object { cap translate <-4.5, 20, -4.5> }
	object { cap translate <4.5, 20, -4.5> }
	// curved section
	intersection {
		difference {
			cylinder { <0, 13, 1.5>, <0, 19, 1.5>, 7.6 }
			cylinder { <0, 12, 1.5>, <0, 20, 1.5>, 7.1 }
			cylinder { <0, 14, 1.5>, <0, 16, 1.5>, 8 }
		}
		box { <-5, 13, -7>, <5, 20, -4> }
	}
	rotate -y*35
	translate <32, 0, 45>
	texture { T_Wood30 }
}
// book
object { Book
	scale 0.8
	rotate -y*20
	translate <19, 18, 63>
}

//----- Near Table and Objects -----//
union {
	// table
	box { <-20, 0, -50>, <20, 18, -20>
		texture { T_Wood25_PC1
			scale 25
			rotate y*90
		}
		finish { diffuse 0.8 }
	}
	object { Case
		rotate -y*30
		translate <2.5, 18.5, -37.5>
	}
}
