#declare glass_mat =
material {
    texture {
        pigment {color rgbt 1}
        finish {
            reflection {
                1
                fresnel
            }
            conserve_energy
            specular 0.125
            roughness 0.0035
        }
    }
    interior {ior 1.43}
}

#declare light_metal_mat =
material {
    texture {
        pigment {color rgb 0.925}
        finish {
            metallic
            diffuse 0.5
            brilliance 4.5
            specular 0.85
            roughness 0.1
            reflection {
                fresnel
                metallic
            }
        }
    }
    interior {ior 8.5}
}

#declare lamp_sphere_radius = 0.085;
#declare lamp_glass_thickness = 0.0012;
#declare lamp_wire_thickness = 0.004;
#declare lamp_lower_part_height = 0.065;
#declare lamp_upper_part_height = 0.03;
#declare lamp_handle_thickness = 0.0065;
#declare lamp_handle_add_length = 0.0375;

#declare lamp =
union {
    union {
        difference {
            cylinder {0, lamp_lower_part_height*y, 1.3*lamp_sphere_radius}
            torus {
                1.3*lamp_sphere_radius, 0.15*lamp_sphere_radius
                scale <1, 0.4*lamp_lower_part_height/(0.15*lamp_sphere_radius), 1>
                translate 0.5*lamp_lower_part_height*y
            }
        }
        cylinder {lamp_lower_part_height*y, (lamp_lower_part_height+2*lamp_sphere_radius)*y, 0.09*lamp_sphere_radius  translate 1.1*lamp_sphere_radius*x}
        cylinder {lamp_lower_part_height*y, (lamp_lower_part_height+2*lamp_sphere_radius)*y, 0.09*lamp_sphere_radius  translate -1.1*lamp_sphere_radius*x}
        cylinder {(lamp_lower_part_height+2*lamp_sphere_radius)*y, (lamp_lower_part_height+2*lamp_sphere_radius+lamp_upper_part_height)*y, 1.3*lamp_sphere_radius}
        difference {
            sphere {0, 1.1*lamp_sphere_radius  scale <1, 0.75, 1>}
            box {-1.2*lamp_sphere_radius, <1.2*lamp_sphere_radius, 0, 1.2*lamp_sphere_radius>}
            translate (lamp_lower_part_height+2*lamp_sphere_radius+lamp_upper_part_height)*y
        }
        union {
            difference {
                torus {1.1*lamp_sphere_radius+lamp_handle_thickness/2, lamp_handle_thickness/2  rotate 90*x}
                box {-1.2*lamp_sphere_radius, <1.4*lamp_sphere_radius, 0, 1.4*lamp_sphere_radius>}
                translate lamp_handle_add_length*y
            }
            cylinder {-(1.1*lamp_sphere_radius+lamp_handle_thickness/2)*x, <-(1.1*lamp_sphere_radius+lamp_handle_thickness/2), lamp_handle_add_length, 0>, lamp_handle_thickness/2}
            cylinder {(1.1*lamp_sphere_radius+lamp_handle_thickness/2)*x, <1.1*lamp_sphere_radius+lamp_handle_thickness/2, lamp_handle_add_length, 0>, lamp_handle_thickness/2}
            sphere {-(1.1*lamp_sphere_radius+lamp_handle_thickness/2)*x, lamp_handle_thickness/2}
            sphere {(1.1*lamp_sphere_radius+lamp_handle_thickness/2)*x, lamp_handle_thickness/2}
            cylinder {-(1.1*lamp_sphere_radius+lamp_handle_thickness/2)*x, (1.1*lamp_sphere_radius+lamp_handle_thickness/2)*x, lamp_handle_thickness/2}
            rotate 10*x
            translate (lamp_lower_part_height+2*lamp_sphere_radius+lamp_upper_part_height+0.75*lamp_handle_thickness)*y
        }
        union {
            cylinder {0, 0.25*lamp_sphere_radius*y, 0.09*lamp_sphere_radius}
            cone {0.25*lamp_sphere_radius*y, 0.09*lamp_sphere_radius, 0.375*lamp_sphere_radius*y, 0.12*lamp_sphere_radius}
            cone {0.375*lamp_sphere_radius*y, 0.12*lamp_sphere_radius, 0.6*lamp_sphere_radius*y, 0.085*lamp_sphere_radius}
            translate lamp_lower_part_height*y
        }
        material {light_metal_mat}
    }
    union {
        difference {
            sphere {0, lamp_sphere_radius}
            sphere {0, lamp_sphere_radius-lamp_glass_thickness}
            material {glass_mat}
            no_shadow
        }
        union {
            torus {lamp_sphere_radius+lamp_wire_thickness/2, lamp_wire_thickness/2  rotate 45*z}
            torus {lamp_sphere_radius+lamp_wire_thickness, lamp_wire_thickness/2  rotate -45*z}
            material {light_metal_mat}
        }
        translate (lamp_sphere_radius+lamp_lower_part_height)*y
    }
    union {
        sphere {0, 1
            hollow
            pigment {color rgbt 1}
            interior {
                media {
                    method 3
                    intervals 1
                    samples 3, 5
                    emission 18
                    density {
                        spherical
                        density_map {
                            [0  color rgb 0]
                            [1
                                bozo
                                scale <1, 2.5, 1>*0.35
                                color_map {
                                    [0     color blue_light_color*0.3+1.5]
                                    [0.5   color rgb z]
                                    [0.85  color rgb 0]
                                    [1     color rgb 0]
                                }
                            ]
                        }
                    }
                }
            }
        }
        light_source {
            0.001  color rgb <0.27, 0.32, 1>*1.3
            fade_power 2
            fade_distance 1.5
        }
        scale 0.8*(lamp_sphere_radius-lamp_glass_thickness)
        translate (lamp_sphere_radius+lamp_lower_part_height)*y
    }
    rotate 2.3*y
    rotate 90*x
    rotate -22.5*y
    translate (stones_hole_depth+stone_height*1.5+1.35*lamp_sphere_radius)*y
}
