camera {
    spherical
    location 0
    look_at z
}

plane {y, -0.01
    pigment {color rgb 0}
}

difference {
    sphere {0, 1}
    sphere {0, 0.85}
    hollow
    pigment {color rgbt 1}
    finish {ambient 1  diffuse 0}
    interior {
        media {
            method 3
            intervals 1
            samples 7, 12
            scattering {
                2
                color rgb 1.5
                extinction 0.45
            }
            density {
                wrinkles
                turbulence 0.5
                omega 0.6
                lambda 1.7
                scale <0.6, 0.125, 0.6>*0.4
                color_map {
                    [0    color rgb 0]
                    [0.6  color rgb 0]
                    [0.7  color rgb 0.5]
                    [1    color rgb 0.5]
                }
            }
        }
    }
}

background {color rgb <0.15, 0.15, 0.25>*1.25}

light_source {1000*z  color rgb 1  rotate -63.5*x}

fog {
    fog_type 2
    distance 630
    color rgb <0.8, 0.7, 0.75>  transmit 0.3
    fog_offset 1.2*70
    fog_alt 0.12
}

