#ifndef (grass_texture)
    #local grass_texture =
    texture {
        pigment {color rgb <0.01, 0.85, 0.03>}
        finish {specular 0.65  roughness 0.04}
    }
#end

#local Z0 = seed (82);

#macro grass_blade ()
    #ifndef (grass_blade_acc)  #local grass_blade_acc = 10;  #end
    #ifndef (grass_blade_radius)  #local grass_blade_radius = 0.025;  #end
    #ifndef (grass_blades_spread)  #local grass_blades_spread = 0.25;  #end    
    #local grass_blade_scale = 0.5+0.5*rand (Z0);
    #local grass_blade_translate = grass_blades_spread*rand (Z0)*x;
    #local grass_blade_rotate_z = -45*rand (Z0);
    #local grass_blade_rotate_y = 360*rand (Z0);
    #local I = 0;
    #local I_c = grass_blade_acc;
    #while (I < I_c)
        #local P1 = vrotate (vrotate (<I/I_c*(1+sin (-pi/2+I/I_c*pi/2)), I/I_c, 0>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P2 = vrotate (vrotate (<-0.5*grass_blade_radius+(1+0.5*grass_blade_radius)*I/I_c*(1+sin (-pi/2+I/I_c*pi/2)), I/I_c, (1-I/I_c)*grass_blade_radius+0.0001>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P3 = vrotate (vrotate (<(I+1)/I_c*(1+sin (-pi/2+(I+1)/I_c*pi/2)), (I+1)/I_c, 0>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P4 = vrotate (vrotate (<-0.5*grass_blade_radius+(1+0.5*grass_blade_radius)*(I+1)/I_c*(1+sin (-pi/2+(I+1)/I_c*pi/2)), (I+1)/I_c, (1-(I+1)/I_c)*grass_blade_radius+0.0001>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P1a = vrotate (vrotate (<0.5*grass_blade_radius+(1-0.5*grass_blade_radius)*I/I_c*(1+sin (-pi/2+I/I_c*pi/2)), I/I_c, -(1-I/I_c)*grass_blade_radius-0.0001>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P1b = vrotate (vrotate (<(I-1)/I_c*(1+sin (-pi/2+(I-1)/I_c*pi/2)), (I-1)/I_c, 0>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P2a = vrotate (vrotate (<-0.5*grass_blade_radius+(1+0.5*grass_blade_radius)*(I-1)/I_c*(1+sin (-pi/2+(I-1)/I_c*pi/2)), (I-1)/I_c, (1-(I-1)/I_c)*grass_blade_radius+0.0001>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P2b = vrotate (vrotate (<I/I_c*(1+sin (-pi/2+I/I_c*pi/2)), I/I_c, (2-2*I/I_c)*grass_blade_radius+0.0002>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P3a = vrotate (vrotate (<(I+2)/I_c*(1+sin (-pi/2+(I+2)/I_c*pi/2)), (I+2)/I_c, 0>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P3b = vrotate (vrotate (<0.5*grass_blade_radius+(1-0.5*grass_blade_radius)*(I+1)/I_c*(1+sin (-pi/2+(I+1)/I_c*pi/2)), (I+1)/I_c, -(1-(I+1)/I_c)*grass_blade_radius-0.0001>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P4a = vrotate (vrotate (<(I+1)/I_c*(1+sin (-pi/2+(I+1)/I_c*pi/2)), (I+1)/I_c, (2-2*(I+1)/I_c)*grass_blade_radius+0.0002>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local P4b = vrotate (vrotate (<-0.5*grass_blade_radius+(1+0.5*grass_blade_radius)*(I+2)/I_c*(1+sin (-pi/2+(I+2)/I_c*pi/2)), (I+2)/I_c, (1-(I+2)/I_c)*grass_blade_radius+0.0001>, grass_blade_rotate_z*z)*grass_blade_scale+grass_blade_translate, grass_blade_rotate_y*y);
        #local N1 = vcross (P1a-P1, P1b-P1)+vcross (P1b-P1, P2-P1)+vcross (P2-P1, P3-P1)+vcross (P3-P1, P1a-P1);
        #local N2 = vcross (P2a-P2, P2b-P2)+vcross (P2b-P2, P4-P2)+vcross (P4-P2, P1-P2)+vcross (P1-P2, P2a-P2);
        #local N3 = vcross (P3a-P3, P3b-P3)+vcross (P3b-P3, P1-P3)+vcross (P1-P3, P4-P3)+vcross (P4-P3, P3a-P3);
        #local N4 = vcross (P4a-P4, P4b-P4)+vcross (P4b-P4, P3-P4)+vcross (P3-P4, P2-P4)+vcross (P2-P4, P4a-P4);
        smooth_triangle {P1, N1, P2, N2, P3, N3}
        smooth_triangle {P4, N4, P3, N3, P2, N2}
        smooth_triangle {P1*<1, 1, -1>, N1*<1, 1, -1>, P2*<1, 1, -1>, N2*<1, 1, -1>, P3*<1, 1, -1>, N3*<1, 1, -1>}
        smooth_triangle {P4*<1, 1, -1>, N4*<1, 1, -1>, P3*<1, 1, -1>, N3*<1, 1, -1>, P2*<1, 1, -1>, N2*<1, 1, -1>}
        #local I = I+1;
    #end
#end

#declare grass_blades =
mesh {
    #ifndef (grass_blades_count)  #local grass_blades_count = 25;  #end
    #local I = 0;
    #local I_c = grass_blades_count;
    #while (I < I_c)
        grass_blade ()
        #local I = I+1;
    #end
    texture {grass_texture}
}
