#version unofficial MegaPov 1.0;

#default {finish {ambient 0.125  diffuse 0.725}}

#global_settings {
    exposure 0.6  exposure_gain 1.5
    max_trace_level 8
}

camera {
    location <-0.25*1.1, 3*1.15, -0.95*1.05>
    look_at <0.05, 0.65, 0>
    angle 44
}

#declare stone_length = 0.265;
#declare stone_length_turb = 0.085;
#declare stone_width = 0.2;
#declare stone_height = 0.2;
#declare stone_edge_sharpness = 0.75;
#declare stones_i_radius = 0.5;
#declare stones_hole_depth = -2.955;
#declare stone_objs = 20;
#declare stone_objs_arr = array [stone_objs]

#declare main_light_location = <-450, 680, -203>;
#declare main_light_color = color rgb <0.7, 0.71, 0.835>*0.485;

light_source {main_light_location  color main_light_color*0.865}

#declare stone_surface_f =
function {
    pigment {
        wrinkles
        color_map {[0  color rgb -1]  [1  color rgb 1]}
    }
}

#declare stone_break_f =
function {
    pigment {
        wrinkles
        scale 1.35
        color_map {[0  color rgb -1]  [1  color rgb 1]}
    }
}

#declare grass_between_stones_c = 0;
#declare grass_between_stones_angles_arr = array [20] [2]

#include "functions.inc"

#declare Z5 = seed (90);

#declare I = 0;
#while (I < stone_objs)
    #declare noise3d_translate_x = 10*rand (Z5);
    #declare noise3d_translate_y = 10*rand (Z5);
    #declare noise3d_translate_z = 10*rand (Z5);
    #declare stone_objs_arr [I] =
    isosurface {
        function {
            (abs (pow (x, 1+1/(1-stone_edge_sharpness)))+
            abs (pow (y, 1+1/(1-stone_edge_sharpness)))+
            abs (pow (z, 1+1/(1-stone_edge_sharpness))))-
            f_noise3d (1.35*x+noise3d_translate_x, 1.35*y+noise3d_translate_y, 1.35*z+noise3d_translate_z)-
            stone_surface_f (x-noise3d_translate_x, y-noise3d_translate_y, z-noise3d_translate_z).gray*0.825}
        contained_by {box {-1.5, 1.5}}
        threshold 1
        evaluate 7.5, 1.85, 0.975
        max_trace 2
    }
    #declare I = I+1;
#end

#declare Z0 = seed (12);
#declare Z1 = seed (55);
#declare Z2 = seed (37);
#declare Z4 = seed (72);

#declare stone_circles=
union {
    #declare break_plane =
    isosurface {
        function {z+stone_break_f (x, y, 0).gray*0.3}
        contained_by {sphere {0, 2.5}}
        threshold 0
        evaluate 5, 1.2, 0.95
        all_intersections
    }
    #declare break_plane2 =
    isosurface {
        function {-z-stone_break_f (x, y, 0).gray*0.3}
        contained_by {sphere {0, 2.5}}
        threshold 0
        evaluate 5, 1.2, 0.95
        all_intersections
    }

    #declare unperturbed_angle = degrees (acos ((2*pow (stones_i_radius, 2)-pow (stone_length, 2))/(2*pow (stones_i_radius, 2))));
    #declare stones_y_trans = 0;
    #while (stones_y_trans > stones_hole_depth)
        #declare angle_1 = 0;
        #while (angle_1 < 360)
            #if (360-angle_1 < unperturbed_angle)
                #declare c_stone_length = sqrt (2*pow (stones_i_radius, 2)-2*pow (stones_i_radius, 2)*cos (radians (360-angle_1)));
            #else
                #declare c_stone_length = stone_length-stone_length_turb+2*stone_length_turb*rand (Z1);
            #end
            #declare angle_2 = degrees (acos ((2*pow (stones_i_radius, 2)-pow (c_stone_length, 2))/(2*pow (stones_i_radius, 2))));
            object {
                #declare stone_broken = 11*rand (Z0);
                #if (stone_broken > 1)
                    stone_objs_arr [floor (20*rand (Z1))]
                #else
                    #declare stone_to_break =
                    object {stone_objs_arr [floor (20*rand (Z1))]}
                    #declare break_plane_rotate_z0 = 360*rand (Z4);
                    #declare break_plane_rotate_y = 37*rand (Z4);
                    #declare break_plane_rotate_z = 360*rand (Z4);
                    #declare break_plane_translate = (-0.75+1.5*rand (Z4))*z;
                    union {
                        intersection {
                            object {stone_to_break}
                            object {break_plane
                                translate (-0.017-0.0025*rand (Z4))*z
                                rotate break_plane_rotate_z0*z
                                rotate break_plane_rotate_y*y
                                rotate break_plane_rotate_z*z
                                translate break_plane_translate
                            }
                        }
                        intersection {
                            object {stone_to_break}
                            object {break_plane2
                                translate (0.017+0.0025*rand (Z4))*z
                                rotate break_plane_rotate_z0*z
                                rotate break_plane_rotate_y*y
                                rotate break_plane_rotate_z*z
                                translate break_plane_translate
                            }
                        }
                    }
                #end
                translate <1, -1, -1>
                scale 0.5*<stone_width, stone_height, 0.9*c_stone_length>
                rotate (90-(180-angle_2)/2)*y
                translate stones_i_radius*x
                rotate (angle_1+unperturbed_angle*(0.5*(-stones_y_trans/stone_height)-1/7+1/7*rand (Z2)))*y
                translate stones_y_trans*y
                #if (stones_y_trans = 0)
                    #declare grass_between_stones_angles_arr [grass_between_stones_c] [0] = angle_2;
                    #declare grass_between_stones_angles_arr [grass_between_stones_c] [1] = angle_1;
                    #declare grass_between_stones_c = grass_between_stones_c+1;
                #end
            }
            #declare angle_1 = angle_1+angle_2;
        #end
        #declare stones_y_trans = stones_y_trans-stone_height;
    #end
}

#declare granite_tex_brightness = 2.37;
#declare granite_tex =
texture {
    pigment {
        average
        pigment_map {
            [1
                granite
                scale 0.08
                color_map {
                    [0   color rgb <0.7, 0.7, 0.7>*granite_tex_brightness]
                    [0.4 color rgb <0.7, 0.7, 0.69>*0.7*granite_tex_brightness]
                    [0.7 color rgb <0.69, 0.665, 0.665>*0.65*granite_tex_brightness]
                    [1   color rgb <0.688, 0.66, 0.68>*0.675*granite_tex_brightness]
                }
            ]
            [0.3
                crackle
                scale 0.05
                color_map {
                    [0   color rgb <0.7, 0.7, 0.7>*granite_tex_brightness]
                    [0.4 color rgb <0.7, 0.7, 0.7>*0.7*granite_tex_brightness]
                    [0.7 color rgb <0.7, 0.665, 0.665>*0.65*granite_tex_brightness]
                    [1   color rgb <0.7, 0.66, 0.68>*0.675*granite_tex_brightness]
                }
            ]            
        }
        turbulence 0.085
        omega 0.8
    }
    finish {
        specular 0.775
        roughness 0.000475
        diffuse 0.57
        brilliance 0.8
    }
    normal {
        average
        normal_map {
            [1  granite 1.7  scale 0.08]
            [4  crackle 1.175   scale 0.05]
        }
        turbulence 0.085
        omega 0.8
    }
    scale 0.15
}

#declare soil_between_stones =
union {
    torus {stones_i_radius+stone_width*0.5, 0.3*stone_width
        scale <1, 0.65, 1>
        translate -stone_height*(0.5-0.1)*y
    }
    difference {
        cylinder {-stone_height*(0.5-0.1)*y, stones_hole_depth*y, stones_i_radius+stone_width*(0.5+0.3)}
        cylinder {0, (stones_hole_depth-1)*y, stones_i_radius+stone_width*(0.5-0.3)}
    }
}

#declare soil_tex_brightness = 1.2;
#declare soil_tex =
texture {
    pigment {
        bozo
        scale 0.03
        color_map {
            [0    color rgb <0.32, 0.25, 0.03>*soil_tex_brightness]
            [0.6  color rgb <0.32, 0.25, 0.03>*1.1*soil_tex_brightness]
            [1    color rgb <0.32, 0.25, 0.03>*0.65*soil_tex_brightness]
        }
    }
    normal {wrinkles 0.75  scale 0.1  turbulence 0.3  omega 0.8}
}

#declare water_fin =
finish {
    reflection {0.425, 0.5}
    conserve_energy
    specular 0.5
    roughness 0.03
}

#declare water_fin2 =
finish {
    reflection {0.425*0.7, 0.5*0.7}
    specular 0.5*0.7
    roughness 0.03
}

#declare soil_bottom_mat =
material {
    texture {
        pigment {
            bozo
            scale 0.03
            color_map {
                [0    color rgb <0.32, 0.25, 0.03>*soil_tex_brightness]
                [0.6  color rgb <0.32, 0.25, 0.03>*1.1*soil_tex_brightness]
                [1    color rgb <0.32, 0.25, 0.03>*0.65*soil_tex_brightness]
            }
        }
        finish {water_fin2}
        normal {wrinkles 0.75  scale 0.1  turbulence 0.3  omega 0.8}
    }
    interior {ior 1.33}
}

#declare grass_texture =
texture {
    pigment {color rgb <0.04, 0.575, 0.1>*1.5}
    finish {specular 0.55  roughness 0.037}
}

#declare grass_blade_radius = 0.036;
#declare grass_blades_count = 25;
#include "grass.inc"

#declare Z5 = seed (38);
#declare Z6 = seed (19);

#declare I = 0;
#declare I_c = grass_between_stones_c;
#declare grass_between_stones =
union {
    #while (I < I_c)
        #declare II = 0;
        #declare II_c = 3+floor (3*rand (Z6));
        #while (II < II_c)
            object {grass_blades
                scale <0, 0.07+0.075*rand (Z5), 0>+0.122+0.051*rand (Z5)
                rotate 360*rand (Z5)*y
                translate stone_width*0.3*0.65*y
                rotate (40-130*II/II_c)*z
                translate stone_width/2*x
                rotate -(90-(180-grass_between_stones_angles_arr [I] [0])/2)*y
                translate stones_i_radius*x-stone_height*(0.5-0.1)*y
                rotate (-1.3+2.6*rand (Z5))*y
                scale <1, 1, 0.25+0.75*II/II_c>
                #switch (I)
                    #case (0) rotate -y #break
                    #case (1) rotate -2*y #break
                    #case (6) rotate -y #break
                    #case (7) rotate -3*y #break
                    #case (8) rotate -4*y #break
                    #case (9) rotate -y #break
                    #case (11) rotate -2*y #break
                #end
                rotate grass_between_stones_angles_arr [I] [1]*y
            }
            #declare II = II+1;
        #end
        #declare I = I+1;
    #end
}

#declare soil_bottom_f =
function {
    pigment {
        bumps
        scale 0.5
        color_map {[0  color rgb -1] [1  color rgb 1]}
    }
}

#declare soil_bottom =
isosurface {
    function {y+soil_bottom_f (x, 0, z).gray*0.1}
    contained_by {sphere {0, stones_i_radius+stone_width}}
    threshold 0
    evaluate 5, 1.25, 0.95
    rotate 100*y
    translate (stones_hole_depth+stone_height*1.5)*y
}

#declare bottom_water =
box {-stones_i_radius-stone_width, (stones_i_radius+stone_width)*(x+z)  translate (stones_hole_depth+stone_height*1.5)*y}

#declare water_mat =
material {
    texture {
        pigment {color rgb 0  transmit 1}
        finish {water_fin}
        normal {ripples 0.06  frequency 5}
    }
    interior {ior 1.33}
}

#declare lawn_fog =
difference {
    box {<-3, -0.5, -3>, <3, -0.1, 3>}
    cylinder {(stones_hole_depth-1)*y, y, stones_i_radius+stone_width/2+0.001}
    hollow
    pigment {color rgbt 1}
    interior {
        media {
            method 3
            intervals 1
            samples 2, 5
            scattering {
                1
                color rgb 3.4
                extinction 0.2
            }
            density {
                wrinkles
                turbulence 0.5
                omega 0.4
                lambda 4
                scale <1, 2, 1>*1.5
                color_map {
                    [0     color rgb 0.03]
                    [0.7   color rgb 0.45]
                    [0.85  color rgb 0.75]
                    [1     color rgb 0.4]
                }
            }
        }
    }
}

#declare Z7 = seed (80);
#declare Z9 = seed (8);

#declare lawn_alt = -0.6;
#declare lawn_radius = 3;
#declare lawn_grass_density = 115;
#declare lawn = 
union {
    #declare I = 0;
    #declare I_c = lawn_grass_density;
    #while (I < I_c)
        #declare II = 0;
        #declare II_c = lawn_grass_density;
        #while (II < II_c)
            #declare put_grass = <-lawn_radius+2*lawn_radius*I/I_c, 0, -lawn_radius+2*lawn_radius*II/II_c>+2*lawn_radius*<(-0.5+rand (Z7))/I_c, 0, (-0.5+rand (Z7))/II_c>;
            #if (sqrt (pow (put_grass.x, 2)+pow (put_grass.z, 2)) > stones_i_radius+stone_width*3/4)
                #declare grass_rand = sqrt (pow (put_grass.x, 2)+pow (put_grass.z, 2))*rand (Z9);
                #if (grass_rand > 1)
                    object {grass_blades
                        rotate 360*rand (Z7)*y
                        scale 1.25*(<0, 0.045+0.22*rand (Z7), 0>+0.1+0.05*rand (Z7))
                        translate put_grass
                    }
                #end
            #end
            #declare II = II+1;
        #end
        #declare I = I+1;
    #end
    translate lawn_alt*y
}

#declare lawn_soil =
difference {
    union {
        plane {y, 0}
        difference {
            cylinder {0, 0.2*y, stones_i_radius+stone_width*1.5}
            torus {stones_i_radius+stone_width*1.5, stone_width  scale <1, 1/stone_width*0.2, 1>  translate 0.2*y}
        }
    }
    cylinder {(stones_hole_depth-1)*y, y, stones_i_radius+stone_width/2}
    translate lawn_alt*y
}

#declare grain_density = 0.8;
#declare grain_tex_brightness = 1.35;
#declare grain_tex0 =
texture {
    pigment {
        crackle solid
        color_map {
            [0     color rgb 0.7*grain_tex_brightness]
            [0.25  color rgb <0.6, 0.6, 0.7>*0.7*grain_tex_brightness]
            [0.4   color rgb 1*grain_tex_brightness]
            [0.5   color rgb <0.7, 0.6, 0.6>*0.6*grain_tex_brightness]
            [0.6   color rgb 1*grain_tex_brightness]
            [0.75  color rgb <0.7, 0.7, 0.6>*0.7*grain_tex_brightness]
            [1     color rgb 1*grain_tex_brightness]
        }
    }
    finish {
        specular 0.55
        roughness 0.000475
        diffuse 0.57
        brilliance 0.8
    }
    normal {
        crackle 3 form <-1, 1.0, 0.4>
    }
}

#declare Z8 = seed (49);

#declare grain_tex =
texture {
    crackle form <-1, 1, 0.4>
    texture_map {
        [0
            crackle form <-1, 1, 0.4>
            #declare grain_translate = 10*<rand (Z8), rand (Z8), rand (Z8)>;
            #declare grain_translate2 = 10*<rand (Z8), rand (Z8), rand (Z8)>;
            translate grain_translate
            texture_map {
                [0
                    crackle form <-1, 1, 0.4>
                    translate grain_translate2
                    texture_map {
                        [0                soil_tex]
                        [1-grain_density  soil_tex]
                        [1-grain_density  grain_tex0]
                        [1                grain_tex0]
                    }
                ]
                [1-grain_density
                    crackle form <-1, 1, 0.4>
                    translate grain_translate2
                    texture_map {
                        [0                soil_tex]
                        [1-grain_density  soil_tex]
                        [1-grain_density  grain_tex0]
                        [1                grain_tex0]
                    }
                ]
                [1-grain_density  grain_tex0]
                [1                grain_tex0]
            }
        ]
        [1-grain_density
            crackle form <-1, 1, 0.4>
            translate grain_translate
            texture_map {
                [0
                    crackle form <-1, 1, 0.4>
                    translate grain_translate2
                    texture_map {
                        [0                soil_tex]
                        [1-grain_density  soil_tex]
                        [1-grain_density  grain_tex0]
                        [1                grain_tex0]
                    }
                ]
                [1-grain_density
                    crackle form <-1, 1, 0.4>
                    translate grain_translate2
                    texture_map {
                        [0                soil_tex]
                        [1-grain_density  soil_tex]
                        [1-grain_density  grain_tex0]
                        [1                grain_tex0]
                    }
                ]
                [1-grain_density  grain_tex0]
                [1                grain_tex0]
            }
        ]
        [1-grain_density  grain_tex0]
        [1                grain_tex0]
    }
    scale 0.2*0.1
    turbulence 0.5
    omega 0.3
    lambda 0.4
}

#declare lawn_pattern =
pigment {
    onion
    scale 10
    color_map {
        [0  color rgb 0]
        [(stones_i_radius+stone_width/2)/10  color rgb 0]
        [1.125*(stones_i_radius+stone_width/2)/10  color rgb 0]
        [2.175*(stones_i_radius+stone_width/2)/10  color rgb 1]
        [1  color rgb 1]
    }
    turbulence 0.02
    omega 0.92
    lambda 2.45
    rotate -60*z
    translate lawn_alt*y
}

#declare lawn_soil_tex =
texture {
    pigment_pattern {lawn_pattern}
    texture_map {
        [0  grain_tex]
        [1  soil_tex]
    }
}

#declare soil_tex2 =
texture {
    average
    texture_map {
        [1  grain_tex]
        [1  soil_tex]
    }
}

object {stone_circles  texture {granite_tex}}
object {soil_between_stones  texture {soil_tex2}}
object {grass_between_stones}
object {soil_bottom  material {soil_bottom_mat}}
object {bottom_water  material {water_mat  translate (stones_hole_depth+stone_height)*y}}
object {lawn_fog}
object {lawn}
object {lawn_soil  texture {lawn_soil_tex}}

#declare blue_light_color = color rgb <0.21, 0.27, 1>*1.25;

#include "wdn_prts.inc"
#include "bucket.inc"
#include "b_light.inc"

light_group {
    object {wooden_parts}
    object {rope}
    object {bucket}
    light_source {-main_light_location  color main_light_color*0.225  shadowless}
    global_lights on
}

light_group {
    object {lamp}
    light_source {<0.1, 3, 0.1>  color rgb <0.52, 0.525, 0.575>  shadowless}
    global_lights on
}

sky_sphere {
    pigment {
        image_map {
            sys "clouds.bmp"  map_type 1  interpolate 2
        }
    }
}