#version 3.5;
#include "colors.inc"
#include "textures.inc"
#include "woods.inc" 
#include "stones.inc"

global_settings {assumed_gamma 1.33}
          

/*
camera{location<7.5,225,-15>
        look_at<7.5,225,0>
}
light_source{<7.5,225,-15> color White}
*/




#declare stair_x = 12;
#declare stair_y = 12;                                    
#declare step_x = stair_x*(1/stair_x);
#declare step_y = stair_y*(1/stair_y);                                    
#declare stair_width = 5;

#declare stair_length = sqrt(stair_x*stair_x + stair_y*stair_y);

#declare step01_cutter = 
box{
        <stair_width/2+1,0,0>,<-stair_width/2-1,step_y,step_x>
}

#declare stair01_cutter = 
merge{
        object{step01_cutter}
        cylinder{
                <stair_width/2+1,step_y*0.9,0>,
                <-stair_width/2-1,step_y*0.9,0>, step_y*0.1
        }
}

#declare step01 =
difference{
        merge{
                box{
                        <stair_width/2,0,0>,<-stair_width/2,step_y,step_x>
                }
                cylinder{
                        <stair_width/2,step_y*0.9,0>,
                        <-stair_width/2,step_y*0.9,0>, step_y*0.1
                }
        }
        object{step01_cutter
                translate<0,-step_y*(1/step_y),step_x*(1/step_x)>
        }
}

#declare side_boards =
difference{
        union{
                box{
                        <stair_width/2,0,0>,<stair_width/2+0.2,step_y*1.5,stair_length>
                }
                box{
                        <0.2-stair_width/2,0,0>,<-stair_width/2,step_y*1.5,stair_length>
                }
                rotate x*-45
        }
        box{
                <stair_width/2+1,-2*step_y,-2*step_x>,<-stair_width/2-1,3*step_y,0>
        }        
        box{
                <stair_width/2+1,stair_y-2*step_y,stair_x-step_x>,
                <-stair_width/2-1,stair_y+3*step_y,stair_x+2>
        }
        texture { brick texture {pigment {color Black}},
                        texture{pigment {P_WoodGrain17A color_map { M_Wood17A } scale 0.1}}                 
                        brick_size <0.8,0.5,10> mortar 0.025 rotate z*90
                        rotate x*-45
        }
}

#declare Rail =
difference{
         box{
                <stair_width/2,0,0>,<stair_width/2+0.4,step_y*0.5,stair_length>
                rotate x*-45
         }
        box{
                <stair_width/2+1,-2*step_y,-2*step_x>,<-stair_width/2-1,3*step_y,0>
        }        
        box{
                <stair_width/2+1,stair_y-2*step_y,stair_x-step_x>,
                <-stair_width/2-1,stair_y+3*step_y,stair_x+2>
        }
        texture{pigment {P_WoodGrain17A color_map { M_Wood17A } scale 0.01} rotate x*-45}
        translate y*5
}


#declare landing =
        box{
                <stair_width/2,0,0>,<-stair_width/2,step_y,stair_width>
                translate<0,stair_y,stair_x>
        }

#declare Stair01 = 
union{
        object{side_boards
                translate z*step_x
        }
        object{Rail
                translate z*step_x
        }
        #declare X=0;
        #declare Y=0;
        #while(X<stair_x)
        object{step01
                texture { brick texture {pigment {color Black}},
                                texture{pigment {P_WoodGrain17A color_map { M_Wood17A} scale 0.1}}                 
                                brick_size <0.8,0.5,10> mortar 0.025 rotate z*90
                                rotate y*90
                }
                translate<0,Y,X>
        }
        #declare X=X+step_x;
        #declare Y=Y+step_y;
        #end  
        
        object{landing
                texture { brick texture {pigment {color Black}},
                                texture{pigment {P_WoodGrain17A color_map { M_Wood17A } scale 0.1}}                 
                                brick_size <0.8,0.5,10> mortar 0.025 rotate z*90
                                 //rotate y*90
                }
        }
}

#declare Stair02 =
union{
        object{Stair01}
        object{Stair01
                rotate y*90
                translate<stair_width/2,stair_y,stair_x+stair_width/2>
        }
        object{Stair01
                rotate y*180
                translate<stair_x+stair_width,stair_y*2,stair_x>
        }
        object{Stair01
                rotate y*-90
                translate<stair_x+stair_width/2,stair_y*3,-stair_width/2>
        }
}

#declare TopFloor01 =
box{
        <stair_width/2,0,0>,<-stair_width/2,step_y,stair_x+stair_width>
        translate<0,stair_y*24,0>
        texture { brick texture {pigment {color Black}},
                        texture{pigment {P_WoodGrain17A color_map { M_Wood17A } scale 0.01}}                 
                        brick_size <0.8,0.5,10> mortar 0.025 rotate z*90
                         //rotate y*90
        }
}
#declare TopRail =
box{
        <stair_width/2,0,0>,<stair_width/2+0.4,step_y*0.5,stair_x>
        texture{pigment {P_WoodGrain17A color_map { M_Wood17A } scale 0.01} rotate z*90}       
                translate y*5
}


object{Stair02}
object{Stair02
        translate y*stair_y*4
}
object{Stair02
        translate y*stair_y*8
}
object{Stair02
        translate y*stair_y*12
}
object{Stair02
        translate y*stair_y*16
}
object{Stair02
        translate y*stair_y*20
}

object{TopFloor01} 
object{TopRail
        translate<0,stair_y*24,0>
}

object{TopFloor01
        rotate y*90
        translate<stair_width/2,0,stair_x+stair_width/2>
}
object{TopRail
        rotate y*90
        translate<stair_width/2,stair_y*24,stair_x+stair_width/2>
}

object{TopFloor01
        rotate y*180
        translate<stair_x+stair_width,0,stair_x>
}
object{TopRail
        rotate y*180
        translate<stair_x+stair_width,stair_y*24,stair_x>
}
object{TopRail
        rotate y*180
        translate<stair_x+stair_width,stair_y*24,stair_width>
}


#declare Post01 =

box{<0,0,0>,<1,stair_y*32,1>
         texture{pigment {P_WoodGrain17A color_map { M_Wood17A } scale 0.01} rotate <91,91,0>}
}

object{Post01
        translate <stair_width/2,0,0>
}
object{Post01
        translate <stair_width/2,0,stair_x-1>
}
object{Post01
        translate <stair_width/2+stair_x-1,0,stair_x-1>
}
object{Post01
        translate <stair_width/2+stair_x-1,0,0>
}


// The room
#declare building =
difference{
        box{
                <-1,-1,-1>,<stair_x+stair_width*2+1,stair_y*32+1,stair_x+stair_width*2+1>
        }

        box{
                <0,0,0>,<stair_x+stair_width*2,stair_y*32,stair_x+stair_width*2>
                hollow
        }
/// Cut out the windows
#declare window_y = 2;
#while(window_y <= 24)
        box{
                <-20,3,(stair_x+stair_width)/2+1.5>,
                <10,10,(stair_x+stair_width)/2+4.5>
                translate y*stair_y*window_y
        }
        cylinder{<-20,10,(stair_x+stair_width)/2+3>,
                <10,10,(stair_x+stair_width)/2+3>,1.5
                translate y*stair_y*window_y
        }

        box{
                <10,3,(stair_x+stair_width)/2+1.5>,
                <50,10,(stair_x+stair_width)/2+4.5>
                translate y*stair_y*window_y
                translate y*8
        }
        cylinder{<10,10,(stair_x+stair_width)/2+3>,
                <50,10,(stair_x+stair_width)/2+3>,1.5
                translate y*stair_y*window_y
                translate y*8
        }


        box{
                <(stair_x+stair_width)/2+1.5,3,-20>,
                <(stair_x+stair_width)/2+4.5,10,50>
                translate y*stair_y*window_y
        }
        cylinder{<(stair_x+stair_width)/2+3,10,-20>,
                <(stair_x+stair_width)/2+3,10,50>,1.5
                translate y*stair_y*window_y
        }
        
#declare window_y = window_y+4;        
#end        
///
        texture{T_Grnt14
                normal{bumps 0.2
                        scale 0.2}
        }
        translate <-stair_width/2,0,-stair_width>
}

object{building}

// The floor
box{
        <0,0,0>,<stair_x+stair_width*2,0.01,stair_x+stair_width*2>
        texture { brick texture {pigment {color Black}},
                        texture{pigment {P_WoodGrain17A color_map { M_Wood17A } scale 0.01}}                 
                        brick_size <0.8,0.5,10> mortar 0.025 rotate z*90
                         //rotate y*90
        }
        translate <-stair_width/2,0,-stair_width>
}

camera{location<stair_x/1.7,stair_y*24+4,stair_x/2-1.75>
        look_at<stair_x/1.7,0,stair_x/2-1.75>

}
//main light source
light_source{<stair_x/2,stair_y*24+24,stair_x/2-2> color Gold*0.5
}
//ambient light
light_source{<stair_x/2,stair_y*24+10,stair_x/2-2> color Gold*0.12
}

//ouside light
light_source{<-700,700,12> color White*0.25}

// "falling shadow maker"
 box{<-1.8,1.8,0> <1.8,-1.8,0.1>
          texture{
                      pigment
                      {
                          image_map
                          {
                            gif "falling.gif"
                            once
                            transmit 174, 1}
                          scale 2
                          translate <-2,-1.8,0>
                      }
          }
          scale 0.5
          rotate <90,0,0>
          translate<stair_x/1.8,stair_y*24+20,stair_x/2-1.5>       
  }

//The ground outside
 plane{<0,1,0>, -1 
        texture{
                pigment{color rgb<0.2,0.5,0.1>}
                normal{bumps 01 scale 0.5}
        }
        hollow
  }

