// Persistence of Vision Ray Tracer Scene Description File
// File: 2roses.pov
// Vers: 3.5
// Desc: IRTC 2003/07 Contest (Surrealism)
// Date: 2003/08/09 - 2003/08/31
// Auth: Slawomir Szczyrba

// +W576 +H768 +A0.3 +AM1 +J1.0
// +W576 +H768 +A0.2 +AM2 +J
// +W240 +H320 +K0.0  +KI0 +KF23 +KFI0 +KFF23 +KC +SC65 +EC120 +SR150 +ER285

#version 3.5;

#declare Radiosity=on;
#declare Photons=on;
#declare Test=off;

#include "2roses.inc"    

global_settings {
  assumed_gamma 1.0
  ambient_light .005
  max_trace_level 25
  #if (Radiosity)
    radiosity {
     Rad_Settings(RadMode, true, true) 
     brightness .5
    }
  #end
  #if (Photons)          // global photon block
    photons {
     spacing .005
     jitter 1.5
    }
  #end
}

camera {
  right x*image_width/image_height
  location  <1,.2,.5>*5.4*10
  look_at   <0,0,.1>*10
  angle 8
  translate y*.35*10
}

light_source { 0, rgb .2 translate <2.5,2.5,2.5>*20 shadowless}

#local GlassAngle=4.5;//clock*2;
union {
 object { wazon scale .2    rotate y*GlassAngle material { M_Glass  interior { fade_color <0.5,0.6,0.8> } }    photons { target reflection on refraction on }}
 object { woda  scale .1999 rotate y*GlassAngle material { M_MyWater } photons { target reflection on refraction on }}
 object { roza1 scale .085 rotate y*15 rotate <17,0,-17> translate <-.29,.21,-.29> photons { target reflection on refraction off } texture { T_Chrome_4C finish {ambient 15}}}
 translate <2.4,.08,1>
}
 
object { zegar      rotate y*35 translate <1.5,0,5>  }
object { lampa      scale 10    translate y*.72*10 }
object { stolik     scale 10 }
object { atmosphere scale 10 }    
object { sciany     scale 10 }

union {
 object { klein }
 object { roza2 scale .085  rotate <5,0,5> rotate y*180 translate <.49,-.9,.49> } 
 light_source { 0, <0.1,0.95,0.1>*.1 area_light x,y,2,2 jitter circular orient fade_power 2 fade_distance 1.5 translate <0,-.45,0> photons{ reflection on refraction on }}
 translate <1,1.25,2.4> 
} 
 