default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/*

Absinthe Minded
--------------------------------

NOTE: please, for the love of all that is good, render justclouds.pov and
 outside.pov first at about 800x600, and convert the resulting images to .jpg
 -rendered jpg version are included but they are little more than thumbnails,
 that allow you to render this scene, but will look absolutely horrid.
 
NOTE: Scroll down and set the switches to zero for test
renders, and 1 for final renders.

This is a slightly modified version of the origonal, in that I had to compress most
of the images to jpg format.  

render time for justclouds + outside + test on an AMD duron 950 mhtz with 512 megs
at 1024x768 with AA using area lights and photons - 8 hours 21 minutes 13 seconds

Thanks to:
 Gilles Tran              - tree macro
 Jonathan Rafael Ghiglia  - candle flame
 anthony bennett          - clouds
 Pov team                 - povray!
 anybody i forgot         - sorry 

2003 James Hughes

*/

/* ******************************************************************************
This is my slightly molested version of Johnathans candle flame scene, that was
posted to the povray newsserver. I'm not smart 'nuff to figure out how to use
'just' the flame, so i made everything else invisible *blush*. works though.
thanks a bunch to Johnathan!

*/
// Persistence Of Vision Ray Tracer Scene Description File
// File: candles.pov
// Vers: 3.5
// Desc: Three candles on a wooden table
// Date: 14 October 2001
// Auth: Jonathan Rafael Ghiglia
// Feel free to use this code. 

// Please notice that these macros are not so *customizable* (sp?). They just helped me to model the candles.
// If you change some params you can get unexpected results.
// I modelled the candles using a technique I saw first in a scene by Jaime Vives Piqueres  

//----SWITCHES

// change these to 1 for final render
#declare AREA_LIGHT = 0;
#declare PHOTONS_ON = 0;

// do not change these.. (i dont know what will happen if u do)
#declare RADIOSITY = 0;
#declare FOCAL_BLUR = 0; //------ REALLY SLOW
#declare TEST_TEXTURE = 0; //-----for testing candles' shape
   
#macro goccia (num,lung,r1,r2,Rad,Ang,Alt,Seed)
#local A=seed(Seed);  
#local i=0;
#while (i<num)
sphere {-y*lung/num*i, ((r2-r1)/lung*(lung/num*i)+r1)*(0.95+0.1*rand(A)),1
        translate <Rad,Alt,0> rotate Ang*y}
#local i=i+1;
#end
#end


#macro cand (alt,_r,num_goc,num_goccini,Seed)
#local I=seed(Seed);
union {
difference {
        blob {
        threshold 0.5
        cylinder {0, alt*y,_r*2,1}
        #local j=0;
        #while (j<num_goc)
        goccia (num_goccini,alt/3+alt/3*rand(I),_r/6+_r/6*rand(I),_r/3+_r/4*rand(I),_r,360/num_goc*j+rand(I)*25,alt,Seed)
        #local j=j+1;
        #end
        sturm}
        sphere {(alt+_r)*y+_r/2*rand(I)*x,_r*3/2 rotate rand(I)*360*y}
}
//cylinder {(alt-_r)*y,(alt+2+rand(I))*y,0.07
//        pigment {rgb 0.4}} 
//--fiamma    The flames only use emission media in this scene.
// If you want to use these candles with brighter backgrounds you have to play with absorption media as well.
blob {
threshold 0.5
#local f=0;
#while (f<15)
 sphere {<sin((0.5*f/14)*2)*0.5,0.3+0.5*f/14,sin((0.5*f/14)*2)*0.5>,(0.4-0.2*f/15) strength 1                
 }
 #local f=f+1;
 #end
hollow   
pigment {rgbt 1}
interior {
    media {
        method 3
        emission 1 //rgb <1,.7,.25> 
        density {
            gradient y
            color_map {
               [0 rgb <.2,.3,1.2>*4]
                [.3 rgb <1,.7,.25>*4]
            }
            scale 2}
        
        density {
            spherical color_map {
                [0.45 rgb 1]
                [.7 rgb 0]}
            scale 1.5/4
            translate 0.3*y}
        
    }
}
rotate rand(I)*360*y                                        
scale <_r,2.5*_r,_r>*2
translate (alt+1)*y
no_shadow}
  

light_source { 
        <0,80,0>
        rgb <.5,.375,.25>*.75
        fade_distance 2
        fade_power 3.5  
#if (AREA_LIGHT) area_light 1.5*x,1.5*y,6,6 adaptive 7 jitter orient circular #end
        scale .3  
        media_attenuation on
}

//-------glow
box {-1,1
    hollow
    no_shadow
    pigment {rgbt 1}
    interior {
        media {
            method 3
            emission 0.15
            density {
                spherical
                color_map {
                    [0 rgb 0]
                    [1 rgb <1,.85,.35>]
                }
                turbulence 0.1
                poly_wave 2
            }
        }
    } 
    translate y/2
    scale <_r,_r,_r>*9
    translate alt*y}
  
}

#end   


#declare pa=array[14]
#declare pa[0]=<-10,0>;
#declare pa[1]=<0,0>;
#declare pa[2]=<4,1>;
#declare pa[3]=<6,7>;
#declare pa[4]=<2,10>;
#declare pa[5]=<2,15>;
#declare pa[6]=<2,16.5>; 
#declare pa[7]=<1.5,17>;
#declare pa[8]=<1.5,15>;
#declare pa[9]=<1.5,10>;
#declare pa[10]=<5.5,7>;
#declare pa[11]=<3.5,1>;
#declare pa[12]=<0,0.7>;
#declare pa[13]=<-5,1>;
            
#declare porta_candela=
lathe {
        cubic_spline 
        14,
        #local sp=0;
        #while (sp<14)
        pa[sp]
        #local sp=sp+1;
        #end
        sturm
} 

#declare holder_metal= 
texture {
            pigment {rgbt 1}
        finish {diffuse 0 }
}

  
  
#macro wax (Color)
material {
    texture {
        pigment { rgbt 1 }finish {diffuse 0.0} 
            } 
         }
#end   

#macro tex()
texture {pigment {rgbt 1} finish {diffuse 0}}
#end

       
#include "colors.inc"
#include "woods.inc" 
#declare Wood   =         
    texture { pigment { rgbt 1 } } 
    texture { pigment { rgbt 1 } }
       


cylinder {-10*y,-15*y,85   translate 20*z
        texture {
         pigment {rgbt 1}
        finish {ambient 0 diffuse 0}
                 }
                }

object {
        cand (20,1.5,10,50,0) 
        hollow      double_illuminate
#if (TEST_TEXTURE) tex()
#else   wax (Wheat)  #end
translate <25,62.7,-68.4>
rotate <90,0,90>
scale .072
}

// End Candle Flame **************************************************************
/*

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 15
  number_of_waves 10
  radiosity {
    brightness       0.01
    count            1
    distance_maximum 1.0
    error_bound      0.4
    gray_threshold   0.8
    low_error_factor 0.5
    minimum_reuse    0.01
    nearest_count    4
    recursion_limit  1
  }  
   #if (PHOTONS_ON)
   photons {
      spacing 0.01      } 
   #end
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <     -0.159,     -12.164,       3.757>
  sky       <    0.00260,    -0.00006,     1.00000> // Use right handed-system (rotated by 0.15 degrees)!
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.56928,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      36.267
  look_at   <      0.124,      -0.607,       2.295>
}


light_source {   // GreenLight1
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.400, 0.000>
  fade_distance  1.5
  fade_power 3.0
  translate  <-3.457026, -3.594985, 2.231087>  
  photons {          
    refraction on
    reflection on
  }
}

light_source {   // Spotlight Spotlight003
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.629, 0.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    13.776  // outer radius (in deg)
    radius     3.517  // inner radius
    tightness  0.000
  shadowless
  fade_distance  3.0
  fade_power 4.0
  rotate <30.52537, 3.449043, 1.665152>
  translate  <3.161719, -6.893869, 3.771136>
}

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    17.195  // outer radius (in deg)
    radius     13.776  // inner radius
    tightness  0.000
  shadowless
  fade_distance  3.0
  fade_power 5.0
  scale <1.48, 0.98, 1.0>
  rotate <100.0, -0.0, 0.0>
  translate  <-1.939, -7.878, 0.681>
}

light_source {   // Arealight FinalLight
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 0
  fade_distance  4.5
  fade_power 5.0
  scale <0.118227, 0.112299, 1.0>
  translate  <-1.238, -5.141, 5.943>  
  photons {          
    refraction on
    reflection on
  }
}


light_source {   // Spotlight Spotlight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.343, 0.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    24.032  // outer radius (in deg)
    radius     12.635  // inner radius
    tightness  0.000
  rotate <-4.229144, -59.575363, 23.562119>
  translate  <-8.258, 1.293, 3.323>
}

light_source {   // GreenLight2
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.400, 0.000>
  fade_distance  1.6
  fade_power 3.0
  translate  <-0.33888, -4.194149, 2.688057> 
  photons {          
    refraction on
    reflection on
  }
}


//
// ********  MATERIALS  *******
//

#include "test.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare BezPtch005 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.028161, -2.028412, -1.254478>, <-0.028168, -2.028412, -1.254478>, <-0.028175, -2.028412, -1.254478>, <-0.022358, -2.024290, -1.259509>, 
      <-1.718740, -1.944145, -2.367135>, <-1.695288, -2.125827, -2.583315>, <-1.337278, -2.125827, -2.583315>, <-0.676910, -2.054128, -1.677917>, 
      <-2.419280, -1.430805, -2.100368>, <-2.357934, -1.708376, -1.682394>, <-1.833128, -1.708376, -1.682394>, <-0.924834, -1.720461, -1.080995>, 
      <-2.961840, -1.184015, -1.546345>, <-2.917524, -1.427702, -1.262792>, <-2.271683, -1.430960, -1.160743>, <-1.144112, -1.444425, -0.682700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.961840, -1.184015, -1.546345>, <-2.917524, -1.427702, -1.262792>, <-2.271683, -1.430960, -1.160743>, <-1.144112, -1.444425, -0.682700>, 
      <-3.504400, -0.937225, -0.992321>, <-3.477115, -1.147028, -0.843191>, <-2.710239, -1.153545, -0.639092>, <-1.363390, -1.226384, -0.284404>, 
      <-4.157516, -0.380013, -0.635600>, <-4.119577, -0.531478, -0.429877>, <-3.282535, -0.531478, -0.147476>, <-1.649538, -0.715645, 0.093430>, 
      <-4.428126, 0.092547, -0.201768>, <-4.384296, -0.009529, 0.011628>, <-3.527733, -0.000628, 0.300614>, <-1.772137, -0.242964, 0.428669>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.428126, 0.092547, -0.201768>, <-4.384296, -0.009529, 0.011628>, <-3.527733, -0.000628, 0.300614>, <-1.772137, -0.242964, 0.428669>, 
      <-4.698736, 0.565107, 0.232063>, <-4.649014, 0.512419, 0.453132>, <-3.772932, 0.530223, 0.748705>, <-1.894736, 0.171721, 0.763909>, 
      <-4.710169, 1.338670, 0.281852>, <-4.645986, 1.334735, 0.507801>, <-3.679877, 1.334735, 0.833746>, <-1.848209, 0.839357, 0.817667>, 
      <-4.431510, 1.608154, 0.167967>, <-4.373332, 1.648136, 0.142857>, <-3.447204, 1.648136, 0.514325>, <-1.731873, 1.169689, 0.554418>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.431510, 1.608154, 0.167967>, <-4.373332, 1.648136, 0.142857>, <-3.447204, 1.648136, 0.514325>, <-1.731873, 1.169689, 0.554418>, 
      <-4.152852, 1.877638, 0.054082>, <-4.100677, 1.961537, -0.222087>, <-3.214532, 1.961537, 0.194904>, <-1.615536, 1.442025, 0.291170>, 
      <-3.851452, 2.223566, -0.428650>, <-3.745820, 2.382574, -0.507898>, <-3.214532, 2.551187, -0.151490>, <-1.615536, 1.927069, -0.010205>, 
      <-3.573523, 2.559838, -0.611222>, <-3.152559, 2.730229, -0.663167>, <-2.699509, 2.888347, -0.764022>, <-1.358025, 2.298999, -0.496488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.022358, -2.024290, -1.259509>, <-0.016541, -2.020169, -1.264540>, <-0.010664, -2.028603, -1.313308>, <-0.001727, -2.028603, -1.313308>, 
      <-0.676910, -2.054128, -1.677917>, <-0.016541, -1.982429, -0.772519>, <-0.010664, -1.863360, -0.902591>, <-0.001727, -1.863360, -0.902591>, 
      <-0.924834, -1.720461, -1.080995>, <-0.016541, -1.732546, -0.479597>, <-0.010664, -1.716221, -0.621528>, <-0.001727, -1.716221, -0.621528>, 
      <-1.144112, -1.444425, -0.682700>, <-0.016541, -1.515885, -0.204657>, <-0.010664, -1.500530, -0.346793>, <-0.001727, -1.442534, -0.346793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.144112, -1.444425, -0.682700>, <-0.016541, -1.515885, -0.204657>, <-0.010664, -1.500530, -0.346793>, <-0.001727, -1.442534, -0.346793>, 
      <-1.363390, -1.226384, -0.284404>, <-0.016541, -1.299223, 0.070284>, <-0.010664, -1.284838, -0.072057>, <-0.001727, -1.284838, -0.072057>, 
      <-1.649538, -0.715645, 0.093430>, <-0.016541, -0.899812, 0.334336>, <-0.010664, -0.896397, 0.190659>, <-0.001727, -0.896397, 0.190659>, 
      <-1.772137, -0.242964, 0.428669>, <-0.016541, -0.543296, 0.556724>, <-0.010664, -0.541589, 0.413007>, <-0.001727, -0.483594, 0.413007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.772137, -0.242964, 0.428669>, <-0.016541, -0.543296, 0.556724>, <-0.010664, -0.541589, 0.413007>, <-0.001727, -0.483594, 0.413007>, 
      <-1.894736, 0.171721, 0.763909>, <-0.016541, -0.186781, 0.779112>, <-0.010664, -0.186781, 0.635356>, <-0.001727, -0.186781, 0.635356>, 
      <-1.848209, 0.839357, 0.817667>, <-0.016541, 0.343979, 0.801588>, <-0.009588, 0.343979, 0.657832>, <-0.001727, 0.343979, 0.657832>, 
      <-1.731873, 1.169689, 0.554418>, <-0.016541, 0.633246, 0.594512>, <-0.009588, 0.626066, 0.451461>, <-0.001727, 0.684062, 0.451461>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.731873, 1.169689, 0.554418>, <-0.016541, 0.633246, 0.594512>, <-0.009588, 0.626066, 0.451461>, <-0.001727, 0.684062, 0.451461>, 
      <-1.615536, 1.442025, 0.291170>, <-0.016541, 0.922514, 0.387436>, <-0.009588, 0.908154, 0.245090>, <-0.001727, 0.908154, 0.245090>, 
      <-1.615536, 1.927069, -0.010205>, <-0.016541, 1.302952, 0.131079>, <-0.009588, 1.274374, -0.007006>, <-0.001727, 1.274374, -0.007006>, 
      <-1.358025, 2.298999, -0.496488>, <-0.016541, 1.709652, -0.228954>, <-0.009588, 1.681074, -0.367039>, <-0.001727, 1.681074, -0.367039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001727, -2.028603, -1.313308>, <0.007209, -2.028603, -1.313308>, <0.016541, -2.020169, -1.264540>, <0.035926, -2.023052, -1.259367>, 
      <-0.001727, -1.863360, -0.902591>, <0.007209, -1.863360, -0.902591>, <0.016541, -1.982429, -0.772519>, <0.490627, -1.961961, -1.632289>, 
      <-0.001727, -1.716221, -0.621528>, <0.007209, -1.716221, -0.621528>, <0.016541, -1.732546, -0.479597>, <0.680798, -1.745588, -1.206359>, 
      <-0.001727, -1.442534, -0.346793>, <0.007209, -1.500530, -0.346793>, <0.016541, -1.515885, -0.204657>, <0.934701, -1.487113, -0.754765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001727, -1.442534, -0.346793>, <0.007209, -1.500530, -0.346793>, <0.016541, -1.515885, -0.204657>, <0.934701, -1.487113, -0.754765>, 
      <-0.001727, -1.284838, -0.072057>, <0.007209, -1.284838, -0.072057>, <0.016541, -1.299223, 0.070284>, <1.188604, -1.286634, -0.303171>, 
      <-0.001727, -0.896397, 0.190659>, <0.007209, -0.896397, 0.190659>, <0.016541, -0.899812, 0.334336>, <1.551841, -0.749919, 0.216644>, 
      <-0.001727, -0.483594, 0.413007>, <0.007209, -0.541589, 0.413007>, <0.016541, -0.543296, 0.556724>, <1.642433, -0.265390, 0.545436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001727, -0.483594, 0.413007>, <0.007209, -0.541589, 0.413007>, <0.016541, -0.543296, 0.556724>, <1.642433, -0.265390, 0.545436>, 
      <-0.001727, -0.186781, 0.635356>, <0.007209, -0.186781, 0.635356>, <0.016541, -0.186781, 0.779112>, <1.733024, 0.161144, 0.874227>, 
      <-0.001727, 0.343979, 0.657832>, <0.006133, 0.343979, 0.657832>, <0.016541, 0.343979, 0.801588>, <1.699180, 0.828780, 0.930871>, 
      <-0.001727, 0.684062, 0.451461>, <0.006133, 0.626066, 0.451461>, <0.016541, 0.633246, 0.594512>, <1.657823, 1.115459, 0.755209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001727, 0.684062, 0.451461>, <0.006133, 0.626066, 0.451461>, <0.016541, 0.633246, 0.594512>, <1.657823, 1.115459, 0.755209>, 
      <-0.001727, 0.908154, 0.245090>, <0.006133, 0.908154, 0.245090>, <0.016541, 0.922514, 0.387436>, <1.616467, 1.344143, 0.579546>, 
      <-0.001727, 1.274374, -0.007006>, <0.006133, 1.274374, -0.007006>, <0.016541, 1.302952, 0.131079>, <1.526209, 1.905287, 0.070320>, 
      <-0.001727, 1.681074, -0.367039>, <0.006133, 1.681074, -0.367039>, <0.016541, 1.709652, -0.228954>, <1.218712, 2.284089, -0.279608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.035926, -2.023052, -1.259367>, <0.055312, -2.025934, -1.254195>, <0.057343, -2.022887, -1.259663>, <0.059133, -2.022075, -1.261120>, 
      <0.490627, -1.961961, -1.632289>, <0.964713, -1.941493, -2.492058>, <1.384563, -2.015929, -2.469376>, <1.382396, -1.860324, -2.169080>, 
      <0.680798, -1.745588, -1.206359>, <1.345055, -1.758630, -1.933120>, <1.852839, -1.814925, -1.953077>, <2.009226, -1.608255, -1.846811>, 
      <0.934701, -1.487113, -0.754765>, <1.852861, -1.516338, -1.304873>, <2.481117, -1.587004, -1.278546>, <2.603311, -1.406845, -1.333471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.934701, -1.487113, -0.754765>, <1.852861, -1.516338, -1.304873>, <2.481117, -1.587004, -1.278546>, <2.603311, -1.406845, -1.333471>, 
      <1.188604, -1.286634, -0.303171>, <2.360668, -1.274045, -0.676625>, <3.109394, -1.359082, -0.604015>, <3.197395, -1.205436, -0.820132>, 
      <1.551841, -0.749919, 0.216644>, <3.087142, -0.600027, 0.098952>, <3.835853, -0.600027, -0.312141>, <3.870211, -0.442731, -0.533784>, 
      <1.642433, -0.265390, 0.545436>, <3.268324, -0.045479, 0.534147>, <4.101206, -0.045479, 0.076838>, <4.166234, 0.060667, -0.167867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.642433, -0.265390, 0.545436>, <3.268324, -0.045479, 0.534147>, <4.101206, -0.045479, 0.076838>, <4.166234, 0.060667, -0.167867>, 
      <1.733024, 0.161144, 0.874227>, <3.449507, 0.509070, 0.969341>, <4.366559, 0.509070, 0.465817>, <4.462257, 0.564065, 0.198049>, 
      <1.699180, 0.828780, 0.930871>, <3.381818, 1.313582, 1.060154>, <4.298870, 1.313582, 0.556629>, <4.402084, 1.319316, 0.284735>, 
      <1.657823, 1.115459, 0.755209>, <3.299106, 1.539677, 0.915905>, <4.216158, 1.539677, 0.412381>, <4.298611, 1.551479, 0.147789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.657823, 1.115459, 0.755209>, <3.299106, 1.539677, 0.915905>, <4.216158, 1.539677, 0.412381>, <4.298611, 1.551479, 0.147789>, 
      <1.616467, 1.344143, 0.579546>, <3.216394, 1.765771, 0.771657>, <4.133446, 1.765771, 0.268132>, <4.195137, 1.783642, 0.010844>, 
      <1.526209, 1.905287, 0.070320>, <3.035876, 2.507622, 0.009561>, <3.659394, 2.348250, -0.411447>, <3.862867, 2.192161, -0.418311>, 
      <1.218712, 2.284089, -0.279608>, <2.420884, 2.858526, -0.330262>, <2.996700, 2.709802, -0.542980>, <3.437226, 2.540373, -0.457651>
    }
  }
  material {
    ChromeLike
  }
  scale <0.16, 0.28, 0.29>
  rotate 5.0*x
  translate  <0.055, -2.311, 1.106>
}


#include "windowframe.inc"

#declare windowframe_Ref = object {
  windowframe  rotate <90.0, -0.148369, -0.0>
  translate  <-1.232478, -0.986, 0.69327>
}




//
// ********  OBJECTS  *******
//

#declare HgtFld002 = object { 
  height_field {
    jpeg "wings_bump.jpg"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    FairyWings
  }
  scale <1.0, 1.333333, 0.05>
  rotate 90.0*x
  translate  <0.0, -6.635316, 2.29063>
}
intersection { // LeftFairyWing
  object { HgtFld002 }
  box { // WingCutter
    <-1, -1, -1>, <1, 1, 1>
    material {
      FairyWings
    }
    scale <1.0, 1.33333, 0.059201>
    rotate 90.0*x
    translate  <-0.001431, -6.656854, 2.289885>
  }
  scale <1.0, 0.3, 1.0>
  rotate <4.981251, -3.422776, -35.965363>
  translate  <3.469185, -2.596918, -0.288129>
}


#include "tail.inc"

object {
  tail
  scale 6.0
  rotate <89.124741, -0.25972, -16.52614>
  translate  <2.489747, -5.189497, -0.968727>
}


#include "top.inc"

object {
  top
  scale 0.79502
  rotate <-0.303892, -180.097702, 166.076843>
  translate  <2.505742, -5.103982, 2.507417>
}


#include "bottom.inc"

object {
  bottom
  scale 0.795024
  rotate <89.124001, -0.25972, -16.525999>
  translate  <2.444277, -5.301738, 1.66216>
}


#include "fairy.inc"

object {
  fairy
  scale 6.0
  rotate <89.124741, -0.259719, -16.526136>
  translate  <2.435165, -5.336735, 0.271242>
}


box { // MyFilter
  <-1, -1, -1>, <1, 1, 1>
  scale <1.936194, 0.01, 1.645134>
  translate  <-0.37448, -10.220044, 3.059973>
  material {
    NoiseFilter
    // Transform to world space
  }
}




box { // Cube007
  <-1, -1, -1>, <1, 1, 1>
  material {
    MySparkles
  }
  no_shadow
  scale <4.177762, 2.872908, 0.001>
  rotate <90.0, 0.0, -9.64947>
  translate  <-0.096037, -4.226576, 2.826999>
}


box { // Cube006
  <-1, -1, -1>, <1, 1, 1>
  material {
    JustBlack
  }
  scale <15.048676, 9.875719, 0.59028>
  translate  <0.460092, -7.012333, 8.895108>
}




#include "spoooon.inc"

#declare spoooon_Ref = object {
  spoooon
  scale <0.252246, 0.270785, 0.232523>
  rotate <91.211136, -0.299364, 97.768005>
  translate  <-3.39496, -3.804795, 1.538096>
}
union { // AbsintheSpoon
  superellipsoid { // SuperQ007
    <0.1, 0.1>
    material {
      Sugar
    }
    scale 0.081126
    rotate <-0.0, 1.679406, 18.905111>
    translate  <-3.375634, -3.91076, 1.585018>
  }
  object { spoooon_Ref }
  rotate 24.440821*z
  translate  <-2.10578, 1.038861, -0.009243>
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    forthesky
  }
  hollow
  scale -31.825518
}


#declare HgtFld001 = object { 
  height_field {
    jpeg "windowcutter.jpg"
    water_level 0.2975
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    T_Wood1
  }
  scale <4.18, 3.41, 1.74>
  rotate 90.0*x
  translate  <1.153, 3.523, 3.072>
}
difference { // CSG001
  box { // DaBackWall
    <-1, -1, -1>, <1, 1, 1>
    scale <14.59, 0.08, 5.29>
    translate  <0.0, 2.824, 3.316>
    material {
      Wallcolor
      // Transform to world space
    }
  }
  object { HgtFld001 }
}


box { // Cube002
  <-1, -1, -1>, <1, 1, 1>
  material {
    Mybackground
  }
  scale <5.596532, 3.8, 1.341667>
  rotate 89.899979*x
  translate  <0.822045, 6.815788, 3.203515>
}






union { // BezPtch002
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.577552, -2.904964, 0.431258>, <-4.000000, -2.000000, 0.000000>, <-3.000000, -2.000000, 0.000000>, <-2.013468, -2.000000, 0.000000>, 
      <-4.577552, -1.904964, 0.431258>, <-4.000000, -1.000000, 0.000000>, <-3.000000, -1.000000, 0.000000>, <-2.013468, -1.000000, 0.000000>, 
      <-4.577552, -0.904964, 0.431258>, <-4.000000, 0.000000, 0.000000>, <-3.000000, 0.000000, 0.000000>, <-2.013468, 0.000000, 0.000000>, 
      <-4.577552, 0.095036, 0.431258>, <-4.000000, 1.000000, 0.000000>, <-3.000000, 1.000000, 0.000000>, <-2.013468, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.013468, -2.000000, 0.000000>, <-1.026936, -2.000000, 0.000000>, <-0.107746, -2.110525, -0.190188>, <0.932659, -2.055212, -0.105088>, 
      <-2.013468, -1.000000, 0.000000>, <-1.026936, -1.000000, 0.000000>, <-0.107746, -1.200188, 0.223681>, <0.976171, -0.850526, -0.621837>, 
      <-2.013468, 0.000000, 0.000000>, <-1.026936, 0.000000, 0.000000>, <-0.107746, 0.000000, 0.700347>, <1.046027, -0.040328, 0.622639>, 
      <-2.013468, 1.000000, 0.000000>, <-1.026936, 1.000000, 0.000000>, <-0.107746, 1.000000, 0.700347>, <0.932659, 0.999975, 0.355170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.932659, -2.055212, -0.105088>, <1.973064, -1.999900, -0.019989>, <2.973064, -2.000000, 0.000000>, <3.973064, -2.000000, 0.000000>, 
      <0.976171, -0.850526, -0.621837>, <2.060089, -0.500863, -1.467356>, <2.973064, -1.000000, 0.000000>, <3.973064, -1.000000, 0.000000>, 
      <1.046027, -0.040328, 0.622639>, <2.199799, -0.080656, 0.544932>, <2.985043, 0.000000, 1.353672>, <3.973064, 0.000000, 0.000000>, 
      <0.932659, 0.999975, 0.355170>, <1.973064, 0.999950, 0.009994>, <2.973064, 1.000000, 0.000000>, <3.973064, 1.000000, 0.000000>
    }
  }
  material {
    Aluminum
  }
  scale <1.27, 1.47, 1.0>
  translate  <0.802, -3.738, 0.0>
}


//
// Include file contains 'RotSweep002'
//
#include "test.in1"
#declare RotSweep002 = object {
  RotSweep002_Raw
  scale 0.9
  translate  <-2.061, -4.005, 1.784>
    material {
    MyBottleGlass
    // Transform to world space
    translate  <-0.583, 1.337, 0.016>
    rotate 11.5*z
    scale 1.0/0.9  
    }
}
#declare BezPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.575370, 0.835744, -1.929491>, <-1.168613, -0.020789, -1.964739>, <0.185103, -0.007551, -1.999987>, <0.519267, 0.951048, -1.999987>, 
      <-1.575407, 0.832088, -0.929497>, <-1.168613, -0.024446, -0.964745>, <0.185103, -0.011207, -0.999993>, <0.519230, 0.947392, -0.999993>, 
      <-1.575444, 0.828431, 0.070496>, <-1.168613, -0.028102, 0.035248>, <0.185103, -0.014864, 0.000000>, <0.519193, 0.943735, 0.000000>, 
      <-1.575481, 0.824775, 1.070489>, <-1.168613, -0.031759, 1.035241>, <0.185103, -0.018520, 0.999993>, <0.519156, 0.940079, 0.999993>
    }
  }
  material {
    MyLabel
    scale <1.45, 1.38, 0.83>
    rotate <270.0, -180.0, -180.0>
    translate <-0.287000, -0.658000, -0.430000>
  }
  scale <0.43, 0.39, 0.31>
  rotate 25.0*z
  translate  <-1.569, -4.476, 1.231>
}
//
// Include file contains 'Corkidie'
//
#include "test.in2"
#declare Corkidie = object {
  Corkidie_Raw
  material {
    GlassCork
  }
  scale 0.111111
  rotate -2.072258*y
  translate  <-2.074444, -3.978889, 3.457778>
}
union { // MyBottle
  object { RotSweep002 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Spirit
    }
    scale <0.51, 0.5, 1.48>
    translate  <-2.056, -4.015, 0.065>
  }
  object { BezPtch001 }
  object { Corkidie }
  scale 0.9
  rotate -11.5*z
  translate  <0.583, -1.337, -0.016>
photons {  // photon block for an object
    target 1.0
    refraction on
    reflection on
  }
}




box { // Cube003
  <-1, -1, -1>, <1, 1, 1>
  material {
    Myrefmap
  }
  scale <14.55, 10.74, -0.34>
  rotate <90.0, -0.0, -180.0>
  translate  <0.026, -13.749228, 7.588433>
}


//
// Include file contains 'RotSweep001'
//
#include "test.in3"
#declare RotSweep001 = object {
  RotSweep001_Raw
  material {
    MyGlass
  }
  translate  <0.0, 0.037, 1.305>
}
#declare Absinthe = difference {
  superellipsoid { // SuperQ001
    <1.0, 1.8>
    scale <0.88, 0.88, 0.97>
    translate  <0.0, 0.029, 2.716>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.73, 1.55, 1.0>
    translate  <0.0, 0.057, 3.582>
  }
  material {
    MyAbsinthe
  }
  rotate -25.0*z
}
union { // GlassOAbsinthe
  object { RotSweep001 }
  object { Absinthe }
  scale 0.5
  translate  <-3.468, -3.625, 0.0>
photons {  // photon block for an object
    target 1.0
    refraction on
    reflection on
  }
}


box { // Cube004
  <-1, -1, -1>, <1, 1, 1>
  material {
    Myrefmap
  }
  scale <14.55, 10.74, -0.34>
  rotate <90.0, -0.0, 90.0>
  translate  <-14.788, 0.708, 7.616>
}


box { // Cube005
  <-1, -1, -1>, <1, 1, 1>
  material {
    Myrefmap
  }
  scale <14.55, 10.74, -0.34>
  rotate <90.0, -0.0, 90.0>
  translate  <14.23, 0.403, 7.616>
}


#declare DaWick = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.420954, -0.000000, -0.815446>, <-0.420954, -0.129032, -0.815446>, <-0.375373, -0.129032, -1.003551>, <-0.375373, -0.000000, -1.003551>, 
      <0.053298, -0.000000, -0.538208>, <0.053298, -0.129032, -0.538208>, <0.228343, -0.129032, -0.620792>, <0.228343, -0.000000, -0.620792>, 
      <0.150490, -0.000000, 0.100621>, <0.150490, -0.129032, 0.100621>, <0.334448, -0.129032, 0.160791>, <0.334448, -0.000000, 0.160791>, 
      <0.123862, -0.000000, 0.757503>, <0.123862, -0.019614, 0.757503>, <0.158658, -0.019614, 0.817673>, <0.158658, -0.000000, 0.817673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.375373, -0.000000, -1.003551>, <-0.375373, 0.129032, -1.003551>, <-0.420954, 0.129032, -0.815446>, <-0.420954, -0.000000, -0.815446>, 
      <0.228343, -0.000000, -0.620792>, <0.228343, 0.129032, -0.620792>, <0.053298, 0.129032, -0.538208>, <0.053298, -0.000000, -0.538208>, 
      <0.334448, -0.000000, 0.160791>, <0.334448, 0.129032, 0.160791>, <0.150490, 0.129032, 0.100621>, <0.150490, -0.000000, 0.100621>, 
      <0.158658, -0.000000, 0.817673>, <0.158658, 0.019614, 0.817673>, <0.123862, 0.019614, 0.757503>, <0.123862, -0.000000, 0.757503>
    }
  }
  material {
    Wicked
  }
  scale 0.2
  rotate 15.0*y
  translate  <0.797, -0.494, 2.717>
}
#declare WallMount = union {
  superellipsoid { // SuperQ002
    <1.0, 0.1>
    material {
      ChromeLike
    }
    scale <1.0, 0.97, 0.04>
    translate  <0.079, -2.648, 0.0>
  }
  superellipsoid { // SuperQ003
    <1.0, 0.1>
    material {
      ChromeLike
    }
    scale <0.91, 0.8827, 0.0364>
    translate  <0.079, -2.635, 0.013>
  }
  superellipsoid { // SuperQ004
    <1.0, 0.1>
    material {
      ChromeLike
    }
    scale <0.8, 0.776, 0.032>
    translate  <0.079, -2.635, 0.052>
  }
  superellipsoid { // SuperQ005
    <1.0, 0.1>
    material {
      ChromeLike
    }
    scale <0.66, 0.6402, 0.0264>
    translate  <0.079, -2.635, 0.086>
  }
  superellipsoid { // SuperQ006
    <1.0, 0.1>
    material {
      ChromeLike
    }
    scale <0.38, 0.3686, 0.0152>
    translate  <0.079, -2.635, 0.12>
  }
  material {
    ChromeLike
  }
  scale 0.82
  rotate 90.0*x
  translate  <-0.314, 1.369, -2.202>
}
#declare BezPtch003 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.144076, 1.467063, -0.264104>, <0.141975, 1.460685, -0.347966>, <0.251259, 1.424697, -0.347965>, <0.253359, 1.431074, -0.264104>, 
      <0.024286, 1.103310, -0.233441>, <0.022186, 1.096932, -0.317302>, <0.131469, 1.060944, -0.317302>, <0.133569, 1.067321, -0.233441>, 
      <-0.050972, 0.713020, -0.377479>, <-0.050972, 0.731809, -0.459484>, <0.064084, 0.731809, -0.459484>, <0.064084, 0.713020, -0.377479>, 
      <-0.113475, 0.447179, -0.265314>, <-0.111079, 0.440379, -0.342863>, <-0.008816, 0.476549, -0.342863>, <-0.011213, 0.483350, -0.265314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.253359, 1.431074, -0.264104>, <0.255459, 1.437452, -0.180243>, <0.146176, 1.473440, -0.180243>, <0.144076, 1.467063, -0.264104>, 
      <0.133569, 1.067321, -0.233441>, <0.135670, 1.073699, -0.149580>, <0.026386, 1.109687, -0.149580>, <0.024286, 1.103310, -0.233441>, 
      <0.064084, 0.713020, -0.377479>, <0.064084, 0.694231, -0.295474>, <-0.050972, 0.694231, -0.295474>, <-0.050972, 0.713020, -0.377479>, 
      <-0.011213, 0.483350, -0.265314>, <-0.035005, 0.490150, -0.187764>, <-0.137268, 0.453979, -0.187764>, <-0.113475, 0.447179, -0.265314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.113475, 0.447179, -0.265314>, <-0.111079, 0.440379, -0.342863>, <-0.008816, 0.476549, -0.342863>, <-0.011213, 0.483350, -0.265314>, 
      <-0.197374, 0.181338, -0.153149>, <-0.171185, 0.148949, -0.226243>, <-0.081716, 0.221290, -0.226243>, <-0.107905, 0.253680, -0.153149>, 
      <-0.114336, 0.078640, 0.153740>, <-0.068821, 0.022349, 0.110875>, <0.020648, 0.094690, 0.110875>, <-0.024867, 0.150982, 0.153740>, 
      <-0.088882, 0.039320, 0.420275>, <-0.066124, -0.030890, 0.398842>, <0.031363, 0.005280, 0.375892>, <0.008605, 0.075491, 0.397325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.011213, 0.483350, -0.265314>, <-0.035005, 0.490150, -0.187764>, <-0.137268, 0.453979, -0.187764>, <-0.113475, 0.447179, -0.265314>, 
      <-0.107905, 0.253680, -0.153149>, <-0.134094, 0.286070, -0.080054>, <-0.223563, 0.213728, -0.080054>, <-0.197374, 0.181338, -0.153149>, 
      <-0.024867, 0.150982, 0.153740>, <-0.070382, 0.207274, 0.196605>, <-0.159852, 0.134932, 0.196605>, <-0.114336, 0.078640, 0.153740>, 
      <0.008605, 0.075491, 0.397325>, <-0.014153, 0.145702, 0.418757>, <-0.111639, 0.109531, 0.441707>, <-0.088882, 0.039320, 0.420275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.088882, 0.039320, 0.420275>, <-0.066124, -0.030890, 0.398842>, <0.031363, 0.005280, 0.375892>, <0.008605, 0.075491, 0.397325>, 
      <-0.063427, -0.000000, 0.686809>, <-0.063427, -0.084130, 0.686809>, <0.042077, -0.084130, 0.640909>, <0.042077, -0.000000, 0.640909>, 
      <0.101307, -0.000000, 1.075734>, <0.101307, -0.084130, 1.075734>, <0.184200, -0.084130, 0.995941>, <0.184200, -0.000000, 0.995941>, 
      <0.367747, -0.000000, 1.352528>, <0.367747, -0.084130, 1.352528>, <0.450640, -0.084130, 1.272736>, <0.450640, -0.000000, 1.272736>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.008605, 0.075491, 0.397325>, <-0.014153, 0.145702, 0.418757>, <-0.111639, 0.109531, 0.441707>, <-0.088882, 0.039320, 0.420275>, 
      <0.042077, -0.000000, 0.640909>, <0.042077, 0.084130, 0.640909>, <-0.063427, 0.084129, 0.686809>, <-0.063427, -0.000000, 0.686809>, 
      <0.184200, -0.000000, 0.995941>, <0.184200, 0.084130, 0.995941>, <0.101307, 0.084129, 1.075734>, <0.101307, -0.000000, 1.075734>, 
      <0.450640, -0.000000, 1.272736>, <0.450640, 0.084130, 1.272736>, <0.367747, 0.084129, 1.352528>, <0.367747, -0.000000, 1.352528>
    }
  }
  material {
    ChromeLike
  }
  translate  <-0.489, -0.145, -4.117>
}
#declare myCandle = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.426786, -0.000001, -2.226710>, <-0.426786, -0.510833, -2.226710>, <0.479754, -0.510833, -2.191638>, <0.479754, -0.000000, -2.191638>, 
      <1.011481, -0.000001, -0.461893>, <1.011481, -0.510833, -0.461893>, <1.706991, -0.510833, -0.705406>, <1.706991, -0.000000, -0.705406>, 
      <-0.333696, -0.000001, 0.834775>, <-0.333696, -0.464426, 0.834775>, <0.404007, -0.464426, 0.860169>, <0.404007, -0.000000, 0.860169>, 
      <0.200749, -0.157866, 1.992166>, <0.128028, -0.561080, 1.992166>, <0.484720, -0.554369, 1.609323>, <0.496576, -0.151154, 1.508663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.479754, -0.000000, -2.191638>, <0.479754, 0.510833, -2.191638>, <-0.426786, 0.510832, -2.226710>, <-0.426786, -0.000001, -2.226710>, 
      <1.706991, -0.000000, -0.705406>, <1.706991, 0.510833, -0.705406>, <1.011481, 0.510832, -0.461893>, <1.011481, -0.000001, -0.461893>, 
      <0.404007, -0.000000, 0.860169>, <0.404007, 0.464425, 0.860169>, <-0.333696, 0.464424, 0.834775>, <-0.333696, -0.000001, 0.834775>, 
      <0.496576, -0.151154, 1.508663>, <0.503750, 0.252060, 1.408002>, <0.273469, 0.245348, 1.992166>, <0.200749, -0.157866, 1.992166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.200749, -0.157866, 1.992166>, <0.128028, -0.561080, 1.992166>, <0.484720, -0.554369, 1.609323>, <0.496576, -0.151154, 1.508663>, 
      <0.735194, -0.315732, 3.149558>, <0.589753, -0.657734, 3.149558>, <0.565433, -0.644312, 2.358478>, <0.584463, -0.302309, 2.157156>, 
      <0.830930, -0.353364, 3.135984>, <0.685489, -0.695367, 3.135984>, <0.702295, -0.821976, 2.035899>, <0.861782, -0.479973, 2.157629>, 
      <0.528882, -0.412071, 2.291405>, <0.524229, -0.423012, 2.291405>, <0.544399, -0.431590, 2.260649>, <0.549052, -0.420649, 2.260649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.496576, -0.151154, 1.508663>, <0.503750, 0.252060, 1.408002>, <0.273469, 0.245348, 1.992166>, <0.200749, -0.157866, 1.992166>, 
      <0.584463, -0.302309, 2.157156>, <0.603494, 0.039694, 1.955835>, <0.880635, 0.026271, 3.149558>, <0.735194, -0.315732, 3.149558>, 
      <0.861782, -0.479973, 2.157629>, <1.021269, -0.137970, 2.279358>, <0.976371, -0.011362, 3.135984>, <0.830930, -0.353364, 3.135984>, 
      <0.549052, -0.420649, 2.260649>, <0.553705, -0.409708, 2.260649>, <0.533535, -0.401131, 2.291405>, <0.528882, -0.412071, 2.291405>
    }
  }
  material {
    CandleTexture
  }
  hollow
}
//
// Include file contains 'RotSweep003'
//
#include "test.in4"
#declare RotSweep003 = object {
  RotSweep003_Raw
  material {
    ChromeLike
  }
}
#declare CandleHolder = union {
  object { // BezPtch010 -> BezPtch005
    BezPtch005
    rotate <-0.0, 0.0, 40.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // BezPtch006 -> BezPtch005
    BezPtch005
    rotate <-0.0, 0.0, -160.0>
    translate  <-0.0, -0.0, -0.0>
  }
  object { // BezPtch004 -> BezPtch005
    BezPtch005
    rotate <-0.0, 0.0, -40.0>
    translate  -0.0*z
  }
  object { BezPtch005 }
  object { // BezPtch007 -> BezPtch005
    BezPtch005
    rotate <-0.0, 0.0, -80.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // BezPtch008 -> BezPtch005
    BezPtch005
    rotate <-0.0, 0.0, -120.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // BezPtch009 -> BezPtch005
    BezPtch005
    rotate <-0.0, 0.0, 160.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // BezPtch011 -> BezPtch005
    BezPtch005
    rotate <-0.0, 0.0, 120.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // BezPtch012 -> BezPtch005
    BezPtch005
    rotate <-0.0, 0.0, 80.0>
    translate  <-0.0, -0.0, -0.0>
  }
  object { RotSweep003 }
  scale 0.45
  rotate <-10.345276, 14.766891, -2.663986>
  translate  <-0.057, -0.126, -2.432>
}
union { // DaFunkyCandle
  object { DaWick }
  object { WallMount }
  object { BezPtch003 }
  object { myCandle }
  object { CandleHolder }
  scale 0.4
  translate  <-5.318, 2.19, 5.115>
}


union { // ThaWindowFrame
  object { windowframe_Ref }
  object { // windowframe1 -> windowframe
    windowframe_Ref
    rotate <0.0, 0.0, 0.0>
    translate  <5.205194, -0.0, 0.224692>
  }
  object { // windowframe2 -> windowframe
    windowframe_Ref
    rotate <0.0, 0.0, 0.0>
    translate  <2.613, 0.0, -0.011>
  }
  object { // windowframe3 -> windowframe
    windowframe_Ref
    rotate <0.0, 75.0, 0.0>
    translate  <-1.107189, 0.0, -2.221548>
  }
  object { // windowframe4 -> windowframe
    windowframe_Ref
    rotate <0.0, 78.388916, 0.0>
    translate  <-0.890828, 0.0, 0.31155>
  }
  object { // windowframe5 -> windowframe
    windowframe_Ref
    rotate <-0.0, 75.401009, -0.0>
    translate  <-1.708, 0.0, -4.444384>
  }
  scale 1.2
  translate  <1.831, 3.871, 1.482>
}




#declare HgtFld003 = object { 
  height_field {
    jpeg "wings_bump.jpg"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    FairyWings
  }
  scale <1.0, 1.333333, 0.05>
  rotate 90.0*x
  translate  <0.0, -6.635316, 2.29063>
}
intersection { // LeftFairyWing1
  object { HgtFld003 }
  box { // WingCutter1
    <-1, -1, -1>, <1, 1, 1>
    material {
      FairyWings
    }
    scale <1.0, 1.33333, 0.059201>
    rotate 90.0*x
    translate  <-0.001431, -6.656854, 2.289885>
  }
  scale <-1.0, 0.3, 1.0>
  rotate <-6.609876, 6.491604, 9.706131>
  translate  <2.948086, -2.977059, -0.730818>
}


