//=======================================================================
// Collonade generator macro for Pov-ray 3.1
// (c) 2000 Thomas lieven tommy@webkenya.com
//=======================================================================
// This file contains 3 macro to build colonnes, tiled ground and roof 
//=======================================================================
// mColon macro
//-----------------------------------------
// It creates a colonnade
// The colonnade can be:
// - one ligne of pilier (type 1)
// - one ligne of colonne (type 2)
// - two lignes of pilier (type 3)
// - two lignes of colonnes (type 4)
// The colonnade is translated on x 
//-----------------------------------------

/* Creation d'une colonnade
            
Componants of the colonnade :
------------
A.   Pilier
B.   Poteau
C.   Ballustrade
D.   Compiler la Colonne  


#declare typeColon = 4;       // type: 1=rangee pilier, 2=rangee colonne, 3=deux rangees de pilier, 4= deux rangees de colonne
                              //       5=balcony
#declare nColon = 5;          // nombre de colonne dans une rangee
#declare Prof = 20;           // espace en deux rangees de colonne (uniaue;ent pour type 3 et 4)
#declare CPA = 4;             // Cote du Pilier A
#declare HPA = 2;             // Hauteur du Pilier A                                     
#declare HCA = HPA*4;         // Hauteur du Central A (par dfaut 4*HPA)                       
#declare alp = 0.5;           // espace entre deux texture dans Central
#declare nSOR = 8;            // nombre de SOR dans espColon   
#declare xSOR = 3;            // espace entre axes de symetrie de deux SORs  
#declare Rcol = 1.25;         // rayon de la colonne (par defaut 5CPA/16)
#declare Hcol = 23;           // hauteur de la colonne  (en distance)
#declare THcol = HCA+HPA+23;  // hauteur du haut de la colonne par rapport a y=0
#declare CSOR = 1.40;         // largeur du SOR de la ballustrade  
#declare htWall = 10;         // hauteur du mur
#declare tWM = texture { pigment {White_Marble} finish { phong 0.6 phong_size 250 reflection .15 }}
#declare tBA = texture { pigment {Brown_Agate} finish { phong 1 phong_size 20 reflection .15 }} 
#declare spd1 = 0.5;          // Value N of spd
#declare spd2 = 0.1;          // value E of spd
#declare pWM = pigment {White_Marble} 
#declare fWM = finish {phong 1 phong_size 20 reflection .25}
#local def = 0.0001;    // Valeur par defaut         */    

                             
                             
                             
#macro mColon(typeColon,nColon,Prof,CPA,HPA,HCA,alp,nSOR,xSOR,Rcol,Hcol,CSOR,tWM,tBA)      

// ---------------------       
// A. Creation du Pilier
// ---------------------

#local PilierA= union {
box {<0,0,0> <CPA,HPA/4,CPA> }
box {<CPA/16,HPA/4,CPA/16> <15*CPA/16,HPA/3,15*CPA/16> }
box {<CPA/12,HPA/3,CPA/12> <11*CPA/12,HPA/2.5,11*CPA/12> }
box {<CPA/10,HPA/2.5,CPA/10> <9*CPA/10,HPA/2,9*CPA/10> }
box {<CPA/8,HPA/2,CPA/8> <7*CPA/8,HPA/1.15,7*CPA/8>}
box {<CPA/6,HPA/1.5,CPA/6> <5*CPA/6,HPA,5*CPA/6>}}

#local PilierB = object {PilierA rotate <0,0,180> translate <CPA,HPA+HCA,0>}

#local Central = union {
box {<3*CPA/16,HPA,3*CPA/16> <13*CPA/16,HPA+HCA,13*CPA/16>}
                 union {
box {<(3*CPA/16)-def,HPA+alp,(3*CPA/16)+alp> <(13*CPA/16)+def,HPA+HCA-alp,(13*CPA/16)-alp> } 
box {<(3*CPA/16)+alp,HPA+alp,(3*CPA/16)-def> <(13*CPA/16)-alp,HPA+HCA-alp,(13*CPA/16)+def> } texture {tBA}}}
 
#local MurPilier = box {<0,0,0> <CPA,htWall,CPA>}
 
#local Pilier = union {
union {
object {PilierA}  
object {PilierB}
object {Central}  translate <0,htWall,0>}
object {MurPilier} }

// ---------
// B. Poteau
// ---------

#local Torus1 = union{ 
torus {Rcol+(Rcol/5),Rcol/10 translate <CPA/2,HPA+HCA,CPA/2> }
cone {<CPA/2,HPA+HCA,CPA/2>,Rcol+(Rcol/5) <CPA/2,(HPA+HCA)*1.05,CPA/2>,Rcol+(2*Rcol/5)}
torus {Rcol+(2*Rcol/5),Rcol/10 translate <CPA/2,(HPA+HCA)*1.05,CPA/2>} texture {tBA} translate <0,htWall,0>}  


#local Poteau = union{
cylinder { <CPA/2,HCA+HPA,CPA/2> <CPA/2,HCA+HPA+Hcol,CPA/2> Rcol } 
torus {Rcol+(Rcol/5), Rcol/5 translate <CPA/2,THcol,CPA/2>}
cone { <CPA/2,THcol,CPA/2>,Rcol,<CPA/2,THcol+(Hcol/6),CPA/2>,Rcol*1.6}  
object {PilierA rotate <0,0,180> translate <CPA,THcol+(Hcol/6),0>}
box {<0,THcol+(Hcol/6),0> <CPA,THcol+(Hcol/11),CPA>}texture {tBA} translate <0,htWall,0>}  

 
// --------------
// C. Ballustrade                                                     
// --------------

#local espColon = nSOR*xSOR-2*CPA/6;    

#local SORA = union {
box {<-CSOR/2,HPA,(CPA/4)+(CPA/6)> <CSOR/2,HPA+(HPA/10),CPA-(CPA/4)-(CPA/6)> texture {tWM}}
lathe {linear_spline 6,
<CSOR/1.47,-def*100>, <2*CSOR/7,0>, <CSOR/7,(HCA-HPA)/7>, <CSOR/2.8,(HCA-HPA)/2.5>, <CSOR/4,10*(HCA-HPA)/21>, <CSOR/4.7,(10*(HCA-HPA)/21)+def*100> 
translate <0,HPA,CPA/2>} } 

#local SORB = union {
object {SORA}
torus {CSOR/4,HCA/50 translate <0,(HCA+HPA)/2,CPA/2> }
object {SORA rotate <0,0,180> translate <0,HCA+HPA,0>}translate <CPA-CPA/6,0,0> texture {tBA}}

#local MurBallustrade =
box {<CPA,0,CPA/4> <CPA+espColon,htWall,CPA-(CPA/4)>}

#local RampeA =  union {    
box {<CPA,0,CPA/4> <CPA+espColon,HPA/4,CPA-(CPA/4)>}
box {<15*CPA/16,HPA/4,(5*CPA/16)> <(17*CPA/16)+espColon,HPA/3,CPA-(CPA/4)-(CPA/16)>}
box {<11*CPA/12,HPA/3,(4*CPA/12)> <espColon+CPA+(CPA/12),(HPA/2.5),CPA-(CPA/4)-(CPA/12)>}
box {<9*CPA/10,HPA/2.5,(CPA/4)+(CPA/10)> <espColon+CPA+(CPA/10),HPA/2,CPA-(CPA/4)-(CPA/10)>}
box {<7*CPA/8,HPA/2,(CPA/4)+(CPA/8)> <espColon+CPA+(CPA/8),HPA/1.5,CPA-(CPA/4)-(CPA/8)>}
box {<5*CPA/6,HPA/1.5,(CPA/4)+(CPA/6)> <espColon+CPA+(CPA/6),HPA,CPA-(CPA/4)-(CPA/6)>}} 

#local RampeB = object {RampeA  translate <-CPA-espColon/2,-HPA/2,-CPA/4> rotate <0,0,180> translate <(CPA+espColon)/2+CPA/2,HPA/2+HCA,CPA/4>} 

#local Ballustrade = union {
union {   
   object {SORB } 
   object {RampeA}
   object {RampeB} 
      #if (nSOR>0)
            #local Count=0;    
                #while (Count<nSOR)
                        object {SORB
                        translate x*((Count+1)*xSOR)}
            #local Count=Count+1;
                        #end  translate <0,htWall,0>}
              #end
    object {MurBallustrade}}                     
       
// Haut 

#local Haut1 = difference {
box {<0,39,0> <26,45,CPA>}
cylinder {<13,28.4,-15> <13,28.4,15> 13.8} texture {tBA}}                                         
              
// ----------------------             
// D. Compiler la Colonne
// ----------------------

union{
   #switch (typeColon)
      // Une rangee de pilier
      #case (1)
         union {
            #if (nColon>0)
               #local CountA=0;
                  #while (CountA<nColon)
                     object {Pilier translate x*((CountA+1)*(espColon+CPA))} 
               #local CountA=CountA+1;
                     #end
                     #end 
            #if (nColon>0)
               #local CountB=0;
                  #while (CountB<(nColon-1))  
                     object {Ballustrade translate <espColon+CPA,0,0>}
                     object {Ballustrade translate x*((CountB+1)*(espColon+CPA))}
               #local CountB=CountB+1;
                     #end texture {tWM}}
                     #end
          #break
      // Une rangee de colonne    
      #case (2) 
         union {
             #if (nColon>0)
                #local CountA=0;
                   #while (CountA<nColon)
                         union {
              object {Pilier}
              object {Torus1}
              object {Poteau}
                        translate  x*((CountA+1)*(espColon+CPA))}
                 #local CountA=CountA+1;
                    #end 
                    #end 
              #if (nColon>0)
                  #local CountB=0;
                      #while (CountB<(nColon-1))  
                        object {Ballustrade translate <espColon+CPA,0,0>}
                        object {Ballustrade translate x*((CountB+1)*(espColon+CPA))}
               #local CountB=CountB+1;
                     #end   texture {tWM}}
                     #end
           #break
           // Deux rangees de pilier 
           #case (3)  
#local Brick=superellipsoid { <spd1, spd2> scale <1, .05, 1> pigment {pWM} finish {fWM}}
#local offs = 2.05;
#local xWall=nColon*espColon+(nColon+1)*CPA-(espColon+CPA);             // wall length in x
#local yWall=Prof-(CPA/2);              // wall height in y
#local nBrickz = yWall/offs;  
#local nBrickx = xWall/offs;
#local Row = union { object {Brick translate <espColon+CPA+1,htWall,CPA-(CPA/4)>} 
                       #if (nBrickz>0)
                 #local Count=0;    
                    #while (Count<nBrickz)
               object {Brick translate z*((Count+1)*offs) translate <espColon+CPA+1,htWall,CPA-(CPA/4)>}
                 #local Count=Count+1;
                        #end  }
                        #end  
                        
                         union {  
               box {<espColon+CPA,0,CPA-(CPA/4)-def> <nColon*espColon+(nColon+1)*CPA,htWall,Prof+(CPA/4+def)> } 
               object {Row}
                       #if (nBrickx>0)
               #local Count=0;
                  #while (Count<nBrickx)
               object { Row translate x*((Count+1)*offs)}
               #local Count = Count+1;
               #end }
               #end
                       #if (nColon>0)
               #local CountA=0;
                  #while (CountA<nColon)
                     union {
                     object {Pilier}
                     object {Pilier translate z*Prof}
                     translate x*((CountA+1)*(espColon+CPA))}
               #local CountA=CountA+1;
                     #end
                     #end 
            #if (nColon>0)
               #local CountB=0;
                  #while (CountB<(nColon-1))  
                     object {Ballustrade translate <espColon+CPA,0,0>}  
                     object {Ballustrade translate <espColon+CPA,0,Prof>} 
                     union {
                     object {Ballustrade}  
                     object {Ballustrade translate <0,0,Prof>} 
                     translate x*((CountB+1)*(espColon+CPA))}
               #local CountB=CountB+1;
                    #end texture {tWM}}
                    #end
            #break
            // Deux rangees de colonne
            #case (4) 
 #local Brick=superellipsoid { <spd1, spd2> scale <1, .05, 1> pigment {pWM} finish {fWM}}
#local offs = 2.05;
#local xWall=nColon*espColon+(nColon+1)*CPA-(espColon+CPA);             // wall length in x
#local yWall=Prof-(CPA/2);              // wall height in y
#local nBrickz = yWall/offs;  
#local nBrickx = xWall/offs;
#local Row = union { object {Brick translate <espColon+CPA+1,htWall,CPA-(CPA/4)>} 
                       #if (nBrickz>0)
                 #local Count=0;    
                    #while (Count<nBrickz)
               object {Brick translate z*((Count+1)*offs) translate <espColon+CPA+1,htWall,CPA-(CPA/4)>}
                 #local Count=Count+1;
                        #end  }
                        #end  
                        
                         union {  
               box {<espColon+CPA,0,CPA-(CPA/4)-def> <nColon*espColon+(nColon+1)*CPA,htWall,Prof+(CPA/4+def)> } 
               object {Row}
                       #if (nBrickx>0)
               #local Count=0;
                  #while (Count<nBrickx)
               object { Row translate x*((Count+1)*offs)}
               #local Count = Count+1;
               #end }
               #end
                
             #if (nColon>0)
                #local CountA=0;
                   #while (CountA<nColon)
                      union {
                      union {
              object {Pilier}
              object {Torus1}
              object {Poteau}}
                      union {
              object {Pilier}
              object {Torus1}
              object {Poteau} translate <0,0,Prof>}
                      translate  x*((CountA+1)*(espColon+CPA))}
                 #local CountA=CountA+1;
                    #end  
                    #end 
              #if (nColon>0)
                  #local CountB=0;
                      #while (CountB<(nColon-1))  
                     object {Ballustrade translate <espColon+CPA,0,0>} 
                    // object {Haut1 translate <espColon+CPA,0,0>} 
                     object {Ballustrade translate <espColon+CPA,0,Prof>} 
                     union {
                     object {Ballustrade}  
                     object {Ballustrade translate <0,0,Prof>} 
                     translate x*((CountB+1)*(espColon+CPA))}
                  #local CountB=CountB+1;
                     #end  texture {tWM}} 
                     #end 
                                         #end 
                     #end
                          
