#include "rand.inc"

// create a smooth blobby shape
#declare RadiusVal   = 1.0; // (0 < RadiusVal) outer sphere of influence on other components
#declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density

#declare PigKovrik = pigment {
	bozo
	color_map {
		[0.5 color rgb x]
		[0.5 color rgb z]
	}
}


blob {
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  
  #declare Num = 1200;
  #declare Rad = 2;
  #declare i = 0;
  #declare Rnd = seed( 52515 );
  
  #while( i < Num )
  	#declare Angle = 360 * rand( Rnd );
  	#declare Dist  = Rad - Rand_Exp( Rad, Rnd );
  	sphere {
  		 < Dist * cos( Angle ),   0,    Dist * sin( Angle ) >, RadiusVal/10, StrengthVal
  		 
  		 //pigment { color rgb < rand( Rnd ), rand( Rnd ), rand( Rnd ) > }

			// you can declare it like texture and interior too
			// Note that it has nothing to do with material_map
			  texture {
			    pigment {
			    	bozo
						color_map {
							[0.5 color rgb <0.95, 0.0, 0.1>/2]
							[0.5 color rgb <0.95, 0.79, 0.1>/2]
						}
			    	scale 0.1
			    }
			    finish { diffuse 0.6 specular 0.2 }
			  }
  	}
  	#declare i = i + 1;
  #end
  // [sturm]
  scale <0.8, 0.7, 0.5>
  translate -z*6
  translate y*0.15
}

