// This is a three-layer wood texture.  Renders rather slowly because of
// the transparent layers and the two layers of turbulence, but it looks
// great.  Try other colors of "varnish" for simple variations.  
#declare WoodLight = 
texture {
    pigment {
        wood  turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        color_map { 
            [0.1 rgb <0.88, 0.60, 0.4>]
            [0.9 rgb <0.60, 0.40, 0.3>]
        }
    }
    finish { 
        specular 0.25
        roughness 0.05
        ambient 0.45 
        diffuse 0.33
        #if( Reflection )
        	reflection 0.1
        #end
    }
}
texture {
    pigment {
        wood  turbulence <0.1, 0.5, 1> 
        octaves 5
        lambda 3.25
        scale <0.15, .5, 1>
        color_map { 
            [0.0 rgbt <0.7, 0.6, 0.4, 0.100>]
            [0.1 rgbt <0.8, 0.6, 0.3, 0.500>]
            [0.1 rgbt <0.8, 0.6, 0.3, 0.650>]
            [0.9 rgbt <0.6, 0.4, 0.2, 0.975>]
            [1.0 rgbt <0.6, 0.4, 0.2, 1.000>]
        }
    rotate <5, 10, 5>
    translate -x*2
    }
    finish { 
        specular 0.25 
        roughness 0.0005
        ambient .1 
        diffuse 0.33
    } 
}
// A "coat of varnish" to modify the overall color of the wood
texture {
    pigment { rgbt <0.75, 0.15, 0.0, 0.95> }
    finish { 
        specular 0.25
        roughness 0.01
        ambient 0
        diffuse 0.33
    }
}

// This is a three-layer wood texture.  Renders rather slowly because of
// the transparent layers and the two layers of turbulence, but it looks
// great.  Try other colors of "varnish" for simple variations.  
#declare WoodDark = 
texture {
    pigment {
        wood  turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        color_map { 
            [0.1 rgb <0.88, 0.60, 0.4>]
            [0.9 rgb <0.60, 0.40, 0.3>]
        }
    }
    finish { 
        specular 0.25
        roughness 0.05
        ambient 0.45 
        diffuse 0.33
        #if( Reflection )
        	reflection 0.1
        #end
    }
}
texture {
    pigment {
        wood  turbulence <0.1, 0.5, 1> 
        octaves 5
        lambda 3.25
        scale <0.15, .5, 1>
        color_map { 
            [0.0 rgbt <0.7, 0.6, 0.4, 0.100>]
            [0.1 rgbt <0.8, 0.6, 0.3, 0.500>]
            [0.1 rgbt <0.8, 0.6, 0.3, 0.650>]
            [0.9 rgbt <0.6, 0.4, 0.2, 0.975>]
            [1.0 rgbt <0.6, 0.4, 0.2, 1.000>]
        }
    rotate <5, 10, 5>
    translate -x*2
    }
    finish { 
        specular 0.25 
        roughness 0.0005
        ambient .1 
        diffuse 0.33
    } 
}
// A "coat of varnish" to modify the overall color of the wood
texture {
    pigment { rgbt <0.75, 0.15, 0.0, 0.95>/2 }
    finish { 
        specular 0.25
        roughness 0.01
        ambient 0.0
        diffuse 0.33
    }
}


// This is a three-layer wood texture.  Renders rather slowly because of
// the transparent layers and the two layers of turbulence, but it looks
// great.  Try other colors of "varnish" for simple variations.  
#declare WoodVeryDark = 
texture {
    pigment {
        wood  turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        color_map { 
            [0.1 rgb <0.88, 0.60, 0.4>]
            [0.9 rgb <0.60, 0.40, 0.3>]
        }
    }
    finish { 
        specular 0.25
        roughness 0.05
        ambient 0.45 
        diffuse 0.33
        #if( Reflection )
        	reflection 0.1
        #end
    }
}
texture {
    pigment {
        wood  turbulence <0.1, 0.5, 1> 
        octaves 5
        lambda 3.25
        scale <0.15, .5, 1>
        color_map { 
            [0.0 rgbt <0.7, 0.6, 0.4, 0.100>]
            [0.1 rgbt <0.8, 0.6, 0.3, 0.500>]
            [0.1 rgbt <0.8, 0.6, 0.3, 0.650>]
            [0.9 rgbt <0.6, 0.4, 0.2, 0.975>]
            [1.0 rgbt <0.6, 0.4, 0.2, 1.000>]
        }
    rotate <5, 10, 5>
    translate -x*2
    }
    finish { 
        specular 0.25 
        roughness 0.0005
        ambient .1 
        diffuse 0.33
    } 
}
// A "coat of varnish" to modify the overall color of the wood
texture {
    pigment { rgbt <0.75, 0.15, 0.0, 0.95>/4 }
    finish { 
        specular 0.25
        roughness 0.01
        ambient 0.0
        diffuse 0.33
    }
}

// This is a three-layer wood texture.  Renders rather slowly because of
// the transparent layers and the two layers of turbulence, but it looks
// great.  Try other colors of "varnish" for simple variations.  
#declare WoodNorm = 
texture {
    pigment {
        wood  turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        color_map { 
            [0.1 rgb <0.88, 0.60, 0.4>]
            [0.9 rgb <0.60, 0.40, 0.3>]
        }
    }
    finish { 
        specular 0.25
        roughness 0.05
        ambient 0.45 
        diffuse 0.33
        #if( Reflection )
        	reflection 0.1
        #end
    }
}
texture {
    pigment {
        wood  turbulence <0.1, 0.5, 1> 
        octaves 5
        lambda 3.25
        scale <0.15, .5, 1>
        color_map { 
            [0.0 rgbt <0.7, 0.6, 0.4, 0.100>]
            [0.1 rgbt <0.8, 0.6, 0.3, 0.500>]
            [0.1 rgbt <0.8, 0.6, 0.3, 0.650>]
            [0.9 rgbt <0.6, 0.4, 0.2, 0.975>]
            [1.0 rgbt <0.6, 0.4, 0.2, 1.000>]
        }
    rotate <5, 10, 5>
    translate -x*2
    }
    finish { 
        specular 0.25 
        roughness 0.0005
        ambient .1 
        diffuse 0.33
    } 
}
// A "coat of varnish" to modify the overall color of the wood
texture {
    pigment { rgbt <0.75, 0.15, 0.0, 0.95>/1.5 }
    finish { 
        specular 0.25
        roughness 0.01
        ambient 0.0
        diffuse 0.33
    }
}


#macro MakeParket( Width, Length, THick, BoxWidth, MinBoxLength, MaxBoxLength )
	#local Rnd = seed(777);
	#local clrLight = color rgb <0.7, 0.5, 0.0>;
	#local clrDark  = color rgb <0.4, 0.3, 0.0>;
	#local WidthPos = 0;
	#local DeltaBoxLength = MaxBoxLength - MinBoxLength;
  
  union {
	#while( WidthPos <= Width )
		#local LengthPos = ( MinBoxLength + MaxBoxLength ) / 2 * rand( Rnd );
		
		#while( LengthPos <= Length )
			#local rndValue = rand( Rnd );
			//#local clrCurr = rndValue * clrLight + ( 1 - rndValue ) * clrDark;
			#local CurrBoxLength = MinBoxLength + DeltaBoxLength * rand( Rnd );
			
			box {
				<LengthPos, 0, WidthPos>
				<LengthPos + CurrBoxLength, THick, WidthPos + BoxWidth>
				texture {
							#if( rndValue < 0.33 )
								WoodLight
							#else #if( rndValue < 0.66 )
								WoodNorm
							#else
								WoodDark
							#end #end

						rotate y*90
						scale 0.4
				}
			}
			#local LengthPos = LengthPos + CurrBoxLength;
		#end
		#local WidthPos = WidthPos + BoxWidth;
	#end
	
		translate <-Length / 2, 0, -Width / 2>
	}
#end


// MakeParket( 10, 10, 0.05, 0.15, 0.3, 0.5 )