// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
#include "transforms.inc"

#include "functions.inc"  // internal functions usable in user defined functions
#include "textures.inc"
#include "woods.inc"

#declare DrawPlintus	= 1;
#declare DrawParket		= 1;
#declare DrawTable		= 1;
#declare DrawTree			= 1;
#declare DrawGrass		= 1;
#declare DrawKovrik		= 1;
#declare DrawHouse		= 1;
#declare DrawFundament= 1;
#declare DrawThings		= 1;
#declare WarpCamera		= 1;
#declare Environment	= 1;
#declare Reflection		= 1;
#declare Radiosity		= 1;

#include "parket.inc"
#include "table.inc"

#if( DrawGrass )
	#include "grass/grass_patch.pov"
#end // Grass

#if( DrawKovrik )
	#include "kovrik.inc"
#end // Kovrik


global_settings {
  assumed_gamma 0.75
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
    #end
  }
}

#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
  }
}

// ----------------------------------------
// Main
#declare CameraPos = <14.0, 5.8, -22.0>;
#declare CameraLookTo = <0.0, 3.0,  0.0>;
camera {
  location  CameraPos
  direction 1.5*z
  right     x*image_width/image_height
  look_at   CameraLookTo
  #if( WarpCamera )
  normal {
	  bumps 0.05
	  scale 0.15
  }
  #end
}

#if( WarpCamera )
#declare fn_Grain = function {
	pigment {
		granite
		color_map {
			[0 color rgb 0]
			[1 color rgb 1]
		}
	}
}


isosurface {
  function { -z + fn_Grain(x*200, y*200, z*200).gray*0.0001 }          // function (can also contain declared functions
  contained_by { box { <-2,-2, -0.5>, <2, 2, 0.5> } }  // container shape
  accuracy 0.001                      // accuracy of calculation [0.001]
  max_gradient 4                      // maximum gradient the function can have [1.1]
                             // remove visible container surface
  
  material {
  	texture {
	  	pigment {
	  		color rgbt 1
	  	}
  	}
	  // describes inside of a shape (similar to texture, but for inside, not surface)
	  interior {
	    ior 1.15              // index of refraction
	    fade_power 1001       // values larger than 1000 give realistic exponential attenuation
	    fade_distance 3       // distance where light reaches half intensity
	    fade_color <0, .3, 0> // color for fading
	  }
  }

  
  Reorient_Trans( z, CameraPos - CameraLookTo )
	
	translate CameraLookTo + (CameraPos - CameraLookTo)*0.99
}

#end // WarpCamera
/*
// Karniz
camera {
  location  <12.0, 5.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 3.0,  4.0>
}
*/


#if( Environment )
 sphere {
		0, 1
		texture {
			pigment { color rgb 0 }
			finish {
				reflection 0.6
			}
		}
		
		scale 300
	}
#else
	sky_sphere {
	  pigment {
	    gradient y
	    color_map {
	      [0.0 rgb <0.6,0.7,1.0>]
	      [0.7 rgb <0.0,0.1,0.8>]
	    }
	  }
	}

	plane {
	  y, -1
	  pigment { color rgb <0.7,0.5,0.3> }
	}

#end // Environment

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>/3  // light's color
  translate <0, 7, 0>
}

// ----------------------------------------


#declare Brick = pigment {
  brick      
  color Gray,          // color of mortar
  color Red            // color of brick
  brick_size <2,1,1>   // size of brick    (optional)
  mortar     0.2       // width of mortar  (optional)

}

#declare texWallpaper = texture {
   pigment {
      image_map {
         jpeg
         "wallpapers/4803-6_my.jpg"
         map_type 0
      }            
      //scale 2
   }

   finish {
      ambient rgb <0.027451, 0.027451, 0.027451>
   }
}

#declare texBricks = texture {
   pigment {
      image_map {
         jpeg
         "wallpapers/9044-2.jpg"
         map_type 0
      }
   }

   finish {
      ambient rgb <0.027451, 0.027451, 0.027451>
   }
}


#declare WallpaperBox = union {
	box {
		<-5, 0, 5>
		< 5, 7,  5.01>
		texture {
			texWallpaper
		}
	}
	box {
		<-5, 0, -5.01>
		< 5, 7,  -5>
		texture {
			texWallpaper
		}
	}
	box {
		<5, 0, -5>
		< 5.01, 7,  5>		
		texture {
			texWallpaper
			rotate y*90
		}
	}
	box {
		<-5.01, 0, -5>
		<-5, 7,  5>
		texture {
			texWallpaper
			rotate y*90
		}
	}
}

#declare fn_Pigm=function {
	pigment {
		agate
		color_map {
			[0 color rgb 0]
			[1 color rgb 1]
		}
	}
}


#declare HouseBox = difference {
	union {
		object { WallpaperBox }
		box { <-5, 0, -5> <5, 7, 5> }
	}
	isosurface {
		function { y - fn_Pigm(x/4, y/4, z/4).gray }
		contained_by { box { <-6, -2, -6>, <6, 2, 6> } }
		open
		texture {
			pigment {
				color rgb <0.5, 0.5, 0.5>
			}
			normal {
				bumps 0.3
			}
		}
		rotate x*180
		translate y*7
	}
}

#declare Plintus = 
// create a isosurface object - the equipotential surface
// of a 3D math function f(x, y, z)
#declare fn_X = function(x,y,z) { x*x + y*y - 1 }  // cylinder function
isosurface {
  function { (x+y) + 0.3 * sin( x*6 ) }          // function (can also contain declared functions
  //function { fn_X(x, y, z) }        // alternative declared function
  contained_by { box { -1, 1 } }  // container shape
  //threshold 0.0                     // optional threshold value for isosurface [0.0]
  accuracy 0.001                      // accuracy of calculation [0.001]
  max_gradient 4                      // maximum gradient the function can have [1.1]
  
  texture { WoodVeryDark }
}

#declare House = union {
	difference {
		//  
		object {
			HouseBox
		}

		//  	
		box {
			<-4.8, 0.07, -4.8>
			< 4.8, 7.1,  4.8>
			
			texture {
				texBricks
				rotate y*90
			}
	
		}
		
		// 
		box {
			<-4.7, 0.055, -4.7>
			< 4.7, 0.08,  4.7>
			
			pigment {
			    bozo
			    color_map {
			        [0 color rgb<0.27, 0.16, 0.0>/2]
			        [0.45 color rgb<0.27, 0.16, 0.0>/2]
			        [0.55 color rgb<0.42, 0.25, 0.01>/2]
			        [1   color rgb<0.42, 0.25, 0.01>/2]
			    }
			    scale 0.5
			}
	
		}
		//  
		box {
			<-1, 0.1, -4.75>
			<1, 5, -5.1>
			texture {
				texBricks
				rotate y*90
			}
		}

		// Dal'nee okno
		box {
			<-4.75, 2.5, -1>
			<-5.1, 5, 1>
			texture {
				texBricks
				rotate y*90
			}
		}
		
		// Blizhnee okno
		box {
			<4.75, 2.5, -1>
			<5.1, 5, 1>
			texture {
				texBricks
				rotate y*90
			}
		}
	}

	// kosiak
	difference {
		box {
			<-1.2, 0.1, -4.75>
			<1.2, 5.2, -5.1>
		}
		//  
		box {
			<-0.95, 0.1, -4.7>
			<0.95, 5, -5.2>
		}
		texture {
			WoodDark
			scale 0.3
			rotate x*90
		}
	}
	// 
	union {
		difference {
			box {
				<-1.2, 0.1, 0>
				<1.2, 5.2, -0.2>
			}
			box {
				<-1.1, 0.2, 0.01>
				<1.1, 5.1, -0.21>
			}
			texture {
				WoodVeryDark
				scale 0.3
				rotate x*90
			}
		}
		box {
			<-1.1, 0.2, 0>
			<1.1, 5.1, -0.2>
			texture {
				WoodDark
					scale 0.3
					rotate x*90
			}
		}
		// 
		union{
			cylinder {
				<0, 0, 0.1>, 0, 0.05
			}
			sphere {
				<0, 0, 0.1>, 0.1
			}
			texture {
				Aluminum
			}
			scale 2
			translate <0.8, 2.5, 0>
		}
		text {
		  ttf             // font type (only TrueType format for now)
		  "diploma.ttf",  // Microsoft Windows-format TrueType font file name
		  "13",      // the string to create
		  -0.2,              // the extrusion depth
		  0               // inter-character spacing
		  rotate y*180
		  scale x*1.5
		  texture {
				Aluminum
		  }
		  translate <0.5,4,0>
		}
		translate x*1.2
		rotate y*120
		translate <-1.2, 0, -5.1>
	}
	
	// Dali's authoportret
	union {
		box {
			-1,1
			
		   pigment {
		      image_map {
		         jpeg
		         "wallpapers/dali.jpg"
		         map_type 0
		      }            
		      rotate -x*90
		      scale 2
		      translate <1, 0, 1>
		   }
			scale <0.605, 0.001, 0.768>
		}
		box {
			-1.2,1.2
			scale <0.605, 0.001, 0.768>
			translate y*0.01
		}
		rotate x*90
		//rotate -z*25
		translate <3, 4, -5.02>
	}
	

#declare Okno = union {
		// rama
		difference {
			box {
				<4.75, 2.5, -1>
				<5.1, 5, 1>
			}
			box {
				<4.7, 2.7, -0.9>
				<5.2, 4.9, 0.9>
			}
			texture {
				//Cork
				DMFWood6
				scale 0.1
			}
		}
		difference {
			box {
				<4.85, 2.7, -0.9>
				<5.0, 4.9, 0.9>
			}
			box {
				<4.7, 2.75, -0.85>
				<5.1, 4.85, 0.85>
			}
			texture {
				//Cork
				DMFWood6
				scale 0.1
			}
		}
		// Steklo
		box {
			<4.9, 2.7, -0.9>
			<4.91, 4.9, 0.9>

			texture {
				NBglass
			}
		}
		// podokonnik
		union {
			box {
				<4.7, 2.65, -1>
				<5.4, 2.5, 1>
			}
			cylinder {
				<5.4, 2.575, -1>, <5.4, 2.575, 1>, 2.65-2.575
			}
			texture {
				DMFWood6
				scale 0.1
			}
		}

		// karniz
		// trubka dlja shtori
		cylinder {
			<5.3, 5.1, -1.3>, <5.3, 5.1, 1.3>, 0.05
			texture {
				Aluminum
			}
		}
		// kronshtein 1
		union{
			cylinder {
				<5.3, 5.1, -1.15>, <5.3, 5.1, -1.14>, 0.1
			}
			box {
				<5.3, 5.2, -1.15>
				<5.0, 5.0, -1.14>
			}
			texture {
				Aluminum
			}
		}

		// kronshtein 2
		union{
			cylinder {
				<5.3, 5.1, 1.15>, <5.3, 5.1, 1.14>, 0.1
			}
			box {
				<5.3, 5.2, 1.15>
				<5.0, 5.0, 1.14>
			}
			texture {
				Aluminum
			}
		}
		// Zanaveska
		box {
			<5.299, 2.65, -1.1>
			<5.3, 5, 1.1>

			pigment {
				granite
				color_map {
					[0.50 color rgbt <1,1,1,0.5>]
					[0.55 color rgbt <1,1,1,1>]
				}
				scale 0.05
				scale y*6
			}
		}

	}

object{ Okno }
object{ Okno rotate y*180 }

#if( DrawPlintus )
	intersection {	
		difference {
			union {
				object {
					Plintus           
				  scale < 0.1, 0.1, 5 >
				  translate <5.1, 0.2, 0>
				}
				object {
					Plintus           
				  scale < 0.1, 0.1, 5 >
				  rotate y*90
				  translate <0, 0.2, -5.1>
				}
			}
			
			//  
			box {
				<-1, -0.1, -4.8>
				<1, 5, -5.3>
			}
		}
		
		// 
		box {
			-sqrt(50)
			sqrt(50)
			rotate y*45
			texture { WoodVeryDark }
		}		
	}
#end // DrawPlintus

#if( DrawParket )
	object {
		MakeParket( 14, 14, 0.05, 0.15, 0.3, 0.5 )
		rotate y*45
	}
#end // DrawParket
}


#declare Fundament = intersection {
	
	isosurface {
		function { y - fn_Pigm(x/4, y/4, z/4).gray }
		contained_by { box { <-9, -2, -9>, <9, 2, 9> } }
		rotate x*180
		rotate y*45
	}

#declare Rnd = seed( 7367 );
#declare FundPoints = array[100][2];
#declare num = 0;
#declare zpos = -7;

#while( zpos < 7 )
	#declare FundPoints[ num ][ 0 ] = rand( Rnd ) - 0.5;
	#declare FundPoints[ num ][ 1 ] = zpos;
	#declare zpos = zpos + 0.3 + 0.3 * rand( Rnd );
	#declare num = num + 1;
#end
			
			
#declare Grad1 = pigment {
				  gradient y
				  color_map {
					  [0 color rgb <1, 1, 1>*0.5]
					  [1 color rgb <0.1, 0.6, 0.1>*0.5]
				  }
				  scale 0.4
			  }
#declare Grad2 = pigment {
				  gradient y
				  color_map {
					  [0 color rgb <1, 1, 1>*0.5]
					  [1 color rgb <1, 0.4, 0.3>*0.5]
				  }
				  scale 0.4
			  }
                                           
// extrude a closed 2-D shape along an axis
prism {                                
  linear_sweep  // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
  -0.1,         // height 1
   -2.5,         // height 2
  num+4,           // number of points
  // (--- the <u,v> points ---)
  < -7, -7>, < 7, -7>//, < 7.5, -6>, < 6.5, -5>, < 7.2, -4.5>, < 7.0, -3.5>
  #declare i = 0;
  #while( i < num )
  	,< 7 + FundPoints[ i ][ 0 ], FundPoints[ i ][ 1 ]>
  	#declare i = i + 1;
  #end
  , < 7, 7>, < -7, 7>

  texture {
	  pigment {
		  leopard
		  turbulence <0.5, 0.2, 0.5>
		  pigment_map {
			  [0.1 color rgb <1, 1, 1>*0.5]
			  [0.25 Grad1]
			  [0.3 Grad2]
			  [0.55 Grad1]
		  }
		  scale <2, 1, 2>
	  }
	  normal {
		  bumps 1.4
		  scale y*0.02
		  scale 0.4
	  }
	  scale <0.05, 2, 0.05>
  }
  
  rotate y*45
}
}

#if( DrawTable )
object {
	Table

	translate x*(5 + 1.5)
	translate -z*2
}
#end


#if( DrawHouse )
	object { House }
#end // DrawHouse

#if( DrawFundament )
	object { Fundament }
#end // DrawFundament

#if( DrawTree )
	#include "tree/MYTREE.inc"
	#include "tree/TOMTREE.inc"

	object {
		TREE
		scale 10
		translate <0, 2.5, 1>
	}
#end // Tree


#if( DrawThings )
// 

#declare Num = 300;
#declare minext = <-50, -20, -50>;
#declare maxext = < 50,  40,  50>;

#declare errminext = <-10, -10, -10>;
#declare errmaxext = < 10,  10,  10>;

#declare Rnd1 = seed(6546);

#while( Num > 0 )
	#declare Point = < minext.x + rand( Rnd1 ) * (maxext.x - minext.x),
	                   minext.y + rand( Rnd1 ) * (maxext.y - minext.y),
	                   minext.z + rand( Rnd1 ) * (maxext.z - minext.z) >;
	#declare Type = rand( Rnd1 );

	#if( (Point.x < errminext.x) + (Point.y < errminext.y) + (Point.z < errminext.z) +
	     (Point.x > errmaxext.x) + (Point.y > errmaxext.y) + (Point.z > errmaxext.z) )	
	     
	  #if( Type < 0.33 )
	    #declare Obj = sphere {
	    	0, 1
	    }
	  #else
	  	#if( Type < 0.66 )
	  		#declare Obj = box {
	  			-1, 1
	  		}
	  	#else
	  		#declare Obj = cylinder {
	  			-1, 1, 0.5
	  		}
	  	#end
	  #end
	  
	  object {
	  	Obj
	  	
	  	pigment {
	  		color rgb 0.5 + < rand( Rnd1 ), rand( Rnd1 ), rand( Rnd1 ) >/2
	  	}
	  	
	  	scale <2 * rand( Rnd1 ), 2 * rand( Rnd1 ), 2 * rand( Rnd1 )>
	  	rotate <180 * rand( Rnd1 ), 180 * rand( Rnd1 ), 180 * rand( Rnd1 )>
	  	translate Point
	  }

		#declare Num = Num - 1;
	#end
#end

#end // DrawThings