// Persistence Of Vision raytracer version 3.5 
// Awakening - Scene file 
// 2003 by Ron Gow
   
#version 3.5;

#include "colors.inc"
#include "transforms.inc"

#declare RAD = 0;
#declare TREES = 0;

#declare Sun_Loc = <500,270,160>;
#declare Cam_Loc = <-15,20,-15>;
#declare Look_At = <20,23,20>;

camera { 
    location Cam_Loc
    look_at Look_At
    angle 80
} 

global_settings{
	adc_bailout 0.0039
	assumed_gamma 1
	hf_gray_16 0
	irid_wavelength rgb <68,46,36>/255
	max_intersections 64
	max_trace_level 15
	number_of_waves 10
	#if(RAD)  
	    radiosity{ 
    		pretrace_start 0.08
            pretrace_end   0.04
            count 250
            nearest_count 7
            error_bound 0.8
            recursion_limit 2
            low_error_factor 0.9
            gray_threshold 0
            minimum_reuse 0.015
            brightness 0.55
            adc_bailout 0.01/2
    	}
	#end  
} 

light_source { Sun_Loc rgb 1 fade_power 7 fade_distance 850 parallel point_at <0,30,0>}

// *****************************************************

#declare P_Cloud1 = pigment {
    bozo
    color_map { 
        [ 0.0  rgb <1.03,.941,1.13> ]
        [ .15  rgb <.933,.941,.732> ]
        [ .35  rgb <.972,.772,.384> ]
        [ 1.0  rgbf <1,.1,.1,1>]
    }
    turbulence 0.63  octaves 8  omega 0.67 lambda 2
    scale <6, .8, 5>
}

#declare P_Cloud2 = pigment {
    ripples
    color_map {
        [0.20 rgb <.167,.510,.680> ]
        [0.50 rgb <.930,.930,.930> ]
        [1.00 rgb <.700,.700,.700> ]
    }
    turbulence 0.9  lambda 7.4 omega .35
    scale <0.41, 0.185,.75>
}

// *****************************************************

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.0 rgb <.32, .60, .74> ] 
            [0.25 P_Cloud1 scale .9 rotate z*5]
            [0.78 P_Cloud2 scale .7 rotate z*11]
            [1.00 rgb <.32, .60, .74> ] 
        }
    }
    scale <1,2.2,1>
    translate -y*.35
}

// *****************************************************

fog {
    distance 1000
    color rgb <.675,.730,.650>
    fog_type 2
    fog_offset 18.5
    fog_alt 22.5
}

// *****************************************************

#declare Ft = 1;
#declare In = Ft/12;
#declare Yd = Ft*3;

// ************* Water *******************
#declare T_Water1 = texture {
    pigment { rgbf <.070,.420,.537, .65>+.25 }
    finish {
        ambient 0 diffuse .15 
        reflection {.05 .65 fresnel on }
    }
    normal { bozo .85 turbulence 1 scale .75 }
}

#declare T_Water2 = texture {
    pigment { rgbf <.030,.200,.400, .5>+.25 }
    finish {
        ambient 0 diffuse .15 
        reflection {.2 .4 fresnel on }
    }
    normal { agate .4 turbulence 2 scale .75 }
}

plane { y 0  texture { T_Water1 } 
    interior { ior 1.33 }
}

plane { y 0  texture { T_Water1 } 
    interior { ior 1.20 }
    translate -y*2
} 
plane { y 0  texture { T_Water1 scale <1.25,2,1.25> } 
    interior { ior 1.15 }
    translate -y*5
} 
plane { y 0  texture { T_Water1 scale 2 } 
    interior { ior 1 }
    translate -y*8
}

// ************** Arch ******************

#declare T_Stones = texture {
    pigment { granite
        color_map {
            [ 0.0 rgb <.735,.770,.775> ]
            [ 0.1 rgb <.650,.640,.610> ]
            [ 0.5 rgb <.860,.890,.905> ]
            [ 0.9 rgb <.470,.495,.555> ]
            [ 1.0 rgb <.810,.740,.750> ]
        }
        turbulence .7 octaves 4
    }
    normal { granite .25 scale .035 turbulence .5 }
    finish { ambient 0 phong .3 phong_size 45 }
}

#declare AW = 4*Ft;
#declare AH = 4.5*Ft;
#declare SD = 6*In;
    
#declare Sill_Stone = superellipsoid { <.1, .1> scale <.25.25,.45> }

#declare Sill = union {
    #declare cnt=0;
    #while(cnt<AH)
        object { Sill_Stone translate <AW/2,cnt,0> 
            texture { T_Stones translate x*cnt*.75 } 
        }
        object { Sill_Stone translate <-AW/2,cnt,0> 
            texture { T_Stones translate -y*cnt*.7 } 
        }
        #declare cnt = cnt+SD;
   #end
   #declare cnt=0;
    #while(cnt<195)
        object { Sill_Stone translate <AW/2,0,0> 
            rotate z*cnt translate y*AH 
            texture { T_Stones rotate -cnt*19 } 
        }
        #declare cnt = cnt+15;
   #end
}

#declare Portal = light_group {
    light_source { <-3,5,8> rgb 1 }
    object { Sill }
    global_lights on
}
object { Portal rotate y*40 translate <-13.560,18,-13.72> }
 

// ************* Piano ******************

#include "piano.inc"
#declare piano = light_group { 
    light_source { <5,5,-6> rgb 1 shadowless }
    object { Piano  }
    global_lights on
}
object { piano scale <6.2,6.2,6.2> rotate -y*16 translate <54,-.75,67> no_shadow }

// ************** Islands ******************
#declare Isl1_Pos = <2.45,-6.5,55>;
#declare Isl2_Pos = <110,-6.5,20>;
#declare Isl3_Pos = <205,-6.5,95>;
#declare Isl4_Pos = <185,-6.5,305>;
#declare Isl5_Pos = <30,-6.5,255>;

#include "islands.inc" 

#declare Islands = union {
    object { Island 
        rotate -y*160 scale <25,10,29> 
        texture { groundtex }
        translate Isl1_Pos
    }
   
    light_group {
        light_source { Isl1_Pos+<35.05,17.8,43.5> rgb .4 shadowless }
        object { Island2 
            scale <33,10,30> rotate -y*115
            texture { groundtex  }
            translate Isl2_Pos
        }
        global_lights
    }
    
    object { Island1 
        scale <35,10,35> rotate y*135
        texture { groundtex }
        translate Isl3_Pos
    }
}

object { Islands }

object { Island2 
    scale <45,10,45>
    texture { groundtex }
    translate Isl4_Pos
}

object { Island2 
    scale <35,10,35> rotate y*115
    texture { groundtex }
    translate Isl5_Pos
}

// **************  Stone Path  ***************

#declare Path = spline {
    cubic_spline
   -1, <-14,0,23>, 00, <-11,0,22>, 01, <-02,0,18>, 02, <05,0,17>, 03, <15.5,0,16>, 
    04, <021,0,09>, 05, <031,0,-1>, 06, <042,0,-3>, 07, <056,0,07>, 08, <070,0,13>, 
    09, <082,0,09>, 10, <095,0,11>, 11, <104,0,16>, 12, <117,0,15>,
    13, <120,0,27>, 14, <132,0,35>, 15, <143,0,43>, 
    16, <144,0,55>, 17, <146,0,69>, 18, <153,0,81>, 19, <163,0,78>, 20, <173,0,84>, 
    21, <189,0,87>, 22, <207,0,88>, 23, <211,0,108>, 24, <215,0,118>, 25, <210,0,130> 
}

#declare P_Stone = union {
    superellipsoid { <.4,.5> scale <1,.5,1> }
    superellipsoid { <.2,.5> scale <1,1.45,1> translate -y*.95 }   
    scale <1,1,1.5> 
}

#declare P_Inc = .5;
#declare P_Len = 22+P_Inc;
#declare cnt = 0;

#while (cnt<P_Len)
    #declare S_Hgt = -.05;
    #declare I1 = trace (Islands,Path(cnt)+y*4,<0,-1,0>); 
    #if( I1.y > S_Hgt )
        #declare S_Hgt = I1.y ;
    #end 
    object { P_Stone        
        Reorient_Trans( +x, Path(cnt+P_Inc)-Path(cnt-P_Inc) )
        translate Path(cnt)+y*S_Hgt
        texture { T_Stones translate x*cnt*.75 }
    }
    #declare cnt = cnt+P_Inc;
#end 

// *************** Trees *********************
#if(TREES)
#include ".\includes\PALM.inc"
#include ".\includes\TOMTREEm.inc"
#declare Palm_Tree = object { TREE }

#include ".\includes\RG_Willow2.inc"
#include ".\includes\TOMTREEm.inc"
#declare Deco_Tree = object { TREE }

#include ".\includes\RG_Bush.inc"
#include ".\includes\TOMTREEm.inc"
#declare Bush = object { TREE }

#include ".\includes\RG_Bush1.inc"
#include ".\includes\TOMTREEm.inc"
#declare Bush1 = object { TREE }

#include ".\includes\RG_Bush2.inc"
#include ".\includes\TOMTREEm.inc"
#declare Bush2 = object { TREE }

light_group {
    light_source { <110,35,150> White shadowless }
    object { Palm_Tree rotate <0,-5,2> scale <40,52,40> translate Isl5_Pos+<-5,10,-4> }
    object { Palm_Tree rotate <5,105,2> scale <50,50,50> translate Isl5_Pos+<22,10,-12> }
    object { Palm_Tree rotate <2,-65,4> scale <45,55,45> translate Isl4_Pos+<-15,10,46> }
    object { Palm_Tree rotate <3,145,-5> scale <55,60,55> translate Isl4_Pos+<5,9,10> }
    global_lights
}

light_group {
    light_source { <-85,80,20> White shadowless }
    object { Deco_Tree rotate <0,100,-6> scale <28,38,28> translate <21,10.15,-8> }
    object { Deco_Tree rotate <0,65,10> rotate x*7 scale <30,60,30> translate <-25,10.15,-18> }
    object { Bush scale 6 rotate -y*75 translate <26,10,-4> }
    object { Bush1 scale 7 rotate -y*15 translate <-24,10,11> }
    object { Bush2 scale 6 rotate -y*75 translate <-32.5,10,2.0> }
    global_lights
    translate Isl2_Pos
}

light_group {
    light_source { <-55,75,-55> White shadowless } 
    object { Bush scale 8.5 rotate y*105 translate <-20,10,25> }
    object { Bush1 scale 7 rotate -y*35 translate <-25,10,33> }
    object { Bush1 scale 9 rotate y*35 translate <0,10,0> }
    object { Bush scale 10 rotate -y*15 translate <-5,10,-25> } 
    object { Bush scale 8 rotate y*55 translate <10,10,-29> }
    global_lights
    translate Isl3_Pos
}

light_group {
    light_source { <19,75,10> White shadowless }
    object { Bush1 scale 8 rotate -y*35 translate <15.05,3.5,24> }
    object { Bush2 scale <6,7,6> rotate -y*25 translate <25.15,3.5,22> } 
    object { Bush2 scale <5,6.5,5> rotate y*15 translate <-6,3.5,22.85> }
    global_lights
}
#end
// ******************  Blimps  ********************

#include "airship.inc"
light_group {
    light_source { <40,1,5> White }
    object { Blimp(1357) scale 7 no_shadow  }  
    rotate <5,99,0>
    translate <155,105,135>
    global_lights 
}

light_group {
    light_source { <40,-5,-12> White }
    object { Blimp(1462)scale 7 no_shadow  }
    rotate <-4,90,0> 
    translate <295,195,100>
    global_lights
}

// *****************  Cabernet  *******************

#include "vino.inc"
object { Goblet scale 90  translate <190,3.5,105> }
object { Goblet scale 90  translate <110,3.5,25> }

light_group { 
    light_source { <-10,7.5,-8> White }
    object { BottleC rotate <84,-65,0> }
    scale 195 
    translate <400,0,65>
    global_lights 
}

// ************  Gazebo & Furniture  ***************

#declare G_Set = <4.55,3.5,41>;
#include "gazebo.inc"
light_group {
    light_source { <.80,15,-8> White }
    light_source { <-10,1.5,-12> rgb <.30,.25,.20> shadowless }
    object { Gazebo }
    global_lights
    scale 3.5 
    translate G_Set 
}

#include "chair.inc"
#include "table.inc"
#include "candle.inc"
#include "tableware.inc"

light_group {
    light_source { <-3,7,-4> White shadowless }
    union {
        object { Chair rotate <0,-50,0> translate <2.90,0,0> }
        object { Chair rotate <0,-150,0> translate <-2.75,0,.5> }
        object { Table }
        object { Candles rotate y*65 translate y*31*In }
        object { Setting translate <1.9,31*In,0> }
        object { Setting rotate y*180 translate <-1.9,31*In,0> }
    }
    scale 3
    rotate <0,17,0> 
    translate G_Set + <-.05,3.5,0>
    global_lights 
}


// ****************  Butterfly  *******************

#include "butterfly.inc"
light_group {
    light_source { <-1,1,-.65> White }
    object { BFly 
        scale .6 
        rotate <-10,0,30> 
        rotate <0,50,0>
        no_shadow 
    }
    global_lights
    translate Cam_Loc+<2.75,-1.125,.375> 
}
