// Persistence Of Vision raytracer version 3.5 
// Butterfly include file
// Ron Gow 2003

#version 3.5;

#local T_B_Wing = texture {
    pigment {
        image_map {
            //png "bflywing.png"
            jpeg "bflywing.jpg"
            once
        }
    }
    finish { diffuse 1.5 }
}

#local P_GrayStripe = pigment { 
    gradient y
    color_map { 
        [ 0.0 rgb <.15,.15,.05> ]
        [ 0.2 rgb <.35,.40,.45> ]
        [ 0.6 rgb <.15,.15,.05> ]
        [ 0.9 rgb <.25,.40,.45> ]
        [ 1.0 rgb <.15,.15,.05> ]
    }
}

#local Wing = height_field {
    //png "bflywing.png"
    jpeg "bflywing.jpg"
    smooth
    water_level .1
    scale <1,.01,1>
    rotate -x*90
    texture { T_B_Wing }
}
    

#local Body = sphere_sweep {
    cubic_spline 7
    <0,0,.15> .05, <0,.1,.1> .05, <0,.35,.0> .1, <0,.5,.0> .08,
    <0,.7,0> .13, <0,.95,.02> .13, <0,1.1,.02> .075
    pigment { P_GrayStripe scale .5}
    scale .45
}


#declare BFly = union {
    object { Body translate y*.35}
    object { Wing rotate y*30 }
    object { Wing rotate y*150 }
    rotate x*90
}

