#include "colors.inc" 
#include "textures.inc"
#include "woods.inc"
//#include "functions.inc" 


#local t_tex = texture { T_Wood24 // 4,12,14,18,24,28
    finish { reflection .05 specular .2 phong .35 ambient 0}
    scale .33
} 

#local s_orn = lathe {
	cubic_spline
	15,
	<-.005,1.005>, <0.000,1.000>, <0.040,1.000>,
	<0.085,0.950>, <0.040,0.900>, <0.060,0.875>,
	<0.040,0.810>, <0.080,0.500>, <0.040,0.190>,
	<0.060,0.125>, <0.040,0.100>, <0.085,0.050>,
	<0.040,0.000>, <0.000,0.000>, <-.005,-.005>
    texture { t_tex scale <.13,.5,.10> rotate x*89 }
    scale <.8,1,.8>
    translate -y*.5
}

#local l_orn = lathe {
	cubic_spline
	15,
	<-.005,1.005>, <0.000,1.000>, <0.040,1.000>,
	<0.055,0.950>, <0.040,0.900>, <0.060,0.875>,
	<0.040,0.810>, <0.080,0.500>, <0.040,0.190>,
	<0.060,0.125>, <0.040,0.100>, <0.055,0.050>,
	<0.040,0.000>, <0.000,0.000>, <-.005,-.005>
    scale <.7,1,.7>
    translate -y*.5
    texture { t_tex scale <.13,.5,.10> rotate x*89 }
}

#local t_side = prism {
	cubic_spline
	0, .02, 11, 
	<0.750,0.000>,
	<0.500,0.000>,
	<0.000,0.000>,
	<0.000,0.070>,
	<0.150,0.050>,
	<0.500,0.100>,
	<0.850,0.050>,
	<1.000,0.070>,
	<1.000,0.000>,
	<0.500,0.000>,
	<0.250,0.000>
	translate -x*.5
	scale x*.95
	rotate x*90
	//texture { t_tex scale <.13,.5,.10> rotate y*89 }
}

#local legs = union {
    #local cnt = 45;
    #while (cnt<360)
    object { s_orn
        scale y*1.35
        rotate x*7 
        translate <0,0,-.8>
        rotate y*cnt
    }
    object { l_orn
        scale y*1.21
        rotate z*90 
        translate <0,-.3,-.6>
        rotate y*(cnt-45)
    }
    object { t_side  translate <0,.68,-.57>
        rotate y*(cnt-45)
        texture { t_tex scale <.13,.5,.10> rotate y*89 }
    }
    #local cnt=cnt+90;
    #end
    
}

#local back_top = intersection { 
    difference {
        cylinder { <0,-.25,0> <0,.45,0> .5 }
        cylinder { <0,-.26,0> <0,.46,0> .40 }
        scale <1.35,0,.35>
    }
    object { t_side
        rotate x*180
        scale <0,4,11>
    }
    translate z*.12
    bounded_by { 
        box { <-.53,-.01,-.09>  <.53,.4,.09>  } 
    }
    texture { t_tex scale <.13,.5,.10> rotate y*89 }
}

#local back_side =  union {
    object { s_orn 
        translate <0,0,0>
    }
    superellipsoid { <.3,.3>
        scale <.08,.15,.08>
        texture { t_tex scale <.13,.5,.10> rotate x*89 }
        translate y*.65
    }
    sphere { 0,.06
        scale y*2 
        translate <0,.9,0>
        texture { t_tex scale <.13,.5,.10> rotate x*89 }
    }
}

#local seat = intersection {
    cylinder { <0,-.028,0> <0,.028,0> .75 
        scale x* 2
        translate -x*.35
    }
    cylinder { <0,-.03,0> <0,.03,0> .6 
        scale <1.1,1,2>
    }
    texture { t_tex scale <.13,.5,.10> rotate y*91 }
}

#local back = union {
    object { back_side
        scale <.85,1.3,.85>
        rotate -z*4 
        rotate <8,-7,0>
        translate <.575,0,.65>
    }
    object { back_side
        scale <.85,1.3,.85>
        rotate -z*4 
        rotate <-8,7,0>
        translate <.575,0,-.65>
    }
    object { back_top 
        scale x*1.5
        rotate <-4,-90,0>
        translate <.65,.7,0>
    }
    object { l_orn 
        scale <.75,1.311,.75>
        rotate -z*4 
        rotate <4,-5,0>
        translate <.627,.021,.25>
    }
    object { l_orn 
        scale <.75,1.311,.75>
        rotate -z*4 
        rotate <-4,5,0>
        translate <.627,.021,-.25>
    }
    object { l_orn 
        scale <.75,1.316,.75>
        rotate -z*4 
        translate <.63,.027,0>
    }
}

#declare Chair = union {
    object { back rotate -z*3 translate <.042,1.385,0> }         
    object { seat scale 1.05  translate <-.03,.7,0> }
    object { legs }
    scale 1.025
    translate y*.695
}

