// Persistence Of Vision raytracer version 3.5 
// Islands include file
// Ron Gow 2003

#version 3.5;

//  ********************************************************
#local beach = texture {
    pigment { function { abs(y) }
        turbulence .35 
        octaves 4
        color_map { 
            [0.00 rgbf <0.615, 0.470, 0.20, .35>]
            [0.30 rgbf <0.770, 0.665, 0.05, .05>]
            [0.93 rgbf <0.820, 0.620, 0.39, .50>]
            [1.00 rgbf <0.785, 0.690, 0.52, 1.0>]
        }
    }
    scale 1.5
    normal { crackle .65 scale .1 }
    translate -y*.25
}

#local rock = texture {
    pigment { agate 
        turbulence .65 
        color_map { 
            [0.00 rgbf <0.525, 0.490, 0.325, .08> ]
            [0.22 rgbf <0.100, 0.095, 0.100, .10> ]
            [0.28 rgbf <0.415, 0.390, 0.320, .15> ]
            [0.85 rgbf <0.515, 0.445, 0.350, .15> ]
            [1.00 rgbf <0.400, 0.390, 0.370, .01 >]
        }
     }
    normal { granite 1 scale 1.5 turbulence 1}
    finish { ambient .05 phong .15 }
    scale <2,5,2>
    translate -y*.25
}

#local grass = texture {
    pigment { slope { -y 0, .5 altitude y -.85, .35 
        }
        turbulence .5  octaves 5
        color_map { 
            [0.00 0.20 color rgbf <0.452, 0.539, 0.229, .15> 
                       color rgb <0.496, 0.530, 0.202> ]
            [0.15 0.75 color rgbf <0.461, 0.533, 0.132, .05>
                       color rgb <0.431, 0.559, 0.298> ]
            [0.65 0.92 color rgbf <0.593, 0.576, 0.224, .25> 
                       color rgb <0.529, 0.529, 0.252> ]          
            [0.90 1.00 color rgbf <0.505, 0.565, 0.242, .05> 
                       color rgb <0.454, 0.553, 0.239> ]
        } 
     } 
    normal { granite .5 scale .005 }
} 

#declare groundtex = texture {
    gradient y
    texture_map {
        [0.00 beach]
        [0.25 rock ]
        [0.85 rock ]
        [1.00 grass]
    }
    scale 9  translate y*1.05
}   

// ****************************************************
#declare Island = 
prism{
    conic_sweep
	cubic_spline
	.75,
	2.1,
	29,
    <0.113543,0.857880>-<.5,.5>,
	<0.029437,0.794801>-<.5,.5>,
	<0.042053,0.681258>-<.5,.5>,
	<0.058874,0.580331>-<.5,.5>,
	<0.021026,0.433145>-<.5,.5>,
	<0.050464,0.256523>-<.5,.5>,
	<0.142980,0.201854>-<.5,.5>,
	<0.176622,0.113543>-<.5,.5>,
	<0.290165,0.042053>-<.5,.5>,
	<0.399503,0.042053>-<.5,.5>,
	<0.479404,0.004205>-<.5,.5>,
	<0.580331,0.008411>-<.5,.5>,
	<0.685463,0.071490>-<.5,.5>,
	<0.803211,0.092516>-<.5,.5>,
	<0.883112,0.151391>-<.5,.5>,
	<0.925165,0.243907>-<.5,.5>,
	<1.005065,0.298576>-<.5,.5>,
	<1.017681,0.416324>-<.5,.5>,
	<0.963012,0.508841>-<.5,.5>,
	<0.975628,0.639205>-<.5,.5>,
	<0.891522,0.811622>-<.5,.5>,
	<0.740132,0.870496>-<.5,.5>,
	<0.538278,0.824238>-<.5,.5>,
	<0.416324,0.874701>-<.5,.5>,
	<0.231291,0.899933>-<.5,.5>,
	<0.109338,0.857880>-<.5,.5>,
	<0.113543,0.857880>-<.5,.5>,
	<0.029437,0.794801>-<.5,.5>,
	<0.042053,0.681258>-<.5,.5>

	translate -y*1
	rotate x*180
	scale 4
}



#declare Island1 = prism{ 
    conic_sweep
	cubic_spline
	.75,
	2.1,
	33,
	<0.496188,0.981289>-<.37,.5>,
	<0.329868,1.000000>-<.37,.5>,
	<0.205128,0.961885>-<.37,.5>,
	<0.152460,0.906445>-<.37,.5>,
	<0.241164,0.853777>-<.37,.5>,
	<0.249480,0.745669>-<.37,.5>,
	<0.149688,0.742897>-<.37,.5>,
	<0.099792,0.820513>-<.37,.5>,
	<0.033264,0.814969>-<.37,.5>,
	<0.030492,0.720721>-<.37,.5>,
	<0.099792,0.659737>-<.37,.5>,
	<0.133056,0.576577>-<.37,.5>,
	<0.016632,0.532225>-<.37,.5>,
	<0.052668,0.396396>-<.37,.5>,
	<0.180180,0.335412>-<.37,.5>,
	<0.180180,0.191268>-<.37,.5>,
	<0.293832,0.144144>-<.37,.5>,
	<0.396396,0.002772>-<.37,.5>,
	<0.609841,0.074844>-<.37,.5>,
	<0.598753,0.194040>-<.37,.5>,
	<0.698545,0.263340>-<.37,.5>,
	<0.737353,0.382536>-<.37,.5>,
	<0.640333,0.471240>-<.37,.5>,
	<0.704089,0.571033>-<.37,.5>,
	<0.645877,0.668053>-<.37,.5>,
	<0.515593,0.687457>-<.37,.5>,
	<0.518365,0.787249>-<.37,.5>,
	<0.584893,0.820513>-<.37,.5>,
	<0.626473,0.903673>-<.37,.5>,
	<0.584893,0.959113>-<.37,.5>,
	<0.496188,0.981289>-<.37,.5>,
	<0.329868,1.000000>-<.37,.5>,
	<0.205128,0.961885>-<.37,.5>
	translate -y*1
	rotate x*180
	scale 4
}

#declare Island2 =  prism{
	conic_sweep
	cubic_spline 
	.75,
	2.1,
	28,
	<0.051435,0.987060>-<.30,.5>,
	<0.146957,0.999307>-<.30,.5>,
	<0.198392,0.957669>-<.30,.5>,
	<0.281667,0.933176>-<.30,.5>,
	<0.360044,0.967466>-<.30,.5>,
	<0.460465,0.908683>-<.30,.5>,
	<0.416378,0.764176>-<.30,.5>,
	<0.502103,0.712741>-<.30,.5>,
	<0.546190,0.509451>-<.30,.5>,
	<0.401682,0.396784>-<.30,.5>,
	<0.404131,0.289015>-<.30,.5>,
	<0.524146,0.311059>-<.30,.5>,
	<0.609871,0.247377>-<.30,.5>,
	<0.526596,0.100421>-<.30,.5>,
	<0.335552,0.044087>-<.30,.5>,
	<0.149406,0.085725>-<.30,.5>,
	<0.100421,0.004899>-<.30,.5>,
	<0.012246,0.046536>-<.30,.5>,
	<0.046536,0.318407>-<.30,.5>,
	<0.132261,0.374740>-<.30,.5>,
	<0.166551,0.533943>-<.30,.5>,
	<0.041638,0.658857>-<.30,.5>,
	<0.017145,0.810712>-<.30,.5>,
	<0.093073,0.854799>-<.30,.5>,
	<0.034290,0.925828>-<.30,.5>,
	<0.051435,0.987060>-<.30,.5>,
	<0.146957,0.999307>-<.30,.5>,
	<0.198392,0.957669>-<.30,.5>
	translate -y*1
	rotate x*180
	scale 4
}


