// Persistence Of Vision Raytracer
// Piano include file
// Ron Gow 2003

#version 3.5;

#include "Woods.inc" 

#ifndef(Ft)
    #declare Ft=1;
    #declare In=Ft/12;
#end

//  ******************************************************** 
//  **********************  Textures  **********************
//  ********************************************************

#local T_WhiteKey = texture {
    pigment { rgb <1,.97,.85> }
    finish { ambient .01 diffuse .65 phong .20 phong_size 70 }
} 

#local T_BlackKey = texture {
    pigment { rgb .015 }
    finish { ambient .00 diffuse .75 phong .15 phong_size 25 }
}

#local T_EbonyLaq = texture {
    pigment { rgb .00 }
    finish { ambient .00 diffuse .65 phong .25 phong_size 45 reflection {.10 falloff .55 } }
}

#local T_BrassPlate = texture {
    pigment { rgb <.70,.57,.15> }
    finish { ambient 0 phong .5 phong_size 50 diffuse .8 reflection { .5 fresnel on } }
}
   
#local T_BlackLeather = texture {
    pigment { bozo
        color_map {
            [ 0.0 rgb <.09,.09,.10> ]
            [ 0.2 rgb <.01,.02,.01> ]
            [ 0.6 rgb <.08,.07,.07> ]
            [ 0.7 rgb <.06,.05,.06> ]
            [ 1.0 rgb <.07,.05,.06> ]
        }
        turbulence .5 octaves 7 scale 1.65
    }
    normal { wrinkles .5 turbulence .4 scale .04}
    finish { ambient 0 phong .15 phong_size 65 diffuse .65 }
}   
  
//  ******************************************************** 
//  **********************  Keyboard  **********************
//  ********************************************************

#local KeyWid = In*7/8;
#local KeyLen = In*5.75;
#local CorRad = In*1/16;
#local TopLen = KeyLen+.01;
#local BlkWid = KeyWid/2;
#local BlkLen = KeyLen-In*2;
#local BlkHgt = In*1.5;
#local KeySpc = KeyWid+.001;
#local KeyNum = 52;
#local BrdLen = KeySpc*KeyNum;

#local KeyBot = union {
    box { 0 <KeyWid, In, KeyLen> }
    box { <CorRad, 0, -CorRad> <KeyWid-CorRad, In, KeyLen> }
    cylinder { 0 <0,In,0> CorRad translate x*CorRad } 
    cylinder { 0 <0,In,0> CorRad translate x*(KeyWid-CorRad) }
}

#local KeyTop = union {
    box { <CorRad, 0, 0> <KeyWid-CorRad, CorRad*2, TopLen> }
    cylinder { <CorRad, CorRad, 0> <CorRad, CorRad, TopLen> CorRad } 
    cylinder { <KeyWid-CorRad, CorRad, 0> <KeyWid-CorRad, CorRad, TopLen> CorRad }
    cylinder { <CorRad, CorRad, 0> <KeyWid-CorRad, CorRad, 0> CorRad }
    sphere { <CorRad, CorRad, 0> CorRad }
    sphere { <KeyWid-CorRad, CorRad, 0> CorRad }
}

#local White_Key = union {
    object { KeyBot }
    object { KeyTop translate <0,In-CorRad/2,-.01> }
    texture { T_WhiteKey }
}

#local Whites = union {
    #local cnt = 0;
    #while (cnt<KeyNum)
        object { White_Key translate x*cnt*KeySpc }
        #local cnt=cnt+1;
    #end
}

#local BlkSlp = union {
    box { <CorRad, BlkHgt-CorRad, CorRad> <BlkWid-CorRad, BlkHgt, BlkHgt+.02> }
    box { <0, 0, 0> <BlkWid, BlkHgt-CorRad, BlkHgt+.02> }
    cylinder { <CorRad, BlkHgt-CorRad, CorRad> <CorRad, BlkHgt-CorRad, BlkHgt+.02> CorRad } 
    cylinder { <BlkWid-CorRad, BlkHgt-CorRad, CorRad> <BlkWid-CorRad, BlkHgt-CorRad, BlkHgt+.02> CorRad }
    rotate -x*55
}

#local BlkKey = union {
    box { <CorRad, BlkHgt-CorRad, CorRad> <BlkWid-CorRad, BlkHgt, BlkLen> }
    box { <0, 0, CorRad> <BlkWid, BlkHgt-CorRad, BlkLen> }
    cylinder { <CorRad, BlkHgt-CorRad, CorRad> <CorRad, BlkHgt-CorRad, BlkLen> CorRad } 
    cylinder { <BlkWid-CorRad, BlkHgt-CorRad, CorRad> <BlkWid-CorRad, BlkHgt-CorRad, BlkLen> CorRad }
    cylinder { <CorRad, BlkHgt-CorRad, CorRad> <BlkWid-CorRad, BlkHgt-CorRad, CorRad> CorRad }
    sphere { <CorRad, BlkHgt-CorRad, CorRad> CorRad }
    sphere { <BlkWid-CorRad, BlkHgt-CorRad, CorRad> CorRad }
}

#local Black_Key = union {
    object { BlkSlp translate <0,-In*.809,In*.245> }
    object { BlkKey }
    texture { T_BlackKey }
    clipped_by { box { <-.01,0,-.3> <BlkWid+.01,BlkHgt+.01,BlkLen+.01> } }
}

#local Blacks = union {
    #local gcnt = 0;
    object { Black_Key translate x*KeySpc }
    #while (gcnt<7)
        #local kcnt = 0;
        #while (kcnt<7)
            #local Dist = KeySpc*2+(gcnt*KeySpc*7)+kcnt*KeySpc;
            #if(kcnt !=0 & kcnt !=3)
                object { Black_Key translate x*Dist }
            #end
            #local kcnt=kcnt+1;
        #end
        #local gcnt=gcnt+1;
    #end
}

#local Keyboard = union {
    object { Blacks translate <-KeyWid/4,0,In*2>}
    object { Whites }
}

//  ******************************************************** 
//  **********************  Keybed  ************************
//  ********************************************************  

#local EndRad = In*2;
#local EndWid = In*1.5;
#local EndSpc = In;
#local BedWid = KeyLen+In;
#local BedLen = BrdLen+(EndSpc+EndWid)*2;
#local BedHgt = In*3;
#local BakHgt = In*12;

#local EndPiece = union {
    #local EndLen = BedWid+In*.25;
    box { 0 <EndWid, BedHgt, EndLen> }
    box { <0, BedHgt, EndRad> <EndWid, BedHgt+EndRad, EndLen> }
    cylinder { <0, BedHgt, EndRad> <EndWid, BedHgt, EndRad> EndRad }
    difference {
        box { <0, 0, BedWid-EndRad> <EndWid, EndRad, EndLen> translate y*(BedHgt+EndRad) }
        cylinder { <-.001, BedHgt+EndRad*2, BedWid-EndRad> <EndWid+.001, BedHgt+EndRad*2, BedWid-EndRad> EndRad }
    }
    translate -z*In/8
}

#local KeyBed = union {
    box { 0 <BedLen, BakHgt, In> translate z*BedWid }
    box { 0 <BedLen, BedHgt, BedWid>  }
    box { <0,0,In> <EndSpc, BedHgt+In/2, BedWid> translate x*EndWid }
    box { <0,0,In> <EndSpc, BedHgt+In/2, BedWid> translate x*(BedLen-EndWid-EndSpc) }
    object { EndPiece translate x*(BedLen-EndWid) }
    object { EndPiece }
    object { Keyboard translate <EndWid+EndSpc,BedHgt-In/2,In> }
    texture { T_EbonyLaq }
}
 
//  ******************************************************** 
//  ***********************  Body  *************************
//  ******************************************************** 

#local BakRad = BedLen/3;
#local HrpRad = BedLen/6;
#local CrnWid = In*11;
#local BodLen = Ft*2.8;
#local H_Hgt = BakHgt*.04;

#local BodShp = union {
    box { 0 <BedLen, BakHgt, CrnWid> }
    box { 0 <BakRad*2, BakHgt, BodLen> }
    cylinder { <BakRad,0,0> <BakRad,BakHgt,0> BakRad scale <1,1,.7> translate z*BodLen }
    cylinder { <HrpRad,0,0> <HrpRad,BakHgt,0> HrpRad scale <1,1,1.19> translate <BedLen-HrpRad*2,0,CrnWid> }
    difference { 
        box { <-.001,0,0> <HrpRad,BakHgt,HrpRad*2> }
        cylinder { <0,-.001,0> <0,BakHgt+.001,0> HrpRad translate <HrpRad,0,HrpRad*2>}
        scale <1,1,1.2>
        translate <BedLen-HrpRad*2,0,CrnWid>
    }
    scale <1,1,1.1>
}

#local BodRim = difference {
    object { BodShp }
    object { BodShp scale .96 translate <In*.7,In,In/2> }
}

#local Lid_R = difference {
    object { BodShp }
    box { -.001 <BedLen+.001, BakHgt+.001, CrnWid+.005> }
    scale <1.01,.05,1.01> 
}

#local Lid_F = box { <0,0,-In> <BedLen, BakHgt, CrnWid-In*4> 
    scale <1,.05,1.01> 
} 

#local L_Hinge = union { 
   box { 0 <BedLen, H_Hgt-.005, In/20> }
    box { 0 <BedLen, H_Hgt-.005, In/20> rotate -x*2 translate y*(H_Hgt+In/12) }
    union {
        #local cnt = 0;
        #while (cnt<(BedLen-In)/In)
             cylinder { 0 <In-.002, 0, 0> In/12 translate <In*cnt,H_Hgt+In/20,-In/32> }
             #local cnt = cnt+1;
        #end
    }
    texture { T_BrassPlate }
}

#local Lid = union {
    object { Lid_R }
    object { Lid_F rotate -x*2 translate <0,H_Hgt+In/12,CrnWid+In> }
    object { L_Hinge translate <0,0,CrnWid-In/16> }
}


#local SndBrd = object { BodShp scale <.95,.05,.95> 
    translate <In/2,In,In/2> texture { T_Wood30 } 
} 

#local PianoBody = union {
    object { BodRim }
    object { KeyBed translate -z*(BedWid+In) }
    object { SndBrd }
    box { <0,0,-In> <BedLen, BakHgt*.05, In*4> translate y*BakHgt } 
    object {Lid rotate z*40 translate y*BakHgt }
    texture { T_EbonyLaq }
}

//  ******************************************************** 
//  ***********************  Legs  *************************
//  ******************************************************** 
#local P_Hgt = Ft*2;
#local M_Wid = In*2;
#local M_Hgt = In*1.5;
#local L_Hgt = P_Hgt-M_Hgt;
#local L_RadMaj = In*1.75;
#local L_RadMin = In/2;
#local S_Len = P_Hgt/L_RadMaj/2;

#local Leg = union {
    box { <-M_Wid,0,-M_Wid> <M_Wid,M_Hgt,M_Wid> translate y*L_Hgt }
    torus { L_RadMaj L_RadMin translate y*(L_Hgt-L_RadMin)  }
    torus { L_RadMaj-In/5 L_RadMin translate y*(L_Hgt-L_RadMin*3) }       
    sphere { 0 L_RadMaj scale <1,S_Len,1> translate y*P_Hgt/2 }
    sphere { 0 L_RadMaj-In/2 scale <1,.8,1> translate y*(L_RadMaj-In/2)*.75 }
}

#local Legs = union {
    object { Leg translate <In*3,0,-In*1.5> }
    object { Leg translate <BedLen-In*3,0,-In*1.5> }
    object { Leg translate <Ft*1.5,0,BodLen+In*9> }
    texture {T_EbonyLaq}
}
//  ******************************************************** 
//  **********************  Stuff  *************************
//  ********************************************************
#local PL = In*1.5;
#local PS = In;
#local C_Pedal =  sphere_sweep { 
    b_spline, 6,
    <-In*3.5,0,0>, PS, <-In*1.5,0,0>, PL, <-In*.5,0,In*.4>, PL, 
    <0,0,In*2>, PL, <0,0,In*7>, PS, <0,0,In*9>, PS
} 

#local S_Pedal =  sphere_sweep { 
    b_spline, 5,
    <0,0,-In*1.5>, PS, <0,0,0>, PL, <0,0,In*1.5>, PL, 
    <0,0,In*7>, PS, <0,0,In*9>, PS
}

#local Pedals = union {
    union {    
        object { S_Pedal  }
        object { C_Pedal translate -x*In*3.5 }
        object { C_Pedal rotate z*180 translate x*In*3.5 }
        scale <.65,.12,.65>
    }
    cylinder { 0 <0,L_Hgt,In/2> In/5 translate <In*1.5,In,In*7.5> }
    cylinder { 0 <0,L_Hgt,In/2> In/5 translate <0,In,In*7.5> }
    cylinder { 0 <0,L_Hgt,In/2> In/5 translate <-In*1.5,In,In*7.5> }
    texture { T_BrassPlate }
}

#local PedBrd = union {
    box {0 <In*10, In*3.2, In*4> }
    object { Pedals translate <In*5,In*1.3,-In*4> }
    object { Leg scale <.5,.9,.5> translate <In*9,In*3.1,In*2> }
    object { Leg scale <.5,.9,.5> translate <In*1,In*3.1,In*2> }
    union {
        cylinder { 0 <-In*2,L_Hgt,Ft> In/4 translate <In*.75,In,In*3.5> }
        cylinder { 0 <In*2,L_Hgt,Ft> In/4 translate <In*9.25,In,In*3.5> }
        texture { T_BrassPlate }
    }
    texture {T_EbonyLaq}
}

#local L_Prop = cylinder { <BedLen-In,BakHgt-In,In*2> <BedLen-Ft*1.5,BakHgt+Ft*2.25,In*2> In/3 }

#local Sheet = polygon { 
    5, <0,0>, <0,In*11>, <In*8.5,In*11>, <In*8.5,0>, <0,0> 
    pigment { rgb .9 /*
        image_map {
            gif "sonataii.gif"
        }
        scale <.7,.9,1> */
    }
    finish { ambient 0 diffuse .65 }
}

#local Sheet_Holder = union {
    difference {
        union { 
            box { 0 <Ft*1.5,In*8,In/3> }
            box { 0 <Ft*1.5,In/3,In> translate <0,In/3,-In> }
            cylinder { 0 <0,0,In/3> In*2 scale <2,1,1> translate <In*9,In*8,0> }
        }
        box { <0,0,-.01> <In*4,In*5,In*.5> translate <In*1.5,In*1.5,0> }
        box { <0,0,-.01> <In*4,In*6.5,In*.5> translate <In*7,In*1.5,0> }
        box { <0,0,-.01> <In*4,In*5,In*.5> translate <In*12.5,In*1.5,0> }
    } 
    object { Sheet translate <In*1.25,In,-.01> }
    object { Sheet translate <In*8.5,In,-.02> }
}
  
    
//  ******************************************************** 
//  **********************  Bench  *************************
//  ********************************************************
#local Cushion = blob {
    #local spc = 3*In;
    #local stn = .8;
    #local cnt = -4;
    #while (cnt<5)
        cylinder { <-1,0,0> <1,0,0> spc*1.2 stn translate z*spc*cnt }
        cylinder { <0,0,-1> <0,0,1> spc*1.2 stn translate x*spc*cnt }
        
        #local cnt=cnt+1;
    #end
    texture { T_BlackLeather } 
    scale <1.3,.85,.65>
}

#local B_Hgt = P_Hgt* .75;
#local B_Leg = object { Leg scale .75 }
    
#local Seat = union {
    object { Cushion translate <In*18,In*2.5,In*9> }
    box { 0 <Ft*3,In*3,In*18> }
}

#local Bench = union {
    object { Seat translate <0,B_Hgt,0> }
    object { B_Leg translate <In*2,0,In*2> }
    object { B_Leg translate <In*2,0,In*16> }
    object { B_Leg translate <Ft*3-In*2,0,In*2> }
    object { B_Leg translate <Ft*3-In*2,0,In*16> }
    texture {T_EbonyLaq} 
}

#declare Piano = union {
    object { Legs }
    object { PianoBody translate y*P_Hgt }
    object { L_Prop translate <0,P_Hgt,CrnWid+In> }
    object { Sheet_Holder rotate x*8 translate <Ft*1.4,P_Hgt+BakHgt+In*.65,In*1> }
    object { PedBrd translate <BedLen/2-In*5,In/2,Ft/2> }
    object { Bench scale <.85,.92,.8> translate <In*10,0,-Ft*2.2> }
} 


